"use strict";
// Generated from the AliCloud ROS Resource Specification
Object.defineProperty(exports, "__esModule", { value: true });
exports.RosRule = exports.RosProductTopic = exports.RosProduct = exports.RosDeviceGroup = exports.RosDevice = void 0;
const ros = require("@alicloud/ros-cdk-core");
/**
 * Determine whether the given properties match those of a `RosDeviceProps`
 *
 * @param properties - the TypeScript properties of a `RosDeviceProps`
 *
 * @returns the result of the validation.
 */
function RosDevicePropsValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('iotInstanceId', ros.validateString)(properties.iotInstanceId));
    errors.collect(ros.propertyValidator('devEui', ros.validateString)(properties.devEui));
    errors.collect(ros.propertyValidator('productKey', ros.requiredValidator)(properties.productKey));
    errors.collect(ros.propertyValidator('productKey', ros.validateString)(properties.productKey));
    errors.collect(ros.propertyValidator('deviceName', ros.validateString)(properties.deviceName));
    errors.collect(ros.propertyValidator('pinCode', ros.validateString)(properties.pinCode));
    errors.collect(ros.propertyValidator('nickname', ros.validateString)(properties.nickname));
    return errors.wrap('supplied properties not correct for "RosDeviceProps"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::IOT::Device` resource
 *
 * @param properties - the TypeScript properties of a `RosDeviceProps`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::IOT::Device` resource.
 */
// @ts-ignore TS6133
function rosDevicePropsToRosTemplate(properties, enableResourcePropertyConstraint) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    if (enableResourcePropertyConstraint) {
        RosDevicePropsValidator(properties).assertSuccess();
    }
    return {
        ProductKey: ros.stringToRosTemplate(properties.productKey),
        DevEui: ros.stringToRosTemplate(properties.devEui),
        DeviceName: ros.stringToRosTemplate(properties.deviceName),
        IotInstanceId: ros.stringToRosTemplate(properties.iotInstanceId),
        Nickname: ros.stringToRosTemplate(properties.nickname),
        PinCode: ros.stringToRosTemplate(properties.pinCode),
    };
}
/**
 * A ROS template type:  `ALIYUN::IOT::Device`
 */
class RosDevice extends ros.RosResource {
    /**
     * Create a new `ALIYUN::IOT::Device`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint) {
        super(scope, id, { type: RosDevice.ROS_RESOURCE_TYPE_NAME, properties: props });
        this.attrDeviceName = ros.Token.asString(this.getAtt('DeviceName'));
        this.attrDeviceSecret = ros.Token.asString(this.getAtt('DeviceSecret'));
        this.attrIotId = ros.Token.asString(this.getAtt('IotId'));
        this.attrIotInstanceId = ros.Token.asString(this.getAtt('IotInstanceId'));
        this.attrIpAddress = ros.Token.asString(this.getAtt('IpAddress'));
        this.attrNickName = ros.Token.asString(this.getAtt('NickName'));
        this.attrNodeType = ros.Token.asString(this.getAtt('NodeType'));
        this.attrProductKey = ros.Token.asString(this.getAtt('ProductKey'));
        this.attrProductName = ros.Token.asString(this.getAtt('ProductName'));
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        this.productKey = props.productKey;
        this.devEui = props.devEui;
        this.deviceName = props.deviceName;
        this.iotInstanceId = props.iotInstanceId;
        this.nickname = props.nickname;
        this.pinCode = props.pinCode;
    }
    get rosProperties() {
        return {
            productKey: this.productKey,
            devEui: this.devEui,
            deviceName: this.deviceName,
            iotInstanceId: this.iotInstanceId,
            nickname: this.nickname,
            pinCode: this.pinCode,
        };
    }
    renderProperties(props) {
        return rosDevicePropsToRosTemplate(props, this.enableResourcePropertyConstraint);
    }
}
exports.RosDevice = RosDevice;
/**
 * The resource type name for this resource class.
 */
RosDevice.ROS_RESOURCE_TYPE_NAME = "ALIYUN::IOT::Device";
/**
 * Determine whether the given properties match those of a `RosDeviceGroupProps`
 *
 * @param properties - the TypeScript properties of a `RosDeviceGroupProps`
 *
 * @returns the result of the validation.
 */
function RosDeviceGroupPropsValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('groupName', ros.requiredValidator)(properties.groupName));
    errors.collect(ros.propertyValidator('groupName', ros.validateString)(properties.groupName));
    errors.collect(ros.propertyValidator('iotInstanceId', ros.validateString)(properties.iotInstanceId));
    errors.collect(ros.propertyValidator('superGroupId', ros.validateString)(properties.superGroupId));
    errors.collect(ros.propertyValidator('groupDesc', ros.validateString)(properties.groupDesc));
    return errors.wrap('supplied properties not correct for "RosDeviceGroupProps"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::IOT::DeviceGroup` resource
 *
 * @param properties - the TypeScript properties of a `RosDeviceGroupProps`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::IOT::DeviceGroup` resource.
 */
// @ts-ignore TS6133
function rosDeviceGroupPropsToRosTemplate(properties, enableResourcePropertyConstraint) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    if (enableResourcePropertyConstraint) {
        RosDeviceGroupPropsValidator(properties).assertSuccess();
    }
    return {
        GroupName: ros.stringToRosTemplate(properties.groupName),
        GroupDesc: ros.stringToRosTemplate(properties.groupDesc),
        IotInstanceId: ros.stringToRosTemplate(properties.iotInstanceId),
        SuperGroupId: ros.stringToRosTemplate(properties.superGroupId),
    };
}
/**
 * A ROS template type:  `ALIYUN::IOT::DeviceGroup`
 */
class RosDeviceGroup extends ros.RosResource {
    /**
     * Create a new `ALIYUN::IOT::DeviceGroup`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint) {
        super(scope, id, { type: RosDeviceGroup.ROS_RESOURCE_TYPE_NAME, properties: props });
        this.attrGroupId = ros.Token.asString(this.getAtt('GroupId'));
        this.attrIotInstanceId = ros.Token.asString(this.getAtt('IotInstanceId'));
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        this.groupName = props.groupName;
        this.groupDesc = props.groupDesc;
        this.iotInstanceId = props.iotInstanceId;
        this.superGroupId = props.superGroupId;
    }
    get rosProperties() {
        return {
            groupName: this.groupName,
            groupDesc: this.groupDesc,
            iotInstanceId: this.iotInstanceId,
            superGroupId: this.superGroupId,
        };
    }
    renderProperties(props) {
        return rosDeviceGroupPropsToRosTemplate(props, this.enableResourcePropertyConstraint);
    }
}
exports.RosDeviceGroup = RosDeviceGroup;
/**
 * The resource type name for this resource class.
 */
RosDeviceGroup.ROS_RESOURCE_TYPE_NAME = "ALIYUN::IOT::DeviceGroup";
/**
 * Determine whether the given properties match those of a `RosProductProps`
 *
 * @param properties - the TypeScript properties of a `RosProductProps`
 *
 * @returns the result of the validation.
 */
function RosProductPropsValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('publishAuto', ros.validateBoolean)(properties.publishAuto));
    errors.collect(ros.propertyValidator('description', ros.validateString)(properties.description));
    errors.collect(ros.propertyValidator('iotInstanceId', ros.validateString)(properties.iotInstanceId));
    errors.collect(ros.propertyValidator('productName', ros.requiredValidator)(properties.productName));
    errors.collect(ros.propertyValidator('productName', ros.validateString)(properties.productName));
    errors.collect(ros.propertyValidator('resourceGroupId', ros.validateString)(properties.resourceGroupId));
    errors.collect(ros.propertyValidator('aliyunCommodityCode', ros.validateString)(properties.aliyunCommodityCode));
    errors.collect(ros.propertyValidator('categoryKey', ros.validateString)(properties.categoryKey));
    if (properties.protocolType && (typeof properties.protocolType) !== 'object') {
        errors.collect(ros.propertyValidator('protocolType', ros.validateAllowedValues)({
            data: properties.protocolType,
            allowedValues: ["ble", "customize", "modbus", "opc-ua", "zigbee"],
        }));
    }
    errors.collect(ros.propertyValidator('protocolType', ros.validateString)(properties.protocolType));
    errors.collect(ros.propertyValidator('id2', ros.validateBoolean)(properties.id2));
    errors.collect(ros.propertyValidator('nodeType', ros.requiredValidator)(properties.nodeType));
    if (properties.nodeType && (typeof properties.nodeType) !== 'object') {
        errors.collect(ros.propertyValidator('nodeType', ros.validateAllowedValues)({
            data: properties.nodeType,
            allowedValues: [0, 1],
        }));
    }
    errors.collect(ros.propertyValidator('nodeType', ros.validateNumber)(properties.nodeType));
    if (properties.dataFormat && (typeof properties.dataFormat) !== 'object') {
        errors.collect(ros.propertyValidator('dataFormat', ros.validateAllowedValues)({
            data: properties.dataFormat,
            allowedValues: [0, 1],
        }));
    }
    errors.collect(ros.propertyValidator('dataFormat', ros.validateNumber)(properties.dataFormat));
    errors.collect(ros.propertyValidator('authType', ros.validateString)(properties.authType));
    errors.collect(ros.propertyValidator('joinPermissionId', ros.validateString)(properties.joinPermissionId));
    if (properties.netType && (typeof properties.netType) !== 'object') {
        errors.collect(ros.propertyValidator('netType', ros.validateAllowedValues)({
            data: properties.netType,
            allowedValues: ["CELLULAR", "ETHERNET", "LORA", "OTHER", "WIFI"],
        }));
    }
    errors.collect(ros.propertyValidator('netType', ros.validateString)(properties.netType));
    return errors.wrap('supplied properties not correct for "RosProductProps"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::IOT::Product` resource
 *
 * @param properties - the TypeScript properties of a `RosProductProps`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::IOT::Product` resource.
 */
// @ts-ignore TS6133
function rosProductPropsToRosTemplate(properties, enableResourcePropertyConstraint) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    if (enableResourcePropertyConstraint) {
        RosProductPropsValidator(properties).assertSuccess();
    }
    return {
        NodeType: ros.numberToRosTemplate(properties.nodeType),
        ProductName: ros.stringToRosTemplate(properties.productName),
        AliyunCommodityCode: ros.stringToRosTemplate(properties.aliyunCommodityCode),
        AuthType: ros.stringToRosTemplate(properties.authType),
        CategoryKey: ros.stringToRosTemplate(properties.categoryKey),
        DataFormat: ros.numberToRosTemplate(properties.dataFormat),
        Description: ros.stringToRosTemplate(properties.description),
        Id2: ros.booleanToRosTemplate(properties.id2),
        IotInstanceId: ros.stringToRosTemplate(properties.iotInstanceId),
        JoinPermissionId: ros.stringToRosTemplate(properties.joinPermissionId),
        NetType: ros.stringToRosTemplate(properties.netType),
        ProtocolType: ros.stringToRosTemplate(properties.protocolType),
        PublishAuto: ros.booleanToRosTemplate(properties.publishAuto),
        ResourceGroupId: ros.stringToRosTemplate(properties.resourceGroupId),
    };
}
/**
 * A ROS template type:  `ALIYUN::IOT::Product`
 */
class RosProduct extends ros.RosResource {
    /**
     * Create a new `ALIYUN::IOT::Product`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint) {
        super(scope, id, { type: RosProduct.ROS_RESOURCE_TYPE_NAME, properties: props });
        this.attrIotInstanceId = ros.Token.asString(this.getAtt('IotInstanceId'));
        this.attrProductKey = ros.Token.asString(this.getAtt('ProductKey'));
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        this.nodeType = props.nodeType;
        this.productName = props.productName;
        this.aliyunCommodityCode = props.aliyunCommodityCode;
        this.authType = props.authType;
        this.categoryKey = props.categoryKey;
        this.dataFormat = props.dataFormat;
        this.description = props.description;
        this.id2 = props.id2;
        this.iotInstanceId = props.iotInstanceId;
        this.joinPermissionId = props.joinPermissionId;
        this.netType = props.netType;
        this.protocolType = props.protocolType;
        this.publishAuto = props.publishAuto;
        this.resourceGroupId = props.resourceGroupId;
    }
    get rosProperties() {
        return {
            nodeType: this.nodeType,
            productName: this.productName,
            aliyunCommodityCode: this.aliyunCommodityCode,
            authType: this.authType,
            categoryKey: this.categoryKey,
            dataFormat: this.dataFormat,
            description: this.description,
            id2: this.id2,
            iotInstanceId: this.iotInstanceId,
            joinPermissionId: this.joinPermissionId,
            netType: this.netType,
            protocolType: this.protocolType,
            publishAuto: this.publishAuto,
            resourceGroupId: this.resourceGroupId,
        };
    }
    renderProperties(props) {
        return rosProductPropsToRosTemplate(props, this.enableResourcePropertyConstraint);
    }
}
exports.RosProduct = RosProduct;
/**
 * The resource type name for this resource class.
 */
RosProduct.ROS_RESOURCE_TYPE_NAME = "ALIYUN::IOT::Product";
/**
 * Determine whether the given properties match those of a `RosProductTopicProps`
 *
 * @param properties - the TypeScript properties of a `RosProductTopicProps`
 *
 * @returns the result of the validation.
 */
function RosProductTopicPropsValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    if (properties.desc && (Array.isArray(properties.desc) || (typeof properties.desc) === 'string')) {
        errors.collect(ros.propertyValidator('desc', ros.validateLength)({
            data: properties.desc.length,
            min: undefined,
            max: 100,
        }));
    }
    errors.collect(ros.propertyValidator('desc', ros.validateString)(properties.desc));
    errors.collect(ros.propertyValidator('iotInstanceId', ros.validateString)(properties.iotInstanceId));
    errors.collect(ros.propertyValidator('topicShortName', ros.requiredValidator)(properties.topicShortName));
    errors.collect(ros.propertyValidator('topicShortName', ros.validateString)(properties.topicShortName));
    errors.collect(ros.propertyValidator('operation', ros.requiredValidator)(properties.operation));
    if (properties.operation && (typeof properties.operation) !== 'object') {
        errors.collect(ros.propertyValidator('operation', ros.validateAllowedValues)({
            data: properties.operation,
            allowedValues: ["ALL", "PUB", "SUB"],
        }));
    }
    errors.collect(ros.propertyValidator('operation', ros.validateString)(properties.operation));
    errors.collect(ros.propertyValidator('productKey', ros.requiredValidator)(properties.productKey));
    errors.collect(ros.propertyValidator('productKey', ros.validateString)(properties.productKey));
    return errors.wrap('supplied properties not correct for "RosProductTopicProps"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::IOT::ProductTopic` resource
 *
 * @param properties - the TypeScript properties of a `RosProductTopicProps`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::IOT::ProductTopic` resource.
 */
// @ts-ignore TS6133
function rosProductTopicPropsToRosTemplate(properties, enableResourcePropertyConstraint) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    if (enableResourcePropertyConstraint) {
        RosProductTopicPropsValidator(properties).assertSuccess();
    }
    return {
        Operation: ros.stringToRosTemplate(properties.operation),
        ProductKey: ros.stringToRosTemplate(properties.productKey),
        TopicShortName: ros.stringToRosTemplate(properties.topicShortName),
        Desc: ros.stringToRosTemplate(properties.desc),
        IotInstanceId: ros.stringToRosTemplate(properties.iotInstanceId),
    };
}
/**
 * A ROS template type:  `ALIYUN::IOT::ProductTopic`
 */
class RosProductTopic extends ros.RosResource {
    /**
     * Create a new `ALIYUN::IOT::ProductTopic`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint) {
        super(scope, id, { type: RosProductTopic.ROS_RESOURCE_TYPE_NAME, properties: props });
        this.attrTopicId = ros.Token.asString(this.getAtt('TopicId'));
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        this.operation = props.operation;
        this.productKey = props.productKey;
        this.topicShortName = props.topicShortName;
        this.desc = props.desc;
        this.iotInstanceId = props.iotInstanceId;
    }
    get rosProperties() {
        return {
            operation: this.operation,
            productKey: this.productKey,
            topicShortName: this.topicShortName,
            desc: this.desc,
            iotInstanceId: this.iotInstanceId,
        };
    }
    renderProperties(props) {
        return rosProductTopicPropsToRosTemplate(props, this.enableResourcePropertyConstraint);
    }
}
exports.RosProductTopic = RosProductTopic;
/**
 * The resource type name for this resource class.
 */
RosProductTopic.ROS_RESOURCE_TYPE_NAME = "ALIYUN::IOT::ProductTopic";
/**
 * Determine whether the given properties match those of a `RosRuleProps`
 *
 * @param properties - the TypeScript properties of a `RosRuleProps`
 *
 * @returns the result of the validation.
 */
function RosRulePropsValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('topicType', ros.validateNumber)(properties.topicType));
    errors.collect(ros.propertyValidator('iotInstanceId', ros.validateString)(properties.iotInstanceId));
    errors.collect(ros.propertyValidator('resourceGroupId', ros.validateString)(properties.resourceGroupId));
    errors.collect(ros.propertyValidator('shortTopic', ros.validateString)(properties.shortTopic));
    errors.collect(ros.propertyValidator('select', ros.validateString)(properties.select));
    errors.collect(ros.propertyValidator('dataType', ros.validateString)(properties.dataType));
    errors.collect(ros.propertyValidator('ruleDesc', ros.validateString)(properties.ruleDesc));
    errors.collect(ros.propertyValidator('where', ros.validateString)(properties.where));
    errors.collect(ros.propertyValidator('productKey', ros.validateString)(properties.productKey));
    errors.collect(ros.propertyValidator('name', ros.requiredValidator)(properties.name));
    errors.collect(ros.propertyValidator('name', ros.validateString)(properties.name));
    return errors.wrap('supplied properties not correct for "RosRuleProps"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::IOT::Rule` resource
 *
 * @param properties - the TypeScript properties of a `RosRuleProps`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::IOT::Rule` resource.
 */
// @ts-ignore TS6133
function rosRulePropsToRosTemplate(properties, enableResourcePropertyConstraint) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    if (enableResourcePropertyConstraint) {
        RosRulePropsValidator(properties).assertSuccess();
    }
    return {
        Name: ros.stringToRosTemplate(properties.name),
        DataType: ros.stringToRosTemplate(properties.dataType),
        IotInstanceId: ros.stringToRosTemplate(properties.iotInstanceId),
        ProductKey: ros.stringToRosTemplate(properties.productKey),
        ResourceGroupId: ros.stringToRosTemplate(properties.resourceGroupId),
        RuleDesc: ros.stringToRosTemplate(properties.ruleDesc),
        Select: ros.stringToRosTemplate(properties.select),
        ShortTopic: ros.stringToRosTemplate(properties.shortTopic),
        TopicType: ros.numberToRosTemplate(properties.topicType),
        Where: ros.stringToRosTemplate(properties.where),
    };
}
/**
 * A ROS template type:  `ALIYUN::IOT::Rule`
 */
class RosRule extends ros.RosResource {
    /**
     * Create a new `ALIYUN::IOT::Rule`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint) {
        super(scope, id, { type: RosRule.ROS_RESOURCE_TYPE_NAME, properties: props });
        this.attrDataType = ros.Token.asString(this.getAtt('DataType'));
        this.attrIotInstanceId = ros.Token.asString(this.getAtt('IotInstanceId'));
        this.attrName = ros.Token.asString(this.getAtt('Name'));
        this.attrProductKey = ros.Token.asString(this.getAtt('ProductKey'));
        this.attrResourceGroupId = ros.Token.asString(this.getAtt('ResourceGroupId'));
        this.attrRuleDesc = ros.Token.asString(this.getAtt('RuleDesc'));
        this.attrRuleId = ros.Token.asString(this.getAtt('RuleId'));
        this.attrSelect = ros.Token.asString(this.getAtt('Select'));
        this.attrShortTopic = ros.Token.asString(this.getAtt('ShortTopic'));
        this.attrTopicType = ros.Token.asString(this.getAtt('TopicType'));
        this.attrWhere = ros.Token.asString(this.getAtt('Where'));
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        this.name = props.name;
        this.dataType = props.dataType;
        this.iotInstanceId = props.iotInstanceId;
        this.productKey = props.productKey;
        this.resourceGroupId = props.resourceGroupId;
        this.ruleDesc = props.ruleDesc;
        this.select = props.select;
        this.shortTopic = props.shortTopic;
        this.topicType = props.topicType;
        this.where = props.where;
    }
    get rosProperties() {
        return {
            name: this.name,
            dataType: this.dataType,
            iotInstanceId: this.iotInstanceId,
            productKey: this.productKey,
            resourceGroupId: this.resourceGroupId,
            ruleDesc: this.ruleDesc,
            select: this.select,
            shortTopic: this.shortTopic,
            topicType: this.topicType,
            where: this.where,
        };
    }
    renderProperties(props) {
        return rosRulePropsToRosTemplate(props, this.enableResourcePropertyConstraint);
    }
}
exports.RosRule = RosRule;
/**
 * The resource type name for this resource class.
 */
RosRule.ROS_RESOURCE_TYPE_NAME = "ALIYUN::IOT::Rule";
//# sourceMappingURL=data:application/json;base64,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