"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DeviceGroup = exports.DeviceGroupProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const iot_generated_1 = require("./iot.generated");
Object.defineProperty(exports, "DeviceGroupProperty", { enumerable: true, get: function () { return iot_generated_1.RosDeviceGroup; } });
/**
 * A ROS resource type:  `ALIYUN::IOT::DeviceGroup`
 */
class DeviceGroup extends ros.Resource {
    /**
     * Create a new `ALIYUN::IOT::DeviceGroup`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosDeviceGroup = new iot_generated_1.RosDeviceGroup(this, id, {
            groupName: props.groupName,
            iotInstanceId: props.iotInstanceId,
            superGroupId: props.superGroupId,
            groupDesc: props.groupDesc,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosDeviceGroup;
        this.attrGroupId = rosDeviceGroup.attrGroupId;
        this.attrIotInstanceId = rosDeviceGroup.attrIotInstanceId;
    }
}
exports.DeviceGroup = DeviceGroup;
//# sourceMappingURL=data:application/json;base64,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