"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Device = exports.DeviceProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const iot_generated_1 = require("./iot.generated");
Object.defineProperty(exports, "DeviceProperty", { enumerable: true, get: function () { return iot_generated_1.RosDevice; } });
/**
 * A ROS resource type:  `ALIYUN::IOT::Device`
 */
class Device extends ros.Resource {
    /**
     * Create a new `ALIYUN::IOT::Device`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosDevice = new iot_generated_1.RosDevice(this, id, {
            iotInstanceId: props.iotInstanceId,
            devEui: props.devEui,
            productKey: props.productKey,
            deviceName: props.deviceName,
            pinCode: props.pinCode,
            nickname: props.nickname,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosDevice;
        this.attrDeviceName = rosDevice.attrDeviceName;
        this.attrDeviceSecret = rosDevice.attrDeviceSecret;
        this.attrIotId = rosDevice.attrIotId;
        this.attrIotInstanceId = rosDevice.attrIotInstanceId;
        this.attrIpAddress = rosDevice.attrIpAddress;
        this.attrNickName = rosDevice.attrNickName;
        this.attrNodeType = rosDevice.attrNodeType;
        this.attrProductKey = rosDevice.attrProductKey;
        this.attrProductName = rosDevice.attrProductName;
    }
}
exports.Device = Device;
//# sourceMappingURL=data:application/json;base64,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