# Install JupyterHub with Docker

The JupyterHub [docker image](https://hub.docker.com/r/jupyterhub/jupyterhub/) is the fastest way to set up Jupyterhub in your local development environment.

:::{note}
This `jupyterhub/jupyterhub` docker image is only an image for running
the Hub service itself. It does not provide the other Jupyter components,
such as Notebook installation, which are needed by the single-user servers.
To run the single-user servers, which may be on the same system as the Hub or
not, [JupyterLab](https://jupyterlab.readthedocs.io/) or Jupyter Notebook must be installed.
:::

:::{important}
We strongly recommend that you follow the [Zero to JupyterHub] tutorial to
install JupyterHub.
:::

## Prerequisites

You should have [Docker] installed on a Linux/Unix based system.

## Run the Docker Image

To pull the latest JupyterHub image and start the `jupyterhub` container, run this command in your terminal.

```
docker run -d -p 8000:8000 --name jupyterhub jupyterhub/jupyterhub jupyterhub
```

This command exposes the Jupyter container on port:8000. Navigate to `http://localhost:8000` in a web browser to access the JupyterHub console.

You can stop and resume the container by running `docker stop` and `docker start` respectively.

```
# find the container id
docker ps

# stop the running container
docker stop  <container-id>

# resume the paused container
docker start <container-id>
```

If you want to run docker on a computer that has a public IP then you should
(as in MUST) **secure it with ssl** by adding ssl options to your docker
configuration or using an ssl enabled proxy.

[Mounting volumes](https://docs.docker.com/engine/admin/volumes/volumes/)
enables you to persist and store the data generated by the docker container, even when you stop the container.
The persistent data can be stored on the host system, outside the container.

## Create System Users

Spawn a root shell in your docker container by running this command in the terminal.:

```
docker exec -it jupyterhub bash
```

The created accounts will be used for authentication in JupyterHub's default
configuration.

[docker]: https://www.docker.com/
[zero to jupyterhub]: https://z2jh.jupyter.org/en/latest/
