"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CodePipelineBadgeNotification = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const cdk = require("aws-cdk-lib");
const constructs_1 = require("constructs");
class CodePipelineBadgeNotification extends constructs_1.Construct {
    constructor(scope, id, props) {
        var _b, _c, _d, _e, _f, _g;
        super(scope, id);
        this.badgeUrl = '';
        this.codePipelineLink = '';
        const pipeline = aws_cdk_lib_1.aws_codepipeline.Pipeline.fromPipelineArn(this, 'CodePipeline', props.pipelineArn);
        const gitHubToken = ((_b = props === null || props === void 0 ? void 0 : props.gitHubTokenFromSecretsManager) === null || _b === void 0 ? void 0 : _b.secretsManagerArn) && ((_c = props === null || props === void 0 ? void 0 : props.gitHubTokenFromSecretsManager) === null || _c === void 0 ? void 0 : _c.secretKey)
            ? cdk.SecretValue.secretsManager(props.gitHubTokenFromSecretsManager.secretsManagerArn, {
                jsonField: props.gitHubTokenFromSecretsManager.secretKey,
            })
            : null;
        const targetLambda = this.createCodePipelineEventLambdaFunction(pipeline.pipelineName, gitHubToken, (_d = props === null || props === void 0 ? void 0 : props.notification) === null || _d === void 0 ? void 0 : _d.stageName, (_e = props === null || props === void 0 ? void 0 : props.notification) === null || _e === void 0 ? void 0 : _e.ssmSlackWebHookUrl, (_f = props === null || props === void 0 ? void 0 : props.notification) === null || _f === void 0 ? void 0 : _f.ssmGoogleChatWebHookUrl, (_g = props === null || props === void 0 ? void 0 : props.notification) === null || _g === void 0 ? void 0 : _g.ssmTelegramWebHookUrl);
        pipeline.onStateChange('CodePipelineChange', {
            eventPattern: {
                source: ['aws.codepipeline'],
                detailType: ['CodePipeline Pipeline Execution State Change'],
            },
            target: new aws_cdk_lib_1.aws_events_targets.LambdaFunction(targetLambda),
        });
    }
    createCodePipelineEventLambdaFunction(codePipelineName, gitHubToken, stage, ssmSlackWebHookUrl, ssmGoogleChatWebHookUrl, ssmTelegramWebHookUrl) {
        var _b, _c;
        const badgeBucket = new aws_cdk_lib_1.aws_s3.Bucket(this, 'BadgeBucket', {
            publicReadAccess: true,
        });
        const stageKeyName = stage ? `${stage}-` : '';
        const badgeBucketImageKeyName = `${stageKeyName}latest-build.svg`;
        const lambdaFunc = new aws_cdk_lib_1.aws_lambda.DockerImageFunction(this, 'CodepipelineEventLambda', {
            code: aws_cdk_lib_1.aws_lambda.DockerImageCode.fromImageAsset(path.join(__dirname, '../lambda/codepipeline-event'), {
                cmd: ['codepipelineEventLambda.handler'],
            }),
            environment: {
                STAGE: stage !== null && stage !== void 0 ? stage : '',
                SLACK_WEBHOOK_URL: ssmSlackWebHookUrl ?
                    aws_cdk_lib_1.aws_ssm.StringParameter.valueForStringParameter(this, ssmSlackWebHookUrl) : '',
                GOOGLE_CHAT_WEBHOOK_URL: ssmGoogleChatWebHookUrl ?
                    aws_cdk_lib_1.aws_ssm.StringParameter.valueForStringParameter(this, ssmGoogleChatWebHookUrl) : '',
                TELEGRAM_WEBHOOK_URL: ssmTelegramWebHookUrl ?
                    aws_cdk_lib_1.aws_ssm.StringParameter.valueForStringParameter(this, ssmTelegramWebHookUrl) : '',
                BADGE_BUCKET_NAME: badgeBucket.bucketName,
                BADGE_BUCKET_IMAGE_KEY_NAME: badgeBucketImageKeyName,
                CODE_PIPELINE_NAME: codePipelineName,
                GITHUB_PERSONAL_TOKEN: gitHubToken ? `${gitHubToken}` : '',
            },
            timeout: cdk.Duration.seconds(30),
        });
        badgeBucket.grantReadWrite(lambdaFunc);
        if (ssmSlackWebHookUrl && lambdaFunc.role) {
            lambdaFunc.role.attachInlinePolicy(new aws_cdk_lib_1.aws_iam.Policy(this, 'ssmSlackWebHookUrl', {
                statements: [
                    new aws_cdk_lib_1.aws_iam.PolicyStatement({
                        effect: aws_cdk_lib_1.aws_iam.Effect.ALLOW,
                        actions: ['ssm:GetParameter', 'ssm:GetParameters'],
                        resources: [`arn:aws:ssm:${cdk.Aws.REGION}:${cdk.Aws.ACCOUNT_ID}:parameter/${ssmSlackWebHookUrl}`],
                    }),
                ],
            }));
        }
        if (ssmGoogleChatWebHookUrl && lambdaFunc.role) {
            lambdaFunc.role.attachInlinePolicy(new aws_cdk_lib_1.aws_iam.Policy(this, 'ssmGoogleChatWebHookUrl', {
                statements: [
                    new aws_cdk_lib_1.aws_iam.PolicyStatement({
                        effect: aws_cdk_lib_1.aws_iam.Effect.ALLOW,
                        actions: ['ssm:GetParameter', 'ssm:GetParameters'],
                        resources: [`arn:aws:ssm:${cdk.Aws.REGION}:${cdk.Aws.ACCOUNT_ID}:parameter/${ssmGoogleChatWebHookUrl}`],
                    }),
                ],
            }));
        }
        if (ssmTelegramWebHookUrl && lambdaFunc.role) {
            lambdaFunc.role.attachInlinePolicy(new aws_cdk_lib_1.aws_iam.Policy(this, 'ssmTelegramWebHookUrl', {
                statements: [
                    new aws_cdk_lib_1.aws_iam.PolicyStatement({
                        effect: aws_cdk_lib_1.aws_iam.Effect.ALLOW,
                        actions: ['ssm:GetParameter', 'ssm:GetParameters'],
                        resources: [`arn:aws:ssm:${cdk.Aws.REGION}:${cdk.Aws.ACCOUNT_ID}:parameter/${ssmTelegramWebHookUrl}`],
                    }),
                ],
            }));
        }
        const region = (_b = cdk.Aws.REGION) !== null && _b !== void 0 ? _b : 'ap-northeast-1';
        this.badgeUrl = `https://${badgeBucket.bucketName}.s3-ap-northeast-1.amazonaws.com/${badgeBucketImageKeyName}#1`;
        this.codePipelineLink = `https://${region}.console.aws.amazon.com/codesuite/codepipeline/pipelines/${codePipelineName}/view`;
        new cdk.CfnOutput(this, 'badgeMarkdownLink', {
            value: `[![Build Status](${this.badgeUrl})](${this.codePipelineLink})`,
        });
        (_c = lambdaFunc.role) === null || _c === void 0 ? void 0 : _c.addManagedPolicy(aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName('AWSCodePipeline_ReadOnlyAccess'));
        this.tagResource(lambdaFunc);
        return lambdaFunc;
    }
    tagResource(scope) {
        cdk.Tags.of(scope).add('CDK-CfnStackId', cdk.Aws.STACK_ID);
        cdk.Tags.of(scope).add('CDK-CfnStackName', cdk.Aws.STACK_NAME);
    }
}
exports.CodePipelineBadgeNotification = CodePipelineBadgeNotification;
_a = JSII_RTTI_SYMBOL_1;
CodePipelineBadgeNotification[_a] = { fqn: "cdk-codepipeline-badge-notification.CodePipelineBadgeNotification", version: "2.0.58" };
//# sourceMappingURL=data:application/json;base64,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