# -*- coding: utf-8 -*-

"""
youtubedataapisearch

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""

from youtubedataapisearch.api_helper import APIHelper
from youtubedataapisearch.configuration import Server
from youtubedataapisearch.controllers.base_controller import BaseController
from youtubedataapisearch.exceptions.invalid_argument_exception import InvalidArgumentException
from youtubedataapisearch.exceptions.invalid_video_id_exception import InvalidVideoIdException


class SimpleSearchController(BaseController):

    """A Controller to access Endpoints in the youtubedataapisearch API."""

    def __init__(self, config, call_back=None):
        super(SimpleSearchController, self).__init__(config, call_back)

    def search_by_keyword(self,
                          search,
                          part,
                          max_results,
                          key,
                          q):
        """Does a GET request to /{search}.

        TODO: type endpoint description here.

        Args:
            search (TypeSearchEnum): TODO: type description here. Example:
                search
            part (string): TODO: type description here. Example: snippet
            max_results (int): TODO: type description here. Example: 25
            key (string): API-Key
            q (string): keyword

        Returns:
            mixed: Response from the API.

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = '/{search}'
        _url_path = APIHelper.append_url_with_template_parameters(_url_path, {
            'search': {'value': search, 'encode': True}
        })
        _query_builder = self.config.get_base_uri()
        _query_builder += _url_path
        _query_parameters = {
            'part': part,
            'maxResults': max_results,
            'key': key,
            'q': q
        }
        _query_builder = APIHelper.append_url_with_query_parameters(
            _query_builder,
            _query_parameters
        )
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {
            'accept': 'application/json'
        }

        # Prepare and execute request
        _request = self.config.http_client.get(_query_url, headers=_headers)
        _response = self.execute_request(_request)

        # Endpoint and global error handling using HTTP status codes.
        if _response.status_code == 400:
            raise InvalidArgumentException('The parameter specified has an invalid argument', _response)
        elif _response.status_code == 402:
            raise InvalidVideoIdException('The relatedToVideo parameter specified an invalid video ID', _response)
        self.validate_response(_response)
        if (_response.text is not None) or (not str(_response.text)):
            decoded = APIHelper.json_deserialize(_response.text)

        return decoded
