"""
    Tapyrus API

    # イントロダクション  これは chaintope 社が開発するブロックチェーン Tapyrus を使ったブロックチェーンに関係する機能を簡単に利用するための REST API です。 現在以下のユースケースをサポートしています。これは今後も拡張されていくことを予定しています。 * Payment: TPC(Tapyrus Coin) の送金 * Timestamp: 任意のデータをタイムスタンプとしてブロックチェーンに記録 * Token: 新しいトークンの発行、送金、焼却。NFTも利用可能  Tapyrus ブロックチェーンについては以下の情報を参照してください。  * [Chaintope のブロックチェーンプロトコル](https://www.chaintope.com/chaintope-blockchain-protocol/) * [chaintope/tapyrus-core - github](https://github.com/chaintope/tapyrus-core)  ## Tapyrus API の利用法  Tapyrus API は REST API として提供されています。利用を開始するためには、Tapyrus API の `エンドポイント` に対して、 `認証` 済みの トークンを使いアクセスする必要があります。また、認証されたユーザはそれぞれが自身のウォレットを Tapyrus API 内部に持つことになります。 ウォレットではそのユーザの TPC やトークンといったアセットを管理するための鍵が管理され、アセットの移動などで利用されます。  ### Tapyrus API のエンドポイント  エンドポイントは以下のフォーマットで作成され、 chaintope より提供されます。  `ap-01.tapyrus.chaintope.com`  例えば [testnet](https://testnet-explorer.tapyrus.dev.chaintope.com/blocks) では以下のようになります。  `testnet-api.tapyrus.chaintope.com`  testnet は誰でも利用可能な動作の確認用のネットワークであり、予告なくリセットされる可能性があります。 利用に必要な TPC は [faucet](https://testnet-faucet.tapyrus.dev.chaintope.com) から取得できます。  * [faucet](https://testnet-faucet.tapyrus.dev.chaintope.com)  ### OpenID Connect を使った認証  Tapyrus API では [OpenID Connect](https://openid.net/connect/) を使った認証をサポートします。この認証を利用するためには、 以下のステップを踏みます。  1. 利用する OpenID Provider(OP) を選択する    公開された OP から選択する方法と、自身で OP を構築する方法があります。独自のユーザデータベースがあり、そのユーザに Tapyrus API   を利用させる場合は後者の自身で OP を構築する方法を選択することになります。  2. OAuth 2.0 Client Credential を入手する    多くの公開された OP では、アプリケーションを登録して Client Credential を入手する必要があります。手順は利用する OP に従ってください。  3. Access Token と ID Token を入手する    OpenID Connect に沿った認証を行い、 token エンドポイントから ID Token を入手します。  4. Tapyrus API ユーザを作成する    入手した Access Token と ID Token を Tapyrus API の [createUser API](https://doc.api.tapyrus.chaintope.com/#operation/createUser) へ送り、 Tapyrus API のユーザを作成します。  コード例を後述の Getting Started ドキュメントで解説していますので、そちらを参照してください。  ## Tapyrus API ユーザとウォレットについて  認証により得たアクセストークンを使い、Tapyrus API ユーザを１つ作成する必要があります。 Tapyrus API の内部では、このユーザ１つにつき１つのウォレットが作成されます。 ウォレットではアセットの受け取りや、送付に必要な公開鍵と秘密鍵のペアが管理されており、同時にそれらのカギに紐づくアセットも管理されます。 そのため、認証を行ったユーザごとに独立したアセットの管理が可能になります。  # Getting Started  Getting Started ドキュメントでは実際のコード例を交えながらより具体的な Tapyrus API の利用法を解説しています。    * [Getting Started - [Javascript] Tapyrus API を利用するウェブアプリケーションの開発を学ぶ](https://github.com/chaintope/tapyrus-api-client-examples/tree/main/javascript/GettingStarted-ja.md)   # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from tapyrus-api-client.api_client import ApiClient, Endpoint as _Endpoint
from tapyrus-api-client.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from tapyrus-api-client.model.add_timestamp_request import AddTimestampRequest
from tapyrus-api-client.model.get_timestamps_response import GetTimestampsResponse


class TimestampApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

        def __add_timestamp(
            self,
            **kwargs
        ):
            """Timestampを記録  # noqa: E501

            ブロックチェーンにハッシュ値をタイムスタンプとして記録します。  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.add_timestamp(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                add_timestamp_request (AddTimestampRequest): `content_hash`, `prefix`を受け取り、ブロックチェーンにハッシュ値をタイムスタンプとして記録します。. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.add_timestamp = _Endpoint(
            settings={
                'response_type': None,
                'auth': [],
                'endpoint_path': '/timestamp',
                'operation_id': 'add_timestamp',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'add_timestamp_request',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'add_timestamp_request':
                        (AddTimestampRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'add_timestamp_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__add_timestamp
        )

        def __get_timestamps(
            self,
            **kwargs
        ):
            """Timestamp一覧表示  # noqa: E501

            ブロックチェーンに記録したタイムスタンプを取得し、`content_hash`,`prefix`,`txid`を一覧で表示します。  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_timestamps(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                [GetTimestampsResponse]
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.get_timestamps = _Endpoint(
            settings={
                'response_type': ([GetTimestampsResponse],),
                'auth': [],
                'endpoint_path': '/timestamps',
                'operation_id': 'get_timestamps',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                },
                'attribute_map': {
                },
                'location_map': {
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_timestamps
        )
