# autogenerated module
from dataclasses import dataclass, field
from typing import List

from ..core.dataclasses_dict import DataclassDictMixIn

from . import core_v1
from . import meta_v1


@dataclass
class PodPreset(DataclassDictMixIn):
    """PodPreset is a policy resource that defines additional runtime requirements
      for a Pod.

      **parameters**

      * **apiVersion** ``str`` - *(optional)* APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
      * **kind** ``str`` - *(optional)* Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated. In CamelCase. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
      * **metadata** ``meta_v1.ObjectMeta`` - *(optional)* 
      * **spec** ``PodPresetSpec`` - *(optional)* 
    """
    apiVersion: 'str' = None
    kind: 'str' = None
    metadata: 'meta_v1.ObjectMeta' = None
    spec: 'PodPresetSpec' = None


@dataclass
class PodPresetList(DataclassDictMixIn):
    """PodPresetList is a list of PodPreset objects.

      **parameters**

      * **items** ``List[PodPreset]`` - Items is a list of schema objects.
      * **apiVersion** ``str`` - *(optional)* APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
      * **kind** ``str`` - *(optional)* Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated. In CamelCase. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
      * **metadata** ``meta_v1.ListMeta`` - *(optional)* Standard list metadata. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
    """
    items: 'List[PodPreset]'
    apiVersion: 'str' = None
    kind: 'str' = None
    metadata: 'meta_v1.ListMeta' = None


@dataclass
class PodPresetSpec(DataclassDictMixIn):
    """PodPresetSpec is a description of a pod preset.

      **parameters**

      * **env** ``List[core_v1.EnvVar]`` - *(optional)* Env defines the collection of EnvVar to inject into containers.
      * **envFrom** ``List[core_v1.EnvFromSource]`` - *(optional)* EnvFrom defines the collection of EnvFromSource to inject into containers.
      * **selector** ``meta_v1.LabelSelector`` - *(optional)* Selector is a label query over a set of resources, in this case pods.
        Required.
      * **volumeMounts** ``List[core_v1.VolumeMount]`` - *(optional)* VolumeMounts defines the collection of VolumeMount to inject into containers.
      * **volumes** ``List[core_v1.Volume]`` - *(optional)* Volumes defines the collection of Volume to inject into the pod.
    """
    env: 'List[core_v1.EnvVar]' = None
    envFrom: 'List[core_v1.EnvFromSource]' = None
    selector: 'meta_v1.LabelSelector' = None
    volumeMounts: 'List[core_v1.VolumeMount]' = None
    volumes: 'List[core_v1.Volume]' = None


