# autogenerated module
from dataclasses import dataclass, field
from typing import List

from ..core.dataclasses_dict import DataclassDictMixIn

from . import util_intstr
from . import meta_v1


@dataclass
class IPBlock(DataclassDictMixIn):
    """IPBlock describes a particular CIDR (Ex. "192.168.1.1/24","2001:db9::/64")
      that is allowed to the pods matched by a NetworkPolicySpec's podSelector. The
      except entry describes CIDRs that should not be included within this rule.

      **parameters**

      * **cidr** ``str`` - CIDR is a string representing the IP Block Valid examples are "192.168.1.1/24"
        or "2001:db9::/64"
      * **except_** ``List[str]`` - *(optional)* Except is a slice of CIDRs that should not be included within an IP Block
        Valid examples are "192.168.1.1/24" or "2001:db9::/64" Except values will be
        rejected if they are outside the CIDR range
    """
    cidr: 'str'
    except_: 'List[str]' = field(metadata={"json": "except"}, default=None)


@dataclass
class NetworkPolicy(DataclassDictMixIn):
    """NetworkPolicy describes what network traffic is allowed for a set of Pods

      **parameters**

      * **apiVersion** ``str`` - *(optional)* APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
      * **kind** ``str`` - *(optional)* Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated. In CamelCase. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
      * **metadata** ``meta_v1.ObjectMeta`` - *(optional)* Standard object's metadata. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
      * **spec** ``NetworkPolicySpec`` - *(optional)* Specification of the desired behavior for this NetworkPolicy.
    """
    apiVersion: 'str' = None
    kind: 'str' = None
    metadata: 'meta_v1.ObjectMeta' = None
    spec: 'NetworkPolicySpec' = None


@dataclass
class NetworkPolicyEgressRule(DataclassDictMixIn):
    """NetworkPolicyEgressRule describes a particular set of traffic that is allowed
      out of pods matched by a NetworkPolicySpec's podSelector. The traffic must
      match both ports and to. This type is beta-level in 1.8

      **parameters**

      * **ports** ``List[NetworkPolicyPort]`` - *(optional)* List of destination ports for outgoing traffic. Each item in this list is
        combined using a logical OR. If this field is empty or missing, this rule
        matches all ports (traffic not restricted by port). If this field is present
        and contains at least one item, then this rule allows traffic only if the
        traffic matches at least one port in the list.
      * **to** ``List[NetworkPolicyPeer]`` - *(optional)* List of destinations for outgoing traffic of pods selected for this rule.
        Items in this list are combined using a logical OR operation. If this field is
        empty or missing, this rule matches all destinations (traffic not restricted
        by destination). If this field is present and contains at least one item, this
        rule allows traffic only if the traffic matches at least one item in the to
        list.
    """
    ports: 'List[NetworkPolicyPort]' = None
    to: 'List[NetworkPolicyPeer]' = None


@dataclass
class NetworkPolicyIngressRule(DataclassDictMixIn):
    """NetworkPolicyIngressRule describes a particular set of traffic that is allowed
      to the pods matched by a NetworkPolicySpec's podSelector. The traffic must
      match both ports and from.

      **parameters**

      * **from_** ``List[NetworkPolicyPeer]`` - *(optional)* List of sources which should be able to access the pods selected for this
        rule. Items in this list are combined using a logical OR operation. If this
        field is empty or missing, this rule matches all sources (traffic not
        restricted by source). If this field is present and contains at least one
        item, this rule allows traffic only if the traffic matches at least one item
        in the from list.
      * **ports** ``List[NetworkPolicyPort]`` - *(optional)* List of ports which should be made accessible on the pods selected for this
        rule. Each item in this list is combined using a logical OR. If this field is
        empty or missing, this rule matches all ports (traffic not restricted by
        port). If this field is present and contains at least one item, then this rule
        allows traffic only if the traffic matches at least one port in the list.
    """
    from_: 'List[NetworkPolicyPeer]' = field(metadata={"json": "from"}, default=None)
    ports: 'List[NetworkPolicyPort]' = None


@dataclass
class NetworkPolicyList(DataclassDictMixIn):
    """NetworkPolicyList is a list of NetworkPolicy objects.

      **parameters**

      * **items** ``List[NetworkPolicy]`` - Items is a list of schema objects.
      * **apiVersion** ``str`` - *(optional)* APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
      * **kind** ``str`` - *(optional)* Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated. In CamelCase. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
      * **metadata** ``meta_v1.ListMeta`` - *(optional)* Standard list metadata. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
    """
    items: 'List[NetworkPolicy]'
    apiVersion: 'str' = None
    kind: 'str' = None
    metadata: 'meta_v1.ListMeta' = None


@dataclass
class NetworkPolicyPeer(DataclassDictMixIn):
    """NetworkPolicyPeer describes a peer to allow traffic from. Only certain
      combinations of fields are allowed

      **parameters**

      * **ipBlock** ``IPBlock`` - *(optional)* IPBlock defines policy on a particular IPBlock. If this field is set then
        neither of the other fields can be.
      * **namespaceSelector** ``meta_v1.LabelSelector`` - *(optional)* Selects Namespaces using cluster-scoped labels. This field follows standard
        label selector semantics; if present but empty, it selects all namespaces.
        If PodSelector is also set, then the NetworkPolicyPeer as a whole selects the
        Pods matching PodSelector in the Namespaces selected by NamespaceSelector.
        Otherwise it selects all Pods in the Namespaces selected by NamespaceSelector.
      * **podSelector** ``meta_v1.LabelSelector`` - *(optional)* This is a label selector which selects Pods. This field follows standard label
        selector semantics; if present but empty, it selects all pods.
        If NamespaceSelector is also set, then the NetworkPolicyPeer as a whole
        selects the Pods matching PodSelector in the Namespaces selected by
        NamespaceSelector. Otherwise it selects the Pods matching PodSelector in the
        policy's own Namespace.
    """
    ipBlock: 'IPBlock' = None
    namespaceSelector: 'meta_v1.LabelSelector' = None
    podSelector: 'meta_v1.LabelSelector' = None


@dataclass
class NetworkPolicyPort(DataclassDictMixIn):
    """NetworkPolicyPort describes a port to allow traffic on

      **parameters**

      * **port** ``util_intstr.IntOrString`` - *(optional)* The port on the given protocol. This can either be a numerical or named port
        on a pod. If this field is not provided, this matches all port names and
        numbers.
      * **protocol** ``str`` - *(optional)* The protocol (TCP, UDP, or SCTP) which traffic must match. If not specified,
        this field defaults to TCP.
    """
    port: 'util_intstr.IntOrString' = None
    protocol: 'str' = None


@dataclass
class NetworkPolicySpec(DataclassDictMixIn):
    """NetworkPolicySpec provides the specification of a NetworkPolicy

      **parameters**

      * **podSelector** ``meta_v1.LabelSelector`` - Selects the pods to which this NetworkPolicy object applies. The array of
        ingress rules is applied to any pods selected by this field. Multiple network
        policies can select the same set of pods. In this case, the ingress rules for
        each are combined additively. This field is NOT optional and follows standard
        label selector semantics. An empty podSelector matches all pods in this
        namespace.
      * **egress** ``List[NetworkPolicyEgressRule]`` - *(optional)* List of egress rules to be applied to the selected pods. Outgoing traffic is
        allowed if there are no NetworkPolicies selecting the pod (and cluster policy
        otherwise allows the traffic), OR if the traffic matches at least one egress
        rule across all of the NetworkPolicy objects whose podSelector matches the
        pod. If this field is empty then this NetworkPolicy limits all outgoing
        traffic (and serves solely to ensure that the pods it selects are isolated by
        default). This field is beta-level in 1.8
      * **ingress** ``List[NetworkPolicyIngressRule]`` - *(optional)* List of ingress rules to be applied to the selected pods. Traffic is allowed
        to a pod if there are no NetworkPolicies selecting the pod (and cluster policy
        otherwise allows the traffic), OR if the traffic source is the pod's local
        node, OR if the traffic matches at least one ingress rule across all of the
        NetworkPolicy objects whose podSelector matches the pod. If this field is
        empty then this NetworkPolicy does not allow any traffic (and serves solely to
        ensure that the pods it selects are isolated by default)
      * **policyTypes** ``List[str]`` - *(optional)* List of rule types that the NetworkPolicy relates to. Valid options are
        "Ingress", "Egress", or "Ingress,Egress". If this field is not specified, it
        will default based on the existence of Ingress or Egress rules; policies that
        contain an Egress section are assumed to affect Egress, and all policies
        (whether or not they contain an Ingress section) are assumed to affect
        Ingress. If you want to write an egress-only policy, you must explicitly
        specify policyTypes [ "Egress" ]. Likewise, if you want to write a policy that
        specifies that no egress is allowed, you must specify a policyTypes value that
        include "Egress" (since such a policy would not include an Egress section and
        would otherwise default to just [ "Ingress" ]). This field is beta-level in
        1.8
    """
    podSelector: 'meta_v1.LabelSelector'
    egress: 'List[NetworkPolicyEgressRule]' = None
    ingress: 'List[NetworkPolicyIngressRule]' = None
    policyTypes: 'List[str]' = None


