# autogenerated module
from dataclasses import dataclass, field
from typing import List

from ..core.dataclasses_dict import DataclassDictMixIn

from . import core_v1
from . import meta_v1


@dataclass
class Event(DataclassDictMixIn):
    """Event is a report of an event somewhere in the cluster. It generally denotes
      some state change in the system.

      **parameters**

      * **eventTime** ``meta_v1.MicroTime`` - Required. Time when this Event was first observed.
      * **action** ``str`` - *(optional)* What action was taken/failed regarding to the regarding object.
      * **apiVersion** ``str`` - *(optional)* APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
      * **deprecatedCount** ``int`` - *(optional)* Deprecated field assuring backward compatibility with core.v1 Event type
      * **deprecatedFirstTimestamp** ``meta_v1.Time`` - *(optional)* Deprecated field assuring backward compatibility with core.v1 Event type
      * **deprecatedLastTimestamp** ``meta_v1.Time`` - *(optional)* Deprecated field assuring backward compatibility with core.v1 Event type
      * **deprecatedSource** ``core_v1.EventSource`` - *(optional)* Deprecated field assuring backward compatibility with core.v1 Event type
      * **kind** ``str`` - *(optional)* Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated. In CamelCase. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
      * **metadata** ``meta_v1.ObjectMeta`` - *(optional)* 
      * **note** ``str`` - *(optional)* Optional. A human-readable description of the status of this operation.
        Maximal length of the note is 1kB, but libraries should be prepared to handle
        values up to 64kB.
      * **reason** ``str`` - *(optional)* Why the action was taken.
      * **regarding** ``core_v1.ObjectReference`` - *(optional)* The object this Event is about. In most cases it's an Object reporting
        controller implements. E.g. ReplicaSetController implements ReplicaSets and
        this event is emitted because it acts on some changes in a ReplicaSet object.
      * **related** ``core_v1.ObjectReference`` - *(optional)* Optional secondary object for more complex actions. E.g. when regarding object
        triggers a creation or deletion of related object.
      * **reportingController** ``str`` - *(optional)* Name of the controller that emitted this Event, e.g. `kubernetes.io/kubelet`.
      * **reportingInstance** ``str`` - *(optional)* ID of the controller instance, e.g. `kubelet-xyzf`.
      * **series** ``EventSeries`` - *(optional)* Data about the Event series this event represents or nil if it's a singleton
        Event.
      * **type** ``str`` - *(optional)* Type of this event (Normal, Warning), new types could be added in the future.
    """
    eventTime: 'meta_v1.MicroTime'
    action: 'str' = None
    apiVersion: 'str' = None
    deprecatedCount: 'int' = None
    deprecatedFirstTimestamp: 'meta_v1.Time' = None
    deprecatedLastTimestamp: 'meta_v1.Time' = None
    deprecatedSource: 'core_v1.EventSource' = None
    kind: 'str' = None
    metadata: 'meta_v1.ObjectMeta' = None
    note: 'str' = None
    reason: 'str' = None
    regarding: 'core_v1.ObjectReference' = None
    related: 'core_v1.ObjectReference' = None
    reportingController: 'str' = None
    reportingInstance: 'str' = None
    series: 'EventSeries' = None
    type: 'str' = None


@dataclass
class EventList(DataclassDictMixIn):
    """EventList is a list of Event objects.

      **parameters**

      * **items** ``List[Event]`` - Items is a list of schema objects.
      * **apiVersion** ``str`` - *(optional)* APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
      * **kind** ``str`` - *(optional)* Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated. In CamelCase. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
      * **metadata** ``meta_v1.ListMeta`` - *(optional)* Standard list metadata. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
    """
    items: 'List[Event]'
    apiVersion: 'str' = None
    kind: 'str' = None
    metadata: 'meta_v1.ListMeta' = None


@dataclass
class EventSeries(DataclassDictMixIn):
    """EventSeries contain information on series of events, i.e. thing that was/is
      happening continuously for some time.

      **parameters**

      * **count** ``int`` - Number of occurrences in this series up to the last heartbeat time
      * **lastObservedTime** ``meta_v1.MicroTime`` - Time when last Event from the series was seen before last heartbeat.
      * **state** ``str`` - Information whether this series is ongoing or finished. Deprecated. Planned
        removal for 1.18
    """
    count: 'int'
    lastObservedTime: 'meta_v1.MicroTime'
    state: 'str'


