# autogenerated module
from dataclasses import dataclass, field
from typing import List

from ..core.dataclasses_dict import DataclassDictMixIn

from . import meta_v1


@dataclass
class CertificateSigningRequest(DataclassDictMixIn):
    """Describes a certificate signing request

      **parameters**

      * **apiVersion** ``str`` - *(optional)* APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
      * **kind** ``str`` - *(optional)* Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated. In CamelCase. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
      * **metadata** ``meta_v1.ObjectMeta`` - *(optional)* 
      * **spec** ``CertificateSigningRequestSpec`` - *(optional)* The certificate request itself and any additional information.
      * **status** ``CertificateSigningRequestStatus`` - *(optional)* Derived information about the request.
    """
    apiVersion: 'str' = None
    kind: 'str' = None
    metadata: 'meta_v1.ObjectMeta' = None
    spec: 'CertificateSigningRequestSpec' = None
    status: 'CertificateSigningRequestStatus' = None


@dataclass
class CertificateSigningRequestCondition(DataclassDictMixIn):
    """

      **parameters**

      * **type** ``str`` - request approval state, currently Approved or Denied.
      * **lastUpdateTime** ``meta_v1.Time`` - *(optional)* timestamp for the last update to this condition
      * **message** ``str`` - *(optional)* human readable message with details about the request state
      * **reason** ``str`` - *(optional)* brief reason for the request state
    """
    type: 'str'
    lastUpdateTime: 'meta_v1.Time' = None
    message: 'str' = None
    reason: 'str' = None


@dataclass
class CertificateSigningRequestList(DataclassDictMixIn):
    """

      **parameters**

      * **items** ``List[CertificateSigningRequest]`` - 
      * **apiVersion** ``str`` - *(optional)* APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
      * **kind** ``str`` - *(optional)* Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated. In CamelCase. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
      * **metadata** ``meta_v1.ListMeta`` - *(optional)* 
    """
    items: 'List[CertificateSigningRequest]'
    apiVersion: 'str' = None
    kind: 'str' = None
    metadata: 'meta_v1.ListMeta' = None


@dataclass
class CertificateSigningRequestSpec(DataclassDictMixIn):
    """This information is immutable after the request is created. Only the Request
      and Usages fields can be set on creation, other fields are derived by
      Kubernetes and cannot be modified by users.

      **parameters**

      * **request** ``str`` - Base64-encoded PKCS#10 CSR data
      * **extra** ``dict`` - *(optional)* Extra information about the requesting user. See user.Info interface for
        details.
      * **groups** ``List[str]`` - *(optional)* Group information about the requesting user. See user.Info interface for
        details.
      * **signerName** ``str`` - *(optional)* Requested signer for the request. It is a qualified name in the form:
        `scope-hostname.io/name`. If empty, it will be defaulted:
         1. If it's a kubelet client certificate, it is assigned
            "kubernetes.io/kube-apiserver-client-kubelet".
         2. If it's a kubelet serving certificate, it is assigned
            "kubernetes.io/kubelet-serving".
         3. Otherwise, it is assigned "kubernetes.io/legacy-unknown".
        Distribution of trust for signers happens out of band. You can select on this
        field using `spec.signerName`.
      * **uid** ``str`` - *(optional)* UID information about the requesting user. See user.Info interface for
        details.
      * **usages** ``List[str]`` - *(optional)* allowedUsages specifies a set of usage contexts the key will be valid for.
        See: https://tools.ietf.org/html/rfc5280#section-4.2.1.3
             https://tools.ietf.org/html/rfc5280#section-4.2.1.12
      * **username** ``str`` - *(optional)* Information about the requesting user. See user.Info interface for details.
    """
    request: 'str'
    extra: 'dict' = None
    groups: 'List[str]' = None
    signerName: 'str' = None
    uid: 'str' = None
    usages: 'List[str]' = None
    username: 'str' = None


@dataclass
class CertificateSigningRequestStatus(DataclassDictMixIn):
    """

      **parameters**

      * **certificate** ``str`` - *(optional)* If request was approved, the controller will place the issued certificate
        here.
      * **conditions** ``List[CertificateSigningRequestCondition]`` - *(optional)* Conditions applied to the request, such as approval or denial.
    """
    certificate: 'str' = None
    conditions: 'List[CertificateSigningRequestCondition]' = None


