# coding: utf-8

"""
    FINBOURNE Luminesce Web API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


import re  # noqa: F401
import io
import warnings

from pydantic import validate_arguments, ValidationError
from typing import overload, Optional, Union, Awaitable

from typing_extensions import Annotated
from pydantic import Field, StrictBool, StrictInt, StrictStr

from typing import Optional, Union

from luminesce.models.convert_to_view_data import ConvertToViewData
from luminesce.models.file_reader_builder_def import FileReaderBuilderDef
from luminesce.models.query_design import QueryDesign

from luminesce.api_client import ApiClient
from luminesce.api_response import ApiResponse
from luminesce.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class SqlExecutionApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @overload
    async def get_by_query_csv(self, query : Annotated[StrictStr, Field(..., description="LuminesceSql to Execute (must be one line only)")], query_name : Annotated[Optional[StrictStr], Field(description="Name to apply to the query in logs and `Sys.Logs.HcQueryStart`")] = None, download : Annotated[Optional[StrictBool], Field(description="Makes this a file-download request (as opposed to returning the data in the response-body)")] = None, timeout : Annotated[Optional[StrictInt], Field(description="In seconds: <0 → ∞, 0 → 120s")] = None, delimiter : Annotated[Optional[StrictStr], Field(description="Delimiter string to override the default")] = None, escape : Annotated[Optional[StrictStr], Field(description="Escape character to override the default")] = None, **kwargs) -> str:  # noqa: E501
        ...

    @overload
    def get_by_query_csv(self, query : Annotated[StrictStr, Field(..., description="LuminesceSql to Execute (must be one line only)")], query_name : Annotated[Optional[StrictStr], Field(description="Name to apply to the query in logs and `Sys.Logs.HcQueryStart`")] = None, download : Annotated[Optional[StrictBool], Field(description="Makes this a file-download request (as opposed to returning the data in the response-body)")] = None, timeout : Annotated[Optional[StrictInt], Field(description="In seconds: <0 → ∞, 0 → 120s")] = None, delimiter : Annotated[Optional[StrictStr], Field(description="Delimiter string to override the default")] = None, escape : Annotated[Optional[StrictStr], Field(description="Escape character to override the default")] = None, async_req: Optional[bool]=True, **kwargs) -> str:  # noqa: E501
        ...

    @validate_arguments
    def get_by_query_csv(self, query : Annotated[StrictStr, Field(..., description="LuminesceSql to Execute (must be one line only)")], query_name : Annotated[Optional[StrictStr], Field(description="Name to apply to the query in logs and `Sys.Logs.HcQueryStart`")] = None, download : Annotated[Optional[StrictBool], Field(description="Makes this a file-download request (as opposed to returning the data in the response-body)")] = None, timeout : Annotated[Optional[StrictInt], Field(description="In seconds: <0 → ∞, 0 → 120s")] = None, delimiter : Annotated[Optional[StrictStr], Field(description="Delimiter string to override the default")] = None, escape : Annotated[Optional[StrictStr], Field(description="Escape character to override the default")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[str, Awaitable[str]]:  # noqa: E501
        """GetByQueryCsv: Executes Sql, returned in CSV format, where the sql is simply in the url.  # noqa: E501

         For simple single-line query execution via the url. e.g. `select ^ from Sys.Field order by 1, 2`  The following error codes are to be anticipated with standard Problem Detail reports: - 400 BadRequest - something failed with the execution or parsing of your query - 401 Unauthorized   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_by_query_csv(query, query_name, download, timeout, delimiter, escape, async_req=True)
        >>> result = thread.get()

        :param query: LuminesceSql to Execute (must be one line only) (required)
        :type query: str
        :param query_name: Name to apply to the query in logs and `Sys.Logs.HcQueryStart`
        :type query_name: str
        :param download: Makes this a file-download request (as opposed to returning the data in the response-body)
        :type download: bool
        :param timeout: In seconds: <0 → ∞, 0 → 120s
        :type timeout: int
        :param delimiter: Delimiter string to override the default
        :type delimiter: str
        :param escape: Escape character to override the default
        :type escape: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: str
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the get_by_query_csv_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.get_by_query_csv_with_http_info(query, query_name, download, timeout, delimiter, escape, **kwargs)  # noqa: E501

    @validate_arguments
    def get_by_query_csv_with_http_info(self, query : Annotated[StrictStr, Field(..., description="LuminesceSql to Execute (must be one line only)")], query_name : Annotated[Optional[StrictStr], Field(description="Name to apply to the query in logs and `Sys.Logs.HcQueryStart`")] = None, download : Annotated[Optional[StrictBool], Field(description="Makes this a file-download request (as opposed to returning the data in the response-body)")] = None, timeout : Annotated[Optional[StrictInt], Field(description="In seconds: <0 → ∞, 0 → 120s")] = None, delimiter : Annotated[Optional[StrictStr], Field(description="Delimiter string to override the default")] = None, escape : Annotated[Optional[StrictStr], Field(description="Escape character to override the default")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """GetByQueryCsv: Executes Sql, returned in CSV format, where the sql is simply in the url.  # noqa: E501

         For simple single-line query execution via the url. e.g. `select ^ from Sys.Field order by 1, 2`  The following error codes are to be anticipated with standard Problem Detail reports: - 400 BadRequest - something failed with the execution or parsing of your query - 401 Unauthorized   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_by_query_csv_with_http_info(query, query_name, download, timeout, delimiter, escape, async_req=True)
        >>> result = thread.get()

        :param query: LuminesceSql to Execute (must be one line only) (required)
        :type query: str
        :param query_name: Name to apply to the query in logs and `Sys.Logs.HcQueryStart`
        :type query_name: str
        :param download: Makes this a file-download request (as opposed to returning the data in the response-body)
        :type download: bool
        :param timeout: In seconds: <0 → ∞, 0 → 120s
        :type timeout: int
        :param delimiter: Delimiter string to override the default
        :type delimiter: str
        :param escape: Escape character to override the default
        :type escape: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(str, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'query',
            'query_name',
            'download',
            'timeout',
            'delimiter',
            'escape'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_by_query_csv" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['query']:
            _path_params['query'] = _params['query']


        # process the query parameters
        _query_params = []
        if _params.get('query_name') is not None:  # noqa: E501
            _query_params.append(('queryName', _params['query_name']))

        if _params.get('download') is not None:  # noqa: E501
            _query_params.append(('download', _params['download']))

        if _params.get('timeout') is not None:  # noqa: E501
            _query_params.append(('timeout', _params['timeout']))

        if _params.get('delimiter') is not None:  # noqa: E501
            _query_params.append(('delimiter', _params['delimiter']))

        if _params.get('escape') is not None:  # noqa: E501
            _query_params.append(('escape', _params['escape']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "str",
            '400': "LusidProblemDetails",
        }

        return self.api_client.call_api(
            '/api/Sql/csv/{query}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @overload
    async def get_by_query_excel(self, query : Annotated[StrictStr, Field(..., description="LuminesceSql to Execute (must be one line only)")], query_name : Annotated[Optional[StrictStr], Field(description="Name to apply to the query in logs and `Sys.Logs.HcQueryStart`")] = None, timeout : Annotated[Optional[StrictInt], Field(description="In seconds: <0 → ∞, 0 → 120s")] = None, **kwargs) -> bytearray:  # noqa: E501
        ...

    @overload
    def get_by_query_excel(self, query : Annotated[StrictStr, Field(..., description="LuminesceSql to Execute (must be one line only)")], query_name : Annotated[Optional[StrictStr], Field(description="Name to apply to the query in logs and `Sys.Logs.HcQueryStart`")] = None, timeout : Annotated[Optional[StrictInt], Field(description="In seconds: <0 → ∞, 0 → 120s")] = None, async_req: Optional[bool]=True, **kwargs) -> bytearray:  # noqa: E501
        ...

    @validate_arguments
    def get_by_query_excel(self, query : Annotated[StrictStr, Field(..., description="LuminesceSql to Execute (must be one line only)")], query_name : Annotated[Optional[StrictStr], Field(description="Name to apply to the query in logs and `Sys.Logs.HcQueryStart`")] = None, timeout : Annotated[Optional[StrictInt], Field(description="In seconds: <0 → ∞, 0 → 120s")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[bytearray, Awaitable[bytearray]]:  # noqa: E501
        """GetByQueryExcel: Executes Sql, returned in Excel (xlsx) format (as a file to be downloaded) format, where the sql is simply in the url.  # noqa: E501

         For simple single-line query execution via the url. e.g. `select ^ from Sys.Field order by 1, 2`  The following error codes are to be anticipated with standard Problem Detail reports: - 400 BadRequest - something failed with the execution or parsing of your query - 401 Unauthorized   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_by_query_excel(query, query_name, timeout, async_req=True)
        >>> result = thread.get()

        :param query: LuminesceSql to Execute (must be one line only) (required)
        :type query: str
        :param query_name: Name to apply to the query in logs and `Sys.Logs.HcQueryStart`
        :type query_name: str
        :param timeout: In seconds: <0 → ∞, 0 → 120s
        :type timeout: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: bytearray
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the get_by_query_excel_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.get_by_query_excel_with_http_info(query, query_name, timeout, **kwargs)  # noqa: E501

    @validate_arguments
    def get_by_query_excel_with_http_info(self, query : Annotated[StrictStr, Field(..., description="LuminesceSql to Execute (must be one line only)")], query_name : Annotated[Optional[StrictStr], Field(description="Name to apply to the query in logs and `Sys.Logs.HcQueryStart`")] = None, timeout : Annotated[Optional[StrictInt], Field(description="In seconds: <0 → ∞, 0 → 120s")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """GetByQueryExcel: Executes Sql, returned in Excel (xlsx) format (as a file to be downloaded) format, where the sql is simply in the url.  # noqa: E501

         For simple single-line query execution via the url. e.g. `select ^ from Sys.Field order by 1, 2`  The following error codes are to be anticipated with standard Problem Detail reports: - 400 BadRequest - something failed with the execution or parsing of your query - 401 Unauthorized   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_by_query_excel_with_http_info(query, query_name, timeout, async_req=True)
        >>> result = thread.get()

        :param query: LuminesceSql to Execute (must be one line only) (required)
        :type query: str
        :param query_name: Name to apply to the query in logs and `Sys.Logs.HcQueryStart`
        :type query_name: str
        :param timeout: In seconds: <0 → ∞, 0 → 120s
        :type timeout: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(bytearray, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'query',
            'query_name',
            'timeout'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_by_query_excel" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['query']:
            _path_params['query'] = _params['query']


        # process the query parameters
        _query_params = []
        if _params.get('query_name') is not None:  # noqa: E501
            _query_params.append(('queryName', _params['query_name']))

        if _params.get('timeout') is not None:  # noqa: E501
            _query_params.append(('timeout', _params['timeout']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "bytearray",
            '400': "LusidProblemDetails",
        }

        return self.api_client.call_api(
            '/api/Sql/excel/{query}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @overload
    async def get_by_query_json(self, query : Annotated[StrictStr, Field(..., description="LuminesceSql to Execute (must be one line only)")], query_name : Annotated[Optional[StrictStr], Field(description="Name to apply to the query in logs and `Sys.Logs.HcQueryStart`")] = None, timeout : Annotated[Optional[StrictInt], Field(description="In seconds: <0 → ∞, 0 → 120s")] = None, json_proper : Annotated[Optional[StrictBool], Field(description="Should this be text/json (not json-encoded-as-a-string)")] = None, **kwargs) -> str:  # noqa: E501
        ...

    @overload
    def get_by_query_json(self, query : Annotated[StrictStr, Field(..., description="LuminesceSql to Execute (must be one line only)")], query_name : Annotated[Optional[StrictStr], Field(description="Name to apply to the query in logs and `Sys.Logs.HcQueryStart`")] = None, timeout : Annotated[Optional[StrictInt], Field(description="In seconds: <0 → ∞, 0 → 120s")] = None, json_proper : Annotated[Optional[StrictBool], Field(description="Should this be text/json (not json-encoded-as-a-string)")] = None, async_req: Optional[bool]=True, **kwargs) -> str:  # noqa: E501
        ...

    @validate_arguments
    def get_by_query_json(self, query : Annotated[StrictStr, Field(..., description="LuminesceSql to Execute (must be one line only)")], query_name : Annotated[Optional[StrictStr], Field(description="Name to apply to the query in logs and `Sys.Logs.HcQueryStart`")] = None, timeout : Annotated[Optional[StrictInt], Field(description="In seconds: <0 → ∞, 0 → 120s")] = None, json_proper : Annotated[Optional[StrictBool], Field(description="Should this be text/json (not json-encoded-as-a-string)")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[str, Awaitable[str]]:  # noqa: E501
        """GetByQueryJson: Executes Sql, returned in JSON format, where the sql is simply in the url.  # noqa: E501

         For simple single-line query execution via the url. e.g. `select ^ from Sys.Field order by 1, 2`  The following error codes are to be anticipated with standard Problem Detail reports: - 400 BadRequest - something failed with the execution or parsing of your query - 401 Unauthorized   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_by_query_json(query, query_name, timeout, json_proper, async_req=True)
        >>> result = thread.get()

        :param query: LuminesceSql to Execute (must be one line only) (required)
        :type query: str
        :param query_name: Name to apply to the query in logs and `Sys.Logs.HcQueryStart`
        :type query_name: str
        :param timeout: In seconds: <0 → ∞, 0 → 120s
        :type timeout: int
        :param json_proper: Should this be text/json (not json-encoded-as-a-string)
        :type json_proper: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: str
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the get_by_query_json_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.get_by_query_json_with_http_info(query, query_name, timeout, json_proper, **kwargs)  # noqa: E501

    @validate_arguments
    def get_by_query_json_with_http_info(self, query : Annotated[StrictStr, Field(..., description="LuminesceSql to Execute (must be one line only)")], query_name : Annotated[Optional[StrictStr], Field(description="Name to apply to the query in logs and `Sys.Logs.HcQueryStart`")] = None, timeout : Annotated[Optional[StrictInt], Field(description="In seconds: <0 → ∞, 0 → 120s")] = None, json_proper : Annotated[Optional[StrictBool], Field(description="Should this be text/json (not json-encoded-as-a-string)")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """GetByQueryJson: Executes Sql, returned in JSON format, where the sql is simply in the url.  # noqa: E501

         For simple single-line query execution via the url. e.g. `select ^ from Sys.Field order by 1, 2`  The following error codes are to be anticipated with standard Problem Detail reports: - 400 BadRequest - something failed with the execution or parsing of your query - 401 Unauthorized   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_by_query_json_with_http_info(query, query_name, timeout, json_proper, async_req=True)
        >>> result = thread.get()

        :param query: LuminesceSql to Execute (must be one line only) (required)
        :type query: str
        :param query_name: Name to apply to the query in logs and `Sys.Logs.HcQueryStart`
        :type query_name: str
        :param timeout: In seconds: <0 → ∞, 0 → 120s
        :type timeout: int
        :param json_proper: Should this be text/json (not json-encoded-as-a-string)
        :type json_proper: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(str, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'query',
            'query_name',
            'timeout',
            'json_proper'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_by_query_json" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['query']:
            _path_params['query'] = _params['query']


        # process the query parameters
        _query_params = []
        if _params.get('query_name') is not None:  # noqa: E501
            _query_params.append(('queryName', _params['query_name']))

        if _params.get('timeout') is not None:  # noqa: E501
            _query_params.append(('timeout', _params['timeout']))

        if _params.get('json_proper') is not None:  # noqa: E501
            _query_params.append(('jsonProper', _params['json_proper']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "str",
            '400': "LusidProblemDetails",
        }

        return self.api_client.call_api(
            '/api/Sql/json/{query}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @overload
    async def get_by_query_parquet(self, query : Annotated[StrictStr, Field(..., description="LuminesceSql to Execute (must be one line only)")], query_name : Annotated[Optional[StrictStr], Field(description="Name to apply to the query in logs and `Sys.Logs.HcQueryStart`")] = None, timeout : Annotated[Optional[StrictInt], Field(description="In seconds: <0 → ∞, 0 → 120s")] = None, **kwargs) -> bytearray:  # noqa: E501
        ...

    @overload
    def get_by_query_parquet(self, query : Annotated[StrictStr, Field(..., description="LuminesceSql to Execute (must be one line only)")], query_name : Annotated[Optional[StrictStr], Field(description="Name to apply to the query in logs and `Sys.Logs.HcQueryStart`")] = None, timeout : Annotated[Optional[StrictInt], Field(description="In seconds: <0 → ∞, 0 → 120s")] = None, async_req: Optional[bool]=True, **kwargs) -> bytearray:  # noqa: E501
        ...

    @validate_arguments
    def get_by_query_parquet(self, query : Annotated[StrictStr, Field(..., description="LuminesceSql to Execute (must be one line only)")], query_name : Annotated[Optional[StrictStr], Field(description="Name to apply to the query in logs and `Sys.Logs.HcQueryStart`")] = None, timeout : Annotated[Optional[StrictInt], Field(description="In seconds: <0 → ∞, 0 → 120s")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[bytearray, Awaitable[bytearray]]:  # noqa: E501
        """GetByQueryParquet: Executes Sql, returned in Parquet (.parquet) format (as a file to be downloaded) format, where the sql is simply in the url.  # noqa: E501

         For simple single-line query execution via the url. e.g. `select ^ from Sys.Field order by 1, 2`  The following error codes are to be anticipated with standard Problem Detail reports: - 400 BadRequest - something failed with the execution or parsing of your query - 401 Unauthorized   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_by_query_parquet(query, query_name, timeout, async_req=True)
        >>> result = thread.get()

        :param query: LuminesceSql to Execute (must be one line only) (required)
        :type query: str
        :param query_name: Name to apply to the query in logs and `Sys.Logs.HcQueryStart`
        :type query_name: str
        :param timeout: In seconds: <0 → ∞, 0 → 120s
        :type timeout: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: bytearray
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the get_by_query_parquet_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.get_by_query_parquet_with_http_info(query, query_name, timeout, **kwargs)  # noqa: E501

    @validate_arguments
    def get_by_query_parquet_with_http_info(self, query : Annotated[StrictStr, Field(..., description="LuminesceSql to Execute (must be one line only)")], query_name : Annotated[Optional[StrictStr], Field(description="Name to apply to the query in logs and `Sys.Logs.HcQueryStart`")] = None, timeout : Annotated[Optional[StrictInt], Field(description="In seconds: <0 → ∞, 0 → 120s")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """GetByQueryParquet: Executes Sql, returned in Parquet (.parquet) format (as a file to be downloaded) format, where the sql is simply in the url.  # noqa: E501

         For simple single-line query execution via the url. e.g. `select ^ from Sys.Field order by 1, 2`  The following error codes are to be anticipated with standard Problem Detail reports: - 400 BadRequest - something failed with the execution or parsing of your query - 401 Unauthorized   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_by_query_parquet_with_http_info(query, query_name, timeout, async_req=True)
        >>> result = thread.get()

        :param query: LuminesceSql to Execute (must be one line only) (required)
        :type query: str
        :param query_name: Name to apply to the query in logs and `Sys.Logs.HcQueryStart`
        :type query_name: str
        :param timeout: In seconds: <0 → ∞, 0 → 120s
        :type timeout: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(bytearray, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'query',
            'query_name',
            'timeout'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_by_query_parquet" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['query']:
            _path_params['query'] = _params['query']


        # process the query parameters
        _query_params = []
        if _params.get('query_name') is not None:  # noqa: E501
            _query_params.append(('queryName', _params['query_name']))

        if _params.get('timeout') is not None:  # noqa: E501
            _query_params.append(('timeout', _params['timeout']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "bytearray",
            '400': "LusidProblemDetails",
        }

        return self.api_client.call_api(
            '/api/Sql/parquet/{query}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @overload
    async def get_by_query_pipe(self, query : Annotated[StrictStr, Field(..., description="LuminesceSql to Execute (must be one line only)")], query_name : Annotated[Optional[StrictStr], Field(description="Name to apply to the query in logs and `Sys.Logs.HcQueryStart`")] = None, download : Annotated[Optional[StrictBool], Field(description="Makes this a file-download request (as opposed to returning the data in the response-body)")] = None, timeout : Annotated[Optional[StrictInt], Field(description="In seconds: <0 → ∞, 0 → 120s")] = None, **kwargs) -> str:  # noqa: E501
        ...

    @overload
    def get_by_query_pipe(self, query : Annotated[StrictStr, Field(..., description="LuminesceSql to Execute (must be one line only)")], query_name : Annotated[Optional[StrictStr], Field(description="Name to apply to the query in logs and `Sys.Logs.HcQueryStart`")] = None, download : Annotated[Optional[StrictBool], Field(description="Makes this a file-download request (as opposed to returning the data in the response-body)")] = None, timeout : Annotated[Optional[StrictInt], Field(description="In seconds: <0 → ∞, 0 → 120s")] = None, async_req: Optional[bool]=True, **kwargs) -> str:  # noqa: E501
        ...

    @validate_arguments
    def get_by_query_pipe(self, query : Annotated[StrictStr, Field(..., description="LuminesceSql to Execute (must be one line only)")], query_name : Annotated[Optional[StrictStr], Field(description="Name to apply to the query in logs and `Sys.Logs.HcQueryStart`")] = None, download : Annotated[Optional[StrictBool], Field(description="Makes this a file-download request (as opposed to returning the data in the response-body)")] = None, timeout : Annotated[Optional[StrictInt], Field(description="In seconds: <0 → ∞, 0 → 120s")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[str, Awaitable[str]]:  # noqa: E501
        """GetByQueryPipe: Executes Sql, returned in pipe-delimited format, where the sql is simply in the url.  # noqa: E501

         For simple single-line query execution via the url. e.g. `select ^ from Sys.Field order by 1, 2`  The following error codes are to be anticipated with standard Problem Detail reports: - 400 BadRequest - something failed with the execution or parsing of your query - 401 Unauthorized   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_by_query_pipe(query, query_name, download, timeout, async_req=True)
        >>> result = thread.get()

        :param query: LuminesceSql to Execute (must be one line only) (required)
        :type query: str
        :param query_name: Name to apply to the query in logs and `Sys.Logs.HcQueryStart`
        :type query_name: str
        :param download: Makes this a file-download request (as opposed to returning the data in the response-body)
        :type download: bool
        :param timeout: In seconds: <0 → ∞, 0 → 120s
        :type timeout: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: str
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the get_by_query_pipe_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.get_by_query_pipe_with_http_info(query, query_name, download, timeout, **kwargs)  # noqa: E501

    @validate_arguments
    def get_by_query_pipe_with_http_info(self, query : Annotated[StrictStr, Field(..., description="LuminesceSql to Execute (must be one line only)")], query_name : Annotated[Optional[StrictStr], Field(description="Name to apply to the query in logs and `Sys.Logs.HcQueryStart`")] = None, download : Annotated[Optional[StrictBool], Field(description="Makes this a file-download request (as opposed to returning the data in the response-body)")] = None, timeout : Annotated[Optional[StrictInt], Field(description="In seconds: <0 → ∞, 0 → 120s")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """GetByQueryPipe: Executes Sql, returned in pipe-delimited format, where the sql is simply in the url.  # noqa: E501

         For simple single-line query execution via the url. e.g. `select ^ from Sys.Field order by 1, 2`  The following error codes are to be anticipated with standard Problem Detail reports: - 400 BadRequest - something failed with the execution or parsing of your query - 401 Unauthorized   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_by_query_pipe_with_http_info(query, query_name, download, timeout, async_req=True)
        >>> result = thread.get()

        :param query: LuminesceSql to Execute (must be one line only) (required)
        :type query: str
        :param query_name: Name to apply to the query in logs and `Sys.Logs.HcQueryStart`
        :type query_name: str
        :param download: Makes this a file-download request (as opposed to returning the data in the response-body)
        :type download: bool
        :param timeout: In seconds: <0 → ∞, 0 → 120s
        :type timeout: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(str, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'query',
            'query_name',
            'download',
            'timeout'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_by_query_pipe" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['query']:
            _path_params['query'] = _params['query']


        # process the query parameters
        _query_params = []
        if _params.get('query_name') is not None:  # noqa: E501
            _query_params.append(('queryName', _params['query_name']))

        if _params.get('download') is not None:  # noqa: E501
            _query_params.append(('download', _params['download']))

        if _params.get('timeout') is not None:  # noqa: E501
            _query_params.append(('timeout', _params['timeout']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "str",
            '400': "LusidProblemDetails",
        }

        return self.api_client.call_api(
            '/api/Sql/pipe/{query}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @overload
    async def get_by_query_sqlite(self, query : Annotated[StrictStr, Field(..., description="LuminesceSql to Execute (must be one line only)")], query_name : Annotated[Optional[StrictStr], Field(description="Name to apply to the query in logs and `Sys.Logs.HcQueryStart`")] = None, timeout : Annotated[Optional[StrictInt], Field(description="In seconds: <0 → ∞, 0 → 120s")] = None, **kwargs) -> bytearray:  # noqa: E501
        ...

    @overload
    def get_by_query_sqlite(self, query : Annotated[StrictStr, Field(..., description="LuminesceSql to Execute (must be one line only)")], query_name : Annotated[Optional[StrictStr], Field(description="Name to apply to the query in logs and `Sys.Logs.HcQueryStart`")] = None, timeout : Annotated[Optional[StrictInt], Field(description="In seconds: <0 → ∞, 0 → 120s")] = None, async_req: Optional[bool]=True, **kwargs) -> bytearray:  # noqa: E501
        ...

    @validate_arguments
    def get_by_query_sqlite(self, query : Annotated[StrictStr, Field(..., description="LuminesceSql to Execute (must be one line only)")], query_name : Annotated[Optional[StrictStr], Field(description="Name to apply to the query in logs and `Sys.Logs.HcQueryStart`")] = None, timeout : Annotated[Optional[StrictInt], Field(description="In seconds: <0 → ∞, 0 → 120s")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[bytearray, Awaitable[bytearray]]:  # noqa: E501
        """GetByQuerySqlite: Executes Sql, returned in SqLite DB (sqlite3) format (as a file to be downloaded) format, where the sql is simply in the url.  # noqa: E501

         For simple single-line query execution via the url. e.g. `select ^ from Sys.Field order by 1, 2`  The following error codes are to be anticipated with standard Problem Detail reports: - 400 BadRequest - something failed with the execution or parsing of your query - 401 Unauthorized   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_by_query_sqlite(query, query_name, timeout, async_req=True)
        >>> result = thread.get()

        :param query: LuminesceSql to Execute (must be one line only) (required)
        :type query: str
        :param query_name: Name to apply to the query in logs and `Sys.Logs.HcQueryStart`
        :type query_name: str
        :param timeout: In seconds: <0 → ∞, 0 → 120s
        :type timeout: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: bytearray
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the get_by_query_sqlite_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.get_by_query_sqlite_with_http_info(query, query_name, timeout, **kwargs)  # noqa: E501

    @validate_arguments
    def get_by_query_sqlite_with_http_info(self, query : Annotated[StrictStr, Field(..., description="LuminesceSql to Execute (must be one line only)")], query_name : Annotated[Optional[StrictStr], Field(description="Name to apply to the query in logs and `Sys.Logs.HcQueryStart`")] = None, timeout : Annotated[Optional[StrictInt], Field(description="In seconds: <0 → ∞, 0 → 120s")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """GetByQuerySqlite: Executes Sql, returned in SqLite DB (sqlite3) format (as a file to be downloaded) format, where the sql is simply in the url.  # noqa: E501

         For simple single-line query execution via the url. e.g. `select ^ from Sys.Field order by 1, 2`  The following error codes are to be anticipated with standard Problem Detail reports: - 400 BadRequest - something failed with the execution or parsing of your query - 401 Unauthorized   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_by_query_sqlite_with_http_info(query, query_name, timeout, async_req=True)
        >>> result = thread.get()

        :param query: LuminesceSql to Execute (must be one line only) (required)
        :type query: str
        :param query_name: Name to apply to the query in logs and `Sys.Logs.HcQueryStart`
        :type query_name: str
        :param timeout: In seconds: <0 → ∞, 0 → 120s
        :type timeout: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(bytearray, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'query',
            'query_name',
            'timeout'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_by_query_sqlite" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['query']:
            _path_params['query'] = _params['query']


        # process the query parameters
        _query_params = []
        if _params.get('query_name') is not None:  # noqa: E501
            _query_params.append(('queryName', _params['query_name']))

        if _params.get('timeout') is not None:  # noqa: E501
            _query_params.append(('timeout', _params['timeout']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "bytearray",
            '400': "LusidProblemDetails",
        }

        return self.api_client.call_api(
            '/api/Sql/sqlite/{query}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @overload
    async def get_by_query_xml(self, query : Annotated[StrictStr, Field(..., description="LuminesceSql to Execute (must be one line only)")], query_name : Annotated[Optional[StrictStr], Field(description="Name to apply to the query in logs and `Sys.Logs.HcQueryStart`")] = None, download : Annotated[Optional[StrictBool], Field(description="Makes this a file-download request (as opposed to returning the data in the response-body)")] = None, timeout : Annotated[Optional[StrictInt], Field(description="In seconds: <0 → ∞, 0 → 120s")] = None, **kwargs) -> str:  # noqa: E501
        ...

    @overload
    def get_by_query_xml(self, query : Annotated[StrictStr, Field(..., description="LuminesceSql to Execute (must be one line only)")], query_name : Annotated[Optional[StrictStr], Field(description="Name to apply to the query in logs and `Sys.Logs.HcQueryStart`")] = None, download : Annotated[Optional[StrictBool], Field(description="Makes this a file-download request (as opposed to returning the data in the response-body)")] = None, timeout : Annotated[Optional[StrictInt], Field(description="In seconds: <0 → ∞, 0 → 120s")] = None, async_req: Optional[bool]=True, **kwargs) -> str:  # noqa: E501
        ...

    @validate_arguments
    def get_by_query_xml(self, query : Annotated[StrictStr, Field(..., description="LuminesceSql to Execute (must be one line only)")], query_name : Annotated[Optional[StrictStr], Field(description="Name to apply to the query in logs and `Sys.Logs.HcQueryStart`")] = None, download : Annotated[Optional[StrictBool], Field(description="Makes this a file-download request (as opposed to returning the data in the response-body)")] = None, timeout : Annotated[Optional[StrictInt], Field(description="In seconds: <0 → ∞, 0 → 120s")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[str, Awaitable[str]]:  # noqa: E501
        """GetByQueryXml: Executes Sql, returned in Xml format, where the sql is simply in the url.  # noqa: E501

         For simple single-line query execution via the url. e.g. `select ^ from Sys.Field order by 1, 2`  The following error codes are to be anticipated with standard Problem Detail reports: - 400 BadRequest - something failed with the execution or parsing of your query - 401 Unauthorized   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_by_query_xml(query, query_name, download, timeout, async_req=True)
        >>> result = thread.get()

        :param query: LuminesceSql to Execute (must be one line only) (required)
        :type query: str
        :param query_name: Name to apply to the query in logs and `Sys.Logs.HcQueryStart`
        :type query_name: str
        :param download: Makes this a file-download request (as opposed to returning the data in the response-body)
        :type download: bool
        :param timeout: In seconds: <0 → ∞, 0 → 120s
        :type timeout: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: str
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the get_by_query_xml_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.get_by_query_xml_with_http_info(query, query_name, download, timeout, **kwargs)  # noqa: E501

    @validate_arguments
    def get_by_query_xml_with_http_info(self, query : Annotated[StrictStr, Field(..., description="LuminesceSql to Execute (must be one line only)")], query_name : Annotated[Optional[StrictStr], Field(description="Name to apply to the query in logs and `Sys.Logs.HcQueryStart`")] = None, download : Annotated[Optional[StrictBool], Field(description="Makes this a file-download request (as opposed to returning the data in the response-body)")] = None, timeout : Annotated[Optional[StrictInt], Field(description="In seconds: <0 → ∞, 0 → 120s")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """GetByQueryXml: Executes Sql, returned in Xml format, where the sql is simply in the url.  # noqa: E501

         For simple single-line query execution via the url. e.g. `select ^ from Sys.Field order by 1, 2`  The following error codes are to be anticipated with standard Problem Detail reports: - 400 BadRequest - something failed with the execution or parsing of your query - 401 Unauthorized   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_by_query_xml_with_http_info(query, query_name, download, timeout, async_req=True)
        >>> result = thread.get()

        :param query: LuminesceSql to Execute (must be one line only) (required)
        :type query: str
        :param query_name: Name to apply to the query in logs and `Sys.Logs.HcQueryStart`
        :type query_name: str
        :param download: Makes this a file-download request (as opposed to returning the data in the response-body)
        :type download: bool
        :param timeout: In seconds: <0 → ∞, 0 → 120s
        :type timeout: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(str, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'query',
            'query_name',
            'download',
            'timeout'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_by_query_xml" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['query']:
            _path_params['query'] = _params['query']


        # process the query parameters
        _query_params = []
        if _params.get('query_name') is not None:  # noqa: E501
            _query_params.append(('queryName', _params['query_name']))

        if _params.get('download') is not None:  # noqa: E501
            _query_params.append(('download', _params['download']))

        if _params.get('timeout') is not None:  # noqa: E501
            _query_params.append(('timeout', _params['timeout']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "str",
            '400': "LusidProblemDetails",
        }

        return self.api_client.call_api(
            '/api/Sql/xml/{query}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @overload
    async def put_by_query_csv(self, body : Annotated[StrictStr, Field(..., description="LuminesceSql to Execute (may be multi-line)")], query_name : Annotated[Optional[StrictStr], Field(description="Name to apply to the query in logs and `Sys.Logs.HcQueryStart`")] = None, download : Annotated[Optional[StrictBool], Field(description="Makes this a file-download request (as opposed to returning the data in the response-body)")] = None, timeout_seconds : Annotated[Optional[StrictInt], Field(description="In seconds: <0 → ∞, 0 → 120s")] = None, delimiter : Annotated[Optional[StrictStr], Field(description="Delimiter string to override the default")] = None, escape : Annotated[Optional[StrictStr], Field(description="Escape character to override the default")] = None, **kwargs) -> str:  # noqa: E501
        ...

    @overload
    def put_by_query_csv(self, body : Annotated[StrictStr, Field(..., description="LuminesceSql to Execute (may be multi-line)")], query_name : Annotated[Optional[StrictStr], Field(description="Name to apply to the query in logs and `Sys.Logs.HcQueryStart`")] = None, download : Annotated[Optional[StrictBool], Field(description="Makes this a file-download request (as opposed to returning the data in the response-body)")] = None, timeout_seconds : Annotated[Optional[StrictInt], Field(description="In seconds: <0 → ∞, 0 → 120s")] = None, delimiter : Annotated[Optional[StrictStr], Field(description="Delimiter string to override the default")] = None, escape : Annotated[Optional[StrictStr], Field(description="Escape character to override the default")] = None, async_req: Optional[bool]=True, **kwargs) -> str:  # noqa: E501
        ...

    @validate_arguments
    def put_by_query_csv(self, body : Annotated[StrictStr, Field(..., description="LuminesceSql to Execute (may be multi-line)")], query_name : Annotated[Optional[StrictStr], Field(description="Name to apply to the query in logs and `Sys.Logs.HcQueryStart`")] = None, download : Annotated[Optional[StrictBool], Field(description="Makes this a file-download request (as opposed to returning the data in the response-body)")] = None, timeout_seconds : Annotated[Optional[StrictInt], Field(description="In seconds: <0 → ∞, 0 → 120s")] = None, delimiter : Annotated[Optional[StrictStr], Field(description="Delimiter string to override the default")] = None, escape : Annotated[Optional[StrictStr], Field(description="Escape character to override the default")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[str, Awaitable[str]]:  # noqa: E501
        """PutByQueryCsv: Executes Sql, returned in CSV format, where the sql is the post-body url.  # noqa: E501

         For more complex LuminesceSql a PUT will allow for longer Sql. e.g.: ```sql @@cutoff = select #2020-02-01#; @issues = select Id, SortId, Summary, Created, Updated from Dev.Jira.Issue where Project='HC' and Created < @@cutoff and Updated > @@cutoff;  select i.Id, i.SortId, i.Summary, LinkText, LinkedIssueId, LinkedIssueSortId, LinkedIssueSummary from @issues i inner join Dev.Jira.Issue.Link li     on i.Id = li.IssueId ```  The following error codes are to be anticipated with standard Problem Detail reports: - 400 BadRequest - something failed with the execution or parsing of your query - 401 Unauthorized   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.put_by_query_csv(body, query_name, download, timeout_seconds, delimiter, escape, async_req=True)
        >>> result = thread.get()

        :param body: LuminesceSql to Execute (may be multi-line) (required)
        :type body: str
        :param query_name: Name to apply to the query in logs and `Sys.Logs.HcQueryStart`
        :type query_name: str
        :param download: Makes this a file-download request (as opposed to returning the data in the response-body)
        :type download: bool
        :param timeout_seconds: In seconds: <0 → ∞, 0 → 120s
        :type timeout_seconds: int
        :param delimiter: Delimiter string to override the default
        :type delimiter: str
        :param escape: Escape character to override the default
        :type escape: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: str
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the put_by_query_csv_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.put_by_query_csv_with_http_info(body, query_name, download, timeout_seconds, delimiter, escape, **kwargs)  # noqa: E501

    @validate_arguments
    def put_by_query_csv_with_http_info(self, body : Annotated[StrictStr, Field(..., description="LuminesceSql to Execute (may be multi-line)")], query_name : Annotated[Optional[StrictStr], Field(description="Name to apply to the query in logs and `Sys.Logs.HcQueryStart`")] = None, download : Annotated[Optional[StrictBool], Field(description="Makes this a file-download request (as opposed to returning the data in the response-body)")] = None, timeout_seconds : Annotated[Optional[StrictInt], Field(description="In seconds: <0 → ∞, 0 → 120s")] = None, delimiter : Annotated[Optional[StrictStr], Field(description="Delimiter string to override the default")] = None, escape : Annotated[Optional[StrictStr], Field(description="Escape character to override the default")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """PutByQueryCsv: Executes Sql, returned in CSV format, where the sql is the post-body url.  # noqa: E501

         For more complex LuminesceSql a PUT will allow for longer Sql. e.g.: ```sql @@cutoff = select #2020-02-01#; @issues = select Id, SortId, Summary, Created, Updated from Dev.Jira.Issue where Project='HC' and Created < @@cutoff and Updated > @@cutoff;  select i.Id, i.SortId, i.Summary, LinkText, LinkedIssueId, LinkedIssueSortId, LinkedIssueSummary from @issues i inner join Dev.Jira.Issue.Link li     on i.Id = li.IssueId ```  The following error codes are to be anticipated with standard Problem Detail reports: - 400 BadRequest - something failed with the execution or parsing of your query - 401 Unauthorized   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.put_by_query_csv_with_http_info(body, query_name, download, timeout_seconds, delimiter, escape, async_req=True)
        >>> result = thread.get()

        :param body: LuminesceSql to Execute (may be multi-line) (required)
        :type body: str
        :param query_name: Name to apply to the query in logs and `Sys.Logs.HcQueryStart`
        :type query_name: str
        :param download: Makes this a file-download request (as opposed to returning the data in the response-body)
        :type download: bool
        :param timeout_seconds: In seconds: <0 → ∞, 0 → 120s
        :type timeout_seconds: int
        :param delimiter: Delimiter string to override the default
        :type delimiter: str
        :param escape: Escape character to override the default
        :type escape: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(str, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'body',
            'query_name',
            'download',
            'timeout_seconds',
            'delimiter',
            'escape'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_by_query_csv" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('query_name') is not None:  # noqa: E501
            _query_params.append(('queryName', _params['query_name']))

        if _params.get('download') is not None:  # noqa: E501
            _query_params.append(('download', _params['download']))

        if _params.get('timeout_seconds') is not None:  # noqa: E501
            _query_params.append(('timeoutSeconds', _params['timeout_seconds']))

        if _params.get('delimiter') is not None:  # noqa: E501
            _query_params.append(('delimiter', _params['delimiter']))

        if _params.get('escape') is not None:  # noqa: E501
            _query_params.append(('escape', _params['escape']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['body'] is not None:
            _body_params = _params['body']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['text/plain']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "str",
            '400': "LusidProblemDetails",
        }

        return self.api_client.call_api(
            '/api/Sql/csv', 'PUT',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @overload
    async def put_by_query_excel(self, body : Annotated[StrictStr, Field(..., description="LuminesceSql to Execute (may be multi-line)")], query_name : Annotated[Optional[StrictStr], Field(description="Name to apply to the query in logs and `Sys.Logs.HcQueryStart`")] = None, timeout_seconds : Annotated[Optional[StrictInt], Field(description="In seconds: <0 → ∞, 0 → 120s")] = None, **kwargs) -> bytearray:  # noqa: E501
        ...

    @overload
    def put_by_query_excel(self, body : Annotated[StrictStr, Field(..., description="LuminesceSql to Execute (may be multi-line)")], query_name : Annotated[Optional[StrictStr], Field(description="Name to apply to the query in logs and `Sys.Logs.HcQueryStart`")] = None, timeout_seconds : Annotated[Optional[StrictInt], Field(description="In seconds: <0 → ∞, 0 → 120s")] = None, async_req: Optional[bool]=True, **kwargs) -> bytearray:  # noqa: E501
        ...

    @validate_arguments
    def put_by_query_excel(self, body : Annotated[StrictStr, Field(..., description="LuminesceSql to Execute (may be multi-line)")], query_name : Annotated[Optional[StrictStr], Field(description="Name to apply to the query in logs and `Sys.Logs.HcQueryStart`")] = None, timeout_seconds : Annotated[Optional[StrictInt], Field(description="In seconds: <0 → ∞, 0 → 120s")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[bytearray, Awaitable[bytearray]]:  # noqa: E501
        """PutByQueryExcel: Executes Sql, returned in Excel (xlsx) format (as a file to be downloaded), where the sql is the post-body url.  # noqa: E501

         For more complex LuminesceSql a PUT will allow for longer Sql. e.g.: ```sql @@cutoff = select #2020-02-01#; @issues = select Id, SortId, Summary, Created, Updated from Dev.Jira.Issue where Project='HC' and Created < @@cutoff and Updated > @@cutoff;  select i.Id, i.SortId, i.Summary, LinkText, LinkedIssueId, LinkedIssueSortId, LinkedIssueSummary from @issues i inner join Dev.Jira.Issue.Link li     on i.Id = li.IssueId ```  The following error codes are to be anticipated with standard Problem Detail reports: - 400 BadRequest - something failed with the execution or parsing of your query - 401 Unauthorized   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.put_by_query_excel(body, query_name, timeout_seconds, async_req=True)
        >>> result = thread.get()

        :param body: LuminesceSql to Execute (may be multi-line) (required)
        :type body: str
        :param query_name: Name to apply to the query in logs and `Sys.Logs.HcQueryStart`
        :type query_name: str
        :param timeout_seconds: In seconds: <0 → ∞, 0 → 120s
        :type timeout_seconds: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: bytearray
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the put_by_query_excel_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.put_by_query_excel_with_http_info(body, query_name, timeout_seconds, **kwargs)  # noqa: E501

    @validate_arguments
    def put_by_query_excel_with_http_info(self, body : Annotated[StrictStr, Field(..., description="LuminesceSql to Execute (may be multi-line)")], query_name : Annotated[Optional[StrictStr], Field(description="Name to apply to the query in logs and `Sys.Logs.HcQueryStart`")] = None, timeout_seconds : Annotated[Optional[StrictInt], Field(description="In seconds: <0 → ∞, 0 → 120s")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """PutByQueryExcel: Executes Sql, returned in Excel (xlsx) format (as a file to be downloaded), where the sql is the post-body url.  # noqa: E501

         For more complex LuminesceSql a PUT will allow for longer Sql. e.g.: ```sql @@cutoff = select #2020-02-01#; @issues = select Id, SortId, Summary, Created, Updated from Dev.Jira.Issue where Project='HC' and Created < @@cutoff and Updated > @@cutoff;  select i.Id, i.SortId, i.Summary, LinkText, LinkedIssueId, LinkedIssueSortId, LinkedIssueSummary from @issues i inner join Dev.Jira.Issue.Link li     on i.Id = li.IssueId ```  The following error codes are to be anticipated with standard Problem Detail reports: - 400 BadRequest - something failed with the execution or parsing of your query - 401 Unauthorized   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.put_by_query_excel_with_http_info(body, query_name, timeout_seconds, async_req=True)
        >>> result = thread.get()

        :param body: LuminesceSql to Execute (may be multi-line) (required)
        :type body: str
        :param query_name: Name to apply to the query in logs and `Sys.Logs.HcQueryStart`
        :type query_name: str
        :param timeout_seconds: In seconds: <0 → ∞, 0 → 120s
        :type timeout_seconds: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(bytearray, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'body',
            'query_name',
            'timeout_seconds'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_by_query_excel" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('query_name') is not None:  # noqa: E501
            _query_params.append(('queryName', _params['query_name']))

        if _params.get('timeout_seconds') is not None:  # noqa: E501
            _query_params.append(('timeoutSeconds', _params['timeout_seconds']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['body'] is not None:
            _body_params = _params['body']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['text/plain']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "bytearray",
            '400': "LusidProblemDetails",
        }

        return self.api_client.call_api(
            '/api/Sql/excel', 'PUT',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @overload
    async def put_by_query_json(self, body : Annotated[StrictStr, Field(..., description="LuminesceSql to Execute (may be multi-line)")], query_name : Annotated[Optional[StrictStr], Field(description="Name to apply to the query in logs and `Sys.Logs.HcQueryStart`")] = None, timeout_seconds : Annotated[Optional[StrictInt], Field(description="In seconds: <0 → ∞, 0 → 120s")] = None, json_proper : Annotated[Optional[StrictBool], Field(description="Should this be text/json (not json-encoded-as-a-string)")] = None, **kwargs) -> str:  # noqa: E501
        ...

    @overload
    def put_by_query_json(self, body : Annotated[StrictStr, Field(..., description="LuminesceSql to Execute (may be multi-line)")], query_name : Annotated[Optional[StrictStr], Field(description="Name to apply to the query in logs and `Sys.Logs.HcQueryStart`")] = None, timeout_seconds : Annotated[Optional[StrictInt], Field(description="In seconds: <0 → ∞, 0 → 120s")] = None, json_proper : Annotated[Optional[StrictBool], Field(description="Should this be text/json (not json-encoded-as-a-string)")] = None, async_req: Optional[bool]=True, **kwargs) -> str:  # noqa: E501
        ...

    @validate_arguments
    def put_by_query_json(self, body : Annotated[StrictStr, Field(..., description="LuminesceSql to Execute (may be multi-line)")], query_name : Annotated[Optional[StrictStr], Field(description="Name to apply to the query in logs and `Sys.Logs.HcQueryStart`")] = None, timeout_seconds : Annotated[Optional[StrictInt], Field(description="In seconds: <0 → ∞, 0 → 120s")] = None, json_proper : Annotated[Optional[StrictBool], Field(description="Should this be text/json (not json-encoded-as-a-string)")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[str, Awaitable[str]]:  # noqa: E501
        """PutByQueryJson: Executes Sql, returned in JSON format, where the sql is the post-body url.  # noqa: E501

         For more complex LuminesceSql a PUT will allow for longer Sql. e.g.: ```sql @@cutoff = select #2020-02-01#; @issues = select Id, SortId, Summary, Created, Updated from Dev.Jira.Issue where Project='HC' and Created < @@cutoff and Updated > @@cutoff;  select i.Id, i.SortId, i.Summary, LinkText, LinkedIssueId, LinkedIssueSortId, LinkedIssueSummary from @issues i inner join Dev.Jira.Issue.Link li     on i.Id = li.IssueId ```  The following error codes are to be anticipated with standard Problem Detail reports: - 400 BadRequest - something failed with the execution or parsing of your query - 401 Unauthorized   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.put_by_query_json(body, query_name, timeout_seconds, json_proper, async_req=True)
        >>> result = thread.get()

        :param body: LuminesceSql to Execute (may be multi-line) (required)
        :type body: str
        :param query_name: Name to apply to the query in logs and `Sys.Logs.HcQueryStart`
        :type query_name: str
        :param timeout_seconds: In seconds: <0 → ∞, 0 → 120s
        :type timeout_seconds: int
        :param json_proper: Should this be text/json (not json-encoded-as-a-string)
        :type json_proper: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: str
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the put_by_query_json_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.put_by_query_json_with_http_info(body, query_name, timeout_seconds, json_proper, **kwargs)  # noqa: E501

    @validate_arguments
    def put_by_query_json_with_http_info(self, body : Annotated[StrictStr, Field(..., description="LuminesceSql to Execute (may be multi-line)")], query_name : Annotated[Optional[StrictStr], Field(description="Name to apply to the query in logs and `Sys.Logs.HcQueryStart`")] = None, timeout_seconds : Annotated[Optional[StrictInt], Field(description="In seconds: <0 → ∞, 0 → 120s")] = None, json_proper : Annotated[Optional[StrictBool], Field(description="Should this be text/json (not json-encoded-as-a-string)")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """PutByQueryJson: Executes Sql, returned in JSON format, where the sql is the post-body url.  # noqa: E501

         For more complex LuminesceSql a PUT will allow for longer Sql. e.g.: ```sql @@cutoff = select #2020-02-01#; @issues = select Id, SortId, Summary, Created, Updated from Dev.Jira.Issue where Project='HC' and Created < @@cutoff and Updated > @@cutoff;  select i.Id, i.SortId, i.Summary, LinkText, LinkedIssueId, LinkedIssueSortId, LinkedIssueSummary from @issues i inner join Dev.Jira.Issue.Link li     on i.Id = li.IssueId ```  The following error codes are to be anticipated with standard Problem Detail reports: - 400 BadRequest - something failed with the execution or parsing of your query - 401 Unauthorized   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.put_by_query_json_with_http_info(body, query_name, timeout_seconds, json_proper, async_req=True)
        >>> result = thread.get()

        :param body: LuminesceSql to Execute (may be multi-line) (required)
        :type body: str
        :param query_name: Name to apply to the query in logs and `Sys.Logs.HcQueryStart`
        :type query_name: str
        :param timeout_seconds: In seconds: <0 → ∞, 0 → 120s
        :type timeout_seconds: int
        :param json_proper: Should this be text/json (not json-encoded-as-a-string)
        :type json_proper: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(str, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'body',
            'query_name',
            'timeout_seconds',
            'json_proper'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_by_query_json" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('query_name') is not None:  # noqa: E501
            _query_params.append(('queryName', _params['query_name']))

        if _params.get('timeout_seconds') is not None:  # noqa: E501
            _query_params.append(('timeoutSeconds', _params['timeout_seconds']))

        if _params.get('json_proper') is not None:  # noqa: E501
            _query_params.append(('jsonProper', _params['json_proper']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['body'] is not None:
            _body_params = _params['body']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['text/plain']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "str",
            '400': "LusidProblemDetails",
        }

        return self.api_client.call_api(
            '/api/Sql/json', 'PUT',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @overload
    async def put_by_query_parquet(self, body : Annotated[StrictStr, Field(..., description="LuminesceSql to Execute (may be multi-line)")], query_name : Annotated[Optional[StrictStr], Field(description="Name to apply to the query in logs and `Sys.Logs.HcQueryStart`")] = None, timeout_seconds : Annotated[Optional[StrictInt], Field(description="In seconds: <0 → ∞, 0 → 120s")] = None, **kwargs) -> bytearray:  # noqa: E501
        ...

    @overload
    def put_by_query_parquet(self, body : Annotated[StrictStr, Field(..., description="LuminesceSql to Execute (may be multi-line)")], query_name : Annotated[Optional[StrictStr], Field(description="Name to apply to the query in logs and `Sys.Logs.HcQueryStart`")] = None, timeout_seconds : Annotated[Optional[StrictInt], Field(description="In seconds: <0 → ∞, 0 → 120s")] = None, async_req: Optional[bool]=True, **kwargs) -> bytearray:  # noqa: E501
        ...

    @validate_arguments
    def put_by_query_parquet(self, body : Annotated[StrictStr, Field(..., description="LuminesceSql to Execute (may be multi-line)")], query_name : Annotated[Optional[StrictStr], Field(description="Name to apply to the query in logs and `Sys.Logs.HcQueryStart`")] = None, timeout_seconds : Annotated[Optional[StrictInt], Field(description="In seconds: <0 → ∞, 0 → 120s")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[bytearray, Awaitable[bytearray]]:  # noqa: E501
        """PutByQueryParquet: Executes Sql, returned in Parquet format, where the sql is the post-body url.  # noqa: E501

         For more complex LuminesceSql a PUT will allow for longer Sql. e.g.: ```sql @@cutoff = select #2020-02-01#; @issues = select Id, SortId, Summary, Created, Updated from Dev.Jira.Issue where Project='HC' and Created < @@cutoff and Updated > @@cutoff;  select i.Id, i.SortId, i.Summary, LinkText, LinkedIssueId, LinkedIssueSortId, LinkedIssueSummary from @issues i inner join Dev.Jira.Issue.Link li     on i.Id = li.IssueId ```  The following error codes are to be anticipated with standard Problem Detail reports: - 400 BadRequest - something failed with the execution or parsing of your query - 401 Unauthorized   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.put_by_query_parquet(body, query_name, timeout_seconds, async_req=True)
        >>> result = thread.get()

        :param body: LuminesceSql to Execute (may be multi-line) (required)
        :type body: str
        :param query_name: Name to apply to the query in logs and `Sys.Logs.HcQueryStart`
        :type query_name: str
        :param timeout_seconds: In seconds: <0 → ∞, 0 → 120s
        :type timeout_seconds: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: bytearray
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the put_by_query_parquet_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.put_by_query_parquet_with_http_info(body, query_name, timeout_seconds, **kwargs)  # noqa: E501

    @validate_arguments
    def put_by_query_parquet_with_http_info(self, body : Annotated[StrictStr, Field(..., description="LuminesceSql to Execute (may be multi-line)")], query_name : Annotated[Optional[StrictStr], Field(description="Name to apply to the query in logs and `Sys.Logs.HcQueryStart`")] = None, timeout_seconds : Annotated[Optional[StrictInt], Field(description="In seconds: <0 → ∞, 0 → 120s")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """PutByQueryParquet: Executes Sql, returned in Parquet format, where the sql is the post-body url.  # noqa: E501

         For more complex LuminesceSql a PUT will allow for longer Sql. e.g.: ```sql @@cutoff = select #2020-02-01#; @issues = select Id, SortId, Summary, Created, Updated from Dev.Jira.Issue where Project='HC' and Created < @@cutoff and Updated > @@cutoff;  select i.Id, i.SortId, i.Summary, LinkText, LinkedIssueId, LinkedIssueSortId, LinkedIssueSummary from @issues i inner join Dev.Jira.Issue.Link li     on i.Id = li.IssueId ```  The following error codes are to be anticipated with standard Problem Detail reports: - 400 BadRequest - something failed with the execution or parsing of your query - 401 Unauthorized   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.put_by_query_parquet_with_http_info(body, query_name, timeout_seconds, async_req=True)
        >>> result = thread.get()

        :param body: LuminesceSql to Execute (may be multi-line) (required)
        :type body: str
        :param query_name: Name to apply to the query in logs and `Sys.Logs.HcQueryStart`
        :type query_name: str
        :param timeout_seconds: In seconds: <0 → ∞, 0 → 120s
        :type timeout_seconds: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(bytearray, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'body',
            'query_name',
            'timeout_seconds'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_by_query_parquet" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('query_name') is not None:  # noqa: E501
            _query_params.append(('queryName', _params['query_name']))

        if _params.get('timeout_seconds') is not None:  # noqa: E501
            _query_params.append(('timeoutSeconds', _params['timeout_seconds']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['body'] is not None:
            _body_params = _params['body']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['text/plain']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "bytearray",
            '400': "LusidProblemDetails",
        }

        return self.api_client.call_api(
            '/api/Sql/parquet', 'PUT',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @overload
    async def put_by_query_pipe(self, body : Annotated[StrictStr, Field(..., description="LuminesceSql to Execute (may be multi-line)")], query_name : Annotated[Optional[StrictStr], Field(description="Name to apply to the query in logs and `Sys.Logs.HcQueryStart`")] = None, download : Annotated[Optional[StrictBool], Field(description="Makes this a file-download request (as opposed to returning the data in the response-body)")] = None, timeout_seconds : Annotated[Optional[StrictInt], Field(description="In seconds: <0 → ∞, 0 → 120s")] = None, **kwargs) -> str:  # noqa: E501
        ...

    @overload
    def put_by_query_pipe(self, body : Annotated[StrictStr, Field(..., description="LuminesceSql to Execute (may be multi-line)")], query_name : Annotated[Optional[StrictStr], Field(description="Name to apply to the query in logs and `Sys.Logs.HcQueryStart`")] = None, download : Annotated[Optional[StrictBool], Field(description="Makes this a file-download request (as opposed to returning the data in the response-body)")] = None, timeout_seconds : Annotated[Optional[StrictInt], Field(description="In seconds: <0 → ∞, 0 → 120s")] = None, async_req: Optional[bool]=True, **kwargs) -> str:  # noqa: E501
        ...

    @validate_arguments
    def put_by_query_pipe(self, body : Annotated[StrictStr, Field(..., description="LuminesceSql to Execute (may be multi-line)")], query_name : Annotated[Optional[StrictStr], Field(description="Name to apply to the query in logs and `Sys.Logs.HcQueryStart`")] = None, download : Annotated[Optional[StrictBool], Field(description="Makes this a file-download request (as opposed to returning the data in the response-body)")] = None, timeout_seconds : Annotated[Optional[StrictInt], Field(description="In seconds: <0 → ∞, 0 → 120s")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[str, Awaitable[str]]:  # noqa: E501
        """PutByQueryPipe: Executes Sql, returned in pipe-delimited format, where the sql is the post-body url.  # noqa: E501

         For more complex LuminesceSql a PUT will allow for longer Sql. e.g.: ```sql @@cutoff = select #2020-02-01#; @issues = select Id, SortId, Summary, Created, Updated from Dev.Jira.Issue where Project='HC' and Created < @@cutoff and Updated > @@cutoff;  select i.Id, i.SortId, i.Summary, LinkText, LinkedIssueId, LinkedIssueSortId, LinkedIssueSummary from @issues i inner join Dev.Jira.Issue.Link li     on i.Id = li.IssueId ```  The following error codes are to be anticipated with standard Problem Detail reports: - 400 BadRequest - something failed with the execution or parsing of your query - 401 Unauthorized   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.put_by_query_pipe(body, query_name, download, timeout_seconds, async_req=True)
        >>> result = thread.get()

        :param body: LuminesceSql to Execute (may be multi-line) (required)
        :type body: str
        :param query_name: Name to apply to the query in logs and `Sys.Logs.HcQueryStart`
        :type query_name: str
        :param download: Makes this a file-download request (as opposed to returning the data in the response-body)
        :type download: bool
        :param timeout_seconds: In seconds: <0 → ∞, 0 → 120s
        :type timeout_seconds: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: str
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the put_by_query_pipe_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.put_by_query_pipe_with_http_info(body, query_name, download, timeout_seconds, **kwargs)  # noqa: E501

    @validate_arguments
    def put_by_query_pipe_with_http_info(self, body : Annotated[StrictStr, Field(..., description="LuminesceSql to Execute (may be multi-line)")], query_name : Annotated[Optional[StrictStr], Field(description="Name to apply to the query in logs and `Sys.Logs.HcQueryStart`")] = None, download : Annotated[Optional[StrictBool], Field(description="Makes this a file-download request (as opposed to returning the data in the response-body)")] = None, timeout_seconds : Annotated[Optional[StrictInt], Field(description="In seconds: <0 → ∞, 0 → 120s")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """PutByQueryPipe: Executes Sql, returned in pipe-delimited format, where the sql is the post-body url.  # noqa: E501

         For more complex LuminesceSql a PUT will allow for longer Sql. e.g.: ```sql @@cutoff = select #2020-02-01#; @issues = select Id, SortId, Summary, Created, Updated from Dev.Jira.Issue where Project='HC' and Created < @@cutoff and Updated > @@cutoff;  select i.Id, i.SortId, i.Summary, LinkText, LinkedIssueId, LinkedIssueSortId, LinkedIssueSummary from @issues i inner join Dev.Jira.Issue.Link li     on i.Id = li.IssueId ```  The following error codes are to be anticipated with standard Problem Detail reports: - 400 BadRequest - something failed with the execution or parsing of your query - 401 Unauthorized   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.put_by_query_pipe_with_http_info(body, query_name, download, timeout_seconds, async_req=True)
        >>> result = thread.get()

        :param body: LuminesceSql to Execute (may be multi-line) (required)
        :type body: str
        :param query_name: Name to apply to the query in logs and `Sys.Logs.HcQueryStart`
        :type query_name: str
        :param download: Makes this a file-download request (as opposed to returning the data in the response-body)
        :type download: bool
        :param timeout_seconds: In seconds: <0 → ∞, 0 → 120s
        :type timeout_seconds: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(str, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'body',
            'query_name',
            'download',
            'timeout_seconds'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_by_query_pipe" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('query_name') is not None:  # noqa: E501
            _query_params.append(('queryName', _params['query_name']))

        if _params.get('download') is not None:  # noqa: E501
            _query_params.append(('download', _params['download']))

        if _params.get('timeout_seconds') is not None:  # noqa: E501
            _query_params.append(('timeoutSeconds', _params['timeout_seconds']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['body'] is not None:
            _body_params = _params['body']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['text/plain']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "str",
            '400': "LusidProblemDetails",
        }

        return self.api_client.call_api(
            '/api/Sql/pipe', 'PUT',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @overload
    async def put_by_query_sqlite(self, body : Annotated[StrictStr, Field(..., description="LuminesceSql to Execute (may be multi-line)")], query_name : Annotated[Optional[StrictStr], Field(description="Name to apply to the query in logs and `Sys.Logs.HcQueryStart`")] = None, timeout_seconds : Annotated[Optional[StrictInt], Field(description="In seconds: <0 → ∞, 0 → 120s")] = None, **kwargs) -> bytearray:  # noqa: E501
        ...

    @overload
    def put_by_query_sqlite(self, body : Annotated[StrictStr, Field(..., description="LuminesceSql to Execute (may be multi-line)")], query_name : Annotated[Optional[StrictStr], Field(description="Name to apply to the query in logs and `Sys.Logs.HcQueryStart`")] = None, timeout_seconds : Annotated[Optional[StrictInt], Field(description="In seconds: <0 → ∞, 0 → 120s")] = None, async_req: Optional[bool]=True, **kwargs) -> bytearray:  # noqa: E501
        ...

    @validate_arguments
    def put_by_query_sqlite(self, body : Annotated[StrictStr, Field(..., description="LuminesceSql to Execute (may be multi-line)")], query_name : Annotated[Optional[StrictStr], Field(description="Name to apply to the query in logs and `Sys.Logs.HcQueryStart`")] = None, timeout_seconds : Annotated[Optional[StrictInt], Field(description="In seconds: <0 → ∞, 0 → 120s")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[bytearray, Awaitable[bytearray]]:  # noqa: E501
        """PutByQuerySqlite: Executes Sql, returned in SqLite DB (sqlite3) format (as a file to be downloaded), where the sql is the post-body url.  # noqa: E501

         For more complex LuminesceSql a PUT will allow for longer Sql. e.g.: ```sql @@cutoff = select #2020-02-01#; @issues = select Id, SortId, Summary, Created, Updated from Dev.Jira.Issue where Project='HC' and Created < @@cutoff and Updated > @@cutoff;  select i.Id, i.SortId, i.Summary, LinkText, LinkedIssueId, LinkedIssueSortId, LinkedIssueSummary from @issues i inner join Dev.Jira.Issue.Link li     on i.Id = li.IssueId ```  The following error codes are to be anticipated with standard Problem Detail reports: - 400 BadRequest - something failed with the execution or parsing of your query - 401 Unauthorized   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.put_by_query_sqlite(body, query_name, timeout_seconds, async_req=True)
        >>> result = thread.get()

        :param body: LuminesceSql to Execute (may be multi-line) (required)
        :type body: str
        :param query_name: Name to apply to the query in logs and `Sys.Logs.HcQueryStart`
        :type query_name: str
        :param timeout_seconds: In seconds: <0 → ∞, 0 → 120s
        :type timeout_seconds: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: bytearray
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the put_by_query_sqlite_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.put_by_query_sqlite_with_http_info(body, query_name, timeout_seconds, **kwargs)  # noqa: E501

    @validate_arguments
    def put_by_query_sqlite_with_http_info(self, body : Annotated[StrictStr, Field(..., description="LuminesceSql to Execute (may be multi-line)")], query_name : Annotated[Optional[StrictStr], Field(description="Name to apply to the query in logs and `Sys.Logs.HcQueryStart`")] = None, timeout_seconds : Annotated[Optional[StrictInt], Field(description="In seconds: <0 → ∞, 0 → 120s")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """PutByQuerySqlite: Executes Sql, returned in SqLite DB (sqlite3) format (as a file to be downloaded), where the sql is the post-body url.  # noqa: E501

         For more complex LuminesceSql a PUT will allow for longer Sql. e.g.: ```sql @@cutoff = select #2020-02-01#; @issues = select Id, SortId, Summary, Created, Updated from Dev.Jira.Issue where Project='HC' and Created < @@cutoff and Updated > @@cutoff;  select i.Id, i.SortId, i.Summary, LinkText, LinkedIssueId, LinkedIssueSortId, LinkedIssueSummary from @issues i inner join Dev.Jira.Issue.Link li     on i.Id = li.IssueId ```  The following error codes are to be anticipated with standard Problem Detail reports: - 400 BadRequest - something failed with the execution or parsing of your query - 401 Unauthorized   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.put_by_query_sqlite_with_http_info(body, query_name, timeout_seconds, async_req=True)
        >>> result = thread.get()

        :param body: LuminesceSql to Execute (may be multi-line) (required)
        :type body: str
        :param query_name: Name to apply to the query in logs and `Sys.Logs.HcQueryStart`
        :type query_name: str
        :param timeout_seconds: In seconds: <0 → ∞, 0 → 120s
        :type timeout_seconds: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(bytearray, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'body',
            'query_name',
            'timeout_seconds'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_by_query_sqlite" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('query_name') is not None:  # noqa: E501
            _query_params.append(('queryName', _params['query_name']))

        if _params.get('timeout_seconds') is not None:  # noqa: E501
            _query_params.append(('timeoutSeconds', _params['timeout_seconds']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['body'] is not None:
            _body_params = _params['body']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['text/plain']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "bytearray",
            '400': "LusidProblemDetails",
        }

        return self.api_client.call_api(
            '/api/Sql/sqlite', 'PUT',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @overload
    async def put_by_query_xml(self, body : Annotated[StrictStr, Field(..., description="LuminesceSql to Execute (may be multi-line)")], query_name : Annotated[Optional[StrictStr], Field(description="Name to apply to the query in logs and `Sys.Logs.HcQueryStart`")] = None, download : Annotated[Optional[StrictBool], Field(description="Makes this a file-download request (as opposed to returning the data in the response-body)")] = None, timeout_seconds : Annotated[Optional[StrictInt], Field(description="In seconds: <0 → ∞, 0 → 120s")] = None, **kwargs) -> str:  # noqa: E501
        ...

    @overload
    def put_by_query_xml(self, body : Annotated[StrictStr, Field(..., description="LuminesceSql to Execute (may be multi-line)")], query_name : Annotated[Optional[StrictStr], Field(description="Name to apply to the query in logs and `Sys.Logs.HcQueryStart`")] = None, download : Annotated[Optional[StrictBool], Field(description="Makes this a file-download request (as opposed to returning the data in the response-body)")] = None, timeout_seconds : Annotated[Optional[StrictInt], Field(description="In seconds: <0 → ∞, 0 → 120s")] = None, async_req: Optional[bool]=True, **kwargs) -> str:  # noqa: E501
        ...

    @validate_arguments
    def put_by_query_xml(self, body : Annotated[StrictStr, Field(..., description="LuminesceSql to Execute (may be multi-line)")], query_name : Annotated[Optional[StrictStr], Field(description="Name to apply to the query in logs and `Sys.Logs.HcQueryStart`")] = None, download : Annotated[Optional[StrictBool], Field(description="Makes this a file-download request (as opposed to returning the data in the response-body)")] = None, timeout_seconds : Annotated[Optional[StrictInt], Field(description="In seconds: <0 → ∞, 0 → 120s")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[str, Awaitable[str]]:  # noqa: E501
        """PutByQueryXml: Executes Sql, returned in Xml format, where the sql is the post-body url.  # noqa: E501

         For more complex LuminesceSql a PUT will allow for longer Sql. e.g.: ```sql @@cutoff = select #2020-02-01#; @issues = select Id, SortId, Summary, Created, Updated from Dev.Jira.Issue where Project='HC' and Created < @@cutoff and Updated > @@cutoff;  select i.Id, i.SortId, i.Summary, LinkText, LinkedIssueId, LinkedIssueSortId, LinkedIssueSummary from @issues i inner join Dev.Jira.Issue.Link li     on i.Id = li.IssueId ```  The following error codes are to be anticipated with standard Problem Detail reports: - 400 BadRequest - something failed with the execution or parsing of your query - 401 Unauthorized   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.put_by_query_xml(body, query_name, download, timeout_seconds, async_req=True)
        >>> result = thread.get()

        :param body: LuminesceSql to Execute (may be multi-line) (required)
        :type body: str
        :param query_name: Name to apply to the query in logs and `Sys.Logs.HcQueryStart`
        :type query_name: str
        :param download: Makes this a file-download request (as opposed to returning the data in the response-body)
        :type download: bool
        :param timeout_seconds: In seconds: <0 → ∞, 0 → 120s
        :type timeout_seconds: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: str
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the put_by_query_xml_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.put_by_query_xml_with_http_info(body, query_name, download, timeout_seconds, **kwargs)  # noqa: E501

    @validate_arguments
    def put_by_query_xml_with_http_info(self, body : Annotated[StrictStr, Field(..., description="LuminesceSql to Execute (may be multi-line)")], query_name : Annotated[Optional[StrictStr], Field(description="Name to apply to the query in logs and `Sys.Logs.HcQueryStart`")] = None, download : Annotated[Optional[StrictBool], Field(description="Makes this a file-download request (as opposed to returning the data in the response-body)")] = None, timeout_seconds : Annotated[Optional[StrictInt], Field(description="In seconds: <0 → ∞, 0 → 120s")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """PutByQueryXml: Executes Sql, returned in Xml format, where the sql is the post-body url.  # noqa: E501

         For more complex LuminesceSql a PUT will allow for longer Sql. e.g.: ```sql @@cutoff = select #2020-02-01#; @issues = select Id, SortId, Summary, Created, Updated from Dev.Jira.Issue where Project='HC' and Created < @@cutoff and Updated > @@cutoff;  select i.Id, i.SortId, i.Summary, LinkText, LinkedIssueId, LinkedIssueSortId, LinkedIssueSummary from @issues i inner join Dev.Jira.Issue.Link li     on i.Id = li.IssueId ```  The following error codes are to be anticipated with standard Problem Detail reports: - 400 BadRequest - something failed with the execution or parsing of your query - 401 Unauthorized   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.put_by_query_xml_with_http_info(body, query_name, download, timeout_seconds, async_req=True)
        >>> result = thread.get()

        :param body: LuminesceSql to Execute (may be multi-line) (required)
        :type body: str
        :param query_name: Name to apply to the query in logs and `Sys.Logs.HcQueryStart`
        :type query_name: str
        :param download: Makes this a file-download request (as opposed to returning the data in the response-body)
        :type download: bool
        :param timeout_seconds: In seconds: <0 → ∞, 0 → 120s
        :type timeout_seconds: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(str, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'body',
            'query_name',
            'download',
            'timeout_seconds'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_by_query_xml" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('query_name') is not None:  # noqa: E501
            _query_params.append(('queryName', _params['query_name']))

        if _params.get('download') is not None:  # noqa: E501
            _query_params.append(('download', _params['download']))

        if _params.get('timeout_seconds') is not None:  # noqa: E501
            _query_params.append(('timeoutSeconds', _params['timeout_seconds']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['body'] is not None:
            _body_params = _params['body']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['text/plain']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "str",
            '400': "LusidProblemDetails",
        }

        return self.api_client.call_api(
            '/api/Sql/xml', 'PUT',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @overload
    async def put_file_read_design_to_sql(self, file_reader_builder_def : Annotated[FileReaderBuilderDef, Field(..., description="Structured file read design object to generate SQL from")], execute_query : Annotated[Optional[StrictBool], Field(description="Should the generated query be executed to build preview data or determine errors.>")] = None, **kwargs) -> str:  # noqa: E501
        ...

    @overload
    def put_file_read_design_to_sql(self, file_reader_builder_def : Annotated[FileReaderBuilderDef, Field(..., description="Structured file read design object to generate SQL from")], execute_query : Annotated[Optional[StrictBool], Field(description="Should the generated query be executed to build preview data or determine errors.>")] = None, async_req: Optional[bool]=True, **kwargs) -> str:  # noqa: E501
        ...

    @validate_arguments
    def put_file_read_design_to_sql(self, file_reader_builder_def : Annotated[FileReaderBuilderDef, Field(..., description="Structured file read design object to generate SQL from")], execute_query : Annotated[Optional[StrictBool], Field(description="Should the generated query be executed to build preview data or determine errors.>")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[str, Awaitable[str]]:  # noqa: E501
        """[EXPERIMENTAL] PutFileReadDesignToSql: Generates file read SQL from a structured query design  # noqa: E501

        SQL Designer specification to generate SQL from  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.put_file_read_design_to_sql(file_reader_builder_def, execute_query, async_req=True)
        >>> result = thread.get()

        :param file_reader_builder_def: Structured file read design object to generate SQL from (required)
        :type file_reader_builder_def: FileReaderBuilderDef
        :param execute_query: Should the generated query be executed to build preview data or determine errors.>
        :type execute_query: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: str
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the put_file_read_design_to_sql_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.put_file_read_design_to_sql_with_http_info(file_reader_builder_def, execute_query, **kwargs)  # noqa: E501

    @validate_arguments
    def put_file_read_design_to_sql_with_http_info(self, file_reader_builder_def : Annotated[FileReaderBuilderDef, Field(..., description="Structured file read design object to generate SQL from")], execute_query : Annotated[Optional[StrictBool], Field(description="Should the generated query be executed to build preview data or determine errors.>")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """[EXPERIMENTAL] PutFileReadDesignToSql: Generates file read SQL from a structured query design  # noqa: E501

        SQL Designer specification to generate SQL from  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.put_file_read_design_to_sql_with_http_info(file_reader_builder_def, execute_query, async_req=True)
        >>> result = thread.get()

        :param file_reader_builder_def: Structured file read design object to generate SQL from (required)
        :type file_reader_builder_def: FileReaderBuilderDef
        :param execute_query: Should the generated query be executed to build preview data or determine errors.>
        :type execute_query: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(str, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'file_reader_builder_def',
            'execute_query'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_file_read_design_to_sql" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('execute_query') is not None:  # noqa: E501
            _query_params.append(('executeQuery', _params['execute_query']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['file_reader_builder_def'] is not None:
            _body_params = _params['file_reader_builder_def']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "str",
            '400': "LusidProblemDetails",
        }

        return self.api_client.call_api(
            '/api/Sql/fromfilereaddesign', 'PUT',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @overload
    async def put_query_design_to_sql(self, query_design : Annotated[QueryDesign, Field(..., description="Structured Query design object to generate SQL from")], **kwargs) -> str:  # noqa: E501
        ...

    @overload
    def put_query_design_to_sql(self, query_design : Annotated[QueryDesign, Field(..., description="Structured Query design object to generate SQL from")], async_req: Optional[bool]=True, **kwargs) -> str:  # noqa: E501
        ...

    @validate_arguments
    def put_query_design_to_sql(self, query_design : Annotated[QueryDesign, Field(..., description="Structured Query design object to generate SQL from")], async_req: Optional[bool]=None, **kwargs) -> Union[str, Awaitable[str]]:  # noqa: E501
        """[EXPERIMENTAL] PutQueryDesignToSql: Generates SQL from a structured query design  # noqa: E501

        SQL Designer specification to generate SQL from  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.put_query_design_to_sql(query_design, async_req=True)
        >>> result = thread.get()

        :param query_design: Structured Query design object to generate SQL from (required)
        :type query_design: QueryDesign
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: str
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the put_query_design_to_sql_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.put_query_design_to_sql_with_http_info(query_design, **kwargs)  # noqa: E501

    @validate_arguments
    def put_query_design_to_sql_with_http_info(self, query_design : Annotated[QueryDesign, Field(..., description="Structured Query design object to generate SQL from")], **kwargs) -> ApiResponse:  # noqa: E501
        """[EXPERIMENTAL] PutQueryDesignToSql: Generates SQL from a structured query design  # noqa: E501

        SQL Designer specification to generate SQL from  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.put_query_design_to_sql_with_http_info(query_design, async_req=True)
        >>> result = thread.get()

        :param query_design: Structured Query design object to generate SQL from (required)
        :type query_design: QueryDesign
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(str, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'query_design'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_query_design_to_sql" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['query_design'] is not None:
            _body_params = _params['query_design']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "str",
            '400': "LusidProblemDetails",
        }

        return self.api_client.call_api(
            '/api/Sql/fromdesign', 'PUT',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @overload
    async def put_query_to_format(self, body : Annotated[StrictStr, Field(..., description="LuminesceSql to Pretty-Print. Even if it doesn't parse an attempt will be made to format it")], trailing_commas : Annotated[Optional[StrictBool], Field(description="Should commas be after an expression (as opposed to before)")] = None, uppercase_keywords : Annotated[Optional[StrictBool], Field(description="Should key words be capitalized")] = None, break_join_on_sections : Annotated[Optional[StrictBool], Field(description="Should clauses on joins be given line breaks?")] = None, space_after_expanded_comma : Annotated[Optional[StrictBool], Field(description="Should comma-lists have spaces after the commas?")] = None, keyword_standardization : Annotated[Optional[StrictBool], Field(description="Should the \"nicest\" key words be used? (e.g. JOIN -> INNER JOIN)")] = None, expand_comma_lists : Annotated[Optional[StrictBool], Field(description="Should comma-lists (e.g. select a,b,c) have line breaks added?")] = None, expand_in_lists : Annotated[Optional[StrictBool], Field(description="Should IN-lists have line breaks added?")] = None, expand_boolean_expressions : Annotated[Optional[StrictBool], Field(description="Should boolean expressions have line breaks added?")] = None, expand_between_conditions : Annotated[Optional[StrictBool], Field(description="Should between conditions have line breaks added?")] = None, expand_case_statements : Annotated[Optional[StrictBool], Field(description="Should case-statements have line breaks added?")] = None, max_line_width : Annotated[Optional[StrictInt], Field(description="Maximum number of characters to allow on one line (if possible)")] = None, space_before_trailing_single_line_comments : Annotated[Optional[StrictBool], Field(description="Should the be a space before trailing single line comments?")] = None, multiline_comment_extra_line_break : Annotated[Optional[StrictBool], Field(description="Should an additional line break be added after multi-line comments?")] = None, **kwargs) -> str:  # noqa: E501
        ...

    @overload
    def put_query_to_format(self, body : Annotated[StrictStr, Field(..., description="LuminesceSql to Pretty-Print. Even if it doesn't parse an attempt will be made to format it")], trailing_commas : Annotated[Optional[StrictBool], Field(description="Should commas be after an expression (as opposed to before)")] = None, uppercase_keywords : Annotated[Optional[StrictBool], Field(description="Should key words be capitalized")] = None, break_join_on_sections : Annotated[Optional[StrictBool], Field(description="Should clauses on joins be given line breaks?")] = None, space_after_expanded_comma : Annotated[Optional[StrictBool], Field(description="Should comma-lists have spaces after the commas?")] = None, keyword_standardization : Annotated[Optional[StrictBool], Field(description="Should the \"nicest\" key words be used? (e.g. JOIN -> INNER JOIN)")] = None, expand_comma_lists : Annotated[Optional[StrictBool], Field(description="Should comma-lists (e.g. select a,b,c) have line breaks added?")] = None, expand_in_lists : Annotated[Optional[StrictBool], Field(description="Should IN-lists have line breaks added?")] = None, expand_boolean_expressions : Annotated[Optional[StrictBool], Field(description="Should boolean expressions have line breaks added?")] = None, expand_between_conditions : Annotated[Optional[StrictBool], Field(description="Should between conditions have line breaks added?")] = None, expand_case_statements : Annotated[Optional[StrictBool], Field(description="Should case-statements have line breaks added?")] = None, max_line_width : Annotated[Optional[StrictInt], Field(description="Maximum number of characters to allow on one line (if possible)")] = None, space_before_trailing_single_line_comments : Annotated[Optional[StrictBool], Field(description="Should the be a space before trailing single line comments?")] = None, multiline_comment_extra_line_break : Annotated[Optional[StrictBool], Field(description="Should an additional line break be added after multi-line comments?")] = None, async_req: Optional[bool]=True, **kwargs) -> str:  # noqa: E501
        ...

    @validate_arguments
    def put_query_to_format(self, body : Annotated[StrictStr, Field(..., description="LuminesceSql to Pretty-Print. Even if it doesn't parse an attempt will be made to format it")], trailing_commas : Annotated[Optional[StrictBool], Field(description="Should commas be after an expression (as opposed to before)")] = None, uppercase_keywords : Annotated[Optional[StrictBool], Field(description="Should key words be capitalized")] = None, break_join_on_sections : Annotated[Optional[StrictBool], Field(description="Should clauses on joins be given line breaks?")] = None, space_after_expanded_comma : Annotated[Optional[StrictBool], Field(description="Should comma-lists have spaces after the commas?")] = None, keyword_standardization : Annotated[Optional[StrictBool], Field(description="Should the \"nicest\" key words be used? (e.g. JOIN -> INNER JOIN)")] = None, expand_comma_lists : Annotated[Optional[StrictBool], Field(description="Should comma-lists (e.g. select a,b,c) have line breaks added?")] = None, expand_in_lists : Annotated[Optional[StrictBool], Field(description="Should IN-lists have line breaks added?")] = None, expand_boolean_expressions : Annotated[Optional[StrictBool], Field(description="Should boolean expressions have line breaks added?")] = None, expand_between_conditions : Annotated[Optional[StrictBool], Field(description="Should between conditions have line breaks added?")] = None, expand_case_statements : Annotated[Optional[StrictBool], Field(description="Should case-statements have line breaks added?")] = None, max_line_width : Annotated[Optional[StrictInt], Field(description="Maximum number of characters to allow on one line (if possible)")] = None, space_before_trailing_single_line_comments : Annotated[Optional[StrictBool], Field(description="Should the be a space before trailing single line comments?")] = None, multiline_comment_extra_line_break : Annotated[Optional[StrictBool], Field(description="Should an additional line break be added after multi-line comments?")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[str, Awaitable[str]]:  # noqa: E501
        """PutQueryToFormat: Executes Sql, returned in JSON format, where the sql is the post-body url.  # noqa: E501

         This formats SQL (given a set of options as to how to do so). It takes some SQL (or a fragment thereof, it need not fully parse as yet and certainly need not execute correctly) and returns the reformatted version. e.g. ```sql select x,y,z from a inner join b on a.x=b.x where x>y or y!=z ``` becomes ```sql select x, y, z from a inner join b    on a.x = b.x where x > y    or y != z ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.put_query_to_format(body, trailing_commas, uppercase_keywords, break_join_on_sections, space_after_expanded_comma, keyword_standardization, expand_comma_lists, expand_in_lists, expand_boolean_expressions, expand_between_conditions, expand_case_statements, max_line_width, space_before_trailing_single_line_comments, multiline_comment_extra_line_break, async_req=True)
        >>> result = thread.get()

        :param body: LuminesceSql to Pretty-Print. Even if it doesn't parse an attempt will be made to format it (required)
        :type body: str
        :param trailing_commas: Should commas be after an expression (as opposed to before)
        :type trailing_commas: bool
        :param uppercase_keywords: Should key words be capitalized
        :type uppercase_keywords: bool
        :param break_join_on_sections: Should clauses on joins be given line breaks?
        :type break_join_on_sections: bool
        :param space_after_expanded_comma: Should comma-lists have spaces after the commas?
        :type space_after_expanded_comma: bool
        :param keyword_standardization: Should the \"nicest\" key words be used? (e.g. JOIN -> INNER JOIN)
        :type keyword_standardization: bool
        :param expand_comma_lists: Should comma-lists (e.g. select a,b,c) have line breaks added?
        :type expand_comma_lists: bool
        :param expand_in_lists: Should IN-lists have line breaks added?
        :type expand_in_lists: bool
        :param expand_boolean_expressions: Should boolean expressions have line breaks added?
        :type expand_boolean_expressions: bool
        :param expand_between_conditions: Should between conditions have line breaks added?
        :type expand_between_conditions: bool
        :param expand_case_statements: Should case-statements have line breaks added?
        :type expand_case_statements: bool
        :param max_line_width: Maximum number of characters to allow on one line (if possible)
        :type max_line_width: int
        :param space_before_trailing_single_line_comments: Should the be a space before trailing single line comments?
        :type space_before_trailing_single_line_comments: bool
        :param multiline_comment_extra_line_break: Should an additional line break be added after multi-line comments?
        :type multiline_comment_extra_line_break: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: str
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the put_query_to_format_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.put_query_to_format_with_http_info(body, trailing_commas, uppercase_keywords, break_join_on_sections, space_after_expanded_comma, keyword_standardization, expand_comma_lists, expand_in_lists, expand_boolean_expressions, expand_between_conditions, expand_case_statements, max_line_width, space_before_trailing_single_line_comments, multiline_comment_extra_line_break, **kwargs)  # noqa: E501

    @validate_arguments
    def put_query_to_format_with_http_info(self, body : Annotated[StrictStr, Field(..., description="LuminesceSql to Pretty-Print. Even if it doesn't parse an attempt will be made to format it")], trailing_commas : Annotated[Optional[StrictBool], Field(description="Should commas be after an expression (as opposed to before)")] = None, uppercase_keywords : Annotated[Optional[StrictBool], Field(description="Should key words be capitalized")] = None, break_join_on_sections : Annotated[Optional[StrictBool], Field(description="Should clauses on joins be given line breaks?")] = None, space_after_expanded_comma : Annotated[Optional[StrictBool], Field(description="Should comma-lists have spaces after the commas?")] = None, keyword_standardization : Annotated[Optional[StrictBool], Field(description="Should the \"nicest\" key words be used? (e.g. JOIN -> INNER JOIN)")] = None, expand_comma_lists : Annotated[Optional[StrictBool], Field(description="Should comma-lists (e.g. select a,b,c) have line breaks added?")] = None, expand_in_lists : Annotated[Optional[StrictBool], Field(description="Should IN-lists have line breaks added?")] = None, expand_boolean_expressions : Annotated[Optional[StrictBool], Field(description="Should boolean expressions have line breaks added?")] = None, expand_between_conditions : Annotated[Optional[StrictBool], Field(description="Should between conditions have line breaks added?")] = None, expand_case_statements : Annotated[Optional[StrictBool], Field(description="Should case-statements have line breaks added?")] = None, max_line_width : Annotated[Optional[StrictInt], Field(description="Maximum number of characters to allow on one line (if possible)")] = None, space_before_trailing_single_line_comments : Annotated[Optional[StrictBool], Field(description="Should the be a space before trailing single line comments?")] = None, multiline_comment_extra_line_break : Annotated[Optional[StrictBool], Field(description="Should an additional line break be added after multi-line comments?")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """PutQueryToFormat: Executes Sql, returned in JSON format, where the sql is the post-body url.  # noqa: E501

         This formats SQL (given a set of options as to how to do so). It takes some SQL (or a fragment thereof, it need not fully parse as yet and certainly need not execute correctly) and returns the reformatted version. e.g. ```sql select x,y,z from a inner join b on a.x=b.x where x>y or y!=z ``` becomes ```sql select x, y, z from a inner join b    on a.x = b.x where x > y    or y != z ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.put_query_to_format_with_http_info(body, trailing_commas, uppercase_keywords, break_join_on_sections, space_after_expanded_comma, keyword_standardization, expand_comma_lists, expand_in_lists, expand_boolean_expressions, expand_between_conditions, expand_case_statements, max_line_width, space_before_trailing_single_line_comments, multiline_comment_extra_line_break, async_req=True)
        >>> result = thread.get()

        :param body: LuminesceSql to Pretty-Print. Even if it doesn't parse an attempt will be made to format it (required)
        :type body: str
        :param trailing_commas: Should commas be after an expression (as opposed to before)
        :type trailing_commas: bool
        :param uppercase_keywords: Should key words be capitalized
        :type uppercase_keywords: bool
        :param break_join_on_sections: Should clauses on joins be given line breaks?
        :type break_join_on_sections: bool
        :param space_after_expanded_comma: Should comma-lists have spaces after the commas?
        :type space_after_expanded_comma: bool
        :param keyword_standardization: Should the \"nicest\" key words be used? (e.g. JOIN -> INNER JOIN)
        :type keyword_standardization: bool
        :param expand_comma_lists: Should comma-lists (e.g. select a,b,c) have line breaks added?
        :type expand_comma_lists: bool
        :param expand_in_lists: Should IN-lists have line breaks added?
        :type expand_in_lists: bool
        :param expand_boolean_expressions: Should boolean expressions have line breaks added?
        :type expand_boolean_expressions: bool
        :param expand_between_conditions: Should between conditions have line breaks added?
        :type expand_between_conditions: bool
        :param expand_case_statements: Should case-statements have line breaks added?
        :type expand_case_statements: bool
        :param max_line_width: Maximum number of characters to allow on one line (if possible)
        :type max_line_width: int
        :param space_before_trailing_single_line_comments: Should the be a space before trailing single line comments?
        :type space_before_trailing_single_line_comments: bool
        :param multiline_comment_extra_line_break: Should an additional line break be added after multi-line comments?
        :type multiline_comment_extra_line_break: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(str, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'body',
            'trailing_commas',
            'uppercase_keywords',
            'break_join_on_sections',
            'space_after_expanded_comma',
            'keyword_standardization',
            'expand_comma_lists',
            'expand_in_lists',
            'expand_boolean_expressions',
            'expand_between_conditions',
            'expand_case_statements',
            'max_line_width',
            'space_before_trailing_single_line_comments',
            'multiline_comment_extra_line_break'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_query_to_format" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('trailing_commas') is not None:  # noqa: E501
            _query_params.append(('trailingCommas', _params['trailing_commas']))

        if _params.get('uppercase_keywords') is not None:  # noqa: E501
            _query_params.append(('uppercaseKeywords', _params['uppercase_keywords']))

        if _params.get('break_join_on_sections') is not None:  # noqa: E501
            _query_params.append(('breakJoinOnSections', _params['break_join_on_sections']))

        if _params.get('space_after_expanded_comma') is not None:  # noqa: E501
            _query_params.append(('spaceAfterExpandedComma', _params['space_after_expanded_comma']))

        if _params.get('keyword_standardization') is not None:  # noqa: E501
            _query_params.append(('keywordStandardization', _params['keyword_standardization']))

        if _params.get('expand_comma_lists') is not None:  # noqa: E501
            _query_params.append(('expandCommaLists', _params['expand_comma_lists']))

        if _params.get('expand_in_lists') is not None:  # noqa: E501
            _query_params.append(('expandInLists', _params['expand_in_lists']))

        if _params.get('expand_boolean_expressions') is not None:  # noqa: E501
            _query_params.append(('expandBooleanExpressions', _params['expand_boolean_expressions']))

        if _params.get('expand_between_conditions') is not None:  # noqa: E501
            _query_params.append(('expandBetweenConditions', _params['expand_between_conditions']))

        if _params.get('expand_case_statements') is not None:  # noqa: E501
            _query_params.append(('expandCaseStatements', _params['expand_case_statements']))

        if _params.get('max_line_width') is not None:  # noqa: E501
            _query_params.append(('maxLineWidth', _params['max_line_width']))

        if _params.get('space_before_trailing_single_line_comments') is not None:  # noqa: E501
            _query_params.append(('spaceBeforeTrailingSingleLineComments', _params['space_before_trailing_single_line_comments']))

        if _params.get('multiline_comment_extra_line_break') is not None:  # noqa: E501
            _query_params.append(('multilineCommentExtraLineBreak', _params['multiline_comment_extra_line_break']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['body'] is not None:
            _body_params = _params['body']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['text/plain']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "str",
            '400': "LusidProblemDetails",
        }

        return self.api_client.call_api(
            '/api/Sql/pretty', 'PUT',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @overload
    async def put_sql_to_file_read_design(self, determine_available_sources : Annotated[Optional[StrictBool], Field(description="Should the available sources be determined from `Sys.Registration`")] = None, body : Annotated[Optional[StrictStr], Field(description="SQL query to generate the file read design object from")] = None, **kwargs) -> str:  # noqa: E501
        ...

    @overload
    def put_sql_to_file_read_design(self, determine_available_sources : Annotated[Optional[StrictBool], Field(description="Should the available sources be determined from `Sys.Registration`")] = None, body : Annotated[Optional[StrictStr], Field(description="SQL query to generate the file read design object from")] = None, async_req: Optional[bool]=True, **kwargs) -> str:  # noqa: E501
        ...

    @validate_arguments
    def put_sql_to_file_read_design(self, determine_available_sources : Annotated[Optional[StrictBool], Field(description="Should the available sources be determined from `Sys.Registration`")] = None, body : Annotated[Optional[StrictStr], Field(description="SQL query to generate the file read design object from")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[str, Awaitable[str]]:  # noqa: E501
        """[EXPERIMENTAL] PutSqlToFileReadDesign: Generates a SQL-file-read-design object from SQL string, if possible.  # noqa: E501

        SQL to attempt to create a Design object from  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.put_sql_to_file_read_design(determine_available_sources, body, async_req=True)
        >>> result = thread.get()

        :param determine_available_sources: Should the available sources be determined from `Sys.Registration`
        :type determine_available_sources: bool
        :param body: SQL query to generate the file read design object from
        :type body: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: str
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the put_sql_to_file_read_design_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.put_sql_to_file_read_design_with_http_info(determine_available_sources, body, **kwargs)  # noqa: E501

    @validate_arguments
    def put_sql_to_file_read_design_with_http_info(self, determine_available_sources : Annotated[Optional[StrictBool], Field(description="Should the available sources be determined from `Sys.Registration`")] = None, body : Annotated[Optional[StrictStr], Field(description="SQL query to generate the file read design object from")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """[EXPERIMENTAL] PutSqlToFileReadDesign: Generates a SQL-file-read-design object from SQL string, if possible.  # noqa: E501

        SQL to attempt to create a Design object from  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.put_sql_to_file_read_design_with_http_info(determine_available_sources, body, async_req=True)
        >>> result = thread.get()

        :param determine_available_sources: Should the available sources be determined from `Sys.Registration`
        :type determine_available_sources: bool
        :param body: SQL query to generate the file read design object from
        :type body: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(str, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'determine_available_sources',
            'body'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_sql_to_file_read_design" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('determine_available_sources') is not None:  # noqa: E501
            _query_params.append(('determineAvailableSources', _params['determine_available_sources']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['body'] is not None:
            _body_params = _params['body']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['text/plain']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "str",
            '400': "LusidProblemDetails",
        }

        return self.api_client.call_api(
            '/api/Sql/tofilereaddesign', 'PUT',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @overload
    async def put_sql_to_query_design(self, body : Annotated[StrictStr, Field(..., description="SQL query to generate the design object from")], validate_with_metadata : Annotated[Optional[StrictBool], Field(description="Should the table be validated against the users' view of Sys.Field to fill in DataTypes, etc.?")] = None, **kwargs) -> str:  # noqa: E501
        ...

    @overload
    def put_sql_to_query_design(self, body : Annotated[StrictStr, Field(..., description="SQL query to generate the design object from")], validate_with_metadata : Annotated[Optional[StrictBool], Field(description="Should the table be validated against the users' view of Sys.Field to fill in DataTypes, etc.?")] = None, async_req: Optional[bool]=True, **kwargs) -> str:  # noqa: E501
        ...

    @validate_arguments
    def put_sql_to_query_design(self, body : Annotated[StrictStr, Field(..., description="SQL query to generate the design object from")], validate_with_metadata : Annotated[Optional[StrictBool], Field(description="Should the table be validated against the users' view of Sys.Field to fill in DataTypes, etc.?")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[str, Awaitable[str]]:  # noqa: E501
        """[EXPERIMENTAL] PutSqlToQueryDesign: Generates a SQL-design object from SQL string, if possible.  # noqa: E501

        SQL to attempt to create a Design object from  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.put_sql_to_query_design(body, validate_with_metadata, async_req=True)
        >>> result = thread.get()

        :param body: SQL query to generate the design object from (required)
        :type body: str
        :param validate_with_metadata: Should the table be validated against the users' view of Sys.Field to fill in DataTypes, etc.?
        :type validate_with_metadata: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: str
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the put_sql_to_query_design_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.put_sql_to_query_design_with_http_info(body, validate_with_metadata, **kwargs)  # noqa: E501

    @validate_arguments
    def put_sql_to_query_design_with_http_info(self, body : Annotated[StrictStr, Field(..., description="SQL query to generate the design object from")], validate_with_metadata : Annotated[Optional[StrictBool], Field(description="Should the table be validated against the users' view of Sys.Field to fill in DataTypes, etc.?")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """[EXPERIMENTAL] PutSqlToQueryDesign: Generates a SQL-design object from SQL string, if possible.  # noqa: E501

        SQL to attempt to create a Design object from  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.put_sql_to_query_design_with_http_info(body, validate_with_metadata, async_req=True)
        >>> result = thread.get()

        :param body: SQL query to generate the design object from (required)
        :type body: str
        :param validate_with_metadata: Should the table be validated against the users' view of Sys.Field to fill in DataTypes, etc.?
        :type validate_with_metadata: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(str, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'body',
            'validate_with_metadata'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_sql_to_query_design" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('validate_with_metadata') is not None:  # noqa: E501
            _query_params.append(('validateWithMetadata', _params['validate_with_metadata']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['body'] is not None:
            _body_params = _params['body']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['text/plain']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "str",
            '400': "LusidProblemDetails",
        }

        return self.api_client.call_api(
            '/api/Sql/todesign', 'PUT',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @overload
    async def put_sql_to_view_design(self, body : Annotated[StrictStr, Field(..., description="SQL Query to generate the ConvertToViewData object from")], **kwargs) -> str:  # noqa: E501
        ...

    @overload
    def put_sql_to_view_design(self, body : Annotated[StrictStr, Field(..., description="SQL Query to generate the ConvertToViewData object from")], async_req: Optional[bool]=True, **kwargs) -> str:  # noqa: E501
        ...

    @validate_arguments
    def put_sql_to_view_design(self, body : Annotated[StrictStr, Field(..., description="SQL Query to generate the ConvertToViewData object from")], async_req: Optional[bool]=None, **kwargs) -> Union[str, Awaitable[str]]:  # noqa: E501
        """[EXPERIMENTAL] PutSqlToViewDesign: Generates a structured view creation design from existing view creation SQL.  # noqa: E501

        SQL which creates a view into a structured ConvertToViewData object  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.put_sql_to_view_design(body, async_req=True)
        >>> result = thread.get()

        :param body: SQL Query to generate the ConvertToViewData object from (required)
        :type body: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: str
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the put_sql_to_view_design_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.put_sql_to_view_design_with_http_info(body, **kwargs)  # noqa: E501

    @validate_arguments
    def put_sql_to_view_design_with_http_info(self, body : Annotated[StrictStr, Field(..., description="SQL Query to generate the ConvertToViewData object from")], **kwargs) -> ApiResponse:  # noqa: E501
        """[EXPERIMENTAL] PutSqlToViewDesign: Generates a structured view creation design from existing view creation SQL.  # noqa: E501

        SQL which creates a view into a structured ConvertToViewData object  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.put_sql_to_view_design_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param body: SQL Query to generate the ConvertToViewData object from (required)
        :type body: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(str, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'body'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_sql_to_view_design" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['body'] is not None:
            _body_params = _params['body']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['text/plain']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "str",
            '400': "LusidProblemDetails",
        }

        return self.api_client.call_api(
            '/api/Sql/toviewdesign', 'PUT',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @overload
    async def put_view_design_to_sql(self, convert_to_view_data : Annotated[ConvertToViewData, Field(..., description="Structured Query design object to generate SQL from")], **kwargs) -> str:  # noqa: E501
        ...

    @overload
    def put_view_design_to_sql(self, convert_to_view_data : Annotated[ConvertToViewData, Field(..., description="Structured Query design object to generate SQL from")], async_req: Optional[bool]=True, **kwargs) -> str:  # noqa: E501
        ...

    @validate_arguments
    def put_view_design_to_sql(self, convert_to_view_data : Annotated[ConvertToViewData, Field(..., description="Structured Query design object to generate SQL from")], async_req: Optional[bool]=None, **kwargs) -> Union[str, Awaitable[str]]:  # noqa: E501
        """[EXPERIMENTAL] PutViewDesignToSql: Generates view creation sql from a structured view creation design  # noqa: E501

        Converts a ConvertToView specification into SQL that creates a view  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.put_view_design_to_sql(convert_to_view_data, async_req=True)
        >>> result = thread.get()

        :param convert_to_view_data: Structured Query design object to generate SQL from (required)
        :type convert_to_view_data: ConvertToViewData
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: str
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the put_view_design_to_sql_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.put_view_design_to_sql_with_http_info(convert_to_view_data, **kwargs)  # noqa: E501

    @validate_arguments
    def put_view_design_to_sql_with_http_info(self, convert_to_view_data : Annotated[ConvertToViewData, Field(..., description="Structured Query design object to generate SQL from")], **kwargs) -> ApiResponse:  # noqa: E501
        """[EXPERIMENTAL] PutViewDesignToSql: Generates view creation sql from a structured view creation design  # noqa: E501

        Converts a ConvertToView specification into SQL that creates a view  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.put_view_design_to_sql_with_http_info(convert_to_view_data, async_req=True)
        >>> result = thread.get()

        :param convert_to_view_data: Structured Query design object to generate SQL from (required)
        :type convert_to_view_data: ConvertToViewData
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(str, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'convert_to_view_data'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_view_design_to_sql" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['convert_to_view_data'] is not None:
            _body_params = _params['convert_to_view_data']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "str",
            '400': "LusidProblemDetails",
        }

        return self.api_client.call_api(
            '/api/Sql/fromviewdesign', 'PUT',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
