import { FinalizeHandler, FinalizeHandlerArguments, MetadataBearer, Provider, RetryStrategy } from "@aws-sdk/types";
import { DelayDecider, RetryDecider, RetryQuota } from "./types";

export interface StandardRetryStrategyOptions {
    retryDecider?: RetryDecider;
    delayDecider?: DelayDecider;
    retryQuota?: RetryQuota;
}
export declare class StandardRetryStrategy implements RetryStrategy {
    private readonly maxAttemptsProvider;
    private retryDecider;
    private delayDecider;
    private retryQuota;
    mode: string;
    constructor(maxAttemptsProvider: Provider<number>, options?: StandardRetryStrategyOptions);
    private shouldRetry;
    private getMaxAttempts;
    retry<Input extends object, Ouput extends MetadataBearer>(next: FinalizeHandler<Input, Ouput>, args: FinalizeHandlerArguments<Input>, options?: {
        beforeRequest: Function;
        afterRequest: Function;
    }): Promise<{
        response: unknown;
        output: Ouput;
    }>;
}
