"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.FunctionInvoker = exports.FunctionInvokerProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const fc_generated_1 = require("./fc.generated");
Object.defineProperty(exports, "FunctionInvokerProperty", { enumerable: true, get: function () { return fc_generated_1.RosFunctionInvoker; } });
/**
 * A ROS resource type:  `ALIYUN::FC::FunctionInvoker`
 */
class FunctionInvoker extends ros.Resource {
    /**
     * Create a new `ALIYUN::FC::FunctionInvoker`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosFunctionInvoker = new fc_generated_1.RosFunctionInvoker(this, id, {
            functionName: props.functionName,
            executeVersion: props.executeVersion,
            serviceRegionId: props.serviceRegionId,
            serviceName: props.serviceName,
            async: props.async ? props.async : false,
            event: props.event,
            qualifier: props.qualifier,
            checkError: props.checkError,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosFunctionInvoker;
        this.attrResult = rosFunctionInvoker.attrResult;
        this.attrResultType = rosFunctionInvoker.attrResultType;
    }
}
exports.FunctionInvoker = FunctionInvoker;
//# sourceMappingURL=data:application/json;base64,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