"""
Django settings for django_crontab_manager_server project.

Generated by 'django-admin startproject' using Django 2.2.19.

For more information on this file, see
https://docs.djangoproject.com/en/2.2/topics/settings/

For the full list of settings and their values, see
https://docs.djangoproject.com/en/2.2/ref/settings/
"""

import os

# Build paths inside the project like this: os.path.join(BASE_DIR, ...)
BASE_DIR = os.path.dirname(os.path.dirname(os.path.abspath(__file__)))


# Quick-start development settings - unsuitable for production
# See https://docs.djangoproject.com/en/2.2/howto/deployment/checklist/

# SECURITY WARNING: keep the secret key used in production secret!
SECRET_KEY = 'XeLaezUQ2p8edWjhsNp3Frk7vCJ6jFbfTH21e55qdSs4GEKTA2ESH1YFM3pf9l3c'

# SECURITY WARNING: don't run with debug turned on in production!
DEBUG = True

ALLOWED_HOSTS = ["*"]


# Application definition

INSTALLED_APPS = [

    'django_admin_safe_login',
    'django_admin_global_sidebar',
    'django_server_controller',
    'django_safe_settings',
    'django_extensions',
    'django_simple_export_admin',
    "django_data_import_management",

    'django_crontab_manager',
    'django.contrib.admin',
    'django.contrib.auth',
    'django.contrib.contenttypes',
    'django.contrib.sessions',
    'django.contrib.messages',
    'django.contrib.staticfiles',
]

from django_app_requires import add_requires
INSTALLED_APPS = add_requires(INSTALLED_APPS)

MIDDLEWARE = [
    'django.middleware.security.SecurityMiddleware',
    'django.contrib.sessions.middleware.SessionMiddleware',
    'django.middleware.common.CommonMiddleware',
    'django.middleware.csrf.CsrfViewMiddleware',
    'django.contrib.auth.middleware.AuthenticationMiddleware',
    'django.contrib.messages.middleware.MessageMiddleware',
    'django.middleware.clickjacking.XFrameOptionsMiddleware',
]

ROOT_URLCONF = 'django_crontab_manager_server.urls'

TEMPLATES = [
    {
        'BACKEND': 'django.template.backends.django.DjangoTemplates',
        'DIRS': [],
        'APP_DIRS': True,
        'OPTIONS': {
            'context_processors': [
                'django.template.context_processors.debug',
                'django.template.context_processors.request',
                'django.contrib.auth.context_processors.auth',
                'django.contrib.messages.context_processors.messages',
            ],
        },
    },
]

WSGI_APPLICATION = 'django_crontab_manager_server.wsgi.application'


# Database
# https://docs.djangoproject.com/en/2.2/ref/settings/#databases

DATABASES = {
    'default': {
        'ENGINE': 'django.db.backends.sqlite3',
        'NAME': os.path.join(BASE_DIR, 'db.sqlite3'),
    }
}


# Password validation
# https://docs.djangoproject.com/en/2.2/ref/settings/#auth-password-validators

AUTH_PASSWORD_VALIDATORS = [
    {
        'NAME': 'django.contrib.auth.password_validation.UserAttributeSimilarityValidator',
    },
    {
        'NAME': 'django.contrib.auth.password_validation.MinimumLengthValidator',
    },
    {
        'NAME': 'django.contrib.auth.password_validation.CommonPasswordValidator',
    },
    {
        'NAME': 'django.contrib.auth.password_validation.NumericPasswordValidator',
    },
]


# Internationalization
# https://docs.djangoproject.com/en/2.2/topics/i18n/

LANGUAGE_CODE = 'en-us'

TIME_ZONE = 'Asia/Shanghai'

USE_I18N = True

USE_L10N = True

USE_TZ = True


# Static files (CSS, JavaScript, Images)
# https://docs.djangoproject.com/en/2.2/howto/static-files/

STATIC_URL = '/static/'

CAPTCHA_IMAGE_SIZE = (100, 30)
DJANGO_ADMIN_SAFE_LOGIN_ENABLE_CAPTCHA = True # optional, default to True
DJANGO_ADMIN_SAFE_LOGIN_BOX_MARGIN_RIGHT = "200px" # optional, default to auto
DJANGO_ADMIN_SAFE_LOGIN_BOX_MARGIN_LEFT = "auto" # optional, default to auto
DJANGO_ADMIN_SAFE_LOGIN_BOX_MARGIN_TOP = "100px" # optional, default to 100px
DJANGO_ADMIN_SAFE_LOGIN_BOX_MARGIN_BOTTOM = "100px" # optional, default to 100px
DJANGO_ADMIN_SAFE_LOGIN_BACKGROUND_IMAGE = "django-admin-safe-login/img/example-background.jpg"  # optional, default to no-image.

DJANGO_ADMIN_GLOBAL_SIDEBAR_MENUS = [
    {
        "title": "Home",
        "icon": "fas fa-home",
        "url": "/admin/",
    },{
        "title": "Crontab Manager",
        "icon": "fas fa-edit",
        "children": [
            {
                "title": "Manage Server",
                "icon": "fas fa-server",
                "model": "django_crontab_manager.server",
                "permissions": ["django_crontab_manager.view_server"],
            },
            {
                "title": "Manage Schedule",
                "icon": "fas fa-list",
                "model": "django_crontab_manager.schedule",
                "permissions": ["django_crontab_manager.view_schedule"], 
            },
            {
                "title": "View Results",
                "icon": "",
                "model": "django_crontab_manager.result",
                "permissions": ["django_crontab_manager.view_result"],
            }
        ]
    },{
        "title": "Settings",
        "icon": "fa fa-cogs",
        "children": [
            {
                "title": "User",
                "icon": "fas fa-user",
                "model": "auth.user",
                "permissions": ["auth.view_user",],
            },
            {
                "title": "Group",
                "icon": "fas fa-users",
                "model": "auth.group",
                "permissions": ["auth.view_group",],
            }
        ]
    }
]

try:
    from django_crontab_manager_server_local_settings import *
except ImportError:
    pass

try:
    from django_safe_settings.patch import patch_all
    patch_all()
except ImportError:
    pass
