# Generated by Django 2.2.19 on 2021-03-03 04:32

from django.db import migrations, models
import django.db.models.deletion
import django_crontab_manager.models
import django_safe_fields.fields
import uuid


class Migration(migrations.Migration):

    dependencies = [
        ('django_crontab_manager', '0002_auto_20210129_1717'),
    ]

    operations = [
        migrations.AlterModelOptions(
            name='result',
            options={'verbose_name': 'Result', 'verbose_name_plural': 'Results'},
        ),
        migrations.AlterModelOptions(
            name='schedule',
            options={'verbose_name': 'Schedule', 'verbose_name_plural': 'Schedules'},
        ),
        migrations.AlterModelOptions(
            name='server',
            options={'verbose_name': 'Server', 'verbose_name_plural': 'Servers'},
        ),
        migrations.AddField(
            model_name='result',
            name='success',
            field=models.NullBooleanField(verbose_name='Success'),
        ),
        migrations.AddField(
            model_name='schedule',
            name='success_determination_config_data',
            field=django_safe_fields.fields.SafeTextField(blank=True, null=True, verbose_name='Success Determination Rule Settings'),
        ),
        migrations.AddField(
            model_name='schedule',
            name='success_determination_rule',
            field=models.IntegerField(choices=[(0, 'An 0 exit code is considered successful'), (10, 'Stdout contains given keyword is considered successful'), (20, 'Stdout NOT contains given keyword is considered successful')], default=0, verbose_name='Success Determination Rule'),
        ),
        migrations.AddField(
            model_name='server',
            name='variables_data',
            field=django_safe_fields.fields.SafeTextField(blank=True, help_text='Set variables in yml format.', null=True, verbose_name='Variables'),
        ),
        migrations.AlterField(
            model_name='result',
            name='code',
            field=models.IntegerField(blank=True, null=True, verbose_name='Script Exit Code'),
        ),
        migrations.AlterField(
            model_name='result',
            name='run_time',
            field=models.DateTimeField(verbose_name='Run Time'),
        ),
        migrations.AlterField(
            model_name='result',
            name='schedule',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='django_crontab_manager.Schedule', verbose_name='Schedule'),
        ),
        migrations.AlterField(
            model_name='result',
            name='stderr',
            field=django_safe_fields.fields.SafeTextField(blank=True, null=True, verbose_name='Stderr Message'),
        ),
        migrations.AlterField(
            model_name='result',
            name='stdout',
            field=django_safe_fields.fields.SafeTextField(blank=True, null=True, verbose_name='Stdout Message'),
        ),
        migrations.AlterField(
            model_name='schedule',
            name='add_time',
            field=models.DateTimeField(auto_now_add=True, verbose_name='Add Time'),
        ),
        migrations.AlterField(
            model_name='schedule',
            name='code',
            field=models.CharField(blank=True, help_text='MD5 code of the schedule settings. It will be auto computed.', max_length=32, null=True, verbose_name='Setting Code'),
        ),
        migrations.AlterField(
            model_name='schedule',
            name='description',
            field=models.TextField(blank=True, null=True, verbose_name='Description'),
        ),
        migrations.AlterField(
            model_name='schedule',
            name='enable',
            field=models.BooleanField(default=True, verbose_name='Enable'),
        ),
        migrations.AlterField(
            model_name='schedule',
            name='modify_time',
            field=models.DateTimeField(auto_now=True, verbose_name='Modify Time'),
        ),
        migrations.AlterField(
            model_name='schedule',
            name='schedule',
            field=models.CharField(default='* * * * *', help_text='Linux crontab schedule settings, e.g. * * * * *', max_length=256, verbose_name='Schedule Settings'),
        ),
        migrations.AlterField(
            model_name='schedule',
            name='script',
            field=django_safe_fields.fields.SafeTextField(blank=True, null=True, verbose_name='Shell Script'),
        ),
        migrations.AlterField(
            model_name='schedule',
            name='server',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='django_crontab_manager.Server', verbose_name='Server'),
        ),
        migrations.AlterField(
            model_name='schedule',
            name='title',
            field=models.CharField(help_text='Describe the scheduled task, so that we know what it is.', max_length=128, verbose_name='Title'),
        ),
        migrations.AlterField(
            model_name='schedule',
            name='uid',
            field=models.UUIDField(blank=True, default=uuid.uuid4, null=True, verbose_name='UUID'),
        ),
        migrations.AlterField(
            model_name='schedule',
            name='user',
            field=models.CharField(default='root', max_length=64, verbose_name='Running User'),
        ),
        migrations.AlterField(
            model_name='server',
            name='aclkey',
            field=django_safe_fields.fields.SafeCharField(default=django_crontab_manager.models.uuidstr, max_length=128, verbose_name='Acl Key'),
        ),
        migrations.AlterField(
            model_name='server',
            name='add_time',
            field=models.DateTimeField(auto_now_add=True, verbose_name='Add Time'),
        ),
        migrations.AlterField(
            model_name='server',
            name='description',
            field=models.TextField(blank=True, null=True, verbose_name='Description'),
        ),
        migrations.AlterField(
            model_name='server',
            name='enable',
            field=models.BooleanField(default=True, verbose_name='Enable'),
        ),
        migrations.AlterField(
            model_name='server',
            name='last_updated_time',
            field=models.DateTimeField(blank=True, help_text="It's the latest time that the agent installed on that server got schedule settings.", null=True, verbose_name='Last Updated Time'),
        ),
        migrations.AlterField(
            model_name='server',
            name='modify_time',
            field=models.DateTimeField(auto_now=True, verbose_name='Modify Time'),
        ),
        migrations.AlterField(
            model_name='server',
            name='name',
            field=models.CharField(max_length=64, verbose_name='Name'),
        ),
        migrations.AlterField(
            model_name='server',
            name='uid',
            field=models.CharField(default=django_crontab_manager.models.uuidstr, max_length=128, unique=True, verbose_name='UUID'),
        ),
    ]
