# Generated by Django 2.2.16 on 2021-01-28 08:30

from django.db import migrations, models
import django.db.models.deletion
import uuid


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='Server',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=64, verbose_name='名称')),
                ('uid', models.CharField(default=uuid.uuid4, max_length=128, unique=True, verbose_name='编码')),
                ('aclkey', models.CharField(default=uuid.uuid4, max_length=128, verbose_name='访问授权码')),
                ('description', models.TextField(blank=True, null=True, verbose_name='描述')),
                ('add_time', models.DateTimeField(auto_now_add=True, verbose_name='创建时间')),
                ('modify_time', models.DateTimeField(auto_now=True, verbose_name='修改时间')),
                ('last_updated_time', models.DateTimeField(blank=True, null=True, verbose_name='最近更新时间')),
            ],
            options={
                'verbose_name': '服务器',
                'verbose_name_plural': '服务器',
            },
        ),
        migrations.CreateModel(
            name='Schedule',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('uid', models.UUIDField(blank=True, default=uuid.uuid4, editable=False, null=True, verbose_name='编码')),
                ('title', models.CharField(help_text='为方便任务的后续维护，请输入任务的描述。', max_length=128, verbose_name='名称')),
                ('description', models.TextField(blank=True, null=True, verbose_name='描述')),
                ('schedule', models.CharField(default='* * * * *', help_text='Linux Crontab格式的任务安排。例如：* * * * *', max_length=256, verbose_name='定时设置')),
                ('user', models.CharField(default='root', max_length=64, verbose_name='运行用户')),
                ('script', models.TextField(blank=True, null=True, verbose_name='脚本')),
                ('enable', models.BooleanField(default=True, verbose_name='启用')),
                ('code', models.CharField(blank=True, help_text='MD5 code of the schedule settings. It will be auto computed.', max_length=32, null=True, verbose_name='Setting Code')),
                ('add_time', models.DateTimeField(auto_now_add=True, verbose_name='创建时间')),
                ('modify_time', models.DateTimeField(auto_now=True, verbose_name='修改时间')),
                ('server', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='django_crontab_manager.Server', verbose_name='服务器')),
            ],
            options={
                'verbose_name': '定时任务',
                'verbose_name_plural': '定时任务',
            },
        ),
        migrations.CreateModel(
            name='Result',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('run_time', models.DateTimeField(verbose_name='执行时间')),
                ('code', models.IntegerField(blank=True, null=True, verbose_name='退出码')),
                ('stdout', models.TextField(blank=True, null=True, verbose_name='Stdout Message')),
                ('stderr', models.TextField(blank=True, null=True, verbose_name='Stderr Message')),
                ('schedule', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='django_crontab_manager.Schedule', verbose_name='定时任务')),
            ],
            options={
                'verbose_name': '运行结果',
                'verbose_name_plural': '运行结果',
            },
        ),
    ]
