"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.UserPoolIdentityProviderGoogle = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cognito_generated_1 = require("../cognito.generated");
const user_pool_idp_base_1 = require("./private/user-pool-idp-base");
/**
 * Represents a identity provider that integrates with 'Google'
 * @resource AWS::Cognito::UserPoolIdentityProvider
 */
class UserPoolIdentityProviderGoogle extends user_pool_idp_base_1.UserPoolIdentityProviderBase {
    constructor(scope, id, props) {
        super(scope, id, props);
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_cognito_UserPoolIdentityProviderGoogleProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, UserPoolIdentityProviderGoogle);
            }
            throw error;
        }
        const scopes = props.scopes ?? ['profile'];
        const resource = new cognito_generated_1.CfnUserPoolIdentityProvider(this, 'Resource', {
            userPoolId: props.userPool.userPoolId,
            providerName: 'Google',
            providerType: 'Google',
            providerDetails: {
                client_id: props.clientId,
                client_secret: props.clientSecret,
                authorize_scopes: scopes.join(' '),
            },
            attributeMapping: super.configureAttributeMapping(),
        });
        this.providerName = super.getResourceNameAttribute(resource.ref);
    }
}
exports.UserPoolIdentityProviderGoogle = UserPoolIdentityProviderGoogle;
_a = JSII_RTTI_SYMBOL_1;
UserPoolIdentityProviderGoogle[_a] = { fqn: "@aws-cdk/aws-cognito.UserPoolIdentityProviderGoogle", version: "1.184.0" };
//# sourceMappingURL=data:application/json;base64,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