# VietQR Generation Library

This is a VietQR generation library. 

This library will help you to generate the VietQR Data String which align with VietQR Specification announced on 05/10/2022
## VietQR Library specification:
- **Generation function:** `VietQR.genQRString(is_dynamic_qr, merchant_category, merchant_name,
  merchant_city,
  postal_code, currency, country_code, amount,
  acq, merchant_id, service_code,
  bill_number, mobile_number, store_label, loyalty_number,
  ref_label, customer_label, terminal_label, purpose_txn, additional_data,
  lang_ref, local_merchant_name, local_merchant_city, uuid,
  ipn_url, app_package_name)`
- **The detail variables:**
  -  `is_dynamic_qr`: 
      - 'False' for static QR
      - 'True' for dynamic QR
  - `merchant_category`: defined by ISO 18245 and assigned by Payment Instituation.
  - `postal_code`: Postal code, **Ex**: postcode = 70000 for Vietnam
  - `currency`: defined by ISO 4217, for Vietnam: `currency = 704`
  - `country_code`: defined by ISO ISO 3166-1 alpha 2, for Vietnam: `country_code = VN`
  - `amount`: Total amount (including TIP) of bill
  - `acq`: Acquirer bank code defined by Vietname State Bank.
  - `service_code`: VietQR service code as following
      - `QRPUSH`: Payment service code by QR
      - `QRIBFTTC`: Inter-Bank Fund Transfer 24/7 to Card service code by QR
      - `QRIBFTTA`: Inter-Bank Fund Transfer 24/7 to Account service code by QR
  - `merchant_id`:  as following
    - for QRPUSH: Merchant ID will be provided by Acquirer bank.
    - for QRIBFTTC: Merchant ID will be your ATM card number which started with '9704...'.
    - for QRIBFTTA: Merchant ID will be your bank account.
  - `purpose_txn`: payment/transfer purpose
  - Other extended and optional variable
    - `bill_number`: Your bill number
    - `terminal_label`: Your terminal ID
    - `store_label`: Your store name
    - `mobile_number`: Your customer mobile phonenumber
    - `loyalty_number`: Your customer loyalty numbeer
    - `customer_label`: Your customer ID
    - `ref_label`: Your reference info

## To use this library, do as following
- Import the library: `from vietqrlib import VietQR`
- Generate the VietQR data string: 

    - **Example for money transfer VietQR**:
  > vietQRString = VietQR.genQRString(merchant_id="660704060000129",
  acq=VietQR.getBincode('VIB'),
  amount="50000",
  service_code="QRIBFTTA",
  ipn_url="abc"
  ) 
  > 
  > print(f"{vietQRString}")
  > 
    - **The result**: 00020101021238590010A0000007270141000697044101156607040600001290208QRIBFTTA5204581253037045405500005802VN5901_6011HO CHI MINH99210010A0000007270203abc63045859
    - Then you can use any **QRcode** library to generate the VietQR and the result as following:
  
  ![img.png](img.png)

## Supporting
- Any questions please send us a comment via email: **community@thebeanfamily.org**.
  