"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.KongEks = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// import * as eks from '@aws-cdk/aws-eks';
// import * as kms from '@aws-cdk/aws-kms';
// import { Construct, Tags } from '@aws-cdk/core';
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
const kong_core_1 = require("kong-core");
const index_1 = require("./resources/helm-charts/kong/index");
const index_2 = require("./resources/helm-charts/private-ca/index");
/**
 * @summary The KongEks class.
 */
class KongEks extends constructs_1.Construct {
    /**
       * @summary Constructs a new instance of the KongEks class.
       * @param {cdk.App} scope - represents the scope for all the resources.
       * @param {string} id - this is a a scope-unique id.
       * @param {CloudFrontToApiGatewayToLambdaProps} props - user provided props for the construct.
       * @since 0.1.0
       * @access public
       */
    constructor(scope, id, props) {
        super(scope, id);
        this.clusterDns = `cluster.${props.hostedZoneName}`;
        this.telemetryDns = `telemetry.${props.hostedZoneName}`;
        const control_plane_secretskey = new aws_cdk_lib_1.aws_kms.Key(this, 'CPSecretsKey');
        this.controlPlane = new aws_cdk_lib_1.aws_eks.Cluster(this, 'CP', {
            ...props.controlPlaneClusterProps,
            secretsEncryptionKey: control_plane_secretskey,
            defaultCapacity: 0,
        });
        const cp_nodegroup = this.controlPlane.addNodegroupCapacity('CpASG', props.controlPlaneNodeProps);
        aws_cdk_lib_1.Tags.of(cp_nodegroup).add('aws-node-termination-handler/managed', 'true');
        aws_cdk_lib_1.Tags.of(cp_nodegroup).add('k8s.io/cluster-autoscaler/enabled', 'TRUE');
        aws_cdk_lib_1.Tags.of(cp_nodegroup).add(`k8s.io/cluster-autoscaler/${this.controlPlane.clusterName}`, 'owned');
        new kong_core_1.AutoScalar(this, 'AutoScalar', {
            cluster: this.controlPlane,
            nodegroup: cp_nodegroup,
            namespace: 'kube-system',
        });
        // new EksNodeHandler(this, 'NodeHandler', {
        //   cluster: this.controlPlane,
        //   nodegroup: cp_nodegroup,
        // });
        new kong_core_1.MetricsServer(this, 'MetricsServer', {
            cluster: this.controlPlane,
        });
        new kong_core_1.Telemetry(this, 'KongLogging', {
            cluster: this.controlPlane,
            namespace: 'telemetry',
        });
        const kong_rds_instance = new kong_core_1.RdsStack(this, 'KongRds', {
            vpc: this.controlPlane.vpc,
            databasename: props.rdsProps.databasename,
            postgresversion: props.rdsProps.postgresversion,
            username: props.rdsProps.username,
        });
        const private_ca = new index_2.PrivateCA(this, 'KongPCA', {
            cluster: this.controlPlane,
            nodegroup: cp_nodegroup,
            namespace: props.namespace,
            cacertname: 'kong-cp-ca-cert',
            clusterIssuerName: 'kong-cp-cluster-issuer',
            // commonname: 'www.dummy.com',
            hostedZoneName: 'kong-cp.internal',
            dnsNames: [
                `${props.hostedZoneName}`,
                `admin.${props.hostedZoneName}`,
                this.telemetryDns,
                this.clusterDns,
                `manager.${props.hostedZoneName}`,
            ],
        });
        this.privateCaArn = private_ca.private_ca_arn;
        const kong_helm = new index_1.KongControlPlane(this, 'KongCPHelmInstall', {
            cluster: this.controlPlane,
            rds: kong_rds_instance.kongPostgresSql,
            namespace: props.namespace,
            nodegroup: cp_nodegroup,
            license_secret_name: props.licenseSecretsName,
        });
        kong_helm.node.addDependency(private_ca, kong_rds_instance);
    }
    ;
}
exports.KongEks = KongEks;
_a = JSII_RTTI_SYMBOL_1;
KongEks[_a] = { fqn: "kong-control-plane.KongEks", version: "2.0.3" };
//# sourceMappingURL=data:application/json;base64,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