# API Reference <a name="API Reference" id="api-reference"></a>

## Constructs <a name="Constructs" id="Constructs"></a>

### KongEks <a name="KongEks" id="kong-control-plane.KongEks"></a>

#### Initializers <a name="Initializers" id="kong-control-plane.KongEks.Initializer"></a>

```typescript
import { KongEks } from 'kong-control-plane'

new KongEks(scope: Construct, id: string, props: KongEksControlPlaneProps)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#kong-control-plane.KongEks.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | - represents the scope for all the resources. |
| <code><a href="#kong-control-plane.KongEks.Initializer.parameter.id">id</a></code> | <code>string</code> | - this is a a scope-unique id. |
| <code><a href="#kong-control-plane.KongEks.Initializer.parameter.props">props</a></code> | <code>kong-core.KongEksControlPlaneProps</code> | - user provided props for the construct. |

---

##### `scope`<sup>Required</sup> <a name="scope" id="kong-control-plane.KongEks.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

represents the scope for all the resources.

---

##### `id`<sup>Required</sup> <a name="id" id="kong-control-plane.KongEks.Initializer.parameter.id"></a>

- *Type:* string

this is a a scope-unique id.

---

##### `props`<sup>Required</sup> <a name="props" id="kong-control-plane.KongEks.Initializer.parameter.props"></a>

- *Type:* kong-core.KongEksControlPlaneProps

user provided props for the construct.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#kong-control-plane.KongEks.toString">toString</a></code> | Returns a string representation of this construct. |

---

##### `toString` <a name="toString" id="kong-control-plane.KongEks.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#kong-control-plane.KongEks.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |

---

##### ~~`isConstruct`~~ <a name="isConstruct" id="kong-control-plane.KongEks.isConstruct"></a>

```typescript
import { KongEks } from 'kong-control-plane'

KongEks.isConstruct(x: any)
```

Checks if `x` is a construct.

###### `x`<sup>Required</sup> <a name="x" id="kong-control-plane.KongEks.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#kong-control-plane.KongEks.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#kong-control-plane.KongEks.property.controlPlane">controlPlane</a></code> | <code>aws-cdk-lib.aws_eks.Cluster</code> | *No description.* |
| <code><a href="#kong-control-plane.KongEks.property.clusterDns">clusterDns</a></code> | <code>string</code> | *No description.* |
| <code><a href="#kong-control-plane.KongEks.property.privateCaArn">privateCaArn</a></code> | <code>string</code> | *No description.* |
| <code><a href="#kong-control-plane.KongEks.property.telemetryDns">telemetryDns</a></code> | <code>string</code> | *No description.* |

---

##### `node`<sup>Required</sup> <a name="node" id="kong-control-plane.KongEks.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `controlPlane`<sup>Required</sup> <a name="controlPlane" id="kong-control-plane.KongEks.property.controlPlane"></a>

```typescript
public readonly controlPlane: Cluster;
```

- *Type:* aws-cdk-lib.aws_eks.Cluster

---

##### `clusterDns`<sup>Required</sup> <a name="clusterDns" id="kong-control-plane.KongEks.property.clusterDns"></a>

```typescript
public readonly clusterDns: string;
```

- *Type:* string

---

##### `privateCaArn`<sup>Required</sup> <a name="privateCaArn" id="kong-control-plane.KongEks.property.privateCaArn"></a>

```typescript
public readonly privateCaArn: string;
```

- *Type:* string

---

##### `telemetryDns`<sup>Required</sup> <a name="telemetryDns" id="kong-control-plane.KongEks.property.telemetryDns"></a>

```typescript
public readonly telemetryDns: string;
```

- *Type:* string

---





