/*!
 * Copyright (c) 2012 - 2022, Anaconda, Inc., and Bokeh Contributors
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 * 
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * 
 * Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 * 
 * Neither the name of Anaconda nor the names of any contributors
 * may be used to endorse or promote products derived from this software
 * without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */
(function(root, factory) {
  factory(root["Bokeh"], "3.0.0-dev.5");
})(this, function(Bokeh, version) {
  let define;
  return (function(modules, entry, aliases, externals) {
    const bokeh = typeof Bokeh !== "undefined" && (version != null ? Bokeh[version] : Bokeh);
    if (bokeh != null) {
      return bokeh.register_plugin(modules, entry, aliases);
    } else {
      throw new Error("Cannot find Bokeh " + version + ". You have to load it prior to loading plugins.");
    }
  })
({
469: function _(t,e,i,o,r){o();const s=t(1).__importStar(t(470));i.Widgets=s;(0,t(7).register_models)(s)},
470: function _(t,e,o,r,u){r(),u("AbstractButton",t(471).AbstractButton),u("AbstractIcon",t(474).AbstractIcon),u("AutocompleteInput",t(475).AutocompleteInput),u("Button",t(481).Button),u("CheckboxButtonGroup",t(482).CheckboxButtonGroup),u("CheckboxGroup",t(485).CheckboxGroup),u("ColorPicker",t(487).ColorPicker),u("DatePicker",t(488).DatePicker),u("DateRangeSlider",t(498).DateRangeSlider),u("DateSlider",t(503).DateSlider),u("Div",t(504).Div),u("Dropdown",t(507).Dropdown),u("FileInput",t(508).FileInput),u("InputWidget",t(478).InputWidget),u("Markup",t(505).Markup),u("MultiSelect",t(509).MultiSelect),u("Paragraph",t(510).Paragraph),u("PasswordInput",t(511).PasswordInput),u("MultiChoice",t(512).MultiChoice),u("NumericInput",t(515).NumericInput),u("PreText",t(516).PreText),u("RadioButtonGroup",t(517).RadioButtonGroup),u("RadioGroup",t(518).RadioGroup),u("RangeSlider",t(519).RangeSlider),u("Select",t(520).Select),u("Slider",t(521).Slider),u("Spinner",t(522).Spinner),u("Switch",t(523).Switch),u("TextInput",t(476).TextInput),u("TextAreaInput",t(525).TextAreaInput),u("Toggle",t(526).Toggle),u("Widget",t(551).Widget)},
471: function _(t,e,n,i,s){i();const l=t(1);var o;const r=t(19),c=t(52),_=t(54),u=t(472),a=t(474),d=l.__importStar(t(346)),h=d;class b extends u.ControlView{*controls(){yield this.button_el}async lazy_initialize(){await super.lazy_initialize();const{icon:t}=this.model;null!=t&&(this.icon_view=await(0,_.build_view)(t,{parent:this}))}connect_signals(){super.connect_signals(),this.connect(this.model.change,(()=>this.render()))}remove(){null!=this.icon_view&&this.icon_view.remove(),super.remove()}styles(){return[...super.styles(),d.default]}_render_button(...t){return(0,c.button)({type:"button",disabled:this.model.disabled,class:[h.btn,h[`btn_${this.model.button_type}`]]},...t)}render(){super.render(),this.button_el=this._render_button(this.model.label),this.button_el.addEventListener("click",(()=>this.click())),null!=this.icon_view&&(""!=this.model.label?(0,c.prepend)(this.button_el,this.icon_view.el,(0,c.nbsp)()):(0,c.prepend)(this.button_el,this.icon_view.el),this.icon_view.render()),this.group_el=(0,c.div)({class:h.btn_group},this.button_el),this.shadow_el.appendChild(this.group_el)}click(){}}n.AbstractButtonView=b,b.__name__="AbstractButtonView";class p extends u.Control{constructor(t){super(t)}}n.AbstractButton=p,o=p,p.__name__="AbstractButton",o.define((({String:t,Ref:e,Nullable:n})=>({label:[t,"Button"],icon:[n(e(a.AbstractIcon)),null],button_type:[r.ButtonType,"default"]})))},
472: function _(t,e,o,s,n){s();const i=t(551),l=t(52);class c extends i.WidgetView{connect_signals(){super.connect_signals();const t=this.model.properties;this.on_change(t.disabled,(()=>{for(const t of this.controls())(0,l.toggle_attribute)(t,"disabled",this.model.disabled)}))}}o.ControlView=c,c.__name__="ControlView";class r extends i.Widget{constructor(t){super(t)}}o.Control=r,r.__name__="Control"},
551: function _(t,i,e,r,s){var n;r();const a=t(340),o=t(163);class h extends a.HTMLBoxView{get orientation(){return"horizontal"}get default_size(){return this.model.default_size}_width_policy(){return"horizontal"==this.orientation?super._width_policy():"fixed"}_height_policy(){return"horizontal"==this.orientation?"fixed":super._height_policy()}box_sizing(){const t=super.box_sizing();return"horizontal"==this.orientation?null==t.width&&(t.width=this.default_size):null==t.height&&(t.height=this.default_size),t}get provider(){return o.default_provider}async lazy_initialize(){await super.lazy_initialize(),"not_started"==this.provider.status&&await this.provider.fetch()}after_layout(){super.after_layout(),"loading"==this.provider.status&&(this._has_finished=!1)}process_tex(t){if(!this.provider.MathJax)return t;const i=this.provider.MathJax.find_tex(t),e=[];let r=0;for(const s of i)e.push(t.slice(r,s.start.n)),e.push(this.provider.MathJax.tex2svg(s.math,{display:s.display}).outerHTML),r=s.end.n;return r<t.length&&e.push(t.slice(r)),e.join("")}contains_tex_string(t){return!!this.provider.MathJax&&this.provider.MathJax.find_tex(t).length>0}}e.WidgetView=h,h.__name__="WidgetView";class d extends a.HTMLBox{constructor(t){super(t)}}e.Widget=d,n=d,d.__name__="Widget",n.define((({Number:t})=>({default_size:[t,300]}))),n.override({margin:[5,5,5,5]})},
474: function _(t,c,n,s,e){s();const o=t(51),_=t(55);class a extends _.DOMComponentView{}n.AbstractIconView=a,a.__name__="AbstractIconView";class r extends o.Model{constructor(t){super(t)}}n.AbstractIcon=r,r.__name__="AbstractIcon"},
475: function _(e,t,n,s,i){s();const h=e(1);var o;const _=e(476),u=e(52),r=e(11),c=h.__importStar(e(480)),a=c;class d extends _.TextInputView{constructor(){super(...arguments),this._open=!1,this._last_value="",this._hover_index=0}styles(){return[...super.styles(),c.default]}render(){super.render(),this.input_el.addEventListener("keydown",(e=>this._keydown(e))),this.input_el.addEventListener("keyup",(e=>this._keyup(e))),this.menu=(0,u.div)({class:[a.menu,a.below]}),this.menu.addEventListener("click",(e=>this._menu_click(e))),this.menu.addEventListener("mouseover",(e=>this._menu_hover(e))),this.shadow_el.appendChild(this.menu),(0,u.undisplay)(this.menu)}change_input(){this._open&&this.menu.children.length>0?(this.model.value=this.menu.children[this._hover_index].textContent,this.input_el.focus(),this._hide_menu()):this.model.restrict||super.change_input()}_update_completions(e){(0,u.empty)(this.menu);for(const t of e){const e=(0,u.div)(t);this.menu.appendChild(e)}e.length>0&&this.menu.children[0].classList.add(a.active)}_show_menu(){if(!this._open){this._open=!0,this._hover_index=0,this._last_value=this.model.value,(0,u.display)(this.menu);const e=t=>{t.composedPath().includes(this.el)||(document.removeEventListener("click",e),this._hide_menu())};document.addEventListener("click",e)}}_hide_menu(){this._open&&(this._open=!1,(0,u.undisplay)(this.menu))}_menu_click(e){e.target!=e.currentTarget&&e.target instanceof Element&&(this.model.value=e.target.textContent,this.input_el.focus(),this._hide_menu())}_menu_hover(e){if(e.target!=e.currentTarget&&e.target instanceof Element)for(let t=0;t<this.menu.children.length;t++)if(this.menu.children[t].textContent==e.target.textContent){this._bump_hover(t);break}}_bump_hover(e){const t=this.menu.children.length;this._open&&t>0&&(this.menu.children[this._hover_index].classList.remove(a.active),this._hover_index=(0,r.clamp)(e,0,t-1),this.menu.children[this._hover_index].classList.add(a.active))}_keydown(e){}_keyup(e){switch(e.keyCode){case u.Keys.Enter:this.change_input();break;case u.Keys.Esc:this._hide_menu();break;case u.Keys.Up:this._bump_hover(this._hover_index-1);break;case u.Keys.Down:this._bump_hover(this._hover_index+1);break;default:{const e=this.input_el.value;if(e.length<this.model.min_characters)return void this._hide_menu();const t=[],{case_sensitive:n}=this.model;let s;s=n?e=>e:e=>e.toLowerCase();for(const n of this.model.completions)s(n).startsWith(s(e))&&t.push(n);this._update_completions(t),0==t.length?this._hide_menu():this._show_menu()}}}}n.AutocompleteInputView=d,d.__name__="AutocompleteInputView";class l extends _.TextInput{constructor(e){super(e)}}n.AutocompleteInput=l,o=l,l.__name__="AutocompleteInput",o.prototype.default_view=d,o.define((({Boolean:e,Int:t,String:n,Array:s})=>({completions:[s(n),[]],min_characters:[t,2],case_sensitive:[e,!0],restrict:[e,!0]})))},
476: function _(t,e,n,p,_){p();const u=t(1);var i;const s=t(477),r=t(52),x=u.__importStar(t(479));class a extends s.TextLikeInputView{_render_input(){this.input_el=(0,r.input)({type:"text",class:x.input})}}n.TextInputView=a,a.__name__="TextInputView";class c extends s.TextLikeInput{constructor(t){super(t)}}n.TextInput=c,i=c,c.__name__="TextInput",i.prototype.default_view=a},
477: function _(e,t,n,i,l){var s;i();const h=e(478);class a extends h.InputWidgetView{connect_signals(){super.connect_signals(),this.connect(this.model.properties.name.change,(()=>{var e;return this.input_el.name=null!==(e=this.model.name)&&void 0!==e?e:""})),this.connect(this.model.properties.value.change,(()=>this.input_el.value=this.model.value)),this.connect(this.model.properties.value_input.change,(()=>this.input_el.value=this.model.value_input)),this.connect(this.model.properties.disabled.change,(()=>this.input_el.disabled=this.model.disabled)),this.connect(this.model.properties.placeholder.change,(()=>this.input_el.placeholder=this.model.placeholder)),this.connect(this.model.properties.max_length.change,(()=>{const{max_length:e}=this.model;null!=e?this.input_el.maxLength=e:this.input_el.removeAttribute("maxLength")}))}render(){var e;super.render(),this._render_input();const{input_el:t}=this;t.name=null!==(e=this.model.name)&&void 0!==e?e:"",t.value=this.model.value,t.disabled=this.model.disabled,t.placeholder=this.model.placeholder,null!=this.model.max_length&&(t.maxLength=this.model.max_length),t.addEventListener("change",(()=>this.change_input())),t.addEventListener("input",(()=>this.change_input_value())),this.group_el.appendChild(t)}change_input(){this.model.value=this.input_el.value,super.change_input()}change_input_value(){this.model.value_input=this.input_el.value,super.change_input()}}n.TextLikeInputView=a,a.__name__="TextLikeInputView";class u extends h.InputWidget{constructor(e){super(e)}}n.TextLikeInput=u,s=u,u.__name__="TextLikeInput",s.define((({Int:e,String:t,Nullable:n})=>({value:[t,""],value_input:[t,""],placeholder:[t,""],max_length:[n(e),null]})))},
478: function _(e,t,n,s,l){s();const i=e(1);var o;const r=e(472),_=e(52),p=i.__importStar(e(479)),a=p;class d extends r.ControlView{*controls(){yield this.input_el}connect_signals(){super.connect_signals(),this.connect(this.model.properties.title.change,(()=>{this.label_el.textContent=this.model.title}))}styles(){return[...super.styles(),p.default]}render(){super.render();const{title:e}=this.model;this.label_el=(0,_.label)({style:{display:0==e.length?"none":""}},e),this.group_el=(0,_.div)({class:a.input_group},this.label_el),this.shadow_el.appendChild(this.group_el)}change_input(){}}n.InputWidgetView=d,d.__name__="InputWidgetView";class c extends r.Control{constructor(e){super(e)}}n.InputWidget=c,o=c,c.__name__="InputWidget",o.define((({String:e})=>({title:[e,""]})))},
479: function _(i,p,n,t,e){t(),n.input="bk-input",n.input_group="bk-input-group",n.inline="bk-inline",n.spin_wrapper="bk-spin-wrapper",n.spin_btn="bk-spin-btn",n.spin_btn_up="bk-spin-btn-up",n.spin_btn_down="bk-spin-btn-down",n.default='input[type=file]::file-selector-button{font-family:inherit;}.bk-input{display:inline-block;width:100%;flex-grow:1;min-height:calc(var(--line-height-computed) + 2*var(--padding-vertical) + 2px);padding:0 var(--padding-horizontal);background-color:#fff;border:1px solid #ccc;border-radius:var(--border-radius);}.bk-input:focus{border-color:#66afe9;outline:0;box-shadow:inset 0 1px 1px rgba(0, 0, 0, 0.075), 0 0 8px rgba(102, 175, 233, 0.6);}.bk-input::placeholder,.bk-input:-ms-input-placeholder,.bk-input::-moz-placeholder,.bk-input::-webkit-input-placeholder{color:#999;opacity:1;}.bk-input[disabled]{cursor:not-allowed;background-color:#eee;opacity:1;}select:not([multiple]).bk-input,select:not([size]).bk-input{height:auto;appearance:none;-webkit-appearance:none;background-image:url(\'data:image/svg+xml;utf8,<svg version="1.1" viewBox="0 0 25 20" xmlns="http://www.w3.org/2000/svg"><path d="M 0,0 25,0 12.5,20 Z" fill="black" /></svg>\');background-position:right 0.5em center;background-size:8px 6px;background-repeat:no-repeat;}option{padding:0;}select[multiple].bk-input,select[size].bk-input,textarea.bk-input{height:auto;}.bk-input-group{width:100%;height:100%;display:inline-flex;flex-wrap:nowrap;align-items:start;flex-direction:column;white-space:nowrap;}.bk-input-group.bk-inline{flex-direction:row;}.bk-input-group.bk-inline > *:not(:first-child){margin-left:5px;}.bk-input-group input[type="checkbox"],.bk-input-group input[type="radio"]{margin:0;}.bk-input-group input[type="checkbox"] + span,.bk-input-group input[type="radio"] + span{position:relative;top:-2px;margin-left:3px;}.bk-input-group > .bk-spin-wrapper{display:inherit;width:inherit;height:inherit;position:relative;overflow:hidden;padding:0;vertical-align:middle;}.bk-input-group > .bk-spin-wrapper input{padding-right:20px;}.bk-input-group > .bk-spin-wrapper > .bk-spin-btn{position:absolute;display:block;height:50%;min-height:0;min-width:0;width:30px;padding:0;margin:0;right:0;border:none;background:none;cursor:pointer;}.bk-input-group > .bk-spin-wrapper > .bk-spin-btn:before{content:"";display:inline-block;transform:translateY(-50%);border-left:5px solid transparent;border-right:5px solid transparent;}.bk-input-group > .bk-spin-wrapper > .bk-spin-btn.bk-spin-btn-up{top:0;}.bk-input-group > .bk-spin-wrapper > .bk-spin-btn.bk-spin-btn-up:before{border-bottom:5px solid black;}.bk-input-group > .bk-spin-wrapper > .bk-spin-btn.bk-spin-btn-up:disabled:before{border-bottom-color:grey;}.bk-input-group > .bk-spin-wrapper > .bk-spin-btn.bk-spin-btn-down{bottom:0;}.bk-input-group > .bk-spin-wrapper > .bk-spin-btn.bk-spin-btn-down:before{border-top:5px solid black;}.bk-input-group > .bk-spin-wrapper > .bk-spin-btn.bk-spin-btn-down:disabled:before{border-top-color:grey;}'},
480: function _(e,o,i,b,d){b(),i.menu="bk-menu",i.above="bk-above",i.below="bk-below",i.divider="bk-divider",i.active="bk-active",i.default=".bk-menu{position:absolute;left:0;width:100%;z-index:100;cursor:pointer;font-size:var(--font-size);background-color:#fff;border:1px solid #ccc;border-radius:var(--border-radius);box-shadow:0 6px 12px rgba(0, 0, 0, 0.175);}.bk-menu.bk-above{bottom:100%;}.bk-menu.bk-below{top:100%;}.bk-menu > .bk-divider{height:1px;margin:calc(var(--line-height-computed)/2 - 1px) 0;overflow:hidden;background-color:#e5e5e5;}.bk-menu > :not(.bk-divider){padding:var(--padding-vertical) var(--padding-horizontal);}.bk-menu > :not(.bk-divider):hover,.bk-menu > :not(.bk-divider).bk-active{background-color:#e6e6e6;}"},
481: function _(t,e,n,o,c){var s;o();const u=t(471),r=t(46);class i extends u.AbstractButtonView{click(){this.model.trigger_event(new r.ButtonClick),super.click()}}n.ButtonView=i,i.__name__="ButtonView";class _ extends u.AbstractButton{constructor(t){super(t)}}n.Button=_,s=_,_.__name__="Button",s.prototype.default_view=i,s.override({label:"Button"})},
482: function _(t,e,o,c,a){c();const s=t(1);var n;const i=t(483),r=t(52),u=s.__importStar(t(346));class _ extends i.ButtonGroupView{get active(){return new Set(this.model.active)}change_active(t){const{active:e}=this;e.has(t)?e.delete(t):e.add(t),this.model.active=[...e].sort()}_update_active(){const{active:t}=this;this._buttons.forEach(((e,o)=>{(0,r.classes)(e).toggle(u.active,t.has(o))}))}}o.CheckboxButtonGroupView=_,_.__name__="CheckboxButtonGroupView";class h extends i.ButtonGroup{constructor(t){super(t)}}o.CheckboxButtonGroup=h,n=h,h.__name__="CheckboxButtonGroup",n.prototype.default_view=_,n.define((({Int:t,Array:e})=>({active:[e(t),[]]})))},
483: function _(t,e,n,s,i){s();const o=t(1);var r;const a=t(484),l=t(46),d=t(19),u=t(52),_=o.__importStar(t(346)),c=_;class h extends a.OrientedControlView{get default_size(){return"horizontal"==this.orientation?super.default_size:void 0}*controls(){yield*this._buttons}connect_signals(){super.connect_signals();const t=this.model.properties;this.on_change(t.button_type,(()=>this.render())),this.on_change(t.labels,(()=>this.render())),this.on_change(t.active,(()=>this._update_active()))}styles(){return[...super.styles(),_.default]}render(){super.render(),this._buttons=this.model.labels.map(((t,e)=>{const n=(0,u.div)({class:[c.btn,c[`btn_${this.model.button_type}`]],disabled:this.model.disabled},t);return n.addEventListener("click",(()=>{this.change_active(e),this.model.trigger_event(new l.ButtonClick)})),n})),this._update_active();const t="horizontal"==this.model.orientation?c.horizontal:c.vertical,e=(0,u.div)({class:[c.btn_group,t]},this._buttons);this.shadow_el.appendChild(e)}}n.ButtonGroupView=h,h.__name__="ButtonGroupView";class p extends a.OrientedControl{constructor(t){super(t)}}n.ButtonGroup=p,r=p,p.__name__="ButtonGroup",r.define((({String:t,Array:e})=>({labels:[e(t),[]],button_type:[d.ButtonType,"default"]})))},
484: function _(n,t,e,o,r){var i;o();const a=n(472),l=n(19);class s extends a.ControlView{get orientation(){return this.model.orientation}}e.OrientedControlView=s,s.__name__="OrientedControlView";class _ extends a.Control{constructor(n){super(n)}}e.OrientedControl=_,i=_,_.__name__="OrientedControl",i.define((()=>({orientation:[l.Orientation,"horizontal"]})))},
485: function _(e,t,n,i,s){i();const o=e(1);var a;const c=e(486),l=e(52),d=e(10),p=o.__importStar(e(479));class r extends c.InputGroupView{render(){super.render();const e=(0,l.div)({class:[p.input_group,this.model.inline?p.inline:null]});this.shadow_el.appendChild(e);const{active:t,labels:n}=this.model;this._inputs=[];for(let i=0;i<n.length;i++){const s=(0,l.input)({type:"checkbox",value:`${i}`});s.addEventListener("change",(()=>this.change_active(i))),this._inputs.push(s),this.model.disabled&&(s.disabled=!0),(0,d.includes)(t,i)&&(s.checked=!0);const o=(0,l.label)(s,(0,l.span)(n[i]));e.appendChild(o)}}change_active(e){const t=new Set(this.model.active);t.has(e)?t.delete(e):t.add(e),this.model.active=[...t].sort()}}n.CheckboxGroupView=r,r.__name__="CheckboxGroupView";class h extends c.InputGroup{constructor(e){super(e)}}n.CheckboxGroup=h,a=h,h.__name__="CheckboxGroup",a.prototype.default_view=r,a.define((({Boolean:e,Int:t,String:n,Array:i})=>({active:[i(t),[]],labels:[i(n),[]],inline:[e,!1]})))},
486: function _(n,t,e,s,o){s();const r=n(1),u=n(472),c=r.__importDefault(n(479));class _ extends u.ControlView{*controls(){yield*this._inputs}connect_signals(){super.connect_signals(),this.connect(this.model.change,(()=>this.render()))}styles(){return[...super.styles(),c.default]}}e.InputGroupView=_,_.__name__="InputGroupView";class i extends u.Control{constructor(n){super(n)}}e.InputGroup=i,i.__name__="InputGroup"},
487: function _(e,t,i,n,o){n();const s=e(1);var l;const r=e(478),c=e(52),a=e(21),d=s.__importStar(e(479));class h extends r.InputWidgetView{connect_signals(){super.connect_signals(),this.connect(this.model.properties.name.change,(()=>{var e;return this.input_el.name=null!==(e=this.model.name)&&void 0!==e?e:""})),this.connect(this.model.properties.color.change,(()=>this.input_el.value=(0,a.color2hexrgb)(this.model.color))),this.connect(this.model.properties.disabled.change,(()=>this.input_el.disabled=this.model.disabled))}render(){super.render(),this.input_el=(0,c.input)({type:"color",class:d.input,name:this.model.name,value:this.model.color,disabled:this.model.disabled}),this.input_el.addEventListener("change",(()=>this.change_input())),this.group_el.appendChild(this.input_el)}change_input(){this.model.color=this.input_el.value,super.change_input()}}i.ColorPickerView=h,h.__name__="ColorPickerView";class p extends r.InputWidget{constructor(e){super(e)}}i.ColorPicker=p,l=p,p.__name__="ColorPicker",l.prototype.default_view=h,l.define((({Color:e})=>({color:[e,"#000000"]})))},
488: function _(e,t,n,i,a){i();const o=e(1);var s;const l=o.__importDefault(e(489)),r=e(478),d=e(52),c=e(19),h=e(8),u=o.__importStar(e(479)),f=o.__importDefault(e(497));function p(e){const t=[];for(const n of e)if((0,h.isString)(n))t.push(n);else{const[e,i]=n;t.push({from:e,to:i})}return t}class _ extends r.InputWidgetView{connect_signals(){super.connect_signals();const{value:e,min_date:t,max_date:n,disabled_dates:i,enabled_dates:a,inline:o}=this.model.properties;this.connect(e.change,(()=>{var e;return null===(e=this._picker)||void 0===e?void 0:e.setDate(this.model.value)})),this.connect(t.change,(()=>{var e;return null===(e=this._picker)||void 0===e?void 0:e.set("minDate",this.model.min_date)})),this.connect(n.change,(()=>{var e;return null===(e=this._picker)||void 0===e?void 0:e.set("maxDate",this.model.max_date)})),this.connect(i.change,(()=>{var e;const{disabled_dates:t}=this.model;null===(e=this._picker)||void 0===e||e.set("disable",null!=t?p(t):void 0)})),this.connect(a.change,(()=>{var e;const{enabled_dates:t}=this.model;null===(e=this._picker)||void 0===e||e.set("enable",null!=t?p(t):void 0)})),this.connect(o.change,(()=>{var e;return null===(e=this._picker)||void 0===e?void 0:e.set("inline",this.model.inline)}))}remove(){var e;null===(e=this._picker)||void 0===e||e.destroy(),super.remove()}styles(){return[...super.styles(),f.default]}render(){if(null!=this._picker)return;super.render(),this.input_el=(0,d.input)({type:"text",class:u.input,disabled:this.model.disabled}),this.group_el.appendChild(this.input_el);const e={appendTo:this.group_el,positionElement:this.input_el,defaultDate:this.model.value,inline:this.model.inline,position:this._position.bind(this),onChange:(e,t,n)=>this._on_change(e,t,n)},{min_date:t,max_date:n,disabled_dates:i,enabled_dates:a}=this.model;null!=t&&(e.minDate=t),null!=n&&(e.maxDate=n),null!=i&&(e.disable=p(i)),null!=a&&(e.enable=p(a)),this._picker=(0,l.default)(this.input_el,e)}_on_change(e,t,n){this.model.value=t,this.change_input()}_position(e,t){const n=null!=t?t:e._positionElement,i=Array.prototype.reduce.call(e.calendarContainer.children,((e,t)=>e+t.offsetHeight),0),a=e.calendarContainer.offsetWidth,o=this.model.position.split(" "),s=o[0],l=o.length>1?o[1]:null,r=n.offsetTop,d=n.offsetTop+n.offsetHeight,c=n.offsetLeft,h=n.offsetLeft+n.offsetWidth,u=n.offsetWidth,f=window.innerHeight-d,p="above"===s||"below"!==s&&f<i&&r>i,_=e.config.appendTo?r+(p?-i-2:n.offsetHeight+2):window.pageYOffset+r+(p?-i-2:n.offsetHeight+2);if(e.calendarContainer.classList.toggle("arrowTop",!p),e.calendarContainer.classList.toggle("arrowBottom",p),e.config.inline)return;let g=window.pageXOffset+c,m=!1,v=!1;"center"===l?(g-=(a-u)/2,m=!0):"right"===l&&(g-=a-u,v=!0),e.calendarContainer.classList.toggle("arrowLeft",!m&&!v),e.calendarContainer.classList.toggle("arrowCenter",m),e.calendarContainer.classList.toggle("arrowRight",v);const w=window.document.body.offsetWidth-(window.pageXOffset+h),b=g+a>window.document.body.offsetWidth,C=w+a>window.document.body.offsetWidth;if(e.calendarContainer.classList.toggle("rightMost",b),!e.config.static)if(e.calendarContainer.style.top=`${_}px`,b)if(C){const t=this.shadow_el.styleSheets[0],n=window.document.body.offsetWidth,i=Math.max(0,n/2-a/2),o=".flatpickr-calendar.centerMost:before",s=".flatpickr-calendar.centerMost:after",l=t.cssRules.length,r=`{left:${c}px;right:auto;}`;e.calendarContainer.classList.toggle("rightMost",!1),e.calendarContainer.classList.toggle("centerMost",!0),t.insertRule(`${o},${s}${r}`,l),e.calendarContainer.style.left=`${i}px`,e.calendarContainer.style.right="auto"}else e.calendarContainer.style.left="auto",e.calendarContainer.style.right=`${w}px`;else e.calendarContainer.style.left=`${g}px`,e.calendarContainer.style.right="auto"}}n.DatePickerView=_,_.__name__="DatePickerView";class g extends r.InputWidget{constructor(e){super(e)}}n.DatePicker=g,s=g,g.__name__="DatePicker",s.prototype.default_view=_,s.define((({Boolean:e,String:t,Array:n,Tuple:i,Or:a,Nullable:o})=>{const s=n(a(t,i(t,t)));return{value:[t],min_date:[o(t),null],max_date:[o(t),null],disabled_dates:[o(s),null],enabled_dates:[o(s),null],position:[c.CalendarPosition,"auto"],inline:[e,!1]}}))},
489: function _(e,t,n,a,i){a();const o=e(1),r=e(490),l=o.__importDefault(e(491)),c=e(492),s=e(493),d=e(494),f=e(495);e(496);function m(e,t){const n={config:Object.assign(Object.assign({},r.defaults),g.defaultConfig),l10n:l.default};function a(e){return e.bind(n)}function i(){const e=n.config;!1===e.weekNumbers&&1===e.showMonths||!0!==e.noCalendar&&window.requestAnimationFrame((function(){if(void 0!==n.calendarContainer&&(n.calendarContainer.style.visibility="hidden",n.calendarContainer.style.display="block"),void 0!==n.daysContainer){const t=(n.days.offsetWidth+1)*e.showMonths;n.daysContainer.style.width=t+"px",n.calendarContainer.style.width=t+(void 0!==n.weekWrapper?n.weekWrapper.offsetWidth:0)+"px",n.calendarContainer.style.removeProperty("visibility"),n.calendarContainer.style.removeProperty("display")}}))}function o(e){if(0===n.selectedDates.length){const e=void 0===n.config.minDate||(0,d.compareDates)(new Date,n.config.minDate)>=0?new Date:new Date(n.config.minDate.getTime()),t=(0,d.getDefaultHours)(n.config);e.setHours(t.hours,t.minutes,t.seconds,e.getMilliseconds()),n.selectedDates=[e],n.latestSelectedDateObj=e}void 0!==e&&"blur"!==e.type&&function(e){e.preventDefault();const t="keydown"===e.type,a=(0,s.getEventTarget)(e),i=a;void 0!==n.amPM&&a===n.amPM&&(n.amPM.textContent=n.l10n.amPM[(0,c.int)(n.amPM.textContent===n.l10n.amPM[0])]);const o=parseFloat(i.getAttribute("min")),r=parseFloat(i.getAttribute("max")),l=parseFloat(i.getAttribute("step")),d=parseInt(i.value,10),f=e.delta||(t?38===e.which?1:-1:0);let m=d+l*f;if(void 0!==i.value&&2===i.value.length){const e=i===n.hourElement,t=i===n.minuteElement;m<o?(m=r+m+(0,c.int)(!e)+((0,c.int)(e)&&(0,c.int)(!n.amPM)),t&&M(void 0,-1,n.hourElement)):m>r&&(m=i===n.hourElement?m-r-(0,c.int)(!n.amPM):o,t&&M(void 0,1,n.hourElement)),n.amPM&&e&&(1===l?m+d===23:Math.abs(m-d)>l)&&(n.amPM.textContent=n.l10n.amPM[(0,c.int)(n.amPM.textContent===n.l10n.amPM[0])]),i.value=(0,c.pad)(m)}}(e);const t=n._input.value;m(),ie(),n._input.value!==t&&n._debouncedChange()}function m(){if(void 0===n.hourElement||void 0===n.minuteElement)return;let e=(parseInt(n.hourElement.value.slice(-2),10)||0)%24,t=(parseInt(n.minuteElement.value,10)||0)%60,a=void 0!==n.secondElement?(parseInt(n.secondElement.value,10)||0)%60:0;var i,o;void 0!==n.amPM&&(i=e,o=n.amPM.textContent,e=i%12+12*(0,c.int)(o===n.l10n.amPM[1]));const r=void 0!==n.config.minTime||n.config.minDate&&n.minDateHasTime&&n.latestSelectedDateObj&&0===(0,d.compareDates)(n.latestSelectedDateObj,n.config.minDate,!0);if(void 0!==n.config.maxTime||n.config.maxDate&&n.maxDateHasTime&&n.latestSelectedDateObj&&0===(0,d.compareDates)(n.latestSelectedDateObj,n.config.maxDate,!0)){const i=void 0!==n.config.maxTime?n.config.maxTime:n.config.maxDate;e=Math.min(e,i.getHours()),e===i.getHours()&&(t=Math.min(t,i.getMinutes())),t===i.getMinutes()&&(a=Math.min(a,i.getSeconds()))}if(r){const i=void 0!==n.config.minTime?n.config.minTime:n.config.minDate;e=Math.max(e,i.getHours()),e===i.getHours()&&t<i.getMinutes()&&(t=i.getMinutes()),t===i.getMinutes()&&(a=Math.max(a,i.getSeconds()))}p(e,t,a)}function u(e){const t=e||n.latestSelectedDateObj;t&&p(t.getHours(),t.getMinutes(),t.getSeconds())}function p(e,t,a){void 0!==n.latestSelectedDateObj&&n.latestSelectedDateObj.setHours(e%24,t,a||0,0),n.hourElement&&n.minuteElement&&!n.isMobile&&(n.hourElement.value=(0,c.pad)(n.config.time_24hr?e:(12+e)%12+12*(0,c.int)(e%12==0)),n.minuteElement.value=(0,c.pad)(t),void 0!==n.amPM&&(n.amPM.textContent=n.l10n.amPM[(0,c.int)(e>=12)]),void 0!==n.secondElement&&(n.secondElement.value=(0,c.pad)(a)))}function h(e){const t=(0,s.getEventTarget)(e),n=parseInt(t.value)+(e.delta||0);(n/1e3>1||"Enter"===e.key&&!/[^\d]/.test(n.toString()))&&j(n)}function D(e,t,a,i){return t instanceof Array?t.forEach((t=>D(e,t,a,i))):e instanceof Array?e.forEach((e=>D(e,t,a,i))):(e.addEventListener(t,a,i),void n._handlers.push({remove:()=>e.removeEventListener(t,a)}))}function v(){Z("onChange")}function b(e,t){const a=void 0!==e?n.parseDate(e):n.latestSelectedDateObj||(n.config.minDate&&n.config.minDate>n.now?n.config.minDate:n.config.maxDate&&n.config.maxDate<n.now?n.config.maxDate:n.now),i=n.currentYear,o=n.currentMonth;try{void 0!==a&&(n.currentYear=a.getFullYear(),n.currentMonth=a.getMonth())}catch(e){e.message="Invalid date supplied: "+a,n.config.errorHandler(e)}t&&n.currentYear!==i&&(Z("onYearChange"),_()),!t||n.currentYear===i&&n.currentMonth===o||Z("onMonthChange"),n.redraw()}function C(e){const t=(0,s.getEventTarget)(e);~t.className.indexOf("arrow")&&M(e,t.classList.contains("arrowUp")?1:-1)}function M(e,t,n){const a=e&&(0,s.getEventTarget)(e),i=n||a&&a.parentNode&&a.parentNode.firstChild,o=ee("increment");o.delta=t,i&&i.dispatchEvent(o)}function y(e,t,a,i){const o=F(t,!0),r=(0,s.createElement)("span","flatpickr-day "+e,t.getDate().toString());return r.dateObj=t,r.$i=i,r.setAttribute("aria-label",n.formatDate(t,n.config.ariaDateFormat)),-1===e.indexOf("hidden")&&0===(0,d.compareDates)(t,n.now)&&(n.todayDateElem=r,r.classList.add("today"),r.setAttribute("aria-current","date")),o?(r.tabIndex=-1,te(t)&&(r.classList.add("selected"),n.selectedDateElem=r,"range"===n.config.mode&&((0,s.toggleClass)(r,"startRange",n.selectedDates[0]&&0===(0,d.compareDates)(t,n.selectedDates[0],!0)),(0,s.toggleClass)(r,"endRange",n.selectedDates[1]&&0===(0,d.compareDates)(t,n.selectedDates[1],!0)),"nextMonthDay"===e&&r.classList.add("inRange")))):r.classList.add("flatpickr-disabled"),"range"===n.config.mode&&function(e){return!("range"!==n.config.mode||n.selectedDates.length<2)&&((0,d.compareDates)(e,n.selectedDates[0])>=0&&(0,d.compareDates)(e,n.selectedDates[1])<=0)}(t)&&!te(t)&&r.classList.add("inRange"),n.weekNumbers&&1===n.config.showMonths&&"prevMonthDay"!==e&&a%7==1&&n.weekNumbers.insertAdjacentHTML("beforeend","<span class='flatpickr-day'>"+n.config.getWeek(t)+"</span>"),Z("onDayCreate",r),r}function w(e){e.focus(),"range"===n.config.mode&&$(e)}function E(e){const t=e>0?0:n.config.showMonths-1,a=e>0?n.config.showMonths:-1;for(let i=t;i!=a;i+=e){const t=n.daysContainer.children[i],a=e>0?0:t.children.length-1,o=e>0?t.children.length:-1;for(let n=a;n!=o;n+=e){const e=t.children[n];if(-1===e.className.indexOf("hidden")&&F(e.dateObj))return e}}}function x(e,t){const a=L(document.activeElement||document.body),i=void 0!==e?e:a?document.activeElement:void 0!==n.selectedDateElem&&L(n.selectedDateElem)?n.selectedDateElem:void 0!==n.todayDateElem&&L(n.todayDateElem)?n.todayDateElem:E(t>0?1:-1);void 0===i?n._input.focus():a?function(e,t){const a=-1===e.className.indexOf("Month")?e.dateObj.getMonth():n.currentMonth,i=t>0?n.config.showMonths:-1,o=t>0?1:-1;for(let r=a-n.currentMonth;r!=i;r+=o){const i=n.daysContainer.children[r],l=a-n.currentMonth===r?e.$i+t:t<0?i.children.length-1:0,c=i.children.length;for(let n=l;n>=0&&n<c&&n!=(t>0?c:-1);n+=o){const a=i.children[n];if(-1===a.className.indexOf("hidden")&&F(a.dateObj)&&Math.abs(e.$i-n)>=Math.abs(t))return w(a)}}n.changeMonth(o),x(E(o),0)}(i,t):w(i)}function T(e,t){const a=(new Date(e,t,1).getDay()-n.l10n.firstDayOfWeek+7)%7,i=n.utils.getDaysInMonth((t-1+12)%12,e),o=n.utils.getDaysInMonth(t,e),r=window.document.createDocumentFragment(),l=n.config.showMonths>1,c=l?"prevMonthDay hidden":"prevMonthDay",d=l?"nextMonthDay hidden":"nextMonthDay";let f=i+1-a,m=0;for(;f<=i;f++,m++)r.appendChild(y(c,new Date(e,t-1,f),f,m));for(f=1;f<=o;f++,m++)r.appendChild(y("",new Date(e,t,f),f,m));for(let i=o+1;i<=42-a&&(1===n.config.showMonths||m%7!=0);i++,m++)r.appendChild(y(d,new Date(e,t+1,i%o),i,m));const u=(0,s.createElement)("div","dayContainer");return u.appendChild(r),u}function k(){if(void 0===n.daysContainer)return;(0,s.clearNode)(n.daysContainer),n.weekNumbers&&(0,s.clearNode)(n.weekNumbers);const e=document.createDocumentFragment();for(let t=0;t<n.config.showMonths;t++){const a=new Date(n.currentYear,n.currentMonth,1);a.setMonth(n.currentMonth+t),e.appendChild(T(a.getFullYear(),a.getMonth()))}n.daysContainer.appendChild(e),n.days=n.daysContainer.firstChild,"range"===n.config.mode&&1===n.selectedDates.length&&$()}function _(){if(n.config.showMonths>1||"dropdown"!==n.config.monthSelectorType)return;const e=function(e){return!(void 0!==n.config.minDate&&n.currentYear===n.config.minDate.getFullYear()&&e<n.config.minDate.getMonth())&&!(void 0!==n.config.maxDate&&n.currentYear===n.config.maxDate.getFullYear()&&e>n.config.maxDate.getMonth())};n.monthsDropdownContainer.tabIndex=-1,n.monthsDropdownContainer.innerHTML="";for(let t=0;t<12;t++){if(!e(t))continue;const a=(0,s.createElement)("option","flatpickr-monthDropdown-month");a.value=new Date(n.currentYear,t).getMonth().toString(),a.textContent=(0,f.monthToStr)(t,n.config.shorthandCurrentMonth,n.l10n),a.tabIndex=-1,n.currentMonth===t&&(a.selected=!0),n.monthsDropdownContainer.appendChild(a)}}function O(){const e=(0,s.createElement)("div","flatpickr-month"),t=window.document.createDocumentFragment();let a;n.config.showMonths>1||"static"===n.config.monthSelectorType?a=(0,s.createElement)("span","cur-month"):(n.monthsDropdownContainer=(0,s.createElement)("select","flatpickr-monthDropdown-months"),n.monthsDropdownContainer.setAttribute("aria-label",n.l10n.monthAriaLabel),D(n.monthsDropdownContainer,"change",(e=>{const t=(0,s.getEventTarget)(e),a=parseInt(t.value,10);n.changeMonth(a-n.currentMonth),Z("onMonthChange")})),_(),a=n.monthsDropdownContainer);const i=(0,s.createNumberInput)("cur-year",{tabindex:"-1"}),o=i.getElementsByTagName("input")[0];o.setAttribute("aria-label",n.l10n.yearAriaLabel),n.config.minDate&&o.setAttribute("min",n.config.minDate.getFullYear().toString()),n.config.maxDate&&(o.setAttribute("max",n.config.maxDate.getFullYear().toString()),o.disabled=!!n.config.minDate&&n.config.minDate.getFullYear()===n.config.maxDate.getFullYear());const r=(0,s.createElement)("div","flatpickr-current-month");return r.appendChild(a),r.appendChild(i),t.appendChild(r),e.appendChild(t),{container:e,yearElement:o,monthElement:a}}function I(){(0,s.clearNode)(n.monthNav),n.monthNav.appendChild(n.prevMonthNav),n.config.showMonths&&(n.yearElements=[],n.monthElements=[]);for(let e=n.config.showMonths;e--;){const e=O();n.yearElements.push(e.yearElement),n.monthElements.push(e.monthElement),n.monthNav.appendChild(e.container)}n.monthNav.appendChild(n.nextMonthNav)}function N(){n.weekdayContainer?(0,s.clearNode)(n.weekdayContainer):n.weekdayContainer=(0,s.createElement)("div","flatpickr-weekdays");for(let e=n.config.showMonths;e--;){const e=(0,s.createElement)("div","flatpickr-weekdaycontainer");n.weekdayContainer.appendChild(e)}return S(),n.weekdayContainer}function S(){if(!n.weekdayContainer)return;const e=n.l10n.firstDayOfWeek;let t=[...n.l10n.weekdays.shorthand];e>0&&e<t.length&&(t=[...t.splice(e,t.length),...t.splice(0,e)]);for(let e=n.config.showMonths;e--;)n.weekdayContainer.children[e].innerHTML=`\n      <span class='flatpickr-weekday'>\n        ${t.join("</span><span class='flatpickr-weekday'>")}\n      </span>\n      `}function P(e,t=!0){const a=t?e:e-n.currentMonth;a<0&&!0===n._hidePrevMonthArrow||a>0&&!0===n._hideNextMonthArrow||(n.currentMonth+=a,(n.currentMonth<0||n.currentMonth>11)&&(n.currentYear+=n.currentMonth>11?1:-1,n.currentMonth=(n.currentMonth+12)%12,Z("onYearChange"),_()),k(),Z("onMonthChange"),ne())}function A(e){return!(!n.config.appendTo||!n.config.appendTo.contains(e))||n.calendarContainer.contains(e)}function Y(e){if(n.isOpen&&!n.config.inline){const t=(0,s.getEventTarget)(e),a=A(t),i=t===n.input||t===n.altInput||n.element.contains(t)||e.path&&e.path.indexOf&&(~e.path.indexOf(n.input)||~e.path.indexOf(n.altInput)),r="blur"===e.type?i&&e.relatedTarget&&!A(e.relatedTarget):!i&&!a&&!A(e.relatedTarget),l=!n.config.ignoredFocusElements.some((e=>e.contains(t)));r&&l&&(void 0!==n.timeContainer&&void 0!==n.minuteElement&&void 0!==n.hourElement&&""!==n.input.value&&void 0!==n.input.value&&o(),n.close(),n.config&&"range"===n.config.mode&&1===n.selectedDates.length&&(n.clear(!1),n.redraw()))}}function j(e){if(!e||n.config.minDate&&e<n.config.minDate.getFullYear()||n.config.maxDate&&e>n.config.maxDate.getFullYear())return;const t=e,a=n.currentYear!==t;n.currentYear=t||n.currentYear,n.config.maxDate&&n.currentYear===n.config.maxDate.getFullYear()?n.currentMonth=Math.min(n.config.maxDate.getMonth(),n.currentMonth):n.config.minDate&&n.currentYear===n.config.minDate.getFullYear()&&(n.currentMonth=Math.max(n.config.minDate.getMonth(),n.currentMonth)),a&&(n.redraw(),Z("onYearChange"),_())}function F(e,t=!0){var a;const i=n.parseDate(e,void 0,t);if(n.config.minDate&&i&&(0,d.compareDates)(i,n.config.minDate,void 0!==t?t:!n.minDateHasTime)<0||n.config.maxDate&&i&&(0,d.compareDates)(i,n.config.maxDate,void 0!==t?t:!n.maxDateHasTime)>0)return!1;if(!n.config.enable&&0===n.config.disable.length)return!0;if(void 0===i)return!1;const o=!!n.config.enable,r=null!==(a=n.config.enable)&&void 0!==a?a:n.config.disable;for(let e,t=0;t<r.length;t++){if(e=r[t],"function"==typeof e&&e(i))return o;if(e instanceof Date&&void 0!==i&&e.getTime()===i.getTime())return o;if("string"==typeof e){const t=n.parseDate(e,void 0,!0);return t&&t.getTime()===i.getTime()?o:!o}if("object"==typeof e&&void 0!==i&&e.from&&e.to&&i.getTime()>=e.from.getTime()&&i.getTime()<=e.to.getTime())return o}return!o}function L(e){return void 0!==n.daysContainer&&(-1===e.className.indexOf("hidden")&&-1===e.className.indexOf("flatpickr-disabled")&&n.daysContainer.contains(e))}function H(e){!(e.target===n._input)||!(n.selectedDates.length>0||n._input.value.length>0)||e.relatedTarget&&A(e.relatedTarget)||n.setDate(n._input.value,!0,e.target===n.altInput?n.config.altFormat:n.config.dateFormat)}function R(t){const a=(0,s.getEventTarget)(t),i=n.config.wrap?e.contains(a):a===n._input,r=n.config.allowInput,l=n.isOpen&&(!r||!i),c=n.config.inline&&i&&!r;if(13===t.keyCode&&i){if(r)return n.setDate(n._input.value,!0,a===n.altInput?n.config.altFormat:n.config.dateFormat),a.blur();n.open()}else if(A(a)||l||c){const e=!!n.timeContainer&&n.timeContainer.contains(a);switch(t.keyCode){case 13:e?(t.preventDefault(),o(),Q()):X(t);break;case 27:t.preventDefault(),Q();break;case 8:case 46:i&&!n.config.allowInput&&(t.preventDefault(),n.clear());break;case 37:case 39:if(e||i)n.hourElement&&n.hourElement.focus();else if(t.preventDefault(),void 0!==n.daysContainer&&(!1===r||document.activeElement&&L(document.activeElement))){const e=39===t.keyCode?1:-1;t.ctrlKey?(t.stopPropagation(),P(e),x(E(1),0)):x(void 0,e)}break;case 38:case 40:t.preventDefault();const l=40===t.keyCode?1:-1;n.daysContainer&&void 0!==a.$i||a===n.input||a===n.altInput?t.ctrlKey?(t.stopPropagation(),j(n.currentYear-l),x(E(1),0)):e||x(void 0,7*l):a===n.currentYearElement?j(n.currentYear-l):n.config.enableTime&&(!e&&n.hourElement&&n.hourElement.focus(),o(t),n._debouncedChange());break;case 9:if(e){const e=[n.hourElement,n.minuteElement,n.secondElement,n.amPM].concat(n.pluginElements).filter((e=>e)),i=e.indexOf(a);if(-1!==i){const a=e[i+(t.shiftKey?-1:1)];t.preventDefault(),(a||n._input).focus()}}else!n.config.noCalendar&&n.daysContainer&&n.daysContainer.contains(a)&&t.shiftKey&&(t.preventDefault(),n._input.focus())}}if(void 0!==n.amPM&&a===n.amPM)switch(t.key){case n.l10n.amPM[0].charAt(0):case n.l10n.amPM[0].charAt(0).toLowerCase():n.amPM.textContent=n.l10n.amPM[0],m(),ie();break;case n.l10n.amPM[1].charAt(0):case n.l10n.amPM[1].charAt(0).toLowerCase():n.amPM.textContent=n.l10n.amPM[1],m(),ie()}(i||A(a))&&Z("onKeyDown",t)}function $(e){if(1!==n.selectedDates.length||e&&(!e.classList.contains("flatpickr-day")||e.classList.contains("flatpickr-disabled")))return;const t=e?e.dateObj.getTime():n.days.firstElementChild.dateObj.getTime(),a=n.parseDate(n.selectedDates[0],void 0,!0).getTime(),i=Math.min(t,n.selectedDates[0].getTime()),o=Math.max(t,n.selectedDates[0].getTime());let r=!1,l=0,c=0;for(let e=i;e<o;e+=d.duration.DAY)F(new Date(e),!0)||(r=r||e>i&&e<o,e<a&&(!l||e>l)?l=e:e>a&&(!c||e<c)&&(c=e));for(let i=0;i<n.config.showMonths;i++){const o=n.daysContainer.children[i];for(let i=0,s=o.children.length;i<s;i++){const s=o.children[i],f=s.dateObj.getTime(),m=l>0&&f<l||c>0&&f>c;m?(s.classList.add("notAllowed"),["inRange","startRange","endRange"].forEach((e=>{s.classList.remove(e)}))):r&&!m||(["startRange","inRange","endRange","notAllowed"].forEach((e=>{s.classList.remove(e)})),void 0!==e&&(e.classList.add(t<=n.selectedDates[0].getTime()?"startRange":"endRange"),a<t&&f===a?s.classList.add("startRange"):a>t&&f===a&&s.classList.add("endRange"),f>=l&&(0===c||f<=c)&&(0,d.isBetween)(f,a,t)&&s.classList.add("inRange")))}}}function W(){!n.isOpen||n.config.static||n.config.inline||J()}function B(e){return t=>{const a=n.config[`_${e}Date`]=n.parseDate(t,n.config.dateFormat),i=n.config[`_${"min"===e?"max":"min"}Date`];void 0!==a&&(n["min"===e?"minDateHasTime":"maxDateHasTime"]=a.getHours()>0||a.getMinutes()>0||a.getSeconds()>0),n.selectedDates&&(n.selectedDates=n.selectedDates.filter((e=>F(e))),n.selectedDates.length||"min"!==e||u(a),ie()),n.daysContainer&&(U(),void 0!==a?n.currentYearElement[e]=a.getFullYear().toString():n.currentYearElement.removeAttribute(e),n.currentYearElement.disabled=!!i&&void 0!==a&&i.getFullYear()===a.getFullYear())}}function K(){return n.config.wrap?e.querySelector("[data-input]"):e}function q(){"object"!=typeof n.config.locale&&void 0===g.l10ns[n.config.locale]&&n.config.errorHandler(new Error(`flatpickr: invalid locale ${n.config.locale}`)),n.l10n=Object.assign(Object.assign({},g.l10ns.default),"object"==typeof n.config.locale?n.config.locale:"default"!==n.config.locale?g.l10ns[n.config.locale]:void 0),f.tokenRegex.K=`(${n.l10n.amPM[0]}|${n.l10n.amPM[1]}|${n.l10n.amPM[0].toLowerCase()}|${n.l10n.amPM[1].toLowerCase()})`;void 0===Object.assign(Object.assign({},t),JSON.parse(JSON.stringify(e.dataset||{}))).time_24hr&&void 0===g.defaultConfig.time_24hr&&(n.config.time_24hr=n.l10n.time_24hr),n.formatDate=(0,d.createDateFormatter)(n),n.parseDate=(0,d.createDateParser)({config:n.config,l10n:n.l10n})}function J(e){if("function"==typeof n.config.position)return void n.config.position(n,e);if(void 0===n.calendarContainer)return;Z("onPreCalendarPosition");const t=e||n._positionElement,a=Array.prototype.reduce.call(n.calendarContainer.children,((e,t)=>e+t.offsetHeight),0),i=n.calendarContainer.offsetWidth,o=n.config.position.split(" "),r=o[0],l=o.length>1?o[1]:null,c=t.getBoundingClientRect(),d=window.innerHeight-c.bottom,f="above"===r||"below"!==r&&d<a&&c.top>a,m=window.pageYOffset+c.top+(f?-a-2:t.offsetHeight+2);if((0,s.toggleClass)(n.calendarContainer,"arrowTop",!f),(0,s.toggleClass)(n.calendarContainer,"arrowBottom",f),n.config.inline)return;let u=window.pageXOffset+c.left,g=!1,p=!1;"center"===l?(u-=(i-c.width)/2,g=!0):"right"===l&&(u-=i-c.width,p=!0),(0,s.toggleClass)(n.calendarContainer,"arrowLeft",!g&&!p),(0,s.toggleClass)(n.calendarContainer,"arrowCenter",g),(0,s.toggleClass)(n.calendarContainer,"arrowRight",p);const h=window.document.body.offsetWidth-(window.pageXOffset+c.right),D=u+i>window.document.body.offsetWidth,v=h+i>window.document.body.offsetWidth;if((0,s.toggleClass)(n.calendarContainer,"rightMost",D),!n.config.static)if(n.calendarContainer.style.top=`${m}px`,D)if(v){const e=function(){let e=null;for(let t=0;t<document.styleSheets.length;t++){const n=document.styleSheets[t];try{n.cssRules}catch(e){continue}e=n;break}return null!=e?e:function(){const e=document.createElement("style");return document.head.appendChild(e),e.sheet}()}();if(void 0===e)return;const t=window.document.body.offsetWidth,a=Math.max(0,t/2-i/2),o=".flatpickr-calendar.centerMost:before",r=".flatpickr-calendar.centerMost:after",l=e.cssRules.length,d=`{left:${c.left}px;right:auto;}`;(0,s.toggleClass)(n.calendarContainer,"rightMost",!1),(0,s.toggleClass)(n.calendarContainer,"centerMost",!0),e.insertRule(`${o},${r}${d}`,l),n.calendarContainer.style.left=`${a}px`,n.calendarContainer.style.right="auto"}else n.calendarContainer.style.left="auto",n.calendarContainer.style.right=`${h}px`;else n.calendarContainer.style.left=`${u}px`,n.calendarContainer.style.right="auto"}function U(){n.config.noCalendar||n.isMobile||(_(),ne(),k())}function Q(){n._input.focus(),-1!==window.navigator.userAgent.indexOf("MSIE")||void 0!==navigator.msMaxTouchPoints?setTimeout(n.close,0):n.close()}function X(e){e.preventDefault(),e.stopPropagation();const t=(0,s.findParent)((0,s.getEventTarget)(e),(e=>e.classList&&e.classList.contains("flatpickr-day")&&!e.classList.contains("flatpickr-disabled")&&!e.classList.contains("notAllowed")));if(void 0===t)return;const a=t,i=n.latestSelectedDateObj=new Date(a.dateObj.getTime()),o=(i.getMonth()<n.currentMonth||i.getMonth()>n.currentMonth+n.config.showMonths-1)&&"range"!==n.config.mode;if(n.selectedDateElem=a,"single"===n.config.mode)n.selectedDates=[i];else if("multiple"===n.config.mode){const e=te(i);e?n.selectedDates.splice(parseInt(e),1):n.selectedDates.push(i)}else"range"===n.config.mode&&(2===n.selectedDates.length&&n.clear(!1,!1),n.latestSelectedDateObj=i,n.selectedDates.push(i),0!==(0,d.compareDates)(i,n.selectedDates[0],!0)&&n.selectedDates.sort(((e,t)=>e.getTime()-t.getTime())));if(m(),o){const e=n.currentYear!==i.getFullYear();n.currentYear=i.getFullYear(),n.currentMonth=i.getMonth(),e&&(Z("onYearChange"),_()),Z("onMonthChange")}if(ne(),k(),ie(),o||"range"===n.config.mode||1!==n.config.showMonths?void 0!==n.selectedDateElem&&void 0===n.hourElement&&n.selectedDateElem&&n.selectedDateElem.focus():w(a),void 0!==n.hourElement&&void 0!==n.hourElement&&n.hourElement.focus(),n.config.closeOnSelect){const e="single"===n.config.mode&&!n.config.enableTime,t="range"===n.config.mode&&2===n.selectedDates.length&&!n.config.enableTime;(e||t)&&Q()}v()}n.parseDate=(0,d.createDateParser)({config:n.config,l10n:n.l10n}),n._handlers=[],n.pluginElements=[],n.loadedPlugins=[],n._bind=D,n._setHoursFromDate=u,n._positionCalendar=J,n.changeMonth=P,n.changeYear=j,n.clear=function(e=!0,t=!0){n.input.value="",void 0!==n.altInput&&(n.altInput.value="");void 0!==n.mobileInput&&(n.mobileInput.value="");n.selectedDates=[],n.latestSelectedDateObj=void 0,!0===t&&(n.currentYear=n._initialDate.getFullYear(),n.currentMonth=n._initialDate.getMonth());if(!0===n.config.enableTime){const{hours:e,minutes:t,seconds:a}=(0,d.getDefaultHours)(n.config);p(e,t,a)}n.redraw(),e&&Z("onChange")},n.close=function(){n.isOpen=!1,n.isMobile||(void 0!==n.calendarContainer&&n.calendarContainer.classList.remove("open"),void 0!==n._input&&n._input.classList.remove("active"));Z("onClose")},n._createElement=s.createElement,n.destroy=function(){void 0!==n.config&&Z("onDestroy");for(let e=n._handlers.length;e--;)n._handlers[e].remove();if(n._handlers=[],n.mobileInput)n.mobileInput.parentNode&&n.mobileInput.parentNode.removeChild(n.mobileInput),n.mobileInput=void 0;else if(n.calendarContainer&&n.calendarContainer.parentNode)if(n.config.static&&n.calendarContainer.parentNode){const e=n.calendarContainer.parentNode;if(e.lastChild&&e.removeChild(e.lastChild),e.parentNode){for(;e.firstChild;)e.parentNode.insertBefore(e.firstChild,e);e.parentNode.removeChild(e)}}else n.calendarContainer.parentNode.removeChild(n.calendarContainer);n.altInput&&(n.input.type="text",n.altInput.parentNode&&n.altInput.parentNode.removeChild(n.altInput),delete n.altInput);n.input&&(n.input.type=n.input._type,n.input.classList.remove("flatpickr-input"),n.input.removeAttribute("readonly"));["_showTimeInput","latestSelectedDateObj","_hideNextMonthArrow","_hidePrevMonthArrow","__hideNextMonthArrow","__hidePrevMonthArrow","isMobile","isOpen","selectedDateElem","minDateHasTime","maxDateHasTime","days","daysContainer","_input","_positionElement","innerContainer","rContainer","monthNav","todayDateElem","calendarContainer","weekdayContainer","prevMonthNav","nextMonthNav","monthsDropdownContainer","currentMonthElement","currentYearElement","navigationCurrentMonth","selectedDateElem","config"].forEach((e=>{try{delete n[e]}catch(e){}}))},n.isEnabled=F,n.jumpToDate=b,n.open=function(e,t=n._positionElement){if(!0===n.isMobile){if(e){e.preventDefault();const t=(0,s.getEventTarget)(e);t&&t.blur()}return void 0!==n.mobileInput&&(n.mobileInput.focus(),n.mobileInput.click()),void Z("onOpen")}if(n._input.disabled||n.config.inline)return;const a=n.isOpen;n.isOpen=!0,a||(n.calendarContainer.classList.add("open"),n._input.classList.add("active"),Z("onOpen"),J(t));!0===n.config.enableTime&&!0===n.config.noCalendar&&(!1!==n.config.allowInput||void 0!==e&&n.timeContainer.contains(e.relatedTarget)||setTimeout((()=>n.hourElement.select()),50))},n.redraw=U,n.set=function(e,t){if(null!==e&&"object"==typeof e){Object.assign(n.config,e);for(const t in e)void 0!==z[t]&&z[t].forEach((e=>e()))}else n.config[e]=t,void 0!==z[e]?z[e].forEach((e=>e())):r.HOOKS.indexOf(e)>-1&&(n.config[e]=(0,c.arrayify)(t));n.redraw(),ie(!0)},n.setDate=function(e,t=!1,a=n.config.dateFormat){if(0!==e&&!e||e instanceof Array&&0===e.length)return n.clear(t);V(e,a),n.latestSelectedDateObj=n.selectedDates[n.selectedDates.length-1],n.redraw(),b(void 0,t),u(),0===n.selectedDates.length&&n.clear(!1);ie(t),t&&Z("onChange")},n.toggle=function(e){if(!0===n.isOpen)return n.close();n.open(e)};const z={locale:[q,S],showMonths:[I,i,N],minDate:[b],maxDate:[b],clickOpens:[()=>{!0===n.config.clickOpens?(D(n._input,"focus",n.open),D(n._input,"click",n.open)):(n._input.removeEventListener("focus",n.open),n._input.removeEventListener("click",n.open))}]};function V(e,t){let a=[];if(e instanceof Array)a=e.map((e=>n.parseDate(e,t)));else if(e instanceof Date||"number"==typeof e)a=[n.parseDate(e,t)];else if("string"==typeof e)switch(n.config.mode){case"single":case"time":a=[n.parseDate(e,t)];break;case"multiple":a=e.split(n.config.conjunction).map((e=>n.parseDate(e,t)));break;case"range":a=e.split(n.l10n.rangeSeparator).map((e=>n.parseDate(e,t)))}else n.config.errorHandler(new Error(`Invalid date supplied: ${JSON.stringify(e)}`));n.selectedDates=n.config.allowInvalidPreload?a:a.filter((e=>e instanceof Date&&F(e,!1))),"range"===n.config.mode&&n.selectedDates.sort(((e,t)=>e.getTime()-t.getTime()))}function G(e){return e.slice().map((e=>"string"==typeof e||"number"==typeof e||e instanceof Date?n.parseDate(e,void 0,!0):e&&"object"==typeof e&&e.from&&e.to?{from:n.parseDate(e.from,void 0),to:n.parseDate(e.to,void 0)}:e)).filter((e=>e))}function Z(e,t){if(void 0===n.config)return;const a=n.config[e];if(void 0!==a&&a.length>0)for(let e=0;a[e]&&e<a.length;e++)a[e](n.selectedDates,n.input.value,n,t);"onChange"===e&&(n.input.dispatchEvent(ee("change")),n.input.dispatchEvent(ee("input")))}function ee(e){const t=document.createEvent("Event");return t.initEvent(e,!0,!0),t}function te(e){for(let t=0;t<n.selectedDates.length;t++)if(0===(0,d.compareDates)(n.selectedDates[t],e))return""+t;return!1}function ne(){n.config.noCalendar||n.isMobile||!n.monthNav||(n.yearElements.forEach(((e,t)=>{const a=new Date(n.currentYear,n.currentMonth,1);a.setMonth(n.currentMonth+t),n.config.showMonths>1||"static"===n.config.monthSelectorType?n.monthElements[t].textContent=(0,f.monthToStr)(a.getMonth(),n.config.shorthandCurrentMonth,n.l10n)+" ":n.monthsDropdownContainer.value=a.getMonth().toString(),e.value=a.getFullYear().toString()})),n._hidePrevMonthArrow=void 0!==n.config.minDate&&(n.currentYear===n.config.minDate.getFullYear()?n.currentMonth<=n.config.minDate.getMonth():n.currentYear<n.config.minDate.getFullYear()),n._hideNextMonthArrow=void 0!==n.config.maxDate&&(n.currentYear===n.config.maxDate.getFullYear()?n.currentMonth+1>n.config.maxDate.getMonth():n.currentYear>n.config.maxDate.getFullYear()))}function ae(e){return n.selectedDates.map((t=>n.formatDate(t,e))).filter(((e,t,a)=>"range"!==n.config.mode||n.config.enableTime||a.indexOf(e)===t)).join("range"!==n.config.mode?n.config.conjunction:n.l10n.rangeSeparator)}function ie(e=!0){void 0!==n.mobileInput&&n.mobileFormatStr&&(n.mobileInput.value=void 0!==n.latestSelectedDateObj?n.formatDate(n.latestSelectedDateObj,n.mobileFormatStr):""),n.input.value=ae(n.config.dateFormat),void 0!==n.altInput&&(n.altInput.value=ae(n.config.altFormat)),!1!==e&&Z("onValueUpdate")}function oe(e){const t=(0,s.getEventTarget)(e),a=n.prevMonthNav.contains(t),i=n.nextMonthNav.contains(t);a||i?P(a?-1:1):n.yearElements.indexOf(t)>=0?t.select():t.classList.contains("arrowUp")?n.changeYear(n.currentYear+1):t.classList.contains("arrowDown")&&n.changeYear(n.currentYear-1)}return function(){n.element=n.input=e,n.isOpen=!1,function(){const i=["wrap","weekNumbers","allowInput","allowInvalidPreload","clickOpens","time_24hr","enableTime","noCalendar","altInput","shorthandCurrentMonth","inline","static","enableSeconds","disableMobile"],o=Object.assign(Object.assign({},JSON.parse(JSON.stringify(e.dataset||{}))),t),l={};n.config.parseDate=o.parseDate,n.config.formatDate=o.formatDate,Object.defineProperty(n.config,"enable",{get:()=>n.config._enable,set:e=>{n.config._enable=G(e)}}),Object.defineProperty(n.config,"disable",{get:()=>n.config._disable,set:e=>{n.config._disable=G(e)}});const s="time"===o.mode;if(!o.dateFormat&&(o.enableTime||s)){const e=g.defaultConfig.dateFormat||r.defaults.dateFormat;l.dateFormat=o.noCalendar||s?"H:i"+(o.enableSeconds?":S":""):e+" H:i"+(o.enableSeconds?":S":"")}if(o.altInput&&(o.enableTime||s)&&!o.altFormat){const e=g.defaultConfig.altFormat||r.defaults.altFormat;l.altFormat=o.noCalendar||s?"h:i"+(o.enableSeconds?":S K":" K"):e+` h:i${o.enableSeconds?":S":""} K`}Object.defineProperty(n.config,"minDate",{get:()=>n.config._minDate,set:B("min")}),Object.defineProperty(n.config,"maxDate",{get:()=>n.config._maxDate,set:B("max")});const d=e=>t=>{n.config["min"===e?"_minTime":"_maxTime"]=n.parseDate(t,"H:i:S")};Object.defineProperty(n.config,"minTime",{get:()=>n.config._minTime,set:d("min")}),Object.defineProperty(n.config,"maxTime",{get:()=>n.config._maxTime,set:d("max")}),"time"===o.mode&&(n.config.noCalendar=!0,n.config.enableTime=!0);Object.assign(n.config,l,o);for(let e=0;e<i.length;e++)n.config[i[e]]=!0===n.config[i[e]]||"true"===n.config[i[e]];r.HOOKS.filter((e=>void 0!==n.config[e])).forEach((e=>{n.config[e]=(0,c.arrayify)(n.config[e]||[]).map(a)})),n.isMobile=!n.config.disableMobile&&!n.config.inline&&"single"===n.config.mode&&!n.config.disable.length&&!n.config.enable&&!n.config.weekNumbers&&/Android|webOS|iPhone|iPad|iPod|BlackBerry|IEMobile|Opera Mini/i.test(navigator.userAgent);for(let e=0;e<n.config.plugins.length;e++){const t=n.config.plugins[e](n)||{};for(const e in t)r.HOOKS.indexOf(e)>-1?n.config[e]=(0,c.arrayify)(t[e]).map(a).concat(n.config[e]):void 0===o[e]&&(n.config[e]=t[e])}o.altInputClass||(n.config.altInputClass=K().className+" "+n.config.altInputClass);Z("onParseConfig")}(),q(),function(){if(n.input=K(),!n.input)return void n.config.errorHandler(new Error("Invalid input element specified"));n.input._type=n.input.type,n.input.type="text",n.input.classList.add("flatpickr-input"),n._input=n.input,n.config.altInput&&(n.altInput=(0,s.createElement)(n.input.nodeName,n.config.altInputClass),n._input=n.altInput,n.altInput.placeholder=n.input.placeholder,n.altInput.disabled=n.input.disabled,n.altInput.required=n.input.required,n.altInput.tabIndex=n.input.tabIndex,n.altInput.type="text",n.input.setAttribute("type","hidden"),!n.config.static&&n.input.parentNode&&n.input.parentNode.insertBefore(n.altInput,n.input.nextSibling));n.config.allowInput||n._input.setAttribute("readonly","readonly");n._positionElement=n.config.positionElement||n._input}(),function(){n.selectedDates=[],n.now=n.parseDate(n.config.now)||new Date;const e=n.config.defaultDate||("INPUT"!==n.input.nodeName&&"TEXTAREA"!==n.input.nodeName||!n.input.placeholder||n.input.value!==n.input.placeholder?n.input.value:null);e&&V(e,n.config.dateFormat);n._initialDate=n.selectedDates.length>0?n.selectedDates[0]:n.config.minDate&&n.config.minDate.getTime()>n.now.getTime()?n.config.minDate:n.config.maxDate&&n.config.maxDate.getTime()<n.now.getTime()?n.config.maxDate:n.now,n.currentYear=n._initialDate.getFullYear(),n.currentMonth=n._initialDate.getMonth(),n.selectedDates.length>0&&(n.latestSelectedDateObj=n.selectedDates[0]);void 0!==n.config.minTime&&(n.config.minTime=n.parseDate(n.config.minTime,"H:i"));void 0!==n.config.maxTime&&(n.config.maxTime=n.parseDate(n.config.maxTime,"H:i"));n.minDateHasTime=!!n.config.minDate&&(n.config.minDate.getHours()>0||n.config.minDate.getMinutes()>0||n.config.minDate.getSeconds()>0),n.maxDateHasTime=!!n.config.maxDate&&(n.config.maxDate.getHours()>0||n.config.maxDate.getMinutes()>0||n.config.maxDate.getSeconds()>0)}(),n.utils={getDaysInMonth:(e=n.currentMonth,t=n.currentYear)=>1===e&&(t%4==0&&t%100!=0||t%400==0)?29:n.l10n.daysInMonth[e]},n.isMobile||function(){const e=window.document.createDocumentFragment();if(n.calendarContainer=(0,s.createElement)("div","flatpickr-calendar"),n.calendarContainer.tabIndex=-1,!n.config.noCalendar){if(e.appendChild((n.monthNav=(0,s.createElement)("div","flatpickr-months"),n.yearElements=[],n.monthElements=[],n.prevMonthNav=(0,s.createElement)("span","flatpickr-prev-month"),n.prevMonthNav.innerHTML=n.config.prevArrow,n.nextMonthNav=(0,s.createElement)("span","flatpickr-next-month"),n.nextMonthNav.innerHTML=n.config.nextArrow,I(),Object.defineProperty(n,"_hidePrevMonthArrow",{get:()=>n.__hidePrevMonthArrow,set(e){n.__hidePrevMonthArrow!==e&&((0,s.toggleClass)(n.prevMonthNav,"flatpickr-disabled",e),n.__hidePrevMonthArrow=e)}}),Object.defineProperty(n,"_hideNextMonthArrow",{get:()=>n.__hideNextMonthArrow,set(e){n.__hideNextMonthArrow!==e&&((0,s.toggleClass)(n.nextMonthNav,"flatpickr-disabled",e),n.__hideNextMonthArrow=e)}}),n.currentYearElement=n.yearElements[0],ne(),n.monthNav)),n.innerContainer=(0,s.createElement)("div","flatpickr-innerContainer"),n.config.weekNumbers){const{weekWrapper:e,weekNumbers:t}=function(){n.calendarContainer.classList.add("hasWeeks");const e=(0,s.createElement)("div","flatpickr-weekwrapper");e.appendChild((0,s.createElement)("span","flatpickr-weekday",n.l10n.weekAbbreviation));const t=(0,s.createElement)("div","flatpickr-weeks");return e.appendChild(t),{weekWrapper:e,weekNumbers:t}}();n.innerContainer.appendChild(e),n.weekNumbers=t,n.weekWrapper=e}n.rContainer=(0,s.createElement)("div","flatpickr-rContainer"),n.rContainer.appendChild(N()),n.daysContainer||(n.daysContainer=(0,s.createElement)("div","flatpickr-days"),n.daysContainer.tabIndex=-1),k(),n.rContainer.appendChild(n.daysContainer),n.innerContainer.appendChild(n.rContainer),e.appendChild(n.innerContainer)}n.config.enableTime&&e.appendChild(function(){n.calendarContainer.classList.add("hasTime"),n.config.noCalendar&&n.calendarContainer.classList.add("noCalendar");const e=(0,d.getDefaultHours)(n.config);n.timeContainer=(0,s.createElement)("div","flatpickr-time"),n.timeContainer.tabIndex=-1;const t=(0,s.createElement)("span","flatpickr-time-separator",":"),a=(0,s.createNumberInput)("flatpickr-hour",{"aria-label":n.l10n.hourAriaLabel});n.hourElement=a.getElementsByTagName("input")[0];const i=(0,s.createNumberInput)("flatpickr-minute",{"aria-label":n.l10n.minuteAriaLabel});n.minuteElement=i.getElementsByTagName("input")[0],n.hourElement.tabIndex=n.minuteElement.tabIndex=-1,n.hourElement.value=(0,c.pad)(n.latestSelectedDateObj?n.latestSelectedDateObj.getHours():n.config.time_24hr?e.hours:function(e){switch(e%24){case 0:case 12:return 12;default:return e%12}}(e.hours)),n.minuteElement.value=(0,c.pad)(n.latestSelectedDateObj?n.latestSelectedDateObj.getMinutes():e.minutes),n.hourElement.setAttribute("step",n.config.hourIncrement.toString()),n.minuteElement.setAttribute("step",n.config.minuteIncrement.toString()),n.hourElement.setAttribute("min",n.config.time_24hr?"0":"1"),n.hourElement.setAttribute("max",n.config.time_24hr?"23":"12"),n.hourElement.setAttribute("maxlength","2"),n.minuteElement.setAttribute("min","0"),n.minuteElement.setAttribute("max","59"),n.minuteElement.setAttribute("maxlength","2"),n.timeContainer.appendChild(a),n.timeContainer.appendChild(t),n.timeContainer.appendChild(i),n.config.time_24hr&&n.timeContainer.classList.add("time24hr");if(n.config.enableSeconds){n.timeContainer.classList.add("hasSeconds");const t=(0,s.createNumberInput)("flatpickr-second");n.secondElement=t.getElementsByTagName("input")[0],n.secondElement.value=(0,c.pad)(n.latestSelectedDateObj?n.latestSelectedDateObj.getSeconds():e.seconds),n.secondElement.setAttribute("step",n.minuteElement.getAttribute("step")),n.secondElement.setAttribute("min","0"),n.secondElement.setAttribute("max","59"),n.secondElement.setAttribute("maxlength","2"),n.timeContainer.appendChild((0,s.createElement)("span","flatpickr-time-separator",":")),n.timeContainer.appendChild(t)}n.config.time_24hr||(n.amPM=(0,s.createElement)("span","flatpickr-am-pm",n.l10n.amPM[(0,c.int)((n.latestSelectedDateObj?n.hourElement.value:n.config.defaultHour)>11)]),n.amPM.title=n.l10n.toggleTitle,n.amPM.tabIndex=-1,n.timeContainer.appendChild(n.amPM));return n.timeContainer}());(0,s.toggleClass)(n.calendarContainer,"rangeMode","range"===n.config.mode),(0,s.toggleClass)(n.calendarContainer,"animate",!0===n.config.animate),(0,s.toggleClass)(n.calendarContainer,"multiMonth",n.config.showMonths>1),n.calendarContainer.appendChild(e);const t=void 0!==n.config.appendTo&&void 0!==n.config.appendTo.nodeType;if((n.config.inline||n.config.static)&&(n.calendarContainer.classList.add(n.config.inline?"inline":"static"),n.config.inline&&(!t&&n.element.parentNode?n.element.parentNode.insertBefore(n.calendarContainer,n._input.nextSibling):void 0!==n.config.appendTo&&n.config.appendTo.appendChild(n.calendarContainer)),n.config.static)){const e=(0,s.createElement)("div","flatpickr-wrapper");n.element.parentNode&&n.element.parentNode.insertBefore(e,n.element),e.appendChild(n.element),n.altInput&&e.appendChild(n.altInput),e.appendChild(n.calendarContainer)}n.config.static||n.config.inline||(void 0!==n.config.appendTo?n.config.appendTo:window.document.body).appendChild(n.calendarContainer)}(),function(){n.config.wrap&&["open","close","toggle","clear"].forEach((e=>{Array.prototype.forEach.call(n.element.querySelectorAll(`[data-${e}]`),(t=>D(t,"click",n[e])))}));if(n.isMobile)return void function(){const e=n.config.enableTime?n.config.noCalendar?"time":"datetime-local":"date";n.mobileInput=(0,s.createElement)("input",n.input.className+" flatpickr-mobile"),n.mobileInput.tabIndex=1,n.mobileInput.type=e,n.mobileInput.disabled=n.input.disabled,n.mobileInput.required=n.input.required,n.mobileInput.placeholder=n.input.placeholder,n.mobileFormatStr="datetime-local"===e?"Y-m-d\\TH:i:S":"date"===e?"Y-m-d":"H:i:S",n.selectedDates.length>0&&(n.mobileInput.defaultValue=n.mobileInput.value=n.formatDate(n.selectedDates[0],n.mobileFormatStr));n.config.minDate&&(n.mobileInput.min=n.formatDate(n.config.minDate,"Y-m-d"));n.config.maxDate&&(n.mobileInput.max=n.formatDate(n.config.maxDate,"Y-m-d"));n.input.getAttribute("step")&&(n.mobileInput.step=String(n.input.getAttribute("step")));n.input.type="hidden",void 0!==n.altInput&&(n.altInput.type="hidden");try{n.input.parentNode&&n.input.parentNode.insertBefore(n.mobileInput,n.input.nextSibling)}catch(e){}D(n.mobileInput,"change",(e=>{n.setDate((0,s.getEventTarget)(e).value,!1,n.mobileFormatStr),Z("onChange"),Z("onClose")}))}();const e=(0,c.debounce)(W,50);n._debouncedChange=(0,c.debounce)(v,300),n.daysContainer&&!/iPhone|iPad|iPod/i.test(navigator.userAgent)&&D(n.daysContainer,"mouseover",(e=>{"range"===n.config.mode&&$((0,s.getEventTarget)(e))}));D(window.document.body,"keydown",R),n.config.inline||n.config.static||D(window,"resize",e);void 0!==window.ontouchstart?D(window.document,"touchstart",Y):D(window.document,"mousedown",Y);D(window.document,"focus",Y,{capture:!0}),!0===n.config.clickOpens&&(D(n._input,"focus",n.open),D(n._input,"click",n.open));void 0!==n.daysContainer&&(D(n.monthNav,"click",oe),D(n.monthNav,["keyup","increment"],h),D(n.daysContainer,"click",X));if(void 0!==n.timeContainer&&void 0!==n.minuteElement&&void 0!==n.hourElement){const e=e=>(0,s.getEventTarget)(e).select();D(n.timeContainer,["increment"],o),D(n.timeContainer,"blur",o,{capture:!0}),D(n.timeContainer,"click",C),D([n.hourElement,n.minuteElement],["focus","click"],e),void 0!==n.secondElement&&D(n.secondElement,"focus",(()=>n.secondElement&&n.secondElement.select())),void 0!==n.amPM&&D(n.amPM,"click",(e=>{o(e),v()}))}n.config.allowInput&&D(n._input,"blur",H)}(),(n.selectedDates.length||n.config.noCalendar)&&(n.config.enableTime&&u(n.config.noCalendar?n.latestSelectedDateObj:void 0),ie(!1)),i();const l=/^((?!chrome|android).)*safari/i.test(navigator.userAgent);!n.isMobile&&l&&J(),Z("onReady")}(),n}function u(e,t){const n=Array.prototype.slice.call(e).filter((e=>e instanceof HTMLElement)),a=[];for(let e=0;e<n.length;e++){const i=n[e];try{if(null!==i.getAttribute("data-fp-omit"))continue;void 0!==i._flatpickr&&(i._flatpickr.destroy(),i._flatpickr=void 0),i._flatpickr=m(i,t||{}),a.push(i._flatpickr)}catch(e){console.error(e)}}return 1===a.length?a[0]:a}"undefined"!=typeof HTMLElement&&"undefined"!=typeof HTMLCollection&&"undefined"!=typeof NodeList&&(HTMLCollection.prototype.flatpickr=NodeList.prototype.flatpickr=function(e){return u(this,e)},HTMLElement.prototype.flatpickr=function(e){return u([this],e)});var g=function(e,t){return"string"==typeof e?u(window.document.querySelectorAll(e),t):e instanceof Node?u([e],t):u(e,t)};g.defaultConfig={},g.l10ns={en:Object.assign({},l.default),default:Object.assign({},l.default)},g.localize=e=>{g.l10ns.default=Object.assign(Object.assign({},g.l10ns.default),e)},g.setDefaults=e=>{g.defaultConfig=Object.assign(Object.assign({},g.defaultConfig),e)},g.parseDate=(0,d.createDateParser)({}),g.formatDate=(0,d.createDateFormatter)({}),g.compareDates=d.compareDates,"undefined"!=typeof jQuery&&void 0!==jQuery.fn&&(jQuery.fn.flatpickr=function(e){return u(this,e)}),Date.prototype.fp_incr=function(e){return new Date(this.getFullYear(),this.getMonth(),this.getDate()+("string"==typeof e?parseInt(e,10):e))},"undefined"!=typeof window&&(window.flatpickr=g),n.default=g},
490: function _(e,n,o,t,a){t(),o.HOOKS=["onChange","onClose","onDayCreate","onDestroy","onKeyDown","onMonthChange","onOpen","onParseConfig","onReady","onValueUpdate","onYearChange","onPreCalendarPosition"],o.defaults={_disable:[],allowInput:!1,allowInvalidPreload:!1,altFormat:"F j, Y",altInput:!1,altInputClass:"form-control input",animate:"object"==typeof window&&-1===window.navigator.userAgent.indexOf("MSIE"),ariaDateFormat:"F j, Y",autoFillDefaultTime:!0,clickOpens:!0,closeOnSelect:!0,conjunction:", ",dateFormat:"Y-m-d",defaultHour:12,defaultMinute:0,defaultSeconds:0,disable:[],disableMobile:!1,enableSeconds:!1,enableTime:!1,errorHandler:e=>"undefined"!=typeof console&&console.warn(e),getWeek:e=>{const n=new Date(e.getTime());n.setHours(0,0,0,0),n.setDate(n.getDate()+3-(n.getDay()+6)%7);var o=new Date(n.getFullYear(),0,4);return 1+Math.round(((n.getTime()-o.getTime())/864e5-3+(o.getDay()+6)%7)/7)},hourIncrement:1,ignoredFocusElements:[],inline:!1,locale:"default",minuteIncrement:5,mode:"single",monthSelectorType:"dropdown",nextArrow:"<svg version='1.1' xmlns='http://www.w3.org/2000/svg' xmlns:xlink='http://www.w3.org/1999/xlink' viewBox='0 0 17 17'><g></g><path d='M13.207 8.472l-7.854 7.854-0.707-0.707 7.146-7.146-7.146-7.148 0.707-0.707 7.854 7.854z' /></svg>",noCalendar:!1,now:new Date,onChange:[],onClose:[],onDayCreate:[],onDestroy:[],onKeyDown:[],onMonthChange:[],onOpen:[],onParseConfig:[],onReady:[],onValueUpdate:[],onYearChange:[],onPreCalendarPosition:[],plugins:[],position:"auto",positionElement:void 0,prevArrow:"<svg version='1.1' xmlns='http://www.w3.org/2000/svg' xmlns:xlink='http://www.w3.org/1999/xlink' viewBox='0 0 17 17'><g></g><path d='M5.207 8.471l7.146 7.147-0.707 0.707-7.853-7.854 7.854-7.853 0.707 0.707-7.147 7.146z' /></svg>",shorthandCurrentMonth:!1,showMonths:1,static:!1,time_24hr:!1,weekNumbers:!1,wrap:!1}},
491: function _(e,r,a,t,n){t(),a.english={weekdays:{shorthand:["Sun","Mon","Tue","Wed","Thu","Fri","Sat"],longhand:["Sunday","Monday","Tuesday","Wednesday","Thursday","Friday","Saturday"]},months:{shorthand:["Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec"],longhand:["January","February","March","April","May","June","July","August","September","October","November","December"]},daysInMonth:[31,28,31,30,31,30,31,31,30,31,30,31],firstDayOfWeek:0,ordinal:e=>{const r=e%100;if(r>3&&r<21)return"th";switch(r%10){case 1:return"st";case 2:return"nd";case 3:return"rd";default:return"th"}},rangeSeparator:" to ",weekAbbreviation:"Wk",scrollTitle:"Scroll to increment",toggleTitle:"Click to toggle",amPM:["AM","PM"],yearAriaLabel:"Year",monthAriaLabel:"Month",hourAriaLabel:"Hour",minuteAriaLabel:"Minute",time_24hr:!1},a.default=a.english},
492: function _(n,t,e,i,a){i();e.pad=(n,t=2)=>`000${n}`.slice(-1*t);e.int=n=>!0===n?1:0,e.debounce=function(n,t){let e;return function(){clearTimeout(e),e=setTimeout((()=>n.apply(this,arguments)),t)}};e.arrayify=n=>n instanceof Array?n:[n]},
493: function _(t,e,n,r,o){function i(t,e,n){const r=window.document.createElement(t);return e=e||"",n=n||"",r.className=e,void 0!==n&&(r.textContent=n),r}r(),n.toggleClass=function(t,e,n){if(!0===n)return t.classList.add(e);t.classList.remove(e)},n.createElement=i,n.clearNode=function(t){for(;t.firstChild;)t.removeChild(t.firstChild)},n.findParent=function t(e,n){return n(e)?e:e.parentNode?t(e.parentNode,n):void 0},n.createNumberInput=function(t,e){const n=i("div","numInputWrapper"),r=i("input","numInput "+t),o=i("span","arrowUp"),a=i("span","arrowDown");if(-1===navigator.userAgent.indexOf("MSIE 9.0")?r.type="number":(r.type="text",r.pattern="\\d*"),void 0!==e)for(const t in e)r.setAttribute(t,e[t]);return n.appendChild(r),n.appendChild(o),n.appendChild(a),n},n.getEventTarget=function(t){try{if("function"==typeof t.composedPath){return t.composedPath()[0]}return t.target}catch(e){return t.target}}},
494: function _(e,t,n,a,s){a();const o=e(495),i=e(490),r=e(491);n.createDateFormatter=({config:e=i.defaults,l10n:t=r.english,isMobile:n=!1})=>(a,s,i)=>{const r=i||t;return void 0===e.formatDate||n?s.split("").map(((t,n,s)=>o.formats[t]&&"\\"!==s[n-1]?o.formats[t](a,r,e):"\\"!==t?t:"")).join(""):e.formatDate(a,s,r)};n.createDateParser=({config:e=i.defaults,l10n:t=r.english})=>(n,a,s,r)=>{if(0!==n&&!n)return;const u=r||t;let f;const g=n;if(n instanceof Date)f=new Date(n.getTime());else if("string"!=typeof n&&void 0!==n.toFixed)f=new Date(n);else if("string"==typeof n){const t=a||(e||i.defaults).dateFormat,r=String(n).trim();if("today"===r)f=new Date,s=!0;else if(/Z$/.test(r)||/GMT$/.test(r))f=new Date(n);else if(e&&e.parseDate)f=e.parseDate(n,t);else{f=e&&e.noCalendar?new Date((new Date).setHours(0,0,0,0)):new Date((new Date).getFullYear(),0,1,0,0,0,0);let a,s=[];for(let e=0,i=0,r="";e<t.length;e++){const g=t[e],m="\\"===g,l="\\"===t[e-1]||m;if(o.tokenRegex[g]&&!l){r+=o.tokenRegex[g];const e=new RegExp(r).exec(n);e&&(a=!0)&&s["Y"!==g?"push":"unshift"]({fn:o.revFormat[g],val:e[++i]})}else m||(r+=".");s.forEach((({fn:e,val:t})=>f=e(f,t,u)||f))}f=a?f:void 0}}if(f instanceof Date&&!isNaN(f.getTime()))return!0===s&&f.setHours(0,0,0,0),f;e.errorHandler(new Error(`Invalid date provided: ${g}`))},n.compareDates=function(e,t,n=!0){return!1!==n?new Date(e.getTime()).setHours(0,0,0,0)-new Date(t.getTime()).setHours(0,0,0,0):e.getTime()-t.getTime()},n.compareTimes=function(e,t){return 3600*(e.getHours()-t.getHours())+60*(e.getMinutes()-t.getMinutes())+e.getSeconds()-t.getSeconds()};n.isBetween=(e,t,n)=>e>Math.min(t,n)&&e<Math.max(t,n),n.duration={DAY:864e5},n.getDefaultHours=function(e){let t=e.defaultHour,n=e.defaultMinute,a=e.defaultSeconds;if(void 0!==e.minDate){const s=e.minDate.getHours(),o=e.minDate.getMinutes(),i=e.minDate.getSeconds();t<s&&(t=s),t===s&&n<o&&(n=o),t===s&&n===o&&a<i&&(a=e.minDate.getSeconds())}if(void 0!==e.maxDate){const s=e.maxDate.getHours(),o=e.maxDate.getMinutes();t=Math.min(t,s),t===s&&(n=Math.min(o,n)),t===s&&n===o&&(a=e.maxDate.getSeconds())}return{hours:t,minutes:n,seconds:a}}},
495: function _(t,e,n,a,o){a();const s=t(492),d=()=>{};n.monthToStr=(t,e,n)=>n.months[e?"shorthand":"longhand"][t],n.revFormat={D:d,F:function(t,e,n){t.setMonth(n.months.longhand.indexOf(e))},G:(t,e)=>{t.setHours(parseFloat(e))},H:(t,e)=>{t.setHours(parseFloat(e))},J:(t,e)=>{t.setDate(parseFloat(e))},K:(t,e,n)=>{t.setHours(t.getHours()%12+12*(0,s.int)(new RegExp(n.amPM[1],"i").test(e)))},M:function(t,e,n){t.setMonth(n.months.shorthand.indexOf(e))},S:(t,e)=>{t.setSeconds(parseFloat(e))},U:(t,e)=>new Date(1e3*parseFloat(e)),W:function(t,e,n){const a=parseInt(e),o=new Date(t.getFullYear(),0,2+7*(a-1),0,0,0,0);return o.setDate(o.getDate()-o.getDay()+n.firstDayOfWeek),o},Y:(t,e)=>{t.setFullYear(parseFloat(e))},Z:(t,e)=>new Date(e),d:(t,e)=>{t.setDate(parseFloat(e))},h:(t,e)=>{t.setHours(parseFloat(e))},i:(t,e)=>{t.setMinutes(parseFloat(e))},j:(t,e)=>{t.setDate(parseFloat(e))},l:d,m:(t,e)=>{t.setMonth(parseFloat(e)-1)},n:(t,e)=>{t.setMonth(parseFloat(e)-1)},s:(t,e)=>{t.setSeconds(parseFloat(e))},u:(t,e)=>new Date(parseFloat(e)),w:d,y:(t,e)=>{t.setFullYear(2e3+parseFloat(e))}},n.tokenRegex={D:"(\\w+)",F:"(\\w+)",G:"(\\d\\d|\\d)",H:"(\\d\\d|\\d)",J:"(\\d\\d|\\d)\\w+",K:"",M:"(\\w+)",S:"(\\d\\d|\\d)",U:"(.+)",W:"(\\d\\d|\\d)",Y:"(\\d{4})",Z:"(.+)",d:"(\\d\\d|\\d)",h:"(\\d\\d|\\d)",i:"(\\d\\d|\\d)",j:"(\\d\\d|\\d)",l:"(\\w+)",m:"(\\d\\d|\\d)",n:"(\\d\\d|\\d)",s:"(\\d\\d|\\d)",u:"(.+)",w:"(\\d\\d|\\d)",y:"(\\d{2})"},n.formats={Z:t=>t.toISOString(),D:function(t,e,a){return e.weekdays.shorthand[n.formats.w(t,e,a)]},F:function(t,e,a){return(0,n.monthToStr)(n.formats.n(t,e,a)-1,!1,e)},G:function(t,e,a){return(0,s.pad)(n.formats.h(t,e,a))},H:t=>(0,s.pad)(t.getHours()),J:function(t,e){return void 0!==e.ordinal?t.getDate()+e.ordinal(t.getDate()):t.getDate()},K:(t,e)=>e.amPM[(0,s.int)(t.getHours()>11)],M:function(t,e){return(0,n.monthToStr)(t.getMonth(),!0,e)},S:t=>(0,s.pad)(t.getSeconds()),U:t=>t.getTime()/1e3,W:function(t,e,n){return n.getWeek(t)},Y:t=>(0,s.pad)(t.getFullYear(),4),d:t=>(0,s.pad)(t.getDate()),h:t=>t.getHours()%12?t.getHours()%12:12,i:t=>(0,s.pad)(t.getMinutes()),j:t=>t.getDate(),l:function(t,e){return e.weekdays.longhand[t.getDay()]},m:t=>(0,s.pad)(t.getMonth()+1),n:t=>t.getMonth()+1,s:t=>t.getSeconds(),u:t=>t.getTime(),w:t=>t.getDay(),y:t=>String(t.getFullYear()).substring(2)}},
496: function _(n,o,t,e,c){"function"!=typeof Object.assign&&(Object.assign=function(n,...o){if(!n)throw TypeError("Cannot convert undefined or null to object");for(const t of o)t&&Object.keys(t).forEach((o=>n[o]=t[o]));return n})},
497: function _(t,e,a,r,i){r(),a.default='.flatpickr-calendar{background:transparent;opacity:0;display:none;text-align:center;visibility:hidden;padding:0;-webkit-animation:none;animation:none;direction:ltr;border:0;font-size:14px;line-height:24px;border-radius:5px;position:absolute;width:307.875px;-webkit-box-sizing:border-box;box-sizing:border-box;-ms-touch-action:manipulation;touch-action:manipulation;background:#fff;-webkit-box-shadow:1px 0 0 #e6e6e6, -1px 0 0 #e6e6e6, 0 1px 0 #e6e6e6, 0 -1px 0 #e6e6e6, 0 3px 13px rgba(0, 0, 0, 0.08);box-shadow:1px 0 0 #e6e6e6, -1px 0 0 #e6e6e6, 0 1px 0 #e6e6e6, 0 -1px 0 #e6e6e6, 0 3px 13px rgba(0, 0, 0, 0.08);}.flatpickr-calendar.open,.flatpickr-calendar.inline{opacity:1;max-height:640px;visibility:visible;}.flatpickr-calendar.open{display:inline-block;z-index:99999;}.flatpickr-calendar.animate.open{-webkit-animation:fpFadeInDown 300ms cubic-bezier(0.23, 1, 0.32, 1);animation:fpFadeInDown 300ms cubic-bezier(0.23, 1, 0.32, 1);}.flatpickr-calendar.inline{display:block;position:relative;top:2px;}.flatpickr-calendar.static{position:absolute;top:calc(100% + 2px);}.flatpickr-calendar.static.open{z-index:999;display:block;}.flatpickr-calendar.multiMonth .flatpickr-days .dayContainer:nth-child(n+1) .flatpickr-day.inRange:nth-child(7n+7){-webkit-box-shadow:none !important;box-shadow:none !important;}.flatpickr-calendar.multiMonth .flatpickr-days .dayContainer:nth-child(n+2) .flatpickr-day.inRange:nth-child(7n+1){-webkit-box-shadow:-2px 0 0 #e6e6e6, 5px 0 0 #e6e6e6;box-shadow:-2px 0 0 #e6e6e6, 5px 0 0 #e6e6e6;}.flatpickr-calendar .hasWeeks .dayContainer,.flatpickr-calendar .hasTime .dayContainer{border-bottom:0;border-bottom-right-radius:0;border-bottom-left-radius:0;}.flatpickr-calendar .hasWeeks .dayContainer{border-left:0;}.flatpickr-calendar.hasTime .flatpickr-time{height:40px;border-top:1px solid #e6e6e6;}.flatpickr-calendar.noCalendar.hasTime .flatpickr-time{height:auto;}.flatpickr-calendar:before,.flatpickr-calendar:after{position:absolute;display:block;pointer-events:none;border:solid transparent;content:\'\';height:0;width:0;left:22px;}.flatpickr-calendar.rightMost:before,.flatpickr-calendar.arrowRight:before,.flatpickr-calendar.rightMost:after,.flatpickr-calendar.arrowRight:after{left:auto;right:22px;}.flatpickr-calendar.arrowCenter:before,.flatpickr-calendar.arrowCenter:after{left:50%;right:50%;}.flatpickr-calendar:before{border-width:5px;margin:0 -5px;}.flatpickr-calendar:after{border-width:4px;margin:0 -4px;}.flatpickr-calendar.arrowTop:before,.flatpickr-calendar.arrowTop:after{bottom:100%;}.flatpickr-calendar.arrowTop:before{border-bottom-color:#e6e6e6;}.flatpickr-calendar.arrowTop:after{border-bottom-color:#fff;}.flatpickr-calendar.arrowBottom:before,.flatpickr-calendar.arrowBottom:after{top:100%;}.flatpickr-calendar.arrowBottom:before{border-top-color:#e6e6e6;}.flatpickr-calendar.arrowBottom:after{border-top-color:#fff;}.flatpickr-calendar:focus{outline:0;}.flatpickr-wrapper{position:relative;display:inline-block;}.flatpickr-months{display:-webkit-box;display:-webkit-flex;display:-ms-flexbox;display:flex;}.flatpickr-months .flatpickr-month{background:transparent;color:rgba(0, 0, 0, 0.9);fill:rgba(0, 0, 0, 0.9);height:34px;line-height:1;text-align:center;position:relative;-webkit-user-select:none;-moz-user-select:none;-ms-user-select:none;user-select:none;overflow:hidden;-webkit-box-flex:1;-webkit-flex:1;-ms-flex:1;flex:1;}.flatpickr-months .flatpickr-prev-month,.flatpickr-months .flatpickr-next-month{text-decoration:none;cursor:pointer;position:absolute;top:0;height:34px;padding:10px;z-index:3;color:rgba(0, 0, 0, 0.9);fill:rgba(0, 0, 0, 0.9);}.flatpickr-months .flatpickr-prev-month.flatpickr-disabled,.flatpickr-months .flatpickr-next-month.flatpickr-disabled{display:none;}.flatpickr-months .flatpickr-prev-month i,.flatpickr-months .flatpickr-next-month i{position:relative;}.flatpickr-months .flatpickr-prev-month.flatpickr-prev-month,.flatpickr-months .flatpickr-next-month.flatpickr-prev-month{left:0;}.flatpickr-months .flatpickr-prev-month.flatpickr-next-month,.flatpickr-months .flatpickr-next-month.flatpickr-next-month{right:0;}.flatpickr-months .flatpickr-prev-month:hover,.flatpickr-months .flatpickr-next-month:hover{color:#959ea9;}.flatpickr-months .flatpickr-prev-month:hover svg,.flatpickr-months .flatpickr-next-month:hover svg{fill:#f64747;}.flatpickr-months .flatpickr-prev-month svg,.flatpickr-months .flatpickr-next-month svg{width:14px;height:14px;}.flatpickr-months .flatpickr-prev-month svg path,.flatpickr-months .flatpickr-next-month svg path{-webkit-transition:fill 0.1s;transition:fill 0.1s;fill:inherit;}.numInputWrapper{position:relative;height:auto;}.numInputWrapper input,.numInputWrapper span{display:inline-block;}.numInputWrapper input{width:100%;}.numInputWrapper input::-ms-clear{display:none;}.numInputWrapper input::-webkit-outer-spin-button,.numInputWrapper input::-webkit-inner-spin-button{margin:0;-webkit-appearance:none;}.numInputWrapper span{position:absolute;right:0;width:14px;padding:0 4px 0 2px;height:50%;line-height:50%;opacity:0;cursor:pointer;border:1px solid rgba(57, 57, 57, 0.15);-webkit-box-sizing:border-box;box-sizing:border-box;}.numInputWrapper span:hover{background:rgba(0, 0, 0, 0.1);}.numInputWrapper span:active{background:rgba(0, 0, 0, 0.2);}.numInputWrapper span:after{display:block;content:"";position:absolute;}.numInputWrapper span.arrowUp{top:0;border-bottom:0;}.numInputWrapper span.arrowUp:after{border-left:4px solid transparent;border-right:4px solid transparent;border-bottom:4px solid rgba(57, 57, 57, 0.6);top:26%;}.numInputWrapper span.arrowDown{top:50%;}.numInputWrapper span.arrowDown:after{border-left:4px solid transparent;border-right:4px solid transparent;border-top:4px solid rgba(57, 57, 57, 0.6);top:40%;}.numInputWrapper span svg{width:inherit;height:auto;}.numInputWrapper span svg path{fill:rgba(0, 0, 0, 0.5);}.numInputWrapper:hover{background:rgba(0, 0, 0, 0.05);}.numInputWrapper:hover span{opacity:1;}.flatpickr-current-month{font-size:135%;line-height:inherit;font-weight:300;color:inherit;position:absolute;width:75%;left:12.5%;padding:7.48px 0 0 0;line-height:1;height:34px;display:inline-block;text-align:center;-webkit-transform:translate3d(0px, 0px, 0px);transform:translate3d(0px, 0px, 0px);}.flatpickr-current-month span.cur-month{font-family:inherit;font-weight:700;color:inherit;display:inline-block;margin-left:0.5ch;padding:0;}.flatpickr-current-month span.cur-month:hover{background:rgba(0, 0, 0, 0.05);}.flatpickr-current-month .numInputWrapper{width:6ch;width:7ch\0;display:inline-block;}.flatpickr-current-month .numInputWrapper span.arrowUp:after{border-bottom-color:rgba(0, 0, 0, 0.9);}.flatpickr-current-month .numInputWrapper span.arrowDown:after{border-top-color:rgba(0, 0, 0, 0.9);}.flatpickr-current-month input.cur-year{background:transparent;-webkit-box-sizing:border-box;box-sizing:border-box;color:inherit;cursor:text;padding:0 0 0 0.5ch;margin:0;display:inline-block;font-size:inherit;font-family:inherit;font-weight:300;line-height:inherit;height:auto;border:0;border-radius:0;vertical-align:initial;-webkit-appearance:textfield;-moz-appearance:textfield;appearance:textfield;}.flatpickr-current-month input.cur-year:focus{outline:0;}.flatpickr-current-month input.cur-year[disabled],.flatpickr-current-month input.cur-year[disabled]:hover{font-size:100%;color:rgba(0, 0, 0, 0.5);background:transparent;pointer-events:none;}.flatpickr-current-month .flatpickr-monthDropdown-months{appearance:menulist;background:transparent;border:none;border-radius:0;box-sizing:border-box;color:inherit;cursor:pointer;font-size:inherit;font-family:inherit;font-weight:300;height:auto;line-height:inherit;margin:-1px 0 0 0;outline:none;padding:0 0 0 0.5ch;position:relative;vertical-align:initial;-webkit-box-sizing:border-box;-webkit-appearance:menulist;-moz-appearance:menulist;width:auto;}.flatpickr-current-month .flatpickr-monthDropdown-months:focus,.flatpickr-current-month .flatpickr-monthDropdown-months:active{outline:none;}.flatpickr-current-month .flatpickr-monthDropdown-months:hover{background:rgba(0, 0, 0, 0.05);}.flatpickr-current-month .flatpickr-monthDropdown-months .flatpickr-monthDropdown-month{background-color:transparent;outline:none;padding:0;}.flatpickr-weekdays{background:transparent;text-align:center;overflow:hidden;width:100%;display:-webkit-box;display:-webkit-flex;display:-ms-flexbox;display:flex;-webkit-box-align:center;-webkit-align-items:center;-ms-flex-align:center;align-items:center;height:28px;}.flatpickr-weekdays .flatpickr-weekdaycontainer{display:-webkit-box;display:-webkit-flex;display:-ms-flexbox;display:flex;-webkit-box-flex:1;-webkit-flex:1;-ms-flex:1;flex:1;}span.flatpickr-weekday{cursor:default;font-size:90%;background:transparent;color:rgba(0, 0, 0, 0.54);line-height:1;margin:0;text-align:center;display:block;-webkit-box-flex:1;-webkit-flex:1;-ms-flex:1;flex:1;font-weight:bolder;}.dayContainer,.flatpickr-weeks{padding:1px 0 0 0;}.flatpickr-days{position:relative;overflow:hidden;display:-webkit-box;display:-webkit-flex;display:-ms-flexbox;display:flex;-webkit-box-align:start;-webkit-align-items:flex-start;-ms-flex-align:start;align-items:flex-start;width:307.875px;}.flatpickr-days:focus{outline:0;}.dayContainer{padding:0;outline:0;text-align:left;width:307.875px;min-width:307.875px;max-width:307.875px;-webkit-box-sizing:border-box;box-sizing:border-box;display:inline-block;display:-ms-flexbox;display:-webkit-box;display:-webkit-flex;display:flex;-webkit-flex-wrap:wrap;flex-wrap:wrap;-ms-flex-wrap:wrap;-ms-flex-pack:justify;-webkit-justify-content:space-around;justify-content:space-around;-webkit-transform:translate3d(0px, 0px, 0px);transform:translate3d(0px, 0px, 0px);opacity:1;}.dayContainer + .dayContainer{-webkit-box-shadow:-1px 0 0 #e6e6e6;box-shadow:-1px 0 0 #e6e6e6;}.flatpickr-day{background:none;border:1px solid transparent;border-radius:150px;-webkit-box-sizing:border-box;box-sizing:border-box;color:#393939;cursor:pointer;font-weight:400;width:14.2857143%;-webkit-flex-basis:14.2857143%;-ms-flex-preferred-size:14.2857143%;flex-basis:14.2857143%;max-width:39px;height:39px;line-height:39px;margin:0;display:inline-block;position:relative;-webkit-box-pack:center;-webkit-justify-content:center;-ms-flex-pack:center;justify-content:center;text-align:center;}.flatpickr-day.inRange,.flatpickr-day.prevMonthDay.inRange,.flatpickr-day.nextMonthDay.inRange,.flatpickr-day.today.inRange,.flatpickr-day.prevMonthDay.today.inRange,.flatpickr-day.nextMonthDay.today.inRange,.flatpickr-day:hover,.flatpickr-day.prevMonthDay:hover,.flatpickr-day.nextMonthDay:hover,.flatpickr-day:focus,.flatpickr-day.prevMonthDay:focus,.flatpickr-day.nextMonthDay:focus{cursor:pointer;outline:0;background:#e6e6e6;border-color:#e6e6e6;}.flatpickr-day.today{border-color:#959ea9;}.flatpickr-day.today:hover,.flatpickr-day.today:focus{border-color:#959ea9;background:#959ea9;color:#fff;}.flatpickr-day.selected,.flatpickr-day.startRange,.flatpickr-day.endRange,.flatpickr-day.selected.inRange,.flatpickr-day.startRange.inRange,.flatpickr-day.endRange.inRange,.flatpickr-day.selected:focus,.flatpickr-day.startRange:focus,.flatpickr-day.endRange:focus,.flatpickr-day.selected:hover,.flatpickr-day.startRange:hover,.flatpickr-day.endRange:hover,.flatpickr-day.selected.prevMonthDay,.flatpickr-day.startRange.prevMonthDay,.flatpickr-day.endRange.prevMonthDay,.flatpickr-day.selected.nextMonthDay,.flatpickr-day.startRange.nextMonthDay,.flatpickr-day.endRange.nextMonthDay{background:#569ff7;-webkit-box-shadow:none;box-shadow:none;color:#fff;border-color:#569ff7;}.flatpickr-day.selected.startRange,.flatpickr-day.startRange.startRange,.flatpickr-day.endRange.startRange{border-radius:50px 0 0 50px;}.flatpickr-day.selected.endRange,.flatpickr-day.startRange.endRange,.flatpickr-day.endRange.endRange{border-radius:0 50px 50px 0;}.flatpickr-day.selected.startRange + .endRange:not(:nth-child(7n+1)),.flatpickr-day.startRange.startRange + .endRange:not(:nth-child(7n+1)),.flatpickr-day.endRange.startRange + .endRange:not(:nth-child(7n+1)){-webkit-box-shadow:-10px 0 0 #569ff7;box-shadow:-10px 0 0 #569ff7;}.flatpickr-day.selected.startRange.endRange,.flatpickr-day.startRange.startRange.endRange,.flatpickr-day.endRange.startRange.endRange{border-radius:50px;}.flatpickr-day.inRange{border-radius:0;-webkit-box-shadow:-5px 0 0 #e6e6e6, 5px 0 0 #e6e6e6;box-shadow:-5px 0 0 #e6e6e6, 5px 0 0 #e6e6e6;}.flatpickr-day.flatpickr-disabled,.flatpickr-day.flatpickr-disabled:hover,.flatpickr-day.prevMonthDay,.flatpickr-day.nextMonthDay,.flatpickr-day.notAllowed,.flatpickr-day.notAllowed.prevMonthDay,.flatpickr-day.notAllowed.nextMonthDay{color:rgba(57, 57, 57, 0.3);background:transparent;border-color:transparent;cursor:default;}.flatpickr-day.flatpickr-disabled,.flatpickr-day.flatpickr-disabled:hover{cursor:not-allowed;color:rgba(57, 57, 57, 0.1);}.flatpickr-day.week.selected{border-radius:0;-webkit-box-shadow:-5px 0 0 #569ff7, 5px 0 0 #569ff7;box-shadow:-5px 0 0 #569ff7, 5px 0 0 #569ff7;}.flatpickr-day.hidden{visibility:hidden;}.rangeMode .flatpickr-day{margin-top:1px;}.flatpickr-weekwrapper{float:left;}.flatpickr-weekwrapper .flatpickr-weeks{padding:0 12px;-webkit-box-shadow:1px 0 0 #e6e6e6;box-shadow:1px 0 0 #e6e6e6;}.flatpickr-weekwrapper .flatpickr-weekday{float:none;width:100%;line-height:28px;}.flatpickr-weekwrapper span.flatpickr-day,.flatpickr-weekwrapper span.flatpickr-day:hover{display:block;width:100%;max-width:none;color:rgba(57, 57, 57, 0.3);background:transparent;cursor:default;border:none;}.flatpickr-innerContainer{display:block;display:-webkit-box;display:-webkit-flex;display:-ms-flexbox;display:flex;-webkit-box-sizing:border-box;box-sizing:border-box;overflow:hidden;}.flatpickr-rContainer{display:inline-block;padding:0;-webkit-box-sizing:border-box;box-sizing:border-box;}.flatpickr-time{text-align:center;outline:0;display:block;height:0;line-height:40px;max-height:40px;-webkit-box-sizing:border-box;box-sizing:border-box;overflow:hidden;display:-webkit-box;display:-webkit-flex;display:-ms-flexbox;display:flex;}.flatpickr-time:after{content:"";display:table;clear:both;}.flatpickr-time .numInputWrapper{-webkit-box-flex:1;-webkit-flex:1;-ms-flex:1;flex:1;width:40%;height:40px;float:left;}.flatpickr-time .numInputWrapper span.arrowUp:after{border-bottom-color:#393939;}.flatpickr-time .numInputWrapper span.arrowDown:after{border-top-color:#393939;}.flatpickr-time.hasSeconds .numInputWrapper{width:26%;}.flatpickr-time.time24hr .numInputWrapper{width:49%;}.flatpickr-time input{background:transparent;-webkit-box-shadow:none;box-shadow:none;border:0;border-radius:0;text-align:center;margin:0;padding:0;height:inherit;line-height:inherit;color:#393939;font-size:14px;position:relative;-webkit-box-sizing:border-box;box-sizing:border-box;-webkit-appearance:textfield;-moz-appearance:textfield;appearance:textfield;}.flatpickr-time input.flatpickr-hour{font-weight:bold;}.flatpickr-time input.flatpickr-minute,.flatpickr-time input.flatpickr-second{font-weight:400;}.flatpickr-time input:focus{outline:0;border:0;}.flatpickr-time .flatpickr-time-separator,.flatpickr-time .flatpickr-am-pm{height:inherit;float:left;line-height:inherit;color:#393939;font-weight:bold;width:2%;-webkit-user-select:none;-moz-user-select:none;-ms-user-select:none;user-select:none;-webkit-align-self:center;-ms-flex-item-align:center;align-self:center;}.flatpickr-time .flatpickr-am-pm{outline:0;width:18%;cursor:pointer;text-align:center;font-weight:400;}.flatpickr-time input:hover,.flatpickr-time .flatpickr-am-pm:hover,.flatpickr-time input:focus,.flatpickr-time .flatpickr-am-pm:focus{background:#eee;}.flatpickr-input[readonly]{cursor:pointer;}@-webkit-keyframes fpFadeInDown{from{opacity:0;-webkit-transform:translate3d(0, -20px, 0);transform:translate3d(0, -20px, 0);}to{opacity:1;-webkit-transform:translate3d(0, 0, 0);transform:translate3d(0, 0, 0);}}@keyframes fpFadeInDown{from{opacity:0;-webkit-transform:translate3d(0, -20px, 0);transform:translate3d(0, -20px, 0);}to{opacity:1;-webkit-transform:translate3d(0, 0, 0);transform:translate3d(0, 0, 0);}}.flatpickr-calendar{background:transparent;opacity:0;display:none;text-align:center;visibility:hidden;padding:0;-webkit-animation:none;animation:none;direction:ltr;border:0;font-size:14px;line-height:24px;border-radius:5px;position:absolute;width:307.875px;-webkit-box-sizing:border-box;box-sizing:border-box;-ms-touch-action:manipulation;touch-action:manipulation;-webkit-box-shadow:0 3px 13px rgba(0, 0, 0, 0.08);box-shadow:0 3px 13px rgba(0, 0, 0, 0.08);}.flatpickr-calendar.open,.flatpickr-calendar.inline{opacity:1;max-height:640px;visibility:visible;}.flatpickr-calendar.open{display:inline-block;z-index:99999;}.flatpickr-calendar.animate.open{-webkit-animation:fpFadeInDown 300ms cubic-bezier(0.23, 1, 0.32, 1);animation:fpFadeInDown 300ms cubic-bezier(0.23, 1, 0.32, 1);}.flatpickr-calendar.inline{display:block;position:relative;top:2px;}.flatpickr-calendar.static{position:absolute;top:calc(100% + 2px);}.flatpickr-calendar.static.open{z-index:999;display:block;}.flatpickr-calendar.multiMonth .flatpickr-days .dayContainer:nth-child(n+1) .flatpickr-day.inRange:nth-child(7n+7){-webkit-box-shadow:none !important;box-shadow:none !important;}.flatpickr-calendar.multiMonth .flatpickr-days .dayContainer:nth-child(n+2) .flatpickr-day.inRange:nth-child(7n+1){-webkit-box-shadow:-2px 0 0 #e6e6e6, 5px 0 0 #e6e6e6;box-shadow:-2px 0 0 #e6e6e6, 5px 0 0 #e6e6e6;}.flatpickr-calendar .hasWeeks .dayContainer,.flatpickr-calendar .hasTime .dayContainer{border-bottom:0;border-bottom-right-radius:0;border-bottom-left-radius:0;}.flatpickr-calendar .hasWeeks .dayContainer{border-left:0;}.flatpickr-calendar.hasTime .flatpickr-time{height:40px;border-top:1px solid #eceef1;}.flatpickr-calendar.hasTime .flatpickr-innerContainer{border-bottom:0;}.flatpickr-calendar.hasTime .flatpickr-time{border:1px solid #eceef1;}.flatpickr-calendar.noCalendar.hasTime .flatpickr-time{height:auto;}.flatpickr-calendar:before,.flatpickr-calendar:after{position:absolute;display:block;pointer-events:none;border:solid transparent;content:\'\';height:0;width:0;left:22px;}.flatpickr-calendar.rightMost:before,.flatpickr-calendar.arrowRight:before,.flatpickr-calendar.rightMost:after,.flatpickr-calendar.arrowRight:after{left:auto;right:22px;}.flatpickr-calendar.arrowCenter:before,.flatpickr-calendar.arrowCenter:after{left:50%;right:50%;}.flatpickr-calendar:before{border-width:5px;margin:0 -5px;}.flatpickr-calendar:after{border-width:4px;margin:0 -4px;}.flatpickr-calendar.arrowTop:before,.flatpickr-calendar.arrowTop:after{bottom:100%;}.flatpickr-calendar.arrowTop:before{border-bottom-color:#eceef1;}.flatpickr-calendar.arrowTop:after{border-bottom-color:#eceef1;}.flatpickr-calendar.arrowBottom:before,.flatpickr-calendar.arrowBottom:after{top:100%;}.flatpickr-calendar.arrowBottom:before{border-top-color:#eceef1;}.flatpickr-calendar.arrowBottom:after{border-top-color:#eceef1;}.flatpickr-calendar:focus{outline:0;}.flatpickr-wrapper{position:relative;display:inline-block;}.flatpickr-months{display:-webkit-box;display:-webkit-flex;display:-ms-flexbox;display:flex;}.flatpickr-months .flatpickr-month{border-radius:5px 5px 0 0;background:#eceef1;color:#5a6171;fill:#5a6171;height:34px;line-height:1;text-align:center;position:relative;-webkit-user-select:none;-moz-user-select:none;-ms-user-select:none;user-select:none;overflow:hidden;-webkit-box-flex:1;-webkit-flex:1;-ms-flex:1;flex:1;}.flatpickr-months .flatpickr-prev-month,.flatpickr-months .flatpickr-next-month{text-decoration:none;cursor:pointer;position:absolute;top:0;height:34px;padding:10px;z-index:3;color:#5a6171;fill:#5a6171;}.flatpickr-months .flatpickr-prev-month.flatpickr-disabled,.flatpickr-months .flatpickr-next-month.flatpickr-disabled{display:none;}.flatpickr-months .flatpickr-prev-month i,.flatpickr-months .flatpickr-next-month i{position:relative;}.flatpickr-months .flatpickr-prev-month.flatpickr-prev-month,.flatpickr-months .flatpickr-next-month.flatpickr-prev-month{left:0;}.flatpickr-months .flatpickr-prev-month.flatpickr-next-month,.flatpickr-months .flatpickr-next-month.flatpickr-next-month{right:0;}.flatpickr-months .flatpickr-prev-month:hover,.flatpickr-months .flatpickr-next-month:hover{color:#bbb;}.flatpickr-months .flatpickr-prev-month:hover svg,.flatpickr-months .flatpickr-next-month:hover svg{fill:#f64747;}.flatpickr-months .flatpickr-prev-month svg,.flatpickr-months .flatpickr-next-month svg{width:14px;height:14px;}.flatpickr-months .flatpickr-prev-month svg path,.flatpickr-months .flatpickr-next-month svg path{-webkit-transition:fill 0.1s;transition:fill 0.1s;fill:inherit;}.numInputWrapper{position:relative;height:auto;}.numInputWrapper input,.numInputWrapper span{display:inline-block;}.numInputWrapper input{width:100%;}.numInputWrapper input::-ms-clear{display:none;}.numInputWrapper input::-webkit-outer-spin-button,.numInputWrapper input::-webkit-inner-spin-button{margin:0;-webkit-appearance:none;}.numInputWrapper span{position:absolute;right:0;width:14px;padding:0 4px 0 2px;height:50%;line-height:50%;opacity:0;cursor:pointer;border:1px solid rgba(72, 72, 72, 0.15);-webkit-box-sizing:border-box;box-sizing:border-box;}.numInputWrapper span:hover{background:rgba(0, 0, 0, 0.1);}.numInputWrapper span:active{background:rgba(0, 0, 0, 0.2);}.numInputWrapper span:after{display:block;content:"";position:absolute;}.numInputWrapper span.arrowUp{top:0;border-bottom:0;}.numInputWrapper span.arrowUp:after{border-left:4px solid transparent;border-right:4px solid transparent;border-bottom:4px solid rgba(72, 72, 72, 0.6);top:26%;}.numInputWrapper span.arrowDown{top:50%;}.numInputWrapper span.arrowDown:after{border-left:4px solid transparent;border-right:4px solid transparent;border-top:4px solid rgba(72, 72, 72, 0.6);top:40%;}.numInputWrapper span svg{width:inherit;height:auto;}.numInputWrapper span svg path{fill:rgba(90, 97, 113, 0.5);}.numInputWrapper:hover{background:rgba(0, 0, 0, 0.05);}.numInputWrapper:hover span{opacity:1;}.flatpickr-current-month{font-size:135%;line-height:inherit;font-weight:300;color:inherit;position:absolute;width:75%;left:12.5%;padding:7.48px 0 0 0;line-height:1;height:34px;display:inline-block;text-align:center;-webkit-transform:translate3d(0px, 0px, 0px);transform:translate3d(0px, 0px, 0px);}.flatpickr-current-month span.cur-month{font-family:inherit;font-weight:700;color:inherit;display:inline-block;margin-left:0.5ch;padding:0;}.flatpickr-current-month span.cur-month:hover{background:rgba(0, 0, 0, 0.05);}.flatpickr-current-month .numInputWrapper{width:6ch;width:7ch\0;display:inline-block;}.flatpickr-current-month .numInputWrapper span.arrowUp:after{border-bottom-color:#5a6171;}.flatpickr-current-month .numInputWrapper span.arrowDown:after{border-top-color:#5a6171;}.flatpickr-current-month input.cur-year{background:transparent;-webkit-box-sizing:border-box;box-sizing:border-box;color:inherit;cursor:text;padding:0 0 0 0.5ch;margin:0;display:inline-block;font-size:inherit;font-family:inherit;font-weight:300;line-height:inherit;height:auto;border:0;border-radius:0;vertical-align:initial;-webkit-appearance:textfield;-moz-appearance:textfield;appearance:textfield;}.flatpickr-current-month input.cur-year:focus{outline:0;}.flatpickr-current-month input.cur-year[disabled],.flatpickr-current-month input.cur-year[disabled]:hover{font-size:100%;color:rgba(90, 97, 113, 0.5);background:transparent;pointer-events:none;}.flatpickr-current-month .flatpickr-monthDropdown-months{appearance:menulist;background:#eceef1;border:none;border-radius:0;box-sizing:border-box;color:inherit;cursor:pointer;font-size:inherit;font-family:inherit;font-weight:300;height:auto;line-height:inherit;margin:-1px 0 0 0;outline:none;padding:0 0 0 0.5ch;position:relative;vertical-align:initial;-webkit-box-sizing:border-box;-webkit-appearance:menulist;-moz-appearance:menulist;width:auto;}.flatpickr-current-month .flatpickr-monthDropdown-months:focus,.flatpickr-current-month .flatpickr-monthDropdown-months:active{outline:none;}.flatpickr-current-month .flatpickr-monthDropdown-months:hover{background:rgba(0, 0, 0, 0.05);}.flatpickr-current-month .flatpickr-monthDropdown-months .flatpickr-monthDropdown-month{background-color:#eceef1;outline:none;padding:0;}.flatpickr-weekdays{background:#eceef1;text-align:center;overflow:hidden;width:100%;display:-webkit-box;display:-webkit-flex;display:-ms-flexbox;display:flex;-webkit-box-align:center;-webkit-align-items:center;-ms-flex-align:center;align-items:center;height:28px;}.flatpickr-weekdays .flatpickr-weekdaycontainer{display:-webkit-box;display:-webkit-flex;display:-ms-flexbox;display:flex;-webkit-box-flex:1;-webkit-flex:1;-ms-flex:1;flex:1;}span.flatpickr-weekday{cursor:default;font-size:90%;background:#eceef1;color:#5a6171;line-height:1;margin:0;text-align:center;display:block;-webkit-box-flex:1;-webkit-flex:1;-ms-flex:1;flex:1;font-weight:bolder;}.dayContainer,.flatpickr-weeks{padding:1px 0 0 0;}.flatpickr-days{position:relative;overflow:hidden;display:-webkit-box;display:-webkit-flex;display:-ms-flexbox;display:flex;-webkit-box-align:start;-webkit-align-items:flex-start;-ms-flex-align:start;align-items:flex-start;width:307.875px;border-left:1px solid #eceef1;border-right:1px solid #eceef1;}.flatpickr-days:focus{outline:0;}.dayContainer{padding:0;outline:0;text-align:left;width:307.875px;min-width:307.875px;max-width:307.875px;-webkit-box-sizing:border-box;box-sizing:border-box;display:inline-block;display:-ms-flexbox;display:-webkit-box;display:-webkit-flex;display:flex;-webkit-flex-wrap:wrap;flex-wrap:wrap;-ms-flex-wrap:wrap;-ms-flex-pack:justify;-webkit-justify-content:space-around;justify-content:space-around;-webkit-transform:translate3d(0px, 0px, 0px);transform:translate3d(0px, 0px, 0px);opacity:1;}.dayContainer + .dayContainer{-webkit-box-shadow:-1px 0 0 #eceef1;box-shadow:-1px 0 0 #eceef1;}.flatpickr-day{background:none;border:1px solid transparent;border-radius:150px;-webkit-box-sizing:border-box;box-sizing:border-box;color:#484848;cursor:pointer;font-weight:400;width:14.2857143%;-webkit-flex-basis:14.2857143%;-ms-flex-preferred-size:14.2857143%;flex-basis:14.2857143%;max-width:39px;height:39px;line-height:39px;margin:0;display:inline-block;position:relative;-webkit-box-pack:center;-webkit-justify-content:center;-ms-flex-pack:center;justify-content:center;text-align:center;}.flatpickr-day.inRange,.flatpickr-day.prevMonthDay.inRange,.flatpickr-day.nextMonthDay.inRange,.flatpickr-day.today.inRange,.flatpickr-day.prevMonthDay.today.inRange,.flatpickr-day.nextMonthDay.today.inRange,.flatpickr-day:hover,.flatpickr-day.prevMonthDay:hover,.flatpickr-day.nextMonthDay:hover,.flatpickr-day:focus,.flatpickr-day.prevMonthDay:focus,.flatpickr-day.nextMonthDay:focus{cursor:pointer;outline:0;background:#e2e2e2;border-color:#e2e2e2;}.flatpickr-day.today{border-color:#bbb;}.flatpickr-day.today:hover,.flatpickr-day.today:focus{border-color:#bbb;background:#bbb;color:#fff;}.flatpickr-day.selected,.flatpickr-day.startRange,.flatpickr-day.endRange,.flatpickr-day.selected.inRange,.flatpickr-day.startRange.inRange,.flatpickr-day.endRange.inRange,.flatpickr-day.selected:focus,.flatpickr-day.startRange:focus,.flatpickr-day.endRange:focus,.flatpickr-day.selected:hover,.flatpickr-day.startRange:hover,.flatpickr-day.endRange:hover,.flatpickr-day.selected.prevMonthDay,.flatpickr-day.startRange.prevMonthDay,.flatpickr-day.endRange.prevMonthDay,.flatpickr-day.selected.nextMonthDay,.flatpickr-day.startRange.nextMonthDay,.flatpickr-day.endRange.nextMonthDay{background:#ff5a5f;-webkit-box-shadow:none;box-shadow:none;color:#fff;border-color:#ff5a5f;}.flatpickr-day.selected.startRange,.flatpickr-day.startRange.startRange,.flatpickr-day.endRange.startRange{border-radius:50px 0 0 50px;}.flatpickr-day.selected.endRange,.flatpickr-day.startRange.endRange,.flatpickr-day.endRange.endRange{border-radius:0 50px 50px 0;}.flatpickr-day.selected.startRange + .endRange:not(:nth-child(7n+1)),.flatpickr-day.startRange.startRange + .endRange:not(:nth-child(7n+1)),.flatpickr-day.endRange.startRange + .endRange:not(:nth-child(7n+1)){-webkit-box-shadow:-10px 0 0 #ff5a5f;box-shadow:-10px 0 0 #ff5a5f;}.flatpickr-day.selected.startRange.endRange,.flatpickr-day.startRange.startRange.endRange,.flatpickr-day.endRange.startRange.endRange{border-radius:50px;}.flatpickr-day.inRange{border-radius:0;-webkit-box-shadow:-5px 0 0 #e2e2e2, 5px 0 0 #e2e2e2;box-shadow:-5px 0 0 #e2e2e2, 5px 0 0 #e2e2e2;}.flatpickr-day.flatpickr-disabled,.flatpickr-day.flatpickr-disabled:hover,.flatpickr-day.prevMonthDay,.flatpickr-day.nextMonthDay,.flatpickr-day.notAllowed,.flatpickr-day.notAllowed.prevMonthDay,.flatpickr-day.notAllowed.nextMonthDay{color:rgba(72, 72, 72, 0.3);background:transparent;border-color:transparent;cursor:default;}.flatpickr-day.flatpickr-disabled,.flatpickr-day.flatpickr-disabled:hover{cursor:not-allowed;color:rgba(72, 72, 72, 0.1);}.flatpickr-day.week.selected{border-radius:0;-webkit-box-shadow:-5px 0 0 #ff5a5f, 5px 0 0 #ff5a5f;box-shadow:-5px 0 0 #ff5a5f, 5px 0 0 #ff5a5f;}.flatpickr-day.hidden{visibility:hidden;}.rangeMode .flatpickr-day{margin-top:1px;}.flatpickr-weekwrapper{float:left;}.flatpickr-weekwrapper .flatpickr-weeks{padding:0 12px;border-left:1px solid #eceef1;}.flatpickr-weekwrapper .flatpickr-weekday{float:none;width:100%;line-height:28px;}.flatpickr-weekwrapper span.flatpickr-day,.flatpickr-weekwrapper span.flatpickr-day:hover{display:block;width:100%;max-width:none;color:rgba(72, 72, 72, 0.3);background:transparent;cursor:default;border:none;}.flatpickr-innerContainer{display:block;display:-webkit-box;display:-webkit-flex;display:-ms-flexbox;display:flex;-webkit-box-sizing:border-box;box-sizing:border-box;overflow:hidden;background:#fff;border-bottom:1px solid #eceef1;}.flatpickr-rContainer{display:inline-block;padding:0;-webkit-box-sizing:border-box;box-sizing:border-box;}.flatpickr-time{text-align:center;outline:0;display:block;height:0;line-height:40px;max-height:40px;-webkit-box-sizing:border-box;box-sizing:border-box;overflow:hidden;display:-webkit-box;display:-webkit-flex;display:-ms-flexbox;display:flex;background:#fff;border-radius:0 0 5px 5px;}.flatpickr-time:after{content:"";display:table;clear:both;}.flatpickr-time .numInputWrapper{-webkit-box-flex:1;-webkit-flex:1;-ms-flex:1;flex:1;width:40%;height:40px;float:left;}.flatpickr-time .numInputWrapper span.arrowUp:after{border-bottom-color:#484848;}.flatpickr-time .numInputWrapper span.arrowDown:after{border-top-color:#484848;}.flatpickr-time.hasSeconds .numInputWrapper{width:26%;}.flatpickr-time.time24hr .numInputWrapper{width:49%;}.flatpickr-time input{background:transparent;-webkit-box-shadow:none;box-shadow:none;border:0;border-radius:0;text-align:center;margin:0;padding:0;height:inherit;line-height:inherit;color:#484848;font-size:14px;position:relative;-webkit-box-sizing:border-box;box-sizing:border-box;-webkit-appearance:textfield;-moz-appearance:textfield;appearance:textfield;}.flatpickr-time input.flatpickr-hour{font-weight:bold;}.flatpickr-time input.flatpickr-minute,.flatpickr-time input.flatpickr-second{font-weight:400;}.flatpickr-time input:focus{outline:0;border:0;}.flatpickr-time .flatpickr-time-separator,.flatpickr-time .flatpickr-am-pm{height:inherit;float:left;line-height:inherit;color:#484848;font-weight:bold;width:2%;-webkit-user-select:none;-moz-user-select:none;-ms-user-select:none;user-select:none;-webkit-align-self:center;-ms-flex-item-align:center;align-self:center;}.flatpickr-time .flatpickr-am-pm{outline:0;width:18%;cursor:pointer;text-align:center;font-weight:400;}.flatpickr-time input:hover,.flatpickr-time .flatpickr-am-pm:hover,.flatpickr-time input:focus,.flatpickr-time .flatpickr-am-pm:focus{background:#eaeaea;}.flatpickr-input[readonly]{cursor:pointer;}@-webkit-keyframes fpFadeInDown{from{opacity:0;-webkit-transform:translate3d(0, -20px, 0);transform:translate3d(0, -20px, 0);}to{opacity:1;-webkit-transform:translate3d(0, 0, 0);transform:translate3d(0, 0, 0);}}@keyframes fpFadeInDown{from{opacity:0;-webkit-transform:translate3d(0, -20px, 0);transform:translate3d(0, -20px, 0);}to{opacity:1;-webkit-transform:translate3d(0, 0, 0);transform:translate3d(0, 0, 0);}}span.flatpickr-day.selected{font-weight:bold;}'},
498: function _(e,t,r,a,i){a();var n;const d=e(1).__importDefault(e(179)),s=e(499),o=e(8);class _ extends s.AbstractRangeSliderView{}r.DateRangeSliderView=_,_.__name__="DateRangeSliderView";class c extends s.AbstractSlider{constructor(e){super(e),this.behaviour="drag",this.connected=[!1,!0,!1]}_formatter(e,t){return(0,o.isString)(t)?(0,d.default)(e,t):t.compute(e)}}r.DateRangeSlider=c,n=c,c.__name__="DateRangeSlider",n.prototype.default_view=_,n.override({format:"%d %b %Y"})},
499: function _(t,e,s,i,l){i();const o=t(1);var r;const n=o.__importDefault(t(500)),a=t(52),d=t(10),_=t(21),h=t(484),c=t(171),u=o.__importStar(t(501)),m=u,p=o.__importDefault(t(502)),b=o.__importStar(t(479));class g extends h.OrientedControlView{*controls(){yield this.slider_el}connect_signals(){super.connect_signals();const{direction:t,orientation:e,tooltips:s}=this.model.properties;this.on_change([t,e,s],(()=>this.render()));const{start:i,end:l,value:o,step:r,title:n}=this.model.properties;this.on_change([i,l,o,r],(()=>{const{start:t,end:e,value:s,step:i}=this._calc_to();this._noUiSlider.updateOptions({range:{min:t,max:e},start:s,step:i},!0)}));const{bar_color:a}=this.model.properties;this.on_change(a,(()=>{this._set_bar_color()}));const{show_value:d}=this.model.properties;this.on_change([o,n,d],(()=>this._update_title()))}styles(){return[...super.styles(),p.default,u.default]}_update_title(){(0,a.empty)(this.title_el);const t=null==this.model.title||0==this.model.title.length&&!this.model.show_value;if(this.title_el.style.display=t?"none":"",!t){const{title:t}=this.model;if(null!=t&&t.length>0&&(this.contains_tex_string(t)?this.title_el.innerHTML=`${this.process_tex(t)}: `:this.title_el.textContent=`${t}: `),this.model.show_value){const{value:t}=this._calc_to(),e=t.map((t=>this.model.pretty(t))).join(" .. ");this.title_el.appendChild((0,a.span)({class:m.slider_value},e))}}}_set_bar_color(){if(!this.model.disabled&&null!=this.slider_el){this.slider_el.querySelector(".noUi-connect").style.backgroundColor=(0,_.color2css)(this.model.bar_color)}}render(){super.render();const{start:t,end:e,value:s,step:i}=this._calc_to();let l;if(this.model.tooltips){const t={to:t=>this.model.pretty(t)};l=(0,d.repeat)(t,s.length)}else l=null;if(null==this.slider_el){this.slider_el=(0,a.div)(),this._noUiSlider=n.default.create(this.slider_el,{range:{min:t,max:e},start:s,step:i,behaviour:this.model.behaviour,connect:this.model.connected,tooltips:null!=l&&l,orientation:this.model.orientation,direction:this.model.direction}),this._noUiSlider.on("slide",((t,e,s)=>this._slide(s))),this._noUiSlider.on("change",((t,e,s)=>this._change(s)));const o=(t,e)=>{if(null==l||null==this.slider_el)return;this.slider_el.querySelectorAll(".noUi-handle")[t].querySelector(".noUi-tooltip").style.display=e?"block":""};this._noUiSlider.on("start",((t,e)=>o(e,!0))),this._noUiSlider.on("end",((t,e)=>o(e,!1)))}else this._noUiSlider.updateOptions({range:{min:t,max:e},start:s,step:i},!0);this._set_bar_color(),this.model.disabled?this.slider_el.setAttribute("disabled","true"):this.slider_el.removeAttribute("disabled"),this.title_el=(0,a.div)({class:m.slider_title}),this._update_title(),this.group_el=(0,a.div)({class:b.input_group},this.title_el,this.slider_el),this.shadow_el.appendChild(this.group_el),this._has_finished=!0}_slide(t){this.model.value=this._calc_from(t)}_change(t){const e=this._calc_from(t);this.model.setv({value:e,value_throttled:e})}}g.__name__="AbstractBaseSliderView";class v extends g{_calc_to(){return{start:this.model.start,end:this.model.end,value:[this.model.value],step:this.model.step}}_calc_from([t]){return Number.isInteger(this.model.start)&&Number.isInteger(this.model.end)&&Number.isInteger(this.model.step)?Math.round(t):t}}s.AbstractSliderView=v,v.__name__="AbstractSliderView";class f extends g{_calc_to(){return{start:this.model.start,end:this.model.end,value:this.model.value,step:this.model.step}}_calc_from(t){return t}}s.AbstractRangeSliderView=f,f.__name__="AbstractRangeSliderView";class S extends h.OrientedControl{constructor(t){super(t),this.connected=!1}pretty(t){return this._formatter(t,this.format)}}s.AbstractSlider=S,r=S,S.__name__="AbstractSlider",r.define((({Any:t,Boolean:e,Number:s,String:i,Color:l,Or:o,Enum:r,Ref:n,Nullable:a})=>({title:[a(i),""],show_value:[e,!0],start:[t],end:[t],value:[t],value_throttled:[t],step:[s,1],format:[o(i,n(c.TickFormatter))],direction:[r("ltr","rtl"),"ltr"],tooltips:[e,!0],bar_color:[l,"#e6e6e6"]})))},
500: function _(t,e,r,n,i){var o,s;o=this,s=function(t){"use strict";var e,r;function n(t){return"object"==typeof t&&"function"==typeof t.to}function i(t){t.parentElement.removeChild(t)}function o(t){return null!=t}function s(t){t.preventDefault()}function a(t){return"number"==typeof t&&!isNaN(t)&&isFinite(t)}function l(t,e,r){r>0&&(f(t,e),setTimeout((function(){d(t,e)}),r))}function u(t){return Math.max(Math.min(t,100),0)}function c(t){return Array.isArray(t)?t:[t]}function p(t){var e=(t=String(t)).split(".");return e.length>1?e[1].length:0}function f(t,e){t.classList&&!/\s/.test(e)?t.classList.add(e):t.className+=" "+e}function d(t,e){t.classList&&!/\s/.test(e)?t.classList.remove(e):t.className=t.className.replace(new RegExp("(^|\\b)"+e.split(" ").join("|")+"(\\b|$)","gi")," ")}function h(t){var e=void 0!==window.pageXOffset,r="CSS1Compat"===(t.compatMode||"");return{x:e?window.pageXOffset:r?t.documentElement.scrollLeft:t.body.scrollLeft,y:e?window.pageYOffset:r?t.documentElement.scrollTop:t.body.scrollTop}}function m(t,e){return 100/(e-t)}function g(t,e,r){return 100*e/(t[r+1]-t[r])}function v(t,e){for(var r=1;t>=e[r];)r+=1;return r}function b(t,e,r){if(r>=t.slice(-1)[0])return 100;var n=v(r,t),i=t[n-1],o=t[n],s=e[n-1],a=e[n];return s+function(t,e){return g(t,t[0]<0?e+Math.abs(t[0]):e-t[0],0)}([i,o],r)/m(s,a)}function S(t,e,r,n){if(100===n)return n;var i=v(n,t),o=t[i-1],s=t[i];return r?n-o>(s-o)/2?s:o:e[i-1]?t[i-1]+function(t,e){return Math.round(t/e)*e}(n-t[i-1],e[i-1]):n}t.PipsMode=void 0,(e=t.PipsMode||(t.PipsMode={})).Range="range",e.Steps="steps",e.Positions="positions",e.Count="count",e.Values="values",t.PipsType=void 0,(r=t.PipsType||(t.PipsType={}))[r.None=-1]="None",r[r.NoValue=0]="NoValue",r[r.LargeValue=1]="LargeValue",r[r.SmallValue=2]="SmallValue";var x=function(){function t(t,e,r){var n;this.xPct=[],this.xVal=[],this.xSteps=[],this.xNumSteps=[],this.xHighestCompleteStep=[],this.xSteps=[r||!1],this.xNumSteps=[!1],this.snap=e;var i=[];for(Object.keys(t).forEach((function(e){i.push([c(t[e]),e])})),i.sort((function(t,e){return t[0][0]-e[0][0]})),n=0;n<i.length;n++)this.handleEntryPoint(i[n][1],i[n][0]);for(this.xNumSteps=this.xSteps.slice(0),n=0;n<this.xNumSteps.length;n++)this.handleStepPoint(n,this.xNumSteps[n])}return t.prototype.getDistance=function(t){for(var e=[],r=0;r<this.xNumSteps.length-1;r++)e[r]=g(this.xVal,t,r);return e},t.prototype.getAbsoluteDistance=function(t,e,r){var n,i=0;if(t<this.xPct[this.xPct.length-1])for(;t>this.xPct[i+1];)i++;else t===this.xPct[this.xPct.length-1]&&(i=this.xPct.length-2);r||t!==this.xPct[i+1]||i++,null===e&&(e=[]);var o=1,s=e[i],a=0,l=0,u=0,c=0;for(n=r?(t-this.xPct[i])/(this.xPct[i+1]-this.xPct[i]):(this.xPct[i+1]-t)/(this.xPct[i+1]-this.xPct[i]);s>0;)a=this.xPct[i+1+c]-this.xPct[i+c],e[i+c]*o+100-100*n>100?(l=a*n,o=(s-100*n)/e[i+c],n=1):(l=e[i+c]*a/100*o,o=0),r?(u-=l,this.xPct.length+c>=1&&c--):(u+=l,this.xPct.length-c>=1&&c++),s=e[i+c]*o;return t+u},t.prototype.toStepping=function(t){return t=b(this.xVal,this.xPct,t)},t.prototype.fromStepping=function(t){return function(t,e,r){if(r>=100)return t.slice(-1)[0];var n=v(r,e),i=t[n-1],o=t[n],s=e[n-1];return function(t,e){return e*(t[1]-t[0])/100+t[0]}([i,o],(r-s)*m(s,e[n]))}(this.xVal,this.xPct,t)},t.prototype.getStep=function(t){return t=S(this.xPct,this.xSteps,this.snap,t)},t.prototype.getDefaultStep=function(t,e,r){var n=v(t,this.xPct);return(100===t||e&&t===this.xPct[n-1])&&(n=Math.max(n-1,1)),(this.xVal[n]-this.xVal[n-1])/r},t.prototype.getNearbySteps=function(t){var e=v(t,this.xPct);return{stepBefore:{startValue:this.xVal[e-2],step:this.xNumSteps[e-2],highestStep:this.xHighestCompleteStep[e-2]},thisStep:{startValue:this.xVal[e-1],step:this.xNumSteps[e-1],highestStep:this.xHighestCompleteStep[e-1]},stepAfter:{startValue:this.xVal[e],step:this.xNumSteps[e],highestStep:this.xHighestCompleteStep[e]}}},t.prototype.countStepDecimals=function(){var t=this.xNumSteps.map(p);return Math.max.apply(null,t)},t.prototype.hasNoSize=function(){return this.xVal[0]===this.xVal[this.xVal.length-1]},t.prototype.convert=function(t){return this.getStep(this.toStepping(t))},t.prototype.handleEntryPoint=function(t,e){var r;if(!a(r="min"===t?0:"max"===t?100:parseFloat(t))||!a(e[0]))throw new Error("noUiSlider: 'range' value isn't numeric.");this.xPct.push(r),this.xVal.push(e[0]);var n=Number(e[1]);r?this.xSteps.push(!isNaN(n)&&n):isNaN(n)||(this.xSteps[0]=n),this.xHighestCompleteStep.push(0)},t.prototype.handleStepPoint=function(t,e){if(e)if(this.xVal[t]!==this.xVal[t+1]){this.xSteps[t]=g([this.xVal[t],this.xVal[t+1]],e,0)/m(this.xPct[t],this.xPct[t+1]);var r=(this.xVal[t+1]-this.xVal[t])/this.xNumSteps[t],n=Math.ceil(Number(r.toFixed(3))-1),i=this.xVal[t]+this.xNumSteps[t]*n;this.xHighestCompleteStep[t]=i}else this.xSteps[t]=this.xHighestCompleteStep[t]=this.xVal[t]},t}(),y={to:function(t){return void 0===t?"":t.toFixed(2)},from:Number},w={target:"target",base:"base",origin:"origin",handle:"handle",handleLower:"handle-lower",handleUpper:"handle-upper",touchArea:"touch-area",horizontal:"horizontal",vertical:"vertical",background:"background",connect:"connect",connects:"connects",ltr:"ltr",rtl:"rtl",textDirectionLtr:"txt-dir-ltr",textDirectionRtl:"txt-dir-rtl",draggable:"draggable",drag:"state-drag",tap:"state-tap",active:"active",tooltip:"tooltip",pips:"pips",pipsHorizontal:"pips-horizontal",pipsVertical:"pips-vertical",marker:"marker",markerHorizontal:"marker-horizontal",markerVertical:"marker-vertical",markerNormal:"marker-normal",markerLarge:"marker-large",markerSub:"marker-sub",value:"value",valueHorizontal:"value-horizontal",valueVertical:"value-vertical",valueNormal:"value-normal",valueLarge:"value-large",valueSub:"value-sub"},E=".__tooltips",P=".__aria";function C(t,e){if(!a(e))throw new Error("noUiSlider: 'step' is not numeric.");t.singleStep=e}function N(t,e){if(!a(e))throw new Error("noUiSlider: 'keyboardPageMultiplier' is not numeric.");t.keyboardPageMultiplier=e}function V(t,e){if(!a(e))throw new Error("noUiSlider: 'keyboardMultiplier' is not numeric.");t.keyboardMultiplier=e}function k(t,e){if(!a(e))throw new Error("noUiSlider: 'keyboardDefaultStep' is not numeric.");t.keyboardDefaultStep=e}function M(t,e){if("object"!=typeof e||Array.isArray(e))throw new Error("noUiSlider: 'range' is not an object.");if(void 0===e.min||void 0===e.max)throw new Error("noUiSlider: Missing 'min' or 'max' in 'range'.");t.spectrum=new x(e,t.snap||!1,t.singleStep)}function A(t,e){if(e=c(e),!Array.isArray(e)||!e.length)throw new Error("noUiSlider: 'start' option is incorrect.");t.handles=e.length,t.start=e}function U(t,e){if("boolean"!=typeof e)throw new Error("noUiSlider: 'snap' option must be a boolean.");t.snap=e}function D(t,e){if("boolean"!=typeof e)throw new Error("noUiSlider: 'animate' option must be a boolean.");t.animate=e}function O(t,e){if("number"!=typeof e)throw new Error("noUiSlider: 'animationDuration' option must be a number.");t.animationDuration=e}function L(t,e){var r,n=[!1];if("lower"===e?e=[!0,!1]:"upper"===e&&(e=[!1,!0]),!0===e||!1===e){for(r=1;r<t.handles;r++)n.push(e);n.push(!1)}else{if(!Array.isArray(e)||!e.length||e.length!==t.handles+1)throw new Error("noUiSlider: 'connect' option doesn't match handle count.");n=e}t.connect=n}function T(t,e){switch(e){case"horizontal":t.ort=0;break;case"vertical":t.ort=1;break;default:throw new Error("noUiSlider: 'orientation' option is invalid.")}}function j(t,e){if(!a(e))throw new Error("noUiSlider: 'margin' option must be numeric.");0!==e&&(t.margin=t.spectrum.getDistance(e))}function z(t,e){if(!a(e))throw new Error("noUiSlider: 'limit' option must be numeric.");if(t.limit=t.spectrum.getDistance(e),!t.limit||t.handles<2)throw new Error("noUiSlider: 'limit' option is only supported on linear sliders with 2 or more handles.")}function H(t,e){var r;if(!a(e)&&!Array.isArray(e))throw new Error("noUiSlider: 'padding' option must be numeric or array of exactly 2 numbers.");if(Array.isArray(e)&&2!==e.length&&!a(e[0])&&!a(e[1]))throw new Error("noUiSlider: 'padding' option must be numeric or array of exactly 2 numbers.");if(0!==e){for(Array.isArray(e)||(e=[e,e]),t.padding=[t.spectrum.getDistance(e[0]),t.spectrum.getDistance(e[1])],r=0;r<t.spectrum.xNumSteps.length-1;r++)if(t.padding[0][r]<0||t.padding[1][r]<0)throw new Error("noUiSlider: 'padding' option must be a positive number(s).");var n=e[0]+e[1],i=t.spectrum.xVal[0];if(n/(t.spectrum.xVal[t.spectrum.xVal.length-1]-i)>1)throw new Error("noUiSlider: 'padding' option must not exceed 100% of the range.")}}function F(t,e){switch(e){case"ltr":t.dir=0;break;case"rtl":t.dir=1;break;default:throw new Error("noUiSlider: 'direction' option was not recognized.")}}function R(t,e){if("string"!=typeof e)throw new Error("noUiSlider: 'behaviour' must be a string containing options.");var r=e.indexOf("tap")>=0,n=e.indexOf("drag")>=0,i=e.indexOf("fixed")>=0,o=e.indexOf("snap")>=0,s=e.indexOf("hover")>=0,a=e.indexOf("unconstrained")>=0,l=e.indexOf("drag-all")>=0;if(i){if(2!==t.handles)throw new Error("noUiSlider: 'fixed' behaviour must be used with 2 handles");j(t,t.start[1]-t.start[0])}if(a&&(t.margin||t.limit))throw new Error("noUiSlider: 'unconstrained' behaviour cannot be used with margin or limit");t.events={tap:r||o,drag:n,dragAll:l,fixed:i,snap:o,hover:s,unconstrained:a}}function _(t,e){if(!1!==e)if(!0===e||n(e)){t.tooltips=[];for(var r=0;r<t.handles;r++)t.tooltips.push(e)}else{if((e=c(e)).length!==t.handles)throw new Error("noUiSlider: must pass a formatter for all handles.");e.forEach((function(t){if("boolean"!=typeof t&&!n(t))throw new Error("noUiSlider: 'tooltips' must be passed a formatter or 'false'.")})),t.tooltips=e}}function B(t,e){if(e.length!==t.handles)throw new Error("noUiSlider: must pass a attributes for all handles.");t.handleAttributes=e}function q(t,e){if(!n(e))throw new Error("noUiSlider: 'ariaFormat' requires 'to' method.");t.ariaFormat=e}function X(t,e){if(!function(t){return n(t)&&"function"==typeof t.from}(e))throw new Error("noUiSlider: 'format' requires 'to' and 'from' methods.");t.format=e}function Y(t,e){if("boolean"!=typeof e)throw new Error("noUiSlider: 'keyboardSupport' option must be a boolean.");t.keyboardSupport=e}function I(t,e){t.documentElement=e}function W(t,e){if("string"!=typeof e&&!1!==e)throw new Error("noUiSlider: 'cssPrefix' must be a string or `false`.");t.cssPrefix=e}function $(t,e){if("object"!=typeof e)throw new Error("noUiSlider: 'cssClasses' must be an object.");"string"==typeof t.cssPrefix?(t.cssClasses={},Object.keys(e).forEach((function(r){t.cssClasses[r]=t.cssPrefix+e[r]}))):t.cssClasses=e}function G(t){var e={margin:null,limit:null,padding:null,animate:!0,animationDuration:300,ariaFormat:y,format:y},r={step:{r:!1,t:C},keyboardPageMultiplier:{r:!1,t:N},keyboardMultiplier:{r:!1,t:V},keyboardDefaultStep:{r:!1,t:k},start:{r:!0,t:A},connect:{r:!0,t:L},direction:{r:!0,t:F},snap:{r:!1,t:U},animate:{r:!1,t:D},animationDuration:{r:!1,t:O},range:{r:!0,t:M},orientation:{r:!1,t:T},margin:{r:!1,t:j},limit:{r:!1,t:z},padding:{r:!1,t:H},behaviour:{r:!0,t:R},ariaFormat:{r:!1,t:q},format:{r:!1,t:X},tooltips:{r:!1,t:_},keyboardSupport:{r:!0,t:Y},documentElement:{r:!1,t:I},cssPrefix:{r:!0,t:W},cssClasses:{r:!0,t:$},handleAttributes:{r:!1,t:B}},n={connect:!1,direction:"ltr",behaviour:"tap",orientation:"horizontal",keyboardSupport:!0,cssPrefix:"noUi-",cssClasses:w,keyboardPageMultiplier:5,keyboardMultiplier:1,keyboardDefaultStep:10};t.format&&!t.ariaFormat&&(t.ariaFormat=t.format),Object.keys(r).forEach((function(i){if(o(t[i])||void 0!==n[i])r[i].t(e,o(t[i])?t[i]:n[i]);else if(r[i].r)throw new Error("noUiSlider: '"+i+"' is required.")})),e.pips=t.pips;var i=document.createElement("div"),s=void 0!==i.style.msTransform,a=void 0!==i.style.transform;return e.transformRule=a?"transform":s?"msTransform":"webkitTransform",e.style=[["left","top"],["right","bottom"]][e.dir][e.ort],e}function J(e,r,n){var a,p,m,g,v,b,S,x=window.navigator.pointerEnabled?{start:"pointerdown",move:"pointermove",end:"pointerup"}:window.navigator.msPointerEnabled?{start:"MSPointerDown",move:"MSPointerMove",end:"MSPointerUp"}:{start:"mousedown touchstart",move:"mousemove touchmove",end:"mouseup touchend"},y=window.CSS&&CSS.supports&&CSS.supports("touch-action","none")&&function(){var t=!1;try{var e=Object.defineProperty({},"passive",{get:function(){t=!0}});window.addEventListener("test",null,e)}catch(t){}return t}(),w=e,C=r.spectrum,N=[],V=[],k=[],M=0,A={},U=e.ownerDocument,D=r.documentElement||U.documentElement,O=U.body,L="rtl"===U.dir||1===r.ort?0:100;function T(t,e){var r=U.createElement("div");return e&&f(r,e),t.appendChild(r),r}function j(t,e){var n=T(t,r.cssClasses.origin),i=T(n,r.cssClasses.handle);if(T(i,r.cssClasses.touchArea),i.setAttribute("data-handle",String(e)),r.keyboardSupport&&(i.setAttribute("tabindex","0"),i.addEventListener("keydown",(function(t){return function(t,e){if(F()||R(e))return!1;var n=["Left","Right"],i=["Down","Up"],o=["PageDown","PageUp"],s=["Home","End"];r.dir&&!r.ort?n.reverse():r.ort&&!r.dir&&(i.reverse(),o.reverse());var a,l=t.key.replace("Arrow",""),u=l===o[0],c=l===o[1],p=l===i[0]||l===n[0]||u,f=l===i[1]||l===n[1]||c,d=l===s[0],h=l===s[1];if(!(p||f||d||h))return!0;if(t.preventDefault(),f||p){var m=p?0:1,g=vt(e)[m];if(null===g)return!1;!1===g&&(g=C.getDefaultStep(V[e],p,r.keyboardDefaultStep)),g*=c||u?r.keyboardPageMultiplier:r.keyboardMultiplier,g=Math.max(g,1e-7),g*=p?-1:1,a=N[e]+g}else a=h?r.spectrum.xVal[r.spectrum.xVal.length-1]:r.spectrum.xVal[0];return ft(e,C.toStepping(a),!0,!0),st("slide",e),st("update",e),st("change",e),st("set",e),!1}(t,e)}))),void 0!==r.handleAttributes){var o=r.handleAttributes[e];Object.keys(o).forEach((function(t){i.setAttribute(t,o[t])}))}return i.setAttribute("role","slider"),i.setAttribute("aria-orientation",r.ort?"vertical":"horizontal"),0===e?f(i,r.cssClasses.handleLower):e===r.handles-1&&f(i,r.cssClasses.handleUpper),n}function z(t,e){return!!e&&T(t,r.cssClasses.connect)}function H(t,e){return!(!r.tooltips||!r.tooltips[e])&&T(t.firstChild,r.cssClasses.tooltip)}function F(){return w.hasAttribute("disabled")}function R(t){return p[t].hasAttribute("disabled")}function _(){v&&(ot("update"+E),v.forEach((function(t){t&&i(t)})),v=null)}function B(){_(),v=p.map(H),it("update"+E,(function(t,e,n){if(v&&r.tooltips&&!1!==v[e]){var i=t[e];!0!==r.tooltips[e]&&(i=r.tooltips[e].to(n[e])),v[e].innerHTML=i}}))}function q(t,e){return t.map((function(t){return C.fromStepping(e?C.getStep(t):t)}))}function X(e){var r,n=function(e){if(e.mode===t.PipsMode.Range||e.mode===t.PipsMode.Steps)return C.xVal;if(e.mode===t.PipsMode.Count){if(e.values<2)throw new Error("noUiSlider: 'values' (>= 2) required for mode 'count'.");for(var r=e.values-1,n=100/r,i=[];r--;)i[r]=r*n;return i.push(100),q(i,e.stepped)}return e.mode===t.PipsMode.Positions?q(e.values,e.stepped):e.mode===t.PipsMode.Values?e.stepped?e.values.map((function(t){return C.fromStepping(C.getStep(C.toStepping(t)))})):e.values:[]}(e),i={},o=C.xVal[0],s=C.xVal[C.xVal.length-1],a=!1,l=!1,u=0;return r=n.slice().sort((function(t,e){return t-e})),(n=r.filter((function(t){return!this[t]&&(this[t]=!0)}),{}))[0]!==o&&(n.unshift(o),a=!0),n[n.length-1]!==s&&(n.push(s),l=!0),n.forEach((function(r,o){var s,c,p,f,d,h,m,g,v,b,S=r,x=n[o+1],y=e.mode===t.PipsMode.Steps;for(y&&(s=C.xNumSteps[o]),s||(s=x-S),void 0===x&&(x=S),s=Math.max(s,1e-7),c=S;c<=x;c=Number((c+s).toFixed(7))){for(g=(d=(f=C.toStepping(c))-u)/(e.density||1),b=d/(v=Math.round(g)),p=1;p<=v;p+=1)i[(h=u+p*b).toFixed(5)]=[C.fromStepping(h),0];m=n.indexOf(c)>-1?t.PipsType.LargeValue:y?t.PipsType.SmallValue:t.PipsType.NoValue,!o&&a&&c!==x&&(m=0),c===x&&l||(i[f.toFixed(5)]=[c,m]),u=f}})),i}function Y(e,n,i){var o,s,a=U.createElement("div"),l=((o={})[t.PipsType.None]="",o[t.PipsType.NoValue]=r.cssClasses.valueNormal,o[t.PipsType.LargeValue]=r.cssClasses.valueLarge,o[t.PipsType.SmallValue]=r.cssClasses.valueSub,o),u=((s={})[t.PipsType.None]="",s[t.PipsType.NoValue]=r.cssClasses.markerNormal,s[t.PipsType.LargeValue]=r.cssClasses.markerLarge,s[t.PipsType.SmallValue]=r.cssClasses.markerSub,s),c=[r.cssClasses.valueHorizontal,r.cssClasses.valueVertical],p=[r.cssClasses.markerHorizontal,r.cssClasses.markerVertical];function d(t,e){var n=e===r.cssClasses.value,i=n?l:u;return e+" "+(n?c:p)[r.ort]+" "+i[t]}return f(a,r.cssClasses.pips),f(a,0===r.ort?r.cssClasses.pipsHorizontal:r.cssClasses.pipsVertical),Object.keys(e).forEach((function(o){!function(e,o,s){if((s=n?n(o,s):s)!==t.PipsType.None){var l=T(a,!1);l.className=d(s,r.cssClasses.marker),l.style[r.style]=e+"%",s>t.PipsType.NoValue&&((l=T(a,!1)).className=d(s,r.cssClasses.value),l.setAttribute("data-value",String(o)),l.style[r.style]=e+"%",l.innerHTML=String(i.to(o)))}}(o,e[o][0],e[o][1])})),a}function I(){g&&(i(g),g=null)}function W(t){I();var e=X(t),r=t.filter,n=t.format||{to:function(t){return String(Math.round(t))}};return g=w.appendChild(Y(e,r,n))}function $(){var t=a.getBoundingClientRect(),e="offset"+["Width","Height"][r.ort];return 0===r.ort?t.width||a[e]:t.height||a[e]}function J(t,e,n,i){var o=function(o){var s,a,l=function(t,e,r){var n=0===t.type.indexOf("touch"),i=0===t.type.indexOf("mouse"),o=0===t.type.indexOf("pointer"),s=0,a=0;if(0===t.type.indexOf("MSPointer")&&(o=!0),"mousedown"===t.type&&!t.buttons&&!t.touches)return!1;if(n){var l=function(e){var n=e.target;return n===r||r.contains(n)||t.composed&&t.composedPath().shift()===r};if("touchstart"===t.type){var u=Array.prototype.filter.call(t.touches,l);if(u.length>1)return!1;s=u[0].pageX,a=u[0].pageY}else{var c=Array.prototype.find.call(t.changedTouches,l);if(!c)return!1;s=c.pageX,a=c.pageY}}return e=e||h(U),(i||o)&&(s=t.clientX+e.x,a=t.clientY+e.y),t.pageOffset=e,t.points=[s,a],t.cursor=i||o,t}(o,i.pageOffset,i.target||e);return!!l&&!(F()&&!i.doNotReject)&&(s=w,a=r.cssClasses.tap,!((s.classList?s.classList.contains(a):new RegExp("\\b"+a+"\\b").test(s.className))&&!i.doNotReject)&&!(t===x.start&&void 0!==l.buttons&&l.buttons>1)&&(!i.hover||!l.buttons)&&(y||l.preventDefault(),l.calcPoint=l.points[r.ort],void n(l,i)))},s=[];return t.split(" ").forEach((function(t){e.addEventListener(t,o,!!y&&{passive:!0}),s.push([t,o])})),s}function K(t){var e,n,i,o,s,l,c=100*(t-(e=a,n=r.ort,i=e.getBoundingClientRect(),o=e.ownerDocument,s=o.documentElement,l=h(o),/webkit.*Chrome.*Mobile/i.test(navigator.userAgent)&&(l.x=0),n?i.top+l.y-s.clientTop:i.left+l.x-s.clientLeft))/$();return c=u(c),r.dir?100-c:c}function Q(t,e){"mouseout"===t.type&&"HTML"===t.target.nodeName&&null===t.relatedTarget&&tt(t,e)}function Z(t,e){if(-1===navigator.appVersion.indexOf("MSIE 9")&&0===t.buttons&&0!==e.buttonsProperty)return tt(t,e);var n=(r.dir?-1:1)*(t.calcPoint-e.startCalcPoint);ut(n>0,100*n/e.baseSize,e.locations,e.handleNumbers,e.connect)}function tt(t,e){e.handle&&(d(e.handle,r.cssClasses.active),M-=1),e.listeners.forEach((function(t){D.removeEventListener(t[0],t[1])})),0===M&&(d(w,r.cssClasses.drag),pt(),t.cursor&&(O.style.cursor="",O.removeEventListener("selectstart",s))),e.handleNumbers.forEach((function(t){st("change",t),st("set",t),st("end",t)}))}function et(t,e){if(!e.handleNumbers.some(R)){var n;1===e.handleNumbers.length&&(n=p[e.handleNumbers[0]].children[0],M+=1,f(n,r.cssClasses.active)),t.stopPropagation();var i=[],o=J(x.move,D,Z,{target:t.target,handle:n,connect:e.connect,listeners:i,startCalcPoint:t.calcPoint,baseSize:$(),pageOffset:t.pageOffset,handleNumbers:e.handleNumbers,buttonsProperty:t.buttons,locations:V.slice()}),a=J(x.end,D,tt,{target:t.target,handle:n,listeners:i,doNotReject:!0,handleNumbers:e.handleNumbers}),l=J("mouseout",D,Q,{target:t.target,handle:n,listeners:i,doNotReject:!0,handleNumbers:e.handleNumbers});i.push.apply(i,o.concat(a,l)),t.cursor&&(O.style.cursor=getComputedStyle(t.target).cursor,p.length>1&&f(w,r.cssClasses.drag),O.addEventListener("selectstart",s,!1)),e.handleNumbers.forEach((function(t){st("start",t)}))}}function rt(t){t.stopPropagation();var e=K(t.calcPoint),n=function(t){var e=100,r=!1;return p.forEach((function(n,i){if(!R(i)){var o=V[i],s=Math.abs(o-t);(s<e||s<=e&&t>o||100===s&&100===e)&&(r=i,e=s)}})),r}(e);!1!==n&&(r.events.snap||l(w,r.cssClasses.tap,r.animationDuration),ft(n,e,!0,!0),pt(),st("slide",n,!0),st("update",n,!0),r.events.snap?et(t,{handleNumbers:[n]}):(st("change",n,!0),st("set",n,!0)))}function nt(t){var e=K(t.calcPoint),r=C.getStep(e),n=C.fromStepping(r);Object.keys(A).forEach((function(t){"hover"===t.split(".")[0]&&A[t].forEach((function(t){t.call(bt,n)}))}))}function it(t,e){A[t]=A[t]||[],A[t].push(e),"update"===t.split(".")[0]&&p.forEach((function(t,e){st("update",e)}))}function ot(t){var e=t&&t.split(".")[0],r=e?t.substring(e.length):t;Object.keys(A).forEach((function(t){var n=t.split(".")[0],i=t.substring(n.length);e&&e!==n||r&&r!==i||function(t){return t===P||t===E}(i)&&r!==i||delete A[t]}))}function st(t,e,n){Object.keys(A).forEach((function(i){var o=i.split(".")[0];t===o&&A[i].forEach((function(t){t.call(bt,N.map(r.format.to),e,N.slice(),n||!1,V.slice(),bt)}))}))}function at(t,e,n,i,o,s){var a;return p.length>1&&!r.events.unconstrained&&(i&&e>0&&(a=C.getAbsoluteDistance(t[e-1],r.margin,!1),n=Math.max(n,a)),o&&e<p.length-1&&(a=C.getAbsoluteDistance(t[e+1],r.margin,!0),n=Math.min(n,a))),p.length>1&&r.limit&&(i&&e>0&&(a=C.getAbsoluteDistance(t[e-1],r.limit,!1),n=Math.min(n,a)),o&&e<p.length-1&&(a=C.getAbsoluteDistance(t[e+1],r.limit,!0),n=Math.max(n,a))),r.padding&&(0===e&&(a=C.getAbsoluteDistance(0,r.padding[0],!1),n=Math.max(n,a)),e===p.length-1&&(a=C.getAbsoluteDistance(100,r.padding[1],!0),n=Math.min(n,a))),!((n=u(n=C.getStep(n)))===t[e]&&!s)&&n}function lt(t,e){var n=r.ort;return(n?e:t)+", "+(n?t:e)}function ut(t,e,r,n,i){var o=r.slice(),s=n[0],a=[!t,t],l=[t,!t];n=n.slice(),t&&n.reverse(),n.length>1?n.forEach((function(t,r){var n=at(o,t,o[t]+e,a[r],l[r],!1);!1===n?e=0:(e=n-o[t],o[t]=n)})):a=l=[!0];var u=!1;n.forEach((function(t,n){u=ft(t,r[t]+e,a[n],l[n])||u})),u&&(n.forEach((function(t){st("update",t),st("slide",t)})),null!=i&&st("drag",s))}function ct(t,e){return r.dir?100-t-e:t}function pt(){k.forEach((function(t){var e=V[t]>50?-1:1,r=3+(p.length+e*t);p[t].style.zIndex=String(r)}))}function ft(t,e,n,i,o){return o||(e=at(V,t,e,n,i,!1)),!1!==e&&(function(t,e){V[t]=e,N[t]=C.fromStepping(e);var n="translate("+lt(ct(e,0)-L+"%","0")+")";p[t].style[r.transformRule]=n,dt(t),dt(t+1)}(t,e),!0)}function dt(t){if(m[t]){var e=0,n=100;0!==t&&(e=V[t-1]),t!==m.length-1&&(n=V[t]);var i=n-e,o="translate("+lt(ct(e,i)+"%","0")+")",s="scale("+lt(i/100,"1")+")";m[t].style[r.transformRule]=o+" "+s}}function ht(t,e){return null===t||!1===t||void 0===t?V[e]:("number"==typeof t&&(t=String(t)),!1!==(t=r.format.from(t))&&(t=C.toStepping(t)),!1===t||isNaN(t)?V[e]:t)}function mt(t,e,n){var i=c(t),o=void 0===V[0];e=void 0===e||e,r.animate&&!o&&l(w,r.cssClasses.tap,r.animationDuration),k.forEach((function(t){ft(t,ht(i[t],t),!0,!1,n)}));var s=1===k.length?0:1;if(o&&C.hasNoSize()&&(n=!0,V[0]=0,k.length>1)){var a=100/(k.length-1);k.forEach((function(t){V[t]=t*a}))}for(;s<k.length;++s)k.forEach((function(t){ft(t,V[t],!0,!0,n)}));pt(),k.forEach((function(t){st("update",t),null!==i[t]&&e&&st("set",t)}))}function gt(t){if(void 0===t&&(t=!1),t)return 1===N.length?N[0]:N.slice(0);var e=N.map(r.format.to);return 1===e.length?e[0]:e}function vt(t){var e=V[t],n=C.getNearbySteps(e),i=N[t],o=n.thisStep.step,s=null;if(r.snap)return[i-n.stepBefore.startValue||null,n.stepAfter.startValue-i||null];!1!==o&&i+o>n.stepAfter.startValue&&(o=n.stepAfter.startValue-i),s=i>n.thisStep.startValue?n.thisStep.step:!1!==n.stepBefore.step&&i-n.stepBefore.highestStep,100===e?o=null:0===e&&(s=null);var a=C.countStepDecimals();return null!==o&&!1!==o&&(o=Number(o.toFixed(a))),null!==s&&!1!==s&&(s=Number(s.toFixed(a))),[s,o]}f(b=w,r.cssClasses.target),0===r.dir?f(b,r.cssClasses.ltr):f(b,r.cssClasses.rtl),0===r.ort?f(b,r.cssClasses.horizontal):f(b,r.cssClasses.vertical),f(b,"rtl"===getComputedStyle(b).direction?r.cssClasses.textDirectionRtl:r.cssClasses.textDirectionLtr),a=T(b,r.cssClasses.base),function(t,e){var n=T(e,r.cssClasses.connects);p=[],(m=[]).push(z(n,t[0]));for(var i=0;i<r.handles;i++)p.push(j(e,i)),k[i]=i,m.push(z(n,t[i+1]))}(r.connect,a),(S=r.events).fixed||p.forEach((function(t,e){J(x.start,t.children[0],et,{handleNumbers:[e]})})),S.tap&&J(x.start,a,rt,{}),S.hover&&J(x.move,a,nt,{hover:!0}),S.drag&&m.forEach((function(t,e){if(!1!==t&&0!==e&&e!==m.length-1){var n=p[e-1],i=p[e],o=[t],s=[n,i],a=[e-1,e];f(t,r.cssClasses.draggable),S.fixed&&(o.push(n.children[0]),o.push(i.children[0])),S.dragAll&&(s=p,a=k),o.forEach((function(e){J(x.start,e,et,{handles:s,handleNumbers:a,connect:t})}))}})),mt(r.start),r.pips&&W(r.pips),r.tooltips&&B(),ot("update"+P),it("update"+P,(function(t,e,n,i,o){k.forEach((function(t){var e=p[t],i=at(V,t,0,!0,!0,!0),s=at(V,t,100,!0,!0,!0),a=o[t],l=String(r.ariaFormat.to(n[t]));i=C.fromStepping(i).toFixed(1),s=C.fromStepping(s).toFixed(1),a=C.fromStepping(a).toFixed(1),e.children[0].setAttribute("aria-valuemin",i),e.children[0].setAttribute("aria-valuemax",s),e.children[0].setAttribute("aria-valuenow",a),e.children[0].setAttribute("aria-valuetext",l)}))}));var bt={destroy:function(){for(ot(P),ot(E),Object.keys(r.cssClasses).forEach((function(t){d(w,r.cssClasses[t])}));w.firstChild;)w.removeChild(w.firstChild);delete w.noUiSlider},steps:function(){return k.map(vt)},on:it,off:ot,get:gt,set:mt,setHandle:function(t,e,r,n){if(!((t=Number(t))>=0&&t<k.length))throw new Error("noUiSlider: invalid handle number, got: "+t);ft(t,ht(e,t),!0,!0,n),st("update",t),r&&st("set",t)},reset:function(t){mt(r.start,t)},__moveHandles:function(t,e,r){ut(t,e,V,r)},options:n,updateOptions:function(t,e){var i=gt(),s=["margin","limit","padding","range","animate","snap","step","format","pips","tooltips"];s.forEach((function(e){void 0!==t[e]&&(n[e]=t[e])}));var a=G(n);s.forEach((function(e){void 0!==t[e]&&(r[e]=a[e])})),C=a.spectrum,r.margin=a.margin,r.limit=a.limit,r.padding=a.padding,r.pips?W(r.pips):I(),r.tooltips?B():_(),V=[],mt(o(t.start)?t.start:i,e)},target:w,removePips:I,removeTooltips:_,getPositions:function(){return V.slice()},getTooltips:function(){return v},getOrigins:function(){return p},pips:W};return bt}function K(t,e){if(!t||!t.nodeName)throw new Error("noUiSlider: create requires a single element, got: "+t);if(t.noUiSlider)throw new Error("noUiSlider: Slider was already initialized.");var r=J(t,G(e),e);return t.noUiSlider=r,r}var Q={__spectrum:x,cssClasses:w,create:K};t.create=K,t.cssClasses=w,t.default=Q,Object.defineProperty(t,"__esModule",{value:!0})},"object"==typeof r&&void 0!==e?s(r):"function"==typeof define&&define.amd?define(["exports"],s):s((o="undefined"!=typeof globalThis?globalThis:o||self).noUiSlider={})},
501: function _(e,l,i,t,d){t(),i.slider_title="bk-slider-title",i.slider_value="bk-slider-value",i.default=".bk-slider-title{white-space:nowrap;}.bk-slider-value{font-weight:600;}"},
502: function _(i,o,t,n,r){n(),t.default='.noUi-target,.noUi-target *{-webkit-touch-callout:none;-webkit-tap-highlight-color:rgba(0, 0, 0, 0);-webkit-user-select:none;-ms-touch-action:none;touch-action:none;-ms-user-select:none;-moz-user-select:none;user-select:none;-moz-box-sizing:border-box;box-sizing:border-box;}.noUi-target{position:relative;}.noUi-base,.noUi-connects{width:100%;height:100%;position:relative;z-index:1;}.noUi-connects{overflow:hidden;z-index:0;}.noUi-connect,.noUi-origin{will-change:transform;position:absolute;z-index:1;top:0;right:0;height:100%;width:100%;-ms-transform-origin:0 0;-webkit-transform-origin:0 0;-webkit-transform-style:preserve-3d;transform-origin:0 0;transform-style:flat;}.noUi-txt-dir-rtl.noUi-horizontal .noUi-origin{left:0;right:auto;}.noUi-vertical .noUi-origin{top:-100%;width:0;}.noUi-horizontal .noUi-origin{height:0;}.noUi-handle{-webkit-backface-visibility:hidden;backface-visibility:hidden;position:absolute;}.noUi-touch-area{height:100%;width:100%;}.noUi-state-tap .noUi-connect,.noUi-state-tap .noUi-origin{-webkit-transition:transform 0.3s;transition:transform 0.3s;}.noUi-state-drag *{cursor:inherit !important;}.noUi-horizontal{height:18px;}.noUi-horizontal .noUi-handle{width:34px;height:28px;right:-17px;top:-6px;}.noUi-vertical{width:18px;}.noUi-vertical .noUi-handle{width:28px;height:34px;right:-6px;bottom:-17px;}.noUi-txt-dir-rtl.noUi-horizontal .noUi-handle{left:-17px;right:auto;}.noUi-target{background:#FAFAFA;border-radius:4px;border:1px solid #D3D3D3;box-shadow:inset 0 1px 1px #F0F0F0, 0 3px 6px -5px #BBB;}.noUi-connects{border-radius:3px;}.noUi-connect{background:#3FB8AF;}.noUi-draggable{cursor:ew-resize;}.noUi-vertical .noUi-draggable{cursor:ns-resize;}.noUi-handle{border:1px solid #D9D9D9;border-radius:3px;background:#FFF;cursor:default;box-shadow:inset 0 0 1px #FFF, inset 0 1px 7px #EBEBEB, 0 3px 6px -3px #BBB;}.noUi-active{box-shadow:inset 0 0 1px #FFF, inset 0 1px 7px #DDD, 0 3px 6px -3px #BBB;}.noUi-handle:before,.noUi-handle:after{content:"";display:block;position:absolute;height:14px;width:1px;background:#E8E7E6;left:14px;top:6px;}.noUi-handle:after{left:17px;}.noUi-vertical .noUi-handle:before,.noUi-vertical .noUi-handle:after{width:14px;height:1px;left:6px;top:14px;}.noUi-vertical .noUi-handle:after{top:17px;}[disabled] .noUi-connect{background:#B8B8B8;}[disabled].noUi-target,[disabled].noUi-handle,[disabled] .noUi-handle{cursor:not-allowed;}.noUi-pips,.noUi-pips *{-moz-box-sizing:border-box;box-sizing:border-box;}.noUi-pips{position:absolute;color:#999;}.noUi-value{position:absolute;white-space:nowrap;text-align:center;}.noUi-value-sub{color:#ccc;font-size:10px;}.noUi-marker{position:absolute;background:#CCC;}.noUi-marker-sub{background:#AAA;}.noUi-marker-large{background:#AAA;}.noUi-pips-horizontal{padding:10px 0;height:80px;top:100%;left:0;width:100%;}.noUi-value-horizontal{-webkit-transform:translate(-50%, 50%);transform:translate(-50%, 50%);}.noUi-rtl .noUi-value-horizontal{-webkit-transform:translate(50%, 50%);transform:translate(50%, 50%);}.noUi-marker-horizontal.noUi-marker{margin-left:-1px;width:2px;height:5px;}.noUi-marker-horizontal.noUi-marker-sub{height:10px;}.noUi-marker-horizontal.noUi-marker-large{height:15px;}.noUi-pips-vertical{padding:0 10px;height:100%;top:0;left:100%;}.noUi-value-vertical{-webkit-transform:translate(0, -50%);transform:translate(0, -50%);padding-left:25px;}.noUi-rtl .noUi-value-vertical{-webkit-transform:translate(0, 50%);transform:translate(0, 50%);}.noUi-marker-vertical.noUi-marker{width:5px;height:2px;margin-top:-1px;}.noUi-marker-vertical.noUi-marker-sub{width:10px;}.noUi-marker-vertical.noUi-marker-large{width:15px;}.noUi-tooltip{display:block;position:absolute;border:1px solid #D9D9D9;border-radius:3px;background:#fff;color:#000;padding:5px;text-align:center;white-space:nowrap;}.noUi-horizontal .noUi-tooltip{-webkit-transform:translate(-50%, 0);transform:translate(-50%, 0);left:50%;bottom:120%;}.noUi-vertical .noUi-tooltip{-webkit-transform:translate(0, -50%);transform:translate(0, -50%);top:50%;right:120%;}.noUi-horizontal .noUi-origin > .noUi-tooltip{-webkit-transform:translate(50%, 0);transform:translate(50%, 0);left:auto;bottom:10px;}.noUi-vertical .noUi-origin > .noUi-tooltip{-webkit-transform:translate(0, -18px);transform:translate(0, -18px);top:auto;right:28px;}.noUi-handle{cursor:grab;cursor:-webkit-grab;}.noUi-handle.noUi-active{cursor:grabbing;cursor:-webkit-grabbing;}.noUi-handle:after,.noUi-handle:before{display:none;}.noUi-tooltip{display:none;white-space:nowrap;}.noUi-handle:hover .noUi-tooltip{display:block;}:host{--slider-size:10px;--handle-width:14px;--handle-height:18px;--handle-right:calc(-1*var(--handle-width)/2);--handle-top:calc(-1*(var(--handle-height) - var(--slider-size))/2 - 1px);--slider-margin:calc((var(--handle-height) - var(--slider-size))/2 + 1px);}.noUi-horizontal{width:100%;height:var(--slider-size);}.noUi-vertical{width:var(--slider-size);height:100%;}.noUi-horizontal .noUi-handle{width:var(--handle-width);height:var(--handle-height);right:var(--handle-right);top:var(--handle-top);}.noUi-vertical .noUi-handle{width:var(--handle-height);height:var(--handle-width);right:var(--handle-top);top:var(--handle-right);}.noUi-target.noUi-horizontal{margin:var(--slider-margin) 0px;}.noUi-target.noUi-vertical{margin:0px var(--slider-margin);}'},
503: function _(e,t,r,a,i){a();var s;const d=e(1).__importDefault(e(179)),o=e(499),_=e(8);class n extends o.AbstractSliderView{}r.DateSliderView=n,n.__name__="DateSliderView";class c extends o.AbstractSlider{constructor(e){super(e),this.behaviour="tap",this.connected=[!0,!1]}_formatter(e,t){return(0,_.isString)(t)?(0,d.default)(e,t):t.compute(e)}}r.DateSlider=c,s=c,c.__name__="DateSlider",s.prototype.default_view=n,s.override({format:"%d %b %Y"})},
504: function _(e,t,s,i,r){var _;i();const n=e(505);class a extends n.MarkupView{render(){super.render(),this.model.render_as_text?this.markup_el.textContent=this.model.text:this.markup_el.innerHTML=this.has_math_disabled()?this.model.text:this.process_tex(this.model.text)}}s.DivView=a,a.__name__="DivView";class d extends n.Markup{constructor(e){super(e)}}s.Div=d,_=d,d.__name__="Div",_.prototype.default_view=a,_.define((({Boolean:e})=>({render_as_text:[e,!1]})))},
505: function _(t,e,i,s,a){s();const r=t(1);var n;const d=t(64),l=t(52),o=t(551),h=r.__importStar(t(506));class _ extends o.WidgetView{async lazy_initialize(){await super.lazy_initialize(),"not_started"!=this.provider.status&&"loading"!=this.provider.status||this.provider.ready.connect((()=>{this.contains_tex_string(this.model.text)&&this.rerender()}))}has_math_disabled(){return this.model.disable_math||!this.contains_tex_string(this.model.text)}rerender(){this.layout.invalidate_cache(),this.render(),this.root.compute_layout()}connect_signals(){super.connect_signals(),this.connect(this.model.change,(()=>{this.rerender()}))}styles(){return[...super.styles(),h.default,"p { margin: 0; }"]}_update_layout(){this.layout=new d.CachedVariadicBox(this.el),this.layout.set_sizing(this.box_sizing())}render(){super.render(),this.markup_el=(0,l.div)({class:h.clearfix,style:{display:"inline-block"}}),this.shadow_el.appendChild(this.markup_el),"failed"!=this.provider.status&&"loaded"!=this.provider.status||(this._has_finished=!0)}}i.MarkupView=_,_.__name__="MarkupView";class c extends o.Widget{constructor(t){super(t)}}i.Markup=c,n=c,c.__name__="Markup",n.define((({Boolean:t,String:e})=>({text:[e,""],disable_math:[t,!1]})))},
506: function _(e,a,f,l,r){l(),f.clearfix="bk-clearfix",f.default='.bk-clearfix:before,.bk-clearfix:after{content:"";display:table;}.bk-clearfix:after{clear:both;}'},
507: function _(e,t,i,s,n){s();const o=e(1);var l;const r=e(471),d=e(46),_=e(52),u=e(8),c=o.__importStar(e(346)),h=o.__importStar(e(480)),p=h,m=o.__importStar(e(347)),a=m;class g extends r.AbstractButtonView{constructor(){super(...arguments),this._open=!1}styles(){return[...super.styles(),h.default,m.default]}render(){super.render();const e=(0,_.div)({class:[a.caret,a.down]});if(this.model.is_split){const t=this._render_button(e);t.classList.add(c.dropdown_toggle),t.addEventListener("click",(()=>this._toggle_menu())),this.group_el.appendChild(t)}else this.button_el.appendChild(e);const t=this.model.menu.map(((e,t)=>{if(null==e)return(0,_.div)({class:p.divider});{const i=(0,u.isString)(e)?e:e[0],s=(0,_.div)(i);return s.addEventListener("click",(()=>this._item_click(t))),s}}));this.menu=(0,_.div)({class:[p.menu,p.below]},t),this.shadow_el.appendChild(this.menu),(0,_.undisplay)(this.menu)}_show_menu(){if(!this._open){this._open=!0,(0,_.display)(this.menu);const e=t=>{t.composedPath().includes(this.el)||(document.removeEventListener("click",e),this._hide_menu())};document.addEventListener("click",e)}}_hide_menu(){this._open&&(this._open=!1,(0,_.undisplay)(this.menu))}_toggle_menu(){this._open?this._hide_menu():this._show_menu()}click(){this.model.is_split?(this._hide_menu(),this.model.trigger_event(new d.ButtonClick),super.click()):this._toggle_menu()}_item_click(e){this._hide_menu();const t=this.model.menu[e];if(null!=t){const i=(0,u.isString)(t)?t:t[1];(0,u.isString)(i)?this.model.trigger_event(new d.MenuItemClick(i)):i.execute(this.model,{index:e})}}}i.DropdownView=g,g.__name__="DropdownView";class w extends r.AbstractButton{constructor(e){super(e)}get is_split(){return this.split}}i.Dropdown=w,l=w,w.__name__="Dropdown",l.prototype.default_view=g,l.define((({Null:e,Boolean:t,String:i,Array:s,Tuple:n,Or:o})=>({split:[t,!1],menu:[s(o(i,n(i,o(i)),e)),[]]}))),l.override({label:"Dropdown"})},
508: function _(e,l,t,i,s){i();const n=e(1);var a;const o=e(52),d=e(551),r=n.__importDefault(e(479));class u extends d.WidgetView{connect_signals(){super.connect_signals(),this.connect(this.model.change,(()=>this.render()))}styles(){return[...super.styles(),r.default]}render(){const{multiple:e,accept:l,disabled:t,width:i}=this.model;null==this.dialog_el&&(this.dialog_el=(0,o.input)({type:"file",multiple:e}),this.dialog_el.onchange=()=>{var e;const l=null===(e=this.dialog_el)||void 0===e?void 0:e.files;null!=l&&this.load_files(l)},this.shadow_el.appendChild(this.dialog_el)),""!=l&&(this.dialog_el.accept=l),this.dialog_el.style.width=`${i}px`,this.dialog_el.disabled=t}async load_files(e){const l=[],t=[],i=[];for(const s of e){const e=await this._read_file(s),[,n="",,a=""]=e.split(/[:;,]/,4);l.push(a),t.push(s.name),i.push(n)}this.model.multiple?this.model.setv({value:l,filename:t,mime_type:i}):this.model.setv({value:l[0],filename:t[0],mime_type:i[0]})}_read_file(e){return new Promise(((l,t)=>{const i=new FileReader;i.onload=()=>{var s;const{result:n}=i;null!=n?l(n):t(null!==(s=i.error)&&void 0!==s?s:new Error(`unable to read '${e.name}'`))},i.readAsDataURL(e)}))}}t.FileInputView=u,u.__name__="FileInputView";class _ extends d.Widget{constructor(e){super(e)}}t.FileInput=_,a=_,_.__name__="FileInput",a.prototype.default_view=u,a.define((({Boolean:e,String:l,Array:t,Or:i})=>({value:[i(l,t(l)),""],mime_type:[i(l,t(l)),""],filename:[i(l,t(l)),""],accept:[l,""],multiple:[e,!1]})))},
509: function _(e,t,s,i,n){i();const l=e(1);var o;const r=e(52),c=e(8),h=e(478),d=l.__importStar(e(479));class p extends h.InputWidgetView{connect_signals(){super.connect_signals(),this.connect(this.model.properties.value.change,(()=>this.render_selection())),this.connect(this.model.properties.options.change,(()=>this.render())),this.connect(this.model.properties.name.change,(()=>this.render())),this.connect(this.model.properties.title.change,(()=>this.render())),this.connect(this.model.properties.size.change,(()=>this.render())),this.connect(this.model.properties.disabled.change,(()=>this.render()))}render(){super.render();const e=this.model.options.map((e=>{let t,s;return(0,c.isString)(e)?t=s=e:[t,s]=e,(0,r.option)({value:t},s)}));this.input_el=(0,r.select)({multiple:!0,class:d.input,name:this.model.name,disabled:this.model.disabled},e),this.input_el.addEventListener("change",(()=>this.change_input())),this.group_el.appendChild(this.input_el),this.render_selection()}render_selection(){const e=new Set(this.model.value);for(const t of this.shadow_el.querySelectorAll("option"))t.selected=e.has(t.value);this.input_el.size=this.model.size}change_input(){const e=null!=this.shadow_el.querySelector("select:focus"),t=[];for(const e of this.shadow_el.querySelectorAll("option"))e.selected&&t.push(e.value);this.model.value=t,super.change_input(),e&&this.input_el.focus()}}s.MultiSelectView=p,p.__name__="MultiSelectView";class a extends h.InputWidget{constructor(e){super(e)}}s.MultiSelect=a,o=a,a.__name__="MultiSelect",o.prototype.default_view=p,o.define((({Int:e,String:t,Array:s,Tuple:i,Or:n})=>({value:[s(t),[]],options:[s(n(t,i(t,t))),[]],size:[e,4]})))},
510: function _(e,a,t,r,s){var n;r();const p=e(505),i=e(52);class _ extends p.MarkupView{render(){super.render();const e=(0,i.p)({style:{margin:0}});this.has_math_disabled()?e.textContent=this.model.text:e.innerHTML=this.process_tex(this.model.text),this.markup_el.appendChild(e)}}t.ParagraphView=_,_.__name__="ParagraphView";class h extends p.Markup{constructor(e){super(e)}}t.Paragraph=h,n=h,h.__name__="Paragraph",n.prototype.default_view=_},
511: function _(e,s,t,n,r){var p;n();const u=e(476);class a extends u.TextInputView{render(){super.render(),this.input_el.type="password"}}t.PasswordInputView=a,a.__name__="PasswordInputView";class o extends u.TextInput{constructor(e){super(e)}}t.PasswordInput=o,p=o,o.__name__="PasswordInput",p.prototype.default_view=a},
512: function _(e,t,i,l,s){l();const o=e(1);var n;const h=o.__importDefault(e(513)),a=e(52),u=e(8),d=e(64),c=o.__importStar(e(479)),_=o.__importDefault(e(514)),r=e(478);class p extends r.InputWidgetView{constructor(){super(...arguments),this._last_height=null}connect_signals(){super.connect_signals(),this.connect(this.model.properties.disabled.change,(()=>this.set_disabled()));const{value:e,max_items:t,option_limit:i,search_option_limit:l,delete_button:s,placeholder:o,options:n,name:h,title:a}=this.model.properties;this.on_change([e,t,i,l,s,o,n,h,a],(()=>this.render()))}styles(){return[...super.styles(),_.default]}_update_layout(){this.layout=new d.CachedVariadicBox(this.el),this.layout.set_sizing(this.box_sizing())}render(){var e,t,i,l;super.render(),this.input_el=(0,a.select)({multiple:!0,class:c.input,name:this.model.name,disabled:this.model.disabled}),this.group_el.appendChild(this.input_el);const s=new Set(this.model.value),o=this.model.options.map((e=>{let t,i;return(0,u.isString)(e)?t=i=e:[t,i]=e,{value:t,label:i,selected:s.has(t)}})),n=this.model.solid?"solid":"light",d=`choices__item ${n}`,_=`choices__button ${n}`,r={choices:o,duplicateItemsAllowed:!1,shouldSort:!1,removeItemButton:this.model.delete_button,classNames:{item:d,button:_},placeholderValue:null!==(e=this.model.placeholder)&&void 0!==e?e:void 0,maxItemCount:null!==(t=this.model.max_items)&&void 0!==t?t:void 0,renderChoiceLimit:null!==(i=this.model.option_limit)&&void 0!==i?i:void 0,searchResultLimit:null!==(l=this.model.search_option_limit)&&void 0!==l?l:void 0};this.choice_el=new h.default(this.input_el,r);const p=()=>this.choice_el.containerOuter.element.getBoundingClientRect().height;null!=this._last_height&&this._last_height!=p()&&this.root.invalidate_layout(),this._last_height=p(),this.input_el.addEventListener("change",(()=>this.change_input()))}set_disabled(){this.model.disabled?this.choice_el.disable():this.choice_el.enable()}change_input(){const e=null!=this.shadow_el.querySelector("select:focus"),t=[];for(const e of this.shadow_el.querySelectorAll("option"))e.selected&&t.push(e.value);this.model.value=t,super.change_input(),e&&this.input_el.focus()}}i.MultiChoiceView=p,p.__name__="MultiChoiceView";class m extends r.InputWidget{constructor(e){super(e)}}i.MultiChoice=m,n=m,m.__name__="MultiChoice",n.prototype.default_view=p,n.define((({Boolean:e,Int:t,String:i,Array:l,Tuple:s,Or:o,Nullable:n})=>({value:[l(i),[]],options:[l(o(i,s(i,i))),[]],max_items:[n(t),null],delete_button:[e,!0],placeholder:[n(i),null],option_limit:[n(t),null],search_option_limit:[n(t),null],solid:[e,!0]})))},
513: function _(e,t,i,n,s){
/*! choices.js v10.0.0 | © 2022 Josh Johnson | https://github.com/jshjohnson/Choices#readme */
var r,o;r=window,o=function(){return function(){"use strict";var e={282:function(e,t,i){Object.defineProperty(t,"__esModule",{value:!0}),t.clearChoices=t.activateChoices=t.filterChoices=t.addChoice=void 0;var n=i(883);t.addChoice=function(e){var t=e.value,i=e.label,s=e.id,r=e.groupId,o=e.disabled,a=e.elementId,c=e.customProperties,l=e.placeholder,h=e.keyCode;return{type:n.ACTION_TYPES.ADD_CHOICE,value:t,label:i,id:s,groupId:r,disabled:o,elementId:a,customProperties:c,placeholder:l,keyCode:h}},t.filterChoices=function(e){return{type:n.ACTION_TYPES.FILTER_CHOICES,results:e}},t.activateChoices=function(e){return void 0===e&&(e=!0),{type:n.ACTION_TYPES.ACTIVATE_CHOICES,active:e}},t.clearChoices=function(){return{type:n.ACTION_TYPES.CLEAR_CHOICES}}},783:function(e,t,i){Object.defineProperty(t,"__esModule",{value:!0}),t.addGroup=void 0;var n=i(883);t.addGroup=function(e){var t=e.value,i=e.id,s=e.active,r=e.disabled;return{type:n.ACTION_TYPES.ADD_GROUP,value:t,id:i,active:s,disabled:r}}},464:function(e,t,i){Object.defineProperty(t,"__esModule",{value:!0}),t.highlightItem=t.removeItem=t.addItem=void 0;var n=i(883);t.addItem=function(e){var t=e.value,i=e.label,s=e.id,r=e.choiceId,o=e.groupId,a=e.customProperties,c=e.placeholder,l=e.keyCode;return{type:n.ACTION_TYPES.ADD_ITEM,value:t,label:i,id:s,choiceId:r,groupId:o,customProperties:a,placeholder:c,keyCode:l}},t.removeItem=function(e,t){return{type:n.ACTION_TYPES.REMOVE_ITEM,id:e,choiceId:t}},t.highlightItem=function(e,t){return{type:n.ACTION_TYPES.HIGHLIGHT_ITEM,id:e,highlighted:t}}},137:function(e,t,i){Object.defineProperty(t,"__esModule",{value:!0}),t.setIsLoading=t.resetTo=t.clearAll=void 0;var n=i(883);t.clearAll=function(){return{type:n.ACTION_TYPES.CLEAR_ALL}},t.resetTo=function(e){return{type:n.ACTION_TYPES.RESET_TO,state:e}},t.setIsLoading=function(e){return{type:n.ACTION_TYPES.SET_IS_LOADING,isLoading:e}}},373:function(e,t,i){var n=this&&this.__spreadArray||function(e,t,i){if(i||2===arguments.length)for(var n,s=0,r=t.length;s<r;s++)!n&&s in t||(n||(n=Array.prototype.slice.call(t,0,s)),n[s]=t[s]);return e.concat(n||Array.prototype.slice.call(t))},s=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(t,"__esModule",{value:!0});var r=s(i(996)),o=s(i(221)),a=i(282),c=i(783),l=i(464),h=i(137),u=i(520),d=i(883),p=i(789),f=i(799),m=i(655),v=s(i(744)),g=s(i(686)),_="-ms-scroll-limit"in document.documentElement.style&&"-ms-ime-align"in document.documentElement.style,y={},E=function(){function e(t,i){var s=this;void 0===t&&(t="[data-choice]"),void 0===i&&(i={}),void 0===i.allowHTML&&console.warn("Deprecation warning: allowHTML will default to false in a future release. To render HTML in Choices, you will need to set it to true. Setting allowHTML will suppress this message."),this.config=r.default.all([p.DEFAULT_CONFIG,e.defaults.options,i],{arrayMerge:function(e,t){return n([],t,!0)}});var o=(0,f.diff)(this.config,p.DEFAULT_CONFIG);o.length&&console.warn("Unknown config option(s) passed",o.join(", "));var a="string"==typeof t?document.querySelector(t):t;if(!(a instanceof HTMLInputElement||a instanceof HTMLSelectElement))throw TypeError("Expected one of the following types text|select-one|select-multiple");if(this._isTextElement=a.type===d.TEXT_TYPE,this._isSelectOneElement=a.type===d.SELECT_ONE_TYPE,this._isSelectMultipleElement=a.type===d.SELECT_MULTIPLE_TYPE,this._isSelectElement=this._isSelectOneElement||this._isSelectMultipleElement,this.config.searchEnabled=this._isSelectMultipleElement||this.config.searchEnabled,["auto","always"].includes("".concat(this.config.renderSelectedChoices))||(this.config.renderSelectedChoices="auto"),i.addItemFilter&&"function"!=typeof i.addItemFilter){var c=i.addItemFilter instanceof RegExp?i.addItemFilter:new RegExp(i.addItemFilter);this.config.addItemFilter=c.test.bind(c)}if(this._isTextElement?this.passedElement=new u.WrappedInput({element:a,classNames:this.config.classNames,delimiter:this.config.delimiter}):this.passedElement=new u.WrappedSelect({element:a,classNames:this.config.classNames,template:function(e){return s._templates.option(e)}}),this.initialised=!1,this._store=new v.default,this._initialState=m.defaultState,this._currentState=m.defaultState,this._prevState=m.defaultState,this._currentValue="",this._canSearch=!!this.config.searchEnabled,this._isScrollingOnIe=!1,this._highlightPosition=0,this._wasTap=!0,this._placeholderValue=this._generatePlaceholderValue(),this._baseId=(0,f.generateId)(this.passedElement.element,"choices-"),this._direction=this.passedElement.dir,!this._direction){var l=window.getComputedStyle(this.passedElement.element).direction;l!==window.getComputedStyle(document.documentElement).direction&&(this._direction=l)}if(this._idNames={itemChoice:"item-choice"},this._isSelectElement&&(this._presetGroups=this.passedElement.optionGroups,this._presetOptions=this.passedElement.options),this._presetChoices=this.config.choices,this._presetItems=this.config.items,this.passedElement.value&&this._isTextElement){var h=this.passedElement.value.split(this.config.delimiter);this._presetItems=this._presetItems.concat(h)}if(this.passedElement.options&&this.passedElement.options.forEach((function(e){s._presetChoices.push({value:e.value,label:e.innerHTML,selected:!!e.selected,disabled:e.disabled||e.parentNode.disabled,placeholder:""===e.value||e.hasAttribute("placeholder"),customProperties:e.dataset["custom-properties"]})})),this._render=this._render.bind(this),this._onFocus=this._onFocus.bind(this),this._onBlur=this._onBlur.bind(this),this._onKeyUp=this._onKeyUp.bind(this),this._onKeyDown=this._onKeyDown.bind(this),this._onClick=this._onClick.bind(this),this._onTouchMove=this._onTouchMove.bind(this),this._onTouchEnd=this._onTouchEnd.bind(this),this._onMouseDown=this._onMouseDown.bind(this),this._onMouseOver=this._onMouseOver.bind(this),this._onFormReset=this._onFormReset.bind(this),this._onSelectKey=this._onSelectKey.bind(this),this._onEnterKey=this._onEnterKey.bind(this),this._onEscapeKey=this._onEscapeKey.bind(this),this._onDirectionKey=this._onDirectionKey.bind(this),this._onDeleteKey=this._onDeleteKey.bind(this),this.passedElement.isActive)return this.config.silent||console.warn("Trying to initialise Choices on element already initialised",{element:t}),void(this.initialised=!0);this.init()}return Object.defineProperty(e,"defaults",{get:function(){return Object.preventExtensions({get options(){return y},get templates(){return g.default}})},enumerable:!1,configurable:!0}),e.prototype.init=function(){if(!this.initialised){this._createTemplates(),this._createElements(),this._createStructure(),this._store.subscribe(this._render),this._render(),this._addEventListeners(),(!this.config.addItems||this.passedElement.element.hasAttribute("disabled"))&&this.disable(),this.initialised=!0;var e=this.config.callbackOnInit;e&&"function"==typeof e&&e.call(this)}},e.prototype.destroy=function(){this.initialised&&(this._removeEventListeners(),this.passedElement.reveal(),this.containerOuter.unwrap(this.passedElement.element),this.clearStore(),this._isSelectElement&&(this.passedElement.options=this._presetOptions),this._templates=g.default,this.initialised=!1)},e.prototype.enable=function(){return this.passedElement.isDisabled&&this.passedElement.enable(),this.containerOuter.isDisabled&&(this._addEventListeners(),this.input.enable(),this.containerOuter.enable()),this},e.prototype.disable=function(){return this.passedElement.isDisabled||this.passedElement.disable(),this.containerOuter.isDisabled||(this._removeEventListeners(),this.input.disable(),this.containerOuter.disable()),this},e.prototype.highlightItem=function(e,t){if(void 0===t&&(t=!0),!e||!e.id)return this;var i=e.id,n=e.groupId,s=void 0===n?-1:n,r=e.value,o=void 0===r?"":r,a=e.label,c=void 0===a?"":a,h=s>=0?this._store.getGroupById(s):null;return this._store.dispatch((0,l.highlightItem)(i,!0)),t&&this.passedElement.triggerEvent(d.EVENTS.highlightItem,{id:i,value:o,label:c,groupValue:h&&h.value?h.value:null}),this},e.prototype.unhighlightItem=function(e){if(!e||!e.id)return this;var t=e.id,i=e.groupId,n=void 0===i?-1:i,s=e.value,r=void 0===s?"":s,o=e.label,a=void 0===o?"":o,c=n>=0?this._store.getGroupById(n):null;return this._store.dispatch((0,l.highlightItem)(t,!1)),this.passedElement.triggerEvent(d.EVENTS.highlightItem,{id:t,value:r,label:a,groupValue:c&&c.value?c.value:null}),this},e.prototype.highlightAll=function(){var e=this;return this._store.items.forEach((function(t){return e.highlightItem(t)})),this},e.prototype.unhighlightAll=function(){var e=this;return this._store.items.forEach((function(t){return e.unhighlightItem(t)})),this},e.prototype.removeActiveItemsByValue=function(e){var t=this;return this._store.activeItems.filter((function(t){return t.value===e})).forEach((function(e){return t._removeItem(e)})),this},e.prototype.removeActiveItems=function(e){var t=this;return this._store.activeItems.filter((function(t){return t.id!==e})).forEach((function(e){return t._removeItem(e)})),this},e.prototype.removeHighlightedItems=function(e){var t=this;return void 0===e&&(e=!1),this._store.highlightedActiveItems.forEach((function(i){t._removeItem(i),e&&t._triggerChange(i.value)})),this},e.prototype.showDropdown=function(e){var t=this;return this.dropdown.isActive||requestAnimationFrame((function(){t.dropdown.show(),t.containerOuter.open(t.dropdown.distanceFromTopWindow),!e&&t._canSearch&&t.input.focus(),t.passedElement.triggerEvent(d.EVENTS.showDropdown,{})})),this},e.prototype.hideDropdown=function(e){var t=this;return this.dropdown.isActive?(requestAnimationFrame((function(){t.dropdown.hide(),t.containerOuter.close(),!e&&t._canSearch&&(t.input.removeActiveDescendant(),t.input.blur()),t.passedElement.triggerEvent(d.EVENTS.hideDropdown,{})})),this):this},e.prototype.getValue=function(e){void 0===e&&(e=!1);var t=this._store.activeItems.reduce((function(t,i){var n=e?i.value:i;return t.push(n),t}),[]);return this._isSelectOneElement?t[0]:t},e.prototype.setValue=function(e){var t=this;return this.initialised?(e.forEach((function(e){return t._setChoiceOrItem(e)})),this):this},e.prototype.setChoiceByValue=function(e){var t=this;return!this.initialised||this._isTextElement||(Array.isArray(e)?e:[e]).forEach((function(e){return t._findAndSelectChoiceByValue(e)})),this},e.prototype.setChoices=function(e,t,i,n){var s=this;if(void 0===e&&(e=[]),void 0===t&&(t="value"),void 0===i&&(i="label"),void 0===n&&(n=!1),!this.initialised)throw new ReferenceError("setChoices was called on a non-initialized instance of Choices");if(!this._isSelectElement)throw new TypeError("setChoices can't be used with INPUT based Choices");if("string"!=typeof t||!t)throw new TypeError("value parameter must be a name of 'value' field in passed objects");if(n&&this.clearChoices(),"function"==typeof e){var r=e(this);if("function"==typeof Promise&&r instanceof Promise)return new Promise((function(e){return requestAnimationFrame(e)})).then((function(){return s._handleLoadingState(!0)})).then((function(){return r})).then((function(e){return s.setChoices(e,t,i,n)})).catch((function(e){s.config.silent||console.error(e)})).then((function(){return s._handleLoadingState(!1)})).then((function(){return s}));if(!Array.isArray(r))throw new TypeError(".setChoices first argument function must return either array of choices or Promise, got: ".concat(typeof r));return this.setChoices(r,t,i,!1)}if(!Array.isArray(e))throw new TypeError(".setChoices must be called either with array of choices with a function resulting into Promise of array of choices");return this.containerOuter.removeLoadingState(),this._startLoading(),e.forEach((function(e){if(e.choices)s._addGroup({id:e.id?parseInt("".concat(e.id),10):null,group:e,valueKey:t,labelKey:i});else{var n=e;s._addChoice({value:n[t],label:n[i],isSelected:!!n.selected,isDisabled:!!n.disabled,placeholder:!!n.placeholder,customProperties:n.customProperties})}})),this._stopLoading(),this},e.prototype.clearChoices=function(){return this._store.dispatch((0,a.clearChoices)()),this},e.prototype.clearStore=function(){return this._store.dispatch((0,h.clearAll)()),this},e.prototype.clearInput=function(){var e=!this._isSelectOneElement;return this.input.clear(e),!this._isTextElement&&this._canSearch&&(this._isSearching=!1,this._store.dispatch((0,a.activateChoices)(!0))),this},e.prototype._render=function(){if(!this._store.isLoading()){this._currentState=this._store.state;var e=this._currentState.choices!==this._prevState.choices||this._currentState.groups!==this._prevState.groups||this._currentState.items!==this._prevState.items,t=this._isSelectElement,i=this._currentState.items!==this._prevState.items;e&&(t&&this._renderChoices(),i&&this._renderItems(),this._prevState=this._currentState)}},e.prototype._renderChoices=function(){var e=this,t=this._store,i=t.activeGroups,n=t.activeChoices,s=document.createDocumentFragment();if(this.choiceList.clear(),this.config.resetScrollPosition&&requestAnimationFrame((function(){return e.choiceList.scrollToTop()})),i.length>=1&&!this._isSearching){var r=n.filter((function(e){return!0===e.placeholder&&-1===e.groupId}));r.length>=1&&(s=this._createChoicesFragment(r,s)),s=this._createGroupsFragment(i,n,s)}else n.length>=1&&(s=this._createChoicesFragment(n,s));if(s.childNodes&&s.childNodes.length>0){var o=this._store.activeItems,a=this._canAddItem(o,this.input.value);if(a.response)this.choiceList.append(s),this._highlightChoice();else{var c=this._getTemplate("notice",a.notice);this.choiceList.append(c)}}else{var l=void 0;c=void 0,this._isSearching?(c="function"==typeof this.config.noResultsText?this.config.noResultsText():this.config.noResultsText,l=this._getTemplate("notice",c,"no-results")):(c="function"==typeof this.config.noChoicesText?this.config.noChoicesText():this.config.noChoicesText,l=this._getTemplate("notice",c,"no-choices")),this.choiceList.append(l)}},e.prototype._renderItems=function(){var e=this._store.activeItems||[];this.itemList.clear();var t=this._createItemsFragment(e);t.childNodes&&this.itemList.append(t)},e.prototype._createGroupsFragment=function(e,t,i){var n=this;return void 0===i&&(i=document.createDocumentFragment()),this.config.shouldSort&&e.sort(this.config.sorter),e.forEach((function(e){var s=function(e){return t.filter((function(t){return n._isSelectOneElement?t.groupId===e.id:t.groupId===e.id&&("always"===n.config.renderSelectedChoices||!t.selected)}))}(e);if(s.length>=1){var r=n._getTemplate("choiceGroup",e);i.appendChild(r),n._createChoicesFragment(s,i,!0)}})),i},e.prototype._createChoicesFragment=function(e,t,i){var s=this;void 0===t&&(t=document.createDocumentFragment()),void 0===i&&(i=!1);var r=this.config,o=r.renderSelectedChoices,a=r.searchResultLimit,c=r.renderChoiceLimit,l=this._isSearching?f.sortByScore:this.config.sorter,h=function(e){if("auto"!==o||s._isSelectOneElement||!e.selected){var i=s._getTemplate("choice",e,s.config.itemSelectText);t.appendChild(i)}},u=e;"auto"!==o||this._isSelectOneElement||(u=e.filter((function(e){return!e.selected})));var d=u.reduce((function(e,t){return t.placeholder?e.placeholderChoices.push(t):e.normalChoices.push(t),e}),{placeholderChoices:[],normalChoices:[]}),p=d.placeholderChoices,m=d.normalChoices;(this.config.shouldSort||this._isSearching)&&m.sort(l);var v=u.length,g=this._isSelectOneElement?n(n([],p,!0),m,!0):m;this._isSearching?v=a:c&&c>0&&!i&&(v=c);for(var _=0;_<v;_+=1)g[_]&&h(g[_]);return t},e.prototype._createItemsFragment=function(e,t){var i=this;void 0===t&&(t=document.createDocumentFragment());var n=this.config,s=n.shouldSortItems,r=n.sorter,o=n.removeItemButton;return s&&!this._isSelectOneElement&&e.sort(r),this._isTextElement?this.passedElement.value=e.map((function(e){return e.value})).join(this.config.delimiter):this.passedElement.options=e,e.forEach((function(e){var n=i._getTemplate("item",e,o);t.appendChild(n)})),t},e.prototype._triggerChange=function(e){null!=e&&this.passedElement.triggerEvent(d.EVENTS.change,{value:e})},e.prototype._selectPlaceholderChoice=function(e){this._addItem({value:e.value,label:e.label,choiceId:e.id,groupId:e.groupId,placeholder:e.placeholder}),this._triggerChange(e.value)},e.prototype._handleButtonAction=function(e,t){if(e&&t&&this.config.removeItems&&this.config.removeItemButton){var i=t.parentNode&&t.parentNode.dataset.id,n=i&&e.find((function(e){return e.id===parseInt(i,10)}));n&&(this._removeItem(n),this._triggerChange(n.value),this._isSelectOneElement&&this._store.placeholderChoice&&this._selectPlaceholderChoice(this._store.placeholderChoice))}},e.prototype._handleItemAction=function(e,t,i){var n=this;if(void 0===i&&(i=!1),e&&t&&this.config.removeItems&&!this._isSelectOneElement){var s=t.dataset.id;e.forEach((function(e){e.id!==parseInt("".concat(s),10)||e.highlighted?!i&&e.highlighted&&n.unhighlightItem(e):n.highlightItem(e)})),this.input.focus()}},e.prototype._handleChoiceAction=function(e,t){if(e&&t){var i=t.dataset.id,n=i&&this._store.getChoiceById(i);if(n){var s=e[0]&&e[0].keyCode?e[0].keyCode:void 0,r=this.dropdown.isActive;n.keyCode=s,this.passedElement.triggerEvent(d.EVENTS.choice,{choice:n}),n.selected||n.disabled||this._canAddItem(e,n.value).response&&(this._addItem({value:n.value,label:n.label,choiceId:n.id,groupId:n.groupId,customProperties:n.customProperties,placeholder:n.placeholder,keyCode:n.keyCode}),this._triggerChange(n.value)),this.clearInput(),r&&this._isSelectOneElement&&(this.hideDropdown(!0),this.containerOuter.focus())}}},e.prototype._handleBackspace=function(e){if(this.config.removeItems&&e){var t=e[e.length-1],i=e.some((function(e){return e.highlighted}));this.config.editItems&&!i&&t?(this.input.value=t.value,this.input.setWidth(),this._removeItem(t),this._triggerChange(t.value)):(i||this.highlightItem(t,!1),this.removeHighlightedItems(!0))}},e.prototype._startLoading=function(){this._store.dispatch((0,h.setIsLoading)(!0))},e.prototype._stopLoading=function(){this._store.dispatch((0,h.setIsLoading)(!1))},e.prototype._handleLoadingState=function(e){void 0===e&&(e=!0);var t=this.itemList.getChild(".".concat(this.config.classNames.placeholder));e?(this.disable(),this.containerOuter.addLoadingState(),this._isSelectOneElement?t?t.innerHTML=this.config.loadingText:(t=this._getTemplate("placeholder",this.config.loadingText))&&this.itemList.append(t):this.input.placeholder=this.config.loadingText):(this.enable(),this.containerOuter.removeLoadingState(),this._isSelectOneElement?t&&(t.innerHTML=this._placeholderValue||""):this.input.placeholder=this._placeholderValue||"")},e.prototype._handleSearch=function(e){if(this.input.isFocussed){var t=this._store.choices,i=this.config,n=i.searchFloor,s=i.searchChoices,r=t.some((function(e){return!e.active}));if(null!=e&&e.length>=n){var o=s?this._searchChoices(e):0;this.passedElement.triggerEvent(d.EVENTS.search,{value:e,resultCount:o})}else r&&(this._isSearching=!1,this._store.dispatch((0,a.activateChoices)(!0)))}},e.prototype._canAddItem=function(e,t){var i=!0,n="function"==typeof this.config.addItemText?this.config.addItemText(t):this.config.addItemText;if(!this._isSelectOneElement){var s=(0,f.existsInArray)(e,t);this.config.maxItemCount>0&&this.config.maxItemCount<=e.length&&(i=!1,n="function"==typeof this.config.maxItemText?this.config.maxItemText(this.config.maxItemCount):this.config.maxItemText),!this.config.duplicateItemsAllowed&&s&&i&&(i=!1,n="function"==typeof this.config.uniqueItemText?this.config.uniqueItemText(t):this.config.uniqueItemText),this._isTextElement&&this.config.addItems&&i&&"function"==typeof this.config.addItemFilter&&!this.config.addItemFilter(t)&&(i=!1,n="function"==typeof this.config.customAddItemText?this.config.customAddItemText(t):this.config.customAddItemText)}return{response:i,notice:n}},e.prototype._searchChoices=function(e){var t="string"==typeof e?e.trim():e,i="string"==typeof this._currentValue?this._currentValue.trim():this._currentValue;if(t.length<1&&t==="".concat(i," "))return 0;var s=this._store.searchableChoices,r=t,c=Object.assign(this.config.fuseOptions,{keys:n([],this.config.searchFields,!0),includeMatches:!0}),l=new o.default(s,c).search(r);return this._currentValue=t,this._highlightPosition=0,this._isSearching=!0,this._store.dispatch((0,a.filterChoices)(l)),l.length},e.prototype._addEventListeners=function(){var e=document.documentElement;e.addEventListener("touchend",this._onTouchEnd,!0),this.containerOuter.element.addEventListener("keydown",this._onKeyDown,!0),this.containerOuter.element.addEventListener("mousedown",this._onMouseDown,!0),e.addEventListener("click",this._onClick,{passive:!0}),e.addEventListener("touchmove",this._onTouchMove,{passive:!0}),this.dropdown.element.addEventListener("mouseover",this._onMouseOver,{passive:!0}),this._isSelectOneElement&&(this.containerOuter.element.addEventListener("focus",this._onFocus,{passive:!0}),this.containerOuter.element.addEventListener("blur",this._onBlur,{passive:!0})),this.input.element.addEventListener("keyup",this._onKeyUp,{passive:!0}),this.input.element.addEventListener("focus",this._onFocus,{passive:!0}),this.input.element.addEventListener("blur",this._onBlur,{passive:!0}),this.input.element.form&&this.input.element.form.addEventListener("reset",this._onFormReset,{passive:!0}),this.input.addEventListeners()},e.prototype._removeEventListeners=function(){var e=document.documentElement;e.removeEventListener("touchend",this._onTouchEnd,!0),this.containerOuter.element.removeEventListener("keydown",this._onKeyDown,!0),this.containerOuter.element.removeEventListener("mousedown",this._onMouseDown,!0),e.removeEventListener("click",this._onClick),e.removeEventListener("touchmove",this._onTouchMove),this.dropdown.element.removeEventListener("mouseover",this._onMouseOver),this._isSelectOneElement&&(this.containerOuter.element.removeEventListener("focus",this._onFocus),this.containerOuter.element.removeEventListener("blur",this._onBlur)),this.input.element.removeEventListener("keyup",this._onKeyUp),this.input.element.removeEventListener("focus",this._onFocus),this.input.element.removeEventListener("blur",this._onBlur),this.input.element.form&&this.input.element.form.removeEventListener("reset",this._onFormReset),this.input.removeEventListeners()},e.prototype._onKeyDown=function(e){var t=e.keyCode,i=this._store.activeItems,n=this.input.isFocussed,s=this.dropdown.isActive,r=this.itemList.hasChildren(),o=String.fromCharCode(t),a=/[a-zA-Z0-9-_ ]/.test(o),c=d.KEY_CODES.BACK_KEY,l=d.KEY_CODES.DELETE_KEY,h=d.KEY_CODES.ENTER_KEY,u=d.KEY_CODES.A_KEY,p=d.KEY_CODES.ESC_KEY,f=d.KEY_CODES.UP_KEY,m=d.KEY_CODES.DOWN_KEY,v=d.KEY_CODES.PAGE_UP_KEY,g=d.KEY_CODES.PAGE_DOWN_KEY;switch(this._isTextElement||s||!a||(this.showDropdown(),this.input.isFocussed||(this.input.value+=o.toLowerCase())),t){case u:return this._onSelectKey(e,r);case h:return this._onEnterKey(e,i,s);case p:return this._onEscapeKey(s);case f:case v:case m:case g:return this._onDirectionKey(e,s);case l:case c:return this._onDeleteKey(e,i,n)}},e.prototype._onKeyUp=function(e){var t=e.target,i=e.keyCode,n=this.input.value,s=this._store.activeItems,r=this._canAddItem(s,n),o=d.KEY_CODES.BACK_KEY,c=d.KEY_CODES.DELETE_KEY;if(this._isTextElement)if(r.notice&&n){var l=this._getTemplate("notice",r.notice);this.dropdown.element.innerHTML=l.outerHTML,this.showDropdown(!0)}else this.hideDropdown(!0);else{var h=(i===o||i===c)&&t&&!t.value,u=!this._isTextElement&&this._isSearching,p=this._canSearch&&r.response;h&&u?(this._isSearching=!1,this._store.dispatch((0,a.activateChoices)(!0))):p&&this._handleSearch(this.input.rawValue)}this._canSearch=this.config.searchEnabled},e.prototype._onSelectKey=function(e,t){var i=e.ctrlKey,n=e.metaKey;(i||n)&&t&&(this._canSearch=!1,this.config.removeItems&&!this.input.value&&this.input.element===document.activeElement&&this.highlightAll())},e.prototype._onEnterKey=function(e,t,i){var n=e.target,s=d.KEY_CODES.ENTER_KEY,r=n&&n.hasAttribute("data-button");if(this._isTextElement&&n&&n.value){var o=this.input.value;this._canAddItem(t,o).response&&(this.hideDropdown(!0),this._addItem({value:o}),this._triggerChange(o),this.clearInput())}if(r&&(this._handleButtonAction(t,n),e.preventDefault()),i){var a=this.dropdown.getChild(".".concat(this.config.classNames.highlightedState));a&&(t[0]&&(t[0].keyCode=s),this._handleChoiceAction(t,a)),e.preventDefault()}else this._isSelectOneElement&&(this.showDropdown(),e.preventDefault())},e.prototype._onEscapeKey=function(e){e&&(this.hideDropdown(!0),this.containerOuter.focus())},e.prototype._onDirectionKey=function(e,t){var i=e.keyCode,n=e.metaKey,s=d.KEY_CODES.DOWN_KEY,r=d.KEY_CODES.PAGE_UP_KEY,o=d.KEY_CODES.PAGE_DOWN_KEY;if(t||this._isSelectOneElement){this.showDropdown(),this._canSearch=!1;var a=i===s||i===o?1:-1,c="[data-choice-selectable]",l=void 0;if(n||i===o||i===r)l=a>0?this.dropdown.element.querySelector("".concat(c,":last-of-type")):this.dropdown.element.querySelector(c);else{var h=this.dropdown.element.querySelector(".".concat(this.config.classNames.highlightedState));l=h?(0,f.getAdjacentEl)(h,c,a):this.dropdown.element.querySelector(c)}l&&((0,f.isScrolledIntoView)(l,this.choiceList.element,a)||this.choiceList.scrollToChildElement(l,a),this._highlightChoice(l)),e.preventDefault()}},e.prototype._onDeleteKey=function(e,t,i){var n=e.target;this._isSelectOneElement||n.value||!i||(this._handleBackspace(t),e.preventDefault())},e.prototype._onTouchMove=function(){this._wasTap&&(this._wasTap=!1)},e.prototype._onTouchEnd=function(e){var t=(e||e.touches[0]).target;this._wasTap&&this.containerOuter.element.contains(t)&&((t===this.containerOuter.element||t===this.containerInner.element)&&(this._isTextElement?this.input.focus():this._isSelectMultipleElement&&this.showDropdown()),e.stopPropagation()),this._wasTap=!0},e.prototype._onMouseDown=function(e){var t=e.target;if(t instanceof HTMLElement){if(_&&this.choiceList.element.contains(t)){var i=this.choiceList.element.firstElementChild,n="ltr"===this._direction?e.offsetX>=i.offsetWidth:e.offsetX<i.offsetLeft;this._isScrollingOnIe=n}if(t!==this.input.element){var s=t.closest("[data-button],[data-item],[data-choice]");if(s instanceof HTMLElement){var r=e.shiftKey,o=this._store.activeItems,a=s.dataset;"button"in a?this._handleButtonAction(o,s):"item"in a?this._handleItemAction(o,s,r):"choice"in a&&this._handleChoiceAction(o,s)}e.preventDefault()}}},e.prototype._onMouseOver=function(e){var t=e.target;t instanceof HTMLElement&&"choice"in t.dataset&&this._highlightChoice(t)},e.prototype._onClick=function(e){var t=e.target;this.containerOuter.element.contains(t)?this.dropdown.isActive||this.containerOuter.isDisabled?this._isSelectOneElement&&t!==this.input.element&&!this.dropdown.element.contains(t)&&this.hideDropdown():this._isTextElement?document.activeElement!==this.input.element&&this.input.focus():(this.showDropdown(),this.containerOuter.focus()):(this._store.highlightedActiveItems.length>0&&this.unhighlightAll(),this.containerOuter.removeFocusState(),this.hideDropdown(!0))},e.prototype._onFocus=function(e){var t,i=this,n=e.target;n&&this.containerOuter.element.contains(n)&&((t={})[d.TEXT_TYPE]=function(){n===i.input.element&&i.containerOuter.addFocusState()},t[d.SELECT_ONE_TYPE]=function(){i.containerOuter.addFocusState(),n===i.input.element&&i.showDropdown(!0)},t[d.SELECT_MULTIPLE_TYPE]=function(){n===i.input.element&&(i.showDropdown(!0),i.containerOuter.addFocusState())},t)[this.passedElement.element.type]()},e.prototype._onBlur=function(e){var t,i=this,n=e.target;if(n&&this.containerOuter.element.contains(n)&&!this._isScrollingOnIe){var s=this._store.activeItems.some((function(e){return e.highlighted}));((t={})[d.TEXT_TYPE]=function(){n===i.input.element&&(i.containerOuter.removeFocusState(),s&&i.unhighlightAll(),i.hideDropdown(!0))},t[d.SELECT_ONE_TYPE]=function(){i.containerOuter.removeFocusState(),(n===i.input.element||n===i.containerOuter.element&&!i._canSearch)&&i.hideDropdown(!0)},t[d.SELECT_MULTIPLE_TYPE]=function(){n===i.input.element&&(i.containerOuter.removeFocusState(),i.hideDropdown(!0),s&&i.unhighlightAll())},t)[this.passedElement.element.type]()}else this._isScrollingOnIe=!1,this.input.element.focus()},e.prototype._onFormReset=function(){this._store.dispatch((0,h.resetTo)(this._initialState))},e.prototype._highlightChoice=function(e){var t=this;void 0===e&&(e=null);var i=Array.from(this.dropdown.element.querySelectorAll("[data-choice-selectable]"));if(i.length){var n=e;Array.from(this.dropdown.element.querySelectorAll(".".concat(this.config.classNames.highlightedState))).forEach((function(e){e.classList.remove(t.config.classNames.highlightedState),e.setAttribute("aria-selected","false")})),n?this._highlightPosition=i.indexOf(n):(n=i.length>this._highlightPosition?i[this._highlightPosition]:i[i.length-1])||(n=i[0]),n.classList.add(this.config.classNames.highlightedState),n.setAttribute("aria-selected","true"),this.passedElement.triggerEvent(d.EVENTS.highlightChoice,{el:n}),this.dropdown.isActive&&(this.input.setActiveDescendant(n.id),this.containerOuter.setActiveDescendant(n.id))}},e.prototype._addItem=function(e){var t=e.value,i=e.label,n=void 0===i?null:i,s=e.choiceId,r=void 0===s?-1:s,o=e.groupId,a=void 0===o?-1:o,c=e.customProperties,h=void 0===c?{}:c,u=e.placeholder,p=void 0!==u&&u,f=e.keyCode,m=void 0===f?-1:f,v="string"==typeof t?t.trim():t,g=this._store.items,_=n||v,y=r||-1,E=a>=0?this._store.getGroupById(a):null,b=g?g.length+1:1;this.config.prependValue&&(v=this.config.prependValue+v.toString()),this.config.appendValue&&(v+=this.config.appendValue.toString()),this._store.dispatch((0,l.addItem)({value:v,label:_,id:b,choiceId:y,groupId:a,customProperties:h,placeholder:p,keyCode:m})),this._isSelectOneElement&&this.removeActiveItems(b),this.passedElement.triggerEvent(d.EVENTS.addItem,{id:b,value:v,label:_,customProperties:h,groupValue:E&&E.value?E.value:null,keyCode:m})},e.prototype._removeItem=function(e){var t=e.id,i=e.value,n=e.label,s=e.customProperties,r=e.choiceId,o=e.groupId,a=o&&o>=0?this._store.getGroupById(o):null;t&&r&&(this._store.dispatch((0,l.removeItem)(t,r)),this.passedElement.triggerEvent(d.EVENTS.removeItem,{id:t,value:i,label:n,customProperties:s,groupValue:a&&a.value?a.value:null}))},e.prototype._addChoice=function(e){var t=e.value,i=e.label,n=void 0===i?null:i,s=e.isSelected,r=void 0!==s&&s,o=e.isDisabled,c=void 0!==o&&o,l=e.groupId,h=void 0===l?-1:l,u=e.customProperties,d=void 0===u?{}:u,p=e.placeholder,f=void 0!==p&&p,m=e.keyCode,v=void 0===m?-1:m;if(null!=t){var g=this._store.choices,_=n||t,y=g?g.length+1:1,E="".concat(this._baseId,"-").concat(this._idNames.itemChoice,"-").concat(y);this._store.dispatch((0,a.addChoice)({id:y,groupId:h,elementId:E,value:t,label:_,disabled:c,customProperties:d,placeholder:f,keyCode:v})),r&&this._addItem({value:t,label:_,choiceId:y,customProperties:d,placeholder:f,keyCode:v})}},e.prototype._addGroup=function(e){var t=this,i=e.group,n=e.id,s=e.valueKey,r=void 0===s?"value":s,o=e.labelKey,a=void 0===o?"label":o,l=(0,f.isType)("Object",i)?i.choices:Array.from(i.getElementsByTagName("OPTION")),h=n||Math.floor((new Date).valueOf()*Math.random()),u=!!i.disabled&&i.disabled;l?(this._store.dispatch((0,c.addGroup)({value:i.label,id:h,active:!0,disabled:u})),l.forEach((function(e){var i=e.disabled||e.parentNode&&e.parentNode.disabled;t._addChoice({value:e[r],label:(0,f.isType)("Object",e)?e[a]:e.innerHTML,isSelected:e.selected,isDisabled:i,groupId:h,customProperties:e.customProperties,placeholder:e.placeholder})}))):this._store.dispatch((0,c.addGroup)({value:i.label,id:i.id,active:!1,disabled:i.disabled}))},e.prototype._getTemplate=function(e){for(var t,i=[],s=1;s<arguments.length;s++)i[s-1]=arguments[s];return(t=this._templates[e]).call.apply(t,n([this,this.config],i,!1))},e.prototype._createTemplates=function(){var e=this.config.callbackOnCreateTemplates,t={};e&&"function"==typeof e&&(t=e.call(this,f.strToEl)),this._templates=(0,r.default)(g.default,t)},e.prototype._createElements=function(){this.containerOuter=new u.Container({element:this._getTemplate("containerOuter",this._direction,this._isSelectElement,this._isSelectOneElement,this.config.searchEnabled,this.passedElement.element.type),classNames:this.config.classNames,type:this.passedElement.element.type,position:this.config.position}),this.containerInner=new u.Container({element:this._getTemplate("containerInner"),classNames:this.config.classNames,type:this.passedElement.element.type,position:this.config.position}),this.input=new u.Input({element:this._getTemplate("input",this._placeholderValue),classNames:this.config.classNames,type:this.passedElement.element.type,preventPaste:!this.config.paste}),this.choiceList=new u.List({element:this._getTemplate("choiceList",this._isSelectOneElement)}),this.itemList=new u.List({element:this._getTemplate("itemList",this._isSelectOneElement)}),this.dropdown=new u.Dropdown({element:this._getTemplate("dropdown"),classNames:this.config.classNames,type:this.passedElement.element.type})},e.prototype._createStructure=function(){this.passedElement.conceal(),this.containerInner.wrap(this.passedElement.element),this.containerOuter.wrap(this.containerInner.element),this._isSelectOneElement?this.input.placeholder=this.config.searchPlaceholderValue||"":this._placeholderValue&&(this.input.placeholder=this._placeholderValue,this.input.setWidth()),this.containerOuter.element.appendChild(this.containerInner.element),this.containerOuter.element.appendChild(this.dropdown.element),this.containerInner.element.appendChild(this.itemList.element),this._isTextElement||this.dropdown.element.appendChild(this.choiceList.element),this._isSelectOneElement?this.config.searchEnabled&&this.dropdown.element.insertBefore(this.input.element,this.dropdown.element.firstChild):this.containerInner.element.appendChild(this.input.element),this._isSelectElement&&(this._highlightPosition=0,this._isSearching=!1,this._startLoading(),this._presetGroups.length?this._addPredefinedGroups(this._presetGroups):this._addPredefinedChoices(this._presetChoices),this._stopLoading()),this._isTextElement&&this._addPredefinedItems(this._presetItems)},e.prototype._addPredefinedGroups=function(e){var t=this,i=this.passedElement.placeholderOption;i&&i.parentNode&&"SELECT"===i.parentNode.tagName&&this._addChoice({value:i.value,label:i.innerHTML,isSelected:i.selected,isDisabled:i.disabled,placeholder:!0}),e.forEach((function(e){return t._addGroup({group:e,id:e.id||null})}))},e.prototype._addPredefinedChoices=function(e){var t=this;this.config.shouldSort&&e.sort(this.config.sorter);var i=e.some((function(e){return e.selected})),n=e.findIndex((function(e){return void 0===e.disabled||!e.disabled}));e.forEach((function(e,s){var r=e.value,o=void 0===r?"":r,a=e.label,c=e.customProperties,l=e.placeholder;if(t._isSelectElement)if(e.choices)t._addGroup({group:e,id:e.id||null});else{var h=!(!t._isSelectOneElement||i||s!==n)||e.selected,u=e.disabled;t._addChoice({value:o,label:a,isSelected:!!h,isDisabled:!!u,placeholder:!!l,customProperties:c})}else t._addChoice({value:o,label:a,isSelected:!!e.selected,isDisabled:!!e.disabled,placeholder:!!e.placeholder,customProperties:c})}))},e.prototype._addPredefinedItems=function(e){var t=this;e.forEach((function(e){"object"==typeof e&&e.value&&t._addItem({value:e.value,label:e.label,choiceId:e.id,customProperties:e.customProperties,placeholder:e.placeholder}),"string"==typeof e&&t._addItem({value:e})}))},e.prototype._setChoiceOrItem=function(e){var t=this;({object:function(){e.value&&(t._isTextElement?t._addItem({value:e.value,label:e.label,choiceId:e.id,customProperties:e.customProperties,placeholder:e.placeholder}):t._addChoice({value:e.value,label:e.label,isSelected:!0,isDisabled:!1,customProperties:e.customProperties,placeholder:e.placeholder}))},string:function(){t._isTextElement?t._addItem({value:e}):t._addChoice({value:e,label:e,isSelected:!0,isDisabled:!1})}})[(0,f.getType)(e).toLowerCase()]()},e.prototype._findAndSelectChoiceByValue=function(e){var t=this,i=this._store.choices.find((function(i){return t.config.valueComparer(i.value,e)}));i&&!i.selected&&this._addItem({value:i.value,label:i.label,choiceId:i.id,groupId:i.groupId,customProperties:i.customProperties,placeholder:i.placeholder,keyCode:i.keyCode})},e.prototype._generatePlaceholderValue=function(){if(this._isSelectElement&&this.passedElement.placeholderOption){var e=this.passedElement.placeholderOption;return e?e.text:null}var t=this.config,i=t.placeholder,n=t.placeholderValue,s=this.passedElement.element.dataset;if(i){if(n)return n;if(s.placeholder)return s.placeholder}return null},e}();t.default=E},613:function(e,t,i){Object.defineProperty(t,"__esModule",{value:!0});var n=i(799),s=i(883),r=function(){function e(e){var t=e.element,i=e.type,n=e.classNames,s=e.position;this.element=t,this.classNames=n,this.type=i,this.position=s,this.isOpen=!1,this.isFlipped=!1,this.isFocussed=!1,this.isDisabled=!1,this.isLoading=!1,this._onFocus=this._onFocus.bind(this),this._onBlur=this._onBlur.bind(this)}return e.prototype.addEventListeners=function(){this.element.addEventListener("focus",this._onFocus),this.element.addEventListener("blur",this._onBlur)},e.prototype.removeEventListeners=function(){this.element.removeEventListener("focus",this._onFocus),this.element.removeEventListener("blur",this._onBlur)},e.prototype.shouldFlip=function(e){if("number"!=typeof e)return!1;var t=!1;return"auto"===this.position?t=!window.matchMedia("(min-height: ".concat(e+1,"px)")).matches:"top"===this.position&&(t=!0),t},e.prototype.setActiveDescendant=function(e){this.element.setAttribute("aria-activedescendant",e)},e.prototype.removeActiveDescendant=function(){this.element.removeAttribute("aria-activedescendant")},e.prototype.open=function(e){this.element.classList.add(this.classNames.openState),this.element.setAttribute("aria-expanded","true"),this.isOpen=!0,this.shouldFlip(e)&&(this.element.classList.add(this.classNames.flippedState),this.isFlipped=!0)},e.prototype.close=function(){this.element.classList.remove(this.classNames.openState),this.element.setAttribute("aria-expanded","false"),this.removeActiveDescendant(),this.isOpen=!1,this.isFlipped&&(this.element.classList.remove(this.classNames.flippedState),this.isFlipped=!1)},e.prototype.focus=function(){this.isFocussed||this.element.focus()},e.prototype.addFocusState=function(){this.element.classList.add(this.classNames.focusState)},e.prototype.removeFocusState=function(){this.element.classList.remove(this.classNames.focusState)},e.prototype.enable=function(){this.element.classList.remove(this.classNames.disabledState),this.element.removeAttribute("aria-disabled"),this.type===s.SELECT_ONE_TYPE&&this.element.setAttribute("tabindex","0"),this.isDisabled=!1},e.prototype.disable=function(){this.element.classList.add(this.classNames.disabledState),this.element.setAttribute("aria-disabled","true"),this.type===s.SELECT_ONE_TYPE&&this.element.setAttribute("tabindex","-1"),this.isDisabled=!0},e.prototype.wrap=function(e){(0,n.wrap)(e,this.element)},e.prototype.unwrap=function(e){this.element.parentNode&&(this.element.parentNode.insertBefore(e,this.element),this.element.parentNode.removeChild(this.element))},e.prototype.addLoadingState=function(){this.element.classList.add(this.classNames.loadingState),this.element.setAttribute("aria-busy","true"),this.isLoading=!0},e.prototype.removeLoadingState=function(){this.element.classList.remove(this.classNames.loadingState),this.element.removeAttribute("aria-busy"),this.isLoading=!1},e.prototype._onFocus=function(){this.isFocussed=!0},e.prototype._onBlur=function(){this.isFocussed=!1},e}();t.default=r},217:function(e,t){Object.defineProperty(t,"__esModule",{value:!0});var i=function(){function e(e){var t=e.element,i=e.type,n=e.classNames;this.element=t,this.classNames=n,this.type=i,this.isActive=!1}return Object.defineProperty(e.prototype,"distanceFromTopWindow",{get:function(){return this.element.getBoundingClientRect().bottom},enumerable:!1,configurable:!0}),e.prototype.getChild=function(e){return this.element.querySelector(e)},e.prototype.show=function(){return this.element.classList.add(this.classNames.activeState),this.element.setAttribute("aria-expanded","true"),this.isActive=!0,this},e.prototype.hide=function(){return this.element.classList.remove(this.classNames.activeState),this.element.setAttribute("aria-expanded","false"),this.isActive=!1,this},e}();t.default=i},520:function(e,t,i){var n=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(t,"__esModule",{value:!0}),t.WrappedSelect=t.WrappedInput=t.List=t.Input=t.Container=t.Dropdown=void 0;var s=n(i(217));t.Dropdown=s.default;var r=n(i(613));t.Container=r.default;var o=n(i(11));t.Input=o.default;var a=n(i(624));t.List=a.default;var c=n(i(541));t.WrappedInput=c.default;var l=n(i(982));t.WrappedSelect=l.default},11:function(e,t,i){Object.defineProperty(t,"__esModule",{value:!0});var n=i(799),s=i(883),r=function(){function e(e){var t=e.element,i=e.type,n=e.classNames,s=e.preventPaste;this.element=t,this.type=i,this.classNames=n,this.preventPaste=s,this.isFocussed=this.element.isEqualNode(document.activeElement),this.isDisabled=t.disabled,this._onPaste=this._onPaste.bind(this),this._onInput=this._onInput.bind(this),this._onFocus=this._onFocus.bind(this),this._onBlur=this._onBlur.bind(this)}return Object.defineProperty(e.prototype,"placeholder",{set:function(e){this.element.placeholder=e},enumerable:!1,configurable:!0}),Object.defineProperty(e.prototype,"value",{get:function(){return(0,n.sanitise)(this.element.value)},set:function(e){this.element.value=e},enumerable:!1,configurable:!0}),Object.defineProperty(e.prototype,"rawValue",{get:function(){return this.element.value},enumerable:!1,configurable:!0}),e.prototype.addEventListeners=function(){this.element.addEventListener("paste",this._onPaste),this.element.addEventListener("input",this._onInput,{passive:!0}),this.element.addEventListener("focus",this._onFocus,{passive:!0}),this.element.addEventListener("blur",this._onBlur,{passive:!0})},e.prototype.removeEventListeners=function(){this.element.removeEventListener("input",this._onInput),this.element.removeEventListener("paste",this._onPaste),this.element.removeEventListener("focus",this._onFocus),this.element.removeEventListener("blur",this._onBlur)},e.prototype.enable=function(){this.element.removeAttribute("disabled"),this.isDisabled=!1},e.prototype.disable=function(){this.element.setAttribute("disabled",""),this.isDisabled=!0},e.prototype.focus=function(){this.isFocussed||this.element.focus()},e.prototype.blur=function(){this.isFocussed&&this.element.blur()},e.prototype.clear=function(e){return void 0===e&&(e=!0),this.element.value&&(this.element.value=""),e&&this.setWidth(),this},e.prototype.setWidth=function(){var e=this.element,t=e.style,i=e.value,n=e.placeholder;t.minWidth="".concat(n.length+1,"ch"),t.width="".concat(i.length+1,"ch")},e.prototype.setActiveDescendant=function(e){this.element.setAttribute("aria-activedescendant",e)},e.prototype.removeActiveDescendant=function(){this.element.removeAttribute("aria-activedescendant")},e.prototype._onInput=function(){this.type!==s.SELECT_ONE_TYPE&&this.setWidth()},e.prototype._onPaste=function(e){this.preventPaste&&e.preventDefault()},e.prototype._onFocus=function(){this.isFocussed=!0},e.prototype._onBlur=function(){this.isFocussed=!1},e}();t.default=r},624:function(e,t,i){Object.defineProperty(t,"__esModule",{value:!0});var n=i(883),s=function(){function e(e){var t=e.element;this.element=t,this.scrollPos=this.element.scrollTop,this.height=this.element.offsetHeight}return e.prototype.clear=function(){this.element.innerHTML=""},e.prototype.append=function(e){this.element.appendChild(e)},e.prototype.getChild=function(e){return this.element.querySelector(e)},e.prototype.hasChildren=function(){return this.element.hasChildNodes()},e.prototype.scrollToTop=function(){this.element.scrollTop=0},e.prototype.scrollToChildElement=function(e,t){var i=this;if(e){var n=this.element.offsetHeight,s=this.element.scrollTop+n,r=e.offsetHeight,o=e.offsetTop+r,a=t>0?this.element.scrollTop+o-s:e.offsetTop;requestAnimationFrame((function(){i._animateScroll(a,t)}))}},e.prototype._scrollDown=function(e,t,i){var n=(i-e)/t,s=n>1?n:1;this.element.scrollTop=e+s},e.prototype._scrollUp=function(e,t,i){var n=(e-i)/t,s=n>1?n:1;this.element.scrollTop=e-s},e.prototype._animateScroll=function(e,t){var i=this,s=n.SCROLLING_SPEED,r=this.element.scrollTop,o=!1;t>0?(this._scrollDown(r,s,e),r<e&&(o=!0)):(this._scrollUp(r,s,e),r>e&&(o=!0)),o&&requestAnimationFrame((function(){i._animateScroll(e,t)}))},e}();t.default=s},730:function(e,t,i){Object.defineProperty(t,"__esModule",{value:!0});var n=i(799),s=function(){function e(e){var t=e.element,i=e.classNames;if(this.element=t,this.classNames=i,!(t instanceof HTMLInputElement||t instanceof HTMLSelectElement))throw new TypeError("Invalid element passed");this.isDisabled=!1}return Object.defineProperty(e.prototype,"isActive",{get:function(){return"active"===this.element.dataset.choice},enumerable:!1,configurable:!0}),Object.defineProperty(e.prototype,"dir",{get:function(){return this.element.dir},enumerable:!1,configurable:!0}),Object.defineProperty(e.prototype,"value",{get:function(){return this.element.value},set:function(e){this.element.value=e},enumerable:!1,configurable:!0}),e.prototype.conceal=function(){this.element.classList.add(this.classNames.input),this.element.hidden=!0,this.element.tabIndex=-1;var e=this.element.getAttribute("style");e&&this.element.setAttribute("data-choice-orig-style",e),this.element.setAttribute("data-choice","active")},e.prototype.reveal=function(){this.element.classList.remove(this.classNames.input),this.element.hidden=!1,this.element.removeAttribute("tabindex");var e=this.element.getAttribute("data-choice-orig-style");e?(this.element.removeAttribute("data-choice-orig-style"),this.element.setAttribute("style",e)):this.element.removeAttribute("style"),this.element.removeAttribute("data-choice"),this.element.value=this.element.value},e.prototype.enable=function(){this.element.removeAttribute("disabled"),this.element.disabled=!1,this.isDisabled=!1},e.prototype.disable=function(){this.element.setAttribute("disabled",""),this.element.disabled=!0,this.isDisabled=!0},e.prototype.triggerEvent=function(e,t){(0,n.dispatchEvent)(this.element,e,t)},e}();t.default=s},541:function(e,t,i){var n,s=this&&this.__extends||(n=function(e,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(e,t){e.__proto__=t}||function(e,t){for(var i in t)Object.prototype.hasOwnProperty.call(t,i)&&(e[i]=t[i])},n(e,t)},function(e,t){if("function"!=typeof t&&null!==t)throw new TypeError("Class extends value "+String(t)+" is not a constructor or null");function i(){this.constructor=e}n(e,t),e.prototype=null===t?Object.create(t):(i.prototype=t.prototype,new i)}),r=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(t,"__esModule",{value:!0});var o=function(e){function t(t){var i=t.element,n=t.classNames,s=t.delimiter,r=e.call(this,{element:i,classNames:n})||this;return r.delimiter=s,r}return s(t,e),Object.defineProperty(t.prototype,"value",{get:function(){return this.element.value},set:function(e){this.element.setAttribute("value",e),this.element.value=e},enumerable:!1,configurable:!0}),t}(r(i(730)).default);t.default=o},982:function(e,t,i){var n,s=this&&this.__extends||(n=function(e,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(e,t){e.__proto__=t}||function(e,t){for(var i in t)Object.prototype.hasOwnProperty.call(t,i)&&(e[i]=t[i])},n(e,t)},function(e,t){if("function"!=typeof t&&null!==t)throw new TypeError("Class extends value "+String(t)+" is not a constructor or null");function i(){this.constructor=e}n(e,t),e.prototype=null===t?Object.create(t):(i.prototype=t.prototype,new i)}),r=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(t,"__esModule",{value:!0});var o=function(e){function t(t){var i=t.element,n=t.classNames,s=t.template,r=e.call(this,{element:i,classNames:n})||this;return r.template=s,r}return s(t,e),Object.defineProperty(t.prototype,"placeholderOption",{get:function(){return this.element.querySelector('option[value=""]')||this.element.querySelector("option[placeholder]")},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"optionGroups",{get:function(){return Array.from(this.element.getElementsByTagName("OPTGROUP"))},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"options",{get:function(){return Array.from(this.element.options)},set:function(e){var t=this,i=document.createDocumentFragment();e.forEach((function(e){return n=e,s=t.template(n),void i.appendChild(s);var n,s})),this.appendDocFragment(i)},enumerable:!1,configurable:!0}),t.prototype.appendDocFragment=function(e){this.element.innerHTML="",this.element.appendChild(e)},t}(r(i(730)).default);t.default=o},883:function(e,t){Object.defineProperty(t,"__esModule",{value:!0}),t.SCROLLING_SPEED=t.SELECT_MULTIPLE_TYPE=t.SELECT_ONE_TYPE=t.TEXT_TYPE=t.KEY_CODES=t.ACTION_TYPES=t.EVENTS=void 0,t.EVENTS={showDropdown:"showDropdown",hideDropdown:"hideDropdown",change:"change",choice:"choice",search:"search",addItem:"addItem",removeItem:"removeItem",highlightItem:"highlightItem",highlightChoice:"highlightChoice",unhighlightItem:"unhighlightItem"},t.ACTION_TYPES={ADD_CHOICE:"ADD_CHOICE",FILTER_CHOICES:"FILTER_CHOICES",ACTIVATE_CHOICES:"ACTIVATE_CHOICES",CLEAR_CHOICES:"CLEAR_CHOICES",ADD_GROUP:"ADD_GROUP",ADD_ITEM:"ADD_ITEM",REMOVE_ITEM:"REMOVE_ITEM",HIGHLIGHT_ITEM:"HIGHLIGHT_ITEM",CLEAR_ALL:"CLEAR_ALL",RESET_TO:"RESET_TO",SET_IS_LOADING:"SET_IS_LOADING"},t.KEY_CODES={BACK_KEY:46,DELETE_KEY:8,ENTER_KEY:13,A_KEY:65,ESC_KEY:27,UP_KEY:38,DOWN_KEY:40,PAGE_UP_KEY:33,PAGE_DOWN_KEY:34},t.TEXT_TYPE="text",t.SELECT_ONE_TYPE="select-one",t.SELECT_MULTIPLE_TYPE="select-multiple",t.SCROLLING_SPEED=4},789:function(e,t,i){Object.defineProperty(t,"__esModule",{value:!0}),t.DEFAULT_CONFIG=t.DEFAULT_CLASSNAMES=void 0;var n=i(799);t.DEFAULT_CLASSNAMES={containerOuter:"choices",containerInner:"choices__inner",input:"choices__input",inputCloned:"choices__input--cloned",list:"choices__list",listItems:"choices__list--multiple",listSingle:"choices__list--single",listDropdown:"choices__list--dropdown",item:"choices__item",itemSelectable:"choices__item--selectable",itemDisabled:"choices__item--disabled",itemChoice:"choices__item--choice",placeholder:"choices__placeholder",group:"choices__group",groupHeading:"choices__heading",button:"choices__button",activeState:"is-active",focusState:"is-focused",openState:"is-open",disabledState:"is-disabled",highlightedState:"is-highlighted",selectedState:"is-selected",flippedState:"is-flipped",loadingState:"is-loading",noResults:"has-no-results",noChoices:"has-no-choices"},t.DEFAULT_CONFIG={items:[],choices:[],silent:!1,renderChoiceLimit:-1,maxItemCount:-1,addItems:!0,addItemFilter:null,removeItems:!0,removeItemButton:!1,editItems:!1,allowHTML:!0,duplicateItemsAllowed:!0,delimiter:",",paste:!0,searchEnabled:!0,searchChoices:!0,searchFloor:1,searchResultLimit:4,searchFields:["label","value"],position:"auto",resetScrollPosition:!0,shouldSort:!0,shouldSortItems:!1,sorter:n.sortByAlpha,placeholder:!0,placeholderValue:null,searchPlaceholderValue:null,prependValue:null,appendValue:null,renderSelectedChoices:"auto",loadingText:"Loading...",noResultsText:"No results found",noChoicesText:"No choices to choose from",itemSelectText:"Press to select",uniqueItemText:"Only unique values can be added",customAddItemText:"Only values matching specific conditions can be added",addItemText:function(e){return'Press Enter to add <b>"'.concat((0,n.sanitise)(e),'"</b>')},maxItemText:function(e){return"Only ".concat(e," values can be added")},valueComparer:function(e,t){return e===t},fuseOptions:{includeScore:!0},callbackOnInit:null,callbackOnCreateTemplates:null,classNames:t.DEFAULT_CLASSNAMES}},18:function(e,t){Object.defineProperty(t,"__esModule",{value:!0})},978:function(e,t){Object.defineProperty(t,"__esModule",{value:!0})},948:function(e,t){Object.defineProperty(t,"__esModule",{value:!0})},359:function(e,t){Object.defineProperty(t,"__esModule",{value:!0})},285:function(e,t){Object.defineProperty(t,"__esModule",{value:!0})},533:function(e,t){Object.defineProperty(t,"__esModule",{value:!0})},187:function(e,t,i){var n=this&&this.__createBinding||(Object.create?function(e,t,i,n){void 0===n&&(n=i),Object.defineProperty(e,n,{enumerable:!0,get:function(){return t[i]}})}:function(e,t,i,n){void 0===n&&(n=i),e[n]=t[i]}),s=this&&this.__exportStar||function(e,t){for(var i in e)"default"===i||Object.prototype.hasOwnProperty.call(t,i)||n(t,e,i)};Object.defineProperty(t,"__esModule",{value:!0}),s(i(18),t),s(i(978),t),s(i(948),t),s(i(359),t),s(i(285),t),s(i(533),t),s(i(287),t),s(i(132),t),s(i(837),t),s(i(598),t),s(i(369),t),s(i(37),t),s(i(47),t),s(i(923),t),s(i(876),t)},287:function(e,t){Object.defineProperty(t,"__esModule",{value:!0})},132:function(e,t){Object.defineProperty(t,"__esModule",{value:!0})},837:function(e,t){Object.defineProperty(t,"__esModule",{value:!0})},598:function(e,t){Object.defineProperty(t,"__esModule",{value:!0})},37:function(e,t){Object.defineProperty(t,"__esModule",{value:!0})},369:function(e,t){Object.defineProperty(t,"__esModule",{value:!0})},47:function(e,t){Object.defineProperty(t,"__esModule",{value:!0})},923:function(e,t){Object.defineProperty(t,"__esModule",{value:!0})},876:function(e,t){Object.defineProperty(t,"__esModule",{value:!0})},799:function(e,t){var i;Object.defineProperty(t,"__esModule",{value:!0}),t.diff=t.cloneObject=t.existsInArray=t.dispatchEvent=t.sortByScore=t.sortByAlpha=t.strToEl=t.sanitise=t.isScrolledIntoView=t.getAdjacentEl=t.wrap=t.isType=t.getType=t.generateId=t.generateChars=t.getRandomNumber=void 0,t.getRandomNumber=function(e,t){return Math.floor(Math.random()*(t-e)+e)},t.generateChars=function(e){return Array.from({length:e},(function(){return(0,t.getRandomNumber)(0,36).toString(36)})).join("")},t.generateId=function(e,i){var n=e.id||e.name&&"".concat(e.name,"-").concat((0,t.generateChars)(2))||(0,t.generateChars)(4);return n=n.replace(/(:|\.|\[|\]|,)/g,""),n="".concat(i,"-").concat(n)},t.getType=function(e){return Object.prototype.toString.call(e).slice(8,-1)},t.isType=function(e,i){return null!=i&&(0,t.getType)(i)===e},t.wrap=function(e,t){return void 0===t&&(t=document.createElement("div")),e.parentNode&&(e.nextSibling?e.parentNode.insertBefore(t,e.nextSibling):e.parentNode.appendChild(t)),t.appendChild(e)},t.getAdjacentEl=function(e,t,i){void 0===i&&(i=1);for(var n="".concat(i>0?"next":"previous","ElementSibling"),s=e[n];s;){if(s.matches(t))return s;s=s[n]}return s},t.isScrolledIntoView=function(e,t,i){return void 0===i&&(i=1),!!e&&(i>0?t.scrollTop+t.offsetHeight>=e.offsetTop+e.offsetHeight:e.offsetTop>=t.scrollTop)},t.sanitise=function(e){return"string"!=typeof e?e:e.replace(/&/g,"&amp;").replace(/>/g,"&gt;").replace(/</g,"&lt;").replace(/"/g,"&quot;")},t.strToEl=(i=document.createElement("div"),function(e){var t=e.trim();i.innerHTML=t;for(var n=i.children[0];i.firstChild;)i.removeChild(i.firstChild);return n}),t.sortByAlpha=function(e,t){var i=e.value,n=e.label,s=void 0===n?i:n,r=t.value,o=t.label,a=void 0===o?r:o;return s.localeCompare(a,[],{sensitivity:"base",ignorePunctuation:!0,numeric:!0})},t.sortByScore=function(e,t){var i=e.score,n=void 0===i?0:i,s=t.score;return n-(void 0===s?0:s)},t.dispatchEvent=function(e,t,i){void 0===i&&(i=null);var n=new CustomEvent(t,{detail:i,bubbles:!0,cancelable:!0});return e.dispatchEvent(n)},t.existsInArray=function(e,t,i){return void 0===i&&(i="value"),e.some((function(e){return"string"==typeof t?e[i]===t.trim():e[i]===t}))},t.cloneObject=function(e){return JSON.parse(JSON.stringify(e))},t.diff=function(e,t){var i=Object.keys(e).sort(),n=Object.keys(t).sort();return i.filter((function(e){return n.indexOf(e)<0}))}},273:function(e,t){var i=this&&this.__spreadArray||function(e,t,i){if(i||2===arguments.length)for(var n,s=0,r=t.length;s<r;s++)!n&&s in t||(n||(n=Array.prototype.slice.call(t,0,s)),n[s]=t[s]);return e.concat(n||Array.prototype.slice.call(t))};Object.defineProperty(t,"__esModule",{value:!0}),t.defaultState=void 0,t.defaultState=[],t.default=function(e,n){switch(void 0===e&&(e=t.defaultState),void 0===n&&(n={}),n.type){case"ADD_CHOICE":var s=n,r={id:s.id,elementId:s.elementId,groupId:s.groupId,value:s.value,label:s.label||s.value,disabled:s.disabled||!1,selected:!1,active:!0,score:9999,customProperties:s.customProperties,placeholder:s.placeholder||!1};return i(i([],e,!0),[r],!1);case"ADD_ITEM":var o=n;return o.choiceId>-1?e.map((function(e){var t=e;return t.id===parseInt("".concat(o.choiceId),10)&&(t.selected=!0),t})):e;case"REMOVE_ITEM":var a=n;return a.choiceId&&a.choiceId>-1?e.map((function(e){var t=e;return t.id===parseInt("".concat(a.choiceId),10)&&(t.selected=!1),t})):e;case"FILTER_CHOICES":var c=n;return e.map((function(e){var t=e;return t.active=c.results.some((function(e){var i=e.item,n=e.score;return i.id===t.id&&(t.score=n,!0)})),t}));case"ACTIVATE_CHOICES":var l=n;return e.map((function(e){var t=e;return t.active=l.active,t}));case"CLEAR_CHOICES":return t.defaultState;default:return e}}},871:function(e,t){var i=this&&this.__spreadArray||function(e,t,i){if(i||2===arguments.length)for(var n,s=0,r=t.length;s<r;s++)!n&&s in t||(n||(n=Array.prototype.slice.call(t,0,s)),n[s]=t[s]);return e.concat(n||Array.prototype.slice.call(t))};Object.defineProperty(t,"__esModule",{value:!0}),t.defaultState=void 0,t.defaultState=[],t.default=function(e,n){switch(void 0===e&&(e=t.defaultState),void 0===n&&(n={}),n.type){case"ADD_GROUP":var s=n;return i(i([],e,!0),[{id:s.id,value:s.value,active:s.active,disabled:s.disabled}],!1);case"CLEAR_CHOICES":return[];default:return e}}},655:function(e,t,i){var n=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(t,"__esModule",{value:!0}),t.defaultState=void 0;var s=i(857),r=n(i(52)),o=n(i(871)),a=n(i(273)),c=n(i(502)),l=i(799);t.defaultState={groups:[],items:[],choices:[],loading:!1};var h=(0,s.combineReducers)({items:r.default,groups:o.default,choices:a.default,loading:c.default});t.default=function(e,i){var n=e;if("CLEAR_ALL"===i.type)n=t.defaultState;else if("RESET_TO"===i.type)return(0,l.cloneObject)(i.state);return h(n,i)}},52:function(e,t){var i=this&&this.__spreadArray||function(e,t,i){if(i||2===arguments.length)for(var n,s=0,r=t.length;s<r;s++)!n&&s in t||(n||(n=Array.prototype.slice.call(t,0,s)),n[s]=t[s]);return e.concat(n||Array.prototype.slice.call(t))};Object.defineProperty(t,"__esModule",{value:!0}),t.defaultState=void 0,t.defaultState=[],t.default=function(e,n){switch(void 0===e&&(e=t.defaultState),void 0===n&&(n={}),n.type){case"ADD_ITEM":var s=n;return i(i([],e,!0),[{id:s.id,choiceId:s.choiceId,groupId:s.groupId,value:s.value,label:s.label,active:!0,highlighted:!1,customProperties:s.customProperties,placeholder:s.placeholder||!1,keyCode:null}],!1).map((function(e){var t=e;return t.highlighted=!1,t}));case"REMOVE_ITEM":return e.map((function(e){var t=e;return t.id===n.id&&(t.active=!1),t}));case"HIGHLIGHT_ITEM":var r=n;return e.map((function(e){var t=e;return t.id===r.id&&(t.highlighted=r.highlighted),t}));default:return e}}},502:function(e,t){Object.defineProperty(t,"__esModule",{value:!0}),t.defaultState=void 0,t.defaultState=!1,t.default=function(e,i){return void 0===e&&(e=t.defaultState),void 0===i&&(i={}),"SET_IS_LOADING"===i.type?i.isLoading:e}},744:function(e,t,i){var n=this&&this.__spreadArray||function(e,t,i){if(i||2===arguments.length)for(var n,s=0,r=t.length;s<r;s++)!n&&s in t||(n||(n=Array.prototype.slice.call(t,0,s)),n[s]=t[s]);return e.concat(n||Array.prototype.slice.call(t))},s=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(t,"__esModule",{value:!0});var r=i(857),o=s(i(655)),a=function(){function e(){this._store=(0,r.createStore)(o.default,window.__REDUX_DEVTOOLS_EXTENSION__&&window.__REDUX_DEVTOOLS_EXTENSION__())}return e.prototype.subscribe=function(e){this._store.subscribe(e)},e.prototype.dispatch=function(e){this._store.dispatch(e)},Object.defineProperty(e.prototype,"state",{get:function(){return this._store.getState()},enumerable:!1,configurable:!0}),Object.defineProperty(e.prototype,"items",{get:function(){return this.state.items},enumerable:!1,configurable:!0}),Object.defineProperty(e.prototype,"activeItems",{get:function(){return this.items.filter((function(e){return!0===e.active}))},enumerable:!1,configurable:!0}),Object.defineProperty(e.prototype,"highlightedActiveItems",{get:function(){return this.items.filter((function(e){return e.active&&e.highlighted}))},enumerable:!1,configurable:!0}),Object.defineProperty(e.prototype,"choices",{get:function(){return this.state.choices},enumerable:!1,configurable:!0}),Object.defineProperty(e.prototype,"activeChoices",{get:function(){return this.choices.filter((function(e){return!0===e.active}))},enumerable:!1,configurable:!0}),Object.defineProperty(e.prototype,"selectableChoices",{get:function(){return this.choices.filter((function(e){return!0!==e.disabled}))},enumerable:!1,configurable:!0}),Object.defineProperty(e.prototype,"searchableChoices",{get:function(){return this.selectableChoices.filter((function(e){return!0!==e.placeholder}))},enumerable:!1,configurable:!0}),Object.defineProperty(e.prototype,"placeholderChoice",{get:function(){return n([],this.choices,!0).reverse().find((function(e){return!0===e.placeholder}))},enumerable:!1,configurable:!0}),Object.defineProperty(e.prototype,"groups",{get:function(){return this.state.groups},enumerable:!1,configurable:!0}),Object.defineProperty(e.prototype,"activeGroups",{get:function(){var e=this.groups,t=this.choices;return e.filter((function(e){var i=!0===e.active&&!1===e.disabled,n=t.some((function(e){return!0===e.active&&!1===e.disabled}));return i&&n}),[])},enumerable:!1,configurable:!0}),e.prototype.isLoading=function(){return this.state.loading},e.prototype.getChoiceById=function(e){return this.activeChoices.find((function(t){return t.id===parseInt(e,10)}))},e.prototype.getGroupById=function(e){return this.groups.find((function(t){return t.id===e}))},e}();t.default=a},686:function(e,t){Object.defineProperty(t,"__esModule",{value:!0});var i={containerOuter:function(e,t,i,n,s,r){var o=e.classNames.containerOuter,a=Object.assign(document.createElement("div"),{className:o});return a.dataset.type=r,t&&(a.dir=t),n&&(a.tabIndex=0),i&&(a.setAttribute("role",s?"combobox":"listbox"),s&&a.setAttribute("aria-autocomplete","list")),a.setAttribute("aria-haspopup","true"),a.setAttribute("aria-expanded","false"),a},containerInner:function(e){var t=e.classNames.containerInner;return Object.assign(document.createElement("div"),{className:t})},itemList:function(e,t){var i=e.classNames,n=i.list,s=i.listSingle,r=i.listItems;return Object.assign(document.createElement("div"),{className:"".concat(n," ").concat(t?s:r)})},placeholder:function(e,t){var i,n=e.allowHTML,s=e.classNames.placeholder;return Object.assign(document.createElement("div"),((i={className:s})[n?"innerHTML":"innerText"]=t,i))},item:function(e,t,i){var n,s,r=e.allowHTML,o=e.classNames,a=o.item,c=o.button,l=o.highlightedState,h=o.itemSelectable,u=o.placeholder,d=t.id,p=t.value,f=t.label,m=t.customProperties,v=t.active,g=t.disabled,_=t.highlighted,y=t.placeholder,E=Object.assign(document.createElement("div"),((n={className:a})[r?"innerHTML":"innerText"]=f,n));if(Object.assign(E.dataset,{item:"",id:d,value:p,customProperties:m}),v&&E.setAttribute("aria-selected","true"),g&&E.setAttribute("aria-disabled","true"),y&&E.classList.add(u),E.classList.add(_?l:h),i){g&&E.classList.remove(h),E.dataset.deletable="";var b="Remove item",S=Object.assign(document.createElement("button"),((s={type:"button",className:c})[r?"innerHTML":"innerText"]=b,s));S.setAttribute("aria-label","".concat(b,": '").concat(p,"'")),S.dataset.button="",E.appendChild(S)}return E},choiceList:function(e,t){var i=e.classNames.list,n=Object.assign(document.createElement("div"),{className:i});return t||n.setAttribute("aria-multiselectable","true"),n.setAttribute("role","listbox"),n},choiceGroup:function(e,t){var i,n=e.allowHTML,s=e.classNames,r=s.group,o=s.groupHeading,a=s.itemDisabled,c=t.id,l=t.value,h=t.disabled,u=Object.assign(document.createElement("div"),{className:"".concat(r," ").concat(h?a:"")});return u.setAttribute("role","group"),Object.assign(u.dataset,{group:"",id:c,value:l}),h&&u.setAttribute("aria-disabled","true"),u.appendChild(Object.assign(document.createElement("div"),((i={className:o})[n?"innerHTML":"innerText"]=l,i))),u},choice:function(e,t,i){var n,s=e.allowHTML,r=e.classNames,o=r.item,a=r.itemChoice,c=r.itemSelectable,l=r.selectedState,h=r.itemDisabled,u=r.placeholder,d=t.id,p=t.value,f=t.label,m=t.groupId,v=t.elementId,g=t.disabled,_=t.selected,y=t.placeholder,E=Object.assign(document.createElement("div"),((n={id:v})[s?"innerHTML":"innerText"]=f,n.className="".concat(o," ").concat(a),n));return _&&E.classList.add(l),y&&E.classList.add(u),E.setAttribute("role",m&&m>0?"treeitem":"option"),Object.assign(E.dataset,{choice:"",id:d,value:p,selectText:i}),g?(E.classList.add(h),E.dataset.choiceDisabled="",E.setAttribute("aria-disabled","true")):(E.classList.add(c),E.dataset.choiceSelectable=""),E},input:function(e,t){var i=e.classNames,n=i.input,s=i.inputCloned,r=Object.assign(document.createElement("input"),{type:"search",name:"search_terms",className:"".concat(n," ").concat(s),autocomplete:"off",autocapitalize:"off",spellcheck:!1});return r.setAttribute("role","textbox"),r.setAttribute("aria-autocomplete","list"),r.setAttribute("aria-label",t),r},dropdown:function(e){var t=e.classNames,i=t.list,n=t.listDropdown,s=document.createElement("div");return s.classList.add(i,n),s.setAttribute("aria-expanded","false"),s},notice:function(e,t,i){var n,s=e.allowHTML,r=e.classNames,o=r.item,a=r.itemChoice,c=r.noResults,l=r.noChoices;void 0===i&&(i="");var h=[o,a];return"no-choices"===i?h.push(l):"no-results"===i&&h.push(c),Object.assign(document.createElement("div"),((n={})[s?"innerHTML":"innerText"]=t,n.className=h.join(" "),n))},option:function(e){var t=e.label,i=e.value,n=e.customProperties,s=e.active,r=e.disabled,o=new Option(t,i,!1,s);return n&&(o.dataset.customProperties="".concat(n)),o.disabled=!!r,o}};t.default=i},996:function(e){var t=function(e){return function(e){return!!e&&"object"==typeof e}(e)&&!function(e){var t=Object.prototype.toString.call(e);return"[object RegExp]"===t||"[object Date]"===t||function(e){return e.$$typeof===i}(e)}(e)},i="function"==typeof Symbol&&Symbol.for?Symbol.for("react.element"):60103;function n(e,t){return!1!==t.clone&&t.isMergeableObject(e)?c((i=e,Array.isArray(i)?[]:{}),e,t):e;var i}function s(e,t,i){return e.concat(t).map((function(e){return n(e,i)}))}function r(e){return Object.keys(e).concat(function(e){return Object.getOwnPropertySymbols?Object.getOwnPropertySymbols(e).filter((function(t){return e.propertyIsEnumerable(t)})):[]}(e))}function o(e,t){try{return t in e}catch(e){return!1}}function a(e,t,i){var s={};return i.isMergeableObject(e)&&r(e).forEach((function(t){s[t]=n(e[t],i)})),r(t).forEach((function(r){(function(e,t){return o(e,t)&&!(Object.hasOwnProperty.call(e,t)&&Object.propertyIsEnumerable.call(e,t))})(e,r)||(o(e,r)&&i.isMergeableObject(t[r])?s[r]=function(e,t){if(!t.customMerge)return c;var i=t.customMerge(e);return"function"==typeof i?i:c}(r,i)(e[r],t[r],i):s[r]=n(t[r],i))})),s}function c(e,i,r){(r=r||{}).arrayMerge=r.arrayMerge||s,r.isMergeableObject=r.isMergeableObject||t,r.cloneUnlessOtherwiseSpecified=n;var o=Array.isArray(i);return o===Array.isArray(e)?o?r.arrayMerge(e,i,r):a(e,i,r):n(i,r)}c.all=function(e,t){if(!Array.isArray(e))throw new Error("first argument should be an array");return e.reduce((function(e,i){return c(e,i,t)}),{})};var l=c;e.exports=l},221:function(e,t,i){
/**
                     * Fuse.js v6.5.3 - Lightweight fuzzy-search (http://fusejs.io)
                     *
                     * Copyright (c) 2021 Kiro Risk (http://kiro.me)
                     * All Rights Reserved. Apache Software License 2.0
                     *
                     * http://www.apache.org/licenses/LICENSE-2.0
                     */
function n(e){return Array.isArray?Array.isArray(e):"[object Array]"===h(e)}function s(e){return"string"==typeof e}function r(e){return"number"==typeof e}function o(e){return!0===e||!1===e||function(e){return a(e)&&null!==e}(e)&&"[object Boolean]"==h(e)}function a(e){return"object"==typeof e}function c(e){return null!=e}function l(e){return!e.trim().length}function h(e){return null==e?void 0===e?"[object Undefined]":"[object Null]":Object.prototype.toString.call(e)}i.r(t),i.d(t,{default:function(){return U}});const u=Object.prototype.hasOwnProperty;class d{constructor(e){this._keys=[],this._keyMap={};let t=0;e.forEach((e=>{let i=p(e);t+=i.weight,this._keys.push(i),this._keyMap[i.id]=i,t+=i.weight})),this._keys.forEach((e=>{e.weight/=t}))}get(e){return this._keyMap[e]}keys(){return this._keys}toJSON(){return JSON.stringify(this._keys)}}function p(e){let t=null,i=null,r=null,o=1;if(s(e)||n(e))r=e,t=f(e),i=m(e);else{if(!u.call(e,"name"))throw new Error((e=>`Missing ${e} property in key`)("name"));const n=e.name;if(r=n,u.call(e,"weight")&&(o=e.weight,o<=0))throw new Error((e=>`Property 'weight' in key '${e}' must be a positive integer`)(n));t=f(n),i=m(n)}return{path:t,id:i,weight:o,src:r}}function f(e){return n(e)?e:e.split(".")}function m(e){return n(e)?e.join("."):e}var v={isCaseSensitive:!1,includeScore:!1,keys:[],shouldSort:!0,sortFn:(e,t)=>e.score===t.score?e.idx<t.idx?-1:1:e.score<t.score?-1:1,includeMatches:!1,findAllMatches:!1,minMatchCharLength:1,location:0,threshold:.6,distance:100,useExtendedSearch:!1,getFn:function(e,t){let i=[],a=!1;const l=(e,t,h)=>{if(c(e))if(t[h]){const u=e[t[h]];if(!c(u))return;if(h===t.length-1&&(s(u)||r(u)||o(u)))i.push(function(e){return null==e?"":function(e){if("string"==typeof e)return e;let t=e+"";return"0"==t&&1/e==-1/0?"-0":t}(e)}(u));else if(n(u)){a=!0;for(let e=0,i=u.length;e<i;e+=1)l(u[e],t,h+1)}else t.length&&l(u,t,h+1)}else i.push(e)};return l(e,s(t)?t.split("."):t,0),a?i:i[0]},ignoreLocation:!1,ignoreFieldNorm:!1,fieldNormWeight:1};const g=/[^ ]+/g;class _{constructor({getFn:e=v.getFn,fieldNormWeight:t=v.fieldNormWeight}={}){this.norm=function(e=1,t=3){const i=new Map,n=Math.pow(10,t);return{get(t){const s=t.match(g).length;if(i.has(s))return i.get(s);const r=1/Math.pow(s,.5*e),o=parseFloat(Math.round(r*n)/n);return i.set(s,o),o},clear(){i.clear()}}}(t,3),this.getFn=e,this.isCreated=!1,this.setIndexRecords()}setSources(e=[]){this.docs=e}setIndexRecords(e=[]){this.records=e}setKeys(e=[]){this.keys=e,this._keysMap={},e.forEach(((e,t)=>{this._keysMap[e.id]=t}))}create(){!this.isCreated&&this.docs.length&&(this.isCreated=!0,s(this.docs[0])?this.docs.forEach(((e,t)=>{this._addString(e,t)})):this.docs.forEach(((e,t)=>{this._addObject(e,t)})),this.norm.clear())}add(e){const t=this.size();s(e)?this._addString(e,t):this._addObject(e,t)}removeAt(e){this.records.splice(e,1);for(let t=e,i=this.size();t<i;t+=1)this.records[t].i-=1}getValueForItemAtKeyId(e,t){return e[this._keysMap[t]]}size(){return this.records.length}_addString(e,t){if(!c(e)||l(e))return;let i={v:e,i:t,n:this.norm.get(e)};this.records.push(i)}_addObject(e,t){let i={i:t,$:{}};this.keys.forEach(((t,r)=>{let o=this.getFn(e,t.path);if(c(o))if(n(o)){let e=[];const t=[{nestedArrIndex:-1,value:o}];for(;t.length;){const{nestedArrIndex:i,value:r}=t.pop();if(c(r))if(s(r)&&!l(r)){let t={v:r,i,n:this.norm.get(r)};e.push(t)}else n(r)&&r.forEach(((e,i)=>{t.push({nestedArrIndex:i,value:e})}))}i.$[r]=e}else if(!l(o)){let e={v:o,n:this.norm.get(o)};i.$[r]=e}})),this.records.push(i)}toJSON(){return{keys:this.keys,records:this.records}}}function y(e,t,{getFn:i=v.getFn,fieldNormWeight:n=v.fieldNormWeight}={}){const s=new _({getFn:i,fieldNormWeight:n});return s.setKeys(e.map(p)),s.setSources(t),s.create(),s}function E(e,{errors:t=0,currentLocation:i=0,expectedLocation:n=0,distance:s=v.distance,ignoreLocation:r=v.ignoreLocation}={}){const o=t/e.length;if(r)return o;const a=Math.abs(n-i);return s?o+a/s:a?1:o}const b=32;function S(e,t,i,{location:n=v.location,distance:s=v.distance,threshold:r=v.threshold,findAllMatches:o=v.findAllMatches,minMatchCharLength:a=v.minMatchCharLength,includeMatches:c=v.includeMatches,ignoreLocation:l=v.ignoreLocation}={}){if(t.length>b)throw new Error("Pattern length exceeds max of 32.");const h=t.length,u=e.length,d=Math.max(0,Math.min(n,u));let p=r,f=d;const m=a>1||c,g=m?Array(u):[];let _;for(;(_=e.indexOf(t,f))>-1;){let e=E(t,{currentLocation:_,expectedLocation:d,distance:s,ignoreLocation:l});if(p=Math.min(e,p),f=_+h,m){let e=0;for(;e<h;)g[_+e]=1,e+=1}}f=-1;let y=[],S=1,O=h+u;const I=1<<h-1;for(let n=0;n<h;n+=1){let r=0,a=O;for(;r<a;)E(t,{errors:n,currentLocation:d+a,expectedLocation:d,distance:s,ignoreLocation:l})<=p?r=a:O=a,a=Math.floor((O-r)/2+r);O=a;let c=Math.max(1,d-a+1),v=o?u:Math.min(d+a,u)+h,_=Array(v+2);_[v+1]=(1<<n)-1;for(let r=v;r>=c;r-=1){let o=r-1,a=i[e.charAt(o)];if(m&&(g[o]=+!!a),_[r]=(_[r+1]<<1|1)&a,n&&(_[r]|=(y[r+1]|y[r])<<1|1|y[r+1]),_[r]&I&&(S=E(t,{errors:n,currentLocation:o,expectedLocation:d,distance:s,ignoreLocation:l}),S<=p)){if(p=S,f=o,f<=d)break;c=Math.max(1,2*d-f)}}if(E(t,{errors:n+1,currentLocation:d,expectedLocation:d,distance:s,ignoreLocation:l})>p)break;y=_}const C={isMatch:f>=0,score:Math.max(.001,S)};if(m){const e=function(e=[],t=v.minMatchCharLength){let i=[],n=-1,s=-1,r=0;for(let o=e.length;r<o;r+=1){let o=e[r];o&&-1===n?n=r:o||-1===n||(s=r-1,s-n+1>=t&&i.push([n,s]),n=-1)}return e[r-1]&&r-n>=t&&i.push([n,r-1]),i}(g,a);e.length?c&&(C.indices=e):C.isMatch=!1}return C}function O(e){let t={};for(let i=0,n=e.length;i<n;i+=1){const s=e.charAt(i);t[s]=(t[s]||0)|1<<n-i-1}return t}class I{constructor(e,{location:t=v.location,threshold:i=v.threshold,distance:n=v.distance,includeMatches:s=v.includeMatches,findAllMatches:r=v.findAllMatches,minMatchCharLength:o=v.minMatchCharLength,isCaseSensitive:a=v.isCaseSensitive,ignoreLocation:c=v.ignoreLocation}={}){if(this.options={location:t,threshold:i,distance:n,includeMatches:s,findAllMatches:r,minMatchCharLength:o,isCaseSensitive:a,ignoreLocation:c},this.pattern=a?e:e.toLowerCase(),this.chunks=[],!this.pattern.length)return;const l=(e,t)=>{this.chunks.push({pattern:e,alphabet:O(e),startIndex:t})},h=this.pattern.length;if(h>b){let e=0;const t=h%b,i=h-t;for(;e<i;)l(this.pattern.substr(e,b),e),e+=b;if(t){const e=h-b;l(this.pattern.substr(e),e)}}else l(this.pattern,0)}searchIn(e){const{isCaseSensitive:t,includeMatches:i}=this.options;if(t||(e=e.toLowerCase()),this.pattern===e){let t={isMatch:!0,score:0};return i&&(t.indices=[[0,e.length-1]]),t}const{location:n,distance:s,threshold:r,findAllMatches:o,minMatchCharLength:a,ignoreLocation:c}=this.options;let l=[],h=0,u=!1;this.chunks.forEach((({pattern:t,alphabet:d,startIndex:p})=>{const{isMatch:f,score:m,indices:v}=S(e,t,d,{location:n+p,distance:s,threshold:r,findAllMatches:o,minMatchCharLength:a,includeMatches:i,ignoreLocation:c});f&&(u=!0),h+=m,f&&v&&(l=[...l,...v])}));let d={isMatch:u,score:u?h/this.chunks.length:1};return u&&i&&(d.indices=l),d}}class C{constructor(e){this.pattern=e}static isMultiMatch(e){return T(e,this.multiRegex)}static isSingleMatch(e){return T(e,this.singleRegex)}search(){}}function T(e,t){const i=e.match(t);return i?i[1]:null}class L extends C{constructor(e,{location:t=v.location,threshold:i=v.threshold,distance:n=v.distance,includeMatches:s=v.includeMatches,findAllMatches:r=v.findAllMatches,minMatchCharLength:o=v.minMatchCharLength,isCaseSensitive:a=v.isCaseSensitive,ignoreLocation:c=v.ignoreLocation}={}){super(e),this._bitapSearch=new I(e,{location:t,threshold:i,distance:n,includeMatches:s,findAllMatches:r,minMatchCharLength:o,isCaseSensitive:a,ignoreLocation:c})}static get type(){return"fuzzy"}static get multiRegex(){return/^"(.*)"$/}static get singleRegex(){return/^(.*)$/}search(e){return this._bitapSearch.searchIn(e)}}class w extends C{constructor(e){super(e)}static get type(){return"include"}static get multiRegex(){return/^'"(.*)"$/}static get singleRegex(){return/^'(.*)$/}search(e){let t,i=0;const n=[],s=this.pattern.length;for(;(t=e.indexOf(this.pattern,i))>-1;)i=t+s,n.push([t,i-1]);const r=!!n.length;return{isMatch:r,score:r?0:1,indices:n}}}const A=[class extends C{constructor(e){super(e)}static get type(){return"exact"}static get multiRegex(){return/^="(.*)"$/}static get singleRegex(){return/^=(.*)$/}search(e){const t=e===this.pattern;return{isMatch:t,score:t?0:1,indices:[0,this.pattern.length-1]}}},w,class extends C{constructor(e){super(e)}static get type(){return"prefix-exact"}static get multiRegex(){return/^\^"(.*)"$/}static get singleRegex(){return/^\^(.*)$/}search(e){const t=e.startsWith(this.pattern);return{isMatch:t,score:t?0:1,indices:[0,this.pattern.length-1]}}},class extends C{constructor(e){super(e)}static get type(){return"inverse-prefix-exact"}static get multiRegex(){return/^!\^"(.*)"$/}static get singleRegex(){return/^!\^(.*)$/}search(e){const t=!e.startsWith(this.pattern);return{isMatch:t,score:t?0:1,indices:[0,e.length-1]}}},class extends C{constructor(e){super(e)}static get type(){return"inverse-suffix-exact"}static get multiRegex(){return/^!"(.*)"\$$/}static get singleRegex(){return/^!(.*)\$$/}search(e){const t=!e.endsWith(this.pattern);return{isMatch:t,score:t?0:1,indices:[0,e.length-1]}}},class extends C{constructor(e){super(e)}static get type(){return"suffix-exact"}static get multiRegex(){return/^"(.*)"\$$/}static get singleRegex(){return/^(.*)\$$/}search(e){const t=e.endsWith(this.pattern);return{isMatch:t,score:t?0:1,indices:[e.length-this.pattern.length,e.length-1]}}},class extends C{constructor(e){super(e)}static get type(){return"inverse-exact"}static get multiRegex(){return/^!"(.*)"$/}static get singleRegex(){return/^!(.*)$/}search(e){const t=-1===e.indexOf(this.pattern);return{isMatch:t,score:t?0:1,indices:[0,e.length-1]}}},L],M=A.length,P=/ +(?=([^\"]*\"[^\"]*\")*[^\"]*$)/,x=new Set([L.type,w.type]);class N{constructor(e,{isCaseSensitive:t=v.isCaseSensitive,includeMatches:i=v.includeMatches,minMatchCharLength:n=v.minMatchCharLength,ignoreLocation:s=v.ignoreLocation,findAllMatches:r=v.findAllMatches,location:o=v.location,threshold:a=v.threshold,distance:c=v.distance}={}){this.query=null,this.options={isCaseSensitive:t,includeMatches:i,minMatchCharLength:n,findAllMatches:r,ignoreLocation:s,location:o,threshold:a,distance:c},this.pattern=t?e:e.toLowerCase(),this.query=function(e,t={}){return e.split("|").map((e=>{let i=e.trim().split(P).filter((e=>e&&!!e.trim())),n=[];for(let e=0,s=i.length;e<s;e+=1){const s=i[e];let r=!1,o=-1;for(;!r&&++o<M;){const e=A[o];let i=e.isMultiMatch(s);i&&(n.push(new e(i,t)),r=!0)}if(!r)for(o=-1;++o<M;){const e=A[o];let i=e.isSingleMatch(s);if(i){n.push(new e(i,t));break}}}return n}))}(this.pattern,this.options)}static condition(e,t){return t.useExtendedSearch}searchIn(e){const t=this.query;if(!t)return{isMatch:!1,score:1};const{includeMatches:i,isCaseSensitive:n}=this.options;e=n?e:e.toLowerCase();let s=0,r=[],o=0;for(let n=0,a=t.length;n<a;n+=1){const a=t[n];r.length=0,s=0;for(let t=0,n=a.length;t<n;t+=1){const n=a[t],{isMatch:c,indices:l,score:h}=n.search(e);if(!c){o=0,s=0,r.length=0;break}if(s+=1,o+=h,i){const e=n.constructor.type;x.has(e)?r=[...r,...l]:r.push(l)}}if(s){let e={isMatch:!0,score:o/s};return i&&(e.indices=r),e}}return{isMatch:!1,score:1}}}const D=[];function j(e,t){for(let i=0,n=D.length;i<n;i+=1){let n=D[i];if(n.condition(e,t))return new n(e,t)}return new I(e,t)}const F="$and",k="$or",K="$path",R="$val",Y=e=>!(!e[F]&&!e[k]),H=e=>({[F]:Object.keys(e).map((t=>({[t]:e[t]})))});function V(e,t,{auto:i=!0}={}){const r=e=>{let o=Object.keys(e);const c=(e=>!!e[K])(e);if(!c&&o.length>1&&!Y(e))return r(H(e));if((e=>!n(e)&&a(e)&&!Y(e))(e)){const n=c?e[K]:o[0],r=c?e[R]:e[n];if(!s(r))throw new Error((e=>`Invalid value for key ${e}`)(n));const a={keyId:m(n),pattern:r};return i&&(a.searcher=j(r,t)),a}let l={children:[],operator:o[0]};return o.forEach((t=>{const i=e[t];n(i)&&i.forEach((e=>{l.children.push(r(e))}))})),l};return Y(e)||(e=H(e)),r(e)}function B(e,t){const i=e.matches;t.matches=[],c(i)&&i.forEach((e=>{if(!c(e.indices)||!e.indices.length)return;const{indices:i,value:n}=e;let s={indices:i,value:n};e.key&&(s.key=e.key.src),e.idx>-1&&(s.refIndex=e.idx),t.matches.push(s)}))}function G(e,t){t.score=e.score}class U{constructor(e,t={},i){this.options={...v,...t},this.options.useExtendedSearch,this._keyStore=new d(this.options.keys),this.setCollection(e,i)}setCollection(e,t){if(this._docs=e,t&&!(t instanceof _))throw new Error("Incorrect 'index' type");this._myIndex=t||y(this.options.keys,this._docs,{getFn:this.options.getFn,fieldNormWeight:this.options.fieldNormWeight})}add(e){c(e)&&(this._docs.push(e),this._myIndex.add(e))}remove(e=(()=>!1)){const t=[];for(let i=0,n=this._docs.length;i<n;i+=1){const s=this._docs[i];e(s,i)&&(this.removeAt(i),i-=1,n-=1,t.push(s))}return t}removeAt(e){this._docs.splice(e,1),this._myIndex.removeAt(e)}getIndex(){return this._myIndex}search(e,{limit:t=-1}={}){const{includeMatches:i,includeScore:n,shouldSort:o,sortFn:a,ignoreFieldNorm:c}=this.options;let l=s(e)?s(this._docs[0])?this._searchStringList(e):this._searchObjectList(e):this._searchLogical(e);return function(e,{ignoreFieldNorm:t=v.ignoreFieldNorm}){e.forEach((e=>{let i=1;e.matches.forEach((({key:e,norm:n,score:s})=>{const r=e?e.weight:null;i*=Math.pow(0===s&&r?Number.EPSILON:s,(r||1)*(t?1:n))})),e.score=i}))}(l,{ignoreFieldNorm:c}),o&&l.sort(a),r(t)&&t>-1&&(l=l.slice(0,t)),function(e,t,{includeMatches:i=v.includeMatches,includeScore:n=v.includeScore}={}){const s=[];return i&&s.push(B),n&&s.push(G),e.map((e=>{const{idx:i}=e,n={item:t[i],refIndex:i};return s.length&&s.forEach((t=>{t(e,n)})),n}))}(l,this._docs,{includeMatches:i,includeScore:n})}_searchStringList(e){const t=j(e,this.options),{records:i}=this._myIndex,n=[];return i.forEach((({v:e,i,n:s})=>{if(!c(e))return;const{isMatch:r,score:o,indices:a}=t.searchIn(e);r&&n.push({item:e,idx:i,matches:[{score:o,value:e,norm:s,indices:a}]})})),n}_searchLogical(e){const t=V(e,this.options),i=(e,t,n)=>{if(!e.children){const{keyId:i,searcher:s}=e,r=this._findMatches({key:this._keyStore.get(i),value:this._myIndex.getValueForItemAtKeyId(t,i),searcher:s});return r&&r.length?[{idx:n,item:t,matches:r}]:[]}const s=[];for(let r=0,o=e.children.length;r<o;r+=1){const o=e.children[r],a=i(o,t,n);if(a.length)s.push(...a);else if(e.operator===F)return[]}return s},n=this._myIndex.records,s={},r=[];return n.forEach((({$:e,i:n})=>{if(c(e)){let o=i(t,e,n);o.length&&(s[n]||(s[n]={idx:n,item:e,matches:[]},r.push(s[n])),o.forEach((({matches:e})=>{s[n].matches.push(...e)})))}})),r}_searchObjectList(e){const t=j(e,this.options),{keys:i,records:n}=this._myIndex,s=[];return n.forEach((({$:e,i:n})=>{if(!c(e))return;let r=[];i.forEach(((i,n)=>{r.push(...this._findMatches({key:i,value:e[n],searcher:t}))})),r.length&&s.push({idx:n,item:e,matches:r})})),s}_findMatches({key:e,value:t,searcher:i}){if(!c(t))return[];let s=[];if(n(t))t.forEach((({v:t,i:n,n:r})=>{if(!c(t))return;const{isMatch:o,score:a,indices:l}=i.searchIn(t);o&&s.push({score:a,key:e,value:t,idx:n,norm:r,indices:l})}));else{const{v:n,n:r}=t,{isMatch:o,score:a,indices:c}=i.searchIn(n);o&&s.push({score:a,key:e,value:n,norm:r,indices:c})}return s}}U.version="6.5.3",U.createIndex=y,U.parseIndex=function(e,{getFn:t=v.getFn,fieldNormWeight:i=v.fieldNormWeight}={}){const{keys:n,records:s}=e,r=new _({getFn:t,fieldNormWeight:i});return r.setKeys(n),r.setIndexRecords(s),r},U.config=v,U.parseQuery=V,function(...e){D.push(...e)}(N)},857:function(e,t,i){function n(e,t,i){return t in e?Object.defineProperty(e,t,{value:i,enumerable:!0,configurable:!0,writable:!0}):e[t]=i,e}function s(e,t){var i=Object.keys(e);if(Object.getOwnPropertySymbols){var n=Object.getOwnPropertySymbols(e);t&&(n=n.filter((function(t){return Object.getOwnPropertyDescriptor(e,t).enumerable}))),i.push.apply(i,n)}return i}function r(e){for(var t=1;t<arguments.length;t++){var i=null!=arguments[t]?arguments[t]:{};t%2?s(Object(i),!0).forEach((function(t){n(e,t,i[t])})):Object.getOwnPropertyDescriptors?Object.defineProperties(e,Object.getOwnPropertyDescriptors(i)):s(Object(i)).forEach((function(t){Object.defineProperty(e,t,Object.getOwnPropertyDescriptor(i,t))}))}return e}function o(e){return"Minified Redux error #"+e+"; visit https://redux.js.org/Errors?code="+e+" for the full message or use the non-minified dev environment for full errors. "}i.r(t),i.d(t,{__DO_NOT_USE__ActionTypes:function(){return l},applyMiddleware:function(){return v},bindActionCreators:function(){return f},combineReducers:function(){return d},compose:function(){return m},createStore:function(){return u}});var a="function"==typeof Symbol&&Symbol.observable||"@@observable",c=function(){return Math.random().toString(36).substring(7).split("").join(".")},l={INIT:"@@redux/INIT"+c(),REPLACE:"@@redux/REPLACE"+c(),PROBE_UNKNOWN_ACTION:function(){return"@@redux/PROBE_UNKNOWN_ACTION"+c()}};function h(e){if("object"!=typeof e||null===e)return!1;for(var t=e;null!==Object.getPrototypeOf(t);)t=Object.getPrototypeOf(t);return Object.getPrototypeOf(e)===t}function u(e,t,i){var n;if("function"==typeof t&&"function"==typeof i||"function"==typeof i&&"function"==typeof arguments[3])throw new Error(o(0));if("function"==typeof t&&void 0===i&&(i=t,t=void 0),void 0!==i){if("function"!=typeof i)throw new Error(o(1));return i(u)(e,t)}if("function"!=typeof e)throw new Error(o(2));var s=e,r=t,c=[],d=c,p=!1;function f(){d===c&&(d=c.slice())}function m(){if(p)throw new Error(o(3));return r}function v(e){if("function"!=typeof e)throw new Error(o(4));if(p)throw new Error(o(5));var t=!0;return f(),d.push(e),function(){if(t){if(p)throw new Error(o(6));t=!1,f();var i=d.indexOf(e);d.splice(i,1),c=null}}}function g(e){if(!h(e))throw new Error(o(7));if(void 0===e.type)throw new Error(o(8));if(p)throw new Error(o(9));try{p=!0,r=s(r,e)}finally{p=!1}for(var t=c=d,i=0;i<t.length;i++)(0,t[i])();return e}function _(e){if("function"!=typeof e)throw new Error(o(10));s=e,g({type:l.REPLACE})}function y(){var e,t=v;return(e={subscribe:function(e){if("object"!=typeof e||null===e)throw new Error(o(11));function i(){e.next&&e.next(m())}return i(),{unsubscribe:t(i)}}})[a]=function(){return this},e}return g({type:l.INIT}),(n={dispatch:g,subscribe:v,getState:m,replaceReducer:_})[a]=y,n}function d(e){for(var t=Object.keys(e),i={},n=0;n<t.length;n++){var s=t[n];"function"==typeof e[s]&&(i[s]=e[s])}var r,a=Object.keys(i);try{!function(e){Object.keys(e).forEach((function(t){var i=e[t];if(void 0===i(void 0,{type:l.INIT}))throw new Error(o(12));if(void 0===i(void 0,{type:l.PROBE_UNKNOWN_ACTION()}))throw new Error(o(13))}))}(i)}catch(e){r=e}return function(e,t){if(void 0===e&&(e={}),r)throw r;for(var n=!1,s={},c=0;c<a.length;c++){var l=a[c],h=i[l],u=e[l],d=h(u,t);if(void 0===d)throw t&&t.type,new Error(o(14));s[l]=d,n=n||d!==u}return(n=n||a.length!==Object.keys(e).length)?s:e}}function p(e,t){return function(){return t(e.apply(this,arguments))}}function f(e,t){if("function"==typeof e)return p(e,t);if("object"!=typeof e||null===e)throw new Error(o(16));var i={};for(var n in e){var s=e[n];"function"==typeof s&&(i[n]=p(s,t))}return i}function m(){for(var e=arguments.length,t=new Array(e),i=0;i<e;i++)t[i]=arguments[i];return 0===t.length?function(e){return e}:1===t.length?t[0]:t.reduce((function(e,t){return function(){return e(t.apply(void 0,arguments))}}))}function v(){for(var e=arguments.length,t=new Array(e),i=0;i<e;i++)t[i]=arguments[i];return function(e){return function(){var i=e.apply(void 0,arguments),n=function(){throw new Error(o(15))},s={getState:i.getState,dispatch:function(){return n.apply(void 0,arguments)}},a=t.map((function(e){return e(s)}));return n=m.apply(void 0,a)(i.dispatch),r(r({},i),{},{dispatch:n})}}}}},t={};function i(n){var s=t[n];if(void 0!==s)return s.exports;var r=t[n]={exports:{}};return e[n].call(r.exports,r,r.exports,i),r.exports}i.n=function(e){var t=e&&e.__esModule?function(){return e.default}:function(){return e};return i.d(t,{a:t}),t},i.d=function(e,t){for(var n in t)i.o(t,n)&&!i.o(e,n)&&Object.defineProperty(e,n,{enumerable:!0,get:t[n]})},i.o=function(e,t){return Object.prototype.hasOwnProperty.call(e,t)},i.r=function(e){"undefined"!=typeof Symbol&&Symbol.toStringTag&&Object.defineProperty(e,Symbol.toStringTag,{value:"Module"}),Object.defineProperty(e,"__esModule",{value:!0})};var n,s,r={};return n=i(373),s=i.n(n),i(187),i(883),i(789),i(686),r.default=s(),r=r.default}()},"object"==typeof i&&"object"==typeof t?t.exports=o():"function"==typeof define&&define.amd?define([],o):"object"==typeof i?i.Choices=o():r.Choices=o()},
514: function _(i,e,o,t,c){t(),o.default='.choices{position:relative;overflow:hidden;margin-bottom:24px;font-size:16px;}.choices:focus{outline:none;}.choices:last-child{margin-bottom:0;}.choices.is-open{overflow:initial;}.choices.is-disabled .choices__inner,.choices.is-disabled .choices__input{background-color:#eaeaea;cursor:not-allowed;-webkit-user-select:none;user-select:none;}.choices.is-disabled .choices__item{cursor:not-allowed;}.choices [hidden]{display:none !important;}.choices[data-type*=select-one]{cursor:pointer;}.choices[data-type*=select-one] .choices__inner{padding-bottom:7.5px;}.choices[data-type*=select-one] .choices__input{display:block;width:100%;padding:10px;border-bottom:1px solid #ddd;background-color:#fff;margin:0;}.choices[data-type*=select-one] .choices__button{background-image:url("data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjEiIGhlaWdodD0iMjEiIHZpZXdCb3g9IjAgMCAyMSAyMSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj48ZyBmaWxsPSIjMDAwIiBmaWxsLXJ1bGU9ImV2ZW5vZGQiPjxwYXRoIGQ9Ik0yLjU5Mi4wNDRsMTguMzY0IDE4LjM2NC0yLjU0OCAyLjU0OEwuMDQ0IDIuNTkyeiIvPjxwYXRoIGQ9Ik0wIDE4LjM2NEwxOC4zNjQgMGwyLjU0OCAyLjU0OEwyLjU0OCAyMC45MTJ6Ii8+PC9nPjwvc3ZnPg==");padding:0;background-size:8px;position:absolute;top:50%;right:0;margin-top:-10px;margin-right:25px;height:20px;width:20px;border-radius:10em;opacity:0.25;}.choices[data-type*=select-one] .choices__button:hover,.choices[data-type*=select-one] .choices__button:focus{opacity:1;}.choices[data-type*=select-one] .choices__button:focus{box-shadow:0 0 0 2px #00bcd4;}.choices[data-type*=select-one] .choices__item[data-value=""] .choices__button{display:none;}.choices[data-type*=select-one]::after{content:"";height:0;width:0;border-style:solid;border-color:#333 transparent transparent transparent;border-width:5px;position:absolute;right:11.5px;top:50%;margin-top:-2.5px;pointer-events:none;}.choices[data-type*=select-one].is-open::after{border-color:transparent transparent #333 transparent;margin-top:-7.5px;}.choices[data-type*=select-one][dir=rtl]::after{left:11.5px;right:auto;}.choices[data-type*=select-one][dir=rtl] .choices__button{right:auto;left:0;margin-left:25px;margin-right:0;}.choices[data-type*=select-multiple] .choices__inner,.choices[data-type*=text] .choices__inner{cursor:text;}.choices[data-type*=select-multiple] .choices__button,.choices[data-type*=text] .choices__button{position:relative;display:inline-block;margin-top:0;margin-right:-4px;margin-bottom:0;margin-left:8px;padding-left:16px;border-left:1px solid #008fa1;background-image:url("data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjEiIGhlaWdodD0iMjEiIHZpZXdCb3g9IjAgMCAyMSAyMSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj48ZyBmaWxsPSIjRkZGIiBmaWxsLXJ1bGU9ImV2ZW5vZGQiPjxwYXRoIGQ9Ik0yLjU5Mi4wNDRsMTguMzY0IDE4LjM2NC0yLjU0OCAyLjU0OEwuMDQ0IDIuNTkyeiIvPjxwYXRoIGQ9Ik0wIDE4LjM2NEwxOC4zNjQgMGwyLjU0OCAyLjU0OEwyLjU0OCAyMC45MTJ6Ii8+PC9nPjwvc3ZnPg==");background-size:8px;width:8px;line-height:1;opacity:0.75;border-radius:0;}.choices[data-type*=select-multiple] .choices__button:hover,.choices[data-type*=select-multiple] .choices__button:focus,.choices[data-type*=text] .choices__button:hover,.choices[data-type*=text] .choices__button:focus{opacity:1;}.choices__inner{display:inline-block;vertical-align:top;width:100%;background-color:#f9f9f9;padding:7.5px 7.5px 3.75px;border:1px solid #ddd;border-radius:2.5px;font-size:14px;min-height:44px;overflow:hidden;}.is-focused .choices__inner,.is-open .choices__inner{border-color:#b7b7b7;}.is-open .choices__inner{border-radius:2.5px 2.5px 0 0;}.is-flipped.is-open .choices__inner{border-radius:0 0 2.5px 2.5px;}.choices__list{margin:0;padding-left:0;list-style:none;}.choices__list--single{display:inline-block;padding:4px 16px 4px 4px;width:100%;}[dir=rtl] .choices__list--single{padding-right:4px;padding-left:16px;}.choices__list--single .choices__item{width:100%;}.choices__list--multiple{display:inline;}.choices__list--multiple .choices__item{display:inline-block;vertical-align:middle;border-radius:20px;padding:4px 10px;font-size:12px;font-weight:500;margin-right:3.75px;margin-bottom:3.75px;background-color:#00bcd4;border:1px solid #00a5bb;color:#fff;word-break:break-all;box-sizing:border-box;}.choices__list--multiple .choices__item[data-deletable]{padding-right:5px;}[dir=rtl] .choices__list--multiple .choices__item{margin-right:0;margin-left:3.75px;}.choices__list--multiple .choices__item.is-highlighted{background-color:#00a5bb;border:1px solid #008fa1;}.is-disabled .choices__list--multiple .choices__item{background-color:#aaaaaa;border:1px solid #919191;}.choices__list--dropdown{visibility:hidden;z-index:1;position:absolute;width:100%;background-color:#fff;border:1px solid #ddd;top:100%;margin-top:-1px;border-bottom-left-radius:2.5px;border-bottom-right-radius:2.5px;overflow:hidden;word-break:break-all;will-change:visibility;}.choices__list--dropdown.is-active{visibility:visible;}.is-open .choices__list--dropdown{border-color:#b7b7b7;}.is-flipped .choices__list--dropdown{top:auto;bottom:100%;margin-top:0;margin-bottom:-1px;border-radius:0.25rem 0.25rem 0 0;}.choices__list--dropdown .choices__list{position:relative;max-height:300px;overflow:auto;-webkit-overflow-scrolling:touch;will-change:scroll-position;}.choices__list--dropdown .choices__item{position:relative;padding:10px;font-size:14px;}[dir=rtl] .choices__list--dropdown .choices__item{text-align:right;}@media (min-width: 640px){.choices__list--dropdown .choices__item--selectable{padding-right:100px;}.choices__list--dropdown .choices__item--selectable::after{content:attr(data-select-text);font-size:12px;opacity:0;position:absolute;right:10px;top:50%;transform:translateY(-50%);}[dir=rtl] .choices__list--dropdown .choices__item--selectable{text-align:right;padding-left:100px;padding-right:10px;}[dir=rtl] .choices__list--dropdown .choices__item--selectable::after{right:auto;left:10px;}}.choices__list--dropdown .choices__item--selectable.is-highlighted{background-color:#f2f2f2;}.choices__list--dropdown .choices__item--selectable.is-highlighted::after{opacity:0.5;}.choices__item{cursor:default;}.choices__item--selectable{cursor:pointer;}.choices__item--disabled{cursor:not-allowed;-webkit-user-select:none;user-select:none;opacity:0.5;}.choices__heading{font-weight:600;font-size:12px;padding:10px;border-bottom:1px solid #f7f7f7;color:gray;}.choices__button{text-indent:-9999px;-webkit-appearance:none;appearance:none;border:0;background-color:transparent;background-repeat:no-repeat;background-position:center;cursor:pointer;}.choices__button:focus{outline:none;}.choices__input{display:inline-block;vertical-align:baseline;background-color:#f9f9f9;font-size:14px;margin-bottom:5px;border:0;border-radius:0;max-width:100%;padding:4px 0 4px 2px;}.choices__input:focus{outline:0;}[dir=rtl] .choices__input{padding-right:2px;padding-left:0;}.choices__placeholder{opacity:0.5;}.choices{width:100%;}.choices{box-sizing:border-box;}.choices *,.choices *:before,.choices *:after{box-sizing:inherit;}.choices__inner .choices__item.light{background-color:rgba(0, 126, 255, 0.08);border-radius:5px;border:1px solid rgba(0, 126, 255, 0.24);color:#007eff;}.choices__inner .choices__item.solid{background-color:#1f77b4;border:none;border-radius:5px;color:white;}.choices__inner .choices__item.solid .is-highlighted{background-color:#1f77b4;border:none;}.choices__input{background-color:transparent;}.choices__inner{background:transparent;border:1px solid darkgray;border-radius:5px;min-height:unset;}.choices__list{white-space:initial;}.choices__list--dropdown{z-index:100;}.choices[data-type*=select-multiple] .choices__button.light{background-image:url(data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjEiIGhlaWdodD0iMjEiIHZpZXdCb3g9IjAgMCAyMSAyMSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj48ZyBmaWxsPSIjMDA3ZWZmIiBmaWxsLXJ1bGU9ImV2ZW5vZGQiPjxwYXRoIGQ9Ik0yLjU5Mi4wNDRsMTguMzY0IDE4LjM2NC0yLjU0OCAyLjU0OEwuMDQ0IDIuNTkyeiIvPjxwYXRoIGQ9Ik0wIDE4LjM2NEwxOC4zNjQgMGwyLjU0OCAyLjU0OEwyLjU0OCAyMC45MTJ6Ii8+PC9nPjwvc3ZnPg==);}.choices[data-type*=select-multiple] .choices__button.solid{background-image:url(data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjEiIGhlaWdodD0iMjEiIHZpZXdCb3g9IjAgMCAyMSAyMSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj48ZyBmaWxsPSIjZmZmZmZmIiBmaWxsLXJ1bGU9ImV2ZW5vZGQiPjxwYXRoIGQ9Ik0yLjU5Mi4wNDRsMTguMzY0IDE4LjM2NC0yLjU0OCAyLjU0OEwuMDQ0IDIuNTkyeiIvPjxwYXRoIGQ9Ik0wIDE4LjM2NEwxOC4zNjQgMGwyLjU0OCAyLjU0OEwyLjU0OCAyMC45MTJ6Ii8+PC9nPjwvc3ZnPg==);border-left:1px solid white;opacity:1;}'},
515: function _(e,t,l,i,n){i();const s=e(1);var u;const h=s.__importStar(e(181)),o=e(478),a=e(171),r=e(52),d=e(8),p=e(12),_=s.__importStar(e(479)),m=/^[-+]?\d*$/,c=/^[-+]?\d*\.?\d*(?:(?:\d|\d.)[eE][-+]?)*\d*$/;class v extends o.InputWidgetView{connect_signals(){super.connect_signals(),this.connect(this.model.properties.name.change,(()=>{var e;return this.input_el.name=null!==(e=this.model.name)&&void 0!==e?e:""})),this.connect(this.model.properties.value.change,(()=>{this.input_el.value=this.format_value,this.old_value=this.input_el.value})),this.connect(this.model.properties.low.change,(()=>{const{value:e,low:t,high:l}=this.model;null!=t&&null!=l&&(0,p.assert)(t<=l,"Invalid bounds, low must be inferior to high"),null!=e&&null!=t&&e<t&&(this.model.value=t)})),this.connect(this.model.properties.high.change,(()=>{const{value:e,low:t,high:l}=this.model;null!=t&&null!=l&&(0,p.assert)(l>=t,"Invalid bounds, high must be superior to low"),null!=e&&null!=l&&e>l&&(this.model.value=l)})),this.connect(this.model.properties.high.change,(()=>this.input_el.placeholder=this.model.placeholder)),this.connect(this.model.properties.disabled.change,(()=>this.input_el.disabled=this.model.disabled)),this.connect(this.model.properties.placeholder.change,(()=>this.input_el.placeholder=this.model.placeholder))}get format_value(){return null!=this.model.value?this.model.pretty(this.model.value):""}_set_input_filter(e){this.input_el.addEventListener("input",(()=>{const{selectionStart:t,selectionEnd:l}=this.input_el;if(e(this.input_el.value))this.old_value=this.input_el.value;else{const e=this.old_value.length-this.input_el.value.length;this.input_el.value=this.old_value,null!=t&&null!=l&&this.input_el.setSelectionRange(t-1,l+e)}}))}render(){super.render(),this.input_el=(0,r.input)({type:"text",class:_.input,name:this.model.name,value:this.format_value,disabled:this.model.disabled,placeholder:this.model.placeholder}),this.old_value=this.format_value,this.set_input_filter(),this.input_el.addEventListener("change",(()=>this.change_input())),this.input_el.addEventListener("focusout",(()=>this.input_el.value=this.format_value)),this.group_el.appendChild(this.input_el)}set_input_filter(){const e="int"==this.model.mode?m:c;this._set_input_filter((t=>e.test(t)))}bound_value(e){let t=e;const{low:l,high:i}=this.model;return t=null!=l?Math.max(l,t):t,t=null!=i?Math.min(i,t):t,t}get value(){let e=""!=this.input_el.value?Number(this.input_el.value):null;return null!=e&&(e=this.bound_value(e)),e}change_input(){null==this.value?this.model.value=null:Number.isNaN(this.value)||(this.model.value=this.value)}}l.NumericInputView=v,v.__name__="NumericInputView";class g extends o.InputWidget{constructor(e){super(e)}_formatter(e,t){return(0,d.isString)(t)?h.format(e,t):t.doFormat([e],{loc:0})[0]}pretty(e){return null!=this.format?this._formatter(e,this.format):`${e}`}}l.NumericInput=g,u=g,g.__name__="NumericInput",u.prototype.default_view=v,u.define((({Number:e,String:t,Enum:l,Ref:i,Or:n,Nullable:s})=>({value:[s(e),null],placeholder:[t,""],mode:[l("int","float"),"int"],format:[s(n(t,i(a.TickFormatter))),null],low:[s(e),null],high:[s(e),null]})))},
516: function _(e,t,r,s,n){var a;s();const o=e(505),_=e(52);class p extends o.MarkupView{render(){super.render();const e=(0,_.pre)({style:{overflow:"auto"}},this.model.text);this.markup_el.appendChild(e)}}r.PreTextView=p,p.__name__="PreTextView";class u extends o.Markup{constructor(e){super(e)}}r.PreText=u,a=u,u.__name__="PreText",a.prototype.default_view=p},
517: function _(t,o,e,a,i){a();const n=t(1);var u;const s=t(483),c=t(52),_=n.__importStar(t(346));class r extends s.ButtonGroupView{change_active(t){this.model.active!==t&&(this.model.active=t)}_update_active(){const{active:t}=this.model;this._buttons.forEach(((o,e)=>{(0,c.classes)(o).toggle(_.active,t===e)}))}}e.RadioButtonGroupView=r,r.__name__="RadioButtonGroupView";class l extends s.ButtonGroup{constructor(t){super(t)}}e.RadioButtonGroup=l,u=l,l.__name__="RadioButtonGroup",u.prototype.default_view=r,u.define((({Int:t,Nullable:o})=>({active:[o(t),null]})))},
518: function _(e,n,i,t,a){t();const s=e(1);var l;const o=e(52),d=e(38),p=e(486),r=s.__importStar(e(479));class u extends p.InputGroupView{render(){super.render();const e=(0,o.div)({class:[r.input_group,this.model.inline?r.inline:null]});this.shadow_el.appendChild(e);const n=(0,d.uniqueId)(),{active:i,labels:t}=this.model;this._inputs=[];for(let a=0;a<t.length;a++){const s=(0,o.input)({type:"radio",name:n,value:`${a}`});s.addEventListener("change",(()=>this.change_active(a))),this._inputs.push(s),this.model.disabled&&(s.disabled=!0),a==i&&(s.checked=!0);const l=(0,o.label)(s,(0,o.span)(t[a]));e.appendChild(l)}}change_active(e){this.model.active=e}}i.RadioGroupView=u,u.__name__="RadioGroupView";class c extends p.InputGroup{constructor(e){super(e)}}i.RadioGroup=c,l=c,c.__name__="RadioGroup",l.prototype.default_view=u,l.define((({Boolean:e,Int:n,String:i,Array:t,Nullable:a})=>({active:[a(n),null],labels:[t(i),[]],inline:[e,!1]})))},
519: function _(e,r,t,a,i){a();var n;const o=e(1).__importStar(e(181)),s=e(499),_=e(8);class d extends s.AbstractRangeSliderView{}t.RangeSliderView=d,d.__name__="RangeSliderView";class c extends s.AbstractSlider{constructor(e){super(e),this.behaviour="drag",this.connected=[!1,!0,!1]}_formatter(e,r){return(0,_.isString)(r)?o.format(e,r):r.compute(e)}}t.RangeSlider=c,n=c,c.__name__="RangeSlider",n.prototype.default_view=d,n.override({format:"0[.]00"})},
520: function _(e,t,n,s,i){s();const l=e(1);var u;const a=e(52),o=e(8),p=e(9),_=e(478),r=l.__importStar(e(479));class c extends _.InputWidgetView{constructor(){super(...arguments),this._known_values=new Set}connect_signals(){super.connect_signals();const{value:e,options:t}=this.model.properties;this.on_change(e,(()=>{this._update_value()})),this.on_change(t,(()=>{(0,a.empty)(this.input_el),(0,a.append)(this.input_el,...this.options_el()),this._update_value()}))}options_el(){const{_known_values:e}=this;function t(t){return t.map((t=>{let n,s;return(0,o.isString)(t)?n=s=t:[n,s]=t,e.add(n),(0,a.option)({value:n},s)}))}e.clear();const{options:n}=this.model;return(0,o.isArray)(n)?t(n):(0,p.entries)(n).map((([e,n])=>(0,a.optgroup)({label:e},t(n))))}render(){super.render(),this.input_el=(0,a.select)({class:r.input,name:this.model.name,disabled:this.model.disabled},this.options_el()),this._update_value(),this.input_el.addEventListener("change",(()=>this.change_input())),this.group_el.appendChild(this.input_el)}change_input(){const e=this.input_el.value;this.model.value=e,super.change_input()}_update_value(){const{value:e}=this.model;this._known_values.has(e)?this.input_el.value=e:this.input_el.removeAttribute("value")}}n.SelectView=c,c.__name__="SelectView";class h extends _.InputWidget{constructor(e){super(e)}}n.Select=h,u=h,h.__name__="Select",u.prototype.default_view=c,u.define((({String:e,Array:t,Tuple:n,Dict:s,Or:i})=>{const l=t(i(e,n(e,e)));return{value:[e,""],options:[i(l,s(l)),[]]}}))},
521: function _(e,t,r,i,a){i();var o;const s=e(1).__importStar(e(181)),_=e(499),n=e(8);class c extends _.AbstractSliderView{}r.SliderView=c,c.__name__="SliderView";class d extends _.AbstractSlider{constructor(e){super(e),this.behaviour="tap",this.connected=[!0,!1]}_formatter(e,t){return(0,n.isString)(t)?s.format(e,t):t.compute(e)}}r.Slider=d,o=d,d.__name__="Slider",o.prototype.default_view=c,o.override({format:"0[.]00"})},
522: function _(e,t,i,n,s){var l;n();const o=e(515),r=e(52),{min:a,max:h,floor:_,abs:u}=Math;function d(e){return _(e)!==e?e.toFixed(16).replace(/0+$/,"").split(".")[1].length:0}class p extends o.NumericInputView{*buttons(){yield this.btn_up_el,yield this.btn_down_el}initialize(){super.initialize(),this._handles={interval:void 0,timeout:void 0},this._interval=200}connect_signals(){super.connect_signals();const e=this.model.properties;this.on_change(e.disabled,(()=>{for(const e of this.buttons())(0,r.toggle_attribute)(e,"disabled",this.model.disabled)}))}render(){super.render(),this.wrapper_el=(0,r.div)({class:"bk-spin-wrapper"}),this.group_el.replaceChild(this.wrapper_el,this.input_el),this.btn_up_el=(0,r.button)({class:"bk-spin-btn bk-spin-btn-up"}),this.btn_down_el=(0,r.button)({class:"bk-spin-btn bk-spin-btn-down"}),this.wrapper_el.appendChild(this.input_el),this.wrapper_el.appendChild(this.btn_up_el),this.wrapper_el.appendChild(this.btn_down_el);for(const e of this.buttons())(0,r.toggle_attribute)(e,"disabled",this.model.disabled),e.addEventListener("mousedown",(e=>this._btn_mouse_down(e))),e.addEventListener("mouseup",(()=>this._btn_mouse_up())),e.addEventListener("mouseleave",(()=>this._btn_mouse_leave()));this.input_el.addEventListener("keydown",(e=>this._input_key_down(e))),this.input_el.addEventListener("keyup",(()=>this.model.value_throttled=this.model.value)),this.input_el.addEventListener("wheel",(e=>this._input_mouse_wheel(e))),this.input_el.addEventListener("wheel",function(e,t,i=!1){let n;return function(...s){const l=this,o=i&&void 0===n;void 0!==n&&clearTimeout(n),n=setTimeout((function(){n=void 0,i||e.apply(l,s)}),t),o&&e.apply(l,s)}}((()=>{this.model.value_throttled=this.model.value}),this.model.wheel_wait,!1))}get precision(){const{low:e,high:t,step:i}=this.model,n=d;return h(n(u(null!=e?e:0)),n(u(null!=t?t:0)),n(u(i)))}remove(){this._stop_incrementation(),super.remove()}_start_incrementation(e){clearInterval(this._handles.interval),this._counter=0;const{step:t}=this.model,i=e=>{if(this._counter+=1,this._counter%5==0){const t=Math.floor(this._counter/5);t<10?(clearInterval(this._handles.interval),this._handles.interval=setInterval((()=>i(e)),this._interval/(t+1))):t>=10&&t<=13&&(clearInterval(this._handles.interval),this._handles.interval=setInterval((()=>i(2*e)),this._interval/10))}this.increment(e)};this._handles.interval=setInterval((()=>i(e*t)),this._interval)}_stop_incrementation(){clearTimeout(this._handles.timeout),this._handles.timeout=void 0,clearInterval(this._handles.interval),this._handles.interval=void 0,this.model.value_throttled=this.model.value}_btn_mouse_down(e){e.preventDefault();const t=e.currentTarget===this.btn_up_el?1:-1;this.increment(t*this.model.step),this.input_el.focus(),this._handles.timeout=setTimeout((()=>this._start_incrementation(t)),this._interval)}_btn_mouse_up(){this._stop_incrementation()}_btn_mouse_leave(){this._stop_incrementation()}_input_mouse_wheel(e){if(document.activeElement===this.input_el){e.preventDefault();const t=e.deltaY>0?-1:1;this.increment(t*this.model.step)}}_input_key_down(e){switch(e.keyCode){case r.Keys.Up:return e.preventDefault(),this.increment(this.model.step);case r.Keys.Down:return e.preventDefault(),this.increment(-this.model.step);case r.Keys.PageUp:return e.preventDefault(),this.increment(this.model.page_step_multiplier*this.model.step);case r.Keys.PageDown:return e.preventDefault(),this.increment(-this.model.page_step_multiplier*this.model.step)}}adjust_to_precision(e){return this.bound_value(Number(e.toFixed(this.precision)))}increment(e){const{low:t,high:i}=this.model;null==this.model.value?e>0?this.model.value=null!=t?t:null!=i?a(0,i):0:e<0&&(this.model.value=null!=i?i:null!=t?h(t,0):0):this.model.value=this.adjust_to_precision(this.model.value+e)}change_input(){super.change_input(),this.model.value_throttled=this.model.value}}i.SpinnerView=p,p.__name__="SpinnerView";class m extends o.NumericInput{constructor(e){super(e)}}i.Spinner=m,l=m,m.__name__="Spinner",l.prototype.default_view=p,l.define((({Number:e,Nullable:t})=>({value_throttled:[t(e),null],step:[e,1],page_step_multiplier:[e,10],wheel_wait:[e,100]}))),l.override({mode:"float"})},
523: function _(e,t,s,i,a){i();const d=e(1);var l;const c=e(551),_=e(52),n=d.__importDefault(e(524));class h extends c.WidgetView{connect_signals(){super.connect_signals();const{active:e,disabled:t}=this.model.properties;this.on_change(e,(()=>this._update_active())),this.on_change(t,(()=>this._update_disabled())),this.el.addEventListener("click",(()=>{this.model.disabled||(this.model.active=!this.model.active)}))}styles(){return[...super.styles(),n.default]}render(){super.render(),this.knob_el=(0,_.div)({class:"knob"}),this.bar_el=(0,_.div)({class:"bar"},this.knob_el),this.shadow_el.appendChild(this.bar_el),this._update_active(),this._update_disabled()}_update_active(){this.el.classList.toggle("active",this.model.active)}_update_disabled(){this.el.classList.toggle("disabled",this.model.disabled)}}s.SwitchView=h,h.__name__="SwitchView";class o extends c.Widget{constructor(e){super(e)}}s.Switch=o,l=o,o.__name__="Switch",l.prototype.default_view=h,l.define((({Boolean:e})=>({active:[e,!1]}))),l.override({width:32})},
524: function _(o,r,t,a,e){a(),t.default=":host{cursor:pointer;height:16px;}:host(.disabled){cursor:default;}.bar{position:relative;top:3px;height:10px;border-radius:5px;background-color:#e5e5e5;transition-property:background-color;}.knob{position:relative;top:-3px;left:0;width:16px;height:16px;border-radius:8px;background-color:#adadad;transition-property:left, background-color;}:host(.active) .bar{background-color:#c2d5f7;}:host(.active) .knob{left:calc(100% - 16px);background-color:#3b80f0;}"},
525: function _(e,t,s,n,i){n();const o=e(1);var r;const c=e(477),l=e(52),p=o.__importStar(e(479));class _ extends c.TextLikeInputView{connect_signals(){super.connect_signals(),this.connect(this.model.properties.rows.change,(()=>this.input_el.rows=this.model.rows)),this.connect(this.model.properties.cols.change,(()=>this.input_el.cols=this.model.cols))}_render_input(){this.input_el=(0,l.textarea)({class:p.input})}render(){super.render(),this.input_el.cols=this.model.cols,this.input_el.rows=this.model.rows}}s.TextAreaInputView=_,_.__name__="TextAreaInputView";class a extends c.TextLikeInput{constructor(e){super(e)}}s.TextAreaInput=a,r=a,a.__name__="TextAreaInput",r.prototype.default_view=_,r.define((({Int:e})=>({cols:[e,20],rows:[e,2]}))),r.override({max_length:500})},
526: function _(e,t,i,s,c){s();const o=e(1);var n;const a=e(471),l=e(52),r=e(46),_=o.__importStar(e(346));class g extends a.AbstractButtonView{connect_signals(){super.connect_signals(),this.connect(this.model.properties.active.change,(()=>this._update_active()))}render(){super.render(),this._update_active()}click(){this.model.active=!this.model.active,this.model.trigger_event(new r.ButtonClick),super.click()}_update_active(){(0,l.classes)(this.button_el).toggle(_.active,this.model.active)}}i.ToggleView=g,g.__name__="ToggleView";class d extends a.AbstractButton{constructor(e){super(e)}}i.Toggle=d,n=d,d.__name__="Toggle",n.prototype.default_view=g,n.define((({Boolean:e})=>({active:[e,!1]}))),n.override({label:"Toggle"})},
}, 469, {"models/widgets/main":469,"models/widgets/index":470,"models/widgets/abstract_button":471,"models/widgets/control":472,"models/widgets/widget":551,"models/widgets/abstract_icon":474,"models/widgets/autocomplete_input":475,"models/widgets/text_input":476,"models/widgets/text_like_input":477,"models/widgets/input_widget":478,"styles/widgets/inputs.css":479,"styles/dropdown.css":480,"models/widgets/button":481,"models/widgets/checkbox_button_group":482,"models/widgets/button_group":483,"models/widgets/oriented_control":484,"models/widgets/checkbox_group":485,"models/widgets/input_group":486,"models/widgets/color_picker":487,"models/widgets/date_picker":488,"styles/widgets/flatpickr.css":497,"models/widgets/date_range_slider":498,"models/widgets/abstract_slider":499,"styles/widgets/sliders.css":501,"styles/widgets/nouislider.css":502,"models/widgets/date_slider":503,"models/widgets/div":504,"models/widgets/markup":505,"styles/clearfix.css":506,"models/widgets/dropdown":507,"models/widgets/file_input":508,"models/widgets/multiselect":509,"models/widgets/paragraph":510,"models/widgets/password_input":511,"models/widgets/multichoice":512,"styles/widgets/choices.css":514,"models/widgets/numeric_input":515,"models/widgets/pretext":516,"models/widgets/radio_button_group":517,"models/widgets/radio_group":518,"models/widgets/range_slider":519,"models/widgets/selectbox":520,"models/widgets/slider":521,"models/widgets/spinner":522,"models/widgets/switch":523,"styles/widgets/switch.css":524,"models/widgets/textarea_input":525,"models/widgets/toggle":526}, {});});
