#!/usr/bin/python3
# Peter Evans
# Cerberus Nuclear Ltd

""" This module contains the print_logo() function, which adds the Cerberus Nuclear logo to a page."""

from . import global_variables as gv


def print_logo():
    # pylint: disable=line-too-long
    """ This function writes the HTML for the Cerberus Logo to a file called gv.f"""
    gv.f.write('<div id="cerberus">\n')
    gv.f.write('<div style="display:inline-block;">\n')
    gv.f.write('<svg \n')
    gv.f.write('   xmlns:dc="http://purl.org/dc/elements/1.1/"\n')
    gv.f.write('   xmlns:cc="http://creativecommons.org/ns#"\n')
    gv.f.write('   xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#"\n')
    gv.f.write('   xmlns:svg="http://www.w3.org/2000/svg"\n')
    gv.f.write('   xmlns="http://www.w3.org/2000/svg"\n')
    gv.f.write('   xmlns:sodipodi="http://sodipodi.sourceforge.net/DTD/sodipodi-0.dtd"\n')
    gv.f.write('   xmlns:inkscape="http://www.inkscape.org/namespaces/inkscape"\n')
    gv.f.write('   width="241.82916mm"\n')
    gv.f.write('   height="59.266666mm"\n')
    gv.f.write('   viewBox="0 0 241.82916 59.266666"\n')
    gv.f.write('   version="1.1"\n')
    gv.f.write('   id="svg4094"\n')
    gv.f.write('   inkscape:version="0.92.3 (2405546, 2018-03-11)"\n')
    gv.f.write('   sodipodi:docname="cerberus.svg">\n')
    gv.f.write('  <defs\n')
    gv.f.write('     id="defs4088" />\n')
    gv.f.write('  <sodipodi:namedview\n')
    gv.f.write('     id="base"\n')
    gv.f.write('     pagecolor="#ffffff"\n')
    gv.f.write('     bordercolor="#666666"\n')
    gv.f.write('     borderopacity="1.0"\n')
    gv.f.write('     inkscape:pageopacity="0.0"\n')
    gv.f.write('     inkscape:pageshadow="2"\n')
    gv.f.write('     inkscape:zoom="0.98994949"\n')
    gv.f.write('     inkscape:cx="275.04836"\n')
    gv.f.write('     inkscape:cy="101.8968"\n')
    gv.f.write('     inkscape:document-units="mm"\n')
    gv.f.write('     inkscape:current-layer="layer1"\n')
    gv.f.write('     showgrid="false"\n')
    gv.f.write('     inkscape:window-width="1920"\n')
    gv.f.write('     inkscape:window-height="986"\n')
    gv.f.write('     inkscape:window-x="-11"\n')
    gv.f.write('     inkscape:window-y="-11"\n')
    gv.f.write('     inkscape:window-maximized="1" />\n')
    gv.f.write('  <metadata\n')
    gv.f.write('     id="metadata4091">\n')
    gv.f.write('    <rdf:RDF>\n')
    gv.f.write('      <cc:Work\n')
    gv.f.write('         rdf:about="">\n')
    gv.f.write('        <dc:format>image/svg+xml</dc:format>\n')
    gv.f.write('        <dc:type\n')
    gv.f.write('           rdf:resource="http://purl.org/dc/dcmitype/StillImage" />\n')
    gv.f.write('        <dc:title />\n')
    gv.f.write('      </cc:Work>\n')
    gv.f.write('    </rdf:RDF>\n')
    gv.f.write('  </metadata>\n')
    gv.f.write('  <g\n')
    gv.f.write('     inkscape:label="Layer 1"\n')
    gv.f.write('     inkscape:groupmode="layer"\n')
    gv.f.write('     id="layer1"\n')
    gv.f.write('     transform="translate(12.813392,-29.241668)">\n')
    gv.f.write('    <g\n')
    gv.f.write('       transform="matrix(0.26458333,0,0,0.26458333,-50.648808,-21.26729)"\n')
    gv.f.write('       id="g4086">\n')
    gv.f.write('      <path\n')
    gv.f.write('         inkscape:connector-curvature="0"\n')
    gv.f.write('         id="path4008"\n')
    gv.f.write('         d="m 354,372.1 c 1.2,1.2 2.6,2.1 4.2,2.8 1.6,0.7 3.3,1.1 5.1,1.1 h 26.1 c 0.9,0 1.3,-0.4 1.3,-1.3 v -6.2 c 0,-0.9 -0.4,-1.3 -1.3,-1.3 h -26.1 c -1.2,0 -2.3,-0.4 -3.1,-1.3 -0.8,-0.9 -1.2,-1.9 -1.2,-3.1 v -35.3 c 0,-1.2 0.4,-2.2 1.2,-3.1 0.8,-0.9 1.9,-1.3 3.1,-1.3 h 26.1 c 0.9,0 1.3,-0.4 1.3,-1.3 v -6.2 c 0,-0.9 -0.4,-1.3 -1.3,-1.3 h -26.1 c -1.8,0 -3.5,0.4 -5.1,1.1 -1.6,0.7 -3,1.6 -4.2,2.8 -1.2,1.2 -2.1,2.6 -2.8,4.2 -0.7,1.6 -1,3.3 -1,5.2 v 35.3 c 0,1.8 0.3,3.5 1,5.2 0.7,1.5 1.6,2.9 2.8,4 z"\n')
    gv.f.write('         class="st0"\n')
    gv.f.write('         style="fill:#1c76bc;fill-opacity:1"\n')
    gv.f.write('         inkscape:export-xdpi="201.7"\n')
    gv.f.write('         inkscape:export-ydpi="201.7" />\n')
    gv.f.write('      <path\n')
    gv.f.write('         inkscape:connector-curvature="0"\n')
    gv.f.write('         id="path4010"\n')
    gv.f.write('         d="m 403.5,372.1 c 1.2,1.2 2.6,2.1 4.2,2.8 1.6,0.7 3.3,1.1 5.2,1.1 h 24.3 c 0.9,0 1.3,-0.4 1.3,-1.3 v -6.2 c 0,-0.9 -0.4,-1.3 -1.3,-1.3 h -24.3 c -1.2,0 -2.3,-0.4 -3.1,-1.3 -0.9,-0.9 -1.3,-1.9 -1.3,-3.1 v -3.1 c 0,-0.9 0.4,-1.3 1.3,-1.3 h 29.1 c 0.9,0 1.3,-0.4 1.3,-1.3 v -11.9 c 0,-1.8 -0.4,-3.5 -1.1,-5.2 -0.7,-1.6 -1.6,-3 -2.8,-4.2 -1.2,-1.2 -2.6,-2.1 -4.2,-2.8 -1.6,-0.7 -3.3,-1.1 -5.2,-1.1 h -14.1 c -1.8,0 -3.5,0.4 -5.2,1.1 -1.6,0.7 -3,1.6 -4.2,2.8 -1.2,1.2 -2.1,2.6 -2.8,4.2 -0.7,1.6 -1.1,3.3 -1.1,5.2 v 17.6 c 0,1.8 0.4,3.5 1.1,5.2 0.8,1.6 1.7,3 2.9,4.1 z m 4.9,-27 c 0,-1.2 0.4,-2.3 1.3,-3.1 0.9,-0.9 1.9,-1.3 3.1,-1.3 H 427 c 1.2,0 2.3,0.4 3.1,1.3 0.9,0.9 1.3,1.9 1.3,3.1 v 4.4 h -22.9 v -4.4 z"\n')
    gv.f.write('         class="st0"\n')
    gv.f.write('         style="fill:#1c76bc;fill-opacity:1"\n')
    gv.f.write('         inkscape:export-xdpi="201.7"\n')
    gv.f.write('         inkscape:export-ydpi="201.7" />\n')
    gv.f.write('      <path\n')
    gv.f.write('         inkscape:connector-curvature="0"\n')
    gv.f.write('         id="path4012"\n')
    gv.f.write('         d="m 451.7,376 h 6.2 c 0.9,0 1.3,-0.4 1.3,-1.3 v -29.5 c 0,-1.2 0.4,-2.3 1.3,-3.2 0.9,-0.9 1.9,-1.3 3.1,-1.3 h 12.8 c 0.9,0 1.3,-0.4 1.3,-1.3 v -6.2 c 0,-0.9 -0.4,-1.3 -1.3,-1.3 h -13 c -1.8,0.1 -3.5,0.4 -5.1,1.1 -1.6,0.7 -3,1.7 -4.1,2.9 -1.2,1.2 -2.1,2.6 -2.8,4.2 -0.7,1.6 -1,3.3 -1,5.1 v 29.5 c -0.1,0.9 0.4,1.3 1.3,1.3 z"\n')
    gv.f.write('         class="st0"\n')
    gv.f.write('         style="fill:#1c76bc;fill-opacity:1"\n')
    gv.f.write('         inkscape:export-xdpi="201.7"\n')
    gv.f.write('         inkscape:export-ydpi="201.7" />\n')
    gv.f.write('      <path\n')
    gv.f.write('         inkscape:connector-curvature="0"\n')
    gv.f.write('         id="path4014"\n')
    gv.f.write('         d="m 489.5,372.1 c 1.2,1.2 2.6,2.1 4.2,2.8 1.6,0.7 3.3,1.1 5.2,1.1 H 513 c 1.8,0 3.5,-0.4 5.2,-1.1 1.6,-0.7 3,-1.6 4.2,-2.8 1.2,-1.2 2.1,-2.6 2.8,-4.2 0.7,-1.6 1.1,-3.3 1.1,-5.2 v -17.6 c 0,-1.8 -0.4,-3.5 -1.1,-5.2 -0.7,-1.6 -1.6,-3 -2.8,-4.2 -1.2,-1.2 -2.6,-2.1 -4.2,-2.8 -1.6,-0.7 -3.3,-1.1 -5.2,-1.1 h -17.2 c -0.9,0 -1.3,-0.4 -1.3,-1.3 v -15 c 0,-0.9 -0.4,-1.3 -1.3,-1.3 H 487 c -0.9,0 -1.3,0.4 -1.3,1.3 v 47.2 c 0,1.8 0.4,3.5 1.1,5.2 0.6,1.7 1.5,3.1 2.7,4.2 z m 5,-30.1 c 0,-0.9 0.4,-1.3 1.3,-1.3 H 513 c 1.2,0 2.3,0.4 3.1,1.3 0.9,0.9 1.3,1.9 1.3,3.1 v 17.6 c 0,1.2 -0.4,2.3 -1.3,3.1 -0.9,0.9 -1.9,1.3 -3.1,1.3 h -14.1 c -1.2,0 -2.3,-0.4 -3.1,-1.3 -0.9,-0.9 -1.3,-1.9 -1.3,-3.1 z"\n')
    gv.f.write('         class="st0"\n')
    gv.f.write('         style="fill:#1c76bc;fill-opacity:1"\n')
    gv.f.write('         inkscape:export-xdpi="201.7"\n')
    gv.f.write('         inkscape:export-ydpi="201.7" />\n')
    gv.f.write('      <path\n')
    gv.f.write('         inkscape:connector-curvature="0"\n')
    gv.f.write('         id="path4016"\n')
    gv.f.write('         d="m 539.8,372.1 c 1.2,1.2 2.6,2.1 4.2,2.8 1.6,0.7 3.3,1.1 5.2,1.1 h 24.3 c 0.9,0 1.3,-0.4 1.3,-1.3 v -6.2 c 0,-0.9 -0.4,-1.3 -1.3,-1.3 h -24.3 c -1.2,0 -2.3,-0.4 -3.1,-1.3 -0.9,-0.9 -1.3,-1.9 -1.3,-3.1 v -3.1 c 0,-0.9 0.4,-1.3 1.3,-1.3 h 29.1 c 0.9,0 1.3,-0.4 1.3,-1.3 v -11.9 c 0,-1.8 -0.4,-3.5 -1.1,-5.2 -0.7,-1.6 -1.6,-3 -2.8,-4.2 -1.2,-1.2 -2.6,-2.1 -4.2,-2.8 -1.6,-0.7 -3.3,-1.1 -5.2,-1.1 h -14.1 c -1.8,0 -3.5,0.4 -5.2,1.1 -1.6,0.7 -3,1.6 -4.2,2.8 -1.2,1.2 -2.1,2.6 -2.8,4.2 -0.7,1.6 -1.1,3.3 -1.1,5.2 v 17.6 c 0,1.8 0.4,3.5 1.1,5.2 0.8,1.6 1.7,3 2.9,4.1 z m 5,-27 c 0,-1.2 0.4,-2.3 1.3,-3.1 0.9,-0.9 1.9,-1.3 3.1,-1.3 h 14.1 c 1.2,0 2.3,0.4 3.1,1.3 0.9,0.9 1.3,1.9 1.3,3.1 v 4.4 h -22.9 z"\n')
    gv.f.write('         class="st0"\n')
    gv.f.write('         style="fill:#1c76bc;fill-opacity:1"\n')
    gv.f.write('         inkscape:export-xdpi="201.7"\n')
    gv.f.write('         inkscape:export-ydpi="201.7" />\n')
    gv.f.write('      <path\n')
    gv.f.write('         inkscape:connector-curvature="0"\n')
    gv.f.write('         id="path4018"\n')
    gv.f.write('         d="m 588,376 h 6.2 c 0.9,0 1.3,-0.4 1.3,-1.3 v -29.5 c 0,-1.2 0.4,-2.3 1.3,-3.2 0.9,-0.9 1.9,-1.3 3.1,-1.3 h 12.8 c 0.9,0 1.3,-0.4 1.3,-1.3 v -6.2 c 0,-0.9 -0.4,-1.3 -1.3,-1.3 h -13 c -1.8,0.1 -3.5,0.4 -5.1,1.1 -1.6,0.7 -3,1.7 -4.1,2.9 -1.2,1.2 -2.1,2.6 -2.8,4.2 -0.7,1.6 -1,3.3 -1,5.1 v 29.5 c 0,0.9 0.4,1.3 1.3,1.3 z"\n')
    gv.f.write('         class="st0"\n')
    gv.f.write('         style="fill:#1c76bc;fill-opacity:1"\n')
    gv.f.write('         inkscape:export-xdpi="201.7"\n')
    gv.f.write('         inkscape:export-ydpi="201.7" />\n')
    gv.f.write('      <path\n')
    gv.f.write('         inkscape:connector-curvature="0"\n')
    gv.f.write('         id="path4020"\n')
    gv.f.write('         d="m 625.4,372.1 c 1.2,1.2 2.6,2.1 4.2,2.8 1.6,0.7 3.3,1.1 5.2,1.1 h 14.1 c 1.8,0 3.5,-0.4 5.2,-1.1 1.6,-0.7 3,-1.6 4.2,-2.8 1.2,-1.2 2.1,-2.6 2.8,-4.2 0.7,-1.6 1.1,-3.3 1.1,-5.2 v -29.6 c 0,-0.9 -0.4,-1.3 -1.3,-1.3 h -6.2 c -0.9,0 -1.3,0.4 -1.3,1.3 v 29.6 c 0,1.2 -0.4,2.3 -1.3,3.1 -0.9,0.9 -1.9,1.3 -3.1,1.3 h -14.1 c -1.2,0 -2.3,-0.4 -3.1,-1.3 -0.9,-0.9 -1.3,-1.9 -1.3,-3.1 v -29.6 c 0,-0.9 -0.4,-1.3 -1.3,-1.3 H 623 c -0.9,0 -1.3,0.4 -1.3,1.3 v 29.6 c 0,1.8 0.4,3.5 1.1,5.2 0.5,1.7 1.4,3.1 2.6,4.2 z"\n')
    gv.f.write('         class="st0"\n')
    gv.f.write('         style="fill:#1c76bc;fill-opacity:1"\n')
    gv.f.write('         inkscape:export-xdpi="201.7"\n')
    gv.f.write('         inkscape:export-ydpi="201.7" />\n')
    gv.f.write('      <path\n')
    gv.f.write('         inkscape:connector-curvature="0"\n')
    gv.f.write('         id="path4022"\n')
    gv.f.write('         d="m 675.7,354.5 c 1.2,1.2 2.6,2.1 4.2,2.8 1.6,0.7 3.3,1.1 5.2,1.1 h 14.1 c 1.2,0 2.3,0.4 3.1,1.3 0.9,0.9 1.3,1.9 1.3,3.1 0,1.2 -0.4,2.2 -1.3,3.1 -0.9,0.9 -1.9,1.3 -3.1,1.3 h -23.5 c -0.9,0 -1.3,0.4 -1.3,1.3 v 6.2 c 0,0.9 0.4,1.3 1.3,1.3 h 23.5 c 1.8,0 3.5,-0.4 5.2,-1.1 1.6,-0.7 3,-1.6 4.2,-2.8 1.2,-1.2 2.1,-2.6 2.8,-4.2 0.7,-1.6 1.1,-3.3 1.1,-5.2 0,-1.8 -0.4,-3.5 -1.1,-5.2 -0.7,-1.6 -1.6,-3 -2.8,-4.2 -1.2,-1.2 -2.6,-2.1 -4.2,-2.8 -1.6,-0.7 -3.3,-1.1 -5.2,-1.1 h -14.1 c -1.2,0 -2.3,-0.4 -3.1,-1.3 -0.9,-0.9 -1.3,-1.9 -1.3,-3.1 0,-1.2 0.4,-2.3 1.3,-3.1 0.9,-0.9 1.9,-1.3 3.1,-1.3 h 23.4 c 0.9,0 1.3,-0.4 1.3,-1.3 v -6.2 c 0,-0.9 -0.4,-1.3 -1.3,-1.3 h -23.4 c -1.8,0 -3.5,0.4 -5.2,1.1 -1.6,0.7 -3,1.6 -4.2,2.8 -1.2,1.2 -2.1,2.6 -2.8,4.2 -0.7,1.6 -1.1,3.3 -1.1,5.2 0,1.8 0.4,3.5 1.1,5.2 0.7,1.6 1.6,3 2.8,4.2 z"\n')
    gv.f.write('         class="st0"\n')
    gv.f.write('         style="fill:#1c76bc;fill-opacity:1"\n')
    gv.f.write('         inkscape:export-xdpi="201.7"\n')
    gv.f.write('         inkscape:export-ydpi="201.7" />\n')
    gv.f.write('      <path\n')
    gv.f.write('         inkscape:connector-curvature="0"\n')
    gv.f.write('         id="path4024"\n')
    gv.f.write('         d="m 750.8,376 h 6.2 c 0.9,0 1.3,-0.4 1.3,-1.3 v -44.1 c 0,-0.8 0.1,-1.1 0.4,-1.1 0.3,0 0.6,0.2 0.8,0.7 l 23.1,45 c 0.4,0.6 0.9,0.9 1.6,0.9 h 8.9 c 0.9,0 1.3,-0.4 1.3,-1.3 v -59.1 c 0,-0.9 -0.4,-1.3 -1.3,-1.3 H 787 c -0.9,0 -1.3,0.4 -1.3,1.3 v 44.1 c 0,0.8 -0.2,1.1 -0.5,1.1 -0.2,0 -0.5,-0.2 -0.7,-0.7 l -23.1,-45 c -0.4,-0.6 -0.9,-0.9 -1.6,-0.9 h -8.9 c -0.9,0 -1.3,0.4 -1.3,1.3 v 59.1 c -0.1,0.9 0.3,1.3 1.2,1.3 z"\n')
    gv.f.write('         class="st0"\n')
    gv.f.write('         style="fill:#1c76bc;fill-opacity:1"\n')
    gv.f.write('         inkscape:export-xdpi="201.7"\n')
    gv.f.write('         inkscape:export-ydpi="201.7" />\n')
    gv.f.write('      <path\n')
    gv.f.write('         inkscape:connector-curvature="0"\n')
    gv.f.write('         id="path4026"\n')
    gv.f.write('         d="m 809.8,372.1 c 1.2,1.2 2.6,2.1 4.2,2.8 1.6,0.7 3.3,1.1 5.2,1.1 h 14.1 c 1.8,0 3.5,-0.4 5.2,-1.1 1.6,-0.7 3,-1.6 4.2,-2.8 1.2,-1.2 2.1,-2.6 2.8,-4.2 0.7,-1.6 1.1,-3.3 1.1,-5.2 v -29.6 c 0,-0.9 -0.4,-1.3 -1.3,-1.3 H 839 c -0.9,0 -1.3,0.4 -1.3,1.3 v 29.6 c 0,1.2 -0.4,2.3 -1.3,3.1 -0.9,0.9 -1.9,1.3 -3.1,1.3 h -14.1 c -1.2,0 -2.3,-0.4 -3.1,-1.3 -0.9,-0.9 -1.3,-1.9 -1.3,-3.1 v -29.6 c 0,-0.9 -0.4,-1.3 -1.3,-1.3 h -6.2 c -0.9,0 -1.3,0.4 -1.3,1.3 v 29.6 c 0,1.8 0.4,3.5 1.1,5.2 0.6,1.7 1.6,3.1 2.7,4.2 z"\n')
    gv.f.write('         class="st0"\n')
    gv.f.write('         style="fill:#1c76bc;fill-opacity:1"\n')
    gv.f.write('         inkscape:export-xdpi="201.7"\n')
    gv.f.write('         inkscape:export-ydpi="201.7" />\n')
    gv.f.write('      <path\n')
    gv.f.write('         inkscape:connector-curvature="0"\n')
    gv.f.write('         id="path4028"\n')
    gv.f.write('         d="m 861,372.1 c 1.2,1.2 2.6,2.1 4.2,2.8 1.6,0.7 3.3,1.1 5.2,1.1 h 24.3 c 0.9,0 1.3,-0.4 1.3,-1.3 v -6.2 c 0,-0.9 -0.4,-1.3 -1.3,-1.3 h -24.3 c -1.2,0 -2.3,-0.4 -3.1,-1.3 -0.9,-0.9 -1.3,-1.9 -1.3,-3.1 v -17.6 c 0,-1.2 0.4,-2.3 1.3,-3.1 0.9,-0.9 1.9,-1.3 3.1,-1.3 h 24.3 c 0.9,0 1.3,-0.4 1.3,-1.3 v -6.2 c 0,-0.9 -0.4,-1.3 -1.3,-1.3 h -24.3 c -1.8,0 -3.5,0.4 -5.2,1.1 -1.6,0.7 -3,1.6 -4.2,2.8 -1.2,1.2 -2.1,2.6 -2.8,4.2 -0.7,1.6 -1.1,3.3 -1.1,5.2 v 17.6 c 0,1.8 0.4,3.5 1.1,5.2 0.7,1.5 1.6,2.9 2.8,4 z"\n')
    gv.f.write('         class="st0"\n')
    gv.f.write('         style="fill:#1c76bc;fill-opacity:1"\n')
    gv.f.write('         inkscape:export-xdpi="201.7"\n')
    gv.f.write('         inkscape:export-ydpi="201.7" />\n')
    gv.f.write('      <path\n')
    gv.f.write('         inkscape:connector-curvature="0"\n')
    gv.f.write('         id="path4030"\n')
    gv.f.write('         d="m 911.4,375.9 h 8.8 c 0.9,0 1.3,-0.4 1.3,-1.3 v -6.2 c 0,-0.9 -0.4,-1.3 -1.3,-1.3 h -3.1 c -0.9,0 -1.3,-0.4 -1.3,-1.3 v -50.2 c 0,-0.9 -0.4,-1.3 -1.3,-1.3 h -6.2 c -0.9,0 -1.3,0.4 -1.3,1.3 v 55.9 c 0,1 0.4,2 1.1,3 0.7,0.9 1.8,1.4 3.3,1.4 z"\n')
    gv.f.write('         class="st0"\n')
    gv.f.write('         style="fill:#1c76bc;fill-opacity:1"\n')
    gv.f.write('         inkscape:export-xdpi="201.7"\n')
    gv.f.write('         inkscape:export-ydpi="201.7" />\n')
    gv.f.write('      <path\n')
    gv.f.write('         inkscape:connector-curvature="0"\n')
    gv.f.write('         id="path4032"\n')
    gv.f.write('         d="m 933.4,372.1 c 1.2,1.2 2.6,2.1 4.2,2.8 1.6,0.7 3.3,1.1 5.2,1.1 H 967 c 0.9,0 1.3,-0.4 1.3,-1.3 v -6.2 c 0,-0.9 -0.4,-1.3 -1.3,-1.3 h -24.3 c -1.2,0 -2.3,-0.4 -3.1,-1.3 -0.9,-0.9 -1.3,-1.9 -1.3,-3.1 v -3.1 c 0,-0.9 0.4,-1.3 1.3,-1.3 h 29.1 c 0.9,0 1.3,-0.4 1.3,-1.3 v -11.9 c 0,-1.8 -0.4,-3.5 -1.1,-5.2 -0.7,-1.6 -1.6,-3 -2.8,-4.2 -1.2,-1.2 -2.6,-2.1 -4.2,-2.8 -1.6,-0.7 -3.3,-1.1 -5.2,-1.1 h -14.1 c -1.8,0 -3.5,0.4 -5.2,1.1 -1.6,0.7 -3,1.6 -4.2,2.8 -1.2,1.2 -2.1,2.6 -2.8,4.2 -0.7,1.6 -1.1,3.3 -1.1,5.2 v 17.6 c 0,1.8 0.4,3.5 1.1,5.2 0.9,1.6 1.8,3 3,4.1 z m 4.9,-27 c 0,-1.2 0.4,-2.3 1.3,-3.1 0.9,-0.9 1.9,-1.3 3.1,-1.3 h 14.1 c 1.2,0 2.3,0.4 3.1,1.3 0.9,0.9 1.3,1.9 1.3,3.1 v 4.4 h -22.9 z"\n')
    gv.f.write('         class="st0"\n')
    gv.f.write('         style="fill:#1c76bc;fill-opacity:1"\n')
    gv.f.write('         inkscape:export-xdpi="201.7"\n')
    gv.f.write('         inkscape:export-ydpi="201.7" />\n')
    gv.f.write('      <path\n')
    gv.f.write('         inkscape:connector-curvature="0"\n')
    gv.f.write('         id="path4034"\n')
    gv.f.write('         d="m 982.8,372.1 c 1.2,1.2 2.6,2.1 4.2,2.8 1.6,0.7 3.3,1.1 5.2,1.1 h 26 c 0.9,0 1.3,-0.4 1.3,-1.3 v -29.6 c 0,-1.8 -0.4,-3.5 -1.1,-5.2 -0.7,-1.6 -1.6,-3 -2.8,-4.2 -1.2,-1.2 -2.6,-2.1 -4.2,-2.8 -1.6,-0.7 -3.3,-1.1 -5.2,-1.1 h -21.7 c -0.9,0 -1.3,0.4 -1.3,1.3 v 6.2 c 0,0.9 0.4,1.3 1.3,1.3 h 21.7 c 1.2,0 2.3,0.4 3.1,1.3 0.9,0.9 1.3,1.9 1.3,3.1 v 3.1 c 0,0.9 -0.4,1.3 -1.3,1.3 h -17.2 c -1.8,0 -3.5,0.4 -5.2,1.1 -1.6,0.7 -3,1.6 -4.2,2.8 -1.2,1.2 -2.1,2.6 -2.8,4.2 -0.7,1.6 -1.1,3.3 -1.1,5.2 0,1.8 0.4,3.5 1.1,5.2 0.8,1.7 1.7,3.1 2.9,4.2 z m 6.2,-12.5 c 0.9,-0.9 1.9,-1.3 3.1,-1.3 h 17.2 c 0.9,0 1.3,0.4 1.3,1.3 v 6.2 c 0,0.9 -0.4,1.3 -1.3,1.3 h -17.2 c -1.2,0 -2.3,-0.4 -3.1,-1.3 -0.9,-0.9 -1.3,-1.9 -1.3,-3.1 0,-1.2 0.5,-2.2 1.3,-3.1 z"\n')
    gv.f.write('         class="st0"\n')
    gv.f.write('         style="fill:#1c76bc;fill-opacity:1"\n')
    gv.f.write('         inkscape:export-xdpi="201.7"\n')
    gv.f.write('         inkscape:export-ydpi="201.7" />\n')
    gv.f.write('      <path\n')
    gv.f.write('         inkscape:connector-curvature="0"\n')
    gv.f.write('         id="path4036"\n')
    gv.f.write('         d="m 1055.7,331.9 h -13 c -1.8,0.1 -3.5,0.4 -5.1,1.1 -1.6,0.7 -3,1.7 -4.1,2.9 -1.2,1.2 -2.1,2.6 -2.8,4.2 -0.7,1.6 -1,3.3 -1,5.1 v 29.5 c 0,0.9 0.4,1.3 1.3,1.3 h 6.2 c 0.9,0 1.3,-0.4 1.3,-1.3 v -29.5 c 0,-1.2 0.4,-2.3 1.3,-3.2 0.9,-0.9 1.9,-1.3 3.1,-1.3 h 12.8 c 0.9,0 1.3,-0.4 1.3,-1.3 v -6.2 c 0,-0.9 -0.4,-1.3 -1.3,-1.3 z"\n')
    gv.f.write('         class="st0"\n')
    gv.f.write('         style="fill:#1c76bc;fill-opacity:1"\n')
    gv.f.write('         inkscape:export-xdpi="201.7"\n')
    gv.f.write('         inkscape:export-ydpi="201.7" />\n')
    gv.f.write('      <path\n')
    gv.f.write('         inkscape:connector-curvature="0"\n')
    gv.f.write('         id="path4038"\n')
    gv.f.write('         d="m 436.5,405.1 c -0.6,2.2 -1.1,4.1 -1.4,6 H 435 c -0.4,-1.9 -1,-3.8 -1.6,-6.1 l -2.9,-9.3 h -2.8 l -3,9.5 c -0.6,2 -1.2,4 -1.6,5.9 H 423 c -0.3,-1.9 -0.8,-3.8 -1.4,-5.9 l -2.5,-9.4 h -3.5 l 5.6,18.6 h 3.1 l 3,-8.8 c 0.7,-2 1.2,-3.9 1.7,-6.1 h 0.1 c 0.5,2.2 1,4 1.6,6.1 l 2.8,8.9 h 3.1 l 6,-18.6 h -3.3 z"\n')
    gv.f.write('         class="st1"\n')
    gv.f.write('         style="fill:#6e6e73;fill-opacity:1"\n')
    gv.f.write('         inkscape:export-xdpi="201.7"\n')
    gv.f.write('         inkscape:export-ydpi="201.7" />\n')
    gv.f.write('      <path\n')
    gv.f.write('         inkscape:connector-curvature="0"\n')
    gv.f.write('         id="path4040"\n')
    gv.f.write('         d="m 475.1,405.1 c -0.6,2.2 -1.1,4.1 -1.4,6 h -0.1 c -0.4,-1.9 -1,-3.8 -1.6,-6.1 l -2.9,-9.3 h -2.8 l -3,9.5 c -0.6,2 -1.2,4 -1.6,5.9 h -0.1 c -0.3,-1.9 -0.8,-3.8 -1.4,-5.9 l -2.5,-9.4 h -3.5 l 5.6,18.6 h 3.1 l 3,-8.8 c 0.7,-2 1.2,-3.9 1.7,-6.1 h 0.1 c 0.5,2.2 1,4 1.6,6.1 l 2.8,8.9 h 3.1 l 6,-18.6 h -3.3 z"\n')
    gv.f.write('         class="st1"\n')
    gv.f.write('         style="fill:#6e6e73;fill-opacity:1"\n')
    gv.f.write('         inkscape:export-xdpi="201.7"\n')
    gv.f.write('         inkscape:export-ydpi="201.7" />\n')
    gv.f.write('      <path\n')
    gv.f.write('         inkscape:connector-curvature="0"\n')
    gv.f.write('         id="path4042"\n')
    gv.f.write('         d="m 513.8,405.1 c -0.6,2.2 -1.1,4.1 -1.4,6 h -0.1 c -0.4,-1.9 -1,-3.8 -1.6,-6.1 l -2.9,-9.3 H 505 l -3,9.5 c -0.6,2 -1.2,4 -1.6,5.9 h -0.1 c -0.3,-1.9 -0.8,-3.8 -1.4,-5.9 l -2.5,-9.4 h -3.5 l 5.6,18.6 h 3.1 l 3,-8.8 c 0.7,-2 1.2,-3.9 1.7,-6.1 h 0.1 c 0.5,2.2 1,4 1.6,6.1 l 2.8,8.9 h 3.1 l 6,-18.6 h -3.3 z"\n')
    gv.f.write('         class="st1"\n')
    gv.f.write('         style="fill:#6e6e73;fill-opacity:1"\n')
    gv.f.write('         inkscape:export-xdpi="201.7"\n')
    gv.f.write('         inkscape:export-ydpi="201.7" />\n')
    gv.f.write('      <path\n')
    gv.f.write('         inkscape:connector-curvature="0"\n')
    gv.f.write('         id="path4044"\n')
    gv.f.write('         d="m 533.1,410 c -1.3,0 -2.3,1 -2.3,2.4 0,1.4 0.9,2.4 2.3,2.4 1.4,0 2.3,-1 2.3,-2.4 0,-1.4 -1,-2.4 -2.3,-2.4 z"\n')
    gv.f.write('         class="st1"\n')
    gv.f.write('         style="fill:#6e6e73;fill-opacity:1"\n')
    gv.f.write('         inkscape:export-xdpi="201.7"\n')
    gv.f.write('         inkscape:export-ydpi="201.7" />\n')
    gv.f.write('      <path\n')
    gv.f.write('         inkscape:connector-curvature="0"\n')
    gv.f.write('         id="path4046"\n')
    gv.f.write('         d="m 558.1,398.1 c 1.8,0 3.1,0.4 3.9,0.9 l 0.8,-2.6 c -0.9,-0.5 -2.7,-1 -4.7,-1 -6.1,0 -10,4.1 -10,9.9 0,5.7 3.6,9.5 9.2,9.5 2.5,0 4.4,-0.6 5.3,-1.1 l -0.6,-2.5 c -1,0.4 -2.2,0.9 -4.1,0.9 -3.7,0 -6.4,-2.6 -6.4,-6.9 0.1,-3.9 2.4,-7.1 6.6,-7.1 z"\n')
    gv.f.write('         class="st1"\n')
    gv.f.write('         style="fill:#6e6e73;fill-opacity:1"\n')
    gv.f.write('         inkscape:export-xdpi="201.7"\n')
    gv.f.write('         inkscape:export-ydpi="201.7" />\n')
    gv.f.write('      <path\n')
    gv.f.write('         inkscape:connector-curvature="0"\n')
    gv.f.write('         id="path4048"\n')
    gv.f.write('         d="m 583.8,395.4 c -5.4,0 -8.7,4.4 -8.7,10 0,5.6 3.4,9.4 9.1,9.4 3,0 5,-0.6 6.2,-1.2 l -0.6,-2.4 c -1.3,0.5 -2.7,1 -5.1,1 -3.4,0 -6.3,-1.9 -6.4,-6.4 h 13 c 0,-0.3 0.1,-0.9 0.1,-1.6 0.1,-3.5 -1.6,-8.8 -7.6,-8.8 z m -5.5,7.9 c 0.3,-2.3 1.8,-5.5 5.2,-5.5 3.8,0 4.7,3.3 4.7,5.5 z"\n')
    gv.f.write('         class="st1"\n')
    gv.f.write('         style="fill:#6e6e73;fill-opacity:1"\n')
    gv.f.write('         inkscape:export-xdpi="201.7"\n')
    gv.f.write('         inkscape:export-ydpi="201.7" />\n')
    gv.f.write('      <path\n')
    gv.f.write('         inkscape:connector-curvature="0"\n')
    gv.f.write('         id="path4050"\n')
    gv.f.write('         d="m 608.7,399.5 h -0.2 l -0.1,-3.6 h -3 c 0.1,1.7 0.2,3.6 0.2,5.8 v 12.8 h 3.3 v -9.9 c 0,-0.6 0.1,-1.1 0.2,-1.6 0.5,-2.5 2.1,-4.3 4.5,-4.3 0.5,0 0.8,0 1.2,0.1 v -3.2 c -0.3,-0.1 -0.6,-0.1 -1,-0.1 -2.2,-0.1 -4.3,1.5 -5.1,4 z"\n')
    gv.f.write('         class="st1"\n')
    gv.f.write('         style="fill:#6e6e73;fill-opacity:1"\n')
    gv.f.write('         inkscape:export-xdpi="201.7"\n')
    gv.f.write('         inkscape:export-ydpi="201.7" />\n')
    gv.f.write('      <path\n')
    gv.f.write('         inkscape:connector-curvature="0"\n')
    gv.f.write('         id="path4052"\n')
    gv.f.write('         d="m 638,395.4 c -3,0 -5.1,1.3 -6.3,3.4 h -0.1 v -11.7 h -3.3 v 22.4 c 0,1.6 -0.1,3.5 -0.2,4.8 h 2.9 l 0.2,-3.1 h 0.1 c 1.4,2.5 3.5,3.5 6.2,3.5 4.1,0 8.3,-3.3 8.3,-9.9 0.1,-5.6 -3.2,-9.4 -7.8,-9.4 z m -1.2,16.7 c -2.5,0 -4.4,-1.6 -5.1,-4 -0.1,-0.4 -0.2,-0.8 -0.2,-1.2 v -3.3 c 0,-0.5 0.1,-1 0.2,-1.4 0.7,-2.6 2.8,-4.1 5.1,-4.1 3.6,0 5.5,3.2 5.5,6.9 0.2,4.2 -1.9,7.1 -5.5,7.1 z"\n')
    gv.f.write('         class="st1"\n')
    gv.f.write('         style="fill:#6e6e73;fill-opacity:1"\n')
    gv.f.write('         inkscape:export-xdpi="201.7"\n')
    gv.f.write('         inkscape:export-ydpi="201.7" />\n')
    gv.f.write('      <path\n')
    gv.f.write('         inkscape:connector-curvature="0"\n')
    gv.f.write('         id="path4054"\n')
    gv.f.write('         d="m 667.4,395.4 c -5.4,0 -8.7,4.4 -8.7,10 0,5.6 3.4,9.4 9.1,9.4 3,0 5,-0.6 6.2,-1.2 l -0.6,-2.4 c -1.3,0.5 -2.7,1 -5.1,1 -3.4,0 -6.3,-1.9 -6.4,-6.4 h 13 c 0,-0.3 0.1,-0.9 0.1,-1.6 0.1,-3.5 -1.5,-8.8 -7.6,-8.8 z m -5.4,7.9 c 0.3,-2.3 1.8,-5.5 5.2,-5.5 3.8,0 4.7,3.3 4.7,5.5 z"\n')
    gv.f.write('         class="st1"\n')
    gv.f.write('         style="fill:#6e6e73;fill-opacity:1"\n')
    gv.f.write('         inkscape:export-xdpi="201.7"\n')
    gv.f.write('         inkscape:export-ydpi="201.7" />\n')
    gv.f.write('      <path\n')
    gv.f.write('         inkscape:connector-curvature="0"\n')
    gv.f.write('         id="path4056"\n')
    gv.f.write('         d="m 692.3,399.5 h -0.2 l -0.1,-3.6 h -3 c 0.1,1.7 0.2,3.6 0.2,5.8 v 12.8 h 3.3 v -9.9 c 0,-0.6 0.1,-1.1 0.2,-1.6 0.5,-2.5 2.1,-4.3 4.5,-4.3 0.5,0 0.8,0 1.2,0.1 v -3.2 c -0.3,-0.1 -0.6,-0.1 -1,-0.1 -2.2,-0.1 -4.2,1.5 -5.1,4 z"\n')
    gv.f.write('         class="st1"\n')
    gv.f.write('         style="fill:#6e6e73;fill-opacity:1"\n')
    gv.f.write('         inkscape:export-xdpi="201.7"\n')
    gv.f.write('         inkscape:export-ydpi="201.7" />\n')
    gv.f.write('      <path\n')
    gv.f.write('         inkscape:connector-curvature="0"\n')
    gv.f.write('         id="path4058"\n')
    gv.f.write('         d="m 727.3,395.8 h -3.4 v 11.4 c 0,0.6 -0.1,1.2 -0.3,1.7 -0.6,1.5 -2.2,3.1 -4.4,3.1 -3.1,0 -4.1,-2.4 -4.1,-5.9 v -10.3 h -3.4 v 10.9 c 0,6.5 3.5,8.1 6.4,8.1 3.3,0 5.3,-2 6.1,-3.5 h 0.1 l 0.2,3 h 3 c -0.1,-1.5 -0.2,-3.1 -0.2,-5.1 z"\n')
    gv.f.write('         class="st1"\n')
    gv.f.write('         style="fill:#6e6e73;fill-opacity:1"\n')
    gv.f.write('         inkscape:export-xdpi="201.7"\n')
    gv.f.write('         inkscape:export-ydpi="201.7" />\n')
    gv.f.write('      <path\n')
    gv.f.write('         inkscape:connector-curvature="0"\n')
    gv.f.write('         id="path4060"\n')
    gv.f.write('         d="m 748.8,403.6 c -2.4,-0.9 -3.5,-1.6 -3.5,-3.1 0,-1.4 1.1,-2.5 3.1,-2.5 1.7,0 3.1,0.6 3.8,1.1 l 0.8,-2.5 c -1,-0.6 -2.7,-1.2 -4.6,-1.2 -4,0 -6.4,2.5 -6.4,5.4 0,2.2 1.6,4.1 4.9,5.3 2.5,0.9 3.5,1.8 3.5,3.4 0,1.5 -1.2,2.8 -3.6,2.8 -1.7,0 -3.5,-0.7 -4.4,-1.3 l -0.8,2.6 c 1.3,0.8 3.2,1.3 5.2,1.3 4.4,0 6.9,-2.3 6.9,-5.6 0,-2.9 -1.6,-4.5 -4.9,-5.7 z"\n')
    gv.f.write('         class="st1"\n')
    gv.f.write('         style="fill:#6e6e73;fill-opacity:1"\n')
    gv.f.write('         inkscape:export-xdpi="201.7"\n')
    gv.f.write('         inkscape:export-ydpi="201.7" />\n')
    gv.f.write('      <path\n')
    gv.f.write('         inkscape:connector-curvature="0"\n')
    gv.f.write('         id="path4062"\n')
    gv.f.write('         d="m 777.3,395.4 c -3.1,0 -5.2,1.7 -6.1,3.5 H 771 l -0.2,-3.1 h -3 c 0.1,1.5 0.2,3.1 0.2,5 v 13.5 h 3.4 v -11.2 c 0,-0.6 0.1,-1.2 0.2,-1.6 0.6,-1.9 2.3,-3.5 4.5,-3.5 3.2,0 4.3,2.5 4.3,5.5 v 10.7 h 3.4 v -11.1 c 0,-6.2 -4,-7.7 -6.5,-7.7 z"\n')
    gv.f.write('         class="st1"\n')
    gv.f.write('         style="fill:#6e6e73;fill-opacity:1"\n')
    gv.f.write('         inkscape:export-xdpi="201.7"\n')
    gv.f.write('         inkscape:export-ydpi="201.7" />\n')
    gv.f.write('      <path\n')
    gv.f.write('         inkscape:connector-curvature="0"\n')
    gv.f.write('         id="path4064"\n')
    gv.f.write('         d="m 814.8,395.8 h -3.4 v 11.4 c 0,0.6 -0.1,1.2 -0.3,1.7 -0.6,1.5 -2.2,3.1 -4.4,3.1 -3.1,0 -4.1,-2.4 -4.1,-5.9 v -10.3 h -3.4 v 10.9 c 0,6.5 3.5,8.1 6.4,8.1 3.3,0 5.3,-2 6.1,-3.5 h 0.1 l 0.2,3 h 3 c -0.1,-1.5 -0.2,-3.1 -0.2,-5.1 z"\n')
    gv.f.write('         class="st1"\n')
    gv.f.write('         style="fill:#6e6e73;fill-opacity:1"\n')
    gv.f.write('         inkscape:export-xdpi="201.7"\n')
    gv.f.write('         inkscape:export-ydpi="201.7" />\n')
    gv.f.write('      <path\n')
    gv.f.write('         inkscape:connector-curvature="0"\n')
    gv.f.write('         id="path4066"\n')
    gv.f.write('         d="m 839,398.1 c 1.8,0 3.1,0.4 3.9,0.9 l 0.8,-2.6 c -0.9,-0.5 -2.7,-1 -4.7,-1 -6.1,0 -10,4.1 -10,9.9 0,5.7 3.6,9.5 9.2,9.5 2.5,0 4.4,-0.6 5.3,-1.1 l -0.6,-2.5 c -1,0.4 -2.2,0.9 -4.1,0.9 -3.7,0 -6.4,-2.6 -6.4,-6.9 0,-3.9 2.3,-7.1 6.6,-7.1 z"\n')
    gv.f.write('         class="st1"\n')
    gv.f.write('         style="fill:#6e6e73;fill-opacity:1"\n')
    gv.f.write('         inkscape:export-xdpi="201.7"\n')
    gv.f.write('         inkscape:export-ydpi="201.7" />\n')
    gv.f.write('      <rect\n')
    gv.f.write('         id="rect4068"\n')
    gv.f.write('         height="27.200001"\n')
    gv.f.write('         width="3.4000001"\n')
    gv.f.write('         class="st1"\n')
    gv.f.write('         y="387.20001"\n')
    gv.f.write('         x="857.5"\n')
    gv.f.write('         style="fill:#6e6e73;fill-opacity:1"\n')
    gv.f.write('         inkscape:export-xdpi="201.7"\n')
    gv.f.write('         inkscape:export-ydpi="201.7" />\n')
    gv.f.write('      <path\n')
    gv.f.write('         inkscape:connector-curvature="0"\n')
    gv.f.write('         id="path4070"\n')
    gv.f.write('         d="m 883.9,395.4 c -5.4,0 -8.7,4.4 -8.7,10 0,5.6 3.4,9.4 9.1,9.4 3,0 5,-0.6 6.2,-1.2 l -0.6,-2.4 c -1.3,0.5 -2.7,1 -5.1,1 -3.4,0 -6.3,-1.9 -6.4,-6.4 h 13 c 0,-0.3 0.1,-0.9 0.1,-1.6 0.1,-3.5 -1.5,-8.8 -7.6,-8.8 z m -5.5,7.9 c 0.3,-2.3 1.8,-5.5 5.2,-5.5 3.8,0 4.7,3.3 4.7,5.5 z"\n')
    gv.f.write('         class="st1"\n')
    gv.f.write('         style="fill:#6e6e73;fill-opacity:1"\n')
    gv.f.write('         inkscape:export-xdpi="201.7"\n')
    gv.f.write('         inkscape:export-ydpi="201.7" />\n')
    gv.f.write('      <path\n')
    gv.f.write('         inkscape:connector-curvature="0"\n')
    gv.f.write('         id="path4072"\n')
    gv.f.write('         d="m 918.8,403 c 0,-3.7 -1.4,-7.6 -7.1,-7.6 -2.3,0 -4.6,0.7 -6.1,1.6 l 0.8,2.2 c 1.3,-0.8 3.1,-1.4 4.8,-1.4 3.8,0 4.2,2.8 4.2,4.3 v 0.4 c -7.2,0 -11.2,2.4 -11.2,6.9 0,2.7 1.9,5.3 5.7,5.3 2.6,0 4.6,-1.3 5.7,-2.8 h 0.1 l 0.3,2.3 h 3.1 c -0.2,-1.3 -0.3,-2.8 -0.3,-4.4 z m -3.3,5.1 c 0,0.3 -0.1,0.7 -0.2,1.1 -0.5,1.6 -2.1,3.1 -4.5,3.1 -1.7,0 -3.2,-1 -3.2,-3.2 0,-3.6 4.2,-4.3 7.9,-4.2 z"\n')
    gv.f.write('         class="st1"\n')
    gv.f.write('         style="fill:#6e6e73;fill-opacity:1"\n')
    gv.f.write('         inkscape:export-xdpi="201.7"\n')
    gv.f.write('         inkscape:export-ydpi="201.7" />\n')
    gv.f.write('      <path\n')
    gv.f.write('         inkscape:connector-curvature="0"\n')
    gv.f.write('         id="path4074"\n')
    gv.f.write('         d="M 937.2,399.5 H 937 l -0.1,-3.6 h -3 c 0.1,1.7 0.2,3.6 0.2,5.8 v 12.8 h 3.3 v -9.9 c 0,-0.6 0.1,-1.1 0.2,-1.6 0.5,-2.5 2.1,-4.3 4.5,-4.3 0.5,0 0.8,0 1.2,0.1 v -3.2 c -0.3,-0.1 -0.6,-0.1 -1,-0.1 -2.2,-0.1 -4.2,1.5 -5.1,4 z"\n')
    gv.f.write('         class="st1"\n')
    gv.f.write('         style="fill:#6e6e73;fill-opacity:1"\n')
    gv.f.write('         inkscape:export-xdpi="201.7"\n')
    gv.f.write('         inkscape:export-ydpi="201.7" />\n')
    gv.f.write('      <path\n')
    gv.f.write('         inkscape:connector-curvature="0"\n')
    gv.f.write('         id="path4076"\n')
    gv.f.write('         d="m 956.1,410 c -1.3,0 -2.3,1 -2.3,2.4 0,1.4 0.9,2.4 2.3,2.4 1.4,0 2.3,-1 2.3,-2.4 0,-1.4 -0.9,-2.4 -2.3,-2.4 z"\n')
    gv.f.write('         class="st1"\n')
    gv.f.write('         style="fill:#6e6e73;fill-opacity:1"\n')
    gv.f.write('         inkscape:export-xdpi="201.7"\n')
    gv.f.write('         inkscape:export-ydpi="201.7" />\n')
    gv.f.write('      <path\n')
    gv.f.write('         inkscape:connector-curvature="0"\n')
    gv.f.write('         id="path4078"\n')
    gv.f.write('         d="m 981.2,398.1 c 1.8,0 3.1,0.4 3.9,0.9 l 0.8,-2.6 c -0.9,-0.5 -2.7,-1 -4.7,-1 -6.1,0 -10,4.1 -10,9.9 0,5.7 3.6,9.5 9.2,9.5 2.5,0 4.4,-0.6 5.3,-1.1 l -0.6,-2.5 c -1,0.4 -2.2,0.9 -4.1,0.9 -3.7,0 -6.4,-2.6 -6.4,-6.9 0,-3.9 2.3,-7.1 6.6,-7.1 z"\n')
    gv.f.write('         class="st1"\n')
    gv.f.write('         style="fill:#6e6e73;fill-opacity:1"\n')
    gv.f.write('         inkscape:export-xdpi="201.7"\n')
    gv.f.write('         inkscape:export-ydpi="201.7" />\n')
    gv.f.write('      <path\n')
    gv.f.write('         inkscape:connector-curvature="0"\n')
    gv.f.write('         id="path4080"\n')
    gv.f.write('         d="m 1007.3,395.4 c -5.1,0 -9.2,3.6 -9.2,9.9 0,5.9 3.9,9.5 8.9,9.5 4.5,0 9.2,-3 9.2,-9.9 0.1,-5.6 -3.5,-9.5 -8.9,-9.5 z m -0.1,16.9 c -3.3,0 -5.6,-3.1 -5.6,-7.1 0,-3.5 1.7,-7.2 5.7,-7.2 4,0 5.6,4 5.6,7.1 -0.1,4.1 -2.5,7.2 -5.7,7.2 z"\n')
    gv.f.write('         class="st1"\n')
    gv.f.write('         style="fill:#6e6e73;fill-opacity:1"\n')
    gv.f.write('         inkscape:export-xdpi="201.7"\n')
    gv.f.write('         inkscape:export-ydpi="201.7" />\n')
    gv.f.write('      <path\n')
    gv.f.write('         inkscape:connector-curvature="0"\n')
    gv.f.write('         id="path4082"\n')
    gv.f.write('         d="m 1050.9,395.4 c -1.8,0 -3,0.5 -4.1,1.3 -0.8,0.6 -1.5,1.4 -2.1,2.4 h -0.1 c -0.8,-2.2 -2.7,-3.7 -5.3,-3.7 -3.1,0 -4.8,1.6 -5.8,3.4 h -0.1 l -0.2,-3 h -3 c 0.1,1.5 0.2,3.1 0.2,5 v 13.5 h 3.3 v -11.2 c 0,-0.6 0.1,-1.2 0.3,-1.6 0.5,-1.7 2.1,-3.4 4.2,-3.4 2.6,0 3.9,2.1 3.9,5.1 v 11.1 h 3.3 v -11.5 c 0,-0.6 0.1,-1.2 0.3,-1.7 0.6,-1.6 2.1,-3.1 4,-3.1 2.7,0 4,2.1 4,5.7 v 10.5 h 3.3 v -10.9 c 0,-6.3 -3.6,-7.9 -6.1,-7.9 z"\n')
    gv.f.write('         class="st1"\n')
    gv.f.write('         style="fill:#6e6e73;fill-opacity:1"\n')
    gv.f.write('         inkscape:export-xdpi="201.7"\n')
    gv.f.write('         inkscape:export-ydpi="201.7" />\n')
    gv.f.write('      <path\n')
    gv.f.write('         inkscape:connector-curvature="0"\n')
    gv.f.write('         id="path4084"\n')
    gv.f.write('         d="m 424.9,378.1 -25.8,7 -4.4,-10.1 -11.5,9.4 -9,-3.7 -3.3,-1.4 c 0,0 -7.5,7.4 -7.5,7.4 -0.2,0 -0.4,0 -0.6,0 -0.5,0 -1,0 -1.6,0 -0.8,0 -1.5,0 -2.3,0 -0.9,0 -1.9,0 -2.8,0 -1,0 -2.1,0 -3.1,0 -1,0 -2.1,0 -3.1,0 -0.9,0 -1.9,0 -2.8,0 -0.8,0 -1.6,0 -2.4,0 -0.5,0 -1.1,0 -1.6,0 -0.1,0 -0.3,0 -0.4,0 0,0 -0.1,0 -0.1,0 0,0 0,0 0,0 -0.1,0 -0.1,-0.3 -0.2,-0.4 0,-0.1 -0.1,-0.1 -0.1,-0.2 -0.1,-0.1 -0.1,-0.3 -0.2,-0.4 -0.1,-0.3 -0.2,-0.7 -0.3,-1 -0.3,-0.8 -0.5,-1.6 -0.7,-2.4 -0.2,-1 -0.5,-1.9 -0.7,-2.9 -0.2,-1.1 -0.5,-2.2 -0.7,-3.3 -0.2,-1.2 -0.4,-2.4 -0.6,-3.6 -0.2,-1.3 -0.4,-2.5 -0.6,-3.8 -0.2,-1.3 -0.4,-2.6 -0.6,-3.9 -0.2,-1.3 -0.4,-2.6 -0.5,-3.9 -0.2,-1.3 -0.3,-2.6 -0.5,-3.9 -0.2,-1.2 -0.3,-2.5 -0.4,-3.7 -0.1,-1.1 -0.3,-2.3 -0.4,-3.4 -0.1,-1 -0.2,-2 -0.3,-3.1 -0.1,-0.9 -0.2,-1.7 -0.3,-2.6 0,-0.2 0,-0.4 -0.1,-0.6 -0.5,-7.8 -3.7,-8.8 -5.7,-8.7 -3.2,0.2 -5.4,3.7 -5.2,8.6 0.1,3.1 -3.7,11.6 -6.7,17.3 -0.6,0.2 -1.2,0.3 -1.8,0.4 -20.9,-29.5 -37.7,-81 -50,-153.6 -0.6,-3.5 -1,-6.2 -1.4,-7.7 -0.6,-3.2 -1.8,-9 -6.1,-9 -1.3,0 -4.9,0 -7.3,11.6 0,0.2 -3.1,12.1 -10.5,29.4 -2.5,4 -4.5,8.4 -6.4,12.7 -2.9,6.4 -5.8,12.9 -10.7,18.1 -21.3,16.4 -77.4,-7.2 -78,-7.5 l -2.6,6 c 1.5,0.6 19.2,8.1 39,11.7 -10,-1 -22.1,-3.4 -36.8,-7.6 l -1.8,6.2 c 52.7,14.8 74.2,7.8 85.6,-5 2.1,-1.9 4,-4.2 5.5,-6.9 4.9,-9 8.9,-17.4 12.1,-24.9 1.8,-2.8 2.8,-3.2 2.8,-3.3 3.5,1.5 7.7,21.8 11.4,39.6 3.4,16.2 7.5,36.3 13.4,56.9 0.3,1.4 0.7,2.8 1.1,4.2 -0.6,-0.8 -1.2,-1.6 -1.8,-2.4 -1.7,-2.3 -3.3,-4.5 -4.9,-6.4 -8.8,-11.2 -16.3,-8.6 -23,-6.3 -4.5,1.6 -8.8,3.1 -14.5,1.2 -15.6,-5.3 -84.7,-35.8 -85.4,-36.1 L 143,288 c 2.9,1.3 70.1,30.9 86,36.3 7.8,2.6 13.8,0.5 18.7,-1.2 6.3,-2.2 9.8,-3.4 15.7,4.2 1.5,1.9 3.1,4.1 4.8,6.3 4.1,5.5 8.8,11.7 13.9,17.3 0.7,1.5 1.5,2.9 2.3,4.4 0.8,1.4 1.6,2.7 2.4,4 0.8,1.3 1.6,2.5 2.5,3.7 0.8,1.2 1.7,2.3 2.6,3.4 0.9,1.1 1.8,2.1 2.7,3.1 0.9,1 1.8,1.9 2.8,2.9 0.9,0.9 1.8,1.8 2.8,2.6 0.9,0.8 1.9,1.6 2.8,2.3 0.9,0.7 1.9,1.4 2.8,2.1 0.9,0.6 1.9,1.3 2.8,1.9 0.9,0.6 1.9,1.1 2.8,1.7 0.9,0.5 1.8,1 2.8,1.5 0.9,0.4 1.8,0.9 2.7,1.3 0.9,0.4 1.8,0.7 2.6,1.1 0.8,0.3 1.7,0.6 2.5,0.9 0.8,0.3 1.6,0.5 2.4,0.8 0.8,0.2 1.5,0.4 2.3,0.6 0.7,0.2 1.4,0.4 2.2,0.5 0.7,0.1 1.3,0.3 2,0.4 0.6,0.1 1.2,0.2 1.8,0.3 0.6,0.1 1.1,0.2 1.7,0.2 0.5,0.1 1,0.1 1.4,0.2 0.4,0 0.8,0.1 1.2,0.1 0.3,0 0.7,0 1,0.1 0.5,0 1,0.1 1.4,0 0.4,-0.1 0.8,-0.2 1.1,-0.4 0.6,-0.3 1,-0.7 1.3,-1.2 0.1,-0.2 0.2,-0.4 0.3,-0.6 h 22.4 l 7.4,-6.7 12.2,5 9.5,-8.4 3.2,9.4 28.1,-7.7 24.7,2.7 H 1057 v -2.2 H 450.1 Z M 321,366.5 l 1.2,-0.4 0.6,-1.1 c 1,-1.8 4.7,-8.6 6.7,-14.7 0.8,7.8 2.4,20.7 4.4,30 -4.8,-3.6 -9.3,-8.1 -13.7,-13.6 0.3,0 0.6,-0.1 0.8,-0.2 z m -40.6,-40.2 c -5.8,-20.5 -10,-40.5 -13.3,-56.6 -6.4,-30.8 -9.3,-43.3 -16.5,-44.7 -0.1,0 -0.1,0 -0.1,0 4.8,-12.4 6.9,-20.5 7,-21.2 0.2,-1 0.5,-2 0.8,-3 0,0.1 0,0.2 0.1,0.3 0.3,1.5 0.7,4 1.3,7.5 11.9,70.4 28.2,121.4 48.6,152.4 -7.5,-1.6 -14.4,-7 -20.7,-13.7 -2.9,-6 -5.3,-12.9 -7.2,-21 z m 17.9,37.9 c 4.6,2.5 9.5,3.9 14.8,3.8 4.3,5.7 8.8,10.6 13.4,14.6 -8.1,-2.4 -18.8,-7.5 -28.2,-18.4 z"\n')
    gv.f.write('         class="st0"\n')
    gv.f.write('         style="fill:#1c76bc;fill-opacity:1"\n')
    gv.f.write('         inkscape:export-xdpi="201.7"\n')
    gv.f.write('         inkscape:export-ydpi="201.7" />\n')
    gv.f.write('    </g>\n')
    gv.f.write('  </g>\n')
    gv.f.write('</svg>\n')
    gv.f.write('</div>\n')
    gv.f.write('</div>\n')
