/*
 * Copyright (C) 2003, 2004 Bjrn-Ove Heimsund
 * 
 * This file is part of NNI.
 * 
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published by the
 * Free Software Foundation; either version 2.1 of the License, or (at your
 * option) any later version.
 * 
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License
 * for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include <jni.h>
#include <stdlib.h>
#include <string.h>
#include <f2c.h>
#include <clapack.h>

#include "nni_LAPACK.h"

/*
 * Definition missing in clapack.h
 */
double dlamch_(char *);

JNIEXPORT jdouble JNICALL Java_nni_LAPACK_lamch(JNIEnv *env, jclass clazz, jcharArray cmach) {
  int i_loc;
  jchar* cmach_l;
  char* cmach_ll;
  jsize cmach_ls;
  double value;

  cmach_l = (*env)->GetPrimitiveArrayCritical(env, cmach, NULL);
  cmach_ls = (*env)->GetArrayLength(env, cmach);
  cmach_ll = malloc(sizeof(char)*cmach_ls);
  for (i_loc=0; i_loc<cmach_ls; ++i_loc) cmach_ll[i_loc] = cmach_l[i_loc];

  value = dlamch_(cmach_ll);

  free(cmach_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, cmach, cmach_l, 0);

  return value;
}

JNIEXPORT jint JNICALL Java_nni_LAPACK_laenv
(JNIEnv *env, jclass clazz, jint ispec, jcharArray name, jcharArray opts, jint n1, jint n2, jint n3, jint n4) {
  int i_loc;
  jchar* name_l;
  char* name_ll;
  jsize name_ls;
  jchar* opts_l;
  char* opts_ll;
  jsize opts_ls;
  integer IS, N1, N2, N3, N4, value;
  name_l = (*env)->GetPrimitiveArrayCritical(env, name, NULL);
  name_ls = (*env)->GetArrayLength(env, name);
  name_ll = malloc(sizeof(char)*name_ls);
  for (i_loc=0; i_loc<name_ls; ++i_loc) name_ll[i_loc] = name_l[i_loc];
  opts_l = (*env)->GetPrimitiveArrayCritical(env, opts, NULL);
  opts_ls = (*env)->GetArrayLength(env, opts);
  opts_ll = malloc(sizeof(char)*opts_ls);
  for (i_loc=0; i_loc<opts_ls; ++i_loc) opts_ll[i_loc] = opts_l[i_loc];

  IS = (integer) ispec;
  N1 = (integer) n1;
  N2 = (integer) n2;
  N3 = (integer) n3;
  N4 = (integer) n4;

  value = ilaenv_(&IS, name_ll, opts_ll, &N1, &N2, &N3, &N4, (short) name_ls, (short) opts_ls);

  for (i_loc=0; i_loc<name_ls; ++i_loc) name_l[i_loc] = name_ll[i_loc];
  free(name_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, name, name_l, 0);
  for (i_loc=0; i_loc<opts_ls; ++i_loc) opts_l[i_loc] = opts_ll[i_loc];
  free(opts_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, opts, opts_l, 0);

  return (jint) value;
}

JNIEXPORT void JNICALL Java_nni_LAPACK_bdsdc
(JNIEnv *env, jclass clazz, jcharArray uplo, jcharArray compq, jintArray n, jdoubleArray d, jdoubleArray e, jdoubleArray u, jintArray ldu, jdoubleArray vt, jintArray ldvt, jdoubleArray q, jintArray iq, jdoubleArray work, jintArray iwork, jintArray info) {
  int i_loc;
  jchar* uplo_l;
  char* uplo_ll;
  jsize uplo_ls;
  jchar* compq_l;
  char* compq_ll;
  jsize compq_ls;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jdouble* d_ll;
  jdouble* e_ll;
  jdouble* u_ll;
  jint* ldu_l;
  integer* ldu_ll;
  jsize ldu_ls;
  jdouble* vt_ll;
  jint* ldvt_l;
  integer* ldvt_ll;
  jsize ldvt_ls;
  jdouble* q_ll;
  jint* iq_l;
  integer* iq_ll;
  jsize iq_ls;
  jdouble* work_ll;
  jint* iwork_l;
  integer* iwork_ll;
  jsize iwork_ls;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  uplo_l = (*env)->GetPrimitiveArrayCritical(env, uplo, NULL);
  uplo_ls = (*env)->GetArrayLength(env, uplo);
  uplo_ll = malloc(sizeof(char)*uplo_ls);
  for (i_loc=0; i_loc<uplo_ls; ++i_loc) uplo_ll[i_loc] = uplo_l[i_loc];
  compq_l = (*env)->GetPrimitiveArrayCritical(env, compq, NULL);
  compq_ls = (*env)->GetArrayLength(env, compq);
  compq_ll = malloc(sizeof(char)*compq_ls);
  for (i_loc=0; i_loc<compq_ls; ++i_loc) compq_ll[i_loc] = compq_l[i_loc];
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  d_ll = (*env)->GetPrimitiveArrayCritical(env, d, NULL);
  e_ll = (*env)->GetPrimitiveArrayCritical(env, e, NULL);
  u_ll = (*env)->GetPrimitiveArrayCritical(env, u, NULL);
  ldu_l = (*env)->GetPrimitiveArrayCritical(env, ldu, NULL);
  ldu_ls = (*env)->GetArrayLength(env, ldu);
  ldu_ll = malloc(sizeof(integer)*ldu_ls);
  for (i_loc=0; i_loc<ldu_ls; ++i_loc) ldu_ll[i_loc] = ldu_l[i_loc];
  vt_ll = (*env)->GetPrimitiveArrayCritical(env, vt, NULL);
  ldvt_l = (*env)->GetPrimitiveArrayCritical(env, ldvt, NULL);
  ldvt_ls = (*env)->GetArrayLength(env, ldvt);
  ldvt_ll = malloc(sizeof(integer)*ldvt_ls);
  for (i_loc=0; i_loc<ldvt_ls; ++i_loc) ldvt_ll[i_loc] = ldvt_l[i_loc];
  q_ll = (*env)->GetPrimitiveArrayCritical(env, q, NULL);
  iq_l = (*env)->GetPrimitiveArrayCritical(env, iq, NULL);
  iq_ls = (*env)->GetArrayLength(env, iq);
  iq_ll = malloc(sizeof(integer)*iq_ls);
  for (i_loc=0; i_loc<iq_ls; ++i_loc) iq_ll[i_loc] = iq_l[i_loc];
  work_ll = (*env)->GetPrimitiveArrayCritical(env, work, NULL);
  iwork_l = (*env)->GetPrimitiveArrayCritical(env, iwork, NULL);
  iwork_ls = (*env)->GetArrayLength(env, iwork);
  iwork_ll = malloc(sizeof(integer)*iwork_ls);
  for (i_loc=0; i_loc<iwork_ls; ++i_loc) iwork_ll[i_loc] = iwork_l[i_loc];
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dbdsdc_(uplo_ll, compq_ll, n_ll, d_ll, e_ll, u_ll, ldu_ll, vt_ll, ldvt_ll, q_ll, iq_ll, work_ll, iwork_ll, info_ll);

  for (i_loc=0; i_loc<uplo_ls; ++i_loc) uplo_l[i_loc] = uplo_ll[i_loc];
  free(uplo_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, uplo, uplo_l, 0);
  for (i_loc=0; i_loc<compq_ls; ++i_loc) compq_l[i_loc] = compq_ll[i_loc];
  free(compq_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, compq, compq_l, 0);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, d, d_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, e, e_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, u, u_ll, 0);
  for (i_loc=0; i_loc<ldu_ls; ++i_loc) ldu_l[i_loc] = ldu_ll[i_loc];
  free(ldu_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldu, ldu_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, vt, vt_ll, 0);
  for (i_loc=0; i_loc<ldvt_ls; ++i_loc) ldvt_l[i_loc] = ldvt_ll[i_loc];
  free(ldvt_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldvt, ldvt_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, q, q_ll, 0);
  for (i_loc=0; i_loc<iq_ls; ++i_loc) iq_l[i_loc] = iq_ll[i_loc];
  free(iq_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, iq, iq_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, work, work_ll, 0);
  for (i_loc=0; i_loc<iwork_ls; ++i_loc) iwork_l[i_loc] = iwork_ll[i_loc];
  free(iwork_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, iwork, iwork_l, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_bdsqr
(JNIEnv *env, jclass clazz, jcharArray uplo, jintArray n, jintArray ncvt, jintArray nru, jintArray ncc, jdoubleArray d, jdoubleArray e, jdoubleArray vt, jintArray ldvt, jdoubleArray u, jintArray ldu, jdoubleArray c, jintArray ldc, jdoubleArray work, jintArray info) {
  int i_loc;
  jchar* uplo_l;
  char* uplo_ll;
  jsize uplo_ls;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jint* ncvt_l;
  integer* ncvt_ll;
  jsize ncvt_ls;
  jint* nru_l;
  integer* nru_ll;
  jsize nru_ls;
  jint* ncc_l;
  integer* ncc_ll;
  jsize ncc_ls;
  jdouble* d_ll;
  jdouble* e_ll;
  jdouble* vt_ll;
  jint* ldvt_l;
  integer* ldvt_ll;
  jsize ldvt_ls;
  jdouble* u_ll;
  jint* ldu_l;
  integer* ldu_ll;
  jsize ldu_ls;
  jdouble* c_ll;
  jint* ldc_l;
  integer* ldc_ll;
  jsize ldc_ls;
  jdouble* work_ll;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  uplo_l = (*env)->GetPrimitiveArrayCritical(env, uplo, NULL);
  uplo_ls = (*env)->GetArrayLength(env, uplo);
  uplo_ll = malloc(sizeof(char)*uplo_ls);
  for (i_loc=0; i_loc<uplo_ls; ++i_loc) uplo_ll[i_loc] = uplo_l[i_loc];
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  ncvt_l = (*env)->GetPrimitiveArrayCritical(env, ncvt, NULL);
  ncvt_ls = (*env)->GetArrayLength(env, ncvt);
  ncvt_ll = malloc(sizeof(integer)*ncvt_ls);
  for (i_loc=0; i_loc<ncvt_ls; ++i_loc) ncvt_ll[i_loc] = ncvt_l[i_loc];
  nru_l = (*env)->GetPrimitiveArrayCritical(env, nru, NULL);
  nru_ls = (*env)->GetArrayLength(env, nru);
  nru_ll = malloc(sizeof(integer)*nru_ls);
  for (i_loc=0; i_loc<nru_ls; ++i_loc) nru_ll[i_loc] = nru_l[i_loc];
  ncc_l = (*env)->GetPrimitiveArrayCritical(env, ncc, NULL);
  ncc_ls = (*env)->GetArrayLength(env, ncc);
  ncc_ll = malloc(sizeof(integer)*ncc_ls);
  for (i_loc=0; i_loc<ncc_ls; ++i_loc) ncc_ll[i_loc] = ncc_l[i_loc];
  d_ll = (*env)->GetPrimitiveArrayCritical(env, d, NULL);
  e_ll = (*env)->GetPrimitiveArrayCritical(env, e, NULL);
  vt_ll = (*env)->GetPrimitiveArrayCritical(env, vt, NULL);
  ldvt_l = (*env)->GetPrimitiveArrayCritical(env, ldvt, NULL);
  ldvt_ls = (*env)->GetArrayLength(env, ldvt);
  ldvt_ll = malloc(sizeof(integer)*ldvt_ls);
  for (i_loc=0; i_loc<ldvt_ls; ++i_loc) ldvt_ll[i_loc] = ldvt_l[i_loc];
  u_ll = (*env)->GetPrimitiveArrayCritical(env, u, NULL);
  ldu_l = (*env)->GetPrimitiveArrayCritical(env, ldu, NULL);
  ldu_ls = (*env)->GetArrayLength(env, ldu);
  ldu_ll = malloc(sizeof(integer)*ldu_ls);
  for (i_loc=0; i_loc<ldu_ls; ++i_loc) ldu_ll[i_loc] = ldu_l[i_loc];
  c_ll = (*env)->GetPrimitiveArrayCritical(env, c, NULL);
  ldc_l = (*env)->GetPrimitiveArrayCritical(env, ldc, NULL);
  ldc_ls = (*env)->GetArrayLength(env, ldc);
  ldc_ll = malloc(sizeof(integer)*ldc_ls);
  for (i_loc=0; i_loc<ldc_ls; ++i_loc) ldc_ll[i_loc] = ldc_l[i_loc];
  work_ll = (*env)->GetPrimitiveArrayCritical(env, work, NULL);
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dbdsqr_(uplo_ll, n_ll, ncvt_ll, nru_ll, ncc_ll, d_ll, e_ll, vt_ll, ldvt_ll, u_ll, ldu_ll, c_ll, ldc_ll, work_ll, info_ll);

  for (i_loc=0; i_loc<uplo_ls; ++i_loc) uplo_l[i_loc] = uplo_ll[i_loc];
  free(uplo_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, uplo, uplo_l, 0);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  for (i_loc=0; i_loc<ncvt_ls; ++i_loc) ncvt_l[i_loc] = ncvt_ll[i_loc];
  free(ncvt_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ncvt, ncvt_l, 0);
  for (i_loc=0; i_loc<nru_ls; ++i_loc) nru_l[i_loc] = nru_ll[i_loc];
  free(nru_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, nru, nru_l, 0);
  for (i_loc=0; i_loc<ncc_ls; ++i_loc) ncc_l[i_loc] = ncc_ll[i_loc];
  free(ncc_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ncc, ncc_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, d, d_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, e, e_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, vt, vt_ll, 0);
  for (i_loc=0; i_loc<ldvt_ls; ++i_loc) ldvt_l[i_loc] = ldvt_ll[i_loc];
  free(ldvt_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldvt, ldvt_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, u, u_ll, 0);
  for (i_loc=0; i_loc<ldu_ls; ++i_loc) ldu_l[i_loc] = ldu_ll[i_loc];
  free(ldu_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldu, ldu_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, c, c_ll, 0);
  for (i_loc=0; i_loc<ldc_ls; ++i_loc) ldc_l[i_loc] = ldc_ll[i_loc];
  free(ldc_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldc, ldc_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, work, work_ll, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_disna
(JNIEnv *env, jclass clazz, jcharArray job, jintArray m, jintArray n, jdoubleArray d, jdoubleArray sep, jintArray info) {
  int i_loc;
  jchar* job_l;
  char* job_ll;
  jsize job_ls;
  jint* m_l;
  integer* m_ll;
  jsize m_ls;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jdouble* d_ll;
  jdouble* sep_ll;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  job_l = (*env)->GetPrimitiveArrayCritical(env, job, NULL);
  job_ls = (*env)->GetArrayLength(env, job);
  job_ll = malloc(sizeof(char)*job_ls);
  for (i_loc=0; i_loc<job_ls; ++i_loc) job_ll[i_loc] = job_l[i_loc];
  m_l = (*env)->GetPrimitiveArrayCritical(env, m, NULL);
  m_ls = (*env)->GetArrayLength(env, m);
  m_ll = malloc(sizeof(integer)*m_ls);
  for (i_loc=0; i_loc<m_ls; ++i_loc) m_ll[i_loc] = m_l[i_loc];
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  d_ll = (*env)->GetPrimitiveArrayCritical(env, d, NULL);
  sep_ll = (*env)->GetPrimitiveArrayCritical(env, sep, NULL);
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  ddisna_(job_ll, m_ll, n_ll, d_ll, sep_ll, info_ll);

  for (i_loc=0; i_loc<job_ls; ++i_loc) job_l[i_loc] = job_ll[i_loc];
  free(job_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, job, job_l, 0);
  for (i_loc=0; i_loc<m_ls; ++i_loc) m_l[i_loc] = m_ll[i_loc];
  free(m_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, m, m_l, 0);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, d, d_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, sep, sep_ll, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_gbbrd
(JNIEnv *env, jclass clazz, jcharArray vect, jintArray m, jintArray n, jintArray ncc, jintArray kl, jintArray ku, jdoubleArray ab, jintArray ldab, jdoubleArray d, jdoubleArray e, jdoubleArray q, jintArray ldq, jdoubleArray pt, jintArray ldpt, jdoubleArray c, jintArray ldc, jdoubleArray work, jintArray info) {
  int i_loc;
  jchar* vect_l;
  char* vect_ll;
  jsize vect_ls;
  jint* m_l;
  integer* m_ll;
  jsize m_ls;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jint* ncc_l;
  integer* ncc_ll;
  jsize ncc_ls;
  jint* kl_l;
  integer* kl_ll;
  jsize kl_ls;
  jint* ku_l;
  integer* ku_ll;
  jsize ku_ls;
  jdouble* ab_ll;
  jint* ldab_l;
  integer* ldab_ll;
  jsize ldab_ls;
  jdouble* d_ll;
  jdouble* e_ll;
  jdouble* q_ll;
  jint* ldq_l;
  integer* ldq_ll;
  jsize ldq_ls;
  jdouble* pt_ll;
  jint* ldpt_l;
  integer* ldpt_ll;
  jsize ldpt_ls;
  jdouble* c_ll;
  jint* ldc_l;
  integer* ldc_ll;
  jsize ldc_ls;
  jdouble* work_ll;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  vect_l = (*env)->GetPrimitiveArrayCritical(env, vect, NULL);
  vect_ls = (*env)->GetArrayLength(env, vect);
  vect_ll = malloc(sizeof(char)*vect_ls);
  for (i_loc=0; i_loc<vect_ls; ++i_loc) vect_ll[i_loc] = vect_l[i_loc];
  m_l = (*env)->GetPrimitiveArrayCritical(env, m, NULL);
  m_ls = (*env)->GetArrayLength(env, m);
  m_ll = malloc(sizeof(integer)*m_ls);
  for (i_loc=0; i_loc<m_ls; ++i_loc) m_ll[i_loc] = m_l[i_loc];
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  ncc_l = (*env)->GetPrimitiveArrayCritical(env, ncc, NULL);
  ncc_ls = (*env)->GetArrayLength(env, ncc);
  ncc_ll = malloc(sizeof(integer)*ncc_ls);
  for (i_loc=0; i_loc<ncc_ls; ++i_loc) ncc_ll[i_loc] = ncc_l[i_loc];
  kl_l = (*env)->GetPrimitiveArrayCritical(env, kl, NULL);
  kl_ls = (*env)->GetArrayLength(env, kl);
  kl_ll = malloc(sizeof(integer)*kl_ls);
  for (i_loc=0; i_loc<kl_ls; ++i_loc) kl_ll[i_loc] = kl_l[i_loc];
  ku_l = (*env)->GetPrimitiveArrayCritical(env, ku, NULL);
  ku_ls = (*env)->GetArrayLength(env, ku);
  ku_ll = malloc(sizeof(integer)*ku_ls);
  for (i_loc=0; i_loc<ku_ls; ++i_loc) ku_ll[i_loc] = ku_l[i_loc];
  ab_ll = (*env)->GetPrimitiveArrayCritical(env, ab, NULL);
  ldab_l = (*env)->GetPrimitiveArrayCritical(env, ldab, NULL);
  ldab_ls = (*env)->GetArrayLength(env, ldab);
  ldab_ll = malloc(sizeof(integer)*ldab_ls);
  for (i_loc=0; i_loc<ldab_ls; ++i_loc) ldab_ll[i_loc] = ldab_l[i_loc];
  d_ll = (*env)->GetPrimitiveArrayCritical(env, d, NULL);
  e_ll = (*env)->GetPrimitiveArrayCritical(env, e, NULL);
  q_ll = (*env)->GetPrimitiveArrayCritical(env, q, NULL);
  ldq_l = (*env)->GetPrimitiveArrayCritical(env, ldq, NULL);
  ldq_ls = (*env)->GetArrayLength(env, ldq);
  ldq_ll = malloc(sizeof(integer)*ldq_ls);
  for (i_loc=0; i_loc<ldq_ls; ++i_loc) ldq_ll[i_loc] = ldq_l[i_loc];
  pt_ll = (*env)->GetPrimitiveArrayCritical(env, pt, NULL);
  ldpt_l = (*env)->GetPrimitiveArrayCritical(env, ldpt, NULL);
  ldpt_ls = (*env)->GetArrayLength(env, ldpt);
  ldpt_ll = malloc(sizeof(integer)*ldpt_ls);
  for (i_loc=0; i_loc<ldpt_ls; ++i_loc) ldpt_ll[i_loc] = ldpt_l[i_loc];
  c_ll = (*env)->GetPrimitiveArrayCritical(env, c, NULL);
  ldc_l = (*env)->GetPrimitiveArrayCritical(env, ldc, NULL);
  ldc_ls = (*env)->GetArrayLength(env, ldc);
  ldc_ll = malloc(sizeof(integer)*ldc_ls);
  for (i_loc=0; i_loc<ldc_ls; ++i_loc) ldc_ll[i_loc] = ldc_l[i_loc];
  work_ll = (*env)->GetPrimitiveArrayCritical(env, work, NULL);
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dgbbrd_(vect_ll, m_ll, n_ll, ncc_ll, kl_ll, ku_ll, ab_ll, ldab_ll, d_ll, e_ll, q_ll, ldq_ll, pt_ll, ldpt_ll, c_ll, ldc_ll, work_ll, info_ll);

  for (i_loc=0; i_loc<vect_ls; ++i_loc) vect_l[i_loc] = vect_ll[i_loc];
  free(vect_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, vect, vect_l, 0);
  for (i_loc=0; i_loc<m_ls; ++i_loc) m_l[i_loc] = m_ll[i_loc];
  free(m_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, m, m_l, 0);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  for (i_loc=0; i_loc<ncc_ls; ++i_loc) ncc_l[i_loc] = ncc_ll[i_loc];
  free(ncc_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ncc, ncc_l, 0);
  for (i_loc=0; i_loc<kl_ls; ++i_loc) kl_l[i_loc] = kl_ll[i_loc];
  free(kl_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, kl, kl_l, 0);
  for (i_loc=0; i_loc<ku_ls; ++i_loc) ku_l[i_loc] = ku_ll[i_loc];
  free(ku_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ku, ku_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, ab, ab_ll, 0);
  for (i_loc=0; i_loc<ldab_ls; ++i_loc) ldab_l[i_loc] = ldab_ll[i_loc];
  free(ldab_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldab, ldab_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, d, d_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, e, e_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, q, q_ll, 0);
  for (i_loc=0; i_loc<ldq_ls; ++i_loc) ldq_l[i_loc] = ldq_ll[i_loc];
  free(ldq_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldq, ldq_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, pt, pt_ll, 0);
  for (i_loc=0; i_loc<ldpt_ls; ++i_loc) ldpt_l[i_loc] = ldpt_ll[i_loc];
  free(ldpt_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldpt, ldpt_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, c, c_ll, 0);
  for (i_loc=0; i_loc<ldc_ls; ++i_loc) ldc_l[i_loc] = ldc_ll[i_loc];
  free(ldc_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldc, ldc_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, work, work_ll, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_gbcon
(JNIEnv *env, jclass clazz, jcharArray norm, jintArray n, jintArray kl, jintArray ku, jdoubleArray ab, jintArray ldab, jintArray ipiv, jdoubleArray anorm, jdoubleArray rcond, jdoubleArray work, jintArray iwork, jintArray info) {
  int i_loc;
  jchar* norm_l;
  char* norm_ll;
  jsize norm_ls;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jint* kl_l;
  integer* kl_ll;
  jsize kl_ls;
  jint* ku_l;
  integer* ku_ll;
  jsize ku_ls;
  jdouble* ab_ll;
  jint* ldab_l;
  integer* ldab_ll;
  jsize ldab_ls;
  jint* ipiv_l;
  integer* ipiv_ll;
  jsize ipiv_ls;
  jdouble* anorm_ll;
  jdouble* rcond_ll;
  jdouble* work_ll;
  jint* iwork_l;
  integer* iwork_ll;
  jsize iwork_ls;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  norm_l = (*env)->GetPrimitiveArrayCritical(env, norm, NULL);
  norm_ls = (*env)->GetArrayLength(env, norm);
  norm_ll = malloc(sizeof(char)*norm_ls);
  for (i_loc=0; i_loc<norm_ls; ++i_loc) norm_ll[i_loc] = norm_l[i_loc];
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  kl_l = (*env)->GetPrimitiveArrayCritical(env, kl, NULL);
  kl_ls = (*env)->GetArrayLength(env, kl);
  kl_ll = malloc(sizeof(integer)*kl_ls);
  for (i_loc=0; i_loc<kl_ls; ++i_loc) kl_ll[i_loc] = kl_l[i_loc];
  ku_l = (*env)->GetPrimitiveArrayCritical(env, ku, NULL);
  ku_ls = (*env)->GetArrayLength(env, ku);
  ku_ll = malloc(sizeof(integer)*ku_ls);
  for (i_loc=0; i_loc<ku_ls; ++i_loc) ku_ll[i_loc] = ku_l[i_loc];
  ab_ll = (*env)->GetPrimitiveArrayCritical(env, ab, NULL);
  ldab_l = (*env)->GetPrimitiveArrayCritical(env, ldab, NULL);
  ldab_ls = (*env)->GetArrayLength(env, ldab);
  ldab_ll = malloc(sizeof(integer)*ldab_ls);
  for (i_loc=0; i_loc<ldab_ls; ++i_loc) ldab_ll[i_loc] = ldab_l[i_loc];
  ipiv_l = (*env)->GetPrimitiveArrayCritical(env, ipiv, NULL);
  ipiv_ls = (*env)->GetArrayLength(env, ipiv);
  ipiv_ll = malloc(sizeof(integer)*ipiv_ls);
  for (i_loc=0; i_loc<ipiv_ls; ++i_loc) ipiv_ll[i_loc] = ipiv_l[i_loc];
  anorm_ll = (*env)->GetPrimitiveArrayCritical(env, anorm, NULL);
  rcond_ll = (*env)->GetPrimitiveArrayCritical(env, rcond, NULL);
  work_ll = (*env)->GetPrimitiveArrayCritical(env, work, NULL);
  iwork_l = (*env)->GetPrimitiveArrayCritical(env, iwork, NULL);
  iwork_ls = (*env)->GetArrayLength(env, iwork);
  iwork_ll = malloc(sizeof(integer)*iwork_ls);
  for (i_loc=0; i_loc<iwork_ls; ++i_loc) iwork_ll[i_loc] = iwork_l[i_loc];
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dgbcon_(norm_ll, n_ll, kl_ll, ku_ll, ab_ll, ldab_ll, ipiv_ll, anorm_ll, rcond_ll, work_ll, iwork_ll, info_ll);

  for (i_loc=0; i_loc<norm_ls; ++i_loc) norm_l[i_loc] = norm_ll[i_loc];
  free(norm_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, norm, norm_l, 0);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  for (i_loc=0; i_loc<kl_ls; ++i_loc) kl_l[i_loc] = kl_ll[i_loc];
  free(kl_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, kl, kl_l, 0);
  for (i_loc=0; i_loc<ku_ls; ++i_loc) ku_l[i_loc] = ku_ll[i_loc];
  free(ku_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ku, ku_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, ab, ab_ll, 0);
  for (i_loc=0; i_loc<ldab_ls; ++i_loc) ldab_l[i_loc] = ldab_ll[i_loc];
  free(ldab_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldab, ldab_l, 0);
  for (i_loc=0; i_loc<ipiv_ls; ++i_loc) ipiv_l[i_loc] = ipiv_ll[i_loc];
  free(ipiv_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ipiv, ipiv_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, anorm, anorm_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, rcond, rcond_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, work, work_ll, 0);
  for (i_loc=0; i_loc<iwork_ls; ++i_loc) iwork_l[i_loc] = iwork_ll[i_loc];
  free(iwork_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, iwork, iwork_l, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_gbequ
(JNIEnv *env, jclass clazz, jintArray m, jintArray n, jintArray kl, jintArray ku, jdoubleArray ab, jintArray ldab, jdoubleArray r, jdoubleArray c, jdoubleArray rowcnd, jdoubleArray colcnd, jdoubleArray amax, jintArray info) {
  int i_loc;
  jint* m_l;
  integer* m_ll;
  jsize m_ls;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jint* kl_l;
  integer* kl_ll;
  jsize kl_ls;
  jint* ku_l;
  integer* ku_ll;
  jsize ku_ls;
  jdouble* ab_ll;
  jint* ldab_l;
  integer* ldab_ll;
  jsize ldab_ls;
  jdouble* r_ll;
  jdouble* c_ll;
  jdouble* rowcnd_ll;
  jdouble* colcnd_ll;
  jdouble* amax_ll;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  m_l = (*env)->GetPrimitiveArrayCritical(env, m, NULL);
  m_ls = (*env)->GetArrayLength(env, m);
  m_ll = malloc(sizeof(integer)*m_ls);
  for (i_loc=0; i_loc<m_ls; ++i_loc) m_ll[i_loc] = m_l[i_loc];
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  kl_l = (*env)->GetPrimitiveArrayCritical(env, kl, NULL);
  kl_ls = (*env)->GetArrayLength(env, kl);
  kl_ll = malloc(sizeof(integer)*kl_ls);
  for (i_loc=0; i_loc<kl_ls; ++i_loc) kl_ll[i_loc] = kl_l[i_loc];
  ku_l = (*env)->GetPrimitiveArrayCritical(env, ku, NULL);
  ku_ls = (*env)->GetArrayLength(env, ku);
  ku_ll = malloc(sizeof(integer)*ku_ls);
  for (i_loc=0; i_loc<ku_ls; ++i_loc) ku_ll[i_loc] = ku_l[i_loc];
  ab_ll = (*env)->GetPrimitiveArrayCritical(env, ab, NULL);
  ldab_l = (*env)->GetPrimitiveArrayCritical(env, ldab, NULL);
  ldab_ls = (*env)->GetArrayLength(env, ldab);
  ldab_ll = malloc(sizeof(integer)*ldab_ls);
  for (i_loc=0; i_loc<ldab_ls; ++i_loc) ldab_ll[i_loc] = ldab_l[i_loc];
  r_ll = (*env)->GetPrimitiveArrayCritical(env, r, NULL);
  c_ll = (*env)->GetPrimitiveArrayCritical(env, c, NULL);
  rowcnd_ll = (*env)->GetPrimitiveArrayCritical(env, rowcnd, NULL);
  colcnd_ll = (*env)->GetPrimitiveArrayCritical(env, colcnd, NULL);
  amax_ll = (*env)->GetPrimitiveArrayCritical(env, amax, NULL);
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dgbequ_(m_ll, n_ll, kl_ll, ku_ll, ab_ll, ldab_ll, r_ll, c_ll, rowcnd_ll, colcnd_ll, amax_ll, info_ll);

  for (i_loc=0; i_loc<m_ls; ++i_loc) m_l[i_loc] = m_ll[i_loc];
  free(m_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, m, m_l, 0);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  for (i_loc=0; i_loc<kl_ls; ++i_loc) kl_l[i_loc] = kl_ll[i_loc];
  free(kl_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, kl, kl_l, 0);
  for (i_loc=0; i_loc<ku_ls; ++i_loc) ku_l[i_loc] = ku_ll[i_loc];
  free(ku_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ku, ku_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, ab, ab_ll, 0);
  for (i_loc=0; i_loc<ldab_ls; ++i_loc) ldab_l[i_loc] = ldab_ll[i_loc];
  free(ldab_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldab, ldab_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, r, r_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, c, c_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, rowcnd, rowcnd_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, colcnd, colcnd_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, amax, amax_ll, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_gbrfs
(JNIEnv *env, jclass clazz, jcharArray trans, jintArray n, jintArray kl, jintArray ku, jintArray nrhs, jdoubleArray ab, jintArray ldab, jdoubleArray afb, jintArray ldafb, jintArray ipiv, jdoubleArray b, jintArray ldb, jdoubleArray x, jintArray ldx, jdoubleArray ferr, jdoubleArray berr, jdoubleArray work, jintArray iwork, jintArray info) {
  int i_loc;
  jchar* trans_l;
  char* trans_ll;
  jsize trans_ls;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jint* kl_l;
  integer* kl_ll;
  jsize kl_ls;
  jint* ku_l;
  integer* ku_ll;
  jsize ku_ls;
  jint* nrhs_l;
  integer* nrhs_ll;
  jsize nrhs_ls;
  jdouble* ab_ll;
  jint* ldab_l;
  integer* ldab_ll;
  jsize ldab_ls;
  jdouble* afb_ll;
  jint* ldafb_l;
  integer* ldafb_ll;
  jsize ldafb_ls;
  jint* ipiv_l;
  integer* ipiv_ll;
  jsize ipiv_ls;
  jdouble* b_ll;
  jint* ldb_l;
  integer* ldb_ll;
  jsize ldb_ls;
  jdouble* x_ll;
  jint* ldx_l;
  integer* ldx_ll;
  jsize ldx_ls;
  jdouble* ferr_ll;
  jdouble* berr_ll;
  jdouble* work_ll;
  jint* iwork_l;
  integer* iwork_ll;
  jsize iwork_ls;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  trans_l = (*env)->GetPrimitiveArrayCritical(env, trans, NULL);
  trans_ls = (*env)->GetArrayLength(env, trans);
  trans_ll = malloc(sizeof(char)*trans_ls);
  for (i_loc=0; i_loc<trans_ls; ++i_loc) trans_ll[i_loc] = trans_l[i_loc];
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  kl_l = (*env)->GetPrimitiveArrayCritical(env, kl, NULL);
  kl_ls = (*env)->GetArrayLength(env, kl);
  kl_ll = malloc(sizeof(integer)*kl_ls);
  for (i_loc=0; i_loc<kl_ls; ++i_loc) kl_ll[i_loc] = kl_l[i_loc];
  ku_l = (*env)->GetPrimitiveArrayCritical(env, ku, NULL);
  ku_ls = (*env)->GetArrayLength(env, ku);
  ku_ll = malloc(sizeof(integer)*ku_ls);
  for (i_loc=0; i_loc<ku_ls; ++i_loc) ku_ll[i_loc] = ku_l[i_loc];
  nrhs_l = (*env)->GetPrimitiveArrayCritical(env, nrhs, NULL);
  nrhs_ls = (*env)->GetArrayLength(env, nrhs);
  nrhs_ll = malloc(sizeof(integer)*nrhs_ls);
  for (i_loc=0; i_loc<nrhs_ls; ++i_loc) nrhs_ll[i_loc] = nrhs_l[i_loc];
  ab_ll = (*env)->GetPrimitiveArrayCritical(env, ab, NULL);
  ldab_l = (*env)->GetPrimitiveArrayCritical(env, ldab, NULL);
  ldab_ls = (*env)->GetArrayLength(env, ldab);
  ldab_ll = malloc(sizeof(integer)*ldab_ls);
  for (i_loc=0; i_loc<ldab_ls; ++i_loc) ldab_ll[i_loc] = ldab_l[i_loc];
  afb_ll = (*env)->GetPrimitiveArrayCritical(env, afb, NULL);
  ldafb_l = (*env)->GetPrimitiveArrayCritical(env, ldafb, NULL);
  ldafb_ls = (*env)->GetArrayLength(env, ldafb);
  ldafb_ll = malloc(sizeof(integer)*ldafb_ls);
  for (i_loc=0; i_loc<ldafb_ls; ++i_loc) ldafb_ll[i_loc] = ldafb_l[i_loc];
  ipiv_l = (*env)->GetPrimitiveArrayCritical(env, ipiv, NULL);
  ipiv_ls = (*env)->GetArrayLength(env, ipiv);
  ipiv_ll = malloc(sizeof(integer)*ipiv_ls);
  for (i_loc=0; i_loc<ipiv_ls; ++i_loc) ipiv_ll[i_loc] = ipiv_l[i_loc];
  b_ll = (*env)->GetPrimitiveArrayCritical(env, b, NULL);
  ldb_l = (*env)->GetPrimitiveArrayCritical(env, ldb, NULL);
  ldb_ls = (*env)->GetArrayLength(env, ldb);
  ldb_ll = malloc(sizeof(integer)*ldb_ls);
  for (i_loc=0; i_loc<ldb_ls; ++i_loc) ldb_ll[i_loc] = ldb_l[i_loc];
  x_ll = (*env)->GetPrimitiveArrayCritical(env, x, NULL);
  ldx_l = (*env)->GetPrimitiveArrayCritical(env, ldx, NULL);
  ldx_ls = (*env)->GetArrayLength(env, ldx);
  ldx_ll = malloc(sizeof(integer)*ldx_ls);
  for (i_loc=0; i_loc<ldx_ls; ++i_loc) ldx_ll[i_loc] = ldx_l[i_loc];
  ferr_ll = (*env)->GetPrimitiveArrayCritical(env, ferr, NULL);
  berr_ll = (*env)->GetPrimitiveArrayCritical(env, berr, NULL);
  work_ll = (*env)->GetPrimitiveArrayCritical(env, work, NULL);
  iwork_l = (*env)->GetPrimitiveArrayCritical(env, iwork, NULL);
  iwork_ls = (*env)->GetArrayLength(env, iwork);
  iwork_ll = malloc(sizeof(integer)*iwork_ls);
  for (i_loc=0; i_loc<iwork_ls; ++i_loc) iwork_ll[i_loc] = iwork_l[i_loc];
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dgbrfs_(trans_ll, n_ll, kl_ll, ku_ll, nrhs_ll, ab_ll, ldab_ll, afb_ll, ldafb_ll, ipiv_ll, b_ll, ldb_ll, x_ll, ldx_ll, ferr_ll, berr_ll, work_ll, iwork_ll, info_ll);

  for (i_loc=0; i_loc<trans_ls; ++i_loc) trans_l[i_loc] = trans_ll[i_loc];
  free(trans_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, trans, trans_l, 0);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  for (i_loc=0; i_loc<kl_ls; ++i_loc) kl_l[i_loc] = kl_ll[i_loc];
  free(kl_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, kl, kl_l, 0);
  for (i_loc=0; i_loc<ku_ls; ++i_loc) ku_l[i_loc] = ku_ll[i_loc];
  free(ku_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ku, ku_l, 0);
  for (i_loc=0; i_loc<nrhs_ls; ++i_loc) nrhs_l[i_loc] = nrhs_ll[i_loc];
  free(nrhs_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, nrhs, nrhs_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, ab, ab_ll, 0);
  for (i_loc=0; i_loc<ldab_ls; ++i_loc) ldab_l[i_loc] = ldab_ll[i_loc];
  free(ldab_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldab, ldab_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, afb, afb_ll, 0);
  for (i_loc=0; i_loc<ldafb_ls; ++i_loc) ldafb_l[i_loc] = ldafb_ll[i_loc];
  free(ldafb_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldafb, ldafb_l, 0);
  for (i_loc=0; i_loc<ipiv_ls; ++i_loc) ipiv_l[i_loc] = ipiv_ll[i_loc];
  free(ipiv_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ipiv, ipiv_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, b, b_ll, 0);
  for (i_loc=0; i_loc<ldb_ls; ++i_loc) ldb_l[i_loc] = ldb_ll[i_loc];
  free(ldb_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldb, ldb_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, x, x_ll, 0);
  for (i_loc=0; i_loc<ldx_ls; ++i_loc) ldx_l[i_loc] = ldx_ll[i_loc];
  free(ldx_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldx, ldx_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, ferr, ferr_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, berr, berr_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, work, work_ll, 0);
  for (i_loc=0; i_loc<iwork_ls; ++i_loc) iwork_l[i_loc] = iwork_ll[i_loc];
  free(iwork_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, iwork, iwork_l, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_gbsv
(JNIEnv *env, jclass clazz, jintArray n, jintArray kl, jintArray ku, jintArray nrhs, jdoubleArray ab, jintArray ldab, jintArray ipiv, jdoubleArray b, jintArray ldb, jintArray info) {
  int i_loc;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jint* kl_l;
  integer* kl_ll;
  jsize kl_ls;
  jint* ku_l;
  integer* ku_ll;
  jsize ku_ls;
  jint* nrhs_l;
  integer* nrhs_ll;
  jsize nrhs_ls;
  jdouble* ab_ll;
  jint* ldab_l;
  integer* ldab_ll;
  jsize ldab_ls;
  jint* ipiv_l;
  integer* ipiv_ll;
  jsize ipiv_ls;
  jdouble* b_ll;
  jint* ldb_l;
  integer* ldb_ll;
  jsize ldb_ls;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  kl_l = (*env)->GetPrimitiveArrayCritical(env, kl, NULL);
  kl_ls = (*env)->GetArrayLength(env, kl);
  kl_ll = malloc(sizeof(integer)*kl_ls);
  for (i_loc=0; i_loc<kl_ls; ++i_loc) kl_ll[i_loc] = kl_l[i_loc];
  ku_l = (*env)->GetPrimitiveArrayCritical(env, ku, NULL);
  ku_ls = (*env)->GetArrayLength(env, ku);
  ku_ll = malloc(sizeof(integer)*ku_ls);
  for (i_loc=0; i_loc<ku_ls; ++i_loc) ku_ll[i_loc] = ku_l[i_loc];
  nrhs_l = (*env)->GetPrimitiveArrayCritical(env, nrhs, NULL);
  nrhs_ls = (*env)->GetArrayLength(env, nrhs);
  nrhs_ll = malloc(sizeof(integer)*nrhs_ls);
  for (i_loc=0; i_loc<nrhs_ls; ++i_loc) nrhs_ll[i_loc] = nrhs_l[i_loc];
  ab_ll = (*env)->GetPrimitiveArrayCritical(env, ab, NULL);
  ldab_l = (*env)->GetPrimitiveArrayCritical(env, ldab, NULL);
  ldab_ls = (*env)->GetArrayLength(env, ldab);
  ldab_ll = malloc(sizeof(integer)*ldab_ls);
  for (i_loc=0; i_loc<ldab_ls; ++i_loc) ldab_ll[i_loc] = ldab_l[i_loc];
  ipiv_l = (*env)->GetPrimitiveArrayCritical(env, ipiv, NULL);
  ipiv_ls = (*env)->GetArrayLength(env, ipiv);
  ipiv_ll = malloc(sizeof(integer)*ipiv_ls);
  for (i_loc=0; i_loc<ipiv_ls; ++i_loc) ipiv_ll[i_loc] = ipiv_l[i_loc];
  b_ll = (*env)->GetPrimitiveArrayCritical(env, b, NULL);
  ldb_l = (*env)->GetPrimitiveArrayCritical(env, ldb, NULL);
  ldb_ls = (*env)->GetArrayLength(env, ldb);
  ldb_ll = malloc(sizeof(integer)*ldb_ls);
  for (i_loc=0; i_loc<ldb_ls; ++i_loc) ldb_ll[i_loc] = ldb_l[i_loc];
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dgbsv_(n_ll, kl_ll, ku_ll, nrhs_ll, ab_ll, ldab_ll, ipiv_ll, b_ll, ldb_ll, info_ll);

  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  for (i_loc=0; i_loc<kl_ls; ++i_loc) kl_l[i_loc] = kl_ll[i_loc];
  free(kl_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, kl, kl_l, 0);
  for (i_loc=0; i_loc<ku_ls; ++i_loc) ku_l[i_loc] = ku_ll[i_loc];
  free(ku_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ku, ku_l, 0);
  for (i_loc=0; i_loc<nrhs_ls; ++i_loc) nrhs_l[i_loc] = nrhs_ll[i_loc];
  free(nrhs_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, nrhs, nrhs_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, ab, ab_ll, 0);
  for (i_loc=0; i_loc<ldab_ls; ++i_loc) ldab_l[i_loc] = ldab_ll[i_loc];
  free(ldab_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldab, ldab_l, 0);
  for (i_loc=0; i_loc<ipiv_ls; ++i_loc) ipiv_l[i_loc] = ipiv_ll[i_loc];
  free(ipiv_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ipiv, ipiv_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, b, b_ll, 0);
  for (i_loc=0; i_loc<ldb_ls; ++i_loc) ldb_l[i_loc] = ldb_ll[i_loc];
  free(ldb_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldb, ldb_l, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_gbsvx
(JNIEnv *env, jclass clazz, jcharArray fact, jcharArray trans, jintArray n, jintArray kl, jintArray ku, jintArray nrhs, jdoubleArray ab, jintArray ldab, jdoubleArray afb, jintArray ldafb, jintArray ipiv, jcharArray equed, jdoubleArray r, jdoubleArray c, jdoubleArray b, jintArray ldb, jdoubleArray x, jintArray ldx, jdoubleArray rcond, jdoubleArray ferr, jdoubleArray berr, jdoubleArray work, jintArray iwork, jintArray info) {
  int i_loc;
  jchar* fact_l;
  char* fact_ll;
  jsize fact_ls;
  jchar* trans_l;
  char* trans_ll;
  jsize trans_ls;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jint* kl_l;
  integer* kl_ll;
  jsize kl_ls;
  jint* ku_l;
  integer* ku_ll;
  jsize ku_ls;
  jint* nrhs_l;
  integer* nrhs_ll;
  jsize nrhs_ls;
  jdouble* ab_ll;
  jint* ldab_l;
  integer* ldab_ll;
  jsize ldab_ls;
  jdouble* afb_ll;
  jint* ldafb_l;
  integer* ldafb_ll;
  jsize ldafb_ls;
  jint* ipiv_l;
  integer* ipiv_ll;
  jsize ipiv_ls;
  jchar* equed_l;
  char* equed_ll;
  jsize equed_ls;
  jdouble* r_ll;
  jdouble* c_ll;
  jdouble* b_ll;
  jint* ldb_l;
  integer* ldb_ll;
  jsize ldb_ls;
  jdouble* x_ll;
  jint* ldx_l;
  integer* ldx_ll;
  jsize ldx_ls;
  jdouble* rcond_ll;
  jdouble* ferr_ll;
  jdouble* berr_ll;
  jdouble* work_ll;
  jint* iwork_l;
  integer* iwork_ll;
  jsize iwork_ls;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  fact_l = (*env)->GetPrimitiveArrayCritical(env, fact, NULL);
  fact_ls = (*env)->GetArrayLength(env, fact);
  fact_ll = malloc(sizeof(char)*fact_ls);
  for (i_loc=0; i_loc<fact_ls; ++i_loc) fact_ll[i_loc] = fact_l[i_loc];
  trans_l = (*env)->GetPrimitiveArrayCritical(env, trans, NULL);
  trans_ls = (*env)->GetArrayLength(env, trans);
  trans_ll = malloc(sizeof(char)*trans_ls);
  for (i_loc=0; i_loc<trans_ls; ++i_loc) trans_ll[i_loc] = trans_l[i_loc];
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  kl_l = (*env)->GetPrimitiveArrayCritical(env, kl, NULL);
  kl_ls = (*env)->GetArrayLength(env, kl);
  kl_ll = malloc(sizeof(integer)*kl_ls);
  for (i_loc=0; i_loc<kl_ls; ++i_loc) kl_ll[i_loc] = kl_l[i_loc];
  ku_l = (*env)->GetPrimitiveArrayCritical(env, ku, NULL);
  ku_ls = (*env)->GetArrayLength(env, ku);
  ku_ll = malloc(sizeof(integer)*ku_ls);
  for (i_loc=0; i_loc<ku_ls; ++i_loc) ku_ll[i_loc] = ku_l[i_loc];
  nrhs_l = (*env)->GetPrimitiveArrayCritical(env, nrhs, NULL);
  nrhs_ls = (*env)->GetArrayLength(env, nrhs);
  nrhs_ll = malloc(sizeof(integer)*nrhs_ls);
  for (i_loc=0; i_loc<nrhs_ls; ++i_loc) nrhs_ll[i_loc] = nrhs_l[i_loc];
  ab_ll = (*env)->GetPrimitiveArrayCritical(env, ab, NULL);
  ldab_l = (*env)->GetPrimitiveArrayCritical(env, ldab, NULL);
  ldab_ls = (*env)->GetArrayLength(env, ldab);
  ldab_ll = malloc(sizeof(integer)*ldab_ls);
  for (i_loc=0; i_loc<ldab_ls; ++i_loc) ldab_ll[i_loc] = ldab_l[i_loc];
  afb_ll = (*env)->GetPrimitiveArrayCritical(env, afb, NULL);
  ldafb_l = (*env)->GetPrimitiveArrayCritical(env, ldafb, NULL);
  ldafb_ls = (*env)->GetArrayLength(env, ldafb);
  ldafb_ll = malloc(sizeof(integer)*ldafb_ls);
  for (i_loc=0; i_loc<ldafb_ls; ++i_loc) ldafb_ll[i_loc] = ldafb_l[i_loc];
  ipiv_l = (*env)->GetPrimitiveArrayCritical(env, ipiv, NULL);
  ipiv_ls = (*env)->GetArrayLength(env, ipiv);
  ipiv_ll = malloc(sizeof(integer)*ipiv_ls);
  for (i_loc=0; i_loc<ipiv_ls; ++i_loc) ipiv_ll[i_loc] = ipiv_l[i_loc];
  equed_l = (*env)->GetPrimitiveArrayCritical(env, equed, NULL);
  equed_ls = (*env)->GetArrayLength(env, equed);
  equed_ll = malloc(sizeof(char)*equed_ls);
  for (i_loc=0; i_loc<equed_ls; ++i_loc) equed_ll[i_loc] = equed_l[i_loc];
  r_ll = (*env)->GetPrimitiveArrayCritical(env, r, NULL);
  c_ll = (*env)->GetPrimitiveArrayCritical(env, c, NULL);
  b_ll = (*env)->GetPrimitiveArrayCritical(env, b, NULL);
  ldb_l = (*env)->GetPrimitiveArrayCritical(env, ldb, NULL);
  ldb_ls = (*env)->GetArrayLength(env, ldb);
  ldb_ll = malloc(sizeof(integer)*ldb_ls);
  for (i_loc=0; i_loc<ldb_ls; ++i_loc) ldb_ll[i_loc] = ldb_l[i_loc];
  x_ll = (*env)->GetPrimitiveArrayCritical(env, x, NULL);
  ldx_l = (*env)->GetPrimitiveArrayCritical(env, ldx, NULL);
  ldx_ls = (*env)->GetArrayLength(env, ldx);
  ldx_ll = malloc(sizeof(integer)*ldx_ls);
  for (i_loc=0; i_loc<ldx_ls; ++i_loc) ldx_ll[i_loc] = ldx_l[i_loc];
  rcond_ll = (*env)->GetPrimitiveArrayCritical(env, rcond, NULL);
  ferr_ll = (*env)->GetPrimitiveArrayCritical(env, ferr, NULL);
  berr_ll = (*env)->GetPrimitiveArrayCritical(env, berr, NULL);
  work_ll = (*env)->GetPrimitiveArrayCritical(env, work, NULL);
  iwork_l = (*env)->GetPrimitiveArrayCritical(env, iwork, NULL);
  iwork_ls = (*env)->GetArrayLength(env, iwork);
  iwork_ll = malloc(sizeof(integer)*iwork_ls);
  for (i_loc=0; i_loc<iwork_ls; ++i_loc) iwork_ll[i_loc] = iwork_l[i_loc];
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dgbsvx_(fact_ll, trans_ll, n_ll, kl_ll, ku_ll, nrhs_ll, ab_ll, ldab_ll, afb_ll, ldafb_ll, ipiv_ll, equed_ll, r_ll, c_ll, b_ll, ldb_ll, x_ll, ldx_ll, rcond_ll, ferr_ll, berr_ll, work_ll, iwork_ll, info_ll);

  for (i_loc=0; i_loc<fact_ls; ++i_loc) fact_l[i_loc] = fact_ll[i_loc];
  free(fact_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, fact, fact_l, 0);
  for (i_loc=0; i_loc<trans_ls; ++i_loc) trans_l[i_loc] = trans_ll[i_loc];
  free(trans_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, trans, trans_l, 0);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  for (i_loc=0; i_loc<kl_ls; ++i_loc) kl_l[i_loc] = kl_ll[i_loc];
  free(kl_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, kl, kl_l, 0);
  for (i_loc=0; i_loc<ku_ls; ++i_loc) ku_l[i_loc] = ku_ll[i_loc];
  free(ku_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ku, ku_l, 0);
  for (i_loc=0; i_loc<nrhs_ls; ++i_loc) nrhs_l[i_loc] = nrhs_ll[i_loc];
  free(nrhs_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, nrhs, nrhs_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, ab, ab_ll, 0);
  for (i_loc=0; i_loc<ldab_ls; ++i_loc) ldab_l[i_loc] = ldab_ll[i_loc];
  free(ldab_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldab, ldab_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, afb, afb_ll, 0);
  for (i_loc=0; i_loc<ldafb_ls; ++i_loc) ldafb_l[i_loc] = ldafb_ll[i_loc];
  free(ldafb_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldafb, ldafb_l, 0);
  for (i_loc=0; i_loc<ipiv_ls; ++i_loc) ipiv_l[i_loc] = ipiv_ll[i_loc];
  free(ipiv_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ipiv, ipiv_l, 0);
  for (i_loc=0; i_loc<equed_ls; ++i_loc) equed_l[i_loc] = equed_ll[i_loc];
  free(equed_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, equed, equed_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, r, r_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, c, c_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, b, b_ll, 0);
  for (i_loc=0; i_loc<ldb_ls; ++i_loc) ldb_l[i_loc] = ldb_ll[i_loc];
  free(ldb_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldb, ldb_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, x, x_ll, 0);
  for (i_loc=0; i_loc<ldx_ls; ++i_loc) ldx_l[i_loc] = ldx_ll[i_loc];
  free(ldx_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldx, ldx_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, rcond, rcond_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, ferr, ferr_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, berr, berr_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, work, work_ll, 0);
  for (i_loc=0; i_loc<iwork_ls; ++i_loc) iwork_l[i_loc] = iwork_ll[i_loc];
  free(iwork_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, iwork, iwork_l, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_gbtf2
(JNIEnv *env, jclass clazz, jintArray m, jintArray n, jintArray kl, jintArray ku, jdoubleArray ab, jintArray ldab, jintArray ipiv, jintArray info) {
  int i_loc;
  jint* m_l;
  integer* m_ll;
  jsize m_ls;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jint* kl_l;
  integer* kl_ll;
  jsize kl_ls;
  jint* ku_l;
  integer* ku_ll;
  jsize ku_ls;
  jdouble* ab_ll;
  jint* ldab_l;
  integer* ldab_ll;
  jsize ldab_ls;
  jint* ipiv_l;
  integer* ipiv_ll;
  jsize ipiv_ls;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  m_l = (*env)->GetPrimitiveArrayCritical(env, m, NULL);
  m_ls = (*env)->GetArrayLength(env, m);
  m_ll = malloc(sizeof(integer)*m_ls);
  for (i_loc=0; i_loc<m_ls; ++i_loc) m_ll[i_loc] = m_l[i_loc];
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  kl_l = (*env)->GetPrimitiveArrayCritical(env, kl, NULL);
  kl_ls = (*env)->GetArrayLength(env, kl);
  kl_ll = malloc(sizeof(integer)*kl_ls);
  for (i_loc=0; i_loc<kl_ls; ++i_loc) kl_ll[i_loc] = kl_l[i_loc];
  ku_l = (*env)->GetPrimitiveArrayCritical(env, ku, NULL);
  ku_ls = (*env)->GetArrayLength(env, ku);
  ku_ll = malloc(sizeof(integer)*ku_ls);
  for (i_loc=0; i_loc<ku_ls; ++i_loc) ku_ll[i_loc] = ku_l[i_loc];
  ab_ll = (*env)->GetPrimitiveArrayCritical(env, ab, NULL);
  ldab_l = (*env)->GetPrimitiveArrayCritical(env, ldab, NULL);
  ldab_ls = (*env)->GetArrayLength(env, ldab);
  ldab_ll = malloc(sizeof(integer)*ldab_ls);
  for (i_loc=0; i_loc<ldab_ls; ++i_loc) ldab_ll[i_loc] = ldab_l[i_loc];
  ipiv_l = (*env)->GetPrimitiveArrayCritical(env, ipiv, NULL);
  ipiv_ls = (*env)->GetArrayLength(env, ipiv);
  ipiv_ll = malloc(sizeof(integer)*ipiv_ls);
  for (i_loc=0; i_loc<ipiv_ls; ++i_loc) ipiv_ll[i_loc] = ipiv_l[i_loc];
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dgbtf2_(m_ll, n_ll, kl_ll, ku_ll, ab_ll, ldab_ll, ipiv_ll, info_ll);

  for (i_loc=0; i_loc<m_ls; ++i_loc) m_l[i_loc] = m_ll[i_loc];
  free(m_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, m, m_l, 0);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  for (i_loc=0; i_loc<kl_ls; ++i_loc) kl_l[i_loc] = kl_ll[i_loc];
  free(kl_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, kl, kl_l, 0);
  for (i_loc=0; i_loc<ku_ls; ++i_loc) ku_l[i_loc] = ku_ll[i_loc];
  free(ku_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ku, ku_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, ab, ab_ll, 0);
  for (i_loc=0; i_loc<ldab_ls; ++i_loc) ldab_l[i_loc] = ldab_ll[i_loc];
  free(ldab_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldab, ldab_l, 0);
  for (i_loc=0; i_loc<ipiv_ls; ++i_loc) ipiv_l[i_loc] = ipiv_ll[i_loc];
  free(ipiv_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ipiv, ipiv_l, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_gbtrf
(JNIEnv *env, jclass clazz, jintArray m, jintArray n, jintArray kl, jintArray ku, jdoubleArray ab, jintArray ldab, jintArray ipiv, jintArray info) {
  int i_loc;
  jint* m_l;
  integer* m_ll;
  jsize m_ls;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jint* kl_l;
  integer* kl_ll;
  jsize kl_ls;
  jint* ku_l;
  integer* ku_ll;
  jsize ku_ls;
  jdouble* ab_ll;
  jint* ldab_l;
  integer* ldab_ll;
  jsize ldab_ls;
  jint* ipiv_l;
  integer* ipiv_ll;
  jsize ipiv_ls;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  m_l = (*env)->GetPrimitiveArrayCritical(env, m, NULL);
  m_ls = (*env)->GetArrayLength(env, m);
  m_ll = malloc(sizeof(integer)*m_ls);
  for (i_loc=0; i_loc<m_ls; ++i_loc) m_ll[i_loc] = m_l[i_loc];
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  kl_l = (*env)->GetPrimitiveArrayCritical(env, kl, NULL);
  kl_ls = (*env)->GetArrayLength(env, kl);
  kl_ll = malloc(sizeof(integer)*kl_ls);
  for (i_loc=0; i_loc<kl_ls; ++i_loc) kl_ll[i_loc] = kl_l[i_loc];
  ku_l = (*env)->GetPrimitiveArrayCritical(env, ku, NULL);
  ku_ls = (*env)->GetArrayLength(env, ku);
  ku_ll = malloc(sizeof(integer)*ku_ls);
  for (i_loc=0; i_loc<ku_ls; ++i_loc) ku_ll[i_loc] = ku_l[i_loc];
  ab_ll = (*env)->GetPrimitiveArrayCritical(env, ab, NULL);
  ldab_l = (*env)->GetPrimitiveArrayCritical(env, ldab, NULL);
  ldab_ls = (*env)->GetArrayLength(env, ldab);
  ldab_ll = malloc(sizeof(integer)*ldab_ls);
  for (i_loc=0; i_loc<ldab_ls; ++i_loc) ldab_ll[i_loc] = ldab_l[i_loc];
  ipiv_l = (*env)->GetPrimitiveArrayCritical(env, ipiv, NULL);
  ipiv_ls = (*env)->GetArrayLength(env, ipiv);
  ipiv_ll = malloc(sizeof(integer)*ipiv_ls);
  for (i_loc=0; i_loc<ipiv_ls; ++i_loc) ipiv_ll[i_loc] = ipiv_l[i_loc];
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dgbtrf_(m_ll, n_ll, kl_ll, ku_ll, ab_ll, ldab_ll, ipiv_ll, info_ll);

  for (i_loc=0; i_loc<m_ls; ++i_loc) m_l[i_loc] = m_ll[i_loc];
  free(m_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, m, m_l, 0);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  for (i_loc=0; i_loc<kl_ls; ++i_loc) kl_l[i_loc] = kl_ll[i_loc];
  free(kl_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, kl, kl_l, 0);
  for (i_loc=0; i_loc<ku_ls; ++i_loc) ku_l[i_loc] = ku_ll[i_loc];
  free(ku_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ku, ku_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, ab, ab_ll, 0);
  for (i_loc=0; i_loc<ldab_ls; ++i_loc) ldab_l[i_loc] = ldab_ll[i_loc];
  free(ldab_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldab, ldab_l, 0);
  for (i_loc=0; i_loc<ipiv_ls; ++i_loc) ipiv_l[i_loc] = ipiv_ll[i_loc];
  free(ipiv_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ipiv, ipiv_l, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_gbtrs
(JNIEnv *env, jclass clazz, jcharArray trans, jintArray n, jintArray kl, jintArray ku, jintArray nrhs, jdoubleArray ab, jintArray ldab, jintArray ipiv, jdoubleArray b, jintArray ldb, jintArray info) {
  int i_loc;
  jchar* trans_l;
  char* trans_ll;
  jsize trans_ls;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jint* kl_l;
  integer* kl_ll;
  jsize kl_ls;
  jint* ku_l;
  integer* ku_ll;
  jsize ku_ls;
  jint* nrhs_l;
  integer* nrhs_ll;
  jsize nrhs_ls;
  jdouble* ab_ll;
  jint* ldab_l;
  integer* ldab_ll;
  jsize ldab_ls;
  jint* ipiv_l;
  integer* ipiv_ll;
  jsize ipiv_ls;
  jdouble* b_ll;
  jint* ldb_l;
  integer* ldb_ll;
  jsize ldb_ls;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  trans_l = (*env)->GetPrimitiveArrayCritical(env, trans, NULL);
  trans_ls = (*env)->GetArrayLength(env, trans);
  trans_ll = malloc(sizeof(char)*trans_ls);
  for (i_loc=0; i_loc<trans_ls; ++i_loc) trans_ll[i_loc] = trans_l[i_loc];
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  kl_l = (*env)->GetPrimitiveArrayCritical(env, kl, NULL);
  kl_ls = (*env)->GetArrayLength(env, kl);
  kl_ll = malloc(sizeof(integer)*kl_ls);
  for (i_loc=0; i_loc<kl_ls; ++i_loc) kl_ll[i_loc] = kl_l[i_loc];
  ku_l = (*env)->GetPrimitiveArrayCritical(env, ku, NULL);
  ku_ls = (*env)->GetArrayLength(env, ku);
  ku_ll = malloc(sizeof(integer)*ku_ls);
  for (i_loc=0; i_loc<ku_ls; ++i_loc) ku_ll[i_loc] = ku_l[i_loc];
  nrhs_l = (*env)->GetPrimitiveArrayCritical(env, nrhs, NULL);
  nrhs_ls = (*env)->GetArrayLength(env, nrhs);
  nrhs_ll = malloc(sizeof(integer)*nrhs_ls);
  for (i_loc=0; i_loc<nrhs_ls; ++i_loc) nrhs_ll[i_loc] = nrhs_l[i_loc];
  ab_ll = (*env)->GetPrimitiveArrayCritical(env, ab, NULL);
  ldab_l = (*env)->GetPrimitiveArrayCritical(env, ldab, NULL);
  ldab_ls = (*env)->GetArrayLength(env, ldab);
  ldab_ll = malloc(sizeof(integer)*ldab_ls);
  for (i_loc=0; i_loc<ldab_ls; ++i_loc) ldab_ll[i_loc] = ldab_l[i_loc];
  ipiv_l = (*env)->GetPrimitiveArrayCritical(env, ipiv, NULL);
  ipiv_ls = (*env)->GetArrayLength(env, ipiv);
  ipiv_ll = malloc(sizeof(integer)*ipiv_ls);
  for (i_loc=0; i_loc<ipiv_ls; ++i_loc) ipiv_ll[i_loc] = ipiv_l[i_loc];
  b_ll = (*env)->GetPrimitiveArrayCritical(env, b, NULL);
  ldb_l = (*env)->GetPrimitiveArrayCritical(env, ldb, NULL);
  ldb_ls = (*env)->GetArrayLength(env, ldb);
  ldb_ll = malloc(sizeof(integer)*ldb_ls);
  for (i_loc=0; i_loc<ldb_ls; ++i_loc) ldb_ll[i_loc] = ldb_l[i_loc];
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dgbtrs_(trans_ll, n_ll, kl_ll, ku_ll, nrhs_ll, ab_ll, ldab_ll, ipiv_ll, b_ll, ldb_ll, info_ll);

  for (i_loc=0; i_loc<trans_ls; ++i_loc) trans_l[i_loc] = trans_ll[i_loc];
  free(trans_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, trans, trans_l, 0);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  for (i_loc=0; i_loc<kl_ls; ++i_loc) kl_l[i_loc] = kl_ll[i_loc];
  free(kl_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, kl, kl_l, 0);
  for (i_loc=0; i_loc<ku_ls; ++i_loc) ku_l[i_loc] = ku_ll[i_loc];
  free(ku_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ku, ku_l, 0);
  for (i_loc=0; i_loc<nrhs_ls; ++i_loc) nrhs_l[i_loc] = nrhs_ll[i_loc];
  free(nrhs_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, nrhs, nrhs_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, ab, ab_ll, 0);
  for (i_loc=0; i_loc<ldab_ls; ++i_loc) ldab_l[i_loc] = ldab_ll[i_loc];
  free(ldab_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldab, ldab_l, 0);
  for (i_loc=0; i_loc<ipiv_ls; ++i_loc) ipiv_l[i_loc] = ipiv_ll[i_loc];
  free(ipiv_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ipiv, ipiv_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, b, b_ll, 0);
  for (i_loc=0; i_loc<ldb_ls; ++i_loc) ldb_l[i_loc] = ldb_ll[i_loc];
  free(ldb_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldb, ldb_l, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_gebak
(JNIEnv *env, jclass clazz, jcharArray job, jcharArray side, jintArray n, jintArray ilo, jintArray ihi, jdoubleArray scale, jintArray m, jdoubleArray v, jintArray ldv, jintArray info) {
  int i_loc;
  jchar* job_l;
  char* job_ll;
  jsize job_ls;
  jchar* side_l;
  char* side_ll;
  jsize side_ls;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jint* ilo_l;
  integer* ilo_ll;
  jsize ilo_ls;
  jint* ihi_l;
  integer* ihi_ll;
  jsize ihi_ls;
  jdouble* scale_ll;
  jint* m_l;
  integer* m_ll;
  jsize m_ls;
  jdouble* v_ll;
  jint* ldv_l;
  integer* ldv_ll;
  jsize ldv_ls;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  job_l = (*env)->GetPrimitiveArrayCritical(env, job, NULL);
  job_ls = (*env)->GetArrayLength(env, job);
  job_ll = malloc(sizeof(char)*job_ls);
  for (i_loc=0; i_loc<job_ls; ++i_loc) job_ll[i_loc] = job_l[i_loc];
  side_l = (*env)->GetPrimitiveArrayCritical(env, side, NULL);
  side_ls = (*env)->GetArrayLength(env, side);
  side_ll = malloc(sizeof(char)*side_ls);
  for (i_loc=0; i_loc<side_ls; ++i_loc) side_ll[i_loc] = side_l[i_loc];
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  ilo_l = (*env)->GetPrimitiveArrayCritical(env, ilo, NULL);
  ilo_ls = (*env)->GetArrayLength(env, ilo);
  ilo_ll = malloc(sizeof(integer)*ilo_ls);
  for (i_loc=0; i_loc<ilo_ls; ++i_loc) ilo_ll[i_loc] = ilo_l[i_loc];
  ihi_l = (*env)->GetPrimitiveArrayCritical(env, ihi, NULL);
  ihi_ls = (*env)->GetArrayLength(env, ihi);
  ihi_ll = malloc(sizeof(integer)*ihi_ls);
  for (i_loc=0; i_loc<ihi_ls; ++i_loc) ihi_ll[i_loc] = ihi_l[i_loc];
  scale_ll = (*env)->GetPrimitiveArrayCritical(env, scale, NULL);
  m_l = (*env)->GetPrimitiveArrayCritical(env, m, NULL);
  m_ls = (*env)->GetArrayLength(env, m);
  m_ll = malloc(sizeof(integer)*m_ls);
  for (i_loc=0; i_loc<m_ls; ++i_loc) m_ll[i_loc] = m_l[i_loc];
  v_ll = (*env)->GetPrimitiveArrayCritical(env, v, NULL);
  ldv_l = (*env)->GetPrimitiveArrayCritical(env, ldv, NULL);
  ldv_ls = (*env)->GetArrayLength(env, ldv);
  ldv_ll = malloc(sizeof(integer)*ldv_ls);
  for (i_loc=0; i_loc<ldv_ls; ++i_loc) ldv_ll[i_loc] = ldv_l[i_loc];
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dgebak_(job_ll, side_ll, n_ll, ilo_ll, ihi_ll, scale_ll, m_ll, v_ll, ldv_ll, info_ll);

  for (i_loc=0; i_loc<job_ls; ++i_loc) job_l[i_loc] = job_ll[i_loc];
  free(job_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, job, job_l, 0);
  for (i_loc=0; i_loc<side_ls; ++i_loc) side_l[i_loc] = side_ll[i_loc];
  free(side_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, side, side_l, 0);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  for (i_loc=0; i_loc<ilo_ls; ++i_loc) ilo_l[i_loc] = ilo_ll[i_loc];
  free(ilo_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ilo, ilo_l, 0);
  for (i_loc=0; i_loc<ihi_ls; ++i_loc) ihi_l[i_loc] = ihi_ll[i_loc];
  free(ihi_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ihi, ihi_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, scale, scale_ll, 0);
  for (i_loc=0; i_loc<m_ls; ++i_loc) m_l[i_loc] = m_ll[i_loc];
  free(m_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, m, m_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, v, v_ll, 0);
  for (i_loc=0; i_loc<ldv_ls; ++i_loc) ldv_l[i_loc] = ldv_ll[i_loc];
  free(ldv_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldv, ldv_l, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_gebal
(JNIEnv *env, jclass clazz, jcharArray job, jintArray n, jdoubleArray a, jintArray lda, jintArray ilo, jintArray ihi, jdoubleArray scale, jintArray info) {
  int i_loc;
  jchar* job_l;
  char* job_ll;
  jsize job_ls;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jdouble* a_ll;
  jint* lda_l;
  integer* lda_ll;
  jsize lda_ls;
  jint* ilo_l;
  integer* ilo_ll;
  jsize ilo_ls;
  jint* ihi_l;
  integer* ihi_ll;
  jsize ihi_ls;
  jdouble* scale_ll;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  job_l = (*env)->GetPrimitiveArrayCritical(env, job, NULL);
  job_ls = (*env)->GetArrayLength(env, job);
  job_ll = malloc(sizeof(char)*job_ls);
  for (i_loc=0; i_loc<job_ls; ++i_loc) job_ll[i_loc] = job_l[i_loc];
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  a_ll = (*env)->GetPrimitiveArrayCritical(env, a, NULL);
  lda_l = (*env)->GetPrimitiveArrayCritical(env, lda, NULL);
  lda_ls = (*env)->GetArrayLength(env, lda);
  lda_ll = malloc(sizeof(integer)*lda_ls);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_ll[i_loc] = lda_l[i_loc];
  ilo_l = (*env)->GetPrimitiveArrayCritical(env, ilo, NULL);
  ilo_ls = (*env)->GetArrayLength(env, ilo);
  ilo_ll = malloc(sizeof(integer)*ilo_ls);
  for (i_loc=0; i_loc<ilo_ls; ++i_loc) ilo_ll[i_loc] = ilo_l[i_loc];
  ihi_l = (*env)->GetPrimitiveArrayCritical(env, ihi, NULL);
  ihi_ls = (*env)->GetArrayLength(env, ihi);
  ihi_ll = malloc(sizeof(integer)*ihi_ls);
  for (i_loc=0; i_loc<ihi_ls; ++i_loc) ihi_ll[i_loc] = ihi_l[i_loc];
  scale_ll = (*env)->GetPrimitiveArrayCritical(env, scale, NULL);
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dgebal_(job_ll, n_ll, a_ll, lda_ll, ilo_ll, ihi_ll, scale_ll, info_ll);

  for (i_loc=0; i_loc<job_ls; ++i_loc) job_l[i_loc] = job_ll[i_loc];
  free(job_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, job, job_l, 0);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, a, a_ll, 0);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_l[i_loc] = lda_ll[i_loc];
  free(lda_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, lda, lda_l, 0);
  for (i_loc=0; i_loc<ilo_ls; ++i_loc) ilo_l[i_loc] = ilo_ll[i_loc];
  free(ilo_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ilo, ilo_l, 0);
  for (i_loc=0; i_loc<ihi_ls; ++i_loc) ihi_l[i_loc] = ihi_ll[i_loc];
  free(ihi_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ihi, ihi_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, scale, scale_ll, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_gebd2
(JNIEnv *env, jclass clazz, jintArray m, jintArray n, jdoubleArray a, jintArray lda, jdoubleArray d, jdoubleArray e, jdoubleArray tauq, jdoubleArray taup, jdoubleArray work, jintArray info) {
  int i_loc;
  jint* m_l;
  integer* m_ll;
  jsize m_ls;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jdouble* a_ll;
  jint* lda_l;
  integer* lda_ll;
  jsize lda_ls;
  jdouble* d_ll;
  jdouble* e_ll;
  jdouble* tauq_ll;
  jdouble* taup_ll;
  jdouble* work_ll;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  m_l = (*env)->GetPrimitiveArrayCritical(env, m, NULL);
  m_ls = (*env)->GetArrayLength(env, m);
  m_ll = malloc(sizeof(integer)*m_ls);
  for (i_loc=0; i_loc<m_ls; ++i_loc) m_ll[i_loc] = m_l[i_loc];
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  a_ll = (*env)->GetPrimitiveArrayCritical(env, a, NULL);
  lda_l = (*env)->GetPrimitiveArrayCritical(env, lda, NULL);
  lda_ls = (*env)->GetArrayLength(env, lda);
  lda_ll = malloc(sizeof(integer)*lda_ls);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_ll[i_loc] = lda_l[i_loc];
  d_ll = (*env)->GetPrimitiveArrayCritical(env, d, NULL);
  e_ll = (*env)->GetPrimitiveArrayCritical(env, e, NULL);
  tauq_ll = (*env)->GetPrimitiveArrayCritical(env, tauq, NULL);
  taup_ll = (*env)->GetPrimitiveArrayCritical(env, taup, NULL);
  work_ll = (*env)->GetPrimitiveArrayCritical(env, work, NULL);
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dgebd2_(m_ll, n_ll, a_ll, lda_ll, d_ll, e_ll, tauq_ll, taup_ll, work_ll, info_ll);

  for (i_loc=0; i_loc<m_ls; ++i_loc) m_l[i_loc] = m_ll[i_loc];
  free(m_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, m, m_l, 0);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, a, a_ll, 0);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_l[i_loc] = lda_ll[i_loc];
  free(lda_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, lda, lda_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, d, d_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, e, e_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, tauq, tauq_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, taup, taup_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, work, work_ll, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_gebrd
(JNIEnv *env, jclass clazz, jintArray m, jintArray n, jdoubleArray a, jintArray lda, jdoubleArray d, jdoubleArray e, jdoubleArray tauq, jdoubleArray taup, jdoubleArray work, jintArray lwork, jintArray info) {
  int i_loc;
  jint* m_l;
  integer* m_ll;
  jsize m_ls;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jdouble* a_ll;
  jint* lda_l;
  integer* lda_ll;
  jsize lda_ls;
  jdouble* d_ll;
  jdouble* e_ll;
  jdouble* tauq_ll;
  jdouble* taup_ll;
  jdouble* work_ll;
  jint* lwork_l;
  integer* lwork_ll;
  jsize lwork_ls;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  m_l = (*env)->GetPrimitiveArrayCritical(env, m, NULL);
  m_ls = (*env)->GetArrayLength(env, m);
  m_ll = malloc(sizeof(integer)*m_ls);
  for (i_loc=0; i_loc<m_ls; ++i_loc) m_ll[i_loc] = m_l[i_loc];
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  a_ll = (*env)->GetPrimitiveArrayCritical(env, a, NULL);
  lda_l = (*env)->GetPrimitiveArrayCritical(env, lda, NULL);
  lda_ls = (*env)->GetArrayLength(env, lda);
  lda_ll = malloc(sizeof(integer)*lda_ls);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_ll[i_loc] = lda_l[i_loc];
  d_ll = (*env)->GetPrimitiveArrayCritical(env, d, NULL);
  e_ll = (*env)->GetPrimitiveArrayCritical(env, e, NULL);
  tauq_ll = (*env)->GetPrimitiveArrayCritical(env, tauq, NULL);
  taup_ll = (*env)->GetPrimitiveArrayCritical(env, taup, NULL);
  work_ll = (*env)->GetPrimitiveArrayCritical(env, work, NULL);
  lwork_l = (*env)->GetPrimitiveArrayCritical(env, lwork, NULL);
  lwork_ls = (*env)->GetArrayLength(env, lwork);
  lwork_ll = malloc(sizeof(integer)*lwork_ls);
  for (i_loc=0; i_loc<lwork_ls; ++i_loc) lwork_ll[i_loc] = lwork_l[i_loc];
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dgebrd_(m_ll, n_ll, a_ll, lda_ll, d_ll, e_ll, tauq_ll, taup_ll, work_ll, lwork_ll, info_ll);

  for (i_loc=0; i_loc<m_ls; ++i_loc) m_l[i_loc] = m_ll[i_loc];
  free(m_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, m, m_l, 0);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, a, a_ll, 0);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_l[i_loc] = lda_ll[i_loc];
  free(lda_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, lda, lda_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, d, d_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, e, e_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, tauq, tauq_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, taup, taup_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, work, work_ll, 0);
  for (i_loc=0; i_loc<lwork_ls; ++i_loc) lwork_l[i_loc] = lwork_ll[i_loc];
  free(lwork_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, lwork, lwork_l, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_gecon
(JNIEnv *env, jclass clazz, jcharArray norm, jintArray n, jdoubleArray a, jintArray lda, jdoubleArray anorm, jdoubleArray rcond, jdoubleArray work, jintArray iwork, jintArray info) {
  int i_loc;
  jchar* norm_l;
  char* norm_ll;
  jsize norm_ls;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jdouble* a_ll;
  jint* lda_l;
  integer* lda_ll;
  jsize lda_ls;
  jdouble* anorm_ll;
  jdouble* rcond_ll;
  jdouble* work_ll;
  jint* iwork_l;
  integer* iwork_ll;
  jsize iwork_ls;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  norm_l = (*env)->GetPrimitiveArrayCritical(env, norm, NULL);
  norm_ls = (*env)->GetArrayLength(env, norm);
  norm_ll = malloc(sizeof(char)*norm_ls);
  for (i_loc=0; i_loc<norm_ls; ++i_loc) norm_ll[i_loc] = norm_l[i_loc];
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  a_ll = (*env)->GetPrimitiveArrayCritical(env, a, NULL);
  lda_l = (*env)->GetPrimitiveArrayCritical(env, lda, NULL);
  lda_ls = (*env)->GetArrayLength(env, lda);
  lda_ll = malloc(sizeof(integer)*lda_ls);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_ll[i_loc] = lda_l[i_loc];
  anorm_ll = (*env)->GetPrimitiveArrayCritical(env, anorm, NULL);
  rcond_ll = (*env)->GetPrimitiveArrayCritical(env, rcond, NULL);
  work_ll = (*env)->GetPrimitiveArrayCritical(env, work, NULL);
  iwork_l = (*env)->GetPrimitiveArrayCritical(env, iwork, NULL);
  iwork_ls = (*env)->GetArrayLength(env, iwork);
  iwork_ll = malloc(sizeof(integer)*iwork_ls);
  for (i_loc=0; i_loc<iwork_ls; ++i_loc) iwork_ll[i_loc] = iwork_l[i_loc];
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dgecon_(norm_ll, n_ll, a_ll, lda_ll, anorm_ll, rcond_ll, work_ll, iwork_ll, info_ll);

  for (i_loc=0; i_loc<norm_ls; ++i_loc) norm_l[i_loc] = norm_ll[i_loc];
  free(norm_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, norm, norm_l, 0);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, a, a_ll, 0);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_l[i_loc] = lda_ll[i_loc];
  free(lda_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, lda, lda_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, anorm, anorm_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, rcond, rcond_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, work, work_ll, 0);
  for (i_loc=0; i_loc<iwork_ls; ++i_loc) iwork_l[i_loc] = iwork_ll[i_loc];
  free(iwork_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, iwork, iwork_l, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_geequ
(JNIEnv *env, jclass clazz, jintArray m, jintArray n, jdoubleArray a, jintArray lda, jdoubleArray r, jdoubleArray c, jdoubleArray rowcnd, jdoubleArray colcnd, jdoubleArray amax, jintArray info) {
  int i_loc;
  jint* m_l;
  integer* m_ll;
  jsize m_ls;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jdouble* a_ll;
  jint* lda_l;
  integer* lda_ll;
  jsize lda_ls;
  jdouble* r_ll;
  jdouble* c_ll;
  jdouble* rowcnd_ll;
  jdouble* colcnd_ll;
  jdouble* amax_ll;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  m_l = (*env)->GetPrimitiveArrayCritical(env, m, NULL);
  m_ls = (*env)->GetArrayLength(env, m);
  m_ll = malloc(sizeof(integer)*m_ls);
  for (i_loc=0; i_loc<m_ls; ++i_loc) m_ll[i_loc] = m_l[i_loc];
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  a_ll = (*env)->GetPrimitiveArrayCritical(env, a, NULL);
  lda_l = (*env)->GetPrimitiveArrayCritical(env, lda, NULL);
  lda_ls = (*env)->GetArrayLength(env, lda);
  lda_ll = malloc(sizeof(integer)*lda_ls);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_ll[i_loc] = lda_l[i_loc];
  r_ll = (*env)->GetPrimitiveArrayCritical(env, r, NULL);
  c_ll = (*env)->GetPrimitiveArrayCritical(env, c, NULL);
  rowcnd_ll = (*env)->GetPrimitiveArrayCritical(env, rowcnd, NULL);
  colcnd_ll = (*env)->GetPrimitiveArrayCritical(env, colcnd, NULL);
  amax_ll = (*env)->GetPrimitiveArrayCritical(env, amax, NULL);
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dgeequ_(m_ll, n_ll, a_ll, lda_ll, r_ll, c_ll, rowcnd_ll, colcnd_ll, amax_ll, info_ll);

  for (i_loc=0; i_loc<m_ls; ++i_loc) m_l[i_loc] = m_ll[i_loc];
  free(m_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, m, m_l, 0);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, a, a_ll, 0);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_l[i_loc] = lda_ll[i_loc];
  free(lda_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, lda, lda_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, r, r_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, c, c_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, rowcnd, rowcnd_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, colcnd, colcnd_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, amax, amax_ll, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_gees
(JNIEnv *env, jclass clazz, jcharArray jobvs, jcharArray sort, jobject select, jintArray n, jdoubleArray a, jintArray lda, jintArray sdim, jdoubleArray wr, jdoubleArray wi, jdoubleArray vs, jintArray ldvs, jdoubleArray work, jintArray lwork, jbooleanArray bwork, jintArray info) {
  int i_loc;
  jchar* jobvs_l;
  char* jobvs_ll;
  jsize jobvs_ls;
  jchar* sort_l;
  char* sort_ll;
  jsize sort_ls;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jdouble* a_ll;
  jint* lda_l;
  integer* lda_ll;
  jsize lda_ls;
  jint* sdim_l;
  integer* sdim_ll;
  jsize sdim_ls;
  jdouble* wr_ll;
  jdouble* wi_ll;
  jdouble* vs_ll;
  jint* ldvs_l;
  integer* ldvs_ll;
  jsize ldvs_ls;
  jdouble* work_ll;
  jint* lwork_l;
  integer* lwork_ll;
  jsize lwork_ls;
  jboolean* bwork_l;
  integer* bwork_ll;
  jsize bwork_ls;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  jobvs_l = (*env)->GetPrimitiveArrayCritical(env, jobvs, NULL);
  jobvs_ls = (*env)->GetArrayLength(env, jobvs);
  jobvs_ll = malloc(sizeof(char)*jobvs_ls);
  for (i_loc=0; i_loc<jobvs_ls; ++i_loc) jobvs_ll[i_loc] = jobvs_l[i_loc];
  sort_l = (*env)->GetPrimitiveArrayCritical(env, sort, NULL);
  sort_ls = (*env)->GetArrayLength(env, sort);
  sort_ll = malloc(sizeof(char)*sort_ls);
  for (i_loc=0; i_loc<sort_ls; ++i_loc) sort_ll[i_loc] = sort_l[i_loc];
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  a_ll = (*env)->GetPrimitiveArrayCritical(env, a, NULL);
  lda_l = (*env)->GetPrimitiveArrayCritical(env, lda, NULL);
  lda_ls = (*env)->GetArrayLength(env, lda);
  lda_ll = malloc(sizeof(integer)*lda_ls);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_ll[i_loc] = lda_l[i_loc];
  sdim_l = (*env)->GetPrimitiveArrayCritical(env, sdim, NULL);
  sdim_ls = (*env)->GetArrayLength(env, sdim);
  sdim_ll = malloc(sizeof(integer)*sdim_ls);
  for (i_loc=0; i_loc<sdim_ls; ++i_loc) sdim_ll[i_loc] = sdim_l[i_loc];
  wr_ll = (*env)->GetPrimitiveArrayCritical(env, wr, NULL);
  wi_ll = (*env)->GetPrimitiveArrayCritical(env, wi, NULL);
  vs_ll = (*env)->GetPrimitiveArrayCritical(env, vs, NULL);
  ldvs_l = (*env)->GetPrimitiveArrayCritical(env, ldvs, NULL);
  ldvs_ls = (*env)->GetArrayLength(env, ldvs);
  ldvs_ll = malloc(sizeof(integer)*ldvs_ls);
  for (i_loc=0; i_loc<ldvs_ls; ++i_loc) ldvs_ll[i_loc] = ldvs_l[i_loc];
  work_ll = (*env)->GetPrimitiveArrayCritical(env, work, NULL);
  lwork_l = (*env)->GetPrimitiveArrayCritical(env, lwork, NULL);
  lwork_ls = (*env)->GetArrayLength(env, lwork);
  lwork_ll = malloc(sizeof(integer)*lwork_ls);
  for (i_loc=0; i_loc<lwork_ls; ++i_loc) lwork_ll[i_loc] = lwork_l[i_loc];
  bwork_l = (*env)->GetPrimitiveArrayCritical(env, bwork, NULL);
  bwork_ls = (*env)->GetArrayLength(env, bwork);
  bwork_ll = malloc(sizeof(integer)*bwork_ls);
  for (i_loc=0; i_loc<bwork_ls; ++i_loc) bwork_ll[i_loc] = bwork_l[i_loc];
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dgees_(jobvs_ll, sort_ll, (L_fp)select, n_ll, a_ll, lda_ll, sdim_ll, wr_ll, wi_ll, vs_ll, ldvs_ll, work_ll, lwork_ll, bwork_ll, info_ll);

  for (i_loc=0; i_loc<jobvs_ls; ++i_loc) jobvs_l[i_loc] = jobvs_ll[i_loc];
  free(jobvs_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, jobvs, jobvs_l, 0);
  for (i_loc=0; i_loc<sort_ls; ++i_loc) sort_l[i_loc] = sort_ll[i_loc];
  free(sort_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, sort, sort_l, 0);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, a, a_ll, 0);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_l[i_loc] = lda_ll[i_loc];
  free(lda_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, lda, lda_l, 0);
  for (i_loc=0; i_loc<sdim_ls; ++i_loc) sdim_l[i_loc] = sdim_ll[i_loc];
  free(sdim_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, sdim, sdim_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, wr, wr_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, wi, wi_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, vs, vs_ll, 0);
  for (i_loc=0; i_loc<ldvs_ls; ++i_loc) ldvs_l[i_loc] = ldvs_ll[i_loc];
  free(ldvs_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldvs, ldvs_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, work, work_ll, 0);
  for (i_loc=0; i_loc<lwork_ls; ++i_loc) lwork_l[i_loc] = lwork_ll[i_loc];
  free(lwork_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, lwork, lwork_l, 0);
  for (i_loc=0; i_loc<bwork_ls; ++i_loc) bwork_l[i_loc] = bwork_ll[i_loc];
  free(bwork_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, bwork, bwork_l, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_geesx
(JNIEnv *env, jclass clazz, jcharArray jobvs, jcharArray sort, jobject select, jcharArray sense, jintArray n, jdoubleArray a, jintArray lda, jintArray sdim, jdoubleArray wr, jdoubleArray wi, jdoubleArray vs, jintArray ldvs, jdoubleArray rconde, jdoubleArray rcondv, jdoubleArray work, jintArray lwork, jintArray iwork, jintArray liwork, jbooleanArray bwork, jintArray info) {
  int i_loc;
  jchar* jobvs_l;
  char* jobvs_ll;
  jsize jobvs_ls;
  jchar* sort_l;
  char* sort_ll;
  jsize sort_ls;
  jchar* sense_l;
  char* sense_ll;
  jsize sense_ls;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jdouble* a_ll;
  jint* lda_l;
  integer* lda_ll;
  jsize lda_ls;
  jint* sdim_l;
  integer* sdim_ll;
  jsize sdim_ls;
  jdouble* wr_ll;
  jdouble* wi_ll;
  jdouble* vs_ll;
  jint* ldvs_l;
  integer* ldvs_ll;
  jsize ldvs_ls;
  jdouble* rconde_ll;
  jdouble* rcondv_ll;
  jdouble* work_ll;
  jint* lwork_l;
  integer* lwork_ll;
  jsize lwork_ls;
  jint* iwork_l;
  integer* iwork_ll;
  jsize iwork_ls;
  jint* liwork_l;
  integer* liwork_ll;
  jsize liwork_ls;
  jboolean* bwork_l;
  integer* bwork_ll;
  jsize bwork_ls;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  jobvs_l = (*env)->GetPrimitiveArrayCritical(env, jobvs, NULL);
  jobvs_ls = (*env)->GetArrayLength(env, jobvs);
  jobvs_ll = malloc(sizeof(char)*jobvs_ls);
  for (i_loc=0; i_loc<jobvs_ls; ++i_loc) jobvs_ll[i_loc] = jobvs_l[i_loc];
  sort_l = (*env)->GetPrimitiveArrayCritical(env, sort, NULL);
  sort_ls = (*env)->GetArrayLength(env, sort);
  sort_ll = malloc(sizeof(char)*sort_ls);
  for (i_loc=0; i_loc<sort_ls; ++i_loc) sort_ll[i_loc] = sort_l[i_loc];
  sense_l = (*env)->GetPrimitiveArrayCritical(env, sense, NULL);
  sense_ls = (*env)->GetArrayLength(env, sense);
  sense_ll = malloc(sizeof(char)*sense_ls);
  for (i_loc=0; i_loc<sense_ls; ++i_loc) sense_ll[i_loc] = sense_l[i_loc];
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  a_ll = (*env)->GetPrimitiveArrayCritical(env, a, NULL);
  lda_l = (*env)->GetPrimitiveArrayCritical(env, lda, NULL);
  lda_ls = (*env)->GetArrayLength(env, lda);
  lda_ll = malloc(sizeof(integer)*lda_ls);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_ll[i_loc] = lda_l[i_loc];
  sdim_l = (*env)->GetPrimitiveArrayCritical(env, sdim, NULL);
  sdim_ls = (*env)->GetArrayLength(env, sdim);
  sdim_ll = malloc(sizeof(integer)*sdim_ls);
  for (i_loc=0; i_loc<sdim_ls; ++i_loc) sdim_ll[i_loc] = sdim_l[i_loc];
  wr_ll = (*env)->GetPrimitiveArrayCritical(env, wr, NULL);
  wi_ll = (*env)->GetPrimitiveArrayCritical(env, wi, NULL);
  vs_ll = (*env)->GetPrimitiveArrayCritical(env, vs, NULL);
  ldvs_l = (*env)->GetPrimitiveArrayCritical(env, ldvs, NULL);
  ldvs_ls = (*env)->GetArrayLength(env, ldvs);
  ldvs_ll = malloc(sizeof(integer)*ldvs_ls);
  for (i_loc=0; i_loc<ldvs_ls; ++i_loc) ldvs_ll[i_loc] = ldvs_l[i_loc];
  rconde_ll = (*env)->GetPrimitiveArrayCritical(env, rconde, NULL);
  rcondv_ll = (*env)->GetPrimitiveArrayCritical(env, rcondv, NULL);
  work_ll = (*env)->GetPrimitiveArrayCritical(env, work, NULL);
  lwork_l = (*env)->GetPrimitiveArrayCritical(env, lwork, NULL);
  lwork_ls = (*env)->GetArrayLength(env, lwork);
  lwork_ll = malloc(sizeof(integer)*lwork_ls);
  for (i_loc=0; i_loc<lwork_ls; ++i_loc) lwork_ll[i_loc] = lwork_l[i_loc];
  iwork_l = (*env)->GetPrimitiveArrayCritical(env, iwork, NULL);
  iwork_ls = (*env)->GetArrayLength(env, iwork);
  iwork_ll = malloc(sizeof(integer)*iwork_ls);
  for (i_loc=0; i_loc<iwork_ls; ++i_loc) iwork_ll[i_loc] = iwork_l[i_loc];
  liwork_l = (*env)->GetPrimitiveArrayCritical(env, liwork, NULL);
  liwork_ls = (*env)->GetArrayLength(env, liwork);
  liwork_ll = malloc(sizeof(integer)*liwork_ls);
  for (i_loc=0; i_loc<liwork_ls; ++i_loc) liwork_ll[i_loc] = liwork_l[i_loc];
  bwork_l = (*env)->GetPrimitiveArrayCritical(env, bwork, NULL);
  bwork_ls = (*env)->GetArrayLength(env, bwork);
  bwork_ll = malloc(sizeof(integer)*bwork_ls);
  for (i_loc=0; i_loc<bwork_ls; ++i_loc) bwork_ll[i_loc] = bwork_l[i_loc];
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dgeesx_(jobvs_ll, sort_ll, (L_fp)select, sense_ll, n_ll, a_ll, lda_ll, sdim_ll, wr_ll, wi_ll, vs_ll, ldvs_ll, rconde_ll, rcondv_ll, work_ll, lwork_ll, iwork_ll, liwork_ll, bwork_ll, info_ll);

  for (i_loc=0; i_loc<jobvs_ls; ++i_loc) jobvs_l[i_loc] = jobvs_ll[i_loc];
  free(jobvs_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, jobvs, jobvs_l, 0);
  for (i_loc=0; i_loc<sort_ls; ++i_loc) sort_l[i_loc] = sort_ll[i_loc];
  free(sort_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, sort, sort_l, 0);
  for (i_loc=0; i_loc<sense_ls; ++i_loc) sense_l[i_loc] = sense_ll[i_loc];
  free(sense_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, sense, sense_l, 0);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, a, a_ll, 0);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_l[i_loc] = lda_ll[i_loc];
  free(lda_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, lda, lda_l, 0);
  for (i_loc=0; i_loc<sdim_ls; ++i_loc) sdim_l[i_loc] = sdim_ll[i_loc];
  free(sdim_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, sdim, sdim_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, wr, wr_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, wi, wi_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, vs, vs_ll, 0);
  for (i_loc=0; i_loc<ldvs_ls; ++i_loc) ldvs_l[i_loc] = ldvs_ll[i_loc];
  free(ldvs_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldvs, ldvs_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, rconde, rconde_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, rcondv, rcondv_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, work, work_ll, 0);
  for (i_loc=0; i_loc<lwork_ls; ++i_loc) lwork_l[i_loc] = lwork_ll[i_loc];
  free(lwork_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, lwork, lwork_l, 0);
  for (i_loc=0; i_loc<iwork_ls; ++i_loc) iwork_l[i_loc] = iwork_ll[i_loc];
  free(iwork_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, iwork, iwork_l, 0);
  for (i_loc=0; i_loc<liwork_ls; ++i_loc) liwork_l[i_loc] = liwork_ll[i_loc];
  free(liwork_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, liwork, liwork_l, 0);
  for (i_loc=0; i_loc<bwork_ls; ++i_loc) bwork_l[i_loc] = bwork_ll[i_loc];
  free(bwork_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, bwork, bwork_l, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_geev
(JNIEnv *env, jclass clazz, jcharArray jobvl, jcharArray jobvr, jintArray n, jdoubleArray a, jintArray lda, jdoubleArray wr, jdoubleArray wi, jdoubleArray vl, jintArray ldvl, jdoubleArray vr, jintArray ldvr, jdoubleArray work, jintArray lwork, jintArray info) {
  int i_loc;
  jchar* jobvl_l;
  char* jobvl_ll;
  jsize jobvl_ls;
  jchar* jobvr_l;
  char* jobvr_ll;
  jsize jobvr_ls;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jdouble* a_ll;
  jint* lda_l;
  integer* lda_ll;
  jsize lda_ls;
  jdouble* wr_ll;
  jdouble* wi_ll;
  jdouble* vl_ll;
  jint* ldvl_l;
  integer* ldvl_ll;
  jsize ldvl_ls;
  jdouble* vr_ll;
  jint* ldvr_l;
  integer* ldvr_ll;
  jsize ldvr_ls;
  jdouble* work_ll;
  jint* lwork_l;
  integer* lwork_ll;
  jsize lwork_ls;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  jobvl_l = (*env)->GetPrimitiveArrayCritical(env, jobvl, NULL);
  jobvl_ls = (*env)->GetArrayLength(env, jobvl);
  jobvl_ll = malloc(sizeof(char)*jobvl_ls);
  for (i_loc=0; i_loc<jobvl_ls; ++i_loc) jobvl_ll[i_loc] = jobvl_l[i_loc];
  jobvr_l = (*env)->GetPrimitiveArrayCritical(env, jobvr, NULL);
  jobvr_ls = (*env)->GetArrayLength(env, jobvr);
  jobvr_ll = malloc(sizeof(char)*jobvr_ls);
  for (i_loc=0; i_loc<jobvr_ls; ++i_loc) jobvr_ll[i_loc] = jobvr_l[i_loc];
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  a_ll = (*env)->GetPrimitiveArrayCritical(env, a, NULL);
  lda_l = (*env)->GetPrimitiveArrayCritical(env, lda, NULL);
  lda_ls = (*env)->GetArrayLength(env, lda);
  lda_ll = malloc(sizeof(integer)*lda_ls);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_ll[i_loc] = lda_l[i_loc];
  wr_ll = (*env)->GetPrimitiveArrayCritical(env, wr, NULL);
  wi_ll = (*env)->GetPrimitiveArrayCritical(env, wi, NULL);
  vl_ll = (*env)->GetPrimitiveArrayCritical(env, vl, NULL);
  ldvl_l = (*env)->GetPrimitiveArrayCritical(env, ldvl, NULL);
  ldvl_ls = (*env)->GetArrayLength(env, ldvl);
  ldvl_ll = malloc(sizeof(integer)*ldvl_ls);
  for (i_loc=0; i_loc<ldvl_ls; ++i_loc) ldvl_ll[i_loc] = ldvl_l[i_loc];
  vr_ll = (*env)->GetPrimitiveArrayCritical(env, vr, NULL);
  ldvr_l = (*env)->GetPrimitiveArrayCritical(env, ldvr, NULL);
  ldvr_ls = (*env)->GetArrayLength(env, ldvr);
  ldvr_ll = malloc(sizeof(integer)*ldvr_ls);
  for (i_loc=0; i_loc<ldvr_ls; ++i_loc) ldvr_ll[i_loc] = ldvr_l[i_loc];
  work_ll = (*env)->GetPrimitiveArrayCritical(env, work, NULL);
  lwork_l = (*env)->GetPrimitiveArrayCritical(env, lwork, NULL);
  lwork_ls = (*env)->GetArrayLength(env, lwork);
  lwork_ll = malloc(sizeof(integer)*lwork_ls);
  for (i_loc=0; i_loc<lwork_ls; ++i_loc) lwork_ll[i_loc] = lwork_l[i_loc];
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dgeev_(jobvl_ll, jobvr_ll, n_ll, a_ll, lda_ll, wr_ll, wi_ll, vl_ll, ldvl_ll, vr_ll, ldvr_ll, work_ll, lwork_ll, info_ll);

  for (i_loc=0; i_loc<jobvl_ls; ++i_loc) jobvl_l[i_loc] = jobvl_ll[i_loc];
  free(jobvl_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, jobvl, jobvl_l, 0);
  for (i_loc=0; i_loc<jobvr_ls; ++i_loc) jobvr_l[i_loc] = jobvr_ll[i_loc];
  free(jobvr_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, jobvr, jobvr_l, 0);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, a, a_ll, 0);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_l[i_loc] = lda_ll[i_loc];
  free(lda_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, lda, lda_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, wr, wr_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, wi, wi_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, vl, vl_ll, 0);
  for (i_loc=0; i_loc<ldvl_ls; ++i_loc) ldvl_l[i_loc] = ldvl_ll[i_loc];
  free(ldvl_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldvl, ldvl_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, vr, vr_ll, 0);
  for (i_loc=0; i_loc<ldvr_ls; ++i_loc) ldvr_l[i_loc] = ldvr_ll[i_loc];
  free(ldvr_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldvr, ldvr_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, work, work_ll, 0);
  for (i_loc=0; i_loc<lwork_ls; ++i_loc) lwork_l[i_loc] = lwork_ll[i_loc];
  free(lwork_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, lwork, lwork_l, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_geevx
(JNIEnv *env, jclass clazz, jcharArray balanc, jcharArray jobvl, jcharArray jobvr, jcharArray sense, jintArray n, jdoubleArray a, jintArray lda, jdoubleArray wr, jdoubleArray wi, jdoubleArray vl, jintArray ldvl, jdoubleArray vr, jintArray ldvr, jintArray ilo, jintArray ihi, jdoubleArray scale, jdoubleArray abnrm, jdoubleArray rconde, jdoubleArray rcondv, jdoubleArray work, jintArray lwork, jintArray iwork, jintArray info) {
  int i_loc;
  jchar* balanc_l;
  char* balanc_ll;
  jsize balanc_ls;
  jchar* jobvl_l;
  char* jobvl_ll;
  jsize jobvl_ls;
  jchar* jobvr_l;
  char* jobvr_ll;
  jsize jobvr_ls;
  jchar* sense_l;
  char* sense_ll;
  jsize sense_ls;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jdouble* a_ll;
  jint* lda_l;
  integer* lda_ll;
  jsize lda_ls;
  jdouble* wr_ll;
  jdouble* wi_ll;
  jdouble* vl_ll;
  jint* ldvl_l;
  integer* ldvl_ll;
  jsize ldvl_ls;
  jdouble* vr_ll;
  jint* ldvr_l;
  integer* ldvr_ll;
  jsize ldvr_ls;
  jint* ilo_l;
  integer* ilo_ll;
  jsize ilo_ls;
  jint* ihi_l;
  integer* ihi_ll;
  jsize ihi_ls;
  jdouble* scale_ll;
  jdouble* abnrm_ll;
  jdouble* rconde_ll;
  jdouble* rcondv_ll;
  jdouble* work_ll;
  jint* lwork_l;
  integer* lwork_ll;
  jsize lwork_ls;
  jint* iwork_l;
  integer* iwork_ll;
  jsize iwork_ls;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  balanc_l = (*env)->GetPrimitiveArrayCritical(env, balanc, NULL);
  balanc_ls = (*env)->GetArrayLength(env, balanc);
  balanc_ll = malloc(sizeof(char)*balanc_ls);
  for (i_loc=0; i_loc<balanc_ls; ++i_loc) balanc_ll[i_loc] = balanc_l[i_loc];
  jobvl_l = (*env)->GetPrimitiveArrayCritical(env, jobvl, NULL);
  jobvl_ls = (*env)->GetArrayLength(env, jobvl);
  jobvl_ll = malloc(sizeof(char)*jobvl_ls);
  for (i_loc=0; i_loc<jobvl_ls; ++i_loc) jobvl_ll[i_loc] = jobvl_l[i_loc];
  jobvr_l = (*env)->GetPrimitiveArrayCritical(env, jobvr, NULL);
  jobvr_ls = (*env)->GetArrayLength(env, jobvr);
  jobvr_ll = malloc(sizeof(char)*jobvr_ls);
  for (i_loc=0; i_loc<jobvr_ls; ++i_loc) jobvr_ll[i_loc] = jobvr_l[i_loc];
  sense_l = (*env)->GetPrimitiveArrayCritical(env, sense, NULL);
  sense_ls = (*env)->GetArrayLength(env, sense);
  sense_ll = malloc(sizeof(char)*sense_ls);
  for (i_loc=0; i_loc<sense_ls; ++i_loc) sense_ll[i_loc] = sense_l[i_loc];
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  a_ll = (*env)->GetPrimitiveArrayCritical(env, a, NULL);
  lda_l = (*env)->GetPrimitiveArrayCritical(env, lda, NULL);
  lda_ls = (*env)->GetArrayLength(env, lda);
  lda_ll = malloc(sizeof(integer)*lda_ls);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_ll[i_loc] = lda_l[i_loc];
  wr_ll = (*env)->GetPrimitiveArrayCritical(env, wr, NULL);
  wi_ll = (*env)->GetPrimitiveArrayCritical(env, wi, NULL);
  vl_ll = (*env)->GetPrimitiveArrayCritical(env, vl, NULL);
  ldvl_l = (*env)->GetPrimitiveArrayCritical(env, ldvl, NULL);
  ldvl_ls = (*env)->GetArrayLength(env, ldvl);
  ldvl_ll = malloc(sizeof(integer)*ldvl_ls);
  for (i_loc=0; i_loc<ldvl_ls; ++i_loc) ldvl_ll[i_loc] = ldvl_l[i_loc];
  vr_ll = (*env)->GetPrimitiveArrayCritical(env, vr, NULL);
  ldvr_l = (*env)->GetPrimitiveArrayCritical(env, ldvr, NULL);
  ldvr_ls = (*env)->GetArrayLength(env, ldvr);
  ldvr_ll = malloc(sizeof(integer)*ldvr_ls);
  for (i_loc=0; i_loc<ldvr_ls; ++i_loc) ldvr_ll[i_loc] = ldvr_l[i_loc];
  ilo_l = (*env)->GetPrimitiveArrayCritical(env, ilo, NULL);
  ilo_ls = (*env)->GetArrayLength(env, ilo);
  ilo_ll = malloc(sizeof(integer)*ilo_ls);
  for (i_loc=0; i_loc<ilo_ls; ++i_loc) ilo_ll[i_loc] = ilo_l[i_loc];
  ihi_l = (*env)->GetPrimitiveArrayCritical(env, ihi, NULL);
  ihi_ls = (*env)->GetArrayLength(env, ihi);
  ihi_ll = malloc(sizeof(integer)*ihi_ls);
  for (i_loc=0; i_loc<ihi_ls; ++i_loc) ihi_ll[i_loc] = ihi_l[i_loc];
  scale_ll = (*env)->GetPrimitiveArrayCritical(env, scale, NULL);
  abnrm_ll = (*env)->GetPrimitiveArrayCritical(env, abnrm, NULL);
  rconde_ll = (*env)->GetPrimitiveArrayCritical(env, rconde, NULL);
  rcondv_ll = (*env)->GetPrimitiveArrayCritical(env, rcondv, NULL);
  work_ll = (*env)->GetPrimitiveArrayCritical(env, work, NULL);
  lwork_l = (*env)->GetPrimitiveArrayCritical(env, lwork, NULL);
  lwork_ls = (*env)->GetArrayLength(env, lwork);
  lwork_ll = malloc(sizeof(integer)*lwork_ls);
  for (i_loc=0; i_loc<lwork_ls; ++i_loc) lwork_ll[i_loc] = lwork_l[i_loc];
  iwork_l = (*env)->GetPrimitiveArrayCritical(env, iwork, NULL);
  iwork_ls = (*env)->GetArrayLength(env, iwork);
  iwork_ll = malloc(sizeof(integer)*iwork_ls);
  for (i_loc=0; i_loc<iwork_ls; ++i_loc) iwork_ll[i_loc] = iwork_l[i_loc];
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dgeevx_(balanc_ll, jobvl_ll, jobvr_ll, sense_ll, n_ll, a_ll, lda_ll, wr_ll, wi_ll, vl_ll, ldvl_ll, vr_ll, ldvr_ll, ilo_ll, ihi_ll, scale_ll, abnrm_ll, rconde_ll, rcondv_ll, work_ll, lwork_ll, iwork_ll, info_ll);

  for (i_loc=0; i_loc<balanc_ls; ++i_loc) balanc_l[i_loc] = balanc_ll[i_loc];
  free(balanc_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, balanc, balanc_l, 0);
  for (i_loc=0; i_loc<jobvl_ls; ++i_loc) jobvl_l[i_loc] = jobvl_ll[i_loc];
  free(jobvl_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, jobvl, jobvl_l, 0);
  for (i_loc=0; i_loc<jobvr_ls; ++i_loc) jobvr_l[i_loc] = jobvr_ll[i_loc];
  free(jobvr_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, jobvr, jobvr_l, 0);
  for (i_loc=0; i_loc<sense_ls; ++i_loc) sense_l[i_loc] = sense_ll[i_loc];
  free(sense_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, sense, sense_l, 0);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, a, a_ll, 0);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_l[i_loc] = lda_ll[i_loc];
  free(lda_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, lda, lda_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, wr, wr_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, wi, wi_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, vl, vl_ll, 0);
  for (i_loc=0; i_loc<ldvl_ls; ++i_loc) ldvl_l[i_loc] = ldvl_ll[i_loc];
  free(ldvl_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldvl, ldvl_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, vr, vr_ll, 0);
  for (i_loc=0; i_loc<ldvr_ls; ++i_loc) ldvr_l[i_loc] = ldvr_ll[i_loc];
  free(ldvr_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldvr, ldvr_l, 0);
  for (i_loc=0; i_loc<ilo_ls; ++i_loc) ilo_l[i_loc] = ilo_ll[i_loc];
  free(ilo_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ilo, ilo_l, 0);
  for (i_loc=0; i_loc<ihi_ls; ++i_loc) ihi_l[i_loc] = ihi_ll[i_loc];
  free(ihi_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ihi, ihi_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, scale, scale_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, abnrm, abnrm_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, rconde, rconde_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, rcondv, rcondv_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, work, work_ll, 0);
  for (i_loc=0; i_loc<lwork_ls; ++i_loc) lwork_l[i_loc] = lwork_ll[i_loc];
  free(lwork_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, lwork, lwork_l, 0);
  for (i_loc=0; i_loc<iwork_ls; ++i_loc) iwork_l[i_loc] = iwork_ll[i_loc];
  free(iwork_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, iwork, iwork_l, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_gegs
(JNIEnv *env, jclass clazz, jcharArray jobvsl, jcharArray jobvsr, jintArray n, jdoubleArray a, jintArray lda, jdoubleArray b, jintArray ldb, jdoubleArray alphar, jdoubleArray alphai, jdoubleArray beta, jdoubleArray vsl, jintArray ldvsl, jdoubleArray vsr, jintArray ldvsr, jdoubleArray work, jintArray lwork, jintArray info) {
  int i_loc;
  jchar* jobvsl_l;
  char* jobvsl_ll;
  jsize jobvsl_ls;
  jchar* jobvsr_l;
  char* jobvsr_ll;
  jsize jobvsr_ls;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jdouble* a_ll;
  jint* lda_l;
  integer* lda_ll;
  jsize lda_ls;
  jdouble* b_ll;
  jint* ldb_l;
  integer* ldb_ll;
  jsize ldb_ls;
  jdouble* alphar_ll;
  jdouble* alphai_ll;
  jdouble* beta_ll;
  jdouble* vsl_ll;
  jint* ldvsl_l;
  integer* ldvsl_ll;
  jsize ldvsl_ls;
  jdouble* vsr_ll;
  jint* ldvsr_l;
  integer* ldvsr_ll;
  jsize ldvsr_ls;
  jdouble* work_ll;
  jint* lwork_l;
  integer* lwork_ll;
  jsize lwork_ls;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  jobvsl_l = (*env)->GetPrimitiveArrayCritical(env, jobvsl, NULL);
  jobvsl_ls = (*env)->GetArrayLength(env, jobvsl);
  jobvsl_ll = malloc(sizeof(char)*jobvsl_ls);
  for (i_loc=0; i_loc<jobvsl_ls; ++i_loc) jobvsl_ll[i_loc] = jobvsl_l[i_loc];
  jobvsr_l = (*env)->GetPrimitiveArrayCritical(env, jobvsr, NULL);
  jobvsr_ls = (*env)->GetArrayLength(env, jobvsr);
  jobvsr_ll = malloc(sizeof(char)*jobvsr_ls);
  for (i_loc=0; i_loc<jobvsr_ls; ++i_loc) jobvsr_ll[i_loc] = jobvsr_l[i_loc];
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  a_ll = (*env)->GetPrimitiveArrayCritical(env, a, NULL);
  lda_l = (*env)->GetPrimitiveArrayCritical(env, lda, NULL);
  lda_ls = (*env)->GetArrayLength(env, lda);
  lda_ll = malloc(sizeof(integer)*lda_ls);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_ll[i_loc] = lda_l[i_loc];
  b_ll = (*env)->GetPrimitiveArrayCritical(env, b, NULL);
  ldb_l = (*env)->GetPrimitiveArrayCritical(env, ldb, NULL);
  ldb_ls = (*env)->GetArrayLength(env, ldb);
  ldb_ll = malloc(sizeof(integer)*ldb_ls);
  for (i_loc=0; i_loc<ldb_ls; ++i_loc) ldb_ll[i_loc] = ldb_l[i_loc];
  alphar_ll = (*env)->GetPrimitiveArrayCritical(env, alphar, NULL);
  alphai_ll = (*env)->GetPrimitiveArrayCritical(env, alphai, NULL);
  beta_ll = (*env)->GetPrimitiveArrayCritical(env, beta, NULL);
  vsl_ll = (*env)->GetPrimitiveArrayCritical(env, vsl, NULL);
  ldvsl_l = (*env)->GetPrimitiveArrayCritical(env, ldvsl, NULL);
  ldvsl_ls = (*env)->GetArrayLength(env, ldvsl);
  ldvsl_ll = malloc(sizeof(integer)*ldvsl_ls);
  for (i_loc=0; i_loc<ldvsl_ls; ++i_loc) ldvsl_ll[i_loc] = ldvsl_l[i_loc];
  vsr_ll = (*env)->GetPrimitiveArrayCritical(env, vsr, NULL);
  ldvsr_l = (*env)->GetPrimitiveArrayCritical(env, ldvsr, NULL);
  ldvsr_ls = (*env)->GetArrayLength(env, ldvsr);
  ldvsr_ll = malloc(sizeof(integer)*ldvsr_ls);
  for (i_loc=0; i_loc<ldvsr_ls; ++i_loc) ldvsr_ll[i_loc] = ldvsr_l[i_loc];
  work_ll = (*env)->GetPrimitiveArrayCritical(env, work, NULL);
  lwork_l = (*env)->GetPrimitiveArrayCritical(env, lwork, NULL);
  lwork_ls = (*env)->GetArrayLength(env, lwork);
  lwork_ll = malloc(sizeof(integer)*lwork_ls);
  for (i_loc=0; i_loc<lwork_ls; ++i_loc) lwork_ll[i_loc] = lwork_l[i_loc];
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dgegs_(jobvsl_ll, jobvsr_ll, n_ll, a_ll, lda_ll, b_ll, ldb_ll, alphar_ll, alphai_ll, beta_ll, vsl_ll, ldvsl_ll, vsr_ll, ldvsr_ll, work_ll, lwork_ll, info_ll);

  for (i_loc=0; i_loc<jobvsl_ls; ++i_loc) jobvsl_l[i_loc] = jobvsl_ll[i_loc];
  free(jobvsl_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, jobvsl, jobvsl_l, 0);
  for (i_loc=0; i_loc<jobvsr_ls; ++i_loc) jobvsr_l[i_loc] = jobvsr_ll[i_loc];
  free(jobvsr_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, jobvsr, jobvsr_l, 0);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, a, a_ll, 0);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_l[i_loc] = lda_ll[i_loc];
  free(lda_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, lda, lda_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, b, b_ll, 0);
  for (i_loc=0; i_loc<ldb_ls; ++i_loc) ldb_l[i_loc] = ldb_ll[i_loc];
  free(ldb_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldb, ldb_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, alphar, alphar_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, alphai, alphai_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, beta, beta_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, vsl, vsl_ll, 0);
  for (i_loc=0; i_loc<ldvsl_ls; ++i_loc) ldvsl_l[i_loc] = ldvsl_ll[i_loc];
  free(ldvsl_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldvsl, ldvsl_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, vsr, vsr_ll, 0);
  for (i_loc=0; i_loc<ldvsr_ls; ++i_loc) ldvsr_l[i_loc] = ldvsr_ll[i_loc];
  free(ldvsr_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldvsr, ldvsr_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, work, work_ll, 0);
  for (i_loc=0; i_loc<lwork_ls; ++i_loc) lwork_l[i_loc] = lwork_ll[i_loc];
  free(lwork_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, lwork, lwork_l, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_gegv
(JNIEnv *env, jclass clazz, jcharArray jobvl, jcharArray jobvr, jintArray n, jdoubleArray a, jintArray lda, jdoubleArray b, jintArray ldb, jdoubleArray alphar, jdoubleArray alphai, jdoubleArray beta, jdoubleArray vl, jintArray ldvl, jdoubleArray vr, jintArray ldvr, jdoubleArray work, jintArray lwork, jintArray info) {
  int i_loc;
  jchar* jobvl_l;
  char* jobvl_ll;
  jsize jobvl_ls;
  jchar* jobvr_l;
  char* jobvr_ll;
  jsize jobvr_ls;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jdouble* a_ll;
  jint* lda_l;
  integer* lda_ll;
  jsize lda_ls;
  jdouble* b_ll;
  jint* ldb_l;
  integer* ldb_ll;
  jsize ldb_ls;
  jdouble* alphar_ll;
  jdouble* alphai_ll;
  jdouble* beta_ll;
  jdouble* vl_ll;
  jint* ldvl_l;
  integer* ldvl_ll;
  jsize ldvl_ls;
  jdouble* vr_ll;
  jint* ldvr_l;
  integer* ldvr_ll;
  jsize ldvr_ls;
  jdouble* work_ll;
  jint* lwork_l;
  integer* lwork_ll;
  jsize lwork_ls;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  jobvl_l = (*env)->GetPrimitiveArrayCritical(env, jobvl, NULL);
  jobvl_ls = (*env)->GetArrayLength(env, jobvl);
  jobvl_ll = malloc(sizeof(char)*jobvl_ls);
  for (i_loc=0; i_loc<jobvl_ls; ++i_loc) jobvl_ll[i_loc] = jobvl_l[i_loc];
  jobvr_l = (*env)->GetPrimitiveArrayCritical(env, jobvr, NULL);
  jobvr_ls = (*env)->GetArrayLength(env, jobvr);
  jobvr_ll = malloc(sizeof(char)*jobvr_ls);
  for (i_loc=0; i_loc<jobvr_ls; ++i_loc) jobvr_ll[i_loc] = jobvr_l[i_loc];
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  a_ll = (*env)->GetPrimitiveArrayCritical(env, a, NULL);
  lda_l = (*env)->GetPrimitiveArrayCritical(env, lda, NULL);
  lda_ls = (*env)->GetArrayLength(env, lda);
  lda_ll = malloc(sizeof(integer)*lda_ls);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_ll[i_loc] = lda_l[i_loc];
  b_ll = (*env)->GetPrimitiveArrayCritical(env, b, NULL);
  ldb_l = (*env)->GetPrimitiveArrayCritical(env, ldb, NULL);
  ldb_ls = (*env)->GetArrayLength(env, ldb);
  ldb_ll = malloc(sizeof(integer)*ldb_ls);
  for (i_loc=0; i_loc<ldb_ls; ++i_loc) ldb_ll[i_loc] = ldb_l[i_loc];
  alphar_ll = (*env)->GetPrimitiveArrayCritical(env, alphar, NULL);
  alphai_ll = (*env)->GetPrimitiveArrayCritical(env, alphai, NULL);
  beta_ll = (*env)->GetPrimitiveArrayCritical(env, beta, NULL);
  vl_ll = (*env)->GetPrimitiveArrayCritical(env, vl, NULL);
  ldvl_l = (*env)->GetPrimitiveArrayCritical(env, ldvl, NULL);
  ldvl_ls = (*env)->GetArrayLength(env, ldvl);
  ldvl_ll = malloc(sizeof(integer)*ldvl_ls);
  for (i_loc=0; i_loc<ldvl_ls; ++i_loc) ldvl_ll[i_loc] = ldvl_l[i_loc];
  vr_ll = (*env)->GetPrimitiveArrayCritical(env, vr, NULL);
  ldvr_l = (*env)->GetPrimitiveArrayCritical(env, ldvr, NULL);
  ldvr_ls = (*env)->GetArrayLength(env, ldvr);
  ldvr_ll = malloc(sizeof(integer)*ldvr_ls);
  for (i_loc=0; i_loc<ldvr_ls; ++i_loc) ldvr_ll[i_loc] = ldvr_l[i_loc];
  work_ll = (*env)->GetPrimitiveArrayCritical(env, work, NULL);
  lwork_l = (*env)->GetPrimitiveArrayCritical(env, lwork, NULL);
  lwork_ls = (*env)->GetArrayLength(env, lwork);
  lwork_ll = malloc(sizeof(integer)*lwork_ls);
  for (i_loc=0; i_loc<lwork_ls; ++i_loc) lwork_ll[i_loc] = lwork_l[i_loc];
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dgegv_(jobvl_ll, jobvr_ll, n_ll, a_ll, lda_ll, b_ll, ldb_ll, alphar_ll, alphai_ll, beta_ll, vl_ll, ldvl_ll, vr_ll, ldvr_ll, work_ll, lwork_ll, info_ll);

  for (i_loc=0; i_loc<jobvl_ls; ++i_loc) jobvl_l[i_loc] = jobvl_ll[i_loc];
  free(jobvl_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, jobvl, jobvl_l, 0);
  for (i_loc=0; i_loc<jobvr_ls; ++i_loc) jobvr_l[i_loc] = jobvr_ll[i_loc];
  free(jobvr_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, jobvr, jobvr_l, 0);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, a, a_ll, 0);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_l[i_loc] = lda_ll[i_loc];
  free(lda_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, lda, lda_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, b, b_ll, 0);
  for (i_loc=0; i_loc<ldb_ls; ++i_loc) ldb_l[i_loc] = ldb_ll[i_loc];
  free(ldb_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldb, ldb_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, alphar, alphar_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, alphai, alphai_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, beta, beta_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, vl, vl_ll, 0);
  for (i_loc=0; i_loc<ldvl_ls; ++i_loc) ldvl_l[i_loc] = ldvl_ll[i_loc];
  free(ldvl_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldvl, ldvl_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, vr, vr_ll, 0);
  for (i_loc=0; i_loc<ldvr_ls; ++i_loc) ldvr_l[i_loc] = ldvr_ll[i_loc];
  free(ldvr_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldvr, ldvr_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, work, work_ll, 0);
  for (i_loc=0; i_loc<lwork_ls; ++i_loc) lwork_l[i_loc] = lwork_ll[i_loc];
  free(lwork_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, lwork, lwork_l, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_gehd2
(JNIEnv *env, jclass clazz, jintArray n, jintArray ilo, jintArray ihi, jdoubleArray a, jintArray lda, jdoubleArray tau, jdoubleArray work, jintArray info) {
  int i_loc;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jint* ilo_l;
  integer* ilo_ll;
  jsize ilo_ls;
  jint* ihi_l;
  integer* ihi_ll;
  jsize ihi_ls;
  jdouble* a_ll;
  jint* lda_l;
  integer* lda_ll;
  jsize lda_ls;
  jdouble* tau_ll;
  jdouble* work_ll;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  ilo_l = (*env)->GetPrimitiveArrayCritical(env, ilo, NULL);
  ilo_ls = (*env)->GetArrayLength(env, ilo);
  ilo_ll = malloc(sizeof(integer)*ilo_ls);
  for (i_loc=0; i_loc<ilo_ls; ++i_loc) ilo_ll[i_loc] = ilo_l[i_loc];
  ihi_l = (*env)->GetPrimitiveArrayCritical(env, ihi, NULL);
  ihi_ls = (*env)->GetArrayLength(env, ihi);
  ihi_ll = malloc(sizeof(integer)*ihi_ls);
  for (i_loc=0; i_loc<ihi_ls; ++i_loc) ihi_ll[i_loc] = ihi_l[i_loc];
  a_ll = (*env)->GetPrimitiveArrayCritical(env, a, NULL);
  lda_l = (*env)->GetPrimitiveArrayCritical(env, lda, NULL);
  lda_ls = (*env)->GetArrayLength(env, lda);
  lda_ll = malloc(sizeof(integer)*lda_ls);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_ll[i_loc] = lda_l[i_loc];
  tau_ll = (*env)->GetPrimitiveArrayCritical(env, tau, NULL);
  work_ll = (*env)->GetPrimitiveArrayCritical(env, work, NULL);
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dgehd2_(n_ll, ilo_ll, ihi_ll, a_ll, lda_ll, tau_ll, work_ll, info_ll);

  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  for (i_loc=0; i_loc<ilo_ls; ++i_loc) ilo_l[i_loc] = ilo_ll[i_loc];
  free(ilo_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ilo, ilo_l, 0);
  for (i_loc=0; i_loc<ihi_ls; ++i_loc) ihi_l[i_loc] = ihi_ll[i_loc];
  free(ihi_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ihi, ihi_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, a, a_ll, 0);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_l[i_loc] = lda_ll[i_loc];
  free(lda_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, lda, lda_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, tau, tau_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, work, work_ll, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_gehrd
(JNIEnv *env, jclass clazz, jintArray n, jintArray ilo, jintArray ihi, jdoubleArray a, jintArray lda, jdoubleArray tau, jdoubleArray work, jintArray lwork, jintArray info) {
  int i_loc;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jint* ilo_l;
  integer* ilo_ll;
  jsize ilo_ls;
  jint* ihi_l;
  integer* ihi_ll;
  jsize ihi_ls;
  jdouble* a_ll;
  jint* lda_l;
  integer* lda_ll;
  jsize lda_ls;
  jdouble* tau_ll;
  jdouble* work_ll;
  jint* lwork_l;
  integer* lwork_ll;
  jsize lwork_ls;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  ilo_l = (*env)->GetPrimitiveArrayCritical(env, ilo, NULL);
  ilo_ls = (*env)->GetArrayLength(env, ilo);
  ilo_ll = malloc(sizeof(integer)*ilo_ls);
  for (i_loc=0; i_loc<ilo_ls; ++i_loc) ilo_ll[i_loc] = ilo_l[i_loc];
  ihi_l = (*env)->GetPrimitiveArrayCritical(env, ihi, NULL);
  ihi_ls = (*env)->GetArrayLength(env, ihi);
  ihi_ll = malloc(sizeof(integer)*ihi_ls);
  for (i_loc=0; i_loc<ihi_ls; ++i_loc) ihi_ll[i_loc] = ihi_l[i_loc];
  a_ll = (*env)->GetPrimitiveArrayCritical(env, a, NULL);
  lda_l = (*env)->GetPrimitiveArrayCritical(env, lda, NULL);
  lda_ls = (*env)->GetArrayLength(env, lda);
  lda_ll = malloc(sizeof(integer)*lda_ls);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_ll[i_loc] = lda_l[i_loc];
  tau_ll = (*env)->GetPrimitiveArrayCritical(env, tau, NULL);
  work_ll = (*env)->GetPrimitiveArrayCritical(env, work, NULL);
  lwork_l = (*env)->GetPrimitiveArrayCritical(env, lwork, NULL);
  lwork_ls = (*env)->GetArrayLength(env, lwork);
  lwork_ll = malloc(sizeof(integer)*lwork_ls);
  for (i_loc=0; i_loc<lwork_ls; ++i_loc) lwork_ll[i_loc] = lwork_l[i_loc];
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dgehrd_(n_ll, ilo_ll, ihi_ll, a_ll, lda_ll, tau_ll, work_ll, lwork_ll, info_ll);

  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  for (i_loc=0; i_loc<ilo_ls; ++i_loc) ilo_l[i_loc] = ilo_ll[i_loc];
  free(ilo_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ilo, ilo_l, 0);
  for (i_loc=0; i_loc<ihi_ls; ++i_loc) ihi_l[i_loc] = ihi_ll[i_loc];
  free(ihi_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ihi, ihi_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, a, a_ll, 0);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_l[i_loc] = lda_ll[i_loc];
  free(lda_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, lda, lda_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, tau, tau_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, work, work_ll, 0);
  for (i_loc=0; i_loc<lwork_ls; ++i_loc) lwork_l[i_loc] = lwork_ll[i_loc];
  free(lwork_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, lwork, lwork_l, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_gelq2
(JNIEnv *env, jclass clazz, jintArray m, jintArray n, jdoubleArray a, jintArray lda, jdoubleArray tau, jdoubleArray work, jintArray info) {
  int i_loc;
  jint* m_l;
  integer* m_ll;
  jsize m_ls;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jdouble* a_ll;
  jint* lda_l;
  integer* lda_ll;
  jsize lda_ls;
  jdouble* tau_ll;
  jdouble* work_ll;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  m_l = (*env)->GetPrimitiveArrayCritical(env, m, NULL);
  m_ls = (*env)->GetArrayLength(env, m);
  m_ll = malloc(sizeof(integer)*m_ls);
  for (i_loc=0; i_loc<m_ls; ++i_loc) m_ll[i_loc] = m_l[i_loc];
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  a_ll = (*env)->GetPrimitiveArrayCritical(env, a, NULL);
  lda_l = (*env)->GetPrimitiveArrayCritical(env, lda, NULL);
  lda_ls = (*env)->GetArrayLength(env, lda);
  lda_ll = malloc(sizeof(integer)*lda_ls);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_ll[i_loc] = lda_l[i_loc];
  tau_ll = (*env)->GetPrimitiveArrayCritical(env, tau, NULL);
  work_ll = (*env)->GetPrimitiveArrayCritical(env, work, NULL);
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dgelq2_(m_ll, n_ll, a_ll, lda_ll, tau_ll, work_ll, info_ll);

  for (i_loc=0; i_loc<m_ls; ++i_loc) m_l[i_loc] = m_ll[i_loc];
  free(m_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, m, m_l, 0);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, a, a_ll, 0);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_l[i_loc] = lda_ll[i_loc];
  free(lda_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, lda, lda_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, tau, tau_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, work, work_ll, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_gelqf
(JNIEnv *env, jclass clazz, jintArray m, jintArray n, jdoubleArray a, jintArray lda, jdoubleArray tau, jdoubleArray work, jintArray lwork, jintArray info) {
  int i_loc;
  jint* m_l;
  integer* m_ll;
  jsize m_ls;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jdouble* a_ll;
  jint* lda_l;
  integer* lda_ll;
  jsize lda_ls;
  jdouble* tau_ll;
  jdouble* work_ll;
  jint* lwork_l;
  integer* lwork_ll;
  jsize lwork_ls;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  m_l = (*env)->GetPrimitiveArrayCritical(env, m, NULL);
  m_ls = (*env)->GetArrayLength(env, m);
  m_ll = malloc(sizeof(integer)*m_ls);
  for (i_loc=0; i_loc<m_ls; ++i_loc) m_ll[i_loc] = m_l[i_loc];
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  a_ll = (*env)->GetPrimitiveArrayCritical(env, a, NULL);
  lda_l = (*env)->GetPrimitiveArrayCritical(env, lda, NULL);
  lda_ls = (*env)->GetArrayLength(env, lda);
  lda_ll = malloc(sizeof(integer)*lda_ls);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_ll[i_loc] = lda_l[i_loc];
  tau_ll = (*env)->GetPrimitiveArrayCritical(env, tau, NULL);
  work_ll = (*env)->GetPrimitiveArrayCritical(env, work, NULL);
  lwork_l = (*env)->GetPrimitiveArrayCritical(env, lwork, NULL);
  lwork_ls = (*env)->GetArrayLength(env, lwork);
  lwork_ll = malloc(sizeof(integer)*lwork_ls);
  for (i_loc=0; i_loc<lwork_ls; ++i_loc) lwork_ll[i_loc] = lwork_l[i_loc];
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dgelqf_(m_ll, n_ll, a_ll, lda_ll, tau_ll, work_ll, lwork_ll, info_ll);

  for (i_loc=0; i_loc<m_ls; ++i_loc) m_l[i_loc] = m_ll[i_loc];
  free(m_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, m, m_l, 0);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, a, a_ll, 0);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_l[i_loc] = lda_ll[i_loc];
  free(lda_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, lda, lda_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, tau, tau_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, work, work_ll, 0);
  for (i_loc=0; i_loc<lwork_ls; ++i_loc) lwork_l[i_loc] = lwork_ll[i_loc];
  free(lwork_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, lwork, lwork_l, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_gels
(JNIEnv *env, jclass clazz, jcharArray trans, jintArray m, jintArray n, jintArray nrhs, jdoubleArray a, jintArray lda, jdoubleArray b, jintArray ldb, jdoubleArray work, jintArray lwork, jintArray info) {
  int i_loc;
  jchar* trans_l;
  char* trans_ll;
  jsize trans_ls;
  jint* m_l;
  integer* m_ll;
  jsize m_ls;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jint* nrhs_l;
  integer* nrhs_ll;
  jsize nrhs_ls;
  jdouble* a_ll;
  jint* lda_l;
  integer* lda_ll;
  jsize lda_ls;
  jdouble* b_ll;
  jint* ldb_l;
  integer* ldb_ll;
  jsize ldb_ls;
  jdouble* work_ll;
  jint* lwork_l;
  integer* lwork_ll;
  jsize lwork_ls;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  trans_l = (*env)->GetPrimitiveArrayCritical(env, trans, NULL);
  trans_ls = (*env)->GetArrayLength(env, trans);
  trans_ll = malloc(sizeof(char)*trans_ls);
  for (i_loc=0; i_loc<trans_ls; ++i_loc) trans_ll[i_loc] = trans_l[i_loc];
  m_l = (*env)->GetPrimitiveArrayCritical(env, m, NULL);
  m_ls = (*env)->GetArrayLength(env, m);
  m_ll = malloc(sizeof(integer)*m_ls);
  for (i_loc=0; i_loc<m_ls; ++i_loc) m_ll[i_loc] = m_l[i_loc];
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  nrhs_l = (*env)->GetPrimitiveArrayCritical(env, nrhs, NULL);
  nrhs_ls = (*env)->GetArrayLength(env, nrhs);
  nrhs_ll = malloc(sizeof(integer)*nrhs_ls);
  for (i_loc=0; i_loc<nrhs_ls; ++i_loc) nrhs_ll[i_loc] = nrhs_l[i_loc];
  a_ll = (*env)->GetPrimitiveArrayCritical(env, a, NULL);
  lda_l = (*env)->GetPrimitiveArrayCritical(env, lda, NULL);
  lda_ls = (*env)->GetArrayLength(env, lda);
  lda_ll = malloc(sizeof(integer)*lda_ls);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_ll[i_loc] = lda_l[i_loc];
  b_ll = (*env)->GetPrimitiveArrayCritical(env, b, NULL);
  ldb_l = (*env)->GetPrimitiveArrayCritical(env, ldb, NULL);
  ldb_ls = (*env)->GetArrayLength(env, ldb);
  ldb_ll = malloc(sizeof(integer)*ldb_ls);
  for (i_loc=0; i_loc<ldb_ls; ++i_loc) ldb_ll[i_loc] = ldb_l[i_loc];
  work_ll = (*env)->GetPrimitiveArrayCritical(env, work, NULL);
  lwork_l = (*env)->GetPrimitiveArrayCritical(env, lwork, NULL);
  lwork_ls = (*env)->GetArrayLength(env, lwork);
  lwork_ll = malloc(sizeof(integer)*lwork_ls);
  for (i_loc=0; i_loc<lwork_ls; ++i_loc) lwork_ll[i_loc] = lwork_l[i_loc];
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dgels_(trans_ll, m_ll, n_ll, nrhs_ll, a_ll, lda_ll, b_ll, ldb_ll, work_ll, lwork_ll, info_ll);

  for (i_loc=0; i_loc<trans_ls; ++i_loc) trans_l[i_loc] = trans_ll[i_loc];
  free(trans_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, trans, trans_l, 0);
  for (i_loc=0; i_loc<m_ls; ++i_loc) m_l[i_loc] = m_ll[i_loc];
  free(m_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, m, m_l, 0);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  for (i_loc=0; i_loc<nrhs_ls; ++i_loc) nrhs_l[i_loc] = nrhs_ll[i_loc];
  free(nrhs_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, nrhs, nrhs_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, a, a_ll, 0);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_l[i_loc] = lda_ll[i_loc];
  free(lda_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, lda, lda_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, b, b_ll, 0);
  for (i_loc=0; i_loc<ldb_ls; ++i_loc) ldb_l[i_loc] = ldb_ll[i_loc];
  free(ldb_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldb, ldb_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, work, work_ll, 0);
  for (i_loc=0; i_loc<lwork_ls; ++i_loc) lwork_l[i_loc] = lwork_ll[i_loc];
  free(lwork_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, lwork, lwork_l, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_gelsd
(JNIEnv *env, jclass clazz, jintArray m, jintArray n, jintArray nrhs, jdoubleArray a, jintArray lda, jdoubleArray b, jintArray ldb, jdoubleArray s, jdoubleArray rcond, jintArray rank, jdoubleArray work, jintArray lwork, jintArray iwork, jintArray info) {
  int i_loc;
  jint* m_l;
  integer* m_ll;
  jsize m_ls;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jint* nrhs_l;
  integer* nrhs_ll;
  jsize nrhs_ls;
  jdouble* a_ll;
  jint* lda_l;
  integer* lda_ll;
  jsize lda_ls;
  jdouble* b_ll;
  jint* ldb_l;
  integer* ldb_ll;
  jsize ldb_ls;
  jdouble* s_ll;
  jdouble* rcond_ll;
  jint* rank_l;
  integer* rank_ll;
  jsize rank_ls;
  jdouble* work_ll;
  jint* lwork_l;
  integer* lwork_ll;
  jsize lwork_ls;
  jint* iwork_l;
  integer* iwork_ll;
  jsize iwork_ls;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  m_l = (*env)->GetPrimitiveArrayCritical(env, m, NULL);
  m_ls = (*env)->GetArrayLength(env, m);
  m_ll = malloc(sizeof(integer)*m_ls);
  for (i_loc=0; i_loc<m_ls; ++i_loc) m_ll[i_loc] = m_l[i_loc];
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  nrhs_l = (*env)->GetPrimitiveArrayCritical(env, nrhs, NULL);
  nrhs_ls = (*env)->GetArrayLength(env, nrhs);
  nrhs_ll = malloc(sizeof(integer)*nrhs_ls);
  for (i_loc=0; i_loc<nrhs_ls; ++i_loc) nrhs_ll[i_loc] = nrhs_l[i_loc];
  a_ll = (*env)->GetPrimitiveArrayCritical(env, a, NULL);
  lda_l = (*env)->GetPrimitiveArrayCritical(env, lda, NULL);
  lda_ls = (*env)->GetArrayLength(env, lda);
  lda_ll = malloc(sizeof(integer)*lda_ls);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_ll[i_loc] = lda_l[i_loc];
  b_ll = (*env)->GetPrimitiveArrayCritical(env, b, NULL);
  ldb_l = (*env)->GetPrimitiveArrayCritical(env, ldb, NULL);
  ldb_ls = (*env)->GetArrayLength(env, ldb);
  ldb_ll = malloc(sizeof(integer)*ldb_ls);
  for (i_loc=0; i_loc<ldb_ls; ++i_loc) ldb_ll[i_loc] = ldb_l[i_loc];
  s_ll = (*env)->GetPrimitiveArrayCritical(env, s, NULL);
  rcond_ll = (*env)->GetPrimitiveArrayCritical(env, rcond, NULL);
  rank_l = (*env)->GetPrimitiveArrayCritical(env, rank, NULL);
  rank_ls = (*env)->GetArrayLength(env, rank);
  rank_ll = malloc(sizeof(integer)*rank_ls);
  for (i_loc=0; i_loc<rank_ls; ++i_loc) rank_ll[i_loc] = rank_l[i_loc];
  work_ll = (*env)->GetPrimitiveArrayCritical(env, work, NULL);
  lwork_l = (*env)->GetPrimitiveArrayCritical(env, lwork, NULL);
  lwork_ls = (*env)->GetArrayLength(env, lwork);
  lwork_ll = malloc(sizeof(integer)*lwork_ls);
  for (i_loc=0; i_loc<lwork_ls; ++i_loc) lwork_ll[i_loc] = lwork_l[i_loc];
  iwork_l = (*env)->GetPrimitiveArrayCritical(env, iwork, NULL);
  iwork_ls = (*env)->GetArrayLength(env, iwork);
  iwork_ll = malloc(sizeof(integer)*iwork_ls);
  for (i_loc=0; i_loc<iwork_ls; ++i_loc) iwork_ll[i_loc] = iwork_l[i_loc];
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dgelsd_(m_ll, n_ll, nrhs_ll, a_ll, lda_ll, b_ll, ldb_ll, s_ll, rcond_ll, rank_ll, work_ll, lwork_ll, iwork_ll, info_ll);

  for (i_loc=0; i_loc<m_ls; ++i_loc) m_l[i_loc] = m_ll[i_loc];
  free(m_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, m, m_l, 0);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  for (i_loc=0; i_loc<nrhs_ls; ++i_loc) nrhs_l[i_loc] = nrhs_ll[i_loc];
  free(nrhs_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, nrhs, nrhs_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, a, a_ll, 0);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_l[i_loc] = lda_ll[i_loc];
  free(lda_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, lda, lda_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, b, b_ll, 0);
  for (i_loc=0; i_loc<ldb_ls; ++i_loc) ldb_l[i_loc] = ldb_ll[i_loc];
  free(ldb_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldb, ldb_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, s, s_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, rcond, rcond_ll, 0);
  for (i_loc=0; i_loc<rank_ls; ++i_loc) rank_l[i_loc] = rank_ll[i_loc];
  free(rank_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, rank, rank_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, work, work_ll, 0);
  for (i_loc=0; i_loc<lwork_ls; ++i_loc) lwork_l[i_loc] = lwork_ll[i_loc];
  free(lwork_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, lwork, lwork_l, 0);
  for (i_loc=0; i_loc<iwork_ls; ++i_loc) iwork_l[i_loc] = iwork_ll[i_loc];
  free(iwork_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, iwork, iwork_l, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_gelss
(JNIEnv *env, jclass clazz, jintArray m, jintArray n, jintArray nrhs, jdoubleArray a, jintArray lda, jdoubleArray b, jintArray ldb, jdoubleArray s, jdoubleArray rcond, jintArray rank, jdoubleArray work, jintArray lwork, jintArray info) {
  int i_loc;
  jint* m_l;
  integer* m_ll;
  jsize m_ls;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jint* nrhs_l;
  integer* nrhs_ll;
  jsize nrhs_ls;
  jdouble* a_ll;
  jint* lda_l;
  integer* lda_ll;
  jsize lda_ls;
  jdouble* b_ll;
  jint* ldb_l;
  integer* ldb_ll;
  jsize ldb_ls;
  jdouble* s_ll;
  jdouble* rcond_ll;
  jint* rank_l;
  integer* rank_ll;
  jsize rank_ls;
  jdouble* work_ll;
  jint* lwork_l;
  integer* lwork_ll;
  jsize lwork_ls;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  m_l = (*env)->GetPrimitiveArrayCritical(env, m, NULL);
  m_ls = (*env)->GetArrayLength(env, m);
  m_ll = malloc(sizeof(integer)*m_ls);
  for (i_loc=0; i_loc<m_ls; ++i_loc) m_ll[i_loc] = m_l[i_loc];
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  nrhs_l = (*env)->GetPrimitiveArrayCritical(env, nrhs, NULL);
  nrhs_ls = (*env)->GetArrayLength(env, nrhs);
  nrhs_ll = malloc(sizeof(integer)*nrhs_ls);
  for (i_loc=0; i_loc<nrhs_ls; ++i_loc) nrhs_ll[i_loc] = nrhs_l[i_loc];
  a_ll = (*env)->GetPrimitiveArrayCritical(env, a, NULL);
  lda_l = (*env)->GetPrimitiveArrayCritical(env, lda, NULL);
  lda_ls = (*env)->GetArrayLength(env, lda);
  lda_ll = malloc(sizeof(integer)*lda_ls);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_ll[i_loc] = lda_l[i_loc];
  b_ll = (*env)->GetPrimitiveArrayCritical(env, b, NULL);
  ldb_l = (*env)->GetPrimitiveArrayCritical(env, ldb, NULL);
  ldb_ls = (*env)->GetArrayLength(env, ldb);
  ldb_ll = malloc(sizeof(integer)*ldb_ls);
  for (i_loc=0; i_loc<ldb_ls; ++i_loc) ldb_ll[i_loc] = ldb_l[i_loc];
  s_ll = (*env)->GetPrimitiveArrayCritical(env, s, NULL);
  rcond_ll = (*env)->GetPrimitiveArrayCritical(env, rcond, NULL);
  rank_l = (*env)->GetPrimitiveArrayCritical(env, rank, NULL);
  rank_ls = (*env)->GetArrayLength(env, rank);
  rank_ll = malloc(sizeof(integer)*rank_ls);
  for (i_loc=0; i_loc<rank_ls; ++i_loc) rank_ll[i_loc] = rank_l[i_loc];
  work_ll = (*env)->GetPrimitiveArrayCritical(env, work, NULL);
  lwork_l = (*env)->GetPrimitiveArrayCritical(env, lwork, NULL);
  lwork_ls = (*env)->GetArrayLength(env, lwork);
  lwork_ll = malloc(sizeof(integer)*lwork_ls);
  for (i_loc=0; i_loc<lwork_ls; ++i_loc) lwork_ll[i_loc] = lwork_l[i_loc];
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dgelss_(m_ll, n_ll, nrhs_ll, a_ll, lda_ll, b_ll, ldb_ll, s_ll, rcond_ll, rank_ll, work_ll, lwork_ll, info_ll);

  for (i_loc=0; i_loc<m_ls; ++i_loc) m_l[i_loc] = m_ll[i_loc];
  free(m_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, m, m_l, 0);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  for (i_loc=0; i_loc<nrhs_ls; ++i_loc) nrhs_l[i_loc] = nrhs_ll[i_loc];
  free(nrhs_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, nrhs, nrhs_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, a, a_ll, 0);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_l[i_loc] = lda_ll[i_loc];
  free(lda_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, lda, lda_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, b, b_ll, 0);
  for (i_loc=0; i_loc<ldb_ls; ++i_loc) ldb_l[i_loc] = ldb_ll[i_loc];
  free(ldb_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldb, ldb_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, s, s_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, rcond, rcond_ll, 0);
  for (i_loc=0; i_loc<rank_ls; ++i_loc) rank_l[i_loc] = rank_ll[i_loc];
  free(rank_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, rank, rank_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, work, work_ll, 0);
  for (i_loc=0; i_loc<lwork_ls; ++i_loc) lwork_l[i_loc] = lwork_ll[i_loc];
  free(lwork_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, lwork, lwork_l, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_gelsx
(JNIEnv *env, jclass clazz, jintArray m, jintArray n, jintArray nrhs, jdoubleArray a, jintArray lda, jdoubleArray b, jintArray ldb, jintArray jpvt, jdoubleArray rcond, jintArray rank, jdoubleArray work, jintArray info) {
  int i_loc;
  jint* m_l;
  integer* m_ll;
  jsize m_ls;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jint* nrhs_l;
  integer* nrhs_ll;
  jsize nrhs_ls;
  jdouble* a_ll;
  jint* lda_l;
  integer* lda_ll;
  jsize lda_ls;
  jdouble* b_ll;
  jint* ldb_l;
  integer* ldb_ll;
  jsize ldb_ls;
  jint* jpvt_l;
  integer* jpvt_ll;
  jsize jpvt_ls;
  jdouble* rcond_ll;
  jint* rank_l;
  integer* rank_ll;
  jsize rank_ls;
  jdouble* work_ll;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  m_l = (*env)->GetPrimitiveArrayCritical(env, m, NULL);
  m_ls = (*env)->GetArrayLength(env, m);
  m_ll = malloc(sizeof(integer)*m_ls);
  for (i_loc=0; i_loc<m_ls; ++i_loc) m_ll[i_loc] = m_l[i_loc];
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  nrhs_l = (*env)->GetPrimitiveArrayCritical(env, nrhs, NULL);
  nrhs_ls = (*env)->GetArrayLength(env, nrhs);
  nrhs_ll = malloc(sizeof(integer)*nrhs_ls);
  for (i_loc=0; i_loc<nrhs_ls; ++i_loc) nrhs_ll[i_loc] = nrhs_l[i_loc];
  a_ll = (*env)->GetPrimitiveArrayCritical(env, a, NULL);
  lda_l = (*env)->GetPrimitiveArrayCritical(env, lda, NULL);
  lda_ls = (*env)->GetArrayLength(env, lda);
  lda_ll = malloc(sizeof(integer)*lda_ls);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_ll[i_loc] = lda_l[i_loc];
  b_ll = (*env)->GetPrimitiveArrayCritical(env, b, NULL);
  ldb_l = (*env)->GetPrimitiveArrayCritical(env, ldb, NULL);
  ldb_ls = (*env)->GetArrayLength(env, ldb);
  ldb_ll = malloc(sizeof(integer)*ldb_ls);
  for (i_loc=0; i_loc<ldb_ls; ++i_loc) ldb_ll[i_loc] = ldb_l[i_loc];
  jpvt_l = (*env)->GetPrimitiveArrayCritical(env, jpvt, NULL);
  jpvt_ls = (*env)->GetArrayLength(env, jpvt);
  jpvt_ll = malloc(sizeof(integer)*jpvt_ls);
  for (i_loc=0; i_loc<jpvt_ls; ++i_loc) jpvt_ll[i_loc] = jpvt_l[i_loc];
  rcond_ll = (*env)->GetPrimitiveArrayCritical(env, rcond, NULL);
  rank_l = (*env)->GetPrimitiveArrayCritical(env, rank, NULL);
  rank_ls = (*env)->GetArrayLength(env, rank);
  rank_ll = malloc(sizeof(integer)*rank_ls);
  for (i_loc=0; i_loc<rank_ls; ++i_loc) rank_ll[i_loc] = rank_l[i_loc];
  work_ll = (*env)->GetPrimitiveArrayCritical(env, work, NULL);
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dgelsx_(m_ll, n_ll, nrhs_ll, a_ll, lda_ll, b_ll, ldb_ll, jpvt_ll, rcond_ll, rank_ll, work_ll, info_ll);

  for (i_loc=0; i_loc<m_ls; ++i_loc) m_l[i_loc] = m_ll[i_loc];
  free(m_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, m, m_l, 0);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  for (i_loc=0; i_loc<nrhs_ls; ++i_loc) nrhs_l[i_loc] = nrhs_ll[i_loc];
  free(nrhs_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, nrhs, nrhs_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, a, a_ll, 0);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_l[i_loc] = lda_ll[i_loc];
  free(lda_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, lda, lda_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, b, b_ll, 0);
  for (i_loc=0; i_loc<ldb_ls; ++i_loc) ldb_l[i_loc] = ldb_ll[i_loc];
  free(ldb_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldb, ldb_l, 0);
  for (i_loc=0; i_loc<jpvt_ls; ++i_loc) jpvt_l[i_loc] = jpvt_ll[i_loc];
  free(jpvt_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, jpvt, jpvt_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, rcond, rcond_ll, 0);
  for (i_loc=0; i_loc<rank_ls; ++i_loc) rank_l[i_loc] = rank_ll[i_loc];
  free(rank_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, rank, rank_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, work, work_ll, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_gelsy
(JNIEnv *env, jclass clazz, jintArray m, jintArray n, jintArray nrhs, jdoubleArray a, jintArray lda, jdoubleArray b, jintArray ldb, jintArray jpvt, jdoubleArray rcond, jintArray rank, jdoubleArray work, jintArray lwork, jintArray info) {
  int i_loc;
  jint* m_l;
  integer* m_ll;
  jsize m_ls;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jint* nrhs_l;
  integer* nrhs_ll;
  jsize nrhs_ls;
  jdouble* a_ll;
  jint* lda_l;
  integer* lda_ll;
  jsize lda_ls;
  jdouble* b_ll;
  jint* ldb_l;
  integer* ldb_ll;
  jsize ldb_ls;
  jint* jpvt_l;
  integer* jpvt_ll;
  jsize jpvt_ls;
  jdouble* rcond_ll;
  jint* rank_l;
  integer* rank_ll;
  jsize rank_ls;
  jdouble* work_ll;
  jint* lwork_l;
  integer* lwork_ll;
  jsize lwork_ls;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  m_l = (*env)->GetPrimitiveArrayCritical(env, m, NULL);
  m_ls = (*env)->GetArrayLength(env, m);
  m_ll = malloc(sizeof(integer)*m_ls);
  for (i_loc=0; i_loc<m_ls; ++i_loc) m_ll[i_loc] = m_l[i_loc];
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  nrhs_l = (*env)->GetPrimitiveArrayCritical(env, nrhs, NULL);
  nrhs_ls = (*env)->GetArrayLength(env, nrhs);
  nrhs_ll = malloc(sizeof(integer)*nrhs_ls);
  for (i_loc=0; i_loc<nrhs_ls; ++i_loc) nrhs_ll[i_loc] = nrhs_l[i_loc];
  a_ll = (*env)->GetPrimitiveArrayCritical(env, a, NULL);
  lda_l = (*env)->GetPrimitiveArrayCritical(env, lda, NULL);
  lda_ls = (*env)->GetArrayLength(env, lda);
  lda_ll = malloc(sizeof(integer)*lda_ls);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_ll[i_loc] = lda_l[i_loc];
  b_ll = (*env)->GetPrimitiveArrayCritical(env, b, NULL);
  ldb_l = (*env)->GetPrimitiveArrayCritical(env, ldb, NULL);
  ldb_ls = (*env)->GetArrayLength(env, ldb);
  ldb_ll = malloc(sizeof(integer)*ldb_ls);
  for (i_loc=0; i_loc<ldb_ls; ++i_loc) ldb_ll[i_loc] = ldb_l[i_loc];
  jpvt_l = (*env)->GetPrimitiveArrayCritical(env, jpvt, NULL);
  jpvt_ls = (*env)->GetArrayLength(env, jpvt);
  jpvt_ll = malloc(sizeof(integer)*jpvt_ls);
  for (i_loc=0; i_loc<jpvt_ls; ++i_loc) jpvt_ll[i_loc] = jpvt_l[i_loc];
  rcond_ll = (*env)->GetPrimitiveArrayCritical(env, rcond, NULL);
  rank_l = (*env)->GetPrimitiveArrayCritical(env, rank, NULL);
  rank_ls = (*env)->GetArrayLength(env, rank);
  rank_ll = malloc(sizeof(integer)*rank_ls);
  for (i_loc=0; i_loc<rank_ls; ++i_loc) rank_ll[i_loc] = rank_l[i_loc];
  work_ll = (*env)->GetPrimitiveArrayCritical(env, work, NULL);
  lwork_l = (*env)->GetPrimitiveArrayCritical(env, lwork, NULL);
  lwork_ls = (*env)->GetArrayLength(env, lwork);
  lwork_ll = malloc(sizeof(integer)*lwork_ls);
  for (i_loc=0; i_loc<lwork_ls; ++i_loc) lwork_ll[i_loc] = lwork_l[i_loc];
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dgelsy_(m_ll, n_ll, nrhs_ll, a_ll, lda_ll, b_ll, ldb_ll, jpvt_ll, rcond_ll, rank_ll, work_ll, lwork_ll, info_ll);

  for (i_loc=0; i_loc<m_ls; ++i_loc) m_l[i_loc] = m_ll[i_loc];
  free(m_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, m, m_l, 0);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  for (i_loc=0; i_loc<nrhs_ls; ++i_loc) nrhs_l[i_loc] = nrhs_ll[i_loc];
  free(nrhs_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, nrhs, nrhs_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, a, a_ll, 0);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_l[i_loc] = lda_ll[i_loc];
  free(lda_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, lda, lda_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, b, b_ll, 0);
  for (i_loc=0; i_loc<ldb_ls; ++i_loc) ldb_l[i_loc] = ldb_ll[i_loc];
  free(ldb_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldb, ldb_l, 0);
  for (i_loc=0; i_loc<jpvt_ls; ++i_loc) jpvt_l[i_loc] = jpvt_ll[i_loc];
  free(jpvt_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, jpvt, jpvt_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, rcond, rcond_ll, 0);
  for (i_loc=0; i_loc<rank_ls; ++i_loc) rank_l[i_loc] = rank_ll[i_loc];
  free(rank_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, rank, rank_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, work, work_ll, 0);
  for (i_loc=0; i_loc<lwork_ls; ++i_loc) lwork_l[i_loc] = lwork_ll[i_loc];
  free(lwork_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, lwork, lwork_l, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_geql2
(JNIEnv *env, jclass clazz, jintArray m, jintArray n, jdoubleArray a, jintArray lda, jdoubleArray tau, jdoubleArray work, jintArray info) {
  int i_loc;
  jint* m_l;
  integer* m_ll;
  jsize m_ls;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jdouble* a_ll;
  jint* lda_l;
  integer* lda_ll;
  jsize lda_ls;
  jdouble* tau_ll;
  jdouble* work_ll;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  m_l = (*env)->GetPrimitiveArrayCritical(env, m, NULL);
  m_ls = (*env)->GetArrayLength(env, m);
  m_ll = malloc(sizeof(integer)*m_ls);
  for (i_loc=0; i_loc<m_ls; ++i_loc) m_ll[i_loc] = m_l[i_loc];
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  a_ll = (*env)->GetPrimitiveArrayCritical(env, a, NULL);
  lda_l = (*env)->GetPrimitiveArrayCritical(env, lda, NULL);
  lda_ls = (*env)->GetArrayLength(env, lda);
  lda_ll = malloc(sizeof(integer)*lda_ls);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_ll[i_loc] = lda_l[i_loc];
  tau_ll = (*env)->GetPrimitiveArrayCritical(env, tau, NULL);
  work_ll = (*env)->GetPrimitiveArrayCritical(env, work, NULL);
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dgeql2_(m_ll, n_ll, a_ll, lda_ll, tau_ll, work_ll, info_ll);

  for (i_loc=0; i_loc<m_ls; ++i_loc) m_l[i_loc] = m_ll[i_loc];
  free(m_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, m, m_l, 0);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, a, a_ll, 0);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_l[i_loc] = lda_ll[i_loc];
  free(lda_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, lda, lda_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, tau, tau_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, work, work_ll, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_geqlf
(JNIEnv *env, jclass clazz, jintArray m, jintArray n, jdoubleArray a, jintArray lda, jdoubleArray tau, jdoubleArray work, jintArray lwork, jintArray info) {
  int i_loc;
  jint* m_l;
  integer* m_ll;
  jsize m_ls;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jdouble* a_ll;
  jint* lda_l;
  integer* lda_ll;
  jsize lda_ls;
  jdouble* tau_ll;
  jdouble* work_ll;
  jint* lwork_l;
  integer* lwork_ll;
  jsize lwork_ls;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  m_l = (*env)->GetPrimitiveArrayCritical(env, m, NULL);
  m_ls = (*env)->GetArrayLength(env, m);
  m_ll = malloc(sizeof(integer)*m_ls);
  for (i_loc=0; i_loc<m_ls; ++i_loc) m_ll[i_loc] = m_l[i_loc];
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  a_ll = (*env)->GetPrimitiveArrayCritical(env, a, NULL);
  lda_l = (*env)->GetPrimitiveArrayCritical(env, lda, NULL);
  lda_ls = (*env)->GetArrayLength(env, lda);
  lda_ll = malloc(sizeof(integer)*lda_ls);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_ll[i_loc] = lda_l[i_loc];
  tau_ll = (*env)->GetPrimitiveArrayCritical(env, tau, NULL);
  work_ll = (*env)->GetPrimitiveArrayCritical(env, work, NULL);
  lwork_l = (*env)->GetPrimitiveArrayCritical(env, lwork, NULL);
  lwork_ls = (*env)->GetArrayLength(env, lwork);
  lwork_ll = malloc(sizeof(integer)*lwork_ls);
  for (i_loc=0; i_loc<lwork_ls; ++i_loc) lwork_ll[i_loc] = lwork_l[i_loc];
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dgeqlf_(m_ll, n_ll, a_ll, lda_ll, tau_ll, work_ll, lwork_ll, info_ll);

  for (i_loc=0; i_loc<m_ls; ++i_loc) m_l[i_loc] = m_ll[i_loc];
  free(m_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, m, m_l, 0);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, a, a_ll, 0);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_l[i_loc] = lda_ll[i_loc];
  free(lda_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, lda, lda_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, tau, tau_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, work, work_ll, 0);
  for (i_loc=0; i_loc<lwork_ls; ++i_loc) lwork_l[i_loc] = lwork_ll[i_loc];
  free(lwork_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, lwork, lwork_l, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_geqp3
(JNIEnv *env, jclass clazz, jintArray m, jintArray n, jdoubleArray a, jintArray lda, jintArray jpvt, jdoubleArray tau, jdoubleArray work, jintArray lwork, jintArray info) {
  int i_loc;
  jint* m_l;
  integer* m_ll;
  jsize m_ls;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jdouble* a_ll;
  jint* lda_l;
  integer* lda_ll;
  jsize lda_ls;
  jint* jpvt_l;
  integer* jpvt_ll;
  jsize jpvt_ls;
  jdouble* tau_ll;
  jdouble* work_ll;
  jint* lwork_l;
  integer* lwork_ll;
  jsize lwork_ls;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  m_l = (*env)->GetPrimitiveArrayCritical(env, m, NULL);
  m_ls = (*env)->GetArrayLength(env, m);
  m_ll = malloc(sizeof(integer)*m_ls);
  for (i_loc=0; i_loc<m_ls; ++i_loc) m_ll[i_loc] = m_l[i_loc];
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  a_ll = (*env)->GetPrimitiveArrayCritical(env, a, NULL);
  lda_l = (*env)->GetPrimitiveArrayCritical(env, lda, NULL);
  lda_ls = (*env)->GetArrayLength(env, lda);
  lda_ll = malloc(sizeof(integer)*lda_ls);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_ll[i_loc] = lda_l[i_loc];
  jpvt_l = (*env)->GetPrimitiveArrayCritical(env, jpvt, NULL);
  jpvt_ls = (*env)->GetArrayLength(env, jpvt);
  jpvt_ll = malloc(sizeof(integer)*jpvt_ls);
  for (i_loc=0; i_loc<jpvt_ls; ++i_loc) jpvt_ll[i_loc] = jpvt_l[i_loc];
  tau_ll = (*env)->GetPrimitiveArrayCritical(env, tau, NULL);
  work_ll = (*env)->GetPrimitiveArrayCritical(env, work, NULL);
  lwork_l = (*env)->GetPrimitiveArrayCritical(env, lwork, NULL);
  lwork_ls = (*env)->GetArrayLength(env, lwork);
  lwork_ll = malloc(sizeof(integer)*lwork_ls);
  for (i_loc=0; i_loc<lwork_ls; ++i_loc) lwork_ll[i_loc] = lwork_l[i_loc];
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dgeqp3_(m_ll, n_ll, a_ll, lda_ll, jpvt_ll, tau_ll, work_ll, lwork_ll, info_ll);

  for (i_loc=0; i_loc<m_ls; ++i_loc) m_l[i_loc] = m_ll[i_loc];
  free(m_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, m, m_l, 0);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, a, a_ll, 0);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_l[i_loc] = lda_ll[i_loc];
  free(lda_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, lda, lda_l, 0);
  for (i_loc=0; i_loc<jpvt_ls; ++i_loc) jpvt_l[i_loc] = jpvt_ll[i_loc];
  free(jpvt_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, jpvt, jpvt_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, tau, tau_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, work, work_ll, 0);
  for (i_loc=0; i_loc<lwork_ls; ++i_loc) lwork_l[i_loc] = lwork_ll[i_loc];
  free(lwork_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, lwork, lwork_l, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_geqpf
(JNIEnv *env, jclass clazz, jintArray m, jintArray n, jdoubleArray a, jintArray lda, jintArray jpvt, jdoubleArray tau, jdoubleArray work, jintArray info) {
  int i_loc;
  jint* m_l;
  integer* m_ll;
  jsize m_ls;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jdouble* a_ll;
  jint* lda_l;
  integer* lda_ll;
  jsize lda_ls;
  jint* jpvt_l;
  integer* jpvt_ll;
  jsize jpvt_ls;
  jdouble* tau_ll;
  jdouble* work_ll;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  m_l = (*env)->GetPrimitiveArrayCritical(env, m, NULL);
  m_ls = (*env)->GetArrayLength(env, m);
  m_ll = malloc(sizeof(integer)*m_ls);
  for (i_loc=0; i_loc<m_ls; ++i_loc) m_ll[i_loc] = m_l[i_loc];
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  a_ll = (*env)->GetPrimitiveArrayCritical(env, a, NULL);
  lda_l = (*env)->GetPrimitiveArrayCritical(env, lda, NULL);
  lda_ls = (*env)->GetArrayLength(env, lda);
  lda_ll = malloc(sizeof(integer)*lda_ls);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_ll[i_loc] = lda_l[i_loc];
  jpvt_l = (*env)->GetPrimitiveArrayCritical(env, jpvt, NULL);
  jpvt_ls = (*env)->GetArrayLength(env, jpvt);
  jpvt_ll = malloc(sizeof(integer)*jpvt_ls);
  for (i_loc=0; i_loc<jpvt_ls; ++i_loc) jpvt_ll[i_loc] = jpvt_l[i_loc];
  tau_ll = (*env)->GetPrimitiveArrayCritical(env, tau, NULL);
  work_ll = (*env)->GetPrimitiveArrayCritical(env, work, NULL);
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dgeqpf_(m_ll, n_ll, a_ll, lda_ll, jpvt_ll, tau_ll, work_ll, info_ll);

  for (i_loc=0; i_loc<m_ls; ++i_loc) m_l[i_loc] = m_ll[i_loc];
  free(m_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, m, m_l, 0);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, a, a_ll, 0);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_l[i_loc] = lda_ll[i_loc];
  free(lda_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, lda, lda_l, 0);
  for (i_loc=0; i_loc<jpvt_ls; ++i_loc) jpvt_l[i_loc] = jpvt_ll[i_loc];
  free(jpvt_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, jpvt, jpvt_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, tau, tau_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, work, work_ll, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_geqr2
(JNIEnv *env, jclass clazz, jintArray m, jintArray n, jdoubleArray a, jintArray lda, jdoubleArray tau, jdoubleArray work, jintArray info) {
  int i_loc;
  jint* m_l;
  integer* m_ll;
  jsize m_ls;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jdouble* a_ll;
  jint* lda_l;
  integer* lda_ll;
  jsize lda_ls;
  jdouble* tau_ll;
  jdouble* work_ll;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  m_l = (*env)->GetPrimitiveArrayCritical(env, m, NULL);
  m_ls = (*env)->GetArrayLength(env, m);
  m_ll = malloc(sizeof(integer)*m_ls);
  for (i_loc=0; i_loc<m_ls; ++i_loc) m_ll[i_loc] = m_l[i_loc];
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  a_ll = (*env)->GetPrimitiveArrayCritical(env, a, NULL);
  lda_l = (*env)->GetPrimitiveArrayCritical(env, lda, NULL);
  lda_ls = (*env)->GetArrayLength(env, lda);
  lda_ll = malloc(sizeof(integer)*lda_ls);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_ll[i_loc] = lda_l[i_loc];
  tau_ll = (*env)->GetPrimitiveArrayCritical(env, tau, NULL);
  work_ll = (*env)->GetPrimitiveArrayCritical(env, work, NULL);
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dgeqr2_(m_ll, n_ll, a_ll, lda_ll, tau_ll, work_ll, info_ll);

  for (i_loc=0; i_loc<m_ls; ++i_loc) m_l[i_loc] = m_ll[i_loc];
  free(m_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, m, m_l, 0);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, a, a_ll, 0);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_l[i_loc] = lda_ll[i_loc];
  free(lda_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, lda, lda_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, tau, tau_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, work, work_ll, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_geqrf
(JNIEnv *env, jclass clazz, jintArray m, jintArray n, jdoubleArray a, jintArray lda, jdoubleArray tau, jdoubleArray work, jintArray lwork, jintArray info) {
  int i_loc;
  jint* m_l;
  integer* m_ll;
  jsize m_ls;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jdouble* a_ll;
  jint* lda_l;
  integer* lda_ll;
  jsize lda_ls;
  jdouble* tau_ll;
  jdouble* work_ll;
  jint* lwork_l;
  integer* lwork_ll;
  jsize lwork_ls;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  m_l = (*env)->GetPrimitiveArrayCritical(env, m, NULL);
  m_ls = (*env)->GetArrayLength(env, m);
  m_ll = malloc(sizeof(integer)*m_ls);
  for (i_loc=0; i_loc<m_ls; ++i_loc) m_ll[i_loc] = m_l[i_loc];
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  a_ll = (*env)->GetPrimitiveArrayCritical(env, a, NULL);
  lda_l = (*env)->GetPrimitiveArrayCritical(env, lda, NULL);
  lda_ls = (*env)->GetArrayLength(env, lda);
  lda_ll = malloc(sizeof(integer)*lda_ls);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_ll[i_loc] = lda_l[i_loc];
  tau_ll = (*env)->GetPrimitiveArrayCritical(env, tau, NULL);
  work_ll = (*env)->GetPrimitiveArrayCritical(env, work, NULL);
  lwork_l = (*env)->GetPrimitiveArrayCritical(env, lwork, NULL);
  lwork_ls = (*env)->GetArrayLength(env, lwork);
  lwork_ll = malloc(sizeof(integer)*lwork_ls);
  for (i_loc=0; i_loc<lwork_ls; ++i_loc) lwork_ll[i_loc] = lwork_l[i_loc];
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dgeqrf_(m_ll, n_ll, a_ll, lda_ll, tau_ll, work_ll, lwork_ll, info_ll);

  for (i_loc=0; i_loc<m_ls; ++i_loc) m_l[i_loc] = m_ll[i_loc];
  free(m_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, m, m_l, 0);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, a, a_ll, 0);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_l[i_loc] = lda_ll[i_loc];
  free(lda_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, lda, lda_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, tau, tau_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, work, work_ll, 0);
  for (i_loc=0; i_loc<lwork_ls; ++i_loc) lwork_l[i_loc] = lwork_ll[i_loc];
  free(lwork_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, lwork, lwork_l, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_gerfs
(JNIEnv *env, jclass clazz, jcharArray trans, jintArray n, jintArray nrhs, jdoubleArray a, jintArray lda, jdoubleArray af, jintArray ldaf, jintArray ipiv, jdoubleArray b, jintArray ldb, jdoubleArray x, jintArray ldx, jdoubleArray ferr, jdoubleArray berr, jdoubleArray work, jintArray iwork, jintArray info) {
  int i_loc;
  jchar* trans_l;
  char* trans_ll;
  jsize trans_ls;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jint* nrhs_l;
  integer* nrhs_ll;
  jsize nrhs_ls;
  jdouble* a_ll;
  jint* lda_l;
  integer* lda_ll;
  jsize lda_ls;
  jdouble* af_ll;
  jint* ldaf_l;
  integer* ldaf_ll;
  jsize ldaf_ls;
  jint* ipiv_l;
  integer* ipiv_ll;
  jsize ipiv_ls;
  jdouble* b_ll;
  jint* ldb_l;
  integer* ldb_ll;
  jsize ldb_ls;
  jdouble* x_ll;
  jint* ldx_l;
  integer* ldx_ll;
  jsize ldx_ls;
  jdouble* ferr_ll;
  jdouble* berr_ll;
  jdouble* work_ll;
  jint* iwork_l;
  integer* iwork_ll;
  jsize iwork_ls;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  trans_l = (*env)->GetPrimitiveArrayCritical(env, trans, NULL);
  trans_ls = (*env)->GetArrayLength(env, trans);
  trans_ll = malloc(sizeof(char)*trans_ls);
  for (i_loc=0; i_loc<trans_ls; ++i_loc) trans_ll[i_loc] = trans_l[i_loc];
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  nrhs_l = (*env)->GetPrimitiveArrayCritical(env, nrhs, NULL);
  nrhs_ls = (*env)->GetArrayLength(env, nrhs);
  nrhs_ll = malloc(sizeof(integer)*nrhs_ls);
  for (i_loc=0; i_loc<nrhs_ls; ++i_loc) nrhs_ll[i_loc] = nrhs_l[i_loc];
  a_ll = (*env)->GetPrimitiveArrayCritical(env, a, NULL);
  lda_l = (*env)->GetPrimitiveArrayCritical(env, lda, NULL);
  lda_ls = (*env)->GetArrayLength(env, lda);
  lda_ll = malloc(sizeof(integer)*lda_ls);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_ll[i_loc] = lda_l[i_loc];
  af_ll = (*env)->GetPrimitiveArrayCritical(env, af, NULL);
  ldaf_l = (*env)->GetPrimitiveArrayCritical(env, ldaf, NULL);
  ldaf_ls = (*env)->GetArrayLength(env, ldaf);
  ldaf_ll = malloc(sizeof(integer)*ldaf_ls);
  for (i_loc=0; i_loc<ldaf_ls; ++i_loc) ldaf_ll[i_loc] = ldaf_l[i_loc];
  ipiv_l = (*env)->GetPrimitiveArrayCritical(env, ipiv, NULL);
  ipiv_ls = (*env)->GetArrayLength(env, ipiv);
  ipiv_ll = malloc(sizeof(integer)*ipiv_ls);
  for (i_loc=0; i_loc<ipiv_ls; ++i_loc) ipiv_ll[i_loc] = ipiv_l[i_loc];
  b_ll = (*env)->GetPrimitiveArrayCritical(env, b, NULL);
  ldb_l = (*env)->GetPrimitiveArrayCritical(env, ldb, NULL);
  ldb_ls = (*env)->GetArrayLength(env, ldb);
  ldb_ll = malloc(sizeof(integer)*ldb_ls);
  for (i_loc=0; i_loc<ldb_ls; ++i_loc) ldb_ll[i_loc] = ldb_l[i_loc];
  x_ll = (*env)->GetPrimitiveArrayCritical(env, x, NULL);
  ldx_l = (*env)->GetPrimitiveArrayCritical(env, ldx, NULL);
  ldx_ls = (*env)->GetArrayLength(env, ldx);
  ldx_ll = malloc(sizeof(integer)*ldx_ls);
  for (i_loc=0; i_loc<ldx_ls; ++i_loc) ldx_ll[i_loc] = ldx_l[i_loc];
  ferr_ll = (*env)->GetPrimitiveArrayCritical(env, ferr, NULL);
  berr_ll = (*env)->GetPrimitiveArrayCritical(env, berr, NULL);
  work_ll = (*env)->GetPrimitiveArrayCritical(env, work, NULL);
  iwork_l = (*env)->GetPrimitiveArrayCritical(env, iwork, NULL);
  iwork_ls = (*env)->GetArrayLength(env, iwork);
  iwork_ll = malloc(sizeof(integer)*iwork_ls);
  for (i_loc=0; i_loc<iwork_ls; ++i_loc) iwork_ll[i_loc] = iwork_l[i_loc];
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dgerfs_(trans_ll, n_ll, nrhs_ll, a_ll, lda_ll, af_ll, ldaf_ll, ipiv_ll, b_ll, ldb_ll, x_ll, ldx_ll, ferr_ll, berr_ll, work_ll, iwork_ll, info_ll);

  for (i_loc=0; i_loc<trans_ls; ++i_loc) trans_l[i_loc] = trans_ll[i_loc];
  free(trans_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, trans, trans_l, 0);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  for (i_loc=0; i_loc<nrhs_ls; ++i_loc) nrhs_l[i_loc] = nrhs_ll[i_loc];
  free(nrhs_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, nrhs, nrhs_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, a, a_ll, 0);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_l[i_loc] = lda_ll[i_loc];
  free(lda_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, lda, lda_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, af, af_ll, 0);
  for (i_loc=0; i_loc<ldaf_ls; ++i_loc) ldaf_l[i_loc] = ldaf_ll[i_loc];
  free(ldaf_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldaf, ldaf_l, 0);
  for (i_loc=0; i_loc<ipiv_ls; ++i_loc) ipiv_l[i_loc] = ipiv_ll[i_loc];
  free(ipiv_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ipiv, ipiv_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, b, b_ll, 0);
  for (i_loc=0; i_loc<ldb_ls; ++i_loc) ldb_l[i_loc] = ldb_ll[i_loc];
  free(ldb_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldb, ldb_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, x, x_ll, 0);
  for (i_loc=0; i_loc<ldx_ls; ++i_loc) ldx_l[i_loc] = ldx_ll[i_loc];
  free(ldx_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldx, ldx_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, ferr, ferr_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, berr, berr_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, work, work_ll, 0);
  for (i_loc=0; i_loc<iwork_ls; ++i_loc) iwork_l[i_loc] = iwork_ll[i_loc];
  free(iwork_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, iwork, iwork_l, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_gerq2
(JNIEnv *env, jclass clazz, jintArray m, jintArray n, jdoubleArray a, jintArray lda, jdoubleArray tau, jdoubleArray work, jintArray info) {
  int i_loc;
  jint* m_l;
  integer* m_ll;
  jsize m_ls;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jdouble* a_ll;
  jint* lda_l;
  integer* lda_ll;
  jsize lda_ls;
  jdouble* tau_ll;
  jdouble* work_ll;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  m_l = (*env)->GetPrimitiveArrayCritical(env, m, NULL);
  m_ls = (*env)->GetArrayLength(env, m);
  m_ll = malloc(sizeof(integer)*m_ls);
  for (i_loc=0; i_loc<m_ls; ++i_loc) m_ll[i_loc] = m_l[i_loc];
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  a_ll = (*env)->GetPrimitiveArrayCritical(env, a, NULL);
  lda_l = (*env)->GetPrimitiveArrayCritical(env, lda, NULL);
  lda_ls = (*env)->GetArrayLength(env, lda);
  lda_ll = malloc(sizeof(integer)*lda_ls);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_ll[i_loc] = lda_l[i_loc];
  tau_ll = (*env)->GetPrimitiveArrayCritical(env, tau, NULL);
  work_ll = (*env)->GetPrimitiveArrayCritical(env, work, NULL);
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dgerq2_(m_ll, n_ll, a_ll, lda_ll, tau_ll, work_ll, info_ll);

  for (i_loc=0; i_loc<m_ls; ++i_loc) m_l[i_loc] = m_ll[i_loc];
  free(m_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, m, m_l, 0);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, a, a_ll, 0);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_l[i_loc] = lda_ll[i_loc];
  free(lda_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, lda, lda_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, tau, tau_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, work, work_ll, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_gerqf
(JNIEnv *env, jclass clazz, jintArray m, jintArray n, jdoubleArray a, jintArray lda, jdoubleArray tau, jdoubleArray work, jintArray lwork, jintArray info) {
  int i_loc;
  jint* m_l;
  integer* m_ll;
  jsize m_ls;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jdouble* a_ll;
  jint* lda_l;
  integer* lda_ll;
  jsize lda_ls;
  jdouble* tau_ll;
  jdouble* work_ll;
  jint* lwork_l;
  integer* lwork_ll;
  jsize lwork_ls;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  m_l = (*env)->GetPrimitiveArrayCritical(env, m, NULL);
  m_ls = (*env)->GetArrayLength(env, m);
  m_ll = malloc(sizeof(integer)*m_ls);
  for (i_loc=0; i_loc<m_ls; ++i_loc) m_ll[i_loc] = m_l[i_loc];
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  a_ll = (*env)->GetPrimitiveArrayCritical(env, a, NULL);
  lda_l = (*env)->GetPrimitiveArrayCritical(env, lda, NULL);
  lda_ls = (*env)->GetArrayLength(env, lda);
  lda_ll = malloc(sizeof(integer)*lda_ls);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_ll[i_loc] = lda_l[i_loc];
  tau_ll = (*env)->GetPrimitiveArrayCritical(env, tau, NULL);
  work_ll = (*env)->GetPrimitiveArrayCritical(env, work, NULL);
  lwork_l = (*env)->GetPrimitiveArrayCritical(env, lwork, NULL);
  lwork_ls = (*env)->GetArrayLength(env, lwork);
  lwork_ll = malloc(sizeof(integer)*lwork_ls);
  for (i_loc=0; i_loc<lwork_ls; ++i_loc) lwork_ll[i_loc] = lwork_l[i_loc];
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dgerqf_(m_ll, n_ll, a_ll, lda_ll, tau_ll, work_ll, lwork_ll, info_ll);

  for (i_loc=0; i_loc<m_ls; ++i_loc) m_l[i_loc] = m_ll[i_loc];
  free(m_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, m, m_l, 0);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, a, a_ll, 0);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_l[i_loc] = lda_ll[i_loc];
  free(lda_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, lda, lda_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, tau, tau_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, work, work_ll, 0);
  for (i_loc=0; i_loc<lwork_ls; ++i_loc) lwork_l[i_loc] = lwork_ll[i_loc];
  free(lwork_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, lwork, lwork_l, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_gesc2
(JNIEnv *env, jclass clazz, jintArray n, jdoubleArray a, jintArray lda, jdoubleArray rhs, jintArray ipiv, jintArray jpiv, jdoubleArray scale) {
  int i_loc;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jdouble* a_ll;
  jint* lda_l;
  integer* lda_ll;
  jsize lda_ls;
  jdouble* rhs_ll;
  jint* ipiv_l;
  integer* ipiv_ll;
  jsize ipiv_ls;
  jint* jpiv_l;
  integer* jpiv_ll;
  jsize jpiv_ls;
  jdouble* scale_ll;
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  a_ll = (*env)->GetPrimitiveArrayCritical(env, a, NULL);
  lda_l = (*env)->GetPrimitiveArrayCritical(env, lda, NULL);
  lda_ls = (*env)->GetArrayLength(env, lda);
  lda_ll = malloc(sizeof(integer)*lda_ls);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_ll[i_loc] = lda_l[i_loc];
  rhs_ll = (*env)->GetPrimitiveArrayCritical(env, rhs, NULL);
  ipiv_l = (*env)->GetPrimitiveArrayCritical(env, ipiv, NULL);
  ipiv_ls = (*env)->GetArrayLength(env, ipiv);
  ipiv_ll = malloc(sizeof(integer)*ipiv_ls);
  for (i_loc=0; i_loc<ipiv_ls; ++i_loc) ipiv_ll[i_loc] = ipiv_l[i_loc];
  jpiv_l = (*env)->GetPrimitiveArrayCritical(env, jpiv, NULL);
  jpiv_ls = (*env)->GetArrayLength(env, jpiv);
  jpiv_ll = malloc(sizeof(integer)*jpiv_ls);
  for (i_loc=0; i_loc<jpiv_ls; ++i_loc) jpiv_ll[i_loc] = jpiv_l[i_loc];
  scale_ll = (*env)->GetPrimitiveArrayCritical(env, scale, NULL);

  dgesc2_(n_ll, a_ll, lda_ll, rhs_ll, ipiv_ll, jpiv_ll, scale_ll);

  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, a, a_ll, 0);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_l[i_loc] = lda_ll[i_loc];
  free(lda_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, lda, lda_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, rhs, rhs_ll, 0);
  for (i_loc=0; i_loc<ipiv_ls; ++i_loc) ipiv_l[i_loc] = ipiv_ll[i_loc];
  free(ipiv_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ipiv, ipiv_l, 0);
  for (i_loc=0; i_loc<jpiv_ls; ++i_loc) jpiv_l[i_loc] = jpiv_ll[i_loc];
  free(jpiv_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, jpiv, jpiv_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, scale, scale_ll, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_gesdd
(JNIEnv *env, jclass clazz, jcharArray jobz, jintArray m, jintArray n, jdoubleArray a, jintArray lda, jdoubleArray s, jdoubleArray u, jintArray ldu, jdoubleArray vt, jintArray ldvt, jdoubleArray work, jintArray lwork, jintArray iwork, jintArray info) {
  int i_loc;
  jchar* jobz_l;
  char* jobz_ll;
  jsize jobz_ls;
  jint* m_l;
  integer* m_ll;
  jsize m_ls;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jdouble* a_ll;
  jint* lda_l;
  integer* lda_ll;
  jsize lda_ls;
  jdouble* s_ll;
  jdouble* u_ll;
  jint* ldu_l;
  integer* ldu_ll;
  jsize ldu_ls;
  jdouble* vt_ll;
  jint* ldvt_l;
  integer* ldvt_ll;
  jsize ldvt_ls;
  jdouble* work_ll;
  jint* lwork_l;
  integer* lwork_ll;
  jsize lwork_ls;
  jint* iwork_l;
  integer* iwork_ll;
  jsize iwork_ls;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  jobz_l = (*env)->GetPrimitiveArrayCritical(env, jobz, NULL);
  jobz_ls = (*env)->GetArrayLength(env, jobz);
  jobz_ll = malloc(sizeof(char)*jobz_ls);
  for (i_loc=0; i_loc<jobz_ls; ++i_loc) jobz_ll[i_loc] = jobz_l[i_loc];
  m_l = (*env)->GetPrimitiveArrayCritical(env, m, NULL);
  m_ls = (*env)->GetArrayLength(env, m);
  m_ll = malloc(sizeof(integer)*m_ls);
  for (i_loc=0; i_loc<m_ls; ++i_loc) m_ll[i_loc] = m_l[i_loc];
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  a_ll = (*env)->GetPrimitiveArrayCritical(env, a, NULL);
  lda_l = (*env)->GetPrimitiveArrayCritical(env, lda, NULL);
  lda_ls = (*env)->GetArrayLength(env, lda);
  lda_ll = malloc(sizeof(integer)*lda_ls);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_ll[i_loc] = lda_l[i_loc];
  s_ll = (*env)->GetPrimitiveArrayCritical(env, s, NULL);
  u_ll = (*env)->GetPrimitiveArrayCritical(env, u, NULL);
  ldu_l = (*env)->GetPrimitiveArrayCritical(env, ldu, NULL);
  ldu_ls = (*env)->GetArrayLength(env, ldu);
  ldu_ll = malloc(sizeof(integer)*ldu_ls);
  for (i_loc=0; i_loc<ldu_ls; ++i_loc) ldu_ll[i_loc] = ldu_l[i_loc];
  vt_ll = (*env)->GetPrimitiveArrayCritical(env, vt, NULL);
  ldvt_l = (*env)->GetPrimitiveArrayCritical(env, ldvt, NULL);
  ldvt_ls = (*env)->GetArrayLength(env, ldvt);
  ldvt_ll = malloc(sizeof(integer)*ldvt_ls);
  for (i_loc=0; i_loc<ldvt_ls; ++i_loc) ldvt_ll[i_loc] = ldvt_l[i_loc];
  work_ll = (*env)->GetPrimitiveArrayCritical(env, work, NULL);
  lwork_l = (*env)->GetPrimitiveArrayCritical(env, lwork, NULL);
  lwork_ls = (*env)->GetArrayLength(env, lwork);
  lwork_ll = malloc(sizeof(integer)*lwork_ls);
  for (i_loc=0; i_loc<lwork_ls; ++i_loc) lwork_ll[i_loc] = lwork_l[i_loc];
  iwork_l = (*env)->GetPrimitiveArrayCritical(env, iwork, NULL);
  iwork_ls = (*env)->GetArrayLength(env, iwork);
  iwork_ll = malloc(sizeof(integer)*iwork_ls);
  for (i_loc=0; i_loc<iwork_ls; ++i_loc) iwork_ll[i_loc] = iwork_l[i_loc];
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dgesdd_(jobz_ll, m_ll, n_ll, a_ll, lda_ll, s_ll, u_ll, ldu_ll, vt_ll, ldvt_ll, work_ll, lwork_ll, iwork_ll, info_ll);

  for (i_loc=0; i_loc<jobz_ls; ++i_loc) jobz_l[i_loc] = jobz_ll[i_loc];
  free(jobz_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, jobz, jobz_l, 0);
  for (i_loc=0; i_loc<m_ls; ++i_loc) m_l[i_loc] = m_ll[i_loc];
  free(m_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, m, m_l, 0);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, a, a_ll, 0);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_l[i_loc] = lda_ll[i_loc];
  free(lda_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, lda, lda_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, s, s_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, u, u_ll, 0);
  for (i_loc=0; i_loc<ldu_ls; ++i_loc) ldu_l[i_loc] = ldu_ll[i_loc];
  free(ldu_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldu, ldu_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, vt, vt_ll, 0);
  for (i_loc=0; i_loc<ldvt_ls; ++i_loc) ldvt_l[i_loc] = ldvt_ll[i_loc];
  free(ldvt_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldvt, ldvt_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, work, work_ll, 0);
  for (i_loc=0; i_loc<lwork_ls; ++i_loc) lwork_l[i_loc] = lwork_ll[i_loc];
  free(lwork_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, lwork, lwork_l, 0);
  for (i_loc=0; i_loc<iwork_ls; ++i_loc) iwork_l[i_loc] = iwork_ll[i_loc];
  free(iwork_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, iwork, iwork_l, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_gesv
(JNIEnv *env, jclass clazz, jintArray n, jintArray nrhs, jdoubleArray a, jintArray lda, jintArray ipiv, jdoubleArray b, jintArray ldb, jintArray info) {
  int i_loc;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jint* nrhs_l;
  integer* nrhs_ll;
  jsize nrhs_ls;
  jdouble* a_ll;
  jint* lda_l;
  integer* lda_ll;
  jsize lda_ls;
  jint* ipiv_l;
  integer* ipiv_ll;
  jsize ipiv_ls;
  jdouble* b_ll;
  jint* ldb_l;
  integer* ldb_ll;
  jsize ldb_ls;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  nrhs_l = (*env)->GetPrimitiveArrayCritical(env, nrhs, NULL);
  nrhs_ls = (*env)->GetArrayLength(env, nrhs);
  nrhs_ll = malloc(sizeof(integer)*nrhs_ls);
  for (i_loc=0; i_loc<nrhs_ls; ++i_loc) nrhs_ll[i_loc] = nrhs_l[i_loc];
  a_ll = (*env)->GetPrimitiveArrayCritical(env, a, NULL);
  lda_l = (*env)->GetPrimitiveArrayCritical(env, lda, NULL);
  lda_ls = (*env)->GetArrayLength(env, lda);
  lda_ll = malloc(sizeof(integer)*lda_ls);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_ll[i_loc] = lda_l[i_loc];
  ipiv_l = (*env)->GetPrimitiveArrayCritical(env, ipiv, NULL);
  ipiv_ls = (*env)->GetArrayLength(env, ipiv);
  ipiv_ll = malloc(sizeof(integer)*ipiv_ls);
  for (i_loc=0; i_loc<ipiv_ls; ++i_loc) ipiv_ll[i_loc] = ipiv_l[i_loc];
  b_ll = (*env)->GetPrimitiveArrayCritical(env, b, NULL);
  ldb_l = (*env)->GetPrimitiveArrayCritical(env, ldb, NULL);
  ldb_ls = (*env)->GetArrayLength(env, ldb);
  ldb_ll = malloc(sizeof(integer)*ldb_ls);
  for (i_loc=0; i_loc<ldb_ls; ++i_loc) ldb_ll[i_loc] = ldb_l[i_loc];
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dgesv_(n_ll, nrhs_ll, a_ll, lda_ll, ipiv_ll, b_ll, ldb_ll, info_ll);

  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  for (i_loc=0; i_loc<nrhs_ls; ++i_loc) nrhs_l[i_loc] = nrhs_ll[i_loc];
  free(nrhs_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, nrhs, nrhs_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, a, a_ll, 0);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_l[i_loc] = lda_ll[i_loc];
  free(lda_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, lda, lda_l, 0);
  for (i_loc=0; i_loc<ipiv_ls; ++i_loc) ipiv_l[i_loc] = ipiv_ll[i_loc];
  free(ipiv_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ipiv, ipiv_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, b, b_ll, 0);
  for (i_loc=0; i_loc<ldb_ls; ++i_loc) ldb_l[i_loc] = ldb_ll[i_loc];
  free(ldb_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldb, ldb_l, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_gesvd
(JNIEnv *env, jclass clazz, jcharArray jobu, jcharArray jobvt, jintArray m, jintArray n, jdoubleArray a, jintArray lda, jdoubleArray s, jdoubleArray u, jintArray ldu, jdoubleArray vt, jintArray ldvt, jdoubleArray work, jintArray lwork, jintArray info) {
  int i_loc;
  jchar* jobu_l;
  char* jobu_ll;
  jsize jobu_ls;
  jchar* jobvt_l;
  char* jobvt_ll;
  jsize jobvt_ls;
  jint* m_l;
  integer* m_ll;
  jsize m_ls;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jdouble* a_ll;
  jint* lda_l;
  integer* lda_ll;
  jsize lda_ls;
  jdouble* s_ll;
  jdouble* u_ll;
  jint* ldu_l;
  integer* ldu_ll;
  jsize ldu_ls;
  jdouble* vt_ll;
  jint* ldvt_l;
  integer* ldvt_ll;
  jsize ldvt_ls;
  jdouble* work_ll;
  jint* lwork_l;
  integer* lwork_ll;
  jsize lwork_ls;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  jobu_l = (*env)->GetPrimitiveArrayCritical(env, jobu, NULL);
  jobu_ls = (*env)->GetArrayLength(env, jobu);
  jobu_ll = malloc(sizeof(char)*jobu_ls);
  for (i_loc=0; i_loc<jobu_ls; ++i_loc) jobu_ll[i_loc] = jobu_l[i_loc];
  jobvt_l = (*env)->GetPrimitiveArrayCritical(env, jobvt, NULL);
  jobvt_ls = (*env)->GetArrayLength(env, jobvt);
  jobvt_ll = malloc(sizeof(char)*jobvt_ls);
  for (i_loc=0; i_loc<jobvt_ls; ++i_loc) jobvt_ll[i_loc] = jobvt_l[i_loc];
  m_l = (*env)->GetPrimitiveArrayCritical(env, m, NULL);
  m_ls = (*env)->GetArrayLength(env, m);
  m_ll = malloc(sizeof(integer)*m_ls);
  for (i_loc=0; i_loc<m_ls; ++i_loc) m_ll[i_loc] = m_l[i_loc];
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  a_ll = (*env)->GetPrimitiveArrayCritical(env, a, NULL);
  lda_l = (*env)->GetPrimitiveArrayCritical(env, lda, NULL);
  lda_ls = (*env)->GetArrayLength(env, lda);
  lda_ll = malloc(sizeof(integer)*lda_ls);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_ll[i_loc] = lda_l[i_loc];
  s_ll = (*env)->GetPrimitiveArrayCritical(env, s, NULL);
  u_ll = (*env)->GetPrimitiveArrayCritical(env, u, NULL);
  ldu_l = (*env)->GetPrimitiveArrayCritical(env, ldu, NULL);
  ldu_ls = (*env)->GetArrayLength(env, ldu);
  ldu_ll = malloc(sizeof(integer)*ldu_ls);
  for (i_loc=0; i_loc<ldu_ls; ++i_loc) ldu_ll[i_loc] = ldu_l[i_loc];
  vt_ll = (*env)->GetPrimitiveArrayCritical(env, vt, NULL);
  ldvt_l = (*env)->GetPrimitiveArrayCritical(env, ldvt, NULL);
  ldvt_ls = (*env)->GetArrayLength(env, ldvt);
  ldvt_ll = malloc(sizeof(integer)*ldvt_ls);
  for (i_loc=0; i_loc<ldvt_ls; ++i_loc) ldvt_ll[i_loc] = ldvt_l[i_loc];
  work_ll = (*env)->GetPrimitiveArrayCritical(env, work, NULL);
  lwork_l = (*env)->GetPrimitiveArrayCritical(env, lwork, NULL);
  lwork_ls = (*env)->GetArrayLength(env, lwork);
  lwork_ll = malloc(sizeof(integer)*lwork_ls);
  for (i_loc=0; i_loc<lwork_ls; ++i_loc) lwork_ll[i_loc] = lwork_l[i_loc];
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dgesvd_(jobu_ll, jobvt_ll, m_ll, n_ll, a_ll, lda_ll, s_ll, u_ll, ldu_ll, vt_ll, ldvt_ll, work_ll, lwork_ll, info_ll);

  for (i_loc=0; i_loc<jobu_ls; ++i_loc) jobu_l[i_loc] = jobu_ll[i_loc];
  free(jobu_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, jobu, jobu_l, 0);
  for (i_loc=0; i_loc<jobvt_ls; ++i_loc) jobvt_l[i_loc] = jobvt_ll[i_loc];
  free(jobvt_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, jobvt, jobvt_l, 0);
  for (i_loc=0; i_loc<m_ls; ++i_loc) m_l[i_loc] = m_ll[i_loc];
  free(m_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, m, m_l, 0);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, a, a_ll, 0);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_l[i_loc] = lda_ll[i_loc];
  free(lda_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, lda, lda_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, s, s_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, u, u_ll, 0);
  for (i_loc=0; i_loc<ldu_ls; ++i_loc) ldu_l[i_loc] = ldu_ll[i_loc];
  free(ldu_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldu, ldu_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, vt, vt_ll, 0);
  for (i_loc=0; i_loc<ldvt_ls; ++i_loc) ldvt_l[i_loc] = ldvt_ll[i_loc];
  free(ldvt_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldvt, ldvt_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, work, work_ll, 0);
  for (i_loc=0; i_loc<lwork_ls; ++i_loc) lwork_l[i_loc] = lwork_ll[i_loc];
  free(lwork_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, lwork, lwork_l, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_gesvx
(JNIEnv *env, jclass clazz, jcharArray fact, jcharArray trans, jintArray n, jintArray nrhs, jdoubleArray a, jintArray lda, jdoubleArray af, jintArray ldaf, jintArray ipiv, jcharArray equed, jdoubleArray r, jdoubleArray c, jdoubleArray b, jintArray ldb, jdoubleArray x, jintArray ldx, jdoubleArray rcond, jdoubleArray ferr, jdoubleArray berr, jdoubleArray work, jintArray iwork, jintArray info) {
  int i_loc;
  jchar* fact_l;
  char* fact_ll;
  jsize fact_ls;
  jchar* trans_l;
  char* trans_ll;
  jsize trans_ls;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jint* nrhs_l;
  integer* nrhs_ll;
  jsize nrhs_ls;
  jdouble* a_ll;
  jint* lda_l;
  integer* lda_ll;
  jsize lda_ls;
  jdouble* af_ll;
  jint* ldaf_l;
  integer* ldaf_ll;
  jsize ldaf_ls;
  jint* ipiv_l;
  integer* ipiv_ll;
  jsize ipiv_ls;
  jchar* equed_l;
  char* equed_ll;
  jsize equed_ls;
  jdouble* r_ll;
  jdouble* c_ll;
  jdouble* b_ll;
  jint* ldb_l;
  integer* ldb_ll;
  jsize ldb_ls;
  jdouble* x_ll;
  jint* ldx_l;
  integer* ldx_ll;
  jsize ldx_ls;
  jdouble* rcond_ll;
  jdouble* ferr_ll;
  jdouble* berr_ll;
  jdouble* work_ll;
  jint* iwork_l;
  integer* iwork_ll;
  jsize iwork_ls;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  fact_l = (*env)->GetPrimitiveArrayCritical(env, fact, NULL);
  fact_ls = (*env)->GetArrayLength(env, fact);
  fact_ll = malloc(sizeof(char)*fact_ls);
  for (i_loc=0; i_loc<fact_ls; ++i_loc) fact_ll[i_loc] = fact_l[i_loc];
  trans_l = (*env)->GetPrimitiveArrayCritical(env, trans, NULL);
  trans_ls = (*env)->GetArrayLength(env, trans);
  trans_ll = malloc(sizeof(char)*trans_ls);
  for (i_loc=0; i_loc<trans_ls; ++i_loc) trans_ll[i_loc] = trans_l[i_loc];
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  nrhs_l = (*env)->GetPrimitiveArrayCritical(env, nrhs, NULL);
  nrhs_ls = (*env)->GetArrayLength(env, nrhs);
  nrhs_ll = malloc(sizeof(integer)*nrhs_ls);
  for (i_loc=0; i_loc<nrhs_ls; ++i_loc) nrhs_ll[i_loc] = nrhs_l[i_loc];
  a_ll = (*env)->GetPrimitiveArrayCritical(env, a, NULL);
  lda_l = (*env)->GetPrimitiveArrayCritical(env, lda, NULL);
  lda_ls = (*env)->GetArrayLength(env, lda);
  lda_ll = malloc(sizeof(integer)*lda_ls);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_ll[i_loc] = lda_l[i_loc];
  af_ll = (*env)->GetPrimitiveArrayCritical(env, af, NULL);
  ldaf_l = (*env)->GetPrimitiveArrayCritical(env, ldaf, NULL);
  ldaf_ls = (*env)->GetArrayLength(env, ldaf);
  ldaf_ll = malloc(sizeof(integer)*ldaf_ls);
  for (i_loc=0; i_loc<ldaf_ls; ++i_loc) ldaf_ll[i_loc] = ldaf_l[i_loc];
  ipiv_l = (*env)->GetPrimitiveArrayCritical(env, ipiv, NULL);
  ipiv_ls = (*env)->GetArrayLength(env, ipiv);
  ipiv_ll = malloc(sizeof(integer)*ipiv_ls);
  for (i_loc=0; i_loc<ipiv_ls; ++i_loc) ipiv_ll[i_loc] = ipiv_l[i_loc];
  equed_l = (*env)->GetPrimitiveArrayCritical(env, equed, NULL);
  equed_ls = (*env)->GetArrayLength(env, equed);
  equed_ll = malloc(sizeof(char)*equed_ls);
  for (i_loc=0; i_loc<equed_ls; ++i_loc) equed_ll[i_loc] = equed_l[i_loc];
  r_ll = (*env)->GetPrimitiveArrayCritical(env, r, NULL);
  c_ll = (*env)->GetPrimitiveArrayCritical(env, c, NULL);
  b_ll = (*env)->GetPrimitiveArrayCritical(env, b, NULL);
  ldb_l = (*env)->GetPrimitiveArrayCritical(env, ldb, NULL);
  ldb_ls = (*env)->GetArrayLength(env, ldb);
  ldb_ll = malloc(sizeof(integer)*ldb_ls);
  for (i_loc=0; i_loc<ldb_ls; ++i_loc) ldb_ll[i_loc] = ldb_l[i_loc];
  x_ll = (*env)->GetPrimitiveArrayCritical(env, x, NULL);
  ldx_l = (*env)->GetPrimitiveArrayCritical(env, ldx, NULL);
  ldx_ls = (*env)->GetArrayLength(env, ldx);
  ldx_ll = malloc(sizeof(integer)*ldx_ls);
  for (i_loc=0; i_loc<ldx_ls; ++i_loc) ldx_ll[i_loc] = ldx_l[i_loc];
  rcond_ll = (*env)->GetPrimitiveArrayCritical(env, rcond, NULL);
  ferr_ll = (*env)->GetPrimitiveArrayCritical(env, ferr, NULL);
  berr_ll = (*env)->GetPrimitiveArrayCritical(env, berr, NULL);
  work_ll = (*env)->GetPrimitiveArrayCritical(env, work, NULL);
  iwork_l = (*env)->GetPrimitiveArrayCritical(env, iwork, NULL);
  iwork_ls = (*env)->GetArrayLength(env, iwork);
  iwork_ll = malloc(sizeof(integer)*iwork_ls);
  for (i_loc=0; i_loc<iwork_ls; ++i_loc) iwork_ll[i_loc] = iwork_l[i_loc];
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dgesvx_(fact_ll, trans_ll, n_ll, nrhs_ll, a_ll, lda_ll, af_ll, ldaf_ll, ipiv_ll, equed_ll, r_ll, c_ll, b_ll, ldb_ll, x_ll, ldx_ll, rcond_ll, ferr_ll, berr_ll, work_ll, iwork_ll, info_ll);

  for (i_loc=0; i_loc<fact_ls; ++i_loc) fact_l[i_loc] = fact_ll[i_loc];
  free(fact_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, fact, fact_l, 0);
  for (i_loc=0; i_loc<trans_ls; ++i_loc) trans_l[i_loc] = trans_ll[i_loc];
  free(trans_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, trans, trans_l, 0);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  for (i_loc=0; i_loc<nrhs_ls; ++i_loc) nrhs_l[i_loc] = nrhs_ll[i_loc];
  free(nrhs_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, nrhs, nrhs_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, a, a_ll, 0);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_l[i_loc] = lda_ll[i_loc];
  free(lda_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, lda, lda_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, af, af_ll, 0);
  for (i_loc=0; i_loc<ldaf_ls; ++i_loc) ldaf_l[i_loc] = ldaf_ll[i_loc];
  free(ldaf_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldaf, ldaf_l, 0);
  for (i_loc=0; i_loc<ipiv_ls; ++i_loc) ipiv_l[i_loc] = ipiv_ll[i_loc];
  free(ipiv_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ipiv, ipiv_l, 0);
  for (i_loc=0; i_loc<equed_ls; ++i_loc) equed_l[i_loc] = equed_ll[i_loc];
  free(equed_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, equed, equed_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, r, r_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, c, c_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, b, b_ll, 0);
  for (i_loc=0; i_loc<ldb_ls; ++i_loc) ldb_l[i_loc] = ldb_ll[i_loc];
  free(ldb_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldb, ldb_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, x, x_ll, 0);
  for (i_loc=0; i_loc<ldx_ls; ++i_loc) ldx_l[i_loc] = ldx_ll[i_loc];
  free(ldx_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldx, ldx_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, rcond, rcond_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, ferr, ferr_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, berr, berr_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, work, work_ll, 0);
  for (i_loc=0; i_loc<iwork_ls; ++i_loc) iwork_l[i_loc] = iwork_ll[i_loc];
  free(iwork_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, iwork, iwork_l, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_getc2
(JNIEnv *env, jclass clazz, jintArray n, jdoubleArray a, jintArray lda, jintArray ipiv, jintArray jpiv, jintArray info) {
  int i_loc;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jdouble* a_ll;
  jint* lda_l;
  integer* lda_ll;
  jsize lda_ls;
  jint* ipiv_l;
  integer* ipiv_ll;
  jsize ipiv_ls;
  jint* jpiv_l;
  integer* jpiv_ll;
  jsize jpiv_ls;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  a_ll = (*env)->GetPrimitiveArrayCritical(env, a, NULL);
  lda_l = (*env)->GetPrimitiveArrayCritical(env, lda, NULL);
  lda_ls = (*env)->GetArrayLength(env, lda);
  lda_ll = malloc(sizeof(integer)*lda_ls);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_ll[i_loc] = lda_l[i_loc];
  ipiv_l = (*env)->GetPrimitiveArrayCritical(env, ipiv, NULL);
  ipiv_ls = (*env)->GetArrayLength(env, ipiv);
  ipiv_ll = malloc(sizeof(integer)*ipiv_ls);
  for (i_loc=0; i_loc<ipiv_ls; ++i_loc) ipiv_ll[i_loc] = ipiv_l[i_loc];
  jpiv_l = (*env)->GetPrimitiveArrayCritical(env, jpiv, NULL);
  jpiv_ls = (*env)->GetArrayLength(env, jpiv);
  jpiv_ll = malloc(sizeof(integer)*jpiv_ls);
  for (i_loc=0; i_loc<jpiv_ls; ++i_loc) jpiv_ll[i_loc] = jpiv_l[i_loc];
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dgetc2_(n_ll, a_ll, lda_ll, ipiv_ll, jpiv_ll, info_ll);

  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, a, a_ll, 0);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_l[i_loc] = lda_ll[i_loc];
  free(lda_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, lda, lda_l, 0);
  for (i_loc=0; i_loc<ipiv_ls; ++i_loc) ipiv_l[i_loc] = ipiv_ll[i_loc];
  free(ipiv_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ipiv, ipiv_l, 0);
  for (i_loc=0; i_loc<jpiv_ls; ++i_loc) jpiv_l[i_loc] = jpiv_ll[i_loc];
  free(jpiv_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, jpiv, jpiv_l, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_getf2
(JNIEnv *env, jclass clazz, jintArray m, jintArray n, jdoubleArray a, jintArray lda, jintArray ipiv, jintArray info) {
  int i_loc;
  jint* m_l;
  integer* m_ll;
  jsize m_ls;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jdouble* a_ll;
  jint* lda_l;
  integer* lda_ll;
  jsize lda_ls;
  jint* ipiv_l;
  integer* ipiv_ll;
  jsize ipiv_ls;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  m_l = (*env)->GetPrimitiveArrayCritical(env, m, NULL);
  m_ls = (*env)->GetArrayLength(env, m);
  m_ll = malloc(sizeof(integer)*m_ls);
  for (i_loc=0; i_loc<m_ls; ++i_loc) m_ll[i_loc] = m_l[i_loc];
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  a_ll = (*env)->GetPrimitiveArrayCritical(env, a, NULL);
  lda_l = (*env)->GetPrimitiveArrayCritical(env, lda, NULL);
  lda_ls = (*env)->GetArrayLength(env, lda);
  lda_ll = malloc(sizeof(integer)*lda_ls);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_ll[i_loc] = lda_l[i_loc];
  ipiv_l = (*env)->GetPrimitiveArrayCritical(env, ipiv, NULL);
  ipiv_ls = (*env)->GetArrayLength(env, ipiv);
  ipiv_ll = malloc(sizeof(integer)*ipiv_ls);
  for (i_loc=0; i_loc<ipiv_ls; ++i_loc) ipiv_ll[i_loc] = ipiv_l[i_loc];
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dgetf2_(m_ll, n_ll, a_ll, lda_ll, ipiv_ll, info_ll);

  for (i_loc=0; i_loc<m_ls; ++i_loc) m_l[i_loc] = m_ll[i_loc];
  free(m_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, m, m_l, 0);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, a, a_ll, 0);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_l[i_loc] = lda_ll[i_loc];
  free(lda_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, lda, lda_l, 0);
  for (i_loc=0; i_loc<ipiv_ls; ++i_loc) ipiv_l[i_loc] = ipiv_ll[i_loc];
  free(ipiv_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ipiv, ipiv_l, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_getrf
(JNIEnv *env, jclass clazz, jintArray m, jintArray n, jdoubleArray a, jintArray lda, jintArray ipiv, jintArray info) {
  int i_loc;
  jint* m_l;
  integer* m_ll;
  jsize m_ls;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jdouble* a_ll;
  jint* lda_l;
  integer* lda_ll;
  jsize lda_ls;
  jint* ipiv_l;
  integer* ipiv_ll;
  jsize ipiv_ls;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  m_l = (*env)->GetPrimitiveArrayCritical(env, m, NULL);
  m_ls = (*env)->GetArrayLength(env, m);
  m_ll = malloc(sizeof(integer)*m_ls);
  for (i_loc=0; i_loc<m_ls; ++i_loc) m_ll[i_loc] = m_l[i_loc];
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  a_ll = (*env)->GetPrimitiveArrayCritical(env, a, NULL);
  lda_l = (*env)->GetPrimitiveArrayCritical(env, lda, NULL);
  lda_ls = (*env)->GetArrayLength(env, lda);
  lda_ll = malloc(sizeof(integer)*lda_ls);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_ll[i_loc] = lda_l[i_loc];
  ipiv_l = (*env)->GetPrimitiveArrayCritical(env, ipiv, NULL);
  ipiv_ls = (*env)->GetArrayLength(env, ipiv);
  ipiv_ll = malloc(sizeof(integer)*ipiv_ls);
  for (i_loc=0; i_loc<ipiv_ls; ++i_loc) ipiv_ll[i_loc] = ipiv_l[i_loc];
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dgetrf_(m_ll, n_ll, a_ll, lda_ll, ipiv_ll, info_ll);

  for (i_loc=0; i_loc<m_ls; ++i_loc) m_l[i_loc] = m_ll[i_loc];
  free(m_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, m, m_l, 0);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, a, a_ll, 0);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_l[i_loc] = lda_ll[i_loc];
  free(lda_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, lda, lda_l, 0);
  for (i_loc=0; i_loc<ipiv_ls; ++i_loc) ipiv_l[i_loc] = ipiv_ll[i_loc];
  free(ipiv_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ipiv, ipiv_l, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_getri
(JNIEnv *env, jclass clazz, jintArray n, jdoubleArray a, jintArray lda, jintArray ipiv, jdoubleArray work, jintArray lwork, jintArray info) {
  int i_loc;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jdouble* a_ll;
  jint* lda_l;
  integer* lda_ll;
  jsize lda_ls;
  jint* ipiv_l;
  integer* ipiv_ll;
  jsize ipiv_ls;
  jdouble* work_ll;
  jint* lwork_l;
  integer* lwork_ll;
  jsize lwork_ls;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  a_ll = (*env)->GetPrimitiveArrayCritical(env, a, NULL);
  lda_l = (*env)->GetPrimitiveArrayCritical(env, lda, NULL);
  lda_ls = (*env)->GetArrayLength(env, lda);
  lda_ll = malloc(sizeof(integer)*lda_ls);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_ll[i_loc] = lda_l[i_loc];
  ipiv_l = (*env)->GetPrimitiveArrayCritical(env, ipiv, NULL);
  ipiv_ls = (*env)->GetArrayLength(env, ipiv);
  ipiv_ll = malloc(sizeof(integer)*ipiv_ls);
  for (i_loc=0; i_loc<ipiv_ls; ++i_loc) ipiv_ll[i_loc] = ipiv_l[i_loc];
  work_ll = (*env)->GetPrimitiveArrayCritical(env, work, NULL);
  lwork_l = (*env)->GetPrimitiveArrayCritical(env, lwork, NULL);
  lwork_ls = (*env)->GetArrayLength(env, lwork);
  lwork_ll = malloc(sizeof(integer)*lwork_ls);
  for (i_loc=0; i_loc<lwork_ls; ++i_loc) lwork_ll[i_loc] = lwork_l[i_loc];
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dgetri_(n_ll, a_ll, lda_ll, ipiv_ll, work_ll, lwork_ll, info_ll);

  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, a, a_ll, 0);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_l[i_loc] = lda_ll[i_loc];
  free(lda_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, lda, lda_l, 0);
  for (i_loc=0; i_loc<ipiv_ls; ++i_loc) ipiv_l[i_loc] = ipiv_ll[i_loc];
  free(ipiv_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ipiv, ipiv_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, work, work_ll, 0);
  for (i_loc=0; i_loc<lwork_ls; ++i_loc) lwork_l[i_loc] = lwork_ll[i_loc];
  free(lwork_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, lwork, lwork_l, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_getrs
(JNIEnv *env, jclass clazz, jcharArray trans, jintArray n, jintArray nrhs, jdoubleArray a, jintArray lda, jintArray ipiv, jdoubleArray b, jintArray ldb, jintArray info) {
  int i_loc;
  jchar* trans_l;
  char* trans_ll;
  jsize trans_ls;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jint* nrhs_l;
  integer* nrhs_ll;
  jsize nrhs_ls;
  jdouble* a_ll;
  jint* lda_l;
  integer* lda_ll;
  jsize lda_ls;
  jint* ipiv_l;
  integer* ipiv_ll;
  jsize ipiv_ls;
  jdouble* b_ll;
  jint* ldb_l;
  integer* ldb_ll;
  jsize ldb_ls;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  trans_l = (*env)->GetPrimitiveArrayCritical(env, trans, NULL);
  trans_ls = (*env)->GetArrayLength(env, trans);
  trans_ll = malloc(sizeof(char)*trans_ls);
  for (i_loc=0; i_loc<trans_ls; ++i_loc) trans_ll[i_loc] = trans_l[i_loc];
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  nrhs_l = (*env)->GetPrimitiveArrayCritical(env, nrhs, NULL);
  nrhs_ls = (*env)->GetArrayLength(env, nrhs);
  nrhs_ll = malloc(sizeof(integer)*nrhs_ls);
  for (i_loc=0; i_loc<nrhs_ls; ++i_loc) nrhs_ll[i_loc] = nrhs_l[i_loc];
  a_ll = (*env)->GetPrimitiveArrayCritical(env, a, NULL);
  lda_l = (*env)->GetPrimitiveArrayCritical(env, lda, NULL);
  lda_ls = (*env)->GetArrayLength(env, lda);
  lda_ll = malloc(sizeof(integer)*lda_ls);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_ll[i_loc] = lda_l[i_loc];
  ipiv_l = (*env)->GetPrimitiveArrayCritical(env, ipiv, NULL);
  ipiv_ls = (*env)->GetArrayLength(env, ipiv);
  ipiv_ll = malloc(sizeof(integer)*ipiv_ls);
  for (i_loc=0; i_loc<ipiv_ls; ++i_loc) ipiv_ll[i_loc] = ipiv_l[i_loc];
  b_ll = (*env)->GetPrimitiveArrayCritical(env, b, NULL);
  ldb_l = (*env)->GetPrimitiveArrayCritical(env, ldb, NULL);
  ldb_ls = (*env)->GetArrayLength(env, ldb);
  ldb_ll = malloc(sizeof(integer)*ldb_ls);
  for (i_loc=0; i_loc<ldb_ls; ++i_loc) ldb_ll[i_loc] = ldb_l[i_loc];
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dgetrs_(trans_ll, n_ll, nrhs_ll, a_ll, lda_ll, ipiv_ll, b_ll, ldb_ll, info_ll);

  for (i_loc=0; i_loc<trans_ls; ++i_loc) trans_l[i_loc] = trans_ll[i_loc];
  free(trans_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, trans, trans_l, 0);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  for (i_loc=0; i_loc<nrhs_ls; ++i_loc) nrhs_l[i_loc] = nrhs_ll[i_loc];
  free(nrhs_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, nrhs, nrhs_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, a, a_ll, 0);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_l[i_loc] = lda_ll[i_loc];
  free(lda_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, lda, lda_l, 0);
  for (i_loc=0; i_loc<ipiv_ls; ++i_loc) ipiv_l[i_loc] = ipiv_ll[i_loc];
  free(ipiv_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ipiv, ipiv_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, b, b_ll, 0);
  for (i_loc=0; i_loc<ldb_ls; ++i_loc) ldb_l[i_loc] = ldb_ll[i_loc];
  free(ldb_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldb, ldb_l, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_ggbak
(JNIEnv *env, jclass clazz, jcharArray job, jcharArray side, jintArray n, jintArray ilo, jintArray ihi, jdoubleArray lscale, jdoubleArray rscale, jintArray m, jdoubleArray v, jintArray ldv, jintArray info) {
  int i_loc;
  jchar* job_l;
  char* job_ll;
  jsize job_ls;
  jchar* side_l;
  char* side_ll;
  jsize side_ls;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jint* ilo_l;
  integer* ilo_ll;
  jsize ilo_ls;
  jint* ihi_l;
  integer* ihi_ll;
  jsize ihi_ls;
  jdouble* lscale_ll;
  jdouble* rscale_ll;
  jint* m_l;
  integer* m_ll;
  jsize m_ls;
  jdouble* v_ll;
  jint* ldv_l;
  integer* ldv_ll;
  jsize ldv_ls;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  job_l = (*env)->GetPrimitiveArrayCritical(env, job, NULL);
  job_ls = (*env)->GetArrayLength(env, job);
  job_ll = malloc(sizeof(char)*job_ls);
  for (i_loc=0; i_loc<job_ls; ++i_loc) job_ll[i_loc] = job_l[i_loc];
  side_l = (*env)->GetPrimitiveArrayCritical(env, side, NULL);
  side_ls = (*env)->GetArrayLength(env, side);
  side_ll = malloc(sizeof(char)*side_ls);
  for (i_loc=0; i_loc<side_ls; ++i_loc) side_ll[i_loc] = side_l[i_loc];
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  ilo_l = (*env)->GetPrimitiveArrayCritical(env, ilo, NULL);
  ilo_ls = (*env)->GetArrayLength(env, ilo);
  ilo_ll = malloc(sizeof(integer)*ilo_ls);
  for (i_loc=0; i_loc<ilo_ls; ++i_loc) ilo_ll[i_loc] = ilo_l[i_loc];
  ihi_l = (*env)->GetPrimitiveArrayCritical(env, ihi, NULL);
  ihi_ls = (*env)->GetArrayLength(env, ihi);
  ihi_ll = malloc(sizeof(integer)*ihi_ls);
  for (i_loc=0; i_loc<ihi_ls; ++i_loc) ihi_ll[i_loc] = ihi_l[i_loc];
  lscale_ll = (*env)->GetPrimitiveArrayCritical(env, lscale, NULL);
  rscale_ll = (*env)->GetPrimitiveArrayCritical(env, rscale, NULL);
  m_l = (*env)->GetPrimitiveArrayCritical(env, m, NULL);
  m_ls = (*env)->GetArrayLength(env, m);
  m_ll = malloc(sizeof(integer)*m_ls);
  for (i_loc=0; i_loc<m_ls; ++i_loc) m_ll[i_loc] = m_l[i_loc];
  v_ll = (*env)->GetPrimitiveArrayCritical(env, v, NULL);
  ldv_l = (*env)->GetPrimitiveArrayCritical(env, ldv, NULL);
  ldv_ls = (*env)->GetArrayLength(env, ldv);
  ldv_ll = malloc(sizeof(integer)*ldv_ls);
  for (i_loc=0; i_loc<ldv_ls; ++i_loc) ldv_ll[i_loc] = ldv_l[i_loc];
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dggbak_(job_ll, side_ll, n_ll, ilo_ll, ihi_ll, lscale_ll, rscale_ll, m_ll, v_ll, ldv_ll, info_ll);

  for (i_loc=0; i_loc<job_ls; ++i_loc) job_l[i_loc] = job_ll[i_loc];
  free(job_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, job, job_l, 0);
  for (i_loc=0; i_loc<side_ls; ++i_loc) side_l[i_loc] = side_ll[i_loc];
  free(side_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, side, side_l, 0);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  for (i_loc=0; i_loc<ilo_ls; ++i_loc) ilo_l[i_loc] = ilo_ll[i_loc];
  free(ilo_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ilo, ilo_l, 0);
  for (i_loc=0; i_loc<ihi_ls; ++i_loc) ihi_l[i_loc] = ihi_ll[i_loc];
  free(ihi_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ihi, ihi_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, lscale, lscale_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, rscale, rscale_ll, 0);
  for (i_loc=0; i_loc<m_ls; ++i_loc) m_l[i_loc] = m_ll[i_loc];
  free(m_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, m, m_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, v, v_ll, 0);
  for (i_loc=0; i_loc<ldv_ls; ++i_loc) ldv_l[i_loc] = ldv_ll[i_loc];
  free(ldv_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldv, ldv_l, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_ggbal
(JNIEnv *env, jclass clazz, jcharArray job, jintArray n, jdoubleArray a, jintArray lda, jdoubleArray b, jintArray ldb, jintArray ilo, jintArray ihi, jdoubleArray lscale, jdoubleArray rscale, jdoubleArray work, jintArray info) {
  int i_loc;
  jchar* job_l;
  char* job_ll;
  jsize job_ls;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jdouble* a_ll;
  jint* lda_l;
  integer* lda_ll;
  jsize lda_ls;
  jdouble* b_ll;
  jint* ldb_l;
  integer* ldb_ll;
  jsize ldb_ls;
  jint* ilo_l;
  integer* ilo_ll;
  jsize ilo_ls;
  jint* ihi_l;
  integer* ihi_ll;
  jsize ihi_ls;
  jdouble* lscale_ll;
  jdouble* rscale_ll;
  jdouble* work_ll;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  job_l = (*env)->GetPrimitiveArrayCritical(env, job, NULL);
  job_ls = (*env)->GetArrayLength(env, job);
  job_ll = malloc(sizeof(char)*job_ls);
  for (i_loc=0; i_loc<job_ls; ++i_loc) job_ll[i_loc] = job_l[i_loc];
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  a_ll = (*env)->GetPrimitiveArrayCritical(env, a, NULL);
  lda_l = (*env)->GetPrimitiveArrayCritical(env, lda, NULL);
  lda_ls = (*env)->GetArrayLength(env, lda);
  lda_ll = malloc(sizeof(integer)*lda_ls);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_ll[i_loc] = lda_l[i_loc];
  b_ll = (*env)->GetPrimitiveArrayCritical(env, b, NULL);
  ldb_l = (*env)->GetPrimitiveArrayCritical(env, ldb, NULL);
  ldb_ls = (*env)->GetArrayLength(env, ldb);
  ldb_ll = malloc(sizeof(integer)*ldb_ls);
  for (i_loc=0; i_loc<ldb_ls; ++i_loc) ldb_ll[i_loc] = ldb_l[i_loc];
  ilo_l = (*env)->GetPrimitiveArrayCritical(env, ilo, NULL);
  ilo_ls = (*env)->GetArrayLength(env, ilo);
  ilo_ll = malloc(sizeof(integer)*ilo_ls);
  for (i_loc=0; i_loc<ilo_ls; ++i_loc) ilo_ll[i_loc] = ilo_l[i_loc];
  ihi_l = (*env)->GetPrimitiveArrayCritical(env, ihi, NULL);
  ihi_ls = (*env)->GetArrayLength(env, ihi);
  ihi_ll = malloc(sizeof(integer)*ihi_ls);
  for (i_loc=0; i_loc<ihi_ls; ++i_loc) ihi_ll[i_loc] = ihi_l[i_loc];
  lscale_ll = (*env)->GetPrimitiveArrayCritical(env, lscale, NULL);
  rscale_ll = (*env)->GetPrimitiveArrayCritical(env, rscale, NULL);
  work_ll = (*env)->GetPrimitiveArrayCritical(env, work, NULL);
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dggbal_(job_ll, n_ll, a_ll, lda_ll, b_ll, ldb_ll, ilo_ll, ihi_ll, lscale_ll, rscale_ll, work_ll, info_ll);

  for (i_loc=0; i_loc<job_ls; ++i_loc) job_l[i_loc] = job_ll[i_loc];
  free(job_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, job, job_l, 0);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, a, a_ll, 0);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_l[i_loc] = lda_ll[i_loc];
  free(lda_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, lda, lda_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, b, b_ll, 0);
  for (i_loc=0; i_loc<ldb_ls; ++i_loc) ldb_l[i_loc] = ldb_ll[i_loc];
  free(ldb_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldb, ldb_l, 0);
  for (i_loc=0; i_loc<ilo_ls; ++i_loc) ilo_l[i_loc] = ilo_ll[i_loc];
  free(ilo_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ilo, ilo_l, 0);
  for (i_loc=0; i_loc<ihi_ls; ++i_loc) ihi_l[i_loc] = ihi_ll[i_loc];
  free(ihi_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ihi, ihi_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, lscale, lscale_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, rscale, rscale_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, work, work_ll, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_gges
(JNIEnv *env, jclass clazz, jcharArray jobvsl, jcharArray jobvsr, jcharArray sort, jobject delctg, jintArray n, jdoubleArray a, jintArray lda, jdoubleArray b, jintArray ldb, jintArray sdim, jdoubleArray alphar, jdoubleArray alphai, jdoubleArray beta, jdoubleArray vsl, jintArray ldvsl, jdoubleArray vsr, jintArray ldvsr, jdoubleArray work, jintArray lwork, jbooleanArray bwork, jintArray info) {
  int i_loc;
  jchar* jobvsl_l;
  char* jobvsl_ll;
  jsize jobvsl_ls;
  jchar* jobvsr_l;
  char* jobvsr_ll;
  jsize jobvsr_ls;
  jchar* sort_l;
  char* sort_ll;
  jsize sort_ls;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jdouble* a_ll;
  jint* lda_l;
  integer* lda_ll;
  jsize lda_ls;
  jdouble* b_ll;
  jint* ldb_l;
  integer* ldb_ll;
  jsize ldb_ls;
  jint* sdim_l;
  integer* sdim_ll;
  jsize sdim_ls;
  jdouble* alphar_ll;
  jdouble* alphai_ll;
  jdouble* beta_ll;
  jdouble* vsl_ll;
  jint* ldvsl_l;
  integer* ldvsl_ll;
  jsize ldvsl_ls;
  jdouble* vsr_ll;
  jint* ldvsr_l;
  integer* ldvsr_ll;
  jsize ldvsr_ls;
  jdouble* work_ll;
  jint* lwork_l;
  integer* lwork_ll;
  jsize lwork_ls;
  jboolean* bwork_l;
  integer* bwork_ll;
  jsize bwork_ls;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  jobvsl_l = (*env)->GetPrimitiveArrayCritical(env, jobvsl, NULL);
  jobvsl_ls = (*env)->GetArrayLength(env, jobvsl);
  jobvsl_ll = malloc(sizeof(char)*jobvsl_ls);
  for (i_loc=0; i_loc<jobvsl_ls; ++i_loc) jobvsl_ll[i_loc] = jobvsl_l[i_loc];
  jobvsr_l = (*env)->GetPrimitiveArrayCritical(env, jobvsr, NULL);
  jobvsr_ls = (*env)->GetArrayLength(env, jobvsr);
  jobvsr_ll = malloc(sizeof(char)*jobvsr_ls);
  for (i_loc=0; i_loc<jobvsr_ls; ++i_loc) jobvsr_ll[i_loc] = jobvsr_l[i_loc];
  sort_l = (*env)->GetPrimitiveArrayCritical(env, sort, NULL);
  sort_ls = (*env)->GetArrayLength(env, sort);
  sort_ll = malloc(sizeof(char)*sort_ls);
  for (i_loc=0; i_loc<sort_ls; ++i_loc) sort_ll[i_loc] = sort_l[i_loc];
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  a_ll = (*env)->GetPrimitiveArrayCritical(env, a, NULL);
  lda_l = (*env)->GetPrimitiveArrayCritical(env, lda, NULL);
  lda_ls = (*env)->GetArrayLength(env, lda);
  lda_ll = malloc(sizeof(integer)*lda_ls);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_ll[i_loc] = lda_l[i_loc];
  b_ll = (*env)->GetPrimitiveArrayCritical(env, b, NULL);
  ldb_l = (*env)->GetPrimitiveArrayCritical(env, ldb, NULL);
  ldb_ls = (*env)->GetArrayLength(env, ldb);
  ldb_ll = malloc(sizeof(integer)*ldb_ls);
  for (i_loc=0; i_loc<ldb_ls; ++i_loc) ldb_ll[i_loc] = ldb_l[i_loc];
  sdim_l = (*env)->GetPrimitiveArrayCritical(env, sdim, NULL);
  sdim_ls = (*env)->GetArrayLength(env, sdim);
  sdim_ll = malloc(sizeof(integer)*sdim_ls);
  for (i_loc=0; i_loc<sdim_ls; ++i_loc) sdim_ll[i_loc] = sdim_l[i_loc];
  alphar_ll = (*env)->GetPrimitiveArrayCritical(env, alphar, NULL);
  alphai_ll = (*env)->GetPrimitiveArrayCritical(env, alphai, NULL);
  beta_ll = (*env)->GetPrimitiveArrayCritical(env, beta, NULL);
  vsl_ll = (*env)->GetPrimitiveArrayCritical(env, vsl, NULL);
  ldvsl_l = (*env)->GetPrimitiveArrayCritical(env, ldvsl, NULL);
  ldvsl_ls = (*env)->GetArrayLength(env, ldvsl);
  ldvsl_ll = malloc(sizeof(integer)*ldvsl_ls);
  for (i_loc=0; i_loc<ldvsl_ls; ++i_loc) ldvsl_ll[i_loc] = ldvsl_l[i_loc];
  vsr_ll = (*env)->GetPrimitiveArrayCritical(env, vsr, NULL);
  ldvsr_l = (*env)->GetPrimitiveArrayCritical(env, ldvsr, NULL);
  ldvsr_ls = (*env)->GetArrayLength(env, ldvsr);
  ldvsr_ll = malloc(sizeof(integer)*ldvsr_ls);
  for (i_loc=0; i_loc<ldvsr_ls; ++i_loc) ldvsr_ll[i_loc] = ldvsr_l[i_loc];
  work_ll = (*env)->GetPrimitiveArrayCritical(env, work, NULL);
  lwork_l = (*env)->GetPrimitiveArrayCritical(env, lwork, NULL);
  lwork_ls = (*env)->GetArrayLength(env, lwork);
  lwork_ll = malloc(sizeof(integer)*lwork_ls);
  for (i_loc=0; i_loc<lwork_ls; ++i_loc) lwork_ll[i_loc] = lwork_l[i_loc];
  bwork_l = (*env)->GetPrimitiveArrayCritical(env, bwork, NULL);
  bwork_ls = (*env)->GetArrayLength(env, bwork);
  bwork_ll = malloc(sizeof(integer)*bwork_ls);
  for (i_loc=0; i_loc<bwork_ls; ++i_loc) bwork_ll[i_loc] = bwork_l[i_loc];
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dgges_(jobvsl_ll, jobvsr_ll, sort_ll, (L_fp)delctg, n_ll, a_ll, lda_ll, b_ll, ldb_ll, sdim_ll, alphar_ll, alphai_ll, beta_ll, vsl_ll, ldvsl_ll, vsr_ll, ldvsr_ll, work_ll, lwork_ll, bwork_ll, info_ll);

  for (i_loc=0; i_loc<jobvsl_ls; ++i_loc) jobvsl_l[i_loc] = jobvsl_ll[i_loc];
  free(jobvsl_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, jobvsl, jobvsl_l, 0);
  for (i_loc=0; i_loc<jobvsr_ls; ++i_loc) jobvsr_l[i_loc] = jobvsr_ll[i_loc];
  free(jobvsr_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, jobvsr, jobvsr_l, 0);
  for (i_loc=0; i_loc<sort_ls; ++i_loc) sort_l[i_loc] = sort_ll[i_loc];
  free(sort_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, sort, sort_l, 0);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, a, a_ll, 0);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_l[i_loc] = lda_ll[i_loc];
  free(lda_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, lda, lda_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, b, b_ll, 0);
  for (i_loc=0; i_loc<ldb_ls; ++i_loc) ldb_l[i_loc] = ldb_ll[i_loc];
  free(ldb_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldb, ldb_l, 0);
  for (i_loc=0; i_loc<sdim_ls; ++i_loc) sdim_l[i_loc] = sdim_ll[i_loc];
  free(sdim_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, sdim, sdim_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, alphar, alphar_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, alphai, alphai_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, beta, beta_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, vsl, vsl_ll, 0);
  for (i_loc=0; i_loc<ldvsl_ls; ++i_loc) ldvsl_l[i_loc] = ldvsl_ll[i_loc];
  free(ldvsl_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldvsl, ldvsl_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, vsr, vsr_ll, 0);
  for (i_loc=0; i_loc<ldvsr_ls; ++i_loc) ldvsr_l[i_loc] = ldvsr_ll[i_loc];
  free(ldvsr_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldvsr, ldvsr_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, work, work_ll, 0);
  for (i_loc=0; i_loc<lwork_ls; ++i_loc) lwork_l[i_loc] = lwork_ll[i_loc];
  free(lwork_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, lwork, lwork_l, 0);
  for (i_loc=0; i_loc<bwork_ls; ++i_loc) bwork_l[i_loc] = bwork_ll[i_loc];
  free(bwork_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, bwork, bwork_l, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_ggesx
(JNIEnv *env, jclass clazz, jcharArray jobvsl, jcharArray jobvsr, jcharArray sort, jobject delctg, jcharArray sense, jintArray n, jdoubleArray a, jintArray lda, jdoubleArray b, jintArray ldb, jintArray sdim, jdoubleArray alphar, jdoubleArray alphai, jdoubleArray beta, jdoubleArray vsl, jintArray ldvsl, jdoubleArray vsr, jintArray ldvsr, jdoubleArray rconde, jdoubleArray rcondv, jdoubleArray work, jintArray lwork, jintArray iwork, jintArray liwork, jbooleanArray bwork, jintArray info) {
  int i_loc;
  jchar* jobvsl_l;
  char* jobvsl_ll;
  jsize jobvsl_ls;
  jchar* jobvsr_l;
  char* jobvsr_ll;
  jsize jobvsr_ls;
  jchar* sort_l;
  char* sort_ll;
  jsize sort_ls;
  jchar* sense_l;
  char* sense_ll;
  jsize sense_ls;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jdouble* a_ll;
  jint* lda_l;
  integer* lda_ll;
  jsize lda_ls;
  jdouble* b_ll;
  jint* ldb_l;
  integer* ldb_ll;
  jsize ldb_ls;
  jint* sdim_l;
  integer* sdim_ll;
  jsize sdim_ls;
  jdouble* alphar_ll;
  jdouble* alphai_ll;
  jdouble* beta_ll;
  jdouble* vsl_ll;
  jint* ldvsl_l;
  integer* ldvsl_ll;
  jsize ldvsl_ls;
  jdouble* vsr_ll;
  jint* ldvsr_l;
  integer* ldvsr_ll;
  jsize ldvsr_ls;
  jdouble* rconde_ll;
  jdouble* rcondv_ll;
  jdouble* work_ll;
  jint* lwork_l;
  integer* lwork_ll;
  jsize lwork_ls;
  jint* iwork_l;
  integer* iwork_ll;
  jsize iwork_ls;
  jint* liwork_l;
  integer* liwork_ll;
  jsize liwork_ls;
  jboolean* bwork_l;
  integer* bwork_ll;
  jsize bwork_ls;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  jobvsl_l = (*env)->GetPrimitiveArrayCritical(env, jobvsl, NULL);
  jobvsl_ls = (*env)->GetArrayLength(env, jobvsl);
  jobvsl_ll = malloc(sizeof(char)*jobvsl_ls);
  for (i_loc=0; i_loc<jobvsl_ls; ++i_loc) jobvsl_ll[i_loc] = jobvsl_l[i_loc];
  jobvsr_l = (*env)->GetPrimitiveArrayCritical(env, jobvsr, NULL);
  jobvsr_ls = (*env)->GetArrayLength(env, jobvsr);
  jobvsr_ll = malloc(sizeof(char)*jobvsr_ls);
  for (i_loc=0; i_loc<jobvsr_ls; ++i_loc) jobvsr_ll[i_loc] = jobvsr_l[i_loc];
  sort_l = (*env)->GetPrimitiveArrayCritical(env, sort, NULL);
  sort_ls = (*env)->GetArrayLength(env, sort);
  sort_ll = malloc(sizeof(char)*sort_ls);
  for (i_loc=0; i_loc<sort_ls; ++i_loc) sort_ll[i_loc] = sort_l[i_loc];
  sense_l = (*env)->GetPrimitiveArrayCritical(env, sense, NULL);
  sense_ls = (*env)->GetArrayLength(env, sense);
  sense_ll = malloc(sizeof(char)*sense_ls);
  for (i_loc=0; i_loc<sense_ls; ++i_loc) sense_ll[i_loc] = sense_l[i_loc];
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  a_ll = (*env)->GetPrimitiveArrayCritical(env, a, NULL);
  lda_l = (*env)->GetPrimitiveArrayCritical(env, lda, NULL);
  lda_ls = (*env)->GetArrayLength(env, lda);
  lda_ll = malloc(sizeof(integer)*lda_ls);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_ll[i_loc] = lda_l[i_loc];
  b_ll = (*env)->GetPrimitiveArrayCritical(env, b, NULL);
  ldb_l = (*env)->GetPrimitiveArrayCritical(env, ldb, NULL);
  ldb_ls = (*env)->GetArrayLength(env, ldb);
  ldb_ll = malloc(sizeof(integer)*ldb_ls);
  for (i_loc=0; i_loc<ldb_ls; ++i_loc) ldb_ll[i_loc] = ldb_l[i_loc];
  sdim_l = (*env)->GetPrimitiveArrayCritical(env, sdim, NULL);
  sdim_ls = (*env)->GetArrayLength(env, sdim);
  sdim_ll = malloc(sizeof(integer)*sdim_ls);
  for (i_loc=0; i_loc<sdim_ls; ++i_loc) sdim_ll[i_loc] = sdim_l[i_loc];
  alphar_ll = (*env)->GetPrimitiveArrayCritical(env, alphar, NULL);
  alphai_ll = (*env)->GetPrimitiveArrayCritical(env, alphai, NULL);
  beta_ll = (*env)->GetPrimitiveArrayCritical(env, beta, NULL);
  vsl_ll = (*env)->GetPrimitiveArrayCritical(env, vsl, NULL);
  ldvsl_l = (*env)->GetPrimitiveArrayCritical(env, ldvsl, NULL);
  ldvsl_ls = (*env)->GetArrayLength(env, ldvsl);
  ldvsl_ll = malloc(sizeof(integer)*ldvsl_ls);
  for (i_loc=0; i_loc<ldvsl_ls; ++i_loc) ldvsl_ll[i_loc] = ldvsl_l[i_loc];
  vsr_ll = (*env)->GetPrimitiveArrayCritical(env, vsr, NULL);
  ldvsr_l = (*env)->GetPrimitiveArrayCritical(env, ldvsr, NULL);
  ldvsr_ls = (*env)->GetArrayLength(env, ldvsr);
  ldvsr_ll = malloc(sizeof(integer)*ldvsr_ls);
  for (i_loc=0; i_loc<ldvsr_ls; ++i_loc) ldvsr_ll[i_loc] = ldvsr_l[i_loc];
  rconde_ll = (*env)->GetPrimitiveArrayCritical(env, rconde, NULL);
  rcondv_ll = (*env)->GetPrimitiveArrayCritical(env, rcondv, NULL);
  work_ll = (*env)->GetPrimitiveArrayCritical(env, work, NULL);
  lwork_l = (*env)->GetPrimitiveArrayCritical(env, lwork, NULL);
  lwork_ls = (*env)->GetArrayLength(env, lwork);
  lwork_ll = malloc(sizeof(integer)*lwork_ls);
  for (i_loc=0; i_loc<lwork_ls; ++i_loc) lwork_ll[i_loc] = lwork_l[i_loc];
  iwork_l = (*env)->GetPrimitiveArrayCritical(env, iwork, NULL);
  iwork_ls = (*env)->GetArrayLength(env, iwork);
  iwork_ll = malloc(sizeof(integer)*iwork_ls);
  for (i_loc=0; i_loc<iwork_ls; ++i_loc) iwork_ll[i_loc] = iwork_l[i_loc];
  liwork_l = (*env)->GetPrimitiveArrayCritical(env, liwork, NULL);
  liwork_ls = (*env)->GetArrayLength(env, liwork);
  liwork_ll = malloc(sizeof(integer)*liwork_ls);
  for (i_loc=0; i_loc<liwork_ls; ++i_loc) liwork_ll[i_loc] = liwork_l[i_loc];
  bwork_l = (*env)->GetPrimitiveArrayCritical(env, bwork, NULL);
  bwork_ls = (*env)->GetArrayLength(env, bwork);
  bwork_ll = malloc(sizeof(integer)*bwork_ls);
  for (i_loc=0; i_loc<bwork_ls; ++i_loc) bwork_ll[i_loc] = bwork_l[i_loc];
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dggesx_(jobvsl_ll, jobvsr_ll, sort_ll, (L_fp)delctg, sense_ll, n_ll, a_ll, lda_ll, b_ll, ldb_ll, sdim_ll, alphar_ll, alphai_ll, beta_ll, vsl_ll, ldvsl_ll, vsr_ll, ldvsr_ll, rconde_ll, rcondv_ll, work_ll, lwork_ll, iwork_ll, liwork_ll, bwork_ll, info_ll);

  for (i_loc=0; i_loc<jobvsl_ls; ++i_loc) jobvsl_l[i_loc] = jobvsl_ll[i_loc];
  free(jobvsl_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, jobvsl, jobvsl_l, 0);
  for (i_loc=0; i_loc<jobvsr_ls; ++i_loc) jobvsr_l[i_loc] = jobvsr_ll[i_loc];
  free(jobvsr_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, jobvsr, jobvsr_l, 0);
  for (i_loc=0; i_loc<sort_ls; ++i_loc) sort_l[i_loc] = sort_ll[i_loc];
  free(sort_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, sort, sort_l, 0);
  for (i_loc=0; i_loc<sense_ls; ++i_loc) sense_l[i_loc] = sense_ll[i_loc];
  free(sense_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, sense, sense_l, 0);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, a, a_ll, 0);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_l[i_loc] = lda_ll[i_loc];
  free(lda_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, lda, lda_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, b, b_ll, 0);
  for (i_loc=0; i_loc<ldb_ls; ++i_loc) ldb_l[i_loc] = ldb_ll[i_loc];
  free(ldb_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldb, ldb_l, 0);
  for (i_loc=0; i_loc<sdim_ls; ++i_loc) sdim_l[i_loc] = sdim_ll[i_loc];
  free(sdim_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, sdim, sdim_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, alphar, alphar_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, alphai, alphai_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, beta, beta_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, vsl, vsl_ll, 0);
  for (i_loc=0; i_loc<ldvsl_ls; ++i_loc) ldvsl_l[i_loc] = ldvsl_ll[i_loc];
  free(ldvsl_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldvsl, ldvsl_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, vsr, vsr_ll, 0);
  for (i_loc=0; i_loc<ldvsr_ls; ++i_loc) ldvsr_l[i_loc] = ldvsr_ll[i_loc];
  free(ldvsr_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldvsr, ldvsr_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, rconde, rconde_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, rcondv, rcondv_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, work, work_ll, 0);
  for (i_loc=0; i_loc<lwork_ls; ++i_loc) lwork_l[i_loc] = lwork_ll[i_loc];
  free(lwork_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, lwork, lwork_l, 0);
  for (i_loc=0; i_loc<iwork_ls; ++i_loc) iwork_l[i_loc] = iwork_ll[i_loc];
  free(iwork_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, iwork, iwork_l, 0);
  for (i_loc=0; i_loc<liwork_ls; ++i_loc) liwork_l[i_loc] = liwork_ll[i_loc];
  free(liwork_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, liwork, liwork_l, 0);
  for (i_loc=0; i_loc<bwork_ls; ++i_loc) bwork_l[i_loc] = bwork_ll[i_loc];
  free(bwork_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, bwork, bwork_l, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_ggev
(JNIEnv *env, jclass clazz, jcharArray jobvl, jcharArray jobvr, jintArray n, jdoubleArray a, jintArray lda, jdoubleArray b, jintArray ldb, jdoubleArray alphar, jdoubleArray alphai, jdoubleArray beta, jdoubleArray vl, jintArray ldvl, jdoubleArray vr, jintArray ldvr, jdoubleArray work, jintArray lwork, jintArray info) {
  int i_loc;
  jchar* jobvl_l;
  char* jobvl_ll;
  jsize jobvl_ls;
  jchar* jobvr_l;
  char* jobvr_ll;
  jsize jobvr_ls;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jdouble* a_ll;
  jint* lda_l;
  integer* lda_ll;
  jsize lda_ls;
  jdouble* b_ll;
  jint* ldb_l;
  integer* ldb_ll;
  jsize ldb_ls;
  jdouble* alphar_ll;
  jdouble* alphai_ll;
  jdouble* beta_ll;
  jdouble* vl_ll;
  jint* ldvl_l;
  integer* ldvl_ll;
  jsize ldvl_ls;
  jdouble* vr_ll;
  jint* ldvr_l;
  integer* ldvr_ll;
  jsize ldvr_ls;
  jdouble* work_ll;
  jint* lwork_l;
  integer* lwork_ll;
  jsize lwork_ls;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  jobvl_l = (*env)->GetPrimitiveArrayCritical(env, jobvl, NULL);
  jobvl_ls = (*env)->GetArrayLength(env, jobvl);
  jobvl_ll = malloc(sizeof(char)*jobvl_ls);
  for (i_loc=0; i_loc<jobvl_ls; ++i_loc) jobvl_ll[i_loc] = jobvl_l[i_loc];
  jobvr_l = (*env)->GetPrimitiveArrayCritical(env, jobvr, NULL);
  jobvr_ls = (*env)->GetArrayLength(env, jobvr);
  jobvr_ll = malloc(sizeof(char)*jobvr_ls);
  for (i_loc=0; i_loc<jobvr_ls; ++i_loc) jobvr_ll[i_loc] = jobvr_l[i_loc];
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  a_ll = (*env)->GetPrimitiveArrayCritical(env, a, NULL);
  lda_l = (*env)->GetPrimitiveArrayCritical(env, lda, NULL);
  lda_ls = (*env)->GetArrayLength(env, lda);
  lda_ll = malloc(sizeof(integer)*lda_ls);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_ll[i_loc] = lda_l[i_loc];
  b_ll = (*env)->GetPrimitiveArrayCritical(env, b, NULL);
  ldb_l = (*env)->GetPrimitiveArrayCritical(env, ldb, NULL);
  ldb_ls = (*env)->GetArrayLength(env, ldb);
  ldb_ll = malloc(sizeof(integer)*ldb_ls);
  for (i_loc=0; i_loc<ldb_ls; ++i_loc) ldb_ll[i_loc] = ldb_l[i_loc];
  alphar_ll = (*env)->GetPrimitiveArrayCritical(env, alphar, NULL);
  alphai_ll = (*env)->GetPrimitiveArrayCritical(env, alphai, NULL);
  beta_ll = (*env)->GetPrimitiveArrayCritical(env, beta, NULL);
  vl_ll = (*env)->GetPrimitiveArrayCritical(env, vl, NULL);
  ldvl_l = (*env)->GetPrimitiveArrayCritical(env, ldvl, NULL);
  ldvl_ls = (*env)->GetArrayLength(env, ldvl);
  ldvl_ll = malloc(sizeof(integer)*ldvl_ls);
  for (i_loc=0; i_loc<ldvl_ls; ++i_loc) ldvl_ll[i_loc] = ldvl_l[i_loc];
  vr_ll = (*env)->GetPrimitiveArrayCritical(env, vr, NULL);
  ldvr_l = (*env)->GetPrimitiveArrayCritical(env, ldvr, NULL);
  ldvr_ls = (*env)->GetArrayLength(env, ldvr);
  ldvr_ll = malloc(sizeof(integer)*ldvr_ls);
  for (i_loc=0; i_loc<ldvr_ls; ++i_loc) ldvr_ll[i_loc] = ldvr_l[i_loc];
  work_ll = (*env)->GetPrimitiveArrayCritical(env, work, NULL);
  lwork_l = (*env)->GetPrimitiveArrayCritical(env, lwork, NULL);
  lwork_ls = (*env)->GetArrayLength(env, lwork);
  lwork_ll = malloc(sizeof(integer)*lwork_ls);
  for (i_loc=0; i_loc<lwork_ls; ++i_loc) lwork_ll[i_loc] = lwork_l[i_loc];
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dggev_(jobvl_ll, jobvr_ll, n_ll, a_ll, lda_ll, b_ll, ldb_ll, alphar_ll, alphai_ll, beta_ll, vl_ll, ldvl_ll, vr_ll, ldvr_ll, work_ll, lwork_ll, info_ll);

  for (i_loc=0; i_loc<jobvl_ls; ++i_loc) jobvl_l[i_loc] = jobvl_ll[i_loc];
  free(jobvl_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, jobvl, jobvl_l, 0);
  for (i_loc=0; i_loc<jobvr_ls; ++i_loc) jobvr_l[i_loc] = jobvr_ll[i_loc];
  free(jobvr_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, jobvr, jobvr_l, 0);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, a, a_ll, 0);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_l[i_loc] = lda_ll[i_loc];
  free(lda_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, lda, lda_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, b, b_ll, 0);
  for (i_loc=0; i_loc<ldb_ls; ++i_loc) ldb_l[i_loc] = ldb_ll[i_loc];
  free(ldb_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldb, ldb_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, alphar, alphar_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, alphai, alphai_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, beta, beta_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, vl, vl_ll, 0);
  for (i_loc=0; i_loc<ldvl_ls; ++i_loc) ldvl_l[i_loc] = ldvl_ll[i_loc];
  free(ldvl_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldvl, ldvl_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, vr, vr_ll, 0);
  for (i_loc=0; i_loc<ldvr_ls; ++i_loc) ldvr_l[i_loc] = ldvr_ll[i_loc];
  free(ldvr_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldvr, ldvr_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, work, work_ll, 0);
  for (i_loc=0; i_loc<lwork_ls; ++i_loc) lwork_l[i_loc] = lwork_ll[i_loc];
  free(lwork_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, lwork, lwork_l, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_ggevx
(JNIEnv *env, jclass clazz, jcharArray balanc, jcharArray jobvl, jcharArray jobvr, jcharArray sense, jintArray n, jdoubleArray a, jintArray lda, jdoubleArray b, jintArray ldb, jdoubleArray alphar, jdoubleArray alphai, jdoubleArray beta, jdoubleArray vl, jintArray ldvl, jdoubleArray vr, jintArray ldvr, jintArray ilo, jintArray ihi, jdoubleArray lscale, jdoubleArray rscale, jdoubleArray abnrm, jdoubleArray bbnrm, jdoubleArray rconde, jdoubleArray rcondv, jdoubleArray work, jintArray lwork, jintArray iwork, jbooleanArray bwork, jintArray info) {
  int i_loc;
  jchar* balanc_l;
  char* balanc_ll;
  jsize balanc_ls;
  jchar* jobvl_l;
  char* jobvl_ll;
  jsize jobvl_ls;
  jchar* jobvr_l;
  char* jobvr_ll;
  jsize jobvr_ls;
  jchar* sense_l;
  char* sense_ll;
  jsize sense_ls;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jdouble* a_ll;
  jint* lda_l;
  integer* lda_ll;
  jsize lda_ls;
  jdouble* b_ll;
  jint* ldb_l;
  integer* ldb_ll;
  jsize ldb_ls;
  jdouble* alphar_ll;
  jdouble* alphai_ll;
  jdouble* beta_ll;
  jdouble* vl_ll;
  jint* ldvl_l;
  integer* ldvl_ll;
  jsize ldvl_ls;
  jdouble* vr_ll;
  jint* ldvr_l;
  integer* ldvr_ll;
  jsize ldvr_ls;
  jint* ilo_l;
  integer* ilo_ll;
  jsize ilo_ls;
  jint* ihi_l;
  integer* ihi_ll;
  jsize ihi_ls;
  jdouble* lscale_ll;
  jdouble* rscale_ll;
  jdouble* abnrm_ll;
  jdouble* bbnrm_ll;
  jdouble* rconde_ll;
  jdouble* rcondv_ll;
  jdouble* work_ll;
  jint* lwork_l;
  integer* lwork_ll;
  jsize lwork_ls;
  jint* iwork_l;
  integer* iwork_ll;
  jsize iwork_ls;
  jboolean* bwork_l;
  integer* bwork_ll;
  jsize bwork_ls;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  balanc_l = (*env)->GetPrimitiveArrayCritical(env, balanc, NULL);
  balanc_ls = (*env)->GetArrayLength(env, balanc);
  balanc_ll = malloc(sizeof(char)*balanc_ls);
  for (i_loc=0; i_loc<balanc_ls; ++i_loc) balanc_ll[i_loc] = balanc_l[i_loc];
  jobvl_l = (*env)->GetPrimitiveArrayCritical(env, jobvl, NULL);
  jobvl_ls = (*env)->GetArrayLength(env, jobvl);
  jobvl_ll = malloc(sizeof(char)*jobvl_ls);
  for (i_loc=0; i_loc<jobvl_ls; ++i_loc) jobvl_ll[i_loc] = jobvl_l[i_loc];
  jobvr_l = (*env)->GetPrimitiveArrayCritical(env, jobvr, NULL);
  jobvr_ls = (*env)->GetArrayLength(env, jobvr);
  jobvr_ll = malloc(sizeof(char)*jobvr_ls);
  for (i_loc=0; i_loc<jobvr_ls; ++i_loc) jobvr_ll[i_loc] = jobvr_l[i_loc];
  sense_l = (*env)->GetPrimitiveArrayCritical(env, sense, NULL);
  sense_ls = (*env)->GetArrayLength(env, sense);
  sense_ll = malloc(sizeof(char)*sense_ls);
  for (i_loc=0; i_loc<sense_ls; ++i_loc) sense_ll[i_loc] = sense_l[i_loc];
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  a_ll = (*env)->GetPrimitiveArrayCritical(env, a, NULL);
  lda_l = (*env)->GetPrimitiveArrayCritical(env, lda, NULL);
  lda_ls = (*env)->GetArrayLength(env, lda);
  lda_ll = malloc(sizeof(integer)*lda_ls);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_ll[i_loc] = lda_l[i_loc];
  b_ll = (*env)->GetPrimitiveArrayCritical(env, b, NULL);
  ldb_l = (*env)->GetPrimitiveArrayCritical(env, ldb, NULL);
  ldb_ls = (*env)->GetArrayLength(env, ldb);
  ldb_ll = malloc(sizeof(integer)*ldb_ls);
  for (i_loc=0; i_loc<ldb_ls; ++i_loc) ldb_ll[i_loc] = ldb_l[i_loc];
  alphar_ll = (*env)->GetPrimitiveArrayCritical(env, alphar, NULL);
  alphai_ll = (*env)->GetPrimitiveArrayCritical(env, alphai, NULL);
  beta_ll = (*env)->GetPrimitiveArrayCritical(env, beta, NULL);
  vl_ll = (*env)->GetPrimitiveArrayCritical(env, vl, NULL);
  ldvl_l = (*env)->GetPrimitiveArrayCritical(env, ldvl, NULL);
  ldvl_ls = (*env)->GetArrayLength(env, ldvl);
  ldvl_ll = malloc(sizeof(integer)*ldvl_ls);
  for (i_loc=0; i_loc<ldvl_ls; ++i_loc) ldvl_ll[i_loc] = ldvl_l[i_loc];
  vr_ll = (*env)->GetPrimitiveArrayCritical(env, vr, NULL);
  ldvr_l = (*env)->GetPrimitiveArrayCritical(env, ldvr, NULL);
  ldvr_ls = (*env)->GetArrayLength(env, ldvr);
  ldvr_ll = malloc(sizeof(integer)*ldvr_ls);
  for (i_loc=0; i_loc<ldvr_ls; ++i_loc) ldvr_ll[i_loc] = ldvr_l[i_loc];
  ilo_l = (*env)->GetPrimitiveArrayCritical(env, ilo, NULL);
  ilo_ls = (*env)->GetArrayLength(env, ilo);
  ilo_ll = malloc(sizeof(integer)*ilo_ls);
  for (i_loc=0; i_loc<ilo_ls; ++i_loc) ilo_ll[i_loc] = ilo_l[i_loc];
  ihi_l = (*env)->GetPrimitiveArrayCritical(env, ihi, NULL);
  ihi_ls = (*env)->GetArrayLength(env, ihi);
  ihi_ll = malloc(sizeof(integer)*ihi_ls);
  for (i_loc=0; i_loc<ihi_ls; ++i_loc) ihi_ll[i_loc] = ihi_l[i_loc];
  lscale_ll = (*env)->GetPrimitiveArrayCritical(env, lscale, NULL);
  rscale_ll = (*env)->GetPrimitiveArrayCritical(env, rscale, NULL);
  abnrm_ll = (*env)->GetPrimitiveArrayCritical(env, abnrm, NULL);
  bbnrm_ll = (*env)->GetPrimitiveArrayCritical(env, bbnrm, NULL);
  rconde_ll = (*env)->GetPrimitiveArrayCritical(env, rconde, NULL);
  rcondv_ll = (*env)->GetPrimitiveArrayCritical(env, rcondv, NULL);
  work_ll = (*env)->GetPrimitiveArrayCritical(env, work, NULL);
  lwork_l = (*env)->GetPrimitiveArrayCritical(env, lwork, NULL);
  lwork_ls = (*env)->GetArrayLength(env, lwork);
  lwork_ll = malloc(sizeof(integer)*lwork_ls);
  for (i_loc=0; i_loc<lwork_ls; ++i_loc) lwork_ll[i_loc] = lwork_l[i_loc];
  iwork_l = (*env)->GetPrimitiveArrayCritical(env, iwork, NULL);
  iwork_ls = (*env)->GetArrayLength(env, iwork);
  iwork_ll = malloc(sizeof(integer)*iwork_ls);
  for (i_loc=0; i_loc<iwork_ls; ++i_loc) iwork_ll[i_loc] = iwork_l[i_loc];
  bwork_l = (*env)->GetPrimitiveArrayCritical(env, bwork, NULL);
  bwork_ls = (*env)->GetArrayLength(env, bwork);
  bwork_ll = malloc(sizeof(integer)*bwork_ls);
  for (i_loc=0; i_loc<bwork_ls; ++i_loc) bwork_ll[i_loc] = bwork_l[i_loc];
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dggevx_(balanc_ll, jobvl_ll, jobvr_ll, sense_ll, n_ll, a_ll, lda_ll, b_ll, ldb_ll, alphar_ll, alphai_ll, beta_ll, vl_ll, ldvl_ll, vr_ll, ldvr_ll, ilo_ll, ihi_ll, lscale_ll, rscale_ll, abnrm_ll, bbnrm_ll, rconde_ll, rcondv_ll, work_ll, lwork_ll, iwork_ll, bwork_ll, info_ll);

  for (i_loc=0; i_loc<balanc_ls; ++i_loc) balanc_l[i_loc] = balanc_ll[i_loc];
  free(balanc_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, balanc, balanc_l, 0);
  for (i_loc=0; i_loc<jobvl_ls; ++i_loc) jobvl_l[i_loc] = jobvl_ll[i_loc];
  free(jobvl_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, jobvl, jobvl_l, 0);
  for (i_loc=0; i_loc<jobvr_ls; ++i_loc) jobvr_l[i_loc] = jobvr_ll[i_loc];
  free(jobvr_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, jobvr, jobvr_l, 0);
  for (i_loc=0; i_loc<sense_ls; ++i_loc) sense_l[i_loc] = sense_ll[i_loc];
  free(sense_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, sense, sense_l, 0);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, a, a_ll, 0);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_l[i_loc] = lda_ll[i_loc];
  free(lda_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, lda, lda_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, b, b_ll, 0);
  for (i_loc=0; i_loc<ldb_ls; ++i_loc) ldb_l[i_loc] = ldb_ll[i_loc];
  free(ldb_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldb, ldb_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, alphar, alphar_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, alphai, alphai_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, beta, beta_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, vl, vl_ll, 0);
  for (i_loc=0; i_loc<ldvl_ls; ++i_loc) ldvl_l[i_loc] = ldvl_ll[i_loc];
  free(ldvl_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldvl, ldvl_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, vr, vr_ll, 0);
  for (i_loc=0; i_loc<ldvr_ls; ++i_loc) ldvr_l[i_loc] = ldvr_ll[i_loc];
  free(ldvr_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldvr, ldvr_l, 0);
  for (i_loc=0; i_loc<ilo_ls; ++i_loc) ilo_l[i_loc] = ilo_ll[i_loc];
  free(ilo_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ilo, ilo_l, 0);
  for (i_loc=0; i_loc<ihi_ls; ++i_loc) ihi_l[i_loc] = ihi_ll[i_loc];
  free(ihi_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ihi, ihi_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, lscale, lscale_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, rscale, rscale_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, abnrm, abnrm_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, bbnrm, bbnrm_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, rconde, rconde_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, rcondv, rcondv_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, work, work_ll, 0);
  for (i_loc=0; i_loc<lwork_ls; ++i_loc) lwork_l[i_loc] = lwork_ll[i_loc];
  free(lwork_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, lwork, lwork_l, 0);
  for (i_loc=0; i_loc<iwork_ls; ++i_loc) iwork_l[i_loc] = iwork_ll[i_loc];
  free(iwork_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, iwork, iwork_l, 0);
  for (i_loc=0; i_loc<bwork_ls; ++i_loc) bwork_l[i_loc] = bwork_ll[i_loc];
  free(bwork_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, bwork, bwork_l, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_ggglm
(JNIEnv *env, jclass clazz, jintArray n, jintArray m, jintArray p, jdoubleArray a, jintArray lda, jdoubleArray b, jintArray ldb, jdoubleArray d, jdoubleArray x, jdoubleArray y, jdoubleArray work, jintArray lwork, jintArray info) {
  int i_loc;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jint* m_l;
  integer* m_ll;
  jsize m_ls;
  jint* p_l;
  integer* p_ll;
  jsize p_ls;
  jdouble* a_ll;
  jint* lda_l;
  integer* lda_ll;
  jsize lda_ls;
  jdouble* b_ll;
  jint* ldb_l;
  integer* ldb_ll;
  jsize ldb_ls;
  jdouble* d_ll;
  jdouble* x_ll;
  jdouble* y_ll;
  jdouble* work_ll;
  jint* lwork_l;
  integer* lwork_ll;
  jsize lwork_ls;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  m_l = (*env)->GetPrimitiveArrayCritical(env, m, NULL);
  m_ls = (*env)->GetArrayLength(env, m);
  m_ll = malloc(sizeof(integer)*m_ls);
  for (i_loc=0; i_loc<m_ls; ++i_loc) m_ll[i_loc] = m_l[i_loc];
  p_l = (*env)->GetPrimitiveArrayCritical(env, p, NULL);
  p_ls = (*env)->GetArrayLength(env, p);
  p_ll = malloc(sizeof(integer)*p_ls);
  for (i_loc=0; i_loc<p_ls; ++i_loc) p_ll[i_loc] = p_l[i_loc];
  a_ll = (*env)->GetPrimitiveArrayCritical(env, a, NULL);
  lda_l = (*env)->GetPrimitiveArrayCritical(env, lda, NULL);
  lda_ls = (*env)->GetArrayLength(env, lda);
  lda_ll = malloc(sizeof(integer)*lda_ls);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_ll[i_loc] = lda_l[i_loc];
  b_ll = (*env)->GetPrimitiveArrayCritical(env, b, NULL);
  ldb_l = (*env)->GetPrimitiveArrayCritical(env, ldb, NULL);
  ldb_ls = (*env)->GetArrayLength(env, ldb);
  ldb_ll = malloc(sizeof(integer)*ldb_ls);
  for (i_loc=0; i_loc<ldb_ls; ++i_loc) ldb_ll[i_loc] = ldb_l[i_loc];
  d_ll = (*env)->GetPrimitiveArrayCritical(env, d, NULL);
  x_ll = (*env)->GetPrimitiveArrayCritical(env, x, NULL);
  y_ll = (*env)->GetPrimitiveArrayCritical(env, y, NULL);
  work_ll = (*env)->GetPrimitiveArrayCritical(env, work, NULL);
  lwork_l = (*env)->GetPrimitiveArrayCritical(env, lwork, NULL);
  lwork_ls = (*env)->GetArrayLength(env, lwork);
  lwork_ll = malloc(sizeof(integer)*lwork_ls);
  for (i_loc=0; i_loc<lwork_ls; ++i_loc) lwork_ll[i_loc] = lwork_l[i_loc];
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dggglm_(n_ll, m_ll, p_ll, a_ll, lda_ll, b_ll, ldb_ll, d_ll, x_ll, y_ll, work_ll, lwork_ll, info_ll);

  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  for (i_loc=0; i_loc<m_ls; ++i_loc) m_l[i_loc] = m_ll[i_loc];
  free(m_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, m, m_l, 0);
  for (i_loc=0; i_loc<p_ls; ++i_loc) p_l[i_loc] = p_ll[i_loc];
  free(p_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, p, p_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, a, a_ll, 0);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_l[i_loc] = lda_ll[i_loc];
  free(lda_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, lda, lda_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, b, b_ll, 0);
  for (i_loc=0; i_loc<ldb_ls; ++i_loc) ldb_l[i_loc] = ldb_ll[i_loc];
  free(ldb_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldb, ldb_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, d, d_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, x, x_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, y, y_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, work, work_ll, 0);
  for (i_loc=0; i_loc<lwork_ls; ++i_loc) lwork_l[i_loc] = lwork_ll[i_loc];
  free(lwork_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, lwork, lwork_l, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_gghrd
(JNIEnv *env, jclass clazz, jcharArray compq, jcharArray compz, jintArray n, jintArray ilo, jintArray ihi, jdoubleArray a, jintArray lda, jdoubleArray b, jintArray ldb, jdoubleArray q, jintArray ldq, jdoubleArray z, jintArray ldz, jintArray info) {
  int i_loc;
  jchar* compq_l;
  char* compq_ll;
  jsize compq_ls;
  jchar* compz_l;
  char* compz_ll;
  jsize compz_ls;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jint* ilo_l;
  integer* ilo_ll;
  jsize ilo_ls;
  jint* ihi_l;
  integer* ihi_ll;
  jsize ihi_ls;
  jdouble* a_ll;
  jint* lda_l;
  integer* lda_ll;
  jsize lda_ls;
  jdouble* b_ll;
  jint* ldb_l;
  integer* ldb_ll;
  jsize ldb_ls;
  jdouble* q_ll;
  jint* ldq_l;
  integer* ldq_ll;
  jsize ldq_ls;
  jdouble* z_ll;
  jint* ldz_l;
  integer* ldz_ll;
  jsize ldz_ls;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  compq_l = (*env)->GetPrimitiveArrayCritical(env, compq, NULL);
  compq_ls = (*env)->GetArrayLength(env, compq);
  compq_ll = malloc(sizeof(char)*compq_ls);
  for (i_loc=0; i_loc<compq_ls; ++i_loc) compq_ll[i_loc] = compq_l[i_loc];
  compz_l = (*env)->GetPrimitiveArrayCritical(env, compz, NULL);
  compz_ls = (*env)->GetArrayLength(env, compz);
  compz_ll = malloc(sizeof(char)*compz_ls);
  for (i_loc=0; i_loc<compz_ls; ++i_loc) compz_ll[i_loc] = compz_l[i_loc];
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  ilo_l = (*env)->GetPrimitiveArrayCritical(env, ilo, NULL);
  ilo_ls = (*env)->GetArrayLength(env, ilo);
  ilo_ll = malloc(sizeof(integer)*ilo_ls);
  for (i_loc=0; i_loc<ilo_ls; ++i_loc) ilo_ll[i_loc] = ilo_l[i_loc];
  ihi_l = (*env)->GetPrimitiveArrayCritical(env, ihi, NULL);
  ihi_ls = (*env)->GetArrayLength(env, ihi);
  ihi_ll = malloc(sizeof(integer)*ihi_ls);
  for (i_loc=0; i_loc<ihi_ls; ++i_loc) ihi_ll[i_loc] = ihi_l[i_loc];
  a_ll = (*env)->GetPrimitiveArrayCritical(env, a, NULL);
  lda_l = (*env)->GetPrimitiveArrayCritical(env, lda, NULL);
  lda_ls = (*env)->GetArrayLength(env, lda);
  lda_ll = malloc(sizeof(integer)*lda_ls);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_ll[i_loc] = lda_l[i_loc];
  b_ll = (*env)->GetPrimitiveArrayCritical(env, b, NULL);
  ldb_l = (*env)->GetPrimitiveArrayCritical(env, ldb, NULL);
  ldb_ls = (*env)->GetArrayLength(env, ldb);
  ldb_ll = malloc(sizeof(integer)*ldb_ls);
  for (i_loc=0; i_loc<ldb_ls; ++i_loc) ldb_ll[i_loc] = ldb_l[i_loc];
  q_ll = (*env)->GetPrimitiveArrayCritical(env, q, NULL);
  ldq_l = (*env)->GetPrimitiveArrayCritical(env, ldq, NULL);
  ldq_ls = (*env)->GetArrayLength(env, ldq);
  ldq_ll = malloc(sizeof(integer)*ldq_ls);
  for (i_loc=0; i_loc<ldq_ls; ++i_loc) ldq_ll[i_loc] = ldq_l[i_loc];
  z_ll = (*env)->GetPrimitiveArrayCritical(env, z, NULL);
  ldz_l = (*env)->GetPrimitiveArrayCritical(env, ldz, NULL);
  ldz_ls = (*env)->GetArrayLength(env, ldz);
  ldz_ll = malloc(sizeof(integer)*ldz_ls);
  for (i_loc=0; i_loc<ldz_ls; ++i_loc) ldz_ll[i_loc] = ldz_l[i_loc];
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dgghrd_(compq_ll, compz_ll, n_ll, ilo_ll, ihi_ll, a_ll, lda_ll, b_ll, ldb_ll, q_ll, ldq_ll, z_ll, ldz_ll, info_ll);

  for (i_loc=0; i_loc<compq_ls; ++i_loc) compq_l[i_loc] = compq_ll[i_loc];
  free(compq_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, compq, compq_l, 0);
  for (i_loc=0; i_loc<compz_ls; ++i_loc) compz_l[i_loc] = compz_ll[i_loc];
  free(compz_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, compz, compz_l, 0);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  for (i_loc=0; i_loc<ilo_ls; ++i_loc) ilo_l[i_loc] = ilo_ll[i_loc];
  free(ilo_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ilo, ilo_l, 0);
  for (i_loc=0; i_loc<ihi_ls; ++i_loc) ihi_l[i_loc] = ihi_ll[i_loc];
  free(ihi_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ihi, ihi_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, a, a_ll, 0);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_l[i_loc] = lda_ll[i_loc];
  free(lda_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, lda, lda_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, b, b_ll, 0);
  for (i_loc=0; i_loc<ldb_ls; ++i_loc) ldb_l[i_loc] = ldb_ll[i_loc];
  free(ldb_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldb, ldb_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, q, q_ll, 0);
  for (i_loc=0; i_loc<ldq_ls; ++i_loc) ldq_l[i_loc] = ldq_ll[i_loc];
  free(ldq_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldq, ldq_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, z, z_ll, 0);
  for (i_loc=0; i_loc<ldz_ls; ++i_loc) ldz_l[i_loc] = ldz_ll[i_loc];
  free(ldz_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldz, ldz_l, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_gglse
(JNIEnv *env, jclass clazz, jintArray m, jintArray n, jintArray p, jdoubleArray a, jintArray lda, jdoubleArray b, jintArray ldb, jdoubleArray c, jdoubleArray d, jdoubleArray x, jdoubleArray work, jintArray lwork, jintArray info) {
  int i_loc;
  jint* m_l;
  integer* m_ll;
  jsize m_ls;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jint* p_l;
  integer* p_ll;
  jsize p_ls;
  jdouble* a_ll;
  jint* lda_l;
  integer* lda_ll;
  jsize lda_ls;
  jdouble* b_ll;
  jint* ldb_l;
  integer* ldb_ll;
  jsize ldb_ls;
  jdouble* c_ll;
  jdouble* d_ll;
  jdouble* x_ll;
  jdouble* work_ll;
  jint* lwork_l;
  integer* lwork_ll;
  jsize lwork_ls;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  m_l = (*env)->GetPrimitiveArrayCritical(env, m, NULL);
  m_ls = (*env)->GetArrayLength(env, m);
  m_ll = malloc(sizeof(integer)*m_ls);
  for (i_loc=0; i_loc<m_ls; ++i_loc) m_ll[i_loc] = m_l[i_loc];
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  p_l = (*env)->GetPrimitiveArrayCritical(env, p, NULL);
  p_ls = (*env)->GetArrayLength(env, p);
  p_ll = malloc(sizeof(integer)*p_ls);
  for (i_loc=0; i_loc<p_ls; ++i_loc) p_ll[i_loc] = p_l[i_loc];
  a_ll = (*env)->GetPrimitiveArrayCritical(env, a, NULL);
  lda_l = (*env)->GetPrimitiveArrayCritical(env, lda, NULL);
  lda_ls = (*env)->GetArrayLength(env, lda);
  lda_ll = malloc(sizeof(integer)*lda_ls);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_ll[i_loc] = lda_l[i_loc];
  b_ll = (*env)->GetPrimitiveArrayCritical(env, b, NULL);
  ldb_l = (*env)->GetPrimitiveArrayCritical(env, ldb, NULL);
  ldb_ls = (*env)->GetArrayLength(env, ldb);
  ldb_ll = malloc(sizeof(integer)*ldb_ls);
  for (i_loc=0; i_loc<ldb_ls; ++i_loc) ldb_ll[i_loc] = ldb_l[i_loc];
  c_ll = (*env)->GetPrimitiveArrayCritical(env, c, NULL);
  d_ll = (*env)->GetPrimitiveArrayCritical(env, d, NULL);
  x_ll = (*env)->GetPrimitiveArrayCritical(env, x, NULL);
  work_ll = (*env)->GetPrimitiveArrayCritical(env, work, NULL);
  lwork_l = (*env)->GetPrimitiveArrayCritical(env, lwork, NULL);
  lwork_ls = (*env)->GetArrayLength(env, lwork);
  lwork_ll = malloc(sizeof(integer)*lwork_ls);
  for (i_loc=0; i_loc<lwork_ls; ++i_loc) lwork_ll[i_loc] = lwork_l[i_loc];
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dgglse_(m_ll, n_ll, p_ll, a_ll, lda_ll, b_ll, ldb_ll, c_ll, d_ll, x_ll, work_ll, lwork_ll, info_ll);

  for (i_loc=0; i_loc<m_ls; ++i_loc) m_l[i_loc] = m_ll[i_loc];
  free(m_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, m, m_l, 0);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  for (i_loc=0; i_loc<p_ls; ++i_loc) p_l[i_loc] = p_ll[i_loc];
  free(p_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, p, p_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, a, a_ll, 0);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_l[i_loc] = lda_ll[i_loc];
  free(lda_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, lda, lda_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, b, b_ll, 0);
  for (i_loc=0; i_loc<ldb_ls; ++i_loc) ldb_l[i_loc] = ldb_ll[i_loc];
  free(ldb_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldb, ldb_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, c, c_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, d, d_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, x, x_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, work, work_ll, 0);
  for (i_loc=0; i_loc<lwork_ls; ++i_loc) lwork_l[i_loc] = lwork_ll[i_loc];
  free(lwork_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, lwork, lwork_l, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_ggqrf
(JNIEnv *env, jclass clazz, jintArray n, jintArray m, jintArray p, jdoubleArray a, jintArray lda, jdoubleArray taua, jdoubleArray b, jintArray ldb, jdoubleArray taub, jdoubleArray work, jintArray lwork, jintArray info) {
  int i_loc;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jint* m_l;
  integer* m_ll;
  jsize m_ls;
  jint* p_l;
  integer* p_ll;
  jsize p_ls;
  jdouble* a_ll;
  jint* lda_l;
  integer* lda_ll;
  jsize lda_ls;
  jdouble* taua_ll;
  jdouble* b_ll;
  jint* ldb_l;
  integer* ldb_ll;
  jsize ldb_ls;
  jdouble* taub_ll;
  jdouble* work_ll;
  jint* lwork_l;
  integer* lwork_ll;
  jsize lwork_ls;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  m_l = (*env)->GetPrimitiveArrayCritical(env, m, NULL);
  m_ls = (*env)->GetArrayLength(env, m);
  m_ll = malloc(sizeof(integer)*m_ls);
  for (i_loc=0; i_loc<m_ls; ++i_loc) m_ll[i_loc] = m_l[i_loc];
  p_l = (*env)->GetPrimitiveArrayCritical(env, p, NULL);
  p_ls = (*env)->GetArrayLength(env, p);
  p_ll = malloc(sizeof(integer)*p_ls);
  for (i_loc=0; i_loc<p_ls; ++i_loc) p_ll[i_loc] = p_l[i_loc];
  a_ll = (*env)->GetPrimitiveArrayCritical(env, a, NULL);
  lda_l = (*env)->GetPrimitiveArrayCritical(env, lda, NULL);
  lda_ls = (*env)->GetArrayLength(env, lda);
  lda_ll = malloc(sizeof(integer)*lda_ls);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_ll[i_loc] = lda_l[i_loc];
  taua_ll = (*env)->GetPrimitiveArrayCritical(env, taua, NULL);
  b_ll = (*env)->GetPrimitiveArrayCritical(env, b, NULL);
  ldb_l = (*env)->GetPrimitiveArrayCritical(env, ldb, NULL);
  ldb_ls = (*env)->GetArrayLength(env, ldb);
  ldb_ll = malloc(sizeof(integer)*ldb_ls);
  for (i_loc=0; i_loc<ldb_ls; ++i_loc) ldb_ll[i_loc] = ldb_l[i_loc];
  taub_ll = (*env)->GetPrimitiveArrayCritical(env, taub, NULL);
  work_ll = (*env)->GetPrimitiveArrayCritical(env, work, NULL);
  lwork_l = (*env)->GetPrimitiveArrayCritical(env, lwork, NULL);
  lwork_ls = (*env)->GetArrayLength(env, lwork);
  lwork_ll = malloc(sizeof(integer)*lwork_ls);
  for (i_loc=0; i_loc<lwork_ls; ++i_loc) lwork_ll[i_loc] = lwork_l[i_loc];
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dggqrf_(n_ll, m_ll, p_ll, a_ll, lda_ll, taua_ll, b_ll, ldb_ll, taub_ll, work_ll, lwork_ll, info_ll);

  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  for (i_loc=0; i_loc<m_ls; ++i_loc) m_l[i_loc] = m_ll[i_loc];
  free(m_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, m, m_l, 0);
  for (i_loc=0; i_loc<p_ls; ++i_loc) p_l[i_loc] = p_ll[i_loc];
  free(p_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, p, p_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, a, a_ll, 0);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_l[i_loc] = lda_ll[i_loc];
  free(lda_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, lda, lda_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, taua, taua_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, b, b_ll, 0);
  for (i_loc=0; i_loc<ldb_ls; ++i_loc) ldb_l[i_loc] = ldb_ll[i_loc];
  free(ldb_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldb, ldb_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, taub, taub_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, work, work_ll, 0);
  for (i_loc=0; i_loc<lwork_ls; ++i_loc) lwork_l[i_loc] = lwork_ll[i_loc];
  free(lwork_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, lwork, lwork_l, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_ggrqf
(JNIEnv *env, jclass clazz, jintArray m, jintArray p, jintArray n, jdoubleArray a, jintArray lda, jdoubleArray taua, jdoubleArray b, jintArray ldb, jdoubleArray taub, jdoubleArray work, jintArray lwork, jintArray info) {
  int i_loc;
  jint* m_l;
  integer* m_ll;
  jsize m_ls;
  jint* p_l;
  integer* p_ll;
  jsize p_ls;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jdouble* a_ll;
  jint* lda_l;
  integer* lda_ll;
  jsize lda_ls;
  jdouble* taua_ll;
  jdouble* b_ll;
  jint* ldb_l;
  integer* ldb_ll;
  jsize ldb_ls;
  jdouble* taub_ll;
  jdouble* work_ll;
  jint* lwork_l;
  integer* lwork_ll;
  jsize lwork_ls;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  m_l = (*env)->GetPrimitiveArrayCritical(env, m, NULL);
  m_ls = (*env)->GetArrayLength(env, m);
  m_ll = malloc(sizeof(integer)*m_ls);
  for (i_loc=0; i_loc<m_ls; ++i_loc) m_ll[i_loc] = m_l[i_loc];
  p_l = (*env)->GetPrimitiveArrayCritical(env, p, NULL);
  p_ls = (*env)->GetArrayLength(env, p);
  p_ll = malloc(sizeof(integer)*p_ls);
  for (i_loc=0; i_loc<p_ls; ++i_loc) p_ll[i_loc] = p_l[i_loc];
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  a_ll = (*env)->GetPrimitiveArrayCritical(env, a, NULL);
  lda_l = (*env)->GetPrimitiveArrayCritical(env, lda, NULL);
  lda_ls = (*env)->GetArrayLength(env, lda);
  lda_ll = malloc(sizeof(integer)*lda_ls);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_ll[i_loc] = lda_l[i_loc];
  taua_ll = (*env)->GetPrimitiveArrayCritical(env, taua, NULL);
  b_ll = (*env)->GetPrimitiveArrayCritical(env, b, NULL);
  ldb_l = (*env)->GetPrimitiveArrayCritical(env, ldb, NULL);
  ldb_ls = (*env)->GetArrayLength(env, ldb);
  ldb_ll = malloc(sizeof(integer)*ldb_ls);
  for (i_loc=0; i_loc<ldb_ls; ++i_loc) ldb_ll[i_loc] = ldb_l[i_loc];
  taub_ll = (*env)->GetPrimitiveArrayCritical(env, taub, NULL);
  work_ll = (*env)->GetPrimitiveArrayCritical(env, work, NULL);
  lwork_l = (*env)->GetPrimitiveArrayCritical(env, lwork, NULL);
  lwork_ls = (*env)->GetArrayLength(env, lwork);
  lwork_ll = malloc(sizeof(integer)*lwork_ls);
  for (i_loc=0; i_loc<lwork_ls; ++i_loc) lwork_ll[i_loc] = lwork_l[i_loc];
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dggrqf_(m_ll, p_ll, n_ll, a_ll, lda_ll, taua_ll, b_ll, ldb_ll, taub_ll, work_ll, lwork_ll, info_ll);

  for (i_loc=0; i_loc<m_ls; ++i_loc) m_l[i_loc] = m_ll[i_loc];
  free(m_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, m, m_l, 0);
  for (i_loc=0; i_loc<p_ls; ++i_loc) p_l[i_loc] = p_ll[i_loc];
  free(p_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, p, p_l, 0);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, a, a_ll, 0);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_l[i_loc] = lda_ll[i_loc];
  free(lda_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, lda, lda_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, taua, taua_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, b, b_ll, 0);
  for (i_loc=0; i_loc<ldb_ls; ++i_loc) ldb_l[i_loc] = ldb_ll[i_loc];
  free(ldb_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldb, ldb_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, taub, taub_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, work, work_ll, 0);
  for (i_loc=0; i_loc<lwork_ls; ++i_loc) lwork_l[i_loc] = lwork_ll[i_loc];
  free(lwork_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, lwork, lwork_l, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_ggsvd
(JNIEnv *env, jclass clazz, jcharArray jobu, jcharArray jobv, jcharArray jobq, jintArray m, jintArray n, jintArray p, jintArray k, jintArray l, jdoubleArray a, jintArray lda, jdoubleArray b, jintArray ldb, jdoubleArray alpha, jdoubleArray beta, jdoubleArray u, jintArray ldu, jdoubleArray v, jintArray ldv, jdoubleArray q, jintArray ldq, jdoubleArray work, jintArray iwork, jintArray info) {
  int i_loc;
  jchar* jobu_l;
  char* jobu_ll;
  jsize jobu_ls;
  jchar* jobv_l;
  char* jobv_ll;
  jsize jobv_ls;
  jchar* jobq_l;
  char* jobq_ll;
  jsize jobq_ls;
  jint* m_l;
  integer* m_ll;
  jsize m_ls;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jint* p_l;
  integer* p_ll;
  jsize p_ls;
  jint* k_l;
  integer* k_ll;
  jsize k_ls;
  jint* l_l;
  integer* l_ll;
  jsize l_ls;
  jdouble* a_ll;
  jint* lda_l;
  integer* lda_ll;
  jsize lda_ls;
  jdouble* b_ll;
  jint* ldb_l;
  integer* ldb_ll;
  jsize ldb_ls;
  jdouble* alpha_ll;
  jdouble* beta_ll;
  jdouble* u_ll;
  jint* ldu_l;
  integer* ldu_ll;
  jsize ldu_ls;
  jdouble* v_ll;
  jint* ldv_l;
  integer* ldv_ll;
  jsize ldv_ls;
  jdouble* q_ll;
  jint* ldq_l;
  integer* ldq_ll;
  jsize ldq_ls;
  jdouble* work_ll;
  jint* iwork_l;
  integer* iwork_ll;
  jsize iwork_ls;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  jobu_l = (*env)->GetPrimitiveArrayCritical(env, jobu, NULL);
  jobu_ls = (*env)->GetArrayLength(env, jobu);
  jobu_ll = malloc(sizeof(char)*jobu_ls);
  for (i_loc=0; i_loc<jobu_ls; ++i_loc) jobu_ll[i_loc] = jobu_l[i_loc];
  jobv_l = (*env)->GetPrimitiveArrayCritical(env, jobv, NULL);
  jobv_ls = (*env)->GetArrayLength(env, jobv);
  jobv_ll = malloc(sizeof(char)*jobv_ls);
  for (i_loc=0; i_loc<jobv_ls; ++i_loc) jobv_ll[i_loc] = jobv_l[i_loc];
  jobq_l = (*env)->GetPrimitiveArrayCritical(env, jobq, NULL);
  jobq_ls = (*env)->GetArrayLength(env, jobq);
  jobq_ll = malloc(sizeof(char)*jobq_ls);
  for (i_loc=0; i_loc<jobq_ls; ++i_loc) jobq_ll[i_loc] = jobq_l[i_loc];
  m_l = (*env)->GetPrimitiveArrayCritical(env, m, NULL);
  m_ls = (*env)->GetArrayLength(env, m);
  m_ll = malloc(sizeof(integer)*m_ls);
  for (i_loc=0; i_loc<m_ls; ++i_loc) m_ll[i_loc] = m_l[i_loc];
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  p_l = (*env)->GetPrimitiveArrayCritical(env, p, NULL);
  p_ls = (*env)->GetArrayLength(env, p);
  p_ll = malloc(sizeof(integer)*p_ls);
  for (i_loc=0; i_loc<p_ls; ++i_loc) p_ll[i_loc] = p_l[i_loc];
  k_l = (*env)->GetPrimitiveArrayCritical(env, k, NULL);
  k_ls = (*env)->GetArrayLength(env, k);
  k_ll = malloc(sizeof(integer)*k_ls);
  for (i_loc=0; i_loc<k_ls; ++i_loc) k_ll[i_loc] = k_l[i_loc];
  l_l = (*env)->GetPrimitiveArrayCritical(env, l, NULL);
  l_ls = (*env)->GetArrayLength(env, l);
  l_ll = malloc(sizeof(integer)*l_ls);
  for (i_loc=0; i_loc<l_ls; ++i_loc) l_ll[i_loc] = l_l[i_loc];
  a_ll = (*env)->GetPrimitiveArrayCritical(env, a, NULL);
  lda_l = (*env)->GetPrimitiveArrayCritical(env, lda, NULL);
  lda_ls = (*env)->GetArrayLength(env, lda);
  lda_ll = malloc(sizeof(integer)*lda_ls);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_ll[i_loc] = lda_l[i_loc];
  b_ll = (*env)->GetPrimitiveArrayCritical(env, b, NULL);
  ldb_l = (*env)->GetPrimitiveArrayCritical(env, ldb, NULL);
  ldb_ls = (*env)->GetArrayLength(env, ldb);
  ldb_ll = malloc(sizeof(integer)*ldb_ls);
  for (i_loc=0; i_loc<ldb_ls; ++i_loc) ldb_ll[i_loc] = ldb_l[i_loc];
  alpha_ll = (*env)->GetPrimitiveArrayCritical(env, alpha, NULL);
  beta_ll = (*env)->GetPrimitiveArrayCritical(env, beta, NULL);
  u_ll = (*env)->GetPrimitiveArrayCritical(env, u, NULL);
  ldu_l = (*env)->GetPrimitiveArrayCritical(env, ldu, NULL);
  ldu_ls = (*env)->GetArrayLength(env, ldu);
  ldu_ll = malloc(sizeof(integer)*ldu_ls);
  for (i_loc=0; i_loc<ldu_ls; ++i_loc) ldu_ll[i_loc] = ldu_l[i_loc];
  v_ll = (*env)->GetPrimitiveArrayCritical(env, v, NULL);
  ldv_l = (*env)->GetPrimitiveArrayCritical(env, ldv, NULL);
  ldv_ls = (*env)->GetArrayLength(env, ldv);
  ldv_ll = malloc(sizeof(integer)*ldv_ls);
  for (i_loc=0; i_loc<ldv_ls; ++i_loc) ldv_ll[i_loc] = ldv_l[i_loc];
  q_ll = (*env)->GetPrimitiveArrayCritical(env, q, NULL);
  ldq_l = (*env)->GetPrimitiveArrayCritical(env, ldq, NULL);
  ldq_ls = (*env)->GetArrayLength(env, ldq);
  ldq_ll = malloc(sizeof(integer)*ldq_ls);
  for (i_loc=0; i_loc<ldq_ls; ++i_loc) ldq_ll[i_loc] = ldq_l[i_loc];
  work_ll = (*env)->GetPrimitiveArrayCritical(env, work, NULL);
  iwork_l = (*env)->GetPrimitiveArrayCritical(env, iwork, NULL);
  iwork_ls = (*env)->GetArrayLength(env, iwork);
  iwork_ll = malloc(sizeof(integer)*iwork_ls);
  for (i_loc=0; i_loc<iwork_ls; ++i_loc) iwork_ll[i_loc] = iwork_l[i_loc];
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dggsvd_(jobu_ll, jobv_ll, jobq_ll, m_ll, n_ll, p_ll, k_ll, l_ll, a_ll, lda_ll, b_ll, ldb_ll, alpha_ll, beta_ll, u_ll, ldu_ll, v_ll, ldv_ll, q_ll, ldq_ll, work_ll, iwork_ll, info_ll);

  for (i_loc=0; i_loc<jobu_ls; ++i_loc) jobu_l[i_loc] = jobu_ll[i_loc];
  free(jobu_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, jobu, jobu_l, 0);
  for (i_loc=0; i_loc<jobv_ls; ++i_loc) jobv_l[i_loc] = jobv_ll[i_loc];
  free(jobv_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, jobv, jobv_l, 0);
  for (i_loc=0; i_loc<jobq_ls; ++i_loc) jobq_l[i_loc] = jobq_ll[i_loc];
  free(jobq_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, jobq, jobq_l, 0);
  for (i_loc=0; i_loc<m_ls; ++i_loc) m_l[i_loc] = m_ll[i_loc];
  free(m_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, m, m_l, 0);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  for (i_loc=0; i_loc<p_ls; ++i_loc) p_l[i_loc] = p_ll[i_loc];
  free(p_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, p, p_l, 0);
  for (i_loc=0; i_loc<k_ls; ++i_loc) k_l[i_loc] = k_ll[i_loc];
  free(k_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, k, k_l, 0);
  for (i_loc=0; i_loc<l_ls; ++i_loc) l_l[i_loc] = l_ll[i_loc];
  free(l_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, l, l_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, a, a_ll, 0);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_l[i_loc] = lda_ll[i_loc];
  free(lda_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, lda, lda_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, b, b_ll, 0);
  for (i_loc=0; i_loc<ldb_ls; ++i_loc) ldb_l[i_loc] = ldb_ll[i_loc];
  free(ldb_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldb, ldb_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, alpha, alpha_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, beta, beta_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, u, u_ll, 0);
  for (i_loc=0; i_loc<ldu_ls; ++i_loc) ldu_l[i_loc] = ldu_ll[i_loc];
  free(ldu_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldu, ldu_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, v, v_ll, 0);
  for (i_loc=0; i_loc<ldv_ls; ++i_loc) ldv_l[i_loc] = ldv_ll[i_loc];
  free(ldv_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldv, ldv_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, q, q_ll, 0);
  for (i_loc=0; i_loc<ldq_ls; ++i_loc) ldq_l[i_loc] = ldq_ll[i_loc];
  free(ldq_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldq, ldq_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, work, work_ll, 0);
  for (i_loc=0; i_loc<iwork_ls; ++i_loc) iwork_l[i_loc] = iwork_ll[i_loc];
  free(iwork_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, iwork, iwork_l, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_ggsvp
(JNIEnv *env, jclass clazz, jcharArray jobu, jcharArray jobv, jcharArray jobq, jintArray m, jintArray p, jintArray n, jdoubleArray a, jintArray lda, jdoubleArray b, jintArray ldb, jdoubleArray tola, jdoubleArray tolb, jintArray k, jintArray l, jdoubleArray u, jintArray ldu, jdoubleArray v, jintArray ldv, jdoubleArray q, jintArray ldq, jintArray iwork, jdoubleArray tau, jdoubleArray work, jintArray info) {
  int i_loc;
  jchar* jobu_l;
  char* jobu_ll;
  jsize jobu_ls;
  jchar* jobv_l;
  char* jobv_ll;
  jsize jobv_ls;
  jchar* jobq_l;
  char* jobq_ll;
  jsize jobq_ls;
  jint* m_l;
  integer* m_ll;
  jsize m_ls;
  jint* p_l;
  integer* p_ll;
  jsize p_ls;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jdouble* a_ll;
  jint* lda_l;
  integer* lda_ll;
  jsize lda_ls;
  jdouble* b_ll;
  jint* ldb_l;
  integer* ldb_ll;
  jsize ldb_ls;
  jdouble* tola_ll;
  jdouble* tolb_ll;
  jint* k_l;
  integer* k_ll;
  jsize k_ls;
  jint* l_l;
  integer* l_ll;
  jsize l_ls;
  jdouble* u_ll;
  jint* ldu_l;
  integer* ldu_ll;
  jsize ldu_ls;
  jdouble* v_ll;
  jint* ldv_l;
  integer* ldv_ll;
  jsize ldv_ls;
  jdouble* q_ll;
  jint* ldq_l;
  integer* ldq_ll;
  jsize ldq_ls;
  jint* iwork_l;
  integer* iwork_ll;
  jsize iwork_ls;
  jdouble* tau_ll;
  jdouble* work_ll;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  jobu_l = (*env)->GetPrimitiveArrayCritical(env, jobu, NULL);
  jobu_ls = (*env)->GetArrayLength(env, jobu);
  jobu_ll = malloc(sizeof(char)*jobu_ls);
  for (i_loc=0; i_loc<jobu_ls; ++i_loc) jobu_ll[i_loc] = jobu_l[i_loc];
  jobv_l = (*env)->GetPrimitiveArrayCritical(env, jobv, NULL);
  jobv_ls = (*env)->GetArrayLength(env, jobv);
  jobv_ll = malloc(sizeof(char)*jobv_ls);
  for (i_loc=0; i_loc<jobv_ls; ++i_loc) jobv_ll[i_loc] = jobv_l[i_loc];
  jobq_l = (*env)->GetPrimitiveArrayCritical(env, jobq, NULL);
  jobq_ls = (*env)->GetArrayLength(env, jobq);
  jobq_ll = malloc(sizeof(char)*jobq_ls);
  for (i_loc=0; i_loc<jobq_ls; ++i_loc) jobq_ll[i_loc] = jobq_l[i_loc];
  m_l = (*env)->GetPrimitiveArrayCritical(env, m, NULL);
  m_ls = (*env)->GetArrayLength(env, m);
  m_ll = malloc(sizeof(integer)*m_ls);
  for (i_loc=0; i_loc<m_ls; ++i_loc) m_ll[i_loc] = m_l[i_loc];
  p_l = (*env)->GetPrimitiveArrayCritical(env, p, NULL);
  p_ls = (*env)->GetArrayLength(env, p);
  p_ll = malloc(sizeof(integer)*p_ls);
  for (i_loc=0; i_loc<p_ls; ++i_loc) p_ll[i_loc] = p_l[i_loc];
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  a_ll = (*env)->GetPrimitiveArrayCritical(env, a, NULL);
  lda_l = (*env)->GetPrimitiveArrayCritical(env, lda, NULL);
  lda_ls = (*env)->GetArrayLength(env, lda);
  lda_ll = malloc(sizeof(integer)*lda_ls);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_ll[i_loc] = lda_l[i_loc];
  b_ll = (*env)->GetPrimitiveArrayCritical(env, b, NULL);
  ldb_l = (*env)->GetPrimitiveArrayCritical(env, ldb, NULL);
  ldb_ls = (*env)->GetArrayLength(env, ldb);
  ldb_ll = malloc(sizeof(integer)*ldb_ls);
  for (i_loc=0; i_loc<ldb_ls; ++i_loc) ldb_ll[i_loc] = ldb_l[i_loc];
  tola_ll = (*env)->GetPrimitiveArrayCritical(env, tola, NULL);
  tolb_ll = (*env)->GetPrimitiveArrayCritical(env, tolb, NULL);
  k_l = (*env)->GetPrimitiveArrayCritical(env, k, NULL);
  k_ls = (*env)->GetArrayLength(env, k);
  k_ll = malloc(sizeof(integer)*k_ls);
  for (i_loc=0; i_loc<k_ls; ++i_loc) k_ll[i_loc] = k_l[i_loc];
  l_l = (*env)->GetPrimitiveArrayCritical(env, l, NULL);
  l_ls = (*env)->GetArrayLength(env, l);
  l_ll = malloc(sizeof(integer)*l_ls);
  for (i_loc=0; i_loc<l_ls; ++i_loc) l_ll[i_loc] = l_l[i_loc];
  u_ll = (*env)->GetPrimitiveArrayCritical(env, u, NULL);
  ldu_l = (*env)->GetPrimitiveArrayCritical(env, ldu, NULL);
  ldu_ls = (*env)->GetArrayLength(env, ldu);
  ldu_ll = malloc(sizeof(integer)*ldu_ls);
  for (i_loc=0; i_loc<ldu_ls; ++i_loc) ldu_ll[i_loc] = ldu_l[i_loc];
  v_ll = (*env)->GetPrimitiveArrayCritical(env, v, NULL);
  ldv_l = (*env)->GetPrimitiveArrayCritical(env, ldv, NULL);
  ldv_ls = (*env)->GetArrayLength(env, ldv);
  ldv_ll = malloc(sizeof(integer)*ldv_ls);
  for (i_loc=0; i_loc<ldv_ls; ++i_loc) ldv_ll[i_loc] = ldv_l[i_loc];
  q_ll = (*env)->GetPrimitiveArrayCritical(env, q, NULL);
  ldq_l = (*env)->GetPrimitiveArrayCritical(env, ldq, NULL);
  ldq_ls = (*env)->GetArrayLength(env, ldq);
  ldq_ll = malloc(sizeof(integer)*ldq_ls);
  for (i_loc=0; i_loc<ldq_ls; ++i_loc) ldq_ll[i_loc] = ldq_l[i_loc];
  iwork_l = (*env)->GetPrimitiveArrayCritical(env, iwork, NULL);
  iwork_ls = (*env)->GetArrayLength(env, iwork);
  iwork_ll = malloc(sizeof(integer)*iwork_ls);
  for (i_loc=0; i_loc<iwork_ls; ++i_loc) iwork_ll[i_loc] = iwork_l[i_loc];
  tau_ll = (*env)->GetPrimitiveArrayCritical(env, tau, NULL);
  work_ll = (*env)->GetPrimitiveArrayCritical(env, work, NULL);
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dggsvp_(jobu_ll, jobv_ll, jobq_ll, m_ll, p_ll, n_ll, a_ll, lda_ll, b_ll, ldb_ll, tola_ll, tolb_ll, k_ll, l_ll, u_ll, ldu_ll, v_ll, ldv_ll, q_ll, ldq_ll, iwork_ll, tau_ll, work_ll, info_ll);

  for (i_loc=0; i_loc<jobu_ls; ++i_loc) jobu_l[i_loc] = jobu_ll[i_loc];
  free(jobu_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, jobu, jobu_l, 0);
  for (i_loc=0; i_loc<jobv_ls; ++i_loc) jobv_l[i_loc] = jobv_ll[i_loc];
  free(jobv_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, jobv, jobv_l, 0);
  for (i_loc=0; i_loc<jobq_ls; ++i_loc) jobq_l[i_loc] = jobq_ll[i_loc];
  free(jobq_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, jobq, jobq_l, 0);
  for (i_loc=0; i_loc<m_ls; ++i_loc) m_l[i_loc] = m_ll[i_loc];
  free(m_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, m, m_l, 0);
  for (i_loc=0; i_loc<p_ls; ++i_loc) p_l[i_loc] = p_ll[i_loc];
  free(p_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, p, p_l, 0);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, a, a_ll, 0);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_l[i_loc] = lda_ll[i_loc];
  free(lda_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, lda, lda_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, b, b_ll, 0);
  for (i_loc=0; i_loc<ldb_ls; ++i_loc) ldb_l[i_loc] = ldb_ll[i_loc];
  free(ldb_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldb, ldb_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, tola, tola_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, tolb, tolb_ll, 0);
  for (i_loc=0; i_loc<k_ls; ++i_loc) k_l[i_loc] = k_ll[i_loc];
  free(k_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, k, k_l, 0);
  for (i_loc=0; i_loc<l_ls; ++i_loc) l_l[i_loc] = l_ll[i_loc];
  free(l_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, l, l_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, u, u_ll, 0);
  for (i_loc=0; i_loc<ldu_ls; ++i_loc) ldu_l[i_loc] = ldu_ll[i_loc];
  free(ldu_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldu, ldu_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, v, v_ll, 0);
  for (i_loc=0; i_loc<ldv_ls; ++i_loc) ldv_l[i_loc] = ldv_ll[i_loc];
  free(ldv_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldv, ldv_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, q, q_ll, 0);
  for (i_loc=0; i_loc<ldq_ls; ++i_loc) ldq_l[i_loc] = ldq_ll[i_loc];
  free(ldq_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldq, ldq_l, 0);
  for (i_loc=0; i_loc<iwork_ls; ++i_loc) iwork_l[i_loc] = iwork_ll[i_loc];
  free(iwork_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, iwork, iwork_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, tau, tau_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, work, work_ll, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_gtcon
(JNIEnv *env, jclass clazz, jcharArray norm, jintArray n, jdoubleArray dl, jdoubleArray d, jdoubleArray du, jdoubleArray du2, jintArray ipiv, jdoubleArray anorm, jdoubleArray rcond, jdoubleArray work, jintArray iwork, jintArray info) {
  int i_loc;
  jchar* norm_l;
  char* norm_ll;
  jsize norm_ls;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jdouble* dl_ll;
  jdouble* d_ll;
  jdouble* du_ll;
  jdouble* du2_ll;
  jint* ipiv_l;
  integer* ipiv_ll;
  jsize ipiv_ls;
  jdouble* anorm_ll;
  jdouble* rcond_ll;
  jdouble* work_ll;
  jint* iwork_l;
  integer* iwork_ll;
  jsize iwork_ls;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  norm_l = (*env)->GetPrimitiveArrayCritical(env, norm, NULL);
  norm_ls = (*env)->GetArrayLength(env, norm);
  norm_ll = malloc(sizeof(char)*norm_ls);
  for (i_loc=0; i_loc<norm_ls; ++i_loc) norm_ll[i_loc] = norm_l[i_loc];
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  dl_ll = (*env)->GetPrimitiveArrayCritical(env, dl, NULL);
  d_ll = (*env)->GetPrimitiveArrayCritical(env, d, NULL);
  du_ll = (*env)->GetPrimitiveArrayCritical(env, du, NULL);
  du2_ll = (*env)->GetPrimitiveArrayCritical(env, du2, NULL);
  ipiv_l = (*env)->GetPrimitiveArrayCritical(env, ipiv, NULL);
  ipiv_ls = (*env)->GetArrayLength(env, ipiv);
  ipiv_ll = malloc(sizeof(integer)*ipiv_ls);
  for (i_loc=0; i_loc<ipiv_ls; ++i_loc) ipiv_ll[i_loc] = ipiv_l[i_loc];
  anorm_ll = (*env)->GetPrimitiveArrayCritical(env, anorm, NULL);
  rcond_ll = (*env)->GetPrimitiveArrayCritical(env, rcond, NULL);
  work_ll = (*env)->GetPrimitiveArrayCritical(env, work, NULL);
  iwork_l = (*env)->GetPrimitiveArrayCritical(env, iwork, NULL);
  iwork_ls = (*env)->GetArrayLength(env, iwork);
  iwork_ll = malloc(sizeof(integer)*iwork_ls);
  for (i_loc=0; i_loc<iwork_ls; ++i_loc) iwork_ll[i_loc] = iwork_l[i_loc];
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dgtcon_(norm_ll, n_ll, dl_ll, d_ll, du_ll, du2_ll, ipiv_ll, anorm_ll, rcond_ll, work_ll, iwork_ll, info_ll);

  for (i_loc=0; i_loc<norm_ls; ++i_loc) norm_l[i_loc] = norm_ll[i_loc];
  free(norm_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, norm, norm_l, 0);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, dl, dl_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, d, d_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, du, du_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, du2, du2_ll, 0);
  for (i_loc=0; i_loc<ipiv_ls; ++i_loc) ipiv_l[i_loc] = ipiv_ll[i_loc];
  free(ipiv_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ipiv, ipiv_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, anorm, anorm_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, rcond, rcond_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, work, work_ll, 0);
  for (i_loc=0; i_loc<iwork_ls; ++i_loc) iwork_l[i_loc] = iwork_ll[i_loc];
  free(iwork_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, iwork, iwork_l, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_gtrfs
(JNIEnv *env, jclass clazz, jcharArray trans, jintArray n, jintArray nrhs, jdoubleArray dl, jdoubleArray d, jdoubleArray du, jdoubleArray dlf, jdoubleArray df, jdoubleArray duf, jdoubleArray du2, jintArray ipiv, jdoubleArray b, jintArray ldb, jdoubleArray x, jintArray ldx, jdoubleArray ferr, jdoubleArray berr, jdoubleArray work, jintArray iwork, jintArray info) {
  int i_loc;
  jchar* trans_l;
  char* trans_ll;
  jsize trans_ls;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jint* nrhs_l;
  integer* nrhs_ll;
  jsize nrhs_ls;
  jdouble* dl_ll;
  jdouble* d_ll;
  jdouble* du_ll;
  jdouble* dlf_ll;
  jdouble* df_ll;
  jdouble* duf_ll;
  jdouble* du2_ll;
  jint* ipiv_l;
  integer* ipiv_ll;
  jsize ipiv_ls;
  jdouble* b_ll;
  jint* ldb_l;
  integer* ldb_ll;
  jsize ldb_ls;
  jdouble* x_ll;
  jint* ldx_l;
  integer* ldx_ll;
  jsize ldx_ls;
  jdouble* ferr_ll;
  jdouble* berr_ll;
  jdouble* work_ll;
  jint* iwork_l;
  integer* iwork_ll;
  jsize iwork_ls;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  trans_l = (*env)->GetPrimitiveArrayCritical(env, trans, NULL);
  trans_ls = (*env)->GetArrayLength(env, trans);
  trans_ll = malloc(sizeof(char)*trans_ls);
  for (i_loc=0; i_loc<trans_ls; ++i_loc) trans_ll[i_loc] = trans_l[i_loc];
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  nrhs_l = (*env)->GetPrimitiveArrayCritical(env, nrhs, NULL);
  nrhs_ls = (*env)->GetArrayLength(env, nrhs);
  nrhs_ll = malloc(sizeof(integer)*nrhs_ls);
  for (i_loc=0; i_loc<nrhs_ls; ++i_loc) nrhs_ll[i_loc] = nrhs_l[i_loc];
  dl_ll = (*env)->GetPrimitiveArrayCritical(env, dl, NULL);
  d_ll = (*env)->GetPrimitiveArrayCritical(env, d, NULL);
  du_ll = (*env)->GetPrimitiveArrayCritical(env, du, NULL);
  dlf_ll = (*env)->GetPrimitiveArrayCritical(env, dlf, NULL);
  df_ll = (*env)->GetPrimitiveArrayCritical(env, df, NULL);
  duf_ll = (*env)->GetPrimitiveArrayCritical(env, duf, NULL);
  du2_ll = (*env)->GetPrimitiveArrayCritical(env, du2, NULL);
  ipiv_l = (*env)->GetPrimitiveArrayCritical(env, ipiv, NULL);
  ipiv_ls = (*env)->GetArrayLength(env, ipiv);
  ipiv_ll = malloc(sizeof(integer)*ipiv_ls);
  for (i_loc=0; i_loc<ipiv_ls; ++i_loc) ipiv_ll[i_loc] = ipiv_l[i_loc];
  b_ll = (*env)->GetPrimitiveArrayCritical(env, b, NULL);
  ldb_l = (*env)->GetPrimitiveArrayCritical(env, ldb, NULL);
  ldb_ls = (*env)->GetArrayLength(env, ldb);
  ldb_ll = malloc(sizeof(integer)*ldb_ls);
  for (i_loc=0; i_loc<ldb_ls; ++i_loc) ldb_ll[i_loc] = ldb_l[i_loc];
  x_ll = (*env)->GetPrimitiveArrayCritical(env, x, NULL);
  ldx_l = (*env)->GetPrimitiveArrayCritical(env, ldx, NULL);
  ldx_ls = (*env)->GetArrayLength(env, ldx);
  ldx_ll = malloc(sizeof(integer)*ldx_ls);
  for (i_loc=0; i_loc<ldx_ls; ++i_loc) ldx_ll[i_loc] = ldx_l[i_loc];
  ferr_ll = (*env)->GetPrimitiveArrayCritical(env, ferr, NULL);
  berr_ll = (*env)->GetPrimitiveArrayCritical(env, berr, NULL);
  work_ll = (*env)->GetPrimitiveArrayCritical(env, work, NULL);
  iwork_l = (*env)->GetPrimitiveArrayCritical(env, iwork, NULL);
  iwork_ls = (*env)->GetArrayLength(env, iwork);
  iwork_ll = malloc(sizeof(integer)*iwork_ls);
  for (i_loc=0; i_loc<iwork_ls; ++i_loc) iwork_ll[i_loc] = iwork_l[i_loc];
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dgtrfs_(trans_ll, n_ll, nrhs_ll, dl_ll, d_ll, du_ll, dlf_ll, df_ll, duf_ll, du2_ll, ipiv_ll, b_ll, ldb_ll, x_ll, ldx_ll, ferr_ll, berr_ll, work_ll, iwork_ll, info_ll);

  for (i_loc=0; i_loc<trans_ls; ++i_loc) trans_l[i_loc] = trans_ll[i_loc];
  free(trans_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, trans, trans_l, 0);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  for (i_loc=0; i_loc<nrhs_ls; ++i_loc) nrhs_l[i_loc] = nrhs_ll[i_loc];
  free(nrhs_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, nrhs, nrhs_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, dl, dl_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, d, d_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, du, du_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, dlf, dlf_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, df, df_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, duf, duf_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, du2, du2_ll, 0);
  for (i_loc=0; i_loc<ipiv_ls; ++i_loc) ipiv_l[i_loc] = ipiv_ll[i_loc];
  free(ipiv_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ipiv, ipiv_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, b, b_ll, 0);
  for (i_loc=0; i_loc<ldb_ls; ++i_loc) ldb_l[i_loc] = ldb_ll[i_loc];
  free(ldb_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldb, ldb_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, x, x_ll, 0);
  for (i_loc=0; i_loc<ldx_ls; ++i_loc) ldx_l[i_loc] = ldx_ll[i_loc];
  free(ldx_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldx, ldx_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, ferr, ferr_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, berr, berr_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, work, work_ll, 0);
  for (i_loc=0; i_loc<iwork_ls; ++i_loc) iwork_l[i_loc] = iwork_ll[i_loc];
  free(iwork_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, iwork, iwork_l, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_gtsv
(JNIEnv *env, jclass clazz, jintArray n, jintArray nrhs, jdoubleArray dl, jdoubleArray d, jdoubleArray du, jdoubleArray b, jintArray ldb, jintArray info) {
  int i_loc;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jint* nrhs_l;
  integer* nrhs_ll;
  jsize nrhs_ls;
  jdouble* dl_ll;
  jdouble* d_ll;
  jdouble* du_ll;
  jdouble* b_ll;
  jint* ldb_l;
  integer* ldb_ll;
  jsize ldb_ls;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  nrhs_l = (*env)->GetPrimitiveArrayCritical(env, nrhs, NULL);
  nrhs_ls = (*env)->GetArrayLength(env, nrhs);
  nrhs_ll = malloc(sizeof(integer)*nrhs_ls);
  for (i_loc=0; i_loc<nrhs_ls; ++i_loc) nrhs_ll[i_loc] = nrhs_l[i_loc];
  dl_ll = (*env)->GetPrimitiveArrayCritical(env, dl, NULL);
  d_ll = (*env)->GetPrimitiveArrayCritical(env, d, NULL);
  du_ll = (*env)->GetPrimitiveArrayCritical(env, du, NULL);
  b_ll = (*env)->GetPrimitiveArrayCritical(env, b, NULL);
  ldb_l = (*env)->GetPrimitiveArrayCritical(env, ldb, NULL);
  ldb_ls = (*env)->GetArrayLength(env, ldb);
  ldb_ll = malloc(sizeof(integer)*ldb_ls);
  for (i_loc=0; i_loc<ldb_ls; ++i_loc) ldb_ll[i_loc] = ldb_l[i_loc];
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dgtsv_(n_ll, nrhs_ll, dl_ll, d_ll, du_ll, b_ll, ldb_ll, info_ll);

  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  for (i_loc=0; i_loc<nrhs_ls; ++i_loc) nrhs_l[i_loc] = nrhs_ll[i_loc];
  free(nrhs_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, nrhs, nrhs_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, dl, dl_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, d, d_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, du, du_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, b, b_ll, 0);
  for (i_loc=0; i_loc<ldb_ls; ++i_loc) ldb_l[i_loc] = ldb_ll[i_loc];
  free(ldb_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldb, ldb_l, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_gtsvx
(JNIEnv *env, jclass clazz, jcharArray fact, jcharArray trans, jintArray n, jintArray nrhs, jdoubleArray dl, jdoubleArray d, jdoubleArray du, jdoubleArray dlf, jdoubleArray df, jdoubleArray duf, jdoubleArray du2, jintArray ipiv, jdoubleArray b, jintArray ldb, jdoubleArray x, jintArray ldx, jdoubleArray rcond, jdoubleArray ferr, jdoubleArray berr, jdoubleArray work, jintArray iwork, jintArray info) {
  int i_loc;
  jchar* fact_l;
  char* fact_ll;
  jsize fact_ls;
  jchar* trans_l;
  char* trans_ll;
  jsize trans_ls;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jint* nrhs_l;
  integer* nrhs_ll;
  jsize nrhs_ls;
  jdouble* dl_ll;
  jdouble* d_ll;
  jdouble* du_ll;
  jdouble* dlf_ll;
  jdouble* df_ll;
  jdouble* duf_ll;
  jdouble* du2_ll;
  jint* ipiv_l;
  integer* ipiv_ll;
  jsize ipiv_ls;
  jdouble* b_ll;
  jint* ldb_l;
  integer* ldb_ll;
  jsize ldb_ls;
  jdouble* x_ll;
  jint* ldx_l;
  integer* ldx_ll;
  jsize ldx_ls;
  jdouble* rcond_ll;
  jdouble* ferr_ll;
  jdouble* berr_ll;
  jdouble* work_ll;
  jint* iwork_l;
  integer* iwork_ll;
  jsize iwork_ls;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  fact_l = (*env)->GetPrimitiveArrayCritical(env, fact, NULL);
  fact_ls = (*env)->GetArrayLength(env, fact);
  fact_ll = malloc(sizeof(char)*fact_ls);
  for (i_loc=0; i_loc<fact_ls; ++i_loc) fact_ll[i_loc] = fact_l[i_loc];
  trans_l = (*env)->GetPrimitiveArrayCritical(env, trans, NULL);
  trans_ls = (*env)->GetArrayLength(env, trans);
  trans_ll = malloc(sizeof(char)*trans_ls);
  for (i_loc=0; i_loc<trans_ls; ++i_loc) trans_ll[i_loc] = trans_l[i_loc];
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  nrhs_l = (*env)->GetPrimitiveArrayCritical(env, nrhs, NULL);
  nrhs_ls = (*env)->GetArrayLength(env, nrhs);
  nrhs_ll = malloc(sizeof(integer)*nrhs_ls);
  for (i_loc=0; i_loc<nrhs_ls; ++i_loc) nrhs_ll[i_loc] = nrhs_l[i_loc];
  dl_ll = (*env)->GetPrimitiveArrayCritical(env, dl, NULL);
  d_ll = (*env)->GetPrimitiveArrayCritical(env, d, NULL);
  du_ll = (*env)->GetPrimitiveArrayCritical(env, du, NULL);
  dlf_ll = (*env)->GetPrimitiveArrayCritical(env, dlf, NULL);
  df_ll = (*env)->GetPrimitiveArrayCritical(env, df, NULL);
  duf_ll = (*env)->GetPrimitiveArrayCritical(env, duf, NULL);
  du2_ll = (*env)->GetPrimitiveArrayCritical(env, du2, NULL);
  ipiv_l = (*env)->GetPrimitiveArrayCritical(env, ipiv, NULL);
  ipiv_ls = (*env)->GetArrayLength(env, ipiv);
  ipiv_ll = malloc(sizeof(integer)*ipiv_ls);
  for (i_loc=0; i_loc<ipiv_ls; ++i_loc) ipiv_ll[i_loc] = ipiv_l[i_loc];
  b_ll = (*env)->GetPrimitiveArrayCritical(env, b, NULL);
  ldb_l = (*env)->GetPrimitiveArrayCritical(env, ldb, NULL);
  ldb_ls = (*env)->GetArrayLength(env, ldb);
  ldb_ll = malloc(sizeof(integer)*ldb_ls);
  for (i_loc=0; i_loc<ldb_ls; ++i_loc) ldb_ll[i_loc] = ldb_l[i_loc];
  x_ll = (*env)->GetPrimitiveArrayCritical(env, x, NULL);
  ldx_l = (*env)->GetPrimitiveArrayCritical(env, ldx, NULL);
  ldx_ls = (*env)->GetArrayLength(env, ldx);
  ldx_ll = malloc(sizeof(integer)*ldx_ls);
  for (i_loc=0; i_loc<ldx_ls; ++i_loc) ldx_ll[i_loc] = ldx_l[i_loc];
  rcond_ll = (*env)->GetPrimitiveArrayCritical(env, rcond, NULL);
  ferr_ll = (*env)->GetPrimitiveArrayCritical(env, ferr, NULL);
  berr_ll = (*env)->GetPrimitiveArrayCritical(env, berr, NULL);
  work_ll = (*env)->GetPrimitiveArrayCritical(env, work, NULL);
  iwork_l = (*env)->GetPrimitiveArrayCritical(env, iwork, NULL);
  iwork_ls = (*env)->GetArrayLength(env, iwork);
  iwork_ll = malloc(sizeof(integer)*iwork_ls);
  for (i_loc=0; i_loc<iwork_ls; ++i_loc) iwork_ll[i_loc] = iwork_l[i_loc];
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dgtsvx_(fact_ll, trans_ll, n_ll, nrhs_ll, dl_ll, d_ll, du_ll, dlf_ll, df_ll, duf_ll, du2_ll, ipiv_ll, b_ll, ldb_ll, x_ll, ldx_ll, rcond_ll, ferr_ll, berr_ll, work_ll, iwork_ll, info_ll);

  for (i_loc=0; i_loc<fact_ls; ++i_loc) fact_l[i_loc] = fact_ll[i_loc];
  free(fact_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, fact, fact_l, 0);
  for (i_loc=0; i_loc<trans_ls; ++i_loc) trans_l[i_loc] = trans_ll[i_loc];
  free(trans_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, trans, trans_l, 0);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  for (i_loc=0; i_loc<nrhs_ls; ++i_loc) nrhs_l[i_loc] = nrhs_ll[i_loc];
  free(nrhs_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, nrhs, nrhs_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, dl, dl_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, d, d_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, du, du_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, dlf, dlf_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, df, df_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, duf, duf_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, du2, du2_ll, 0);
  for (i_loc=0; i_loc<ipiv_ls; ++i_loc) ipiv_l[i_loc] = ipiv_ll[i_loc];
  free(ipiv_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ipiv, ipiv_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, b, b_ll, 0);
  for (i_loc=0; i_loc<ldb_ls; ++i_loc) ldb_l[i_loc] = ldb_ll[i_loc];
  free(ldb_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldb, ldb_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, x, x_ll, 0);
  for (i_loc=0; i_loc<ldx_ls; ++i_loc) ldx_l[i_loc] = ldx_ll[i_loc];
  free(ldx_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldx, ldx_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, rcond, rcond_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, ferr, ferr_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, berr, berr_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, work, work_ll, 0);
  for (i_loc=0; i_loc<iwork_ls; ++i_loc) iwork_l[i_loc] = iwork_ll[i_loc];
  free(iwork_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, iwork, iwork_l, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_gttrf
(JNIEnv *env, jclass clazz, jintArray n, jdoubleArray dl, jdoubleArray d, jdoubleArray du, jdoubleArray du2, jintArray ipiv, jintArray info) {
  int i_loc;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jdouble* dl_ll;
  jdouble* d_ll;
  jdouble* du_ll;
  jdouble* du2_ll;
  jint* ipiv_l;
  integer* ipiv_ll;
  jsize ipiv_ls;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  dl_ll = (*env)->GetPrimitiveArrayCritical(env, dl, NULL);
  d_ll = (*env)->GetPrimitiveArrayCritical(env, d, NULL);
  du_ll = (*env)->GetPrimitiveArrayCritical(env, du, NULL);
  du2_ll = (*env)->GetPrimitiveArrayCritical(env, du2, NULL);
  ipiv_l = (*env)->GetPrimitiveArrayCritical(env, ipiv, NULL);
  ipiv_ls = (*env)->GetArrayLength(env, ipiv);
  ipiv_ll = malloc(sizeof(integer)*ipiv_ls);
  for (i_loc=0; i_loc<ipiv_ls; ++i_loc) ipiv_ll[i_loc] = ipiv_l[i_loc];
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dgttrf_(n_ll, dl_ll, d_ll, du_ll, du2_ll, ipiv_ll, info_ll);

  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, dl, dl_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, d, d_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, du, du_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, du2, du2_ll, 0);
  for (i_loc=0; i_loc<ipiv_ls; ++i_loc) ipiv_l[i_loc] = ipiv_ll[i_loc];
  free(ipiv_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ipiv, ipiv_l, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_gttrs
(JNIEnv *env, jclass clazz, jcharArray trans, jintArray n, jintArray nrhs, jdoubleArray dl, jdoubleArray d, jdoubleArray du, jdoubleArray du2, jintArray ipiv, jdoubleArray b, jintArray ldb, jintArray info) {
  int i_loc;
  jchar* trans_l;
  char* trans_ll;
  jsize trans_ls;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jint* nrhs_l;
  integer* nrhs_ll;
  jsize nrhs_ls;
  jdouble* dl_ll;
  jdouble* d_ll;
  jdouble* du_ll;
  jdouble* du2_ll;
  jint* ipiv_l;
  integer* ipiv_ll;
  jsize ipiv_ls;
  jdouble* b_ll;
  jint* ldb_l;
  integer* ldb_ll;
  jsize ldb_ls;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  trans_l = (*env)->GetPrimitiveArrayCritical(env, trans, NULL);
  trans_ls = (*env)->GetArrayLength(env, trans);
  trans_ll = malloc(sizeof(char)*trans_ls);
  for (i_loc=0; i_loc<trans_ls; ++i_loc) trans_ll[i_loc] = trans_l[i_loc];
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  nrhs_l = (*env)->GetPrimitiveArrayCritical(env, nrhs, NULL);
  nrhs_ls = (*env)->GetArrayLength(env, nrhs);
  nrhs_ll = malloc(sizeof(integer)*nrhs_ls);
  for (i_loc=0; i_loc<nrhs_ls; ++i_loc) nrhs_ll[i_loc] = nrhs_l[i_loc];
  dl_ll = (*env)->GetPrimitiveArrayCritical(env, dl, NULL);
  d_ll = (*env)->GetPrimitiveArrayCritical(env, d, NULL);
  du_ll = (*env)->GetPrimitiveArrayCritical(env, du, NULL);
  du2_ll = (*env)->GetPrimitiveArrayCritical(env, du2, NULL);
  ipiv_l = (*env)->GetPrimitiveArrayCritical(env, ipiv, NULL);
  ipiv_ls = (*env)->GetArrayLength(env, ipiv);
  ipiv_ll = malloc(sizeof(integer)*ipiv_ls);
  for (i_loc=0; i_loc<ipiv_ls; ++i_loc) ipiv_ll[i_loc] = ipiv_l[i_loc];
  b_ll = (*env)->GetPrimitiveArrayCritical(env, b, NULL);
  ldb_l = (*env)->GetPrimitiveArrayCritical(env, ldb, NULL);
  ldb_ls = (*env)->GetArrayLength(env, ldb);
  ldb_ll = malloc(sizeof(integer)*ldb_ls);
  for (i_loc=0; i_loc<ldb_ls; ++i_loc) ldb_ll[i_loc] = ldb_l[i_loc];
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dgttrs_(trans_ll, n_ll, nrhs_ll, dl_ll, d_ll, du_ll, du2_ll, ipiv_ll, b_ll, ldb_ll, info_ll);

  for (i_loc=0; i_loc<trans_ls; ++i_loc) trans_l[i_loc] = trans_ll[i_loc];
  free(trans_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, trans, trans_l, 0);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  for (i_loc=0; i_loc<nrhs_ls; ++i_loc) nrhs_l[i_loc] = nrhs_ll[i_loc];
  free(nrhs_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, nrhs, nrhs_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, dl, dl_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, d, d_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, du, du_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, du2, du2_ll, 0);
  for (i_loc=0; i_loc<ipiv_ls; ++i_loc) ipiv_l[i_loc] = ipiv_ll[i_loc];
  free(ipiv_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ipiv, ipiv_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, b, b_ll, 0);
  for (i_loc=0; i_loc<ldb_ls; ++i_loc) ldb_l[i_loc] = ldb_ll[i_loc];
  free(ldb_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldb, ldb_l, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_gtts2
(JNIEnv *env, jclass clazz, jintArray itrans, jintArray n, jintArray nrhs, jdoubleArray dl, jdoubleArray d, jdoubleArray du, jdoubleArray du2, jintArray ipiv, jdoubleArray b, jintArray ldb) {
  int i_loc;
  jint* itrans_l;
  integer* itrans_ll;
  jsize itrans_ls;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jint* nrhs_l;
  integer* nrhs_ll;
  jsize nrhs_ls;
  jdouble* dl_ll;
  jdouble* d_ll;
  jdouble* du_ll;
  jdouble* du2_ll;
  jint* ipiv_l;
  integer* ipiv_ll;
  jsize ipiv_ls;
  jdouble* b_ll;
  jint* ldb_l;
  integer* ldb_ll;
  jsize ldb_ls;
  itrans_l = (*env)->GetPrimitiveArrayCritical(env, itrans, NULL);
  itrans_ls = (*env)->GetArrayLength(env, itrans);
  itrans_ll = malloc(sizeof(integer)*itrans_ls);
  for (i_loc=0; i_loc<itrans_ls; ++i_loc) itrans_ll[i_loc] = itrans_l[i_loc];
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  nrhs_l = (*env)->GetPrimitiveArrayCritical(env, nrhs, NULL);
  nrhs_ls = (*env)->GetArrayLength(env, nrhs);
  nrhs_ll = malloc(sizeof(integer)*nrhs_ls);
  for (i_loc=0; i_loc<nrhs_ls; ++i_loc) nrhs_ll[i_loc] = nrhs_l[i_loc];
  dl_ll = (*env)->GetPrimitiveArrayCritical(env, dl, NULL);
  d_ll = (*env)->GetPrimitiveArrayCritical(env, d, NULL);
  du_ll = (*env)->GetPrimitiveArrayCritical(env, du, NULL);
  du2_ll = (*env)->GetPrimitiveArrayCritical(env, du2, NULL);
  ipiv_l = (*env)->GetPrimitiveArrayCritical(env, ipiv, NULL);
  ipiv_ls = (*env)->GetArrayLength(env, ipiv);
  ipiv_ll = malloc(sizeof(integer)*ipiv_ls);
  for (i_loc=0; i_loc<ipiv_ls; ++i_loc) ipiv_ll[i_loc] = ipiv_l[i_loc];
  b_ll = (*env)->GetPrimitiveArrayCritical(env, b, NULL);
  ldb_l = (*env)->GetPrimitiveArrayCritical(env, ldb, NULL);
  ldb_ls = (*env)->GetArrayLength(env, ldb);
  ldb_ll = malloc(sizeof(integer)*ldb_ls);
  for (i_loc=0; i_loc<ldb_ls; ++i_loc) ldb_ll[i_loc] = ldb_l[i_loc];

  dgtts2_(itrans_ll, n_ll, nrhs_ll, dl_ll, d_ll, du_ll, du2_ll, ipiv_ll, b_ll, ldb_ll);

  for (i_loc=0; i_loc<itrans_ls; ++i_loc) itrans_l[i_loc] = itrans_ll[i_loc];
  free(itrans_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, itrans, itrans_l, 0);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  for (i_loc=0; i_loc<nrhs_ls; ++i_loc) nrhs_l[i_loc] = nrhs_ll[i_loc];
  free(nrhs_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, nrhs, nrhs_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, dl, dl_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, d, d_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, du, du_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, du2, du2_ll, 0);
  for (i_loc=0; i_loc<ipiv_ls; ++i_loc) ipiv_l[i_loc] = ipiv_ll[i_loc];
  free(ipiv_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ipiv, ipiv_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, b, b_ll, 0);
  for (i_loc=0; i_loc<ldb_ls; ++i_loc) ldb_l[i_loc] = ldb_ll[i_loc];
  free(ldb_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldb, ldb_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_hgeqz
(JNIEnv *env, jclass clazz, jcharArray job, jcharArray compq, jcharArray compz, jintArray n, jintArray ilo, jintArray ihi, jdoubleArray a, jintArray lda, jdoubleArray b, jintArray ldb, jdoubleArray alphar, jdoubleArray alphai, jdoubleArray beta, jdoubleArray q, jintArray ldq, jdoubleArray z, jintArray ldz, jdoubleArray work, jintArray lwork, jintArray info) {
  int i_loc;
  jchar* job_l;
  char* job_ll;
  jsize job_ls;
  jchar* compq_l;
  char* compq_ll;
  jsize compq_ls;
  jchar* compz_l;
  char* compz_ll;
  jsize compz_ls;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jint* ilo_l;
  integer* ilo_ll;
  jsize ilo_ls;
  jint* ihi_l;
  integer* ihi_ll;
  jsize ihi_ls;
  jdouble* a_ll;
  jint* lda_l;
  integer* lda_ll;
  jsize lda_ls;
  jdouble* b_ll;
  jint* ldb_l;
  integer* ldb_ll;
  jsize ldb_ls;
  jdouble* alphar_ll;
  jdouble* alphai_ll;
  jdouble* beta_ll;
  jdouble* q_ll;
  jint* ldq_l;
  integer* ldq_ll;
  jsize ldq_ls;
  jdouble* z_ll;
  jint* ldz_l;
  integer* ldz_ll;
  jsize ldz_ls;
  jdouble* work_ll;
  jint* lwork_l;
  integer* lwork_ll;
  jsize lwork_ls;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  job_l = (*env)->GetPrimitiveArrayCritical(env, job, NULL);
  job_ls = (*env)->GetArrayLength(env, job);
  job_ll = malloc(sizeof(char)*job_ls);
  for (i_loc=0; i_loc<job_ls; ++i_loc) job_ll[i_loc] = job_l[i_loc];
  compq_l = (*env)->GetPrimitiveArrayCritical(env, compq, NULL);
  compq_ls = (*env)->GetArrayLength(env, compq);
  compq_ll = malloc(sizeof(char)*compq_ls);
  for (i_loc=0; i_loc<compq_ls; ++i_loc) compq_ll[i_loc] = compq_l[i_loc];
  compz_l = (*env)->GetPrimitiveArrayCritical(env, compz, NULL);
  compz_ls = (*env)->GetArrayLength(env, compz);
  compz_ll = malloc(sizeof(char)*compz_ls);
  for (i_loc=0; i_loc<compz_ls; ++i_loc) compz_ll[i_loc] = compz_l[i_loc];
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  ilo_l = (*env)->GetPrimitiveArrayCritical(env, ilo, NULL);
  ilo_ls = (*env)->GetArrayLength(env, ilo);
  ilo_ll = malloc(sizeof(integer)*ilo_ls);
  for (i_loc=0; i_loc<ilo_ls; ++i_loc) ilo_ll[i_loc] = ilo_l[i_loc];
  ihi_l = (*env)->GetPrimitiveArrayCritical(env, ihi, NULL);
  ihi_ls = (*env)->GetArrayLength(env, ihi);
  ihi_ll = malloc(sizeof(integer)*ihi_ls);
  for (i_loc=0; i_loc<ihi_ls; ++i_loc) ihi_ll[i_loc] = ihi_l[i_loc];
  a_ll = (*env)->GetPrimitiveArrayCritical(env, a, NULL);
  lda_l = (*env)->GetPrimitiveArrayCritical(env, lda, NULL);
  lda_ls = (*env)->GetArrayLength(env, lda);
  lda_ll = malloc(sizeof(integer)*lda_ls);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_ll[i_loc] = lda_l[i_loc];
  b_ll = (*env)->GetPrimitiveArrayCritical(env, b, NULL);
  ldb_l = (*env)->GetPrimitiveArrayCritical(env, ldb, NULL);
  ldb_ls = (*env)->GetArrayLength(env, ldb);
  ldb_ll = malloc(sizeof(integer)*ldb_ls);
  for (i_loc=0; i_loc<ldb_ls; ++i_loc) ldb_ll[i_loc] = ldb_l[i_loc];
  alphar_ll = (*env)->GetPrimitiveArrayCritical(env, alphar, NULL);
  alphai_ll = (*env)->GetPrimitiveArrayCritical(env, alphai, NULL);
  beta_ll = (*env)->GetPrimitiveArrayCritical(env, beta, NULL);
  q_ll = (*env)->GetPrimitiveArrayCritical(env, q, NULL);
  ldq_l = (*env)->GetPrimitiveArrayCritical(env, ldq, NULL);
  ldq_ls = (*env)->GetArrayLength(env, ldq);
  ldq_ll = malloc(sizeof(integer)*ldq_ls);
  for (i_loc=0; i_loc<ldq_ls; ++i_loc) ldq_ll[i_loc] = ldq_l[i_loc];
  z_ll = (*env)->GetPrimitiveArrayCritical(env, z, NULL);
  ldz_l = (*env)->GetPrimitiveArrayCritical(env, ldz, NULL);
  ldz_ls = (*env)->GetArrayLength(env, ldz);
  ldz_ll = malloc(sizeof(integer)*ldz_ls);
  for (i_loc=0; i_loc<ldz_ls; ++i_loc) ldz_ll[i_loc] = ldz_l[i_loc];
  work_ll = (*env)->GetPrimitiveArrayCritical(env, work, NULL);
  lwork_l = (*env)->GetPrimitiveArrayCritical(env, lwork, NULL);
  lwork_ls = (*env)->GetArrayLength(env, lwork);
  lwork_ll = malloc(sizeof(integer)*lwork_ls);
  for (i_loc=0; i_loc<lwork_ls; ++i_loc) lwork_ll[i_loc] = lwork_l[i_loc];
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dhgeqz_(job_ll, compq_ll, compz_ll, n_ll, ilo_ll, ihi_ll, a_ll, lda_ll, b_ll, ldb_ll, alphar_ll, alphai_ll, beta_ll, q_ll, ldq_ll, z_ll, ldz_ll, work_ll, lwork_ll, info_ll);

  for (i_loc=0; i_loc<job_ls; ++i_loc) job_l[i_loc] = job_ll[i_loc];
  free(job_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, job, job_l, 0);
  for (i_loc=0; i_loc<compq_ls; ++i_loc) compq_l[i_loc] = compq_ll[i_loc];
  free(compq_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, compq, compq_l, 0);
  for (i_loc=0; i_loc<compz_ls; ++i_loc) compz_l[i_loc] = compz_ll[i_loc];
  free(compz_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, compz, compz_l, 0);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  for (i_loc=0; i_loc<ilo_ls; ++i_loc) ilo_l[i_loc] = ilo_ll[i_loc];
  free(ilo_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ilo, ilo_l, 0);
  for (i_loc=0; i_loc<ihi_ls; ++i_loc) ihi_l[i_loc] = ihi_ll[i_loc];
  free(ihi_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ihi, ihi_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, a, a_ll, 0);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_l[i_loc] = lda_ll[i_loc];
  free(lda_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, lda, lda_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, b, b_ll, 0);
  for (i_loc=0; i_loc<ldb_ls; ++i_loc) ldb_l[i_loc] = ldb_ll[i_loc];
  free(ldb_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldb, ldb_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, alphar, alphar_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, alphai, alphai_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, beta, beta_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, q, q_ll, 0);
  for (i_loc=0; i_loc<ldq_ls; ++i_loc) ldq_l[i_loc] = ldq_ll[i_loc];
  free(ldq_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldq, ldq_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, z, z_ll, 0);
  for (i_loc=0; i_loc<ldz_ls; ++i_loc) ldz_l[i_loc] = ldz_ll[i_loc];
  free(ldz_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldz, ldz_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, work, work_ll, 0);
  for (i_loc=0; i_loc<lwork_ls; ++i_loc) lwork_l[i_loc] = lwork_ll[i_loc];
  free(lwork_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, lwork, lwork_l, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_hsein
(JNIEnv *env, jclass clazz, jcharArray side, jcharArray eigsrc, jcharArray initv, jbooleanArray select, jintArray n, jdoubleArray h, jintArray ldh, jdoubleArray wr, jdoubleArray wi, jdoubleArray vl, jintArray ldvl, jdoubleArray vr, jintArray ldvr, jintArray mm, jintArray m, jdoubleArray work, jintArray ifaill, jintArray ifailr, jintArray info) {
  int i_loc;
  jchar* side_l;
  char* side_ll;
  jsize side_ls;
  jchar* eigsrc_l;
  char* eigsrc_ll;
  jsize eigsrc_ls;
  jchar* initv_l;
  char* initv_ll;
  jsize initv_ls;
  jboolean* select_l;
  integer* select_ll;
  jsize select_ls;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jdouble* h_ll;
  jint* ldh_l;
  integer* ldh_ll;
  jsize ldh_ls;
  jdouble* wr_ll;
  jdouble* wi_ll;
  jdouble* vl_ll;
  jint* ldvl_l;
  integer* ldvl_ll;
  jsize ldvl_ls;
  jdouble* vr_ll;
  jint* ldvr_l;
  integer* ldvr_ll;
  jsize ldvr_ls;
  jint* mm_l;
  integer* mm_ll;
  jsize mm_ls;
  jint* m_l;
  integer* m_ll;
  jsize m_ls;
  jdouble* work_ll;
  jint* ifaill_l;
  integer* ifaill_ll;
  jsize ifaill_ls;
  jint* ifailr_l;
  integer* ifailr_ll;
  jsize ifailr_ls;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  side_l = (*env)->GetPrimitiveArrayCritical(env, side, NULL);
  side_ls = (*env)->GetArrayLength(env, side);
  side_ll = malloc(sizeof(char)*side_ls);
  for (i_loc=0; i_loc<side_ls; ++i_loc) side_ll[i_loc] = side_l[i_loc];
  eigsrc_l = (*env)->GetPrimitiveArrayCritical(env, eigsrc, NULL);
  eigsrc_ls = (*env)->GetArrayLength(env, eigsrc);
  eigsrc_ll = malloc(sizeof(char)*eigsrc_ls);
  for (i_loc=0; i_loc<eigsrc_ls; ++i_loc) eigsrc_ll[i_loc] = eigsrc_l[i_loc];
  initv_l = (*env)->GetPrimitiveArrayCritical(env, initv, NULL);
  initv_ls = (*env)->GetArrayLength(env, initv);
  initv_ll = malloc(sizeof(char)*initv_ls);
  for (i_loc=0; i_loc<initv_ls; ++i_loc) initv_ll[i_loc] = initv_l[i_loc];
  select_l = (*env)->GetPrimitiveArrayCritical(env, select, NULL);
  select_ls = (*env)->GetArrayLength(env, select);
  select_ll = malloc(sizeof(integer)*select_ls);
  for (i_loc=0; i_loc<select_ls; ++i_loc) select_ll[i_loc] = select_l[i_loc];
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  h_ll = (*env)->GetPrimitiveArrayCritical(env, h, NULL);
  ldh_l = (*env)->GetPrimitiveArrayCritical(env, ldh, NULL);
  ldh_ls = (*env)->GetArrayLength(env, ldh);
  ldh_ll = malloc(sizeof(integer)*ldh_ls);
  for (i_loc=0; i_loc<ldh_ls; ++i_loc) ldh_ll[i_loc] = ldh_l[i_loc];
  wr_ll = (*env)->GetPrimitiveArrayCritical(env, wr, NULL);
  wi_ll = (*env)->GetPrimitiveArrayCritical(env, wi, NULL);
  vl_ll = (*env)->GetPrimitiveArrayCritical(env, vl, NULL);
  ldvl_l = (*env)->GetPrimitiveArrayCritical(env, ldvl, NULL);
  ldvl_ls = (*env)->GetArrayLength(env, ldvl);
  ldvl_ll = malloc(sizeof(integer)*ldvl_ls);
  for (i_loc=0; i_loc<ldvl_ls; ++i_loc) ldvl_ll[i_loc] = ldvl_l[i_loc];
  vr_ll = (*env)->GetPrimitiveArrayCritical(env, vr, NULL);
  ldvr_l = (*env)->GetPrimitiveArrayCritical(env, ldvr, NULL);
  ldvr_ls = (*env)->GetArrayLength(env, ldvr);
  ldvr_ll = malloc(sizeof(integer)*ldvr_ls);
  for (i_loc=0; i_loc<ldvr_ls; ++i_loc) ldvr_ll[i_loc] = ldvr_l[i_loc];
  mm_l = (*env)->GetPrimitiveArrayCritical(env, mm, NULL);
  mm_ls = (*env)->GetArrayLength(env, mm);
  mm_ll = malloc(sizeof(integer)*mm_ls);
  for (i_loc=0; i_loc<mm_ls; ++i_loc) mm_ll[i_loc] = mm_l[i_loc];
  m_l = (*env)->GetPrimitiveArrayCritical(env, m, NULL);
  m_ls = (*env)->GetArrayLength(env, m);
  m_ll = malloc(sizeof(integer)*m_ls);
  for (i_loc=0; i_loc<m_ls; ++i_loc) m_ll[i_loc] = m_l[i_loc];
  work_ll = (*env)->GetPrimitiveArrayCritical(env, work, NULL);
  ifaill_l = (*env)->GetPrimitiveArrayCritical(env, ifaill, NULL);
  ifaill_ls = (*env)->GetArrayLength(env, ifaill);
  ifaill_ll = malloc(sizeof(integer)*ifaill_ls);
  for (i_loc=0; i_loc<ifaill_ls; ++i_loc) ifaill_ll[i_loc] = ifaill_l[i_loc];
  ifailr_l = (*env)->GetPrimitiveArrayCritical(env, ifailr, NULL);
  ifailr_ls = (*env)->GetArrayLength(env, ifailr);
  ifailr_ll = malloc(sizeof(integer)*ifailr_ls);
  for (i_loc=0; i_loc<ifailr_ls; ++i_loc) ifailr_ll[i_loc] = ifailr_l[i_loc];
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dhsein_(side_ll, eigsrc_ll, initv_ll, select_ll, n_ll, h_ll, ldh_ll, wr_ll, wi_ll, vl_ll, ldvl_ll, vr_ll, ldvr_ll, mm_ll, m_ll, work_ll, ifaill_ll, ifailr_ll, info_ll);

  for (i_loc=0; i_loc<side_ls; ++i_loc) side_l[i_loc] = side_ll[i_loc];
  free(side_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, side, side_l, 0);
  for (i_loc=0; i_loc<eigsrc_ls; ++i_loc) eigsrc_l[i_loc] = eigsrc_ll[i_loc];
  free(eigsrc_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, eigsrc, eigsrc_l, 0);
  for (i_loc=0; i_loc<initv_ls; ++i_loc) initv_l[i_loc] = initv_ll[i_loc];
  free(initv_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, initv, initv_l, 0);
  for (i_loc=0; i_loc<select_ls; ++i_loc) select_l[i_loc] = select_ll[i_loc];
  free(select_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, select, select_l, 0);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, h, h_ll, 0);
  for (i_loc=0; i_loc<ldh_ls; ++i_loc) ldh_l[i_loc] = ldh_ll[i_loc];
  free(ldh_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldh, ldh_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, wr, wr_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, wi, wi_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, vl, vl_ll, 0);
  for (i_loc=0; i_loc<ldvl_ls; ++i_loc) ldvl_l[i_loc] = ldvl_ll[i_loc];
  free(ldvl_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldvl, ldvl_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, vr, vr_ll, 0);
  for (i_loc=0; i_loc<ldvr_ls; ++i_loc) ldvr_l[i_loc] = ldvr_ll[i_loc];
  free(ldvr_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldvr, ldvr_l, 0);
  for (i_loc=0; i_loc<mm_ls; ++i_loc) mm_l[i_loc] = mm_ll[i_loc];
  free(mm_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, mm, mm_l, 0);
  for (i_loc=0; i_loc<m_ls; ++i_loc) m_l[i_loc] = m_ll[i_loc];
  free(m_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, m, m_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, work, work_ll, 0);
  for (i_loc=0; i_loc<ifaill_ls; ++i_loc) ifaill_l[i_loc] = ifaill_ll[i_loc];
  free(ifaill_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ifaill, ifaill_l, 0);
  for (i_loc=0; i_loc<ifailr_ls; ++i_loc) ifailr_l[i_loc] = ifailr_ll[i_loc];
  free(ifailr_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ifailr, ifailr_l, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_hseqr
(JNIEnv *env, jclass clazz, jcharArray job, jcharArray compz, jintArray n, jintArray ilo, jintArray ihi, jdoubleArray h, jintArray ldh, jdoubleArray wr, jdoubleArray wi, jdoubleArray z, jintArray ldz, jdoubleArray work, jintArray lwork, jintArray info) {
  int i_loc;
  jchar* job_l;
  char* job_ll;
  jsize job_ls;
  jchar* compz_l;
  char* compz_ll;
  jsize compz_ls;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jint* ilo_l;
  integer* ilo_ll;
  jsize ilo_ls;
  jint* ihi_l;
  integer* ihi_ll;
  jsize ihi_ls;
  jdouble* h_ll;
  jint* ldh_l;
  integer* ldh_ll;
  jsize ldh_ls;
  jdouble* wr_ll;
  jdouble* wi_ll;
  jdouble* z_ll;
  jint* ldz_l;
  integer* ldz_ll;
  jsize ldz_ls;
  jdouble* work_ll;
  jint* lwork_l;
  integer* lwork_ll;
  jsize lwork_ls;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  job_l = (*env)->GetPrimitiveArrayCritical(env, job, NULL);
  job_ls = (*env)->GetArrayLength(env, job);
  job_ll = malloc(sizeof(char)*job_ls);
  for (i_loc=0; i_loc<job_ls; ++i_loc) job_ll[i_loc] = job_l[i_loc];
  compz_l = (*env)->GetPrimitiveArrayCritical(env, compz, NULL);
  compz_ls = (*env)->GetArrayLength(env, compz);
  compz_ll = malloc(sizeof(char)*compz_ls);
  for (i_loc=0; i_loc<compz_ls; ++i_loc) compz_ll[i_loc] = compz_l[i_loc];
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  ilo_l = (*env)->GetPrimitiveArrayCritical(env, ilo, NULL);
  ilo_ls = (*env)->GetArrayLength(env, ilo);
  ilo_ll = malloc(sizeof(integer)*ilo_ls);
  for (i_loc=0; i_loc<ilo_ls; ++i_loc) ilo_ll[i_loc] = ilo_l[i_loc];
  ihi_l = (*env)->GetPrimitiveArrayCritical(env, ihi, NULL);
  ihi_ls = (*env)->GetArrayLength(env, ihi);
  ihi_ll = malloc(sizeof(integer)*ihi_ls);
  for (i_loc=0; i_loc<ihi_ls; ++i_loc) ihi_ll[i_loc] = ihi_l[i_loc];
  h_ll = (*env)->GetPrimitiveArrayCritical(env, h, NULL);
  ldh_l = (*env)->GetPrimitiveArrayCritical(env, ldh, NULL);
  ldh_ls = (*env)->GetArrayLength(env, ldh);
  ldh_ll = malloc(sizeof(integer)*ldh_ls);
  for (i_loc=0; i_loc<ldh_ls; ++i_loc) ldh_ll[i_loc] = ldh_l[i_loc];
  wr_ll = (*env)->GetPrimitiveArrayCritical(env, wr, NULL);
  wi_ll = (*env)->GetPrimitiveArrayCritical(env, wi, NULL);
  z_ll = (*env)->GetPrimitiveArrayCritical(env, z, NULL);
  ldz_l = (*env)->GetPrimitiveArrayCritical(env, ldz, NULL);
  ldz_ls = (*env)->GetArrayLength(env, ldz);
  ldz_ll = malloc(sizeof(integer)*ldz_ls);
  for (i_loc=0; i_loc<ldz_ls; ++i_loc) ldz_ll[i_loc] = ldz_l[i_loc];
  work_ll = (*env)->GetPrimitiveArrayCritical(env, work, NULL);
  lwork_l = (*env)->GetPrimitiveArrayCritical(env, lwork, NULL);
  lwork_ls = (*env)->GetArrayLength(env, lwork);
  lwork_ll = malloc(sizeof(integer)*lwork_ls);
  for (i_loc=0; i_loc<lwork_ls; ++i_loc) lwork_ll[i_loc] = lwork_l[i_loc];
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dhseqr_(job_ll, compz_ll, n_ll, ilo_ll, ihi_ll, h_ll, ldh_ll, wr_ll, wi_ll, z_ll, ldz_ll, work_ll, lwork_ll, info_ll);

  for (i_loc=0; i_loc<job_ls; ++i_loc) job_l[i_loc] = job_ll[i_loc];
  free(job_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, job, job_l, 0);
  for (i_loc=0; i_loc<compz_ls; ++i_loc) compz_l[i_loc] = compz_ll[i_loc];
  free(compz_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, compz, compz_l, 0);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  for (i_loc=0; i_loc<ilo_ls; ++i_loc) ilo_l[i_loc] = ilo_ll[i_loc];
  free(ilo_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ilo, ilo_l, 0);
  for (i_loc=0; i_loc<ihi_ls; ++i_loc) ihi_l[i_loc] = ihi_ll[i_loc];
  free(ihi_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ihi, ihi_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, h, h_ll, 0);
  for (i_loc=0; i_loc<ldh_ls; ++i_loc) ldh_l[i_loc] = ldh_ll[i_loc];
  free(ldh_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldh, ldh_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, wr, wr_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, wi, wi_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, z, z_ll, 0);
  for (i_loc=0; i_loc<ldz_ls; ++i_loc) ldz_l[i_loc] = ldz_ll[i_loc];
  free(ldz_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldz, ldz_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, work, work_ll, 0);
  for (i_loc=0; i_loc<lwork_ls; ++i_loc) lwork_l[i_loc] = lwork_ll[i_loc];
  free(lwork_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, lwork, lwork_l, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_labad
(JNIEnv *env, jclass clazz, jdoubleArray small, jdoubleArray large) {
  jdouble* small_ll;
  jdouble* large_ll;
  small_ll = (*env)->GetPrimitiveArrayCritical(env, small, NULL);
  large_ll = (*env)->GetPrimitiveArrayCritical(env, large, NULL);

  dlabad_(small_ll, large_ll);

  (*env)->ReleasePrimitiveArrayCritical(env, small, small_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, large, large_ll, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_labrd
(JNIEnv *env, jclass clazz, jintArray m, jintArray n, jintArray nb, jdoubleArray a, jintArray lda, jdoubleArray d, jdoubleArray e, jdoubleArray tauq, jdoubleArray taup, jdoubleArray x, jintArray ldx, jdoubleArray y, jintArray ldy) {
  int i_loc;
  jint* m_l;
  integer* m_ll;
  jsize m_ls;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jint* nb_l;
  integer* nb_ll;
  jsize nb_ls;
  jdouble* a_ll;
  jint* lda_l;
  integer* lda_ll;
  jsize lda_ls;
  jdouble* d_ll;
  jdouble* e_ll;
  jdouble* tauq_ll;
  jdouble* taup_ll;
  jdouble* x_ll;
  jint* ldx_l;
  integer* ldx_ll;
  jsize ldx_ls;
  jdouble* y_ll;
  jint* ldy_l;
  integer* ldy_ll;
  jsize ldy_ls;
  m_l = (*env)->GetPrimitiveArrayCritical(env, m, NULL);
  m_ls = (*env)->GetArrayLength(env, m);
  m_ll = malloc(sizeof(integer)*m_ls);
  for (i_loc=0; i_loc<m_ls; ++i_loc) m_ll[i_loc] = m_l[i_loc];
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  nb_l = (*env)->GetPrimitiveArrayCritical(env, nb, NULL);
  nb_ls = (*env)->GetArrayLength(env, nb);
  nb_ll = malloc(sizeof(integer)*nb_ls);
  for (i_loc=0; i_loc<nb_ls; ++i_loc) nb_ll[i_loc] = nb_l[i_loc];
  a_ll = (*env)->GetPrimitiveArrayCritical(env, a, NULL);
  lda_l = (*env)->GetPrimitiveArrayCritical(env, lda, NULL);
  lda_ls = (*env)->GetArrayLength(env, lda);
  lda_ll = malloc(sizeof(integer)*lda_ls);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_ll[i_loc] = lda_l[i_loc];
  d_ll = (*env)->GetPrimitiveArrayCritical(env, d, NULL);
  e_ll = (*env)->GetPrimitiveArrayCritical(env, e, NULL);
  tauq_ll = (*env)->GetPrimitiveArrayCritical(env, tauq, NULL);
  taup_ll = (*env)->GetPrimitiveArrayCritical(env, taup, NULL);
  x_ll = (*env)->GetPrimitiveArrayCritical(env, x, NULL);
  ldx_l = (*env)->GetPrimitiveArrayCritical(env, ldx, NULL);
  ldx_ls = (*env)->GetArrayLength(env, ldx);
  ldx_ll = malloc(sizeof(integer)*ldx_ls);
  for (i_loc=0; i_loc<ldx_ls; ++i_loc) ldx_ll[i_loc] = ldx_l[i_loc];
  y_ll = (*env)->GetPrimitiveArrayCritical(env, y, NULL);
  ldy_l = (*env)->GetPrimitiveArrayCritical(env, ldy, NULL);
  ldy_ls = (*env)->GetArrayLength(env, ldy);
  ldy_ll = malloc(sizeof(integer)*ldy_ls);
  for (i_loc=0; i_loc<ldy_ls; ++i_loc) ldy_ll[i_loc] = ldy_l[i_loc];

  dlabrd_(m_ll, n_ll, nb_ll, a_ll, lda_ll, d_ll, e_ll, tauq_ll, taup_ll, x_ll, ldx_ll, y_ll, ldy_ll);

  for (i_loc=0; i_loc<m_ls; ++i_loc) m_l[i_loc] = m_ll[i_loc];
  free(m_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, m, m_l, 0);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  for (i_loc=0; i_loc<nb_ls; ++i_loc) nb_l[i_loc] = nb_ll[i_loc];
  free(nb_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, nb, nb_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, a, a_ll, 0);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_l[i_loc] = lda_ll[i_loc];
  free(lda_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, lda, lda_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, d, d_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, e, e_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, tauq, tauq_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, taup, taup_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, x, x_ll, 0);
  for (i_loc=0; i_loc<ldx_ls; ++i_loc) ldx_l[i_loc] = ldx_ll[i_loc];
  free(ldx_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldx, ldx_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, y, y_ll, 0);
  for (i_loc=0; i_loc<ldy_ls; ++i_loc) ldy_l[i_loc] = ldy_ll[i_loc];
  free(ldy_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldy, ldy_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_lacon
(JNIEnv *env, jclass clazz, jintArray n, jdoubleArray v, jdoubleArray x, jintArray isgn, jdoubleArray est, jintArray kase) {
  int i_loc;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jdouble* v_ll;
  jdouble* x_ll;
  jint* isgn_l;
  integer* isgn_ll;
  jsize isgn_ls;
  jdouble* est_ll;
  jint* kase_l;
  integer* kase_ll;
  jsize kase_ls;
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  v_ll = (*env)->GetPrimitiveArrayCritical(env, v, NULL);
  x_ll = (*env)->GetPrimitiveArrayCritical(env, x, NULL);
  isgn_l = (*env)->GetPrimitiveArrayCritical(env, isgn, NULL);
  isgn_ls = (*env)->GetArrayLength(env, isgn);
  isgn_ll = malloc(sizeof(integer)*isgn_ls);
  for (i_loc=0; i_loc<isgn_ls; ++i_loc) isgn_ll[i_loc] = isgn_l[i_loc];
  est_ll = (*env)->GetPrimitiveArrayCritical(env, est, NULL);
  kase_l = (*env)->GetPrimitiveArrayCritical(env, kase, NULL);
  kase_ls = (*env)->GetArrayLength(env, kase);
  kase_ll = malloc(sizeof(integer)*kase_ls);
  for (i_loc=0; i_loc<kase_ls; ++i_loc) kase_ll[i_loc] = kase_l[i_loc];

  dlacon_(n_ll, v_ll, x_ll, isgn_ll, est_ll, kase_ll);

  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, v, v_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, x, x_ll, 0);
  for (i_loc=0; i_loc<isgn_ls; ++i_loc) isgn_l[i_loc] = isgn_ll[i_loc];
  free(isgn_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, isgn, isgn_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, est, est_ll, 0);
  for (i_loc=0; i_loc<kase_ls; ++i_loc) kase_l[i_loc] = kase_ll[i_loc];
  free(kase_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, kase, kase_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_lacpy
(JNIEnv *env, jclass clazz, jcharArray uplo, jintArray m, jintArray n, jdoubleArray a, jintArray lda, jdoubleArray b, jintArray ldb) {
  int i_loc;
  jchar* uplo_l;
  char* uplo_ll;
  jsize uplo_ls;
  jint* m_l;
  integer* m_ll;
  jsize m_ls;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jdouble* a_ll;
  jint* lda_l;
  integer* lda_ll;
  jsize lda_ls;
  jdouble* b_ll;
  jint* ldb_l;
  integer* ldb_ll;
  jsize ldb_ls;
  uplo_l = (*env)->GetPrimitiveArrayCritical(env, uplo, NULL);
  uplo_ls = (*env)->GetArrayLength(env, uplo);
  uplo_ll = malloc(sizeof(char)*uplo_ls);
  for (i_loc=0; i_loc<uplo_ls; ++i_loc) uplo_ll[i_loc] = uplo_l[i_loc];
  m_l = (*env)->GetPrimitiveArrayCritical(env, m, NULL);
  m_ls = (*env)->GetArrayLength(env, m);
  m_ll = malloc(sizeof(integer)*m_ls);
  for (i_loc=0; i_loc<m_ls; ++i_loc) m_ll[i_loc] = m_l[i_loc];
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  a_ll = (*env)->GetPrimitiveArrayCritical(env, a, NULL);
  lda_l = (*env)->GetPrimitiveArrayCritical(env, lda, NULL);
  lda_ls = (*env)->GetArrayLength(env, lda);
  lda_ll = malloc(sizeof(integer)*lda_ls);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_ll[i_loc] = lda_l[i_loc];
  b_ll = (*env)->GetPrimitiveArrayCritical(env, b, NULL);
  ldb_l = (*env)->GetPrimitiveArrayCritical(env, ldb, NULL);
  ldb_ls = (*env)->GetArrayLength(env, ldb);
  ldb_ll = malloc(sizeof(integer)*ldb_ls);
  for (i_loc=0; i_loc<ldb_ls; ++i_loc) ldb_ll[i_loc] = ldb_l[i_loc];

  dlacpy_(uplo_ll, m_ll, n_ll, a_ll, lda_ll, b_ll, ldb_ll);

  for (i_loc=0; i_loc<uplo_ls; ++i_loc) uplo_l[i_loc] = uplo_ll[i_loc];
  free(uplo_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, uplo, uplo_l, 0);
  for (i_loc=0; i_loc<m_ls; ++i_loc) m_l[i_loc] = m_ll[i_loc];
  free(m_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, m, m_l, 0);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, a, a_ll, 0);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_l[i_loc] = lda_ll[i_loc];
  free(lda_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, lda, lda_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, b, b_ll, 0);
  for (i_loc=0; i_loc<ldb_ls; ++i_loc) ldb_l[i_loc] = ldb_ll[i_loc];
  free(ldb_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldb, ldb_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_ladiv
(JNIEnv *env, jclass clazz, jdoubleArray a, jdoubleArray b, jdoubleArray c, jdoubleArray d, jdoubleArray p, jdoubleArray q) {
  jdouble* a_ll;
  jdouble* b_ll;
  jdouble* c_ll;
  jdouble* d_ll;
  jdouble* p_ll;
  jdouble* q_ll;
  a_ll = (*env)->GetPrimitiveArrayCritical(env, a, NULL);
  b_ll = (*env)->GetPrimitiveArrayCritical(env, b, NULL);
  c_ll = (*env)->GetPrimitiveArrayCritical(env, c, NULL);
  d_ll = (*env)->GetPrimitiveArrayCritical(env, d, NULL);
  p_ll = (*env)->GetPrimitiveArrayCritical(env, p, NULL);
  q_ll = (*env)->GetPrimitiveArrayCritical(env, q, NULL);

  dladiv_(a_ll, b_ll, c_ll, d_ll, p_ll, q_ll);

  (*env)->ReleasePrimitiveArrayCritical(env, a, a_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, b, b_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, c, c_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, d, d_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, p, p_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, q, q_ll, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_lae2
(JNIEnv *env, jclass clazz, jdoubleArray a, jdoubleArray b, jdoubleArray c, jdoubleArray rt1, jdoubleArray rt2) {
  jdouble* a_ll;
  jdouble* b_ll;
  jdouble* c_ll;
  jdouble* rt1_ll;
  jdouble* rt2_ll;
  a_ll = (*env)->GetPrimitiveArrayCritical(env, a, NULL);
  b_ll = (*env)->GetPrimitiveArrayCritical(env, b, NULL);
  c_ll = (*env)->GetPrimitiveArrayCritical(env, c, NULL);
  rt1_ll = (*env)->GetPrimitiveArrayCritical(env, rt1, NULL);
  rt2_ll = (*env)->GetPrimitiveArrayCritical(env, rt2, NULL);

  dlae2_(a_ll, b_ll, c_ll, rt1_ll, rt2_ll);

  (*env)->ReleasePrimitiveArrayCritical(env, a, a_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, b, b_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, c, c_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, rt1, rt1_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, rt2, rt2_ll, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_laebz
(JNIEnv *env, jclass clazz, jintArray ijob, jintArray nitmax, jintArray n, jintArray mmax, jintArray minp, jintArray nbmin, jdoubleArray abstol, jdoubleArray reltol, jdoubleArray pivmin, jdoubleArray d, jdoubleArray e, jdoubleArray e2, jintArray nval, jdoubleArray ab, jdoubleArray c, jintArray mout, jintArray nab, jdoubleArray work, jintArray iwork, jintArray info) {
  int i_loc;
  jint* ijob_l;
  integer* ijob_ll;
  jsize ijob_ls;
  jint* nitmax_l;
  integer* nitmax_ll;
  jsize nitmax_ls;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jint* mmax_l;
  integer* mmax_ll;
  jsize mmax_ls;
  jint* minp_l;
  integer* minp_ll;
  jsize minp_ls;
  jint* nbmin_l;
  integer* nbmin_ll;
  jsize nbmin_ls;
  jdouble* abstol_ll;
  jdouble* reltol_ll;
  jdouble* pivmin_ll;
  jdouble* d_ll;
  jdouble* e_ll;
  jdouble* e2_ll;
  jint* nval_l;
  integer* nval_ll;
  jsize nval_ls;
  jdouble* ab_ll;
  jdouble* c_ll;
  jint* mout_l;
  integer* mout_ll;
  jsize mout_ls;
  jint* nab_l;
  integer* nab_ll;
  jsize nab_ls;
  jdouble* work_ll;
  jint* iwork_l;
  integer* iwork_ll;
  jsize iwork_ls;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  ijob_l = (*env)->GetPrimitiveArrayCritical(env, ijob, NULL);
  ijob_ls = (*env)->GetArrayLength(env, ijob);
  ijob_ll = malloc(sizeof(integer)*ijob_ls);
  for (i_loc=0; i_loc<ijob_ls; ++i_loc) ijob_ll[i_loc] = ijob_l[i_loc];
  nitmax_l = (*env)->GetPrimitiveArrayCritical(env, nitmax, NULL);
  nitmax_ls = (*env)->GetArrayLength(env, nitmax);
  nitmax_ll = malloc(sizeof(integer)*nitmax_ls);
  for (i_loc=0; i_loc<nitmax_ls; ++i_loc) nitmax_ll[i_loc] = nitmax_l[i_loc];
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  mmax_l = (*env)->GetPrimitiveArrayCritical(env, mmax, NULL);
  mmax_ls = (*env)->GetArrayLength(env, mmax);
  mmax_ll = malloc(sizeof(integer)*mmax_ls);
  for (i_loc=0; i_loc<mmax_ls; ++i_loc) mmax_ll[i_loc] = mmax_l[i_loc];
  minp_l = (*env)->GetPrimitiveArrayCritical(env, minp, NULL);
  minp_ls = (*env)->GetArrayLength(env, minp);
  minp_ll = malloc(sizeof(integer)*minp_ls);
  for (i_loc=0; i_loc<minp_ls; ++i_loc) minp_ll[i_loc] = minp_l[i_loc];
  nbmin_l = (*env)->GetPrimitiveArrayCritical(env, nbmin, NULL);
  nbmin_ls = (*env)->GetArrayLength(env, nbmin);
  nbmin_ll = malloc(sizeof(integer)*nbmin_ls);
  for (i_loc=0; i_loc<nbmin_ls; ++i_loc) nbmin_ll[i_loc] = nbmin_l[i_loc];
  abstol_ll = (*env)->GetPrimitiveArrayCritical(env, abstol, NULL);
  reltol_ll = (*env)->GetPrimitiveArrayCritical(env, reltol, NULL);
  pivmin_ll = (*env)->GetPrimitiveArrayCritical(env, pivmin, NULL);
  d_ll = (*env)->GetPrimitiveArrayCritical(env, d, NULL);
  e_ll = (*env)->GetPrimitiveArrayCritical(env, e, NULL);
  e2_ll = (*env)->GetPrimitiveArrayCritical(env, e2, NULL);
  nval_l = (*env)->GetPrimitiveArrayCritical(env, nval, NULL);
  nval_ls = (*env)->GetArrayLength(env, nval);
  nval_ll = malloc(sizeof(integer)*nval_ls);
  for (i_loc=0; i_loc<nval_ls; ++i_loc) nval_ll[i_loc] = nval_l[i_loc];
  ab_ll = (*env)->GetPrimitiveArrayCritical(env, ab, NULL);
  c_ll = (*env)->GetPrimitiveArrayCritical(env, c, NULL);
  mout_l = (*env)->GetPrimitiveArrayCritical(env, mout, NULL);
  mout_ls = (*env)->GetArrayLength(env, mout);
  mout_ll = malloc(sizeof(integer)*mout_ls);
  for (i_loc=0; i_loc<mout_ls; ++i_loc) mout_ll[i_loc] = mout_l[i_loc];
  nab_l = (*env)->GetPrimitiveArrayCritical(env, nab, NULL);
  nab_ls = (*env)->GetArrayLength(env, nab);
  nab_ll = malloc(sizeof(integer)*nab_ls);
  for (i_loc=0; i_loc<nab_ls; ++i_loc) nab_ll[i_loc] = nab_l[i_loc];
  work_ll = (*env)->GetPrimitiveArrayCritical(env, work, NULL);
  iwork_l = (*env)->GetPrimitiveArrayCritical(env, iwork, NULL);
  iwork_ls = (*env)->GetArrayLength(env, iwork);
  iwork_ll = malloc(sizeof(integer)*iwork_ls);
  for (i_loc=0; i_loc<iwork_ls; ++i_loc) iwork_ll[i_loc] = iwork_l[i_loc];
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dlaebz_(ijob_ll, nitmax_ll, n_ll, mmax_ll, minp_ll, nbmin_ll, abstol_ll, reltol_ll, pivmin_ll, d_ll, e_ll, e2_ll, nval_ll, ab_ll, c_ll, mout_ll, nab_ll, work_ll, iwork_ll, info_ll);

  for (i_loc=0; i_loc<ijob_ls; ++i_loc) ijob_l[i_loc] = ijob_ll[i_loc];
  free(ijob_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ijob, ijob_l, 0);
  for (i_loc=0; i_loc<nitmax_ls; ++i_loc) nitmax_l[i_loc] = nitmax_ll[i_loc];
  free(nitmax_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, nitmax, nitmax_l, 0);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  for (i_loc=0; i_loc<mmax_ls; ++i_loc) mmax_l[i_loc] = mmax_ll[i_loc];
  free(mmax_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, mmax, mmax_l, 0);
  for (i_loc=0; i_loc<minp_ls; ++i_loc) minp_l[i_loc] = minp_ll[i_loc];
  free(minp_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, minp, minp_l, 0);
  for (i_loc=0; i_loc<nbmin_ls; ++i_loc) nbmin_l[i_loc] = nbmin_ll[i_loc];
  free(nbmin_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, nbmin, nbmin_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, abstol, abstol_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, reltol, reltol_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, pivmin, pivmin_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, d, d_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, e, e_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, e2, e2_ll, 0);
  for (i_loc=0; i_loc<nval_ls; ++i_loc) nval_l[i_loc] = nval_ll[i_loc];
  free(nval_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, nval, nval_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, ab, ab_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, c, c_ll, 0);
  for (i_loc=0; i_loc<mout_ls; ++i_loc) mout_l[i_loc] = mout_ll[i_loc];
  free(mout_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, mout, mout_l, 0);
  for (i_loc=0; i_loc<nab_ls; ++i_loc) nab_l[i_loc] = nab_ll[i_loc];
  free(nab_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, nab, nab_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, work, work_ll, 0);
  for (i_loc=0; i_loc<iwork_ls; ++i_loc) iwork_l[i_loc] = iwork_ll[i_loc];
  free(iwork_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, iwork, iwork_l, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_laed0
(JNIEnv *env, jclass clazz, jintArray icompq, jintArray qsiz, jintArray n, jdoubleArray d, jdoubleArray e, jdoubleArray q, jintArray ldq, jdoubleArray qstore, jintArray ldqs, jdoubleArray work, jintArray iwork, jintArray info) {
  int i_loc;
  jint* icompq_l;
  integer* icompq_ll;
  jsize icompq_ls;
  jint* qsiz_l;
  integer* qsiz_ll;
  jsize qsiz_ls;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jdouble* d_ll;
  jdouble* e_ll;
  jdouble* q_ll;
  jint* ldq_l;
  integer* ldq_ll;
  jsize ldq_ls;
  jdouble* qstore_ll;
  jint* ldqs_l;
  integer* ldqs_ll;
  jsize ldqs_ls;
  jdouble* work_ll;
  jint* iwork_l;
  integer* iwork_ll;
  jsize iwork_ls;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  icompq_l = (*env)->GetPrimitiveArrayCritical(env, icompq, NULL);
  icompq_ls = (*env)->GetArrayLength(env, icompq);
  icompq_ll = malloc(sizeof(integer)*icompq_ls);
  for (i_loc=0; i_loc<icompq_ls; ++i_loc) icompq_ll[i_loc] = icompq_l[i_loc];
  qsiz_l = (*env)->GetPrimitiveArrayCritical(env, qsiz, NULL);
  qsiz_ls = (*env)->GetArrayLength(env, qsiz);
  qsiz_ll = malloc(sizeof(integer)*qsiz_ls);
  for (i_loc=0; i_loc<qsiz_ls; ++i_loc) qsiz_ll[i_loc] = qsiz_l[i_loc];
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  d_ll = (*env)->GetPrimitiveArrayCritical(env, d, NULL);
  e_ll = (*env)->GetPrimitiveArrayCritical(env, e, NULL);
  q_ll = (*env)->GetPrimitiveArrayCritical(env, q, NULL);
  ldq_l = (*env)->GetPrimitiveArrayCritical(env, ldq, NULL);
  ldq_ls = (*env)->GetArrayLength(env, ldq);
  ldq_ll = malloc(sizeof(integer)*ldq_ls);
  for (i_loc=0; i_loc<ldq_ls; ++i_loc) ldq_ll[i_loc] = ldq_l[i_loc];
  qstore_ll = (*env)->GetPrimitiveArrayCritical(env, qstore, NULL);
  ldqs_l = (*env)->GetPrimitiveArrayCritical(env, ldqs, NULL);
  ldqs_ls = (*env)->GetArrayLength(env, ldqs);
  ldqs_ll = malloc(sizeof(integer)*ldqs_ls);
  for (i_loc=0; i_loc<ldqs_ls; ++i_loc) ldqs_ll[i_loc] = ldqs_l[i_loc];
  work_ll = (*env)->GetPrimitiveArrayCritical(env, work, NULL);
  iwork_l = (*env)->GetPrimitiveArrayCritical(env, iwork, NULL);
  iwork_ls = (*env)->GetArrayLength(env, iwork);
  iwork_ll = malloc(sizeof(integer)*iwork_ls);
  for (i_loc=0; i_loc<iwork_ls; ++i_loc) iwork_ll[i_loc] = iwork_l[i_loc];
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dlaed0_(icompq_ll, qsiz_ll, n_ll, d_ll, e_ll, q_ll, ldq_ll, qstore_ll, ldqs_ll, work_ll, iwork_ll, info_ll);

  for (i_loc=0; i_loc<icompq_ls; ++i_loc) icompq_l[i_loc] = icompq_ll[i_loc];
  free(icompq_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, icompq, icompq_l, 0);
  for (i_loc=0; i_loc<qsiz_ls; ++i_loc) qsiz_l[i_loc] = qsiz_ll[i_loc];
  free(qsiz_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, qsiz, qsiz_l, 0);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, d, d_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, e, e_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, q, q_ll, 0);
  for (i_loc=0; i_loc<ldq_ls; ++i_loc) ldq_l[i_loc] = ldq_ll[i_loc];
  free(ldq_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldq, ldq_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, qstore, qstore_ll, 0);
  for (i_loc=0; i_loc<ldqs_ls; ++i_loc) ldqs_l[i_loc] = ldqs_ll[i_loc];
  free(ldqs_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldqs, ldqs_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, work, work_ll, 0);
  for (i_loc=0; i_loc<iwork_ls; ++i_loc) iwork_l[i_loc] = iwork_ll[i_loc];
  free(iwork_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, iwork, iwork_l, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_laed1
(JNIEnv *env, jclass clazz, jintArray n, jdoubleArray d, jdoubleArray q, jintArray ldq, jintArray indxq, jdoubleArray rho, jintArray cutpnt, jdoubleArray work, jintArray iwork, jintArray info) {
  int i_loc;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jdouble* d_ll;
  jdouble* q_ll;
  jint* ldq_l;
  integer* ldq_ll;
  jsize ldq_ls;
  jint* indxq_l;
  integer* indxq_ll;
  jsize indxq_ls;
  jdouble* rho_ll;
  jint* cutpnt_l;
  integer* cutpnt_ll;
  jsize cutpnt_ls;
  jdouble* work_ll;
  jint* iwork_l;
  integer* iwork_ll;
  jsize iwork_ls;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  d_ll = (*env)->GetPrimitiveArrayCritical(env, d, NULL);
  q_ll = (*env)->GetPrimitiveArrayCritical(env, q, NULL);
  ldq_l = (*env)->GetPrimitiveArrayCritical(env, ldq, NULL);
  ldq_ls = (*env)->GetArrayLength(env, ldq);
  ldq_ll = malloc(sizeof(integer)*ldq_ls);
  for (i_loc=0; i_loc<ldq_ls; ++i_loc) ldq_ll[i_loc] = ldq_l[i_loc];
  indxq_l = (*env)->GetPrimitiveArrayCritical(env, indxq, NULL);
  indxq_ls = (*env)->GetArrayLength(env, indxq);
  indxq_ll = malloc(sizeof(integer)*indxq_ls);
  for (i_loc=0; i_loc<indxq_ls; ++i_loc) indxq_ll[i_loc] = indxq_l[i_loc];
  rho_ll = (*env)->GetPrimitiveArrayCritical(env, rho, NULL);
  cutpnt_l = (*env)->GetPrimitiveArrayCritical(env, cutpnt, NULL);
  cutpnt_ls = (*env)->GetArrayLength(env, cutpnt);
  cutpnt_ll = malloc(sizeof(integer)*cutpnt_ls);
  for (i_loc=0; i_loc<cutpnt_ls; ++i_loc) cutpnt_ll[i_loc] = cutpnt_l[i_loc];
  work_ll = (*env)->GetPrimitiveArrayCritical(env, work, NULL);
  iwork_l = (*env)->GetPrimitiveArrayCritical(env, iwork, NULL);
  iwork_ls = (*env)->GetArrayLength(env, iwork);
  iwork_ll = malloc(sizeof(integer)*iwork_ls);
  for (i_loc=0; i_loc<iwork_ls; ++i_loc) iwork_ll[i_loc] = iwork_l[i_loc];
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dlaed1_(n_ll, d_ll, q_ll, ldq_ll, indxq_ll, rho_ll, cutpnt_ll, work_ll, iwork_ll, info_ll);

  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, d, d_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, q, q_ll, 0);
  for (i_loc=0; i_loc<ldq_ls; ++i_loc) ldq_l[i_loc] = ldq_ll[i_loc];
  free(ldq_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldq, ldq_l, 0);
  for (i_loc=0; i_loc<indxq_ls; ++i_loc) indxq_l[i_loc] = indxq_ll[i_loc];
  free(indxq_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, indxq, indxq_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, rho, rho_ll, 0);
  for (i_loc=0; i_loc<cutpnt_ls; ++i_loc) cutpnt_l[i_loc] = cutpnt_ll[i_loc];
  free(cutpnt_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, cutpnt, cutpnt_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, work, work_ll, 0);
  for (i_loc=0; i_loc<iwork_ls; ++i_loc) iwork_l[i_loc] = iwork_ll[i_loc];
  free(iwork_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, iwork, iwork_l, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_laed2
(JNIEnv *env, jclass clazz, jintArray k, jintArray n, jintArray n1, jdoubleArray d, jdoubleArray q, jintArray ldq, jintArray indxq, jdoubleArray rho, jdoubleArray z, jdoubleArray dlamda, jdoubleArray w, jdoubleArray q2, jintArray indx, jintArray indxc, jintArray indxp, jintArray coltyp, jintArray info) {
  int i_loc;
  jint* k_l;
  integer* k_ll;
  jsize k_ls;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jint* n1_l;
  integer* n1_ll;
  jsize n1_ls;
  jdouble* d_ll;
  jdouble* q_ll;
  jint* ldq_l;
  integer* ldq_ll;
  jsize ldq_ls;
  jint* indxq_l;
  integer* indxq_ll;
  jsize indxq_ls;
  jdouble* rho_ll;
  jdouble* z_ll;
  jdouble* dlamda_ll;
  jdouble* w_ll;
  jdouble* q2_ll;
  jint* indx_l;
  integer* indx_ll;
  jsize indx_ls;
  jint* indxc_l;
  integer* indxc_ll;
  jsize indxc_ls;
  jint* indxp_l;
  integer* indxp_ll;
  jsize indxp_ls;
  jint* coltyp_l;
  integer* coltyp_ll;
  jsize coltyp_ls;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  k_l = (*env)->GetPrimitiveArrayCritical(env, k, NULL);
  k_ls = (*env)->GetArrayLength(env, k);
  k_ll = malloc(sizeof(integer)*k_ls);
  for (i_loc=0; i_loc<k_ls; ++i_loc) k_ll[i_loc] = k_l[i_loc];
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  n1_l = (*env)->GetPrimitiveArrayCritical(env, n1, NULL);
  n1_ls = (*env)->GetArrayLength(env, n1);
  n1_ll = malloc(sizeof(integer)*n1_ls);
  for (i_loc=0; i_loc<n1_ls; ++i_loc) n1_ll[i_loc] = n1_l[i_loc];
  d_ll = (*env)->GetPrimitiveArrayCritical(env, d, NULL);
  q_ll = (*env)->GetPrimitiveArrayCritical(env, q, NULL);
  ldq_l = (*env)->GetPrimitiveArrayCritical(env, ldq, NULL);
  ldq_ls = (*env)->GetArrayLength(env, ldq);
  ldq_ll = malloc(sizeof(integer)*ldq_ls);
  for (i_loc=0; i_loc<ldq_ls; ++i_loc) ldq_ll[i_loc] = ldq_l[i_loc];
  indxq_l = (*env)->GetPrimitiveArrayCritical(env, indxq, NULL);
  indxq_ls = (*env)->GetArrayLength(env, indxq);
  indxq_ll = malloc(sizeof(integer)*indxq_ls);
  for (i_loc=0; i_loc<indxq_ls; ++i_loc) indxq_ll[i_loc] = indxq_l[i_loc];
  rho_ll = (*env)->GetPrimitiveArrayCritical(env, rho, NULL);
  z_ll = (*env)->GetPrimitiveArrayCritical(env, z, NULL);
  dlamda_ll = (*env)->GetPrimitiveArrayCritical(env, dlamda, NULL);
  w_ll = (*env)->GetPrimitiveArrayCritical(env, w, NULL);
  q2_ll = (*env)->GetPrimitiveArrayCritical(env, q2, NULL);
  indx_l = (*env)->GetPrimitiveArrayCritical(env, indx, NULL);
  indx_ls = (*env)->GetArrayLength(env, indx);
  indx_ll = malloc(sizeof(integer)*indx_ls);
  for (i_loc=0; i_loc<indx_ls; ++i_loc) indx_ll[i_loc] = indx_l[i_loc];
  indxc_l = (*env)->GetPrimitiveArrayCritical(env, indxc, NULL);
  indxc_ls = (*env)->GetArrayLength(env, indxc);
  indxc_ll = malloc(sizeof(integer)*indxc_ls);
  for (i_loc=0; i_loc<indxc_ls; ++i_loc) indxc_ll[i_loc] = indxc_l[i_loc];
  indxp_l = (*env)->GetPrimitiveArrayCritical(env, indxp, NULL);
  indxp_ls = (*env)->GetArrayLength(env, indxp);
  indxp_ll = malloc(sizeof(integer)*indxp_ls);
  for (i_loc=0; i_loc<indxp_ls; ++i_loc) indxp_ll[i_loc] = indxp_l[i_loc];
  coltyp_l = (*env)->GetPrimitiveArrayCritical(env, coltyp, NULL);
  coltyp_ls = (*env)->GetArrayLength(env, coltyp);
  coltyp_ll = malloc(sizeof(integer)*coltyp_ls);
  for (i_loc=0; i_loc<coltyp_ls; ++i_loc) coltyp_ll[i_loc] = coltyp_l[i_loc];
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dlaed2_(k_ll, n_ll, n1_ll, d_ll, q_ll, ldq_ll, indxq_ll, rho_ll, z_ll, dlamda_ll, w_ll, q2_ll, indx_ll, indxc_ll, indxp_ll, coltyp_ll, info_ll);

  for (i_loc=0; i_loc<k_ls; ++i_loc) k_l[i_loc] = k_ll[i_loc];
  free(k_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, k, k_l, 0);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  for (i_loc=0; i_loc<n1_ls; ++i_loc) n1_l[i_loc] = n1_ll[i_loc];
  free(n1_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n1, n1_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, d, d_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, q, q_ll, 0);
  for (i_loc=0; i_loc<ldq_ls; ++i_loc) ldq_l[i_loc] = ldq_ll[i_loc];
  free(ldq_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldq, ldq_l, 0);
  for (i_loc=0; i_loc<indxq_ls; ++i_loc) indxq_l[i_loc] = indxq_ll[i_loc];
  free(indxq_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, indxq, indxq_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, rho, rho_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, z, z_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, dlamda, dlamda_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, w, w_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, q2, q2_ll, 0);
  for (i_loc=0; i_loc<indx_ls; ++i_loc) indx_l[i_loc] = indx_ll[i_loc];
  free(indx_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, indx, indx_l, 0);
  for (i_loc=0; i_loc<indxc_ls; ++i_loc) indxc_l[i_loc] = indxc_ll[i_loc];
  free(indxc_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, indxc, indxc_l, 0);
  for (i_loc=0; i_loc<indxp_ls; ++i_loc) indxp_l[i_loc] = indxp_ll[i_loc];
  free(indxp_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, indxp, indxp_l, 0);
  for (i_loc=0; i_loc<coltyp_ls; ++i_loc) coltyp_l[i_loc] = coltyp_ll[i_loc];
  free(coltyp_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, coltyp, coltyp_l, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_laed3
(JNIEnv *env, jclass clazz, jintArray k, jintArray n, jintArray n1, jdoubleArray d, jdoubleArray q, jintArray ldq, jdoubleArray rho, jdoubleArray dlamda, jdoubleArray q2, jintArray indx, jintArray ctot, jdoubleArray w, jdoubleArray s, jintArray info) {
  int i_loc;
  jint* k_l;
  integer* k_ll;
  jsize k_ls;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jint* n1_l;
  integer* n1_ll;
  jsize n1_ls;
  jdouble* d_ll;
  jdouble* q_ll;
  jint* ldq_l;
  integer* ldq_ll;
  jsize ldq_ls;
  jdouble* rho_ll;
  jdouble* dlamda_ll;
  jdouble* q2_ll;
  jint* indx_l;
  integer* indx_ll;
  jsize indx_ls;
  jint* ctot_l;
  integer* ctot_ll;
  jsize ctot_ls;
  jdouble* w_ll;
  jdouble* s_ll;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  k_l = (*env)->GetPrimitiveArrayCritical(env, k, NULL);
  k_ls = (*env)->GetArrayLength(env, k);
  k_ll = malloc(sizeof(integer)*k_ls);
  for (i_loc=0; i_loc<k_ls; ++i_loc) k_ll[i_loc] = k_l[i_loc];
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  n1_l = (*env)->GetPrimitiveArrayCritical(env, n1, NULL);
  n1_ls = (*env)->GetArrayLength(env, n1);
  n1_ll = malloc(sizeof(integer)*n1_ls);
  for (i_loc=0; i_loc<n1_ls; ++i_loc) n1_ll[i_loc] = n1_l[i_loc];
  d_ll = (*env)->GetPrimitiveArrayCritical(env, d, NULL);
  q_ll = (*env)->GetPrimitiveArrayCritical(env, q, NULL);
  ldq_l = (*env)->GetPrimitiveArrayCritical(env, ldq, NULL);
  ldq_ls = (*env)->GetArrayLength(env, ldq);
  ldq_ll = malloc(sizeof(integer)*ldq_ls);
  for (i_loc=0; i_loc<ldq_ls; ++i_loc) ldq_ll[i_loc] = ldq_l[i_loc];
  rho_ll = (*env)->GetPrimitiveArrayCritical(env, rho, NULL);
  dlamda_ll = (*env)->GetPrimitiveArrayCritical(env, dlamda, NULL);
  q2_ll = (*env)->GetPrimitiveArrayCritical(env, q2, NULL);
  indx_l = (*env)->GetPrimitiveArrayCritical(env, indx, NULL);
  indx_ls = (*env)->GetArrayLength(env, indx);
  indx_ll = malloc(sizeof(integer)*indx_ls);
  for (i_loc=0; i_loc<indx_ls; ++i_loc) indx_ll[i_loc] = indx_l[i_loc];
  ctot_l = (*env)->GetPrimitiveArrayCritical(env, ctot, NULL);
  ctot_ls = (*env)->GetArrayLength(env, ctot);
  ctot_ll = malloc(sizeof(integer)*ctot_ls);
  for (i_loc=0; i_loc<ctot_ls; ++i_loc) ctot_ll[i_loc] = ctot_l[i_loc];
  w_ll = (*env)->GetPrimitiveArrayCritical(env, w, NULL);
  s_ll = (*env)->GetPrimitiveArrayCritical(env, s, NULL);
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dlaed3_(k_ll, n_ll, n1_ll, d_ll, q_ll, ldq_ll, rho_ll, dlamda_ll, q2_ll, indx_ll, ctot_ll, w_ll, s_ll, info_ll);

  for (i_loc=0; i_loc<k_ls; ++i_loc) k_l[i_loc] = k_ll[i_loc];
  free(k_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, k, k_l, 0);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  for (i_loc=0; i_loc<n1_ls; ++i_loc) n1_l[i_loc] = n1_ll[i_loc];
  free(n1_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n1, n1_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, d, d_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, q, q_ll, 0);
  for (i_loc=0; i_loc<ldq_ls; ++i_loc) ldq_l[i_loc] = ldq_ll[i_loc];
  free(ldq_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldq, ldq_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, rho, rho_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, dlamda, dlamda_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, q2, q2_ll, 0);
  for (i_loc=0; i_loc<indx_ls; ++i_loc) indx_l[i_loc] = indx_ll[i_loc];
  free(indx_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, indx, indx_l, 0);
  for (i_loc=0; i_loc<ctot_ls; ++i_loc) ctot_l[i_loc] = ctot_ll[i_loc];
  free(ctot_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ctot, ctot_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, w, w_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, s, s_ll, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_laed4
(JNIEnv *env, jclass clazz, jintArray n, jintArray i, jdoubleArray d, jdoubleArray z, jdoubleArray delta, jdoubleArray rho, jdoubleArray dlam, jintArray info) {
  int i_loc;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jint* i_l;
  integer* i_ll;
  jsize i_ls;
  jdouble* d_ll;
  jdouble* z_ll;
  jdouble* delta_ll;
  jdouble* rho_ll;
  jdouble* dlam_ll;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  i_l = (*env)->GetPrimitiveArrayCritical(env, i, NULL);
  i_ls = (*env)->GetArrayLength(env, i);
  i_ll = malloc(sizeof(integer)*i_ls);
  for (i_loc=0; i_loc<i_ls; ++i_loc) i_ll[i_loc] = i_l[i_loc];
  d_ll = (*env)->GetPrimitiveArrayCritical(env, d, NULL);
  z_ll = (*env)->GetPrimitiveArrayCritical(env, z, NULL);
  delta_ll = (*env)->GetPrimitiveArrayCritical(env, delta, NULL);
  rho_ll = (*env)->GetPrimitiveArrayCritical(env, rho, NULL);
  dlam_ll = (*env)->GetPrimitiveArrayCritical(env, dlam, NULL);
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dlaed4_(n_ll, i_ll, d_ll, z_ll, delta_ll, rho_ll, dlam_ll, info_ll);

  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  for (i_loc=0; i_loc<i_ls; ++i_loc) i_l[i_loc] = i_ll[i_loc];
  free(i_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, i, i_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, d, d_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, z, z_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, delta, delta_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, rho, rho_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, dlam, dlam_ll, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_laed5
(JNIEnv *env, jclass clazz, jintArray i, jdoubleArray d, jdoubleArray z, jdoubleArray delta, jdoubleArray rho, jdoubleArray dlam) {
  int i_loc;
  jint* i_l;
  integer* i_ll;
  jsize i_ls;
  jdouble* d_ll;
  jdouble* z_ll;
  jdouble* delta_ll;
  jdouble* rho_ll;
  jdouble* dlam_ll;
  i_l = (*env)->GetPrimitiveArrayCritical(env, i, NULL);
  i_ls = (*env)->GetArrayLength(env, i);
  i_ll = malloc(sizeof(integer)*i_ls);
  for (i_loc=0; i_loc<i_ls; ++i_loc) i_ll[i_loc] = i_l[i_loc];
  d_ll = (*env)->GetPrimitiveArrayCritical(env, d, NULL);
  z_ll = (*env)->GetPrimitiveArrayCritical(env, z, NULL);
  delta_ll = (*env)->GetPrimitiveArrayCritical(env, delta, NULL);
  rho_ll = (*env)->GetPrimitiveArrayCritical(env, rho, NULL);
  dlam_ll = (*env)->GetPrimitiveArrayCritical(env, dlam, NULL);

  dlaed5_(i_ll, d_ll, z_ll, delta_ll, rho_ll, dlam_ll);

  for (i_loc=0; i_loc<i_ls; ++i_loc) i_l[i_loc] = i_ll[i_loc];
  free(i_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, i, i_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, d, d_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, z, z_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, delta, delta_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, rho, rho_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, dlam, dlam_ll, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_laed6
(JNIEnv *env, jclass clazz, jintArray kniter, jbooleanArray orgati, jdoubleArray rho, jdoubleArray d, jdoubleArray z, jdoubleArray finit, jdoubleArray tau, jintArray info) {
  int i_loc;
  jint* kniter_l;
  integer* kniter_ll;
  jsize kniter_ls;
  jboolean* orgati_l;
  integer* orgati_ll;
  jsize orgati_ls;
  jdouble* rho_ll;
  jdouble* d_ll;
  jdouble* z_ll;
  jdouble* finit_ll;
  jdouble* tau_ll;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  kniter_l = (*env)->GetPrimitiveArrayCritical(env, kniter, NULL);
  kniter_ls = (*env)->GetArrayLength(env, kniter);
  kniter_ll = malloc(sizeof(integer)*kniter_ls);
  for (i_loc=0; i_loc<kniter_ls; ++i_loc) kniter_ll[i_loc] = kniter_l[i_loc];
  orgati_l = (*env)->GetPrimitiveArrayCritical(env, orgati, NULL);
  orgati_ls = (*env)->GetArrayLength(env, orgati);
  orgati_ll = malloc(sizeof(integer)*orgati_ls);
  for (i_loc=0; i_loc<orgati_ls; ++i_loc) orgati_ll[i_loc] = orgati_l[i_loc];
  rho_ll = (*env)->GetPrimitiveArrayCritical(env, rho, NULL);
  d_ll = (*env)->GetPrimitiveArrayCritical(env, d, NULL);
  z_ll = (*env)->GetPrimitiveArrayCritical(env, z, NULL);
  finit_ll = (*env)->GetPrimitiveArrayCritical(env, finit, NULL);
  tau_ll = (*env)->GetPrimitiveArrayCritical(env, tau, NULL);
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dlaed6_(kniter_ll, orgati_ll, rho_ll, d_ll, z_ll, finit_ll, tau_ll, info_ll);

  for (i_loc=0; i_loc<kniter_ls; ++i_loc) kniter_l[i_loc] = kniter_ll[i_loc];
  free(kniter_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, kniter, kniter_l, 0);
  for (i_loc=0; i_loc<orgati_ls; ++i_loc) orgati_l[i_loc] = orgati_ll[i_loc];
  free(orgati_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, orgati, orgati_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, rho, rho_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, d, d_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, z, z_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, finit, finit_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, tau, tau_ll, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_laed7
(JNIEnv *env, jclass clazz, jintArray icompq, jintArray n, jintArray qsiz, jintArray tlvls, jintArray curlvl, jintArray curpbm, jdoubleArray d, jdoubleArray q, jintArray ldq, jintArray indxq, jdoubleArray rho, jintArray cutpnt, jdoubleArray qstore, jintArray qptr, jintArray prmptr, jintArray perm, jintArray givptr, jintArray givcol, jdoubleArray givnum, jdoubleArray work, jintArray iwork, jintArray info) {
  int i_loc;
  jint* icompq_l;
  integer* icompq_ll;
  jsize icompq_ls;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jint* qsiz_l;
  integer* qsiz_ll;
  jsize qsiz_ls;
  jint* tlvls_l;
  integer* tlvls_ll;
  jsize tlvls_ls;
  jint* curlvl_l;
  integer* curlvl_ll;
  jsize curlvl_ls;
  jint* curpbm_l;
  integer* curpbm_ll;
  jsize curpbm_ls;
  jdouble* d_ll;
  jdouble* q_ll;
  jint* ldq_l;
  integer* ldq_ll;
  jsize ldq_ls;
  jint* indxq_l;
  integer* indxq_ll;
  jsize indxq_ls;
  jdouble* rho_ll;
  jint* cutpnt_l;
  integer* cutpnt_ll;
  jsize cutpnt_ls;
  jdouble* qstore_ll;
  jint* qptr_l;
  integer* qptr_ll;
  jsize qptr_ls;
  jint* prmptr_l;
  integer* prmptr_ll;
  jsize prmptr_ls;
  jint* perm_l;
  integer* perm_ll;
  jsize perm_ls;
  jint* givptr_l;
  integer* givptr_ll;
  jsize givptr_ls;
  jint* givcol_l;
  integer* givcol_ll;
  jsize givcol_ls;
  jdouble* givnum_ll;
  jdouble* work_ll;
  jint* iwork_l;
  integer* iwork_ll;
  jsize iwork_ls;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  icompq_l = (*env)->GetPrimitiveArrayCritical(env, icompq, NULL);
  icompq_ls = (*env)->GetArrayLength(env, icompq);
  icompq_ll = malloc(sizeof(integer)*icompq_ls);
  for (i_loc=0; i_loc<icompq_ls; ++i_loc) icompq_ll[i_loc] = icompq_l[i_loc];
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  qsiz_l = (*env)->GetPrimitiveArrayCritical(env, qsiz, NULL);
  qsiz_ls = (*env)->GetArrayLength(env, qsiz);
  qsiz_ll = malloc(sizeof(integer)*qsiz_ls);
  for (i_loc=0; i_loc<qsiz_ls; ++i_loc) qsiz_ll[i_loc] = qsiz_l[i_loc];
  tlvls_l = (*env)->GetPrimitiveArrayCritical(env, tlvls, NULL);
  tlvls_ls = (*env)->GetArrayLength(env, tlvls);
  tlvls_ll = malloc(sizeof(integer)*tlvls_ls);
  for (i_loc=0; i_loc<tlvls_ls; ++i_loc) tlvls_ll[i_loc] = tlvls_l[i_loc];
  curlvl_l = (*env)->GetPrimitiveArrayCritical(env, curlvl, NULL);
  curlvl_ls = (*env)->GetArrayLength(env, curlvl);
  curlvl_ll = malloc(sizeof(integer)*curlvl_ls);
  for (i_loc=0; i_loc<curlvl_ls; ++i_loc) curlvl_ll[i_loc] = curlvl_l[i_loc];
  curpbm_l = (*env)->GetPrimitiveArrayCritical(env, curpbm, NULL);
  curpbm_ls = (*env)->GetArrayLength(env, curpbm);
  curpbm_ll = malloc(sizeof(integer)*curpbm_ls);
  for (i_loc=0; i_loc<curpbm_ls; ++i_loc) curpbm_ll[i_loc] = curpbm_l[i_loc];
  d_ll = (*env)->GetPrimitiveArrayCritical(env, d, NULL);
  q_ll = (*env)->GetPrimitiveArrayCritical(env, q, NULL);
  ldq_l = (*env)->GetPrimitiveArrayCritical(env, ldq, NULL);
  ldq_ls = (*env)->GetArrayLength(env, ldq);
  ldq_ll = malloc(sizeof(integer)*ldq_ls);
  for (i_loc=0; i_loc<ldq_ls; ++i_loc) ldq_ll[i_loc] = ldq_l[i_loc];
  indxq_l = (*env)->GetPrimitiveArrayCritical(env, indxq, NULL);
  indxq_ls = (*env)->GetArrayLength(env, indxq);
  indxq_ll = malloc(sizeof(integer)*indxq_ls);
  for (i_loc=0; i_loc<indxq_ls; ++i_loc) indxq_ll[i_loc] = indxq_l[i_loc];
  rho_ll = (*env)->GetPrimitiveArrayCritical(env, rho, NULL);
  cutpnt_l = (*env)->GetPrimitiveArrayCritical(env, cutpnt, NULL);
  cutpnt_ls = (*env)->GetArrayLength(env, cutpnt);
  cutpnt_ll = malloc(sizeof(integer)*cutpnt_ls);
  for (i_loc=0; i_loc<cutpnt_ls; ++i_loc) cutpnt_ll[i_loc] = cutpnt_l[i_loc];
  qstore_ll = (*env)->GetPrimitiveArrayCritical(env, qstore, NULL);
  qptr_l = (*env)->GetPrimitiveArrayCritical(env, qptr, NULL);
  qptr_ls = (*env)->GetArrayLength(env, qptr);
  qptr_ll = malloc(sizeof(integer)*qptr_ls);
  for (i_loc=0; i_loc<qptr_ls; ++i_loc) qptr_ll[i_loc] = qptr_l[i_loc];
  prmptr_l = (*env)->GetPrimitiveArrayCritical(env, prmptr, NULL);
  prmptr_ls = (*env)->GetArrayLength(env, prmptr);
  prmptr_ll = malloc(sizeof(integer)*prmptr_ls);
  for (i_loc=0; i_loc<prmptr_ls; ++i_loc) prmptr_ll[i_loc] = prmptr_l[i_loc];
  perm_l = (*env)->GetPrimitiveArrayCritical(env, perm, NULL);
  perm_ls = (*env)->GetArrayLength(env, perm);
  perm_ll = malloc(sizeof(integer)*perm_ls);
  for (i_loc=0; i_loc<perm_ls; ++i_loc) perm_ll[i_loc] = perm_l[i_loc];
  givptr_l = (*env)->GetPrimitiveArrayCritical(env, givptr, NULL);
  givptr_ls = (*env)->GetArrayLength(env, givptr);
  givptr_ll = malloc(sizeof(integer)*givptr_ls);
  for (i_loc=0; i_loc<givptr_ls; ++i_loc) givptr_ll[i_loc] = givptr_l[i_loc];
  givcol_l = (*env)->GetPrimitiveArrayCritical(env, givcol, NULL);
  givcol_ls = (*env)->GetArrayLength(env, givcol);
  givcol_ll = malloc(sizeof(integer)*givcol_ls);
  for (i_loc=0; i_loc<givcol_ls; ++i_loc) givcol_ll[i_loc] = givcol_l[i_loc];
  givnum_ll = (*env)->GetPrimitiveArrayCritical(env, givnum, NULL);
  work_ll = (*env)->GetPrimitiveArrayCritical(env, work, NULL);
  iwork_l = (*env)->GetPrimitiveArrayCritical(env, iwork, NULL);
  iwork_ls = (*env)->GetArrayLength(env, iwork);
  iwork_ll = malloc(sizeof(integer)*iwork_ls);
  for (i_loc=0; i_loc<iwork_ls; ++i_loc) iwork_ll[i_loc] = iwork_l[i_loc];
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dlaed7_(icompq_ll, n_ll, qsiz_ll, tlvls_ll, curlvl_ll, curpbm_ll, d_ll, q_ll, ldq_ll, indxq_ll, rho_ll, cutpnt_ll, qstore_ll, qptr_ll, prmptr_ll, perm_ll, givptr_ll, givcol_ll, givnum_ll, work_ll, iwork_ll, info_ll);

  for (i_loc=0; i_loc<icompq_ls; ++i_loc) icompq_l[i_loc] = icompq_ll[i_loc];
  free(icompq_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, icompq, icompq_l, 0);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  for (i_loc=0; i_loc<qsiz_ls; ++i_loc) qsiz_l[i_loc] = qsiz_ll[i_loc];
  free(qsiz_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, qsiz, qsiz_l, 0);
  for (i_loc=0; i_loc<tlvls_ls; ++i_loc) tlvls_l[i_loc] = tlvls_ll[i_loc];
  free(tlvls_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, tlvls, tlvls_l, 0);
  for (i_loc=0; i_loc<curlvl_ls; ++i_loc) curlvl_l[i_loc] = curlvl_ll[i_loc];
  free(curlvl_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, curlvl, curlvl_l, 0);
  for (i_loc=0; i_loc<curpbm_ls; ++i_loc) curpbm_l[i_loc] = curpbm_ll[i_loc];
  free(curpbm_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, curpbm, curpbm_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, d, d_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, q, q_ll, 0);
  for (i_loc=0; i_loc<ldq_ls; ++i_loc) ldq_l[i_loc] = ldq_ll[i_loc];
  free(ldq_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldq, ldq_l, 0);
  for (i_loc=0; i_loc<indxq_ls; ++i_loc) indxq_l[i_loc] = indxq_ll[i_loc];
  free(indxq_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, indxq, indxq_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, rho, rho_ll, 0);
  for (i_loc=0; i_loc<cutpnt_ls; ++i_loc) cutpnt_l[i_loc] = cutpnt_ll[i_loc];
  free(cutpnt_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, cutpnt, cutpnt_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, qstore, qstore_ll, 0);
  for (i_loc=0; i_loc<qptr_ls; ++i_loc) qptr_l[i_loc] = qptr_ll[i_loc];
  free(qptr_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, qptr, qptr_l, 0);
  for (i_loc=0; i_loc<prmptr_ls; ++i_loc) prmptr_l[i_loc] = prmptr_ll[i_loc];
  free(prmptr_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, prmptr, prmptr_l, 0);
  for (i_loc=0; i_loc<perm_ls; ++i_loc) perm_l[i_loc] = perm_ll[i_loc];
  free(perm_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, perm, perm_l, 0);
  for (i_loc=0; i_loc<givptr_ls; ++i_loc) givptr_l[i_loc] = givptr_ll[i_loc];
  free(givptr_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, givptr, givptr_l, 0);
  for (i_loc=0; i_loc<givcol_ls; ++i_loc) givcol_l[i_loc] = givcol_ll[i_loc];
  free(givcol_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, givcol, givcol_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, givnum, givnum_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, work, work_ll, 0);
  for (i_loc=0; i_loc<iwork_ls; ++i_loc) iwork_l[i_loc] = iwork_ll[i_loc];
  free(iwork_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, iwork, iwork_l, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_laed8
(JNIEnv *env, jclass clazz, jintArray icompq, jintArray k, jintArray n, jintArray qsiz, jdoubleArray d, jdoubleArray q, jintArray ldq, jintArray indxq, jdoubleArray rho, jintArray cutpnt, jdoubleArray z, jdoubleArray dlamda, jdoubleArray q2, jintArray ldq2, jdoubleArray w, jintArray perm, jintArray givptr, jintArray givcol, jdoubleArray givnum, jintArray indxp, jintArray indx, jintArray info) {
  int i_loc;
  jint* icompq_l;
  integer* icompq_ll;
  jsize icompq_ls;
  jint* k_l;
  integer* k_ll;
  jsize k_ls;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jint* qsiz_l;
  integer* qsiz_ll;
  jsize qsiz_ls;
  jdouble* d_ll;
  jdouble* q_ll;
  jint* ldq_l;
  integer* ldq_ll;
  jsize ldq_ls;
  jint* indxq_l;
  integer* indxq_ll;
  jsize indxq_ls;
  jdouble* rho_ll;
  jint* cutpnt_l;
  integer* cutpnt_ll;
  jsize cutpnt_ls;
  jdouble* z_ll;
  jdouble* dlamda_ll;
  jdouble* q2_ll;
  jint* ldq2_l;
  integer* ldq2_ll;
  jsize ldq2_ls;
  jdouble* w_ll;
  jint* perm_l;
  integer* perm_ll;
  jsize perm_ls;
  jint* givptr_l;
  integer* givptr_ll;
  jsize givptr_ls;
  jint* givcol_l;
  integer* givcol_ll;
  jsize givcol_ls;
  jdouble* givnum_ll;
  jint* indxp_l;
  integer* indxp_ll;
  jsize indxp_ls;
  jint* indx_l;
  integer* indx_ll;
  jsize indx_ls;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  icompq_l = (*env)->GetPrimitiveArrayCritical(env, icompq, NULL);
  icompq_ls = (*env)->GetArrayLength(env, icompq);
  icompq_ll = malloc(sizeof(integer)*icompq_ls);
  for (i_loc=0; i_loc<icompq_ls; ++i_loc) icompq_ll[i_loc] = icompq_l[i_loc];
  k_l = (*env)->GetPrimitiveArrayCritical(env, k, NULL);
  k_ls = (*env)->GetArrayLength(env, k);
  k_ll = malloc(sizeof(integer)*k_ls);
  for (i_loc=0; i_loc<k_ls; ++i_loc) k_ll[i_loc] = k_l[i_loc];
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  qsiz_l = (*env)->GetPrimitiveArrayCritical(env, qsiz, NULL);
  qsiz_ls = (*env)->GetArrayLength(env, qsiz);
  qsiz_ll = malloc(sizeof(integer)*qsiz_ls);
  for (i_loc=0; i_loc<qsiz_ls; ++i_loc) qsiz_ll[i_loc] = qsiz_l[i_loc];
  d_ll = (*env)->GetPrimitiveArrayCritical(env, d, NULL);
  q_ll = (*env)->GetPrimitiveArrayCritical(env, q, NULL);
  ldq_l = (*env)->GetPrimitiveArrayCritical(env, ldq, NULL);
  ldq_ls = (*env)->GetArrayLength(env, ldq);
  ldq_ll = malloc(sizeof(integer)*ldq_ls);
  for (i_loc=0; i_loc<ldq_ls; ++i_loc) ldq_ll[i_loc] = ldq_l[i_loc];
  indxq_l = (*env)->GetPrimitiveArrayCritical(env, indxq, NULL);
  indxq_ls = (*env)->GetArrayLength(env, indxq);
  indxq_ll = malloc(sizeof(integer)*indxq_ls);
  for (i_loc=0; i_loc<indxq_ls; ++i_loc) indxq_ll[i_loc] = indxq_l[i_loc];
  rho_ll = (*env)->GetPrimitiveArrayCritical(env, rho, NULL);
  cutpnt_l = (*env)->GetPrimitiveArrayCritical(env, cutpnt, NULL);
  cutpnt_ls = (*env)->GetArrayLength(env, cutpnt);
  cutpnt_ll = malloc(sizeof(integer)*cutpnt_ls);
  for (i_loc=0; i_loc<cutpnt_ls; ++i_loc) cutpnt_ll[i_loc] = cutpnt_l[i_loc];
  z_ll = (*env)->GetPrimitiveArrayCritical(env, z, NULL);
  dlamda_ll = (*env)->GetPrimitiveArrayCritical(env, dlamda, NULL);
  q2_ll = (*env)->GetPrimitiveArrayCritical(env, q2, NULL);
  ldq2_l = (*env)->GetPrimitiveArrayCritical(env, ldq2, NULL);
  ldq2_ls = (*env)->GetArrayLength(env, ldq2);
  ldq2_ll = malloc(sizeof(integer)*ldq2_ls);
  for (i_loc=0; i_loc<ldq2_ls; ++i_loc) ldq2_ll[i_loc] = ldq2_l[i_loc];
  w_ll = (*env)->GetPrimitiveArrayCritical(env, w, NULL);
  perm_l = (*env)->GetPrimitiveArrayCritical(env, perm, NULL);
  perm_ls = (*env)->GetArrayLength(env, perm);
  perm_ll = malloc(sizeof(integer)*perm_ls);
  for (i_loc=0; i_loc<perm_ls; ++i_loc) perm_ll[i_loc] = perm_l[i_loc];
  givptr_l = (*env)->GetPrimitiveArrayCritical(env, givptr, NULL);
  givptr_ls = (*env)->GetArrayLength(env, givptr);
  givptr_ll = malloc(sizeof(integer)*givptr_ls);
  for (i_loc=0; i_loc<givptr_ls; ++i_loc) givptr_ll[i_loc] = givptr_l[i_loc];
  givcol_l = (*env)->GetPrimitiveArrayCritical(env, givcol, NULL);
  givcol_ls = (*env)->GetArrayLength(env, givcol);
  givcol_ll = malloc(sizeof(integer)*givcol_ls);
  for (i_loc=0; i_loc<givcol_ls; ++i_loc) givcol_ll[i_loc] = givcol_l[i_loc];
  givnum_ll = (*env)->GetPrimitiveArrayCritical(env, givnum, NULL);
  indxp_l = (*env)->GetPrimitiveArrayCritical(env, indxp, NULL);
  indxp_ls = (*env)->GetArrayLength(env, indxp);
  indxp_ll = malloc(sizeof(integer)*indxp_ls);
  for (i_loc=0; i_loc<indxp_ls; ++i_loc) indxp_ll[i_loc] = indxp_l[i_loc];
  indx_l = (*env)->GetPrimitiveArrayCritical(env, indx, NULL);
  indx_ls = (*env)->GetArrayLength(env, indx);
  indx_ll = malloc(sizeof(integer)*indx_ls);
  for (i_loc=0; i_loc<indx_ls; ++i_loc) indx_ll[i_loc] = indx_l[i_loc];
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dlaed8_(icompq_ll, k_ll, n_ll, qsiz_ll, d_ll, q_ll, ldq_ll, indxq_ll, rho_ll, cutpnt_ll, z_ll, dlamda_ll, q2_ll, ldq2_ll, w_ll, perm_ll, givptr_ll, givcol_ll, givnum_ll, indxp_ll, indx_ll, info_ll);

  for (i_loc=0; i_loc<icompq_ls; ++i_loc) icompq_l[i_loc] = icompq_ll[i_loc];
  free(icompq_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, icompq, icompq_l, 0);
  for (i_loc=0; i_loc<k_ls; ++i_loc) k_l[i_loc] = k_ll[i_loc];
  free(k_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, k, k_l, 0);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  for (i_loc=0; i_loc<qsiz_ls; ++i_loc) qsiz_l[i_loc] = qsiz_ll[i_loc];
  free(qsiz_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, qsiz, qsiz_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, d, d_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, q, q_ll, 0);
  for (i_loc=0; i_loc<ldq_ls; ++i_loc) ldq_l[i_loc] = ldq_ll[i_loc];
  free(ldq_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldq, ldq_l, 0);
  for (i_loc=0; i_loc<indxq_ls; ++i_loc) indxq_l[i_loc] = indxq_ll[i_loc];
  free(indxq_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, indxq, indxq_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, rho, rho_ll, 0);
  for (i_loc=0; i_loc<cutpnt_ls; ++i_loc) cutpnt_l[i_loc] = cutpnt_ll[i_loc];
  free(cutpnt_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, cutpnt, cutpnt_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, z, z_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, dlamda, dlamda_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, q2, q2_ll, 0);
  for (i_loc=0; i_loc<ldq2_ls; ++i_loc) ldq2_l[i_loc] = ldq2_ll[i_loc];
  free(ldq2_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldq2, ldq2_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, w, w_ll, 0);
  for (i_loc=0; i_loc<perm_ls; ++i_loc) perm_l[i_loc] = perm_ll[i_loc];
  free(perm_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, perm, perm_l, 0);
  for (i_loc=0; i_loc<givptr_ls; ++i_loc) givptr_l[i_loc] = givptr_ll[i_loc];
  free(givptr_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, givptr, givptr_l, 0);
  for (i_loc=0; i_loc<givcol_ls; ++i_loc) givcol_l[i_loc] = givcol_ll[i_loc];
  free(givcol_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, givcol, givcol_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, givnum, givnum_ll, 0);
  for (i_loc=0; i_loc<indxp_ls; ++i_loc) indxp_l[i_loc] = indxp_ll[i_loc];
  free(indxp_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, indxp, indxp_l, 0);
  for (i_loc=0; i_loc<indx_ls; ++i_loc) indx_l[i_loc] = indx_ll[i_loc];
  free(indx_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, indx, indx_l, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_laed9
(JNIEnv *env, jclass clazz, jintArray k, jintArray kstart, jintArray kstop, jintArray n, jdoubleArray d, jdoubleArray q, jintArray ldq, jdoubleArray rho, jdoubleArray dlamda, jdoubleArray w, jdoubleArray s, jintArray lds, jintArray info) {
  int i_loc;
  jint* k_l;
  integer* k_ll;
  jsize k_ls;
  jint* kstart_l;
  integer* kstart_ll;
  jsize kstart_ls;
  jint* kstop_l;
  integer* kstop_ll;
  jsize kstop_ls;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jdouble* d_ll;
  jdouble* q_ll;
  jint* ldq_l;
  integer* ldq_ll;
  jsize ldq_ls;
  jdouble* rho_ll;
  jdouble* dlamda_ll;
  jdouble* w_ll;
  jdouble* s_ll;
  jint* lds_l;
  integer* lds_ll;
  jsize lds_ls;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  k_l = (*env)->GetPrimitiveArrayCritical(env, k, NULL);
  k_ls = (*env)->GetArrayLength(env, k);
  k_ll = malloc(sizeof(integer)*k_ls);
  for (i_loc=0; i_loc<k_ls; ++i_loc) k_ll[i_loc] = k_l[i_loc];
  kstart_l = (*env)->GetPrimitiveArrayCritical(env, kstart, NULL);
  kstart_ls = (*env)->GetArrayLength(env, kstart);
  kstart_ll = malloc(sizeof(integer)*kstart_ls);
  for (i_loc=0; i_loc<kstart_ls; ++i_loc) kstart_ll[i_loc] = kstart_l[i_loc];
  kstop_l = (*env)->GetPrimitiveArrayCritical(env, kstop, NULL);
  kstop_ls = (*env)->GetArrayLength(env, kstop);
  kstop_ll = malloc(sizeof(integer)*kstop_ls);
  for (i_loc=0; i_loc<kstop_ls; ++i_loc) kstop_ll[i_loc] = kstop_l[i_loc];
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  d_ll = (*env)->GetPrimitiveArrayCritical(env, d, NULL);
  q_ll = (*env)->GetPrimitiveArrayCritical(env, q, NULL);
  ldq_l = (*env)->GetPrimitiveArrayCritical(env, ldq, NULL);
  ldq_ls = (*env)->GetArrayLength(env, ldq);
  ldq_ll = malloc(sizeof(integer)*ldq_ls);
  for (i_loc=0; i_loc<ldq_ls; ++i_loc) ldq_ll[i_loc] = ldq_l[i_loc];
  rho_ll = (*env)->GetPrimitiveArrayCritical(env, rho, NULL);
  dlamda_ll = (*env)->GetPrimitiveArrayCritical(env, dlamda, NULL);
  w_ll = (*env)->GetPrimitiveArrayCritical(env, w, NULL);
  s_ll = (*env)->GetPrimitiveArrayCritical(env, s, NULL);
  lds_l = (*env)->GetPrimitiveArrayCritical(env, lds, NULL);
  lds_ls = (*env)->GetArrayLength(env, lds);
  lds_ll = malloc(sizeof(integer)*lds_ls);
  for (i_loc=0; i_loc<lds_ls; ++i_loc) lds_ll[i_loc] = lds_l[i_loc];
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dlaed9_(k_ll, kstart_ll, kstop_ll, n_ll, d_ll, q_ll, ldq_ll, rho_ll, dlamda_ll, w_ll, s_ll, lds_ll, info_ll);

  for (i_loc=0; i_loc<k_ls; ++i_loc) k_l[i_loc] = k_ll[i_loc];
  free(k_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, k, k_l, 0);
  for (i_loc=0; i_loc<kstart_ls; ++i_loc) kstart_l[i_loc] = kstart_ll[i_loc];
  free(kstart_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, kstart, kstart_l, 0);
  for (i_loc=0; i_loc<kstop_ls; ++i_loc) kstop_l[i_loc] = kstop_ll[i_loc];
  free(kstop_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, kstop, kstop_l, 0);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, d, d_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, q, q_ll, 0);
  for (i_loc=0; i_loc<ldq_ls; ++i_loc) ldq_l[i_loc] = ldq_ll[i_loc];
  free(ldq_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldq, ldq_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, rho, rho_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, dlamda, dlamda_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, w, w_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, s, s_ll, 0);
  for (i_loc=0; i_loc<lds_ls; ++i_loc) lds_l[i_loc] = lds_ll[i_loc];
  free(lds_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, lds, lds_l, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_laeda
(JNIEnv *env, jclass clazz, jintArray n, jintArray tlvls, jintArray curlvl, jintArray curpbm, jintArray prmptr, jintArray perm, jintArray givptr, jintArray givcol, jdoubleArray givnum, jdoubleArray q, jintArray qptr, jdoubleArray z, jdoubleArray ztemp, jintArray info) {
  int i_loc;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jint* tlvls_l;
  integer* tlvls_ll;
  jsize tlvls_ls;
  jint* curlvl_l;
  integer* curlvl_ll;
  jsize curlvl_ls;
  jint* curpbm_l;
  integer* curpbm_ll;
  jsize curpbm_ls;
  jint* prmptr_l;
  integer* prmptr_ll;
  jsize prmptr_ls;
  jint* perm_l;
  integer* perm_ll;
  jsize perm_ls;
  jint* givptr_l;
  integer* givptr_ll;
  jsize givptr_ls;
  jint* givcol_l;
  integer* givcol_ll;
  jsize givcol_ls;
  jdouble* givnum_ll;
  jdouble* q_ll;
  jint* qptr_l;
  integer* qptr_ll;
  jsize qptr_ls;
  jdouble* z_ll;
  jdouble* ztemp_ll;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  tlvls_l = (*env)->GetPrimitiveArrayCritical(env, tlvls, NULL);
  tlvls_ls = (*env)->GetArrayLength(env, tlvls);
  tlvls_ll = malloc(sizeof(integer)*tlvls_ls);
  for (i_loc=0; i_loc<tlvls_ls; ++i_loc) tlvls_ll[i_loc] = tlvls_l[i_loc];
  curlvl_l = (*env)->GetPrimitiveArrayCritical(env, curlvl, NULL);
  curlvl_ls = (*env)->GetArrayLength(env, curlvl);
  curlvl_ll = malloc(sizeof(integer)*curlvl_ls);
  for (i_loc=0; i_loc<curlvl_ls; ++i_loc) curlvl_ll[i_loc] = curlvl_l[i_loc];
  curpbm_l = (*env)->GetPrimitiveArrayCritical(env, curpbm, NULL);
  curpbm_ls = (*env)->GetArrayLength(env, curpbm);
  curpbm_ll = malloc(sizeof(integer)*curpbm_ls);
  for (i_loc=0; i_loc<curpbm_ls; ++i_loc) curpbm_ll[i_loc] = curpbm_l[i_loc];
  prmptr_l = (*env)->GetPrimitiveArrayCritical(env, prmptr, NULL);
  prmptr_ls = (*env)->GetArrayLength(env, prmptr);
  prmptr_ll = malloc(sizeof(integer)*prmptr_ls);
  for (i_loc=0; i_loc<prmptr_ls; ++i_loc) prmptr_ll[i_loc] = prmptr_l[i_loc];
  perm_l = (*env)->GetPrimitiveArrayCritical(env, perm, NULL);
  perm_ls = (*env)->GetArrayLength(env, perm);
  perm_ll = malloc(sizeof(integer)*perm_ls);
  for (i_loc=0; i_loc<perm_ls; ++i_loc) perm_ll[i_loc] = perm_l[i_loc];
  givptr_l = (*env)->GetPrimitiveArrayCritical(env, givptr, NULL);
  givptr_ls = (*env)->GetArrayLength(env, givptr);
  givptr_ll = malloc(sizeof(integer)*givptr_ls);
  for (i_loc=0; i_loc<givptr_ls; ++i_loc) givptr_ll[i_loc] = givptr_l[i_loc];
  givcol_l = (*env)->GetPrimitiveArrayCritical(env, givcol, NULL);
  givcol_ls = (*env)->GetArrayLength(env, givcol);
  givcol_ll = malloc(sizeof(integer)*givcol_ls);
  for (i_loc=0; i_loc<givcol_ls; ++i_loc) givcol_ll[i_loc] = givcol_l[i_loc];
  givnum_ll = (*env)->GetPrimitiveArrayCritical(env, givnum, NULL);
  q_ll = (*env)->GetPrimitiveArrayCritical(env, q, NULL);
  qptr_l = (*env)->GetPrimitiveArrayCritical(env, qptr, NULL);
  qptr_ls = (*env)->GetArrayLength(env, qptr);
  qptr_ll = malloc(sizeof(integer)*qptr_ls);
  for (i_loc=0; i_loc<qptr_ls; ++i_loc) qptr_ll[i_loc] = qptr_l[i_loc];
  z_ll = (*env)->GetPrimitiveArrayCritical(env, z, NULL);
  ztemp_ll = (*env)->GetPrimitiveArrayCritical(env, ztemp, NULL);
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dlaeda_(n_ll, tlvls_ll, curlvl_ll, curpbm_ll, prmptr_ll, perm_ll, givptr_ll, givcol_ll, givnum_ll, q_ll, qptr_ll, z_ll, ztemp_ll, info_ll);

  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  for (i_loc=0; i_loc<tlvls_ls; ++i_loc) tlvls_l[i_loc] = tlvls_ll[i_loc];
  free(tlvls_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, tlvls, tlvls_l, 0);
  for (i_loc=0; i_loc<curlvl_ls; ++i_loc) curlvl_l[i_loc] = curlvl_ll[i_loc];
  free(curlvl_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, curlvl, curlvl_l, 0);
  for (i_loc=0; i_loc<curpbm_ls; ++i_loc) curpbm_l[i_loc] = curpbm_ll[i_loc];
  free(curpbm_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, curpbm, curpbm_l, 0);
  for (i_loc=0; i_loc<prmptr_ls; ++i_loc) prmptr_l[i_loc] = prmptr_ll[i_loc];
  free(prmptr_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, prmptr, prmptr_l, 0);
  for (i_loc=0; i_loc<perm_ls; ++i_loc) perm_l[i_loc] = perm_ll[i_loc];
  free(perm_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, perm, perm_l, 0);
  for (i_loc=0; i_loc<givptr_ls; ++i_loc) givptr_l[i_loc] = givptr_ll[i_loc];
  free(givptr_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, givptr, givptr_l, 0);
  for (i_loc=0; i_loc<givcol_ls; ++i_loc) givcol_l[i_loc] = givcol_ll[i_loc];
  free(givcol_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, givcol, givcol_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, givnum, givnum_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, q, q_ll, 0);
  for (i_loc=0; i_loc<qptr_ls; ++i_loc) qptr_l[i_loc] = qptr_ll[i_loc];
  free(qptr_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, qptr, qptr_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, z, z_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, ztemp, ztemp_ll, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_laein
(JNIEnv *env, jclass clazz, jbooleanArray rightv, jbooleanArray noinit, jintArray n, jdoubleArray h, jintArray ldh, jdoubleArray wr, jdoubleArray wi, jdoubleArray vr, jdoubleArray vi, jdoubleArray b, jintArray ldb, jdoubleArray work, jdoubleArray eps3, jdoubleArray smlnum, jdoubleArray bignum, jintArray info) {
  int i_loc;
  jboolean* rightv_l;
  integer* rightv_ll;
  jsize rightv_ls;
  jboolean* noinit_l;
  integer* noinit_ll;
  jsize noinit_ls;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jdouble* h_ll;
  jint* ldh_l;
  integer* ldh_ll;
  jsize ldh_ls;
  jdouble* wr_ll;
  jdouble* wi_ll;
  jdouble* vr_ll;
  jdouble* vi_ll;
  jdouble* b_ll;
  jint* ldb_l;
  integer* ldb_ll;
  jsize ldb_ls;
  jdouble* work_ll;
  jdouble* eps3_ll;
  jdouble* smlnum_ll;
  jdouble* bignum_ll;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  rightv_l = (*env)->GetPrimitiveArrayCritical(env, rightv, NULL);
  rightv_ls = (*env)->GetArrayLength(env, rightv);
  rightv_ll = malloc(sizeof(integer)*rightv_ls);
  for (i_loc=0; i_loc<rightv_ls; ++i_loc) rightv_ll[i_loc] = rightv_l[i_loc];
  noinit_l = (*env)->GetPrimitiveArrayCritical(env, noinit, NULL);
  noinit_ls = (*env)->GetArrayLength(env, noinit);
  noinit_ll = malloc(sizeof(integer)*noinit_ls);
  for (i_loc=0; i_loc<noinit_ls; ++i_loc) noinit_ll[i_loc] = noinit_l[i_loc];
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  h_ll = (*env)->GetPrimitiveArrayCritical(env, h, NULL);
  ldh_l = (*env)->GetPrimitiveArrayCritical(env, ldh, NULL);
  ldh_ls = (*env)->GetArrayLength(env, ldh);
  ldh_ll = malloc(sizeof(integer)*ldh_ls);
  for (i_loc=0; i_loc<ldh_ls; ++i_loc) ldh_ll[i_loc] = ldh_l[i_loc];
  wr_ll = (*env)->GetPrimitiveArrayCritical(env, wr, NULL);
  wi_ll = (*env)->GetPrimitiveArrayCritical(env, wi, NULL);
  vr_ll = (*env)->GetPrimitiveArrayCritical(env, vr, NULL);
  vi_ll = (*env)->GetPrimitiveArrayCritical(env, vi, NULL);
  b_ll = (*env)->GetPrimitiveArrayCritical(env, b, NULL);
  ldb_l = (*env)->GetPrimitiveArrayCritical(env, ldb, NULL);
  ldb_ls = (*env)->GetArrayLength(env, ldb);
  ldb_ll = malloc(sizeof(integer)*ldb_ls);
  for (i_loc=0; i_loc<ldb_ls; ++i_loc) ldb_ll[i_loc] = ldb_l[i_loc];
  work_ll = (*env)->GetPrimitiveArrayCritical(env, work, NULL);
  eps3_ll = (*env)->GetPrimitiveArrayCritical(env, eps3, NULL);
  smlnum_ll = (*env)->GetPrimitiveArrayCritical(env, smlnum, NULL);
  bignum_ll = (*env)->GetPrimitiveArrayCritical(env, bignum, NULL);
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dlaein_(rightv_ll, noinit_ll, n_ll, h_ll, ldh_ll, wr_ll, wi_ll, vr_ll, vi_ll, b_ll, ldb_ll, work_ll, eps3_ll, smlnum_ll, bignum_ll, info_ll);

  for (i_loc=0; i_loc<rightv_ls; ++i_loc) rightv_l[i_loc] = rightv_ll[i_loc];
  free(rightv_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, rightv, rightv_l, 0);
  for (i_loc=0; i_loc<noinit_ls; ++i_loc) noinit_l[i_loc] = noinit_ll[i_loc];
  free(noinit_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, noinit, noinit_l, 0);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, h, h_ll, 0);
  for (i_loc=0; i_loc<ldh_ls; ++i_loc) ldh_l[i_loc] = ldh_ll[i_loc];
  free(ldh_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldh, ldh_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, wr, wr_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, wi, wi_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, vr, vr_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, vi, vi_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, b, b_ll, 0);
  for (i_loc=0; i_loc<ldb_ls; ++i_loc) ldb_l[i_loc] = ldb_ll[i_loc];
  free(ldb_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldb, ldb_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, work, work_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, eps3, eps3_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, smlnum, smlnum_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, bignum, bignum_ll, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_laev2
(JNIEnv *env, jclass clazz, jdoubleArray a, jdoubleArray b, jdoubleArray c, jdoubleArray rt1, jdoubleArray rt2, jdoubleArray cs1, jdoubleArray sn1) {
  jdouble* a_ll;
  jdouble* b_ll;
  jdouble* c_ll;
  jdouble* rt1_ll;
  jdouble* rt2_ll;
  jdouble* cs1_ll;
  jdouble* sn1_ll;
  a_ll = (*env)->GetPrimitiveArrayCritical(env, a, NULL);
  b_ll = (*env)->GetPrimitiveArrayCritical(env, b, NULL);
  c_ll = (*env)->GetPrimitiveArrayCritical(env, c, NULL);
  rt1_ll = (*env)->GetPrimitiveArrayCritical(env, rt1, NULL);
  rt2_ll = (*env)->GetPrimitiveArrayCritical(env, rt2, NULL);
  cs1_ll = (*env)->GetPrimitiveArrayCritical(env, cs1, NULL);
  sn1_ll = (*env)->GetPrimitiveArrayCritical(env, sn1, NULL);

  dlaev2_(a_ll, b_ll, c_ll, rt1_ll, rt2_ll, cs1_ll, sn1_ll);

  (*env)->ReleasePrimitiveArrayCritical(env, a, a_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, b, b_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, c, c_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, rt1, rt1_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, rt2, rt2_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, cs1, cs1_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, sn1, sn1_ll, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_laexc
(JNIEnv *env, jclass clazz, jbooleanArray wantq, jintArray n, jdoubleArray t, jintArray ldt, jdoubleArray q, jintArray ldq, jintArray j1, jintArray n1, jintArray n2, jdoubleArray work, jintArray info) {
  int i_loc;
  jboolean* wantq_l;
  integer* wantq_ll;
  jsize wantq_ls;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jdouble* t_ll;
  jint* ldt_l;
  integer* ldt_ll;
  jsize ldt_ls;
  jdouble* q_ll;
  jint* ldq_l;
  integer* ldq_ll;
  jsize ldq_ls;
  jint* j1_l;
  integer* j1_ll;
  jsize j1_ls;
  jint* n1_l;
  integer* n1_ll;
  jsize n1_ls;
  jint* n2_l;
  integer* n2_ll;
  jsize n2_ls;
  jdouble* work_ll;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  wantq_l = (*env)->GetPrimitiveArrayCritical(env, wantq, NULL);
  wantq_ls = (*env)->GetArrayLength(env, wantq);
  wantq_ll = malloc(sizeof(integer)*wantq_ls);
  for (i_loc=0; i_loc<wantq_ls; ++i_loc) wantq_ll[i_loc] = wantq_l[i_loc];
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  t_ll = (*env)->GetPrimitiveArrayCritical(env, t, NULL);
  ldt_l = (*env)->GetPrimitiveArrayCritical(env, ldt, NULL);
  ldt_ls = (*env)->GetArrayLength(env, ldt);
  ldt_ll = malloc(sizeof(integer)*ldt_ls);
  for (i_loc=0; i_loc<ldt_ls; ++i_loc) ldt_ll[i_loc] = ldt_l[i_loc];
  q_ll = (*env)->GetPrimitiveArrayCritical(env, q, NULL);
  ldq_l = (*env)->GetPrimitiveArrayCritical(env, ldq, NULL);
  ldq_ls = (*env)->GetArrayLength(env, ldq);
  ldq_ll = malloc(sizeof(integer)*ldq_ls);
  for (i_loc=0; i_loc<ldq_ls; ++i_loc) ldq_ll[i_loc] = ldq_l[i_loc];
  j1_l = (*env)->GetPrimitiveArrayCritical(env, j1, NULL);
  j1_ls = (*env)->GetArrayLength(env, j1);
  j1_ll = malloc(sizeof(integer)*j1_ls);
  for (i_loc=0; i_loc<j1_ls; ++i_loc) j1_ll[i_loc] = j1_l[i_loc];
  n1_l = (*env)->GetPrimitiveArrayCritical(env, n1, NULL);
  n1_ls = (*env)->GetArrayLength(env, n1);
  n1_ll = malloc(sizeof(integer)*n1_ls);
  for (i_loc=0; i_loc<n1_ls; ++i_loc) n1_ll[i_loc] = n1_l[i_loc];
  n2_l = (*env)->GetPrimitiveArrayCritical(env, n2, NULL);
  n2_ls = (*env)->GetArrayLength(env, n2);
  n2_ll = malloc(sizeof(integer)*n2_ls);
  for (i_loc=0; i_loc<n2_ls; ++i_loc) n2_ll[i_loc] = n2_l[i_loc];
  work_ll = (*env)->GetPrimitiveArrayCritical(env, work, NULL);
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dlaexc_(wantq_ll, n_ll, t_ll, ldt_ll, q_ll, ldq_ll, j1_ll, n1_ll, n2_ll, work_ll, info_ll);

  for (i_loc=0; i_loc<wantq_ls; ++i_loc) wantq_l[i_loc] = wantq_ll[i_loc];
  free(wantq_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, wantq, wantq_l, 0);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, t, t_ll, 0);
  for (i_loc=0; i_loc<ldt_ls; ++i_loc) ldt_l[i_loc] = ldt_ll[i_loc];
  free(ldt_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldt, ldt_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, q, q_ll, 0);
  for (i_loc=0; i_loc<ldq_ls; ++i_loc) ldq_l[i_loc] = ldq_ll[i_loc];
  free(ldq_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldq, ldq_l, 0);
  for (i_loc=0; i_loc<j1_ls; ++i_loc) j1_l[i_loc] = j1_ll[i_loc];
  free(j1_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, j1, j1_l, 0);
  for (i_loc=0; i_loc<n1_ls; ++i_loc) n1_l[i_loc] = n1_ll[i_loc];
  free(n1_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n1, n1_l, 0);
  for (i_loc=0; i_loc<n2_ls; ++i_loc) n2_l[i_loc] = n2_ll[i_loc];
  free(n2_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n2, n2_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, work, work_ll, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_lag2
(JNIEnv *env, jclass clazz, jdoubleArray a, jintArray lda, jdoubleArray b, jintArray ldb, jdoubleArray safmin, jdoubleArray scale1, jdoubleArray scale2, jdoubleArray wr1, jdoubleArray wr2, jdoubleArray wi) {
  int i_loc;
  jdouble* a_ll;
  jint* lda_l;
  integer* lda_ll;
  jsize lda_ls;
  jdouble* b_ll;
  jint* ldb_l;
  integer* ldb_ll;
  jsize ldb_ls;
  jdouble* safmin_ll;
  jdouble* scale1_ll;
  jdouble* scale2_ll;
  jdouble* wr1_ll;
  jdouble* wr2_ll;
  jdouble* wi_ll;
  a_ll = (*env)->GetPrimitiveArrayCritical(env, a, NULL);
  lda_l = (*env)->GetPrimitiveArrayCritical(env, lda, NULL);
  lda_ls = (*env)->GetArrayLength(env, lda);
  lda_ll = malloc(sizeof(integer)*lda_ls);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_ll[i_loc] = lda_l[i_loc];
  b_ll = (*env)->GetPrimitiveArrayCritical(env, b, NULL);
  ldb_l = (*env)->GetPrimitiveArrayCritical(env, ldb, NULL);
  ldb_ls = (*env)->GetArrayLength(env, ldb);
  ldb_ll = malloc(sizeof(integer)*ldb_ls);
  for (i_loc=0; i_loc<ldb_ls; ++i_loc) ldb_ll[i_loc] = ldb_l[i_loc];
  safmin_ll = (*env)->GetPrimitiveArrayCritical(env, safmin, NULL);
  scale1_ll = (*env)->GetPrimitiveArrayCritical(env, scale1, NULL);
  scale2_ll = (*env)->GetPrimitiveArrayCritical(env, scale2, NULL);
  wr1_ll = (*env)->GetPrimitiveArrayCritical(env, wr1, NULL);
  wr2_ll = (*env)->GetPrimitiveArrayCritical(env, wr2, NULL);
  wi_ll = (*env)->GetPrimitiveArrayCritical(env, wi, NULL);

  dlag2_(a_ll, lda_ll, b_ll, ldb_ll, safmin_ll, scale1_ll, scale2_ll, wr1_ll, wr2_ll, wi_ll);

  (*env)->ReleasePrimitiveArrayCritical(env, a, a_ll, 0);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_l[i_loc] = lda_ll[i_loc];
  free(lda_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, lda, lda_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, b, b_ll, 0);
  for (i_loc=0; i_loc<ldb_ls; ++i_loc) ldb_l[i_loc] = ldb_ll[i_loc];
  free(ldb_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldb, ldb_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, safmin, safmin_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, scale1, scale1_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, scale2, scale2_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, wr1, wr1_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, wr2, wr2_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, wi, wi_ll, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_lags2
(JNIEnv *env, jclass clazz, jbooleanArray upper, jdoubleArray a1, jdoubleArray a2, jdoubleArray a3, jdoubleArray b1, jdoubleArray b2, jdoubleArray b3, jdoubleArray csu, jdoubleArray snu, jdoubleArray csv, jdoubleArray snv, jdoubleArray csq, jdoubleArray snq) {
  int i_loc;
  jboolean* upper_l;
  integer* upper_ll;
  jsize upper_ls;
  jdouble* a1_ll;
  jdouble* a2_ll;
  jdouble* a3_ll;
  jdouble* b1_ll;
  jdouble* b2_ll;
  jdouble* b3_ll;
  jdouble* csu_ll;
  jdouble* snu_ll;
  jdouble* csv_ll;
  jdouble* snv_ll;
  jdouble* csq_ll;
  jdouble* snq_ll;
  upper_l = (*env)->GetPrimitiveArrayCritical(env, upper, NULL);
  upper_ls = (*env)->GetArrayLength(env, upper);
  upper_ll = malloc(sizeof(integer)*upper_ls);
  for (i_loc=0; i_loc<upper_ls; ++i_loc) upper_ll[i_loc] = upper_l[i_loc];
  a1_ll = (*env)->GetPrimitiveArrayCritical(env, a1, NULL);
  a2_ll = (*env)->GetPrimitiveArrayCritical(env, a2, NULL);
  a3_ll = (*env)->GetPrimitiveArrayCritical(env, a3, NULL);
  b1_ll = (*env)->GetPrimitiveArrayCritical(env, b1, NULL);
  b2_ll = (*env)->GetPrimitiveArrayCritical(env, b2, NULL);
  b3_ll = (*env)->GetPrimitiveArrayCritical(env, b3, NULL);
  csu_ll = (*env)->GetPrimitiveArrayCritical(env, csu, NULL);
  snu_ll = (*env)->GetPrimitiveArrayCritical(env, snu, NULL);
  csv_ll = (*env)->GetPrimitiveArrayCritical(env, csv, NULL);
  snv_ll = (*env)->GetPrimitiveArrayCritical(env, snv, NULL);
  csq_ll = (*env)->GetPrimitiveArrayCritical(env, csq, NULL);
  snq_ll = (*env)->GetPrimitiveArrayCritical(env, snq, NULL);

  dlags2_(upper_ll, a1_ll, a2_ll, a3_ll, b1_ll, b2_ll, b3_ll, csu_ll, snu_ll, csv_ll, snv_ll, csq_ll, snq_ll);

  for (i_loc=0; i_loc<upper_ls; ++i_loc) upper_l[i_loc] = upper_ll[i_loc];
  free(upper_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, upper, upper_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, a1, a1_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, a2, a2_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, a3, a3_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, b1, b1_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, b2, b2_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, b3, b3_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, csu, csu_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, snu, snu_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, csv, csv_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, snv, snv_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, csq, csq_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, snq, snq_ll, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_lagtf
(JNIEnv *env, jclass clazz, jintArray n, jdoubleArray a, jdoubleArray lambda, jdoubleArray b, jdoubleArray c, jdoubleArray tol, jdoubleArray d, jintArray in, jintArray info) {
  int i_loc;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jdouble* a_ll;
  jdouble* lambda_ll;
  jdouble* b_ll;
  jdouble* c_ll;
  jdouble* tol_ll;
  jdouble* d_ll;
  jint* in_l;
  integer* in_ll;
  jsize in_ls;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  a_ll = (*env)->GetPrimitiveArrayCritical(env, a, NULL);
  lambda_ll = (*env)->GetPrimitiveArrayCritical(env, lambda, NULL);
  b_ll = (*env)->GetPrimitiveArrayCritical(env, b, NULL);
  c_ll = (*env)->GetPrimitiveArrayCritical(env, c, NULL);
  tol_ll = (*env)->GetPrimitiveArrayCritical(env, tol, NULL);
  d_ll = (*env)->GetPrimitiveArrayCritical(env, d, NULL);
  in_l = (*env)->GetPrimitiveArrayCritical(env, in, NULL);
  in_ls = (*env)->GetArrayLength(env, in);
  in_ll = malloc(sizeof(integer)*in_ls);
  for (i_loc=0; i_loc<in_ls; ++i_loc) in_ll[i_loc] = in_l[i_loc];
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dlagtf_(n_ll, a_ll, lambda_ll, b_ll, c_ll, tol_ll, d_ll, in_ll, info_ll);

  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, a, a_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, lambda, lambda_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, b, b_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, c, c_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, tol, tol_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, d, d_ll, 0);
  for (i_loc=0; i_loc<in_ls; ++i_loc) in_l[i_loc] = in_ll[i_loc];
  free(in_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, in, in_l, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_lagtm
(JNIEnv *env, jclass clazz, jcharArray trans, jintArray n, jintArray nrhs, jdoubleArray alpha, jdoubleArray dl, jdoubleArray d, jdoubleArray du, jdoubleArray x, jintArray ldx, jdoubleArray beta, jdoubleArray b, jintArray ldb) {
  int i_loc;
  jchar* trans_l;
  char* trans_ll;
  jsize trans_ls;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jint* nrhs_l;
  integer* nrhs_ll;
  jsize nrhs_ls;
  jdouble* alpha_ll;
  jdouble* dl_ll;
  jdouble* d_ll;
  jdouble* du_ll;
  jdouble* x_ll;
  jint* ldx_l;
  integer* ldx_ll;
  jsize ldx_ls;
  jdouble* beta_ll;
  jdouble* b_ll;
  jint* ldb_l;
  integer* ldb_ll;
  jsize ldb_ls;
  trans_l = (*env)->GetPrimitiveArrayCritical(env, trans, NULL);
  trans_ls = (*env)->GetArrayLength(env, trans);
  trans_ll = malloc(sizeof(char)*trans_ls);
  for (i_loc=0; i_loc<trans_ls; ++i_loc) trans_ll[i_loc] = trans_l[i_loc];
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  nrhs_l = (*env)->GetPrimitiveArrayCritical(env, nrhs, NULL);
  nrhs_ls = (*env)->GetArrayLength(env, nrhs);
  nrhs_ll = malloc(sizeof(integer)*nrhs_ls);
  for (i_loc=0; i_loc<nrhs_ls; ++i_loc) nrhs_ll[i_loc] = nrhs_l[i_loc];
  alpha_ll = (*env)->GetPrimitiveArrayCritical(env, alpha, NULL);
  dl_ll = (*env)->GetPrimitiveArrayCritical(env, dl, NULL);
  d_ll = (*env)->GetPrimitiveArrayCritical(env, d, NULL);
  du_ll = (*env)->GetPrimitiveArrayCritical(env, du, NULL);
  x_ll = (*env)->GetPrimitiveArrayCritical(env, x, NULL);
  ldx_l = (*env)->GetPrimitiveArrayCritical(env, ldx, NULL);
  ldx_ls = (*env)->GetArrayLength(env, ldx);
  ldx_ll = malloc(sizeof(integer)*ldx_ls);
  for (i_loc=0; i_loc<ldx_ls; ++i_loc) ldx_ll[i_loc] = ldx_l[i_loc];
  beta_ll = (*env)->GetPrimitiveArrayCritical(env, beta, NULL);
  b_ll = (*env)->GetPrimitiveArrayCritical(env, b, NULL);
  ldb_l = (*env)->GetPrimitiveArrayCritical(env, ldb, NULL);
  ldb_ls = (*env)->GetArrayLength(env, ldb);
  ldb_ll = malloc(sizeof(integer)*ldb_ls);
  for (i_loc=0; i_loc<ldb_ls; ++i_loc) ldb_ll[i_loc] = ldb_l[i_loc];

  dlagtm_(trans_ll, n_ll, nrhs_ll, alpha_ll, dl_ll, d_ll, du_ll, x_ll, ldx_ll, beta_ll, b_ll, ldb_ll);

  for (i_loc=0; i_loc<trans_ls; ++i_loc) trans_l[i_loc] = trans_ll[i_loc];
  free(trans_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, trans, trans_l, 0);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  for (i_loc=0; i_loc<nrhs_ls; ++i_loc) nrhs_l[i_loc] = nrhs_ll[i_loc];
  free(nrhs_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, nrhs, nrhs_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, alpha, alpha_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, dl, dl_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, d, d_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, du, du_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, x, x_ll, 0);
  for (i_loc=0; i_loc<ldx_ls; ++i_loc) ldx_l[i_loc] = ldx_ll[i_loc];
  free(ldx_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldx, ldx_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, beta, beta_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, b, b_ll, 0);
  for (i_loc=0; i_loc<ldb_ls; ++i_loc) ldb_l[i_loc] = ldb_ll[i_loc];
  free(ldb_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldb, ldb_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_lagts
(JNIEnv *env, jclass clazz, jintArray job, jintArray n, jdoubleArray a, jdoubleArray b, jdoubleArray c, jdoubleArray d, jintArray in, jdoubleArray y, jdoubleArray tol, jintArray info) {
  int i_loc;
  jint* job_l;
  integer* job_ll;
  jsize job_ls;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jdouble* a_ll;
  jdouble* b_ll;
  jdouble* c_ll;
  jdouble* d_ll;
  jint* in_l;
  integer* in_ll;
  jsize in_ls;
  jdouble* y_ll;
  jdouble* tol_ll;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  job_l = (*env)->GetPrimitiveArrayCritical(env, job, NULL);
  job_ls = (*env)->GetArrayLength(env, job);
  job_ll = malloc(sizeof(integer)*job_ls);
  for (i_loc=0; i_loc<job_ls; ++i_loc) job_ll[i_loc] = job_l[i_loc];
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  a_ll = (*env)->GetPrimitiveArrayCritical(env, a, NULL);
  b_ll = (*env)->GetPrimitiveArrayCritical(env, b, NULL);
  c_ll = (*env)->GetPrimitiveArrayCritical(env, c, NULL);
  d_ll = (*env)->GetPrimitiveArrayCritical(env, d, NULL);
  in_l = (*env)->GetPrimitiveArrayCritical(env, in, NULL);
  in_ls = (*env)->GetArrayLength(env, in);
  in_ll = malloc(sizeof(integer)*in_ls);
  for (i_loc=0; i_loc<in_ls; ++i_loc) in_ll[i_loc] = in_l[i_loc];
  y_ll = (*env)->GetPrimitiveArrayCritical(env, y, NULL);
  tol_ll = (*env)->GetPrimitiveArrayCritical(env, tol, NULL);
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dlagts_(job_ll, n_ll, a_ll, b_ll, c_ll, d_ll, in_ll, y_ll, tol_ll, info_ll);

  for (i_loc=0; i_loc<job_ls; ++i_loc) job_l[i_loc] = job_ll[i_loc];
  free(job_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, job, job_l, 0);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, a, a_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, b, b_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, c, c_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, d, d_ll, 0);
  for (i_loc=0; i_loc<in_ls; ++i_loc) in_l[i_loc] = in_ll[i_loc];
  free(in_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, in, in_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, y, y_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, tol, tol_ll, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_lagv2
(JNIEnv *env, jclass clazz, jdoubleArray a, jintArray lda, jdoubleArray b, jintArray ldb, jdoubleArray alphar, jdoubleArray alphai, jdoubleArray beta, jdoubleArray csl, jdoubleArray snl, jdoubleArray csr, jdoubleArray snr) {
  int i_loc;
  jdouble* a_ll;
  jint* lda_l;
  integer* lda_ll;
  jsize lda_ls;
  jdouble* b_ll;
  jint* ldb_l;
  integer* ldb_ll;
  jsize ldb_ls;
  jdouble* alphar_ll;
  jdouble* alphai_ll;
  jdouble* beta_ll;
  jdouble* csl_ll;
  jdouble* snl_ll;
  jdouble* csr_ll;
  jdouble* snr_ll;
  a_ll = (*env)->GetPrimitiveArrayCritical(env, a, NULL);
  lda_l = (*env)->GetPrimitiveArrayCritical(env, lda, NULL);
  lda_ls = (*env)->GetArrayLength(env, lda);
  lda_ll = malloc(sizeof(integer)*lda_ls);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_ll[i_loc] = lda_l[i_loc];
  b_ll = (*env)->GetPrimitiveArrayCritical(env, b, NULL);
  ldb_l = (*env)->GetPrimitiveArrayCritical(env, ldb, NULL);
  ldb_ls = (*env)->GetArrayLength(env, ldb);
  ldb_ll = malloc(sizeof(integer)*ldb_ls);
  for (i_loc=0; i_loc<ldb_ls; ++i_loc) ldb_ll[i_loc] = ldb_l[i_loc];
  alphar_ll = (*env)->GetPrimitiveArrayCritical(env, alphar, NULL);
  alphai_ll = (*env)->GetPrimitiveArrayCritical(env, alphai, NULL);
  beta_ll = (*env)->GetPrimitiveArrayCritical(env, beta, NULL);
  csl_ll = (*env)->GetPrimitiveArrayCritical(env, csl, NULL);
  snl_ll = (*env)->GetPrimitiveArrayCritical(env, snl, NULL);
  csr_ll = (*env)->GetPrimitiveArrayCritical(env, csr, NULL);
  snr_ll = (*env)->GetPrimitiveArrayCritical(env, snr, NULL);

  dlagv2_(a_ll, lda_ll, b_ll, ldb_ll, alphar_ll, alphai_ll, beta_ll, csl_ll, snl_ll, csr_ll, snr_ll);

  (*env)->ReleasePrimitiveArrayCritical(env, a, a_ll, 0);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_l[i_loc] = lda_ll[i_loc];
  free(lda_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, lda, lda_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, b, b_ll, 0);
  for (i_loc=0; i_loc<ldb_ls; ++i_loc) ldb_l[i_loc] = ldb_ll[i_loc];
  free(ldb_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldb, ldb_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, alphar, alphar_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, alphai, alphai_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, beta, beta_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, csl, csl_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, snl, snl_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, csr, csr_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, snr, snr_ll, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_lahqr
(JNIEnv *env, jclass clazz, jbooleanArray wantt, jbooleanArray wantz, jintArray n, jintArray ilo, jintArray ihi, jdoubleArray h, jintArray ldh, jdoubleArray wr, jdoubleArray wi, jintArray iloz, jintArray ihiz, jdoubleArray z, jintArray ldz, jintArray info) {
  int i_loc;
  jboolean* wantt_l;
  integer* wantt_ll;
  jsize wantt_ls;
  jboolean* wantz_l;
  integer* wantz_ll;
  jsize wantz_ls;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jint* ilo_l;
  integer* ilo_ll;
  jsize ilo_ls;
  jint* ihi_l;
  integer* ihi_ll;
  jsize ihi_ls;
  jdouble* h_ll;
  jint* ldh_l;
  integer* ldh_ll;
  jsize ldh_ls;
  jdouble* wr_ll;
  jdouble* wi_ll;
  jint* iloz_l;
  integer* iloz_ll;
  jsize iloz_ls;
  jint* ihiz_l;
  integer* ihiz_ll;
  jsize ihiz_ls;
  jdouble* z_ll;
  jint* ldz_l;
  integer* ldz_ll;
  jsize ldz_ls;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  wantt_l = (*env)->GetPrimitiveArrayCritical(env, wantt, NULL);
  wantt_ls = (*env)->GetArrayLength(env, wantt);
  wantt_ll = malloc(sizeof(integer)*wantt_ls);
  for (i_loc=0; i_loc<wantt_ls; ++i_loc) wantt_ll[i_loc] = wantt_l[i_loc];
  wantz_l = (*env)->GetPrimitiveArrayCritical(env, wantz, NULL);
  wantz_ls = (*env)->GetArrayLength(env, wantz);
  wantz_ll = malloc(sizeof(integer)*wantz_ls);
  for (i_loc=0; i_loc<wantz_ls; ++i_loc) wantz_ll[i_loc] = wantz_l[i_loc];
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  ilo_l = (*env)->GetPrimitiveArrayCritical(env, ilo, NULL);
  ilo_ls = (*env)->GetArrayLength(env, ilo);
  ilo_ll = malloc(sizeof(integer)*ilo_ls);
  for (i_loc=0; i_loc<ilo_ls; ++i_loc) ilo_ll[i_loc] = ilo_l[i_loc];
  ihi_l = (*env)->GetPrimitiveArrayCritical(env, ihi, NULL);
  ihi_ls = (*env)->GetArrayLength(env, ihi);
  ihi_ll = malloc(sizeof(integer)*ihi_ls);
  for (i_loc=0; i_loc<ihi_ls; ++i_loc) ihi_ll[i_loc] = ihi_l[i_loc];
  h_ll = (*env)->GetPrimitiveArrayCritical(env, h, NULL);
  ldh_l = (*env)->GetPrimitiveArrayCritical(env, ldh, NULL);
  ldh_ls = (*env)->GetArrayLength(env, ldh);
  ldh_ll = malloc(sizeof(integer)*ldh_ls);
  for (i_loc=0; i_loc<ldh_ls; ++i_loc) ldh_ll[i_loc] = ldh_l[i_loc];
  wr_ll = (*env)->GetPrimitiveArrayCritical(env, wr, NULL);
  wi_ll = (*env)->GetPrimitiveArrayCritical(env, wi, NULL);
  iloz_l = (*env)->GetPrimitiveArrayCritical(env, iloz, NULL);
  iloz_ls = (*env)->GetArrayLength(env, iloz);
  iloz_ll = malloc(sizeof(integer)*iloz_ls);
  for (i_loc=0; i_loc<iloz_ls; ++i_loc) iloz_ll[i_loc] = iloz_l[i_loc];
  ihiz_l = (*env)->GetPrimitiveArrayCritical(env, ihiz, NULL);
  ihiz_ls = (*env)->GetArrayLength(env, ihiz);
  ihiz_ll = malloc(sizeof(integer)*ihiz_ls);
  for (i_loc=0; i_loc<ihiz_ls; ++i_loc) ihiz_ll[i_loc] = ihiz_l[i_loc];
  z_ll = (*env)->GetPrimitiveArrayCritical(env, z, NULL);
  ldz_l = (*env)->GetPrimitiveArrayCritical(env, ldz, NULL);
  ldz_ls = (*env)->GetArrayLength(env, ldz);
  ldz_ll = malloc(sizeof(integer)*ldz_ls);
  for (i_loc=0; i_loc<ldz_ls; ++i_loc) ldz_ll[i_loc] = ldz_l[i_loc];
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dlahqr_(wantt_ll, wantz_ll, n_ll, ilo_ll, ihi_ll, h_ll, ldh_ll, wr_ll, wi_ll, iloz_ll, ihiz_ll, z_ll, ldz_ll, info_ll);

  for (i_loc=0; i_loc<wantt_ls; ++i_loc) wantt_l[i_loc] = wantt_ll[i_loc];
  free(wantt_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, wantt, wantt_l, 0);
  for (i_loc=0; i_loc<wantz_ls; ++i_loc) wantz_l[i_loc] = wantz_ll[i_loc];
  free(wantz_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, wantz, wantz_l, 0);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  for (i_loc=0; i_loc<ilo_ls; ++i_loc) ilo_l[i_loc] = ilo_ll[i_loc];
  free(ilo_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ilo, ilo_l, 0);
  for (i_loc=0; i_loc<ihi_ls; ++i_loc) ihi_l[i_loc] = ihi_ll[i_loc];
  free(ihi_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ihi, ihi_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, h, h_ll, 0);
  for (i_loc=0; i_loc<ldh_ls; ++i_loc) ldh_l[i_loc] = ldh_ll[i_loc];
  free(ldh_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldh, ldh_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, wr, wr_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, wi, wi_ll, 0);
  for (i_loc=0; i_loc<iloz_ls; ++i_loc) iloz_l[i_loc] = iloz_ll[i_loc];
  free(iloz_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, iloz, iloz_l, 0);
  for (i_loc=0; i_loc<ihiz_ls; ++i_loc) ihiz_l[i_loc] = ihiz_ll[i_loc];
  free(ihiz_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ihiz, ihiz_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, z, z_ll, 0);
  for (i_loc=0; i_loc<ldz_ls; ++i_loc) ldz_l[i_loc] = ldz_ll[i_loc];
  free(ldz_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldz, ldz_l, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_lahrd
(JNIEnv *env, jclass clazz, jintArray n, jintArray k, jintArray nb, jdoubleArray a, jintArray lda, jdoubleArray tau, jdoubleArray t, jintArray ldt, jdoubleArray y, jintArray ldy) {
  int i_loc;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jint* k_l;
  integer* k_ll;
  jsize k_ls;
  jint* nb_l;
  integer* nb_ll;
  jsize nb_ls;
  jdouble* a_ll;
  jint* lda_l;
  integer* lda_ll;
  jsize lda_ls;
  jdouble* tau_ll;
  jdouble* t_ll;
  jint* ldt_l;
  integer* ldt_ll;
  jsize ldt_ls;
  jdouble* y_ll;
  jint* ldy_l;
  integer* ldy_ll;
  jsize ldy_ls;
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  k_l = (*env)->GetPrimitiveArrayCritical(env, k, NULL);
  k_ls = (*env)->GetArrayLength(env, k);
  k_ll = malloc(sizeof(integer)*k_ls);
  for (i_loc=0; i_loc<k_ls; ++i_loc) k_ll[i_loc] = k_l[i_loc];
  nb_l = (*env)->GetPrimitiveArrayCritical(env, nb, NULL);
  nb_ls = (*env)->GetArrayLength(env, nb);
  nb_ll = malloc(sizeof(integer)*nb_ls);
  for (i_loc=0; i_loc<nb_ls; ++i_loc) nb_ll[i_loc] = nb_l[i_loc];
  a_ll = (*env)->GetPrimitiveArrayCritical(env, a, NULL);
  lda_l = (*env)->GetPrimitiveArrayCritical(env, lda, NULL);
  lda_ls = (*env)->GetArrayLength(env, lda);
  lda_ll = malloc(sizeof(integer)*lda_ls);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_ll[i_loc] = lda_l[i_loc];
  tau_ll = (*env)->GetPrimitiveArrayCritical(env, tau, NULL);
  t_ll = (*env)->GetPrimitiveArrayCritical(env, t, NULL);
  ldt_l = (*env)->GetPrimitiveArrayCritical(env, ldt, NULL);
  ldt_ls = (*env)->GetArrayLength(env, ldt);
  ldt_ll = malloc(sizeof(integer)*ldt_ls);
  for (i_loc=0; i_loc<ldt_ls; ++i_loc) ldt_ll[i_loc] = ldt_l[i_loc];
  y_ll = (*env)->GetPrimitiveArrayCritical(env, y, NULL);
  ldy_l = (*env)->GetPrimitiveArrayCritical(env, ldy, NULL);
  ldy_ls = (*env)->GetArrayLength(env, ldy);
  ldy_ll = malloc(sizeof(integer)*ldy_ls);
  for (i_loc=0; i_loc<ldy_ls; ++i_loc) ldy_ll[i_loc] = ldy_l[i_loc];

  dlahrd_(n_ll, k_ll, nb_ll, a_ll, lda_ll, tau_ll, t_ll, ldt_ll, y_ll, ldy_ll);

  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  for (i_loc=0; i_loc<k_ls; ++i_loc) k_l[i_loc] = k_ll[i_loc];
  free(k_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, k, k_l, 0);
  for (i_loc=0; i_loc<nb_ls; ++i_loc) nb_l[i_loc] = nb_ll[i_loc];
  free(nb_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, nb, nb_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, a, a_ll, 0);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_l[i_loc] = lda_ll[i_loc];
  free(lda_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, lda, lda_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, tau, tau_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, t, t_ll, 0);
  for (i_loc=0; i_loc<ldt_ls; ++i_loc) ldt_l[i_loc] = ldt_ll[i_loc];
  free(ldt_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldt, ldt_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, y, y_ll, 0);
  for (i_loc=0; i_loc<ldy_ls; ++i_loc) ldy_l[i_loc] = ldy_ll[i_loc];
  free(ldy_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldy, ldy_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_laic1
(JNIEnv *env, jclass clazz, jintArray job, jintArray j, jdoubleArray x, jdoubleArray sest, jdoubleArray w, jdoubleArray gamma, jdoubleArray sestpr, jdoubleArray s, jdoubleArray c) {
  int i_loc;
  jint* job_l;
  integer* job_ll;
  jsize job_ls;
  jint* j_l;
  integer* j_ll;
  jsize j_ls;
  jdouble* x_ll;
  jdouble* sest_ll;
  jdouble* w_ll;
  jdouble* gamma_ll;
  jdouble* sestpr_ll;
  jdouble* s_ll;
  jdouble* c_ll;
  job_l = (*env)->GetPrimitiveArrayCritical(env, job, NULL);
  job_ls = (*env)->GetArrayLength(env, job);
  job_ll = malloc(sizeof(integer)*job_ls);
  for (i_loc=0; i_loc<job_ls; ++i_loc) job_ll[i_loc] = job_l[i_loc];
  j_l = (*env)->GetPrimitiveArrayCritical(env, j, NULL);
  j_ls = (*env)->GetArrayLength(env, j);
  j_ll = malloc(sizeof(integer)*j_ls);
  for (i_loc=0; i_loc<j_ls; ++i_loc) j_ll[i_loc] = j_l[i_loc];
  x_ll = (*env)->GetPrimitiveArrayCritical(env, x, NULL);
  sest_ll = (*env)->GetPrimitiveArrayCritical(env, sest, NULL);
  w_ll = (*env)->GetPrimitiveArrayCritical(env, w, NULL);
  gamma_ll = (*env)->GetPrimitiveArrayCritical(env, gamma, NULL);
  sestpr_ll = (*env)->GetPrimitiveArrayCritical(env, sestpr, NULL);
  s_ll = (*env)->GetPrimitiveArrayCritical(env, s, NULL);
  c_ll = (*env)->GetPrimitiveArrayCritical(env, c, NULL);

  dlaic1_(job_ll, j_ll, x_ll, sest_ll, w_ll, gamma_ll, sestpr_ll, s_ll, c_ll);

  for (i_loc=0; i_loc<job_ls; ++i_loc) job_l[i_loc] = job_ll[i_loc];
  free(job_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, job, job_l, 0);
  for (i_loc=0; i_loc<j_ls; ++i_loc) j_l[i_loc] = j_ll[i_loc];
  free(j_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, j, j_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, x, x_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, sest, sest_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, w, w_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, gamma, gamma_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, sestpr, sestpr_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, s, s_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, c, c_ll, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_laln2
(JNIEnv *env, jclass clazz, jbooleanArray ltrans, jintArray na, jintArray nw, jdoubleArray smin, jdoubleArray ca, jdoubleArray a, jintArray lda, jdoubleArray d1, jdoubleArray d2, jdoubleArray b, jintArray ldb, jdoubleArray wr, jdoubleArray wi, jdoubleArray x, jintArray ldx, jdoubleArray scale, jdoubleArray xnorm, jintArray info) {
  int i_loc;
  jboolean* ltrans_l;
  integer* ltrans_ll;
  jsize ltrans_ls;
  jint* na_l;
  integer* na_ll;
  jsize na_ls;
  jint* nw_l;
  integer* nw_ll;
  jsize nw_ls;
  jdouble* smin_ll;
  jdouble* ca_ll;
  jdouble* a_ll;
  jint* lda_l;
  integer* lda_ll;
  jsize lda_ls;
  jdouble* d1_ll;
  jdouble* d2_ll;
  jdouble* b_ll;
  jint* ldb_l;
  integer* ldb_ll;
  jsize ldb_ls;
  jdouble* wr_ll;
  jdouble* wi_ll;
  jdouble* x_ll;
  jint* ldx_l;
  integer* ldx_ll;
  jsize ldx_ls;
  jdouble* scale_ll;
  jdouble* xnorm_ll;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  ltrans_l = (*env)->GetPrimitiveArrayCritical(env, ltrans, NULL);
  ltrans_ls = (*env)->GetArrayLength(env, ltrans);
  ltrans_ll = malloc(sizeof(integer)*ltrans_ls);
  for (i_loc=0; i_loc<ltrans_ls; ++i_loc) ltrans_ll[i_loc] = ltrans_l[i_loc];
  na_l = (*env)->GetPrimitiveArrayCritical(env, na, NULL);
  na_ls = (*env)->GetArrayLength(env, na);
  na_ll = malloc(sizeof(integer)*na_ls);
  for (i_loc=0; i_loc<na_ls; ++i_loc) na_ll[i_loc] = na_l[i_loc];
  nw_l = (*env)->GetPrimitiveArrayCritical(env, nw, NULL);
  nw_ls = (*env)->GetArrayLength(env, nw);
  nw_ll = malloc(sizeof(integer)*nw_ls);
  for (i_loc=0; i_loc<nw_ls; ++i_loc) nw_ll[i_loc] = nw_l[i_loc];
  smin_ll = (*env)->GetPrimitiveArrayCritical(env, smin, NULL);
  ca_ll = (*env)->GetPrimitiveArrayCritical(env, ca, NULL);
  a_ll = (*env)->GetPrimitiveArrayCritical(env, a, NULL);
  lda_l = (*env)->GetPrimitiveArrayCritical(env, lda, NULL);
  lda_ls = (*env)->GetArrayLength(env, lda);
  lda_ll = malloc(sizeof(integer)*lda_ls);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_ll[i_loc] = lda_l[i_loc];
  d1_ll = (*env)->GetPrimitiveArrayCritical(env, d1, NULL);
  d2_ll = (*env)->GetPrimitiveArrayCritical(env, d2, NULL);
  b_ll = (*env)->GetPrimitiveArrayCritical(env, b, NULL);
  ldb_l = (*env)->GetPrimitiveArrayCritical(env, ldb, NULL);
  ldb_ls = (*env)->GetArrayLength(env, ldb);
  ldb_ll = malloc(sizeof(integer)*ldb_ls);
  for (i_loc=0; i_loc<ldb_ls; ++i_loc) ldb_ll[i_loc] = ldb_l[i_loc];
  wr_ll = (*env)->GetPrimitiveArrayCritical(env, wr, NULL);
  wi_ll = (*env)->GetPrimitiveArrayCritical(env, wi, NULL);
  x_ll = (*env)->GetPrimitiveArrayCritical(env, x, NULL);
  ldx_l = (*env)->GetPrimitiveArrayCritical(env, ldx, NULL);
  ldx_ls = (*env)->GetArrayLength(env, ldx);
  ldx_ll = malloc(sizeof(integer)*ldx_ls);
  for (i_loc=0; i_loc<ldx_ls; ++i_loc) ldx_ll[i_loc] = ldx_l[i_loc];
  scale_ll = (*env)->GetPrimitiveArrayCritical(env, scale, NULL);
  xnorm_ll = (*env)->GetPrimitiveArrayCritical(env, xnorm, NULL);
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dlaln2_(ltrans_ll, na_ll, nw_ll, smin_ll, ca_ll, a_ll, lda_ll, d1_ll, d2_ll, b_ll, ldb_ll, wr_ll, wi_ll, x_ll, ldx_ll, scale_ll, xnorm_ll, info_ll);

  for (i_loc=0; i_loc<ltrans_ls; ++i_loc) ltrans_l[i_loc] = ltrans_ll[i_loc];
  free(ltrans_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ltrans, ltrans_l, 0);
  for (i_loc=0; i_loc<na_ls; ++i_loc) na_l[i_loc] = na_ll[i_loc];
  free(na_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, na, na_l, 0);
  for (i_loc=0; i_loc<nw_ls; ++i_loc) nw_l[i_loc] = nw_ll[i_loc];
  free(nw_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, nw, nw_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, smin, smin_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, ca, ca_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, a, a_ll, 0);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_l[i_loc] = lda_ll[i_loc];
  free(lda_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, lda, lda_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, d1, d1_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, d2, d2_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, b, b_ll, 0);
  for (i_loc=0; i_loc<ldb_ls; ++i_loc) ldb_l[i_loc] = ldb_ll[i_loc];
  free(ldb_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldb, ldb_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, wr, wr_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, wi, wi_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, x, x_ll, 0);
  for (i_loc=0; i_loc<ldx_ls; ++i_loc) ldx_l[i_loc] = ldx_ll[i_loc];
  free(ldx_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldx, ldx_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, scale, scale_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, xnorm, xnorm_ll, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_lals0
(JNIEnv *env, jclass clazz, jintArray icompq, jintArray nl, jintArray nr, jintArray sqre, jintArray nrhs, jdoubleArray b, jintArray ldb, jdoubleArray bx, jintArray ldbx, jintArray perm, jintArray givptr, jintArray givcol, jintArray ldgcol, jdoubleArray givnum, jintArray ldgnum, jdoubleArray poles, jdoubleArray difl, jdoubleArray difr, jdoubleArray z, jintArray k, jdoubleArray c, jdoubleArray s, jdoubleArray work, jintArray info) {
  int i_loc;
  jint* icompq_l;
  integer* icompq_ll;
  jsize icompq_ls;
  jint* nl_l;
  integer* nl_ll;
  jsize nl_ls;
  jint* nr_l;
  integer* nr_ll;
  jsize nr_ls;
  jint* sqre_l;
  integer* sqre_ll;
  jsize sqre_ls;
  jint* nrhs_l;
  integer* nrhs_ll;
  jsize nrhs_ls;
  jdouble* b_ll;
  jint* ldb_l;
  integer* ldb_ll;
  jsize ldb_ls;
  jdouble* bx_ll;
  jint* ldbx_l;
  integer* ldbx_ll;
  jsize ldbx_ls;
  jint* perm_l;
  integer* perm_ll;
  jsize perm_ls;
  jint* givptr_l;
  integer* givptr_ll;
  jsize givptr_ls;
  jint* givcol_l;
  integer* givcol_ll;
  jsize givcol_ls;
  jint* ldgcol_l;
  integer* ldgcol_ll;
  jsize ldgcol_ls;
  jdouble* givnum_ll;
  jint* ldgnum_l;
  integer* ldgnum_ll;
  jsize ldgnum_ls;
  jdouble* poles_ll;
  jdouble* difl_ll;
  jdouble* difr_ll;
  jdouble* z_ll;
  jint* k_l;
  integer* k_ll;
  jsize k_ls;
  jdouble* c_ll;
  jdouble* s_ll;
  jdouble* work_ll;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  icompq_l = (*env)->GetPrimitiveArrayCritical(env, icompq, NULL);
  icompq_ls = (*env)->GetArrayLength(env, icompq);
  icompq_ll = malloc(sizeof(integer)*icompq_ls);
  for (i_loc=0; i_loc<icompq_ls; ++i_loc) icompq_ll[i_loc] = icompq_l[i_loc];
  nl_l = (*env)->GetPrimitiveArrayCritical(env, nl, NULL);
  nl_ls = (*env)->GetArrayLength(env, nl);
  nl_ll = malloc(sizeof(integer)*nl_ls);
  for (i_loc=0; i_loc<nl_ls; ++i_loc) nl_ll[i_loc] = nl_l[i_loc];
  nr_l = (*env)->GetPrimitiveArrayCritical(env, nr, NULL);
  nr_ls = (*env)->GetArrayLength(env, nr);
  nr_ll = malloc(sizeof(integer)*nr_ls);
  for (i_loc=0; i_loc<nr_ls; ++i_loc) nr_ll[i_loc] = nr_l[i_loc];
  sqre_l = (*env)->GetPrimitiveArrayCritical(env, sqre, NULL);
  sqre_ls = (*env)->GetArrayLength(env, sqre);
  sqre_ll = malloc(sizeof(integer)*sqre_ls);
  for (i_loc=0; i_loc<sqre_ls; ++i_loc) sqre_ll[i_loc] = sqre_l[i_loc];
  nrhs_l = (*env)->GetPrimitiveArrayCritical(env, nrhs, NULL);
  nrhs_ls = (*env)->GetArrayLength(env, nrhs);
  nrhs_ll = malloc(sizeof(integer)*nrhs_ls);
  for (i_loc=0; i_loc<nrhs_ls; ++i_loc) nrhs_ll[i_loc] = nrhs_l[i_loc];
  b_ll = (*env)->GetPrimitiveArrayCritical(env, b, NULL);
  ldb_l = (*env)->GetPrimitiveArrayCritical(env, ldb, NULL);
  ldb_ls = (*env)->GetArrayLength(env, ldb);
  ldb_ll = malloc(sizeof(integer)*ldb_ls);
  for (i_loc=0; i_loc<ldb_ls; ++i_loc) ldb_ll[i_loc] = ldb_l[i_loc];
  bx_ll = (*env)->GetPrimitiveArrayCritical(env, bx, NULL);
  ldbx_l = (*env)->GetPrimitiveArrayCritical(env, ldbx, NULL);
  ldbx_ls = (*env)->GetArrayLength(env, ldbx);
  ldbx_ll = malloc(sizeof(integer)*ldbx_ls);
  for (i_loc=0; i_loc<ldbx_ls; ++i_loc) ldbx_ll[i_loc] = ldbx_l[i_loc];
  perm_l = (*env)->GetPrimitiveArrayCritical(env, perm, NULL);
  perm_ls = (*env)->GetArrayLength(env, perm);
  perm_ll = malloc(sizeof(integer)*perm_ls);
  for (i_loc=0; i_loc<perm_ls; ++i_loc) perm_ll[i_loc] = perm_l[i_loc];
  givptr_l = (*env)->GetPrimitiveArrayCritical(env, givptr, NULL);
  givptr_ls = (*env)->GetArrayLength(env, givptr);
  givptr_ll = malloc(sizeof(integer)*givptr_ls);
  for (i_loc=0; i_loc<givptr_ls; ++i_loc) givptr_ll[i_loc] = givptr_l[i_loc];
  givcol_l = (*env)->GetPrimitiveArrayCritical(env, givcol, NULL);
  givcol_ls = (*env)->GetArrayLength(env, givcol);
  givcol_ll = malloc(sizeof(integer)*givcol_ls);
  for (i_loc=0; i_loc<givcol_ls; ++i_loc) givcol_ll[i_loc] = givcol_l[i_loc];
  ldgcol_l = (*env)->GetPrimitiveArrayCritical(env, ldgcol, NULL);
  ldgcol_ls = (*env)->GetArrayLength(env, ldgcol);
  ldgcol_ll = malloc(sizeof(integer)*ldgcol_ls);
  for (i_loc=0; i_loc<ldgcol_ls; ++i_loc) ldgcol_ll[i_loc] = ldgcol_l[i_loc];
  givnum_ll = (*env)->GetPrimitiveArrayCritical(env, givnum, NULL);
  ldgnum_l = (*env)->GetPrimitiveArrayCritical(env, ldgnum, NULL);
  ldgnum_ls = (*env)->GetArrayLength(env, ldgnum);
  ldgnum_ll = malloc(sizeof(integer)*ldgnum_ls);
  for (i_loc=0; i_loc<ldgnum_ls; ++i_loc) ldgnum_ll[i_loc] = ldgnum_l[i_loc];
  poles_ll = (*env)->GetPrimitiveArrayCritical(env, poles, NULL);
  difl_ll = (*env)->GetPrimitiveArrayCritical(env, difl, NULL);
  difr_ll = (*env)->GetPrimitiveArrayCritical(env, difr, NULL);
  z_ll = (*env)->GetPrimitiveArrayCritical(env, z, NULL);
  k_l = (*env)->GetPrimitiveArrayCritical(env, k, NULL);
  k_ls = (*env)->GetArrayLength(env, k);
  k_ll = malloc(sizeof(integer)*k_ls);
  for (i_loc=0; i_loc<k_ls; ++i_loc) k_ll[i_loc] = k_l[i_loc];
  c_ll = (*env)->GetPrimitiveArrayCritical(env, c, NULL);
  s_ll = (*env)->GetPrimitiveArrayCritical(env, s, NULL);
  work_ll = (*env)->GetPrimitiveArrayCritical(env, work, NULL);
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dlals0_(icompq_ll, nl_ll, nr_ll, sqre_ll, nrhs_ll, b_ll, ldb_ll, bx_ll, ldbx_ll, perm_ll, givptr_ll, givcol_ll, ldgcol_ll, givnum_ll, ldgnum_ll, poles_ll, difl_ll, difr_ll, z_ll, k_ll, c_ll, s_ll, work_ll, info_ll);

  for (i_loc=0; i_loc<icompq_ls; ++i_loc) icompq_l[i_loc] = icompq_ll[i_loc];
  free(icompq_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, icompq, icompq_l, 0);
  for (i_loc=0; i_loc<nl_ls; ++i_loc) nl_l[i_loc] = nl_ll[i_loc];
  free(nl_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, nl, nl_l, 0);
  for (i_loc=0; i_loc<nr_ls; ++i_loc) nr_l[i_loc] = nr_ll[i_loc];
  free(nr_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, nr, nr_l, 0);
  for (i_loc=0; i_loc<sqre_ls; ++i_loc) sqre_l[i_loc] = sqre_ll[i_loc];
  free(sqre_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, sqre, sqre_l, 0);
  for (i_loc=0; i_loc<nrhs_ls; ++i_loc) nrhs_l[i_loc] = nrhs_ll[i_loc];
  free(nrhs_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, nrhs, nrhs_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, b, b_ll, 0);
  for (i_loc=0; i_loc<ldb_ls; ++i_loc) ldb_l[i_loc] = ldb_ll[i_loc];
  free(ldb_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldb, ldb_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, bx, bx_ll, 0);
  for (i_loc=0; i_loc<ldbx_ls; ++i_loc) ldbx_l[i_loc] = ldbx_ll[i_loc];
  free(ldbx_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldbx, ldbx_l, 0);
  for (i_loc=0; i_loc<perm_ls; ++i_loc) perm_l[i_loc] = perm_ll[i_loc];
  free(perm_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, perm, perm_l, 0);
  for (i_loc=0; i_loc<givptr_ls; ++i_loc) givptr_l[i_loc] = givptr_ll[i_loc];
  free(givptr_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, givptr, givptr_l, 0);
  for (i_loc=0; i_loc<givcol_ls; ++i_loc) givcol_l[i_loc] = givcol_ll[i_loc];
  free(givcol_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, givcol, givcol_l, 0);
  for (i_loc=0; i_loc<ldgcol_ls; ++i_loc) ldgcol_l[i_loc] = ldgcol_ll[i_loc];
  free(ldgcol_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldgcol, ldgcol_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, givnum, givnum_ll, 0);
  for (i_loc=0; i_loc<ldgnum_ls; ++i_loc) ldgnum_l[i_loc] = ldgnum_ll[i_loc];
  free(ldgnum_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldgnum, ldgnum_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, poles, poles_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, difl, difl_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, difr, difr_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, z, z_ll, 0);
  for (i_loc=0; i_loc<k_ls; ++i_loc) k_l[i_loc] = k_ll[i_loc];
  free(k_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, k, k_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, c, c_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, s, s_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, work, work_ll, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_lalsa
(JNIEnv *env, jclass clazz, jintArray icompq, jintArray smlsiz, jintArray n, jintArray nrhs, jdoubleArray b, jintArray ldb, jdoubleArray bx, jintArray ldbx, jdoubleArray u, jintArray ldu, jdoubleArray vt, jintArray k, jdoubleArray difl, jdoubleArray difr, jdoubleArray z, jdoubleArray poles, jintArray givptr, jintArray givcol, jintArray ldgcol, jintArray perm, jdoubleArray givnum, jdoubleArray c, jdoubleArray s, jdoubleArray work, jintArray iwork, jintArray info) {
  int i_loc;
  jint* icompq_l;
  integer* icompq_ll;
  jsize icompq_ls;
  jint* smlsiz_l;
  integer* smlsiz_ll;
  jsize smlsiz_ls;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jint* nrhs_l;
  integer* nrhs_ll;
  jsize nrhs_ls;
  jdouble* b_ll;
  jint* ldb_l;
  integer* ldb_ll;
  jsize ldb_ls;
  jdouble* bx_ll;
  jint* ldbx_l;
  integer* ldbx_ll;
  jsize ldbx_ls;
  jdouble* u_ll;
  jint* ldu_l;
  integer* ldu_ll;
  jsize ldu_ls;
  jdouble* vt_ll;
  jint* k_l;
  integer* k_ll;
  jsize k_ls;
  jdouble* difl_ll;
  jdouble* difr_ll;
  jdouble* z_ll;
  jdouble* poles_ll;
  jint* givptr_l;
  integer* givptr_ll;
  jsize givptr_ls;
  jint* givcol_l;
  integer* givcol_ll;
  jsize givcol_ls;
  jint* ldgcol_l;
  integer* ldgcol_ll;
  jsize ldgcol_ls;
  jint* perm_l;
  integer* perm_ll;
  jsize perm_ls;
  jdouble* givnum_ll;
  jdouble* c_ll;
  jdouble* s_ll;
  jdouble* work_ll;
  jint* iwork_l;
  integer* iwork_ll;
  jsize iwork_ls;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  icompq_l = (*env)->GetPrimitiveArrayCritical(env, icompq, NULL);
  icompq_ls = (*env)->GetArrayLength(env, icompq);
  icompq_ll = malloc(sizeof(integer)*icompq_ls);
  for (i_loc=0; i_loc<icompq_ls; ++i_loc) icompq_ll[i_loc] = icompq_l[i_loc];
  smlsiz_l = (*env)->GetPrimitiveArrayCritical(env, smlsiz, NULL);
  smlsiz_ls = (*env)->GetArrayLength(env, smlsiz);
  smlsiz_ll = malloc(sizeof(integer)*smlsiz_ls);
  for (i_loc=0; i_loc<smlsiz_ls; ++i_loc) smlsiz_ll[i_loc] = smlsiz_l[i_loc];
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  nrhs_l = (*env)->GetPrimitiveArrayCritical(env, nrhs, NULL);
  nrhs_ls = (*env)->GetArrayLength(env, nrhs);
  nrhs_ll = malloc(sizeof(integer)*nrhs_ls);
  for (i_loc=0; i_loc<nrhs_ls; ++i_loc) nrhs_ll[i_loc] = nrhs_l[i_loc];
  b_ll = (*env)->GetPrimitiveArrayCritical(env, b, NULL);
  ldb_l = (*env)->GetPrimitiveArrayCritical(env, ldb, NULL);
  ldb_ls = (*env)->GetArrayLength(env, ldb);
  ldb_ll = malloc(sizeof(integer)*ldb_ls);
  for (i_loc=0; i_loc<ldb_ls; ++i_loc) ldb_ll[i_loc] = ldb_l[i_loc];
  bx_ll = (*env)->GetPrimitiveArrayCritical(env, bx, NULL);
  ldbx_l = (*env)->GetPrimitiveArrayCritical(env, ldbx, NULL);
  ldbx_ls = (*env)->GetArrayLength(env, ldbx);
  ldbx_ll = malloc(sizeof(integer)*ldbx_ls);
  for (i_loc=0; i_loc<ldbx_ls; ++i_loc) ldbx_ll[i_loc] = ldbx_l[i_loc];
  u_ll = (*env)->GetPrimitiveArrayCritical(env, u, NULL);
  ldu_l = (*env)->GetPrimitiveArrayCritical(env, ldu, NULL);
  ldu_ls = (*env)->GetArrayLength(env, ldu);
  ldu_ll = malloc(sizeof(integer)*ldu_ls);
  for (i_loc=0; i_loc<ldu_ls; ++i_loc) ldu_ll[i_loc] = ldu_l[i_loc];
  vt_ll = (*env)->GetPrimitiveArrayCritical(env, vt, NULL);
  k_l = (*env)->GetPrimitiveArrayCritical(env, k, NULL);
  k_ls = (*env)->GetArrayLength(env, k);
  k_ll = malloc(sizeof(integer)*k_ls);
  for (i_loc=0; i_loc<k_ls; ++i_loc) k_ll[i_loc] = k_l[i_loc];
  difl_ll = (*env)->GetPrimitiveArrayCritical(env, difl, NULL);
  difr_ll = (*env)->GetPrimitiveArrayCritical(env, difr, NULL);
  z_ll = (*env)->GetPrimitiveArrayCritical(env, z, NULL);
  poles_ll = (*env)->GetPrimitiveArrayCritical(env, poles, NULL);
  givptr_l = (*env)->GetPrimitiveArrayCritical(env, givptr, NULL);
  givptr_ls = (*env)->GetArrayLength(env, givptr);
  givptr_ll = malloc(sizeof(integer)*givptr_ls);
  for (i_loc=0; i_loc<givptr_ls; ++i_loc) givptr_ll[i_loc] = givptr_l[i_loc];
  givcol_l = (*env)->GetPrimitiveArrayCritical(env, givcol, NULL);
  givcol_ls = (*env)->GetArrayLength(env, givcol);
  givcol_ll = malloc(sizeof(integer)*givcol_ls);
  for (i_loc=0; i_loc<givcol_ls; ++i_loc) givcol_ll[i_loc] = givcol_l[i_loc];
  ldgcol_l = (*env)->GetPrimitiveArrayCritical(env, ldgcol, NULL);
  ldgcol_ls = (*env)->GetArrayLength(env, ldgcol);
  ldgcol_ll = malloc(sizeof(integer)*ldgcol_ls);
  for (i_loc=0; i_loc<ldgcol_ls; ++i_loc) ldgcol_ll[i_loc] = ldgcol_l[i_loc];
  perm_l = (*env)->GetPrimitiveArrayCritical(env, perm, NULL);
  perm_ls = (*env)->GetArrayLength(env, perm);
  perm_ll = malloc(sizeof(integer)*perm_ls);
  for (i_loc=0; i_loc<perm_ls; ++i_loc) perm_ll[i_loc] = perm_l[i_loc];
  givnum_ll = (*env)->GetPrimitiveArrayCritical(env, givnum, NULL);
  c_ll = (*env)->GetPrimitiveArrayCritical(env, c, NULL);
  s_ll = (*env)->GetPrimitiveArrayCritical(env, s, NULL);
  work_ll = (*env)->GetPrimitiveArrayCritical(env, work, NULL);
  iwork_l = (*env)->GetPrimitiveArrayCritical(env, iwork, NULL);
  iwork_ls = (*env)->GetArrayLength(env, iwork);
  iwork_ll = malloc(sizeof(integer)*iwork_ls);
  for (i_loc=0; i_loc<iwork_ls; ++i_loc) iwork_ll[i_loc] = iwork_l[i_loc];
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dlalsa_(icompq_ll, smlsiz_ll, n_ll, nrhs_ll, b_ll, ldb_ll, bx_ll, ldbx_ll, u_ll, ldu_ll, vt_ll, k_ll, difl_ll, difr_ll, z_ll, poles_ll, givptr_ll, givcol_ll, ldgcol_ll, perm_ll, givnum_ll, c_ll, s_ll, work_ll, iwork_ll, info_ll);

  for (i_loc=0; i_loc<icompq_ls; ++i_loc) icompq_l[i_loc] = icompq_ll[i_loc];
  free(icompq_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, icompq, icompq_l, 0);
  for (i_loc=0; i_loc<smlsiz_ls; ++i_loc) smlsiz_l[i_loc] = smlsiz_ll[i_loc];
  free(smlsiz_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, smlsiz, smlsiz_l, 0);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  for (i_loc=0; i_loc<nrhs_ls; ++i_loc) nrhs_l[i_loc] = nrhs_ll[i_loc];
  free(nrhs_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, nrhs, nrhs_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, b, b_ll, 0);
  for (i_loc=0; i_loc<ldb_ls; ++i_loc) ldb_l[i_loc] = ldb_ll[i_loc];
  free(ldb_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldb, ldb_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, bx, bx_ll, 0);
  for (i_loc=0; i_loc<ldbx_ls; ++i_loc) ldbx_l[i_loc] = ldbx_ll[i_loc];
  free(ldbx_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldbx, ldbx_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, u, u_ll, 0);
  for (i_loc=0; i_loc<ldu_ls; ++i_loc) ldu_l[i_loc] = ldu_ll[i_loc];
  free(ldu_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldu, ldu_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, vt, vt_ll, 0);
  for (i_loc=0; i_loc<k_ls; ++i_loc) k_l[i_loc] = k_ll[i_loc];
  free(k_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, k, k_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, difl, difl_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, difr, difr_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, z, z_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, poles, poles_ll, 0);
  for (i_loc=0; i_loc<givptr_ls; ++i_loc) givptr_l[i_loc] = givptr_ll[i_loc];
  free(givptr_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, givptr, givptr_l, 0);
  for (i_loc=0; i_loc<givcol_ls; ++i_loc) givcol_l[i_loc] = givcol_ll[i_loc];
  free(givcol_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, givcol, givcol_l, 0);
  for (i_loc=0; i_loc<ldgcol_ls; ++i_loc) ldgcol_l[i_loc] = ldgcol_ll[i_loc];
  free(ldgcol_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldgcol, ldgcol_l, 0);
  for (i_loc=0; i_loc<perm_ls; ++i_loc) perm_l[i_loc] = perm_ll[i_loc];
  free(perm_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, perm, perm_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, givnum, givnum_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, c, c_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, s, s_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, work, work_ll, 0);
  for (i_loc=0; i_loc<iwork_ls; ++i_loc) iwork_l[i_loc] = iwork_ll[i_loc];
  free(iwork_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, iwork, iwork_l, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_lalsd
(JNIEnv *env, jclass clazz, jcharArray uplo, jintArray smlsiz, jintArray n, jintArray nrhs, jdoubleArray d, jdoubleArray e, jdoubleArray b, jintArray ldb, jdoubleArray rcond, jintArray rank, jdoubleArray work, jintArray iwork, jintArray info) {
  int i_loc;
  jchar* uplo_l;
  char* uplo_ll;
  jsize uplo_ls;
  jint* smlsiz_l;
  integer* smlsiz_ll;
  jsize smlsiz_ls;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jint* nrhs_l;
  integer* nrhs_ll;
  jsize nrhs_ls;
  jdouble* d_ll;
  jdouble* e_ll;
  jdouble* b_ll;
  jint* ldb_l;
  integer* ldb_ll;
  jsize ldb_ls;
  jdouble* rcond_ll;
  jint* rank_l;
  integer* rank_ll;
  jsize rank_ls;
  jdouble* work_ll;
  jint* iwork_l;
  integer* iwork_ll;
  jsize iwork_ls;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  uplo_l = (*env)->GetPrimitiveArrayCritical(env, uplo, NULL);
  uplo_ls = (*env)->GetArrayLength(env, uplo);
  uplo_ll = malloc(sizeof(char)*uplo_ls);
  for (i_loc=0; i_loc<uplo_ls; ++i_loc) uplo_ll[i_loc] = uplo_l[i_loc];
  smlsiz_l = (*env)->GetPrimitiveArrayCritical(env, smlsiz, NULL);
  smlsiz_ls = (*env)->GetArrayLength(env, smlsiz);
  smlsiz_ll = malloc(sizeof(integer)*smlsiz_ls);
  for (i_loc=0; i_loc<smlsiz_ls; ++i_loc) smlsiz_ll[i_loc] = smlsiz_l[i_loc];
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  nrhs_l = (*env)->GetPrimitiveArrayCritical(env, nrhs, NULL);
  nrhs_ls = (*env)->GetArrayLength(env, nrhs);
  nrhs_ll = malloc(sizeof(integer)*nrhs_ls);
  for (i_loc=0; i_loc<nrhs_ls; ++i_loc) nrhs_ll[i_loc] = nrhs_l[i_loc];
  d_ll = (*env)->GetPrimitiveArrayCritical(env, d, NULL);
  e_ll = (*env)->GetPrimitiveArrayCritical(env, e, NULL);
  b_ll = (*env)->GetPrimitiveArrayCritical(env, b, NULL);
  ldb_l = (*env)->GetPrimitiveArrayCritical(env, ldb, NULL);
  ldb_ls = (*env)->GetArrayLength(env, ldb);
  ldb_ll = malloc(sizeof(integer)*ldb_ls);
  for (i_loc=0; i_loc<ldb_ls; ++i_loc) ldb_ll[i_loc] = ldb_l[i_loc];
  rcond_ll = (*env)->GetPrimitiveArrayCritical(env, rcond, NULL);
  rank_l = (*env)->GetPrimitiveArrayCritical(env, rank, NULL);
  rank_ls = (*env)->GetArrayLength(env, rank);
  rank_ll = malloc(sizeof(integer)*rank_ls);
  for (i_loc=0; i_loc<rank_ls; ++i_loc) rank_ll[i_loc] = rank_l[i_loc];
  work_ll = (*env)->GetPrimitiveArrayCritical(env, work, NULL);
  iwork_l = (*env)->GetPrimitiveArrayCritical(env, iwork, NULL);
  iwork_ls = (*env)->GetArrayLength(env, iwork);
  iwork_ll = malloc(sizeof(integer)*iwork_ls);
  for (i_loc=0; i_loc<iwork_ls; ++i_loc) iwork_ll[i_loc] = iwork_l[i_loc];
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dlalsd_(uplo_ll, smlsiz_ll, n_ll, nrhs_ll, d_ll, e_ll, b_ll, ldb_ll, rcond_ll, rank_ll, work_ll, iwork_ll, info_ll);

  for (i_loc=0; i_loc<uplo_ls; ++i_loc) uplo_l[i_loc] = uplo_ll[i_loc];
  free(uplo_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, uplo, uplo_l, 0);
  for (i_loc=0; i_loc<smlsiz_ls; ++i_loc) smlsiz_l[i_loc] = smlsiz_ll[i_loc];
  free(smlsiz_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, smlsiz, smlsiz_l, 0);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  for (i_loc=0; i_loc<nrhs_ls; ++i_loc) nrhs_l[i_loc] = nrhs_ll[i_loc];
  free(nrhs_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, nrhs, nrhs_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, d, d_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, e, e_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, b, b_ll, 0);
  for (i_loc=0; i_loc<ldb_ls; ++i_loc) ldb_l[i_loc] = ldb_ll[i_loc];
  free(ldb_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldb, ldb_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, rcond, rcond_ll, 0);
  for (i_loc=0; i_loc<rank_ls; ++i_loc) rank_l[i_loc] = rank_ll[i_loc];
  free(rank_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, rank, rank_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, work, work_ll, 0);
  for (i_loc=0; i_loc<iwork_ls; ++i_loc) iwork_l[i_loc] = iwork_ll[i_loc];
  free(iwork_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, iwork, iwork_l, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_lamc1
(JNIEnv *env, jclass clazz, jintArray beta, jintArray t, jbooleanArray rnd, jbooleanArray ieee1) {
  int i_loc;
  jint* beta_l;
  integer* beta_ll;
  jsize beta_ls;
  jint* t_l;
  integer* t_ll;
  jsize t_ls;
  jboolean* rnd_l;
  integer* rnd_ll;
  jsize rnd_ls;
  jboolean* ieee1_l;
  integer* ieee1_ll;
  jsize ieee1_ls;
  beta_l = (*env)->GetPrimitiveArrayCritical(env, beta, NULL);
  beta_ls = (*env)->GetArrayLength(env, beta);
  beta_ll = malloc(sizeof(integer)*beta_ls);
  for (i_loc=0; i_loc<beta_ls; ++i_loc) beta_ll[i_loc] = beta_l[i_loc];
  t_l = (*env)->GetPrimitiveArrayCritical(env, t, NULL);
  t_ls = (*env)->GetArrayLength(env, t);
  t_ll = malloc(sizeof(integer)*t_ls);
  for (i_loc=0; i_loc<t_ls; ++i_loc) t_ll[i_loc] = t_l[i_loc];
  rnd_l = (*env)->GetPrimitiveArrayCritical(env, rnd, NULL);
  rnd_ls = (*env)->GetArrayLength(env, rnd);
  rnd_ll = malloc(sizeof(integer)*rnd_ls);
  for (i_loc=0; i_loc<rnd_ls; ++i_loc) rnd_ll[i_loc] = rnd_l[i_loc];
  ieee1_l = (*env)->GetPrimitiveArrayCritical(env, ieee1, NULL);
  ieee1_ls = (*env)->GetArrayLength(env, ieee1);
  ieee1_ll = malloc(sizeof(integer)*ieee1_ls);
  for (i_loc=0; i_loc<ieee1_ls; ++i_loc) ieee1_ll[i_loc] = ieee1_l[i_loc];

  dlamc1_(beta_ll, t_ll, rnd_ll, ieee1_ll);

  for (i_loc=0; i_loc<beta_ls; ++i_loc) beta_l[i_loc] = beta_ll[i_loc];
  free(beta_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, beta, beta_l, 0);
  for (i_loc=0; i_loc<t_ls; ++i_loc) t_l[i_loc] = t_ll[i_loc];
  free(t_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, t, t_l, 0);
  for (i_loc=0; i_loc<rnd_ls; ++i_loc) rnd_l[i_loc] = rnd_ll[i_loc];
  free(rnd_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, rnd, rnd_l, 0);
  for (i_loc=0; i_loc<ieee1_ls; ++i_loc) ieee1_l[i_loc] = ieee1_ll[i_loc];
  free(ieee1_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ieee1, ieee1_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_lamc2
(JNIEnv *env, jclass clazz, jintArray beta, jintArray t, jbooleanArray rnd, jdoubleArray eps, jintArray emin, jdoubleArray rmin, jintArray emax, jdoubleArray rmax) {
  int i_loc;
  jint* beta_l;
  integer* beta_ll;
  jsize beta_ls;
  jint* t_l;
  integer* t_ll;
  jsize t_ls;
  jboolean* rnd_l;
  integer* rnd_ll;
  jsize rnd_ls;
  jdouble* eps_ll;
  jint* emin_l;
  integer* emin_ll;
  jsize emin_ls;
  jdouble* rmin_ll;
  jint* emax_l;
  integer* emax_ll;
  jsize emax_ls;
  jdouble* rmax_ll;
  beta_l = (*env)->GetPrimitiveArrayCritical(env, beta, NULL);
  beta_ls = (*env)->GetArrayLength(env, beta);
  beta_ll = malloc(sizeof(integer)*beta_ls);
  for (i_loc=0; i_loc<beta_ls; ++i_loc) beta_ll[i_loc] = beta_l[i_loc];
  t_l = (*env)->GetPrimitiveArrayCritical(env, t, NULL);
  t_ls = (*env)->GetArrayLength(env, t);
  t_ll = malloc(sizeof(integer)*t_ls);
  for (i_loc=0; i_loc<t_ls; ++i_loc) t_ll[i_loc] = t_l[i_loc];
  rnd_l = (*env)->GetPrimitiveArrayCritical(env, rnd, NULL);
  rnd_ls = (*env)->GetArrayLength(env, rnd);
  rnd_ll = malloc(sizeof(integer)*rnd_ls);
  for (i_loc=0; i_loc<rnd_ls; ++i_loc) rnd_ll[i_loc] = rnd_l[i_loc];
  eps_ll = (*env)->GetPrimitiveArrayCritical(env, eps, NULL);
  emin_l = (*env)->GetPrimitiveArrayCritical(env, emin, NULL);
  emin_ls = (*env)->GetArrayLength(env, emin);
  emin_ll = malloc(sizeof(integer)*emin_ls);
  for (i_loc=0; i_loc<emin_ls; ++i_loc) emin_ll[i_loc] = emin_l[i_loc];
  rmin_ll = (*env)->GetPrimitiveArrayCritical(env, rmin, NULL);
  emax_l = (*env)->GetPrimitiveArrayCritical(env, emax, NULL);
  emax_ls = (*env)->GetArrayLength(env, emax);
  emax_ll = malloc(sizeof(integer)*emax_ls);
  for (i_loc=0; i_loc<emax_ls; ++i_loc) emax_ll[i_loc] = emax_l[i_loc];
  rmax_ll = (*env)->GetPrimitiveArrayCritical(env, rmax, NULL);

  dlamc2_(beta_ll, t_ll, rnd_ll, eps_ll, emin_ll, rmin_ll, emax_ll, rmax_ll);

  for (i_loc=0; i_loc<beta_ls; ++i_loc) beta_l[i_loc] = beta_ll[i_loc];
  free(beta_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, beta, beta_l, 0);
  for (i_loc=0; i_loc<t_ls; ++i_loc) t_l[i_loc] = t_ll[i_loc];
  free(t_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, t, t_l, 0);
  for (i_loc=0; i_loc<rnd_ls; ++i_loc) rnd_l[i_loc] = rnd_ll[i_loc];
  free(rnd_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, rnd, rnd_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, eps, eps_ll, 0);
  for (i_loc=0; i_loc<emin_ls; ++i_loc) emin_l[i_loc] = emin_ll[i_loc];
  free(emin_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, emin, emin_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, rmin, rmin_ll, 0);
  for (i_loc=0; i_loc<emax_ls; ++i_loc) emax_l[i_loc] = emax_ll[i_loc];
  free(emax_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, emax, emax_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, rmax, rmax_ll, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_lamc4
(JNIEnv *env, jclass clazz, jintArray emin, jdoubleArray start, jintArray base) {
  int i_loc;
  jint* emin_l;
  integer* emin_ll;
  jsize emin_ls;
  jdouble* start_ll;
  jint* base_l;
  integer* base_ll;
  jsize base_ls;
  emin_l = (*env)->GetPrimitiveArrayCritical(env, emin, NULL);
  emin_ls = (*env)->GetArrayLength(env, emin);
  emin_ll = malloc(sizeof(integer)*emin_ls);
  for (i_loc=0; i_loc<emin_ls; ++i_loc) emin_ll[i_loc] = emin_l[i_loc];
  start_ll = (*env)->GetPrimitiveArrayCritical(env, start, NULL);
  base_l = (*env)->GetPrimitiveArrayCritical(env, base, NULL);
  base_ls = (*env)->GetArrayLength(env, base);
  base_ll = malloc(sizeof(integer)*base_ls);
  for (i_loc=0; i_loc<base_ls; ++i_loc) base_ll[i_loc] = base_l[i_loc];

  dlamc4_(emin_ll, start_ll, base_ll);

  for (i_loc=0; i_loc<emin_ls; ++i_loc) emin_l[i_loc] = emin_ll[i_loc];
  free(emin_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, emin, emin_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, start, start_ll, 0);
  for (i_loc=0; i_loc<base_ls; ++i_loc) base_l[i_loc] = base_ll[i_loc];
  free(base_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, base, base_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_lamc5
(JNIEnv *env, jclass clazz, jintArray beta, jintArray p, jintArray emin, jbooleanArray ieee, jintArray emax, jdoubleArray rmax) {
  int i_loc;
  jint* beta_l;
  integer* beta_ll;
  jsize beta_ls;
  jint* p_l;
  integer* p_ll;
  jsize p_ls;
  jint* emin_l;
  integer* emin_ll;
  jsize emin_ls;
  jboolean* ieee_l;
  integer* ieee_ll;
  jsize ieee_ls;
  jint* emax_l;
  integer* emax_ll;
  jsize emax_ls;
  jdouble* rmax_ll;
  beta_l = (*env)->GetPrimitiveArrayCritical(env, beta, NULL);
  beta_ls = (*env)->GetArrayLength(env, beta);
  beta_ll = malloc(sizeof(integer)*beta_ls);
  for (i_loc=0; i_loc<beta_ls; ++i_loc) beta_ll[i_loc] = beta_l[i_loc];
  p_l = (*env)->GetPrimitiveArrayCritical(env, p, NULL);
  p_ls = (*env)->GetArrayLength(env, p);
  p_ll = malloc(sizeof(integer)*p_ls);
  for (i_loc=0; i_loc<p_ls; ++i_loc) p_ll[i_loc] = p_l[i_loc];
  emin_l = (*env)->GetPrimitiveArrayCritical(env, emin, NULL);
  emin_ls = (*env)->GetArrayLength(env, emin);
  emin_ll = malloc(sizeof(integer)*emin_ls);
  for (i_loc=0; i_loc<emin_ls; ++i_loc) emin_ll[i_loc] = emin_l[i_loc];
  ieee_l = (*env)->GetPrimitiveArrayCritical(env, ieee, NULL);
  ieee_ls = (*env)->GetArrayLength(env, ieee);
  ieee_ll = malloc(sizeof(integer)*ieee_ls);
  for (i_loc=0; i_loc<ieee_ls; ++i_loc) ieee_ll[i_loc] = ieee_l[i_loc];
  emax_l = (*env)->GetPrimitiveArrayCritical(env, emax, NULL);
  emax_ls = (*env)->GetArrayLength(env, emax);
  emax_ll = malloc(sizeof(integer)*emax_ls);
  for (i_loc=0; i_loc<emax_ls; ++i_loc) emax_ll[i_loc] = emax_l[i_loc];
  rmax_ll = (*env)->GetPrimitiveArrayCritical(env, rmax, NULL);

  dlamc5_(beta_ll, p_ll, emin_ll, ieee_ll, emax_ll, rmax_ll);

  for (i_loc=0; i_loc<beta_ls; ++i_loc) beta_l[i_loc] = beta_ll[i_loc];
  free(beta_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, beta, beta_l, 0);
  for (i_loc=0; i_loc<p_ls; ++i_loc) p_l[i_loc] = p_ll[i_loc];
  free(p_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, p, p_l, 0);
  for (i_loc=0; i_loc<emin_ls; ++i_loc) emin_l[i_loc] = emin_ll[i_loc];
  free(emin_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, emin, emin_l, 0);
  for (i_loc=0; i_loc<ieee_ls; ++i_loc) ieee_l[i_loc] = ieee_ll[i_loc];
  free(ieee_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ieee, ieee_l, 0);
  for (i_loc=0; i_loc<emax_ls; ++i_loc) emax_l[i_loc] = emax_ll[i_loc];
  free(emax_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, emax, emax_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, rmax, rmax_ll, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_lamrg
(JNIEnv *env, jclass clazz, jintArray n1, jintArray n2, jdoubleArray a, jintArray dtrd1, jintArray dtrd2, jintArray index) {
  int i_loc;
  jint* n1_l;
  integer* n1_ll;
  jsize n1_ls;
  jint* n2_l;
  integer* n2_ll;
  jsize n2_ls;
  jdouble* a_ll;
  jint* dtrd1_l;
  integer* dtrd1_ll;
  jsize dtrd1_ls;
  jint* dtrd2_l;
  integer* dtrd2_ll;
  jsize dtrd2_ls;
  jint* index_l;
  integer* index_ll;
  jsize index_ls;
  n1_l = (*env)->GetPrimitiveArrayCritical(env, n1, NULL);
  n1_ls = (*env)->GetArrayLength(env, n1);
  n1_ll = malloc(sizeof(integer)*n1_ls);
  for (i_loc=0; i_loc<n1_ls; ++i_loc) n1_ll[i_loc] = n1_l[i_loc];
  n2_l = (*env)->GetPrimitiveArrayCritical(env, n2, NULL);
  n2_ls = (*env)->GetArrayLength(env, n2);
  n2_ll = malloc(sizeof(integer)*n2_ls);
  for (i_loc=0; i_loc<n2_ls; ++i_loc) n2_ll[i_loc] = n2_l[i_loc];
  a_ll = (*env)->GetPrimitiveArrayCritical(env, a, NULL);
  dtrd1_l = (*env)->GetPrimitiveArrayCritical(env, dtrd1, NULL);
  dtrd1_ls = (*env)->GetArrayLength(env, dtrd1);
  dtrd1_ll = malloc(sizeof(integer)*dtrd1_ls);
  for (i_loc=0; i_loc<dtrd1_ls; ++i_loc) dtrd1_ll[i_loc] = dtrd1_l[i_loc];
  dtrd2_l = (*env)->GetPrimitiveArrayCritical(env, dtrd2, NULL);
  dtrd2_ls = (*env)->GetArrayLength(env, dtrd2);
  dtrd2_ll = malloc(sizeof(integer)*dtrd2_ls);
  for (i_loc=0; i_loc<dtrd2_ls; ++i_loc) dtrd2_ll[i_loc] = dtrd2_l[i_loc];
  index_l = (*env)->GetPrimitiveArrayCritical(env, index, NULL);
  index_ls = (*env)->GetArrayLength(env, index);
  index_ll = malloc(sizeof(integer)*index_ls);
  for (i_loc=0; i_loc<index_ls; ++i_loc) index_ll[i_loc] = index_l[i_loc];

  dlamrg_(n1_ll, n2_ll, a_ll, dtrd1_ll, dtrd2_ll, index_ll);

  for (i_loc=0; i_loc<n1_ls; ++i_loc) n1_l[i_loc] = n1_ll[i_loc];
  free(n1_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n1, n1_l, 0);
  for (i_loc=0; i_loc<n2_ls; ++i_loc) n2_l[i_loc] = n2_ll[i_loc];
  free(n2_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n2, n2_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, a, a_ll, 0);
  for (i_loc=0; i_loc<dtrd1_ls; ++i_loc) dtrd1_l[i_loc] = dtrd1_ll[i_loc];
  free(dtrd1_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, dtrd1, dtrd1_l, 0);
  for (i_loc=0; i_loc<dtrd2_ls; ++i_loc) dtrd2_l[i_loc] = dtrd2_ll[i_loc];
  free(dtrd2_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, dtrd2, dtrd2_l, 0);
  for (i_loc=0; i_loc<index_ls; ++i_loc) index_l[i_loc] = index_ll[i_loc];
  free(index_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, index, index_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_lanv2
(JNIEnv *env, jclass clazz, jdoubleArray a, jdoubleArray b, jdoubleArray c, jdoubleArray d, jdoubleArray rt1r, jdoubleArray rt1i, jdoubleArray rt2r, jdoubleArray rt2i, jdoubleArray cs, jdoubleArray sn) {
  jdouble* a_ll;
  jdouble* b_ll;
  jdouble* c_ll;
  jdouble* d_ll;
  jdouble* rt1r_ll;
  jdouble* rt1i_ll;
  jdouble* rt2r_ll;
  jdouble* rt2i_ll;
  jdouble* cs_ll;
  jdouble* sn_ll;
  a_ll = (*env)->GetPrimitiveArrayCritical(env, a, NULL);
  b_ll = (*env)->GetPrimitiveArrayCritical(env, b, NULL);
  c_ll = (*env)->GetPrimitiveArrayCritical(env, c, NULL);
  d_ll = (*env)->GetPrimitiveArrayCritical(env, d, NULL);
  rt1r_ll = (*env)->GetPrimitiveArrayCritical(env, rt1r, NULL);
  rt1i_ll = (*env)->GetPrimitiveArrayCritical(env, rt1i, NULL);
  rt2r_ll = (*env)->GetPrimitiveArrayCritical(env, rt2r, NULL);
  rt2i_ll = (*env)->GetPrimitiveArrayCritical(env, rt2i, NULL);
  cs_ll = (*env)->GetPrimitiveArrayCritical(env, cs, NULL);
  sn_ll = (*env)->GetPrimitiveArrayCritical(env, sn, NULL);

  dlanv2_(a_ll, b_ll, c_ll, d_ll, rt1r_ll, rt1i_ll, rt2r_ll, rt2i_ll, cs_ll, sn_ll);

  (*env)->ReleasePrimitiveArrayCritical(env, a, a_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, b, b_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, c, c_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, d, d_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, rt1r, rt1r_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, rt1i, rt1i_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, rt2r, rt2r_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, rt2i, rt2i_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, cs, cs_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, sn, sn_ll, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_lapll
(JNIEnv *env, jclass clazz, jintArray n, jdoubleArray x, jintArray incx, jdoubleArray y, jintArray incy, jdoubleArray ssmin) {
  int i_loc;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jdouble* x_ll;
  jint* incx_l;
  integer* incx_ll;
  jsize incx_ls;
  jdouble* y_ll;
  jint* incy_l;
  integer* incy_ll;
  jsize incy_ls;
  jdouble* ssmin_ll;
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  x_ll = (*env)->GetPrimitiveArrayCritical(env, x, NULL);
  incx_l = (*env)->GetPrimitiveArrayCritical(env, incx, NULL);
  incx_ls = (*env)->GetArrayLength(env, incx);
  incx_ll = malloc(sizeof(integer)*incx_ls);
  for (i_loc=0; i_loc<incx_ls; ++i_loc) incx_ll[i_loc] = incx_l[i_loc];
  y_ll = (*env)->GetPrimitiveArrayCritical(env, y, NULL);
  incy_l = (*env)->GetPrimitiveArrayCritical(env, incy, NULL);
  incy_ls = (*env)->GetArrayLength(env, incy);
  incy_ll = malloc(sizeof(integer)*incy_ls);
  for (i_loc=0; i_loc<incy_ls; ++i_loc) incy_ll[i_loc] = incy_l[i_loc];
  ssmin_ll = (*env)->GetPrimitiveArrayCritical(env, ssmin, NULL);

  dlapll_(n_ll, x_ll, incx_ll, y_ll, incy_ll, ssmin_ll);

  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, x, x_ll, 0);
  for (i_loc=0; i_loc<incx_ls; ++i_loc) incx_l[i_loc] = incx_ll[i_loc];
  free(incx_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, incx, incx_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, y, y_ll, 0);
  for (i_loc=0; i_loc<incy_ls; ++i_loc) incy_l[i_loc] = incy_ll[i_loc];
  free(incy_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, incy, incy_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, ssmin, ssmin_ll, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_lapmt
(JNIEnv *env, jclass clazz, jbooleanArray forwrd, jintArray m, jintArray n, jdoubleArray x, jintArray ldx, jintArray k) {
  int i_loc;
  jboolean* forwrd_l;
  integer* forwrd_ll;
  jsize forwrd_ls;
  jint* m_l;
  integer* m_ll;
  jsize m_ls;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jdouble* x_ll;
  jint* ldx_l;
  integer* ldx_ll;
  jsize ldx_ls;
  jint* k_l;
  integer* k_ll;
  jsize k_ls;
  forwrd_l = (*env)->GetPrimitiveArrayCritical(env, forwrd, NULL);
  forwrd_ls = (*env)->GetArrayLength(env, forwrd);
  forwrd_ll = malloc(sizeof(integer)*forwrd_ls);
  for (i_loc=0; i_loc<forwrd_ls; ++i_loc) forwrd_ll[i_loc] = forwrd_l[i_loc];
  m_l = (*env)->GetPrimitiveArrayCritical(env, m, NULL);
  m_ls = (*env)->GetArrayLength(env, m);
  m_ll = malloc(sizeof(integer)*m_ls);
  for (i_loc=0; i_loc<m_ls; ++i_loc) m_ll[i_loc] = m_l[i_loc];
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  x_ll = (*env)->GetPrimitiveArrayCritical(env, x, NULL);
  ldx_l = (*env)->GetPrimitiveArrayCritical(env, ldx, NULL);
  ldx_ls = (*env)->GetArrayLength(env, ldx);
  ldx_ll = malloc(sizeof(integer)*ldx_ls);
  for (i_loc=0; i_loc<ldx_ls; ++i_loc) ldx_ll[i_loc] = ldx_l[i_loc];
  k_l = (*env)->GetPrimitiveArrayCritical(env, k, NULL);
  k_ls = (*env)->GetArrayLength(env, k);
  k_ll = malloc(sizeof(integer)*k_ls);
  for (i_loc=0; i_loc<k_ls; ++i_loc) k_ll[i_loc] = k_l[i_loc];

  dlapmt_(forwrd_ll, m_ll, n_ll, x_ll, ldx_ll, k_ll);

  for (i_loc=0; i_loc<forwrd_ls; ++i_loc) forwrd_l[i_loc] = forwrd_ll[i_loc];
  free(forwrd_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, forwrd, forwrd_l, 0);
  for (i_loc=0; i_loc<m_ls; ++i_loc) m_l[i_loc] = m_ll[i_loc];
  free(m_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, m, m_l, 0);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, x, x_ll, 0);
  for (i_loc=0; i_loc<ldx_ls; ++i_loc) ldx_l[i_loc] = ldx_ll[i_loc];
  free(ldx_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldx, ldx_l, 0);
  for (i_loc=0; i_loc<k_ls; ++i_loc) k_l[i_loc] = k_ll[i_loc];
  free(k_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, k, k_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_laqgb
(JNIEnv *env, jclass clazz, jintArray m, jintArray n, jintArray kl, jintArray ku, jdoubleArray ab, jintArray ldab, jdoubleArray r, jdoubleArray c, jdoubleArray rowcnd, jdoubleArray colcnd, jdoubleArray amax, jcharArray equed) {
  int i_loc;
  jint* m_l;
  integer* m_ll;
  jsize m_ls;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jint* kl_l;
  integer* kl_ll;
  jsize kl_ls;
  jint* ku_l;
  integer* ku_ll;
  jsize ku_ls;
  jdouble* ab_ll;
  jint* ldab_l;
  integer* ldab_ll;
  jsize ldab_ls;
  jdouble* r_ll;
  jdouble* c_ll;
  jdouble* rowcnd_ll;
  jdouble* colcnd_ll;
  jdouble* amax_ll;
  jchar* equed_l;
  char* equed_ll;
  jsize equed_ls;
  m_l = (*env)->GetPrimitiveArrayCritical(env, m, NULL);
  m_ls = (*env)->GetArrayLength(env, m);
  m_ll = malloc(sizeof(integer)*m_ls);
  for (i_loc=0; i_loc<m_ls; ++i_loc) m_ll[i_loc] = m_l[i_loc];
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  kl_l = (*env)->GetPrimitiveArrayCritical(env, kl, NULL);
  kl_ls = (*env)->GetArrayLength(env, kl);
  kl_ll = malloc(sizeof(integer)*kl_ls);
  for (i_loc=0; i_loc<kl_ls; ++i_loc) kl_ll[i_loc] = kl_l[i_loc];
  ku_l = (*env)->GetPrimitiveArrayCritical(env, ku, NULL);
  ku_ls = (*env)->GetArrayLength(env, ku);
  ku_ll = malloc(sizeof(integer)*ku_ls);
  for (i_loc=0; i_loc<ku_ls; ++i_loc) ku_ll[i_loc] = ku_l[i_loc];
  ab_ll = (*env)->GetPrimitiveArrayCritical(env, ab, NULL);
  ldab_l = (*env)->GetPrimitiveArrayCritical(env, ldab, NULL);
  ldab_ls = (*env)->GetArrayLength(env, ldab);
  ldab_ll = malloc(sizeof(integer)*ldab_ls);
  for (i_loc=0; i_loc<ldab_ls; ++i_loc) ldab_ll[i_loc] = ldab_l[i_loc];
  r_ll = (*env)->GetPrimitiveArrayCritical(env, r, NULL);
  c_ll = (*env)->GetPrimitiveArrayCritical(env, c, NULL);
  rowcnd_ll = (*env)->GetPrimitiveArrayCritical(env, rowcnd, NULL);
  colcnd_ll = (*env)->GetPrimitiveArrayCritical(env, colcnd, NULL);
  amax_ll = (*env)->GetPrimitiveArrayCritical(env, amax, NULL);
  equed_l = (*env)->GetPrimitiveArrayCritical(env, equed, NULL);
  equed_ls = (*env)->GetArrayLength(env, equed);
  equed_ll = malloc(sizeof(char)*equed_ls);
  for (i_loc=0; i_loc<equed_ls; ++i_loc) equed_ll[i_loc] = equed_l[i_loc];

  dlaqgb_(m_ll, n_ll, kl_ll, ku_ll, ab_ll, ldab_ll, r_ll, c_ll, rowcnd_ll, colcnd_ll, amax_ll, equed_ll);

  for (i_loc=0; i_loc<m_ls; ++i_loc) m_l[i_loc] = m_ll[i_loc];
  free(m_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, m, m_l, 0);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  for (i_loc=0; i_loc<kl_ls; ++i_loc) kl_l[i_loc] = kl_ll[i_loc];
  free(kl_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, kl, kl_l, 0);
  for (i_loc=0; i_loc<ku_ls; ++i_loc) ku_l[i_loc] = ku_ll[i_loc];
  free(ku_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ku, ku_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, ab, ab_ll, 0);
  for (i_loc=0; i_loc<ldab_ls; ++i_loc) ldab_l[i_loc] = ldab_ll[i_loc];
  free(ldab_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldab, ldab_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, r, r_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, c, c_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, rowcnd, rowcnd_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, colcnd, colcnd_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, amax, amax_ll, 0);
  for (i_loc=0; i_loc<equed_ls; ++i_loc) equed_l[i_loc] = equed_ll[i_loc];
  free(equed_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, equed, equed_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_laqge
(JNIEnv *env, jclass clazz, jintArray m, jintArray n, jdoubleArray a, jintArray lda, jdoubleArray r, jdoubleArray c, jdoubleArray rowcnd, jdoubleArray colcnd, jdoubleArray amax, jcharArray equed) {
  int i_loc;
  jint* m_l;
  integer* m_ll;
  jsize m_ls;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jdouble* a_ll;
  jint* lda_l;
  integer* lda_ll;
  jsize lda_ls;
  jdouble* r_ll;
  jdouble* c_ll;
  jdouble* rowcnd_ll;
  jdouble* colcnd_ll;
  jdouble* amax_ll;
  jchar* equed_l;
  char* equed_ll;
  jsize equed_ls;
  m_l = (*env)->GetPrimitiveArrayCritical(env, m, NULL);
  m_ls = (*env)->GetArrayLength(env, m);
  m_ll = malloc(sizeof(integer)*m_ls);
  for (i_loc=0; i_loc<m_ls; ++i_loc) m_ll[i_loc] = m_l[i_loc];
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  a_ll = (*env)->GetPrimitiveArrayCritical(env, a, NULL);
  lda_l = (*env)->GetPrimitiveArrayCritical(env, lda, NULL);
  lda_ls = (*env)->GetArrayLength(env, lda);
  lda_ll = malloc(sizeof(integer)*lda_ls);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_ll[i_loc] = lda_l[i_loc];
  r_ll = (*env)->GetPrimitiveArrayCritical(env, r, NULL);
  c_ll = (*env)->GetPrimitiveArrayCritical(env, c, NULL);
  rowcnd_ll = (*env)->GetPrimitiveArrayCritical(env, rowcnd, NULL);
  colcnd_ll = (*env)->GetPrimitiveArrayCritical(env, colcnd, NULL);
  amax_ll = (*env)->GetPrimitiveArrayCritical(env, amax, NULL);
  equed_l = (*env)->GetPrimitiveArrayCritical(env, equed, NULL);
  equed_ls = (*env)->GetArrayLength(env, equed);
  equed_ll = malloc(sizeof(char)*equed_ls);
  for (i_loc=0; i_loc<equed_ls; ++i_loc) equed_ll[i_loc] = equed_l[i_loc];

  dlaqge_(m_ll, n_ll, a_ll, lda_ll, r_ll, c_ll, rowcnd_ll, colcnd_ll, amax_ll, equed_ll);

  for (i_loc=0; i_loc<m_ls; ++i_loc) m_l[i_loc] = m_ll[i_loc];
  free(m_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, m, m_l, 0);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, a, a_ll, 0);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_l[i_loc] = lda_ll[i_loc];
  free(lda_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, lda, lda_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, r, r_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, c, c_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, rowcnd, rowcnd_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, colcnd, colcnd_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, amax, amax_ll, 0);
  for (i_loc=0; i_loc<equed_ls; ++i_loc) equed_l[i_loc] = equed_ll[i_loc];
  free(equed_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, equed, equed_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_laqp2
(JNIEnv *env, jclass clazz, jintArray m, jintArray n, jintArray offset, jdoubleArray a, jintArray lda, jintArray jpvt, jdoubleArray tau, jdoubleArray vn1, jdoubleArray vn2, jdoubleArray work) {
  int i_loc;
  jint* m_l;
  integer* m_ll;
  jsize m_ls;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jint* offset_l;
  integer* offset_ll;
  jsize offset_ls;
  jdouble* a_ll;
  jint* lda_l;
  integer* lda_ll;
  jsize lda_ls;
  jint* jpvt_l;
  integer* jpvt_ll;
  jsize jpvt_ls;
  jdouble* tau_ll;
  jdouble* vn1_ll;
  jdouble* vn2_ll;
  jdouble* work_ll;
  m_l = (*env)->GetPrimitiveArrayCritical(env, m, NULL);
  m_ls = (*env)->GetArrayLength(env, m);
  m_ll = malloc(sizeof(integer)*m_ls);
  for (i_loc=0; i_loc<m_ls; ++i_loc) m_ll[i_loc] = m_l[i_loc];
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  offset_l = (*env)->GetPrimitiveArrayCritical(env, offset, NULL);
  offset_ls = (*env)->GetArrayLength(env, offset);
  offset_ll = malloc(sizeof(integer)*offset_ls);
  for (i_loc=0; i_loc<offset_ls; ++i_loc) offset_ll[i_loc] = offset_l[i_loc];
  a_ll = (*env)->GetPrimitiveArrayCritical(env, a, NULL);
  lda_l = (*env)->GetPrimitiveArrayCritical(env, lda, NULL);
  lda_ls = (*env)->GetArrayLength(env, lda);
  lda_ll = malloc(sizeof(integer)*lda_ls);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_ll[i_loc] = lda_l[i_loc];
  jpvt_l = (*env)->GetPrimitiveArrayCritical(env, jpvt, NULL);
  jpvt_ls = (*env)->GetArrayLength(env, jpvt);
  jpvt_ll = malloc(sizeof(integer)*jpvt_ls);
  for (i_loc=0; i_loc<jpvt_ls; ++i_loc) jpvt_ll[i_loc] = jpvt_l[i_loc];
  tau_ll = (*env)->GetPrimitiveArrayCritical(env, tau, NULL);
  vn1_ll = (*env)->GetPrimitiveArrayCritical(env, vn1, NULL);
  vn2_ll = (*env)->GetPrimitiveArrayCritical(env, vn2, NULL);
  work_ll = (*env)->GetPrimitiveArrayCritical(env, work, NULL);

  dlaqp2_(m_ll, n_ll, offset_ll, a_ll, lda_ll, jpvt_ll, tau_ll, vn1_ll, vn2_ll, work_ll);

  for (i_loc=0; i_loc<m_ls; ++i_loc) m_l[i_loc] = m_ll[i_loc];
  free(m_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, m, m_l, 0);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  for (i_loc=0; i_loc<offset_ls; ++i_loc) offset_l[i_loc] = offset_ll[i_loc];
  free(offset_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, offset, offset_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, a, a_ll, 0);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_l[i_loc] = lda_ll[i_loc];
  free(lda_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, lda, lda_l, 0);
  for (i_loc=0; i_loc<jpvt_ls; ++i_loc) jpvt_l[i_loc] = jpvt_ll[i_loc];
  free(jpvt_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, jpvt, jpvt_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, tau, tau_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, vn1, vn1_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, vn2, vn2_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, work, work_ll, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_laqps
(JNIEnv *env, jclass clazz, jintArray m, jintArray n, jintArray offset, jintArray nb, jintArray kb, jdoubleArray a, jintArray lda, jintArray jpvt, jdoubleArray tau, jdoubleArray vn1, jdoubleArray vn2, jdoubleArray auxv, jdoubleArray f, jintArray ldf) {
  int i_loc;
  jint* m_l;
  integer* m_ll;
  jsize m_ls;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jint* offset_l;
  integer* offset_ll;
  jsize offset_ls;
  jint* nb_l;
  integer* nb_ll;
  jsize nb_ls;
  jint* kb_l;
  integer* kb_ll;
  jsize kb_ls;
  jdouble* a_ll;
  jint* lda_l;
  integer* lda_ll;
  jsize lda_ls;
  jint* jpvt_l;
  integer* jpvt_ll;
  jsize jpvt_ls;
  jdouble* tau_ll;
  jdouble* vn1_ll;
  jdouble* vn2_ll;
  jdouble* auxv_ll;
  jdouble* f_ll;
  jint* ldf_l;
  integer* ldf_ll;
  jsize ldf_ls;
  m_l = (*env)->GetPrimitiveArrayCritical(env, m, NULL);
  m_ls = (*env)->GetArrayLength(env, m);
  m_ll = malloc(sizeof(integer)*m_ls);
  for (i_loc=0; i_loc<m_ls; ++i_loc) m_ll[i_loc] = m_l[i_loc];
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  offset_l = (*env)->GetPrimitiveArrayCritical(env, offset, NULL);
  offset_ls = (*env)->GetArrayLength(env, offset);
  offset_ll = malloc(sizeof(integer)*offset_ls);
  for (i_loc=0; i_loc<offset_ls; ++i_loc) offset_ll[i_loc] = offset_l[i_loc];
  nb_l = (*env)->GetPrimitiveArrayCritical(env, nb, NULL);
  nb_ls = (*env)->GetArrayLength(env, nb);
  nb_ll = malloc(sizeof(integer)*nb_ls);
  for (i_loc=0; i_loc<nb_ls; ++i_loc) nb_ll[i_loc] = nb_l[i_loc];
  kb_l = (*env)->GetPrimitiveArrayCritical(env, kb, NULL);
  kb_ls = (*env)->GetArrayLength(env, kb);
  kb_ll = malloc(sizeof(integer)*kb_ls);
  for (i_loc=0; i_loc<kb_ls; ++i_loc) kb_ll[i_loc] = kb_l[i_loc];
  a_ll = (*env)->GetPrimitiveArrayCritical(env, a, NULL);
  lda_l = (*env)->GetPrimitiveArrayCritical(env, lda, NULL);
  lda_ls = (*env)->GetArrayLength(env, lda);
  lda_ll = malloc(sizeof(integer)*lda_ls);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_ll[i_loc] = lda_l[i_loc];
  jpvt_l = (*env)->GetPrimitiveArrayCritical(env, jpvt, NULL);
  jpvt_ls = (*env)->GetArrayLength(env, jpvt);
  jpvt_ll = malloc(sizeof(integer)*jpvt_ls);
  for (i_loc=0; i_loc<jpvt_ls; ++i_loc) jpvt_ll[i_loc] = jpvt_l[i_loc];
  tau_ll = (*env)->GetPrimitiveArrayCritical(env, tau, NULL);
  vn1_ll = (*env)->GetPrimitiveArrayCritical(env, vn1, NULL);
  vn2_ll = (*env)->GetPrimitiveArrayCritical(env, vn2, NULL);
  auxv_ll = (*env)->GetPrimitiveArrayCritical(env, auxv, NULL);
  f_ll = (*env)->GetPrimitiveArrayCritical(env, f, NULL);
  ldf_l = (*env)->GetPrimitiveArrayCritical(env, ldf, NULL);
  ldf_ls = (*env)->GetArrayLength(env, ldf);
  ldf_ll = malloc(sizeof(integer)*ldf_ls);
  for (i_loc=0; i_loc<ldf_ls; ++i_loc) ldf_ll[i_loc] = ldf_l[i_loc];

  dlaqps_(m_ll, n_ll, offset_ll, nb_ll, kb_ll, a_ll, lda_ll, jpvt_ll, tau_ll, vn1_ll, vn2_ll, auxv_ll, f_ll, ldf_ll);

  for (i_loc=0; i_loc<m_ls; ++i_loc) m_l[i_loc] = m_ll[i_loc];
  free(m_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, m, m_l, 0);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  for (i_loc=0; i_loc<offset_ls; ++i_loc) offset_l[i_loc] = offset_ll[i_loc];
  free(offset_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, offset, offset_l, 0);
  for (i_loc=0; i_loc<nb_ls; ++i_loc) nb_l[i_loc] = nb_ll[i_loc];
  free(nb_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, nb, nb_l, 0);
  for (i_loc=0; i_loc<kb_ls; ++i_loc) kb_l[i_loc] = kb_ll[i_loc];
  free(kb_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, kb, kb_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, a, a_ll, 0);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_l[i_loc] = lda_ll[i_loc];
  free(lda_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, lda, lda_l, 0);
  for (i_loc=0; i_loc<jpvt_ls; ++i_loc) jpvt_l[i_loc] = jpvt_ll[i_loc];
  free(jpvt_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, jpvt, jpvt_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, tau, tau_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, vn1, vn1_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, vn2, vn2_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, auxv, auxv_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, f, f_ll, 0);
  for (i_loc=0; i_loc<ldf_ls; ++i_loc) ldf_l[i_loc] = ldf_ll[i_loc];
  free(ldf_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldf, ldf_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_laqsb
(JNIEnv *env, jclass clazz, jcharArray uplo, jintArray n, jintArray kd, jdoubleArray ab, jintArray ldab, jdoubleArray s, jdoubleArray scond, jdoubleArray amax, jcharArray equed) {
  int i_loc;
  jchar* uplo_l;
  char* uplo_ll;
  jsize uplo_ls;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jint* kd_l;
  integer* kd_ll;
  jsize kd_ls;
  jdouble* ab_ll;
  jint* ldab_l;
  integer* ldab_ll;
  jsize ldab_ls;
  jdouble* s_ll;
  jdouble* scond_ll;
  jdouble* amax_ll;
  jchar* equed_l;
  char* equed_ll;
  jsize equed_ls;
  uplo_l = (*env)->GetPrimitiveArrayCritical(env, uplo, NULL);
  uplo_ls = (*env)->GetArrayLength(env, uplo);
  uplo_ll = malloc(sizeof(char)*uplo_ls);
  for (i_loc=0; i_loc<uplo_ls; ++i_loc) uplo_ll[i_loc] = uplo_l[i_loc];
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  kd_l = (*env)->GetPrimitiveArrayCritical(env, kd, NULL);
  kd_ls = (*env)->GetArrayLength(env, kd);
  kd_ll = malloc(sizeof(integer)*kd_ls);
  for (i_loc=0; i_loc<kd_ls; ++i_loc) kd_ll[i_loc] = kd_l[i_loc];
  ab_ll = (*env)->GetPrimitiveArrayCritical(env, ab, NULL);
  ldab_l = (*env)->GetPrimitiveArrayCritical(env, ldab, NULL);
  ldab_ls = (*env)->GetArrayLength(env, ldab);
  ldab_ll = malloc(sizeof(integer)*ldab_ls);
  for (i_loc=0; i_loc<ldab_ls; ++i_loc) ldab_ll[i_loc] = ldab_l[i_loc];
  s_ll = (*env)->GetPrimitiveArrayCritical(env, s, NULL);
  scond_ll = (*env)->GetPrimitiveArrayCritical(env, scond, NULL);
  amax_ll = (*env)->GetPrimitiveArrayCritical(env, amax, NULL);
  equed_l = (*env)->GetPrimitiveArrayCritical(env, equed, NULL);
  equed_ls = (*env)->GetArrayLength(env, equed);
  equed_ll = malloc(sizeof(char)*equed_ls);
  for (i_loc=0; i_loc<equed_ls; ++i_loc) equed_ll[i_loc] = equed_l[i_loc];

  dlaqsb_(uplo_ll, n_ll, kd_ll, ab_ll, ldab_ll, s_ll, scond_ll, amax_ll, equed_ll);

  for (i_loc=0; i_loc<uplo_ls; ++i_loc) uplo_l[i_loc] = uplo_ll[i_loc];
  free(uplo_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, uplo, uplo_l, 0);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  for (i_loc=0; i_loc<kd_ls; ++i_loc) kd_l[i_loc] = kd_ll[i_loc];
  free(kd_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, kd, kd_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, ab, ab_ll, 0);
  for (i_loc=0; i_loc<ldab_ls; ++i_loc) ldab_l[i_loc] = ldab_ll[i_loc];
  free(ldab_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldab, ldab_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, s, s_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, scond, scond_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, amax, amax_ll, 0);
  for (i_loc=0; i_loc<equed_ls; ++i_loc) equed_l[i_loc] = equed_ll[i_loc];
  free(equed_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, equed, equed_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_laqsp
(JNIEnv *env, jclass clazz, jcharArray uplo, jintArray n, jdoubleArray ap, jdoubleArray s, jdoubleArray scond, jdoubleArray amax, jcharArray equed) {
  int i_loc;
  jchar* uplo_l;
  char* uplo_ll;
  jsize uplo_ls;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jdouble* ap_ll;
  jdouble* s_ll;
  jdouble* scond_ll;
  jdouble* amax_ll;
  jchar* equed_l;
  char* equed_ll;
  jsize equed_ls;
  uplo_l = (*env)->GetPrimitiveArrayCritical(env, uplo, NULL);
  uplo_ls = (*env)->GetArrayLength(env, uplo);
  uplo_ll = malloc(sizeof(char)*uplo_ls);
  for (i_loc=0; i_loc<uplo_ls; ++i_loc) uplo_ll[i_loc] = uplo_l[i_loc];
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  ap_ll = (*env)->GetPrimitiveArrayCritical(env, ap, NULL);
  s_ll = (*env)->GetPrimitiveArrayCritical(env, s, NULL);
  scond_ll = (*env)->GetPrimitiveArrayCritical(env, scond, NULL);
  amax_ll = (*env)->GetPrimitiveArrayCritical(env, amax, NULL);
  equed_l = (*env)->GetPrimitiveArrayCritical(env, equed, NULL);
  equed_ls = (*env)->GetArrayLength(env, equed);
  equed_ll = malloc(sizeof(char)*equed_ls);
  for (i_loc=0; i_loc<equed_ls; ++i_loc) equed_ll[i_loc] = equed_l[i_loc];

  dlaqsp_(uplo_ll, n_ll, ap_ll, s_ll, scond_ll, amax_ll, equed_ll);

  for (i_loc=0; i_loc<uplo_ls; ++i_loc) uplo_l[i_loc] = uplo_ll[i_loc];
  free(uplo_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, uplo, uplo_l, 0);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, ap, ap_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, s, s_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, scond, scond_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, amax, amax_ll, 0);
  for (i_loc=0; i_loc<equed_ls; ++i_loc) equed_l[i_loc] = equed_ll[i_loc];
  free(equed_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, equed, equed_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_laqsy
(JNIEnv *env, jclass clazz, jcharArray uplo, jintArray n, jdoubleArray a, jintArray lda, jdoubleArray s, jdoubleArray scond, jdoubleArray amax, jcharArray equed) {
  int i_loc;
  jchar* uplo_l;
  char* uplo_ll;
  jsize uplo_ls;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jdouble* a_ll;
  jint* lda_l;
  integer* lda_ll;
  jsize lda_ls;
  jdouble* s_ll;
  jdouble* scond_ll;
  jdouble* amax_ll;
  jchar* equed_l;
  char* equed_ll;
  jsize equed_ls;
  uplo_l = (*env)->GetPrimitiveArrayCritical(env, uplo, NULL);
  uplo_ls = (*env)->GetArrayLength(env, uplo);
  uplo_ll = malloc(sizeof(char)*uplo_ls);
  for (i_loc=0; i_loc<uplo_ls; ++i_loc) uplo_ll[i_loc] = uplo_l[i_loc];
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  a_ll = (*env)->GetPrimitiveArrayCritical(env, a, NULL);
  lda_l = (*env)->GetPrimitiveArrayCritical(env, lda, NULL);
  lda_ls = (*env)->GetArrayLength(env, lda);
  lda_ll = malloc(sizeof(integer)*lda_ls);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_ll[i_loc] = lda_l[i_loc];
  s_ll = (*env)->GetPrimitiveArrayCritical(env, s, NULL);
  scond_ll = (*env)->GetPrimitiveArrayCritical(env, scond, NULL);
  amax_ll = (*env)->GetPrimitiveArrayCritical(env, amax, NULL);
  equed_l = (*env)->GetPrimitiveArrayCritical(env, equed, NULL);
  equed_ls = (*env)->GetArrayLength(env, equed);
  equed_ll = malloc(sizeof(char)*equed_ls);
  for (i_loc=0; i_loc<equed_ls; ++i_loc) equed_ll[i_loc] = equed_l[i_loc];

  dlaqsy_(uplo_ll, n_ll, a_ll, lda_ll, s_ll, scond_ll, amax_ll, equed_ll);

  for (i_loc=0; i_loc<uplo_ls; ++i_loc) uplo_l[i_loc] = uplo_ll[i_loc];
  free(uplo_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, uplo, uplo_l, 0);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, a, a_ll, 0);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_l[i_loc] = lda_ll[i_loc];
  free(lda_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, lda, lda_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, s, s_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, scond, scond_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, amax, amax_ll, 0);
  for (i_loc=0; i_loc<equed_ls; ++i_loc) equed_l[i_loc] = equed_ll[i_loc];
  free(equed_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, equed, equed_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_laqtr
(JNIEnv *env, jclass clazz, jbooleanArray ltran, jbooleanArray lreal, jintArray n, jdoubleArray t, jintArray ldt, jdoubleArray b, jdoubleArray w, jdoubleArray scale, jdoubleArray x, jdoubleArray work, jintArray info) {
  int i_loc;
  jboolean* ltran_l;
  integer* ltran_ll;
  jsize ltran_ls;
  jboolean* lreal_l;
  integer* lreal_ll;
  jsize lreal_ls;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jdouble* t_ll;
  jint* ldt_l;
  integer* ldt_ll;
  jsize ldt_ls;
  jdouble* b_ll;
  jdouble* w_ll;
  jdouble* scale_ll;
  jdouble* x_ll;
  jdouble* work_ll;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  ltran_l = (*env)->GetPrimitiveArrayCritical(env, ltran, NULL);
  ltran_ls = (*env)->GetArrayLength(env, ltran);
  ltran_ll = malloc(sizeof(integer)*ltran_ls);
  for (i_loc=0; i_loc<ltran_ls; ++i_loc) ltran_ll[i_loc] = ltran_l[i_loc];
  lreal_l = (*env)->GetPrimitiveArrayCritical(env, lreal, NULL);
  lreal_ls = (*env)->GetArrayLength(env, lreal);
  lreal_ll = malloc(sizeof(integer)*lreal_ls);
  for (i_loc=0; i_loc<lreal_ls; ++i_loc) lreal_ll[i_loc] = lreal_l[i_loc];
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  t_ll = (*env)->GetPrimitiveArrayCritical(env, t, NULL);
  ldt_l = (*env)->GetPrimitiveArrayCritical(env, ldt, NULL);
  ldt_ls = (*env)->GetArrayLength(env, ldt);
  ldt_ll = malloc(sizeof(integer)*ldt_ls);
  for (i_loc=0; i_loc<ldt_ls; ++i_loc) ldt_ll[i_loc] = ldt_l[i_loc];
  b_ll = (*env)->GetPrimitiveArrayCritical(env, b, NULL);
  w_ll = (*env)->GetPrimitiveArrayCritical(env, w, NULL);
  scale_ll = (*env)->GetPrimitiveArrayCritical(env, scale, NULL);
  x_ll = (*env)->GetPrimitiveArrayCritical(env, x, NULL);
  work_ll = (*env)->GetPrimitiveArrayCritical(env, work, NULL);
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dlaqtr_(ltran_ll, lreal_ll, n_ll, t_ll, ldt_ll, b_ll, w_ll, scale_ll, x_ll, work_ll, info_ll);

  for (i_loc=0; i_loc<ltran_ls; ++i_loc) ltran_l[i_loc] = ltran_ll[i_loc];
  free(ltran_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ltran, ltran_l, 0);
  for (i_loc=0; i_loc<lreal_ls; ++i_loc) lreal_l[i_loc] = lreal_ll[i_loc];
  free(lreal_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, lreal, lreal_l, 0);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, t, t_ll, 0);
  for (i_loc=0; i_loc<ldt_ls; ++i_loc) ldt_l[i_loc] = ldt_ll[i_loc];
  free(ldt_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldt, ldt_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, b, b_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, w, w_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, scale, scale_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, x, x_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, work, work_ll, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_lar1v
(JNIEnv *env, jclass clazz, jintArray n, jintArray b1, jintArray bn, jdoubleArray sigma, jdoubleArray d, jdoubleArray l, jdoubleArray ld, jdoubleArray lld, jdoubleArray gersch, jdoubleArray z, jdoubleArray ztz, jdoubleArray mingma, jintArray r, jintArray isuppz, jdoubleArray work) {
  int i_loc;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jint* b1_l;
  integer* b1_ll;
  jsize b1_ls;
  jint* bn_l;
  integer* bn_ll;
  jsize bn_ls;
  jdouble* sigma_ll;
  jdouble* d_ll;
  jdouble* l_ll;
  jdouble* ld_ll;
  jdouble* lld_ll;
  jdouble* gersch_ll;
  jdouble* z_ll;
  jdouble* ztz_ll;
  jdouble* mingma_ll;
  jint* r_l;
  integer* r_ll;
  jsize r_ls;
  jint* isuppz_l;
  integer* isuppz_ll;
  jsize isuppz_ls;
  jdouble* work_ll;
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  b1_l = (*env)->GetPrimitiveArrayCritical(env, b1, NULL);
  b1_ls = (*env)->GetArrayLength(env, b1);
  b1_ll = malloc(sizeof(integer)*b1_ls);
  for (i_loc=0; i_loc<b1_ls; ++i_loc) b1_ll[i_loc] = b1_l[i_loc];
  bn_l = (*env)->GetPrimitiveArrayCritical(env, bn, NULL);
  bn_ls = (*env)->GetArrayLength(env, bn);
  bn_ll = malloc(sizeof(integer)*bn_ls);
  for (i_loc=0; i_loc<bn_ls; ++i_loc) bn_ll[i_loc] = bn_l[i_loc];
  sigma_ll = (*env)->GetPrimitiveArrayCritical(env, sigma, NULL);
  d_ll = (*env)->GetPrimitiveArrayCritical(env, d, NULL);
  l_ll = (*env)->GetPrimitiveArrayCritical(env, l, NULL);
  ld_ll = (*env)->GetPrimitiveArrayCritical(env, ld, NULL);
  lld_ll = (*env)->GetPrimitiveArrayCritical(env, lld, NULL);
  gersch_ll = (*env)->GetPrimitiveArrayCritical(env, gersch, NULL);
  z_ll = (*env)->GetPrimitiveArrayCritical(env, z, NULL);
  ztz_ll = (*env)->GetPrimitiveArrayCritical(env, ztz, NULL);
  mingma_ll = (*env)->GetPrimitiveArrayCritical(env, mingma, NULL);
  r_l = (*env)->GetPrimitiveArrayCritical(env, r, NULL);
  r_ls = (*env)->GetArrayLength(env, r);
  r_ll = malloc(sizeof(integer)*r_ls);
  for (i_loc=0; i_loc<r_ls; ++i_loc) r_ll[i_loc] = r_l[i_loc];
  isuppz_l = (*env)->GetPrimitiveArrayCritical(env, isuppz, NULL);
  isuppz_ls = (*env)->GetArrayLength(env, isuppz);
  isuppz_ll = malloc(sizeof(integer)*isuppz_ls);
  for (i_loc=0; i_loc<isuppz_ls; ++i_loc) isuppz_ll[i_loc] = isuppz_l[i_loc];
  work_ll = (*env)->GetPrimitiveArrayCritical(env, work, NULL);

  dlar1v_(n_ll, b1_ll, bn_ll, sigma_ll, d_ll, l_ll, ld_ll, lld_ll, gersch_ll, z_ll, ztz_ll, mingma_ll, r_ll, isuppz_ll, work_ll);

  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  for (i_loc=0; i_loc<b1_ls; ++i_loc) b1_l[i_loc] = b1_ll[i_loc];
  free(b1_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, b1, b1_l, 0);
  for (i_loc=0; i_loc<bn_ls; ++i_loc) bn_l[i_loc] = bn_ll[i_loc];
  free(bn_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, bn, bn_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, sigma, sigma_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, d, d_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, l, l_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, ld, ld_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, lld, lld_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, gersch, gersch_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, z, z_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, ztz, ztz_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, mingma, mingma_ll, 0);
  for (i_loc=0; i_loc<r_ls; ++i_loc) r_l[i_loc] = r_ll[i_loc];
  free(r_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, r, r_l, 0);
  for (i_loc=0; i_loc<isuppz_ls; ++i_loc) isuppz_l[i_loc] = isuppz_ll[i_loc];
  free(isuppz_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, isuppz, isuppz_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, work, work_ll, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_lar2v
(JNIEnv *env, jclass clazz, jintArray n, jdoubleArray x, jdoubleArray y, jdoubleArray z, jintArray incx, jdoubleArray c, jdoubleArray s, jintArray incc) {
  int i_loc;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jdouble* x_ll;
  jdouble* y_ll;
  jdouble* z_ll;
  jint* incx_l;
  integer* incx_ll;
  jsize incx_ls;
  jdouble* c_ll;
  jdouble* s_ll;
  jint* incc_l;
  integer* incc_ll;
  jsize incc_ls;
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  x_ll = (*env)->GetPrimitiveArrayCritical(env, x, NULL);
  y_ll = (*env)->GetPrimitiveArrayCritical(env, y, NULL);
  z_ll = (*env)->GetPrimitiveArrayCritical(env, z, NULL);
  incx_l = (*env)->GetPrimitiveArrayCritical(env, incx, NULL);
  incx_ls = (*env)->GetArrayLength(env, incx);
  incx_ll = malloc(sizeof(integer)*incx_ls);
  for (i_loc=0; i_loc<incx_ls; ++i_loc) incx_ll[i_loc] = incx_l[i_loc];
  c_ll = (*env)->GetPrimitiveArrayCritical(env, c, NULL);
  s_ll = (*env)->GetPrimitiveArrayCritical(env, s, NULL);
  incc_l = (*env)->GetPrimitiveArrayCritical(env, incc, NULL);
  incc_ls = (*env)->GetArrayLength(env, incc);
  incc_ll = malloc(sizeof(integer)*incc_ls);
  for (i_loc=0; i_loc<incc_ls; ++i_loc) incc_ll[i_loc] = incc_l[i_loc];

  dlar2v_(n_ll, x_ll, y_ll, z_ll, incx_ll, c_ll, s_ll, incc_ll);

  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, x, x_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, y, y_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, z, z_ll, 0);
  for (i_loc=0; i_loc<incx_ls; ++i_loc) incx_l[i_loc] = incx_ll[i_loc];
  free(incx_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, incx, incx_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, c, c_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, s, s_ll, 0);
  for (i_loc=0; i_loc<incc_ls; ++i_loc) incc_l[i_loc] = incc_ll[i_loc];
  free(incc_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, incc, incc_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_larf
(JNIEnv *env, jclass clazz, jcharArray side, jintArray m, jintArray n, jdoubleArray v, jintArray incv, jdoubleArray tau, jdoubleArray c, jintArray ldc, jdoubleArray work) {
  int i_loc;
  jchar* side_l;
  char* side_ll;
  jsize side_ls;
  jint* m_l;
  integer* m_ll;
  jsize m_ls;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jdouble* v_ll;
  jint* incv_l;
  integer* incv_ll;
  jsize incv_ls;
  jdouble* tau_ll;
  jdouble* c_ll;
  jint* ldc_l;
  integer* ldc_ll;
  jsize ldc_ls;
  jdouble* work_ll;
  side_l = (*env)->GetPrimitiveArrayCritical(env, side, NULL);
  side_ls = (*env)->GetArrayLength(env, side);
  side_ll = malloc(sizeof(char)*side_ls);
  for (i_loc=0; i_loc<side_ls; ++i_loc) side_ll[i_loc] = side_l[i_loc];
  m_l = (*env)->GetPrimitiveArrayCritical(env, m, NULL);
  m_ls = (*env)->GetArrayLength(env, m);
  m_ll = malloc(sizeof(integer)*m_ls);
  for (i_loc=0; i_loc<m_ls; ++i_loc) m_ll[i_loc] = m_l[i_loc];
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  v_ll = (*env)->GetPrimitiveArrayCritical(env, v, NULL);
  incv_l = (*env)->GetPrimitiveArrayCritical(env, incv, NULL);
  incv_ls = (*env)->GetArrayLength(env, incv);
  incv_ll = malloc(sizeof(integer)*incv_ls);
  for (i_loc=0; i_loc<incv_ls; ++i_loc) incv_ll[i_loc] = incv_l[i_loc];
  tau_ll = (*env)->GetPrimitiveArrayCritical(env, tau, NULL);
  c_ll = (*env)->GetPrimitiveArrayCritical(env, c, NULL);
  ldc_l = (*env)->GetPrimitiveArrayCritical(env, ldc, NULL);
  ldc_ls = (*env)->GetArrayLength(env, ldc);
  ldc_ll = malloc(sizeof(integer)*ldc_ls);
  for (i_loc=0; i_loc<ldc_ls; ++i_loc) ldc_ll[i_loc] = ldc_l[i_loc];
  work_ll = (*env)->GetPrimitiveArrayCritical(env, work, NULL);

  dlarf_(side_ll, m_ll, n_ll, v_ll, incv_ll, tau_ll, c_ll, ldc_ll, work_ll);

  for (i_loc=0; i_loc<side_ls; ++i_loc) side_l[i_loc] = side_ll[i_loc];
  free(side_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, side, side_l, 0);
  for (i_loc=0; i_loc<m_ls; ++i_loc) m_l[i_loc] = m_ll[i_loc];
  free(m_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, m, m_l, 0);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, v, v_ll, 0);
  for (i_loc=0; i_loc<incv_ls; ++i_loc) incv_l[i_loc] = incv_ll[i_loc];
  free(incv_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, incv, incv_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, tau, tau_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, c, c_ll, 0);
  for (i_loc=0; i_loc<ldc_ls; ++i_loc) ldc_l[i_loc] = ldc_ll[i_loc];
  free(ldc_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldc, ldc_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, work, work_ll, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_larfb
(JNIEnv *env, jclass clazz, jcharArray side, jcharArray trans, jcharArray direct, jcharArray storev, jintArray m, jintArray n, jintArray k, jdoubleArray v, jintArray ldv, jdoubleArray t, jintArray ldt, jdoubleArray c, jintArray ldc, jdoubleArray work, jintArray ldwork) {
  int i_loc;
  jchar* side_l;
  char* side_ll;
  jsize side_ls;
  jchar* trans_l;
  char* trans_ll;
  jsize trans_ls;
  jchar* direct_l;
  char* direct_ll;
  jsize direct_ls;
  jchar* storev_l;
  char* storev_ll;
  jsize storev_ls;
  jint* m_l;
  integer* m_ll;
  jsize m_ls;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jint* k_l;
  integer* k_ll;
  jsize k_ls;
  jdouble* v_ll;
  jint* ldv_l;
  integer* ldv_ll;
  jsize ldv_ls;
  jdouble* t_ll;
  jint* ldt_l;
  integer* ldt_ll;
  jsize ldt_ls;
  jdouble* c_ll;
  jint* ldc_l;
  integer* ldc_ll;
  jsize ldc_ls;
  jdouble* work_ll;
  jint* ldwork_l;
  integer* ldwork_ll;
  jsize ldwork_ls;
  side_l = (*env)->GetPrimitiveArrayCritical(env, side, NULL);
  side_ls = (*env)->GetArrayLength(env, side);
  side_ll = malloc(sizeof(char)*side_ls);
  for (i_loc=0; i_loc<side_ls; ++i_loc) side_ll[i_loc] = side_l[i_loc];
  trans_l = (*env)->GetPrimitiveArrayCritical(env, trans, NULL);
  trans_ls = (*env)->GetArrayLength(env, trans);
  trans_ll = malloc(sizeof(char)*trans_ls);
  for (i_loc=0; i_loc<trans_ls; ++i_loc) trans_ll[i_loc] = trans_l[i_loc];
  direct_l = (*env)->GetPrimitiveArrayCritical(env, direct, NULL);
  direct_ls = (*env)->GetArrayLength(env, direct);
  direct_ll = malloc(sizeof(char)*direct_ls);
  for (i_loc=0; i_loc<direct_ls; ++i_loc) direct_ll[i_loc] = direct_l[i_loc];
  storev_l = (*env)->GetPrimitiveArrayCritical(env, storev, NULL);
  storev_ls = (*env)->GetArrayLength(env, storev);
  storev_ll = malloc(sizeof(char)*storev_ls);
  for (i_loc=0; i_loc<storev_ls; ++i_loc) storev_ll[i_loc] = storev_l[i_loc];
  m_l = (*env)->GetPrimitiveArrayCritical(env, m, NULL);
  m_ls = (*env)->GetArrayLength(env, m);
  m_ll = malloc(sizeof(integer)*m_ls);
  for (i_loc=0; i_loc<m_ls; ++i_loc) m_ll[i_loc] = m_l[i_loc];
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  k_l = (*env)->GetPrimitiveArrayCritical(env, k, NULL);
  k_ls = (*env)->GetArrayLength(env, k);
  k_ll = malloc(sizeof(integer)*k_ls);
  for (i_loc=0; i_loc<k_ls; ++i_loc) k_ll[i_loc] = k_l[i_loc];
  v_ll = (*env)->GetPrimitiveArrayCritical(env, v, NULL);
  ldv_l = (*env)->GetPrimitiveArrayCritical(env, ldv, NULL);
  ldv_ls = (*env)->GetArrayLength(env, ldv);
  ldv_ll = malloc(sizeof(integer)*ldv_ls);
  for (i_loc=0; i_loc<ldv_ls; ++i_loc) ldv_ll[i_loc] = ldv_l[i_loc];
  t_ll = (*env)->GetPrimitiveArrayCritical(env, t, NULL);
  ldt_l = (*env)->GetPrimitiveArrayCritical(env, ldt, NULL);
  ldt_ls = (*env)->GetArrayLength(env, ldt);
  ldt_ll = malloc(sizeof(integer)*ldt_ls);
  for (i_loc=0; i_loc<ldt_ls; ++i_loc) ldt_ll[i_loc] = ldt_l[i_loc];
  c_ll = (*env)->GetPrimitiveArrayCritical(env, c, NULL);
  ldc_l = (*env)->GetPrimitiveArrayCritical(env, ldc, NULL);
  ldc_ls = (*env)->GetArrayLength(env, ldc);
  ldc_ll = malloc(sizeof(integer)*ldc_ls);
  for (i_loc=0; i_loc<ldc_ls; ++i_loc) ldc_ll[i_loc] = ldc_l[i_loc];
  work_ll = (*env)->GetPrimitiveArrayCritical(env, work, NULL);
  ldwork_l = (*env)->GetPrimitiveArrayCritical(env, ldwork, NULL);
  ldwork_ls = (*env)->GetArrayLength(env, ldwork);
  ldwork_ll = malloc(sizeof(integer)*ldwork_ls);
  for (i_loc=0; i_loc<ldwork_ls; ++i_loc) ldwork_ll[i_loc] = ldwork_l[i_loc];

  dlarfb_(side_ll, trans_ll, direct_ll, storev_ll, m_ll, n_ll, k_ll, v_ll, ldv_ll, t_ll, ldt_ll, c_ll, ldc_ll, work_ll, ldwork_ll);

  for (i_loc=0; i_loc<side_ls; ++i_loc) side_l[i_loc] = side_ll[i_loc];
  free(side_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, side, side_l, 0);
  for (i_loc=0; i_loc<trans_ls; ++i_loc) trans_l[i_loc] = trans_ll[i_loc];
  free(trans_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, trans, trans_l, 0);
  for (i_loc=0; i_loc<direct_ls; ++i_loc) direct_l[i_loc] = direct_ll[i_loc];
  free(direct_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, direct, direct_l, 0);
  for (i_loc=0; i_loc<storev_ls; ++i_loc) storev_l[i_loc] = storev_ll[i_loc];
  free(storev_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, storev, storev_l, 0);
  for (i_loc=0; i_loc<m_ls; ++i_loc) m_l[i_loc] = m_ll[i_loc];
  free(m_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, m, m_l, 0);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  for (i_loc=0; i_loc<k_ls; ++i_loc) k_l[i_loc] = k_ll[i_loc];
  free(k_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, k, k_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, v, v_ll, 0);
  for (i_loc=0; i_loc<ldv_ls; ++i_loc) ldv_l[i_loc] = ldv_ll[i_loc];
  free(ldv_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldv, ldv_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, t, t_ll, 0);
  for (i_loc=0; i_loc<ldt_ls; ++i_loc) ldt_l[i_loc] = ldt_ll[i_loc];
  free(ldt_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldt, ldt_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, c, c_ll, 0);
  for (i_loc=0; i_loc<ldc_ls; ++i_loc) ldc_l[i_loc] = ldc_ll[i_loc];
  free(ldc_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldc, ldc_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, work, work_ll, 0);
  for (i_loc=0; i_loc<ldwork_ls; ++i_loc) ldwork_l[i_loc] = ldwork_ll[i_loc];
  free(ldwork_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldwork, ldwork_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_larfg
(JNIEnv *env, jclass clazz, jintArray n, jdoubleArray alpha, jdoubleArray x, jintArray incx, jdoubleArray tau) {
  int i_loc;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jdouble* alpha_ll;
  jdouble* x_ll;
  jint* incx_l;
  integer* incx_ll;
  jsize incx_ls;
  jdouble* tau_ll;
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  alpha_ll = (*env)->GetPrimitiveArrayCritical(env, alpha, NULL);
  x_ll = (*env)->GetPrimitiveArrayCritical(env, x, NULL);
  incx_l = (*env)->GetPrimitiveArrayCritical(env, incx, NULL);
  incx_ls = (*env)->GetArrayLength(env, incx);
  incx_ll = malloc(sizeof(integer)*incx_ls);
  for (i_loc=0; i_loc<incx_ls; ++i_loc) incx_ll[i_loc] = incx_l[i_loc];
  tau_ll = (*env)->GetPrimitiveArrayCritical(env, tau, NULL);

  dlarfg_(n_ll, alpha_ll, x_ll, incx_ll, tau_ll);

  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, alpha, alpha_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, x, x_ll, 0);
  for (i_loc=0; i_loc<incx_ls; ++i_loc) incx_l[i_loc] = incx_ll[i_loc];
  free(incx_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, incx, incx_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, tau, tau_ll, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_larft
(JNIEnv *env, jclass clazz, jcharArray direct, jcharArray storev, jintArray n, jintArray k, jdoubleArray v, jintArray ldv, jdoubleArray tau, jdoubleArray t, jintArray ldt) {
  int i_loc;
  jchar* direct_l;
  char* direct_ll;
  jsize direct_ls;
  jchar* storev_l;
  char* storev_ll;
  jsize storev_ls;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jint* k_l;
  integer* k_ll;
  jsize k_ls;
  jdouble* v_ll;
  jint* ldv_l;
  integer* ldv_ll;
  jsize ldv_ls;
  jdouble* tau_ll;
  jdouble* t_ll;
  jint* ldt_l;
  integer* ldt_ll;
  jsize ldt_ls;
  direct_l = (*env)->GetPrimitiveArrayCritical(env, direct, NULL);
  direct_ls = (*env)->GetArrayLength(env, direct);
  direct_ll = malloc(sizeof(char)*direct_ls);
  for (i_loc=0; i_loc<direct_ls; ++i_loc) direct_ll[i_loc] = direct_l[i_loc];
  storev_l = (*env)->GetPrimitiveArrayCritical(env, storev, NULL);
  storev_ls = (*env)->GetArrayLength(env, storev);
  storev_ll = malloc(sizeof(char)*storev_ls);
  for (i_loc=0; i_loc<storev_ls; ++i_loc) storev_ll[i_loc] = storev_l[i_loc];
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  k_l = (*env)->GetPrimitiveArrayCritical(env, k, NULL);
  k_ls = (*env)->GetArrayLength(env, k);
  k_ll = malloc(sizeof(integer)*k_ls);
  for (i_loc=0; i_loc<k_ls; ++i_loc) k_ll[i_loc] = k_l[i_loc];
  v_ll = (*env)->GetPrimitiveArrayCritical(env, v, NULL);
  ldv_l = (*env)->GetPrimitiveArrayCritical(env, ldv, NULL);
  ldv_ls = (*env)->GetArrayLength(env, ldv);
  ldv_ll = malloc(sizeof(integer)*ldv_ls);
  for (i_loc=0; i_loc<ldv_ls; ++i_loc) ldv_ll[i_loc] = ldv_l[i_loc];
  tau_ll = (*env)->GetPrimitiveArrayCritical(env, tau, NULL);
  t_ll = (*env)->GetPrimitiveArrayCritical(env, t, NULL);
  ldt_l = (*env)->GetPrimitiveArrayCritical(env, ldt, NULL);
  ldt_ls = (*env)->GetArrayLength(env, ldt);
  ldt_ll = malloc(sizeof(integer)*ldt_ls);
  for (i_loc=0; i_loc<ldt_ls; ++i_loc) ldt_ll[i_loc] = ldt_l[i_loc];

  dlarft_(direct_ll, storev_ll, n_ll, k_ll, v_ll, ldv_ll, tau_ll, t_ll, ldt_ll);

  for (i_loc=0; i_loc<direct_ls; ++i_loc) direct_l[i_loc] = direct_ll[i_loc];
  free(direct_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, direct, direct_l, 0);
  for (i_loc=0; i_loc<storev_ls; ++i_loc) storev_l[i_loc] = storev_ll[i_loc];
  free(storev_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, storev, storev_l, 0);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  for (i_loc=0; i_loc<k_ls; ++i_loc) k_l[i_loc] = k_ll[i_loc];
  free(k_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, k, k_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, v, v_ll, 0);
  for (i_loc=0; i_loc<ldv_ls; ++i_loc) ldv_l[i_loc] = ldv_ll[i_loc];
  free(ldv_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldv, ldv_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, tau, tau_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, t, t_ll, 0);
  for (i_loc=0; i_loc<ldt_ls; ++i_loc) ldt_l[i_loc] = ldt_ll[i_loc];
  free(ldt_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldt, ldt_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_larfx
(JNIEnv *env, jclass clazz, jcharArray side, jintArray m, jintArray n, jdoubleArray v, jdoubleArray tau, jdoubleArray c, jintArray ldc, jdoubleArray work) {
  int i_loc;
  jchar* side_l;
  char* side_ll;
  jsize side_ls;
  jint* m_l;
  integer* m_ll;
  jsize m_ls;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jdouble* v_ll;
  jdouble* tau_ll;
  jdouble* c_ll;
  jint* ldc_l;
  integer* ldc_ll;
  jsize ldc_ls;
  jdouble* work_ll;
  side_l = (*env)->GetPrimitiveArrayCritical(env, side, NULL);
  side_ls = (*env)->GetArrayLength(env, side);
  side_ll = malloc(sizeof(char)*side_ls);
  for (i_loc=0; i_loc<side_ls; ++i_loc) side_ll[i_loc] = side_l[i_loc];
  m_l = (*env)->GetPrimitiveArrayCritical(env, m, NULL);
  m_ls = (*env)->GetArrayLength(env, m);
  m_ll = malloc(sizeof(integer)*m_ls);
  for (i_loc=0; i_loc<m_ls; ++i_loc) m_ll[i_loc] = m_l[i_loc];
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  v_ll = (*env)->GetPrimitiveArrayCritical(env, v, NULL);
  tau_ll = (*env)->GetPrimitiveArrayCritical(env, tau, NULL);
  c_ll = (*env)->GetPrimitiveArrayCritical(env, c, NULL);
  ldc_l = (*env)->GetPrimitiveArrayCritical(env, ldc, NULL);
  ldc_ls = (*env)->GetArrayLength(env, ldc);
  ldc_ll = malloc(sizeof(integer)*ldc_ls);
  for (i_loc=0; i_loc<ldc_ls; ++i_loc) ldc_ll[i_loc] = ldc_l[i_loc];
  work_ll = (*env)->GetPrimitiveArrayCritical(env, work, NULL);

  dlarfx_(side_ll, m_ll, n_ll, v_ll, tau_ll, c_ll, ldc_ll, work_ll);

  for (i_loc=0; i_loc<side_ls; ++i_loc) side_l[i_loc] = side_ll[i_loc];
  free(side_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, side, side_l, 0);
  for (i_loc=0; i_loc<m_ls; ++i_loc) m_l[i_loc] = m_ll[i_loc];
  free(m_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, m, m_l, 0);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, v, v_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, tau, tau_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, c, c_ll, 0);
  for (i_loc=0; i_loc<ldc_ls; ++i_loc) ldc_l[i_loc] = ldc_ll[i_loc];
  free(ldc_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldc, ldc_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, work, work_ll, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_largv
(JNIEnv *env, jclass clazz, jintArray n, jdoubleArray x, jintArray incx, jdoubleArray y, jintArray incy, jdoubleArray c, jintArray incc) {
  int i_loc;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jdouble* x_ll;
  jint* incx_l;
  integer* incx_ll;
  jsize incx_ls;
  jdouble* y_ll;
  jint* incy_l;
  integer* incy_ll;
  jsize incy_ls;
  jdouble* c_ll;
  jint* incc_l;
  integer* incc_ll;
  jsize incc_ls;
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  x_ll = (*env)->GetPrimitiveArrayCritical(env, x, NULL);
  incx_l = (*env)->GetPrimitiveArrayCritical(env, incx, NULL);
  incx_ls = (*env)->GetArrayLength(env, incx);
  incx_ll = malloc(sizeof(integer)*incx_ls);
  for (i_loc=0; i_loc<incx_ls; ++i_loc) incx_ll[i_loc] = incx_l[i_loc];
  y_ll = (*env)->GetPrimitiveArrayCritical(env, y, NULL);
  incy_l = (*env)->GetPrimitiveArrayCritical(env, incy, NULL);
  incy_ls = (*env)->GetArrayLength(env, incy);
  incy_ll = malloc(sizeof(integer)*incy_ls);
  for (i_loc=0; i_loc<incy_ls; ++i_loc) incy_ll[i_loc] = incy_l[i_loc];
  c_ll = (*env)->GetPrimitiveArrayCritical(env, c, NULL);
  incc_l = (*env)->GetPrimitiveArrayCritical(env, incc, NULL);
  incc_ls = (*env)->GetArrayLength(env, incc);
  incc_ll = malloc(sizeof(integer)*incc_ls);
  for (i_loc=0; i_loc<incc_ls; ++i_loc) incc_ll[i_loc] = incc_l[i_loc];

  dlargv_(n_ll, x_ll, incx_ll, y_ll, incy_ll, c_ll, incc_ll);

  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, x, x_ll, 0);
  for (i_loc=0; i_loc<incx_ls; ++i_loc) incx_l[i_loc] = incx_ll[i_loc];
  free(incx_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, incx, incx_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, y, y_ll, 0);
  for (i_loc=0; i_loc<incy_ls; ++i_loc) incy_l[i_loc] = incy_ll[i_loc];
  free(incy_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, incy, incy_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, c, c_ll, 0);
  for (i_loc=0; i_loc<incc_ls; ++i_loc) incc_l[i_loc] = incc_ll[i_loc];
  free(incc_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, incc, incc_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_larnv
(JNIEnv *env, jclass clazz, jintArray idist, jintArray iseed, jintArray n, jdoubleArray x) {
  int i_loc;
  jint* idist_l;
  integer* idist_ll;
  jsize idist_ls;
  jint* iseed_l;
  integer* iseed_ll;
  jsize iseed_ls;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jdouble* x_ll;
  idist_l = (*env)->GetPrimitiveArrayCritical(env, idist, NULL);
  idist_ls = (*env)->GetArrayLength(env, idist);
  idist_ll = malloc(sizeof(integer)*idist_ls);
  for (i_loc=0; i_loc<idist_ls; ++i_loc) idist_ll[i_loc] = idist_l[i_loc];
  iseed_l = (*env)->GetPrimitiveArrayCritical(env, iseed, NULL);
  iseed_ls = (*env)->GetArrayLength(env, iseed);
  iseed_ll = malloc(sizeof(integer)*iseed_ls);
  for (i_loc=0; i_loc<iseed_ls; ++i_loc) iseed_ll[i_loc] = iseed_l[i_loc];
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  x_ll = (*env)->GetPrimitiveArrayCritical(env, x, NULL);

  dlarnv_(idist_ll, iseed_ll, n_ll, x_ll);

  for (i_loc=0; i_loc<idist_ls; ++i_loc) idist_l[i_loc] = idist_ll[i_loc];
  free(idist_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, idist, idist_l, 0);
  for (i_loc=0; i_loc<iseed_ls; ++i_loc) iseed_l[i_loc] = iseed_ll[i_loc];
  free(iseed_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, iseed, iseed_l, 0);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, x, x_ll, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_larrb
(JNIEnv *env, jclass clazz, jintArray n, jdoubleArray d, jdoubleArray l, jdoubleArray ld, jdoubleArray lld, jintArray ifirst, jintArray ilast, jdoubleArray sigma, jdoubleArray reltol, jdoubleArray w, jdoubleArray wgap, jdoubleArray werr, jdoubleArray work, jintArray iwork, jintArray info) {
  int i_loc;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jdouble* d_ll;
  jdouble* l_ll;
  jdouble* ld_ll;
  jdouble* lld_ll;
  jint* ifirst_l;
  integer* ifirst_ll;
  jsize ifirst_ls;
  jint* ilast_l;
  integer* ilast_ll;
  jsize ilast_ls;
  jdouble* sigma_ll;
  jdouble* reltol_ll;
  jdouble* w_ll;
  jdouble* wgap_ll;
  jdouble* werr_ll;
  jdouble* work_ll;
  jint* iwork_l;
  integer* iwork_ll;
  jsize iwork_ls;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  d_ll = (*env)->GetPrimitiveArrayCritical(env, d, NULL);
  l_ll = (*env)->GetPrimitiveArrayCritical(env, l, NULL);
  ld_ll = (*env)->GetPrimitiveArrayCritical(env, ld, NULL);
  lld_ll = (*env)->GetPrimitiveArrayCritical(env, lld, NULL);
  ifirst_l = (*env)->GetPrimitiveArrayCritical(env, ifirst, NULL);
  ifirst_ls = (*env)->GetArrayLength(env, ifirst);
  ifirst_ll = malloc(sizeof(integer)*ifirst_ls);
  for (i_loc=0; i_loc<ifirst_ls; ++i_loc) ifirst_ll[i_loc] = ifirst_l[i_loc];
  ilast_l = (*env)->GetPrimitiveArrayCritical(env, ilast, NULL);
  ilast_ls = (*env)->GetArrayLength(env, ilast);
  ilast_ll = malloc(sizeof(integer)*ilast_ls);
  for (i_loc=0; i_loc<ilast_ls; ++i_loc) ilast_ll[i_loc] = ilast_l[i_loc];
  sigma_ll = (*env)->GetPrimitiveArrayCritical(env, sigma, NULL);
  reltol_ll = (*env)->GetPrimitiveArrayCritical(env, reltol, NULL);
  w_ll = (*env)->GetPrimitiveArrayCritical(env, w, NULL);
  wgap_ll = (*env)->GetPrimitiveArrayCritical(env, wgap, NULL);
  werr_ll = (*env)->GetPrimitiveArrayCritical(env, werr, NULL);
  work_ll = (*env)->GetPrimitiveArrayCritical(env, work, NULL);
  iwork_l = (*env)->GetPrimitiveArrayCritical(env, iwork, NULL);
  iwork_ls = (*env)->GetArrayLength(env, iwork);
  iwork_ll = malloc(sizeof(integer)*iwork_ls);
  for (i_loc=0; i_loc<iwork_ls; ++i_loc) iwork_ll[i_loc] = iwork_l[i_loc];
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dlarrb_(n_ll, d_ll, l_ll, ld_ll, lld_ll, ifirst_ll, ilast_ll, sigma_ll, reltol_ll, w_ll, wgap_ll, werr_ll, work_ll, iwork_ll, info_ll);

  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, d, d_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, l, l_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, ld, ld_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, lld, lld_ll, 0);
  for (i_loc=0; i_loc<ifirst_ls; ++i_loc) ifirst_l[i_loc] = ifirst_ll[i_loc];
  free(ifirst_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ifirst, ifirst_l, 0);
  for (i_loc=0; i_loc<ilast_ls; ++i_loc) ilast_l[i_loc] = ilast_ll[i_loc];
  free(ilast_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ilast, ilast_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, sigma, sigma_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, reltol, reltol_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, w, w_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, wgap, wgap_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, werr, werr_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, work, work_ll, 0);
  for (i_loc=0; i_loc<iwork_ls; ++i_loc) iwork_l[i_loc] = iwork_ll[i_loc];
  free(iwork_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, iwork, iwork_l, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_larre
(JNIEnv *env, jclass clazz, jintArray n, jdoubleArray d, jdoubleArray e, jdoubleArray tol, jintArray nsplit, jintArray isplit, jintArray m, jdoubleArray w, jdoubleArray woff, jdoubleArray gersch, jdoubleArray work, jintArray info) {
  int i_loc;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jdouble* d_ll;
  jdouble* e_ll;
  jdouble* tol_ll;
  jint* nsplit_l;
  integer* nsplit_ll;
  jsize nsplit_ls;
  jint* isplit_l;
  integer* isplit_ll;
  jsize isplit_ls;
  jint* m_l;
  integer* m_ll;
  jsize m_ls;
  jdouble* w_ll;
  jdouble* woff_ll;
  jdouble* gersch_ll;
  jdouble* work_ll;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  d_ll = (*env)->GetPrimitiveArrayCritical(env, d, NULL);
  e_ll = (*env)->GetPrimitiveArrayCritical(env, e, NULL);
  tol_ll = (*env)->GetPrimitiveArrayCritical(env, tol, NULL);
  nsplit_l = (*env)->GetPrimitiveArrayCritical(env, nsplit, NULL);
  nsplit_ls = (*env)->GetArrayLength(env, nsplit);
  nsplit_ll = malloc(sizeof(integer)*nsplit_ls);
  for (i_loc=0; i_loc<nsplit_ls; ++i_loc) nsplit_ll[i_loc] = nsplit_l[i_loc];
  isplit_l = (*env)->GetPrimitiveArrayCritical(env, isplit, NULL);
  isplit_ls = (*env)->GetArrayLength(env, isplit);
  isplit_ll = malloc(sizeof(integer)*isplit_ls);
  for (i_loc=0; i_loc<isplit_ls; ++i_loc) isplit_ll[i_loc] = isplit_l[i_loc];
  m_l = (*env)->GetPrimitiveArrayCritical(env, m, NULL);
  m_ls = (*env)->GetArrayLength(env, m);
  m_ll = malloc(sizeof(integer)*m_ls);
  for (i_loc=0; i_loc<m_ls; ++i_loc) m_ll[i_loc] = m_l[i_loc];
  w_ll = (*env)->GetPrimitiveArrayCritical(env, w, NULL);
  woff_ll = (*env)->GetPrimitiveArrayCritical(env, woff, NULL);
  gersch_ll = (*env)->GetPrimitiveArrayCritical(env, gersch, NULL);
  work_ll = (*env)->GetPrimitiveArrayCritical(env, work, NULL);
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dlarre_(n_ll, d_ll, e_ll, tol_ll, nsplit_ll, isplit_ll, m_ll, w_ll, woff_ll, gersch_ll, work_ll, info_ll);

  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, d, d_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, e, e_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, tol, tol_ll, 0);
  for (i_loc=0; i_loc<nsplit_ls; ++i_loc) nsplit_l[i_loc] = nsplit_ll[i_loc];
  free(nsplit_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, nsplit, nsplit_l, 0);
  for (i_loc=0; i_loc<isplit_ls; ++i_loc) isplit_l[i_loc] = isplit_ll[i_loc];
  free(isplit_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, isplit, isplit_l, 0);
  for (i_loc=0; i_loc<m_ls; ++i_loc) m_l[i_loc] = m_ll[i_loc];
  free(m_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, m, m_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, w, w_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, woff, woff_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, gersch, gersch_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, work, work_ll, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_larrf
(JNIEnv *env, jclass clazz, jintArray n, jdoubleArray d, jdoubleArray l, jdoubleArray ld, jdoubleArray lld, jintArray ifirst, jintArray ilast, jdoubleArray w, jdoubleArray dplus, jdoubleArray lplus, jdoubleArray work, jintArray iwork, jintArray info) {
  int i_loc;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jdouble* d_ll;
  jdouble* l_ll;
  jdouble* ld_ll;
  jdouble* lld_ll;
  jint* ifirst_l;
  integer* ifirst_ll;
  jsize ifirst_ls;
  jint* ilast_l;
  integer* ilast_ll;
  jsize ilast_ls;
  jdouble* w_ll;
  jdouble* dplus_ll;
  jdouble* lplus_ll;
  jdouble* work_ll;
  jint* iwork_l;
  integer* iwork_ll;
  jsize iwork_ls;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  d_ll = (*env)->GetPrimitiveArrayCritical(env, d, NULL);
  l_ll = (*env)->GetPrimitiveArrayCritical(env, l, NULL);
  ld_ll = (*env)->GetPrimitiveArrayCritical(env, ld, NULL);
  lld_ll = (*env)->GetPrimitiveArrayCritical(env, lld, NULL);
  ifirst_l = (*env)->GetPrimitiveArrayCritical(env, ifirst, NULL);
  ifirst_ls = (*env)->GetArrayLength(env, ifirst);
  ifirst_ll = malloc(sizeof(integer)*ifirst_ls);
  for (i_loc=0; i_loc<ifirst_ls; ++i_loc) ifirst_ll[i_loc] = ifirst_l[i_loc];
  ilast_l = (*env)->GetPrimitiveArrayCritical(env, ilast, NULL);
  ilast_ls = (*env)->GetArrayLength(env, ilast);
  ilast_ll = malloc(sizeof(integer)*ilast_ls);
  for (i_loc=0; i_loc<ilast_ls; ++i_loc) ilast_ll[i_loc] = ilast_l[i_loc];
  w_ll = (*env)->GetPrimitiveArrayCritical(env, w, NULL);
  dplus_ll = (*env)->GetPrimitiveArrayCritical(env, dplus, NULL);
  lplus_ll = (*env)->GetPrimitiveArrayCritical(env, lplus, NULL);
  work_ll = (*env)->GetPrimitiveArrayCritical(env, work, NULL);
  iwork_l = (*env)->GetPrimitiveArrayCritical(env, iwork, NULL);
  iwork_ls = (*env)->GetArrayLength(env, iwork);
  iwork_ll = malloc(sizeof(integer)*iwork_ls);
  for (i_loc=0; i_loc<iwork_ls; ++i_loc) iwork_ll[i_loc] = iwork_l[i_loc];
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dlarrf_(n_ll, d_ll, l_ll, ld_ll, lld_ll, ifirst_ll, ilast_ll, w_ll, dplus_ll, lplus_ll, work_ll, iwork_ll, info_ll);

  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, d, d_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, l, l_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, ld, ld_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, lld, lld_ll, 0);
  for (i_loc=0; i_loc<ifirst_ls; ++i_loc) ifirst_l[i_loc] = ifirst_ll[i_loc];
  free(ifirst_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ifirst, ifirst_l, 0);
  for (i_loc=0; i_loc<ilast_ls; ++i_loc) ilast_l[i_loc] = ilast_ll[i_loc];
  free(ilast_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ilast, ilast_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, w, w_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, dplus, dplus_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, lplus, lplus_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, work, work_ll, 0);
  for (i_loc=0; i_loc<iwork_ls; ++i_loc) iwork_l[i_loc] = iwork_ll[i_loc];
  free(iwork_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, iwork, iwork_l, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_larrv
(JNIEnv *env, jclass clazz, jintArray n, jdoubleArray d, jdoubleArray l, jintArray isplit, jintArray m, jdoubleArray w, jintArray iblock, jdoubleArray gersch, jdoubleArray tol, jdoubleArray z, jintArray ldz, jintArray isuppz, jdoubleArray work, jintArray iwork, jintArray info) {
  int i_loc;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jdouble* d_ll;
  jdouble* l_ll;
  jint* isplit_l;
  integer* isplit_ll;
  jsize isplit_ls;
  jint* m_l;
  integer* m_ll;
  jsize m_ls;
  jdouble* w_ll;
  jint* iblock_l;
  integer* iblock_ll;
  jsize iblock_ls;
  jdouble* gersch_ll;
  jdouble* tol_ll;
  jdouble* z_ll;
  jint* ldz_l;
  integer* ldz_ll;
  jsize ldz_ls;
  jint* isuppz_l;
  integer* isuppz_ll;
  jsize isuppz_ls;
  jdouble* work_ll;
  jint* iwork_l;
  integer* iwork_ll;
  jsize iwork_ls;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  d_ll = (*env)->GetPrimitiveArrayCritical(env, d, NULL);
  l_ll = (*env)->GetPrimitiveArrayCritical(env, l, NULL);
  isplit_l = (*env)->GetPrimitiveArrayCritical(env, isplit, NULL);
  isplit_ls = (*env)->GetArrayLength(env, isplit);
  isplit_ll = malloc(sizeof(integer)*isplit_ls);
  for (i_loc=0; i_loc<isplit_ls; ++i_loc) isplit_ll[i_loc] = isplit_l[i_loc];
  m_l = (*env)->GetPrimitiveArrayCritical(env, m, NULL);
  m_ls = (*env)->GetArrayLength(env, m);
  m_ll = malloc(sizeof(integer)*m_ls);
  for (i_loc=0; i_loc<m_ls; ++i_loc) m_ll[i_loc] = m_l[i_loc];
  w_ll = (*env)->GetPrimitiveArrayCritical(env, w, NULL);
  iblock_l = (*env)->GetPrimitiveArrayCritical(env, iblock, NULL);
  iblock_ls = (*env)->GetArrayLength(env, iblock);
  iblock_ll = malloc(sizeof(integer)*iblock_ls);
  for (i_loc=0; i_loc<iblock_ls; ++i_loc) iblock_ll[i_loc] = iblock_l[i_loc];
  gersch_ll = (*env)->GetPrimitiveArrayCritical(env, gersch, NULL);
  tol_ll = (*env)->GetPrimitiveArrayCritical(env, tol, NULL);
  z_ll = (*env)->GetPrimitiveArrayCritical(env, z, NULL);
  ldz_l = (*env)->GetPrimitiveArrayCritical(env, ldz, NULL);
  ldz_ls = (*env)->GetArrayLength(env, ldz);
  ldz_ll = malloc(sizeof(integer)*ldz_ls);
  for (i_loc=0; i_loc<ldz_ls; ++i_loc) ldz_ll[i_loc] = ldz_l[i_loc];
  isuppz_l = (*env)->GetPrimitiveArrayCritical(env, isuppz, NULL);
  isuppz_ls = (*env)->GetArrayLength(env, isuppz);
  isuppz_ll = malloc(sizeof(integer)*isuppz_ls);
  for (i_loc=0; i_loc<isuppz_ls; ++i_loc) isuppz_ll[i_loc] = isuppz_l[i_loc];
  work_ll = (*env)->GetPrimitiveArrayCritical(env, work, NULL);
  iwork_l = (*env)->GetPrimitiveArrayCritical(env, iwork, NULL);
  iwork_ls = (*env)->GetArrayLength(env, iwork);
  iwork_ll = malloc(sizeof(integer)*iwork_ls);
  for (i_loc=0; i_loc<iwork_ls; ++i_loc) iwork_ll[i_loc] = iwork_l[i_loc];
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dlarrv_(n_ll, d_ll, l_ll, isplit_ll, m_ll, w_ll, iblock_ll, gersch_ll, tol_ll, z_ll, ldz_ll, isuppz_ll, work_ll, iwork_ll, info_ll);

  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, d, d_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, l, l_ll, 0);
  for (i_loc=0; i_loc<isplit_ls; ++i_loc) isplit_l[i_loc] = isplit_ll[i_loc];
  free(isplit_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, isplit, isplit_l, 0);
  for (i_loc=0; i_loc<m_ls; ++i_loc) m_l[i_loc] = m_ll[i_loc];
  free(m_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, m, m_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, w, w_ll, 0);
  for (i_loc=0; i_loc<iblock_ls; ++i_loc) iblock_l[i_loc] = iblock_ll[i_loc];
  free(iblock_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, iblock, iblock_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, gersch, gersch_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, tol, tol_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, z, z_ll, 0);
  for (i_loc=0; i_loc<ldz_ls; ++i_loc) ldz_l[i_loc] = ldz_ll[i_loc];
  free(ldz_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldz, ldz_l, 0);
  for (i_loc=0; i_loc<isuppz_ls; ++i_loc) isuppz_l[i_loc] = isuppz_ll[i_loc];
  free(isuppz_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, isuppz, isuppz_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, work, work_ll, 0);
  for (i_loc=0; i_loc<iwork_ls; ++i_loc) iwork_l[i_loc] = iwork_ll[i_loc];
  free(iwork_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, iwork, iwork_l, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_lartg
(JNIEnv *env, jclass clazz, jdoubleArray f, jdoubleArray g, jdoubleArray cs, jdoubleArray sn, jdoubleArray r) {
  jdouble* f_ll;
  jdouble* g_ll;
  jdouble* cs_ll;
  jdouble* sn_ll;
  jdouble* r_ll;
  f_ll = (*env)->GetPrimitiveArrayCritical(env, f, NULL);
  g_ll = (*env)->GetPrimitiveArrayCritical(env, g, NULL);
  cs_ll = (*env)->GetPrimitiveArrayCritical(env, cs, NULL);
  sn_ll = (*env)->GetPrimitiveArrayCritical(env, sn, NULL);
  r_ll = (*env)->GetPrimitiveArrayCritical(env, r, NULL);

  dlartg_(f_ll, g_ll, cs_ll, sn_ll, r_ll);

  (*env)->ReleasePrimitiveArrayCritical(env, f, f_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, g, g_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, cs, cs_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, sn, sn_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, r, r_ll, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_lartv
(JNIEnv *env, jclass clazz, jintArray n, jdoubleArray x, jintArray incx, jdoubleArray y, jintArray incy, jdoubleArray c, jdoubleArray s, jintArray incc) {
  int i_loc;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jdouble* x_ll;
  jint* incx_l;
  integer* incx_ll;
  jsize incx_ls;
  jdouble* y_ll;
  jint* incy_l;
  integer* incy_ll;
  jsize incy_ls;
  jdouble* c_ll;
  jdouble* s_ll;
  jint* incc_l;
  integer* incc_ll;
  jsize incc_ls;
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  x_ll = (*env)->GetPrimitiveArrayCritical(env, x, NULL);
  incx_l = (*env)->GetPrimitiveArrayCritical(env, incx, NULL);
  incx_ls = (*env)->GetArrayLength(env, incx);
  incx_ll = malloc(sizeof(integer)*incx_ls);
  for (i_loc=0; i_loc<incx_ls; ++i_loc) incx_ll[i_loc] = incx_l[i_loc];
  y_ll = (*env)->GetPrimitiveArrayCritical(env, y, NULL);
  incy_l = (*env)->GetPrimitiveArrayCritical(env, incy, NULL);
  incy_ls = (*env)->GetArrayLength(env, incy);
  incy_ll = malloc(sizeof(integer)*incy_ls);
  for (i_loc=0; i_loc<incy_ls; ++i_loc) incy_ll[i_loc] = incy_l[i_loc];
  c_ll = (*env)->GetPrimitiveArrayCritical(env, c, NULL);
  s_ll = (*env)->GetPrimitiveArrayCritical(env, s, NULL);
  incc_l = (*env)->GetPrimitiveArrayCritical(env, incc, NULL);
  incc_ls = (*env)->GetArrayLength(env, incc);
  incc_ll = malloc(sizeof(integer)*incc_ls);
  for (i_loc=0; i_loc<incc_ls; ++i_loc) incc_ll[i_loc] = incc_l[i_loc];

  dlartv_(n_ll, x_ll, incx_ll, y_ll, incy_ll, c_ll, s_ll, incc_ll);

  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, x, x_ll, 0);
  for (i_loc=0; i_loc<incx_ls; ++i_loc) incx_l[i_loc] = incx_ll[i_loc];
  free(incx_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, incx, incx_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, y, y_ll, 0);
  for (i_loc=0; i_loc<incy_ls; ++i_loc) incy_l[i_loc] = incy_ll[i_loc];
  free(incy_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, incy, incy_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, c, c_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, s, s_ll, 0);
  for (i_loc=0; i_loc<incc_ls; ++i_loc) incc_l[i_loc] = incc_ll[i_loc];
  free(incc_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, incc, incc_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_laruv
(JNIEnv *env, jclass clazz, jintArray iseed, jintArray n, jdoubleArray x) {
  int i_loc;
  jint* iseed_l;
  integer* iseed_ll;
  jsize iseed_ls;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jdouble* x_ll;
  iseed_l = (*env)->GetPrimitiveArrayCritical(env, iseed, NULL);
  iseed_ls = (*env)->GetArrayLength(env, iseed);
  iseed_ll = malloc(sizeof(integer)*iseed_ls);
  for (i_loc=0; i_loc<iseed_ls; ++i_loc) iseed_ll[i_loc] = iseed_l[i_loc];
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  x_ll = (*env)->GetPrimitiveArrayCritical(env, x, NULL);

  dlaruv_(iseed_ll, n_ll, x_ll);

  for (i_loc=0; i_loc<iseed_ls; ++i_loc) iseed_l[i_loc] = iseed_ll[i_loc];
  free(iseed_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, iseed, iseed_l, 0);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, x, x_ll, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_larz
(JNIEnv *env, jclass clazz, jcharArray side, jintArray m, jintArray n, jintArray l, jdoubleArray v, jintArray incv, jdoubleArray tau, jdoubleArray c, jintArray ldc, jdoubleArray work) {
  int i_loc;
  jchar* side_l;
  char* side_ll;
  jsize side_ls;
  jint* m_l;
  integer* m_ll;
  jsize m_ls;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jint* l_l;
  integer* l_ll;
  jsize l_ls;
  jdouble* v_ll;
  jint* incv_l;
  integer* incv_ll;
  jsize incv_ls;
  jdouble* tau_ll;
  jdouble* c_ll;
  jint* ldc_l;
  integer* ldc_ll;
  jsize ldc_ls;
  jdouble* work_ll;
  side_l = (*env)->GetPrimitiveArrayCritical(env, side, NULL);
  side_ls = (*env)->GetArrayLength(env, side);
  side_ll = malloc(sizeof(char)*side_ls);
  for (i_loc=0; i_loc<side_ls; ++i_loc) side_ll[i_loc] = side_l[i_loc];
  m_l = (*env)->GetPrimitiveArrayCritical(env, m, NULL);
  m_ls = (*env)->GetArrayLength(env, m);
  m_ll = malloc(sizeof(integer)*m_ls);
  for (i_loc=0; i_loc<m_ls; ++i_loc) m_ll[i_loc] = m_l[i_loc];
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  l_l = (*env)->GetPrimitiveArrayCritical(env, l, NULL);
  l_ls = (*env)->GetArrayLength(env, l);
  l_ll = malloc(sizeof(integer)*l_ls);
  for (i_loc=0; i_loc<l_ls; ++i_loc) l_ll[i_loc] = l_l[i_loc];
  v_ll = (*env)->GetPrimitiveArrayCritical(env, v, NULL);
  incv_l = (*env)->GetPrimitiveArrayCritical(env, incv, NULL);
  incv_ls = (*env)->GetArrayLength(env, incv);
  incv_ll = malloc(sizeof(integer)*incv_ls);
  for (i_loc=0; i_loc<incv_ls; ++i_loc) incv_ll[i_loc] = incv_l[i_loc];
  tau_ll = (*env)->GetPrimitiveArrayCritical(env, tau, NULL);
  c_ll = (*env)->GetPrimitiveArrayCritical(env, c, NULL);
  ldc_l = (*env)->GetPrimitiveArrayCritical(env, ldc, NULL);
  ldc_ls = (*env)->GetArrayLength(env, ldc);
  ldc_ll = malloc(sizeof(integer)*ldc_ls);
  for (i_loc=0; i_loc<ldc_ls; ++i_loc) ldc_ll[i_loc] = ldc_l[i_loc];
  work_ll = (*env)->GetPrimitiveArrayCritical(env, work, NULL);

  dlarz_(side_ll, m_ll, n_ll, l_ll, v_ll, incv_ll, tau_ll, c_ll, ldc_ll, work_ll);

  for (i_loc=0; i_loc<side_ls; ++i_loc) side_l[i_loc] = side_ll[i_loc];
  free(side_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, side, side_l, 0);
  for (i_loc=0; i_loc<m_ls; ++i_loc) m_l[i_loc] = m_ll[i_loc];
  free(m_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, m, m_l, 0);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  for (i_loc=0; i_loc<l_ls; ++i_loc) l_l[i_loc] = l_ll[i_loc];
  free(l_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, l, l_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, v, v_ll, 0);
  for (i_loc=0; i_loc<incv_ls; ++i_loc) incv_l[i_loc] = incv_ll[i_loc];
  free(incv_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, incv, incv_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, tau, tau_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, c, c_ll, 0);
  for (i_loc=0; i_loc<ldc_ls; ++i_loc) ldc_l[i_loc] = ldc_ll[i_loc];
  free(ldc_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldc, ldc_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, work, work_ll, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_larzb
(JNIEnv *env, jclass clazz, jcharArray side, jcharArray trans, jcharArray direct, jcharArray storev, jintArray m, jintArray n, jintArray k, jintArray l, jdoubleArray v, jintArray ldv, jdoubleArray t, jintArray ldt, jdoubleArray c, jintArray ldc, jdoubleArray work, jintArray ldwork) {
  int i_loc;
  jchar* side_l;
  char* side_ll;
  jsize side_ls;
  jchar* trans_l;
  char* trans_ll;
  jsize trans_ls;
  jchar* direct_l;
  char* direct_ll;
  jsize direct_ls;
  jchar* storev_l;
  char* storev_ll;
  jsize storev_ls;
  jint* m_l;
  integer* m_ll;
  jsize m_ls;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jint* k_l;
  integer* k_ll;
  jsize k_ls;
  jint* l_l;
  integer* l_ll;
  jsize l_ls;
  jdouble* v_ll;
  jint* ldv_l;
  integer* ldv_ll;
  jsize ldv_ls;
  jdouble* t_ll;
  jint* ldt_l;
  integer* ldt_ll;
  jsize ldt_ls;
  jdouble* c_ll;
  jint* ldc_l;
  integer* ldc_ll;
  jsize ldc_ls;
  jdouble* work_ll;
  jint* ldwork_l;
  integer* ldwork_ll;
  jsize ldwork_ls;
  side_l = (*env)->GetPrimitiveArrayCritical(env, side, NULL);
  side_ls = (*env)->GetArrayLength(env, side);
  side_ll = malloc(sizeof(char)*side_ls);
  for (i_loc=0; i_loc<side_ls; ++i_loc) side_ll[i_loc] = side_l[i_loc];
  trans_l = (*env)->GetPrimitiveArrayCritical(env, trans, NULL);
  trans_ls = (*env)->GetArrayLength(env, trans);
  trans_ll = malloc(sizeof(char)*trans_ls);
  for (i_loc=0; i_loc<trans_ls; ++i_loc) trans_ll[i_loc] = trans_l[i_loc];
  direct_l = (*env)->GetPrimitiveArrayCritical(env, direct, NULL);
  direct_ls = (*env)->GetArrayLength(env, direct);
  direct_ll = malloc(sizeof(char)*direct_ls);
  for (i_loc=0; i_loc<direct_ls; ++i_loc) direct_ll[i_loc] = direct_l[i_loc];
  storev_l = (*env)->GetPrimitiveArrayCritical(env, storev, NULL);
  storev_ls = (*env)->GetArrayLength(env, storev);
  storev_ll = malloc(sizeof(char)*storev_ls);
  for (i_loc=0; i_loc<storev_ls; ++i_loc) storev_ll[i_loc] = storev_l[i_loc];
  m_l = (*env)->GetPrimitiveArrayCritical(env, m, NULL);
  m_ls = (*env)->GetArrayLength(env, m);
  m_ll = malloc(sizeof(integer)*m_ls);
  for (i_loc=0; i_loc<m_ls; ++i_loc) m_ll[i_loc] = m_l[i_loc];
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  k_l = (*env)->GetPrimitiveArrayCritical(env, k, NULL);
  k_ls = (*env)->GetArrayLength(env, k);
  k_ll = malloc(sizeof(integer)*k_ls);
  for (i_loc=0; i_loc<k_ls; ++i_loc) k_ll[i_loc] = k_l[i_loc];
  l_l = (*env)->GetPrimitiveArrayCritical(env, l, NULL);
  l_ls = (*env)->GetArrayLength(env, l);
  l_ll = malloc(sizeof(integer)*l_ls);
  for (i_loc=0; i_loc<l_ls; ++i_loc) l_ll[i_loc] = l_l[i_loc];
  v_ll = (*env)->GetPrimitiveArrayCritical(env, v, NULL);
  ldv_l = (*env)->GetPrimitiveArrayCritical(env, ldv, NULL);
  ldv_ls = (*env)->GetArrayLength(env, ldv);
  ldv_ll = malloc(sizeof(integer)*ldv_ls);
  for (i_loc=0; i_loc<ldv_ls; ++i_loc) ldv_ll[i_loc] = ldv_l[i_loc];
  t_ll = (*env)->GetPrimitiveArrayCritical(env, t, NULL);
  ldt_l = (*env)->GetPrimitiveArrayCritical(env, ldt, NULL);
  ldt_ls = (*env)->GetArrayLength(env, ldt);
  ldt_ll = malloc(sizeof(integer)*ldt_ls);
  for (i_loc=0; i_loc<ldt_ls; ++i_loc) ldt_ll[i_loc] = ldt_l[i_loc];
  c_ll = (*env)->GetPrimitiveArrayCritical(env, c, NULL);
  ldc_l = (*env)->GetPrimitiveArrayCritical(env, ldc, NULL);
  ldc_ls = (*env)->GetArrayLength(env, ldc);
  ldc_ll = malloc(sizeof(integer)*ldc_ls);
  for (i_loc=0; i_loc<ldc_ls; ++i_loc) ldc_ll[i_loc] = ldc_l[i_loc];
  work_ll = (*env)->GetPrimitiveArrayCritical(env, work, NULL);
  ldwork_l = (*env)->GetPrimitiveArrayCritical(env, ldwork, NULL);
  ldwork_ls = (*env)->GetArrayLength(env, ldwork);
  ldwork_ll = malloc(sizeof(integer)*ldwork_ls);
  for (i_loc=0; i_loc<ldwork_ls; ++i_loc) ldwork_ll[i_loc] = ldwork_l[i_loc];

  dlarzb_(side_ll, trans_ll, direct_ll, storev_ll, m_ll, n_ll, k_ll, l_ll, v_ll, ldv_ll, t_ll, ldt_ll, c_ll, ldc_ll, work_ll, ldwork_ll);

  for (i_loc=0; i_loc<side_ls; ++i_loc) side_l[i_loc] = side_ll[i_loc];
  free(side_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, side, side_l, 0);
  for (i_loc=0; i_loc<trans_ls; ++i_loc) trans_l[i_loc] = trans_ll[i_loc];
  free(trans_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, trans, trans_l, 0);
  for (i_loc=0; i_loc<direct_ls; ++i_loc) direct_l[i_loc] = direct_ll[i_loc];
  free(direct_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, direct, direct_l, 0);
  for (i_loc=0; i_loc<storev_ls; ++i_loc) storev_l[i_loc] = storev_ll[i_loc];
  free(storev_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, storev, storev_l, 0);
  for (i_loc=0; i_loc<m_ls; ++i_loc) m_l[i_loc] = m_ll[i_loc];
  free(m_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, m, m_l, 0);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  for (i_loc=0; i_loc<k_ls; ++i_loc) k_l[i_loc] = k_ll[i_loc];
  free(k_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, k, k_l, 0);
  for (i_loc=0; i_loc<l_ls; ++i_loc) l_l[i_loc] = l_ll[i_loc];
  free(l_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, l, l_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, v, v_ll, 0);
  for (i_loc=0; i_loc<ldv_ls; ++i_loc) ldv_l[i_loc] = ldv_ll[i_loc];
  free(ldv_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldv, ldv_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, t, t_ll, 0);
  for (i_loc=0; i_loc<ldt_ls; ++i_loc) ldt_l[i_loc] = ldt_ll[i_loc];
  free(ldt_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldt, ldt_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, c, c_ll, 0);
  for (i_loc=0; i_loc<ldc_ls; ++i_loc) ldc_l[i_loc] = ldc_ll[i_loc];
  free(ldc_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldc, ldc_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, work, work_ll, 0);
  for (i_loc=0; i_loc<ldwork_ls; ++i_loc) ldwork_l[i_loc] = ldwork_ll[i_loc];
  free(ldwork_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldwork, ldwork_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_larzt
(JNIEnv *env, jclass clazz, jcharArray direct, jcharArray storev, jintArray n, jintArray k, jdoubleArray v, jintArray ldv, jdoubleArray tau, jdoubleArray t, jintArray ldt) {
  int i_loc;
  jchar* direct_l;
  char* direct_ll;
  jsize direct_ls;
  jchar* storev_l;
  char* storev_ll;
  jsize storev_ls;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jint* k_l;
  integer* k_ll;
  jsize k_ls;
  jdouble* v_ll;
  jint* ldv_l;
  integer* ldv_ll;
  jsize ldv_ls;
  jdouble* tau_ll;
  jdouble* t_ll;
  jint* ldt_l;
  integer* ldt_ll;
  jsize ldt_ls;
  direct_l = (*env)->GetPrimitiveArrayCritical(env, direct, NULL);
  direct_ls = (*env)->GetArrayLength(env, direct);
  direct_ll = malloc(sizeof(char)*direct_ls);
  for (i_loc=0; i_loc<direct_ls; ++i_loc) direct_ll[i_loc] = direct_l[i_loc];
  storev_l = (*env)->GetPrimitiveArrayCritical(env, storev, NULL);
  storev_ls = (*env)->GetArrayLength(env, storev);
  storev_ll = malloc(sizeof(char)*storev_ls);
  for (i_loc=0; i_loc<storev_ls; ++i_loc) storev_ll[i_loc] = storev_l[i_loc];
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  k_l = (*env)->GetPrimitiveArrayCritical(env, k, NULL);
  k_ls = (*env)->GetArrayLength(env, k);
  k_ll = malloc(sizeof(integer)*k_ls);
  for (i_loc=0; i_loc<k_ls; ++i_loc) k_ll[i_loc] = k_l[i_loc];
  v_ll = (*env)->GetPrimitiveArrayCritical(env, v, NULL);
  ldv_l = (*env)->GetPrimitiveArrayCritical(env, ldv, NULL);
  ldv_ls = (*env)->GetArrayLength(env, ldv);
  ldv_ll = malloc(sizeof(integer)*ldv_ls);
  for (i_loc=0; i_loc<ldv_ls; ++i_loc) ldv_ll[i_loc] = ldv_l[i_loc];
  tau_ll = (*env)->GetPrimitiveArrayCritical(env, tau, NULL);
  t_ll = (*env)->GetPrimitiveArrayCritical(env, t, NULL);
  ldt_l = (*env)->GetPrimitiveArrayCritical(env, ldt, NULL);
  ldt_ls = (*env)->GetArrayLength(env, ldt);
  ldt_ll = malloc(sizeof(integer)*ldt_ls);
  for (i_loc=0; i_loc<ldt_ls; ++i_loc) ldt_ll[i_loc] = ldt_l[i_loc];

  dlarzt_(direct_ll, storev_ll, n_ll, k_ll, v_ll, ldv_ll, tau_ll, t_ll, ldt_ll);

  for (i_loc=0; i_loc<direct_ls; ++i_loc) direct_l[i_loc] = direct_ll[i_loc];
  free(direct_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, direct, direct_l, 0);
  for (i_loc=0; i_loc<storev_ls; ++i_loc) storev_l[i_loc] = storev_ll[i_loc];
  free(storev_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, storev, storev_l, 0);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  for (i_loc=0; i_loc<k_ls; ++i_loc) k_l[i_loc] = k_ll[i_loc];
  free(k_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, k, k_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, v, v_ll, 0);
  for (i_loc=0; i_loc<ldv_ls; ++i_loc) ldv_l[i_loc] = ldv_ll[i_loc];
  free(ldv_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldv, ldv_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, tau, tau_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, t, t_ll, 0);
  for (i_loc=0; i_loc<ldt_ls; ++i_loc) ldt_l[i_loc] = ldt_ll[i_loc];
  free(ldt_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldt, ldt_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_las2
(JNIEnv *env, jclass clazz, jdoubleArray f, jdoubleArray g, jdoubleArray h, jdoubleArray ssmin, jdoubleArray ssmax) {
  jdouble* f_ll;
  jdouble* g_ll;
  jdouble* h_ll;
  jdouble* ssmin_ll;
  jdouble* ssmax_ll;
  f_ll = (*env)->GetPrimitiveArrayCritical(env, f, NULL);
  g_ll = (*env)->GetPrimitiveArrayCritical(env, g, NULL);
  h_ll = (*env)->GetPrimitiveArrayCritical(env, h, NULL);
  ssmin_ll = (*env)->GetPrimitiveArrayCritical(env, ssmin, NULL);
  ssmax_ll = (*env)->GetPrimitiveArrayCritical(env, ssmax, NULL);

  dlas2_(f_ll, g_ll, h_ll, ssmin_ll, ssmax_ll);

  (*env)->ReleasePrimitiveArrayCritical(env, f, f_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, g, g_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, h, h_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, ssmin, ssmin_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, ssmax, ssmax_ll, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_lascl
(JNIEnv *env, jclass clazz, jcharArray type, jintArray kl, jintArray ku, jdoubleArray cfrom, jdoubleArray cto, jintArray m, jintArray n, jdoubleArray a, jintArray lda, jintArray info) {
  int i_loc;
  jchar* type_l;
  char* type_ll;
  jsize type_ls;
  jint* kl_l;
  integer* kl_ll;
  jsize kl_ls;
  jint* ku_l;
  integer* ku_ll;
  jsize ku_ls;
  jdouble* cfrom_ll;
  jdouble* cto_ll;
  jint* m_l;
  integer* m_ll;
  jsize m_ls;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jdouble* a_ll;
  jint* lda_l;
  integer* lda_ll;
  jsize lda_ls;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  type_l = (*env)->GetPrimitiveArrayCritical(env, type, NULL);
  type_ls = (*env)->GetArrayLength(env, type);
  type_ll = malloc(sizeof(char)*type_ls);
  for (i_loc=0; i_loc<type_ls; ++i_loc) type_ll[i_loc] = type_l[i_loc];
  kl_l = (*env)->GetPrimitiveArrayCritical(env, kl, NULL);
  kl_ls = (*env)->GetArrayLength(env, kl);
  kl_ll = malloc(sizeof(integer)*kl_ls);
  for (i_loc=0; i_loc<kl_ls; ++i_loc) kl_ll[i_loc] = kl_l[i_loc];
  ku_l = (*env)->GetPrimitiveArrayCritical(env, ku, NULL);
  ku_ls = (*env)->GetArrayLength(env, ku);
  ku_ll = malloc(sizeof(integer)*ku_ls);
  for (i_loc=0; i_loc<ku_ls; ++i_loc) ku_ll[i_loc] = ku_l[i_loc];
  cfrom_ll = (*env)->GetPrimitiveArrayCritical(env, cfrom, NULL);
  cto_ll = (*env)->GetPrimitiveArrayCritical(env, cto, NULL);
  m_l = (*env)->GetPrimitiveArrayCritical(env, m, NULL);
  m_ls = (*env)->GetArrayLength(env, m);
  m_ll = malloc(sizeof(integer)*m_ls);
  for (i_loc=0; i_loc<m_ls; ++i_loc) m_ll[i_loc] = m_l[i_loc];
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  a_ll = (*env)->GetPrimitiveArrayCritical(env, a, NULL);
  lda_l = (*env)->GetPrimitiveArrayCritical(env, lda, NULL);
  lda_ls = (*env)->GetArrayLength(env, lda);
  lda_ll = malloc(sizeof(integer)*lda_ls);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_ll[i_loc] = lda_l[i_loc];
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dlascl_(type_ll, kl_ll, ku_ll, cfrom_ll, cto_ll, m_ll, n_ll, a_ll, lda_ll, info_ll);

  for (i_loc=0; i_loc<type_ls; ++i_loc) type_l[i_loc] = type_ll[i_loc];
  free(type_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, type, type_l, 0);
  for (i_loc=0; i_loc<kl_ls; ++i_loc) kl_l[i_loc] = kl_ll[i_loc];
  free(kl_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, kl, kl_l, 0);
  for (i_loc=0; i_loc<ku_ls; ++i_loc) ku_l[i_loc] = ku_ll[i_loc];
  free(ku_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ku, ku_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, cfrom, cfrom_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, cto, cto_ll, 0);
  for (i_loc=0; i_loc<m_ls; ++i_loc) m_l[i_loc] = m_ll[i_loc];
  free(m_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, m, m_l, 0);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, a, a_ll, 0);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_l[i_loc] = lda_ll[i_loc];
  free(lda_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, lda, lda_l, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_lasd0
(JNIEnv *env, jclass clazz, jintArray n, jintArray sqre, jdoubleArray d, jdoubleArray e, jdoubleArray u, jintArray ldu, jdoubleArray vt, jintArray ldvt, jintArray smlsiz, jintArray iwork, jdoubleArray work, jintArray info) {
  int i_loc;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jint* sqre_l;
  integer* sqre_ll;
  jsize sqre_ls;
  jdouble* d_ll;
  jdouble* e_ll;
  jdouble* u_ll;
  jint* ldu_l;
  integer* ldu_ll;
  jsize ldu_ls;
  jdouble* vt_ll;
  jint* ldvt_l;
  integer* ldvt_ll;
  jsize ldvt_ls;
  jint* smlsiz_l;
  integer* smlsiz_ll;
  jsize smlsiz_ls;
  jint* iwork_l;
  integer* iwork_ll;
  jsize iwork_ls;
  jdouble* work_ll;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  sqre_l = (*env)->GetPrimitiveArrayCritical(env, sqre, NULL);
  sqre_ls = (*env)->GetArrayLength(env, sqre);
  sqre_ll = malloc(sizeof(integer)*sqre_ls);
  for (i_loc=0; i_loc<sqre_ls; ++i_loc) sqre_ll[i_loc] = sqre_l[i_loc];
  d_ll = (*env)->GetPrimitiveArrayCritical(env, d, NULL);
  e_ll = (*env)->GetPrimitiveArrayCritical(env, e, NULL);
  u_ll = (*env)->GetPrimitiveArrayCritical(env, u, NULL);
  ldu_l = (*env)->GetPrimitiveArrayCritical(env, ldu, NULL);
  ldu_ls = (*env)->GetArrayLength(env, ldu);
  ldu_ll = malloc(sizeof(integer)*ldu_ls);
  for (i_loc=0; i_loc<ldu_ls; ++i_loc) ldu_ll[i_loc] = ldu_l[i_loc];
  vt_ll = (*env)->GetPrimitiveArrayCritical(env, vt, NULL);
  ldvt_l = (*env)->GetPrimitiveArrayCritical(env, ldvt, NULL);
  ldvt_ls = (*env)->GetArrayLength(env, ldvt);
  ldvt_ll = malloc(sizeof(integer)*ldvt_ls);
  for (i_loc=0; i_loc<ldvt_ls; ++i_loc) ldvt_ll[i_loc] = ldvt_l[i_loc];
  smlsiz_l = (*env)->GetPrimitiveArrayCritical(env, smlsiz, NULL);
  smlsiz_ls = (*env)->GetArrayLength(env, smlsiz);
  smlsiz_ll = malloc(sizeof(integer)*smlsiz_ls);
  for (i_loc=0; i_loc<smlsiz_ls; ++i_loc) smlsiz_ll[i_loc] = smlsiz_l[i_loc];
  iwork_l = (*env)->GetPrimitiveArrayCritical(env, iwork, NULL);
  iwork_ls = (*env)->GetArrayLength(env, iwork);
  iwork_ll = malloc(sizeof(integer)*iwork_ls);
  for (i_loc=0; i_loc<iwork_ls; ++i_loc) iwork_ll[i_loc] = iwork_l[i_loc];
  work_ll = (*env)->GetPrimitiveArrayCritical(env, work, NULL);
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dlasd0_(n_ll, sqre_ll, d_ll, e_ll, u_ll, ldu_ll, vt_ll, ldvt_ll, smlsiz_ll, iwork_ll, work_ll, info_ll);

  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  for (i_loc=0; i_loc<sqre_ls; ++i_loc) sqre_l[i_loc] = sqre_ll[i_loc];
  free(sqre_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, sqre, sqre_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, d, d_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, e, e_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, u, u_ll, 0);
  for (i_loc=0; i_loc<ldu_ls; ++i_loc) ldu_l[i_loc] = ldu_ll[i_loc];
  free(ldu_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldu, ldu_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, vt, vt_ll, 0);
  for (i_loc=0; i_loc<ldvt_ls; ++i_loc) ldvt_l[i_loc] = ldvt_ll[i_loc];
  free(ldvt_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldvt, ldvt_l, 0);
  for (i_loc=0; i_loc<smlsiz_ls; ++i_loc) smlsiz_l[i_loc] = smlsiz_ll[i_loc];
  free(smlsiz_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, smlsiz, smlsiz_l, 0);
  for (i_loc=0; i_loc<iwork_ls; ++i_loc) iwork_l[i_loc] = iwork_ll[i_loc];
  free(iwork_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, iwork, iwork_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, work, work_ll, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_lasd1
(JNIEnv *env, jclass clazz, jintArray nl, jintArray nr, jintArray sqre, jdoubleArray d, jdoubleArray alpha, jdoubleArray beta, jdoubleArray u, jintArray ldu, jdoubleArray vt, jintArray ldvt, jintArray idxq, jintArray iwork, jdoubleArray work, jintArray info) {
  int i_loc;
  jint* nl_l;
  integer* nl_ll;
  jsize nl_ls;
  jint* nr_l;
  integer* nr_ll;
  jsize nr_ls;
  jint* sqre_l;
  integer* sqre_ll;
  jsize sqre_ls;
  jdouble* d_ll;
  jdouble* alpha_ll;
  jdouble* beta_ll;
  jdouble* u_ll;
  jint* ldu_l;
  integer* ldu_ll;
  jsize ldu_ls;
  jdouble* vt_ll;
  jint* ldvt_l;
  integer* ldvt_ll;
  jsize ldvt_ls;
  jint* idxq_l;
  integer* idxq_ll;
  jsize idxq_ls;
  jint* iwork_l;
  integer* iwork_ll;
  jsize iwork_ls;
  jdouble* work_ll;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  nl_l = (*env)->GetPrimitiveArrayCritical(env, nl, NULL);
  nl_ls = (*env)->GetArrayLength(env, nl);
  nl_ll = malloc(sizeof(integer)*nl_ls);
  for (i_loc=0; i_loc<nl_ls; ++i_loc) nl_ll[i_loc] = nl_l[i_loc];
  nr_l = (*env)->GetPrimitiveArrayCritical(env, nr, NULL);
  nr_ls = (*env)->GetArrayLength(env, nr);
  nr_ll = malloc(sizeof(integer)*nr_ls);
  for (i_loc=0; i_loc<nr_ls; ++i_loc) nr_ll[i_loc] = nr_l[i_loc];
  sqre_l = (*env)->GetPrimitiveArrayCritical(env, sqre, NULL);
  sqre_ls = (*env)->GetArrayLength(env, sqre);
  sqre_ll = malloc(sizeof(integer)*sqre_ls);
  for (i_loc=0; i_loc<sqre_ls; ++i_loc) sqre_ll[i_loc] = sqre_l[i_loc];
  d_ll = (*env)->GetPrimitiveArrayCritical(env, d, NULL);
  alpha_ll = (*env)->GetPrimitiveArrayCritical(env, alpha, NULL);
  beta_ll = (*env)->GetPrimitiveArrayCritical(env, beta, NULL);
  u_ll = (*env)->GetPrimitiveArrayCritical(env, u, NULL);
  ldu_l = (*env)->GetPrimitiveArrayCritical(env, ldu, NULL);
  ldu_ls = (*env)->GetArrayLength(env, ldu);
  ldu_ll = malloc(sizeof(integer)*ldu_ls);
  for (i_loc=0; i_loc<ldu_ls; ++i_loc) ldu_ll[i_loc] = ldu_l[i_loc];
  vt_ll = (*env)->GetPrimitiveArrayCritical(env, vt, NULL);
  ldvt_l = (*env)->GetPrimitiveArrayCritical(env, ldvt, NULL);
  ldvt_ls = (*env)->GetArrayLength(env, ldvt);
  ldvt_ll = malloc(sizeof(integer)*ldvt_ls);
  for (i_loc=0; i_loc<ldvt_ls; ++i_loc) ldvt_ll[i_loc] = ldvt_l[i_loc];
  idxq_l = (*env)->GetPrimitiveArrayCritical(env, idxq, NULL);
  idxq_ls = (*env)->GetArrayLength(env, idxq);
  idxq_ll = malloc(sizeof(integer)*idxq_ls);
  for (i_loc=0; i_loc<idxq_ls; ++i_loc) idxq_ll[i_loc] = idxq_l[i_loc];
  iwork_l = (*env)->GetPrimitiveArrayCritical(env, iwork, NULL);
  iwork_ls = (*env)->GetArrayLength(env, iwork);
  iwork_ll = malloc(sizeof(integer)*iwork_ls);
  for (i_loc=0; i_loc<iwork_ls; ++i_loc) iwork_ll[i_loc] = iwork_l[i_loc];
  work_ll = (*env)->GetPrimitiveArrayCritical(env, work, NULL);
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dlasd1_(nl_ll, nr_ll, sqre_ll, d_ll, alpha_ll, beta_ll, u_ll, ldu_ll, vt_ll, ldvt_ll, idxq_ll, iwork_ll, work_ll, info_ll);

  for (i_loc=0; i_loc<nl_ls; ++i_loc) nl_l[i_loc] = nl_ll[i_loc];
  free(nl_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, nl, nl_l, 0);
  for (i_loc=0; i_loc<nr_ls; ++i_loc) nr_l[i_loc] = nr_ll[i_loc];
  free(nr_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, nr, nr_l, 0);
  for (i_loc=0; i_loc<sqre_ls; ++i_loc) sqre_l[i_loc] = sqre_ll[i_loc];
  free(sqre_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, sqre, sqre_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, d, d_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, alpha, alpha_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, beta, beta_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, u, u_ll, 0);
  for (i_loc=0; i_loc<ldu_ls; ++i_loc) ldu_l[i_loc] = ldu_ll[i_loc];
  free(ldu_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldu, ldu_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, vt, vt_ll, 0);
  for (i_loc=0; i_loc<ldvt_ls; ++i_loc) ldvt_l[i_loc] = ldvt_ll[i_loc];
  free(ldvt_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldvt, ldvt_l, 0);
  for (i_loc=0; i_loc<idxq_ls; ++i_loc) idxq_l[i_loc] = idxq_ll[i_loc];
  free(idxq_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, idxq, idxq_l, 0);
  for (i_loc=0; i_loc<iwork_ls; ++i_loc) iwork_l[i_loc] = iwork_ll[i_loc];
  free(iwork_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, iwork, iwork_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, work, work_ll, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_lasd2
(JNIEnv *env, jclass clazz, jintArray nl, jintArray nr, jintArray sqre, jintArray k, jdoubleArray d, jdoubleArray z, jdoubleArray alpha, jdoubleArray beta, jdoubleArray u, jintArray ldu, jdoubleArray vt, jintArray ldvt, jdoubleArray dsigma, jdoubleArray u2, jintArray ldu2, jdoubleArray vt2, jintArray ldvt2, jintArray idxp, jintArray idx, jintArray idxc, jintArray idxq, jintArray coltyp, jintArray info) {
  int i_loc;
  jint* nl_l;
  integer* nl_ll;
  jsize nl_ls;
  jint* nr_l;
  integer* nr_ll;
  jsize nr_ls;
  jint* sqre_l;
  integer* sqre_ll;
  jsize sqre_ls;
  jint* k_l;
  integer* k_ll;
  jsize k_ls;
  jdouble* d_ll;
  jdouble* z_ll;
  jdouble* alpha_ll;
  jdouble* beta_ll;
  jdouble* u_ll;
  jint* ldu_l;
  integer* ldu_ll;
  jsize ldu_ls;
  jdouble* vt_ll;
  jint* ldvt_l;
  integer* ldvt_ll;
  jsize ldvt_ls;
  jdouble* dsigma_ll;
  jdouble* u2_ll;
  jint* ldu2_l;
  integer* ldu2_ll;
  jsize ldu2_ls;
  jdouble* vt2_ll;
  jint* ldvt2_l;
  integer* ldvt2_ll;
  jsize ldvt2_ls;
  jint* idxp_l;
  integer* idxp_ll;
  jsize idxp_ls;
  jint* idx_l;
  integer* idx_ll;
  jsize idx_ls;
  jint* idxc_l;
  integer* idxc_ll;
  jsize idxc_ls;
  jint* idxq_l;
  integer* idxq_ll;
  jsize idxq_ls;
  jint* coltyp_l;
  integer* coltyp_ll;
  jsize coltyp_ls;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  nl_l = (*env)->GetPrimitiveArrayCritical(env, nl, NULL);
  nl_ls = (*env)->GetArrayLength(env, nl);
  nl_ll = malloc(sizeof(integer)*nl_ls);
  for (i_loc=0; i_loc<nl_ls; ++i_loc) nl_ll[i_loc] = nl_l[i_loc];
  nr_l = (*env)->GetPrimitiveArrayCritical(env, nr, NULL);
  nr_ls = (*env)->GetArrayLength(env, nr);
  nr_ll = malloc(sizeof(integer)*nr_ls);
  for (i_loc=0; i_loc<nr_ls; ++i_loc) nr_ll[i_loc] = nr_l[i_loc];
  sqre_l = (*env)->GetPrimitiveArrayCritical(env, sqre, NULL);
  sqre_ls = (*env)->GetArrayLength(env, sqre);
  sqre_ll = malloc(sizeof(integer)*sqre_ls);
  for (i_loc=0; i_loc<sqre_ls; ++i_loc) sqre_ll[i_loc] = sqre_l[i_loc];
  k_l = (*env)->GetPrimitiveArrayCritical(env, k, NULL);
  k_ls = (*env)->GetArrayLength(env, k);
  k_ll = malloc(sizeof(integer)*k_ls);
  for (i_loc=0; i_loc<k_ls; ++i_loc) k_ll[i_loc] = k_l[i_loc];
  d_ll = (*env)->GetPrimitiveArrayCritical(env, d, NULL);
  z_ll = (*env)->GetPrimitiveArrayCritical(env, z, NULL);
  alpha_ll = (*env)->GetPrimitiveArrayCritical(env, alpha, NULL);
  beta_ll = (*env)->GetPrimitiveArrayCritical(env, beta, NULL);
  u_ll = (*env)->GetPrimitiveArrayCritical(env, u, NULL);
  ldu_l = (*env)->GetPrimitiveArrayCritical(env, ldu, NULL);
  ldu_ls = (*env)->GetArrayLength(env, ldu);
  ldu_ll = malloc(sizeof(integer)*ldu_ls);
  for (i_loc=0; i_loc<ldu_ls; ++i_loc) ldu_ll[i_loc] = ldu_l[i_loc];
  vt_ll = (*env)->GetPrimitiveArrayCritical(env, vt, NULL);
  ldvt_l = (*env)->GetPrimitiveArrayCritical(env, ldvt, NULL);
  ldvt_ls = (*env)->GetArrayLength(env, ldvt);
  ldvt_ll = malloc(sizeof(integer)*ldvt_ls);
  for (i_loc=0; i_loc<ldvt_ls; ++i_loc) ldvt_ll[i_loc] = ldvt_l[i_loc];
  dsigma_ll = (*env)->GetPrimitiveArrayCritical(env, dsigma, NULL);
  u2_ll = (*env)->GetPrimitiveArrayCritical(env, u2, NULL);
  ldu2_l = (*env)->GetPrimitiveArrayCritical(env, ldu2, NULL);
  ldu2_ls = (*env)->GetArrayLength(env, ldu2);
  ldu2_ll = malloc(sizeof(integer)*ldu2_ls);
  for (i_loc=0; i_loc<ldu2_ls; ++i_loc) ldu2_ll[i_loc] = ldu2_l[i_loc];
  vt2_ll = (*env)->GetPrimitiveArrayCritical(env, vt2, NULL);
  ldvt2_l = (*env)->GetPrimitiveArrayCritical(env, ldvt2, NULL);
  ldvt2_ls = (*env)->GetArrayLength(env, ldvt2);
  ldvt2_ll = malloc(sizeof(integer)*ldvt2_ls);
  for (i_loc=0; i_loc<ldvt2_ls; ++i_loc) ldvt2_ll[i_loc] = ldvt2_l[i_loc];
  idxp_l = (*env)->GetPrimitiveArrayCritical(env, idxp, NULL);
  idxp_ls = (*env)->GetArrayLength(env, idxp);
  idxp_ll = malloc(sizeof(integer)*idxp_ls);
  for (i_loc=0; i_loc<idxp_ls; ++i_loc) idxp_ll[i_loc] = idxp_l[i_loc];
  idx_l = (*env)->GetPrimitiveArrayCritical(env, idx, NULL);
  idx_ls = (*env)->GetArrayLength(env, idx);
  idx_ll = malloc(sizeof(integer)*idx_ls);
  for (i_loc=0; i_loc<idx_ls; ++i_loc) idx_ll[i_loc] = idx_l[i_loc];
  idxc_l = (*env)->GetPrimitiveArrayCritical(env, idxc, NULL);
  idxc_ls = (*env)->GetArrayLength(env, idxc);
  idxc_ll = malloc(sizeof(integer)*idxc_ls);
  for (i_loc=0; i_loc<idxc_ls; ++i_loc) idxc_ll[i_loc] = idxc_l[i_loc];
  idxq_l = (*env)->GetPrimitiveArrayCritical(env, idxq, NULL);
  idxq_ls = (*env)->GetArrayLength(env, idxq);
  idxq_ll = malloc(sizeof(integer)*idxq_ls);
  for (i_loc=0; i_loc<idxq_ls; ++i_loc) idxq_ll[i_loc] = idxq_l[i_loc];
  coltyp_l = (*env)->GetPrimitiveArrayCritical(env, coltyp, NULL);
  coltyp_ls = (*env)->GetArrayLength(env, coltyp);
  coltyp_ll = malloc(sizeof(integer)*coltyp_ls);
  for (i_loc=0; i_loc<coltyp_ls; ++i_loc) coltyp_ll[i_loc] = coltyp_l[i_loc];
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dlasd2_(nl_ll, nr_ll, sqre_ll, k_ll, d_ll, z_ll, alpha_ll, beta_ll, u_ll, ldu_ll, vt_ll, ldvt_ll, dsigma_ll, u2_ll, ldu2_ll, vt2_ll, ldvt2_ll, idxp_ll, idx_ll, idxc_ll, idxq_ll, coltyp_ll, info_ll);

  for (i_loc=0; i_loc<nl_ls; ++i_loc) nl_l[i_loc] = nl_ll[i_loc];
  free(nl_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, nl, nl_l, 0);
  for (i_loc=0; i_loc<nr_ls; ++i_loc) nr_l[i_loc] = nr_ll[i_loc];
  free(nr_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, nr, nr_l, 0);
  for (i_loc=0; i_loc<sqre_ls; ++i_loc) sqre_l[i_loc] = sqre_ll[i_loc];
  free(sqre_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, sqre, sqre_l, 0);
  for (i_loc=0; i_loc<k_ls; ++i_loc) k_l[i_loc] = k_ll[i_loc];
  free(k_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, k, k_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, d, d_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, z, z_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, alpha, alpha_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, beta, beta_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, u, u_ll, 0);
  for (i_loc=0; i_loc<ldu_ls; ++i_loc) ldu_l[i_loc] = ldu_ll[i_loc];
  free(ldu_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldu, ldu_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, vt, vt_ll, 0);
  for (i_loc=0; i_loc<ldvt_ls; ++i_loc) ldvt_l[i_loc] = ldvt_ll[i_loc];
  free(ldvt_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldvt, ldvt_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, dsigma, dsigma_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, u2, u2_ll, 0);
  for (i_loc=0; i_loc<ldu2_ls; ++i_loc) ldu2_l[i_loc] = ldu2_ll[i_loc];
  free(ldu2_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldu2, ldu2_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, vt2, vt2_ll, 0);
  for (i_loc=0; i_loc<ldvt2_ls; ++i_loc) ldvt2_l[i_loc] = ldvt2_ll[i_loc];
  free(ldvt2_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldvt2, ldvt2_l, 0);
  for (i_loc=0; i_loc<idxp_ls; ++i_loc) idxp_l[i_loc] = idxp_ll[i_loc];
  free(idxp_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, idxp, idxp_l, 0);
  for (i_loc=0; i_loc<idx_ls; ++i_loc) idx_l[i_loc] = idx_ll[i_loc];
  free(idx_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, idx, idx_l, 0);
  for (i_loc=0; i_loc<idxc_ls; ++i_loc) idxc_l[i_loc] = idxc_ll[i_loc];
  free(idxc_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, idxc, idxc_l, 0);
  for (i_loc=0; i_loc<idxq_ls; ++i_loc) idxq_l[i_loc] = idxq_ll[i_loc];
  free(idxq_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, idxq, idxq_l, 0);
  for (i_loc=0; i_loc<coltyp_ls; ++i_loc) coltyp_l[i_loc] = coltyp_ll[i_loc];
  free(coltyp_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, coltyp, coltyp_l, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_lasd3
(JNIEnv *env, jclass clazz, jintArray nl, jintArray nr, jintArray sqre, jintArray k, jdoubleArray d, jdoubleArray q, jintArray ldq, jdoubleArray dsigma, jdoubleArray u, jintArray ldu, jdoubleArray u2, jintArray ldu2, jdoubleArray vt, jintArray ldvt, jdoubleArray vt2, jintArray ldvt2, jintArray idxc, jintArray ctot, jdoubleArray z, jintArray info) {
  int i_loc;
  jint* nl_l;
  integer* nl_ll;
  jsize nl_ls;
  jint* nr_l;
  integer* nr_ll;
  jsize nr_ls;
  jint* sqre_l;
  integer* sqre_ll;
  jsize sqre_ls;
  jint* k_l;
  integer* k_ll;
  jsize k_ls;
  jdouble* d_ll;
  jdouble* q_ll;
  jint* ldq_l;
  integer* ldq_ll;
  jsize ldq_ls;
  jdouble* dsigma_ll;
  jdouble* u_ll;
  jint* ldu_l;
  integer* ldu_ll;
  jsize ldu_ls;
  jdouble* u2_ll;
  jint* ldu2_l;
  integer* ldu2_ll;
  jsize ldu2_ls;
  jdouble* vt_ll;
  jint* ldvt_l;
  integer* ldvt_ll;
  jsize ldvt_ls;
  jdouble* vt2_ll;
  jint* ldvt2_l;
  integer* ldvt2_ll;
  jsize ldvt2_ls;
  jint* idxc_l;
  integer* idxc_ll;
  jsize idxc_ls;
  jint* ctot_l;
  integer* ctot_ll;
  jsize ctot_ls;
  jdouble* z_ll;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  nl_l = (*env)->GetPrimitiveArrayCritical(env, nl, NULL);
  nl_ls = (*env)->GetArrayLength(env, nl);
  nl_ll = malloc(sizeof(integer)*nl_ls);
  for (i_loc=0; i_loc<nl_ls; ++i_loc) nl_ll[i_loc] = nl_l[i_loc];
  nr_l = (*env)->GetPrimitiveArrayCritical(env, nr, NULL);
  nr_ls = (*env)->GetArrayLength(env, nr);
  nr_ll = malloc(sizeof(integer)*nr_ls);
  for (i_loc=0; i_loc<nr_ls; ++i_loc) nr_ll[i_loc] = nr_l[i_loc];
  sqre_l = (*env)->GetPrimitiveArrayCritical(env, sqre, NULL);
  sqre_ls = (*env)->GetArrayLength(env, sqre);
  sqre_ll = malloc(sizeof(integer)*sqre_ls);
  for (i_loc=0; i_loc<sqre_ls; ++i_loc) sqre_ll[i_loc] = sqre_l[i_loc];
  k_l = (*env)->GetPrimitiveArrayCritical(env, k, NULL);
  k_ls = (*env)->GetArrayLength(env, k);
  k_ll = malloc(sizeof(integer)*k_ls);
  for (i_loc=0; i_loc<k_ls; ++i_loc) k_ll[i_loc] = k_l[i_loc];
  d_ll = (*env)->GetPrimitiveArrayCritical(env, d, NULL);
  q_ll = (*env)->GetPrimitiveArrayCritical(env, q, NULL);
  ldq_l = (*env)->GetPrimitiveArrayCritical(env, ldq, NULL);
  ldq_ls = (*env)->GetArrayLength(env, ldq);
  ldq_ll = malloc(sizeof(integer)*ldq_ls);
  for (i_loc=0; i_loc<ldq_ls; ++i_loc) ldq_ll[i_loc] = ldq_l[i_loc];
  dsigma_ll = (*env)->GetPrimitiveArrayCritical(env, dsigma, NULL);
  u_ll = (*env)->GetPrimitiveArrayCritical(env, u, NULL);
  ldu_l = (*env)->GetPrimitiveArrayCritical(env, ldu, NULL);
  ldu_ls = (*env)->GetArrayLength(env, ldu);
  ldu_ll = malloc(sizeof(integer)*ldu_ls);
  for (i_loc=0; i_loc<ldu_ls; ++i_loc) ldu_ll[i_loc] = ldu_l[i_loc];
  u2_ll = (*env)->GetPrimitiveArrayCritical(env, u2, NULL);
  ldu2_l = (*env)->GetPrimitiveArrayCritical(env, ldu2, NULL);
  ldu2_ls = (*env)->GetArrayLength(env, ldu2);
  ldu2_ll = malloc(sizeof(integer)*ldu2_ls);
  for (i_loc=0; i_loc<ldu2_ls; ++i_loc) ldu2_ll[i_loc] = ldu2_l[i_loc];
  vt_ll = (*env)->GetPrimitiveArrayCritical(env, vt, NULL);
  ldvt_l = (*env)->GetPrimitiveArrayCritical(env, ldvt, NULL);
  ldvt_ls = (*env)->GetArrayLength(env, ldvt);
  ldvt_ll = malloc(sizeof(integer)*ldvt_ls);
  for (i_loc=0; i_loc<ldvt_ls; ++i_loc) ldvt_ll[i_loc] = ldvt_l[i_loc];
  vt2_ll = (*env)->GetPrimitiveArrayCritical(env, vt2, NULL);
  ldvt2_l = (*env)->GetPrimitiveArrayCritical(env, ldvt2, NULL);
  ldvt2_ls = (*env)->GetArrayLength(env, ldvt2);
  ldvt2_ll = malloc(sizeof(integer)*ldvt2_ls);
  for (i_loc=0; i_loc<ldvt2_ls; ++i_loc) ldvt2_ll[i_loc] = ldvt2_l[i_loc];
  idxc_l = (*env)->GetPrimitiveArrayCritical(env, idxc, NULL);
  idxc_ls = (*env)->GetArrayLength(env, idxc);
  idxc_ll = malloc(sizeof(integer)*idxc_ls);
  for (i_loc=0; i_loc<idxc_ls; ++i_loc) idxc_ll[i_loc] = idxc_l[i_loc];
  ctot_l = (*env)->GetPrimitiveArrayCritical(env, ctot, NULL);
  ctot_ls = (*env)->GetArrayLength(env, ctot);
  ctot_ll = malloc(sizeof(integer)*ctot_ls);
  for (i_loc=0; i_loc<ctot_ls; ++i_loc) ctot_ll[i_loc] = ctot_l[i_loc];
  z_ll = (*env)->GetPrimitiveArrayCritical(env, z, NULL);
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dlasd3_(nl_ll, nr_ll, sqre_ll, k_ll, d_ll, q_ll, ldq_ll, dsigma_ll, u_ll, ldu_ll, u2_ll, ldu2_ll, vt_ll, ldvt_ll, vt2_ll, ldvt2_ll, idxc_ll, ctot_ll, z_ll, info_ll);

  for (i_loc=0; i_loc<nl_ls; ++i_loc) nl_l[i_loc] = nl_ll[i_loc];
  free(nl_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, nl, nl_l, 0);
  for (i_loc=0; i_loc<nr_ls; ++i_loc) nr_l[i_loc] = nr_ll[i_loc];
  free(nr_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, nr, nr_l, 0);
  for (i_loc=0; i_loc<sqre_ls; ++i_loc) sqre_l[i_loc] = sqre_ll[i_loc];
  free(sqre_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, sqre, sqre_l, 0);
  for (i_loc=0; i_loc<k_ls; ++i_loc) k_l[i_loc] = k_ll[i_loc];
  free(k_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, k, k_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, d, d_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, q, q_ll, 0);
  for (i_loc=0; i_loc<ldq_ls; ++i_loc) ldq_l[i_loc] = ldq_ll[i_loc];
  free(ldq_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldq, ldq_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, dsigma, dsigma_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, u, u_ll, 0);
  for (i_loc=0; i_loc<ldu_ls; ++i_loc) ldu_l[i_loc] = ldu_ll[i_loc];
  free(ldu_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldu, ldu_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, u2, u2_ll, 0);
  for (i_loc=0; i_loc<ldu2_ls; ++i_loc) ldu2_l[i_loc] = ldu2_ll[i_loc];
  free(ldu2_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldu2, ldu2_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, vt, vt_ll, 0);
  for (i_loc=0; i_loc<ldvt_ls; ++i_loc) ldvt_l[i_loc] = ldvt_ll[i_loc];
  free(ldvt_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldvt, ldvt_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, vt2, vt2_ll, 0);
  for (i_loc=0; i_loc<ldvt2_ls; ++i_loc) ldvt2_l[i_loc] = ldvt2_ll[i_loc];
  free(ldvt2_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldvt2, ldvt2_l, 0);
  for (i_loc=0; i_loc<idxc_ls; ++i_loc) idxc_l[i_loc] = idxc_ll[i_loc];
  free(idxc_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, idxc, idxc_l, 0);
  for (i_loc=0; i_loc<ctot_ls; ++i_loc) ctot_l[i_loc] = ctot_ll[i_loc];
  free(ctot_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ctot, ctot_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, z, z_ll, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_lasd4
(JNIEnv *env, jclass clazz, jintArray n, jintArray i, jdoubleArray d, jdoubleArray z, jdoubleArray delta, jdoubleArray rho, jdoubleArray sigma, jdoubleArray work, jintArray info) {
  int i_loc;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jint* i_l;
  integer* i_ll;
  jsize i_ls;
  jdouble* d_ll;
  jdouble* z_ll;
  jdouble* delta_ll;
  jdouble* rho_ll;
  jdouble* sigma_ll;
  jdouble* work_ll;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  i_l = (*env)->GetPrimitiveArrayCritical(env, i, NULL);
  i_ls = (*env)->GetArrayLength(env, i);
  i_ll = malloc(sizeof(integer)*i_ls);
  for (i_loc=0; i_loc<i_ls; ++i_loc) i_ll[i_loc] = i_l[i_loc];
  d_ll = (*env)->GetPrimitiveArrayCritical(env, d, NULL);
  z_ll = (*env)->GetPrimitiveArrayCritical(env, z, NULL);
  delta_ll = (*env)->GetPrimitiveArrayCritical(env, delta, NULL);
  rho_ll = (*env)->GetPrimitiveArrayCritical(env, rho, NULL);
  sigma_ll = (*env)->GetPrimitiveArrayCritical(env, sigma, NULL);
  work_ll = (*env)->GetPrimitiveArrayCritical(env, work, NULL);
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dlasd4_(n_ll, i_ll, d_ll, z_ll, delta_ll, rho_ll, sigma_ll, work_ll, info_ll);

  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  for (i_loc=0; i_loc<i_ls; ++i_loc) i_l[i_loc] = i_ll[i_loc];
  free(i_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, i, i_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, d, d_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, z, z_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, delta, delta_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, rho, rho_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, sigma, sigma_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, work, work_ll, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_lasd5
(JNIEnv *env, jclass clazz, jintArray i, jdoubleArray d, jdoubleArray z, jdoubleArray delta, jdoubleArray rho, jdoubleArray dsigma, jdoubleArray work) {
  int i_loc;
  jint* i_l;
  integer* i_ll;
  jsize i_ls;
  jdouble* d_ll;
  jdouble* z_ll;
  jdouble* delta_ll;
  jdouble* rho_ll;
  jdouble* dsigma_ll;
  jdouble* work_ll;
  i_l = (*env)->GetPrimitiveArrayCritical(env, i, NULL);
  i_ls = (*env)->GetArrayLength(env, i);
  i_ll = malloc(sizeof(integer)*i_ls);
  for (i_loc=0; i_loc<i_ls; ++i_loc) i_ll[i_loc] = i_l[i_loc];
  d_ll = (*env)->GetPrimitiveArrayCritical(env, d, NULL);
  z_ll = (*env)->GetPrimitiveArrayCritical(env, z, NULL);
  delta_ll = (*env)->GetPrimitiveArrayCritical(env, delta, NULL);
  rho_ll = (*env)->GetPrimitiveArrayCritical(env, rho, NULL);
  dsigma_ll = (*env)->GetPrimitiveArrayCritical(env, dsigma, NULL);
  work_ll = (*env)->GetPrimitiveArrayCritical(env, work, NULL);

  dlasd5_(i_ll, d_ll, z_ll, delta_ll, rho_ll, dsigma_ll, work_ll);

  for (i_loc=0; i_loc<i_ls; ++i_loc) i_l[i_loc] = i_ll[i_loc];
  free(i_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, i, i_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, d, d_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, z, z_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, delta, delta_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, rho, rho_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, dsigma, dsigma_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, work, work_ll, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_lasd6
(JNIEnv *env, jclass clazz, jintArray icompq, jintArray nl, jintArray nr, jintArray sqre, jdoubleArray d, jdoubleArray vf, jdoubleArray vl, jdoubleArray alpha, jdoubleArray beta, jintArray idxq, jintArray perm, jintArray givptr, jintArray givcol, jintArray ldgcol, jdoubleArray givnum, jintArray ldgnum, jdoubleArray poles, jdoubleArray difl, jdoubleArray difr, jdoubleArray z, jintArray k, jdoubleArray c, jdoubleArray s, jdoubleArray work, jintArray iwork, jintArray info) {
  int i_loc;
  jint* icompq_l;
  integer* icompq_ll;
  jsize icompq_ls;
  jint* nl_l;
  integer* nl_ll;
  jsize nl_ls;
  jint* nr_l;
  integer* nr_ll;
  jsize nr_ls;
  jint* sqre_l;
  integer* sqre_ll;
  jsize sqre_ls;
  jdouble* d_ll;
  jdouble* vf_ll;
  jdouble* vl_ll;
  jdouble* alpha_ll;
  jdouble* beta_ll;
  jint* idxq_l;
  integer* idxq_ll;
  jsize idxq_ls;
  jint* perm_l;
  integer* perm_ll;
  jsize perm_ls;
  jint* givptr_l;
  integer* givptr_ll;
  jsize givptr_ls;
  jint* givcol_l;
  integer* givcol_ll;
  jsize givcol_ls;
  jint* ldgcol_l;
  integer* ldgcol_ll;
  jsize ldgcol_ls;
  jdouble* givnum_ll;
  jint* ldgnum_l;
  integer* ldgnum_ll;
  jsize ldgnum_ls;
  jdouble* poles_ll;
  jdouble* difl_ll;
  jdouble* difr_ll;
  jdouble* z_ll;
  jint* k_l;
  integer* k_ll;
  jsize k_ls;
  jdouble* c_ll;
  jdouble* s_ll;
  jdouble* work_ll;
  jint* iwork_l;
  integer* iwork_ll;
  jsize iwork_ls;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  icompq_l = (*env)->GetPrimitiveArrayCritical(env, icompq, NULL);
  icompq_ls = (*env)->GetArrayLength(env, icompq);
  icompq_ll = malloc(sizeof(integer)*icompq_ls);
  for (i_loc=0; i_loc<icompq_ls; ++i_loc) icompq_ll[i_loc] = icompq_l[i_loc];
  nl_l = (*env)->GetPrimitiveArrayCritical(env, nl, NULL);
  nl_ls = (*env)->GetArrayLength(env, nl);
  nl_ll = malloc(sizeof(integer)*nl_ls);
  for (i_loc=0; i_loc<nl_ls; ++i_loc) nl_ll[i_loc] = nl_l[i_loc];
  nr_l = (*env)->GetPrimitiveArrayCritical(env, nr, NULL);
  nr_ls = (*env)->GetArrayLength(env, nr);
  nr_ll = malloc(sizeof(integer)*nr_ls);
  for (i_loc=0; i_loc<nr_ls; ++i_loc) nr_ll[i_loc] = nr_l[i_loc];
  sqre_l = (*env)->GetPrimitiveArrayCritical(env, sqre, NULL);
  sqre_ls = (*env)->GetArrayLength(env, sqre);
  sqre_ll = malloc(sizeof(integer)*sqre_ls);
  for (i_loc=0; i_loc<sqre_ls; ++i_loc) sqre_ll[i_loc] = sqre_l[i_loc];
  d_ll = (*env)->GetPrimitiveArrayCritical(env, d, NULL);
  vf_ll = (*env)->GetPrimitiveArrayCritical(env, vf, NULL);
  vl_ll = (*env)->GetPrimitiveArrayCritical(env, vl, NULL);
  alpha_ll = (*env)->GetPrimitiveArrayCritical(env, alpha, NULL);
  beta_ll = (*env)->GetPrimitiveArrayCritical(env, beta, NULL);
  idxq_l = (*env)->GetPrimitiveArrayCritical(env, idxq, NULL);
  idxq_ls = (*env)->GetArrayLength(env, idxq);
  idxq_ll = malloc(sizeof(integer)*idxq_ls);
  for (i_loc=0; i_loc<idxq_ls; ++i_loc) idxq_ll[i_loc] = idxq_l[i_loc];
  perm_l = (*env)->GetPrimitiveArrayCritical(env, perm, NULL);
  perm_ls = (*env)->GetArrayLength(env, perm);
  perm_ll = malloc(sizeof(integer)*perm_ls);
  for (i_loc=0; i_loc<perm_ls; ++i_loc) perm_ll[i_loc] = perm_l[i_loc];
  givptr_l = (*env)->GetPrimitiveArrayCritical(env, givptr, NULL);
  givptr_ls = (*env)->GetArrayLength(env, givptr);
  givptr_ll = malloc(sizeof(integer)*givptr_ls);
  for (i_loc=0; i_loc<givptr_ls; ++i_loc) givptr_ll[i_loc] = givptr_l[i_loc];
  givcol_l = (*env)->GetPrimitiveArrayCritical(env, givcol, NULL);
  givcol_ls = (*env)->GetArrayLength(env, givcol);
  givcol_ll = malloc(sizeof(integer)*givcol_ls);
  for (i_loc=0; i_loc<givcol_ls; ++i_loc) givcol_ll[i_loc] = givcol_l[i_loc];
  ldgcol_l = (*env)->GetPrimitiveArrayCritical(env, ldgcol, NULL);
  ldgcol_ls = (*env)->GetArrayLength(env, ldgcol);
  ldgcol_ll = malloc(sizeof(integer)*ldgcol_ls);
  for (i_loc=0; i_loc<ldgcol_ls; ++i_loc) ldgcol_ll[i_loc] = ldgcol_l[i_loc];
  givnum_ll = (*env)->GetPrimitiveArrayCritical(env, givnum, NULL);
  ldgnum_l = (*env)->GetPrimitiveArrayCritical(env, ldgnum, NULL);
  ldgnum_ls = (*env)->GetArrayLength(env, ldgnum);
  ldgnum_ll = malloc(sizeof(integer)*ldgnum_ls);
  for (i_loc=0; i_loc<ldgnum_ls; ++i_loc) ldgnum_ll[i_loc] = ldgnum_l[i_loc];
  poles_ll = (*env)->GetPrimitiveArrayCritical(env, poles, NULL);
  difl_ll = (*env)->GetPrimitiveArrayCritical(env, difl, NULL);
  difr_ll = (*env)->GetPrimitiveArrayCritical(env, difr, NULL);
  z_ll = (*env)->GetPrimitiveArrayCritical(env, z, NULL);
  k_l = (*env)->GetPrimitiveArrayCritical(env, k, NULL);
  k_ls = (*env)->GetArrayLength(env, k);
  k_ll = malloc(sizeof(integer)*k_ls);
  for (i_loc=0; i_loc<k_ls; ++i_loc) k_ll[i_loc] = k_l[i_loc];
  c_ll = (*env)->GetPrimitiveArrayCritical(env, c, NULL);
  s_ll = (*env)->GetPrimitiveArrayCritical(env, s, NULL);
  work_ll = (*env)->GetPrimitiveArrayCritical(env, work, NULL);
  iwork_l = (*env)->GetPrimitiveArrayCritical(env, iwork, NULL);
  iwork_ls = (*env)->GetArrayLength(env, iwork);
  iwork_ll = malloc(sizeof(integer)*iwork_ls);
  for (i_loc=0; i_loc<iwork_ls; ++i_loc) iwork_ll[i_loc] = iwork_l[i_loc];
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dlasd6_(icompq_ll, nl_ll, nr_ll, sqre_ll, d_ll, vf_ll, vl_ll, alpha_ll, beta_ll, idxq_ll, perm_ll, givptr_ll, givcol_ll, ldgcol_ll, givnum_ll, ldgnum_ll, poles_ll, difl_ll, difr_ll, z_ll, k_ll, c_ll, s_ll, work_ll, iwork_ll, info_ll);

  for (i_loc=0; i_loc<icompq_ls; ++i_loc) icompq_l[i_loc] = icompq_ll[i_loc];
  free(icompq_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, icompq, icompq_l, 0);
  for (i_loc=0; i_loc<nl_ls; ++i_loc) nl_l[i_loc] = nl_ll[i_loc];
  free(nl_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, nl, nl_l, 0);
  for (i_loc=0; i_loc<nr_ls; ++i_loc) nr_l[i_loc] = nr_ll[i_loc];
  free(nr_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, nr, nr_l, 0);
  for (i_loc=0; i_loc<sqre_ls; ++i_loc) sqre_l[i_loc] = sqre_ll[i_loc];
  free(sqre_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, sqre, sqre_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, d, d_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, vf, vf_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, vl, vl_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, alpha, alpha_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, beta, beta_ll, 0);
  for (i_loc=0; i_loc<idxq_ls; ++i_loc) idxq_l[i_loc] = idxq_ll[i_loc];
  free(idxq_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, idxq, idxq_l, 0);
  for (i_loc=0; i_loc<perm_ls; ++i_loc) perm_l[i_loc] = perm_ll[i_loc];
  free(perm_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, perm, perm_l, 0);
  for (i_loc=0; i_loc<givptr_ls; ++i_loc) givptr_l[i_loc] = givptr_ll[i_loc];
  free(givptr_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, givptr, givptr_l, 0);
  for (i_loc=0; i_loc<givcol_ls; ++i_loc) givcol_l[i_loc] = givcol_ll[i_loc];
  free(givcol_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, givcol, givcol_l, 0);
  for (i_loc=0; i_loc<ldgcol_ls; ++i_loc) ldgcol_l[i_loc] = ldgcol_ll[i_loc];
  free(ldgcol_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldgcol, ldgcol_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, givnum, givnum_ll, 0);
  for (i_loc=0; i_loc<ldgnum_ls; ++i_loc) ldgnum_l[i_loc] = ldgnum_ll[i_loc];
  free(ldgnum_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldgnum, ldgnum_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, poles, poles_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, difl, difl_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, difr, difr_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, z, z_ll, 0);
  for (i_loc=0; i_loc<k_ls; ++i_loc) k_l[i_loc] = k_ll[i_loc];
  free(k_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, k, k_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, c, c_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, s, s_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, work, work_ll, 0);
  for (i_loc=0; i_loc<iwork_ls; ++i_loc) iwork_l[i_loc] = iwork_ll[i_loc];
  free(iwork_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, iwork, iwork_l, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_lasd7
(JNIEnv *env, jclass clazz, jintArray icompq, jintArray nl, jintArray nr, jintArray sqre, jintArray k, jdoubleArray d, jdoubleArray z, jdoubleArray zw, jdoubleArray vf, jdoubleArray vfw, jdoubleArray vl, jdoubleArray vlw, jdoubleArray alpha, jdoubleArray beta, jdoubleArray dsigma, jintArray idx, jintArray idxp, jintArray idxq, jintArray perm, jintArray givptr, jintArray givcol, jintArray ldgcol, jdoubleArray givnum, jintArray ldgnum, jdoubleArray c, jdoubleArray s, jintArray info) {
  int i_loc;
  jint* icompq_l;
  integer* icompq_ll;
  jsize icompq_ls;
  jint* nl_l;
  integer* nl_ll;
  jsize nl_ls;
  jint* nr_l;
  integer* nr_ll;
  jsize nr_ls;
  jint* sqre_l;
  integer* sqre_ll;
  jsize sqre_ls;
  jint* k_l;
  integer* k_ll;
  jsize k_ls;
  jdouble* d_ll;
  jdouble* z_ll;
  jdouble* zw_ll;
  jdouble* vf_ll;
  jdouble* vfw_ll;
  jdouble* vl_ll;
  jdouble* vlw_ll;
  jdouble* alpha_ll;
  jdouble* beta_ll;
  jdouble* dsigma_ll;
  jint* idx_l;
  integer* idx_ll;
  jsize idx_ls;
  jint* idxp_l;
  integer* idxp_ll;
  jsize idxp_ls;
  jint* idxq_l;
  integer* idxq_ll;
  jsize idxq_ls;
  jint* perm_l;
  integer* perm_ll;
  jsize perm_ls;
  jint* givptr_l;
  integer* givptr_ll;
  jsize givptr_ls;
  jint* givcol_l;
  integer* givcol_ll;
  jsize givcol_ls;
  jint* ldgcol_l;
  integer* ldgcol_ll;
  jsize ldgcol_ls;
  jdouble* givnum_ll;
  jint* ldgnum_l;
  integer* ldgnum_ll;
  jsize ldgnum_ls;
  jdouble* c_ll;
  jdouble* s_ll;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  icompq_l = (*env)->GetPrimitiveArrayCritical(env, icompq, NULL);
  icompq_ls = (*env)->GetArrayLength(env, icompq);
  icompq_ll = malloc(sizeof(integer)*icompq_ls);
  for (i_loc=0; i_loc<icompq_ls; ++i_loc) icompq_ll[i_loc] = icompq_l[i_loc];
  nl_l = (*env)->GetPrimitiveArrayCritical(env, nl, NULL);
  nl_ls = (*env)->GetArrayLength(env, nl);
  nl_ll = malloc(sizeof(integer)*nl_ls);
  for (i_loc=0; i_loc<nl_ls; ++i_loc) nl_ll[i_loc] = nl_l[i_loc];
  nr_l = (*env)->GetPrimitiveArrayCritical(env, nr, NULL);
  nr_ls = (*env)->GetArrayLength(env, nr);
  nr_ll = malloc(sizeof(integer)*nr_ls);
  for (i_loc=0; i_loc<nr_ls; ++i_loc) nr_ll[i_loc] = nr_l[i_loc];
  sqre_l = (*env)->GetPrimitiveArrayCritical(env, sqre, NULL);
  sqre_ls = (*env)->GetArrayLength(env, sqre);
  sqre_ll = malloc(sizeof(integer)*sqre_ls);
  for (i_loc=0; i_loc<sqre_ls; ++i_loc) sqre_ll[i_loc] = sqre_l[i_loc];
  k_l = (*env)->GetPrimitiveArrayCritical(env, k, NULL);
  k_ls = (*env)->GetArrayLength(env, k);
  k_ll = malloc(sizeof(integer)*k_ls);
  for (i_loc=0; i_loc<k_ls; ++i_loc) k_ll[i_loc] = k_l[i_loc];
  d_ll = (*env)->GetPrimitiveArrayCritical(env, d, NULL);
  z_ll = (*env)->GetPrimitiveArrayCritical(env, z, NULL);
  zw_ll = (*env)->GetPrimitiveArrayCritical(env, zw, NULL);
  vf_ll = (*env)->GetPrimitiveArrayCritical(env, vf, NULL);
  vfw_ll = (*env)->GetPrimitiveArrayCritical(env, vfw, NULL);
  vl_ll = (*env)->GetPrimitiveArrayCritical(env, vl, NULL);
  vlw_ll = (*env)->GetPrimitiveArrayCritical(env, vlw, NULL);
  alpha_ll = (*env)->GetPrimitiveArrayCritical(env, alpha, NULL);
  beta_ll = (*env)->GetPrimitiveArrayCritical(env, beta, NULL);
  dsigma_ll = (*env)->GetPrimitiveArrayCritical(env, dsigma, NULL);
  idx_l = (*env)->GetPrimitiveArrayCritical(env, idx, NULL);
  idx_ls = (*env)->GetArrayLength(env, idx);
  idx_ll = malloc(sizeof(integer)*idx_ls);
  for (i_loc=0; i_loc<idx_ls; ++i_loc) idx_ll[i_loc] = idx_l[i_loc];
  idxp_l = (*env)->GetPrimitiveArrayCritical(env, idxp, NULL);
  idxp_ls = (*env)->GetArrayLength(env, idxp);
  idxp_ll = malloc(sizeof(integer)*idxp_ls);
  for (i_loc=0; i_loc<idxp_ls; ++i_loc) idxp_ll[i_loc] = idxp_l[i_loc];
  idxq_l = (*env)->GetPrimitiveArrayCritical(env, idxq, NULL);
  idxq_ls = (*env)->GetArrayLength(env, idxq);
  idxq_ll = malloc(sizeof(integer)*idxq_ls);
  for (i_loc=0; i_loc<idxq_ls; ++i_loc) idxq_ll[i_loc] = idxq_l[i_loc];
  perm_l = (*env)->GetPrimitiveArrayCritical(env, perm, NULL);
  perm_ls = (*env)->GetArrayLength(env, perm);
  perm_ll = malloc(sizeof(integer)*perm_ls);
  for (i_loc=0; i_loc<perm_ls; ++i_loc) perm_ll[i_loc] = perm_l[i_loc];
  givptr_l = (*env)->GetPrimitiveArrayCritical(env, givptr, NULL);
  givptr_ls = (*env)->GetArrayLength(env, givptr);
  givptr_ll = malloc(sizeof(integer)*givptr_ls);
  for (i_loc=0; i_loc<givptr_ls; ++i_loc) givptr_ll[i_loc] = givptr_l[i_loc];
  givcol_l = (*env)->GetPrimitiveArrayCritical(env, givcol, NULL);
  givcol_ls = (*env)->GetArrayLength(env, givcol);
  givcol_ll = malloc(sizeof(integer)*givcol_ls);
  for (i_loc=0; i_loc<givcol_ls; ++i_loc) givcol_ll[i_loc] = givcol_l[i_loc];
  ldgcol_l = (*env)->GetPrimitiveArrayCritical(env, ldgcol, NULL);
  ldgcol_ls = (*env)->GetArrayLength(env, ldgcol);
  ldgcol_ll = malloc(sizeof(integer)*ldgcol_ls);
  for (i_loc=0; i_loc<ldgcol_ls; ++i_loc) ldgcol_ll[i_loc] = ldgcol_l[i_loc];
  givnum_ll = (*env)->GetPrimitiveArrayCritical(env, givnum, NULL);
  ldgnum_l = (*env)->GetPrimitiveArrayCritical(env, ldgnum, NULL);
  ldgnum_ls = (*env)->GetArrayLength(env, ldgnum);
  ldgnum_ll = malloc(sizeof(integer)*ldgnum_ls);
  for (i_loc=0; i_loc<ldgnum_ls; ++i_loc) ldgnum_ll[i_loc] = ldgnum_l[i_loc];
  c_ll = (*env)->GetPrimitiveArrayCritical(env, c, NULL);
  s_ll = (*env)->GetPrimitiveArrayCritical(env, s, NULL);
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dlasd7_(icompq_ll, nl_ll, nr_ll, sqre_ll, k_ll, d_ll, z_ll, zw_ll, vf_ll, vfw_ll, vl_ll, vlw_ll, alpha_ll, beta_ll, dsigma_ll, idx_ll, idxp_ll, idxq_ll, perm_ll, givptr_ll, givcol_ll, ldgcol_ll, givnum_ll, ldgnum_ll, c_ll, s_ll, info_ll);

  for (i_loc=0; i_loc<icompq_ls; ++i_loc) icompq_l[i_loc] = icompq_ll[i_loc];
  free(icompq_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, icompq, icompq_l, 0);
  for (i_loc=0; i_loc<nl_ls; ++i_loc) nl_l[i_loc] = nl_ll[i_loc];
  free(nl_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, nl, nl_l, 0);
  for (i_loc=0; i_loc<nr_ls; ++i_loc) nr_l[i_loc] = nr_ll[i_loc];
  free(nr_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, nr, nr_l, 0);
  for (i_loc=0; i_loc<sqre_ls; ++i_loc) sqre_l[i_loc] = sqre_ll[i_loc];
  free(sqre_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, sqre, sqre_l, 0);
  for (i_loc=0; i_loc<k_ls; ++i_loc) k_l[i_loc] = k_ll[i_loc];
  free(k_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, k, k_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, d, d_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, z, z_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, zw, zw_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, vf, vf_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, vfw, vfw_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, vl, vl_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, vlw, vlw_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, alpha, alpha_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, beta, beta_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, dsigma, dsigma_ll, 0);
  for (i_loc=0; i_loc<idx_ls; ++i_loc) idx_l[i_loc] = idx_ll[i_loc];
  free(idx_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, idx, idx_l, 0);
  for (i_loc=0; i_loc<idxp_ls; ++i_loc) idxp_l[i_loc] = idxp_ll[i_loc];
  free(idxp_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, idxp, idxp_l, 0);
  for (i_loc=0; i_loc<idxq_ls; ++i_loc) idxq_l[i_loc] = idxq_ll[i_loc];
  free(idxq_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, idxq, idxq_l, 0);
  for (i_loc=0; i_loc<perm_ls; ++i_loc) perm_l[i_loc] = perm_ll[i_loc];
  free(perm_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, perm, perm_l, 0);
  for (i_loc=0; i_loc<givptr_ls; ++i_loc) givptr_l[i_loc] = givptr_ll[i_loc];
  free(givptr_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, givptr, givptr_l, 0);
  for (i_loc=0; i_loc<givcol_ls; ++i_loc) givcol_l[i_loc] = givcol_ll[i_loc];
  free(givcol_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, givcol, givcol_l, 0);
  for (i_loc=0; i_loc<ldgcol_ls; ++i_loc) ldgcol_l[i_loc] = ldgcol_ll[i_loc];
  free(ldgcol_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldgcol, ldgcol_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, givnum, givnum_ll, 0);
  for (i_loc=0; i_loc<ldgnum_ls; ++i_loc) ldgnum_l[i_loc] = ldgnum_ll[i_loc];
  free(ldgnum_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldgnum, ldgnum_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, c, c_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, s, s_ll, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_lasd8
(JNIEnv *env, jclass clazz, jintArray icompq, jintArray k, jdoubleArray d, jdoubleArray z, jdoubleArray vf, jdoubleArray vl, jdoubleArray difl, jdoubleArray difr, jintArray lddifr, jdoubleArray dsigma, jdoubleArray work, jintArray info) {
  int i_loc;
  jint* icompq_l;
  integer* icompq_ll;
  jsize icompq_ls;
  jint* k_l;
  integer* k_ll;
  jsize k_ls;
  jdouble* d_ll;
  jdouble* z_ll;
  jdouble* vf_ll;
  jdouble* vl_ll;
  jdouble* difl_ll;
  jdouble* difr_ll;
  jint* lddifr_l;
  integer* lddifr_ll;
  jsize lddifr_ls;
  jdouble* dsigma_ll;
  jdouble* work_ll;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  icompq_l = (*env)->GetPrimitiveArrayCritical(env, icompq, NULL);
  icompq_ls = (*env)->GetArrayLength(env, icompq);
  icompq_ll = malloc(sizeof(integer)*icompq_ls);
  for (i_loc=0; i_loc<icompq_ls; ++i_loc) icompq_ll[i_loc] = icompq_l[i_loc];
  k_l = (*env)->GetPrimitiveArrayCritical(env, k, NULL);
  k_ls = (*env)->GetArrayLength(env, k);
  k_ll = malloc(sizeof(integer)*k_ls);
  for (i_loc=0; i_loc<k_ls; ++i_loc) k_ll[i_loc] = k_l[i_loc];
  d_ll = (*env)->GetPrimitiveArrayCritical(env, d, NULL);
  z_ll = (*env)->GetPrimitiveArrayCritical(env, z, NULL);
  vf_ll = (*env)->GetPrimitiveArrayCritical(env, vf, NULL);
  vl_ll = (*env)->GetPrimitiveArrayCritical(env, vl, NULL);
  difl_ll = (*env)->GetPrimitiveArrayCritical(env, difl, NULL);
  difr_ll = (*env)->GetPrimitiveArrayCritical(env, difr, NULL);
  lddifr_l = (*env)->GetPrimitiveArrayCritical(env, lddifr, NULL);
  lddifr_ls = (*env)->GetArrayLength(env, lddifr);
  lddifr_ll = malloc(sizeof(integer)*lddifr_ls);
  for (i_loc=0; i_loc<lddifr_ls; ++i_loc) lddifr_ll[i_loc] = lddifr_l[i_loc];
  dsigma_ll = (*env)->GetPrimitiveArrayCritical(env, dsigma, NULL);
  work_ll = (*env)->GetPrimitiveArrayCritical(env, work, NULL);
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dlasd8_(icompq_ll, k_ll, d_ll, z_ll, vf_ll, vl_ll, difl_ll, difr_ll, lddifr_ll, dsigma_ll, work_ll, info_ll);

  for (i_loc=0; i_loc<icompq_ls; ++i_loc) icompq_l[i_loc] = icompq_ll[i_loc];
  free(icompq_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, icompq, icompq_l, 0);
  for (i_loc=0; i_loc<k_ls; ++i_loc) k_l[i_loc] = k_ll[i_loc];
  free(k_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, k, k_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, d, d_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, z, z_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, vf, vf_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, vl, vl_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, difl, difl_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, difr, difr_ll, 0);
  for (i_loc=0; i_loc<lddifr_ls; ++i_loc) lddifr_l[i_loc] = lddifr_ll[i_loc];
  free(lddifr_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, lddifr, lddifr_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, dsigma, dsigma_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, work, work_ll, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_lasd9
(JNIEnv *env, jclass clazz, jintArray icompq, jintArray ldu, jintArray k, jdoubleArray d, jdoubleArray z, jdoubleArray vf, jdoubleArray vl, jdoubleArray difl, jdoubleArray difr, jdoubleArray dsigma, jdoubleArray work, jintArray info) {
  int i_loc;
  jint* icompq_l;
  integer* icompq_ll;
  jsize icompq_ls;
  jint* ldu_l;
  integer* ldu_ll;
  jsize ldu_ls;
  jint* k_l;
  integer* k_ll;
  jsize k_ls;
  jdouble* d_ll;
  jdouble* z_ll;
  jdouble* vf_ll;
  jdouble* vl_ll;
  jdouble* difl_ll;
  jdouble* difr_ll;
  jdouble* dsigma_ll;
  jdouble* work_ll;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  icompq_l = (*env)->GetPrimitiveArrayCritical(env, icompq, NULL);
  icompq_ls = (*env)->GetArrayLength(env, icompq);
  icompq_ll = malloc(sizeof(integer)*icompq_ls);
  for (i_loc=0; i_loc<icompq_ls; ++i_loc) icompq_ll[i_loc] = icompq_l[i_loc];
  ldu_l = (*env)->GetPrimitiveArrayCritical(env, ldu, NULL);
  ldu_ls = (*env)->GetArrayLength(env, ldu);
  ldu_ll = malloc(sizeof(integer)*ldu_ls);
  for (i_loc=0; i_loc<ldu_ls; ++i_loc) ldu_ll[i_loc] = ldu_l[i_loc];
  k_l = (*env)->GetPrimitiveArrayCritical(env, k, NULL);
  k_ls = (*env)->GetArrayLength(env, k);
  k_ll = malloc(sizeof(integer)*k_ls);
  for (i_loc=0; i_loc<k_ls; ++i_loc) k_ll[i_loc] = k_l[i_loc];
  d_ll = (*env)->GetPrimitiveArrayCritical(env, d, NULL);
  z_ll = (*env)->GetPrimitiveArrayCritical(env, z, NULL);
  vf_ll = (*env)->GetPrimitiveArrayCritical(env, vf, NULL);
  vl_ll = (*env)->GetPrimitiveArrayCritical(env, vl, NULL);
  difl_ll = (*env)->GetPrimitiveArrayCritical(env, difl, NULL);
  difr_ll = (*env)->GetPrimitiveArrayCritical(env, difr, NULL);
  dsigma_ll = (*env)->GetPrimitiveArrayCritical(env, dsigma, NULL);
  work_ll = (*env)->GetPrimitiveArrayCritical(env, work, NULL);
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dlasd9_(icompq_ll, ldu_ll, k_ll, d_ll, z_ll, vf_ll, vl_ll, difl_ll, difr_ll, dsigma_ll, work_ll, info_ll);

  for (i_loc=0; i_loc<icompq_ls; ++i_loc) icompq_l[i_loc] = icompq_ll[i_loc];
  free(icompq_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, icompq, icompq_l, 0);
  for (i_loc=0; i_loc<ldu_ls; ++i_loc) ldu_l[i_loc] = ldu_ll[i_loc];
  free(ldu_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldu, ldu_l, 0);
  for (i_loc=0; i_loc<k_ls; ++i_loc) k_l[i_loc] = k_ll[i_loc];
  free(k_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, k, k_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, d, d_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, z, z_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, vf, vf_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, vl, vl_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, difl, difl_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, difr, difr_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, dsigma, dsigma_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, work, work_ll, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_lasda
(JNIEnv *env, jclass clazz, jintArray icompq, jintArray smlsiz, jintArray n, jintArray sqre, jdoubleArray d, jdoubleArray e, jdoubleArray u, jintArray ldu, jdoubleArray vt, jintArray k, jdoubleArray difl, jdoubleArray difr, jdoubleArray z, jdoubleArray poles, jintArray givptr, jintArray givcol, jintArray ldgcol, jintArray perm, jdoubleArray givnum, jdoubleArray c, jdoubleArray s, jdoubleArray work, jintArray iwork, jintArray info) {
  int i_loc;
  jint* icompq_l;
  integer* icompq_ll;
  jsize icompq_ls;
  jint* smlsiz_l;
  integer* smlsiz_ll;
  jsize smlsiz_ls;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jint* sqre_l;
  integer* sqre_ll;
  jsize sqre_ls;
  jdouble* d_ll;
  jdouble* e_ll;
  jdouble* u_ll;
  jint* ldu_l;
  integer* ldu_ll;
  jsize ldu_ls;
  jdouble* vt_ll;
  jint* k_l;
  integer* k_ll;
  jsize k_ls;
  jdouble* difl_ll;
  jdouble* difr_ll;
  jdouble* z_ll;
  jdouble* poles_ll;
  jint* givptr_l;
  integer* givptr_ll;
  jsize givptr_ls;
  jint* givcol_l;
  integer* givcol_ll;
  jsize givcol_ls;
  jint* ldgcol_l;
  integer* ldgcol_ll;
  jsize ldgcol_ls;
  jint* perm_l;
  integer* perm_ll;
  jsize perm_ls;
  jdouble* givnum_ll;
  jdouble* c_ll;
  jdouble* s_ll;
  jdouble* work_ll;
  jint* iwork_l;
  integer* iwork_ll;
  jsize iwork_ls;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  icompq_l = (*env)->GetPrimitiveArrayCritical(env, icompq, NULL);
  icompq_ls = (*env)->GetArrayLength(env, icompq);
  icompq_ll = malloc(sizeof(integer)*icompq_ls);
  for (i_loc=0; i_loc<icompq_ls; ++i_loc) icompq_ll[i_loc] = icompq_l[i_loc];
  smlsiz_l = (*env)->GetPrimitiveArrayCritical(env, smlsiz, NULL);
  smlsiz_ls = (*env)->GetArrayLength(env, smlsiz);
  smlsiz_ll = malloc(sizeof(integer)*smlsiz_ls);
  for (i_loc=0; i_loc<smlsiz_ls; ++i_loc) smlsiz_ll[i_loc] = smlsiz_l[i_loc];
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  sqre_l = (*env)->GetPrimitiveArrayCritical(env, sqre, NULL);
  sqre_ls = (*env)->GetArrayLength(env, sqre);
  sqre_ll = malloc(sizeof(integer)*sqre_ls);
  for (i_loc=0; i_loc<sqre_ls; ++i_loc) sqre_ll[i_loc] = sqre_l[i_loc];
  d_ll = (*env)->GetPrimitiveArrayCritical(env, d, NULL);
  e_ll = (*env)->GetPrimitiveArrayCritical(env, e, NULL);
  u_ll = (*env)->GetPrimitiveArrayCritical(env, u, NULL);
  ldu_l = (*env)->GetPrimitiveArrayCritical(env, ldu, NULL);
  ldu_ls = (*env)->GetArrayLength(env, ldu);
  ldu_ll = malloc(sizeof(integer)*ldu_ls);
  for (i_loc=0; i_loc<ldu_ls; ++i_loc) ldu_ll[i_loc] = ldu_l[i_loc];
  vt_ll = (*env)->GetPrimitiveArrayCritical(env, vt, NULL);
  k_l = (*env)->GetPrimitiveArrayCritical(env, k, NULL);
  k_ls = (*env)->GetArrayLength(env, k);
  k_ll = malloc(sizeof(integer)*k_ls);
  for (i_loc=0; i_loc<k_ls; ++i_loc) k_ll[i_loc] = k_l[i_loc];
  difl_ll = (*env)->GetPrimitiveArrayCritical(env, difl, NULL);
  difr_ll = (*env)->GetPrimitiveArrayCritical(env, difr, NULL);
  z_ll = (*env)->GetPrimitiveArrayCritical(env, z, NULL);
  poles_ll = (*env)->GetPrimitiveArrayCritical(env, poles, NULL);
  givptr_l = (*env)->GetPrimitiveArrayCritical(env, givptr, NULL);
  givptr_ls = (*env)->GetArrayLength(env, givptr);
  givptr_ll = malloc(sizeof(integer)*givptr_ls);
  for (i_loc=0; i_loc<givptr_ls; ++i_loc) givptr_ll[i_loc] = givptr_l[i_loc];
  givcol_l = (*env)->GetPrimitiveArrayCritical(env, givcol, NULL);
  givcol_ls = (*env)->GetArrayLength(env, givcol);
  givcol_ll = malloc(sizeof(integer)*givcol_ls);
  for (i_loc=0; i_loc<givcol_ls; ++i_loc) givcol_ll[i_loc] = givcol_l[i_loc];
  ldgcol_l = (*env)->GetPrimitiveArrayCritical(env, ldgcol, NULL);
  ldgcol_ls = (*env)->GetArrayLength(env, ldgcol);
  ldgcol_ll = malloc(sizeof(integer)*ldgcol_ls);
  for (i_loc=0; i_loc<ldgcol_ls; ++i_loc) ldgcol_ll[i_loc] = ldgcol_l[i_loc];
  perm_l = (*env)->GetPrimitiveArrayCritical(env, perm, NULL);
  perm_ls = (*env)->GetArrayLength(env, perm);
  perm_ll = malloc(sizeof(integer)*perm_ls);
  for (i_loc=0; i_loc<perm_ls; ++i_loc) perm_ll[i_loc] = perm_l[i_loc];
  givnum_ll = (*env)->GetPrimitiveArrayCritical(env, givnum, NULL);
  c_ll = (*env)->GetPrimitiveArrayCritical(env, c, NULL);
  s_ll = (*env)->GetPrimitiveArrayCritical(env, s, NULL);
  work_ll = (*env)->GetPrimitiveArrayCritical(env, work, NULL);
  iwork_l = (*env)->GetPrimitiveArrayCritical(env, iwork, NULL);
  iwork_ls = (*env)->GetArrayLength(env, iwork);
  iwork_ll = malloc(sizeof(integer)*iwork_ls);
  for (i_loc=0; i_loc<iwork_ls; ++i_loc) iwork_ll[i_loc] = iwork_l[i_loc];
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dlasda_(icompq_ll, smlsiz_ll, n_ll, sqre_ll, d_ll, e_ll, u_ll, ldu_ll, vt_ll, k_ll, difl_ll, difr_ll, z_ll, poles_ll, givptr_ll, givcol_ll, ldgcol_ll, perm_ll, givnum_ll, c_ll, s_ll, work_ll, iwork_ll, info_ll);

  for (i_loc=0; i_loc<icompq_ls; ++i_loc) icompq_l[i_loc] = icompq_ll[i_loc];
  free(icompq_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, icompq, icompq_l, 0);
  for (i_loc=0; i_loc<smlsiz_ls; ++i_loc) smlsiz_l[i_loc] = smlsiz_ll[i_loc];
  free(smlsiz_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, smlsiz, smlsiz_l, 0);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  for (i_loc=0; i_loc<sqre_ls; ++i_loc) sqre_l[i_loc] = sqre_ll[i_loc];
  free(sqre_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, sqre, sqre_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, d, d_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, e, e_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, u, u_ll, 0);
  for (i_loc=0; i_loc<ldu_ls; ++i_loc) ldu_l[i_loc] = ldu_ll[i_loc];
  free(ldu_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldu, ldu_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, vt, vt_ll, 0);
  for (i_loc=0; i_loc<k_ls; ++i_loc) k_l[i_loc] = k_ll[i_loc];
  free(k_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, k, k_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, difl, difl_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, difr, difr_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, z, z_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, poles, poles_ll, 0);
  for (i_loc=0; i_loc<givptr_ls; ++i_loc) givptr_l[i_loc] = givptr_ll[i_loc];
  free(givptr_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, givptr, givptr_l, 0);
  for (i_loc=0; i_loc<givcol_ls; ++i_loc) givcol_l[i_loc] = givcol_ll[i_loc];
  free(givcol_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, givcol, givcol_l, 0);
  for (i_loc=0; i_loc<ldgcol_ls; ++i_loc) ldgcol_l[i_loc] = ldgcol_ll[i_loc];
  free(ldgcol_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldgcol, ldgcol_l, 0);
  for (i_loc=0; i_loc<perm_ls; ++i_loc) perm_l[i_loc] = perm_ll[i_loc];
  free(perm_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, perm, perm_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, givnum, givnum_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, c, c_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, s, s_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, work, work_ll, 0);
  for (i_loc=0; i_loc<iwork_ls; ++i_loc) iwork_l[i_loc] = iwork_ll[i_loc];
  free(iwork_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, iwork, iwork_l, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_lasdq
(JNIEnv *env, jclass clazz, jcharArray uplo, jintArray sqre, jintArray n, jintArray ncvt, jintArray nru, jintArray ncc, jdoubleArray d, jdoubleArray e, jdoubleArray vt, jintArray ldvt, jdoubleArray u, jintArray ldu, jdoubleArray c, jintArray ldc, jdoubleArray work, jintArray info) {
  int i_loc;
  jchar* uplo_l;
  char* uplo_ll;
  jsize uplo_ls;
  jint* sqre_l;
  integer* sqre_ll;
  jsize sqre_ls;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jint* ncvt_l;
  integer* ncvt_ll;
  jsize ncvt_ls;
  jint* nru_l;
  integer* nru_ll;
  jsize nru_ls;
  jint* ncc_l;
  integer* ncc_ll;
  jsize ncc_ls;
  jdouble* d_ll;
  jdouble* e_ll;
  jdouble* vt_ll;
  jint* ldvt_l;
  integer* ldvt_ll;
  jsize ldvt_ls;
  jdouble* u_ll;
  jint* ldu_l;
  integer* ldu_ll;
  jsize ldu_ls;
  jdouble* c_ll;
  jint* ldc_l;
  integer* ldc_ll;
  jsize ldc_ls;
  jdouble* work_ll;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  uplo_l = (*env)->GetPrimitiveArrayCritical(env, uplo, NULL);
  uplo_ls = (*env)->GetArrayLength(env, uplo);
  uplo_ll = malloc(sizeof(char)*uplo_ls);
  for (i_loc=0; i_loc<uplo_ls; ++i_loc) uplo_ll[i_loc] = uplo_l[i_loc];
  sqre_l = (*env)->GetPrimitiveArrayCritical(env, sqre, NULL);
  sqre_ls = (*env)->GetArrayLength(env, sqre);
  sqre_ll = malloc(sizeof(integer)*sqre_ls);
  for (i_loc=0; i_loc<sqre_ls; ++i_loc) sqre_ll[i_loc] = sqre_l[i_loc];
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  ncvt_l = (*env)->GetPrimitiveArrayCritical(env, ncvt, NULL);
  ncvt_ls = (*env)->GetArrayLength(env, ncvt);
  ncvt_ll = malloc(sizeof(integer)*ncvt_ls);
  for (i_loc=0; i_loc<ncvt_ls; ++i_loc) ncvt_ll[i_loc] = ncvt_l[i_loc];
  nru_l = (*env)->GetPrimitiveArrayCritical(env, nru, NULL);
  nru_ls = (*env)->GetArrayLength(env, nru);
  nru_ll = malloc(sizeof(integer)*nru_ls);
  for (i_loc=0; i_loc<nru_ls; ++i_loc) nru_ll[i_loc] = nru_l[i_loc];
  ncc_l = (*env)->GetPrimitiveArrayCritical(env, ncc, NULL);
  ncc_ls = (*env)->GetArrayLength(env, ncc);
  ncc_ll = malloc(sizeof(integer)*ncc_ls);
  for (i_loc=0; i_loc<ncc_ls; ++i_loc) ncc_ll[i_loc] = ncc_l[i_loc];
  d_ll = (*env)->GetPrimitiveArrayCritical(env, d, NULL);
  e_ll = (*env)->GetPrimitiveArrayCritical(env, e, NULL);
  vt_ll = (*env)->GetPrimitiveArrayCritical(env, vt, NULL);
  ldvt_l = (*env)->GetPrimitiveArrayCritical(env, ldvt, NULL);
  ldvt_ls = (*env)->GetArrayLength(env, ldvt);
  ldvt_ll = malloc(sizeof(integer)*ldvt_ls);
  for (i_loc=0; i_loc<ldvt_ls; ++i_loc) ldvt_ll[i_loc] = ldvt_l[i_loc];
  u_ll = (*env)->GetPrimitiveArrayCritical(env, u, NULL);
  ldu_l = (*env)->GetPrimitiveArrayCritical(env, ldu, NULL);
  ldu_ls = (*env)->GetArrayLength(env, ldu);
  ldu_ll = malloc(sizeof(integer)*ldu_ls);
  for (i_loc=0; i_loc<ldu_ls; ++i_loc) ldu_ll[i_loc] = ldu_l[i_loc];
  c_ll = (*env)->GetPrimitiveArrayCritical(env, c, NULL);
  ldc_l = (*env)->GetPrimitiveArrayCritical(env, ldc, NULL);
  ldc_ls = (*env)->GetArrayLength(env, ldc);
  ldc_ll = malloc(sizeof(integer)*ldc_ls);
  for (i_loc=0; i_loc<ldc_ls; ++i_loc) ldc_ll[i_loc] = ldc_l[i_loc];
  work_ll = (*env)->GetPrimitiveArrayCritical(env, work, NULL);
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dlasdq_(uplo_ll, sqre_ll, n_ll, ncvt_ll, nru_ll, ncc_ll, d_ll, e_ll, vt_ll, ldvt_ll, u_ll, ldu_ll, c_ll, ldc_ll, work_ll, info_ll);

  for (i_loc=0; i_loc<uplo_ls; ++i_loc) uplo_l[i_loc] = uplo_ll[i_loc];
  free(uplo_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, uplo, uplo_l, 0);
  for (i_loc=0; i_loc<sqre_ls; ++i_loc) sqre_l[i_loc] = sqre_ll[i_loc];
  free(sqre_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, sqre, sqre_l, 0);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  for (i_loc=0; i_loc<ncvt_ls; ++i_loc) ncvt_l[i_loc] = ncvt_ll[i_loc];
  free(ncvt_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ncvt, ncvt_l, 0);
  for (i_loc=0; i_loc<nru_ls; ++i_loc) nru_l[i_loc] = nru_ll[i_loc];
  free(nru_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, nru, nru_l, 0);
  for (i_loc=0; i_loc<ncc_ls; ++i_loc) ncc_l[i_loc] = ncc_ll[i_loc];
  free(ncc_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ncc, ncc_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, d, d_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, e, e_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, vt, vt_ll, 0);
  for (i_loc=0; i_loc<ldvt_ls; ++i_loc) ldvt_l[i_loc] = ldvt_ll[i_loc];
  free(ldvt_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldvt, ldvt_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, u, u_ll, 0);
  for (i_loc=0; i_loc<ldu_ls; ++i_loc) ldu_l[i_loc] = ldu_ll[i_loc];
  free(ldu_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldu, ldu_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, c, c_ll, 0);
  for (i_loc=0; i_loc<ldc_ls; ++i_loc) ldc_l[i_loc] = ldc_ll[i_loc];
  free(ldc_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldc, ldc_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, work, work_ll, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_lasdt
(JNIEnv *env, jclass clazz, jintArray n, jintArray lvl, jintArray nd, jintArray inode, jintArray ndiml, jintArray ndimr, jintArray msub) {
  int i_loc;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jint* lvl_l;
  integer* lvl_ll;
  jsize lvl_ls;
  jint* nd_l;
  integer* nd_ll;
  jsize nd_ls;
  jint* inode_l;
  integer* inode_ll;
  jsize inode_ls;
  jint* ndiml_l;
  integer* ndiml_ll;
  jsize ndiml_ls;
  jint* ndimr_l;
  integer* ndimr_ll;
  jsize ndimr_ls;
  jint* msub_l;
  integer* msub_ll;
  jsize msub_ls;
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  lvl_l = (*env)->GetPrimitiveArrayCritical(env, lvl, NULL);
  lvl_ls = (*env)->GetArrayLength(env, lvl);
  lvl_ll = malloc(sizeof(integer)*lvl_ls);
  for (i_loc=0; i_loc<lvl_ls; ++i_loc) lvl_ll[i_loc] = lvl_l[i_loc];
  nd_l = (*env)->GetPrimitiveArrayCritical(env, nd, NULL);
  nd_ls = (*env)->GetArrayLength(env, nd);
  nd_ll = malloc(sizeof(integer)*nd_ls);
  for (i_loc=0; i_loc<nd_ls; ++i_loc) nd_ll[i_loc] = nd_l[i_loc];
  inode_l = (*env)->GetPrimitiveArrayCritical(env, inode, NULL);
  inode_ls = (*env)->GetArrayLength(env, inode);
  inode_ll = malloc(sizeof(integer)*inode_ls);
  for (i_loc=0; i_loc<inode_ls; ++i_loc) inode_ll[i_loc] = inode_l[i_loc];
  ndiml_l = (*env)->GetPrimitiveArrayCritical(env, ndiml, NULL);
  ndiml_ls = (*env)->GetArrayLength(env, ndiml);
  ndiml_ll = malloc(sizeof(integer)*ndiml_ls);
  for (i_loc=0; i_loc<ndiml_ls; ++i_loc) ndiml_ll[i_loc] = ndiml_l[i_loc];
  ndimr_l = (*env)->GetPrimitiveArrayCritical(env, ndimr, NULL);
  ndimr_ls = (*env)->GetArrayLength(env, ndimr);
  ndimr_ll = malloc(sizeof(integer)*ndimr_ls);
  for (i_loc=0; i_loc<ndimr_ls; ++i_loc) ndimr_ll[i_loc] = ndimr_l[i_loc];
  msub_l = (*env)->GetPrimitiveArrayCritical(env, msub, NULL);
  msub_ls = (*env)->GetArrayLength(env, msub);
  msub_ll = malloc(sizeof(integer)*msub_ls);
  for (i_loc=0; i_loc<msub_ls; ++i_loc) msub_ll[i_loc] = msub_l[i_loc];

  dlasdt_(n_ll, lvl_ll, nd_ll, inode_ll, ndiml_ll, ndimr_ll, msub_ll);

  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  for (i_loc=0; i_loc<lvl_ls; ++i_loc) lvl_l[i_loc] = lvl_ll[i_loc];
  free(lvl_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, lvl, lvl_l, 0);
  for (i_loc=0; i_loc<nd_ls; ++i_loc) nd_l[i_loc] = nd_ll[i_loc];
  free(nd_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, nd, nd_l, 0);
  for (i_loc=0; i_loc<inode_ls; ++i_loc) inode_l[i_loc] = inode_ll[i_loc];
  free(inode_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, inode, inode_l, 0);
  for (i_loc=0; i_loc<ndiml_ls; ++i_loc) ndiml_l[i_loc] = ndiml_ll[i_loc];
  free(ndiml_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ndiml, ndiml_l, 0);
  for (i_loc=0; i_loc<ndimr_ls; ++i_loc) ndimr_l[i_loc] = ndimr_ll[i_loc];
  free(ndimr_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ndimr, ndimr_l, 0);
  for (i_loc=0; i_loc<msub_ls; ++i_loc) msub_l[i_loc] = msub_ll[i_loc];
  free(msub_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, msub, msub_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_laset
(JNIEnv *env, jclass clazz, jcharArray uplo, jintArray m, jintArray n, jdoubleArray alpha, jdoubleArray beta, jdoubleArray a, jintArray lda) {
  int i_loc;
  jchar* uplo_l;
  char* uplo_ll;
  jsize uplo_ls;
  jint* m_l;
  integer* m_ll;
  jsize m_ls;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jdouble* alpha_ll;
  jdouble* beta_ll;
  jdouble* a_ll;
  jint* lda_l;
  integer* lda_ll;
  jsize lda_ls;
  uplo_l = (*env)->GetPrimitiveArrayCritical(env, uplo, NULL);
  uplo_ls = (*env)->GetArrayLength(env, uplo);
  uplo_ll = malloc(sizeof(char)*uplo_ls);
  for (i_loc=0; i_loc<uplo_ls; ++i_loc) uplo_ll[i_loc] = uplo_l[i_loc];
  m_l = (*env)->GetPrimitiveArrayCritical(env, m, NULL);
  m_ls = (*env)->GetArrayLength(env, m);
  m_ll = malloc(sizeof(integer)*m_ls);
  for (i_loc=0; i_loc<m_ls; ++i_loc) m_ll[i_loc] = m_l[i_loc];
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  alpha_ll = (*env)->GetPrimitiveArrayCritical(env, alpha, NULL);
  beta_ll = (*env)->GetPrimitiveArrayCritical(env, beta, NULL);
  a_ll = (*env)->GetPrimitiveArrayCritical(env, a, NULL);
  lda_l = (*env)->GetPrimitiveArrayCritical(env, lda, NULL);
  lda_ls = (*env)->GetArrayLength(env, lda);
  lda_ll = malloc(sizeof(integer)*lda_ls);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_ll[i_loc] = lda_l[i_loc];

  dlaset_(uplo_ll, m_ll, n_ll, alpha_ll, beta_ll, a_ll, lda_ll);

  for (i_loc=0; i_loc<uplo_ls; ++i_loc) uplo_l[i_loc] = uplo_ll[i_loc];
  free(uplo_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, uplo, uplo_l, 0);
  for (i_loc=0; i_loc<m_ls; ++i_loc) m_l[i_loc] = m_ll[i_loc];
  free(m_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, m, m_l, 0);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, alpha, alpha_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, beta, beta_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, a, a_ll, 0);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_l[i_loc] = lda_ll[i_loc];
  free(lda_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, lda, lda_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_lasq1
(JNIEnv *env, jclass clazz, jintArray n, jdoubleArray d, jdoubleArray e, jdoubleArray work, jintArray info) {
  int i_loc;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jdouble* d_ll;
  jdouble* e_ll;
  jdouble* work_ll;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  d_ll = (*env)->GetPrimitiveArrayCritical(env, d, NULL);
  e_ll = (*env)->GetPrimitiveArrayCritical(env, e, NULL);
  work_ll = (*env)->GetPrimitiveArrayCritical(env, work, NULL);
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dlasq1_(n_ll, d_ll, e_ll, work_ll, info_ll);

  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, d, d_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, e, e_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, work, work_ll, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_lasq2
(JNIEnv *env, jclass clazz, jintArray n, jdoubleArray z, jintArray info) {
  int i_loc;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jdouble* z_ll;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  z_ll = (*env)->GetPrimitiveArrayCritical(env, z, NULL);
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dlasq2_(n_ll, z_ll, info_ll);

  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, z, z_ll, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_lasq3
(JNIEnv *env, jclass clazz, jintArray i0, jintArray n0, jdoubleArray z, jintArray pp, jdoubleArray dmin, jdoubleArray sigma, jdoubleArray desig, jdoubleArray qmax, jintArray nfail, jintArray iter, jintArray ndiv, jbooleanArray ieee) {
  int i_loc;
  jint* i0_l;
  integer* i0_ll;
  jsize i0_ls;
  jint* n0_l;
  integer* n0_ll;
  jsize n0_ls;
  jdouble* z_ll;
  jint* pp_l;
  integer* pp_ll;
  jsize pp_ls;
  jdouble* dmin_ll;
  jdouble* sigma_ll;
  jdouble* desig_ll;
  jdouble* qmax_ll;
  jint* nfail_l;
  integer* nfail_ll;
  jsize nfail_ls;
  jint* iter_l;
  integer* iter_ll;
  jsize iter_ls;
  jint* ndiv_l;
  integer* ndiv_ll;
  jsize ndiv_ls;
  jboolean* ieee_l;
  integer* ieee_ll;
  jsize ieee_ls;
  i0_l = (*env)->GetPrimitiveArrayCritical(env, i0, NULL);
  i0_ls = (*env)->GetArrayLength(env, i0);
  i0_ll = malloc(sizeof(integer)*i0_ls);
  for (i_loc=0; i_loc<i0_ls; ++i_loc) i0_ll[i_loc] = i0_l[i_loc];
  n0_l = (*env)->GetPrimitiveArrayCritical(env, n0, NULL);
  n0_ls = (*env)->GetArrayLength(env, n0);
  n0_ll = malloc(sizeof(integer)*n0_ls);
  for (i_loc=0; i_loc<n0_ls; ++i_loc) n0_ll[i_loc] = n0_l[i_loc];
  z_ll = (*env)->GetPrimitiveArrayCritical(env, z, NULL);
  pp_l = (*env)->GetPrimitiveArrayCritical(env, pp, NULL);
  pp_ls = (*env)->GetArrayLength(env, pp);
  pp_ll = malloc(sizeof(integer)*pp_ls);
  for (i_loc=0; i_loc<pp_ls; ++i_loc) pp_ll[i_loc] = pp_l[i_loc];
  dmin_ll = (*env)->GetPrimitiveArrayCritical(env, dmin, NULL);
  sigma_ll = (*env)->GetPrimitiveArrayCritical(env, sigma, NULL);
  desig_ll = (*env)->GetPrimitiveArrayCritical(env, desig, NULL);
  qmax_ll = (*env)->GetPrimitiveArrayCritical(env, qmax, NULL);
  nfail_l = (*env)->GetPrimitiveArrayCritical(env, nfail, NULL);
  nfail_ls = (*env)->GetArrayLength(env, nfail);
  nfail_ll = malloc(sizeof(integer)*nfail_ls);
  for (i_loc=0; i_loc<nfail_ls; ++i_loc) nfail_ll[i_loc] = nfail_l[i_loc];
  iter_l = (*env)->GetPrimitiveArrayCritical(env, iter, NULL);
  iter_ls = (*env)->GetArrayLength(env, iter);
  iter_ll = malloc(sizeof(integer)*iter_ls);
  for (i_loc=0; i_loc<iter_ls; ++i_loc) iter_ll[i_loc] = iter_l[i_loc];
  ndiv_l = (*env)->GetPrimitiveArrayCritical(env, ndiv, NULL);
  ndiv_ls = (*env)->GetArrayLength(env, ndiv);
  ndiv_ll = malloc(sizeof(integer)*ndiv_ls);
  for (i_loc=0; i_loc<ndiv_ls; ++i_loc) ndiv_ll[i_loc] = ndiv_l[i_loc];
  ieee_l = (*env)->GetPrimitiveArrayCritical(env, ieee, NULL);
  ieee_ls = (*env)->GetArrayLength(env, ieee);
  ieee_ll = malloc(sizeof(integer)*ieee_ls);
  for (i_loc=0; i_loc<ieee_ls; ++i_loc) ieee_ll[i_loc] = ieee_l[i_loc];

  dlasq3_(i0_ll, n0_ll, z_ll, pp_ll, dmin_ll, sigma_ll, desig_ll, qmax_ll, nfail_ll, iter_ll, ndiv_ll, ieee_ll);

  for (i_loc=0; i_loc<i0_ls; ++i_loc) i0_l[i_loc] = i0_ll[i_loc];
  free(i0_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, i0, i0_l, 0);
  for (i_loc=0; i_loc<n0_ls; ++i_loc) n0_l[i_loc] = n0_ll[i_loc];
  free(n0_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n0, n0_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, z, z_ll, 0);
  for (i_loc=0; i_loc<pp_ls; ++i_loc) pp_l[i_loc] = pp_ll[i_loc];
  free(pp_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, pp, pp_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, dmin, dmin_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, sigma, sigma_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, desig, desig_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, qmax, qmax_ll, 0);
  for (i_loc=0; i_loc<nfail_ls; ++i_loc) nfail_l[i_loc] = nfail_ll[i_loc];
  free(nfail_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, nfail, nfail_l, 0);
  for (i_loc=0; i_loc<iter_ls; ++i_loc) iter_l[i_loc] = iter_ll[i_loc];
  free(iter_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, iter, iter_l, 0);
  for (i_loc=0; i_loc<ndiv_ls; ++i_loc) ndiv_l[i_loc] = ndiv_ll[i_loc];
  free(ndiv_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ndiv, ndiv_l, 0);
  for (i_loc=0; i_loc<ieee_ls; ++i_loc) ieee_l[i_loc] = ieee_ll[i_loc];
  free(ieee_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ieee, ieee_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_lasq4
(JNIEnv *env, jclass clazz, jintArray i0, jintArray n0, jdoubleArray z, jintArray pp, jintArray n0in, jdoubleArray dmin, jdoubleArray dmin1, jdoubleArray dmin2, jdoubleArray dn, jdoubleArray dn1, jdoubleArray dn2, jdoubleArray tau, jintArray ttype) {
  int i_loc;
  jint* i0_l;
  integer* i0_ll;
  jsize i0_ls;
  jint* n0_l;
  integer* n0_ll;
  jsize n0_ls;
  jdouble* z_ll;
  jint* pp_l;
  integer* pp_ll;
  jsize pp_ls;
  jint* n0in_l;
  integer* n0in_ll;
  jsize n0in_ls;
  jdouble* dmin_ll;
  jdouble* dmin1_ll;
  jdouble* dmin2_ll;
  jdouble* dn_ll;
  jdouble* dn1_ll;
  jdouble* dn2_ll;
  jdouble* tau_ll;
  jint* ttype_l;
  integer* ttype_ll;
  jsize ttype_ls;
  i0_l = (*env)->GetPrimitiveArrayCritical(env, i0, NULL);
  i0_ls = (*env)->GetArrayLength(env, i0);
  i0_ll = malloc(sizeof(integer)*i0_ls);
  for (i_loc=0; i_loc<i0_ls; ++i_loc) i0_ll[i_loc] = i0_l[i_loc];
  n0_l = (*env)->GetPrimitiveArrayCritical(env, n0, NULL);
  n0_ls = (*env)->GetArrayLength(env, n0);
  n0_ll = malloc(sizeof(integer)*n0_ls);
  for (i_loc=0; i_loc<n0_ls; ++i_loc) n0_ll[i_loc] = n0_l[i_loc];
  z_ll = (*env)->GetPrimitiveArrayCritical(env, z, NULL);
  pp_l = (*env)->GetPrimitiveArrayCritical(env, pp, NULL);
  pp_ls = (*env)->GetArrayLength(env, pp);
  pp_ll = malloc(sizeof(integer)*pp_ls);
  for (i_loc=0; i_loc<pp_ls; ++i_loc) pp_ll[i_loc] = pp_l[i_loc];
  n0in_l = (*env)->GetPrimitiveArrayCritical(env, n0in, NULL);
  n0in_ls = (*env)->GetArrayLength(env, n0in);
  n0in_ll = malloc(sizeof(integer)*n0in_ls);
  for (i_loc=0; i_loc<n0in_ls; ++i_loc) n0in_ll[i_loc] = n0in_l[i_loc];
  dmin_ll = (*env)->GetPrimitiveArrayCritical(env, dmin, NULL);
  dmin1_ll = (*env)->GetPrimitiveArrayCritical(env, dmin1, NULL);
  dmin2_ll = (*env)->GetPrimitiveArrayCritical(env, dmin2, NULL);
  dn_ll = (*env)->GetPrimitiveArrayCritical(env, dn, NULL);
  dn1_ll = (*env)->GetPrimitiveArrayCritical(env, dn1, NULL);
  dn2_ll = (*env)->GetPrimitiveArrayCritical(env, dn2, NULL);
  tau_ll = (*env)->GetPrimitiveArrayCritical(env, tau, NULL);
  ttype_l = (*env)->GetPrimitiveArrayCritical(env, ttype, NULL);
  ttype_ls = (*env)->GetArrayLength(env, ttype);
  ttype_ll = malloc(sizeof(integer)*ttype_ls);
  for (i_loc=0; i_loc<ttype_ls; ++i_loc) ttype_ll[i_loc] = ttype_l[i_loc];

  dlasq4_(i0_ll, n0_ll, z_ll, pp_ll, n0in_ll, dmin_ll, dmin1_ll, dmin2_ll, dn_ll, dn1_ll, dn2_ll, tau_ll, ttype_ll);

  for (i_loc=0; i_loc<i0_ls; ++i_loc) i0_l[i_loc] = i0_ll[i_loc];
  free(i0_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, i0, i0_l, 0);
  for (i_loc=0; i_loc<n0_ls; ++i_loc) n0_l[i_loc] = n0_ll[i_loc];
  free(n0_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n0, n0_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, z, z_ll, 0);
  for (i_loc=0; i_loc<pp_ls; ++i_loc) pp_l[i_loc] = pp_ll[i_loc];
  free(pp_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, pp, pp_l, 0);
  for (i_loc=0; i_loc<n0in_ls; ++i_loc) n0in_l[i_loc] = n0in_ll[i_loc];
  free(n0in_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n0in, n0in_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, dmin, dmin_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, dmin1, dmin1_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, dmin2, dmin2_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, dn, dn_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, dn1, dn1_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, dn2, dn2_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, tau, tau_ll, 0);
  for (i_loc=0; i_loc<ttype_ls; ++i_loc) ttype_l[i_loc] = ttype_ll[i_loc];
  free(ttype_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ttype, ttype_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_lasq5
(JNIEnv *env, jclass clazz, jintArray i0, jintArray n0, jdoubleArray z, jintArray pp, jdoubleArray tau, jdoubleArray dmin, jdoubleArray dmin1, jdoubleArray dmin2, jdoubleArray dn, jdoubleArray dnm1, jdoubleArray dnm2, jbooleanArray ieee) {
  int i_loc;
  jint* i0_l;
  integer* i0_ll;
  jsize i0_ls;
  jint* n0_l;
  integer* n0_ll;
  jsize n0_ls;
  jdouble* z_ll;
  jint* pp_l;
  integer* pp_ll;
  jsize pp_ls;
  jdouble* tau_ll;
  jdouble* dmin_ll;
  jdouble* dmin1_ll;
  jdouble* dmin2_ll;
  jdouble* dn_ll;
  jdouble* dnm1_ll;
  jdouble* dnm2_ll;
  jboolean* ieee_l;
  integer* ieee_ll;
  jsize ieee_ls;
  i0_l = (*env)->GetPrimitiveArrayCritical(env, i0, NULL);
  i0_ls = (*env)->GetArrayLength(env, i0);
  i0_ll = malloc(sizeof(integer)*i0_ls);
  for (i_loc=0; i_loc<i0_ls; ++i_loc) i0_ll[i_loc] = i0_l[i_loc];
  n0_l = (*env)->GetPrimitiveArrayCritical(env, n0, NULL);
  n0_ls = (*env)->GetArrayLength(env, n0);
  n0_ll = malloc(sizeof(integer)*n0_ls);
  for (i_loc=0; i_loc<n0_ls; ++i_loc) n0_ll[i_loc] = n0_l[i_loc];
  z_ll = (*env)->GetPrimitiveArrayCritical(env, z, NULL);
  pp_l = (*env)->GetPrimitiveArrayCritical(env, pp, NULL);
  pp_ls = (*env)->GetArrayLength(env, pp);
  pp_ll = malloc(sizeof(integer)*pp_ls);
  for (i_loc=0; i_loc<pp_ls; ++i_loc) pp_ll[i_loc] = pp_l[i_loc];
  tau_ll = (*env)->GetPrimitiveArrayCritical(env, tau, NULL);
  dmin_ll = (*env)->GetPrimitiveArrayCritical(env, dmin, NULL);
  dmin1_ll = (*env)->GetPrimitiveArrayCritical(env, dmin1, NULL);
  dmin2_ll = (*env)->GetPrimitiveArrayCritical(env, dmin2, NULL);
  dn_ll = (*env)->GetPrimitiveArrayCritical(env, dn, NULL);
  dnm1_ll = (*env)->GetPrimitiveArrayCritical(env, dnm1, NULL);
  dnm2_ll = (*env)->GetPrimitiveArrayCritical(env, dnm2, NULL);
  ieee_l = (*env)->GetPrimitiveArrayCritical(env, ieee, NULL);
  ieee_ls = (*env)->GetArrayLength(env, ieee);
  ieee_ll = malloc(sizeof(integer)*ieee_ls);
  for (i_loc=0; i_loc<ieee_ls; ++i_loc) ieee_ll[i_loc] = ieee_l[i_loc];

  dlasq5_(i0_ll, n0_ll, z_ll, pp_ll, tau_ll, dmin_ll, dmin1_ll, dmin2_ll, dn_ll, dnm1_ll, dnm2_ll, ieee_ll);

  for (i_loc=0; i_loc<i0_ls; ++i_loc) i0_l[i_loc] = i0_ll[i_loc];
  free(i0_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, i0, i0_l, 0);
  for (i_loc=0; i_loc<n0_ls; ++i_loc) n0_l[i_loc] = n0_ll[i_loc];
  free(n0_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n0, n0_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, z, z_ll, 0);
  for (i_loc=0; i_loc<pp_ls; ++i_loc) pp_l[i_loc] = pp_ll[i_loc];
  free(pp_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, pp, pp_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, tau, tau_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, dmin, dmin_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, dmin1, dmin1_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, dmin2, dmin2_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, dn, dn_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, dnm1, dnm1_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, dnm2, dnm2_ll, 0);
  for (i_loc=0; i_loc<ieee_ls; ++i_loc) ieee_l[i_loc] = ieee_ll[i_loc];
  free(ieee_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ieee, ieee_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_lasq6
(JNIEnv *env, jclass clazz, jintArray i0, jintArray n0, jdoubleArray z, jintArray pp, jdoubleArray dmin, jdoubleArray dmin1, jdoubleArray dmin2, jdoubleArray dn, jdoubleArray dnm1, jdoubleArray dnm2) {
  int i_loc;
  jint* i0_l;
  integer* i0_ll;
  jsize i0_ls;
  jint* n0_l;
  integer* n0_ll;
  jsize n0_ls;
  jdouble* z_ll;
  jint* pp_l;
  integer* pp_ll;
  jsize pp_ls;
  jdouble* dmin_ll;
  jdouble* dmin1_ll;
  jdouble* dmin2_ll;
  jdouble* dn_ll;
  jdouble* dnm1_ll;
  jdouble* dnm2_ll;
  i0_l = (*env)->GetPrimitiveArrayCritical(env, i0, NULL);
  i0_ls = (*env)->GetArrayLength(env, i0);
  i0_ll = malloc(sizeof(integer)*i0_ls);
  for (i_loc=0; i_loc<i0_ls; ++i_loc) i0_ll[i_loc] = i0_l[i_loc];
  n0_l = (*env)->GetPrimitiveArrayCritical(env, n0, NULL);
  n0_ls = (*env)->GetArrayLength(env, n0);
  n0_ll = malloc(sizeof(integer)*n0_ls);
  for (i_loc=0; i_loc<n0_ls; ++i_loc) n0_ll[i_loc] = n0_l[i_loc];
  z_ll = (*env)->GetPrimitiveArrayCritical(env, z, NULL);
  pp_l = (*env)->GetPrimitiveArrayCritical(env, pp, NULL);
  pp_ls = (*env)->GetArrayLength(env, pp);
  pp_ll = malloc(sizeof(integer)*pp_ls);
  for (i_loc=0; i_loc<pp_ls; ++i_loc) pp_ll[i_loc] = pp_l[i_loc];
  dmin_ll = (*env)->GetPrimitiveArrayCritical(env, dmin, NULL);
  dmin1_ll = (*env)->GetPrimitiveArrayCritical(env, dmin1, NULL);
  dmin2_ll = (*env)->GetPrimitiveArrayCritical(env, dmin2, NULL);
  dn_ll = (*env)->GetPrimitiveArrayCritical(env, dn, NULL);
  dnm1_ll = (*env)->GetPrimitiveArrayCritical(env, dnm1, NULL);
  dnm2_ll = (*env)->GetPrimitiveArrayCritical(env, dnm2, NULL);

  dlasq6_(i0_ll, n0_ll, z_ll, pp_ll, dmin_ll, dmin1_ll, dmin2_ll, dn_ll, dnm1_ll, dnm2_ll);

  for (i_loc=0; i_loc<i0_ls; ++i_loc) i0_l[i_loc] = i0_ll[i_loc];
  free(i0_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, i0, i0_l, 0);
  for (i_loc=0; i_loc<n0_ls; ++i_loc) n0_l[i_loc] = n0_ll[i_loc];
  free(n0_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n0, n0_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, z, z_ll, 0);
  for (i_loc=0; i_loc<pp_ls; ++i_loc) pp_l[i_loc] = pp_ll[i_loc];
  free(pp_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, pp, pp_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, dmin, dmin_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, dmin1, dmin1_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, dmin2, dmin2_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, dn, dn_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, dnm1, dnm1_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, dnm2, dnm2_ll, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_lasr
(JNIEnv *env, jclass clazz, jcharArray side, jcharArray pivot, jcharArray direct, jintArray m, jintArray n, jdoubleArray c, jdoubleArray s, jdoubleArray a, jintArray lda) {
  int i_loc;
  jchar* side_l;
  char* side_ll;
  jsize side_ls;
  jchar* pivot_l;
  char* pivot_ll;
  jsize pivot_ls;
  jchar* direct_l;
  char* direct_ll;
  jsize direct_ls;
  jint* m_l;
  integer* m_ll;
  jsize m_ls;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jdouble* c_ll;
  jdouble* s_ll;
  jdouble* a_ll;
  jint* lda_l;
  integer* lda_ll;
  jsize lda_ls;
  side_l = (*env)->GetPrimitiveArrayCritical(env, side, NULL);
  side_ls = (*env)->GetArrayLength(env, side);
  side_ll = malloc(sizeof(char)*side_ls);
  for (i_loc=0; i_loc<side_ls; ++i_loc) side_ll[i_loc] = side_l[i_loc];
  pivot_l = (*env)->GetPrimitiveArrayCritical(env, pivot, NULL);
  pivot_ls = (*env)->GetArrayLength(env, pivot);
  pivot_ll = malloc(sizeof(char)*pivot_ls);
  for (i_loc=0; i_loc<pivot_ls; ++i_loc) pivot_ll[i_loc] = pivot_l[i_loc];
  direct_l = (*env)->GetPrimitiveArrayCritical(env, direct, NULL);
  direct_ls = (*env)->GetArrayLength(env, direct);
  direct_ll = malloc(sizeof(char)*direct_ls);
  for (i_loc=0; i_loc<direct_ls; ++i_loc) direct_ll[i_loc] = direct_l[i_loc];
  m_l = (*env)->GetPrimitiveArrayCritical(env, m, NULL);
  m_ls = (*env)->GetArrayLength(env, m);
  m_ll = malloc(sizeof(integer)*m_ls);
  for (i_loc=0; i_loc<m_ls; ++i_loc) m_ll[i_loc] = m_l[i_loc];
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  c_ll = (*env)->GetPrimitiveArrayCritical(env, c, NULL);
  s_ll = (*env)->GetPrimitiveArrayCritical(env, s, NULL);
  a_ll = (*env)->GetPrimitiveArrayCritical(env, a, NULL);
  lda_l = (*env)->GetPrimitiveArrayCritical(env, lda, NULL);
  lda_ls = (*env)->GetArrayLength(env, lda);
  lda_ll = malloc(sizeof(integer)*lda_ls);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_ll[i_loc] = lda_l[i_loc];

  dlasr_(side_ll, pivot_ll, direct_ll, m_ll, n_ll, c_ll, s_ll, a_ll, lda_ll);

  for (i_loc=0; i_loc<side_ls; ++i_loc) side_l[i_loc] = side_ll[i_loc];
  free(side_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, side, side_l, 0);
  for (i_loc=0; i_loc<pivot_ls; ++i_loc) pivot_l[i_loc] = pivot_ll[i_loc];
  free(pivot_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, pivot, pivot_l, 0);
  for (i_loc=0; i_loc<direct_ls; ++i_loc) direct_l[i_loc] = direct_ll[i_loc];
  free(direct_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, direct, direct_l, 0);
  for (i_loc=0; i_loc<m_ls; ++i_loc) m_l[i_loc] = m_ll[i_loc];
  free(m_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, m, m_l, 0);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, c, c_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, s, s_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, a, a_ll, 0);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_l[i_loc] = lda_ll[i_loc];
  free(lda_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, lda, lda_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_lasrt
(JNIEnv *env, jclass clazz, jcharArray id, jintArray n, jdoubleArray d, jintArray info) {
  int i_loc;
  jchar* id_l;
  char* id_ll;
  jsize id_ls;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jdouble* d_ll;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  id_l = (*env)->GetPrimitiveArrayCritical(env, id, NULL);
  id_ls = (*env)->GetArrayLength(env, id);
  id_ll = malloc(sizeof(char)*id_ls);
  for (i_loc=0; i_loc<id_ls; ++i_loc) id_ll[i_loc] = id_l[i_loc];
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  d_ll = (*env)->GetPrimitiveArrayCritical(env, d, NULL);
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dlasrt_(id_ll, n_ll, d_ll, info_ll);

  for (i_loc=0; i_loc<id_ls; ++i_loc) id_l[i_loc] = id_ll[i_loc];
  free(id_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, id, id_l, 0);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, d, d_ll, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_lassq
(JNIEnv *env, jclass clazz, jintArray n, jdoubleArray x, jintArray incx, jdoubleArray scale, jdoubleArray sumsq) {
  int i_loc;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jdouble* x_ll;
  jint* incx_l;
  integer* incx_ll;
  jsize incx_ls;
  jdouble* scale_ll;
  jdouble* sumsq_ll;
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  x_ll = (*env)->GetPrimitiveArrayCritical(env, x, NULL);
  incx_l = (*env)->GetPrimitiveArrayCritical(env, incx, NULL);
  incx_ls = (*env)->GetArrayLength(env, incx);
  incx_ll = malloc(sizeof(integer)*incx_ls);
  for (i_loc=0; i_loc<incx_ls; ++i_loc) incx_ll[i_loc] = incx_l[i_loc];
  scale_ll = (*env)->GetPrimitiveArrayCritical(env, scale, NULL);
  sumsq_ll = (*env)->GetPrimitiveArrayCritical(env, sumsq, NULL);

  dlassq_(n_ll, x_ll, incx_ll, scale_ll, sumsq_ll);

  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, x, x_ll, 0);
  for (i_loc=0; i_loc<incx_ls; ++i_loc) incx_l[i_loc] = incx_ll[i_loc];
  free(incx_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, incx, incx_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, scale, scale_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, sumsq, sumsq_ll, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_lasv2
(JNIEnv *env, jclass clazz, jdoubleArray f, jdoubleArray g, jdoubleArray h, jdoubleArray ssmin, jdoubleArray ssmax, jdoubleArray snr, jdoubleArray csr, jdoubleArray snl, jdoubleArray csl) {
  jdouble* f_ll;
  jdouble* g_ll;
  jdouble* h_ll;
  jdouble* ssmin_ll;
  jdouble* ssmax_ll;
  jdouble* snr_ll;
  jdouble* csr_ll;
  jdouble* snl_ll;
  jdouble* csl_ll;
  f_ll = (*env)->GetPrimitiveArrayCritical(env, f, NULL);
  g_ll = (*env)->GetPrimitiveArrayCritical(env, g, NULL);
  h_ll = (*env)->GetPrimitiveArrayCritical(env, h, NULL);
  ssmin_ll = (*env)->GetPrimitiveArrayCritical(env, ssmin, NULL);
  ssmax_ll = (*env)->GetPrimitiveArrayCritical(env, ssmax, NULL);
  snr_ll = (*env)->GetPrimitiveArrayCritical(env, snr, NULL);
  csr_ll = (*env)->GetPrimitiveArrayCritical(env, csr, NULL);
  snl_ll = (*env)->GetPrimitiveArrayCritical(env, snl, NULL);
  csl_ll = (*env)->GetPrimitiveArrayCritical(env, csl, NULL);

  dlasv2_(f_ll, g_ll, h_ll, ssmin_ll, ssmax_ll, snr_ll, csr_ll, snl_ll, csl_ll);

  (*env)->ReleasePrimitiveArrayCritical(env, f, f_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, g, g_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, h, h_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, ssmin, ssmin_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, ssmax, ssmax_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, snr, snr_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, csr, csr_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, snl, snl_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, csl, csl_ll, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_laswp
(JNIEnv *env, jclass clazz, jintArray n, jdoubleArray a, jintArray lda, jintArray k1, jintArray k2, jintArray ipiv, jintArray incx) {
  int i_loc;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jdouble* a_ll;
  jint* lda_l;
  integer* lda_ll;
  jsize lda_ls;
  jint* k1_l;
  integer* k1_ll;
  jsize k1_ls;
  jint* k2_l;
  integer* k2_ll;
  jsize k2_ls;
  jint* ipiv_l;
  integer* ipiv_ll;
  jsize ipiv_ls;
  jint* incx_l;
  integer* incx_ll;
  jsize incx_ls;
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  a_ll = (*env)->GetPrimitiveArrayCritical(env, a, NULL);
  lda_l = (*env)->GetPrimitiveArrayCritical(env, lda, NULL);
  lda_ls = (*env)->GetArrayLength(env, lda);
  lda_ll = malloc(sizeof(integer)*lda_ls);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_ll[i_loc] = lda_l[i_loc];
  k1_l = (*env)->GetPrimitiveArrayCritical(env, k1, NULL);
  k1_ls = (*env)->GetArrayLength(env, k1);
  k1_ll = malloc(sizeof(integer)*k1_ls);
  for (i_loc=0; i_loc<k1_ls; ++i_loc) k1_ll[i_loc] = k1_l[i_loc];
  k2_l = (*env)->GetPrimitiveArrayCritical(env, k2, NULL);
  k2_ls = (*env)->GetArrayLength(env, k2);
  k2_ll = malloc(sizeof(integer)*k2_ls);
  for (i_loc=0; i_loc<k2_ls; ++i_loc) k2_ll[i_loc] = k2_l[i_loc];
  ipiv_l = (*env)->GetPrimitiveArrayCritical(env, ipiv, NULL);
  ipiv_ls = (*env)->GetArrayLength(env, ipiv);
  ipiv_ll = malloc(sizeof(integer)*ipiv_ls);
  for (i_loc=0; i_loc<ipiv_ls; ++i_loc) ipiv_ll[i_loc] = ipiv_l[i_loc];
  incx_l = (*env)->GetPrimitiveArrayCritical(env, incx, NULL);
  incx_ls = (*env)->GetArrayLength(env, incx);
  incx_ll = malloc(sizeof(integer)*incx_ls);
  for (i_loc=0; i_loc<incx_ls; ++i_loc) incx_ll[i_loc] = incx_l[i_loc];

  dlaswp_(n_ll, a_ll, lda_ll, k1_ll, k2_ll, ipiv_ll, incx_ll);

  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, a, a_ll, 0);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_l[i_loc] = lda_ll[i_loc];
  free(lda_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, lda, lda_l, 0);
  for (i_loc=0; i_loc<k1_ls; ++i_loc) k1_l[i_loc] = k1_ll[i_loc];
  free(k1_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, k1, k1_l, 0);
  for (i_loc=0; i_loc<k2_ls; ++i_loc) k2_l[i_loc] = k2_ll[i_loc];
  free(k2_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, k2, k2_l, 0);
  for (i_loc=0; i_loc<ipiv_ls; ++i_loc) ipiv_l[i_loc] = ipiv_ll[i_loc];
  free(ipiv_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ipiv, ipiv_l, 0);
  for (i_loc=0; i_loc<incx_ls; ++i_loc) incx_l[i_loc] = incx_ll[i_loc];
  free(incx_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, incx, incx_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_lasy2
(JNIEnv *env, jclass clazz, jbooleanArray ltranl, jbooleanArray ltranr, jintArray isgn, jintArray n1, jintArray n2, jdoubleArray tl, jintArray ldtl, jdoubleArray tr, jintArray ldtr, jdoubleArray b, jintArray ldb, jdoubleArray scale, jdoubleArray x, jintArray ldx, jdoubleArray xnorm, jintArray info) {
  int i_loc;
  jboolean* ltranl_l;
  integer* ltranl_ll;
  jsize ltranl_ls;
  jboolean* ltranr_l;
  integer* ltranr_ll;
  jsize ltranr_ls;
  jint* isgn_l;
  integer* isgn_ll;
  jsize isgn_ls;
  jint* n1_l;
  integer* n1_ll;
  jsize n1_ls;
  jint* n2_l;
  integer* n2_ll;
  jsize n2_ls;
  jdouble* tl_ll;
  jint* ldtl_l;
  integer* ldtl_ll;
  jsize ldtl_ls;
  jdouble* tr_ll;
  jint* ldtr_l;
  integer* ldtr_ll;
  jsize ldtr_ls;
  jdouble* b_ll;
  jint* ldb_l;
  integer* ldb_ll;
  jsize ldb_ls;
  jdouble* scale_ll;
  jdouble* x_ll;
  jint* ldx_l;
  integer* ldx_ll;
  jsize ldx_ls;
  jdouble* xnorm_ll;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  ltranl_l = (*env)->GetPrimitiveArrayCritical(env, ltranl, NULL);
  ltranl_ls = (*env)->GetArrayLength(env, ltranl);
  ltranl_ll = malloc(sizeof(integer)*ltranl_ls);
  for (i_loc=0; i_loc<ltranl_ls; ++i_loc) ltranl_ll[i_loc] = ltranl_l[i_loc];
  ltranr_l = (*env)->GetPrimitiveArrayCritical(env, ltranr, NULL);
  ltranr_ls = (*env)->GetArrayLength(env, ltranr);
  ltranr_ll = malloc(sizeof(integer)*ltranr_ls);
  for (i_loc=0; i_loc<ltranr_ls; ++i_loc) ltranr_ll[i_loc] = ltranr_l[i_loc];
  isgn_l = (*env)->GetPrimitiveArrayCritical(env, isgn, NULL);
  isgn_ls = (*env)->GetArrayLength(env, isgn);
  isgn_ll = malloc(sizeof(integer)*isgn_ls);
  for (i_loc=0; i_loc<isgn_ls; ++i_loc) isgn_ll[i_loc] = isgn_l[i_loc];
  n1_l = (*env)->GetPrimitiveArrayCritical(env, n1, NULL);
  n1_ls = (*env)->GetArrayLength(env, n1);
  n1_ll = malloc(sizeof(integer)*n1_ls);
  for (i_loc=0; i_loc<n1_ls; ++i_loc) n1_ll[i_loc] = n1_l[i_loc];
  n2_l = (*env)->GetPrimitiveArrayCritical(env, n2, NULL);
  n2_ls = (*env)->GetArrayLength(env, n2);
  n2_ll = malloc(sizeof(integer)*n2_ls);
  for (i_loc=0; i_loc<n2_ls; ++i_loc) n2_ll[i_loc] = n2_l[i_loc];
  tl_ll = (*env)->GetPrimitiveArrayCritical(env, tl, NULL);
  ldtl_l = (*env)->GetPrimitiveArrayCritical(env, ldtl, NULL);
  ldtl_ls = (*env)->GetArrayLength(env, ldtl);
  ldtl_ll = malloc(sizeof(integer)*ldtl_ls);
  for (i_loc=0; i_loc<ldtl_ls; ++i_loc) ldtl_ll[i_loc] = ldtl_l[i_loc];
  tr_ll = (*env)->GetPrimitiveArrayCritical(env, tr, NULL);
  ldtr_l = (*env)->GetPrimitiveArrayCritical(env, ldtr, NULL);
  ldtr_ls = (*env)->GetArrayLength(env, ldtr);
  ldtr_ll = malloc(sizeof(integer)*ldtr_ls);
  for (i_loc=0; i_loc<ldtr_ls; ++i_loc) ldtr_ll[i_loc] = ldtr_l[i_loc];
  b_ll = (*env)->GetPrimitiveArrayCritical(env, b, NULL);
  ldb_l = (*env)->GetPrimitiveArrayCritical(env, ldb, NULL);
  ldb_ls = (*env)->GetArrayLength(env, ldb);
  ldb_ll = malloc(sizeof(integer)*ldb_ls);
  for (i_loc=0; i_loc<ldb_ls; ++i_loc) ldb_ll[i_loc] = ldb_l[i_loc];
  scale_ll = (*env)->GetPrimitiveArrayCritical(env, scale, NULL);
  x_ll = (*env)->GetPrimitiveArrayCritical(env, x, NULL);
  ldx_l = (*env)->GetPrimitiveArrayCritical(env, ldx, NULL);
  ldx_ls = (*env)->GetArrayLength(env, ldx);
  ldx_ll = malloc(sizeof(integer)*ldx_ls);
  for (i_loc=0; i_loc<ldx_ls; ++i_loc) ldx_ll[i_loc] = ldx_l[i_loc];
  xnorm_ll = (*env)->GetPrimitiveArrayCritical(env, xnorm, NULL);
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dlasy2_(ltranl_ll, ltranr_ll, isgn_ll, n1_ll, n2_ll, tl_ll, ldtl_ll, tr_ll, ldtr_ll, b_ll, ldb_ll, scale_ll, x_ll, ldx_ll, xnorm_ll, info_ll);

  for (i_loc=0; i_loc<ltranl_ls; ++i_loc) ltranl_l[i_loc] = ltranl_ll[i_loc];
  free(ltranl_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ltranl, ltranl_l, 0);
  for (i_loc=0; i_loc<ltranr_ls; ++i_loc) ltranr_l[i_loc] = ltranr_ll[i_loc];
  free(ltranr_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ltranr, ltranr_l, 0);
  for (i_loc=0; i_loc<isgn_ls; ++i_loc) isgn_l[i_loc] = isgn_ll[i_loc];
  free(isgn_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, isgn, isgn_l, 0);
  for (i_loc=0; i_loc<n1_ls; ++i_loc) n1_l[i_loc] = n1_ll[i_loc];
  free(n1_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n1, n1_l, 0);
  for (i_loc=0; i_loc<n2_ls; ++i_loc) n2_l[i_loc] = n2_ll[i_loc];
  free(n2_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n2, n2_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, tl, tl_ll, 0);
  for (i_loc=0; i_loc<ldtl_ls; ++i_loc) ldtl_l[i_loc] = ldtl_ll[i_loc];
  free(ldtl_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldtl, ldtl_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, tr, tr_ll, 0);
  for (i_loc=0; i_loc<ldtr_ls; ++i_loc) ldtr_l[i_loc] = ldtr_ll[i_loc];
  free(ldtr_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldtr, ldtr_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, b, b_ll, 0);
  for (i_loc=0; i_loc<ldb_ls; ++i_loc) ldb_l[i_loc] = ldb_ll[i_loc];
  free(ldb_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldb, ldb_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, scale, scale_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, x, x_ll, 0);
  for (i_loc=0; i_loc<ldx_ls; ++i_loc) ldx_l[i_loc] = ldx_ll[i_loc];
  free(ldx_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldx, ldx_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, xnorm, xnorm_ll, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_lasyf
(JNIEnv *env, jclass clazz, jcharArray uplo, jintArray n, jintArray nb, jintArray kb, jdoubleArray a, jintArray lda, jintArray ipiv, jdoubleArray w, jintArray ldw, jintArray info) {
  int i_loc;
  jchar* uplo_l;
  char* uplo_ll;
  jsize uplo_ls;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jint* nb_l;
  integer* nb_ll;
  jsize nb_ls;
  jint* kb_l;
  integer* kb_ll;
  jsize kb_ls;
  jdouble* a_ll;
  jint* lda_l;
  integer* lda_ll;
  jsize lda_ls;
  jint* ipiv_l;
  integer* ipiv_ll;
  jsize ipiv_ls;
  jdouble* w_ll;
  jint* ldw_l;
  integer* ldw_ll;
  jsize ldw_ls;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  uplo_l = (*env)->GetPrimitiveArrayCritical(env, uplo, NULL);
  uplo_ls = (*env)->GetArrayLength(env, uplo);
  uplo_ll = malloc(sizeof(char)*uplo_ls);
  for (i_loc=0; i_loc<uplo_ls; ++i_loc) uplo_ll[i_loc] = uplo_l[i_loc];
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  nb_l = (*env)->GetPrimitiveArrayCritical(env, nb, NULL);
  nb_ls = (*env)->GetArrayLength(env, nb);
  nb_ll = malloc(sizeof(integer)*nb_ls);
  for (i_loc=0; i_loc<nb_ls; ++i_loc) nb_ll[i_loc] = nb_l[i_loc];
  kb_l = (*env)->GetPrimitiveArrayCritical(env, kb, NULL);
  kb_ls = (*env)->GetArrayLength(env, kb);
  kb_ll = malloc(sizeof(integer)*kb_ls);
  for (i_loc=0; i_loc<kb_ls; ++i_loc) kb_ll[i_loc] = kb_l[i_loc];
  a_ll = (*env)->GetPrimitiveArrayCritical(env, a, NULL);
  lda_l = (*env)->GetPrimitiveArrayCritical(env, lda, NULL);
  lda_ls = (*env)->GetArrayLength(env, lda);
  lda_ll = malloc(sizeof(integer)*lda_ls);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_ll[i_loc] = lda_l[i_loc];
  ipiv_l = (*env)->GetPrimitiveArrayCritical(env, ipiv, NULL);
  ipiv_ls = (*env)->GetArrayLength(env, ipiv);
  ipiv_ll = malloc(sizeof(integer)*ipiv_ls);
  for (i_loc=0; i_loc<ipiv_ls; ++i_loc) ipiv_ll[i_loc] = ipiv_l[i_loc];
  w_ll = (*env)->GetPrimitiveArrayCritical(env, w, NULL);
  ldw_l = (*env)->GetPrimitiveArrayCritical(env, ldw, NULL);
  ldw_ls = (*env)->GetArrayLength(env, ldw);
  ldw_ll = malloc(sizeof(integer)*ldw_ls);
  for (i_loc=0; i_loc<ldw_ls; ++i_loc) ldw_ll[i_loc] = ldw_l[i_loc];
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dlasyf_(uplo_ll, n_ll, nb_ll, kb_ll, a_ll, lda_ll, ipiv_ll, w_ll, ldw_ll, info_ll);

  for (i_loc=0; i_loc<uplo_ls; ++i_loc) uplo_l[i_loc] = uplo_ll[i_loc];
  free(uplo_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, uplo, uplo_l, 0);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  for (i_loc=0; i_loc<nb_ls; ++i_loc) nb_l[i_loc] = nb_ll[i_loc];
  free(nb_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, nb, nb_l, 0);
  for (i_loc=0; i_loc<kb_ls; ++i_loc) kb_l[i_loc] = kb_ll[i_loc];
  free(kb_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, kb, kb_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, a, a_ll, 0);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_l[i_loc] = lda_ll[i_loc];
  free(lda_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, lda, lda_l, 0);
  for (i_loc=0; i_loc<ipiv_ls; ++i_loc) ipiv_l[i_loc] = ipiv_ll[i_loc];
  free(ipiv_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ipiv, ipiv_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, w, w_ll, 0);
  for (i_loc=0; i_loc<ldw_ls; ++i_loc) ldw_l[i_loc] = ldw_ll[i_loc];
  free(ldw_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldw, ldw_l, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_latbs
(JNIEnv *env, jclass clazz, jcharArray uplo, jcharArray trans, jcharArray diag, jcharArray normin, jintArray n, jintArray kd, jdoubleArray ab, jintArray ldab, jdoubleArray x, jdoubleArray scale, jdoubleArray cnorm, jintArray info) {
  int i_loc;
  jchar* uplo_l;
  char* uplo_ll;
  jsize uplo_ls;
  jchar* trans_l;
  char* trans_ll;
  jsize trans_ls;
  jchar* diag_l;
  char* diag_ll;
  jsize diag_ls;
  jchar* normin_l;
  char* normin_ll;
  jsize normin_ls;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jint* kd_l;
  integer* kd_ll;
  jsize kd_ls;
  jdouble* ab_ll;
  jint* ldab_l;
  integer* ldab_ll;
  jsize ldab_ls;
  jdouble* x_ll;
  jdouble* scale_ll;
  jdouble* cnorm_ll;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  uplo_l = (*env)->GetPrimitiveArrayCritical(env, uplo, NULL);
  uplo_ls = (*env)->GetArrayLength(env, uplo);
  uplo_ll = malloc(sizeof(char)*uplo_ls);
  for (i_loc=0; i_loc<uplo_ls; ++i_loc) uplo_ll[i_loc] = uplo_l[i_loc];
  trans_l = (*env)->GetPrimitiveArrayCritical(env, trans, NULL);
  trans_ls = (*env)->GetArrayLength(env, trans);
  trans_ll = malloc(sizeof(char)*trans_ls);
  for (i_loc=0; i_loc<trans_ls; ++i_loc) trans_ll[i_loc] = trans_l[i_loc];
  diag_l = (*env)->GetPrimitiveArrayCritical(env, diag, NULL);
  diag_ls = (*env)->GetArrayLength(env, diag);
  diag_ll = malloc(sizeof(char)*diag_ls);
  for (i_loc=0; i_loc<diag_ls; ++i_loc) diag_ll[i_loc] = diag_l[i_loc];
  normin_l = (*env)->GetPrimitiveArrayCritical(env, normin, NULL);
  normin_ls = (*env)->GetArrayLength(env, normin);
  normin_ll = malloc(sizeof(char)*normin_ls);
  for (i_loc=0; i_loc<normin_ls; ++i_loc) normin_ll[i_loc] = normin_l[i_loc];
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  kd_l = (*env)->GetPrimitiveArrayCritical(env, kd, NULL);
  kd_ls = (*env)->GetArrayLength(env, kd);
  kd_ll = malloc(sizeof(integer)*kd_ls);
  for (i_loc=0; i_loc<kd_ls; ++i_loc) kd_ll[i_loc] = kd_l[i_loc];
  ab_ll = (*env)->GetPrimitiveArrayCritical(env, ab, NULL);
  ldab_l = (*env)->GetPrimitiveArrayCritical(env, ldab, NULL);
  ldab_ls = (*env)->GetArrayLength(env, ldab);
  ldab_ll = malloc(sizeof(integer)*ldab_ls);
  for (i_loc=0; i_loc<ldab_ls; ++i_loc) ldab_ll[i_loc] = ldab_l[i_loc];
  x_ll = (*env)->GetPrimitiveArrayCritical(env, x, NULL);
  scale_ll = (*env)->GetPrimitiveArrayCritical(env, scale, NULL);
  cnorm_ll = (*env)->GetPrimitiveArrayCritical(env, cnorm, NULL);
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dlatbs_(uplo_ll, trans_ll, diag_ll, normin_ll, n_ll, kd_ll, ab_ll, ldab_ll, x_ll, scale_ll, cnorm_ll, info_ll);

  for (i_loc=0; i_loc<uplo_ls; ++i_loc) uplo_l[i_loc] = uplo_ll[i_loc];
  free(uplo_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, uplo, uplo_l, 0);
  for (i_loc=0; i_loc<trans_ls; ++i_loc) trans_l[i_loc] = trans_ll[i_loc];
  free(trans_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, trans, trans_l, 0);
  for (i_loc=0; i_loc<diag_ls; ++i_loc) diag_l[i_loc] = diag_ll[i_loc];
  free(diag_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, diag, diag_l, 0);
  for (i_loc=0; i_loc<normin_ls; ++i_loc) normin_l[i_loc] = normin_ll[i_loc];
  free(normin_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, normin, normin_l, 0);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  for (i_loc=0; i_loc<kd_ls; ++i_loc) kd_l[i_loc] = kd_ll[i_loc];
  free(kd_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, kd, kd_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, ab, ab_ll, 0);
  for (i_loc=0; i_loc<ldab_ls; ++i_loc) ldab_l[i_loc] = ldab_ll[i_loc];
  free(ldab_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldab, ldab_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, x, x_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, scale, scale_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, cnorm, cnorm_ll, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_latdf
(JNIEnv *env, jclass clazz, jintArray ijob, jintArray n, jdoubleArray z, jintArray ldz, jdoubleArray rhs, jdoubleArray rdsum, jdoubleArray rdscal, jintArray ipiv, jintArray jpiv) {
  int i_loc;
  jint* ijob_l;
  integer* ijob_ll;
  jsize ijob_ls;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jdouble* z_ll;
  jint* ldz_l;
  integer* ldz_ll;
  jsize ldz_ls;
  jdouble* rhs_ll;
  jdouble* rdsum_ll;
  jdouble* rdscal_ll;
  jint* ipiv_l;
  integer* ipiv_ll;
  jsize ipiv_ls;
  jint* jpiv_l;
  integer* jpiv_ll;
  jsize jpiv_ls;
  ijob_l = (*env)->GetPrimitiveArrayCritical(env, ijob, NULL);
  ijob_ls = (*env)->GetArrayLength(env, ijob);
  ijob_ll = malloc(sizeof(integer)*ijob_ls);
  for (i_loc=0; i_loc<ijob_ls; ++i_loc) ijob_ll[i_loc] = ijob_l[i_loc];
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  z_ll = (*env)->GetPrimitiveArrayCritical(env, z, NULL);
  ldz_l = (*env)->GetPrimitiveArrayCritical(env, ldz, NULL);
  ldz_ls = (*env)->GetArrayLength(env, ldz);
  ldz_ll = malloc(sizeof(integer)*ldz_ls);
  for (i_loc=0; i_loc<ldz_ls; ++i_loc) ldz_ll[i_loc] = ldz_l[i_loc];
  rhs_ll = (*env)->GetPrimitiveArrayCritical(env, rhs, NULL);
  rdsum_ll = (*env)->GetPrimitiveArrayCritical(env, rdsum, NULL);
  rdscal_ll = (*env)->GetPrimitiveArrayCritical(env, rdscal, NULL);
  ipiv_l = (*env)->GetPrimitiveArrayCritical(env, ipiv, NULL);
  ipiv_ls = (*env)->GetArrayLength(env, ipiv);
  ipiv_ll = malloc(sizeof(integer)*ipiv_ls);
  for (i_loc=0; i_loc<ipiv_ls; ++i_loc) ipiv_ll[i_loc] = ipiv_l[i_loc];
  jpiv_l = (*env)->GetPrimitiveArrayCritical(env, jpiv, NULL);
  jpiv_ls = (*env)->GetArrayLength(env, jpiv);
  jpiv_ll = malloc(sizeof(integer)*jpiv_ls);
  for (i_loc=0; i_loc<jpiv_ls; ++i_loc) jpiv_ll[i_loc] = jpiv_l[i_loc];

  dlatdf_(ijob_ll, n_ll, z_ll, ldz_ll, rhs_ll, rdsum_ll, rdscal_ll, ipiv_ll, jpiv_ll);

  for (i_loc=0; i_loc<ijob_ls; ++i_loc) ijob_l[i_loc] = ijob_ll[i_loc];
  free(ijob_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ijob, ijob_l, 0);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, z, z_ll, 0);
  for (i_loc=0; i_loc<ldz_ls; ++i_loc) ldz_l[i_loc] = ldz_ll[i_loc];
  free(ldz_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldz, ldz_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, rhs, rhs_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, rdsum, rdsum_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, rdscal, rdscal_ll, 0);
  for (i_loc=0; i_loc<ipiv_ls; ++i_loc) ipiv_l[i_loc] = ipiv_ll[i_loc];
  free(ipiv_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ipiv, ipiv_l, 0);
  for (i_loc=0; i_loc<jpiv_ls; ++i_loc) jpiv_l[i_loc] = jpiv_ll[i_loc];
  free(jpiv_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, jpiv, jpiv_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_latps
(JNIEnv *env, jclass clazz, jcharArray uplo, jcharArray trans, jcharArray diag, jcharArray normin, jintArray n, jdoubleArray ap, jdoubleArray x, jdoubleArray scale, jdoubleArray cnorm, jintArray info) {
  int i_loc;
  jchar* uplo_l;
  char* uplo_ll;
  jsize uplo_ls;
  jchar* trans_l;
  char* trans_ll;
  jsize trans_ls;
  jchar* diag_l;
  char* diag_ll;
  jsize diag_ls;
  jchar* normin_l;
  char* normin_ll;
  jsize normin_ls;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jdouble* ap_ll;
  jdouble* x_ll;
  jdouble* scale_ll;
  jdouble* cnorm_ll;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  uplo_l = (*env)->GetPrimitiveArrayCritical(env, uplo, NULL);
  uplo_ls = (*env)->GetArrayLength(env, uplo);
  uplo_ll = malloc(sizeof(char)*uplo_ls);
  for (i_loc=0; i_loc<uplo_ls; ++i_loc) uplo_ll[i_loc] = uplo_l[i_loc];
  trans_l = (*env)->GetPrimitiveArrayCritical(env, trans, NULL);
  trans_ls = (*env)->GetArrayLength(env, trans);
  trans_ll = malloc(sizeof(char)*trans_ls);
  for (i_loc=0; i_loc<trans_ls; ++i_loc) trans_ll[i_loc] = trans_l[i_loc];
  diag_l = (*env)->GetPrimitiveArrayCritical(env, diag, NULL);
  diag_ls = (*env)->GetArrayLength(env, diag);
  diag_ll = malloc(sizeof(char)*diag_ls);
  for (i_loc=0; i_loc<diag_ls; ++i_loc) diag_ll[i_loc] = diag_l[i_loc];
  normin_l = (*env)->GetPrimitiveArrayCritical(env, normin, NULL);
  normin_ls = (*env)->GetArrayLength(env, normin);
  normin_ll = malloc(sizeof(char)*normin_ls);
  for (i_loc=0; i_loc<normin_ls; ++i_loc) normin_ll[i_loc] = normin_l[i_loc];
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  ap_ll = (*env)->GetPrimitiveArrayCritical(env, ap, NULL);
  x_ll = (*env)->GetPrimitiveArrayCritical(env, x, NULL);
  scale_ll = (*env)->GetPrimitiveArrayCritical(env, scale, NULL);
  cnorm_ll = (*env)->GetPrimitiveArrayCritical(env, cnorm, NULL);
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dlatps_(uplo_ll, trans_ll, diag_ll, normin_ll, n_ll, ap_ll, x_ll, scale_ll, cnorm_ll, info_ll);

  for (i_loc=0; i_loc<uplo_ls; ++i_loc) uplo_l[i_loc] = uplo_ll[i_loc];
  free(uplo_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, uplo, uplo_l, 0);
  for (i_loc=0; i_loc<trans_ls; ++i_loc) trans_l[i_loc] = trans_ll[i_loc];
  free(trans_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, trans, trans_l, 0);
  for (i_loc=0; i_loc<diag_ls; ++i_loc) diag_l[i_loc] = diag_ll[i_loc];
  free(diag_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, diag, diag_l, 0);
  for (i_loc=0; i_loc<normin_ls; ++i_loc) normin_l[i_loc] = normin_ll[i_loc];
  free(normin_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, normin, normin_l, 0);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, ap, ap_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, x, x_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, scale, scale_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, cnorm, cnorm_ll, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_latrd
(JNIEnv *env, jclass clazz, jcharArray uplo, jintArray n, jintArray nb, jdoubleArray a, jintArray lda, jdoubleArray e, jdoubleArray tau, jdoubleArray w, jintArray ldw) {
  int i_loc;
  jchar* uplo_l;
  char* uplo_ll;
  jsize uplo_ls;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jint* nb_l;
  integer* nb_ll;
  jsize nb_ls;
  jdouble* a_ll;
  jint* lda_l;
  integer* lda_ll;
  jsize lda_ls;
  jdouble* e_ll;
  jdouble* tau_ll;
  jdouble* w_ll;
  jint* ldw_l;
  integer* ldw_ll;
  jsize ldw_ls;
  uplo_l = (*env)->GetPrimitiveArrayCritical(env, uplo, NULL);
  uplo_ls = (*env)->GetArrayLength(env, uplo);
  uplo_ll = malloc(sizeof(char)*uplo_ls);
  for (i_loc=0; i_loc<uplo_ls; ++i_loc) uplo_ll[i_loc] = uplo_l[i_loc];
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  nb_l = (*env)->GetPrimitiveArrayCritical(env, nb, NULL);
  nb_ls = (*env)->GetArrayLength(env, nb);
  nb_ll = malloc(sizeof(integer)*nb_ls);
  for (i_loc=0; i_loc<nb_ls; ++i_loc) nb_ll[i_loc] = nb_l[i_loc];
  a_ll = (*env)->GetPrimitiveArrayCritical(env, a, NULL);
  lda_l = (*env)->GetPrimitiveArrayCritical(env, lda, NULL);
  lda_ls = (*env)->GetArrayLength(env, lda);
  lda_ll = malloc(sizeof(integer)*lda_ls);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_ll[i_loc] = lda_l[i_loc];
  e_ll = (*env)->GetPrimitiveArrayCritical(env, e, NULL);
  tau_ll = (*env)->GetPrimitiveArrayCritical(env, tau, NULL);
  w_ll = (*env)->GetPrimitiveArrayCritical(env, w, NULL);
  ldw_l = (*env)->GetPrimitiveArrayCritical(env, ldw, NULL);
  ldw_ls = (*env)->GetArrayLength(env, ldw);
  ldw_ll = malloc(sizeof(integer)*ldw_ls);
  for (i_loc=0; i_loc<ldw_ls; ++i_loc) ldw_ll[i_loc] = ldw_l[i_loc];

  dlatrd_(uplo_ll, n_ll, nb_ll, a_ll, lda_ll, e_ll, tau_ll, w_ll, ldw_ll);

  for (i_loc=0; i_loc<uplo_ls; ++i_loc) uplo_l[i_loc] = uplo_ll[i_loc];
  free(uplo_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, uplo, uplo_l, 0);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  for (i_loc=0; i_loc<nb_ls; ++i_loc) nb_l[i_loc] = nb_ll[i_loc];
  free(nb_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, nb, nb_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, a, a_ll, 0);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_l[i_loc] = lda_ll[i_loc];
  free(lda_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, lda, lda_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, e, e_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, tau, tau_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, w, w_ll, 0);
  for (i_loc=0; i_loc<ldw_ls; ++i_loc) ldw_l[i_loc] = ldw_ll[i_loc];
  free(ldw_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldw, ldw_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_latrs
(JNIEnv *env, jclass clazz, jcharArray uplo, jcharArray trans, jcharArray diag, jcharArray normin, jintArray n, jdoubleArray a, jintArray lda, jdoubleArray x, jdoubleArray scale, jdoubleArray cnorm, jintArray info) {
  int i_loc;
  jchar* uplo_l;
  char* uplo_ll;
  jsize uplo_ls;
  jchar* trans_l;
  char* trans_ll;
  jsize trans_ls;
  jchar* diag_l;
  char* diag_ll;
  jsize diag_ls;
  jchar* normin_l;
  char* normin_ll;
  jsize normin_ls;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jdouble* a_ll;
  jint* lda_l;
  integer* lda_ll;
  jsize lda_ls;
  jdouble* x_ll;
  jdouble* scale_ll;
  jdouble* cnorm_ll;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  uplo_l = (*env)->GetPrimitiveArrayCritical(env, uplo, NULL);
  uplo_ls = (*env)->GetArrayLength(env, uplo);
  uplo_ll = malloc(sizeof(char)*uplo_ls);
  for (i_loc=0; i_loc<uplo_ls; ++i_loc) uplo_ll[i_loc] = uplo_l[i_loc];
  trans_l = (*env)->GetPrimitiveArrayCritical(env, trans, NULL);
  trans_ls = (*env)->GetArrayLength(env, trans);
  trans_ll = malloc(sizeof(char)*trans_ls);
  for (i_loc=0; i_loc<trans_ls; ++i_loc) trans_ll[i_loc] = trans_l[i_loc];
  diag_l = (*env)->GetPrimitiveArrayCritical(env, diag, NULL);
  diag_ls = (*env)->GetArrayLength(env, diag);
  diag_ll = malloc(sizeof(char)*diag_ls);
  for (i_loc=0; i_loc<diag_ls; ++i_loc) diag_ll[i_loc] = diag_l[i_loc];
  normin_l = (*env)->GetPrimitiveArrayCritical(env, normin, NULL);
  normin_ls = (*env)->GetArrayLength(env, normin);
  normin_ll = malloc(sizeof(char)*normin_ls);
  for (i_loc=0; i_loc<normin_ls; ++i_loc) normin_ll[i_loc] = normin_l[i_loc];
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  a_ll = (*env)->GetPrimitiveArrayCritical(env, a, NULL);
  lda_l = (*env)->GetPrimitiveArrayCritical(env, lda, NULL);
  lda_ls = (*env)->GetArrayLength(env, lda);
  lda_ll = malloc(sizeof(integer)*lda_ls);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_ll[i_loc] = lda_l[i_loc];
  x_ll = (*env)->GetPrimitiveArrayCritical(env, x, NULL);
  scale_ll = (*env)->GetPrimitiveArrayCritical(env, scale, NULL);
  cnorm_ll = (*env)->GetPrimitiveArrayCritical(env, cnorm, NULL);
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dlatrs_(uplo_ll, trans_ll, diag_ll, normin_ll, n_ll, a_ll, lda_ll, x_ll, scale_ll, cnorm_ll, info_ll);

  for (i_loc=0; i_loc<uplo_ls; ++i_loc) uplo_l[i_loc] = uplo_ll[i_loc];
  free(uplo_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, uplo, uplo_l, 0);
  for (i_loc=0; i_loc<trans_ls; ++i_loc) trans_l[i_loc] = trans_ll[i_loc];
  free(trans_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, trans, trans_l, 0);
  for (i_loc=0; i_loc<diag_ls; ++i_loc) diag_l[i_loc] = diag_ll[i_loc];
  free(diag_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, diag, diag_l, 0);
  for (i_loc=0; i_loc<normin_ls; ++i_loc) normin_l[i_loc] = normin_ll[i_loc];
  free(normin_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, normin, normin_l, 0);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, a, a_ll, 0);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_l[i_loc] = lda_ll[i_loc];
  free(lda_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, lda, lda_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, x, x_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, scale, scale_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, cnorm, cnorm_ll, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_latrz
(JNIEnv *env, jclass clazz, jintArray m, jintArray n, jintArray l, jdoubleArray a, jintArray lda, jdoubleArray tau, jdoubleArray work) {
  int i_loc;
  jint* m_l;
  integer* m_ll;
  jsize m_ls;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jint* l_l;
  integer* l_ll;
  jsize l_ls;
  jdouble* a_ll;
  jint* lda_l;
  integer* lda_ll;
  jsize lda_ls;
  jdouble* tau_ll;
  jdouble* work_ll;
  m_l = (*env)->GetPrimitiveArrayCritical(env, m, NULL);
  m_ls = (*env)->GetArrayLength(env, m);
  m_ll = malloc(sizeof(integer)*m_ls);
  for (i_loc=0; i_loc<m_ls; ++i_loc) m_ll[i_loc] = m_l[i_loc];
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  l_l = (*env)->GetPrimitiveArrayCritical(env, l, NULL);
  l_ls = (*env)->GetArrayLength(env, l);
  l_ll = malloc(sizeof(integer)*l_ls);
  for (i_loc=0; i_loc<l_ls; ++i_loc) l_ll[i_loc] = l_l[i_loc];
  a_ll = (*env)->GetPrimitiveArrayCritical(env, a, NULL);
  lda_l = (*env)->GetPrimitiveArrayCritical(env, lda, NULL);
  lda_ls = (*env)->GetArrayLength(env, lda);
  lda_ll = malloc(sizeof(integer)*lda_ls);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_ll[i_loc] = lda_l[i_loc];
  tau_ll = (*env)->GetPrimitiveArrayCritical(env, tau, NULL);
  work_ll = (*env)->GetPrimitiveArrayCritical(env, work, NULL);

  dlatrz_(m_ll, n_ll, l_ll, a_ll, lda_ll, tau_ll, work_ll);

  for (i_loc=0; i_loc<m_ls; ++i_loc) m_l[i_loc] = m_ll[i_loc];
  free(m_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, m, m_l, 0);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  for (i_loc=0; i_loc<l_ls; ++i_loc) l_l[i_loc] = l_ll[i_loc];
  free(l_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, l, l_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, a, a_ll, 0);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_l[i_loc] = lda_ll[i_loc];
  free(lda_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, lda, lda_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, tau, tau_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, work, work_ll, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_latzm
(JNIEnv *env, jclass clazz, jcharArray side, jintArray m, jintArray n, jdoubleArray v, jintArray incv, jdoubleArray tau, jdoubleArray c1, jdoubleArray c2, jintArray ldc, jdoubleArray work) {
  int i_loc;
  jchar* side_l;
  char* side_ll;
  jsize side_ls;
  jint* m_l;
  integer* m_ll;
  jsize m_ls;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jdouble* v_ll;
  jint* incv_l;
  integer* incv_ll;
  jsize incv_ls;
  jdouble* tau_ll;
  jdouble* c1_ll;
  jdouble* c2_ll;
  jint* ldc_l;
  integer* ldc_ll;
  jsize ldc_ls;
  jdouble* work_ll;
  side_l = (*env)->GetPrimitiveArrayCritical(env, side, NULL);
  side_ls = (*env)->GetArrayLength(env, side);
  side_ll = malloc(sizeof(char)*side_ls);
  for (i_loc=0; i_loc<side_ls; ++i_loc) side_ll[i_loc] = side_l[i_loc];
  m_l = (*env)->GetPrimitiveArrayCritical(env, m, NULL);
  m_ls = (*env)->GetArrayLength(env, m);
  m_ll = malloc(sizeof(integer)*m_ls);
  for (i_loc=0; i_loc<m_ls; ++i_loc) m_ll[i_loc] = m_l[i_loc];
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  v_ll = (*env)->GetPrimitiveArrayCritical(env, v, NULL);
  incv_l = (*env)->GetPrimitiveArrayCritical(env, incv, NULL);
  incv_ls = (*env)->GetArrayLength(env, incv);
  incv_ll = malloc(sizeof(integer)*incv_ls);
  for (i_loc=0; i_loc<incv_ls; ++i_loc) incv_ll[i_loc] = incv_l[i_loc];
  tau_ll = (*env)->GetPrimitiveArrayCritical(env, tau, NULL);
  c1_ll = (*env)->GetPrimitiveArrayCritical(env, c1, NULL);
  c2_ll = (*env)->GetPrimitiveArrayCritical(env, c2, NULL);
  ldc_l = (*env)->GetPrimitiveArrayCritical(env, ldc, NULL);
  ldc_ls = (*env)->GetArrayLength(env, ldc);
  ldc_ll = malloc(sizeof(integer)*ldc_ls);
  for (i_loc=0; i_loc<ldc_ls; ++i_loc) ldc_ll[i_loc] = ldc_l[i_loc];
  work_ll = (*env)->GetPrimitiveArrayCritical(env, work, NULL);

  dlatzm_(side_ll, m_ll, n_ll, v_ll, incv_ll, tau_ll, c1_ll, c2_ll, ldc_ll, work_ll);

  for (i_loc=0; i_loc<side_ls; ++i_loc) side_l[i_loc] = side_ll[i_loc];
  free(side_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, side, side_l, 0);
  for (i_loc=0; i_loc<m_ls; ++i_loc) m_l[i_loc] = m_ll[i_loc];
  free(m_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, m, m_l, 0);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, v, v_ll, 0);
  for (i_loc=0; i_loc<incv_ls; ++i_loc) incv_l[i_loc] = incv_ll[i_loc];
  free(incv_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, incv, incv_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, tau, tau_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, c1, c1_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, c2, c2_ll, 0);
  for (i_loc=0; i_loc<ldc_ls; ++i_loc) ldc_l[i_loc] = ldc_ll[i_loc];
  free(ldc_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldc, ldc_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, work, work_ll, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_lauu2
(JNIEnv *env, jclass clazz, jcharArray uplo, jintArray n, jdoubleArray a, jintArray lda, jintArray info) {
  int i_loc;
  jchar* uplo_l;
  char* uplo_ll;
  jsize uplo_ls;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jdouble* a_ll;
  jint* lda_l;
  integer* lda_ll;
  jsize lda_ls;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  uplo_l = (*env)->GetPrimitiveArrayCritical(env, uplo, NULL);
  uplo_ls = (*env)->GetArrayLength(env, uplo);
  uplo_ll = malloc(sizeof(char)*uplo_ls);
  for (i_loc=0; i_loc<uplo_ls; ++i_loc) uplo_ll[i_loc] = uplo_l[i_loc];
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  a_ll = (*env)->GetPrimitiveArrayCritical(env, a, NULL);
  lda_l = (*env)->GetPrimitiveArrayCritical(env, lda, NULL);
  lda_ls = (*env)->GetArrayLength(env, lda);
  lda_ll = malloc(sizeof(integer)*lda_ls);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_ll[i_loc] = lda_l[i_loc];
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dlauu2_(uplo_ll, n_ll, a_ll, lda_ll, info_ll);

  for (i_loc=0; i_loc<uplo_ls; ++i_loc) uplo_l[i_loc] = uplo_ll[i_loc];
  free(uplo_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, uplo, uplo_l, 0);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, a, a_ll, 0);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_l[i_loc] = lda_ll[i_loc];
  free(lda_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, lda, lda_l, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_lauum
(JNIEnv *env, jclass clazz, jcharArray uplo, jintArray n, jdoubleArray a, jintArray lda, jintArray info) {
  int i_loc;
  jchar* uplo_l;
  char* uplo_ll;
  jsize uplo_ls;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jdouble* a_ll;
  jint* lda_l;
  integer* lda_ll;
  jsize lda_ls;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  uplo_l = (*env)->GetPrimitiveArrayCritical(env, uplo, NULL);
  uplo_ls = (*env)->GetArrayLength(env, uplo);
  uplo_ll = malloc(sizeof(char)*uplo_ls);
  for (i_loc=0; i_loc<uplo_ls; ++i_loc) uplo_ll[i_loc] = uplo_l[i_loc];
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  a_ll = (*env)->GetPrimitiveArrayCritical(env, a, NULL);
  lda_l = (*env)->GetPrimitiveArrayCritical(env, lda, NULL);
  lda_ls = (*env)->GetArrayLength(env, lda);
  lda_ll = malloc(sizeof(integer)*lda_ls);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_ll[i_loc] = lda_l[i_loc];
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dlauum_(uplo_ll, n_ll, a_ll, lda_ll, info_ll);

  for (i_loc=0; i_loc<uplo_ls; ++i_loc) uplo_l[i_loc] = uplo_ll[i_loc];
  free(uplo_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, uplo, uplo_l, 0);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, a, a_ll, 0);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_l[i_loc] = lda_ll[i_loc];
  free(lda_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, lda, lda_l, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_opgtr
(JNIEnv *env, jclass clazz, jcharArray uplo, jintArray n, jdoubleArray ap, jdoubleArray tau, jdoubleArray q, jintArray ldq, jdoubleArray work, jintArray info) {
  int i_loc;
  jchar* uplo_l;
  char* uplo_ll;
  jsize uplo_ls;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jdouble* ap_ll;
  jdouble* tau_ll;
  jdouble* q_ll;
  jint* ldq_l;
  integer* ldq_ll;
  jsize ldq_ls;
  jdouble* work_ll;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  uplo_l = (*env)->GetPrimitiveArrayCritical(env, uplo, NULL);
  uplo_ls = (*env)->GetArrayLength(env, uplo);
  uplo_ll = malloc(sizeof(char)*uplo_ls);
  for (i_loc=0; i_loc<uplo_ls; ++i_loc) uplo_ll[i_loc] = uplo_l[i_loc];
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  ap_ll = (*env)->GetPrimitiveArrayCritical(env, ap, NULL);
  tau_ll = (*env)->GetPrimitiveArrayCritical(env, tau, NULL);
  q_ll = (*env)->GetPrimitiveArrayCritical(env, q, NULL);
  ldq_l = (*env)->GetPrimitiveArrayCritical(env, ldq, NULL);
  ldq_ls = (*env)->GetArrayLength(env, ldq);
  ldq_ll = malloc(sizeof(integer)*ldq_ls);
  for (i_loc=0; i_loc<ldq_ls; ++i_loc) ldq_ll[i_loc] = ldq_l[i_loc];
  work_ll = (*env)->GetPrimitiveArrayCritical(env, work, NULL);
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dopgtr_(uplo_ll, n_ll, ap_ll, tau_ll, q_ll, ldq_ll, work_ll, info_ll);

  for (i_loc=0; i_loc<uplo_ls; ++i_loc) uplo_l[i_loc] = uplo_ll[i_loc];
  free(uplo_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, uplo, uplo_l, 0);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, ap, ap_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, tau, tau_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, q, q_ll, 0);
  for (i_loc=0; i_loc<ldq_ls; ++i_loc) ldq_l[i_loc] = ldq_ll[i_loc];
  free(ldq_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldq, ldq_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, work, work_ll, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_opmtr
(JNIEnv *env, jclass clazz, jcharArray side, jcharArray uplo, jcharArray trans, jintArray m, jintArray n, jdoubleArray ap, jdoubleArray tau, jdoubleArray c, jintArray ldc, jdoubleArray work, jintArray info) {
  int i_loc;
  jchar* side_l;
  char* side_ll;
  jsize side_ls;
  jchar* uplo_l;
  char* uplo_ll;
  jsize uplo_ls;
  jchar* trans_l;
  char* trans_ll;
  jsize trans_ls;
  jint* m_l;
  integer* m_ll;
  jsize m_ls;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jdouble* ap_ll;
  jdouble* tau_ll;
  jdouble* c_ll;
  jint* ldc_l;
  integer* ldc_ll;
  jsize ldc_ls;
  jdouble* work_ll;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  side_l = (*env)->GetPrimitiveArrayCritical(env, side, NULL);
  side_ls = (*env)->GetArrayLength(env, side);
  side_ll = malloc(sizeof(char)*side_ls);
  for (i_loc=0; i_loc<side_ls; ++i_loc) side_ll[i_loc] = side_l[i_loc];
  uplo_l = (*env)->GetPrimitiveArrayCritical(env, uplo, NULL);
  uplo_ls = (*env)->GetArrayLength(env, uplo);
  uplo_ll = malloc(sizeof(char)*uplo_ls);
  for (i_loc=0; i_loc<uplo_ls; ++i_loc) uplo_ll[i_loc] = uplo_l[i_loc];
  trans_l = (*env)->GetPrimitiveArrayCritical(env, trans, NULL);
  trans_ls = (*env)->GetArrayLength(env, trans);
  trans_ll = malloc(sizeof(char)*trans_ls);
  for (i_loc=0; i_loc<trans_ls; ++i_loc) trans_ll[i_loc] = trans_l[i_loc];
  m_l = (*env)->GetPrimitiveArrayCritical(env, m, NULL);
  m_ls = (*env)->GetArrayLength(env, m);
  m_ll = malloc(sizeof(integer)*m_ls);
  for (i_loc=0; i_loc<m_ls; ++i_loc) m_ll[i_loc] = m_l[i_loc];
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  ap_ll = (*env)->GetPrimitiveArrayCritical(env, ap, NULL);
  tau_ll = (*env)->GetPrimitiveArrayCritical(env, tau, NULL);
  c_ll = (*env)->GetPrimitiveArrayCritical(env, c, NULL);
  ldc_l = (*env)->GetPrimitiveArrayCritical(env, ldc, NULL);
  ldc_ls = (*env)->GetArrayLength(env, ldc);
  ldc_ll = malloc(sizeof(integer)*ldc_ls);
  for (i_loc=0; i_loc<ldc_ls; ++i_loc) ldc_ll[i_loc] = ldc_l[i_loc];
  work_ll = (*env)->GetPrimitiveArrayCritical(env, work, NULL);
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dopmtr_(side_ll, uplo_ll, trans_ll, m_ll, n_ll, ap_ll, tau_ll, c_ll, ldc_ll, work_ll, info_ll);

  for (i_loc=0; i_loc<side_ls; ++i_loc) side_l[i_loc] = side_ll[i_loc];
  free(side_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, side, side_l, 0);
  for (i_loc=0; i_loc<uplo_ls; ++i_loc) uplo_l[i_loc] = uplo_ll[i_loc];
  free(uplo_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, uplo, uplo_l, 0);
  for (i_loc=0; i_loc<trans_ls; ++i_loc) trans_l[i_loc] = trans_ll[i_loc];
  free(trans_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, trans, trans_l, 0);
  for (i_loc=0; i_loc<m_ls; ++i_loc) m_l[i_loc] = m_ll[i_loc];
  free(m_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, m, m_l, 0);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, ap, ap_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, tau, tau_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, c, c_ll, 0);
  for (i_loc=0; i_loc<ldc_ls; ++i_loc) ldc_l[i_loc] = ldc_ll[i_loc];
  free(ldc_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldc, ldc_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, work, work_ll, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_org2l
(JNIEnv *env, jclass clazz, jintArray m, jintArray n, jintArray k, jdoubleArray a, jintArray lda, jdoubleArray tau, jdoubleArray work, jintArray info) {
  int i_loc;
  jint* m_l;
  integer* m_ll;
  jsize m_ls;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jint* k_l;
  integer* k_ll;
  jsize k_ls;
  jdouble* a_ll;
  jint* lda_l;
  integer* lda_ll;
  jsize lda_ls;
  jdouble* tau_ll;
  jdouble* work_ll;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  m_l = (*env)->GetPrimitiveArrayCritical(env, m, NULL);
  m_ls = (*env)->GetArrayLength(env, m);
  m_ll = malloc(sizeof(integer)*m_ls);
  for (i_loc=0; i_loc<m_ls; ++i_loc) m_ll[i_loc] = m_l[i_loc];
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  k_l = (*env)->GetPrimitiveArrayCritical(env, k, NULL);
  k_ls = (*env)->GetArrayLength(env, k);
  k_ll = malloc(sizeof(integer)*k_ls);
  for (i_loc=0; i_loc<k_ls; ++i_loc) k_ll[i_loc] = k_l[i_loc];
  a_ll = (*env)->GetPrimitiveArrayCritical(env, a, NULL);
  lda_l = (*env)->GetPrimitiveArrayCritical(env, lda, NULL);
  lda_ls = (*env)->GetArrayLength(env, lda);
  lda_ll = malloc(sizeof(integer)*lda_ls);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_ll[i_loc] = lda_l[i_loc];
  tau_ll = (*env)->GetPrimitiveArrayCritical(env, tau, NULL);
  work_ll = (*env)->GetPrimitiveArrayCritical(env, work, NULL);
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dorg2l_(m_ll, n_ll, k_ll, a_ll, lda_ll, tau_ll, work_ll, info_ll);

  for (i_loc=0; i_loc<m_ls; ++i_loc) m_l[i_loc] = m_ll[i_loc];
  free(m_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, m, m_l, 0);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  for (i_loc=0; i_loc<k_ls; ++i_loc) k_l[i_loc] = k_ll[i_loc];
  free(k_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, k, k_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, a, a_ll, 0);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_l[i_loc] = lda_ll[i_loc];
  free(lda_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, lda, lda_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, tau, tau_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, work, work_ll, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_org2r
(JNIEnv *env, jclass clazz, jintArray m, jintArray n, jintArray k, jdoubleArray a, jintArray lda, jdoubleArray tau, jdoubleArray work, jintArray info) {
  int i_loc;
  jint* m_l;
  integer* m_ll;
  jsize m_ls;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jint* k_l;
  integer* k_ll;
  jsize k_ls;
  jdouble* a_ll;
  jint* lda_l;
  integer* lda_ll;
  jsize lda_ls;
  jdouble* tau_ll;
  jdouble* work_ll;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  m_l = (*env)->GetPrimitiveArrayCritical(env, m, NULL);
  m_ls = (*env)->GetArrayLength(env, m);
  m_ll = malloc(sizeof(integer)*m_ls);
  for (i_loc=0; i_loc<m_ls; ++i_loc) m_ll[i_loc] = m_l[i_loc];
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  k_l = (*env)->GetPrimitiveArrayCritical(env, k, NULL);
  k_ls = (*env)->GetArrayLength(env, k);
  k_ll = malloc(sizeof(integer)*k_ls);
  for (i_loc=0; i_loc<k_ls; ++i_loc) k_ll[i_loc] = k_l[i_loc];
  a_ll = (*env)->GetPrimitiveArrayCritical(env, a, NULL);
  lda_l = (*env)->GetPrimitiveArrayCritical(env, lda, NULL);
  lda_ls = (*env)->GetArrayLength(env, lda);
  lda_ll = malloc(sizeof(integer)*lda_ls);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_ll[i_loc] = lda_l[i_loc];
  tau_ll = (*env)->GetPrimitiveArrayCritical(env, tau, NULL);
  work_ll = (*env)->GetPrimitiveArrayCritical(env, work, NULL);
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dorg2r_(m_ll, n_ll, k_ll, a_ll, lda_ll, tau_ll, work_ll, info_ll);

  for (i_loc=0; i_loc<m_ls; ++i_loc) m_l[i_loc] = m_ll[i_loc];
  free(m_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, m, m_l, 0);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  for (i_loc=0; i_loc<k_ls; ++i_loc) k_l[i_loc] = k_ll[i_loc];
  free(k_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, k, k_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, a, a_ll, 0);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_l[i_loc] = lda_ll[i_loc];
  free(lda_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, lda, lda_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, tau, tau_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, work, work_ll, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_orgbr
(JNIEnv *env, jclass clazz, jcharArray vect, jintArray m, jintArray n, jintArray k, jdoubleArray a, jintArray lda, jdoubleArray tau, jdoubleArray work, jintArray lwork, jintArray info) {
  int i_loc;
  jchar* vect_l;
  char* vect_ll;
  jsize vect_ls;
  jint* m_l;
  integer* m_ll;
  jsize m_ls;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jint* k_l;
  integer* k_ll;
  jsize k_ls;
  jdouble* a_ll;
  jint* lda_l;
  integer* lda_ll;
  jsize lda_ls;
  jdouble* tau_ll;
  jdouble* work_ll;
  jint* lwork_l;
  integer* lwork_ll;
  jsize lwork_ls;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  vect_l = (*env)->GetPrimitiveArrayCritical(env, vect, NULL);
  vect_ls = (*env)->GetArrayLength(env, vect);
  vect_ll = malloc(sizeof(char)*vect_ls);
  for (i_loc=0; i_loc<vect_ls; ++i_loc) vect_ll[i_loc] = vect_l[i_loc];
  m_l = (*env)->GetPrimitiveArrayCritical(env, m, NULL);
  m_ls = (*env)->GetArrayLength(env, m);
  m_ll = malloc(sizeof(integer)*m_ls);
  for (i_loc=0; i_loc<m_ls; ++i_loc) m_ll[i_loc] = m_l[i_loc];
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  k_l = (*env)->GetPrimitiveArrayCritical(env, k, NULL);
  k_ls = (*env)->GetArrayLength(env, k);
  k_ll = malloc(sizeof(integer)*k_ls);
  for (i_loc=0; i_loc<k_ls; ++i_loc) k_ll[i_loc] = k_l[i_loc];
  a_ll = (*env)->GetPrimitiveArrayCritical(env, a, NULL);
  lda_l = (*env)->GetPrimitiveArrayCritical(env, lda, NULL);
  lda_ls = (*env)->GetArrayLength(env, lda);
  lda_ll = malloc(sizeof(integer)*lda_ls);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_ll[i_loc] = lda_l[i_loc];
  tau_ll = (*env)->GetPrimitiveArrayCritical(env, tau, NULL);
  work_ll = (*env)->GetPrimitiveArrayCritical(env, work, NULL);
  lwork_l = (*env)->GetPrimitiveArrayCritical(env, lwork, NULL);
  lwork_ls = (*env)->GetArrayLength(env, lwork);
  lwork_ll = malloc(sizeof(integer)*lwork_ls);
  for (i_loc=0; i_loc<lwork_ls; ++i_loc) lwork_ll[i_loc] = lwork_l[i_loc];
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dorgbr_(vect_ll, m_ll, n_ll, k_ll, a_ll, lda_ll, tau_ll, work_ll, lwork_ll, info_ll);

  for (i_loc=0; i_loc<vect_ls; ++i_loc) vect_l[i_loc] = vect_ll[i_loc];
  free(vect_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, vect, vect_l, 0);
  for (i_loc=0; i_loc<m_ls; ++i_loc) m_l[i_loc] = m_ll[i_loc];
  free(m_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, m, m_l, 0);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  for (i_loc=0; i_loc<k_ls; ++i_loc) k_l[i_loc] = k_ll[i_loc];
  free(k_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, k, k_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, a, a_ll, 0);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_l[i_loc] = lda_ll[i_loc];
  free(lda_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, lda, lda_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, tau, tau_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, work, work_ll, 0);
  for (i_loc=0; i_loc<lwork_ls; ++i_loc) lwork_l[i_loc] = lwork_ll[i_loc];
  free(lwork_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, lwork, lwork_l, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_orghr
(JNIEnv *env, jclass clazz, jintArray n, jintArray ilo, jintArray ihi, jdoubleArray a, jintArray lda, jdoubleArray tau, jdoubleArray work, jintArray lwork, jintArray info) {
  int i_loc;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jint* ilo_l;
  integer* ilo_ll;
  jsize ilo_ls;
  jint* ihi_l;
  integer* ihi_ll;
  jsize ihi_ls;
  jdouble* a_ll;
  jint* lda_l;
  integer* lda_ll;
  jsize lda_ls;
  jdouble* tau_ll;
  jdouble* work_ll;
  jint* lwork_l;
  integer* lwork_ll;
  jsize lwork_ls;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  ilo_l = (*env)->GetPrimitiveArrayCritical(env, ilo, NULL);
  ilo_ls = (*env)->GetArrayLength(env, ilo);
  ilo_ll = malloc(sizeof(integer)*ilo_ls);
  for (i_loc=0; i_loc<ilo_ls; ++i_loc) ilo_ll[i_loc] = ilo_l[i_loc];
  ihi_l = (*env)->GetPrimitiveArrayCritical(env, ihi, NULL);
  ihi_ls = (*env)->GetArrayLength(env, ihi);
  ihi_ll = malloc(sizeof(integer)*ihi_ls);
  for (i_loc=0; i_loc<ihi_ls; ++i_loc) ihi_ll[i_loc] = ihi_l[i_loc];
  a_ll = (*env)->GetPrimitiveArrayCritical(env, a, NULL);
  lda_l = (*env)->GetPrimitiveArrayCritical(env, lda, NULL);
  lda_ls = (*env)->GetArrayLength(env, lda);
  lda_ll = malloc(sizeof(integer)*lda_ls);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_ll[i_loc] = lda_l[i_loc];
  tau_ll = (*env)->GetPrimitiveArrayCritical(env, tau, NULL);
  work_ll = (*env)->GetPrimitiveArrayCritical(env, work, NULL);
  lwork_l = (*env)->GetPrimitiveArrayCritical(env, lwork, NULL);
  lwork_ls = (*env)->GetArrayLength(env, lwork);
  lwork_ll = malloc(sizeof(integer)*lwork_ls);
  for (i_loc=0; i_loc<lwork_ls; ++i_loc) lwork_ll[i_loc] = lwork_l[i_loc];
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dorghr_(n_ll, ilo_ll, ihi_ll, a_ll, lda_ll, tau_ll, work_ll, lwork_ll, info_ll);

  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  for (i_loc=0; i_loc<ilo_ls; ++i_loc) ilo_l[i_loc] = ilo_ll[i_loc];
  free(ilo_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ilo, ilo_l, 0);
  for (i_loc=0; i_loc<ihi_ls; ++i_loc) ihi_l[i_loc] = ihi_ll[i_loc];
  free(ihi_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ihi, ihi_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, a, a_ll, 0);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_l[i_loc] = lda_ll[i_loc];
  free(lda_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, lda, lda_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, tau, tau_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, work, work_ll, 0);
  for (i_loc=0; i_loc<lwork_ls; ++i_loc) lwork_l[i_loc] = lwork_ll[i_loc];
  free(lwork_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, lwork, lwork_l, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_orgl2
(JNIEnv *env, jclass clazz, jintArray m, jintArray n, jintArray k, jdoubleArray a, jintArray lda, jdoubleArray tau, jdoubleArray work, jintArray info) {
  int i_loc;
  jint* m_l;
  integer* m_ll;
  jsize m_ls;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jint* k_l;
  integer* k_ll;
  jsize k_ls;
  jdouble* a_ll;
  jint* lda_l;
  integer* lda_ll;
  jsize lda_ls;
  jdouble* tau_ll;
  jdouble* work_ll;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  m_l = (*env)->GetPrimitiveArrayCritical(env, m, NULL);
  m_ls = (*env)->GetArrayLength(env, m);
  m_ll = malloc(sizeof(integer)*m_ls);
  for (i_loc=0; i_loc<m_ls; ++i_loc) m_ll[i_loc] = m_l[i_loc];
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  k_l = (*env)->GetPrimitiveArrayCritical(env, k, NULL);
  k_ls = (*env)->GetArrayLength(env, k);
  k_ll = malloc(sizeof(integer)*k_ls);
  for (i_loc=0; i_loc<k_ls; ++i_loc) k_ll[i_loc] = k_l[i_loc];
  a_ll = (*env)->GetPrimitiveArrayCritical(env, a, NULL);
  lda_l = (*env)->GetPrimitiveArrayCritical(env, lda, NULL);
  lda_ls = (*env)->GetArrayLength(env, lda);
  lda_ll = malloc(sizeof(integer)*lda_ls);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_ll[i_loc] = lda_l[i_loc];
  tau_ll = (*env)->GetPrimitiveArrayCritical(env, tau, NULL);
  work_ll = (*env)->GetPrimitiveArrayCritical(env, work, NULL);
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dorgl2_(m_ll, n_ll, k_ll, a_ll, lda_ll, tau_ll, work_ll, info_ll);

  for (i_loc=0; i_loc<m_ls; ++i_loc) m_l[i_loc] = m_ll[i_loc];
  free(m_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, m, m_l, 0);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  for (i_loc=0; i_loc<k_ls; ++i_loc) k_l[i_loc] = k_ll[i_loc];
  free(k_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, k, k_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, a, a_ll, 0);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_l[i_loc] = lda_ll[i_loc];
  free(lda_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, lda, lda_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, tau, tau_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, work, work_ll, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_orglq
(JNIEnv *env, jclass clazz, jintArray m, jintArray n, jintArray k, jdoubleArray a, jintArray lda, jdoubleArray tau, jdoubleArray work, jintArray lwork, jintArray info) {
  int i_loc;
  jint* m_l;
  integer* m_ll;
  jsize m_ls;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jint* k_l;
  integer* k_ll;
  jsize k_ls;
  jdouble* a_ll;
  jint* lda_l;
  integer* lda_ll;
  jsize lda_ls;
  jdouble* tau_ll;
  jdouble* work_ll;
  jint* lwork_l;
  integer* lwork_ll;
  jsize lwork_ls;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  m_l = (*env)->GetPrimitiveArrayCritical(env, m, NULL);
  m_ls = (*env)->GetArrayLength(env, m);
  m_ll = malloc(sizeof(integer)*m_ls);
  for (i_loc=0; i_loc<m_ls; ++i_loc) m_ll[i_loc] = m_l[i_loc];
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  k_l = (*env)->GetPrimitiveArrayCritical(env, k, NULL);
  k_ls = (*env)->GetArrayLength(env, k);
  k_ll = malloc(sizeof(integer)*k_ls);
  for (i_loc=0; i_loc<k_ls; ++i_loc) k_ll[i_loc] = k_l[i_loc];
  a_ll = (*env)->GetPrimitiveArrayCritical(env, a, NULL);
  lda_l = (*env)->GetPrimitiveArrayCritical(env, lda, NULL);
  lda_ls = (*env)->GetArrayLength(env, lda);
  lda_ll = malloc(sizeof(integer)*lda_ls);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_ll[i_loc] = lda_l[i_loc];
  tau_ll = (*env)->GetPrimitiveArrayCritical(env, tau, NULL);
  work_ll = (*env)->GetPrimitiveArrayCritical(env, work, NULL);
  lwork_l = (*env)->GetPrimitiveArrayCritical(env, lwork, NULL);
  lwork_ls = (*env)->GetArrayLength(env, lwork);
  lwork_ll = malloc(sizeof(integer)*lwork_ls);
  for (i_loc=0; i_loc<lwork_ls; ++i_loc) lwork_ll[i_loc] = lwork_l[i_loc];
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dorglq_(m_ll, n_ll, k_ll, a_ll, lda_ll, tau_ll, work_ll, lwork_ll, info_ll);

  for (i_loc=0; i_loc<m_ls; ++i_loc) m_l[i_loc] = m_ll[i_loc];
  free(m_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, m, m_l, 0);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  for (i_loc=0; i_loc<k_ls; ++i_loc) k_l[i_loc] = k_ll[i_loc];
  free(k_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, k, k_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, a, a_ll, 0);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_l[i_loc] = lda_ll[i_loc];
  free(lda_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, lda, lda_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, tau, tau_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, work, work_ll, 0);
  for (i_loc=0; i_loc<lwork_ls; ++i_loc) lwork_l[i_loc] = lwork_ll[i_loc];
  free(lwork_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, lwork, lwork_l, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_orgql
(JNIEnv *env, jclass clazz, jintArray m, jintArray n, jintArray k, jdoubleArray a, jintArray lda, jdoubleArray tau, jdoubleArray work, jintArray lwork, jintArray info) {
  int i_loc;
  jint* m_l;
  integer* m_ll;
  jsize m_ls;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jint* k_l;
  integer* k_ll;
  jsize k_ls;
  jdouble* a_ll;
  jint* lda_l;
  integer* lda_ll;
  jsize lda_ls;
  jdouble* tau_ll;
  jdouble* work_ll;
  jint* lwork_l;
  integer* lwork_ll;
  jsize lwork_ls;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  m_l = (*env)->GetPrimitiveArrayCritical(env, m, NULL);
  m_ls = (*env)->GetArrayLength(env, m);
  m_ll = malloc(sizeof(integer)*m_ls);
  for (i_loc=0; i_loc<m_ls; ++i_loc) m_ll[i_loc] = m_l[i_loc];
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  k_l = (*env)->GetPrimitiveArrayCritical(env, k, NULL);
  k_ls = (*env)->GetArrayLength(env, k);
  k_ll = malloc(sizeof(integer)*k_ls);
  for (i_loc=0; i_loc<k_ls; ++i_loc) k_ll[i_loc] = k_l[i_loc];
  a_ll = (*env)->GetPrimitiveArrayCritical(env, a, NULL);
  lda_l = (*env)->GetPrimitiveArrayCritical(env, lda, NULL);
  lda_ls = (*env)->GetArrayLength(env, lda);
  lda_ll = malloc(sizeof(integer)*lda_ls);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_ll[i_loc] = lda_l[i_loc];
  tau_ll = (*env)->GetPrimitiveArrayCritical(env, tau, NULL);
  work_ll = (*env)->GetPrimitiveArrayCritical(env, work, NULL);
  lwork_l = (*env)->GetPrimitiveArrayCritical(env, lwork, NULL);
  lwork_ls = (*env)->GetArrayLength(env, lwork);
  lwork_ll = malloc(sizeof(integer)*lwork_ls);
  for (i_loc=0; i_loc<lwork_ls; ++i_loc) lwork_ll[i_loc] = lwork_l[i_loc];
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dorgql_(m_ll, n_ll, k_ll, a_ll, lda_ll, tau_ll, work_ll, lwork_ll, info_ll);

  for (i_loc=0; i_loc<m_ls; ++i_loc) m_l[i_loc] = m_ll[i_loc];
  free(m_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, m, m_l, 0);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  for (i_loc=0; i_loc<k_ls; ++i_loc) k_l[i_loc] = k_ll[i_loc];
  free(k_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, k, k_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, a, a_ll, 0);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_l[i_loc] = lda_ll[i_loc];
  free(lda_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, lda, lda_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, tau, tau_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, work, work_ll, 0);
  for (i_loc=0; i_loc<lwork_ls; ++i_loc) lwork_l[i_loc] = lwork_ll[i_loc];
  free(lwork_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, lwork, lwork_l, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_orgqr
(JNIEnv *env, jclass clazz, jintArray m, jintArray n, jintArray k, jdoubleArray a, jintArray lda, jdoubleArray tau, jdoubleArray work, jintArray lwork, jintArray info) {
  int i_loc;
  jint* m_l;
  integer* m_ll;
  jsize m_ls;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jint* k_l;
  integer* k_ll;
  jsize k_ls;
  jdouble* a_ll;
  jint* lda_l;
  integer* lda_ll;
  jsize lda_ls;
  jdouble* tau_ll;
  jdouble* work_ll;
  jint* lwork_l;
  integer* lwork_ll;
  jsize lwork_ls;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  m_l = (*env)->GetPrimitiveArrayCritical(env, m, NULL);
  m_ls = (*env)->GetArrayLength(env, m);
  m_ll = malloc(sizeof(integer)*m_ls);
  for (i_loc=0; i_loc<m_ls; ++i_loc) m_ll[i_loc] = m_l[i_loc];
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  k_l = (*env)->GetPrimitiveArrayCritical(env, k, NULL);
  k_ls = (*env)->GetArrayLength(env, k);
  k_ll = malloc(sizeof(integer)*k_ls);
  for (i_loc=0; i_loc<k_ls; ++i_loc) k_ll[i_loc] = k_l[i_loc];
  a_ll = (*env)->GetPrimitiveArrayCritical(env, a, NULL);
  lda_l = (*env)->GetPrimitiveArrayCritical(env, lda, NULL);
  lda_ls = (*env)->GetArrayLength(env, lda);
  lda_ll = malloc(sizeof(integer)*lda_ls);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_ll[i_loc] = lda_l[i_loc];
  tau_ll = (*env)->GetPrimitiveArrayCritical(env, tau, NULL);
  work_ll = (*env)->GetPrimitiveArrayCritical(env, work, NULL);
  lwork_l = (*env)->GetPrimitiveArrayCritical(env, lwork, NULL);
  lwork_ls = (*env)->GetArrayLength(env, lwork);
  lwork_ll = malloc(sizeof(integer)*lwork_ls);
  for (i_loc=0; i_loc<lwork_ls; ++i_loc) lwork_ll[i_loc] = lwork_l[i_loc];
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dorgqr_(m_ll, n_ll, k_ll, a_ll, lda_ll, tau_ll, work_ll, lwork_ll, info_ll);

  for (i_loc=0; i_loc<m_ls; ++i_loc) m_l[i_loc] = m_ll[i_loc];
  free(m_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, m, m_l, 0);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  for (i_loc=0; i_loc<k_ls; ++i_loc) k_l[i_loc] = k_ll[i_loc];
  free(k_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, k, k_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, a, a_ll, 0);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_l[i_loc] = lda_ll[i_loc];
  free(lda_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, lda, lda_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, tau, tau_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, work, work_ll, 0);
  for (i_loc=0; i_loc<lwork_ls; ++i_loc) lwork_l[i_loc] = lwork_ll[i_loc];
  free(lwork_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, lwork, lwork_l, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_orgr2
(JNIEnv *env, jclass clazz, jintArray m, jintArray n, jintArray k, jdoubleArray a, jintArray lda, jdoubleArray tau, jdoubleArray work, jintArray info) {
  int i_loc;
  jint* m_l;
  integer* m_ll;
  jsize m_ls;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jint* k_l;
  integer* k_ll;
  jsize k_ls;
  jdouble* a_ll;
  jint* lda_l;
  integer* lda_ll;
  jsize lda_ls;
  jdouble* tau_ll;
  jdouble* work_ll;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  m_l = (*env)->GetPrimitiveArrayCritical(env, m, NULL);
  m_ls = (*env)->GetArrayLength(env, m);
  m_ll = malloc(sizeof(integer)*m_ls);
  for (i_loc=0; i_loc<m_ls; ++i_loc) m_ll[i_loc] = m_l[i_loc];
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  k_l = (*env)->GetPrimitiveArrayCritical(env, k, NULL);
  k_ls = (*env)->GetArrayLength(env, k);
  k_ll = malloc(sizeof(integer)*k_ls);
  for (i_loc=0; i_loc<k_ls; ++i_loc) k_ll[i_loc] = k_l[i_loc];
  a_ll = (*env)->GetPrimitiveArrayCritical(env, a, NULL);
  lda_l = (*env)->GetPrimitiveArrayCritical(env, lda, NULL);
  lda_ls = (*env)->GetArrayLength(env, lda);
  lda_ll = malloc(sizeof(integer)*lda_ls);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_ll[i_loc] = lda_l[i_loc];
  tau_ll = (*env)->GetPrimitiveArrayCritical(env, tau, NULL);
  work_ll = (*env)->GetPrimitiveArrayCritical(env, work, NULL);
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dorgr2_(m_ll, n_ll, k_ll, a_ll, lda_ll, tau_ll, work_ll, info_ll);

  for (i_loc=0; i_loc<m_ls; ++i_loc) m_l[i_loc] = m_ll[i_loc];
  free(m_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, m, m_l, 0);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  for (i_loc=0; i_loc<k_ls; ++i_loc) k_l[i_loc] = k_ll[i_loc];
  free(k_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, k, k_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, a, a_ll, 0);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_l[i_loc] = lda_ll[i_loc];
  free(lda_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, lda, lda_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, tau, tau_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, work, work_ll, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_orgrq
(JNIEnv *env, jclass clazz, jintArray m, jintArray n, jintArray k, jdoubleArray a, jintArray lda, jdoubleArray tau, jdoubleArray work, jintArray lwork, jintArray info) {
  int i_loc;
  jint* m_l;
  integer* m_ll;
  jsize m_ls;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jint* k_l;
  integer* k_ll;
  jsize k_ls;
  jdouble* a_ll;
  jint* lda_l;
  integer* lda_ll;
  jsize lda_ls;
  jdouble* tau_ll;
  jdouble* work_ll;
  jint* lwork_l;
  integer* lwork_ll;
  jsize lwork_ls;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  m_l = (*env)->GetPrimitiveArrayCritical(env, m, NULL);
  m_ls = (*env)->GetArrayLength(env, m);
  m_ll = malloc(sizeof(integer)*m_ls);
  for (i_loc=0; i_loc<m_ls; ++i_loc) m_ll[i_loc] = m_l[i_loc];
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  k_l = (*env)->GetPrimitiveArrayCritical(env, k, NULL);
  k_ls = (*env)->GetArrayLength(env, k);
  k_ll = malloc(sizeof(integer)*k_ls);
  for (i_loc=0; i_loc<k_ls; ++i_loc) k_ll[i_loc] = k_l[i_loc];
  a_ll = (*env)->GetPrimitiveArrayCritical(env, a, NULL);
  lda_l = (*env)->GetPrimitiveArrayCritical(env, lda, NULL);
  lda_ls = (*env)->GetArrayLength(env, lda);
  lda_ll = malloc(sizeof(integer)*lda_ls);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_ll[i_loc] = lda_l[i_loc];
  tau_ll = (*env)->GetPrimitiveArrayCritical(env, tau, NULL);
  work_ll = (*env)->GetPrimitiveArrayCritical(env, work, NULL);
  lwork_l = (*env)->GetPrimitiveArrayCritical(env, lwork, NULL);
  lwork_ls = (*env)->GetArrayLength(env, lwork);
  lwork_ll = malloc(sizeof(integer)*lwork_ls);
  for (i_loc=0; i_loc<lwork_ls; ++i_loc) lwork_ll[i_loc] = lwork_l[i_loc];
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dorgrq_(m_ll, n_ll, k_ll, a_ll, lda_ll, tau_ll, work_ll, lwork_ll, info_ll);

  for (i_loc=0; i_loc<m_ls; ++i_loc) m_l[i_loc] = m_ll[i_loc];
  free(m_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, m, m_l, 0);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  for (i_loc=0; i_loc<k_ls; ++i_loc) k_l[i_loc] = k_ll[i_loc];
  free(k_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, k, k_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, a, a_ll, 0);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_l[i_loc] = lda_ll[i_loc];
  free(lda_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, lda, lda_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, tau, tau_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, work, work_ll, 0);
  for (i_loc=0; i_loc<lwork_ls; ++i_loc) lwork_l[i_loc] = lwork_ll[i_loc];
  free(lwork_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, lwork, lwork_l, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_orgtr
(JNIEnv *env, jclass clazz, jcharArray uplo, jintArray n, jdoubleArray a, jintArray lda, jdoubleArray tau, jdoubleArray work, jintArray lwork, jintArray info) {
  int i_loc;
  jchar* uplo_l;
  char* uplo_ll;
  jsize uplo_ls;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jdouble* a_ll;
  jint* lda_l;
  integer* lda_ll;
  jsize lda_ls;
  jdouble* tau_ll;
  jdouble* work_ll;
  jint* lwork_l;
  integer* lwork_ll;
  jsize lwork_ls;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  uplo_l = (*env)->GetPrimitiveArrayCritical(env, uplo, NULL);
  uplo_ls = (*env)->GetArrayLength(env, uplo);
  uplo_ll = malloc(sizeof(char)*uplo_ls);
  for (i_loc=0; i_loc<uplo_ls; ++i_loc) uplo_ll[i_loc] = uplo_l[i_loc];
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  a_ll = (*env)->GetPrimitiveArrayCritical(env, a, NULL);
  lda_l = (*env)->GetPrimitiveArrayCritical(env, lda, NULL);
  lda_ls = (*env)->GetArrayLength(env, lda);
  lda_ll = malloc(sizeof(integer)*lda_ls);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_ll[i_loc] = lda_l[i_loc];
  tau_ll = (*env)->GetPrimitiveArrayCritical(env, tau, NULL);
  work_ll = (*env)->GetPrimitiveArrayCritical(env, work, NULL);
  lwork_l = (*env)->GetPrimitiveArrayCritical(env, lwork, NULL);
  lwork_ls = (*env)->GetArrayLength(env, lwork);
  lwork_ll = malloc(sizeof(integer)*lwork_ls);
  for (i_loc=0; i_loc<lwork_ls; ++i_loc) lwork_ll[i_loc] = lwork_l[i_loc];
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dorgtr_(uplo_ll, n_ll, a_ll, lda_ll, tau_ll, work_ll, lwork_ll, info_ll);

  for (i_loc=0; i_loc<uplo_ls; ++i_loc) uplo_l[i_loc] = uplo_ll[i_loc];
  free(uplo_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, uplo, uplo_l, 0);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, a, a_ll, 0);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_l[i_loc] = lda_ll[i_loc];
  free(lda_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, lda, lda_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, tau, tau_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, work, work_ll, 0);
  for (i_loc=0; i_loc<lwork_ls; ++i_loc) lwork_l[i_loc] = lwork_ll[i_loc];
  free(lwork_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, lwork, lwork_l, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_orm2l
(JNIEnv *env, jclass clazz, jcharArray side, jcharArray trans, jintArray m, jintArray n, jintArray k, jdoubleArray a, jintArray lda, jdoubleArray tau, jdoubleArray c, jintArray ldc, jdoubleArray work, jintArray info) {
  int i_loc;
  jchar* side_l;
  char* side_ll;
  jsize side_ls;
  jchar* trans_l;
  char* trans_ll;
  jsize trans_ls;
  jint* m_l;
  integer* m_ll;
  jsize m_ls;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jint* k_l;
  integer* k_ll;
  jsize k_ls;
  jdouble* a_ll;
  jint* lda_l;
  integer* lda_ll;
  jsize lda_ls;
  jdouble* tau_ll;
  jdouble* c_ll;
  jint* ldc_l;
  integer* ldc_ll;
  jsize ldc_ls;
  jdouble* work_ll;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  side_l = (*env)->GetPrimitiveArrayCritical(env, side, NULL);
  side_ls = (*env)->GetArrayLength(env, side);
  side_ll = malloc(sizeof(char)*side_ls);
  for (i_loc=0; i_loc<side_ls; ++i_loc) side_ll[i_loc] = side_l[i_loc];
  trans_l = (*env)->GetPrimitiveArrayCritical(env, trans, NULL);
  trans_ls = (*env)->GetArrayLength(env, trans);
  trans_ll = malloc(sizeof(char)*trans_ls);
  for (i_loc=0; i_loc<trans_ls; ++i_loc) trans_ll[i_loc] = trans_l[i_loc];
  m_l = (*env)->GetPrimitiveArrayCritical(env, m, NULL);
  m_ls = (*env)->GetArrayLength(env, m);
  m_ll = malloc(sizeof(integer)*m_ls);
  for (i_loc=0; i_loc<m_ls; ++i_loc) m_ll[i_loc] = m_l[i_loc];
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  k_l = (*env)->GetPrimitiveArrayCritical(env, k, NULL);
  k_ls = (*env)->GetArrayLength(env, k);
  k_ll = malloc(sizeof(integer)*k_ls);
  for (i_loc=0; i_loc<k_ls; ++i_loc) k_ll[i_loc] = k_l[i_loc];
  a_ll = (*env)->GetPrimitiveArrayCritical(env, a, NULL);
  lda_l = (*env)->GetPrimitiveArrayCritical(env, lda, NULL);
  lda_ls = (*env)->GetArrayLength(env, lda);
  lda_ll = malloc(sizeof(integer)*lda_ls);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_ll[i_loc] = lda_l[i_loc];
  tau_ll = (*env)->GetPrimitiveArrayCritical(env, tau, NULL);
  c_ll = (*env)->GetPrimitiveArrayCritical(env, c, NULL);
  ldc_l = (*env)->GetPrimitiveArrayCritical(env, ldc, NULL);
  ldc_ls = (*env)->GetArrayLength(env, ldc);
  ldc_ll = malloc(sizeof(integer)*ldc_ls);
  for (i_loc=0; i_loc<ldc_ls; ++i_loc) ldc_ll[i_loc] = ldc_l[i_loc];
  work_ll = (*env)->GetPrimitiveArrayCritical(env, work, NULL);
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dorm2l_(side_ll, trans_ll, m_ll, n_ll, k_ll, a_ll, lda_ll, tau_ll, c_ll, ldc_ll, work_ll, info_ll);

  for (i_loc=0; i_loc<side_ls; ++i_loc) side_l[i_loc] = side_ll[i_loc];
  free(side_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, side, side_l, 0);
  for (i_loc=0; i_loc<trans_ls; ++i_loc) trans_l[i_loc] = trans_ll[i_loc];
  free(trans_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, trans, trans_l, 0);
  for (i_loc=0; i_loc<m_ls; ++i_loc) m_l[i_loc] = m_ll[i_loc];
  free(m_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, m, m_l, 0);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  for (i_loc=0; i_loc<k_ls; ++i_loc) k_l[i_loc] = k_ll[i_loc];
  free(k_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, k, k_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, a, a_ll, 0);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_l[i_loc] = lda_ll[i_loc];
  free(lda_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, lda, lda_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, tau, tau_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, c, c_ll, 0);
  for (i_loc=0; i_loc<ldc_ls; ++i_loc) ldc_l[i_loc] = ldc_ll[i_loc];
  free(ldc_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldc, ldc_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, work, work_ll, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_orm2r
(JNIEnv *env, jclass clazz, jcharArray side, jcharArray trans, jintArray m, jintArray n, jintArray k, jdoubleArray a, jintArray lda, jdoubleArray tau, jdoubleArray c, jintArray ldc, jdoubleArray work, jintArray info) {
  int i_loc;
  jchar* side_l;
  char* side_ll;
  jsize side_ls;
  jchar* trans_l;
  char* trans_ll;
  jsize trans_ls;
  jint* m_l;
  integer* m_ll;
  jsize m_ls;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jint* k_l;
  integer* k_ll;
  jsize k_ls;
  jdouble* a_ll;
  jint* lda_l;
  integer* lda_ll;
  jsize lda_ls;
  jdouble* tau_ll;
  jdouble* c_ll;
  jint* ldc_l;
  integer* ldc_ll;
  jsize ldc_ls;
  jdouble* work_ll;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  side_l = (*env)->GetPrimitiveArrayCritical(env, side, NULL);
  side_ls = (*env)->GetArrayLength(env, side);
  side_ll = malloc(sizeof(char)*side_ls);
  for (i_loc=0; i_loc<side_ls; ++i_loc) side_ll[i_loc] = side_l[i_loc];
  trans_l = (*env)->GetPrimitiveArrayCritical(env, trans, NULL);
  trans_ls = (*env)->GetArrayLength(env, trans);
  trans_ll = malloc(sizeof(char)*trans_ls);
  for (i_loc=0; i_loc<trans_ls; ++i_loc) trans_ll[i_loc] = trans_l[i_loc];
  m_l = (*env)->GetPrimitiveArrayCritical(env, m, NULL);
  m_ls = (*env)->GetArrayLength(env, m);
  m_ll = malloc(sizeof(integer)*m_ls);
  for (i_loc=0; i_loc<m_ls; ++i_loc) m_ll[i_loc] = m_l[i_loc];
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  k_l = (*env)->GetPrimitiveArrayCritical(env, k, NULL);
  k_ls = (*env)->GetArrayLength(env, k);
  k_ll = malloc(sizeof(integer)*k_ls);
  for (i_loc=0; i_loc<k_ls; ++i_loc) k_ll[i_loc] = k_l[i_loc];
  a_ll = (*env)->GetPrimitiveArrayCritical(env, a, NULL);
  lda_l = (*env)->GetPrimitiveArrayCritical(env, lda, NULL);
  lda_ls = (*env)->GetArrayLength(env, lda);
  lda_ll = malloc(sizeof(integer)*lda_ls);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_ll[i_loc] = lda_l[i_loc];
  tau_ll = (*env)->GetPrimitiveArrayCritical(env, tau, NULL);
  c_ll = (*env)->GetPrimitiveArrayCritical(env, c, NULL);
  ldc_l = (*env)->GetPrimitiveArrayCritical(env, ldc, NULL);
  ldc_ls = (*env)->GetArrayLength(env, ldc);
  ldc_ll = malloc(sizeof(integer)*ldc_ls);
  for (i_loc=0; i_loc<ldc_ls; ++i_loc) ldc_ll[i_loc] = ldc_l[i_loc];
  work_ll = (*env)->GetPrimitiveArrayCritical(env, work, NULL);
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dorm2r_(side_ll, trans_ll, m_ll, n_ll, k_ll, a_ll, lda_ll, tau_ll, c_ll, ldc_ll, work_ll, info_ll);

  for (i_loc=0; i_loc<side_ls; ++i_loc) side_l[i_loc] = side_ll[i_loc];
  free(side_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, side, side_l, 0);
  for (i_loc=0; i_loc<trans_ls; ++i_loc) trans_l[i_loc] = trans_ll[i_loc];
  free(trans_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, trans, trans_l, 0);
  for (i_loc=0; i_loc<m_ls; ++i_loc) m_l[i_loc] = m_ll[i_loc];
  free(m_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, m, m_l, 0);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  for (i_loc=0; i_loc<k_ls; ++i_loc) k_l[i_loc] = k_ll[i_loc];
  free(k_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, k, k_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, a, a_ll, 0);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_l[i_loc] = lda_ll[i_loc];
  free(lda_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, lda, lda_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, tau, tau_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, c, c_ll, 0);
  for (i_loc=0; i_loc<ldc_ls; ++i_loc) ldc_l[i_loc] = ldc_ll[i_loc];
  free(ldc_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldc, ldc_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, work, work_ll, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_ormbr
(JNIEnv *env, jclass clazz, jcharArray vect, jcharArray side, jcharArray trans, jintArray m, jintArray n, jintArray k, jdoubleArray a, jintArray lda, jdoubleArray tau, jdoubleArray c, jintArray ldc, jdoubleArray work, jintArray lwork, jintArray info) {
  int i_loc;
  jchar* vect_l;
  char* vect_ll;
  jsize vect_ls;
  jchar* side_l;
  char* side_ll;
  jsize side_ls;
  jchar* trans_l;
  char* trans_ll;
  jsize trans_ls;
  jint* m_l;
  integer* m_ll;
  jsize m_ls;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jint* k_l;
  integer* k_ll;
  jsize k_ls;
  jdouble* a_ll;
  jint* lda_l;
  integer* lda_ll;
  jsize lda_ls;
  jdouble* tau_ll;
  jdouble* c_ll;
  jint* ldc_l;
  integer* ldc_ll;
  jsize ldc_ls;
  jdouble* work_ll;
  jint* lwork_l;
  integer* lwork_ll;
  jsize lwork_ls;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  vect_l = (*env)->GetPrimitiveArrayCritical(env, vect, NULL);
  vect_ls = (*env)->GetArrayLength(env, vect);
  vect_ll = malloc(sizeof(char)*vect_ls);
  for (i_loc=0; i_loc<vect_ls; ++i_loc) vect_ll[i_loc] = vect_l[i_loc];
  side_l = (*env)->GetPrimitiveArrayCritical(env, side, NULL);
  side_ls = (*env)->GetArrayLength(env, side);
  side_ll = malloc(sizeof(char)*side_ls);
  for (i_loc=0; i_loc<side_ls; ++i_loc) side_ll[i_loc] = side_l[i_loc];
  trans_l = (*env)->GetPrimitiveArrayCritical(env, trans, NULL);
  trans_ls = (*env)->GetArrayLength(env, trans);
  trans_ll = malloc(sizeof(char)*trans_ls);
  for (i_loc=0; i_loc<trans_ls; ++i_loc) trans_ll[i_loc] = trans_l[i_loc];
  m_l = (*env)->GetPrimitiveArrayCritical(env, m, NULL);
  m_ls = (*env)->GetArrayLength(env, m);
  m_ll = malloc(sizeof(integer)*m_ls);
  for (i_loc=0; i_loc<m_ls; ++i_loc) m_ll[i_loc] = m_l[i_loc];
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  k_l = (*env)->GetPrimitiveArrayCritical(env, k, NULL);
  k_ls = (*env)->GetArrayLength(env, k);
  k_ll = malloc(sizeof(integer)*k_ls);
  for (i_loc=0; i_loc<k_ls; ++i_loc) k_ll[i_loc] = k_l[i_loc];
  a_ll = (*env)->GetPrimitiveArrayCritical(env, a, NULL);
  lda_l = (*env)->GetPrimitiveArrayCritical(env, lda, NULL);
  lda_ls = (*env)->GetArrayLength(env, lda);
  lda_ll = malloc(sizeof(integer)*lda_ls);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_ll[i_loc] = lda_l[i_loc];
  tau_ll = (*env)->GetPrimitiveArrayCritical(env, tau, NULL);
  c_ll = (*env)->GetPrimitiveArrayCritical(env, c, NULL);
  ldc_l = (*env)->GetPrimitiveArrayCritical(env, ldc, NULL);
  ldc_ls = (*env)->GetArrayLength(env, ldc);
  ldc_ll = malloc(sizeof(integer)*ldc_ls);
  for (i_loc=0; i_loc<ldc_ls; ++i_loc) ldc_ll[i_loc] = ldc_l[i_loc];
  work_ll = (*env)->GetPrimitiveArrayCritical(env, work, NULL);
  lwork_l = (*env)->GetPrimitiveArrayCritical(env, lwork, NULL);
  lwork_ls = (*env)->GetArrayLength(env, lwork);
  lwork_ll = malloc(sizeof(integer)*lwork_ls);
  for (i_loc=0; i_loc<lwork_ls; ++i_loc) lwork_ll[i_loc] = lwork_l[i_loc];
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dormbr_(vect_ll, side_ll, trans_ll, m_ll, n_ll, k_ll, a_ll, lda_ll, tau_ll, c_ll, ldc_ll, work_ll, lwork_ll, info_ll);

  for (i_loc=0; i_loc<vect_ls; ++i_loc) vect_l[i_loc] = vect_ll[i_loc];
  free(vect_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, vect, vect_l, 0);
  for (i_loc=0; i_loc<side_ls; ++i_loc) side_l[i_loc] = side_ll[i_loc];
  free(side_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, side, side_l, 0);
  for (i_loc=0; i_loc<trans_ls; ++i_loc) trans_l[i_loc] = trans_ll[i_loc];
  free(trans_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, trans, trans_l, 0);
  for (i_loc=0; i_loc<m_ls; ++i_loc) m_l[i_loc] = m_ll[i_loc];
  free(m_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, m, m_l, 0);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  for (i_loc=0; i_loc<k_ls; ++i_loc) k_l[i_loc] = k_ll[i_loc];
  free(k_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, k, k_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, a, a_ll, 0);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_l[i_loc] = lda_ll[i_loc];
  free(lda_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, lda, lda_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, tau, tau_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, c, c_ll, 0);
  for (i_loc=0; i_loc<ldc_ls; ++i_loc) ldc_l[i_loc] = ldc_ll[i_loc];
  free(ldc_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldc, ldc_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, work, work_ll, 0);
  for (i_loc=0; i_loc<lwork_ls; ++i_loc) lwork_l[i_loc] = lwork_ll[i_loc];
  free(lwork_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, lwork, lwork_l, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_ormhr
(JNIEnv *env, jclass clazz, jcharArray side, jcharArray trans, jintArray m, jintArray n, jintArray ilo, jintArray ihi, jdoubleArray a, jintArray lda, jdoubleArray tau, jdoubleArray c, jintArray ldc, jdoubleArray work, jintArray lwork, jintArray info) {
  int i_loc;
  jchar* side_l;
  char* side_ll;
  jsize side_ls;
  jchar* trans_l;
  char* trans_ll;
  jsize trans_ls;
  jint* m_l;
  integer* m_ll;
  jsize m_ls;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jint* ilo_l;
  integer* ilo_ll;
  jsize ilo_ls;
  jint* ihi_l;
  integer* ihi_ll;
  jsize ihi_ls;
  jdouble* a_ll;
  jint* lda_l;
  integer* lda_ll;
  jsize lda_ls;
  jdouble* tau_ll;
  jdouble* c_ll;
  jint* ldc_l;
  integer* ldc_ll;
  jsize ldc_ls;
  jdouble* work_ll;
  jint* lwork_l;
  integer* lwork_ll;
  jsize lwork_ls;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  side_l = (*env)->GetPrimitiveArrayCritical(env, side, NULL);
  side_ls = (*env)->GetArrayLength(env, side);
  side_ll = malloc(sizeof(char)*side_ls);
  for (i_loc=0; i_loc<side_ls; ++i_loc) side_ll[i_loc] = side_l[i_loc];
  trans_l = (*env)->GetPrimitiveArrayCritical(env, trans, NULL);
  trans_ls = (*env)->GetArrayLength(env, trans);
  trans_ll = malloc(sizeof(char)*trans_ls);
  for (i_loc=0; i_loc<trans_ls; ++i_loc) trans_ll[i_loc] = trans_l[i_loc];
  m_l = (*env)->GetPrimitiveArrayCritical(env, m, NULL);
  m_ls = (*env)->GetArrayLength(env, m);
  m_ll = malloc(sizeof(integer)*m_ls);
  for (i_loc=0; i_loc<m_ls; ++i_loc) m_ll[i_loc] = m_l[i_loc];
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  ilo_l = (*env)->GetPrimitiveArrayCritical(env, ilo, NULL);
  ilo_ls = (*env)->GetArrayLength(env, ilo);
  ilo_ll = malloc(sizeof(integer)*ilo_ls);
  for (i_loc=0; i_loc<ilo_ls; ++i_loc) ilo_ll[i_loc] = ilo_l[i_loc];
  ihi_l = (*env)->GetPrimitiveArrayCritical(env, ihi, NULL);
  ihi_ls = (*env)->GetArrayLength(env, ihi);
  ihi_ll = malloc(sizeof(integer)*ihi_ls);
  for (i_loc=0; i_loc<ihi_ls; ++i_loc) ihi_ll[i_loc] = ihi_l[i_loc];
  a_ll = (*env)->GetPrimitiveArrayCritical(env, a, NULL);
  lda_l = (*env)->GetPrimitiveArrayCritical(env, lda, NULL);
  lda_ls = (*env)->GetArrayLength(env, lda);
  lda_ll = malloc(sizeof(integer)*lda_ls);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_ll[i_loc] = lda_l[i_loc];
  tau_ll = (*env)->GetPrimitiveArrayCritical(env, tau, NULL);
  c_ll = (*env)->GetPrimitiveArrayCritical(env, c, NULL);
  ldc_l = (*env)->GetPrimitiveArrayCritical(env, ldc, NULL);
  ldc_ls = (*env)->GetArrayLength(env, ldc);
  ldc_ll = malloc(sizeof(integer)*ldc_ls);
  for (i_loc=0; i_loc<ldc_ls; ++i_loc) ldc_ll[i_loc] = ldc_l[i_loc];
  work_ll = (*env)->GetPrimitiveArrayCritical(env, work, NULL);
  lwork_l = (*env)->GetPrimitiveArrayCritical(env, lwork, NULL);
  lwork_ls = (*env)->GetArrayLength(env, lwork);
  lwork_ll = malloc(sizeof(integer)*lwork_ls);
  for (i_loc=0; i_loc<lwork_ls; ++i_loc) lwork_ll[i_loc] = lwork_l[i_loc];
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dormhr_(side_ll, trans_ll, m_ll, n_ll, ilo_ll, ihi_ll, a_ll, lda_ll, tau_ll, c_ll, ldc_ll, work_ll, lwork_ll, info_ll);

  for (i_loc=0; i_loc<side_ls; ++i_loc) side_l[i_loc] = side_ll[i_loc];
  free(side_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, side, side_l, 0);
  for (i_loc=0; i_loc<trans_ls; ++i_loc) trans_l[i_loc] = trans_ll[i_loc];
  free(trans_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, trans, trans_l, 0);
  for (i_loc=0; i_loc<m_ls; ++i_loc) m_l[i_loc] = m_ll[i_loc];
  free(m_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, m, m_l, 0);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  for (i_loc=0; i_loc<ilo_ls; ++i_loc) ilo_l[i_loc] = ilo_ll[i_loc];
  free(ilo_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ilo, ilo_l, 0);
  for (i_loc=0; i_loc<ihi_ls; ++i_loc) ihi_l[i_loc] = ihi_ll[i_loc];
  free(ihi_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ihi, ihi_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, a, a_ll, 0);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_l[i_loc] = lda_ll[i_loc];
  free(lda_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, lda, lda_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, tau, tau_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, c, c_ll, 0);
  for (i_loc=0; i_loc<ldc_ls; ++i_loc) ldc_l[i_loc] = ldc_ll[i_loc];
  free(ldc_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldc, ldc_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, work, work_ll, 0);
  for (i_loc=0; i_loc<lwork_ls; ++i_loc) lwork_l[i_loc] = lwork_ll[i_loc];
  free(lwork_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, lwork, lwork_l, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_orml2
(JNIEnv *env, jclass clazz, jcharArray side, jcharArray trans, jintArray m, jintArray n, jintArray k, jdoubleArray a, jintArray lda, jdoubleArray tau, jdoubleArray c, jintArray ldc, jdoubleArray work, jintArray info) {
  int i_loc;
  jchar* side_l;
  char* side_ll;
  jsize side_ls;
  jchar* trans_l;
  char* trans_ll;
  jsize trans_ls;
  jint* m_l;
  integer* m_ll;
  jsize m_ls;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jint* k_l;
  integer* k_ll;
  jsize k_ls;
  jdouble* a_ll;
  jint* lda_l;
  integer* lda_ll;
  jsize lda_ls;
  jdouble* tau_ll;
  jdouble* c_ll;
  jint* ldc_l;
  integer* ldc_ll;
  jsize ldc_ls;
  jdouble* work_ll;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  side_l = (*env)->GetPrimitiveArrayCritical(env, side, NULL);
  side_ls = (*env)->GetArrayLength(env, side);
  side_ll = malloc(sizeof(char)*side_ls);
  for (i_loc=0; i_loc<side_ls; ++i_loc) side_ll[i_loc] = side_l[i_loc];
  trans_l = (*env)->GetPrimitiveArrayCritical(env, trans, NULL);
  trans_ls = (*env)->GetArrayLength(env, trans);
  trans_ll = malloc(sizeof(char)*trans_ls);
  for (i_loc=0; i_loc<trans_ls; ++i_loc) trans_ll[i_loc] = trans_l[i_loc];
  m_l = (*env)->GetPrimitiveArrayCritical(env, m, NULL);
  m_ls = (*env)->GetArrayLength(env, m);
  m_ll = malloc(sizeof(integer)*m_ls);
  for (i_loc=0; i_loc<m_ls; ++i_loc) m_ll[i_loc] = m_l[i_loc];
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  k_l = (*env)->GetPrimitiveArrayCritical(env, k, NULL);
  k_ls = (*env)->GetArrayLength(env, k);
  k_ll = malloc(sizeof(integer)*k_ls);
  for (i_loc=0; i_loc<k_ls; ++i_loc) k_ll[i_loc] = k_l[i_loc];
  a_ll = (*env)->GetPrimitiveArrayCritical(env, a, NULL);
  lda_l = (*env)->GetPrimitiveArrayCritical(env, lda, NULL);
  lda_ls = (*env)->GetArrayLength(env, lda);
  lda_ll = malloc(sizeof(integer)*lda_ls);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_ll[i_loc] = lda_l[i_loc];
  tau_ll = (*env)->GetPrimitiveArrayCritical(env, tau, NULL);
  c_ll = (*env)->GetPrimitiveArrayCritical(env, c, NULL);
  ldc_l = (*env)->GetPrimitiveArrayCritical(env, ldc, NULL);
  ldc_ls = (*env)->GetArrayLength(env, ldc);
  ldc_ll = malloc(sizeof(integer)*ldc_ls);
  for (i_loc=0; i_loc<ldc_ls; ++i_loc) ldc_ll[i_loc] = ldc_l[i_loc];
  work_ll = (*env)->GetPrimitiveArrayCritical(env, work, NULL);
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dorml2_(side_ll, trans_ll, m_ll, n_ll, k_ll, a_ll, lda_ll, tau_ll, c_ll, ldc_ll, work_ll, info_ll);

  for (i_loc=0; i_loc<side_ls; ++i_loc) side_l[i_loc] = side_ll[i_loc];
  free(side_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, side, side_l, 0);
  for (i_loc=0; i_loc<trans_ls; ++i_loc) trans_l[i_loc] = trans_ll[i_loc];
  free(trans_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, trans, trans_l, 0);
  for (i_loc=0; i_loc<m_ls; ++i_loc) m_l[i_loc] = m_ll[i_loc];
  free(m_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, m, m_l, 0);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  for (i_loc=0; i_loc<k_ls; ++i_loc) k_l[i_loc] = k_ll[i_loc];
  free(k_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, k, k_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, a, a_ll, 0);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_l[i_loc] = lda_ll[i_loc];
  free(lda_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, lda, lda_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, tau, tau_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, c, c_ll, 0);
  for (i_loc=0; i_loc<ldc_ls; ++i_loc) ldc_l[i_loc] = ldc_ll[i_loc];
  free(ldc_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldc, ldc_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, work, work_ll, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_ormlq
(JNIEnv *env, jclass clazz, jcharArray side, jcharArray trans, jintArray m, jintArray n, jintArray k, jdoubleArray a, jintArray lda, jdoubleArray tau, jdoubleArray c, jintArray ldc, jdoubleArray work, jintArray lwork, jintArray info) {
  int i_loc;
  jchar* side_l;
  char* side_ll;
  jsize side_ls;
  jchar* trans_l;
  char* trans_ll;
  jsize trans_ls;
  jint* m_l;
  integer* m_ll;
  jsize m_ls;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jint* k_l;
  integer* k_ll;
  jsize k_ls;
  jdouble* a_ll;
  jint* lda_l;
  integer* lda_ll;
  jsize lda_ls;
  jdouble* tau_ll;
  jdouble* c_ll;
  jint* ldc_l;
  integer* ldc_ll;
  jsize ldc_ls;
  jdouble* work_ll;
  jint* lwork_l;
  integer* lwork_ll;
  jsize lwork_ls;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  side_l = (*env)->GetPrimitiveArrayCritical(env, side, NULL);
  side_ls = (*env)->GetArrayLength(env, side);
  side_ll = malloc(sizeof(char)*side_ls);
  for (i_loc=0; i_loc<side_ls; ++i_loc) side_ll[i_loc] = side_l[i_loc];
  trans_l = (*env)->GetPrimitiveArrayCritical(env, trans, NULL);
  trans_ls = (*env)->GetArrayLength(env, trans);
  trans_ll = malloc(sizeof(char)*trans_ls);
  for (i_loc=0; i_loc<trans_ls; ++i_loc) trans_ll[i_loc] = trans_l[i_loc];
  m_l = (*env)->GetPrimitiveArrayCritical(env, m, NULL);
  m_ls = (*env)->GetArrayLength(env, m);
  m_ll = malloc(sizeof(integer)*m_ls);
  for (i_loc=0; i_loc<m_ls; ++i_loc) m_ll[i_loc] = m_l[i_loc];
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  k_l = (*env)->GetPrimitiveArrayCritical(env, k, NULL);
  k_ls = (*env)->GetArrayLength(env, k);
  k_ll = malloc(sizeof(integer)*k_ls);
  for (i_loc=0; i_loc<k_ls; ++i_loc) k_ll[i_loc] = k_l[i_loc];
  a_ll = (*env)->GetPrimitiveArrayCritical(env, a, NULL);
  lda_l = (*env)->GetPrimitiveArrayCritical(env, lda, NULL);
  lda_ls = (*env)->GetArrayLength(env, lda);
  lda_ll = malloc(sizeof(integer)*lda_ls);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_ll[i_loc] = lda_l[i_loc];
  tau_ll = (*env)->GetPrimitiveArrayCritical(env, tau, NULL);
  c_ll = (*env)->GetPrimitiveArrayCritical(env, c, NULL);
  ldc_l = (*env)->GetPrimitiveArrayCritical(env, ldc, NULL);
  ldc_ls = (*env)->GetArrayLength(env, ldc);
  ldc_ll = malloc(sizeof(integer)*ldc_ls);
  for (i_loc=0; i_loc<ldc_ls; ++i_loc) ldc_ll[i_loc] = ldc_l[i_loc];
  work_ll = (*env)->GetPrimitiveArrayCritical(env, work, NULL);
  lwork_l = (*env)->GetPrimitiveArrayCritical(env, lwork, NULL);
  lwork_ls = (*env)->GetArrayLength(env, lwork);
  lwork_ll = malloc(sizeof(integer)*lwork_ls);
  for (i_loc=0; i_loc<lwork_ls; ++i_loc) lwork_ll[i_loc] = lwork_l[i_loc];
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dormlq_(side_ll, trans_ll, m_ll, n_ll, k_ll, a_ll, lda_ll, tau_ll, c_ll, ldc_ll, work_ll, lwork_ll, info_ll);

  for (i_loc=0; i_loc<side_ls; ++i_loc) side_l[i_loc] = side_ll[i_loc];
  free(side_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, side, side_l, 0);
  for (i_loc=0; i_loc<trans_ls; ++i_loc) trans_l[i_loc] = trans_ll[i_loc];
  free(trans_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, trans, trans_l, 0);
  for (i_loc=0; i_loc<m_ls; ++i_loc) m_l[i_loc] = m_ll[i_loc];
  free(m_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, m, m_l, 0);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  for (i_loc=0; i_loc<k_ls; ++i_loc) k_l[i_loc] = k_ll[i_loc];
  free(k_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, k, k_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, a, a_ll, 0);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_l[i_loc] = lda_ll[i_loc];
  free(lda_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, lda, lda_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, tau, tau_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, c, c_ll, 0);
  for (i_loc=0; i_loc<ldc_ls; ++i_loc) ldc_l[i_loc] = ldc_ll[i_loc];
  free(ldc_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldc, ldc_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, work, work_ll, 0);
  for (i_loc=0; i_loc<lwork_ls; ++i_loc) lwork_l[i_loc] = lwork_ll[i_loc];
  free(lwork_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, lwork, lwork_l, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_ormql
(JNIEnv *env, jclass clazz, jcharArray side, jcharArray trans, jintArray m, jintArray n, jintArray k, jdoubleArray a, jintArray lda, jdoubleArray tau, jdoubleArray c, jintArray ldc, jdoubleArray work, jintArray lwork, jintArray info) {
  int i_loc;
  jchar* side_l;
  char* side_ll;
  jsize side_ls;
  jchar* trans_l;
  char* trans_ll;
  jsize trans_ls;
  jint* m_l;
  integer* m_ll;
  jsize m_ls;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jint* k_l;
  integer* k_ll;
  jsize k_ls;
  jdouble* a_ll;
  jint* lda_l;
  integer* lda_ll;
  jsize lda_ls;
  jdouble* tau_ll;
  jdouble* c_ll;
  jint* ldc_l;
  integer* ldc_ll;
  jsize ldc_ls;
  jdouble* work_ll;
  jint* lwork_l;
  integer* lwork_ll;
  jsize lwork_ls;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  side_l = (*env)->GetPrimitiveArrayCritical(env, side, NULL);
  side_ls = (*env)->GetArrayLength(env, side);
  side_ll = malloc(sizeof(char)*side_ls);
  for (i_loc=0; i_loc<side_ls; ++i_loc) side_ll[i_loc] = side_l[i_loc];
  trans_l = (*env)->GetPrimitiveArrayCritical(env, trans, NULL);
  trans_ls = (*env)->GetArrayLength(env, trans);
  trans_ll = malloc(sizeof(char)*trans_ls);
  for (i_loc=0; i_loc<trans_ls; ++i_loc) trans_ll[i_loc] = trans_l[i_loc];
  m_l = (*env)->GetPrimitiveArrayCritical(env, m, NULL);
  m_ls = (*env)->GetArrayLength(env, m);
  m_ll = malloc(sizeof(integer)*m_ls);
  for (i_loc=0; i_loc<m_ls; ++i_loc) m_ll[i_loc] = m_l[i_loc];
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  k_l = (*env)->GetPrimitiveArrayCritical(env, k, NULL);
  k_ls = (*env)->GetArrayLength(env, k);
  k_ll = malloc(sizeof(integer)*k_ls);
  for (i_loc=0; i_loc<k_ls; ++i_loc) k_ll[i_loc] = k_l[i_loc];
  a_ll = (*env)->GetPrimitiveArrayCritical(env, a, NULL);
  lda_l = (*env)->GetPrimitiveArrayCritical(env, lda, NULL);
  lda_ls = (*env)->GetArrayLength(env, lda);
  lda_ll = malloc(sizeof(integer)*lda_ls);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_ll[i_loc] = lda_l[i_loc];
  tau_ll = (*env)->GetPrimitiveArrayCritical(env, tau, NULL);
  c_ll = (*env)->GetPrimitiveArrayCritical(env, c, NULL);
  ldc_l = (*env)->GetPrimitiveArrayCritical(env, ldc, NULL);
  ldc_ls = (*env)->GetArrayLength(env, ldc);
  ldc_ll = malloc(sizeof(integer)*ldc_ls);
  for (i_loc=0; i_loc<ldc_ls; ++i_loc) ldc_ll[i_loc] = ldc_l[i_loc];
  work_ll = (*env)->GetPrimitiveArrayCritical(env, work, NULL);
  lwork_l = (*env)->GetPrimitiveArrayCritical(env, lwork, NULL);
  lwork_ls = (*env)->GetArrayLength(env, lwork);
  lwork_ll = malloc(sizeof(integer)*lwork_ls);
  for (i_loc=0; i_loc<lwork_ls; ++i_loc) lwork_ll[i_loc] = lwork_l[i_loc];
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dormql_(side_ll, trans_ll, m_ll, n_ll, k_ll, a_ll, lda_ll, tau_ll, c_ll, ldc_ll, work_ll, lwork_ll, info_ll);

  for (i_loc=0; i_loc<side_ls; ++i_loc) side_l[i_loc] = side_ll[i_loc];
  free(side_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, side, side_l, 0);
  for (i_loc=0; i_loc<trans_ls; ++i_loc) trans_l[i_loc] = trans_ll[i_loc];
  free(trans_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, trans, trans_l, 0);
  for (i_loc=0; i_loc<m_ls; ++i_loc) m_l[i_loc] = m_ll[i_loc];
  free(m_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, m, m_l, 0);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  for (i_loc=0; i_loc<k_ls; ++i_loc) k_l[i_loc] = k_ll[i_loc];
  free(k_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, k, k_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, a, a_ll, 0);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_l[i_loc] = lda_ll[i_loc];
  free(lda_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, lda, lda_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, tau, tau_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, c, c_ll, 0);
  for (i_loc=0; i_loc<ldc_ls; ++i_loc) ldc_l[i_loc] = ldc_ll[i_loc];
  free(ldc_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldc, ldc_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, work, work_ll, 0);
  for (i_loc=0; i_loc<lwork_ls; ++i_loc) lwork_l[i_loc] = lwork_ll[i_loc];
  free(lwork_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, lwork, lwork_l, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_ormqr
(JNIEnv *env, jclass clazz, jcharArray side, jcharArray trans, jintArray m, jintArray n, jintArray k, jdoubleArray a, jintArray lda, jdoubleArray tau, jdoubleArray c, jintArray ldc, jdoubleArray work, jintArray lwork, jintArray info) {
  int i_loc;
  jchar* side_l;
  char* side_ll;
  jsize side_ls;
  jchar* trans_l;
  char* trans_ll;
  jsize trans_ls;
  jint* m_l;
  integer* m_ll;
  jsize m_ls;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jint* k_l;
  integer* k_ll;
  jsize k_ls;
  jdouble* a_ll;
  jint* lda_l;
  integer* lda_ll;
  jsize lda_ls;
  jdouble* tau_ll;
  jdouble* c_ll;
  jint* ldc_l;
  integer* ldc_ll;
  jsize ldc_ls;
  jdouble* work_ll;
  jint* lwork_l;
  integer* lwork_ll;
  jsize lwork_ls;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  side_l = (*env)->GetPrimitiveArrayCritical(env, side, NULL);
  side_ls = (*env)->GetArrayLength(env, side);
  side_ll = malloc(sizeof(char)*side_ls);
  for (i_loc=0; i_loc<side_ls; ++i_loc) side_ll[i_loc] = side_l[i_loc];
  trans_l = (*env)->GetPrimitiveArrayCritical(env, trans, NULL);
  trans_ls = (*env)->GetArrayLength(env, trans);
  trans_ll = malloc(sizeof(char)*trans_ls);
  for (i_loc=0; i_loc<trans_ls; ++i_loc) trans_ll[i_loc] = trans_l[i_loc];
  m_l = (*env)->GetPrimitiveArrayCritical(env, m, NULL);
  m_ls = (*env)->GetArrayLength(env, m);
  m_ll = malloc(sizeof(integer)*m_ls);
  for (i_loc=0; i_loc<m_ls; ++i_loc) m_ll[i_loc] = m_l[i_loc];
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  k_l = (*env)->GetPrimitiveArrayCritical(env, k, NULL);
  k_ls = (*env)->GetArrayLength(env, k);
  k_ll = malloc(sizeof(integer)*k_ls);
  for (i_loc=0; i_loc<k_ls; ++i_loc) k_ll[i_loc] = k_l[i_loc];
  a_ll = (*env)->GetPrimitiveArrayCritical(env, a, NULL);
  lda_l = (*env)->GetPrimitiveArrayCritical(env, lda, NULL);
  lda_ls = (*env)->GetArrayLength(env, lda);
  lda_ll = malloc(sizeof(integer)*lda_ls);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_ll[i_loc] = lda_l[i_loc];
  tau_ll = (*env)->GetPrimitiveArrayCritical(env, tau, NULL);
  c_ll = (*env)->GetPrimitiveArrayCritical(env, c, NULL);
  ldc_l = (*env)->GetPrimitiveArrayCritical(env, ldc, NULL);
  ldc_ls = (*env)->GetArrayLength(env, ldc);
  ldc_ll = malloc(sizeof(integer)*ldc_ls);
  for (i_loc=0; i_loc<ldc_ls; ++i_loc) ldc_ll[i_loc] = ldc_l[i_loc];
  work_ll = (*env)->GetPrimitiveArrayCritical(env, work, NULL);
  lwork_l = (*env)->GetPrimitiveArrayCritical(env, lwork, NULL);
  lwork_ls = (*env)->GetArrayLength(env, lwork);
  lwork_ll = malloc(sizeof(integer)*lwork_ls);
  for (i_loc=0; i_loc<lwork_ls; ++i_loc) lwork_ll[i_loc] = lwork_l[i_loc];
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dormqr_(side_ll, trans_ll, m_ll, n_ll, k_ll, a_ll, lda_ll, tau_ll, c_ll, ldc_ll, work_ll, lwork_ll, info_ll);

  for (i_loc=0; i_loc<side_ls; ++i_loc) side_l[i_loc] = side_ll[i_loc];
  free(side_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, side, side_l, 0);
  for (i_loc=0; i_loc<trans_ls; ++i_loc) trans_l[i_loc] = trans_ll[i_loc];
  free(trans_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, trans, trans_l, 0);
  for (i_loc=0; i_loc<m_ls; ++i_loc) m_l[i_loc] = m_ll[i_loc];
  free(m_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, m, m_l, 0);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  for (i_loc=0; i_loc<k_ls; ++i_loc) k_l[i_loc] = k_ll[i_loc];
  free(k_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, k, k_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, a, a_ll, 0);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_l[i_loc] = lda_ll[i_loc];
  free(lda_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, lda, lda_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, tau, tau_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, c, c_ll, 0);
  for (i_loc=0; i_loc<ldc_ls; ++i_loc) ldc_l[i_loc] = ldc_ll[i_loc];
  free(ldc_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldc, ldc_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, work, work_ll, 0);
  for (i_loc=0; i_loc<lwork_ls; ++i_loc) lwork_l[i_loc] = lwork_ll[i_loc];
  free(lwork_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, lwork, lwork_l, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_ormr2
(JNIEnv *env, jclass clazz, jcharArray side, jcharArray trans, jintArray m, jintArray n, jintArray k, jdoubleArray a, jintArray lda, jdoubleArray tau, jdoubleArray c, jintArray ldc, jdoubleArray work, jintArray info) {
  int i_loc;
  jchar* side_l;
  char* side_ll;
  jsize side_ls;
  jchar* trans_l;
  char* trans_ll;
  jsize trans_ls;
  jint* m_l;
  integer* m_ll;
  jsize m_ls;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jint* k_l;
  integer* k_ll;
  jsize k_ls;
  jdouble* a_ll;
  jint* lda_l;
  integer* lda_ll;
  jsize lda_ls;
  jdouble* tau_ll;
  jdouble* c_ll;
  jint* ldc_l;
  integer* ldc_ll;
  jsize ldc_ls;
  jdouble* work_ll;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  side_l = (*env)->GetPrimitiveArrayCritical(env, side, NULL);
  side_ls = (*env)->GetArrayLength(env, side);
  side_ll = malloc(sizeof(char)*side_ls);
  for (i_loc=0; i_loc<side_ls; ++i_loc) side_ll[i_loc] = side_l[i_loc];
  trans_l = (*env)->GetPrimitiveArrayCritical(env, trans, NULL);
  trans_ls = (*env)->GetArrayLength(env, trans);
  trans_ll = malloc(sizeof(char)*trans_ls);
  for (i_loc=0; i_loc<trans_ls; ++i_loc) trans_ll[i_loc] = trans_l[i_loc];
  m_l = (*env)->GetPrimitiveArrayCritical(env, m, NULL);
  m_ls = (*env)->GetArrayLength(env, m);
  m_ll = malloc(sizeof(integer)*m_ls);
  for (i_loc=0; i_loc<m_ls; ++i_loc) m_ll[i_loc] = m_l[i_loc];
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  k_l = (*env)->GetPrimitiveArrayCritical(env, k, NULL);
  k_ls = (*env)->GetArrayLength(env, k);
  k_ll = malloc(sizeof(integer)*k_ls);
  for (i_loc=0; i_loc<k_ls; ++i_loc) k_ll[i_loc] = k_l[i_loc];
  a_ll = (*env)->GetPrimitiveArrayCritical(env, a, NULL);
  lda_l = (*env)->GetPrimitiveArrayCritical(env, lda, NULL);
  lda_ls = (*env)->GetArrayLength(env, lda);
  lda_ll = malloc(sizeof(integer)*lda_ls);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_ll[i_loc] = lda_l[i_loc];
  tau_ll = (*env)->GetPrimitiveArrayCritical(env, tau, NULL);
  c_ll = (*env)->GetPrimitiveArrayCritical(env, c, NULL);
  ldc_l = (*env)->GetPrimitiveArrayCritical(env, ldc, NULL);
  ldc_ls = (*env)->GetArrayLength(env, ldc);
  ldc_ll = malloc(sizeof(integer)*ldc_ls);
  for (i_loc=0; i_loc<ldc_ls; ++i_loc) ldc_ll[i_loc] = ldc_l[i_loc];
  work_ll = (*env)->GetPrimitiveArrayCritical(env, work, NULL);
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dormr2_(side_ll, trans_ll, m_ll, n_ll, k_ll, a_ll, lda_ll, tau_ll, c_ll, ldc_ll, work_ll, info_ll);

  for (i_loc=0; i_loc<side_ls; ++i_loc) side_l[i_loc] = side_ll[i_loc];
  free(side_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, side, side_l, 0);
  for (i_loc=0; i_loc<trans_ls; ++i_loc) trans_l[i_loc] = trans_ll[i_loc];
  free(trans_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, trans, trans_l, 0);
  for (i_loc=0; i_loc<m_ls; ++i_loc) m_l[i_loc] = m_ll[i_loc];
  free(m_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, m, m_l, 0);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  for (i_loc=0; i_loc<k_ls; ++i_loc) k_l[i_loc] = k_ll[i_loc];
  free(k_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, k, k_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, a, a_ll, 0);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_l[i_loc] = lda_ll[i_loc];
  free(lda_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, lda, lda_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, tau, tau_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, c, c_ll, 0);
  for (i_loc=0; i_loc<ldc_ls; ++i_loc) ldc_l[i_loc] = ldc_ll[i_loc];
  free(ldc_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldc, ldc_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, work, work_ll, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_ormr3
(JNIEnv *env, jclass clazz, jcharArray side, jcharArray trans, jintArray m, jintArray n, jintArray k, jintArray l, jdoubleArray a, jintArray lda, jdoubleArray tau, jdoubleArray c, jintArray ldc, jdoubleArray work, jintArray info) {
  int i_loc;
  jchar* side_l;
  char* side_ll;
  jsize side_ls;
  jchar* trans_l;
  char* trans_ll;
  jsize trans_ls;
  jint* m_l;
  integer* m_ll;
  jsize m_ls;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jint* k_l;
  integer* k_ll;
  jsize k_ls;
  jint* l_l;
  integer* l_ll;
  jsize l_ls;
  jdouble* a_ll;
  jint* lda_l;
  integer* lda_ll;
  jsize lda_ls;
  jdouble* tau_ll;
  jdouble* c_ll;
  jint* ldc_l;
  integer* ldc_ll;
  jsize ldc_ls;
  jdouble* work_ll;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  side_l = (*env)->GetPrimitiveArrayCritical(env, side, NULL);
  side_ls = (*env)->GetArrayLength(env, side);
  side_ll = malloc(sizeof(char)*side_ls);
  for (i_loc=0; i_loc<side_ls; ++i_loc) side_ll[i_loc] = side_l[i_loc];
  trans_l = (*env)->GetPrimitiveArrayCritical(env, trans, NULL);
  trans_ls = (*env)->GetArrayLength(env, trans);
  trans_ll = malloc(sizeof(char)*trans_ls);
  for (i_loc=0; i_loc<trans_ls; ++i_loc) trans_ll[i_loc] = trans_l[i_loc];
  m_l = (*env)->GetPrimitiveArrayCritical(env, m, NULL);
  m_ls = (*env)->GetArrayLength(env, m);
  m_ll = malloc(sizeof(integer)*m_ls);
  for (i_loc=0; i_loc<m_ls; ++i_loc) m_ll[i_loc] = m_l[i_loc];
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  k_l = (*env)->GetPrimitiveArrayCritical(env, k, NULL);
  k_ls = (*env)->GetArrayLength(env, k);
  k_ll = malloc(sizeof(integer)*k_ls);
  for (i_loc=0; i_loc<k_ls; ++i_loc) k_ll[i_loc] = k_l[i_loc];
  l_l = (*env)->GetPrimitiveArrayCritical(env, l, NULL);
  l_ls = (*env)->GetArrayLength(env, l);
  l_ll = malloc(sizeof(integer)*l_ls);
  for (i_loc=0; i_loc<l_ls; ++i_loc) l_ll[i_loc] = l_l[i_loc];
  a_ll = (*env)->GetPrimitiveArrayCritical(env, a, NULL);
  lda_l = (*env)->GetPrimitiveArrayCritical(env, lda, NULL);
  lda_ls = (*env)->GetArrayLength(env, lda);
  lda_ll = malloc(sizeof(integer)*lda_ls);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_ll[i_loc] = lda_l[i_loc];
  tau_ll = (*env)->GetPrimitiveArrayCritical(env, tau, NULL);
  c_ll = (*env)->GetPrimitiveArrayCritical(env, c, NULL);
  ldc_l = (*env)->GetPrimitiveArrayCritical(env, ldc, NULL);
  ldc_ls = (*env)->GetArrayLength(env, ldc);
  ldc_ll = malloc(sizeof(integer)*ldc_ls);
  for (i_loc=0; i_loc<ldc_ls; ++i_loc) ldc_ll[i_loc] = ldc_l[i_loc];
  work_ll = (*env)->GetPrimitiveArrayCritical(env, work, NULL);
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dormr3_(side_ll, trans_ll, m_ll, n_ll, k_ll, l_ll, a_ll, lda_ll, tau_ll, c_ll, ldc_ll, work_ll, info_ll);

  for (i_loc=0; i_loc<side_ls; ++i_loc) side_l[i_loc] = side_ll[i_loc];
  free(side_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, side, side_l, 0);
  for (i_loc=0; i_loc<trans_ls; ++i_loc) trans_l[i_loc] = trans_ll[i_loc];
  free(trans_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, trans, trans_l, 0);
  for (i_loc=0; i_loc<m_ls; ++i_loc) m_l[i_loc] = m_ll[i_loc];
  free(m_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, m, m_l, 0);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  for (i_loc=0; i_loc<k_ls; ++i_loc) k_l[i_loc] = k_ll[i_loc];
  free(k_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, k, k_l, 0);
  for (i_loc=0; i_loc<l_ls; ++i_loc) l_l[i_loc] = l_ll[i_loc];
  free(l_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, l, l_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, a, a_ll, 0);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_l[i_loc] = lda_ll[i_loc];
  free(lda_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, lda, lda_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, tau, tau_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, c, c_ll, 0);
  for (i_loc=0; i_loc<ldc_ls; ++i_loc) ldc_l[i_loc] = ldc_ll[i_loc];
  free(ldc_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldc, ldc_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, work, work_ll, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_ormrq
(JNIEnv *env, jclass clazz, jcharArray side, jcharArray trans, jintArray m, jintArray n, jintArray k, jdoubleArray a, jintArray lda, jdoubleArray tau, jdoubleArray c, jintArray ldc, jdoubleArray work, jintArray lwork, jintArray info) {
  int i_loc;
  jchar* side_l;
  char* side_ll;
  jsize side_ls;
  jchar* trans_l;
  char* trans_ll;
  jsize trans_ls;
  jint* m_l;
  integer* m_ll;
  jsize m_ls;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jint* k_l;
  integer* k_ll;
  jsize k_ls;
  jdouble* a_ll;
  jint* lda_l;
  integer* lda_ll;
  jsize lda_ls;
  jdouble* tau_ll;
  jdouble* c_ll;
  jint* ldc_l;
  integer* ldc_ll;
  jsize ldc_ls;
  jdouble* work_ll;
  jint* lwork_l;
  integer* lwork_ll;
  jsize lwork_ls;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  side_l = (*env)->GetPrimitiveArrayCritical(env, side, NULL);
  side_ls = (*env)->GetArrayLength(env, side);
  side_ll = malloc(sizeof(char)*side_ls);
  for (i_loc=0; i_loc<side_ls; ++i_loc) side_ll[i_loc] = side_l[i_loc];
  trans_l = (*env)->GetPrimitiveArrayCritical(env, trans, NULL);
  trans_ls = (*env)->GetArrayLength(env, trans);
  trans_ll = malloc(sizeof(char)*trans_ls);
  for (i_loc=0; i_loc<trans_ls; ++i_loc) trans_ll[i_loc] = trans_l[i_loc];
  m_l = (*env)->GetPrimitiveArrayCritical(env, m, NULL);
  m_ls = (*env)->GetArrayLength(env, m);
  m_ll = malloc(sizeof(integer)*m_ls);
  for (i_loc=0; i_loc<m_ls; ++i_loc) m_ll[i_loc] = m_l[i_loc];
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  k_l = (*env)->GetPrimitiveArrayCritical(env, k, NULL);
  k_ls = (*env)->GetArrayLength(env, k);
  k_ll = malloc(sizeof(integer)*k_ls);
  for (i_loc=0; i_loc<k_ls; ++i_loc) k_ll[i_loc] = k_l[i_loc];
  a_ll = (*env)->GetPrimitiveArrayCritical(env, a, NULL);
  lda_l = (*env)->GetPrimitiveArrayCritical(env, lda, NULL);
  lda_ls = (*env)->GetArrayLength(env, lda);
  lda_ll = malloc(sizeof(integer)*lda_ls);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_ll[i_loc] = lda_l[i_loc];
  tau_ll = (*env)->GetPrimitiveArrayCritical(env, tau, NULL);
  c_ll = (*env)->GetPrimitiveArrayCritical(env, c, NULL);
  ldc_l = (*env)->GetPrimitiveArrayCritical(env, ldc, NULL);
  ldc_ls = (*env)->GetArrayLength(env, ldc);
  ldc_ll = malloc(sizeof(integer)*ldc_ls);
  for (i_loc=0; i_loc<ldc_ls; ++i_loc) ldc_ll[i_loc] = ldc_l[i_loc];
  work_ll = (*env)->GetPrimitiveArrayCritical(env, work, NULL);
  lwork_l = (*env)->GetPrimitiveArrayCritical(env, lwork, NULL);
  lwork_ls = (*env)->GetArrayLength(env, lwork);
  lwork_ll = malloc(sizeof(integer)*lwork_ls);
  for (i_loc=0; i_loc<lwork_ls; ++i_loc) lwork_ll[i_loc] = lwork_l[i_loc];
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dormrq_(side_ll, trans_ll, m_ll, n_ll, k_ll, a_ll, lda_ll, tau_ll, c_ll, ldc_ll, work_ll, lwork_ll, info_ll);

  for (i_loc=0; i_loc<side_ls; ++i_loc) side_l[i_loc] = side_ll[i_loc];
  free(side_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, side, side_l, 0);
  for (i_loc=0; i_loc<trans_ls; ++i_loc) trans_l[i_loc] = trans_ll[i_loc];
  free(trans_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, trans, trans_l, 0);
  for (i_loc=0; i_loc<m_ls; ++i_loc) m_l[i_loc] = m_ll[i_loc];
  free(m_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, m, m_l, 0);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  for (i_loc=0; i_loc<k_ls; ++i_loc) k_l[i_loc] = k_ll[i_loc];
  free(k_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, k, k_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, a, a_ll, 0);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_l[i_loc] = lda_ll[i_loc];
  free(lda_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, lda, lda_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, tau, tau_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, c, c_ll, 0);
  for (i_loc=0; i_loc<ldc_ls; ++i_loc) ldc_l[i_loc] = ldc_ll[i_loc];
  free(ldc_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldc, ldc_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, work, work_ll, 0);
  for (i_loc=0; i_loc<lwork_ls; ++i_loc) lwork_l[i_loc] = lwork_ll[i_loc];
  free(lwork_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, lwork, lwork_l, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_ormrz
(JNIEnv *env, jclass clazz, jcharArray side, jcharArray trans, jintArray m, jintArray n, jintArray k, jintArray l, jdoubleArray a, jintArray lda, jdoubleArray tau, jdoubleArray c, jintArray ldc, jdoubleArray work, jintArray lwork, jintArray info) {
  int i_loc;
  jchar* side_l;
  char* side_ll;
  jsize side_ls;
  jchar* trans_l;
  char* trans_ll;
  jsize trans_ls;
  jint* m_l;
  integer* m_ll;
  jsize m_ls;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jint* k_l;
  integer* k_ll;
  jsize k_ls;
  jint* l_l;
  integer* l_ll;
  jsize l_ls;
  jdouble* a_ll;
  jint* lda_l;
  integer* lda_ll;
  jsize lda_ls;
  jdouble* tau_ll;
  jdouble* c_ll;
  jint* ldc_l;
  integer* ldc_ll;
  jsize ldc_ls;
  jdouble* work_ll;
  jint* lwork_l;
  integer* lwork_ll;
  jsize lwork_ls;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  side_l = (*env)->GetPrimitiveArrayCritical(env, side, NULL);
  side_ls = (*env)->GetArrayLength(env, side);
  side_ll = malloc(sizeof(char)*side_ls);
  for (i_loc=0; i_loc<side_ls; ++i_loc) side_ll[i_loc] = side_l[i_loc];
  trans_l = (*env)->GetPrimitiveArrayCritical(env, trans, NULL);
  trans_ls = (*env)->GetArrayLength(env, trans);
  trans_ll = malloc(sizeof(char)*trans_ls);
  for (i_loc=0; i_loc<trans_ls; ++i_loc) trans_ll[i_loc] = trans_l[i_loc];
  m_l = (*env)->GetPrimitiveArrayCritical(env, m, NULL);
  m_ls = (*env)->GetArrayLength(env, m);
  m_ll = malloc(sizeof(integer)*m_ls);
  for (i_loc=0; i_loc<m_ls; ++i_loc) m_ll[i_loc] = m_l[i_loc];
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  k_l = (*env)->GetPrimitiveArrayCritical(env, k, NULL);
  k_ls = (*env)->GetArrayLength(env, k);
  k_ll = malloc(sizeof(integer)*k_ls);
  for (i_loc=0; i_loc<k_ls; ++i_loc) k_ll[i_loc] = k_l[i_loc];
  l_l = (*env)->GetPrimitiveArrayCritical(env, l, NULL);
  l_ls = (*env)->GetArrayLength(env, l);
  l_ll = malloc(sizeof(integer)*l_ls);
  for (i_loc=0; i_loc<l_ls; ++i_loc) l_ll[i_loc] = l_l[i_loc];
  a_ll = (*env)->GetPrimitiveArrayCritical(env, a, NULL);
  lda_l = (*env)->GetPrimitiveArrayCritical(env, lda, NULL);
  lda_ls = (*env)->GetArrayLength(env, lda);
  lda_ll = malloc(sizeof(integer)*lda_ls);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_ll[i_loc] = lda_l[i_loc];
  tau_ll = (*env)->GetPrimitiveArrayCritical(env, tau, NULL);
  c_ll = (*env)->GetPrimitiveArrayCritical(env, c, NULL);
  ldc_l = (*env)->GetPrimitiveArrayCritical(env, ldc, NULL);
  ldc_ls = (*env)->GetArrayLength(env, ldc);
  ldc_ll = malloc(sizeof(integer)*ldc_ls);
  for (i_loc=0; i_loc<ldc_ls; ++i_loc) ldc_ll[i_loc] = ldc_l[i_loc];
  work_ll = (*env)->GetPrimitiveArrayCritical(env, work, NULL);
  lwork_l = (*env)->GetPrimitiveArrayCritical(env, lwork, NULL);
  lwork_ls = (*env)->GetArrayLength(env, lwork);
  lwork_ll = malloc(sizeof(integer)*lwork_ls);
  for (i_loc=0; i_loc<lwork_ls; ++i_loc) lwork_ll[i_loc] = lwork_l[i_loc];
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dormrz_(side_ll, trans_ll, m_ll, n_ll, k_ll, l_ll, a_ll, lda_ll, tau_ll, c_ll, ldc_ll, work_ll, lwork_ll, info_ll);

  for (i_loc=0; i_loc<side_ls; ++i_loc) side_l[i_loc] = side_ll[i_loc];
  free(side_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, side, side_l, 0);
  for (i_loc=0; i_loc<trans_ls; ++i_loc) trans_l[i_loc] = trans_ll[i_loc];
  free(trans_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, trans, trans_l, 0);
  for (i_loc=0; i_loc<m_ls; ++i_loc) m_l[i_loc] = m_ll[i_loc];
  free(m_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, m, m_l, 0);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  for (i_loc=0; i_loc<k_ls; ++i_loc) k_l[i_loc] = k_ll[i_loc];
  free(k_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, k, k_l, 0);
  for (i_loc=0; i_loc<l_ls; ++i_loc) l_l[i_loc] = l_ll[i_loc];
  free(l_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, l, l_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, a, a_ll, 0);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_l[i_loc] = lda_ll[i_loc];
  free(lda_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, lda, lda_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, tau, tau_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, c, c_ll, 0);
  for (i_loc=0; i_loc<ldc_ls; ++i_loc) ldc_l[i_loc] = ldc_ll[i_loc];
  free(ldc_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldc, ldc_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, work, work_ll, 0);
  for (i_loc=0; i_loc<lwork_ls; ++i_loc) lwork_l[i_loc] = lwork_ll[i_loc];
  free(lwork_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, lwork, lwork_l, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_ormtr
(JNIEnv *env, jclass clazz, jcharArray side, jcharArray uplo, jcharArray trans, jintArray m, jintArray n, jdoubleArray a, jintArray lda, jdoubleArray tau, jdoubleArray c, jintArray ldc, jdoubleArray work, jintArray lwork, jintArray info) {
  int i_loc;
  jchar* side_l;
  char* side_ll;
  jsize side_ls;
  jchar* uplo_l;
  char* uplo_ll;
  jsize uplo_ls;
  jchar* trans_l;
  char* trans_ll;
  jsize trans_ls;
  jint* m_l;
  integer* m_ll;
  jsize m_ls;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jdouble* a_ll;
  jint* lda_l;
  integer* lda_ll;
  jsize lda_ls;
  jdouble* tau_ll;
  jdouble* c_ll;
  jint* ldc_l;
  integer* ldc_ll;
  jsize ldc_ls;
  jdouble* work_ll;
  jint* lwork_l;
  integer* lwork_ll;
  jsize lwork_ls;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  side_l = (*env)->GetPrimitiveArrayCritical(env, side, NULL);
  side_ls = (*env)->GetArrayLength(env, side);
  side_ll = malloc(sizeof(char)*side_ls);
  for (i_loc=0; i_loc<side_ls; ++i_loc) side_ll[i_loc] = side_l[i_loc];
  uplo_l = (*env)->GetPrimitiveArrayCritical(env, uplo, NULL);
  uplo_ls = (*env)->GetArrayLength(env, uplo);
  uplo_ll = malloc(sizeof(char)*uplo_ls);
  for (i_loc=0; i_loc<uplo_ls; ++i_loc) uplo_ll[i_loc] = uplo_l[i_loc];
  trans_l = (*env)->GetPrimitiveArrayCritical(env, trans, NULL);
  trans_ls = (*env)->GetArrayLength(env, trans);
  trans_ll = malloc(sizeof(char)*trans_ls);
  for (i_loc=0; i_loc<trans_ls; ++i_loc) trans_ll[i_loc] = trans_l[i_loc];
  m_l = (*env)->GetPrimitiveArrayCritical(env, m, NULL);
  m_ls = (*env)->GetArrayLength(env, m);
  m_ll = malloc(sizeof(integer)*m_ls);
  for (i_loc=0; i_loc<m_ls; ++i_loc) m_ll[i_loc] = m_l[i_loc];
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  a_ll = (*env)->GetPrimitiveArrayCritical(env, a, NULL);
  lda_l = (*env)->GetPrimitiveArrayCritical(env, lda, NULL);
  lda_ls = (*env)->GetArrayLength(env, lda);
  lda_ll = malloc(sizeof(integer)*lda_ls);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_ll[i_loc] = lda_l[i_loc];
  tau_ll = (*env)->GetPrimitiveArrayCritical(env, tau, NULL);
  c_ll = (*env)->GetPrimitiveArrayCritical(env, c, NULL);
  ldc_l = (*env)->GetPrimitiveArrayCritical(env, ldc, NULL);
  ldc_ls = (*env)->GetArrayLength(env, ldc);
  ldc_ll = malloc(sizeof(integer)*ldc_ls);
  for (i_loc=0; i_loc<ldc_ls; ++i_loc) ldc_ll[i_loc] = ldc_l[i_loc];
  work_ll = (*env)->GetPrimitiveArrayCritical(env, work, NULL);
  lwork_l = (*env)->GetPrimitiveArrayCritical(env, lwork, NULL);
  lwork_ls = (*env)->GetArrayLength(env, lwork);
  lwork_ll = malloc(sizeof(integer)*lwork_ls);
  for (i_loc=0; i_loc<lwork_ls; ++i_loc) lwork_ll[i_loc] = lwork_l[i_loc];
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dormtr_(side_ll, uplo_ll, trans_ll, m_ll, n_ll, a_ll, lda_ll, tau_ll, c_ll, ldc_ll, work_ll, lwork_ll, info_ll);

  for (i_loc=0; i_loc<side_ls; ++i_loc) side_l[i_loc] = side_ll[i_loc];
  free(side_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, side, side_l, 0);
  for (i_loc=0; i_loc<uplo_ls; ++i_loc) uplo_l[i_loc] = uplo_ll[i_loc];
  free(uplo_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, uplo, uplo_l, 0);
  for (i_loc=0; i_loc<trans_ls; ++i_loc) trans_l[i_loc] = trans_ll[i_loc];
  free(trans_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, trans, trans_l, 0);
  for (i_loc=0; i_loc<m_ls; ++i_loc) m_l[i_loc] = m_ll[i_loc];
  free(m_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, m, m_l, 0);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, a, a_ll, 0);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_l[i_loc] = lda_ll[i_loc];
  free(lda_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, lda, lda_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, tau, tau_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, c, c_ll, 0);
  for (i_loc=0; i_loc<ldc_ls; ++i_loc) ldc_l[i_loc] = ldc_ll[i_loc];
  free(ldc_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldc, ldc_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, work, work_ll, 0);
  for (i_loc=0; i_loc<lwork_ls; ++i_loc) lwork_l[i_loc] = lwork_ll[i_loc];
  free(lwork_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, lwork, lwork_l, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_pbcon
(JNIEnv *env, jclass clazz, jcharArray uplo, jintArray n, jintArray kd, jdoubleArray ab, jintArray ldab, jdoubleArray anorm, jdoubleArray rcond, jdoubleArray work, jintArray iwork, jintArray info) {
  int i_loc;
  jchar* uplo_l;
  char* uplo_ll;
  jsize uplo_ls;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jint* kd_l;
  integer* kd_ll;
  jsize kd_ls;
  jdouble* ab_ll;
  jint* ldab_l;
  integer* ldab_ll;
  jsize ldab_ls;
  jdouble* anorm_ll;
  jdouble* rcond_ll;
  jdouble* work_ll;
  jint* iwork_l;
  integer* iwork_ll;
  jsize iwork_ls;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  uplo_l = (*env)->GetPrimitiveArrayCritical(env, uplo, NULL);
  uplo_ls = (*env)->GetArrayLength(env, uplo);
  uplo_ll = malloc(sizeof(char)*uplo_ls);
  for (i_loc=0; i_loc<uplo_ls; ++i_loc) uplo_ll[i_loc] = uplo_l[i_loc];
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  kd_l = (*env)->GetPrimitiveArrayCritical(env, kd, NULL);
  kd_ls = (*env)->GetArrayLength(env, kd);
  kd_ll = malloc(sizeof(integer)*kd_ls);
  for (i_loc=0; i_loc<kd_ls; ++i_loc) kd_ll[i_loc] = kd_l[i_loc];
  ab_ll = (*env)->GetPrimitiveArrayCritical(env, ab, NULL);
  ldab_l = (*env)->GetPrimitiveArrayCritical(env, ldab, NULL);
  ldab_ls = (*env)->GetArrayLength(env, ldab);
  ldab_ll = malloc(sizeof(integer)*ldab_ls);
  for (i_loc=0; i_loc<ldab_ls; ++i_loc) ldab_ll[i_loc] = ldab_l[i_loc];
  anorm_ll = (*env)->GetPrimitiveArrayCritical(env, anorm, NULL);
  rcond_ll = (*env)->GetPrimitiveArrayCritical(env, rcond, NULL);
  work_ll = (*env)->GetPrimitiveArrayCritical(env, work, NULL);
  iwork_l = (*env)->GetPrimitiveArrayCritical(env, iwork, NULL);
  iwork_ls = (*env)->GetArrayLength(env, iwork);
  iwork_ll = malloc(sizeof(integer)*iwork_ls);
  for (i_loc=0; i_loc<iwork_ls; ++i_loc) iwork_ll[i_loc] = iwork_l[i_loc];
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dpbcon_(uplo_ll, n_ll, kd_ll, ab_ll, ldab_ll, anorm_ll, rcond_ll, work_ll, iwork_ll, info_ll);

  for (i_loc=0; i_loc<uplo_ls; ++i_loc) uplo_l[i_loc] = uplo_ll[i_loc];
  free(uplo_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, uplo, uplo_l, 0);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  for (i_loc=0; i_loc<kd_ls; ++i_loc) kd_l[i_loc] = kd_ll[i_loc];
  free(kd_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, kd, kd_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, ab, ab_ll, 0);
  for (i_loc=0; i_loc<ldab_ls; ++i_loc) ldab_l[i_loc] = ldab_ll[i_loc];
  free(ldab_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldab, ldab_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, anorm, anorm_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, rcond, rcond_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, work, work_ll, 0);
  for (i_loc=0; i_loc<iwork_ls; ++i_loc) iwork_l[i_loc] = iwork_ll[i_loc];
  free(iwork_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, iwork, iwork_l, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_pbequ
(JNIEnv *env, jclass clazz, jcharArray uplo, jintArray n, jintArray kd, jdoubleArray ab, jintArray ldab, jdoubleArray s, jdoubleArray scond, jdoubleArray amax, jintArray info) {
  int i_loc;
  jchar* uplo_l;
  char* uplo_ll;
  jsize uplo_ls;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jint* kd_l;
  integer* kd_ll;
  jsize kd_ls;
  jdouble* ab_ll;
  jint* ldab_l;
  integer* ldab_ll;
  jsize ldab_ls;
  jdouble* s_ll;
  jdouble* scond_ll;
  jdouble* amax_ll;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  uplo_l = (*env)->GetPrimitiveArrayCritical(env, uplo, NULL);
  uplo_ls = (*env)->GetArrayLength(env, uplo);
  uplo_ll = malloc(sizeof(char)*uplo_ls);
  for (i_loc=0; i_loc<uplo_ls; ++i_loc) uplo_ll[i_loc] = uplo_l[i_loc];
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  kd_l = (*env)->GetPrimitiveArrayCritical(env, kd, NULL);
  kd_ls = (*env)->GetArrayLength(env, kd);
  kd_ll = malloc(sizeof(integer)*kd_ls);
  for (i_loc=0; i_loc<kd_ls; ++i_loc) kd_ll[i_loc] = kd_l[i_loc];
  ab_ll = (*env)->GetPrimitiveArrayCritical(env, ab, NULL);
  ldab_l = (*env)->GetPrimitiveArrayCritical(env, ldab, NULL);
  ldab_ls = (*env)->GetArrayLength(env, ldab);
  ldab_ll = malloc(sizeof(integer)*ldab_ls);
  for (i_loc=0; i_loc<ldab_ls; ++i_loc) ldab_ll[i_loc] = ldab_l[i_loc];
  s_ll = (*env)->GetPrimitiveArrayCritical(env, s, NULL);
  scond_ll = (*env)->GetPrimitiveArrayCritical(env, scond, NULL);
  amax_ll = (*env)->GetPrimitiveArrayCritical(env, amax, NULL);
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dpbequ_(uplo_ll, n_ll, kd_ll, ab_ll, ldab_ll, s_ll, scond_ll, amax_ll, info_ll);

  for (i_loc=0; i_loc<uplo_ls; ++i_loc) uplo_l[i_loc] = uplo_ll[i_loc];
  free(uplo_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, uplo, uplo_l, 0);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  for (i_loc=0; i_loc<kd_ls; ++i_loc) kd_l[i_loc] = kd_ll[i_loc];
  free(kd_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, kd, kd_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, ab, ab_ll, 0);
  for (i_loc=0; i_loc<ldab_ls; ++i_loc) ldab_l[i_loc] = ldab_ll[i_loc];
  free(ldab_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldab, ldab_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, s, s_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, scond, scond_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, amax, amax_ll, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_pbrfs
(JNIEnv *env, jclass clazz, jcharArray uplo, jintArray n, jintArray kd, jintArray nrhs, jdoubleArray ab, jintArray ldab, jdoubleArray afb, jintArray ldafb, jdoubleArray b, jintArray ldb, jdoubleArray x, jintArray ldx, jdoubleArray ferr, jdoubleArray berr, jdoubleArray work, jintArray iwork, jintArray info) {
  int i_loc;
  jchar* uplo_l;
  char* uplo_ll;
  jsize uplo_ls;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jint* kd_l;
  integer* kd_ll;
  jsize kd_ls;
  jint* nrhs_l;
  integer* nrhs_ll;
  jsize nrhs_ls;
  jdouble* ab_ll;
  jint* ldab_l;
  integer* ldab_ll;
  jsize ldab_ls;
  jdouble* afb_ll;
  jint* ldafb_l;
  integer* ldafb_ll;
  jsize ldafb_ls;
  jdouble* b_ll;
  jint* ldb_l;
  integer* ldb_ll;
  jsize ldb_ls;
  jdouble* x_ll;
  jint* ldx_l;
  integer* ldx_ll;
  jsize ldx_ls;
  jdouble* ferr_ll;
  jdouble* berr_ll;
  jdouble* work_ll;
  jint* iwork_l;
  integer* iwork_ll;
  jsize iwork_ls;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  uplo_l = (*env)->GetPrimitiveArrayCritical(env, uplo, NULL);
  uplo_ls = (*env)->GetArrayLength(env, uplo);
  uplo_ll = malloc(sizeof(char)*uplo_ls);
  for (i_loc=0; i_loc<uplo_ls; ++i_loc) uplo_ll[i_loc] = uplo_l[i_loc];
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  kd_l = (*env)->GetPrimitiveArrayCritical(env, kd, NULL);
  kd_ls = (*env)->GetArrayLength(env, kd);
  kd_ll = malloc(sizeof(integer)*kd_ls);
  for (i_loc=0; i_loc<kd_ls; ++i_loc) kd_ll[i_loc] = kd_l[i_loc];
  nrhs_l = (*env)->GetPrimitiveArrayCritical(env, nrhs, NULL);
  nrhs_ls = (*env)->GetArrayLength(env, nrhs);
  nrhs_ll = malloc(sizeof(integer)*nrhs_ls);
  for (i_loc=0; i_loc<nrhs_ls; ++i_loc) nrhs_ll[i_loc] = nrhs_l[i_loc];
  ab_ll = (*env)->GetPrimitiveArrayCritical(env, ab, NULL);
  ldab_l = (*env)->GetPrimitiveArrayCritical(env, ldab, NULL);
  ldab_ls = (*env)->GetArrayLength(env, ldab);
  ldab_ll = malloc(sizeof(integer)*ldab_ls);
  for (i_loc=0; i_loc<ldab_ls; ++i_loc) ldab_ll[i_loc] = ldab_l[i_loc];
  afb_ll = (*env)->GetPrimitiveArrayCritical(env, afb, NULL);
  ldafb_l = (*env)->GetPrimitiveArrayCritical(env, ldafb, NULL);
  ldafb_ls = (*env)->GetArrayLength(env, ldafb);
  ldafb_ll = malloc(sizeof(integer)*ldafb_ls);
  for (i_loc=0; i_loc<ldafb_ls; ++i_loc) ldafb_ll[i_loc] = ldafb_l[i_loc];
  b_ll = (*env)->GetPrimitiveArrayCritical(env, b, NULL);
  ldb_l = (*env)->GetPrimitiveArrayCritical(env, ldb, NULL);
  ldb_ls = (*env)->GetArrayLength(env, ldb);
  ldb_ll = malloc(sizeof(integer)*ldb_ls);
  for (i_loc=0; i_loc<ldb_ls; ++i_loc) ldb_ll[i_loc] = ldb_l[i_loc];
  x_ll = (*env)->GetPrimitiveArrayCritical(env, x, NULL);
  ldx_l = (*env)->GetPrimitiveArrayCritical(env, ldx, NULL);
  ldx_ls = (*env)->GetArrayLength(env, ldx);
  ldx_ll = malloc(sizeof(integer)*ldx_ls);
  for (i_loc=0; i_loc<ldx_ls; ++i_loc) ldx_ll[i_loc] = ldx_l[i_loc];
  ferr_ll = (*env)->GetPrimitiveArrayCritical(env, ferr, NULL);
  berr_ll = (*env)->GetPrimitiveArrayCritical(env, berr, NULL);
  work_ll = (*env)->GetPrimitiveArrayCritical(env, work, NULL);
  iwork_l = (*env)->GetPrimitiveArrayCritical(env, iwork, NULL);
  iwork_ls = (*env)->GetArrayLength(env, iwork);
  iwork_ll = malloc(sizeof(integer)*iwork_ls);
  for (i_loc=0; i_loc<iwork_ls; ++i_loc) iwork_ll[i_loc] = iwork_l[i_loc];
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dpbrfs_(uplo_ll, n_ll, kd_ll, nrhs_ll, ab_ll, ldab_ll, afb_ll, ldafb_ll, b_ll, ldb_ll, x_ll, ldx_ll, ferr_ll, berr_ll, work_ll, iwork_ll, info_ll);

  for (i_loc=0; i_loc<uplo_ls; ++i_loc) uplo_l[i_loc] = uplo_ll[i_loc];
  free(uplo_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, uplo, uplo_l, 0);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  for (i_loc=0; i_loc<kd_ls; ++i_loc) kd_l[i_loc] = kd_ll[i_loc];
  free(kd_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, kd, kd_l, 0);
  for (i_loc=0; i_loc<nrhs_ls; ++i_loc) nrhs_l[i_loc] = nrhs_ll[i_loc];
  free(nrhs_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, nrhs, nrhs_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, ab, ab_ll, 0);
  for (i_loc=0; i_loc<ldab_ls; ++i_loc) ldab_l[i_loc] = ldab_ll[i_loc];
  free(ldab_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldab, ldab_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, afb, afb_ll, 0);
  for (i_loc=0; i_loc<ldafb_ls; ++i_loc) ldafb_l[i_loc] = ldafb_ll[i_loc];
  free(ldafb_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldafb, ldafb_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, b, b_ll, 0);
  for (i_loc=0; i_loc<ldb_ls; ++i_loc) ldb_l[i_loc] = ldb_ll[i_loc];
  free(ldb_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldb, ldb_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, x, x_ll, 0);
  for (i_loc=0; i_loc<ldx_ls; ++i_loc) ldx_l[i_loc] = ldx_ll[i_loc];
  free(ldx_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldx, ldx_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, ferr, ferr_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, berr, berr_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, work, work_ll, 0);
  for (i_loc=0; i_loc<iwork_ls; ++i_loc) iwork_l[i_loc] = iwork_ll[i_loc];
  free(iwork_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, iwork, iwork_l, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_pbstf
(JNIEnv *env, jclass clazz, jcharArray uplo, jintArray n, jintArray kd, jdoubleArray ab, jintArray ldab, jintArray info) {
  int i_loc;
  jchar* uplo_l;
  char* uplo_ll;
  jsize uplo_ls;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jint* kd_l;
  integer* kd_ll;
  jsize kd_ls;
  jdouble* ab_ll;
  jint* ldab_l;
  integer* ldab_ll;
  jsize ldab_ls;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  uplo_l = (*env)->GetPrimitiveArrayCritical(env, uplo, NULL);
  uplo_ls = (*env)->GetArrayLength(env, uplo);
  uplo_ll = malloc(sizeof(char)*uplo_ls);
  for (i_loc=0; i_loc<uplo_ls; ++i_loc) uplo_ll[i_loc] = uplo_l[i_loc];
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  kd_l = (*env)->GetPrimitiveArrayCritical(env, kd, NULL);
  kd_ls = (*env)->GetArrayLength(env, kd);
  kd_ll = malloc(sizeof(integer)*kd_ls);
  for (i_loc=0; i_loc<kd_ls; ++i_loc) kd_ll[i_loc] = kd_l[i_loc];
  ab_ll = (*env)->GetPrimitiveArrayCritical(env, ab, NULL);
  ldab_l = (*env)->GetPrimitiveArrayCritical(env, ldab, NULL);
  ldab_ls = (*env)->GetArrayLength(env, ldab);
  ldab_ll = malloc(sizeof(integer)*ldab_ls);
  for (i_loc=0; i_loc<ldab_ls; ++i_loc) ldab_ll[i_loc] = ldab_l[i_loc];
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dpbstf_(uplo_ll, n_ll, kd_ll, ab_ll, ldab_ll, info_ll);

  for (i_loc=0; i_loc<uplo_ls; ++i_loc) uplo_l[i_loc] = uplo_ll[i_loc];
  free(uplo_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, uplo, uplo_l, 0);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  for (i_loc=0; i_loc<kd_ls; ++i_loc) kd_l[i_loc] = kd_ll[i_loc];
  free(kd_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, kd, kd_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, ab, ab_ll, 0);
  for (i_loc=0; i_loc<ldab_ls; ++i_loc) ldab_l[i_loc] = ldab_ll[i_loc];
  free(ldab_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldab, ldab_l, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_pbsv
(JNIEnv *env, jclass clazz, jcharArray uplo, jintArray n, jintArray kd, jintArray nrhs, jdoubleArray ab, jintArray ldab, jdoubleArray b, jintArray ldb, jintArray info) {
  int i_loc;
  jchar* uplo_l;
  char* uplo_ll;
  jsize uplo_ls;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jint* kd_l;
  integer* kd_ll;
  jsize kd_ls;
  jint* nrhs_l;
  integer* nrhs_ll;
  jsize nrhs_ls;
  jdouble* ab_ll;
  jint* ldab_l;
  integer* ldab_ll;
  jsize ldab_ls;
  jdouble* b_ll;
  jint* ldb_l;
  integer* ldb_ll;
  jsize ldb_ls;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  uplo_l = (*env)->GetPrimitiveArrayCritical(env, uplo, NULL);
  uplo_ls = (*env)->GetArrayLength(env, uplo);
  uplo_ll = malloc(sizeof(char)*uplo_ls);
  for (i_loc=0; i_loc<uplo_ls; ++i_loc) uplo_ll[i_loc] = uplo_l[i_loc];
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  kd_l = (*env)->GetPrimitiveArrayCritical(env, kd, NULL);
  kd_ls = (*env)->GetArrayLength(env, kd);
  kd_ll = malloc(sizeof(integer)*kd_ls);
  for (i_loc=0; i_loc<kd_ls; ++i_loc) kd_ll[i_loc] = kd_l[i_loc];
  nrhs_l = (*env)->GetPrimitiveArrayCritical(env, nrhs, NULL);
  nrhs_ls = (*env)->GetArrayLength(env, nrhs);
  nrhs_ll = malloc(sizeof(integer)*nrhs_ls);
  for (i_loc=0; i_loc<nrhs_ls; ++i_loc) nrhs_ll[i_loc] = nrhs_l[i_loc];
  ab_ll = (*env)->GetPrimitiveArrayCritical(env, ab, NULL);
  ldab_l = (*env)->GetPrimitiveArrayCritical(env, ldab, NULL);
  ldab_ls = (*env)->GetArrayLength(env, ldab);
  ldab_ll = malloc(sizeof(integer)*ldab_ls);
  for (i_loc=0; i_loc<ldab_ls; ++i_loc) ldab_ll[i_loc] = ldab_l[i_loc];
  b_ll = (*env)->GetPrimitiveArrayCritical(env, b, NULL);
  ldb_l = (*env)->GetPrimitiveArrayCritical(env, ldb, NULL);
  ldb_ls = (*env)->GetArrayLength(env, ldb);
  ldb_ll = malloc(sizeof(integer)*ldb_ls);
  for (i_loc=0; i_loc<ldb_ls; ++i_loc) ldb_ll[i_loc] = ldb_l[i_loc];
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dpbsv_(uplo_ll, n_ll, kd_ll, nrhs_ll, ab_ll, ldab_ll, b_ll, ldb_ll, info_ll);

  for (i_loc=0; i_loc<uplo_ls; ++i_loc) uplo_l[i_loc] = uplo_ll[i_loc];
  free(uplo_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, uplo, uplo_l, 0);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  for (i_loc=0; i_loc<kd_ls; ++i_loc) kd_l[i_loc] = kd_ll[i_loc];
  free(kd_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, kd, kd_l, 0);
  for (i_loc=0; i_loc<nrhs_ls; ++i_loc) nrhs_l[i_loc] = nrhs_ll[i_loc];
  free(nrhs_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, nrhs, nrhs_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, ab, ab_ll, 0);
  for (i_loc=0; i_loc<ldab_ls; ++i_loc) ldab_l[i_loc] = ldab_ll[i_loc];
  free(ldab_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldab, ldab_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, b, b_ll, 0);
  for (i_loc=0; i_loc<ldb_ls; ++i_loc) ldb_l[i_loc] = ldb_ll[i_loc];
  free(ldb_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldb, ldb_l, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_pbsvx
(JNIEnv *env, jclass clazz, jcharArray fact, jcharArray uplo, jintArray n, jintArray kd, jintArray nrhs, jdoubleArray ab, jintArray ldab, jdoubleArray afb, jintArray ldafb, jcharArray equed, jdoubleArray s, jdoubleArray b, jintArray ldb, jdoubleArray x, jintArray ldx, jdoubleArray rcond, jdoubleArray ferr, jdoubleArray berr, jdoubleArray work, jintArray iwork, jintArray info) {
  int i_loc;
  jchar* fact_l;
  char* fact_ll;
  jsize fact_ls;
  jchar* uplo_l;
  char* uplo_ll;
  jsize uplo_ls;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jint* kd_l;
  integer* kd_ll;
  jsize kd_ls;
  jint* nrhs_l;
  integer* nrhs_ll;
  jsize nrhs_ls;
  jdouble* ab_ll;
  jint* ldab_l;
  integer* ldab_ll;
  jsize ldab_ls;
  jdouble* afb_ll;
  jint* ldafb_l;
  integer* ldafb_ll;
  jsize ldafb_ls;
  jchar* equed_l;
  char* equed_ll;
  jsize equed_ls;
  jdouble* s_ll;
  jdouble* b_ll;
  jint* ldb_l;
  integer* ldb_ll;
  jsize ldb_ls;
  jdouble* x_ll;
  jint* ldx_l;
  integer* ldx_ll;
  jsize ldx_ls;
  jdouble* rcond_ll;
  jdouble* ferr_ll;
  jdouble* berr_ll;
  jdouble* work_ll;
  jint* iwork_l;
  integer* iwork_ll;
  jsize iwork_ls;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  fact_l = (*env)->GetPrimitiveArrayCritical(env, fact, NULL);
  fact_ls = (*env)->GetArrayLength(env, fact);
  fact_ll = malloc(sizeof(char)*fact_ls);
  for (i_loc=0; i_loc<fact_ls; ++i_loc) fact_ll[i_loc] = fact_l[i_loc];
  uplo_l = (*env)->GetPrimitiveArrayCritical(env, uplo, NULL);
  uplo_ls = (*env)->GetArrayLength(env, uplo);
  uplo_ll = malloc(sizeof(char)*uplo_ls);
  for (i_loc=0; i_loc<uplo_ls; ++i_loc) uplo_ll[i_loc] = uplo_l[i_loc];
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  kd_l = (*env)->GetPrimitiveArrayCritical(env, kd, NULL);
  kd_ls = (*env)->GetArrayLength(env, kd);
  kd_ll = malloc(sizeof(integer)*kd_ls);
  for (i_loc=0; i_loc<kd_ls; ++i_loc) kd_ll[i_loc] = kd_l[i_loc];
  nrhs_l = (*env)->GetPrimitiveArrayCritical(env, nrhs, NULL);
  nrhs_ls = (*env)->GetArrayLength(env, nrhs);
  nrhs_ll = malloc(sizeof(integer)*nrhs_ls);
  for (i_loc=0; i_loc<nrhs_ls; ++i_loc) nrhs_ll[i_loc] = nrhs_l[i_loc];
  ab_ll = (*env)->GetPrimitiveArrayCritical(env, ab, NULL);
  ldab_l = (*env)->GetPrimitiveArrayCritical(env, ldab, NULL);
  ldab_ls = (*env)->GetArrayLength(env, ldab);
  ldab_ll = malloc(sizeof(integer)*ldab_ls);
  for (i_loc=0; i_loc<ldab_ls; ++i_loc) ldab_ll[i_loc] = ldab_l[i_loc];
  afb_ll = (*env)->GetPrimitiveArrayCritical(env, afb, NULL);
  ldafb_l = (*env)->GetPrimitiveArrayCritical(env, ldafb, NULL);
  ldafb_ls = (*env)->GetArrayLength(env, ldafb);
  ldafb_ll = malloc(sizeof(integer)*ldafb_ls);
  for (i_loc=0; i_loc<ldafb_ls; ++i_loc) ldafb_ll[i_loc] = ldafb_l[i_loc];
  equed_l = (*env)->GetPrimitiveArrayCritical(env, equed, NULL);
  equed_ls = (*env)->GetArrayLength(env, equed);
  equed_ll = malloc(sizeof(char)*equed_ls);
  for (i_loc=0; i_loc<equed_ls; ++i_loc) equed_ll[i_loc] = equed_l[i_loc];
  s_ll = (*env)->GetPrimitiveArrayCritical(env, s, NULL);
  b_ll = (*env)->GetPrimitiveArrayCritical(env, b, NULL);
  ldb_l = (*env)->GetPrimitiveArrayCritical(env, ldb, NULL);
  ldb_ls = (*env)->GetArrayLength(env, ldb);
  ldb_ll = malloc(sizeof(integer)*ldb_ls);
  for (i_loc=0; i_loc<ldb_ls; ++i_loc) ldb_ll[i_loc] = ldb_l[i_loc];
  x_ll = (*env)->GetPrimitiveArrayCritical(env, x, NULL);
  ldx_l = (*env)->GetPrimitiveArrayCritical(env, ldx, NULL);
  ldx_ls = (*env)->GetArrayLength(env, ldx);
  ldx_ll = malloc(sizeof(integer)*ldx_ls);
  for (i_loc=0; i_loc<ldx_ls; ++i_loc) ldx_ll[i_loc] = ldx_l[i_loc];
  rcond_ll = (*env)->GetPrimitiveArrayCritical(env, rcond, NULL);
  ferr_ll = (*env)->GetPrimitiveArrayCritical(env, ferr, NULL);
  berr_ll = (*env)->GetPrimitiveArrayCritical(env, berr, NULL);
  work_ll = (*env)->GetPrimitiveArrayCritical(env, work, NULL);
  iwork_l = (*env)->GetPrimitiveArrayCritical(env, iwork, NULL);
  iwork_ls = (*env)->GetArrayLength(env, iwork);
  iwork_ll = malloc(sizeof(integer)*iwork_ls);
  for (i_loc=0; i_loc<iwork_ls; ++i_loc) iwork_ll[i_loc] = iwork_l[i_loc];
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dpbsvx_(fact_ll, uplo_ll, n_ll, kd_ll, nrhs_ll, ab_ll, ldab_ll, afb_ll, ldafb_ll, equed_ll, s_ll, b_ll, ldb_ll, x_ll, ldx_ll, rcond_ll, ferr_ll, berr_ll, work_ll, iwork_ll, info_ll);

  for (i_loc=0; i_loc<fact_ls; ++i_loc) fact_l[i_loc] = fact_ll[i_loc];
  free(fact_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, fact, fact_l, 0);
  for (i_loc=0; i_loc<uplo_ls; ++i_loc) uplo_l[i_loc] = uplo_ll[i_loc];
  free(uplo_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, uplo, uplo_l, 0);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  for (i_loc=0; i_loc<kd_ls; ++i_loc) kd_l[i_loc] = kd_ll[i_loc];
  free(kd_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, kd, kd_l, 0);
  for (i_loc=0; i_loc<nrhs_ls; ++i_loc) nrhs_l[i_loc] = nrhs_ll[i_loc];
  free(nrhs_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, nrhs, nrhs_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, ab, ab_ll, 0);
  for (i_loc=0; i_loc<ldab_ls; ++i_loc) ldab_l[i_loc] = ldab_ll[i_loc];
  free(ldab_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldab, ldab_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, afb, afb_ll, 0);
  for (i_loc=0; i_loc<ldafb_ls; ++i_loc) ldafb_l[i_loc] = ldafb_ll[i_loc];
  free(ldafb_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldafb, ldafb_l, 0);
  for (i_loc=0; i_loc<equed_ls; ++i_loc) equed_l[i_loc] = equed_ll[i_loc];
  free(equed_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, equed, equed_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, s, s_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, b, b_ll, 0);
  for (i_loc=0; i_loc<ldb_ls; ++i_loc) ldb_l[i_loc] = ldb_ll[i_loc];
  free(ldb_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldb, ldb_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, x, x_ll, 0);
  for (i_loc=0; i_loc<ldx_ls; ++i_loc) ldx_l[i_loc] = ldx_ll[i_loc];
  free(ldx_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldx, ldx_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, rcond, rcond_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, ferr, ferr_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, berr, berr_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, work, work_ll, 0);
  for (i_loc=0; i_loc<iwork_ls; ++i_loc) iwork_l[i_loc] = iwork_ll[i_loc];
  free(iwork_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, iwork, iwork_l, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_pbtf2
(JNIEnv *env, jclass clazz, jcharArray uplo, jintArray n, jintArray kd, jdoubleArray ab, jintArray ldab, jintArray info) {
  int i_loc;
  jchar* uplo_l;
  char* uplo_ll;
  jsize uplo_ls;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jint* kd_l;
  integer* kd_ll;
  jsize kd_ls;
  jdouble* ab_ll;
  jint* ldab_l;
  integer* ldab_ll;
  jsize ldab_ls;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  uplo_l = (*env)->GetPrimitiveArrayCritical(env, uplo, NULL);
  uplo_ls = (*env)->GetArrayLength(env, uplo);
  uplo_ll = malloc(sizeof(char)*uplo_ls);
  for (i_loc=0; i_loc<uplo_ls; ++i_loc) uplo_ll[i_loc] = uplo_l[i_loc];
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  kd_l = (*env)->GetPrimitiveArrayCritical(env, kd, NULL);
  kd_ls = (*env)->GetArrayLength(env, kd);
  kd_ll = malloc(sizeof(integer)*kd_ls);
  for (i_loc=0; i_loc<kd_ls; ++i_loc) kd_ll[i_loc] = kd_l[i_loc];
  ab_ll = (*env)->GetPrimitiveArrayCritical(env, ab, NULL);
  ldab_l = (*env)->GetPrimitiveArrayCritical(env, ldab, NULL);
  ldab_ls = (*env)->GetArrayLength(env, ldab);
  ldab_ll = malloc(sizeof(integer)*ldab_ls);
  for (i_loc=0; i_loc<ldab_ls; ++i_loc) ldab_ll[i_loc] = ldab_l[i_loc];
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dpbtf2_(uplo_ll, n_ll, kd_ll, ab_ll, ldab_ll, info_ll);

  for (i_loc=0; i_loc<uplo_ls; ++i_loc) uplo_l[i_loc] = uplo_ll[i_loc];
  free(uplo_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, uplo, uplo_l, 0);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  for (i_loc=0; i_loc<kd_ls; ++i_loc) kd_l[i_loc] = kd_ll[i_loc];
  free(kd_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, kd, kd_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, ab, ab_ll, 0);
  for (i_loc=0; i_loc<ldab_ls; ++i_loc) ldab_l[i_loc] = ldab_ll[i_loc];
  free(ldab_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldab, ldab_l, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_pbtrf
(JNIEnv *env, jclass clazz, jcharArray uplo, jintArray n, jintArray kd, jdoubleArray ab, jintArray ldab, jintArray info) {
  int i_loc;
  jchar* uplo_l;
  char* uplo_ll;
  jsize uplo_ls;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jint* kd_l;
  integer* kd_ll;
  jsize kd_ls;
  jdouble* ab_ll;
  jint* ldab_l;
  integer* ldab_ll;
  jsize ldab_ls;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  uplo_l = (*env)->GetPrimitiveArrayCritical(env, uplo, NULL);
  uplo_ls = (*env)->GetArrayLength(env, uplo);
  uplo_ll = malloc(sizeof(char)*uplo_ls);
  for (i_loc=0; i_loc<uplo_ls; ++i_loc) uplo_ll[i_loc] = uplo_l[i_loc];
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  kd_l = (*env)->GetPrimitiveArrayCritical(env, kd, NULL);
  kd_ls = (*env)->GetArrayLength(env, kd);
  kd_ll = malloc(sizeof(integer)*kd_ls);
  for (i_loc=0; i_loc<kd_ls; ++i_loc) kd_ll[i_loc] = kd_l[i_loc];
  ab_ll = (*env)->GetPrimitiveArrayCritical(env, ab, NULL);
  ldab_l = (*env)->GetPrimitiveArrayCritical(env, ldab, NULL);
  ldab_ls = (*env)->GetArrayLength(env, ldab);
  ldab_ll = malloc(sizeof(integer)*ldab_ls);
  for (i_loc=0; i_loc<ldab_ls; ++i_loc) ldab_ll[i_loc] = ldab_l[i_loc];
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dpbtrf_(uplo_ll, n_ll, kd_ll, ab_ll, ldab_ll, info_ll);

  for (i_loc=0; i_loc<uplo_ls; ++i_loc) uplo_l[i_loc] = uplo_ll[i_loc];
  free(uplo_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, uplo, uplo_l, 0);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  for (i_loc=0; i_loc<kd_ls; ++i_loc) kd_l[i_loc] = kd_ll[i_loc];
  free(kd_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, kd, kd_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, ab, ab_ll, 0);
  for (i_loc=0; i_loc<ldab_ls; ++i_loc) ldab_l[i_loc] = ldab_ll[i_loc];
  free(ldab_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldab, ldab_l, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_pbtrs
(JNIEnv *env, jclass clazz, jcharArray uplo, jintArray n, jintArray kd, jintArray nrhs, jdoubleArray ab, jintArray ldab, jdoubleArray b, jintArray ldb, jintArray info) {
  int i_loc;
  jchar* uplo_l;
  char* uplo_ll;
  jsize uplo_ls;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jint* kd_l;
  integer* kd_ll;
  jsize kd_ls;
  jint* nrhs_l;
  integer* nrhs_ll;
  jsize nrhs_ls;
  jdouble* ab_ll;
  jint* ldab_l;
  integer* ldab_ll;
  jsize ldab_ls;
  jdouble* b_ll;
  jint* ldb_l;
  integer* ldb_ll;
  jsize ldb_ls;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  uplo_l = (*env)->GetPrimitiveArrayCritical(env, uplo, NULL);
  uplo_ls = (*env)->GetArrayLength(env, uplo);
  uplo_ll = malloc(sizeof(char)*uplo_ls);
  for (i_loc=0; i_loc<uplo_ls; ++i_loc) uplo_ll[i_loc] = uplo_l[i_loc];
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  kd_l = (*env)->GetPrimitiveArrayCritical(env, kd, NULL);
  kd_ls = (*env)->GetArrayLength(env, kd);
  kd_ll = malloc(sizeof(integer)*kd_ls);
  for (i_loc=0; i_loc<kd_ls; ++i_loc) kd_ll[i_loc] = kd_l[i_loc];
  nrhs_l = (*env)->GetPrimitiveArrayCritical(env, nrhs, NULL);
  nrhs_ls = (*env)->GetArrayLength(env, nrhs);
  nrhs_ll = malloc(sizeof(integer)*nrhs_ls);
  for (i_loc=0; i_loc<nrhs_ls; ++i_loc) nrhs_ll[i_loc] = nrhs_l[i_loc];
  ab_ll = (*env)->GetPrimitiveArrayCritical(env, ab, NULL);
  ldab_l = (*env)->GetPrimitiveArrayCritical(env, ldab, NULL);
  ldab_ls = (*env)->GetArrayLength(env, ldab);
  ldab_ll = malloc(sizeof(integer)*ldab_ls);
  for (i_loc=0; i_loc<ldab_ls; ++i_loc) ldab_ll[i_loc] = ldab_l[i_loc];
  b_ll = (*env)->GetPrimitiveArrayCritical(env, b, NULL);
  ldb_l = (*env)->GetPrimitiveArrayCritical(env, ldb, NULL);
  ldb_ls = (*env)->GetArrayLength(env, ldb);
  ldb_ll = malloc(sizeof(integer)*ldb_ls);
  for (i_loc=0; i_loc<ldb_ls; ++i_loc) ldb_ll[i_loc] = ldb_l[i_loc];
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dpbtrs_(uplo_ll, n_ll, kd_ll, nrhs_ll, ab_ll, ldab_ll, b_ll, ldb_ll, info_ll);

  for (i_loc=0; i_loc<uplo_ls; ++i_loc) uplo_l[i_loc] = uplo_ll[i_loc];
  free(uplo_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, uplo, uplo_l, 0);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  for (i_loc=0; i_loc<kd_ls; ++i_loc) kd_l[i_loc] = kd_ll[i_loc];
  free(kd_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, kd, kd_l, 0);
  for (i_loc=0; i_loc<nrhs_ls; ++i_loc) nrhs_l[i_loc] = nrhs_ll[i_loc];
  free(nrhs_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, nrhs, nrhs_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, ab, ab_ll, 0);
  for (i_loc=0; i_loc<ldab_ls; ++i_loc) ldab_l[i_loc] = ldab_ll[i_loc];
  free(ldab_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldab, ldab_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, b, b_ll, 0);
  for (i_loc=0; i_loc<ldb_ls; ++i_loc) ldb_l[i_loc] = ldb_ll[i_loc];
  free(ldb_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldb, ldb_l, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_pocon
(JNIEnv *env, jclass clazz, jcharArray uplo, jintArray n, jdoubleArray a, jintArray lda, jdoubleArray anorm, jdoubleArray rcond, jdoubleArray work, jintArray iwork, jintArray info) {
  int i_loc;
  jchar* uplo_l;
  char* uplo_ll;
  jsize uplo_ls;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jdouble* a_ll;
  jint* lda_l;
  integer* lda_ll;
  jsize lda_ls;
  jdouble* anorm_ll;
  jdouble* rcond_ll;
  jdouble* work_ll;
  jint* iwork_l;
  integer* iwork_ll;
  jsize iwork_ls;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  uplo_l = (*env)->GetPrimitiveArrayCritical(env, uplo, NULL);
  uplo_ls = (*env)->GetArrayLength(env, uplo);
  uplo_ll = malloc(sizeof(char)*uplo_ls);
  for (i_loc=0; i_loc<uplo_ls; ++i_loc) uplo_ll[i_loc] = uplo_l[i_loc];
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  a_ll = (*env)->GetPrimitiveArrayCritical(env, a, NULL);
  lda_l = (*env)->GetPrimitiveArrayCritical(env, lda, NULL);
  lda_ls = (*env)->GetArrayLength(env, lda);
  lda_ll = malloc(sizeof(integer)*lda_ls);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_ll[i_loc] = lda_l[i_loc];
  anorm_ll = (*env)->GetPrimitiveArrayCritical(env, anorm, NULL);
  rcond_ll = (*env)->GetPrimitiveArrayCritical(env, rcond, NULL);
  work_ll = (*env)->GetPrimitiveArrayCritical(env, work, NULL);
  iwork_l = (*env)->GetPrimitiveArrayCritical(env, iwork, NULL);
  iwork_ls = (*env)->GetArrayLength(env, iwork);
  iwork_ll = malloc(sizeof(integer)*iwork_ls);
  for (i_loc=0; i_loc<iwork_ls; ++i_loc) iwork_ll[i_loc] = iwork_l[i_loc];
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dpocon_(uplo_ll, n_ll, a_ll, lda_ll, anorm_ll, rcond_ll, work_ll, iwork_ll, info_ll);

  for (i_loc=0; i_loc<uplo_ls; ++i_loc) uplo_l[i_loc] = uplo_ll[i_loc];
  free(uplo_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, uplo, uplo_l, 0);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, a, a_ll, 0);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_l[i_loc] = lda_ll[i_loc];
  free(lda_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, lda, lda_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, anorm, anorm_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, rcond, rcond_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, work, work_ll, 0);
  for (i_loc=0; i_loc<iwork_ls; ++i_loc) iwork_l[i_loc] = iwork_ll[i_loc];
  free(iwork_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, iwork, iwork_l, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_poequ
(JNIEnv *env, jclass clazz, jintArray n, jdoubleArray a, jintArray lda, jdoubleArray s, jdoubleArray scond, jdoubleArray amax, jintArray info) {
  int i_loc;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jdouble* a_ll;
  jint* lda_l;
  integer* lda_ll;
  jsize lda_ls;
  jdouble* s_ll;
  jdouble* scond_ll;
  jdouble* amax_ll;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  a_ll = (*env)->GetPrimitiveArrayCritical(env, a, NULL);
  lda_l = (*env)->GetPrimitiveArrayCritical(env, lda, NULL);
  lda_ls = (*env)->GetArrayLength(env, lda);
  lda_ll = malloc(sizeof(integer)*lda_ls);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_ll[i_loc] = lda_l[i_loc];
  s_ll = (*env)->GetPrimitiveArrayCritical(env, s, NULL);
  scond_ll = (*env)->GetPrimitiveArrayCritical(env, scond, NULL);
  amax_ll = (*env)->GetPrimitiveArrayCritical(env, amax, NULL);
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dpoequ_(n_ll, a_ll, lda_ll, s_ll, scond_ll, amax_ll, info_ll);

  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, a, a_ll, 0);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_l[i_loc] = lda_ll[i_loc];
  free(lda_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, lda, lda_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, s, s_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, scond, scond_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, amax, amax_ll, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_porfs
(JNIEnv *env, jclass clazz, jcharArray uplo, jintArray n, jintArray nrhs, jdoubleArray a, jintArray lda, jdoubleArray af, jintArray ldaf, jdoubleArray b, jintArray ldb, jdoubleArray x, jintArray ldx, jdoubleArray ferr, jdoubleArray berr, jdoubleArray work, jintArray iwork, jintArray info) {
  int i_loc;
  jchar* uplo_l;
  char* uplo_ll;
  jsize uplo_ls;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jint* nrhs_l;
  integer* nrhs_ll;
  jsize nrhs_ls;
  jdouble* a_ll;
  jint* lda_l;
  integer* lda_ll;
  jsize lda_ls;
  jdouble* af_ll;
  jint* ldaf_l;
  integer* ldaf_ll;
  jsize ldaf_ls;
  jdouble* b_ll;
  jint* ldb_l;
  integer* ldb_ll;
  jsize ldb_ls;
  jdouble* x_ll;
  jint* ldx_l;
  integer* ldx_ll;
  jsize ldx_ls;
  jdouble* ferr_ll;
  jdouble* berr_ll;
  jdouble* work_ll;
  jint* iwork_l;
  integer* iwork_ll;
  jsize iwork_ls;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  uplo_l = (*env)->GetPrimitiveArrayCritical(env, uplo, NULL);
  uplo_ls = (*env)->GetArrayLength(env, uplo);
  uplo_ll = malloc(sizeof(char)*uplo_ls);
  for (i_loc=0; i_loc<uplo_ls; ++i_loc) uplo_ll[i_loc] = uplo_l[i_loc];
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  nrhs_l = (*env)->GetPrimitiveArrayCritical(env, nrhs, NULL);
  nrhs_ls = (*env)->GetArrayLength(env, nrhs);
  nrhs_ll = malloc(sizeof(integer)*nrhs_ls);
  for (i_loc=0; i_loc<nrhs_ls; ++i_loc) nrhs_ll[i_loc] = nrhs_l[i_loc];
  a_ll = (*env)->GetPrimitiveArrayCritical(env, a, NULL);
  lda_l = (*env)->GetPrimitiveArrayCritical(env, lda, NULL);
  lda_ls = (*env)->GetArrayLength(env, lda);
  lda_ll = malloc(sizeof(integer)*lda_ls);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_ll[i_loc] = lda_l[i_loc];
  af_ll = (*env)->GetPrimitiveArrayCritical(env, af, NULL);
  ldaf_l = (*env)->GetPrimitiveArrayCritical(env, ldaf, NULL);
  ldaf_ls = (*env)->GetArrayLength(env, ldaf);
  ldaf_ll = malloc(sizeof(integer)*ldaf_ls);
  for (i_loc=0; i_loc<ldaf_ls; ++i_loc) ldaf_ll[i_loc] = ldaf_l[i_loc];
  b_ll = (*env)->GetPrimitiveArrayCritical(env, b, NULL);
  ldb_l = (*env)->GetPrimitiveArrayCritical(env, ldb, NULL);
  ldb_ls = (*env)->GetArrayLength(env, ldb);
  ldb_ll = malloc(sizeof(integer)*ldb_ls);
  for (i_loc=0; i_loc<ldb_ls; ++i_loc) ldb_ll[i_loc] = ldb_l[i_loc];
  x_ll = (*env)->GetPrimitiveArrayCritical(env, x, NULL);
  ldx_l = (*env)->GetPrimitiveArrayCritical(env, ldx, NULL);
  ldx_ls = (*env)->GetArrayLength(env, ldx);
  ldx_ll = malloc(sizeof(integer)*ldx_ls);
  for (i_loc=0; i_loc<ldx_ls; ++i_loc) ldx_ll[i_loc] = ldx_l[i_loc];
  ferr_ll = (*env)->GetPrimitiveArrayCritical(env, ferr, NULL);
  berr_ll = (*env)->GetPrimitiveArrayCritical(env, berr, NULL);
  work_ll = (*env)->GetPrimitiveArrayCritical(env, work, NULL);
  iwork_l = (*env)->GetPrimitiveArrayCritical(env, iwork, NULL);
  iwork_ls = (*env)->GetArrayLength(env, iwork);
  iwork_ll = malloc(sizeof(integer)*iwork_ls);
  for (i_loc=0; i_loc<iwork_ls; ++i_loc) iwork_ll[i_loc] = iwork_l[i_loc];
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dporfs_(uplo_ll, n_ll, nrhs_ll, a_ll, lda_ll, af_ll, ldaf_ll, b_ll, ldb_ll, x_ll, ldx_ll, ferr_ll, berr_ll, work_ll, iwork_ll, info_ll);

  for (i_loc=0; i_loc<uplo_ls; ++i_loc) uplo_l[i_loc] = uplo_ll[i_loc];
  free(uplo_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, uplo, uplo_l, 0);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  for (i_loc=0; i_loc<nrhs_ls; ++i_loc) nrhs_l[i_loc] = nrhs_ll[i_loc];
  free(nrhs_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, nrhs, nrhs_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, a, a_ll, 0);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_l[i_loc] = lda_ll[i_loc];
  free(lda_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, lda, lda_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, af, af_ll, 0);
  for (i_loc=0; i_loc<ldaf_ls; ++i_loc) ldaf_l[i_loc] = ldaf_ll[i_loc];
  free(ldaf_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldaf, ldaf_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, b, b_ll, 0);
  for (i_loc=0; i_loc<ldb_ls; ++i_loc) ldb_l[i_loc] = ldb_ll[i_loc];
  free(ldb_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldb, ldb_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, x, x_ll, 0);
  for (i_loc=0; i_loc<ldx_ls; ++i_loc) ldx_l[i_loc] = ldx_ll[i_loc];
  free(ldx_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldx, ldx_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, ferr, ferr_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, berr, berr_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, work, work_ll, 0);
  for (i_loc=0; i_loc<iwork_ls; ++i_loc) iwork_l[i_loc] = iwork_ll[i_loc];
  free(iwork_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, iwork, iwork_l, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_posv
(JNIEnv *env, jclass clazz, jcharArray uplo, jintArray n, jintArray nrhs, jdoubleArray a, jintArray lda, jdoubleArray b, jintArray ldb, jintArray info) {
  int i_loc;
  jchar* uplo_l;
  char* uplo_ll;
  jsize uplo_ls;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jint* nrhs_l;
  integer* nrhs_ll;
  jsize nrhs_ls;
  jdouble* a_ll;
  jint* lda_l;
  integer* lda_ll;
  jsize lda_ls;
  jdouble* b_ll;
  jint* ldb_l;
  integer* ldb_ll;
  jsize ldb_ls;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  uplo_l = (*env)->GetPrimitiveArrayCritical(env, uplo, NULL);
  uplo_ls = (*env)->GetArrayLength(env, uplo);
  uplo_ll = malloc(sizeof(char)*uplo_ls);
  for (i_loc=0; i_loc<uplo_ls; ++i_loc) uplo_ll[i_loc] = uplo_l[i_loc];
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  nrhs_l = (*env)->GetPrimitiveArrayCritical(env, nrhs, NULL);
  nrhs_ls = (*env)->GetArrayLength(env, nrhs);
  nrhs_ll = malloc(sizeof(integer)*nrhs_ls);
  for (i_loc=0; i_loc<nrhs_ls; ++i_loc) nrhs_ll[i_loc] = nrhs_l[i_loc];
  a_ll = (*env)->GetPrimitiveArrayCritical(env, a, NULL);
  lda_l = (*env)->GetPrimitiveArrayCritical(env, lda, NULL);
  lda_ls = (*env)->GetArrayLength(env, lda);
  lda_ll = malloc(sizeof(integer)*lda_ls);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_ll[i_loc] = lda_l[i_loc];
  b_ll = (*env)->GetPrimitiveArrayCritical(env, b, NULL);
  ldb_l = (*env)->GetPrimitiveArrayCritical(env, ldb, NULL);
  ldb_ls = (*env)->GetArrayLength(env, ldb);
  ldb_ll = malloc(sizeof(integer)*ldb_ls);
  for (i_loc=0; i_loc<ldb_ls; ++i_loc) ldb_ll[i_loc] = ldb_l[i_loc];
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dposv_(uplo_ll, n_ll, nrhs_ll, a_ll, lda_ll, b_ll, ldb_ll, info_ll);

  for (i_loc=0; i_loc<uplo_ls; ++i_loc) uplo_l[i_loc] = uplo_ll[i_loc];
  free(uplo_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, uplo, uplo_l, 0);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  for (i_loc=0; i_loc<nrhs_ls; ++i_loc) nrhs_l[i_loc] = nrhs_ll[i_loc];
  free(nrhs_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, nrhs, nrhs_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, a, a_ll, 0);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_l[i_loc] = lda_ll[i_loc];
  free(lda_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, lda, lda_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, b, b_ll, 0);
  for (i_loc=0; i_loc<ldb_ls; ++i_loc) ldb_l[i_loc] = ldb_ll[i_loc];
  free(ldb_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldb, ldb_l, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_posvx
(JNIEnv *env, jclass clazz, jcharArray fact, jcharArray uplo, jintArray n, jintArray nrhs, jdoubleArray a, jintArray lda, jdoubleArray af, jintArray ldaf, jcharArray equed, jdoubleArray s, jdoubleArray b, jintArray ldb, jdoubleArray x, jintArray ldx, jdoubleArray rcond, jdoubleArray ferr, jdoubleArray berr, jdoubleArray work, jintArray iwork, jintArray info) {
  int i_loc;
  jchar* fact_l;
  char* fact_ll;
  jsize fact_ls;
  jchar* uplo_l;
  char* uplo_ll;
  jsize uplo_ls;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jint* nrhs_l;
  integer* nrhs_ll;
  jsize nrhs_ls;
  jdouble* a_ll;
  jint* lda_l;
  integer* lda_ll;
  jsize lda_ls;
  jdouble* af_ll;
  jint* ldaf_l;
  integer* ldaf_ll;
  jsize ldaf_ls;
  jchar* equed_l;
  char* equed_ll;
  jsize equed_ls;
  jdouble* s_ll;
  jdouble* b_ll;
  jint* ldb_l;
  integer* ldb_ll;
  jsize ldb_ls;
  jdouble* x_ll;
  jint* ldx_l;
  integer* ldx_ll;
  jsize ldx_ls;
  jdouble* rcond_ll;
  jdouble* ferr_ll;
  jdouble* berr_ll;
  jdouble* work_ll;
  jint* iwork_l;
  integer* iwork_ll;
  jsize iwork_ls;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  fact_l = (*env)->GetPrimitiveArrayCritical(env, fact, NULL);
  fact_ls = (*env)->GetArrayLength(env, fact);
  fact_ll = malloc(sizeof(char)*fact_ls);
  for (i_loc=0; i_loc<fact_ls; ++i_loc) fact_ll[i_loc] = fact_l[i_loc];
  uplo_l = (*env)->GetPrimitiveArrayCritical(env, uplo, NULL);
  uplo_ls = (*env)->GetArrayLength(env, uplo);
  uplo_ll = malloc(sizeof(char)*uplo_ls);
  for (i_loc=0; i_loc<uplo_ls; ++i_loc) uplo_ll[i_loc] = uplo_l[i_loc];
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  nrhs_l = (*env)->GetPrimitiveArrayCritical(env, nrhs, NULL);
  nrhs_ls = (*env)->GetArrayLength(env, nrhs);
  nrhs_ll = malloc(sizeof(integer)*nrhs_ls);
  for (i_loc=0; i_loc<nrhs_ls; ++i_loc) nrhs_ll[i_loc] = nrhs_l[i_loc];
  a_ll = (*env)->GetPrimitiveArrayCritical(env, a, NULL);
  lda_l = (*env)->GetPrimitiveArrayCritical(env, lda, NULL);
  lda_ls = (*env)->GetArrayLength(env, lda);
  lda_ll = malloc(sizeof(integer)*lda_ls);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_ll[i_loc] = lda_l[i_loc];
  af_ll = (*env)->GetPrimitiveArrayCritical(env, af, NULL);
  ldaf_l = (*env)->GetPrimitiveArrayCritical(env, ldaf, NULL);
  ldaf_ls = (*env)->GetArrayLength(env, ldaf);
  ldaf_ll = malloc(sizeof(integer)*ldaf_ls);
  for (i_loc=0; i_loc<ldaf_ls; ++i_loc) ldaf_ll[i_loc] = ldaf_l[i_loc];
  equed_l = (*env)->GetPrimitiveArrayCritical(env, equed, NULL);
  equed_ls = (*env)->GetArrayLength(env, equed);
  equed_ll = malloc(sizeof(char)*equed_ls);
  for (i_loc=0; i_loc<equed_ls; ++i_loc) equed_ll[i_loc] = equed_l[i_loc];
  s_ll = (*env)->GetPrimitiveArrayCritical(env, s, NULL);
  b_ll = (*env)->GetPrimitiveArrayCritical(env, b, NULL);
  ldb_l = (*env)->GetPrimitiveArrayCritical(env, ldb, NULL);
  ldb_ls = (*env)->GetArrayLength(env, ldb);
  ldb_ll = malloc(sizeof(integer)*ldb_ls);
  for (i_loc=0; i_loc<ldb_ls; ++i_loc) ldb_ll[i_loc] = ldb_l[i_loc];
  x_ll = (*env)->GetPrimitiveArrayCritical(env, x, NULL);
  ldx_l = (*env)->GetPrimitiveArrayCritical(env, ldx, NULL);
  ldx_ls = (*env)->GetArrayLength(env, ldx);
  ldx_ll = malloc(sizeof(integer)*ldx_ls);
  for (i_loc=0; i_loc<ldx_ls; ++i_loc) ldx_ll[i_loc] = ldx_l[i_loc];
  rcond_ll = (*env)->GetPrimitiveArrayCritical(env, rcond, NULL);
  ferr_ll = (*env)->GetPrimitiveArrayCritical(env, ferr, NULL);
  berr_ll = (*env)->GetPrimitiveArrayCritical(env, berr, NULL);
  work_ll = (*env)->GetPrimitiveArrayCritical(env, work, NULL);
  iwork_l = (*env)->GetPrimitiveArrayCritical(env, iwork, NULL);
  iwork_ls = (*env)->GetArrayLength(env, iwork);
  iwork_ll = malloc(sizeof(integer)*iwork_ls);
  for (i_loc=0; i_loc<iwork_ls; ++i_loc) iwork_ll[i_loc] = iwork_l[i_loc];
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dposvx_(fact_ll, uplo_ll, n_ll, nrhs_ll, a_ll, lda_ll, af_ll, ldaf_ll, equed_ll, s_ll, b_ll, ldb_ll, x_ll, ldx_ll, rcond_ll, ferr_ll, berr_ll, work_ll, iwork_ll, info_ll);

  for (i_loc=0; i_loc<fact_ls; ++i_loc) fact_l[i_loc] = fact_ll[i_loc];
  free(fact_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, fact, fact_l, 0);
  for (i_loc=0; i_loc<uplo_ls; ++i_loc) uplo_l[i_loc] = uplo_ll[i_loc];
  free(uplo_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, uplo, uplo_l, 0);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  for (i_loc=0; i_loc<nrhs_ls; ++i_loc) nrhs_l[i_loc] = nrhs_ll[i_loc];
  free(nrhs_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, nrhs, nrhs_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, a, a_ll, 0);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_l[i_loc] = lda_ll[i_loc];
  free(lda_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, lda, lda_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, af, af_ll, 0);
  for (i_loc=0; i_loc<ldaf_ls; ++i_loc) ldaf_l[i_loc] = ldaf_ll[i_loc];
  free(ldaf_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldaf, ldaf_l, 0);
  for (i_loc=0; i_loc<equed_ls; ++i_loc) equed_l[i_loc] = equed_ll[i_loc];
  free(equed_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, equed, equed_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, s, s_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, b, b_ll, 0);
  for (i_loc=0; i_loc<ldb_ls; ++i_loc) ldb_l[i_loc] = ldb_ll[i_loc];
  free(ldb_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldb, ldb_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, x, x_ll, 0);
  for (i_loc=0; i_loc<ldx_ls; ++i_loc) ldx_l[i_loc] = ldx_ll[i_loc];
  free(ldx_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldx, ldx_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, rcond, rcond_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, ferr, ferr_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, berr, berr_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, work, work_ll, 0);
  for (i_loc=0; i_loc<iwork_ls; ++i_loc) iwork_l[i_loc] = iwork_ll[i_loc];
  free(iwork_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, iwork, iwork_l, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_potf2
(JNIEnv *env, jclass clazz, jcharArray uplo, jintArray n, jdoubleArray a, jintArray lda, jintArray info) {
  int i_loc;
  jchar* uplo_l;
  char* uplo_ll;
  jsize uplo_ls;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jdouble* a_ll;
  jint* lda_l;
  integer* lda_ll;
  jsize lda_ls;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  uplo_l = (*env)->GetPrimitiveArrayCritical(env, uplo, NULL);
  uplo_ls = (*env)->GetArrayLength(env, uplo);
  uplo_ll = malloc(sizeof(char)*uplo_ls);
  for (i_loc=0; i_loc<uplo_ls; ++i_loc) uplo_ll[i_loc] = uplo_l[i_loc];
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  a_ll = (*env)->GetPrimitiveArrayCritical(env, a, NULL);
  lda_l = (*env)->GetPrimitiveArrayCritical(env, lda, NULL);
  lda_ls = (*env)->GetArrayLength(env, lda);
  lda_ll = malloc(sizeof(integer)*lda_ls);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_ll[i_loc] = lda_l[i_loc];
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dpotf2_(uplo_ll, n_ll, a_ll, lda_ll, info_ll);

  for (i_loc=0; i_loc<uplo_ls; ++i_loc) uplo_l[i_loc] = uplo_ll[i_loc];
  free(uplo_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, uplo, uplo_l, 0);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, a, a_ll, 0);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_l[i_loc] = lda_ll[i_loc];
  free(lda_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, lda, lda_l, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_potrf
(JNIEnv *env, jclass clazz, jcharArray uplo, jintArray n, jdoubleArray a, jintArray lda, jintArray info) {
  int i_loc;
  jchar* uplo_l;
  char* uplo_ll;
  jsize uplo_ls;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jdouble* a_ll;
  jint* lda_l;
  integer* lda_ll;
  jsize lda_ls;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  uplo_l = (*env)->GetPrimitiveArrayCritical(env, uplo, NULL);
  uplo_ls = (*env)->GetArrayLength(env, uplo);
  uplo_ll = malloc(sizeof(char)*uplo_ls);
  for (i_loc=0; i_loc<uplo_ls; ++i_loc) uplo_ll[i_loc] = uplo_l[i_loc];
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  a_ll = (*env)->GetPrimitiveArrayCritical(env, a, NULL);
  lda_l = (*env)->GetPrimitiveArrayCritical(env, lda, NULL);
  lda_ls = (*env)->GetArrayLength(env, lda);
  lda_ll = malloc(sizeof(integer)*lda_ls);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_ll[i_loc] = lda_l[i_loc];
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dpotrf_(uplo_ll, n_ll, a_ll, lda_ll, info_ll);

  for (i_loc=0; i_loc<uplo_ls; ++i_loc) uplo_l[i_loc] = uplo_ll[i_loc];
  free(uplo_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, uplo, uplo_l, 0);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, a, a_ll, 0);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_l[i_loc] = lda_ll[i_loc];
  free(lda_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, lda, lda_l, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_potri
(JNIEnv *env, jclass clazz, jcharArray uplo, jintArray n, jdoubleArray a, jintArray lda, jintArray info) {
  int i_loc;
  jchar* uplo_l;
  char* uplo_ll;
  jsize uplo_ls;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jdouble* a_ll;
  jint* lda_l;
  integer* lda_ll;
  jsize lda_ls;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  uplo_l = (*env)->GetPrimitiveArrayCritical(env, uplo, NULL);
  uplo_ls = (*env)->GetArrayLength(env, uplo);
  uplo_ll = malloc(sizeof(char)*uplo_ls);
  for (i_loc=0; i_loc<uplo_ls; ++i_loc) uplo_ll[i_loc] = uplo_l[i_loc];
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  a_ll = (*env)->GetPrimitiveArrayCritical(env, a, NULL);
  lda_l = (*env)->GetPrimitiveArrayCritical(env, lda, NULL);
  lda_ls = (*env)->GetArrayLength(env, lda);
  lda_ll = malloc(sizeof(integer)*lda_ls);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_ll[i_loc] = lda_l[i_loc];
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dpotri_(uplo_ll, n_ll, a_ll, lda_ll, info_ll);

  for (i_loc=0; i_loc<uplo_ls; ++i_loc) uplo_l[i_loc] = uplo_ll[i_loc];
  free(uplo_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, uplo, uplo_l, 0);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, a, a_ll, 0);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_l[i_loc] = lda_ll[i_loc];
  free(lda_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, lda, lda_l, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_potrs
(JNIEnv *env, jclass clazz, jcharArray uplo, jintArray n, jintArray nrhs, jdoubleArray a, jintArray lda, jdoubleArray b, jintArray ldb, jintArray info) {
  int i_loc;
  jchar* uplo_l;
  char* uplo_ll;
  jsize uplo_ls;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jint* nrhs_l;
  integer* nrhs_ll;
  jsize nrhs_ls;
  jdouble* a_ll;
  jint* lda_l;
  integer* lda_ll;
  jsize lda_ls;
  jdouble* b_ll;
  jint* ldb_l;
  integer* ldb_ll;
  jsize ldb_ls;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  uplo_l = (*env)->GetPrimitiveArrayCritical(env, uplo, NULL);
  uplo_ls = (*env)->GetArrayLength(env, uplo);
  uplo_ll = malloc(sizeof(char)*uplo_ls);
  for (i_loc=0; i_loc<uplo_ls; ++i_loc) uplo_ll[i_loc] = uplo_l[i_loc];
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  nrhs_l = (*env)->GetPrimitiveArrayCritical(env, nrhs, NULL);
  nrhs_ls = (*env)->GetArrayLength(env, nrhs);
  nrhs_ll = malloc(sizeof(integer)*nrhs_ls);
  for (i_loc=0; i_loc<nrhs_ls; ++i_loc) nrhs_ll[i_loc] = nrhs_l[i_loc];
  a_ll = (*env)->GetPrimitiveArrayCritical(env, a, NULL);
  lda_l = (*env)->GetPrimitiveArrayCritical(env, lda, NULL);
  lda_ls = (*env)->GetArrayLength(env, lda);
  lda_ll = malloc(sizeof(integer)*lda_ls);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_ll[i_loc] = lda_l[i_loc];
  b_ll = (*env)->GetPrimitiveArrayCritical(env, b, NULL);
  ldb_l = (*env)->GetPrimitiveArrayCritical(env, ldb, NULL);
  ldb_ls = (*env)->GetArrayLength(env, ldb);
  ldb_ll = malloc(sizeof(integer)*ldb_ls);
  for (i_loc=0; i_loc<ldb_ls; ++i_loc) ldb_ll[i_loc] = ldb_l[i_loc];
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dpotrs_(uplo_ll, n_ll, nrhs_ll, a_ll, lda_ll, b_ll, ldb_ll, info_ll);

  for (i_loc=0; i_loc<uplo_ls; ++i_loc) uplo_l[i_loc] = uplo_ll[i_loc];
  free(uplo_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, uplo, uplo_l, 0);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  for (i_loc=0; i_loc<nrhs_ls; ++i_loc) nrhs_l[i_loc] = nrhs_ll[i_loc];
  free(nrhs_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, nrhs, nrhs_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, a, a_ll, 0);
  for (i_loc=0; i_loc<lda_ls; ++i_loc) lda_l[i_loc] = lda_ll[i_loc];
  free(lda_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, lda, lda_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, b, b_ll, 0);
  for (i_loc=0; i_loc<ldb_ls; ++i_loc) ldb_l[i_loc] = ldb_ll[i_loc];
  free(ldb_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldb, ldb_l, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_ppcon
(JNIEnv *env, jclass clazz, jcharArray uplo, jintArray n, jdoubleArray ap, jdoubleArray anorm, jdoubleArray rcond, jdoubleArray work, jintArray iwork, jintArray info) {
  int i_loc;
  jchar* uplo_l;
  char* uplo_ll;
  jsize uplo_ls;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jdouble* ap_ll;
  jdouble* anorm_ll;
  jdouble* rcond_ll;
  jdouble* work_ll;
  jint* iwork_l;
  integer* iwork_ll;
  jsize iwork_ls;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  uplo_l = (*env)->GetPrimitiveArrayCritical(env, uplo, NULL);
  uplo_ls = (*env)->GetArrayLength(env, uplo);
  uplo_ll = malloc(sizeof(char)*uplo_ls);
  for (i_loc=0; i_loc<uplo_ls; ++i_loc) uplo_ll[i_loc] = uplo_l[i_loc];
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  ap_ll = (*env)->GetPrimitiveArrayCritical(env, ap, NULL);
  anorm_ll = (*env)->GetPrimitiveArrayCritical(env, anorm, NULL);
  rcond_ll = (*env)->GetPrimitiveArrayCritical(env, rcond, NULL);
  work_ll = (*env)->GetPrimitiveArrayCritical(env, work, NULL);
  iwork_l = (*env)->GetPrimitiveArrayCritical(env, iwork, NULL);
  iwork_ls = (*env)->GetArrayLength(env, iwork);
  iwork_ll = malloc(sizeof(integer)*iwork_ls);
  for (i_loc=0; i_loc<iwork_ls; ++i_loc) iwork_ll[i_loc] = iwork_l[i_loc];
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dppcon_(uplo_ll, n_ll, ap_ll, anorm_ll, rcond_ll, work_ll, iwork_ll, info_ll);

  for (i_loc=0; i_loc<uplo_ls; ++i_loc) uplo_l[i_loc] = uplo_ll[i_loc];
  free(uplo_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, uplo, uplo_l, 0);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, ap, ap_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, anorm, anorm_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, rcond, rcond_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, work, work_ll, 0);
  for (i_loc=0; i_loc<iwork_ls; ++i_loc) iwork_l[i_loc] = iwork_ll[i_loc];
  free(iwork_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, iwork, iwork_l, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_ppequ
(JNIEnv *env, jclass clazz, jcharArray uplo, jintArray n, jdoubleArray ap, jdoubleArray s, jdoubleArray scond, jdoubleArray amax, jintArray info) {
  int i_loc;
  jchar* uplo_l;
  char* uplo_ll;
  jsize uplo_ls;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jdouble* ap_ll;
  jdouble* s_ll;
  jdouble* scond_ll;
  jdouble* amax_ll;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  uplo_l = (*env)->GetPrimitiveArrayCritical(env, uplo, NULL);
  uplo_ls = (*env)->GetArrayLength(env, uplo);
  uplo_ll = malloc(sizeof(char)*uplo_ls);
  for (i_loc=0; i_loc<uplo_ls; ++i_loc) uplo_ll[i_loc] = uplo_l[i_loc];
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  ap_ll = (*env)->GetPrimitiveArrayCritical(env, ap, NULL);
  s_ll = (*env)->GetPrimitiveArrayCritical(env, s, NULL);
  scond_ll = (*env)->GetPrimitiveArrayCritical(env, scond, NULL);
  amax_ll = (*env)->GetPrimitiveArrayCritical(env, amax, NULL);
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dppequ_(uplo_ll, n_ll, ap_ll, s_ll, scond_ll, amax_ll, info_ll);

  for (i_loc=0; i_loc<uplo_ls; ++i_loc) uplo_l[i_loc] = uplo_ll[i_loc];
  free(uplo_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, uplo, uplo_l, 0);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, ap, ap_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, s, s_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, scond, scond_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, amax, amax_ll, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_pprfs
(JNIEnv *env, jclass clazz, jcharArray uplo, jintArray n, jintArray nrhs, jdoubleArray ap, jdoubleArray afp, jdoubleArray b, jintArray ldb, jdoubleArray x, jintArray ldx, jdoubleArray ferr, jdoubleArray berr, jdoubleArray work, jintArray iwork, jintArray info) {
  int i_loc;
  jchar* uplo_l;
  char* uplo_ll;
  jsize uplo_ls;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jint* nrhs_l;
  integer* nrhs_ll;
  jsize nrhs_ls;
  jdouble* ap_ll;
  jdouble* afp_ll;
  jdouble* b_ll;
  jint* ldb_l;
  integer* ldb_ll;
  jsize ldb_ls;
  jdouble* x_ll;
  jint* ldx_l;
  integer* ldx_ll;
  jsize ldx_ls;
  jdouble* ferr_ll;
  jdouble* berr_ll;
  jdouble* work_ll;
  jint* iwork_l;
  integer* iwork_ll;
  jsize iwork_ls;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  uplo_l = (*env)->GetPrimitiveArrayCritical(env, uplo, NULL);
  uplo_ls = (*env)->GetArrayLength(env, uplo);
  uplo_ll = malloc(sizeof(char)*uplo_ls);
  for (i_loc=0; i_loc<uplo_ls; ++i_loc) uplo_ll[i_loc] = uplo_l[i_loc];
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  nrhs_l = (*env)->GetPrimitiveArrayCritical(env, nrhs, NULL);
  nrhs_ls = (*env)->GetArrayLength(env, nrhs);
  nrhs_ll = malloc(sizeof(integer)*nrhs_ls);
  for (i_loc=0; i_loc<nrhs_ls; ++i_loc) nrhs_ll[i_loc] = nrhs_l[i_loc];
  ap_ll = (*env)->GetPrimitiveArrayCritical(env, ap, NULL);
  afp_ll = (*env)->GetPrimitiveArrayCritical(env, afp, NULL);
  b_ll = (*env)->GetPrimitiveArrayCritical(env, b, NULL);
  ldb_l = (*env)->GetPrimitiveArrayCritical(env, ldb, NULL);
  ldb_ls = (*env)->GetArrayLength(env, ldb);
  ldb_ll = malloc(sizeof(integer)*ldb_ls);
  for (i_loc=0; i_loc<ldb_ls; ++i_loc) ldb_ll[i_loc] = ldb_l[i_loc];
  x_ll = (*env)->GetPrimitiveArrayCritical(env, x, NULL);
  ldx_l = (*env)->GetPrimitiveArrayCritical(env, ldx, NULL);
  ldx_ls = (*env)->GetArrayLength(env, ldx);
  ldx_ll = malloc(sizeof(integer)*ldx_ls);
  for (i_loc=0; i_loc<ldx_ls; ++i_loc) ldx_ll[i_loc] = ldx_l[i_loc];
  ferr_ll = (*env)->GetPrimitiveArrayCritical(env, ferr, NULL);
  berr_ll = (*env)->GetPrimitiveArrayCritical(env, berr, NULL);
  work_ll = (*env)->GetPrimitiveArrayCritical(env, work, NULL);
  iwork_l = (*env)->GetPrimitiveArrayCritical(env, iwork, NULL);
  iwork_ls = (*env)->GetArrayLength(env, iwork);
  iwork_ll = malloc(sizeof(integer)*iwork_ls);
  for (i_loc=0; i_loc<iwork_ls; ++i_loc) iwork_ll[i_loc] = iwork_l[i_loc];
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dpprfs_(uplo_ll, n_ll, nrhs_ll, ap_ll, afp_ll, b_ll, ldb_ll, x_ll, ldx_ll, ferr_ll, berr_ll, work_ll, iwork_ll, info_ll);

  for (i_loc=0; i_loc<uplo_ls; ++i_loc) uplo_l[i_loc] = uplo_ll[i_loc];
  free(uplo_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, uplo, uplo_l, 0);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  for (i_loc=0; i_loc<nrhs_ls; ++i_loc) nrhs_l[i_loc] = nrhs_ll[i_loc];
  free(nrhs_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, nrhs, nrhs_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, ap, ap_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, afp, afp_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, b, b_ll, 0);
  for (i_loc=0; i_loc<ldb_ls; ++i_loc) ldb_l[i_loc] = ldb_ll[i_loc];
  free(ldb_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldb, ldb_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, x, x_ll, 0);
  for (i_loc=0; i_loc<ldx_ls; ++i_loc) ldx_l[i_loc] = ldx_ll[i_loc];
  free(ldx_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldx, ldx_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, ferr, ferr_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, berr, berr_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, work, work_ll, 0);
  for (i_loc=0; i_loc<iwork_ls; ++i_loc) iwork_l[i_loc] = iwork_ll[i_loc];
  free(iwork_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, iwork, iwork_l, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_ppsv
(JNIEnv *env, jclass clazz, jcharArray uplo, jintArray n, jintArray nrhs, jdoubleArray ap, jdoubleArray b, jintArray ldb, jintArray info) {
  int i_loc;
  jchar* uplo_l;
  char* uplo_ll;
  jsize uplo_ls;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jint* nrhs_l;
  integer* nrhs_ll;
  jsize nrhs_ls;
  jdouble* ap_ll;
  jdouble* b_ll;
  jint* ldb_l;
  integer* ldb_ll;
  jsize ldb_ls;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  uplo_l = (*env)->GetPrimitiveArrayCritical(env, uplo, NULL);
  uplo_ls = (*env)->GetArrayLength(env, uplo);
  uplo_ll = malloc(sizeof(char)*uplo_ls);
  for (i_loc=0; i_loc<uplo_ls; ++i_loc) uplo_ll[i_loc] = uplo_l[i_loc];
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  nrhs_l = (*env)->GetPrimitiveArrayCritical(env, nrhs, NULL);
  nrhs_ls = (*env)->GetArrayLength(env, nrhs);
  nrhs_ll = malloc(sizeof(integer)*nrhs_ls);
  for (i_loc=0; i_loc<nrhs_ls; ++i_loc) nrhs_ll[i_loc] = nrhs_l[i_loc];
  ap_ll = (*env)->GetPrimitiveArrayCritical(env, ap, NULL);
  b_ll = (*env)->GetPrimitiveArrayCritical(env, b, NULL);
  ldb_l = (*env)->GetPrimitiveArrayCritical(env, ldb, NULL);
  ldb_ls = (*env)->GetArrayLength(env, ldb);
  ldb_ll = malloc(sizeof(integer)*ldb_ls);
  for (i_loc=0; i_loc<ldb_ls; ++i_loc) ldb_ll[i_loc] = ldb_l[i_loc];
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dppsv_(uplo_ll, n_ll, nrhs_ll, ap_ll, b_ll, ldb_ll, info_ll);

  for (i_loc=0; i_loc<uplo_ls; ++i_loc) uplo_l[i_loc] = uplo_ll[i_loc];
  free(uplo_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, uplo, uplo_l, 0);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  for (i_loc=0; i_loc<nrhs_ls; ++i_loc) nrhs_l[i_loc] = nrhs_ll[i_loc];
  free(nrhs_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, nrhs, nrhs_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, ap, ap_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, b, b_ll, 0);
  for (i_loc=0; i_loc<ldb_ls; ++i_loc) ldb_l[i_loc] = ldb_ll[i_loc];
  free(ldb_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldb, ldb_l, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_ppsvx
(JNIEnv *env, jclass clazz, jcharArray fact, jcharArray uplo, jintArray n, jintArray nrhs, jdoubleArray ap, jdoubleArray afp, jcharArray equed, jdoubleArray s, jdoubleArray b, jintArray ldb, jdoubleArray x, jintArray ldx, jdoubleArray rcond, jdoubleArray ferr, jdoubleArray berr, jdoubleArray work, jintArray iwork, jintArray info) {
  int i_loc;
  jchar* fact_l;
  char* fact_ll;
  jsize fact_ls;
  jchar* uplo_l;
  char* uplo_ll;
  jsize uplo_ls;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jint* nrhs_l;
  integer* nrhs_ll;
  jsize nrhs_ls;
  jdouble* ap_ll;
  jdouble* afp_ll;
  jchar* equed_l;
  char* equed_ll;
  jsize equed_ls;
  jdouble* s_ll;
  jdouble* b_ll;
  jint* ldb_l;
  integer* ldb_ll;
  jsize ldb_ls;
  jdouble* x_ll;
  jint* ldx_l;
  integer* ldx_ll;
  jsize ldx_ls;
  jdouble* rcond_ll;
  jdouble* ferr_ll;
  jdouble* berr_ll;
  jdouble* work_ll;
  jint* iwork_l;
  integer* iwork_ll;
  jsize iwork_ls;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  fact_l = (*env)->GetPrimitiveArrayCritical(env, fact, NULL);
  fact_ls = (*env)->GetArrayLength(env, fact);
  fact_ll = malloc(sizeof(char)*fact_ls);
  for (i_loc=0; i_loc<fact_ls; ++i_loc) fact_ll[i_loc] = fact_l[i_loc];
  uplo_l = (*env)->GetPrimitiveArrayCritical(env, uplo, NULL);
  uplo_ls = (*env)->GetArrayLength(env, uplo);
  uplo_ll = malloc(sizeof(char)*uplo_ls);
  for (i_loc=0; i_loc<uplo_ls; ++i_loc) uplo_ll[i_loc] = uplo_l[i_loc];
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  nrhs_l = (*env)->GetPrimitiveArrayCritical(env, nrhs, NULL);
  nrhs_ls = (*env)->GetArrayLength(env, nrhs);
  nrhs_ll = malloc(sizeof(integer)*nrhs_ls);
  for (i_loc=0; i_loc<nrhs_ls; ++i_loc) nrhs_ll[i_loc] = nrhs_l[i_loc];
  ap_ll = (*env)->GetPrimitiveArrayCritical(env, ap, NULL);
  afp_ll = (*env)->GetPrimitiveArrayCritical(env, afp, NULL);
  equed_l = (*env)->GetPrimitiveArrayCritical(env, equed, NULL);
  equed_ls = (*env)->GetArrayLength(env, equed);
  equed_ll = malloc(sizeof(char)*equed_ls);
  for (i_loc=0; i_loc<equed_ls; ++i_loc) equed_ll[i_loc] = equed_l[i_loc];
  s_ll = (*env)->GetPrimitiveArrayCritical(env, s, NULL);
  b_ll = (*env)->GetPrimitiveArrayCritical(env, b, NULL);
  ldb_l = (*env)->GetPrimitiveArrayCritical(env, ldb, NULL);
  ldb_ls = (*env)->GetArrayLength(env, ldb);
  ldb_ll = malloc(sizeof(integer)*ldb_ls);
  for (i_loc=0; i_loc<ldb_ls; ++i_loc) ldb_ll[i_loc] = ldb_l[i_loc];
  x_ll = (*env)->GetPrimitiveArrayCritical(env, x, NULL);
  ldx_l = (*env)->GetPrimitiveArrayCritical(env, ldx, NULL);
  ldx_ls = (*env)->GetArrayLength(env, ldx);
  ldx_ll = malloc(sizeof(integer)*ldx_ls);
  for (i_loc=0; i_loc<ldx_ls; ++i_loc) ldx_ll[i_loc] = ldx_l[i_loc];
  rcond_ll = (*env)->GetPrimitiveArrayCritical(env, rcond, NULL);
  ferr_ll = (*env)->GetPrimitiveArrayCritical(env, ferr, NULL);
  berr_ll = (*env)->GetPrimitiveArrayCritical(env, berr, NULL);
  work_ll = (*env)->GetPrimitiveArrayCritical(env, work, NULL);
  iwork_l = (*env)->GetPrimitiveArrayCritical(env, iwork, NULL);
  iwork_ls = (*env)->GetArrayLength(env, iwork);
  iwork_ll = malloc(sizeof(integer)*iwork_ls);
  for (i_loc=0; i_loc<iwork_ls; ++i_loc) iwork_ll[i_loc] = iwork_l[i_loc];
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dppsvx_(fact_ll, uplo_ll, n_ll, nrhs_ll, ap_ll, afp_ll, equed_ll, s_ll, b_ll, ldb_ll, x_ll, ldx_ll, rcond_ll, ferr_ll, berr_ll, work_ll, iwork_ll, info_ll);

  for (i_loc=0; i_loc<fact_ls; ++i_loc) fact_l[i_loc] = fact_ll[i_loc];
  free(fact_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, fact, fact_l, 0);
  for (i_loc=0; i_loc<uplo_ls; ++i_loc) uplo_l[i_loc] = uplo_ll[i_loc];
  free(uplo_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, uplo, uplo_l, 0);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  for (i_loc=0; i_loc<nrhs_ls; ++i_loc) nrhs_l[i_loc] = nrhs_ll[i_loc];
  free(nrhs_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, nrhs, nrhs_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, ap, ap_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, afp, afp_ll, 0);
  for (i_loc=0; i_loc<equed_ls; ++i_loc) equed_l[i_loc] = equed_ll[i_loc];
  free(equed_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, equed, equed_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, s, s_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, b, b_ll, 0);
  for (i_loc=0; i_loc<ldb_ls; ++i_loc) ldb_l[i_loc] = ldb_ll[i_loc];
  free(ldb_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldb, ldb_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, x, x_ll, 0);
  for (i_loc=0; i_loc<ldx_ls; ++i_loc) ldx_l[i_loc] = ldx_ll[i_loc];
  free(ldx_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldx, ldx_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, rcond, rcond_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, ferr, ferr_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, berr, berr_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, work, work_ll, 0);
  for (i_loc=0; i_loc<iwork_ls; ++i_loc) iwork_l[i_loc] = iwork_ll[i_loc];
  free(iwork_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, iwork, iwork_l, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_pptrf
(JNIEnv *env, jclass clazz, jcharArray uplo, jintArray n, jdoubleArray ap, jintArray info) {
  int i_loc;
  jchar* uplo_l;
  char* uplo_ll;
  jsize uplo_ls;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jdouble* ap_ll;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  uplo_l = (*env)->GetPrimitiveArrayCritical(env, uplo, NULL);
  uplo_ls = (*env)->GetArrayLength(env, uplo);
  uplo_ll = malloc(sizeof(char)*uplo_ls);
  for (i_loc=0; i_loc<uplo_ls; ++i_loc) uplo_ll[i_loc] = uplo_l[i_loc];
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  ap_ll = (*env)->GetPrimitiveArrayCritical(env, ap, NULL);
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dpptrf_(uplo_ll, n_ll, ap_ll, info_ll);

  for (i_loc=0; i_loc<uplo_ls; ++i_loc) uplo_l[i_loc] = uplo_ll[i_loc];
  free(uplo_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, uplo, uplo_l, 0);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, ap, ap_ll, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_pptri
(JNIEnv *env, jclass clazz, jcharArray uplo, jintArray n, jdoubleArray ap, jintArray info) {
  int i_loc;
  jchar* uplo_l;
  char* uplo_ll;
  jsize uplo_ls;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jdouble* ap_ll;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  uplo_l = (*env)->GetPrimitiveArrayCritical(env, uplo, NULL);
  uplo_ls = (*env)->GetArrayLength(env, uplo);
  uplo_ll = malloc(sizeof(char)*uplo_ls);
  for (i_loc=0; i_loc<uplo_ls; ++i_loc) uplo_ll[i_loc] = uplo_l[i_loc];
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  ap_ll = (*env)->GetPrimitiveArrayCritical(env, ap, NULL);
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dpptri_(uplo_ll, n_ll, ap_ll, info_ll);

  for (i_loc=0; i_loc<uplo_ls; ++i_loc) uplo_l[i_loc] = uplo_ll[i_loc];
  free(uplo_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, uplo, uplo_l, 0);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, ap, ap_ll, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_pptrs
(JNIEnv *env, jclass clazz, jcharArray uplo, jintArray n, jintArray nrhs, jdoubleArray ap, jdoubleArray b, jintArray ldb, jintArray info) {
  int i_loc;
  jchar* uplo_l;
  char* uplo_ll;
  jsize uplo_ls;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jint* nrhs_l;
  integer* nrhs_ll;
  jsize nrhs_ls;
  jdouble* ap_ll;
  jdouble* b_ll;
  jint* ldb_l;
  integer* ldb_ll;
  jsize ldb_ls;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  uplo_l = (*env)->GetPrimitiveArrayCritical(env, uplo, NULL);
  uplo_ls = (*env)->GetArrayLength(env, uplo);
  uplo_ll = malloc(sizeof(char)*uplo_ls);
  for (i_loc=0; i_loc<uplo_ls; ++i_loc) uplo_ll[i_loc] = uplo_l[i_loc];
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  nrhs_l = (*env)->GetPrimitiveArrayCritical(env, nrhs, NULL);
  nrhs_ls = (*env)->GetArrayLength(env, nrhs);
  nrhs_ll = malloc(sizeof(integer)*nrhs_ls);
  for (i_loc=0; i_loc<nrhs_ls; ++i_loc) nrhs_ll[i_loc] = nrhs_l[i_loc];
  ap_ll = (*env)->GetPrimitiveArrayCritical(env, ap, NULL);
  b_ll = (*env)->GetPrimitiveArrayCritical(env, b, NULL);
  ldb_l = (*env)->GetPrimitiveArrayCritical(env, ldb, NULL);
  ldb_ls = (*env)->GetArrayLength(env, ldb);
  ldb_ll = malloc(sizeof(integer)*ldb_ls);
  for (i_loc=0; i_loc<ldb_ls; ++i_loc) ldb_ll[i_loc] = ldb_l[i_loc];
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dpptrs_(uplo_ll, n_ll, nrhs_ll, ap_ll, b_ll, ldb_ll, info_ll);

  for (i_loc=0; i_loc<uplo_ls; ++i_loc) uplo_l[i_loc] = uplo_ll[i_loc];
  free(uplo_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, uplo, uplo_l, 0);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  for (i_loc=0; i_loc<nrhs_ls; ++i_loc) nrhs_l[i_loc] = nrhs_ll[i_loc];
  free(nrhs_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, nrhs, nrhs_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, ap, ap_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, b, b_ll, 0);
  for (i_loc=0; i_loc<ldb_ls; ++i_loc) ldb_l[i_loc] = ldb_ll[i_loc];
  free(ldb_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldb, ldb_l, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_ptcon
(JNIEnv *env, jclass clazz, jintArray n, jdoubleArray d, jdoubleArray e, jdoubleArray anorm, jdoubleArray rcond, jdoubleArray work, jintArray info) {
  int i_loc;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jdouble* d_ll;
  jdouble* e_ll;
  jdouble* anorm_ll;
  jdouble* rcond_ll;
  jdouble* work_ll;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  d_ll = (*env)->GetPrimitiveArrayCritical(env, d, NULL);
  e_ll = (*env)->GetPrimitiveArrayCritical(env, e, NULL);
  anorm_ll = (*env)->GetPrimitiveArrayCritical(env, anorm, NULL);
  rcond_ll = (*env)->GetPrimitiveArrayCritical(env, rcond, NULL);
  work_ll = (*env)->GetPrimitiveArrayCritical(env, work, NULL);
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dptcon_(n_ll, d_ll, e_ll, anorm_ll, rcond_ll, work_ll, info_ll);

  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, d, d_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, e, e_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, anorm, anorm_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, rcond, rcond_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, work, work_ll, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_pteqr
(JNIEnv *env, jclass clazz, jcharArray compz, jintArray n, jdoubleArray d, jdoubleArray e, jdoubleArray z, jintArray ldz, jdoubleArray work, jintArray info) {
  int i_loc;
  jchar* compz_l;
  char* compz_ll;
  jsize compz_ls;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jdouble* d_ll;
  jdouble* e_ll;
  jdouble* z_ll;
  jint* ldz_l;
  integer* ldz_ll;
  jsize ldz_ls;
  jdouble* work_ll;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  compz_l = (*env)->GetPrimitiveArrayCritical(env, compz, NULL);
  compz_ls = (*env)->GetArrayLength(env, compz);
  compz_ll = malloc(sizeof(char)*compz_ls);
  for (i_loc=0; i_loc<compz_ls; ++i_loc) compz_ll[i_loc] = compz_l[i_loc];
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  d_ll = (*env)->GetPrimitiveArrayCritical(env, d, NULL);
  e_ll = (*env)->GetPrimitiveArrayCritical(env, e, NULL);
  z_ll = (*env)->GetPrimitiveArrayCritical(env, z, NULL);
  ldz_l = (*env)->GetPrimitiveArrayCritical(env, ldz, NULL);
  ldz_ls = (*env)->GetArrayLength(env, ldz);
  ldz_ll = malloc(sizeof(integer)*ldz_ls);
  for (i_loc=0; i_loc<ldz_ls; ++i_loc) ldz_ll[i_loc] = ldz_l[i_loc];
  work_ll = (*env)->GetPrimitiveArrayCritical(env, work, NULL);
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dpteqr_(compz_ll, n_ll, d_ll, e_ll, z_ll, ldz_ll, work_ll, info_ll);

  for (i_loc=0; i_loc<compz_ls; ++i_loc) compz_l[i_loc] = compz_ll[i_loc];
  free(compz_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, compz, compz_l, 0);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, d, d_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, e, e_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, z, z_ll, 0);
  for (i_loc=0; i_loc<ldz_ls; ++i_loc) ldz_l[i_loc] = ldz_ll[i_loc];
  free(ldz_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldz, ldz_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, work, work_ll, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_ptrfs
(JNIEnv *env, jclass clazz, jintArray n, jintArray nrhs, jdoubleArray d, jdoubleArray e, jdoubleArray df, jdoubleArray ef, jdoubleArray b, jintArray ldb, jdoubleArray x, jintArray ldx, jdoubleArray ferr, jdoubleArray berr, jdoubleArray work, jintArray info) {
  int i_loc;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jint* nrhs_l;
  integer* nrhs_ll;
  jsize nrhs_ls;
  jdouble* d_ll;
  jdouble* e_ll;
  jdouble* df_ll;
  jdouble* ef_ll;
  jdouble* b_ll;
  jint* ldb_l;
  integer* ldb_ll;
  jsize ldb_ls;
  jdouble* x_ll;
  jint* ldx_l;
  integer* ldx_ll;
  jsize ldx_ls;
  jdouble* ferr_ll;
  jdouble* berr_ll;
  jdouble* work_ll;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  nrhs_l = (*env)->GetPrimitiveArrayCritical(env, nrhs, NULL);
  nrhs_ls = (*env)->GetArrayLength(env, nrhs);
  nrhs_ll = malloc(sizeof(integer)*nrhs_ls);
  for (i_loc=0; i_loc<nrhs_ls; ++i_loc) nrhs_ll[i_loc] = nrhs_l[i_loc];
  d_ll = (*env)->GetPrimitiveArrayCritical(env, d, NULL);
  e_ll = (*env)->GetPrimitiveArrayCritical(env, e, NULL);
  df_ll = (*env)->GetPrimitiveArrayCritical(env, df, NULL);
  ef_ll = (*env)->GetPrimitiveArrayCritical(env, ef, NULL);
  b_ll = (*env)->GetPrimitiveArrayCritical(env, b, NULL);
  ldb_l = (*env)->GetPrimitiveArrayCritical(env, ldb, NULL);
  ldb_ls = (*env)->GetArrayLength(env, ldb);
  ldb_ll = malloc(sizeof(integer)*ldb_ls);
  for (i_loc=0; i_loc<ldb_ls; ++i_loc) ldb_ll[i_loc] = ldb_l[i_loc];
  x_ll = (*env)->GetPrimitiveArrayCritical(env, x, NULL);
  ldx_l = (*env)->GetPrimitiveArrayCritical(env, ldx, NULL);
  ldx_ls = (*env)->GetArrayLength(env, ldx);
  ldx_ll = malloc(sizeof(integer)*ldx_ls);
  for (i_loc=0; i_loc<ldx_ls; ++i_loc) ldx_ll[i_loc] = ldx_l[i_loc];
  ferr_ll = (*env)->GetPrimitiveArrayCritical(env, ferr, NULL);
  berr_ll = (*env)->GetPrimitiveArrayCritical(env, berr, NULL);
  work_ll = (*env)->GetPrimitiveArrayCritical(env, work, NULL);
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dptrfs_(n_ll, nrhs_ll, d_ll, e_ll, df_ll, ef_ll, b_ll, ldb_ll, x_ll, ldx_ll, ferr_ll, berr_ll, work_ll, info_ll);

  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  for (i_loc=0; i_loc<nrhs_ls; ++i_loc) nrhs_l[i_loc] = nrhs_ll[i_loc];
  free(nrhs_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, nrhs, nrhs_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, d, d_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, e, e_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, df, df_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, ef, ef_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, b, b_ll, 0);
  for (i_loc=0; i_loc<ldb_ls; ++i_loc) ldb_l[i_loc] = ldb_ll[i_loc];
  free(ldb_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldb, ldb_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, x, x_ll, 0);
  for (i_loc=0; i_loc<ldx_ls; ++i_loc) ldx_l[i_loc] = ldx_ll[i_loc];
  free(ldx_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldx, ldx_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, ferr, ferr_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, berr, berr_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, work, work_ll, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_ptsv
(JNIEnv *env, jclass clazz, jintArray n, jintArray nrhs, jdoubleArray d, jdoubleArray e, jdoubleArray b, jintArray ldb, jintArray info) {
  int i_loc;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jint* nrhs_l;
  integer* nrhs_ll;
  jsize nrhs_ls;
  jdouble* d_ll;
  jdouble* e_ll;
  jdouble* b_ll;
  jint* ldb_l;
  integer* ldb_ll;
  jsize ldb_ls;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  nrhs_l = (*env)->GetPrimitiveArrayCritical(env, nrhs, NULL);
  nrhs_ls = (*env)->GetArrayLength(env, nrhs);
  nrhs_ll = malloc(sizeof(integer)*nrhs_ls);
  for (i_loc=0; i_loc<nrhs_ls; ++i_loc) nrhs_ll[i_loc] = nrhs_l[i_loc];
  d_ll = (*env)->GetPrimitiveArrayCritical(env, d, NULL);
  e_ll = (*env)->GetPrimitiveArrayCritical(env, e, NULL);
  b_ll = (*env)->GetPrimitiveArrayCritical(env, b, NULL);
  ldb_l = (*env)->GetPrimitiveArrayCritical(env, ldb, NULL);
  ldb_ls = (*env)->GetArrayLength(env, ldb);
  ldb_ll = malloc(sizeof(integer)*ldb_ls);
  for (i_loc=0; i_loc<ldb_ls; ++i_loc) ldb_ll[i_loc] = ldb_l[i_loc];
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dptsv_(n_ll, nrhs_ll, d_ll, e_ll, b_ll, ldb_ll, info_ll);

  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  for (i_loc=0; i_loc<nrhs_ls; ++i_loc) nrhs_l[i_loc] = nrhs_ll[i_loc];
  free(nrhs_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, nrhs, nrhs_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, d, d_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, e, e_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, b, b_ll, 0);
  for (i_loc=0; i_loc<ldb_ls; ++i_loc) ldb_l[i_loc] = ldb_ll[i_loc];
  free(ldb_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldb, ldb_l, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_ptsvx
(JNIEnv *env, jclass clazz, jcharArray fact, jintArray n, jintArray nrhs, jdoubleArray d, jdoubleArray e, jdoubleArray df, jdoubleArray ef, jdoubleArray b, jintArray ldb, jdoubleArray x, jintArray ldx, jdoubleArray rcond, jdoubleArray ferr, jdoubleArray berr, jdoubleArray work, jintArray info) {
  int i_loc;
  jchar* fact_l;
  char* fact_ll;
  jsize fact_ls;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jint* nrhs_l;
  integer* nrhs_ll;
  jsize nrhs_ls;
  jdouble* d_ll;
  jdouble* e_ll;
  jdouble* df_ll;
  jdouble* ef_ll;
  jdouble* b_ll;
  jint* ldb_l;
  integer* ldb_ll;
  jsize ldb_ls;
  jdouble* x_ll;
  jint* ldx_l;
  integer* ldx_ll;
  jsize ldx_ls;
  jdouble* rcond_ll;
  jdouble* ferr_ll;
  jdouble* berr_ll;
  jdouble* work_ll;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  fact_l = (*env)->GetPrimitiveArrayCritical(env, fact, NULL);
  fact_ls = (*env)->GetArrayLength(env, fact);
  fact_ll = malloc(sizeof(char)*fact_ls);
  for (i_loc=0; i_loc<fact_ls; ++i_loc) fact_ll[i_loc] = fact_l[i_loc];
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  nrhs_l = (*env)->GetPrimitiveArrayCritical(env, nrhs, NULL);
  nrhs_ls = (*env)->GetArrayLength(env, nrhs);
  nrhs_ll = malloc(sizeof(integer)*nrhs_ls);
  for (i_loc=0; i_loc<nrhs_ls; ++i_loc) nrhs_ll[i_loc] = nrhs_l[i_loc];
  d_ll = (*env)->GetPrimitiveArrayCritical(env, d, NULL);
  e_ll = (*env)->GetPrimitiveArrayCritical(env, e, NULL);
  df_ll = (*env)->GetPrimitiveArrayCritical(env, df, NULL);
  ef_ll = (*env)->GetPrimitiveArrayCritical(env, ef, NULL);
  b_ll = (*env)->GetPrimitiveArrayCritical(env, b, NULL);
  ldb_l = (*env)->GetPrimitiveArrayCritical(env, ldb, NULL);
  ldb_ls = (*env)->GetArrayLength(env, ldb);
  ldb_ll = malloc(sizeof(integer)*ldb_ls);
  for (i_loc=0; i_loc<ldb_ls; ++i_loc) ldb_ll[i_loc] = ldb_l[i_loc];
  x_ll = (*env)->GetPrimitiveArrayCritical(env, x, NULL);
  ldx_l = (*env)->GetPrimitiveArrayCritical(env, ldx, NULL);
  ldx_ls = (*env)->GetArrayLength(env, ldx);
  ldx_ll = malloc(sizeof(integer)*ldx_ls);
  for (i_loc=0; i_loc<ldx_ls; ++i_loc) ldx_ll[i_loc] = ldx_l[i_loc];
  rcond_ll = (*env)->GetPrimitiveArrayCritical(env, rcond, NULL);
  ferr_ll = (*env)->GetPrimitiveArrayCritical(env, ferr, NULL);
  berr_ll = (*env)->GetPrimitiveArrayCritical(env, berr, NULL);
  work_ll = (*env)->GetPrimitiveArrayCritical(env, work, NULL);
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dptsvx_(fact_ll, n_ll, nrhs_ll, d_ll, e_ll, df_ll, ef_ll, b_ll, ldb_ll, x_ll, ldx_ll, rcond_ll, ferr_ll, berr_ll, work_ll, info_ll);

  for (i_loc=0; i_loc<fact_ls; ++i_loc) fact_l[i_loc] = fact_ll[i_loc];
  free(fact_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, fact, fact_l, 0);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  for (i_loc=0; i_loc<nrhs_ls; ++i_loc) nrhs_l[i_loc] = nrhs_ll[i_loc];
  free(nrhs_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, nrhs, nrhs_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, d, d_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, e, e_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, df, df_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, ef, ef_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, b, b_ll, 0);
  for (i_loc=0; i_loc<ldb_ls; ++i_loc) ldb_l[i_loc] = ldb_ll[i_loc];
  free(ldb_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldb, ldb_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, x, x_ll, 0);
  for (i_loc=0; i_loc<ldx_ls; ++i_loc) ldx_l[i_loc] = ldx_ll[i_loc];
  free(ldx_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldx, ldx_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, rcond, rcond_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, ferr, ferr_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, berr, berr_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, work, work_ll, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_pttrf
(JNIEnv *env, jclass clazz, jintArray n, jdoubleArray d, jdoubleArray e, jintArray info) {
  int i_loc;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jdouble* d_ll;
  jdouble* e_ll;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  d_ll = (*env)->GetPrimitiveArrayCritical(env, d, NULL);
  e_ll = (*env)->GetPrimitiveArrayCritical(env, e, NULL);
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dpttrf_(n_ll, d_ll, e_ll, info_ll);

  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, d, d_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, e, e_ll, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_pttrs
(JNIEnv *env, jclass clazz, jintArray n, jintArray nrhs, jdoubleArray d, jdoubleArray e, jdoubleArray b, jintArray ldb, jintArray info) {
  int i_loc;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jint* nrhs_l;
  integer* nrhs_ll;
  jsize nrhs_ls;
  jdouble* d_ll;
  jdouble* e_ll;
  jdouble* b_ll;
  jint* ldb_l;
  integer* ldb_ll;
  jsize ldb_ls;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  nrhs_l = (*env)->GetPrimitiveArrayCritical(env, nrhs, NULL);
  nrhs_ls = (*env)->GetArrayLength(env, nrhs);
  nrhs_ll = malloc(sizeof(integer)*nrhs_ls);
  for (i_loc=0; i_loc<nrhs_ls; ++i_loc) nrhs_ll[i_loc] = nrhs_l[i_loc];
  d_ll = (*env)->GetPrimitiveArrayCritical(env, d, NULL);
  e_ll = (*env)->GetPrimitiveArrayCritical(env, e, NULL);
  b_ll = (*env)->GetPrimitiveArrayCritical(env, b, NULL);
  ldb_l = (*env)->GetPrimitiveArrayCritical(env, ldb, NULL);
  ldb_ls = (*env)->GetArrayLength(env, ldb);
  ldb_ll = malloc(sizeof(integer)*ldb_ls);
  for (i_loc=0; i_loc<ldb_ls; ++i_loc) ldb_ll[i_loc] = ldb_l[i_loc];
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dpttrs_(n_ll, nrhs_ll, d_ll, e_ll, b_ll, ldb_ll, info_ll);

  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  for (i_loc=0; i_loc<nrhs_ls; ++i_loc) nrhs_l[i_loc] = nrhs_ll[i_loc];
  free(nrhs_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, nrhs, nrhs_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, d, d_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, e, e_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, b, b_ll, 0);
  for (i_loc=0; i_loc<ldb_ls; ++i_loc) ldb_l[i_loc] = ldb_ll[i_loc];
  free(ldb_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldb, ldb_l, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_ptts2
(JNIEnv *env, jclass clazz, jintArray n, jintArray nrhs, jdoubleArray d, jdoubleArray e, jdoubleArray b, jintArray ldb) {
  int i_loc;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jint* nrhs_l;
  integer* nrhs_ll;
  jsize nrhs_ls;
  jdouble* d_ll;
  jdouble* e_ll;
  jdouble* b_ll;
  jint* ldb_l;
  integer* ldb_ll;
  jsize ldb_ls;
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  nrhs_l = (*env)->GetPrimitiveArrayCritical(env, nrhs, NULL);
  nrhs_ls = (*env)->GetArrayLength(env, nrhs);
  nrhs_ll = malloc(sizeof(integer)*nrhs_ls);
  for (i_loc=0; i_loc<nrhs_ls; ++i_loc) nrhs_ll[i_loc] = nrhs_l[i_loc];
  d_ll = (*env)->GetPrimitiveArrayCritical(env, d, NULL);
  e_ll = (*env)->GetPrimitiveArrayCritical(env, e, NULL);
  b_ll = (*env)->GetPrimitiveArrayCritical(env, b, NULL);
  ldb_l = (*env)->GetPrimitiveArrayCritical(env, ldb, NULL);
  ldb_ls = (*env)->GetArrayLength(env, ldb);
  ldb_ll = malloc(sizeof(integer)*ldb_ls);
  for (i_loc=0; i_loc<ldb_ls; ++i_loc) ldb_ll[i_loc] = ldb_l[i_loc];

  dptts2_(n_ll, nrhs_ll, d_ll, e_ll, b_ll, ldb_ll);

  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  for (i_loc=0; i_loc<nrhs_ls; ++i_loc) nrhs_l[i_loc] = nrhs_ll[i_loc];
  free(nrhs_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, nrhs, nrhs_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, d, d_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, e, e_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, b, b_ll, 0);
  for (i_loc=0; i_loc<ldb_ls; ++i_loc) ldb_l[i_loc] = ldb_ll[i_loc];
  free(ldb_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldb, ldb_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_rscl
(JNIEnv *env, jclass clazz, jintArray n, jdoubleArray sa, jdoubleArray sx, jintArray incx) {
  int i_loc;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jdouble* sa_ll;
  jdouble* sx_ll;
  jint* incx_l;
  integer* incx_ll;
  jsize incx_ls;
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  sa_ll = (*env)->GetPrimitiveArrayCritical(env, sa, NULL);
  sx_ll = (*env)->GetPrimitiveArrayCritical(env, sx, NULL);
  incx_l = (*env)->GetPrimitiveArrayCritical(env, incx, NULL);
  incx_ls = (*env)->GetArrayLength(env, incx);
  incx_ll = malloc(sizeof(integer)*incx_ls);
  for (i_loc=0; i_loc<incx_ls; ++i_loc) incx_ll[i_loc] = incx_l[i_loc];

  drscl_(n_ll, sa_ll, sx_ll, incx_ll);

  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, sa, sa_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, sx, sx_ll, 0);
  for (i_loc=0; i_loc<incx_ls; ++i_loc) incx_l[i_loc] = incx_ll[i_loc];
  free(incx_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, incx, incx_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_sbev
(JNIEnv *env, jclass clazz, jcharArray jobz, jcharArray uplo, jintArray n, jintArray kd, jdoubleArray ab, jintArray ldab, jdoubleArray w, jdoubleArray z, jintArray ldz, jdoubleArray work, jintArray info) {
  int i_loc;
  jchar* jobz_l;
  char* jobz_ll;
  jsize jobz_ls;
  jchar* uplo_l;
  char* uplo_ll;
  jsize uplo_ls;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jint* kd_l;
  integer* kd_ll;
  jsize kd_ls;
  jdouble* ab_ll;
  jint* ldab_l;
  integer* ldab_ll;
  jsize ldab_ls;
  jdouble* w_ll;
  jdouble* z_ll;
  jint* ldz_l;
  integer* ldz_ll;
  jsize ldz_ls;
  jdouble* work_ll;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  jobz_l = (*env)->GetPrimitiveArrayCritical(env, jobz, NULL);
  jobz_ls = (*env)->GetArrayLength(env, jobz);
  jobz_ll = malloc(sizeof(char)*jobz_ls);
  for (i_loc=0; i_loc<jobz_ls; ++i_loc) jobz_ll[i_loc] = jobz_l[i_loc];
  uplo_l = (*env)->GetPrimitiveArrayCritical(env, uplo, NULL);
  uplo_ls = (*env)->GetArrayLength(env, uplo);
  uplo_ll = malloc(sizeof(char)*uplo_ls);
  for (i_loc=0; i_loc<uplo_ls; ++i_loc) uplo_ll[i_loc] = uplo_l[i_loc];
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  kd_l = (*env)->GetPrimitiveArrayCritical(env, kd, NULL);
  kd_ls = (*env)->GetArrayLength(env, kd);
  kd_ll = malloc(sizeof(integer)*kd_ls);
  for (i_loc=0; i_loc<kd_ls; ++i_loc) kd_ll[i_loc] = kd_l[i_loc];
  ab_ll = (*env)->GetPrimitiveArrayCritical(env, ab, NULL);
  ldab_l = (*env)->GetPrimitiveArrayCritical(env, ldab, NULL);
  ldab_ls = (*env)->GetArrayLength(env, ldab);
  ldab_ll = malloc(sizeof(integer)*ldab_ls);
  for (i_loc=0; i_loc<ldab_ls; ++i_loc) ldab_ll[i_loc] = ldab_l[i_loc];
  w_ll = (*env)->GetPrimitiveArrayCritical(env, w, NULL);
  z_ll = (*env)->GetPrimitiveArrayCritical(env, z, NULL);
  ldz_l = (*env)->GetPrimitiveArrayCritical(env, ldz, NULL);
  ldz_ls = (*env)->GetArrayLength(env, ldz);
  ldz_ll = malloc(sizeof(integer)*ldz_ls);
  for (i_loc=0; i_loc<ldz_ls; ++i_loc) ldz_ll[i_loc] = ldz_l[i_loc];
  work_ll = (*env)->GetPrimitiveArrayCritical(env, work, NULL);
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dsbev_(jobz_ll, uplo_ll, n_ll, kd_ll, ab_ll, ldab_ll, w_ll, z_ll, ldz_ll, work_ll, info_ll);

  for (i_loc=0; i_loc<jobz_ls; ++i_loc) jobz_l[i_loc] = jobz_ll[i_loc];
  free(jobz_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, jobz, jobz_l, 0);
  for (i_loc=0; i_loc<uplo_ls; ++i_loc) uplo_l[i_loc] = uplo_ll[i_loc];
  free(uplo_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, uplo, uplo_l, 0);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  for (i_loc=0; i_loc<kd_ls; ++i_loc) kd_l[i_loc] = kd_ll[i_loc];
  free(kd_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, kd, kd_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, ab, ab_ll, 0);
  for (i_loc=0; i_loc<ldab_ls; ++i_loc) ldab_l[i_loc] = ldab_ll[i_loc];
  free(ldab_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldab, ldab_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, w, w_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, z, z_ll, 0);
  for (i_loc=0; i_loc<ldz_ls; ++i_loc) ldz_l[i_loc] = ldz_ll[i_loc];
  free(ldz_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldz, ldz_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, work, work_ll, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_sbevd
(JNIEnv *env, jclass clazz, jcharArray jobz, jcharArray uplo, jintArray n, jintArray kd, jdoubleArray ab, jintArray ldab, jdoubleArray w, jdoubleArray z, jintArray ldz, jdoubleArray work, jintArray lwork, jintArray iwork, jintArray liwork, jintArray info) {
  int i_loc;
  jchar* jobz_l;
  char* jobz_ll;
  jsize jobz_ls;
  jchar* uplo_l;
  char* uplo_ll;
  jsize uplo_ls;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jint* kd_l;
  integer* kd_ll;
  jsize kd_ls;
  jdouble* ab_ll;
  jint* ldab_l;
  integer* ldab_ll;
  jsize ldab_ls;
  jdouble* w_ll;
  jdouble* z_ll;
  jint* ldz_l;
  integer* ldz_ll;
  jsize ldz_ls;
  jdouble* work_ll;
  jint* lwork_l;
  integer* lwork_ll;
  jsize lwork_ls;
  jint* iwork_l;
  integer* iwork_ll;
  jsize iwork_ls;
  jint* liwork_l;
  integer* liwork_ll;
  jsize liwork_ls;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  jobz_l = (*env)->GetPrimitiveArrayCritical(env, jobz, NULL);
  jobz_ls = (*env)->GetArrayLength(env, jobz);
  jobz_ll = malloc(sizeof(char)*jobz_ls);
  for (i_loc=0; i_loc<jobz_ls; ++i_loc) jobz_ll[i_loc] = jobz_l[i_loc];
  uplo_l = (*env)->GetPrimitiveArrayCritical(env, uplo, NULL);
  uplo_ls = (*env)->GetArrayLength(env, uplo);
  uplo_ll = malloc(sizeof(char)*uplo_ls);
  for (i_loc=0; i_loc<uplo_ls; ++i_loc) uplo_ll[i_loc] = uplo_l[i_loc];
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  kd_l = (*env)->GetPrimitiveArrayCritical(env, kd, NULL);
  kd_ls = (*env)->GetArrayLength(env, kd);
  kd_ll = malloc(sizeof(integer)*kd_ls);
  for (i_loc=0; i_loc<kd_ls; ++i_loc) kd_ll[i_loc] = kd_l[i_loc];
  ab_ll = (*env)->GetPrimitiveArrayCritical(env, ab, NULL);
  ldab_l = (*env)->GetPrimitiveArrayCritical(env, ldab, NULL);
  ldab_ls = (*env)->GetArrayLength(env, ldab);
  ldab_ll = malloc(sizeof(integer)*ldab_ls);
  for (i_loc=0; i_loc<ldab_ls; ++i_loc) ldab_ll[i_loc] = ldab_l[i_loc];
  w_ll = (*env)->GetPrimitiveArrayCritical(env, w, NULL);
  z_ll = (*env)->GetPrimitiveArrayCritical(env, z, NULL);
  ldz_l = (*env)->GetPrimitiveArrayCritical(env, ldz, NULL);
  ldz_ls = (*env)->GetArrayLength(env, ldz);
  ldz_ll = malloc(sizeof(integer)*ldz_ls);
  for (i_loc=0; i_loc<ldz_ls; ++i_loc) ldz_ll[i_loc] = ldz_l[i_loc];
  work_ll = (*env)->GetPrimitiveArrayCritical(env, work, NULL);
  lwork_l = (*env)->GetPrimitiveArrayCritical(env, lwork, NULL);
  lwork_ls = (*env)->GetArrayLength(env, lwork);
  lwork_ll = malloc(sizeof(integer)*lwork_ls);
  for (i_loc=0; i_loc<lwork_ls; ++i_loc) lwork_ll[i_loc] = lwork_l[i_loc];
  iwork_l = (*env)->GetPrimitiveArrayCritical(env, iwork, NULL);
  iwork_ls = (*env)->GetArrayLength(env, iwork);
  iwork_ll = malloc(sizeof(integer)*iwork_ls);
  for (i_loc=0; i_loc<iwork_ls; ++i_loc) iwork_ll[i_loc] = iwork_l[i_loc];
  liwork_l = (*env)->GetPrimitiveArrayCritical(env, liwork, NULL);
  liwork_ls = (*env)->GetArrayLength(env, liwork);
  liwork_ll = malloc(sizeof(integer)*liwork_ls);
  for (i_loc=0; i_loc<liwork_ls; ++i_loc) liwork_ll[i_loc] = liwork_l[i_loc];
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dsbevd_(jobz_ll, uplo_ll, n_ll, kd_ll, ab_ll, ldab_ll, w_ll, z_ll, ldz_ll, work_ll, lwork_ll, iwork_ll, liwork_ll, info_ll);

  for (i_loc=0; i_loc<jobz_ls; ++i_loc) jobz_l[i_loc] = jobz_ll[i_loc];
  free(jobz_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, jobz, jobz_l, 0);
  for (i_loc=0; i_loc<uplo_ls; ++i_loc) uplo_l[i_loc] = uplo_ll[i_loc];
  free(uplo_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, uplo, uplo_l, 0);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  for (i_loc=0; i_loc<kd_ls; ++i_loc) kd_l[i_loc] = kd_ll[i_loc];
  free(kd_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, kd, kd_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, ab, ab_ll, 0);
  for (i_loc=0; i_loc<ldab_ls; ++i_loc) ldab_l[i_loc] = ldab_ll[i_loc];
  free(ldab_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldab, ldab_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, w, w_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, z, z_ll, 0);
  for (i_loc=0; i_loc<ldz_ls; ++i_loc) ldz_l[i_loc] = ldz_ll[i_loc];
  free(ldz_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldz, ldz_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, work, work_ll, 0);
  for (i_loc=0; i_loc<lwork_ls; ++i_loc) lwork_l[i_loc] = lwork_ll[i_loc];
  free(lwork_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, lwork, lwork_l, 0);
  for (i_loc=0; i_loc<iwork_ls; ++i_loc) iwork_l[i_loc] = iwork_ll[i_loc];
  free(iwork_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, iwork, iwork_l, 0);
  for (i_loc=0; i_loc<liwork_ls; ++i_loc) liwork_l[i_loc] = liwork_ll[i_loc];
  free(liwork_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, liwork, liwork_l, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_sbevx
(JNIEnv *env, jclass clazz, jcharArray jobz, jcharArray range, jcharArray uplo, jintArray n, jintArray kd, jdoubleArray ab, jintArray ldab, jdoubleArray q, jintArray ldq, jdoubleArray vl, jdoubleArray vu, jintArray il, jintArray iu, jdoubleArray abstol, jintArray m, jdoubleArray w, jdoubleArray z, jintArray ldz, jdoubleArray work, jintArray iwork, jintArray ifail, jintArray info) {
  int i_loc;
  jchar* jobz_l;
  char* jobz_ll;
  jsize jobz_ls;
  jchar* range_l;
  char* range_ll;
  jsize range_ls;
  jchar* uplo_l;
  char* uplo_ll;
  jsize uplo_ls;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jint* kd_l;
  integer* kd_ll;
  jsize kd_ls;
  jdouble* ab_ll;
  jint* ldab_l;
  integer* ldab_ll;
  jsize ldab_ls;
  jdouble* q_ll;
  jint* ldq_l;
  integer* ldq_ll;
  jsize ldq_ls;
  jdouble* vl_ll;
  jdouble* vu_ll;
  jint* il_l;
  integer* il_ll;
  jsize il_ls;
  jint* iu_l;
  integer* iu_ll;
  jsize iu_ls;
  jdouble* abstol_ll;
  jint* m_l;
  integer* m_ll;
  jsize m_ls;
  jdouble* w_ll;
  jdouble* z_ll;
  jint* ldz_l;
  integer* ldz_ll;
  jsize ldz_ls;
  jdouble* work_ll;
  jint* iwork_l;
  integer* iwork_ll;
  jsize iwork_ls;
  jint* ifail_l;
  integer* ifail_ll;
  jsize ifail_ls;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  jobz_l = (*env)->GetPrimitiveArrayCritical(env, jobz, NULL);
  jobz_ls = (*env)->GetArrayLength(env, jobz);
  jobz_ll = malloc(sizeof(char)*jobz_ls);
  for (i_loc=0; i_loc<jobz_ls; ++i_loc) jobz_ll[i_loc] = jobz_l[i_loc];
  range_l = (*env)->GetPrimitiveArrayCritical(env, range, NULL);
  range_ls = (*env)->GetArrayLength(env, range);
  range_ll = malloc(sizeof(char)*range_ls);
  for (i_loc=0; i_loc<range_ls; ++i_loc) range_ll[i_loc] = range_l[i_loc];
  uplo_l = (*env)->GetPrimitiveArrayCritical(env, uplo, NULL);
  uplo_ls = (*env)->GetArrayLength(env, uplo);
  uplo_ll = malloc(sizeof(char)*uplo_ls);
  for (i_loc=0; i_loc<uplo_ls; ++i_loc) uplo_ll[i_loc] = uplo_l[i_loc];
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  kd_l = (*env)->GetPrimitiveArrayCritical(env, kd, NULL);
  kd_ls = (*env)->GetArrayLength(env, kd);
  kd_ll = malloc(sizeof(integer)*kd_ls);
  for (i_loc=0; i_loc<kd_ls; ++i_loc) kd_ll[i_loc] = kd_l[i_loc];
  ab_ll = (*env)->GetPrimitiveArrayCritical(env, ab, NULL);
  ldab_l = (*env)->GetPrimitiveArrayCritical(env, ldab, NULL);
  ldab_ls = (*env)->GetArrayLength(env, ldab);
  ldab_ll = malloc(sizeof(integer)*ldab_ls);
  for (i_loc=0; i_loc<ldab_ls; ++i_loc) ldab_ll[i_loc] = ldab_l[i_loc];
  q_ll = (*env)->GetPrimitiveArrayCritical(env, q, NULL);
  ldq_l = (*env)->GetPrimitiveArrayCritical(env, ldq, NULL);
  ldq_ls = (*env)->GetArrayLength(env, ldq);
  ldq_ll = malloc(sizeof(integer)*ldq_ls);
  for (i_loc=0; i_loc<ldq_ls; ++i_loc) ldq_ll[i_loc] = ldq_l[i_loc];
  vl_ll = (*env)->GetPrimitiveArrayCritical(env, vl, NULL);
  vu_ll = (*env)->GetPrimitiveArrayCritical(env, vu, NULL);
  il_l = (*env)->GetPrimitiveArrayCritical(env, il, NULL);
  il_ls = (*env)->GetArrayLength(env, il);
  il_ll = malloc(sizeof(integer)*il_ls);
  for (i_loc=0; i_loc<il_ls; ++i_loc) il_ll[i_loc] = il_l[i_loc];
  iu_l = (*env)->GetPrimitiveArrayCritical(env, iu, NULL);
  iu_ls = (*env)->GetArrayLength(env, iu);
  iu_ll = malloc(sizeof(integer)*iu_ls);
  for (i_loc=0; i_loc<iu_ls; ++i_loc) iu_ll[i_loc] = iu_l[i_loc];
  abstol_ll = (*env)->GetPrimitiveArrayCritical(env, abstol, NULL);
  m_l = (*env)->GetPrimitiveArrayCritical(env, m, NULL);
  m_ls = (*env)->GetArrayLength(env, m);
  m_ll = malloc(sizeof(integer)*m_ls);
  for (i_loc=0; i_loc<m_ls; ++i_loc) m_ll[i_loc] = m_l[i_loc];
  w_ll = (*env)->GetPrimitiveArrayCritical(env, w, NULL);
  z_ll = (*env)->GetPrimitiveArrayCritical(env, z, NULL);
  ldz_l = (*env)->GetPrimitiveArrayCritical(env, ldz, NULL);
  ldz_ls = (*env)->GetArrayLength(env, ldz);
  ldz_ll = malloc(sizeof(integer)*ldz_ls);
  for (i_loc=0; i_loc<ldz_ls; ++i_loc) ldz_ll[i_loc] = ldz_l[i_loc];
  work_ll = (*env)->GetPrimitiveArrayCritical(env, work, NULL);
  iwork_l = (*env)->GetPrimitiveArrayCritical(env, iwork, NULL);
  iwork_ls = (*env)->GetArrayLength(env, iwork);
  iwork_ll = malloc(sizeof(integer)*iwork_ls);
  for (i_loc=0; i_loc<iwork_ls; ++i_loc) iwork_ll[i_loc] = iwork_l[i_loc];
  ifail_l = (*env)->GetPrimitiveArrayCritical(env, ifail, NULL);
  ifail_ls = (*env)->GetArrayLength(env, ifail);
  ifail_ll = malloc(sizeof(integer)*ifail_ls);
  for (i_loc=0; i_loc<ifail_ls; ++i_loc) ifail_ll[i_loc] = ifail_l[i_loc];
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dsbevx_(jobz_ll, range_ll, uplo_ll, n_ll, kd_ll, ab_ll, ldab_ll, q_ll, ldq_ll, vl_ll, vu_ll, il_ll, iu_ll, abstol_ll, m_ll, w_ll, z_ll, ldz_ll, work_ll, iwork_ll, ifail_ll, info_ll);

  for (i_loc=0; i_loc<jobz_ls; ++i_loc) jobz_l[i_loc] = jobz_ll[i_loc];
  free(jobz_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, jobz, jobz_l, 0);
  for (i_loc=0; i_loc<range_ls; ++i_loc) range_l[i_loc] = range_ll[i_loc];
  free(range_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, range, range_l, 0);
  for (i_loc=0; i_loc<uplo_ls; ++i_loc) uplo_l[i_loc] = uplo_ll[i_loc];
  free(uplo_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, uplo, uplo_l, 0);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  for (i_loc=0; i_loc<kd_ls; ++i_loc) kd_l[i_loc] = kd_ll[i_loc];
  free(kd_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, kd, kd_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, ab, ab_ll, 0);
  for (i_loc=0; i_loc<ldab_ls; ++i_loc) ldab_l[i_loc] = ldab_ll[i_loc];
  free(ldab_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldab, ldab_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, q, q_ll, 0);
  for (i_loc=0; i_loc<ldq_ls; ++i_loc) ldq_l[i_loc] = ldq_ll[i_loc];
  free(ldq_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldq, ldq_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, vl, vl_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, vu, vu_ll, 0);
  for (i_loc=0; i_loc<il_ls; ++i_loc) il_l[i_loc] = il_ll[i_loc];
  free(il_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, il, il_l, 0);
  for (i_loc=0; i_loc<iu_ls; ++i_loc) iu_l[i_loc] = iu_ll[i_loc];
  free(iu_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, iu, iu_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, abstol, abstol_ll, 0);
  for (i_loc=0; i_loc<m_ls; ++i_loc) m_l[i_loc] = m_ll[i_loc];
  free(m_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, m, m_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, w, w_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, z, z_ll, 0);
  for (i_loc=0; i_loc<ldz_ls; ++i_loc) ldz_l[i_loc] = ldz_ll[i_loc];
  free(ldz_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldz, ldz_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, work, work_ll, 0);
  for (i_loc=0; i_loc<iwork_ls; ++i_loc) iwork_l[i_loc] = iwork_ll[i_loc];
  free(iwork_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, iwork, iwork_l, 0);
  for (i_loc=0; i_loc<ifail_ls; ++i_loc) ifail_l[i_loc] = ifail_ll[i_loc];
  free(ifail_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ifail, ifail_l, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_sbgst
(JNIEnv *env, jclass clazz, jcharArray vect, jcharArray uplo, jintArray n, jintArray ka, jintArray kb, jdoubleArray ab, jintArray ldab, jdoubleArray bb, jintArray ldbb, jdoubleArray x, jintArray ldx, jdoubleArray work, jintArray info) {
  int i_loc;
  jchar* vect_l;
  char* vect_ll;
  jsize vect_ls;
  jchar* uplo_l;
  char* uplo_ll;
  jsize uplo_ls;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jint* ka_l;
  integer* ka_ll;
  jsize ka_ls;
  jint* kb_l;
  integer* kb_ll;
  jsize kb_ls;
  jdouble* ab_ll;
  jint* ldab_l;
  integer* ldab_ll;
  jsize ldab_ls;
  jdouble* bb_ll;
  jint* ldbb_l;
  integer* ldbb_ll;
  jsize ldbb_ls;
  jdouble* x_ll;
  jint* ldx_l;
  integer* ldx_ll;
  jsize ldx_ls;
  jdouble* work_ll;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  vect_l = (*env)->GetPrimitiveArrayCritical(env, vect, NULL);
  vect_ls = (*env)->GetArrayLength(env, vect);
  vect_ll = malloc(sizeof(char)*vect_ls);
  for (i_loc=0; i_loc<vect_ls; ++i_loc) vect_ll[i_loc] = vect_l[i_loc];
  uplo_l = (*env)->GetPrimitiveArrayCritical(env, uplo, NULL);
  uplo_ls = (*env)->GetArrayLength(env, uplo);
  uplo_ll = malloc(sizeof(char)*uplo_ls);
  for (i_loc=0; i_loc<uplo_ls; ++i_loc) uplo_ll[i_loc] = uplo_l[i_loc];
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  ka_l = (*env)->GetPrimitiveArrayCritical(env, ka, NULL);
  ka_ls = (*env)->GetArrayLength(env, ka);
  ka_ll = malloc(sizeof(integer)*ka_ls);
  for (i_loc=0; i_loc<ka_ls; ++i_loc) ka_ll[i_loc] = ka_l[i_loc];
  kb_l = (*env)->GetPrimitiveArrayCritical(env, kb, NULL);
  kb_ls = (*env)->GetArrayLength(env, kb);
  kb_ll = malloc(sizeof(integer)*kb_ls);
  for (i_loc=0; i_loc<kb_ls; ++i_loc) kb_ll[i_loc] = kb_l[i_loc];
  ab_ll = (*env)->GetPrimitiveArrayCritical(env, ab, NULL);
  ldab_l = (*env)->GetPrimitiveArrayCritical(env, ldab, NULL);
  ldab_ls = (*env)->GetArrayLength(env, ldab);
  ldab_ll = malloc(sizeof(integer)*ldab_ls);
  for (i_loc=0; i_loc<ldab_ls; ++i_loc) ldab_ll[i_loc] = ldab_l[i_loc];
  bb_ll = (*env)->GetPrimitiveArrayCritical(env, bb, NULL);
  ldbb_l = (*env)->GetPrimitiveArrayCritical(env, ldbb, NULL);
  ldbb_ls = (*env)->GetArrayLength(env, ldbb);
  ldbb_ll = malloc(sizeof(integer)*ldbb_ls);
  for (i_loc=0; i_loc<ldbb_ls; ++i_loc) ldbb_ll[i_loc] = ldbb_l[i_loc];
  x_ll = (*env)->GetPrimitiveArrayCritical(env, x, NULL);
  ldx_l = (*env)->GetPrimitiveArrayCritical(env, ldx, NULL);
  ldx_ls = (*env)->GetArrayLength(env, ldx);
  ldx_ll = malloc(sizeof(integer)*ldx_ls);
  for (i_loc=0; i_loc<ldx_ls; ++i_loc) ldx_ll[i_loc] = ldx_l[i_loc];
  work_ll = (*env)->GetPrimitiveArrayCritical(env, work, NULL);
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dsbgst_(vect_ll, uplo_ll, n_ll, ka_ll, kb_ll, ab_ll, ldab_ll, bb_ll, ldbb_ll, x_ll, ldx_ll, work_ll, info_ll);

  for (i_loc=0; i_loc<vect_ls; ++i_loc) vect_l[i_loc] = vect_ll[i_loc];
  free(vect_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, vect, vect_l, 0);
  for (i_loc=0; i_loc<uplo_ls; ++i_loc) uplo_l[i_loc] = uplo_ll[i_loc];
  free(uplo_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, uplo, uplo_l, 0);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  for (i_loc=0; i_loc<ka_ls; ++i_loc) ka_l[i_loc] = ka_ll[i_loc];
  free(ka_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ka, ka_l, 0);
  for (i_loc=0; i_loc<kb_ls; ++i_loc) kb_l[i_loc] = kb_ll[i_loc];
  free(kb_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, kb, kb_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, ab, ab_ll, 0);
  for (i_loc=0; i_loc<ldab_ls; ++i_loc) ldab_l[i_loc] = ldab_ll[i_loc];
  free(ldab_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldab, ldab_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, bb, bb_ll, 0);
  for (i_loc=0; i_loc<ldbb_ls; ++i_loc) ldbb_l[i_loc] = ldbb_ll[i_loc];
  free(ldbb_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldbb, ldbb_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, x, x_ll, 0);
  for (i_loc=0; i_loc<ldx_ls; ++i_loc) ldx_l[i_loc] = ldx_ll[i_loc];
  free(ldx_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldx, ldx_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, work, work_ll, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_sbgv
(JNIEnv *env, jclass clazz, jcharArray jobz, jcharArray uplo, jintArray n, jintArray ka, jintArray kb, jdoubleArray ab, jintArray ldab, jdoubleArray bb, jintArray ldbb, jdoubleArray w, jdoubleArray z, jintArray ldz, jdoubleArray work, jintArray info) {
  int i_loc;
  jchar* jobz_l;
  char* jobz_ll;
  jsize jobz_ls;
  jchar* uplo_l;
  char* uplo_ll;
  jsize uplo_ls;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jint* ka_l;
  integer* ka_ll;
  jsize ka_ls;
  jint* kb_l;
  integer* kb_ll;
  jsize kb_ls;
  jdouble* ab_ll;
  jint* ldab_l;
  integer* ldab_ll;
  jsize ldab_ls;
  jdouble* bb_ll;
  jint* ldbb_l;
  integer* ldbb_ll;
  jsize ldbb_ls;
  jdouble* w_ll;
  jdouble* z_ll;
  jint* ldz_l;
  integer* ldz_ll;
  jsize ldz_ls;
  jdouble* work_ll;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  jobz_l = (*env)->GetPrimitiveArrayCritical(env, jobz, NULL);
  jobz_ls = (*env)->GetArrayLength(env, jobz);
  jobz_ll = malloc(sizeof(char)*jobz_ls);
  for (i_loc=0; i_loc<jobz_ls; ++i_loc) jobz_ll[i_loc] = jobz_l[i_loc];
  uplo_l = (*env)->GetPrimitiveArrayCritical(env, uplo, NULL);
  uplo_ls = (*env)->GetArrayLength(env, uplo);
  uplo_ll = malloc(sizeof(char)*uplo_ls);
  for (i_loc=0; i_loc<uplo_ls; ++i_loc) uplo_ll[i_loc] = uplo_l[i_loc];
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  ka_l = (*env)->GetPrimitiveArrayCritical(env, ka, NULL);
  ka_ls = (*env)->GetArrayLength(env, ka);
  ka_ll = malloc(sizeof(integer)*ka_ls);
  for (i_loc=0; i_loc<ka_ls; ++i_loc) ka_ll[i_loc] = ka_l[i_loc];
  kb_l = (*env)->GetPrimitiveArrayCritical(env, kb, NULL);
  kb_ls = (*env)->GetArrayLength(env, kb);
  kb_ll = malloc(sizeof(integer)*kb_ls);
  for (i_loc=0; i_loc<kb_ls; ++i_loc) kb_ll[i_loc] = kb_l[i_loc];
  ab_ll = (*env)->GetPrimitiveArrayCritical(env, ab, NULL);
  ldab_l = (*env)->GetPrimitiveArrayCritical(env, ldab, NULL);
  ldab_ls = (*env)->GetArrayLength(env, ldab);
  ldab_ll = malloc(sizeof(integer)*ldab_ls);
  for (i_loc=0; i_loc<ldab_ls; ++i_loc) ldab_ll[i_loc] = ldab_l[i_loc];
  bb_ll = (*env)->GetPrimitiveArrayCritical(env, bb, NULL);
  ldbb_l = (*env)->GetPrimitiveArrayCritical(env, ldbb, NULL);
  ldbb_ls = (*env)->GetArrayLength(env, ldbb);
  ldbb_ll = malloc(sizeof(integer)*ldbb_ls);
  for (i_loc=0; i_loc<ldbb_ls; ++i_loc) ldbb_ll[i_loc] = ldbb_l[i_loc];
  w_ll = (*env)->GetPrimitiveArrayCritical(env, w, NULL);
  z_ll = (*env)->GetPrimitiveArrayCritical(env, z, NULL);
  ldz_l = (*env)->GetPrimitiveArrayCritical(env, ldz, NULL);
  ldz_ls = (*env)->GetArrayLength(env, ldz);
  ldz_ll = malloc(sizeof(integer)*ldz_ls);
  for (i_loc=0; i_loc<ldz_ls; ++i_loc) ldz_ll[i_loc] = ldz_l[i_loc];
  work_ll = (*env)->GetPrimitiveArrayCritical(env, work, NULL);
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dsbgv_(jobz_ll, uplo_ll, n_ll, ka_ll, kb_ll, ab_ll, ldab_ll, bb_ll, ldbb_ll, w_ll, z_ll, ldz_ll, work_ll, info_ll);

  for (i_loc=0; i_loc<jobz_ls; ++i_loc) jobz_l[i_loc] = jobz_ll[i_loc];
  free(jobz_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, jobz, jobz_l, 0);
  for (i_loc=0; i_loc<uplo_ls; ++i_loc) uplo_l[i_loc] = uplo_ll[i_loc];
  free(uplo_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, uplo, uplo_l, 0);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  for (i_loc=0; i_loc<ka_ls; ++i_loc) ka_l[i_loc] = ka_ll[i_loc];
  free(ka_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ka, ka_l, 0);
  for (i_loc=0; i_loc<kb_ls; ++i_loc) kb_l[i_loc] = kb_ll[i_loc];
  free(kb_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, kb, kb_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, ab, ab_ll, 0);
  for (i_loc=0; i_loc<ldab_ls; ++i_loc) ldab_l[i_loc] = ldab_ll[i_loc];
  free(ldab_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldab, ldab_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, bb, bb_ll, 0);
  for (i_loc=0; i_loc<ldbb_ls; ++i_loc) ldbb_l[i_loc] = ldbb_ll[i_loc];
  free(ldbb_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldbb, ldbb_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, w, w_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, z, z_ll, 0);
  for (i_loc=0; i_loc<ldz_ls; ++i_loc) ldz_l[i_loc] = ldz_ll[i_loc];
  free(ldz_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldz, ldz_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, work, work_ll, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_sbgvd
(JNIEnv *env, jclass clazz, jcharArray jobz, jcharArray uplo, jintArray n, jintArray ka, jintArray kb, jdoubleArray ab, jintArray ldab, jdoubleArray bb, jintArray ldbb, jdoubleArray w, jdoubleArray z, jintArray ldz, jdoubleArray work, jintArray lwork, jintArray iwork, jintArray liwork, jintArray info) {
  int i_loc;
  jchar* jobz_l;
  char* jobz_ll;
  jsize jobz_ls;
  jchar* uplo_l;
  char* uplo_ll;
  jsize uplo_ls;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jint* ka_l;
  integer* ka_ll;
  jsize ka_ls;
  jint* kb_l;
  integer* kb_ll;
  jsize kb_ls;
  jdouble* ab_ll;
  jint* ldab_l;
  integer* ldab_ll;
  jsize ldab_ls;
  jdouble* bb_ll;
  jint* ldbb_l;
  integer* ldbb_ll;
  jsize ldbb_ls;
  jdouble* w_ll;
  jdouble* z_ll;
  jint* ldz_l;
  integer* ldz_ll;
  jsize ldz_ls;
  jdouble* work_ll;
  jint* lwork_l;
  integer* lwork_ll;
  jsize lwork_ls;
  jint* iwork_l;
  integer* iwork_ll;
  jsize iwork_ls;
  jint* liwork_l;
  integer* liwork_ll;
  jsize liwork_ls;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  jobz_l = (*env)->GetPrimitiveArrayCritical(env, jobz, NULL);
  jobz_ls = (*env)->GetArrayLength(env, jobz);
  jobz_ll = malloc(sizeof(char)*jobz_ls);
  for (i_loc=0; i_loc<jobz_ls; ++i_loc) jobz_ll[i_loc] = jobz_l[i_loc];
  uplo_l = (*env)->GetPrimitiveArrayCritical(env, uplo, NULL);
  uplo_ls = (*env)->GetArrayLength(env, uplo);
  uplo_ll = malloc(sizeof(char)*uplo_ls);
  for (i_loc=0; i_loc<uplo_ls; ++i_loc) uplo_ll[i_loc] = uplo_l[i_loc];
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  ka_l = (*env)->GetPrimitiveArrayCritical(env, ka, NULL);
  ka_ls = (*env)->GetArrayLength(env, ka);
  ka_ll = malloc(sizeof(integer)*ka_ls);
  for (i_loc=0; i_loc<ka_ls; ++i_loc) ka_ll[i_loc] = ka_l[i_loc];
  kb_l = (*env)->GetPrimitiveArrayCritical(env, kb, NULL);
  kb_ls = (*env)->GetArrayLength(env, kb);
  kb_ll = malloc(sizeof(integer)*kb_ls);
  for (i_loc=0; i_loc<kb_ls; ++i_loc) kb_ll[i_loc] = kb_l[i_loc];
  ab_ll = (*env)->GetPrimitiveArrayCritical(env, ab, NULL);
  ldab_l = (*env)->GetPrimitiveArrayCritical(env, ldab, NULL);
  ldab_ls = (*env)->GetArrayLength(env, ldab);
  ldab_ll = malloc(sizeof(integer)*ldab_ls);
  for (i_loc=0; i_loc<ldab_ls; ++i_loc) ldab_ll[i_loc] = ldab_l[i_loc];
  bb_ll = (*env)->GetPrimitiveArrayCritical(env, bb, NULL);
  ldbb_l = (*env)->GetPrimitiveArrayCritical(env, ldbb, NULL);
  ldbb_ls = (*env)->GetArrayLength(env, ldbb);
  ldbb_ll = malloc(sizeof(integer)*ldbb_ls);
  for (i_loc=0; i_loc<ldbb_ls; ++i_loc) ldbb_ll[i_loc] = ldbb_l[i_loc];
  w_ll = (*env)->GetPrimitiveArrayCritical(env, w, NULL);
  z_ll = (*env)->GetPrimitiveArrayCritical(env, z, NULL);
  ldz_l = (*env)->GetPrimitiveArrayCritical(env, ldz, NULL);
  ldz_ls = (*env)->GetArrayLength(env, ldz);
  ldz_ll = malloc(sizeof(integer)*ldz_ls);
  for (i_loc=0; i_loc<ldz_ls; ++i_loc) ldz_ll[i_loc] = ldz_l[i_loc];
  work_ll = (*env)->GetPrimitiveArrayCritical(env, work, NULL);
  lwork_l = (*env)->GetPrimitiveArrayCritical(env, lwork, NULL);
  lwork_ls = (*env)->GetArrayLength(env, lwork);
  lwork_ll = malloc(sizeof(integer)*lwork_ls);
  for (i_loc=0; i_loc<lwork_ls; ++i_loc) lwork_ll[i_loc] = lwork_l[i_loc];
  iwork_l = (*env)->GetPrimitiveArrayCritical(env, iwork, NULL);
  iwork_ls = (*env)->GetArrayLength(env, iwork);
  iwork_ll = malloc(sizeof(integer)*iwork_ls);
  for (i_loc=0; i_loc<iwork_ls; ++i_loc) iwork_ll[i_loc] = iwork_l[i_loc];
  liwork_l = (*env)->GetPrimitiveArrayCritical(env, liwork, NULL);
  liwork_ls = (*env)->GetArrayLength(env, liwork);
  liwork_ll = malloc(sizeof(integer)*liwork_ls);
  for (i_loc=0; i_loc<liwork_ls; ++i_loc) liwork_ll[i_loc] = liwork_l[i_loc];
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dsbgvd_(jobz_ll, uplo_ll, n_ll, ka_ll, kb_ll, ab_ll, ldab_ll, bb_ll, ldbb_ll, w_ll, z_ll, ldz_ll, work_ll, lwork_ll, iwork_ll, liwork_ll, info_ll);

  for (i_loc=0; i_loc<jobz_ls; ++i_loc) jobz_l[i_loc] = jobz_ll[i_loc];
  free(jobz_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, jobz, jobz_l, 0);
  for (i_loc=0; i_loc<uplo_ls; ++i_loc) uplo_l[i_loc] = uplo_ll[i_loc];
  free(uplo_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, uplo, uplo_l, 0);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  for (i_loc=0; i_loc<ka_ls; ++i_loc) ka_l[i_loc] = ka_ll[i_loc];
  free(ka_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ka, ka_l, 0);
  for (i_loc=0; i_loc<kb_ls; ++i_loc) kb_l[i_loc] = kb_ll[i_loc];
  free(kb_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, kb, kb_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, ab, ab_ll, 0);
  for (i_loc=0; i_loc<ldab_ls; ++i_loc) ldab_l[i_loc] = ldab_ll[i_loc];
  free(ldab_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldab, ldab_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, bb, bb_ll, 0);
  for (i_loc=0; i_loc<ldbb_ls; ++i_loc) ldbb_l[i_loc] = ldbb_ll[i_loc];
  free(ldbb_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldbb, ldbb_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, w, w_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, z, z_ll, 0);
  for (i_loc=0; i_loc<ldz_ls; ++i_loc) ldz_l[i_loc] = ldz_ll[i_loc];
  free(ldz_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldz, ldz_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, work, work_ll, 0);
  for (i_loc=0; i_loc<lwork_ls; ++i_loc) lwork_l[i_loc] = lwork_ll[i_loc];
  free(lwork_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, lwork, lwork_l, 0);
  for (i_loc=0; i_loc<iwork_ls; ++i_loc) iwork_l[i_loc] = iwork_ll[i_loc];
  free(iwork_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, iwork, iwork_l, 0);
  for (i_loc=0; i_loc<liwork_ls; ++i_loc) liwork_l[i_loc] = liwork_ll[i_loc];
  free(liwork_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, liwork, liwork_l, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_sbgvx
(JNIEnv *env, jclass clazz, jcharArray jobz, jcharArray range, jcharArray uplo, jintArray n, jintArray ka, jintArray kb, jdoubleArray ab, jintArray ldab, jdoubleArray bb, jintArray ldbb, jdoubleArray q, jintArray ldq, jdoubleArray vl, jdoubleArray vu, jintArray il, jintArray iu, jdoubleArray abstol, jintArray m, jdoubleArray w, jdoubleArray z, jintArray ldz, jdoubleArray work, jintArray iwork, jintArray ifail, jintArray info) {
  int i_loc;
  jchar* jobz_l;
  char* jobz_ll;
  jsize jobz_ls;
  jchar* range_l;
  char* range_ll;
  jsize range_ls;
  jchar* uplo_l;
  char* uplo_ll;
  jsize uplo_ls;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jint* ka_l;
  integer* ka_ll;
  jsize ka_ls;
  jint* kb_l;
  integer* kb_ll;
  jsize kb_ls;
  jdouble* ab_ll;
  jint* ldab_l;
  integer* ldab_ll;
  jsize ldab_ls;
  jdouble* bb_ll;
  jint* ldbb_l;
  integer* ldbb_ll;
  jsize ldbb_ls;
  jdouble* q_ll;
  jint* ldq_l;
  integer* ldq_ll;
  jsize ldq_ls;
  jdouble* vl_ll;
  jdouble* vu_ll;
  jint* il_l;
  integer* il_ll;
  jsize il_ls;
  jint* iu_l;
  integer* iu_ll;
  jsize iu_ls;
  jdouble* abstol_ll;
  jint* m_l;
  integer* m_ll;
  jsize m_ls;
  jdouble* w_ll;
  jdouble* z_ll;
  jint* ldz_l;
  integer* ldz_ll;
  jsize ldz_ls;
  jdouble* work_ll;
  jint* iwork_l;
  integer* iwork_ll;
  jsize iwork_ls;
  jint* ifail_l;
  integer* ifail_ll;
  jsize ifail_ls;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  jobz_l = (*env)->GetPrimitiveArrayCritical(env, jobz, NULL);
  jobz_ls = (*env)->GetArrayLength(env, jobz);
  jobz_ll = malloc(sizeof(char)*jobz_ls);
  for (i_loc=0; i_loc<jobz_ls; ++i_loc) jobz_ll[i_loc] = jobz_l[i_loc];
  range_l = (*env)->GetPrimitiveArrayCritical(env, range, NULL);
  range_ls = (*env)->GetArrayLength(env, range);
  range_ll = malloc(sizeof(char)*range_ls);
  for (i_loc=0; i_loc<range_ls; ++i_loc) range_ll[i_loc] = range_l[i_loc];
  uplo_l = (*env)->GetPrimitiveArrayCritical(env, uplo, NULL);
  uplo_ls = (*env)->GetArrayLength(env, uplo);
  uplo_ll = malloc(sizeof(char)*uplo_ls);
  for (i_loc=0; i_loc<uplo_ls; ++i_loc) uplo_ll[i_loc] = uplo_l[i_loc];
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  ka_l = (*env)->GetPrimitiveArrayCritical(env, ka, NULL);
  ka_ls = (*env)->GetArrayLength(env, ka);
  ka_ll = malloc(sizeof(integer)*ka_ls);
  for (i_loc=0; i_loc<ka_ls; ++i_loc) ka_ll[i_loc] = ka_l[i_loc];
  kb_l = (*env)->GetPrimitiveArrayCritical(env, kb, NULL);
  kb_ls = (*env)->GetArrayLength(env, kb);
  kb_ll = malloc(sizeof(integer)*kb_ls);
  for (i_loc=0; i_loc<kb_ls; ++i_loc) kb_ll[i_loc] = kb_l[i_loc];
  ab_ll = (*env)->GetPrimitiveArrayCritical(env, ab, NULL);
  ldab_l = (*env)->GetPrimitiveArrayCritical(env, ldab, NULL);
  ldab_ls = (*env)->GetArrayLength(env, ldab);
  ldab_ll = malloc(sizeof(integer)*ldab_ls);
  for (i_loc=0; i_loc<ldab_ls; ++i_loc) ldab_ll[i_loc] = ldab_l[i_loc];
  bb_ll = (*env)->GetPrimitiveArrayCritical(env, bb, NULL);
  ldbb_l = (*env)->GetPrimitiveArrayCritical(env, ldbb, NULL);
  ldbb_ls = (*env)->GetArrayLength(env, ldbb);
  ldbb_ll = malloc(sizeof(integer)*ldbb_ls);
  for (i_loc=0; i_loc<ldbb_ls; ++i_loc) ldbb_ll[i_loc] = ldbb_l[i_loc];
  q_ll = (*env)->GetPrimitiveArrayCritical(env, q, NULL);
  ldq_l = (*env)->GetPrimitiveArrayCritical(env, ldq, NULL);
  ldq_ls = (*env)->GetArrayLength(env, ldq);
  ldq_ll = malloc(sizeof(integer)*ldq_ls);
  for (i_loc=0; i_loc<ldq_ls; ++i_loc) ldq_ll[i_loc] = ldq_l[i_loc];
  vl_ll = (*env)->GetPrimitiveArrayCritical(env, vl, NULL);
  vu_ll = (*env)->GetPrimitiveArrayCritical(env, vu, NULL);
  il_l = (*env)->GetPrimitiveArrayCritical(env, il, NULL);
  il_ls = (*env)->GetArrayLength(env, il);
  il_ll = malloc(sizeof(integer)*il_ls);
  for (i_loc=0; i_loc<il_ls; ++i_loc) il_ll[i_loc] = il_l[i_loc];
  iu_l = (*env)->GetPrimitiveArrayCritical(env, iu, NULL);
  iu_ls = (*env)->GetArrayLength(env, iu);
  iu_ll = malloc(sizeof(integer)*iu_ls);
  for (i_loc=0; i_loc<iu_ls; ++i_loc) iu_ll[i_loc] = iu_l[i_loc];
  abstol_ll = (*env)->GetPrimitiveArrayCritical(env, abstol, NULL);
  m_l = (*env)->GetPrimitiveArrayCritical(env, m, NULL);
  m_ls = (*env)->GetArrayLength(env, m);
  m_ll = malloc(sizeof(integer)*m_ls);
  for (i_loc=0; i_loc<m_ls; ++i_loc) m_ll[i_loc] = m_l[i_loc];
  w_ll = (*env)->GetPrimitiveArrayCritical(env, w, NULL);
  z_ll = (*env)->GetPrimitiveArrayCritical(env, z, NULL);
  ldz_l = (*env)->GetPrimitiveArrayCritical(env, ldz, NULL);
  ldz_ls = (*env)->GetArrayLength(env, ldz);
  ldz_ll = malloc(sizeof(integer)*ldz_ls);
  for (i_loc=0; i_loc<ldz_ls; ++i_loc) ldz_ll[i_loc] = ldz_l[i_loc];
  work_ll = (*env)->GetPrimitiveArrayCritical(env, work, NULL);
  iwork_l = (*env)->GetPrimitiveArrayCritical(env, iwork, NULL);
  iwork_ls = (*env)->GetArrayLength(env, iwork);
  iwork_ll = malloc(sizeof(integer)*iwork_ls);
  for (i_loc=0; i_loc<iwork_ls; ++i_loc) iwork_ll[i_loc] = iwork_l[i_loc];
  ifail_l = (*env)->GetPrimitiveArrayCritical(env, ifail, NULL);
  ifail_ls = (*env)->GetArrayLength(env, ifail);
  ifail_ll = malloc(sizeof(integer)*ifail_ls);
  for (i_loc=0; i_loc<ifail_ls; ++i_loc) ifail_ll[i_loc] = ifail_l[i_loc];
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dsbgvx_(jobz_ll, range_ll, uplo_ll, n_ll, ka_ll, kb_ll, ab_ll, ldab_ll, bb_ll, ldbb_ll, q_ll, ldq_ll, vl_ll, vu_ll, il_ll, iu_ll, abstol_ll, m_ll, w_ll, z_ll, ldz_ll, work_ll, iwork_ll, ifail_ll, info_ll);

  for (i_loc=0; i_loc<jobz_ls; ++i_loc) jobz_l[i_loc] = jobz_ll[i_loc];
  free(jobz_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, jobz, jobz_l, 0);
  for (i_loc=0; i_loc<range_ls; ++i_loc) range_l[i_loc] = range_ll[i_loc];
  free(range_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, range, range_l, 0);
  for (i_loc=0; i_loc<uplo_ls; ++i_loc) uplo_l[i_loc] = uplo_ll[i_loc];
  free(uplo_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, uplo, uplo_l, 0);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  for (i_loc=0; i_loc<ka_ls; ++i_loc) ka_l[i_loc] = ka_ll[i_loc];
  free(ka_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ka, ka_l, 0);
  for (i_loc=0; i_loc<kb_ls; ++i_loc) kb_l[i_loc] = kb_ll[i_loc];
  free(kb_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, kb, kb_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, ab, ab_ll, 0);
  for (i_loc=0; i_loc<ldab_ls; ++i_loc) ldab_l[i_loc] = ldab_ll[i_loc];
  free(ldab_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldab, ldab_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, bb, bb_ll, 0);
  for (i_loc=0; i_loc<ldbb_ls; ++i_loc) ldbb_l[i_loc] = ldbb_ll[i_loc];
  free(ldbb_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldbb, ldbb_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, q, q_ll, 0);
  for (i_loc=0; i_loc<ldq_ls; ++i_loc) ldq_l[i_loc] = ldq_ll[i_loc];
  free(ldq_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldq, ldq_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, vl, vl_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, vu, vu_ll, 0);
  for (i_loc=0; i_loc<il_ls; ++i_loc) il_l[i_loc] = il_ll[i_loc];
  free(il_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, il, il_l, 0);
  for (i_loc=0; i_loc<iu_ls; ++i_loc) iu_l[i_loc] = iu_ll[i_loc];
  free(iu_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, iu, iu_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, abstol, abstol_ll, 0);
  for (i_loc=0; i_loc<m_ls; ++i_loc) m_l[i_loc] = m_ll[i_loc];
  free(m_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, m, m_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, w, w_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, z, z_ll, 0);
  for (i_loc=0; i_loc<ldz_ls; ++i_loc) ldz_l[i_loc] = ldz_ll[i_loc];
  free(ldz_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldz, ldz_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, work, work_ll, 0);
  for (i_loc=0; i_loc<iwork_ls; ++i_loc) iwork_l[i_loc] = iwork_ll[i_loc];
  free(iwork_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, iwork, iwork_l, 0);
  for (i_loc=0; i_loc<ifail_ls; ++i_loc) ifail_l[i_loc] = ifail_ll[i_loc];
  free(ifail_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ifail, ifail_l, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_sbtrd
(JNIEnv *env, jclass clazz, jcharArray vect, jcharArray uplo, jintArray n, jintArray kd, jdoubleArray ab, jintArray ldab, jdoubleArray d, jdoubleArray e, jdoubleArray q, jintArray ldq, jdoubleArray work, jintArray info) {
  int i_loc;
  jchar* vect_l;
  char* vect_ll;
  jsize vect_ls;
  jchar* uplo_l;
  char* uplo_ll;
  jsize uplo_ls;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jint* kd_l;
  integer* kd_ll;
  jsize kd_ls;
  jdouble* ab_ll;
  jint* ldab_l;
  integer* ldab_ll;
  jsize ldab_ls;
  jdouble* d_ll;
  jdouble* e_ll;
  jdouble* q_ll;
  jint* ldq_l;
  integer* ldq_ll;
  jsize ldq_ls;
  jdouble* work_ll;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  vect_l = (*env)->GetPrimitiveArrayCritical(env, vect, NULL);
  vect_ls = (*env)->GetArrayLength(env, vect);
  vect_ll = malloc(sizeof(char)*vect_ls);
  for (i_loc=0; i_loc<vect_ls; ++i_loc) vect_ll[i_loc] = vect_l[i_loc];
  uplo_l = (*env)->GetPrimitiveArrayCritical(env, uplo, NULL);
  uplo_ls = (*env)->GetArrayLength(env, uplo);
  uplo_ll = malloc(sizeof(char)*uplo_ls);
  for (i_loc=0; i_loc<uplo_ls; ++i_loc) uplo_ll[i_loc] = uplo_l[i_loc];
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  kd_l = (*env)->GetPrimitiveArrayCritical(env, kd, NULL);
  kd_ls = (*env)->GetArrayLength(env, kd);
  kd_ll = malloc(sizeof(integer)*kd_ls);
  for (i_loc=0; i_loc<kd_ls; ++i_loc) kd_ll[i_loc] = kd_l[i_loc];
  ab_ll = (*env)->GetPrimitiveArrayCritical(env, ab, NULL);
  ldab_l = (*env)->GetPrimitiveArrayCritical(env, ldab, NULL);
  ldab_ls = (*env)->GetArrayLength(env, ldab);
  ldab_ll = malloc(sizeof(integer)*ldab_ls);
  for (i_loc=0; i_loc<ldab_ls; ++i_loc) ldab_ll[i_loc] = ldab_l[i_loc];
  d_ll = (*env)->GetPrimitiveArrayCritical(env, d, NULL);
  e_ll = (*env)->GetPrimitiveArrayCritical(env, e, NULL);
  q_ll = (*env)->GetPrimitiveArrayCritical(env, q, NULL);
  ldq_l = (*env)->GetPrimitiveArrayCritical(env, ldq, NULL);
  ldq_ls = (*env)->GetArrayLength(env, ldq);
  ldq_ll = malloc(sizeof(integer)*ldq_ls);
  for (i_loc=0; i_loc<ldq_ls; ++i_loc) ldq_ll[i_loc] = ldq_l[i_loc];
  work_ll = (*env)->GetPrimitiveArrayCritical(env, work, NULL);
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dsbtrd_(vect_ll, uplo_ll, n_ll, kd_ll, ab_ll, ldab_ll, d_ll, e_ll, q_ll, ldq_ll, work_ll, info_ll);

  for (i_loc=0; i_loc<vect_ls; ++i_loc) vect_l[i_loc] = vect_ll[i_loc];
  free(vect_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, vect, vect_l, 0);
  for (i_loc=0; i_loc<uplo_ls; ++i_loc) uplo_l[i_loc] = uplo_ll[i_loc];
  free(uplo_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, uplo, uplo_l, 0);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  for (i_loc=0; i_loc<kd_ls; ++i_loc) kd_l[i_loc] = kd_ll[i_loc];
  free(kd_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, kd, kd_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, ab, ab_ll, 0);
  for (i_loc=0; i_loc<ldab_ls; ++i_loc) ldab_l[i_loc] = ldab_ll[i_loc];
  free(ldab_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldab, ldab_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, d, d_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, e, e_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, q, q_ll, 0);
  for (i_loc=0; i_loc<ldq_ls; ++i_loc) ldq_l[i_loc] = ldq_ll[i_loc];
  free(ldq_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldq, ldq_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, work, work_ll, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_spcon
(JNIEnv *env, jclass clazz, jcharArray uplo, jintArray n, jdoubleArray ap, jintArray ipiv, jdoubleArray anorm, jdoubleArray rcond, jdoubleArray work, jintArray iwork, jintArray info) {
  int i_loc;
  jchar* uplo_l;
  char* uplo_ll;
  jsize uplo_ls;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jdouble* ap_ll;
  jint* ipiv_l;
  integer* ipiv_ll;
  jsize ipiv_ls;
  jdouble* anorm_ll;
  jdouble* rcond_ll;
  jdouble* work_ll;
  jint* iwork_l;
  integer* iwork_ll;
  jsize iwork_ls;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  uplo_l = (*env)->GetPrimitiveArrayCritical(env, uplo, NULL);
  uplo_ls = (*env)->GetArrayLength(env, uplo);
  uplo_ll = malloc(sizeof(char)*uplo_ls);
  for (i_loc=0; i_loc<uplo_ls; ++i_loc) uplo_ll[i_loc] = uplo_l[i_loc];
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  ap_ll = (*env)->GetPrimitiveArrayCritical(env, ap, NULL);
  ipiv_l = (*env)->GetPrimitiveArrayCritical(env, ipiv, NULL);
  ipiv_ls = (*env)->GetArrayLength(env, ipiv);
  ipiv_ll = malloc(sizeof(integer)*ipiv_ls);
  for (i_loc=0; i_loc<ipiv_ls; ++i_loc) ipiv_ll[i_loc] = ipiv_l[i_loc];
  anorm_ll = (*env)->GetPrimitiveArrayCritical(env, anorm, NULL);
  rcond_ll = (*env)->GetPrimitiveArrayCritical(env, rcond, NULL);
  work_ll = (*env)->GetPrimitiveArrayCritical(env, work, NULL);
  iwork_l = (*env)->GetPrimitiveArrayCritical(env, iwork, NULL);
  iwork_ls = (*env)->GetArrayLength(env, iwork);
  iwork_ll = malloc(sizeof(integer)*iwork_ls);
  for (i_loc=0; i_loc<iwork_ls; ++i_loc) iwork_ll[i_loc] = iwork_l[i_loc];
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dspcon_(uplo_ll, n_ll, ap_ll, ipiv_ll, anorm_ll, rcond_ll, work_ll, iwork_ll, info_ll);

  for (i_loc=0; i_loc<uplo_ls; ++i_loc) uplo_l[i_loc] = uplo_ll[i_loc];
  free(uplo_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, uplo, uplo_l, 0);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, ap, ap_ll, 0);
  for (i_loc=0; i_loc<ipiv_ls; ++i_loc) ipiv_l[i_loc] = ipiv_ll[i_loc];
  free(ipiv_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ipiv, ipiv_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, anorm, anorm_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, rcond, rcond_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, work, work_ll, 0);
  for (i_loc=0; i_loc<iwork_ls; ++i_loc) iwork_l[i_loc] = iwork_ll[i_loc];
  free(iwork_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, iwork, iwork_l, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_spev
(JNIEnv *env, jclass clazz, jcharArray jobz, jcharArray uplo, jintArray n, jdoubleArray ap, jdoubleArray w, jdoubleArray z, jintArray ldz, jdoubleArray work, jintArray info) {
  int i_loc;
  jchar* jobz_l;
  char* jobz_ll;
  jsize jobz_ls;
  jchar* uplo_l;
  char* uplo_ll;
  jsize uplo_ls;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jdouble* ap_ll;
  jdouble* w_ll;
  jdouble* z_ll;
  jint* ldz_l;
  integer* ldz_ll;
  jsize ldz_ls;
  jdouble* work_ll;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  jobz_l = (*env)->GetPrimitiveArrayCritical(env, jobz, NULL);
  jobz_ls = (*env)->GetArrayLength(env, jobz);
  jobz_ll = malloc(sizeof(char)*jobz_ls);
  for (i_loc=0; i_loc<jobz_ls; ++i_loc) jobz_ll[i_loc] = jobz_l[i_loc];
  uplo_l = (*env)->GetPrimitiveArrayCritical(env, uplo, NULL);
  uplo_ls = (*env)->GetArrayLength(env, uplo);
  uplo_ll = malloc(sizeof(char)*uplo_ls);
  for (i_loc=0; i_loc<uplo_ls; ++i_loc) uplo_ll[i_loc] = uplo_l[i_loc];
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  ap_ll = (*env)->GetPrimitiveArrayCritical(env, ap, NULL);
  w_ll = (*env)->GetPrimitiveArrayCritical(env, w, NULL);
  z_ll = (*env)->GetPrimitiveArrayCritical(env, z, NULL);
  ldz_l = (*env)->GetPrimitiveArrayCritical(env, ldz, NULL);
  ldz_ls = (*env)->GetArrayLength(env, ldz);
  ldz_ll = malloc(sizeof(integer)*ldz_ls);
  for (i_loc=0; i_loc<ldz_ls; ++i_loc) ldz_ll[i_loc] = ldz_l[i_loc];
  work_ll = (*env)->GetPrimitiveArrayCritical(env, work, NULL);
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dspev_(jobz_ll, uplo_ll, n_ll, ap_ll, w_ll, z_ll, ldz_ll, work_ll, info_ll);

  for (i_loc=0; i_loc<jobz_ls; ++i_loc) jobz_l[i_loc] = jobz_ll[i_loc];
  free(jobz_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, jobz, jobz_l, 0);
  for (i_loc=0; i_loc<uplo_ls; ++i_loc) uplo_l[i_loc] = uplo_ll[i_loc];
  free(uplo_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, uplo, uplo_l, 0);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, ap, ap_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, w, w_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, z, z_ll, 0);
  for (i_loc=0; i_loc<ldz_ls; ++i_loc) ldz_l[i_loc] = ldz_ll[i_loc];
  free(ldz_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldz, ldz_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, work, work_ll, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_spevd
(JNIEnv *env, jclass clazz, jcharArray jobz, jcharArray uplo, jintArray n, jdoubleArray ap, jdoubleArray w, jdoubleArray z, jintArray ldz, jdoubleArray work, jintArray lwork, jintArray iwork, jintArray liwork, jintArray info) {
  int i_loc;
  jchar* jobz_l;
  char* jobz_ll;
  jsize jobz_ls;
  jchar* uplo_l;
  char* uplo_ll;
  jsize uplo_ls;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jdouble* ap_ll;
  jdouble* w_ll;
  jdouble* z_ll;
  jint* ldz_l;
  integer* ldz_ll;
  jsize ldz_ls;
  jdouble* work_ll;
  jint* lwork_l;
  integer* lwork_ll;
  jsize lwork_ls;
  jint* iwork_l;
  integer* iwork_ll;
  jsize iwork_ls;
  jint* liwork_l;
  integer* liwork_ll;
  jsize liwork_ls;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  jobz_l = (*env)->GetPrimitiveArrayCritical(env, jobz, NULL);
  jobz_ls = (*env)->GetArrayLength(env, jobz);
  jobz_ll = malloc(sizeof(char)*jobz_ls);
  for (i_loc=0; i_loc<jobz_ls; ++i_loc) jobz_ll[i_loc] = jobz_l[i_loc];
  uplo_l = (*env)->GetPrimitiveArrayCritical(env, uplo, NULL);
  uplo_ls = (*env)->GetArrayLength(env, uplo);
  uplo_ll = malloc(sizeof(char)*uplo_ls);
  for (i_loc=0; i_loc<uplo_ls; ++i_loc) uplo_ll[i_loc] = uplo_l[i_loc];
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  ap_ll = (*env)->GetPrimitiveArrayCritical(env, ap, NULL);
  w_ll = (*env)->GetPrimitiveArrayCritical(env, w, NULL);
  z_ll = (*env)->GetPrimitiveArrayCritical(env, z, NULL);
  ldz_l = (*env)->GetPrimitiveArrayCritical(env, ldz, NULL);
  ldz_ls = (*env)->GetArrayLength(env, ldz);
  ldz_ll = malloc(sizeof(integer)*ldz_ls);
  for (i_loc=0; i_loc<ldz_ls; ++i_loc) ldz_ll[i_loc] = ldz_l[i_loc];
  work_ll = (*env)->GetPrimitiveArrayCritical(env, work, NULL);
  lwork_l = (*env)->GetPrimitiveArrayCritical(env, lwork, NULL);
  lwork_ls = (*env)->GetArrayLength(env, lwork);
  lwork_ll = malloc(sizeof(integer)*lwork_ls);
  for (i_loc=0; i_loc<lwork_ls; ++i_loc) lwork_ll[i_loc] = lwork_l[i_loc];
  iwork_l = (*env)->GetPrimitiveArrayCritical(env, iwork, NULL);
  iwork_ls = (*env)->GetArrayLength(env, iwork);
  iwork_ll = malloc(sizeof(integer)*iwork_ls);
  for (i_loc=0; i_loc<iwork_ls; ++i_loc) iwork_ll[i_loc] = iwork_l[i_loc];
  liwork_l = (*env)->GetPrimitiveArrayCritical(env, liwork, NULL);
  liwork_ls = (*env)->GetArrayLength(env, liwork);
  liwork_ll = malloc(sizeof(integer)*liwork_ls);
  for (i_loc=0; i_loc<liwork_ls; ++i_loc) liwork_ll[i_loc] = liwork_l[i_loc];
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dspevd_(jobz_ll, uplo_ll, n_ll, ap_ll, w_ll, z_ll, ldz_ll, work_ll, lwork_ll, iwork_ll, liwork_ll, info_ll);

  for (i_loc=0; i_loc<jobz_ls; ++i_loc) jobz_l[i_loc] = jobz_ll[i_loc];
  free(jobz_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, jobz, jobz_l, 0);
  for (i_loc=0; i_loc<uplo_ls; ++i_loc) uplo_l[i_loc] = uplo_ll[i_loc];
  free(uplo_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, uplo, uplo_l, 0);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, ap, ap_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, w, w_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, z, z_ll, 0);
  for (i_loc=0; i_loc<ldz_ls; ++i_loc) ldz_l[i_loc] = ldz_ll[i_loc];
  free(ldz_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldz, ldz_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, work, work_ll, 0);
  for (i_loc=0; i_loc<lwork_ls; ++i_loc) lwork_l[i_loc] = lwork_ll[i_loc];
  free(lwork_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, lwork, lwork_l, 0);
  for (i_loc=0; i_loc<iwork_ls; ++i_loc) iwork_l[i_loc] = iwork_ll[i_loc];
  free(iwork_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, iwork, iwork_l, 0);
  for (i_loc=0; i_loc<liwork_ls; ++i_loc) liwork_l[i_loc] = liwork_ll[i_loc];
  free(liwork_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, liwork, liwork_l, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_spevx
(JNIEnv *env, jclass clazz, jcharArray jobz, jcharArray range, jcharArray uplo, jintArray n, jdoubleArray ap, jdoubleArray vl, jdoubleArray vu, jintArray il, jintArray iu, jdoubleArray abstol, jintArray m, jdoubleArray w, jdoubleArray z, jintArray ldz, jdoubleArray work, jintArray iwork, jintArray ifail, jintArray info) {
  int i_loc;
  jchar* jobz_l;
  char* jobz_ll;
  jsize jobz_ls;
  jchar* range_l;
  char* range_ll;
  jsize range_ls;
  jchar* uplo_l;
  char* uplo_ll;
  jsize uplo_ls;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jdouble* ap_ll;
  jdouble* vl_ll;
  jdouble* vu_ll;
  jint* il_l;
  integer* il_ll;
  jsize il_ls;
  jint* iu_l;
  integer* iu_ll;
  jsize iu_ls;
  jdouble* abstol_ll;
  jint* m_l;
  integer* m_ll;
  jsize m_ls;
  jdouble* w_ll;
  jdouble* z_ll;
  jint* ldz_l;
  integer* ldz_ll;
  jsize ldz_ls;
  jdouble* work_ll;
  jint* iwork_l;
  integer* iwork_ll;
  jsize iwork_ls;
  jint* ifail_l;
  integer* ifail_ll;
  jsize ifail_ls;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  jobz_l = (*env)->GetPrimitiveArrayCritical(env, jobz, NULL);
  jobz_ls = (*env)->GetArrayLength(env, jobz);
  jobz_ll = malloc(sizeof(char)*jobz_ls);
  for (i_loc=0; i_loc<jobz_ls; ++i_loc) jobz_ll[i_loc] = jobz_l[i_loc];
  range_l = (*env)->GetPrimitiveArrayCritical(env, range, NULL);
  range_ls = (*env)->GetArrayLength(env, range);
  range_ll = malloc(sizeof(char)*range_ls);
  for (i_loc=0; i_loc<range_ls; ++i_loc) range_ll[i_loc] = range_l[i_loc];
  uplo_l = (*env)->GetPrimitiveArrayCritical(env, uplo, NULL);
  uplo_ls = (*env)->GetArrayLength(env, uplo);
  uplo_ll = malloc(sizeof(char)*uplo_ls);
  for (i_loc=0; i_loc<uplo_ls; ++i_loc) uplo_ll[i_loc] = uplo_l[i_loc];
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  ap_ll = (*env)->GetPrimitiveArrayCritical(env, ap, NULL);
  vl_ll = (*env)->GetPrimitiveArrayCritical(env, vl, NULL);
  vu_ll = (*env)->GetPrimitiveArrayCritical(env, vu, NULL);
  il_l = (*env)->GetPrimitiveArrayCritical(env, il, NULL);
  il_ls = (*env)->GetArrayLength(env, il);
  il_ll = malloc(sizeof(integer)*il_ls);
  for (i_loc=0; i_loc<il_ls; ++i_loc) il_ll[i_loc] = il_l[i_loc];
  iu_l = (*env)->GetPrimitiveArrayCritical(env, iu, NULL);
  iu_ls = (*env)->GetArrayLength(env, iu);
  iu_ll = malloc(sizeof(integer)*iu_ls);
  for (i_loc=0; i_loc<iu_ls; ++i_loc) iu_ll[i_loc] = iu_l[i_loc];
  abstol_ll = (*env)->GetPrimitiveArrayCritical(env, abstol, NULL);
  m_l = (*env)->GetPrimitiveArrayCritical(env, m, NULL);
  m_ls = (*env)->GetArrayLength(env, m);
  m_ll = malloc(sizeof(integer)*m_ls);
  for (i_loc=0; i_loc<m_ls; ++i_loc) m_ll[i_loc] = m_l[i_loc];
  w_ll = (*env)->GetPrimitiveArrayCritical(env, w, NULL);
  z_ll = (*env)->GetPrimitiveArrayCritical(env, z, NULL);
  ldz_l = (*env)->GetPrimitiveArrayCritical(env, ldz, NULL);
  ldz_ls = (*env)->GetArrayLength(env, ldz);
  ldz_ll = malloc(sizeof(integer)*ldz_ls);
  for (i_loc=0; i_loc<ldz_ls; ++i_loc) ldz_ll[i_loc] = ldz_l[i_loc];
  work_ll = (*env)->GetPrimitiveArrayCritical(env, work, NULL);
  iwork_l = (*env)->GetPrimitiveArrayCritical(env, iwork, NULL);
  iwork_ls = (*env)->GetArrayLength(env, iwork);
  iwork_ll = malloc(sizeof(integer)*iwork_ls);
  for (i_loc=0; i_loc<iwork_ls; ++i_loc) iwork_ll[i_loc] = iwork_l[i_loc];
  ifail_l = (*env)->GetPrimitiveArrayCritical(env, ifail, NULL);
  ifail_ls = (*env)->GetArrayLength(env, ifail);
  ifail_ll = malloc(sizeof(integer)*ifail_ls);
  for (i_loc=0; i_loc<ifail_ls; ++i_loc) ifail_ll[i_loc] = ifail_l[i_loc];
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dspevx_(jobz_ll, range_ll, uplo_ll, n_ll, ap_ll, vl_ll, vu_ll, il_ll, iu_ll, abstol_ll, m_ll, w_ll, z_ll, ldz_ll, work_ll, iwork_ll, ifail_ll, info_ll);

  for (i_loc=0; i_loc<jobz_ls; ++i_loc) jobz_l[i_loc] = jobz_ll[i_loc];
  free(jobz_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, jobz, jobz_l, 0);
  for (i_loc=0; i_loc<range_ls; ++i_loc) range_l[i_loc] = range_ll[i_loc];
  free(range_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, range, range_l, 0);
  for (i_loc=0; i_loc<uplo_ls; ++i_loc) uplo_l[i_loc] = uplo_ll[i_loc];
  free(uplo_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, uplo, uplo_l, 0);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, ap, ap_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, vl, vl_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, vu, vu_ll, 0);
  for (i_loc=0; i_loc<il_ls; ++i_loc) il_l[i_loc] = il_ll[i_loc];
  free(il_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, il, il_l, 0);
  for (i_loc=0; i_loc<iu_ls; ++i_loc) iu_l[i_loc] = iu_ll[i_loc];
  free(iu_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, iu, iu_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, abstol, abstol_ll, 0);
  for (i_loc=0; i_loc<m_ls; ++i_loc) m_l[i_loc] = m_ll[i_loc];
  free(m_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, m, m_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, w, w_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, z, z_ll, 0);
  for (i_loc=0; i_loc<ldz_ls; ++i_loc) ldz_l[i_loc] = ldz_ll[i_loc];
  free(ldz_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldz, ldz_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, work, work_ll, 0);
  for (i_loc=0; i_loc<iwork_ls; ++i_loc) iwork_l[i_loc] = iwork_ll[i_loc];
  free(iwork_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, iwork, iwork_l, 0);
  for (i_loc=0; i_loc<ifail_ls; ++i_loc) ifail_l[i_loc] = ifail_ll[i_loc];
  free(ifail_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ifail, ifail_l, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_spgst
(JNIEnv *env, jclass clazz, jintArray itype, jcharArray uplo, jintArray n, jdoubleArray ap, jdoubleArray bp, jintArray info) {
  int i_loc;
  jint* itype_l;
  integer* itype_ll;
  jsize itype_ls;
  jchar* uplo_l;
  char* uplo_ll;
  jsize uplo_ls;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jdouble* ap_ll;
  jdouble* bp_ll;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  itype_l = (*env)->GetPrimitiveArrayCritical(env, itype, NULL);
  itype_ls = (*env)->GetArrayLength(env, itype);
  itype_ll = malloc(sizeof(integer)*itype_ls);
  for (i_loc=0; i_loc<itype_ls; ++i_loc) itype_ll[i_loc] = itype_l[i_loc];
  uplo_l = (*env)->GetPrimitiveArrayCritical(env, uplo, NULL);
  uplo_ls = (*env)->GetArrayLength(env, uplo);
  uplo_ll = malloc(sizeof(char)*uplo_ls);
  for (i_loc=0; i_loc<uplo_ls; ++i_loc) uplo_ll[i_loc] = uplo_l[i_loc];
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  ap_ll = (*env)->GetPrimitiveArrayCritical(env, ap, NULL);
  bp_ll = (*env)->GetPrimitiveArrayCritical(env, bp, NULL);
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dspgst_(itype_ll, uplo_ll, n_ll, ap_ll, bp_ll, info_ll);

  for (i_loc=0; i_loc<itype_ls; ++i_loc) itype_l[i_loc] = itype_ll[i_loc];
  free(itype_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, itype, itype_l, 0);
  for (i_loc=0; i_loc<uplo_ls; ++i_loc) uplo_l[i_loc] = uplo_ll[i_loc];
  free(uplo_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, uplo, uplo_l, 0);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, ap, ap_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, bp, bp_ll, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_spgv
(JNIEnv *env, jclass clazz, jintArray itype, jcharArray jobz, jcharArray uplo, jintArray n, jdoubleArray ap, jdoubleArray bp, jdoubleArray w, jdoubleArray z, jintArray ldz, jdoubleArray work, jintArray info) {
  int i_loc;
  jint* itype_l;
  integer* itype_ll;
  jsize itype_ls;
  jchar* jobz_l;
  char* jobz_ll;
  jsize jobz_ls;
  jchar* uplo_l;
  char* uplo_ll;
  jsize uplo_ls;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jdouble* ap_ll;
  jdouble* bp_ll;
  jdouble* w_ll;
  jdouble* z_ll;
  jint* ldz_l;
  integer* ldz_ll;
  jsize ldz_ls;
  jdouble* work_ll;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  itype_l = (*env)->GetPrimitiveArrayCritical(env, itype, NULL);
  itype_ls = (*env)->GetArrayLength(env, itype);
  itype_ll = malloc(sizeof(integer)*itype_ls);
  for (i_loc=0; i_loc<itype_ls; ++i_loc) itype_ll[i_loc] = itype_l[i_loc];
  jobz_l = (*env)->GetPrimitiveArrayCritical(env, jobz, NULL);
  jobz_ls = (*env)->GetArrayLength(env, jobz);
  jobz_ll = malloc(sizeof(char)*jobz_ls);
  for (i_loc=0; i_loc<jobz_ls; ++i_loc) jobz_ll[i_loc] = jobz_l[i_loc];
  uplo_l = (*env)->GetPrimitiveArrayCritical(env, uplo, NULL);
  uplo_ls = (*env)->GetArrayLength(env, uplo);
  uplo_ll = malloc(sizeof(char)*uplo_ls);
  for (i_loc=0; i_loc<uplo_ls; ++i_loc) uplo_ll[i_loc] = uplo_l[i_loc];
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  ap_ll = (*env)->GetPrimitiveArrayCritical(env, ap, NULL);
  bp_ll = (*env)->GetPrimitiveArrayCritical(env, bp, NULL);
  w_ll = (*env)->GetPrimitiveArrayCritical(env, w, NULL);
  z_ll = (*env)->GetPrimitiveArrayCritical(env, z, NULL);
  ldz_l = (*env)->GetPrimitiveArrayCritical(env, ldz, NULL);
  ldz_ls = (*env)->GetArrayLength(env, ldz);
  ldz_ll = malloc(sizeof(integer)*ldz_ls);
  for (i_loc=0; i_loc<ldz_ls; ++i_loc) ldz_ll[i_loc] = ldz_l[i_loc];
  work_ll = (*env)->GetPrimitiveArrayCritical(env, work, NULL);
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dspgv_(itype_ll, jobz_ll, uplo_ll, n_ll, ap_ll, bp_ll, w_ll, z_ll, ldz_ll, work_ll, info_ll);

  for (i_loc=0; i_loc<itype_ls; ++i_loc) itype_l[i_loc] = itype_ll[i_loc];
  free(itype_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, itype, itype_l, 0);
  for (i_loc=0; i_loc<jobz_ls; ++i_loc) jobz_l[i_loc] = jobz_ll[i_loc];
  free(jobz_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, jobz, jobz_l, 0);
  for (i_loc=0; i_loc<uplo_ls; ++i_loc) uplo_l[i_loc] = uplo_ll[i_loc];
  free(uplo_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, uplo, uplo_l, 0);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, ap, ap_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, bp, bp_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, w, w_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, z, z_ll, 0);
  for (i_loc=0; i_loc<ldz_ls; ++i_loc) ldz_l[i_loc] = ldz_ll[i_loc];
  free(ldz_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldz, ldz_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, work, work_ll, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_spgvd
(JNIEnv *env, jclass clazz, jintArray itype, jcharArray jobz, jcharArray uplo, jintArray n, jdoubleArray ap, jdoubleArray bp, jdoubleArray w, jdoubleArray z, jintArray ldz, jdoubleArray work, jintArray lwork, jintArray iwork, jintArray liwork, jintArray info) {
  int i_loc;
  jint* itype_l;
  integer* itype_ll;
  jsize itype_ls;
  jchar* jobz_l;
  char* jobz_ll;
  jsize jobz_ls;
  jchar* uplo_l;
  char* uplo_ll;
  jsize uplo_ls;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jdouble* ap_ll;
  jdouble* bp_ll;
  jdouble* w_ll;
  jdouble* z_ll;
  jint* ldz_l;
  integer* ldz_ll;
  jsize ldz_ls;
  jdouble* work_ll;
  jint* lwork_l;
  integer* lwork_ll;
  jsize lwork_ls;
  jint* iwork_l;
  integer* iwork_ll;
  jsize iwork_ls;
  jint* liwork_l;
  integer* liwork_ll;
  jsize liwork_ls;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  itype_l = (*env)->GetPrimitiveArrayCritical(env, itype, NULL);
  itype_ls = (*env)->GetArrayLength(env, itype);
  itype_ll = malloc(sizeof(integer)*itype_ls);
  for (i_loc=0; i_loc<itype_ls; ++i_loc) itype_ll[i_loc] = itype_l[i_loc];
  jobz_l = (*env)->GetPrimitiveArrayCritical(env, jobz, NULL);
  jobz_ls = (*env)->GetArrayLength(env, jobz);
  jobz_ll = malloc(sizeof(char)*jobz_ls);
  for (i_loc=0; i_loc<jobz_ls; ++i_loc) jobz_ll[i_loc] = jobz_l[i_loc];
  uplo_l = (*env)->GetPrimitiveArrayCritical(env, uplo, NULL);
  uplo_ls = (*env)->GetArrayLength(env, uplo);
  uplo_ll = malloc(sizeof(char)*uplo_ls);
  for (i_loc=0; i_loc<uplo_ls; ++i_loc) uplo_ll[i_loc] = uplo_l[i_loc];
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  ap_ll = (*env)->GetPrimitiveArrayCritical(env, ap, NULL);
  bp_ll = (*env)->GetPrimitiveArrayCritical(env, bp, NULL);
  w_ll = (*env)->GetPrimitiveArrayCritical(env, w, NULL);
  z_ll = (*env)->GetPrimitiveArrayCritical(env, z, NULL);
  ldz_l = (*env)->GetPrimitiveArrayCritical(env, ldz, NULL);
  ldz_ls = (*env)->GetArrayLength(env, ldz);
  ldz_ll = malloc(sizeof(integer)*ldz_ls);
  for (i_loc=0; i_loc<ldz_ls; ++i_loc) ldz_ll[i_loc] = ldz_l[i_loc];
  work_ll = (*env)->GetPrimitiveArrayCritical(env, work, NULL);
  lwork_l = (*env)->GetPrimitiveArrayCritical(env, lwork, NULL);
  lwork_ls = (*env)->GetArrayLength(env, lwork);
  lwork_ll = malloc(sizeof(integer)*lwork_ls);
  for (i_loc=0; i_loc<lwork_ls; ++i_loc) lwork_ll[i_loc] = lwork_l[i_loc];
  iwork_l = (*env)->GetPrimitiveArrayCritical(env, iwork, NULL);
  iwork_ls = (*env)->GetArrayLength(env, iwork);
  iwork_ll = malloc(sizeof(integer)*iwork_ls);
  for (i_loc=0; i_loc<iwork_ls; ++i_loc) iwork_ll[i_loc] = iwork_l[i_loc];
  liwork_l = (*env)->GetPrimitiveArrayCritical(env, liwork, NULL);
  liwork_ls = (*env)->GetArrayLength(env, liwork);
  liwork_ll = malloc(sizeof(integer)*liwork_ls);
  for (i_loc=0; i_loc<liwork_ls; ++i_loc) liwork_ll[i_loc] = liwork_l[i_loc];
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dspgvd_(itype_ll, jobz_ll, uplo_ll, n_ll, ap_ll, bp_ll, w_ll, z_ll, ldz_ll, work_ll, lwork_ll, iwork_ll, liwork_ll, info_ll);

  for (i_loc=0; i_loc<itype_ls; ++i_loc) itype_l[i_loc] = itype_ll[i_loc];
  free(itype_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, itype, itype_l, 0);
  for (i_loc=0; i_loc<jobz_ls; ++i_loc) jobz_l[i_loc] = jobz_ll[i_loc];
  free(jobz_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, jobz, jobz_l, 0);
  for (i_loc=0; i_loc<uplo_ls; ++i_loc) uplo_l[i_loc] = uplo_ll[i_loc];
  free(uplo_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, uplo, uplo_l, 0);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, ap, ap_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, bp, bp_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, w, w_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, z, z_ll, 0);
  for (i_loc=0; i_loc<ldz_ls; ++i_loc) ldz_l[i_loc] = ldz_ll[i_loc];
  free(ldz_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldz, ldz_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, work, work_ll, 0);
  for (i_loc=0; i_loc<lwork_ls; ++i_loc) lwork_l[i_loc] = lwork_ll[i_loc];
  free(lwork_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, lwork, lwork_l, 0);
  for (i_loc=0; i_loc<iwork_ls; ++i_loc) iwork_l[i_loc] = iwork_ll[i_loc];
  free(iwork_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, iwork, iwork_l, 0);
  for (i_loc=0; i_loc<liwork_ls; ++i_loc) liwork_l[i_loc] = liwork_ll[i_loc];
  free(liwork_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, liwork, liwork_l, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_spgvx
(JNIEnv *env, jclass clazz, jintArray itype, jcharArray jobz, jcharArray range, jcharArray uplo, jintArray n, jdoubleArray ap, jdoubleArray bp, jdoubleArray vl, jdoubleArray vu, jintArray il, jintArray iu, jdoubleArray abstol, jintArray m, jdoubleArray w, jdoubleArray z, jintArray ldz, jdoubleArray work, jintArray iwork, jintArray ifail, jintArray info) {
  int i_loc;
  jint* itype_l;
  integer* itype_ll;
  jsize itype_ls;
  jchar* jobz_l;
  char* jobz_ll;
  jsize jobz_ls;
  jchar* range_l;
  char* range_ll;
  jsize range_ls;
  jchar* uplo_l;
  char* uplo_ll;
  jsize uplo_ls;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jdouble* ap_ll;
  jdouble* bp_ll;
  jdouble* vl_ll;
  jdouble* vu_ll;
  jint* il_l;
  integer* il_ll;
  jsize il_ls;
  jint* iu_l;
  integer* iu_ll;
  jsize iu_ls;
  jdouble* abstol_ll;
  jint* m_l;
  integer* m_ll;
  jsize m_ls;
  jdouble* w_ll;
  jdouble* z_ll;
  jint* ldz_l;
  integer* ldz_ll;
  jsize ldz_ls;
  jdouble* work_ll;
  jint* iwork_l;
  integer* iwork_ll;
  jsize iwork_ls;
  jint* ifail_l;
  integer* ifail_ll;
  jsize ifail_ls;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  itype_l = (*env)->GetPrimitiveArrayCritical(env, itype, NULL);
  itype_ls = (*env)->GetArrayLength(env, itype);
  itype_ll = malloc(sizeof(integer)*itype_ls);
  for (i_loc=0; i_loc<itype_ls; ++i_loc) itype_ll[i_loc] = itype_l[i_loc];
  jobz_l = (*env)->GetPrimitiveArrayCritical(env, jobz, NULL);
  jobz_ls = (*env)->GetArrayLength(env, jobz);
  jobz_ll = malloc(sizeof(char)*jobz_ls);
  for (i_loc=0; i_loc<jobz_ls; ++i_loc) jobz_ll[i_loc] = jobz_l[i_loc];
  range_l = (*env)->GetPrimitiveArrayCritical(env, range, NULL);
  range_ls = (*env)->GetArrayLength(env, range);
  range_ll = malloc(sizeof(char)*range_ls);
  for (i_loc=0; i_loc<range_ls; ++i_loc) range_ll[i_loc] = range_l[i_loc];
  uplo_l = (*env)->GetPrimitiveArrayCritical(env, uplo, NULL);
  uplo_ls = (*env)->GetArrayLength(env, uplo);
  uplo_ll = malloc(sizeof(char)*uplo_ls);
  for (i_loc=0; i_loc<uplo_ls; ++i_loc) uplo_ll[i_loc] = uplo_l[i_loc];
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  ap_ll = (*env)->GetPrimitiveArrayCritical(env, ap, NULL);
  bp_ll = (*env)->GetPrimitiveArrayCritical(env, bp, NULL);
  vl_ll = (*env)->GetPrimitiveArrayCritical(env, vl, NULL);
  vu_ll = (*env)->GetPrimitiveArrayCritical(env, vu, NULL);
  il_l = (*env)->GetPrimitiveArrayCritical(env, il, NULL);
  il_ls = (*env)->GetArrayLength(env, il);
  il_ll = malloc(sizeof(integer)*il_ls);
  for (i_loc=0; i_loc<il_ls; ++i_loc) il_ll[i_loc] = il_l[i_loc];
  iu_l = (*env)->GetPrimitiveArrayCritical(env, iu, NULL);
  iu_ls = (*env)->GetArrayLength(env, iu);
  iu_ll = malloc(sizeof(integer)*iu_ls);
  for (i_loc=0; i_loc<iu_ls; ++i_loc) iu_ll[i_loc] = iu_l[i_loc];
  abstol_ll = (*env)->GetPrimitiveArrayCritical(env, abstol, NULL);
  m_l = (*env)->GetPrimitiveArrayCritical(env, m, NULL);
  m_ls = (*env)->GetArrayLength(env, m);
  m_ll = malloc(sizeof(integer)*m_ls);
  for (i_loc=0; i_loc<m_ls; ++i_loc) m_ll[i_loc] = m_l[i_loc];
  w_ll = (*env)->GetPrimitiveArrayCritical(env, w, NULL);
  z_ll = (*env)->GetPrimitiveArrayCritical(env, z, NULL);
  ldz_l = (*env)->GetPrimitiveArrayCritical(env, ldz, NULL);
  ldz_ls = (*env)->GetArrayLength(env, ldz);
  ldz_ll = malloc(sizeof(integer)*ldz_ls);
  for (i_loc=0; i_loc<ldz_ls; ++i_loc) ldz_ll[i_loc] = ldz_l[i_loc];
  work_ll = (*env)->GetPrimitiveArrayCritical(env, work, NULL);
  iwork_l = (*env)->GetPrimitiveArrayCritical(env, iwork, NULL);
  iwork_ls = (*env)->GetArrayLength(env, iwork);
  iwork_ll = malloc(sizeof(integer)*iwork_ls);
  for (i_loc=0; i_loc<iwork_ls; ++i_loc) iwork_ll[i_loc] = iwork_l[i_loc];
  ifail_l = (*env)->GetPrimitiveArrayCritical(env, ifail, NULL);
  ifail_ls = (*env)->GetArrayLength(env, ifail);
  ifail_ll = malloc(sizeof(integer)*ifail_ls);
  for (i_loc=0; i_loc<ifail_ls; ++i_loc) ifail_ll[i_loc] = ifail_l[i_loc];
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dspgvx_(itype_ll, jobz_ll, range_ll, uplo_ll, n_ll, ap_ll, bp_ll, vl_ll, vu_ll, il_ll, iu_ll, abstol_ll, m_ll, w_ll, z_ll, ldz_ll, work_ll, iwork_ll, ifail_ll, info_ll);

  for (i_loc=0; i_loc<itype_ls; ++i_loc) itype_l[i_loc] = itype_ll[i_loc];
  free(itype_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, itype, itype_l, 0);
  for (i_loc=0; i_loc<jobz_ls; ++i_loc) jobz_l[i_loc] = jobz_ll[i_loc];
  free(jobz_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, jobz, jobz_l, 0);
  for (i_loc=0; i_loc<range_ls; ++i_loc) range_l[i_loc] = range_ll[i_loc];
  free(range_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, range, range_l, 0);
  for (i_loc=0; i_loc<uplo_ls; ++i_loc) uplo_l[i_loc] = uplo_ll[i_loc];
  free(uplo_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, uplo, uplo_l, 0);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, ap, ap_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, bp, bp_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, vl, vl_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, vu, vu_ll, 0);
  for (i_loc=0; i_loc<il_ls; ++i_loc) il_l[i_loc] = il_ll[i_loc];
  free(il_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, il, il_l, 0);
  for (i_loc=0; i_loc<iu_ls; ++i_loc) iu_l[i_loc] = iu_ll[i_loc];
  free(iu_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, iu, iu_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, abstol, abstol_ll, 0);
  for (i_loc=0; i_loc<m_ls; ++i_loc) m_l[i_loc] = m_ll[i_loc];
  free(m_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, m, m_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, w, w_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, z, z_ll, 0);
  for (i_loc=0; i_loc<ldz_ls; ++i_loc) ldz_l[i_loc] = ldz_ll[i_loc];
  free(ldz_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldz, ldz_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, work, work_ll, 0);
  for (i_loc=0; i_loc<iwork_ls; ++i_loc) iwork_l[i_loc] = iwork_ll[i_loc];
  free(iwork_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, iwork, iwork_l, 0);
  for (i_loc=0; i_loc<ifail_ls; ++i_loc) ifail_l[i_loc] = ifail_ll[i_loc];
  free(ifail_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ifail, ifail_l, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_sprfs
(JNIEnv *env, jclass clazz, jcharArray uplo, jintArray n, jintArray nrhs, jdoubleArray ap, jdoubleArray afp, jintArray ipiv, jdoubleArray b, jintArray ldb, jdoubleArray x, jintArray ldx, jdoubleArray ferr, jdoubleArray berr, jdoubleArray work, jintArray iwork, jintArray info) {
  int i_loc;
  jchar* uplo_l;
  char* uplo_ll;
  jsize uplo_ls;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jint* nrhs_l;
  integer* nrhs_ll;
  jsize nrhs_ls;
  jdouble* ap_ll;
  jdouble* afp_ll;
  jint* ipiv_l;
  integer* ipiv_ll;
  jsize ipiv_ls;
  jdouble* b_ll;
  jint* ldb_l;
  integer* ldb_ll;
  jsize ldb_ls;
  jdouble* x_ll;
  jint* ldx_l;
  integer* ldx_ll;
  jsize ldx_ls;
  jdouble* ferr_ll;
  jdouble* berr_ll;
  jdouble* work_ll;
  jint* iwork_l;
  integer* iwork_ll;
  jsize iwork_ls;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  uplo_l = (*env)->GetPrimitiveArrayCritical(env, uplo, NULL);
  uplo_ls = (*env)->GetArrayLength(env, uplo);
  uplo_ll = malloc(sizeof(char)*uplo_ls);
  for (i_loc=0; i_loc<uplo_ls; ++i_loc) uplo_ll[i_loc] = uplo_l[i_loc];
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  nrhs_l = (*env)->GetPrimitiveArrayCritical(env, nrhs, NULL);
  nrhs_ls = (*env)->GetArrayLength(env, nrhs);
  nrhs_ll = malloc(sizeof(integer)*nrhs_ls);
  for (i_loc=0; i_loc<nrhs_ls; ++i_loc) nrhs_ll[i_loc] = nrhs_l[i_loc];
  ap_ll = (*env)->GetPrimitiveArrayCritical(env, ap, NULL);
  afp_ll = (*env)->GetPrimitiveArrayCritical(env, afp, NULL);
  ipiv_l = (*env)->GetPrimitiveArrayCritical(env, ipiv, NULL);
  ipiv_ls = (*env)->GetArrayLength(env, ipiv);
  ipiv_ll = malloc(sizeof(integer)*ipiv_ls);
  for (i_loc=0; i_loc<ipiv_ls; ++i_loc) ipiv_ll[i_loc] = ipiv_l[i_loc];
  b_ll = (*env)->GetPrimitiveArrayCritical(env, b, NULL);
  ldb_l = (*env)->GetPrimitiveArrayCritical(env, ldb, NULL);
  ldb_ls = (*env)->GetArrayLength(env, ldb);
  ldb_ll = malloc(sizeof(integer)*ldb_ls);
  for (i_loc=0; i_loc<ldb_ls; ++i_loc) ldb_ll[i_loc] = ldb_l[i_loc];
  x_ll = (*env)->GetPrimitiveArrayCritical(env, x, NULL);
  ldx_l = (*env)->GetPrimitiveArrayCritical(env, ldx, NULL);
  ldx_ls = (*env)->GetArrayLength(env, ldx);
  ldx_ll = malloc(sizeof(integer)*ldx_ls);
  for (i_loc=0; i_loc<ldx_ls; ++i_loc) ldx_ll[i_loc] = ldx_l[i_loc];
  ferr_ll = (*env)->GetPrimitiveArrayCritical(env, ferr, NULL);
  berr_ll = (*env)->GetPrimitiveArrayCritical(env, berr, NULL);
  work_ll = (*env)->GetPrimitiveArrayCritical(env, work, NULL);
  iwork_l = (*env)->GetPrimitiveArrayCritical(env, iwork, NULL);
  iwork_ls = (*env)->GetArrayLength(env, iwork);
  iwork_ll = malloc(sizeof(integer)*iwork_ls);
  for (i_loc=0; i_loc<iwork_ls; ++i_loc) iwork_ll[i_loc] = iwork_l[i_loc];
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dsprfs_(uplo_ll, n_ll, nrhs_ll, ap_ll, afp_ll, ipiv_ll, b_ll, ldb_ll, x_ll, ldx_ll, ferr_ll, berr_ll, work_ll, iwork_ll, info_ll);

  for (i_loc=0; i_loc<uplo_ls; ++i_loc) uplo_l[i_loc] = uplo_ll[i_loc];
  free(uplo_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, uplo, uplo_l, 0);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  for (i_loc=0; i_loc<nrhs_ls; ++i_loc) nrhs_l[i_loc] = nrhs_ll[i_loc];
  free(nrhs_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, nrhs, nrhs_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, ap, ap_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, afp, afp_ll, 0);
  for (i_loc=0; i_loc<ipiv_ls; ++i_loc) ipiv_l[i_loc] = ipiv_ll[i_loc];
  free(ipiv_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ipiv, ipiv_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, b, b_ll, 0);
  for (i_loc=0; i_loc<ldb_ls; ++i_loc) ldb_l[i_loc] = ldb_ll[i_loc];
  free(ldb_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldb, ldb_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, x, x_ll, 0);
  for (i_loc=0; i_loc<ldx_ls; ++i_loc) ldx_l[i_loc] = ldx_ll[i_loc];
  free(ldx_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldx, ldx_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, ferr, ferr_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, berr, berr_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, work, work_ll, 0);
  for (i_loc=0; i_loc<iwork_ls; ++i_loc) iwork_l[i_loc] = iwork_ll[i_loc];
  free(iwork_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, iwork, iwork_l, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_spsv
(JNIEnv *env, jclass clazz, jcharArray uplo, jintArray n, jintArray nrhs, jdoubleArray ap, jintArray ipiv, jdoubleArray b, jintArray ldb, jintArray info) {
  int i_loc;
  jchar* uplo_l;
  char* uplo_ll;
  jsize uplo_ls;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jint* nrhs_l;
  integer* nrhs_ll;
  jsize nrhs_ls;
  jdouble* ap_ll;
  jint* ipiv_l;
  integer* ipiv_ll;
  jsize ipiv_ls;
  jdouble* b_ll;
  jint* ldb_l;
  integer* ldb_ll;
  jsize ldb_ls;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  uplo_l = (*env)->GetPrimitiveArrayCritical(env, uplo, NULL);
  uplo_ls = (*env)->GetArrayLength(env, uplo);
  uplo_ll = malloc(sizeof(char)*uplo_ls);
  for (i_loc=0; i_loc<uplo_ls; ++i_loc) uplo_ll[i_loc] = uplo_l[i_loc];
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  nrhs_l = (*env)->GetPrimitiveArrayCritical(env, nrhs, NULL);
  nrhs_ls = (*env)->GetArrayLength(env, nrhs);
  nrhs_ll = malloc(sizeof(integer)*nrhs_ls);
  for (i_loc=0; i_loc<nrhs_ls; ++i_loc) nrhs_ll[i_loc] = nrhs_l[i_loc];
  ap_ll = (*env)->GetPrimitiveArrayCritical(env, ap, NULL);
  ipiv_l = (*env)->GetPrimitiveArrayCritical(env, ipiv, NULL);
  ipiv_ls = (*env)->GetArrayLength(env, ipiv);
  ipiv_ll = malloc(sizeof(integer)*ipiv_ls);
  for (i_loc=0; i_loc<ipiv_ls; ++i_loc) ipiv_ll[i_loc] = ipiv_l[i_loc];
  b_ll = (*env)->GetPrimitiveArrayCritical(env, b, NULL);
  ldb_l = (*env)->GetPrimitiveArrayCritical(env, ldb, NULL);
  ldb_ls = (*env)->GetArrayLength(env, ldb);
  ldb_ll = malloc(sizeof(integer)*ldb_ls);
  for (i_loc=0; i_loc<ldb_ls; ++i_loc) ldb_ll[i_loc] = ldb_l[i_loc];
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dspsv_(uplo_ll, n_ll, nrhs_ll, ap_ll, ipiv_ll, b_ll, ldb_ll, info_ll);

  for (i_loc=0; i_loc<uplo_ls; ++i_loc) uplo_l[i_loc] = uplo_ll[i_loc];
  free(uplo_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, uplo, uplo_l, 0);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  for (i_loc=0; i_loc<nrhs_ls; ++i_loc) nrhs_l[i_loc] = nrhs_ll[i_loc];
  free(nrhs_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, nrhs, nrhs_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, ap, ap_ll, 0);
  for (i_loc=0; i_loc<ipiv_ls; ++i_loc) ipiv_l[i_loc] = ipiv_ll[i_loc];
  free(ipiv_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ipiv, ipiv_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, b, b_ll, 0);
  for (i_loc=0; i_loc<ldb_ls; ++i_loc) ldb_l[i_loc] = ldb_ll[i_loc];
  free(ldb_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldb, ldb_l, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_spsvx
(JNIEnv *env, jclass clazz, jcharArray fact, jcharArray uplo, jintArray n, jintArray nrhs, jdoubleArray ap, jdoubleArray afp, jintArray ipiv, jdoubleArray b, jintArray ldb, jdoubleArray x, jintArray ldx, jdoubleArray rcond, jdoubleArray ferr, jdoubleArray berr, jdoubleArray work, jintArray iwork, jintArray info) {
  int i_loc;
  jchar* fact_l;
  char* fact_ll;
  jsize fact_ls;
  jchar* uplo_l;
  char* uplo_ll;
  jsize uplo_ls;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jint* nrhs_l;
  integer* nrhs_ll;
  jsize nrhs_ls;
  jdouble* ap_ll;
  jdouble* afp_ll;
  jint* ipiv_l;
  integer* ipiv_ll;
  jsize ipiv_ls;
  jdouble* b_ll;
  jint* ldb_l;
  integer* ldb_ll;
  jsize ldb_ls;
  jdouble* x_ll;
  jint* ldx_l;
  integer* ldx_ll;
  jsize ldx_ls;
  jdouble* rcond_ll;
  jdouble* ferr_ll;
  jdouble* berr_ll;
  jdouble* work_ll;
  jint* iwork_l;
  integer* iwork_ll;
  jsize iwork_ls;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  fact_l = (*env)->GetPrimitiveArrayCritical(env, fact, NULL);
  fact_ls = (*env)->GetArrayLength(env, fact);
  fact_ll = malloc(sizeof(char)*fact_ls);
  for (i_loc=0; i_loc<fact_ls; ++i_loc) fact_ll[i_loc] = fact_l[i_loc];
  uplo_l = (*env)->GetPrimitiveArrayCritical(env, uplo, NULL);
  uplo_ls = (*env)->GetArrayLength(env, uplo);
  uplo_ll = malloc(sizeof(char)*uplo_ls);
  for (i_loc=0; i_loc<uplo_ls; ++i_loc) uplo_ll[i_loc] = uplo_l[i_loc];
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  nrhs_l = (*env)->GetPrimitiveArrayCritical(env, nrhs, NULL);
  nrhs_ls = (*env)->GetArrayLength(env, nrhs);
  nrhs_ll = malloc(sizeof(integer)*nrhs_ls);
  for (i_loc=0; i_loc<nrhs_ls; ++i_loc) nrhs_ll[i_loc] = nrhs_l[i_loc];
  ap_ll = (*env)->GetPrimitiveArrayCritical(env, ap, NULL);
  afp_ll = (*env)->GetPrimitiveArrayCritical(env, afp, NULL);
  ipiv_l = (*env)->GetPrimitiveArrayCritical(env, ipiv, NULL);
  ipiv_ls = (*env)->GetArrayLength(env, ipiv);
  ipiv_ll = malloc(sizeof(integer)*ipiv_ls);
  for (i_loc=0; i_loc<ipiv_ls; ++i_loc) ipiv_ll[i_loc] = ipiv_l[i_loc];
  b_ll = (*env)->GetPrimitiveArrayCritical(env, b, NULL);
  ldb_l = (*env)->GetPrimitiveArrayCritical(env, ldb, NULL);
  ldb_ls = (*env)->GetArrayLength(env, ldb);
  ldb_ll = malloc(sizeof(integer)*ldb_ls);
  for (i_loc=0; i_loc<ldb_ls; ++i_loc) ldb_ll[i_loc] = ldb_l[i_loc];
  x_ll = (*env)->GetPrimitiveArrayCritical(env, x, NULL);
  ldx_l = (*env)->GetPrimitiveArrayCritical(env, ldx, NULL);
  ldx_ls = (*env)->GetArrayLength(env, ldx);
  ldx_ll = malloc(sizeof(integer)*ldx_ls);
  for (i_loc=0; i_loc<ldx_ls; ++i_loc) ldx_ll[i_loc] = ldx_l[i_loc];
  rcond_ll = (*env)->GetPrimitiveArrayCritical(env, rcond, NULL);
  ferr_ll = (*env)->GetPrimitiveArrayCritical(env, ferr, NULL);
  berr_ll = (*env)->GetPrimitiveArrayCritical(env, berr, NULL);
  work_ll = (*env)->GetPrimitiveArrayCritical(env, work, NULL);
  iwork_l = (*env)->GetPrimitiveArrayCritical(env, iwork, NULL);
  iwork_ls = (*env)->GetArrayLength(env, iwork);
  iwork_ll = malloc(sizeof(integer)*iwork_ls);
  for (i_loc=0; i_loc<iwork_ls; ++i_loc) iwork_ll[i_loc] = iwork_l[i_loc];
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dspsvx_(fact_ll, uplo_ll, n_ll, nrhs_ll, ap_ll, afp_ll, ipiv_ll, b_ll, ldb_ll, x_ll, ldx_ll, rcond_ll, ferr_ll, berr_ll, work_ll, iwork_ll, info_ll);

  for (i_loc=0; i_loc<fact_ls; ++i_loc) fact_l[i_loc] = fact_ll[i_loc];
  free(fact_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, fact, fact_l, 0);
  for (i_loc=0; i_loc<uplo_ls; ++i_loc) uplo_l[i_loc] = uplo_ll[i_loc];
  free(uplo_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, uplo, uplo_l, 0);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_l[i_loc] = n_ll[i_loc];
  free(n_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, n, n_l, 0);
  for (i_loc=0; i_loc<nrhs_ls; ++i_loc) nrhs_l[i_loc] = nrhs_ll[i_loc];
  free(nrhs_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, nrhs, nrhs_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, ap, ap_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, afp, afp_ll, 0);
  for (i_loc=0; i_loc<ipiv_ls; ++i_loc) ipiv_l[i_loc] = ipiv_ll[i_loc];
  free(ipiv_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ipiv, ipiv_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, b, b_ll, 0);
  for (i_loc=0; i_loc<ldb_ls; ++i_loc) ldb_l[i_loc] = ldb_ll[i_loc];
  free(ldb_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldb, ldb_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, x, x_ll, 0);
  for (i_loc=0; i_loc<ldx_ls; ++i_loc) ldx_l[i_loc] = ldx_ll[i_loc];
  free(ldx_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, ldx, ldx_l, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, rcond, rcond_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, ferr, ferr_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, berr, berr_ll, 0);
  (*env)->ReleasePrimitiveArrayCritical(env, work, work_ll, 0);
  for (i_loc=0; i_loc<iwork_ls; ++i_loc) iwork_l[i_loc] = iwork_ll[i_loc];
  free(iwork_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, iwork, iwork_l, 0);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_l[i_loc] = info_ll[i_loc];
  free(info_ll);
  (*env)->ReleasePrimitiveArrayCritical(env, info, info_l, 0);
}

JNIEXPORT void JNICALL Java_nni_LAPACK_sptrd
(JNIEnv *env, jclass clazz, jcharArray uplo, jintArray n, jdoubleArray ap, jdoubleArray d, jdoubleArray e, jdoubleArray tau, jintArray info) {
  int i_loc;
  jchar* uplo_l;
  char* uplo_ll;
  jsize uplo_ls;
  jint* n_l;
  integer* n_ll;
  jsize n_ls;
  jdouble* ap_ll;
  jdouble* d_ll;
  jdouble* e_ll;
  jdouble* tau_ll;
  jint* info_l;
  integer* info_ll;
  jsize info_ls;
  uplo_l = (*env)->GetPrimitiveArrayCritical(env, uplo, NULL);
  uplo_ls = (*env)->GetArrayLength(env, uplo);
  uplo_ll = malloc(sizeof(char)*uplo_ls);
  for (i_loc=0; i_loc<uplo_ls; ++i_loc) uplo_ll[i_loc] = uplo_l[i_loc];
  n_l = (*env)->GetPrimitiveArrayCritical(env, n, NULL);
  n_ls = (*env)->GetArrayLength(env, n);
  n_ll = malloc(sizeof(integer)*n_ls);
  for (i_loc=0; i_loc<n_ls; ++i_loc) n_ll[i_loc] = n_l[i_loc];
  ap_ll = (*env)->GetPrimitiveArrayCritical(env, ap, NULL);
  d_ll = (*env)->GetPrimitiveArrayCritical(env, d, NULL);
  e_ll = (*env)->GetPrimitiveArrayCritical(env, e, NULL);
  tau_ll = (*env)->GetPrimitiveArrayCritical(env, tau, NULL);
  info_l = (*env)->GetPrimitiveArrayCritical(env, info, NULL);
  info_ls = (*env)->GetArrayLength(env, info);
  info_ll = malloc(sizeof(integer)*info_ls);
  for (i_loc=0; i_loc<info_ls; ++i_loc) info_ll[i_loc] = info_l[i_loc];

  dsptrd_(uplo_ll, n_ll, ap_ll, d_ll, e_ll, tau_ll, info_ll);

  for (i_loc=0; i_loc<uplo_ls; ++i_loc) uplo_l[i_loc] = uplo_ll[i_loc];
  free(uplo_ll);
  (*env)->ReleasePrim