/*
 * Copyright (C) 2003, 2004 Bjrn-Ove Heimsund
 * 
 * This file is part of MT.
 * 
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published by the
 * Free Software Foundation; either version 2.1 of the License, or (at your
 * option) any later version.
 * 
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License
 * for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

package mt.test;

import junit.framework.TestCase;
import mt.DenseMatrix;
import mt.LowerSPDDenseMatrix;
import mt.Matrix;
import mt.UpperSPDDenseMatrix;
import mt.fact.DenseCholesky;

/**
 * Tests the dense Cholesky decomposition
 */
public class DenseCholeskyTest extends TestCase {

	/**
	 * Identity matrix
	 */
	private DenseMatrix I;

	/**
	 * Matrix to decompose
	 */
	private LowerSPDDenseMatrix L;

	/**
	 * Matrix to decompose
	 */
	private UpperSPDDenseMatrix U;

	private final int max = 50;

	public DenseCholeskyTest(String arg0) {
		super(arg0);
	}

	protected void setUp() throws Exception {
		int n = Utilities.getInt(max);

		L = new LowerSPDDenseMatrix(n);
		Utilities.lowerPopulate(L);
		L.addDiagonal(1);
		while (!Utilities.spd(L))
			L.addDiagonal(1);

		U = new UpperSPDDenseMatrix(n);
		Utilities.upperPopulate(U);
		U.addDiagonal(1);
		while (!Utilities.spd(U))
			U.addDiagonal(1);

		I = new DenseMatrix(n, n);
		for (int i = 0; i < n; ++i)
			I.set(i, i, 1);
	}

	protected void tearDown() throws Exception {
		L = null;
		U = null;
		I = null;
	}

	public void testLowerDenseCholesky() {
		DenseCholesky c = new DenseCholesky(L.copy());

		c.solve(I);

		int n = I.numRows();
		Matrix J = I.mult(L, new DenseMatrix(n, n));
		for (int i = 0; i < n; ++i)
			for (int j = 0; j < n; ++j)
				if (i != j)
					assertEquals(J.get(i, j), 0, 1e-10);
				else
					assertEquals(J.get(i, j), 1, 1e-10);
	}

	public void testUpperDenseCholesky() {
		DenseCholesky c = new DenseCholesky(U.copy());

		c.solve(I);

		int n = I.numRows();
		Matrix J = I.mult(U, new DenseMatrix(n, n));
		for (int i = 0; i < n; ++i)
			for (int j = 0; j < n; ++j)
				if (i != j)
					assertEquals(J.get(i, j), 0, 1e-10);
				else
					assertEquals(J.get(i, j), 1, 1e-10);
	}

}
