/*
 * Copyright (C) 2003, 2004 Bjrn-Ove Heimsund
 * 
 * This file is part of DMT.
 * 
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published by the
 * Free Software Foundation; either version 2.1 of the License, or (at your
 * option) any later version.
 * 
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License
 * for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

package dmt.prec;

import mt.DenseMatrix;
import mt.Matrix;
import mt.Vector;
import mt.fact.DenseLU;
import smt.iter.prec.Preconditioner;

/**
 * LU decomposition as preconditioner. Useful as a subdomain solver, but note
 * that it does not exploit sparsity
 */
public class LU implements Preconditioner {

    private DenseLU lu;

    private DenseMatrix A;

    /**
     * Constructor for LU
     * 
     * @param A
     *            Matrix to create decomposition preconditioner from. Not
     *            modified
     */
    public LU(Matrix A) {
        setMatrix(A);
    }

    public Vector apply(Vector b, Vector x) {
        lu.solve(new DenseMatrix(x.set(b), false));
        return x;
    }

    public Vector transApply(Vector b, Vector x) {
        lu.transSolve(new DenseMatrix(x.set(b), false));
        return x;
    }

    public void setMatrix(Matrix A) {
        this.A.set(A);
        lu = new DenseLU(this.A);
    }

}
