/*
 * Decompiled with CFR 0.152.
 */
package ru.sscc.spline.polynomial;

import ru.sscc.spline.SplineBody;
import ru.sscc.spline.SplineWorkspace;
import ru.sscc.spline.base.SimpleMesh;
import ru.sscc.spline.polynomial.PSplineWorkspace;
import ru.sscc.util.data.RealPointer;

public class PSplineBody
implements SplineBody {
    public final int interCount;
    public final int extraCount;
    protected SimpleMesh mesh;

    public PSplineBody(SimpleMesh simpleMesh, int n, int n2) {
        if (n < n2 || n2 < -1) {
            throw new IllegalArgumentException("Incorrect spline degrees");
        }
        this.mesh = simpleMesh;
        this.interCount = n + 1;
        this.extraCount = n2 + 1;
    }

    public double calculate(SplineWorkspace splineWorkspace) {
        return ((PSplineWorkspace)splineWorkspace).calculate();
    }

    public SplineWorkspace createWorkspace(RealPointer realPointer) {
        return new PSplineWorkspace(realPointer, this.mesh.scale, this.interCount - 1);
    }

    public int dimension() {
        return 1;
    }

    public SimpleMesh getMesh() {
        return this.mesh;
    }

    public int getVectorLength() {
        return (this.mesh.size - 1) * this.interCount + this.extraCount;
    }

    public int maxQuote() {
        return this.interCount;
    }

    public void prepareWorkspace(SplineWorkspace splineWorkspace, double d, int n, int n2) {
        if (n < 0) {
            throw new IllegalArgumentException("The required derivative cannot be calculated");
        }
        PSplineWorkspace pSplineWorkspace = (PSplineWorkspace)splineWorkspace;
        pSplineWorkspace.setDerivative(n);
        this.mesh.findCell(pSplineWorkspace, d);
        if (pSplineWorkspace.cellIndex == 0) {
            pSplineWorkspace.dataIndex = 0;
            pSplineWorkspace.dataCount = this.extraCount;
        } else {
            pSplineWorkspace.dataIndex = this.interCount * (pSplineWorkspace.cellIndex - 1);
            int n3 = pSplineWorkspace.dataCount = pSplineWorkspace.cellIndex == this.mesh.size ? this.extraCount : this.interCount;
        }
        if (n > 0) {
            pSplineWorkspace.dataIndex += n;
            pSplineWorkspace.dataCount -= n;
        }
    }

    public void prepareWorkspace(SplineWorkspace splineWorkspace, RealPointer realPointer, int n) {
        this.prepareWorkspace(splineWorkspace, realPointer.get(), 0, n);
    }
}

