/*
 * Decompiled with CFR 0.152.
 */
package ru.sscc.spline.base;

import ru.sscc.spline.base.OrderedMesh;
import ru.sscc.spline.base.OrderedPreparator;
import ru.sscc.spline.base.SimpleMeshWorkspace;
import ru.sscc.spline.base.UniformPreparator;

public class UniformMesh
extends OrderedMesh {
    public UniformMesh(double d, double d2, int n) {
        this.size = n;
        this.origin = d;
        if (d2 == 0.0) {
            throw new IllegalArgumentException("Zero mesh step");
        }
        this.scale = 1.0 / d2;
    }

    public final double distance(int n, int n2) {
        return n - n2;
    }

    public void findCell(SimpleMeshWorkspace simpleMeshWorkspace, double d) {
        int n;
        simpleMeshWorkspace.cellIndex = n = (d = (d - this.origin) * this.scale) < 0.0 ? 0 : (d >= (double)(this.size - 1) ? this.size : (int)Math.floor(d) + 1);
        simpleMeshWorkspace.cellPoint = d - (double)(n == 0 ? 0 : n - 1);
    }

    public final double get(int n) {
        return this.origin + (double)n / this.scale;
    }

    public final boolean isUniform() {
        return true;
    }

    public final OrderedPreparator makePreparator(int n) {
        return new UniformPreparator(this.size, n);
    }
}

