/*
 * Decompiled with CFR 0.152.
 */
package ru.sscc.spline;

import ru.sscc.spline.BaseSpline;
import ru.sscc.spline.SplineBody;
import ru.sscc.util.data.DoubleContainer;
import ru.sscc.util.data.RealContainer;
import ru.sscc.util.data.RealPointer;
import ru.sscc.util.data.RealVector;

public class Splines
extends BaseSpline {
    public final int count;

    public Splines(SplineBody splineBody, int n) {
        this(splineBody, new DoubleContainer(splineBody.getVectorLength() * n), n);
    }

    public Splines(SplineBody splineBody, RealContainer realContainer, int n) {
        super(splineBody, realContainer);
        this.count = n;
    }

    private RealPointer calculate(RealPointer realPointer) {
        int n = this.workspace.dataIndex * this.count;
        int n2 = 0;
        while (n2 < this.count) {
            if (this.workspace.dataCount > 0) {
                this.workspace.data.reset(n, this.count);
                realPointer.set(this.body.calculate(this.workspace));
            } else {
                realPointer.set(0.0);
            }
            ++n2;
            ++n;
            realPointer.next();
        }
        return realPointer.shift(-this.count);
    }

    public final RealVector getVector(int n) {
        return this.data.getVector(n, this.count, this.body.getVectorLength());
    }

    public final double value(int n, double d) {
        return this.value(n, d, 0);
    }

    public double value(int n, double d, int n2) {
        this.prepareWorkspace(d, n2, 1);
        if (this.workspace.dataCount <= 0) {
            return 0.0;
        }
        this.workspace.data.reset(this.workspace.dataIndex * this.count + n, this.count);
        return this.body.calculate(this.workspace);
    }

    public double value(int n, RealPointer realPointer) {
        this.prepareWorkspace(realPointer, 1);
        if (this.workspace.dataCount <= 0) {
            return 0.0;
        }
        this.workspace.data.reset(this.workspace.dataIndex * this.count + n, this.count);
        return this.body.calculate(this.workspace);
    }

    public final RealPointer values(RealPointer realPointer, double d) {
        return this.values(realPointer, d, 0);
    }

    public RealPointer values(RealPointer realPointer, double d, int n) {
        this.prepareWorkspace(d, n, this.count);
        return this.calculate(realPointer);
    }

    public RealPointer values(RealPointer realPointer, RealPointer realPointer2) {
        this.prepareWorkspace(realPointer2, this.count);
        return this.calculate(realPointer);
    }
}

