/*
 * Decompiled with CFR 0.152.
 */
package ru.sscc.matrix;

import ru.sscc.matrix.DenseMatrix;
import ru.sscc.matrix.Matrix;
import ru.sscc.matrix.RealAlgebraicMatrix;
import ru.sscc.util.data.DoubleVector;
import ru.sscc.util.data.RealContainer;
import ru.sscc.util.data.RealMath;
import ru.sscc.util.data.RealPointer;
import ru.sscc.util.data.RealVector;

public abstract class RealMatrix
implements RealAlgebraicMatrix,
Cloneable {
    private boolean algebraic = true;
    static final String CANT_SET_VALUE = "Cannot set a value of the matrix entry";
    public final int nRows;
    public final int nColumns;
    protected RealContainer entries;
    private static final int ALL_DENSE = 0;
    private static final int A_DENSE = 1;
    private static final int B_DENSE = 2;
    private static final int NOT_DENSE = 3;

    protected RealMatrix(RealContainer realContainer, int n, int n2) {
        this.entries = realContainer;
        this.nRows = n;
        this.nColumns = n2;
    }

    public abstract double add(int var1, int var2, double var3);

    public Object clone() {
        try {
            RealMatrix realMatrix = (RealMatrix)super.clone();
            realMatrix.entries = (RealContainer)this.entries.clone();
            realMatrix.unlock();
            return realMatrix;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public final int columnsNumber() {
        return this.nColumns;
    }

    private static void doMultiply(DenseMatrix denseMatrix, DenseMatrix denseMatrix2, DenseMatrix denseMatrix3) {
        int n = denseMatrix.nRows;
        int n2 = denseMatrix2.nColumns;
        int n3 = denseMatrix.nColumns;
        int n4 = denseMatrix.rowStep;
        int n5 = denseMatrix.columnStep;
        RealPointer realPointer = denseMatrix.getContainer().getPointer();
        int n6 = denseMatrix2.columnStep;
        int n7 = denseMatrix2.rowStep;
        RealPointer realPointer2 = denseMatrix2.getContainer().getPointer();
        int n8 = denseMatrix3.rowStep;
        int n9 = denseMatrix3.columnStep;
        RealPointer realPointer3 = denseMatrix3.getContainer().getPointer();
        int n10 = 0;
        int n11 = denseMatrix.startIndex;
        int n12 = denseMatrix3.startIndex;
        while (n10 < n) {
            realPointer.reset(n11, n5);
            realPointer3.reset(n12, n9);
            int n13 = 0;
            int n14 = denseMatrix2.startIndex;
            while (n13 < n2) {
                realPointer3.set(RealMath.innerProduct(realPointer, realPointer2.reset(n14, n7), n3));
                ++n13;
                n14 += n6;
                realPointer3.next();
            }
            ++n10;
            n11 += n4;
            n12 += n8;
        }
    }

    private static void doMultiply(RealMatrix realMatrix, DenseMatrix denseMatrix, DenseMatrix denseMatrix2) {
        RealContainer realContainer = denseMatrix.getContainer();
        RealVector realVector = realContainer.getVector(denseMatrix.startIndex, denseMatrix.rowStep, denseMatrix.nRows);
        int n = denseMatrix.columnStep;
        RealContainer realContainer2 = denseMatrix2.getContainer();
        RealVector realVector2 = realContainer2.getVector(denseMatrix2.startIndex, denseMatrix2.rowStep, denseMatrix2.nRows);
        int n2 = denseMatrix2.columnStep;
        int n3 = denseMatrix2.nColumns;
        while (n3-- > 0) {
            realMatrix.multiply(realVector, realVector2);
            realContainer.shiftVector(realVector, n);
            realContainer2.shiftVector(realVector2, n2);
        }
    }

    private static void doMultiply(RealMatrix realMatrix, RealMatrix realMatrix2, DenseMatrix denseMatrix) {
        RealContainer realContainer = denseMatrix.getContainer();
        RealVector realVector = realContainer.getVector(denseMatrix.startIndex, denseMatrix.rowStep, denseMatrix.nRows);
        int n = denseMatrix.columnStep;
        int n2 = denseMatrix.nColumns;
        int n3 = realMatrix2.nRows;
        double[] dArray = new double[n3];
        DoubleVector doubleVector = new DoubleVector(dArray);
        int n4 = 0;
        while (n4 < n2) {
            int n5 = 0;
            while (n5 < n3) {
                dArray[n5] = realMatrix2.get(n5, n4);
                ++n5;
            }
            realMatrix.multiply(doubleVector, realVector);
            realContainer.shiftVector(realVector, n);
            ++n4;
        }
    }

    private static void doMultiplyNT(RealMatrix realMatrix, RealMatrix realMatrix2, DenseMatrix denseMatrix) {
        RealContainer realContainer = denseMatrix.getContainer();
        RealVector realVector = realContainer.getVector(denseMatrix.startIndex, denseMatrix.rowStep, denseMatrix.nRows);
        int n = denseMatrix.columnStep;
        int n2 = denseMatrix.nColumns;
        int n3 = realMatrix2.nColumns;
        double[] dArray = new double[n3];
        DoubleVector doubleVector = new DoubleVector(dArray);
        int n4 = 0;
        while (n4 < n2) {
            int n5 = 0;
            while (n5 < n3) {
                dArray[n5] = realMatrix2.get(n4, n5);
                ++n5;
            }
            realMatrix.multiply(doubleVector, realVector);
            realContainer.shiftVector(realVector, n);
            ++n4;
        }
    }

    private static void doMultiplyT(RealMatrix realMatrix, DenseMatrix denseMatrix, DenseMatrix denseMatrix2) {
        RealContainer realContainer = denseMatrix.getContainer();
        RealVector realVector = realContainer.getVector(denseMatrix.startIndex, denseMatrix.rowStep, denseMatrix.nRows);
        int n = denseMatrix.columnStep;
        RealContainer realContainer2 = denseMatrix2.getContainer();
        RealVector realVector2 = realContainer2.getVector(denseMatrix2.startIndex, denseMatrix2.rowStep, denseMatrix2.nRows);
        int n2 = denseMatrix2.columnStep;
        int n3 = denseMatrix2.nColumns;
        while (n3-- > 0) {
            realMatrix.multiplyT(realVector, realVector2);
            realContainer.shiftVector(realVector, n);
            realContainer2.shiftVector(realVector2, n2);
        }
    }

    private static void doMultiplyT(RealMatrix realMatrix, RealMatrix realMatrix2, DenseMatrix denseMatrix) {
        RealContainer realContainer = denseMatrix.getContainer();
        RealVector realVector = realContainer.getVector(denseMatrix.startIndex, denseMatrix.rowStep, denseMatrix.nRows);
        int n = denseMatrix.columnStep;
        int n2 = denseMatrix.nColumns;
        int n3 = realMatrix2.nRows;
        double[] dArray = new double[n3];
        DoubleVector doubleVector = new DoubleVector(dArray);
        int n4 = 0;
        while (n4 < n2) {
            int n5 = 0;
            while (n5 < n3) {
                dArray[n5] = realMatrix2.get(n5, n4);
                ++n5;
            }
            realMatrix.multiplyT(doubleVector, realVector);
            realContainer.shiftVector(realVector, n);
            ++n4;
        }
    }

    public void ensureAlgebraic() {
        if (!this.algebraic) {
            throw new IllegalStateException("Nonalgebraic matrix");
        }
    }

    public final void ensureDimensions(int n, int n2) {
        if (this.nRows != n || this.nColumns != n2) {
            throw new IllegalArgumentException("Incompatible dimensions");
        }
    }

    public final void ensureDimensions(Matrix matrix) {
        this.ensureDimensions(matrix.rowsNumber(), matrix.columnsNumber());
    }

    private static DenseMatrix ensureMultiply(int n, int n2, int n3, int n4, RealMatrix realMatrix, RealMatrix realMatrix2, DenseMatrix denseMatrix) {
        realMatrix.ensureAlgebraic();
        realMatrix2.ensureAlgebraic();
        if (n2 != n3) {
            throw new IllegalArgumentException("Incompatible dimensions: cannot multiply matrices");
        }
        if (denseMatrix != null) {
            denseMatrix.ensureAlgebraic();
            denseMatrix.ensureDimensions(n, n4);
        } else {
            denseMatrix = new DenseMatrix(n, n4);
        }
        return denseMatrix;
    }

    public void ensureSquareMatrix() {
        if (this.nRows != this.nColumns) {
            throw new IllegalArgumentException("Non-square matrix");
        }
    }

    public abstract double get(int var1, int var2);

    public final RealContainer getContainer() {
        return this.entries;
    }

    public final void lock() {
        if (!this.algebraic) {
            throw new IllegalStateException("Attempt to lock already locked matrix");
        }
        this.algebraic = false;
    }

    public abstract double mul(int var1, int var2, double var3);

    public abstract void multiply(RealVector var1, RealVector var2);

    public static DenseMatrix multiplyNN(RealMatrix realMatrix, RealMatrix realMatrix2, DenseMatrix denseMatrix) {
        denseMatrix = RealMatrix.ensureMultiply(realMatrix.nRows, realMatrix.nColumns, realMatrix2.nRows, realMatrix2.nColumns, realMatrix, realMatrix2, denseMatrix);
        switch (RealMatrix.selectCase(realMatrix, realMatrix2)) {
            case 0: {
                RealMatrix.doMultiply((DenseMatrix)realMatrix, (DenseMatrix)realMatrix2, denseMatrix);
                break;
            }
            case 1: {
                RealMatrix.doMultiplyT(realMatrix2, ((DenseMatrix)realMatrix).transpose(), denseMatrix.transpose());
                break;
            }
            case 2: {
                RealMatrix.doMultiply(realMatrix, (DenseMatrix)realMatrix2, denseMatrix);
                break;
            }
            case 3: {
                RealMatrix.doMultiply(realMatrix, realMatrix2, denseMatrix);
                break;
            }
        }
        return denseMatrix;
    }

    public static DenseMatrix multiplyNT(RealMatrix realMatrix, RealMatrix realMatrix2, DenseMatrix denseMatrix) {
        denseMatrix = RealMatrix.ensureMultiply(realMatrix.nRows, realMatrix.nColumns, realMatrix2.nColumns, realMatrix2.nRows, realMatrix, realMatrix2, denseMatrix);
        switch (RealMatrix.selectCase(realMatrix, realMatrix2)) {
            case 0: {
                RealMatrix.doMultiply((DenseMatrix)realMatrix, ((DenseMatrix)realMatrix2).transpose(), denseMatrix);
                break;
            }
            case 1: {
                RealMatrix.doMultiply(realMatrix2, ((DenseMatrix)realMatrix).transpose(), denseMatrix.transpose());
                break;
            }
            case 2: {
                RealMatrix.doMultiply(realMatrix, ((DenseMatrix)realMatrix2).transpose(), denseMatrix);
                break;
            }
            case 3: {
                RealMatrix.doMultiplyNT(realMatrix, realMatrix2, denseMatrix);
                break;
            }
        }
        return denseMatrix;
    }

    public abstract void multiplyT(RealVector var1, RealVector var2);

    public static DenseMatrix multiplyTN(RealMatrix realMatrix, RealMatrix realMatrix2, DenseMatrix denseMatrix) {
        denseMatrix = RealMatrix.ensureMultiply(realMatrix.nColumns, realMatrix.nRows, realMatrix2.nRows, realMatrix2.nColumns, realMatrix, realMatrix2, denseMatrix);
        switch (RealMatrix.selectCase(realMatrix, realMatrix2)) {
            case 0: {
                RealMatrix.doMultiply(((DenseMatrix)realMatrix).transpose(), (DenseMatrix)realMatrix2, denseMatrix);
                break;
            }
            case 1: {
                RealMatrix.doMultiplyT(realMatrix2, (DenseMatrix)realMatrix, denseMatrix.transpose());
                break;
            }
            case 2: {
                RealMatrix.doMultiplyT(realMatrix, (DenseMatrix)realMatrix2, denseMatrix);
                break;
            }
            case 3: {
                RealMatrix.doMultiplyT(realMatrix, realMatrix2, denseMatrix);
                break;
            }
        }
        return denseMatrix;
    }

    public static DenseMatrix multiplyTT(RealMatrix realMatrix, RealMatrix realMatrix2, DenseMatrix denseMatrix) {
        denseMatrix = RealMatrix.ensureMultiply(realMatrix.nColumns, realMatrix.nRows, realMatrix2.nColumns, realMatrix2.nRows, realMatrix, realMatrix2, denseMatrix);
        switch (RealMatrix.selectCase(realMatrix, realMatrix2)) {
            case 0: {
                RealMatrix.doMultiply((DenseMatrix)realMatrix2, (DenseMatrix)realMatrix, denseMatrix.transpose());
                break;
            }
            case 1: {
                RealMatrix.doMultiply(realMatrix2, (DenseMatrix)realMatrix, denseMatrix.transpose());
                break;
            }
            case 2: {
                RealMatrix.doMultiplyT(realMatrix, ((DenseMatrix)realMatrix2).transpose(), denseMatrix);
                break;
            }
            case 3: {
                RealMatrix.doMultiply(realMatrix2, realMatrix, denseMatrix.transpose());
                break;
            }
        }
        return denseMatrix;
    }

    public final double relativeAccuracy() {
        return this.entries.relativeAccuracy();
    }

    public final int rowsNumber() {
        return this.nRows;
    }

    private static final int selectCase(RealMatrix realMatrix, RealMatrix realMatrix2) {
        return (realMatrix instanceof DenseMatrix ? 0 : 1) + (realMatrix2 instanceof DenseMatrix ? 0 : 2);
    }

    public abstract double set(int var1, int var2, double var3);

    protected void unlock() {
        this.algebraic = true;
    }
}

