/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.util.logging;

import ch.javasoft.util.logging.LogFormatter;
import ch.javasoft.util.logging.StandardErrHandler;
import ch.javasoft.util.logging.StandardOutHandler;
import ch.javasoft.util.logging.SystemProperties;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class Loggers {
    static {
        Loggers.initLogManagerConfiguration();
    }

    public static Logger getRootLogger() {
        return Logger.getLogger("");
    }

    public static Logger getLoggerForPackage(Package pkg, int parts) {
        return Loggers.getLogger(pkg.getName(), parts);
    }

    public static Logger getLogger(Class clazz, int parts) {
        int lastDot = clazz.getName().lastIndexOf(46);
        String pkgName = lastDot < 0 ? clazz.getName() : clazz.getName().substring(0, lastDot);
        return Loggers.getLogger(pkgName, parts);
    }

    public static Logger getLogger(String name, int parts) {
        if (parts != 0) {
            int absPackParts = Math.abs(parts);
            String[] packs = name.split("\\.");
            if (packs.length > absPackParts) {
                StringBuffer sb = new StringBuffer();
                int ii = 0;
                while (ii < absPackParts) {
                    if (sb.length() > 0) {
                        sb.append('.');
                    }
                    sb.append(packs[parts > 0 ? ii : packs.length - absPackParts + ii]);
                    ++ii;
                }
                name = sb.toString();
            }
        }
        return Logger.getLogger(name);
    }

    public static Logger getLogger(String groupName) {
        return Logger.getLogger(groupName);
    }

    public static void logToFile(File file, Level level) throws IOException {
        Properties props = Loggers.getDefaultConfigurationAsProperties();
        props.setProperty(".level", level.getName());
        props.setProperty("handlers", FileHandler.class.getName());
        props.setProperty(String.valueOf(FileHandler.class.getName()) + ".pattern", file.getAbsolutePath());
        Loggers.initLogManagerConfiguration(props);
    }

    public static void logToFile(String fileName, Level level) throws IOException {
        Loggers.logToFile(new File(fileName), level);
    }

    public static void logToConsole(Level level) throws SecurityException, IOException {
        Properties props = Loggers.getDefaultConfigurationAsProperties();
        props.setProperty(".level", level.getName());
        props.setProperty("handlers", String.valueOf(StandardErrHandler.class.getName()) + "," + StandardOutHandler.class.getName());
        Loggers.initLogManagerConfiguration(props);
    }

    public static boolean isLoggable(Logger logger, Level level) {
        Logger parent;
        if (!logger.isLoggable(level)) {
            return false;
        }
        LogRecord testRec = new LogRecord(level, "is loggable test record");
        if (logger.getFilter() == null || logger.getFilter().isLoggable(testRec)) {
            Handler[] handlerArray = logger.getHandlers();
            int n = handlerArray.length;
            int n2 = 0;
            while (n2 < n) {
                Handler hdl = handlerArray[n2];
                if (hdl.isLoggable(testRec)) {
                    return true;
                }
                ++n2;
            }
        }
        if (logger.getUseParentHandlers() && (parent = logger.getParent()) != null) {
            return Loggers.isLoggable(parent, level);
        }
        return false;
    }

    public static void removeAllHandlers(Logger logger, boolean close) {
        Handler[] handlerArray = logger.getHandlers();
        int n = handlerArray.length;
        int n2 = 0;
        while (n2 < n) {
            Handler hdl = handlerArray[n2];
            logger.removeHandler(hdl);
            if (close) {
                hdl.close();
            }
            ++n2;
        }
    }

    public static void setPlainFormatter(Logger logger) {
        Loggers.setFormatter(logger, new LogFormatter(LogFormatter.FORMAT_PLAIN));
    }

    public static void setFormatter(Logger logger, LogFormatter formatter) {
        Handler[] handlerArray = logger.getHandlers();
        int n = handlerArray.length;
        int n2 = 0;
        while (n2 < n) {
            Handler h = handlerArray[n2];
            h.setFormatter(formatter);
            ++n2;
        }
    }

    public static String getDefaultConfigurationName() {
        return String.valueOf(Loggers.class.getSimpleName()) + ".properties";
    }

    private static void initLogManagerConfiguration() {
        try {
            if (SystemProperties.LogManagerPropertiesClass.getSystemProperty() == null) {
                if (SystemProperties.LogManagerPropertiesFile.getSystemProperty() == null) {
                    LogManager.getLogManager().readConfiguration(Loggers.getDefaultConfiguration());
                } else {
                    LogManager.getLogManager().readConfiguration();
                }
            } else {
                LogManager.getLogManager().readConfiguration();
            }
        }
        catch (Exception ex) {
            System.err.println("cannot initialize log manager configuration, e=" + ex);
            ex.printStackTrace();
        }
    }

    public static void initLogManagerConfiguration(Properties config) throws SecurityException, IOException {
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        config.store(buf, "configuration from properties");
        ByteArrayInputStream in = new ByteArrayInputStream(buf.toByteArray());
        LogManager.getLogManager().readConfiguration(in);
    }

    public static Properties getDefaultConfigurationAsProperties() throws IOException {
        String propFile = Loggers.getDefaultConfigurationName();
        InputStream in = Loggers.class.getResourceAsStream(propFile);
        if (in == null) {
            throw new FileNotFoundException(propFile);
        }
        Properties props = new Properties();
        props.load(in);
        return props;
    }

    private static InputStream getDefaultConfiguration() throws IOException {
        String propFile = Loggers.getDefaultConfigurationName();
        InputStream in = Loggers.class.getResourceAsStream(propFile);
        if (in == null) {
            throw new FileNotFoundException(propFile);
        }
        return in;
    }

    private Loggers() {
    }
}

