/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.util.genarr;

import ch.javasoft.util.Null;
import ch.javasoft.util.genarr.ArrayIterable;
import ch.javasoft.util.genarr.GenericArray;
import ch.javasoft.util.genarr.GenericFixSizeArray;
import java.lang.reflect.Array;
import java.util.ListIterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractArrayIterable<T>
implements ArrayIterable<T> {
    @Override
    public abstract int length();

    @Override
    public abstract T get(int var1) throws IndexOutOfBoundsException;

    @Override
    public T set(int index, T obj) throws IndexOutOfBoundsException, UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isEmpty() {
        return this.length() == 0;
    }

    @Override
    public ListIterator<T> iterator() {
        return this.iterator(0, this.length());
    }

    @Override
    public ListIterator<T> iterator(int start, int end) {
        return new ArrayListIterator(start, end);
    }

    @Override
    public Iterable<T> iterable(final int start, final int end) {
        if (start < 0) {
            throw new IndexOutOfBoundsException("negative start index: " + start);
        }
        if (end < start) {
            throw new IndexOutOfBoundsException("end index before start: " + start + ">" + end);
        }
        if (end > this.length()) {
            throw new IndexOutOfBoundsException("end index after length: " + end + ">" + this.length());
        }
        final AbstractArrayIterable nested = this;
        return new AbstractArrayIterable<T>(){

            @Override
            public T get(int index) throws IndexOutOfBoundsException {
                return nested.get(index - start);
            }

            @Override
            public int length() {
                return end - start;
            }
        };
    }

    @Override
    public Object[] toArray() {
        return this.toArray(Object.class);
    }

    @Override
    public <TT> TT[] toArray(TT[] arr) {
        int size = this.length();
        if (arr.length < size) {
            arr = (Object[])Array.newInstance(arr.getClass().getComponentType(), size);
        }
        int ii = 0;
        while (ii < size) {
            arr[ii] = this.get(ii);
            ++ii;
        }
        if (arr.length > size) {
            arr[size] = null;
        }
        return arr;
    }

    @Override
    public <TT> TT[] toArray(Class<TT> componentType) {
        int size = this.length();
        Object[] arr = (Object[])Array.newInstance(componentType, size);
        int ii = 0;
        while (ii < size) {
            arr[ii] = this.get(ii);
            ++ii;
        }
        return arr;
    }

    @Override
    public int indexOf(Object obj) {
        if (obj == null) {
            obj = Null.INSTANCE;
        }
        int len = this.length();
        int ii = 0;
        while (ii < len) {
            if (obj.equals(this.get(ii))) {
                return ii;
            }
            ++ii;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object obj) {
        if (obj == null) {
            obj = Null.INSTANCE;
        }
        int len = this.length();
        int ii = len - 1;
        while (ii >= 0) {
            if (obj.equals(this.get(ii))) {
                return ii;
            }
            --ii;
        }
        return -1;
    }

    @Override
    public GenericArray<T> toGenericArray(boolean forceNewInstance) {
        if (!forceNewInstance && this instanceof GenericArray) {
            return (GenericArray)((Object)this);
        }
        return new GenericFixSizeArray(this);
    }

    public int hashCode() {
        int code = 0;
        int ii = 0;
        while (ii < this.length()) {
            code ^= this.get(ii).hashCode();
            ++ii;
        }
        return code;
    }

    public boolean equals(Object obj) {
        if (obj.getClass() == this.getClass()) {
            ArrayIterable other = (ArrayIterable)obj;
            if (this.length() != other.length()) {
                return false;
            }
            int ii = 0;
            while (ii < this.length()) {
                T mine = this.get(ii);
                Object others = other.get(ii);
                if (mine == null && others != null) {
                    return false;
                }
                if (!mine.equals(others)) {
                    return false;
                }
                ++ii;
            }
            return true;
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ArrayListIterator
    implements ListIterator<T> {
        protected int mIndex;
        protected final int mStart;
        protected final int mEnd;

        public ArrayListIterator(int start, int end) {
            if (start < 0 || end > AbstractArrayIterable.this.length() || start > end) {
                throw new IndexOutOfBoundsException("[" + start + ", " + end + "] out of bounds [0, " + AbstractArrayIterable.this.length() + "] or fromIndex > toIndex");
            }
            this.mStart = start;
            this.mIndex = start;
            this.mEnd = end;
        }

        @Override
        public boolean hasPrevious() {
            return this.mIndex > this.mStart;
        }

        @Override
        public boolean hasNext() {
            return this.mIndex < this.mEnd;
        }

        @Override
        public T next() {
            if (this.mIndex < this.mEnd) {
                return AbstractArrayIterable.this.get(this.mIndex++);
            }
            throw new NoSuchElementException();
        }

        @Override
        public T previous() {
            if (this.mIndex > this.mStart) {
                return AbstractArrayIterable.this.get(--this.mIndex);
            }
            throw new NoSuchElementException();
        }

        @Override
        public int nextIndex() {
            if (this.mIndex < this.mEnd) {
                return this.mIndex;
            }
            return AbstractArrayIterable.this.length();
        }

        @Override
        public int previousIndex() {
            if (this.mIndex > this.mStart) {
                return this.mIndex - 1;
            }
            return -1;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(T o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(T o) {
            throw new UnsupportedOperationException();
        }
    }
}

