/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.util;

import ch.javasoft.util.Arrays;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DoubleArray
implements Iterable<Double>,
Cloneable,
Serializable {
    private static final long serialVersionUID = -7460755602011341106L;
    public static final double[] EMPTY_ARRAY = new double[0];
    private static final int DEFAULT_CAPACITY = 7;
    private int mLength = 0;
    private double[] mArray;

    public DoubleArray() {
        this(7);
    }

    public DoubleArray(int capacity) {
        this.mArray = new double[capacity];
        this.initialize(this.mArray, 0, capacity, false);
    }

    public DoubleArray(double[] initialValues) {
        this.mArray = initialValues;
        this.mLength = initialValues.length;
    }

    public DoubleArray(double[] original, int from, int to) {
        this.mArray = Arrays.copyOfRange(original, from, to);
        this.mLength = to - from;
    }

    public int length() {
        return this.mLength;
    }

    public boolean isEmpty() {
        return this.mLength == 0;
    }

    public double get(int index) throws IndexOutOfBoundsException {
        if (index >= this.mLength) {
            throw new IndexOutOfBoundsException("index not in [0, " + (this.mLength - 1) + "]: " + index);
        }
        return this.mArray[index];
    }

    public int indexOf(double value) {
        return this.indexOf(0, value);
    }

    public int indexOf(int fromIndex, double value) {
        int i = fromIndex;
        while (i < this.mLength) {
            if (value == this.mArray[i]) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public double set(int index, double value) throws IndexOutOfBoundsException {
        double old;
        if (index >= this.mLength) {
            this.ensureCapacity(index + 1);
            old = this.initialValue();
        } else {
            old = this.mArray[index];
        }
        this.mArray[index] = value;
        this.mLength = Math.max(this.mLength, index + 1);
        return old;
    }

    public void add(double value) {
        this.set(this.mLength, value);
    }

    public void addAll(DoubleArray array) {
        this.addAll(0, this.mLength, array.mArray);
    }

    public void addAll(int from, int to, DoubleArray array) {
        if (to > array.mLength) {
            throw new IndexOutOfBoundsException("to index after length: " + to + " > " + array.mLength);
        }
        this.addAll(from, to, array.mArray);
    }

    public void addAll(double ... values) {
        this.addAll(0, values.length, values);
    }

    public void addAll(int from, int to, double ... values) {
        if (from < 0) {
            throw new IndexOutOfBoundsException("from must be non-negative: " + from);
        }
        if (to < from) {
            throw new IndexOutOfBoundsException("to must not be smaller than from: " + to + " < " + from);
        }
        this.ensureCapacity(this.mLength + to - from);
        System.arraycopy(values, from, this.mArray, this.mLength, to - from);
        this.mLength += to - from;
    }

    public boolean add(int index, double value) {
        if (index < 0 || index > this.mLength) {
            throw new IndexOutOfBoundsException("index must be >=0 and <= length, but was " + index);
        }
        this.ensureCapacity(this.mLength + 1);
        System.arraycopy(this.mArray, index, this.mArray, index + 1, this.mLength - index);
        this.mArray[index] = value;
        ++this.mLength;
        return true;
    }

    public double removeLast() {
        return this.remove(this.mLength - 1);
    }

    public double remove(int index) {
        if (index >= this.mLength) {
            throw new IndexOutOfBoundsException("index not in [0, " + (this.mLength - 1) + "]: " + index);
        }
        double old = this.mArray[index];
        --this.mLength;
        System.arraycopy(this.mArray, index + 1, this.mArray, index, this.mLength - index);
        return old;
    }

    public void clear() {
        this.initialize(this.mArray, 0, this.mLength, true);
        this.mLength = 0;
    }

    public double first() {
        return this.get(0);
    }

    public double last() {
        return this.get(this.mLength - 1);
    }

    public void swap(int indexA, int indexB) {
        if (indexA < 0 || indexA >= this.mLength) {
            throw new IndexOutOfBoundsException("index " + indexA + " not in [0, " + (this.mLength - 1) + "]");
        }
        if (indexB < 0 || indexB >= this.mLength) {
            throw new IndexOutOfBoundsException("index " + indexB + " not in [0, " + (this.mLength - 1) + "]");
        }
        double tmp = this.mArray[indexA];
        this.mArray[indexA] = this.mArray[indexB];
        this.mArray[indexB] = tmp;
    }

    protected void ensureCapacity(int size) {
        if (size >= this.mArray.length) {
            int newSize = Math.max(size, this.mArray.length * 2);
            double[] newArr = new double[newSize];
            System.arraycopy(this.mArray, 0, newArr, 0, this.mLength);
            this.initialize(newArr, this.mLength, newSize, false);
            this.mArray = newArr;
        }
    }

    protected double initialValue() {
        return 0.0;
    }

    private void initialize(double[] array, int from, int to, boolean force) {
        double initialValue = this.initialValue();
        if ((force || initialValue != 0.0) && from < to) {
            java.util.Arrays.fill(array, from, to, initialValue);
        }
    }

    public double[] toArray() {
        double[] arr = new double[this.mLength];
        System.arraycopy(this.mArray, 0, arr, 0, this.mLength);
        return arr;
    }

    public double[] yieldArray() {
        this.trimToLength();
        double[] arr = this.mArray;
        this.mArray = new double[7];
        this.initialize(this.mArray, 0, 7, false);
        this.mLength = 0;
        return arr;
    }

    public DoubleArray clone() {
        return new DoubleArray(this.mArray, 0, this.mLength);
    }

    public DoubleArray subRange(int from) {
        return this.subRange(from, this.mLength);
    }

    public DoubleArray subRange(int from, int to) {
        return new DoubleArray(this.mArray, from, to);
    }

    @Override
    public Iterator<Double> iterator() {
        return new Iterator<Double>(){
            int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < DoubleArray.this.length();
            }

            @Override
            public Double next() {
                return DoubleArray.this.get(this.index++);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("immutable iterator");
            }
        };
    }

    public static double[][] toMatrix(DoubleArray[] mx) {
        double[][] res = new double[mx.length][];
        int i = 0;
        while (i < mx.length) {
            res[i] = mx[i].toArray();
            ++i;
        }
        return res;
    }

    public static double[][] toMatrix(Collection<DoubleArray> mx) {
        double[][] res = new double[mx.size()][];
        int ri = 0;
        for (DoubleArray row : mx) {
            res[ri++] = row.toArray();
        }
        return res;
    }

    public static double[][] toMatrix(Collection<double[]> mx, boolean cloneArrays) {
        double[][] res = new double[mx.size()][];
        int ri = 0;
        if (cloneArrays) {
            for (double[] row : mx) {
                res[ri++] = (double[])row.clone();
            }
        } else {
            for (double[] row : mx) {
                res[ri++] = row;
            }
        }
        return res;
    }

    public static void swap(double[] arr, int indexA, int indexB) {
        double tmp = arr[indexA];
        arr[indexA] = arr[indexB];
        arr[indexB] = tmp;
    }

    public static double[][] clone(double[][] arr) {
        double[][] clone = new double[arr.length][];
        int i = 0;
        while (i < clone.length) {
            int len = arr[i].length;
            clone[i] = new double[len];
            System.arraycopy(arr[i], 0, clone[i], 0, len);
            ++i;
        }
        return clone;
    }

    public void trimToLength() {
        if (this.mLength < this.mArray.length) {
            double[] arr = new double[this.mLength];
            System.arraycopy(this.mArray, 0, arr, 0, this.mLength);
            this.mArray = arr;
        }
    }

    public int binarySearch(double key) throws IllegalStateException {
        return this.binarySearch(key, 0, this.mLength);
    }

    public int binarySearch(double key, int fromIndex, int toIndex) throws IllegalStateException {
        return Arrays.binarySearch(this.mArray, fromIndex, toIndex, key);
    }

    public int addToSorted(double value) {
        int pos = this.binarySearch(value);
        if (pos < 0) {
            pos = -(pos + 1);
        }
        this.add(pos, value);
        return pos;
    }

    public void sort(boolean ascending) {
        this.sort(ascending, 0, this.mLength);
    }

    public void sort(boolean ascending, int start, int end) {
        java.util.Arrays.sort(this.mArray, start, end);
        if (!ascending) {
            int ii = start;
            while (ii < end / 2) {
                double tmp = this.mArray[ii];
                this.mArray[ii] = this.mArray[end - ii - 1];
                this.mArray[end - ii - 1] = tmp;
                ++ii;
            }
        }
    }

    public int hashCode() {
        int hash = 0;
        int i = 0;
        while (i < this.mLength) {
            long val = Double.doubleToLongBits(this.mArray[i]);
            hash = (int)((long)hash ^ val);
            hash = (int)((long)hash ^ val >>> 32);
            ++i;
        }
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof DoubleArray) {
            DoubleArray other = (DoubleArray)obj;
            if (this.mLength != other.mLength) {
                return false;
            }
            int i = 0;
            while (i < this.mLength) {
                if (this.mArray[i] != other.mArray[i]) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        int ii = 0;
        while (ii < this.mLength) {
            if (ii > 0) {
                sb.append(", ");
            }
            sb.append(this.mArray[ii]);
            ++ii;
        }
        sb.append(']');
        return sb.toString();
    }
}

