/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.tool;

import java.io.File;
import java.io.FilenameFilter;

public class JarFileCollector {
    public static void main(String[] args) {
        try {
            int start = 0;
            String baseDir = null;
            String[] fileEndings = new String[]{"jar"};
            int i = 0;
            while (i < args.length) {
                if (!args[i].startsWith("-")) break;
                if (i == 0 && args[i].equals("--help")) {
                    JarFileCollector.showUsage();
                    System.exit(0);
                }
                if ("--base".equals(args[i])) {
                    ++start;
                    if (++i == args.length) {
                        JarFileCollector.showUsage();
                        System.exit(4);
                    }
                    baseDir = new File(args[i]).getCanonicalPath();
                    ++i;
                    ++start;
                    continue;
                }
                ++i;
                if (++start > fileEndings.length) {
                    String[] old = fileEndings;
                    fileEndings = new String[fileEndings.length + 1];
                    System.arraycopy(old, 0, fileEndings, 0, old.length);
                }
                fileEndings[start - 1] = args[i].substring(1);
            }
            if (start == args.length) {
                JarFileCollector.showUsage();
                System.exit(3);
            }
            String path = null;
            int i2 = start;
            while (i2 < args.length) {
                File file = new File(args[i2]);
                if (!(file.exists() && file.isDirectory() && file.canRead())) {
                    System.err.println("file does not exist, is not a directory or not readable: " + file.getAbsolutePath());
                    System.exit(1);
                }
                if (baseDir == null) {
                    baseDir = file.getCanonicalPath();
                }
                if (baseDir.endsWith(File.separator)) {
                    baseDir = baseDir.substring(0, baseDir.length() - 1);
                }
                int j = 0;
                while (j < fileEndings.length) {
                    final String fileEnding = "." + fileEndings[j];
                    File[] files = file.listFiles(new FilenameFilter(){

                        public boolean accept(File dir, String name) {
                            return name.endsWith(fileEnding);
                        }
                    });
                    int k = 0;
                    while (k < files.length) {
                        String fileName = files[k].getCanonicalPath();
                        if (!fileName.startsWith(baseDir)) {
                            System.err.println("file '" + fileName + "' does not start with base directory: " + baseDir);
                            System.exit(5);
                        }
                        String relFileName = fileName.substring(baseDir.length() + (baseDir.length() == 0 ? 0 : 1));
                        path = path == null ? relFileName : String.valueOf(path) + ":" + relFileName;
                        ++k;
                    }
                    ++j;
                }
                ++i2;
            }
            System.out.println(path);
            System.exit(0);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(2);
        }
    }

    private static void showUsage() {
        System.out.println("usage: JarFileCollector [options] dir [dir ...]");
        System.out.println("         options    --help          show this help message");
        System.out.println("         options    --base basedir  base directory, needed if multiple directories are given");
        System.out.println("         options    -ending         one or more file endings for archives");
        System.out.println("                                    e.g. -jar -zip, default is -jar");
        System.out.println();
        System.out.println("samples:");
        System.out.println("         JarFileCollector lib                             collects all jar files in the lib directory");
        System.out.println("         JarFileCollector -jar -zip lib                   collects all jar and zip files in lib");
        System.out.println("         JarFileCollector -base . lib/int lib/ext lib     collects all jar files in lib/int and lib/ext");
    }
}

