/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.smx.util;

import ch.javasoft.smx.iface.WritableIntRationalMatrix;
import ch.javasoft.util.numeric.IntegerUtil;

public class SmxIntegerUtil {
    public static int checkIntegerRange(long value) throws ArithmeticException {
        if (value > Integer.MAX_VALUE || value < Integer.MIN_VALUE) {
            throw new ArithmeticException("integer overflow: " + value);
        }
        return (int)value;
    }

    public static void checkLongRangeAfterAddition(long summandA, long summandB, long sum) throws ArithmeticException {
        int sigA = IntegerUtil.signum(summandA);
        if (sigA == IntegerUtil.signum(summandB) && sigA != IntegerUtil.signum(sum)) {
            throw new ArithmeticException("long overflow: " + sum);
        }
    }

    public static void checkLongRangeAfterMultiplication(long factorA, long factorB, long product) throws ArithmeticException {
        if (IntegerUtil.signum(factorA) * IntegerUtil.signum(factorB) != IntegerUtil.signum(product)) {
            throw new ArithmeticException("long overflow: " + product);
        }
    }

    public static void multiply(int dividendA, int divisorA, int dividendB, int divisorB, WritableIntRationalMatrix dst, int row, int col) {
        if (divisorA == 0 || divisorB == 0) {
            throw new ArithmeticException("div by 0");
        }
        if (dividendA == 0 || dividendB == 0) {
            dst.setValueAt(row, col, 0, 1);
        } else {
            long newDividend = (long)dividendA * (long)dividendB;
            long newDivisor = (long)divisorA * (long)divisorB;
            long gcd = IntegerUtil.gcd(newDividend, newDivisor);
            SmxIntegerUtil.checkIntegerRange(newDividend /= gcd);
            SmxIntegerUtil.checkIntegerRange(newDivisor /= gcd);
            dst.setValueAt(row, col, (int)newDividend, (int)newDivisor);
        }
    }

    public static void add(int dividendA, int divisorA, int dividendB, int divisorB, WritableIntRationalMatrix dst, int row, int col) {
        if (divisorA == divisorB) {
            long sum = (long)dividendA + (long)dividendB;
            long gcd = IntegerUtil.gcd(sum, (long)divisorA);
            SmxIntegerUtil.checkIntegerRange(sum /= gcd);
            dst.setValueAt(row, col, (int)sum, divisorA / (int)gcd);
        } else {
            long prodA = (long)dividendA * (long)divisorB;
            long prodB = (long)dividendB * (long)divisorA;
            long dividend = prodA + prodB;
            SmxIntegerUtil.checkLongRangeAfterAddition(prodA, prodB, dividend);
            long divisor = (long)dividendA * (long)dividendB;
            long gcd = IntegerUtil.gcd(dividend, divisor);
            SmxIntegerUtil.checkIntegerRange(dividend /= gcd);
            SmxIntegerUtil.checkIntegerRange(divisor /= gcd);
            dst.setValueAt(row, col, (int)dividend, (int)divisor);
        }
    }

    private SmxIntegerUtil() {
    }
}

