/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.smx.impl;

import ch.javasoft.smx.iface.ReadableDoubleMatrix;
import ch.javasoft.smx.impl.AbstractDoubleMatrix;

public class DefaultDoubleMatrix
extends AbstractDoubleMatrix {
    private final int mColumnCount;
    private final double[] mValues;

    public DefaultDoubleMatrix(int rowCount, int colCount) {
        this(new double[rowCount * colCount], rowCount, colCount);
    }

    public DefaultDoubleMatrix(double[][] values, boolean rowsInDim1) {
        int colCnt;
        int rowCnt;
        if (rowsInDim1) {
            rowCnt = values.length;
            colCnt = 0;
            int row = 0;
            while (row < values.length) {
                colCnt = Math.max(colCnt, values[row].length);
                ++row;
            }
        } else {
            colCnt = values.length;
            rowCnt = 0;
            int col = 0;
            while (col < values.length) {
                rowCnt = Math.max(rowCnt, values[col].length);
                ++col;
            }
        }
        double[] vals = new double[rowCnt * colCnt];
        int row = 0;
        while (row < rowCnt) {
            int col = 0;
            while (col < colCnt) {
                int index1 = rowsInDim1 ? row : col;
                int index2 = rowsInDim1 ? col : row;
                vals[row * colCnt + col] = index2 < values[index1].length ? values[index1][index2] : 0.0;
                ++col;
            }
            ++row;
        }
        this.mValues = vals;
        this.mColumnCount = colCnt;
    }

    public DefaultDoubleMatrix(Double[][] values, boolean rowsInDim1) {
        this((Number[][])values, rowsInDim1);
    }

    public DefaultDoubleMatrix(Number[][] values, boolean rowsInDim1) {
        int colCnt;
        int rowCnt;
        if (rowsInDim1) {
            rowCnt = values.length;
            colCnt = 0;
            int row = 0;
            while (row < values.length) {
                colCnt = Math.max(colCnt, values[row].length);
                ++row;
            }
        } else {
            colCnt = values.length;
            rowCnt = 0;
            int col = 0;
            while (col < values.length) {
                rowCnt = Math.max(rowCnt, values[col].length);
                ++col;
            }
        }
        double[] vals = new double[rowCnt * colCnt];
        int row = 0;
        while (row < rowCnt) {
            int col = 0;
            while (col < colCnt) {
                int index1 = rowsInDim1 ? row : col;
                int index2 = rowsInDim1 ? col : row;
                vals[row * colCnt + col] = index2 < values[index1].length ? values[index1][index2].doubleValue() : 0.0;
                ++col;
            }
            ++row;
        }
        this.mValues = vals;
        this.mColumnCount = colCnt;
    }

    public DefaultDoubleMatrix(double[] values, int rowCount, int columnCount) {
        if (rowCount == -1) {
            rowCount = values.length / columnCount;
        }
        if (columnCount == -1) {
            columnCount = values.length / rowCount;
        }
        if (rowCount < 0 || columnCount < 0 || rowCount * columnCount != values.length) {
            throw new IllegalArgumentException("rowCount (" + rowCount + ") * columnCount (" + columnCount + ") != number of values (" + values.length + ")");
        }
        this.mValues = values;
        this.mColumnCount = columnCount;
    }

    public DefaultDoubleMatrix(ReadableDoubleMatrix mx) {
        this.mValues = mx.toDoubleArray();
        this.mColumnCount = mx.getColumnCount();
    }

    public static DefaultDoubleMatrix diag(double[] values) {
        int len = values.length;
        DefaultDoubleMatrix mx = new DefaultDoubleMatrix(new double[len * len], len, len);
        int ii = 0;
        while (ii < len) {
            mx.setValueAt(ii, ii, values[ii]);
            ++ii;
        }
        return mx;
    }

    public static DefaultDoubleMatrix diag(double value, int len) {
        DefaultDoubleMatrix mx = new DefaultDoubleMatrix(new double[len * len], len, len);
        int ii = 0;
        while (ii < len) {
            mx.setValueAt(ii, ii, value);
            ++ii;
        }
        return mx;
    }

    public static DefaultDoubleMatrix identity(int len) {
        return DefaultDoubleMatrix.diag(1.0, len);
    }

    public double getDoubleValueAt(int row, int col) {
        return this.mValues[row * this.mColumnCount + col];
    }

    public int getRowCount() {
        return this.mValues.length / (this.mColumnCount == 0 ? 1 : this.mColumnCount);
    }

    public int getColumnCount() {
        return this.mColumnCount;
    }

    public void setValueAt(int row, int col, double value) {
        this.mValues[row * this.mColumnCount + col] = value;
    }

    public void swapRows(int rowA, int rowB) {
        if (rowA == rowB) {
            return;
        }
        double[] tmpRow = new double[this.mColumnCount];
        System.arraycopy(this.mValues, rowA * this.mColumnCount, tmpRow, 0, this.mColumnCount);
        System.arraycopy(this.mValues, rowB * this.mColumnCount, this.mValues, rowA * this.mColumnCount, this.mColumnCount);
        System.arraycopy(tmpRow, 0, this.mValues, rowB * this.mColumnCount, this.mColumnCount);
    }

    public double[] toDoubleArray() {
        return (double[])this.mValues.clone();
    }

    public void toArray(double[] array) {
        if (array.length != this.mValues.length) {
            throw new IllegalArgumentException("expected array length " + this.mValues.length + " but found " + array.length);
        }
        System.arraycopy(this.mValues, 0, array, 0, array.length);
    }

    public DefaultDoubleMatrix clone() {
        return new DefaultDoubleMatrix((double[])this.mValues.clone(), this.getRowCount(), this.mColumnCount);
    }

    public DefaultDoubleMatrix newInstance(int rows, int cols) {
        return new DefaultDoubleMatrix(rows, cols);
    }

    public DefaultDoubleMatrix newInstance(Double[][] data, boolean rowsInDim1) {
        int cols;
        int rows;
        if (rowsInDim1) {
            rows = data.length;
            cols = rows == 0 ? 0 : data[0].length;
        } else {
            cols = data.length;
            rows = cols == 0 ? 0 : data[0].length;
        }
        double[] values = new double[rows * cols];
        int row = 0;
        while (row < rows) {
            int col = 0;
            while (col < cols) {
                Double val = rowsInDim1 ? data[row][col] : data[col][row];
                values[row * cols + col] = val;
                ++col;
            }
            ++row;
        }
        return new DefaultDoubleMatrix(values, rows, cols);
    }

    public DefaultDoubleMatrix transpose() {
        int rows = this.getRowCount();
        int cols = this.getColumnCount();
        DefaultDoubleMatrix tr = new DefaultDoubleMatrix(cols, rows);
        int row = 0;
        while (row < rows) {
            int col = 0;
            while (col < cols) {
                tr.setValueAt(col, row, this.getDoubleValueAt(row, col));
                ++col;
            }
            ++row;
        }
        return tr;
    }
}

