/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.smx.impl;

import ch.javasoft.math.BigFraction;
import ch.javasoft.math.ops.BigFractionOperations;
import ch.javasoft.smx.iface.BigIntegerRationalMatrix;
import ch.javasoft.smx.iface.DoubleMatrix;
import ch.javasoft.smx.iface.ReadableBigIntegerRationalMatrix;
import ch.javasoft.smx.iface.ReadableMatrix;
import ch.javasoft.smx.impl.DefaultDoubleMatrix;
import ch.javasoft.smx.ops.MatrixOperations;
import ch.javasoft.smx.ops.matrix.BigIntegerRationalMatrixOperations;
import ch.javasoft.util.StringUtil;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigInteger;
import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultBigIntegerRationalMatrix
implements BigIntegerRationalMatrix {
    private static final String NL = StringUtil.LINE_SEPARATOR;
    private final int mRowCount;
    private final int mColumnCount;
    private final BigInteger[] mNumerators;
    private final BigInteger[] mDenominators;

    public DefaultBigIntegerRationalMatrix(int rowCount, int colCount) {
        if (rowCount < 0) {
            throw new IllegalArgumentException("negative row count: " + rowCount);
        }
        if (colCount < 0) {
            throw new IllegalArgumentException("negative column count: " + colCount);
        }
        int vals = rowCount * colCount;
        this.mRowCount = rowCount;
        this.mColumnCount = colCount;
        this.mNumerators = new BigInteger[vals];
        this.mDenominators = new BigInteger[vals];
        Arrays.fill(this.mNumerators, BigInteger.ZERO);
        Arrays.fill(this.mDenominators, BigInteger.ONE);
    }

    public DefaultBigIntegerRationalMatrix(ReadableBigIntegerRationalMatrix mx) {
        this(mx.getRowCount(), mx.getColumnCount());
        int row = 0;
        while (row < mx.getRowCount()) {
            int col = 0;
            while (col < mx.getColumnCount()) {
                this.setValueAt(row, col, mx.getBigIntegerNumeratorAt(row, col), mx.getBigIntegerDenominatorAt(row, col));
                ++col;
            }
            ++row;
        }
    }

    public DefaultBigIntegerRationalMatrix(ReadableMatrix<BigFraction> mx) {
        this(mx.getRowCount(), mx.getColumnCount());
        int row = 0;
        while (row < mx.getRowCount()) {
            int col = 0;
            while (col < mx.getColumnCount()) {
                this.setValueAt(row, col, mx.getNumberValueAt(row, col));
                ++col;
            }
            ++row;
        }
    }

    protected DefaultBigIntegerRationalMatrix(DefaultBigIntegerRationalMatrix toClone) {
        this.mRowCount = toClone.mRowCount;
        this.mColumnCount = toClone.mColumnCount;
        this.mNumerators = (BigInteger[])toClone.mNumerators.clone();
        this.mDenominators = (BigInteger[])toClone.mDenominators.clone();
    }

    public DefaultBigIntegerRationalMatrix(String[] values, int rowCount, int colCount) {
        this(DefaultBigIntegerRationalMatrix.toBigIntegerFractionNumbers(values), rowCount, colCount);
    }

    public DefaultBigIntegerRationalMatrix(double[][] values, boolean rowIsFirstDim, boolean adjustDoubleValues) {
        this(DefaultBigIntegerRationalMatrix.toBigIntegerFractionNumbers(values, rowIsFirstDim, adjustDoubleValues), values.length, values.length == 0 ? 0 : values[0].length);
    }

    public DefaultBigIntegerRationalMatrix(double[] values, int rowCount, int colCount, boolean adjustDoubleValues) {
        this(DefaultBigIntegerRationalMatrix.toBigIntegerFractionNumbers(values, adjustDoubleValues, 0.0), rowCount, colCount);
    }

    public DefaultBigIntegerRationalMatrix(double[] values, int rowCount, int colCount, double adjustTolerance) {
        this(DefaultBigIntegerRationalMatrix.toBigIntegerFractionNumbers(values, true, adjustTolerance), rowCount, colCount);
    }

    public DefaultBigIntegerRationalMatrix(String[] numerators, String[] denominators, int rowCount, int colCount) {
        this(DefaultBigIntegerRationalMatrix.toBigIntegers(numerators), DefaultBigIntegerRationalMatrix.toBigIntegers(denominators), rowCount, colCount);
    }

    public DefaultBigIntegerRationalMatrix(long[] values, int rowCount, int colCount) {
        this(DefaultBigIntegerRationalMatrix.toBigIntegers(values), DefaultBigIntegerRationalMatrix.ones(values.length), rowCount, colCount);
    }

    public DefaultBigIntegerRationalMatrix(long[] numerators, long[] denominators, int rowCount, int colCount) {
        this(DefaultBigIntegerRationalMatrix.toBigIntegers(numerators), DefaultBigIntegerRationalMatrix.toBigIntegers(denominators), rowCount, colCount);
    }

    public DefaultBigIntegerRationalMatrix(BigFraction[][] values, boolean rowIsFirstDim) {
        this(DefaultBigIntegerRationalMatrix.toBigIntegerFractionNumbers(values, rowIsFirstDim), values.length, values.length == 0 ? 0 : values[0].length);
    }

    public DefaultBigIntegerRationalMatrix(BigFraction[] values, int rowCount, int colCount) {
        int expLen = rowCount * colCount;
        if (expLen != values.length) {
            throw new IllegalArgumentException("expected " + expLen + " numerators, but found " + values.length);
        }
        this.mRowCount = rowCount;
        this.mColumnCount = colCount;
        this.mNumerators = new BigInteger[expLen];
        this.mDenominators = new BigInteger[expLen];
        int i = 0;
        while (i < values.length) {
            this.mNumerators[i] = values[i].getNumerator();
            this.mDenominators[i] = values[i].getDenominator();
            ++i;
        }
    }

    public DefaultBigIntegerRationalMatrix(BigInteger[] numerators, BigInteger[] denominators, int rowCount, int colCount) {
        int expLen = rowCount * colCount;
        if (expLen != numerators.length) {
            throw new IllegalArgumentException("expected " + expLen + " numerators, but found " + numerators.length);
        }
        if (expLen != denominators.length) {
            throw new IllegalArgumentException("expected " + expLen + " denominators, but found " + denominators.length);
        }
        this.mNumerators = numerators;
        this.mDenominators = denominators;
        this.mRowCount = rowCount;
        this.mColumnCount = colCount;
    }

    public BigFractionOperations getNumberOperations() {
        return BigFractionOperations.instance();
    }

    @Override
    public MatrixOperations<BigFraction> getMatrixOperations() {
        return BigIntegerRationalMatrixOperations.instance();
    }

    @Override
    public BigFraction getBigFractionValueAt(int row, int col) {
        return new BigFraction(this.getBigIntegerNumeratorAt(row, col), this.getBigIntegerDenominatorAt(row, col));
    }

    @Override
    public BigInteger getBigIntegerNumeratorAt(int row, int col) {
        return this.mNumerators[row * this.mColumnCount + col];
    }

    @Override
    public BigInteger getBigIntegerDenominatorAt(int row, int col) {
        return this.mDenominators[row * this.mColumnCount + col];
    }

    @Override
    public int getSignumAt(int row, int col) {
        int num = this.getBigIntegerNumeratorAt(row, col).signum();
        int den = this.getBigIntegerDenominatorAt(row, col).signum();
        return num * den;
    }

    @Override
    public BigIntegerRationalMatrix subBigIntegerRationalMatrix(int rowStart, int rowEnd, int colStart, int colEnd) {
        int rows = this.getRowCount();
        int cols = this.getColumnCount();
        if (rowEnd < rowStart) {
            throw new IllegalArgumentException("rowEnd < rowStart");
        }
        if (colEnd < colStart) {
            throw new IllegalArgumentException("colEnd < colStart");
        }
        if (rowStart < 0) {
            throw new IllegalArgumentException("rowStart < 0");
        }
        if (colStart < 0) {
            throw new IllegalArgumentException("colStart < 0");
        }
        if (rowEnd > rows) {
            throw new IllegalArgumentException("rowEnd > getRowCount()");
        }
        if (colEnd > cols) {
            throw new IllegalArgumentException("colEnd > getColumnCount()");
        }
        int newRows = rowEnd - rowStart;
        int newCols = colEnd - colStart;
        int newVals = newRows * newCols;
        BigInteger[] numerators = new BigInteger[newVals];
        BigInteger[] denominators = new BigInteger[newVals];
        int row = 0;
        while (row < newRows) {
            System.arraycopy(this.mNumerators, (rowStart + row) * cols + colStart, numerators, row * newCols, newCols);
            System.arraycopy(this.mDenominators, (rowStart + row) * cols + colStart, denominators, row * newCols, newCols);
            ++row;
        }
        return new DefaultBigIntegerRationalMatrix(numerators, denominators, newRows, newCols);
    }

    @Override
    public BigIntegerRationalMatrix toBigIntegerRationalMatrix(boolean enforceNewInstance) {
        return enforceNewInstance ? this.clone() : this;
    }

    public BigIntegerRationalMatrix toWritableMatrix(boolean enforceNewInstance) {
        return this.toBigIntegerRationalMatrix(enforceNewInstance);
    }

    public BigIntegerRationalMatrix toReadableMatrix(boolean enforceNewInstance) {
        return this.toBigIntegerRationalMatrix(enforceNewInstance);
    }

    @Override
    public double[] getDoubleColumn(int col) {
        double[] colData = new double[this.getRowCount()];
        int row = 0;
        while (row < colData.length) {
            colData[row] = this.getDoubleValueAt(row, col);
            ++row;
        }
        return colData;
    }

    @Override
    public double[][] getDoubleColumns() {
        double[][] cols = new double[this.getColumnCount()][];
        int col = 0;
        while (col < cols.length) {
            cols[col] = this.getDoubleColumn(col);
            ++col;
        }
        return cols;
    }

    @Override
    public double[] getDoubleRow(int row) {
        double[] rowData = new double[this.getColumnCount()];
        int col = 0;
        while (col < rowData.length) {
            rowData[col] = this.getDoubleValueAt(row, col);
            ++col;
        }
        return rowData;
    }

    @Override
    public double[][] getDoubleRows() {
        double[][] rows = new double[this.getRowCount()][];
        int row = 0;
        while (row < rows.length) {
            rows[row] = this.getDoubleRow(row);
            ++row;
        }
        return rows;
    }

    @Override
    public double getDoubleValueAt(int row, int col) {
        return BigFraction.toDouble(this.getBigIntegerNumeratorAt(row, col), this.getBigIntegerDenominatorAt(row, col));
    }

    @Override
    public DoubleMatrix subDoubleMatrix(int rowStart, int rowEnd, int colStart, int colEnd) {
        return this.subBigIntegerRationalMatrix(rowStart, rowEnd, colStart, colEnd).toDoubleMatrix(false);
    }

    @Override
    public void toArray(double[] array) {
        if (array.length != this.mNumerators.length) {
            throw new IllegalArgumentException("expected array length " + this.mNumerators.length + " but found " + array.length);
        }
        int ii = 0;
        while (ii < array.length) {
            array[ii] = BigFraction.toDouble(this.mNumerators[ii], this.mDenominators[ii]);
            ++ii;
        }
    }

    @Override
    public double[] toDoubleArray() {
        double[] vals = new double[this.mNumerators.length];
        this.toArray(vals);
        return vals;
    }

    @Override
    public DoubleMatrix toDoubleMatrix(boolean enforceNewInstance) {
        return new DefaultDoubleMatrix(this.toDoubleArray(), this.getRowCount(), this.getColumnCount());
    }

    @Override
    public BigFraction getNumberValueAt(int row, int col) {
        return this.getBigFractionValueAt(row, col);
    }

    @Override
    public int getColumnCount() {
        return this.mColumnCount;
    }

    @Override
    public int getRowCount() {
        return this.mRowCount;
    }

    @Override
    public void add(int row, int col, BigInteger numerator, BigInteger denominator) {
        BigFraction cur = this.getBigFractionValueAt(row, col);
        BigFraction add = new BigFraction(numerator, denominator);
        BigFraction sum = cur.add(add).reduce();
        this.setValueAt(row, col, sum.getNumerator(), sum.getDenominator());
    }

    @Override
    public void addRowToOtherRow(int srcRow, BigInteger srcNumerator, BigInteger srcDenominator, int dstRow, BigInteger dstNumerator, BigInteger dstDenominator) {
        int cols = this.getColumnCount();
        int col = 0;
        while (col < cols) {
            BigFraction src = this.getBigFractionValueAt(srcRow, col);
            BigFraction dst = this.getBigFractionValueAt(dstRow, col);
            src = src.multiply(new BigFraction(srcNumerator, srcDenominator));
            dst = src.multiply(new BigFraction(dstNumerator, dstDenominator));
            BigFraction res = dst.add(src).reduce();
            this.setValueAt(dstRow, col, res.getNumerator(), res.getDenominator());
            ++col;
        }
    }

    @Override
    public void multiply(int row, int col, BigInteger numerator, BigInteger denominator) {
        BigFraction cur = this.getBigFractionValueAt(row, col);
        BigFraction mul = new BigFraction(numerator, denominator);
        BigFraction pro = cur.multiply(mul).reduce();
        this.setValueAt(row, col, pro.getNumerator(), pro.getDenominator());
    }

    @Override
    public void multiplyRow(int row, BigInteger numerator, BigInteger denominator) {
        int cols = this.getColumnCount();
        BigFraction mul = new BigFraction(numerator, denominator);
        int col = 0;
        while (col < cols) {
            BigFraction cur = this.getBigFractionValueAt(row, col);
            cur = cur.multiply(mul).reduce();
            this.setValueAt(row, col, cur.getNumerator(), cur.getDenominator());
            ++col;
        }
    }

    @Override
    public void setValueAt(int row, int col, BigInteger numerator, BigInteger denominator) {
        int index = row * this.mColumnCount + col;
        this.mNumerators[index] = numerator;
        this.mDenominators[index] = denominator;
    }

    @Override
    public void setValueAt(int row, int col, BigFraction value) {
        this.setValueAt(row, col, value.getNumerator(), value.getDenominator());
    }

    @Override
    public boolean reduce() {
        int rows = this.getRowCount();
        int cols = this.getColumnCount();
        boolean any = false;
        int row = 0;
        while (row < rows) {
            int col = 0;
            while (col < cols) {
                any |= this.reduceValueAt(row, col);
                ++col;
            }
            ++row;
        }
        return any;
    }

    @Override
    public boolean reduceRow(int row) {
        int cols = this.getColumnCount();
        boolean any = false;
        int col = 0;
        while (col < cols) {
            any |= this.reduceValueAt(row, col);
            ++col;
        }
        return any;
    }

    @Override
    public boolean reduceValueAt(int row, int col) {
        BigInteger num = this.getBigIntegerNumeratorAt(row, col);
        BigInteger den = this.getBigIntegerDenominatorAt(row, col);
        if (num.signum() == 0) {
            if (num != BigInteger.ZERO || den != BigInteger.ONE) {
                this.setValueAt(row, col, BigInteger.ZERO, BigInteger.ONE);
                return true;
            }
            return false;
        }
        BigInteger gcd = num.gcd(den);
        if (BigInteger.ONE.compareTo(gcd) != 0) {
            if (den.signum() < 0) {
                gcd = gcd.negate();
            }
            num = num.divide(gcd);
            den = den.divide(gcd);
            if (BigInteger.ONE.compareTo(num) == 0) {
                num = BigInteger.ONE;
            }
            if (BigInteger.ONE.compareTo(den) == 0) {
                den = BigInteger.ONE;
            }
            this.setValueAt(row, col, num, den);
            return true;
        }
        return false;
    }

    @Override
    public void add(int row, int col, long numerator, long denominator) {
        this.add(row, col, BigInteger.valueOf(numerator), BigInteger.valueOf(denominator));
    }

    @Override
    public void addRowToOtherRow(int srcRow, long srcNumerator, long srcDenominator, int dstRow, long dstNumerator, long dstDenominator) {
        this.addRowToOtherRow(srcRow, BigInteger.valueOf(srcNumerator), BigInteger.valueOf(srcDenominator), dstRow, BigInteger.valueOf(dstNumerator), BigInteger.valueOf(dstDenominator));
    }

    @Override
    public void multiply(int row, int col, long numerator, long denominator) {
        this.multiply(row, col, BigInteger.valueOf(numerator), BigInteger.valueOf(denominator));
    }

    @Override
    public void multiplyRow(int row, long numerator, long denominator) {
        this.multiplyRow(row, BigInteger.valueOf(numerator), BigInteger.valueOf(denominator));
    }

    @Override
    public void setValueAt(int row, int col, long numerator, long denominator) {
        this.setValueAt(row, col, BigInteger.valueOf(numerator), BigInteger.valueOf(denominator));
    }

    @Override
    public void add(int row, int col, long value) {
        this.add(row, col, BigInteger.valueOf(value), BigInteger.ONE);
    }

    @Override
    public void addRowToOtherRow(int srcRow, long srcFactor, int dstRow, long dstFactor) {
        this.addRowToOtherRow(srcRow, BigInteger.valueOf(srcFactor), BigInteger.ONE, dstRow, BigInteger.valueOf(dstFactor), BigInteger.ONE);
    }

    @Override
    public void multiply(int row, int col, long factor) {
        this.multiply(row, col, BigInteger.valueOf(factor), BigInteger.ONE);
    }

    @Override
    public void multiplyRow(int row, long factor) {
        this.multiplyRow(row, BigInteger.valueOf(factor), BigInteger.ONE);
    }

    @Override
    public void setValueAt(int row, int col, long value) {
        this.setValueAt(row, col, BigInteger.valueOf(value), BigInteger.ONE);
    }

    @Override
    public void add(int row, int col, int value) {
        this.add(row, col, (long)value);
    }

    @Override
    public void addRowToOtherRow(int srcRow, int srcFactor, int dstRow, int dstFactor) {
        this.addRowToOtherRow(srcRow, (long)srcFactor, dstRow, (long)dstFactor);
    }

    @Override
    public void multiply(int row, int col, int factor) {
        this.multiply(row, col, (long)factor);
    }

    @Override
    public void multiplyRow(int row, int factor) {
        this.multiplyRow(row, (long)factor);
    }

    @Override
    public void setValueAt(int row, int col, int value) {
        this.setValueAt(row, col, (long)value);
    }

    @Override
    public void swapColumns(int colA, int colB) {
        if (colA != colB) {
            int rows = this.getRowCount();
            int row = 0;
            while (row < rows) {
                BigInteger numA = this.getBigIntegerNumeratorAt(row, colA);
                BigInteger denA = this.getBigIntegerDenominatorAt(row, colA);
                BigInteger numB = this.getBigIntegerNumeratorAt(row, colB);
                BigInteger denB = this.getBigIntegerDenominatorAt(row, colB);
                this.setValueAt(row, colA, numB, denB);
                this.setValueAt(row, colB, numA, denA);
                ++row;
            }
        }
    }

    @Override
    public void swapRows(int rowA, int rowB) {
        if (rowA == rowB) {
            return;
        }
        int cols = this.getColumnCount();
        BigInteger[] tmp = new BigInteger[cols];
        System.arraycopy(this.mNumerators, rowA * cols, tmp, 0, cols);
        System.arraycopy(this.mNumerators, rowB * cols, this.mNumerators, rowA * cols, cols);
        System.arraycopy(tmp, 0, this.mNumerators, rowB * cols, cols);
        System.arraycopy(this.mDenominators, rowA * cols, tmp, 0, cols);
        System.arraycopy(this.mDenominators, rowB * cols, this.mDenominators, rowA * cols, cols);
        System.arraycopy(tmp, 0, this.mDenominators, rowB * cols, cols);
    }

    @Override
    public void add(int row, int col, int numerator, int denominator) {
        this.add(row, col, (long)numerator, (long)denominator);
    }

    @Override
    public void addRowToOtherRow(int srcRow, int srcNumerator, int srcDenominator, int dstRow, int dstNumerator, int dstDenominator) {
        this.addRowToOtherRow(srcRow, (long)srcNumerator, (long)srcDenominator, dstRow, (long)dstNumerator, (long)dstDenominator);
    }

    @Override
    public void multiply(int row, int col, int numerator, int denominator) {
        this.multiply(row, col, (long)numerator, (long)denominator);
    }

    @Override
    public void multiplyRow(int row, int numerator, int denominator) {
        this.multiplyRow(row, (long)numerator, (long)denominator);
    }

    @Override
    public void setValueAt(int row, int col, int numerator, int denominator) {
        this.setValueAt(row, col, (long)numerator, (long)denominator);
    }

    @Override
    public DefaultBigIntegerRationalMatrix clone() {
        return new DefaultBigIntegerRationalMatrix(this);
    }

    @Override
    public DefaultBigIntegerRationalMatrix newInstance(int rows, int cols) {
        return new DefaultBigIntegerRationalMatrix(rows, cols);
    }

    @Override
    public DefaultBigIntegerRationalMatrix newInstance(BigFraction[][] data, boolean rowsInDim1) {
        return new DefaultBigIntegerRationalMatrix(data, rowsInDim1);
    }

    private static BigInteger[] toBigIntegers(String[] values) {
        BigInteger[] vals = new BigInteger[values.length];
        int i = 0;
        while (i < vals.length) {
            vals[i] = new BigInteger(values[i]);
            ++i;
        }
        return vals;
    }

    private static BigInteger[] toBigIntegers(long[] values) {
        BigInteger[] vals = new BigInteger[values.length];
        int i = 0;
        while (i < vals.length) {
            vals[i] = BigInteger.valueOf(values[i]);
            ++i;
        }
        return vals;
    }

    private static BigInteger[] ones(int len) {
        BigInteger[] ones = new BigInteger[len];
        int i = 0;
        while (i < ones.length) {
            ones[i] = BigInteger.ONE;
            ++i;
        }
        return ones;
    }

    private static BigFraction[] toBigIntegerFractionNumbers(String[] values) {
        BigFraction[] vals = new BigFraction[values.length];
        int i = 0;
        while (i < vals.length) {
            vals[i] = BigFraction.valueOf(values[i]);
            ++i;
        }
        return vals;
    }

    private static BigFraction[] toBigIntegerFractionNumbers(double[] values, boolean adjustDoubleValues, double tolerance) {
        BigFraction[] vals = new BigFraction[values.length];
        int i = 0;
        while (i < vals.length) {
            vals[i] = adjustDoubleValues ? BigFraction.valueOfAdjusted(values[i], tolerance) : BigFraction.valueOf(values[i]);
            ++i;
        }
        return vals;
    }

    private static BigFraction[] toBigIntegerFractionNumbers(double[][] values, boolean rowIsFirstDim, boolean adjustDoubleValues) {
        int cols;
        int rows;
        if (rowIsFirstDim) {
            rows = values.length;
            cols = rows == 0 ? 0 : values[0].length;
        } else {
            cols = values.length;
            rows = cols == 0 ? 0 : values[0].length;
        }
        BigFraction[] vals = new BigFraction[rows * cols];
        int row = 0;
        while (row < rows) {
            int col = 0;
            while (col < cols) {
                double val = rowIsFirstDim ? values[row][col] : values[col][row];
                vals[row * cols + col] = adjustDoubleValues ? BigFraction.valueOfAdjusted(val) : BigFraction.valueOf(val);
                ++col;
            }
            ++row;
        }
        return vals;
    }

    private static BigFraction[] toBigIntegerFractionNumbers(BigFraction[][] values, boolean rowIsFirstDim) {
        int cols;
        int rows;
        if (rowIsFirstDim) {
            rows = values.length;
            cols = rows == 0 ? 0 : values[0].length;
        } else {
            cols = values.length;
            rows = cols == 0 ? 0 : values[0].length;
        }
        BigFraction[] vals = new BigFraction[rows * cols];
        int row = 0;
        while (row < rows) {
            System.arraycopy(values[row], 0, vals, row * cols, values[row].length);
            ++row;
        }
        return vals;
    }

    @Override
    public String toString() {
        return DefaultBigIntegerRationalMatrix.toString(this);
    }

    @Override
    public void writeTo(Writer writer) {
        DefaultBigIntegerRationalMatrix.writeTo(writer, (ReadableBigIntegerRationalMatrix)this);
    }

    @Override
    public void writeTo(OutputStream out) {
        DefaultBigIntegerRationalMatrix.writeTo(out, (ReadableBigIntegerRationalMatrix)this);
    }

    public static String toString(ReadableBigIntegerRationalMatrix mx) {
        return DefaultBigIntegerRationalMatrix.toString(mx, "{", " }", " [", "]", "", "", "", ", ");
    }

    public static void writeTo(Writer writer, ReadableBigIntegerRationalMatrix mx) {
        DefaultBigIntegerRationalMatrix.writeTo(writer instanceof PrintWriter ? (PrintWriter)writer : new PrintWriter(writer), mx, "{", " }", " [", "]", "", "", "", ", ");
    }

    public static void writeTo(OutputStream out, ReadableBigIntegerRationalMatrix mx) {
        DefaultBigIntegerRationalMatrix.writeTo(new PrintWriter(new OutputStreamWriter(out)), mx, "{", " }", " [", "]", "", "", "", ", ");
    }

    @Override
    public String toMultilineString() {
        return DefaultBigIntegerRationalMatrix.toMultilineString(this);
    }

    @Override
    public void writeToMultiline(Writer writer) {
        DefaultBigIntegerRationalMatrix.writeToMultiline(writer, (ReadableBigIntegerRationalMatrix)this);
    }

    @Override
    public void writeToMultiline(OutputStream out) {
        DefaultBigIntegerRationalMatrix.writeToMultiline(out, (ReadableBigIntegerRationalMatrix)this);
    }

    public static String toMultilineString(ReadableBigIntegerRationalMatrix mx) {
        return DefaultBigIntegerRationalMatrix.toString(mx, "{" + NL, "}" + NL, " [", "]" + NL, "", " ", " ", ",");
    }

    public static void writeToMultiline(Writer writer, ReadableBigIntegerRationalMatrix mx) {
        String sizeStr = String.valueOf(mx.getRowCount()) + "x" + mx.getColumnCount();
        DefaultBigIntegerRationalMatrix.writeTo(writer instanceof PrintWriter ? (PrintWriter)writer : new PrintWriter(writer), mx, String.valueOf(sizeStr) + " {" + NL, "}" + NL, " [", "]" + NL, "", " ", " ", ",");
    }

    public static void writeToMultiline(OutputStream out, ReadableBigIntegerRationalMatrix mx) {
        String sizeStr = String.valueOf(mx.getRowCount()) + "x" + mx.getColumnCount();
        DefaultBigIntegerRationalMatrix.writeTo(new PrintWriter(new OutputStreamWriter(out)), mx, String.valueOf(sizeStr) + " {" + NL, "}" + NL, " [", "]" + NL, "", " ", " ", ",");
    }

    protected static String toString(ReadableBigIntegerRationalMatrix mx, String prefix, String postfix, String rowPrefix, String rowPostfix, String rowSeparator, String colPrefix, String colPostfix, String colSeparator) {
        StringWriter sw = new StringWriter();
        DefaultBigIntegerRationalMatrix.writeTo(new PrintWriter(sw), mx, prefix, postfix, rowPrefix, rowPostfix, rowSeparator, colPrefix, colPostfix, colSeparator);
        return sw.toString();
    }

    protected static void writeTo(PrintWriter writer, ReadableBigIntegerRationalMatrix mx, String prefix, String postfix, String rowPrefix, String rowPostfix, String rowSeparator, String colPrefix, String colPostfix, String colSeparator) {
        int rows = mx.getRowCount();
        int cols = mx.getColumnCount();
        writer.print(prefix);
        int row = 0;
        while (row < rows) {
            if (row > 0) {
                writer.print(rowSeparator);
            }
            writer.print(rowPrefix);
            int col = 0;
            while (col < cols) {
                if (col > 0) {
                    writer.print(colSeparator);
                }
                writer.print(colPrefix);
                writer.print(mx.getBigFractionValueAt(row, col));
                writer.print(colPostfix);
                ++col;
            }
            writer.print(rowPostfix);
            ++row;
        }
        writer.print(postfix);
        writer.flush();
    }

    @Override
    public DefaultBigIntegerRationalMatrix transpose() {
        int rows = this.getRowCount();
        int cols = this.getColumnCount();
        DefaultBigIntegerRationalMatrix tr = new DefaultBigIntegerRationalMatrix(cols, rows);
        int row = 0;
        while (row < rows) {
            int col = 0;
            while (col < cols) {
                tr.setValueAt(col, row, this.getBigIntegerNumeratorAt(row, col), this.getBigIntegerDenominatorAt(row, col));
                ++col;
            }
            ++row;
        }
        return tr;
    }

    public BigFraction[][] getNumberRows() {
        return DefaultBigIntegerRationalMatrix.getNumberRows(this);
    }

    public static BigFraction[][] getNumberRows(ReadableBigIntegerRationalMatrix<BigFraction> mx) {
        int rows = mx.getRowCount();
        int cols = mx.getColumnCount();
        BigFraction[][] data = new BigFraction[rows][cols];
        int row = 0;
        while (row < rows) {
            int col = 0;
            while (col < cols) {
                data[row][col] = mx.getBigFractionValueAt(row, col);
                ++col;
            }
            ++row;
        }
        return data;
    }

    @Override
    public void add(int row, int col, BigInteger value) {
        this.add(row, col, value, BigInteger.ONE);
    }

    @Override
    public void addRowToOtherRow(int srcRow, BigInteger srcFactor, int dstRow, BigInteger dstFactor) {
        this.addRowToOtherRow(srcRow, srcFactor, BigInteger.ONE, dstRow, dstFactor, BigInteger.ONE);
    }

    @Override
    public void multiply(int row, int col, BigInteger factor) {
        this.multiply(row, col, factor, BigInteger.ONE);
    }

    @Override
    public void multiplyRow(int row, BigInteger factor) {
        this.multiplyRow(row, factor, BigInteger.ONE);
    }

    @Override
    public void setValueAt(int row, int col, BigInteger value) {
        this.setValueAt(row, col, value, BigInteger.ONE);
    }

    @Override
    public void negate(int row, int col) {
        BigFraction val = this.getBigFractionValueAt(row, col);
        this.setValueAt(row, col, val.signum() == 0 ? BigFraction.ZERO : val.negate());
    }
}

