/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.polco.parse;

import ch.javasoft.math.array.NumberArrayOperations;
import ch.javasoft.polco.PolyhedralCone;
import ch.javasoft.polco.config.Arithmetic;
import ch.javasoft.polco.impl.DefaultInequalityCone;
import ch.javasoft.polco.parse.InputStreamParser;
import ch.javasoft.polco.parse.LogPkg;
import ch.javasoft.polco.parse.util.ArithmeticConverter;
import ch.javasoft.polco.parse.util.SortUtil;
import ch.javasoft.polymake.parse.PolymakeMatrixData;
import ch.javasoft.util.numeric.Zero;
import java.io.IOException;
import java.io.InputStream;
import org.dom4j.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PolymakeParser
implements InputStreamParser {
    @Override
    public <N extends Number, A> PolyhedralCone<N, A> parse(Element config, Arithmetic<N, A> arithmetic, Zero zero, InputStream in) throws IOException {
        ch.javasoft.polymake.parse.PolymakeParser parser = new ch.javasoft.polymake.parse.PolymakeParser(in);
        LogPkg.LOGGER.info("parsed " + parser);
        LogPkg.LOGGER.info("using " + (Object)((Object)parser.getData(0).getDefinitionType()) + " as algorithm input");
        A[] matrix = PolymakeParser.getMatrix(arithmetic, zero, parser.getData(0));
        SortUtil.sortMatrix(config, arithmetic, zero, matrix);
        return new DefaultInequalityCone<N, A>(arithmetic.getLinAlgOperations(zero), matrix);
    }

    private static <N extends Number, A> A[] getMatrix(Arithmetic<N, A> arithmetic, Zero zero, PolymakeMatrixData polymakeMatrixData) {
        NumberArrayOperations naops = arithmetic.getLinAlgOperations(zero).getNumberArrayOperations();
        try {
            return polymakeMatrixData.getMatrixCast(naops.getNumberOperators().arrayClass());
        }
        catch (ClassCastException e) {
            return polymakeMatrixData.getMatrixConverted(new ArithmeticConverter<N, A>(arithmetic, zero));
        }
    }
}

