/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.polco.callback;

import ch.javasoft.math.array.NumberArrayOperations;
import ch.javasoft.polco.xenum.ExtremeRayCallback;
import ch.javasoft.polco.xenum.ExtremeRayEvent;
import java.io.OutputStream;
import java.io.PrintStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextCallback<Num extends Number, Arr>
implements ExtremeRayCallback<Num, Arr> {
    private final PrintStream print;

    public TextCallback(OutputStream out) {
        this.print = out instanceof PrintStream ? (PrintStream)out : new PrintStream(out);
    }

    @Override
    public boolean initialize(ExtremeRayEvent<Num, Arr> event) {
        return true;
    }

    @Override
    public void outputExtremeRay(ExtremeRayEvent<Num, Arr> event, long index, Arr extremeRay) {
        NumberArrayOperations naops = event.getPolyhedralCone().getLinAlgOperations().getNumberArrayOperations();
        int cnt = naops.getArrayOperations().getLength(extremeRay);
        int i = 0;
        while (i < cnt) {
            if (i > 0) {
                this.print.print('\t');
            }
            this.print.print(naops.get(extremeRay, i));
            ++i;
        }
        this.print.println();
    }

    @Override
    public void terminate(ExtremeRayEvent<Num, Arr> event) {
        this.print.flush();
    }
}

