/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.util;

import ch.javasoft.metabolic.MetabolicNetwork;
import ch.javasoft.metabolic.Reaction;

public class MetabolicNetworkUtil {
    public static String getNetworkSizeString(String prefix, MetabolicNetwork net) {
        int cntRev = 0;
        for (Reaction reaction : net.getReactions()) {
            if (!reaction.getConstraints().isReversible()) continue;
            ++cntRev;
        }
        return String.valueOf(prefix == null ? "" : prefix) + net.getMetabolites().length() + " metabolites, " + net.getReactions().length() + " reactions (" + cntRev + " reversible)";
    }

    public static String getReactionNamesString(MetabolicNetwork net) {
        StringBuilder sb = new StringBuilder();
        for (Reaction reaction : net.getReactions()) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(reaction.getName());
        }
        return sb.toString();
    }

    private MetabolicNetworkUtil() {
    }
}

