/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.impl;

import ch.javasoft.metabolic.MetabolicNetwork;
import ch.javasoft.metabolic.Metabolite;
import ch.javasoft.metabolic.MetaboliteRatio;
import ch.javasoft.metabolic.Reaction;
import ch.javasoft.metabolic.ReactionConstraints;
import ch.javasoft.metabolic.impl.AbstractMetabolicNetwork;
import ch.javasoft.metabolic.impl.AbstractNamedReaction;
import ch.javasoft.metabolic.impl.DefaultMetabolicNetwork;
import ch.javasoft.metabolic.impl.DefaultMetaboliteRatio;
import ch.javasoft.metabolic.impl.DefaultReactionConstraints;
import ch.javasoft.metabolic.util.StoichiometricMatrices;
import ch.javasoft.smx.iface.DoubleMatrix;
import ch.javasoft.smx.impl.DefaultDoubleMatrix;
import ch.javasoft.util.genarr.AbstractArrayIterable;
import ch.javasoft.util.genarr.ArrayIterable;
import ch.javasoft.util.genarr.GenericDynamicArray;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StoichMatrixMetabolicNetwork
extends AbstractMetabolicNetwork {
    private final double[][] mStoichMatrix;
    private final Metabolite[] mMetabolites;
    private final String[] mReactionNames;
    private final ReactionConstraints[] mReactionConstraints;
    private final int[] mMetaboliteIndices;
    private int mMetaboliteCount;
    private final int[] mReactionIndices;
    private int mReactionCount;
    private transient GenericDynamicArray<Metabolite> tMetabolites;
    private transient GenericDynamicArray<Reaction> tReactions;

    public StoichMatrixMetabolicNetwork(MetabolicNetwork metaNet) {
        this(StoichiometricMatrices.createStoichiometricMatrix(metaNet), metaNet.getMetabolites().toArray(new Metabolite[metaNet.getMetabolites().length()]), StoichMatrixMetabolicNetwork.reactionNames(metaNet), StoichMatrixMetabolicNetwork.reactionConstraints(metaNet));
    }

    public StoichMatrixMetabolicNetwork(double[][] stoichMatrix, boolean[] reactionRevesibilities) {
        this(stoichMatrix, DefaultMetabolicNetwork.metaboliteNames(stoichMatrix), DefaultMetabolicNetwork.reactionNames(stoichMatrix), reactionRevesibilities);
    }

    public StoichMatrixMetabolicNetwork(double[][] stoichMatrix, String[] metaboliteNames, String[] reactionNames, boolean[] reactionRevesibilities) {
        this(stoichMatrix, metaboliteNames, reactionNames, StoichMatrixMetabolicNetwork.createReactionConstraints(reactionRevesibilities));
    }

    public StoichMatrixMetabolicNetwork(double[][] stoichMatrix, Metabolite[] metabolites, String[] reactionNames, boolean[] reactionRevesibilities) {
        this(stoichMatrix, metabolites, reactionNames, StoichMatrixMetabolicNetwork.createReactionConstraints(reactionRevesibilities));
    }

    public StoichMatrixMetabolicNetwork(double[][] stoichMatrix, String[] metaboliteNames, String[] reactionNames, ReactionConstraints[] reactionConstraints) {
        this(stoichMatrix, DefaultMetabolicNetwork.metabolites(metaboliteNames), reactionNames, reactionConstraints);
    }

    public StoichMatrixMetabolicNetwork(double[][] stoichMatrix, Metabolite[] metabolites, String[] reactionNames, ReactionConstraints[] reactionConstraints) {
        this.mStoichMatrix = stoichMatrix;
        this.mMetabolites = metabolites;
        this.mReactionNames = reactionNames;
        this.mReactionConstraints = reactionConstraints;
        this.mMetaboliteIndices = new int[metabolites.length];
        this.mReactionIndices = new int[reactionNames.length];
        this.initIndicesAndCounts();
    }

    public void swapMetabolites(int metaboliteIndexA, int metaboliteIndexB) {
        StoichMatrixMetabolicNetwork.swap(this.mMetaboliteIndices, metaboliteIndexA, metaboliteIndexB);
        this.tMetabolites = null;
        this.tReactions = null;
    }

    public void swapReactions(int reactionIndexA, int reactionIndexB) {
        StoichMatrixMetabolicNetwork.swap(this.mReactionIndices, reactionIndexA, reactionIndexB);
        this.tMetabolites = null;
        this.tReactions = null;
    }

    public int getMetaboliteIndex(Metabolite meta) {
        int ii = 0;
        while (ii < this.mMetaboliteCount) {
            if (meta.equals(this.mMetabolites[this.mMetaboliteIndices[ii]])) {
                return ii;
            }
            ++ii;
        }
        return -1;
    }

    public int hideMetabolite(Metabolite meta) {
        int metaIndex = this.getMetaboliteIndex(meta);
        if (metaIndex == -1) {
            throw new IllegalArgumentException("no such metabolite: " + meta);
        }
        return this.hideMetabolite(metaIndex);
    }

    public int hideMetabolite(int metaboliteIndex) {
        --this.mMetaboliteCount;
        this.swapMetabolites(metaboliteIndex, this.mMetaboliteCount);
        return this.mMetaboliteIndices[this.mMetaboliteCount];
    }

    public int getReactionIndex(Reaction react) {
        ArrayIterable<Reaction> reacts = this.getReactions();
        int ii = 0;
        while (ii < reacts.length()) {
            if (react.equals(reacts.get(ii))) {
                return ii;
            }
            ++ii;
        }
        return -1;
    }

    public int hideReaction(Reaction react) {
        int reactionIndex = this.getReactionIndex(react);
        if (reactionIndex == -1) {
            throw new IllegalArgumentException("no such reaction: " + react);
        }
        return this.hideReaction(reactionIndex);
    }

    public int hideReaction(int reactionIndex) {
        --this.mReactionCount;
        this.swapReactions(reactionIndex, this.mReactionCount);
        return this.mReactionIndices[this.mReactionCount];
    }

    private void initIndicesAndCounts() {
        int ii = 0;
        while (ii < this.mMetaboliteIndices.length) {
            this.mMetaboliteIndices[ii] = ii;
            ++ii;
        }
        ii = 0;
        while (ii < this.mReactionIndices.length) {
            this.mReactionIndices[ii] = ii;
            ++ii;
        }
        this.mMetaboliteCount = this.mMetaboliteIndices.length;
        this.mReactionCount = this.mReactionIndices.length;
    }

    public ArrayIterable<Metabolite> getMetabolites() {
        if (this.tMetabolites == null) {
            this.tMetabolites = StoichMatrixMetabolicNetwork.createMetabolites(this);
        }
        return this.tMetabolites;
    }

    public ArrayIterable<Reaction> getReactions() {
        if (this.tReactions == null) {
            this.tReactions = StoichMatrixMetabolicNetwork.createReactions(this);
        }
        return this.tReactions;
    }

    protected double getStoichiometricValue(int metaIndex, int reactionIndex) {
        return this.mStoichMatrix[metaIndex][reactionIndex];
    }

    public DoubleMatrix getStoichiometricMatrix() {
        return new DefaultDoubleMatrix(this.mStoichMatrix, true);
    }

    private static GenericDynamicArray<Metabolite> createMetabolites(StoichMatrixMetabolicNetwork net) {
        GenericDynamicArray<Metabolite> result = new GenericDynamicArray<Metabolite>(net.mMetaboliteCount);
        int ii = 0;
        while (ii < net.mMetaboliteCount) {
            result.add(net.mMetabolites[net.mMetaboliteIndices[ii]]);
            ++ii;
        }
        return result;
    }

    private static GenericDynamicArray<Reaction> createReactions(final StoichMatrixMetabolicNetwork net) {
        GenericDynamicArray<Reaction> result = new GenericDynamicArray<Reaction>(net.mReactionCount);
        int ii = 0;
        while (ii < net.mReactionCount) {
            final int reactionIndex = net.mReactionIndices[ii];
            result.add(new AbstractNamedReaction(net.mReactionNames[reactionIndex]){

                public ArrayIterable<MetaboliteRatio> getMetaboliteRatios() {
                    return new AbstractArrayIterable<MetaboliteRatio>(){
                        private int[] mMetaboliteIndices = this.initMetaIndices();

                        private int[] initMetaIndices() {
                            int cnt = 0;
                            int[] inds = new int[net.mMetaboliteCount];
                            int ii = 0;
                            while (ii < net.mMetaboliteCount) {
                                int metaIndex = net.mMetaboliteIndices[ii];
                                if (net.getStoichiometricValue(metaIndex, reactionIndex) != 0.0) {
                                    inds[cnt] = metaIndex;
                                    ++cnt;
                                }
                                ++ii;
                            }
                            int[] result = new int[cnt];
                            System.arraycopy(inds, 0, result, 0, cnt);
                            return result;
                        }

                        @Override
                        public MetaboliteRatio get(int index) throws IndexOutOfBoundsException {
                            int metaIndex = this.mMetaboliteIndices[index];
                            return new DefaultMetaboliteRatio(net.mMetabolites[metaIndex], net.getStoichiometricValue(metaIndex, reactionIndex));
                        }

                        @Override
                        public int length() {
                            return this.mMetaboliteIndices.length;
                        }
                    };
                }

                @Override
                public ReactionConstraints getConstraints() {
                    return net.mReactionConstraints[reactionIndex];
                }

                @Override
                public double getRatioValueForMetabolite(Metabolite metabolite) {
                    int metaIndex = net.mMetaboliteIndices[net.getMetaboliteIndex(metabolite)];
                    return net.getStoichiometricValue(metaIndex, reactionIndex);
                }
            });
            ++ii;
        }
        return result;
    }

    private static ReactionConstraints[] createReactionConstraints(boolean[] reactionReversibilities) {
        ReactionConstraints[] constraints = new ReactionConstraints[reactionReversibilities.length];
        int ii = 0;
        while (ii < constraints.length) {
            constraints[ii] = reactionReversibilities[ii] ? DefaultReactionConstraints.DEFAULT_REVERSIBLE : DefaultReactionConstraints.DEFAULT_IRREVERSIBLE;
            ++ii;
        }
        return constraints;
    }

    private static String[] reactionNames(MetabolicNetwork metaNet) {
        ArrayIterable<? extends Reaction> reacts = metaNet.getReactions();
        String[] names = new String[reacts.length()];
        int ii = 0;
        while (ii < names.length) {
            names[ii] = reacts.get(ii).getName();
            ++ii;
        }
        return names;
    }

    private static ReactionConstraints[] reactionConstraints(MetabolicNetwork metaNet) {
        ArrayIterable<? extends Reaction> reacts = metaNet.getReactions();
        ReactionConstraints[] constraints = new ReactionConstraints[reacts.length()];
        int ii = 0;
        while (ii < constraints.length) {
            constraints[ii] = reacts.get(ii).getConstraints();
            ++ii;
        }
        return constraints;
    }

    private static void swap(int[] indices, int indexA, int indexB) {
        if (indexA != indexB) {
            int tmp = indices[indexA];
            indices[indexA] = indices[indexB];
            indices[indexB] = tmp;
        }
    }
}

