/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.impl;

import ch.javasoft.metabolic.MetabolicNetwork;
import ch.javasoft.metabolic.Metabolite;
import ch.javasoft.metabolic.MetaboliteRatio;
import ch.javasoft.metabolic.Reaction;
import ch.javasoft.metabolic.ReactionConstraints;
import ch.javasoft.metabolic.impl.AbstractMetabolicNetwork;
import ch.javasoft.metabolic.impl.AbstractNamedReaction;
import ch.javasoft.metabolic.impl.DefaultMetabolite;
import ch.javasoft.metabolic.impl.DefaultMetaboliteRatio;
import ch.javasoft.smx.iface.ReadableMatrix;
import ch.javasoft.smx.iface.WritableMatrix;
import ch.javasoft.util.genarr.ArrayIterable;
import ch.javasoft.util.genarr.GenericDynamicArray;
import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.HashSet;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilteredMetabolicNetwork
extends AbstractMetabolicNetwork {
    private final MetabolicNetwork mNetwork;
    private final Set<Metabolite> mExcludedMetas = new HashSet<Metabolite>();
    private final Set<Reaction> mExcludedReacs = new HashSet<Reaction>();
    private transient GenericDynamicArray<Metabolite> tMetabolites = null;
    private transient GenericDynamicArray<Reaction> tReactions = null;

    public FilteredMetabolicNetwork(MetabolicNetwork network) {
        this.mNetwork = network;
    }

    public FilteredMetabolicNetwork(MetabolicNetwork network, Set<String> suppressedReactions) {
        this(network);
        if (suppressedReactions != null) {
            this.excludeReactions(suppressedReactions.toArray(new String[suppressedReactions.size()]));
        }
    }

    public void excludeMetabolite(String metaboliteName, boolean removeConcernedReactions) {
        this.excludeMetabolite(new DefaultMetabolite(metaboliteName), removeConcernedReactions);
    }

    public void excludeMetabolites(String[] metaboliteNames, boolean removeConcernedReactions) {
        int ii = 0;
        while (ii < metaboliteNames.length) {
            this.excludeMetabolite(new DefaultMetabolite(metaboliteNames[ii]), removeConcernedReactions);
            ++ii;
        }
    }

    public void excludeMetabolite(Metabolite metabolite, boolean removeConcernedReactions) {
        if (this.mExcludedMetas.add(metabolite)) {
            if (removeConcernedReactions) {
                for (Reaction reaction : this.mNetwork.getReactions()) {
                    if (this.mExcludedReacs.contains(reaction) || !reaction.isMetaboliteParticipating(metabolite)) continue;
                    this.excludeReaction(reaction);
                }
            }
            this.tMetabolites = null;
            this.tReactions = null;
        }
    }

    public void excludeReactions(String ... reactionNames) {
        int ii = 0;
        while (ii < reactionNames.length) {
            this.excludeReaction(reactionNames[ii]);
            ++ii;
        }
    }

    public void excludeReaction(String reactionName) {
        for (Reaction reac : this.getReactions()) {
            if (!reac.getName().equals(reactionName)) continue;
            this.excludeReaction(reac);
            return;
        }
        throw new IllegalArgumentException("no such reaction: " + reactionName);
    }

    public void excludeReaction(Reaction reaction) {
        if (this.mExcludedReacs.add(reaction)) {
            for (MetaboliteRatio metaboliteRatio : reaction.getMetaboliteRatios()) {
                Metabolite meta = metaboliteRatio.getMetabolite();
                if (this.mExcludedMetas.contains(meta)) continue;
                int cnt = 0;
                ListIterator<? extends Reaction> it = this.mNetwork.getReactions(meta).iterator();
                while (it.hasNext() && cnt == 0) {
                    Reaction reac = (Reaction)it.next();
                    if (this.mExcludedReacs.contains(reac)) continue;
                    ++cnt;
                }
                if (cnt != 0) continue;
                this.mExcludedMetas.add(meta);
            }
            this.tMetabolites = null;
            this.tReactions = null;
        }
    }

    public ArrayIterable<Metabolite> getMetabolites() {
        if (this.tMetabolites == null) {
            this.tMetabolites = new GenericDynamicArray();
            for (Metabolite metabolite : this.mNetwork.getMetabolites()) {
                if (this.mExcludedMetas.contains(metabolite)) continue;
                this.tMetabolites.add(metabolite);
            }
        }
        return this.tMetabolites;
    }

    public ArrayIterable<Reaction> getReactions() {
        if (this.tReactions == null) {
            HashMap<Metabolite, Integer> metaCounter = new HashMap<Metabolite, Integer>();
            this.tReactions = new GenericDynamicArray();
            for (Reaction reaction : this.mNetwork.getReactions()) {
                if (this.mExcludedReacs.contains(reaction)) continue;
                this.tReactions.add(this.mapReaction(reaction, metaCounter));
            }
        }
        return this.tReactions;
    }

    private Reaction mapReaction(final Reaction reaction, Map<Metabolite, Integer> metaboliteCounter) {
        boolean mustWrap = false;
        for (MetaboliteRatio metaboliteRatio : reaction.getMetaboliteRatios()) {
            Metabolite meta = metaboliteRatio.getMetabolite();
            if (!this.mExcludedMetas.contains(meta)) continue;
            mustWrap = true;
            break;
        }
        if (mustWrap) {
            final GenericDynamicArray<MetaboliteRatio> genericDynamicArray = new GenericDynamicArray<MetaboliteRatio>();
            for (MetaboliteRatio metaboliteRatio : reaction.getMetaboliteRatios()) {
                Metabolite meta = metaboliteRatio.getMetabolite();
                if (this.mExcludedMetas.contains(meta)) {
                    Integer iIndex = metaboliteCounter.get(meta);
                    int index = iIndex == null ? 0 : iIndex;
                    metaboliteCounter.put(meta, index + 1);
                    genericDynamicArray.add(new DefaultMetaboliteRatio(new DefaultMetabolite(String.valueOf(meta.getName()) + "-" + index), metaboliteRatio.getRatio()));
                    continue;
                }
                genericDynamicArray.add(metaboliteRatio);
            }
            return new AbstractNamedReaction(reaction.getName()){

                public ArrayIterable<MetaboliteRatio> getMetaboliteRatios() {
                    return genericDynamicArray;
                }

                @Override
                public ReactionConstraints getConstraints() {
                    return reaction.getConstraints();
                }
            };
        }
        return reaction;
    }

    @Override
    public ReadableMatrix<?> getStoichiometricMatrix() {
        ReadableMatrix<?> orig = this.mNetwork.getStoichiometricMatrix();
        int origMetas = orig.getRowCount();
        int origReacs = orig.getColumnCount();
        int metas = this.getMetabolites().length();
        int reacs = this.getReactions().length();
        Number[][] stoich = (Number[][])Array.newInstance(orig.getNumberValueAt(0, 0).getClass(), metas, reacs);
        int metaInd = 0;
        int m = 0;
        while (m < origMetas) {
            Metabolite meta = this.mNetwork.getMetabolites().get(m);
            if (!this.mExcludedMetas.contains(meta)) {
                int reacInd = 0;
                int r = 0;
                while (r < origReacs) {
                    Reaction reac = this.mNetwork.getReactions().get(r);
                    if (!this.mExcludedReacs.contains(reac)) {
                        stoich[metaInd][reacInd] = orig.getNumberValueAt(m, r);
                        ++reacInd;
                    }
                    ++r;
                }
                ++metaInd;
            }
            ++m;
        }
        WritableMatrix stoichMx = orig.newInstance(stoich, true);
        return stoichMx.toReadableMatrix(false);
    }
}

