/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.impl;

import ch.javasoft.metabolic.MetabolicNetwork;
import ch.javasoft.metabolic.Norm;
import ch.javasoft.metabolic.Reaction;
import ch.javasoft.metabolic.impl.AbstractFluxDistribution;
import ch.javasoft.metabolic.util.FluxNormalizer;
import ch.javasoft.util.numeric.Zero;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultFluxDistribution
extends AbstractFluxDistribution {
    private final double[] mRates;

    public DefaultFluxDistribution(MetabolicNetwork network, double[] rates) {
        super(network);
        this.mRates = rates;
    }

    @Override
    public int getSize() {
        return this.mRates.length;
    }

    @Override
    public double[] getDoubleRates() {
        return this.mRates;
    }

    @Override
    public double getRate(Reaction reaction) {
        int index = this.getReactionIndex(reaction);
        if (index < 0) {
            throw new IllegalArgumentException("no such reaction in the network: " + reaction);
        }
        return this.mRates[index];
    }

    @Override
    public Double getNumberRate(Reaction reaction) {
        return this.getRate(reaction);
    }

    @Override
    public Number getNumberRate(int index) {
        return this.mRates[index];
    }

    @Override
    public int getRateSignum(int index) {
        return (int)Math.signum(this.mRates[index]);
    }

    public Number getCombinedRate(int indexForward, int indexBackward) {
        return this.mRates[indexForward] - this.mRates[indexBackward];
    }

    @Override
    public void setRate(int index, Number rate) {
        this.mRates[index] = rate.doubleValue();
    }

    @Override
    public void setRate(Reaction reaction, Number rate) {
        int index = this.getReactionIndex(reaction);
        if (index < 0) {
            throw new IllegalArgumentException("no such reaction in the network: " + reaction);
        }
        this.setRate(index, rate);
    }

    public Class<Double> getPreferredNumberClass() {
        return Double.class;
    }

    @Override
    public void norm(Norm norm, Zero zero) {
        switch (norm) {
            case max: {
                FluxNormalizer.normalizeMax(this.mNetwork, this.mRates, zero);
                break;
            }
            case min: {
                FluxNormalizer.normalizeMin(this.mNetwork, this.mRates, zero);
                break;
            }
            case norm2: {
                FluxNormalizer.normalizeNorm2(this.mNetwork, this.mRates, zero);
                break;
            }
            case squared: {
                FluxNormalizer.normalizeSquared(this.mNetwork, this.mRates, zero);
                break;
            }
            case none: {
                break;
            }
            default: {
                throw new IllegalArgumentException("unsupported normalization: " + (Object)((Object)norm));
            }
        }
    }

    @Override
    public DefaultFluxDistribution clone() {
        return new DefaultFluxDistribution(this.mNetwork, (double[])this.mRates.clone());
    }

    @Override
    public DefaultFluxDistribution create(MetabolicNetwork net) {
        return new DefaultFluxDistribution(net, new double[net.getReactions().length()]);
    }

    @Override
    public int hashCode() {
        int code = this.mNetwork.hashCode();
        int ii = 0;
        while (ii < this.mRates.length) {
            long bits = Double.doubleToLongBits(this.mRates[ii]);
            code ^= (int)(bits ^ bits >>> 32);
            ++ii;
        }
        return code;
    }

    @Override
    public boolean equals(Object obj) {
        DefaultFluxDistribution dist;
        if (obj == this) {
            return true;
        }
        if (obj instanceof DefaultFluxDistribution && this.mNetwork.equals((dist = (DefaultFluxDistribution)obj).getNetwork())) {
            double[] dRates = dist.mRates;
            int ii = 0;
            while (ii < this.mRates.length) {
                if (this.mRates[ii] != dRates[ii]) {
                    return false;
                }
                ++ii;
            }
            return true;
        }
        return false;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append('[');
        int ii = 0;
        while (ii < this.mRates.length) {
            if (ii > 0) {
                sb.append(", ");
            }
            sb.append(this.mRates[ii]);
            ++ii;
        }
        sb.append(']');
        return sb.toString();
    }
}

