/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.impl;

import ch.javasoft.metabolic.FluxDistribution;
import ch.javasoft.metabolic.MetabolicNetwork;
import ch.javasoft.metabolic.Reaction;

public abstract class AbstractFluxDistribution
implements FluxDistribution {
    protected final MetabolicNetwork mNetwork;

    public AbstractFluxDistribution(MetabolicNetwork network) {
        this.mNetwork = network;
    }

    public MetabolicNetwork getNetwork() {
        return this.mNetwork;
    }

    public int getReactionIndex(Reaction reaction) {
        try {
            int index = this.mNetwork.getReactionIndex(reaction.getName());
            if (reaction.equals(this.mNetwork.getReactions().get(index))) {
                return index;
            }
            return -1;
        }
        catch (IllegalArgumentException ex) {
            return -1;
        }
    }

    public double getRate(Reaction reaction) {
        return this.getNumberRate(reaction).doubleValue();
    }

    public void setRate(Reaction reaction, Number rate) {
        int index = this.getReactionIndex(reaction);
        if (index < 0) {
            throw new IllegalArgumentException("no such reaction in the network: " + reaction);
        }
        this.setRate(index, rate);
    }

    public double[] getDoubleRates() {
        double[] rates = new double[this.getSize()];
        int i = 0;
        while (i < rates.length) {
            rates[i] = this.getNumberRate(i).doubleValue();
            ++i;
        }
        return rates;
    }

    public abstract AbstractFluxDistribution clone();

    public int hashCode() {
        int len = this.getSize();
        int code = this.mNetwork.hashCode();
        int ii = 0;
        while (ii < len) {
            code ^= this.getNumberRate(ii).hashCode();
            ++ii;
        }
        return code;
    }

    public boolean equals(Object obj) {
        FluxDistribution dist;
        if (obj == this) {
            return true;
        }
        if (obj instanceof FluxDistribution && this.mNetwork.equals((dist = (FluxDistribution)obj).getNetwork())) {
            int len = this.getSize();
            int ii = 0;
            while (ii < len) {
                if (!this.getNumberRate(ii).equals(dist.getNumberRate(ii))) {
                    return false;
                }
                ++ii;
            }
            return true;
        }
        return false;
    }

    public String toString() {
        int len = this.getSize();
        StringBuffer sb = new StringBuffer();
        sb.append('[');
        int ii = 0;
        while (ii < len) {
            if (ii > 0) {
                sb.append(", ");
            }
            sb.append(this.getNumberRate(ii));
            ++ii;
        }
        sb.append(']');
        return sb.toString();
    }
}

