/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.generate;

import ch.javasoft.io.Print;
import ch.javasoft.metabolic.MetabolicNetwork;
import ch.javasoft.metabolic.generate.ExcelGenerator;
import ch.javasoft.metabolic.generate.LogPkg;
import ch.javasoft.metabolic.generate.MatlabGenerator;
import ch.javasoft.metabolic.impl.FilteredMetabolicNetwork;
import java.io.File;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SbmlTest
extends ch.javasoft.metabolic.parse.SbmlTest {
    private ThreadLocal<String> mModelName = new ThreadLocal();
    private ThreadLocal<String> mMatFileName = new ThreadLocal();
    private ThreadLocal<String> mXlsFileName = new ThreadLocal();

    @Override
    public void testUrea_iAbaylyiv4() throws Exception {
        this.mModelName.set("iAbaylyiv4");
        this.mXlsFileName.set("iAbaylyiv4.xls");
        this.mMatFileName.set("iAbaylyiv4.m");
        super.testUrea_iAbaylyiv4();
    }

    @Override
    public void test_yest_jamboree_model_final_annotated() throws Exception {
        this.mModelName.set("Yeast: jamboree_model_final_annotated");
        this.mXlsFileName.set("jamboree_model_final_annotated.xls");
        this.mMatFileName.set("jamboree_model_final_annotated.m");
        super.test_yest_jamboree_model_final_annotated();
    }

    @Override
    protected void internalTestMetabolicNetwork(MetabolicNetwork network, Set<String> suppressedReactions) throws Exception {
        FilteredMetabolicNetwork filtered = new FilteredMetabolicNetwork(network, suppressedReactions);
        this.internalTestMetabolicNetwork(network, filtered);
    }

    public void internalTestMetabolicNetwork(MetabolicNetwork originalNetwork, MetabolicNetwork reducedNetwork) throws Exception {
        File matFileOut = new File(FOLDER_OUT, this.mMatFileName.get());
        File xlsFileOut = new File(FOLDER_OUT, this.mXlsFileName.get());
        String modelName = this.mModelName.get();
        new MatlabGenerator(modelName).writeAll(reducedNetwork, Print.createWriter(matFileOut));
        LogPkg.LOGGER.info("written to file: " + matFileOut.getAbsolutePath());
        new ExcelGenerator(reducedNetwork).writeTo(xlsFileOut);
        LogPkg.LOGGER.info("written to file: " + xlsFileOut.getAbsolutePath());
    }
}

