/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.efm.util;

import ch.javasoft.io.Files;
import java.io.File;
import java.io.IOException;

public class TempDir {
    private final File baseDir;
    private File personalizedDir;

    public TempDir(File baseDir) {
        this.baseDir = baseDir;
    }

    public File getBaseDir() {
        return this.baseDir;
    }

    public File getPersonalizedDir() {
        if (this.personalizedDir == null) {
            throw new IllegalStateException("mkdirPersonalized() not called or failed -- most probably, you must use the out-core memory");
        }
        return this.personalizedDir;
    }

    public void mkdirPersonalized() throws IOException {
        this.mkdirPersonalized(Files.getFileNameStamped(), false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void mkdirPersonalized(String personalizedDirName, boolean allowExists) throws IOException {
        if (this.personalizedDir != null) throw new IOException("personalized dir already initialized");
        if (!this.baseDir.exists() || !this.baseDir.isDirectory() || !this.baseDir.canRead() || !this.baseDir.canWrite()) throw new IOException("base temp directory not writable: " + this.baseDir.getAbsolutePath());
        File pd = new File(this.baseDir, personalizedDirName);
        if (pd.exists()) {
            if (!allowExists) {
                throw new IOException("personalized temp dir exists: " + pd.getAbsolutePath());
            }
        } else if (!pd.mkdir()) {
            throw new IOException("cannot create personalized temp dir: " + pd.getAbsolutePath());
        }
        this.personalizedDir = pd;
    }

    public boolean rmdirPersonalized() throws IOException {
        if (this.personalizedDir != null && this.personalizedDir.exists()) {
            Files.deleteRecursive(this.personalizedDir);
            if (!this.personalizedDir.delete()) {
                throw new IOException("could not delete directory: " + this.personalizedDir.getAbsolutePath());
            }
            return true;
        }
        return false;
    }

    public String toString() {
        return this.personalizedDir == null ? new File(this.baseDir, "???").getAbsolutePath() : this.personalizedDir.getAbsolutePath();
    }
}

