/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.efm.tree.outcore;

import ch.javasoft.bitset.IBitSet;
import ch.javasoft.metabolic.efm.tree.impl.AbstractInterNode;
import ch.javasoft.metabolic.efm.tree.outcore.PersistentBitPatternTree;
import ch.javasoft.metabolic.efm.tree.outcore.PersistentNode;
import ch.javasoft.metabolic.efm.tree.outcore.PersistentNodeEntity;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;

public class PersistentInterNode
extends AbstractInterNode
implements PersistentNode {
    private final PersistentBitPatternTree tree;
    public final int tableIndexLeft;
    public final int tableIndexRight;
    private Reference<PersistentNode> left;
    private Reference<PersistentNode> right;

    public PersistentInterNode(PersistentBitPatternTree tree, IBitSet unionPattern, int tableIndexLeft, int tableIndexRight, PersistentNode leftNode, PersistentNode rightNode) {
        super(unionPattern);
        this.tree = tree;
        this.tableIndexLeft = tableIndexLeft;
        this.tableIndexRight = tableIndexRight;
        this.left = new WeakReference<PersistentNode>(leftNode);
        this.right = new WeakReference<PersistentNode>(rightNode);
    }

    public PersistentNode left() {
        PersistentNode node = this.left.get();
        if (node == null) {
            node = this.loadEntity(this.tableIndexLeft).toNode(this.tree, null, null);
            this.left = new SoftReference<PersistentNode>(node);
        }
        return node;
    }

    public PersistentNode right() {
        PersistentNode node = this.right.get();
        if (node == null) {
            node = this.loadEntity(this.tableIndexRight).toNode(this.tree, null, null);
            this.right = new SoftReference<PersistentNode>(node);
        }
        return node;
    }

    protected PersistentNodeEntity loadEntity(int tableIndex) {
        try {
            return this.tree.getEntity(tableIndex);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

