/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.efm.stress;

import ch.javasoft.io.Files;
import ch.javasoft.metabolic.compress.CompressionMethod;
import ch.javasoft.metabolic.efm.ColiTest;
import ch.javasoft.metabolic.efm.config.Arithmetic;
import ch.javasoft.metabolic.efm.config.Config;
import ch.javasoft.metabolic.efm.sort.SortUtil;
import ch.javasoft.util.logging.Loggers;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.NumberFormat;
import java.util.logging.Level;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.textui.TestRunner;

public class StressTest
extends TestCase {
    private static File FOLDER = Files.getTempDir();

    public void testColiGlRandom() throws IOException {
        CompressionMethod[] compression = CompressionMethod.STANDARD_NO_DUPLICATE;
        boolean runs = true;
        String testName = "testAll";
        ColiTest coliTest = new ColiTest();
        coliTest.setName("testAll");
        NumberFormat fmt = NumberFormat.getIntegerInstance();
        fmt.setMinimumIntegerDigits(7);
        fmt.setGroupingUsed(false);
        Config.initForJUnitTest("pattern-tree-minzero", "MostZerosOrAbsLexMin", compression, false, Arithmetic.fractional);
        long timeTotal = 0L;
        int i = 1;
        while (i <= 1) {
            File logOut = new File(FOLDER, "testAll-" + i + "-log.txt");
            File kernel = new File(FOLDER, "testAll-" + i + "-kernel.txt");
            File iterat = new File(FOLDER, "testAll-" + i + "-iteration.txt");
            Loggers.logToFile(logOut, Level.ALL);
            SortUtil.setTraceSortingFile(kernel);
            long timeStart = System.currentTimeMillis();
            new TestRunner().doRun((Test)coliTest, false);
            long timeEnd = System.currentTimeMillis();
            long time = timeEnd - timeStart;
            String strTime = fmt.format(time);
            logOut.renameTo(new File(FOLDER, String.valueOf(strTime) + "ms-" + logOut.getName()));
            kernel.renameTo(new File(FOLDER, String.valueOf(strTime) + "ms-" + kernel.getName()));
            iterat.renameTo(new File(FOLDER, String.valueOf(strTime) + "ms-" + iterat.getName()));
            timeTotal += time;
            ++i;
        }
        String msg = "average running time: " + timeTotal / 1L + "ms";
        PrintWriter pw = new PrintWriter(new FileWriter(new File(FOLDER, "average-testAll.txt")));
        pw.println(msg);
        pw.flush();
        pw.close();
        System.out.println(msg);
    }

    public void testColiTspShifts() throws IOException {
        int index;
        String testName = "testAll";
        String rowOrderingPref = "Fixed:1:MostZerosOrAbsLexMin:";
        String rowOrderingPerm = "1:3:8:16:19:15:18:17:20:21:25:24:23:26:22:5:2:6:14:12:9:7:13:11:10:4";
        CompressionMethod[] compression = CompressionMethod.STANDARD;
        ColiTest coliTest = new ColiTest();
        coliTest.setName("testAll");
        NumberFormat fmt = NumberFormat.getIntegerInstance();
        fmt.setMinimumIntegerDigits(7);
        fmt.setGroupingUsed(false);
        int i = 0;
        String rowOrderingP = "1:3:8:16:19:15:18:17:20:21:25:24:23:26:22:5:2:6:14:12:9:7:13:11:10:4";
        do {
            File logOut = new File(FOLDER, "testAll-" + ++i + "-log.txt");
            File kernel = new File(FOLDER, "testAll-" + i + "-kernel.txt");
            File iterat = new File(FOLDER, "testAll-" + i + "-iteration.txt");
            String rowOrdering = "Fixed:1:MostZerosOrAbsLexMin:" + rowOrderingP;
            Config.initForJUnitTest("pattern-tree-minzero", rowOrdering, compression, Arithmetic.double_);
            Loggers.logToFile(logOut, Level.ALL);
            SortUtil.setTraceSortingFile(kernel);
            long timeStart = System.currentTimeMillis();
            new TestRunner().doRun((Test)coliTest, false);
            long timeEnd = System.currentTimeMillis();
            long time = timeEnd - timeStart;
            String strTime = fmt.format(time);
            logOut.renameTo(new File(FOLDER, String.valueOf(strTime) + "ms-" + logOut.getName()));
            kernel.renameTo(new File(FOLDER, String.valueOf(strTime) + "ms-" + kernel.getName()));
            iterat.renameTo(new File(FOLDER, String.valueOf(strTime) + "ms-" + iterat.getName()));
        } while (!(rowOrderingP = String.valueOf(rowOrderingP.substring((index = rowOrderingP.indexOf(58)) + 1)) + ':' + rowOrderingP.substring(0, index)).equals("1:3:8:16:19:15:18:17:20:21:25:24:23:26:22:5:2:6:14:12:9:7:13:11:10:4"));
    }
}

