/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.efm.sort;

import ch.javasoft.metabolic.efm.sort.MatrixSorter;
import ch.javasoft.smx.iface.ReadableDoubleMatrix;

public abstract class RowColSorter
implements MatrixSorter {
    private final boolean mCompareRows;
    private final int mStartRowCol;
    private final int mStartColRow;
    private final int mEndRowCol;
    private final int mEndColRow;

    public RowColSorter(boolean compareRows, int startRowCol, int endRowCol, int startColRow, int endColRow) {
        this.mCompareRows = compareRows;
        this.mStartRowCol = startRowCol;
        this.mEndRowCol = endRowCol;
        this.mStartColRow = startColRow;
        this.mEndColRow = endColRow;
    }

    public boolean compareRows() {
        return this.mCompareRows;
    }

    protected int count(ReadableDoubleMatrix mx) {
        return this.compareRows() ? mx.getColumnCount() : mx.getRowCount();
    }

    protected int startRow(ReadableDoubleMatrix mx) {
        return this.compareRows() ? this.mStartRowCol : this.mStartColRow;
    }

    protected int endRow(ReadableDoubleMatrix mx) {
        return this.compareRows() ? this.mEndRowCol : this.mEndColRow;
    }

    protected int startCol(ReadableDoubleMatrix mx) {
        return this.compareRows() ? this.mStartColRow : this.mStartRowCol;
    }

    protected int endCol(ReadableDoubleMatrix mx) {
        return this.compareRows() ? this.mEndColRow : this.mEndRowCol;
    }

    protected int row(int rowOrCol, int colOrRow) {
        return this.compareRows() ? rowOrCol : colOrRow;
    }

    protected int col(int rowOrCol, int colOrRow) {
        return this.compareRows() ? colOrRow : rowOrCol;
    }

    protected double value(ReadableDoubleMatrix mx, int rowOrCol, int colOrRow) {
        int col = this.col(rowOrCol, colOrRow);
        int row = this.row(rowOrCol, colOrRow);
        return mx.getDoubleValueAt(row, col);
    }

    public int start(ReadableDoubleMatrix mx) {
        return this.startRow(mx);
    }

    public int end(ReadableDoubleMatrix mx) {
        return this.endRow(mx);
    }
}

