/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.efm.output.mat;

import ch.javasoft.jsmat.ReservedMatrixWriter;
import ch.javasoft.jsmat.variable.MatReservedMatrix;
import ch.javasoft.metabolic.efm.output.EfmOutputCallback;
import ch.javasoft.metabolic.efm.output.EfmOutputEvent;
import ch.javasoft.metabolic.efm.output.EfmProcessor;
import ch.javasoft.metabolic.efm.output.mat.MatFileWriter;
import ch.javasoft.util.Arrays;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MatReservedVariableEfmProcessor
implements EfmProcessor<MatFileWriter> {
    private ReservedMatrixWriter<double[]> mReservedWriterDbl;
    private ReservedMatrixWriter<int[]> mReservedWriterInt8;

    @Override
    public int[] initialize(EfmOutputCallback cb, MatFileWriter writer, EfmOutputEvent evt, long efmCount) throws IOException {
        int reactionCount = evt.getMetabolicNetwork().getReactions().length();
        if (cb.getGranularity().isBinarySufficient()) {
            MatReservedMatrix<int[]> mx = MatReservedMatrix.createInt8Matrix(reactionCount, (int)efmCount);
            this.mReservedWriterInt8 = writer.createReservedWriter("efms", mx);
        } else {
            MatReservedMatrix<double[]> mx = MatReservedMatrix.createDoubleMatrix(reactionCount, (int)efmCount);
            this.mReservedWriterDbl = writer.createReservedWriter("efms", mx);
        }
        return Arrays.EMPTY_INT;
    }

    @Override
    public int addEfm(EfmOutputCallback cb, MatFileWriter writer, EfmOutputEvent evt, long efmIndex) throws IOException {
        if (this.mReservedWriterInt8 == null && this.mReservedWriterDbl == null) {
            throw new IOException("reserved writer not initialized, must call initialize()");
        }
        if (this.mReservedWriterDbl != null) {
            double[] values = evt.getEfm().getDoubleRates();
            this.mReservedWriterDbl.append(values);
        } else {
            int[] sgns = new int[evt.getEfm().getSize()];
            int i = 0;
            while (i < sgns.length) {
                sgns[i] = evt.getEfm().getRateSignum(i);
                ++i;
            }
            this.mReservedWriterInt8.append(sgns);
        }
        return 0;
    }

    @Override
    public void finalize(EfmOutputCallback cb, MatFileWriter writer, EfmOutputEvent evt) throws IOException {
        if (this.mReservedWriterDbl != null) {
            this.mReservedWriterDbl.close();
            this.mReservedWriterDbl = null;
        }
        if (this.mReservedWriterInt8 != null) {
            this.mReservedWriterInt8.close();
            this.mReservedWriterInt8 = null;
        }
    }
}

